unit dutil.text.ConvertTest;
{

 Delphi DUnit Test Case
 ----------------------
 This unit contains a skeleton test case class generated by the Test Case Wizard.
 Modify the generated code to correctly setup and call the methods from the unit
 being tested.

}

interface

uses
  TestFramework, dutil.text.Convert;

type
  // Test methods for class TConvert
  TConvertTest = class(TTestCase)
  strict private
    FConvert: TConvert;
  public
    procedure SetUp; override;
    procedure TearDown; override;
  published
    procedure TestStrToUInt;
    procedure TestStrToUInt_Failed;
  end;

implementation

uses
  SysUtils;

procedure TConvertTest.SetUp;
begin
  FConvert := TConvert.Create;
end;

procedure TConvertTest.TearDown;
begin
  FConvert.Free;
  FConvert := nil;
end;

procedure TConvertTest.TestStrToUInt;
const
  BIG_CARDINAL = Cardinal(MaxInt) + 100;
var
  ReturnValue: Cardinal;
  S: string;
begin
  S := UIntToStr(BIG_CARDINAL);

  ReturnValue := FConvert.StrToUInt(S);
  CheckEquals(BIG_CARDINAL, ReturnValue);
end;

procedure TConvertTest.TestStrToUInt_Failed;
begin
  ExpectedException := EConvertError;

  FConvert.StrToUInt('-1');
end;

initialization

// Register any test cases with the test runner
RegisterTest(TConvertTest.Suite);

end.
