unit dutil.sys.win32.registry.ValidationTest;
{

 Delphi DUnit Test Case
 ----------------------
 This unit contains a skeleton test case class generated by the Test Case Wizard.
 Modify the generated code to correctly setup and call the methods from the unit
 being tested.

}

interface

uses
  TestFramework, dutil.sys.win32.registry.Validation, Registry, Windows;

type
  // Test methods for class TValidation
  TValidationTest = class(TTestCase)
  strict private
    FValidation: TValidation;
  public
    procedure SetUp; override;
    procedure TearDown; override;
  published
    procedure TestRequireStr;
    procedure TestRequireStr_NotExists;
    procedure TestRequireStr_HighestPriviledge;
    procedure TestRequireUInt;
    procedure TestRequireUInt_HighestPriviledge;
  end;

implementation

procedure TValidationTest.SetUp;
begin
  FValidation := TValidation.Create;
end;

procedure TValidationTest.TearDown;
begin
  FValidation.Free;
  FValidation := nil;
end;

procedure TValidationTest.TestRequireStr;
var
  ReturnValue: string;
  RootKey: HKEY;
  Name: string;
  Key: string;
begin
  RootKey := HKEY_CURRENT_USER;
  Key := '\Software\Microsoft\Windows\CurrentVersion\Internet Settings';
  Name := 'AutoConfigProxy';

  ReturnValue := FValidation.RequireStr(Key, Name, RootKey);
  CheckEquals('wininet.dll', ReturnValue);
end;

procedure TValidationTest.TestRequireStr_NotExists;
var
  ReturnValue: string;
  RootKey: HKEY;
  Name: string;
  Key: string;
begin
  RootKey := HKEY_CURRENT_USER;
  Key := '\Software\foo\bar';
  Name := 'hello';
  StartExpectingException(ERegistryException);

  ReturnValue := FValidation.RequireStr(Key, Name, RootKey);
  StopExpectingException;
end;

procedure TValidationTest.TestRequireStr_HighestPriviledge;
var
  ReturnValue: string;
  RootKey: HKEY;
  Name: string;
  Key: string;
begin
  RootKey := HKEY_LOCAL_MACHINE;
  Key := '\Software\Microsoft\Windows\CurrentVersion\Internet Settings';
  Name := 'ActiveXCache';

  ReturnValue := FValidation.RequireStr(Key, Name, RootKey);
  CheckEquals('C:\Windows\Downloaded Program Files', ReturnValue);
end;

procedure TValidationTest.TestRequireUInt;
var
  ReturnValue: Cardinal;
  RootKey: HKEY;
  Name: string;
  Key: string;
begin
  RootKey := HKEY_CURRENT_USER;
  Key := '\Software\Microsoft\Windows\CurrentVersion\Internet Settings';
  Name := 'EnableHttp1_1';

  ReturnValue := FValidation.RequireUInt(Key, Name, RootKey);
  CheckEquals(1, ReturnValue);
end;

procedure TValidationTest.TestRequireUInt_HighestPriviledge;
var
  ReturnValue: Integer;
  RootKey: HKEY;
  Name: string;
  Key: string;
begin
  RootKey := HKEY_LOCAL_MACHINE;
  Key := '\Software\Microsoft\Windows\CurrentVersion\Internet Settings';
  Name := 'EnablePunycode';

  ReturnValue := FValidation.RequireUInt(Key, Name, RootKey);
  CheckEquals(1, ReturnValue);
end;

initialization

// Register any test cases with the test runner
RegisterTest(TValidationTest.Suite);

end.
