unit dutil.sys.win32.SpecialPathTest;
{

 Delphi DUnit Test Case
 ----------------------
 This unit contains a skeleton test case class generated by the Test Case Wizard.
 Modify the generated code to correctly setup and call the methods from the unit
 being tested.

}

interface

uses
  TestFramework, dutil.sys.win32.SpecialPath;

type
  // Test methods for class TSpecialPath
  TSpecialPathTest = class(TTestCase)
  strict private
    FSpecialPath: TSpecialPath;
  public
    procedure SetUp; override;
    procedure TearDown; override;
  published
    procedure TestFromCsidl;
  end;

implementation

uses
  ShlObj;

procedure TSpecialPathTest.SetUp;
begin
  FSpecialPath := TSpecialPath.Create;
end;

procedure TSpecialPathTest.TearDown;
begin
  FSpecialPath.Free;
  FSpecialPath := nil;
end;

procedure TSpecialPathTest.TestFromCsidl;
var
  ReturnValue: string;
  Csidl: Integer;
begin
  Csidl := CSIDL_WINDOWS;

  ReturnValue := FSpecialPath.FromCsidl(Csidl, {CanCreate=}False);
  CheckEquals('C:\Windows', ReturnValue);
end;

initialization

// Register any test cases with the test runner
RegisterTest(TSpecialPathTest.Suite);

end.
