unit dutil.sys.win32.PlatformTest;
{

 Delphi DUnit Test Case
 ----------------------
 This unit contains a skeleton test case class generated by the Test Case Wizard.
 Modify the generated code to correctly setup and call the methods from the unit
 being tested.

}

interface

uses
  TestFramework, dutil.sys.win32.Platform, Windows;

type
  // Test methods for class TPlatform
  TPlatformTest = class(TTestCase)
  strict private
    FPlatform: TPlatform;
  public
    procedure SetUp; override;
    procedure TearDown; override;
  published
    procedure TestVersionGreaterThanOrEquals;
    procedure TestVersionGreaterThanOrEquals_Failed;
  end;

implementation

procedure TPlatformTest.SetUp;
begin
  FPlatform := TPlatform.Create;
end;

procedure TPlatformTest.TearDown;
begin
  FPlatform.Free;
  FPlatform := nil;
end;

procedure TPlatformTest.TestVersionGreaterThanOrEquals;
var
  ReturnValue: Boolean;
  ServicePackMinor: Word;
  ServicePackMajor: Word;
  Minor: System.Cardinal;
  Major: System.Cardinal;
begin
  ServicePackMajor := 0;
  ServicePackMinor := 0;
  Minor := 5;
  Major := 0;

  ReturnValue := FPlatform.VersionGreaterThanOrEquals(Major, Minor, ServicePackMajor, ServicePackMinor);
  CheckTrue(ReturnValue, 'Operating system is older than Windows 2000?');
end;

procedure TPlatformTest.TestVersionGreaterThanOrEquals_Failed;
var
  ReturnValue: Boolean;
  ServicePackMinor: Word;
  ServicePackMajor: Word;
  Minor: System.Cardinal;
  Major: System.Cardinal;
begin
  ServicePackMajor := 0;
  ServicePackMinor := 0;
  Minor := 0;
  Major := 99;

  ReturnValue := FPlatform.VersionGreaterThanOrEquals(Major, Minor, ServicePackMajor, ServicePackMinor);
  CheckFalse(ReturnValue, 'Operating system is too modern?');
end;

initialization

// Register any test cases with the test runner
RegisterTest(TPlatformTest.Suite);

end.
