unit dutil.io.device.TempFileTest;
{

 Delphi DUnit Test Case
 ----------------------
 This unit contains a skeleton test case class generated by the Test Case Wizard.
 Modify the generated code to correctly setup and call the methods from the unit
 being tested.

}

interface

uses
  TestFramework, dutil.io.device.TempFile;

type
  // Test methods for class TTempFile
  TTempFileTest = class(TTestCase)
  strict private
    FTempFile: TTempFile;
  public
    procedure SetUp; override;
    procedure TearDown; override;
  published
    procedure TestMakeTempDirectory;
  end;

implementation

uses
  IOUtils,
  SysUtils,
  Types;

procedure TTempFileTest.SetUp;
begin
  FTempFile := TTempFile.Create;
end;

procedure TTempFileTest.TearDown;
begin
  FTempFile.Free;
  FTempFile := nil;
end;

procedure TTempFileTest.TestMakeTempDirectory;
var
  ReturnValue: string;
  Suffix: string;
  Prefix: string;
  ParentDirectory: string;
  ExistingDirectories: TStringDynArray;
  Directory: string;
begin
  ParentDirectory := GetCurrentDir();
  Prefix := 'temp_dir_';
  Suffix := '';
  ExistingDirectories := TDirectory.GetDirectories(ParentDirectory, Prefix + '*');

  ReturnValue := FTempFile.MakeTempDirectory(ParentDirectory, Prefix, Suffix);
  CheckTrue(TDirectory.Exists(ReturnValue));
  for Directory in ExistingDirectories do
    CheckNotEquals(Directory, ReturnValue);
  CheckEquals(Length(TDirectory.GetDirectories(ParentDirectory, Prefix + '*')), Length(ExistingDirectories) + 1);
  TDirectory.Delete(ReturnValue);
end;

initialization

// Register any test cases with the test runner
RegisterTest(TTempFileTest.Suite);

end.
