unit dutil.io.device.FileTest;
{

 Delphi DUnit Test Case
 ----------------------
 This unit contains a skeleton test case class generated by the Test Case Wizard.
 Modify the generated code to correctly setup and call the methods from the unit
 being tested.

}

interface

uses
  TestFramework, dutil.io.device.File_;

type
  // Test methods for class TFile
  TFileTest = class(TTestCase)
  strict private
    FFile: TFile;
  public
    procedure SetUp; override;
    procedure TearDown; override;
  published
    procedure TestContentsEqual;
    procedure TestContentsEqual_Different;
  end;

implementation

procedure TFileTest.SetUp;
begin
  FFile := TFile.Create;
end;

procedure TFileTest.TearDown;
begin
  FFile.Free;
  FFile := nil;
end;

procedure TFileTest.TestContentsEqual;
var
  ReturnValue: Boolean;
  Filename: string;
begin
  Filename := '..\fixture\example.xml';

  ReturnValue := FFile.ContentsEqual(Filename, Filename);
  CheckTrue(ReturnValue);
end;

procedure TFileTest.TestContentsEqual_Different;
var
  ReturnValue: Boolean;
  FilenameA: string;
  FilenameB: string;
begin
  FilenameA := '..\fixture\file1.bin';
  FilenameB := '..\fixture\file2.bin';

  ReturnValue := FFile.ContentsEqual(FilenameA, FilenameB);
  CheckFalse(ReturnValue);
end;

initialization

// Register any test cases with the test runner
RegisterTest(TFileTest.Suite);

end.
