import type { Metadata } from 'next';
import { Mulish } from 'next/font/google';
import { Analytics } from '@vercel/analytics/react';

import './globals.css';

const inter = Mulish({ subsets: ['latin'] });

export const metadata: Metadata = {
  title: 'Stackwise UI',
  description: 'Explain what you want to do you, and AI builds it.',
};

export default function RootLayout({
  children,
}: {
  children: React.ReactNode;
}) {
  return (
    <html lang="en">
      <body className={inter.className}>
        {children} <Analytics />
      </body>
    </html>
  );
}
