# Changelog

All notable changes to this project will be documented in this file. See [commit-and-tag-version](https://github.com/absolute-version/commit-and-tag-version) for commit guidelines.

## [0.12.0](https://github.com/ssube/onnx-web/compare/v0.11.0...v0.12.0) (2023-12-31)


### Features

* add API parameter for upscale checkbox ([71fbc87](https://github.com/ssube/onnx-web/commit/71fbc871a641c266247ab6aa45c68bb33bf76b54))
* **api:** add optimization flag to ORT extended optimizations ([e8a30ae](https://github.com/ssube/onnx-web/commit/e8a30ae56b67e184f2ad456fa229991f18373ba9))
* **api:** add stage for local standard deviation denoising for XL ([f28fdda](https://github.com/ssube/onnx-web/commit/f28fdda47a7a318c109af6b9a7ae1df4a7fcfeb3))
* **api:** enable 1x upscaling models ([7abe6dc](https://github.com/ssube/onnx-web/commit/7abe6dc6a9e89dc3fbddca7fd43b0fcb6a0e7fea))
* **api:** support both ESRGAN variants ([0ddc162](https://github.com/ssube/onnx-web/commit/0ddc16288ffe4ff0269e591944538fe002c9a89b))
* **api:** support more RealESRGAN-based models ([9588643](https://github.com/ssube/onnx-web/commit/95886430a4b41c47ff17cf9eab78c01317b02097))
* **api:** use wrapped model's input types in UNet patch ([80a2553](https://github.com/ssube/onnx-web/commit/80a255397eb76a48b325706212472c1ed7e807c2))


### Bug Fixes

* **api:** make sure ControlNet constructor is used for same pipeline ([#449](https://github.com/ssube/onnx-web/issues/449)) ([00db9a2](https://github.com/ssube/onnx-web/commit/00db9a278721425c750d39f3c7e90871f38f4fda))
* **api:** make sure upscaling only runs once regardless of correction options ([c6718a3](https://github.com/ssube/onnx-web/commit/c6718a3e3b2e15c29b5d22b5d1101da2930c08cb))
* **api:** make version-safe imports compatible with tests ([6a00481](https://github.com/ssube/onnx-web/commit/6a004816afff0a0ce7269307638e4ac066388824))
* **api:** reduce min VAE tile size to match min height/width ([6d2d505](https://github.com/ssube/onnx-web/commit/6d2d5058d92ea4c21d389a4d9307506af8aa0d97))
* **api:** turn off SDXL's very visible watermarking ([#438](https://github.com/ssube/onnx-web/issues/438)) ([9736779](https://github.com/ssube/onnx-web/commit/973677967d4050ff31cfc0ae5080f85c837ceed8))
* **api:** use correct part of the gfpgan output ([de8ab6f](https://github.com/ssube/onnx-web/commit/de8ab6f1c933242207daee119f6ff1ac8cda4845))
* **api:** use standard op block list for SDXL ([006f983](https://github.com/ssube/onnx-web/commit/006f9832691d38321d1cb8351b3269e3a8498d05))
* **build:** use python image for pip release job ([7725719](https://github.com/ssube/onnx-web/commit/77257199816fa5903e7f178555bffd1defdb6afd))
* **docs:** add more info about testing models and running server ([#451](https://github.com/ssube/onnx-web/issues/451)) ([9c3ff75](https://github.com/ssube/onnx-web/commit/9c3ff75a64706079ac6f147e7ab7f3dda790eb85))
* **docs:** remove old tile size section ([fab3ac6](https://github.com/ssube/onnx-web/commit/fab3ac68c2214f2cf0764fa787f62a622556476c))
* download LoRAs and other networks by default ([a5ecb59](https://github.com/ssube/onnx-web/commit/a5ecb59cd97fb3f4e7725e3f6ff99da024786559))
* **exe:** correct path for gfpgan folders within bundle ([d3a3f95](https://github.com/ssube/onnx-web/commit/d3a3f95c506cd5d0a62c6a6fb85988d3013dbfbd))
* **gui:** add missing params to client-side config ([1d373fa](https://github.com/ssube/onnx-web/commit/1d373faf5d19723f342ea79564e4b1e3ce6a6ba4))
* **gui:** sync client and server default params ([b93a5da](https://github.com/ssube/onnx-web/commit/b93a5da19077b926045f367d18795d035555e80d))

## [0.11.0](https://github.com/ssube/onnx-web/compare/v0.10.0...v0.11.0) (2023-12-24)


### Features

* add panorama pipeline for SDXL ([0fa03e7](https://github.com/ssube/onnx-web/commit/0fa03e77ad175b0f8756b138ddc2ed2b793655b9))
* **api:** add an experimental multi-prompt syntax ([0ad2502](https://github.com/ssube/onnx-web/commit/0ad250251eeb8c47c29963f3e0db61c7929e705b))
* **api:** add basic plugin system ([535b685](https://github.com/ssube/onnx-web/commit/535b685a5775501a9088a75e30154e8c8dcf36e8))
* **api:** add chain pipeline stage result type ([d52c68d](https://github.com/ssube/onnx-web/commit/d52c68d6074b1dc11daba1f3641adc5c0fd47016))
* **api:** add conversion for SDXL models ([fe68670](https://github.com/ssube/onnx-web/commit/fe68670844d25226a634c8ead689b47fa520722b))
* **api:** add converter to extract ZIP archives ([#437](https://github.com/ssube/onnx-web/issues/437)) ([f3e1bea](https://github.com/ssube/onnx-web/commit/f3e1beaa711a9eb335bb619d6985008f7d383820))
* **api:** add denoise stage, use before highres ([95e2d6d](https://github.com/ssube/onnx-web/commit/95e2d6d71006b02b24b5ce72e6eb9078e4e0ffaa))
* **api:** add edge feathering to region prompts ([5951519](https://github.com/ssube/onnx-web/commit/59515193a1cd6ffc0027f08e652adb675f60eeeb))
* **api:** add edge options to region feathering ([1fae41d](https://github.com/ssube/onnx-web/commit/1fae41ddcf918168cfc20862ce4755eeeabf925a))
* **api:** add env vars for Civitai and Huggingface auth tokens ([4edb32a](https://github.com/ssube/onnx-web/commit/4edb32aaac1a4881d962d2caf1e90b947558f58f))
* **api:** add experimental region prompts to SDXL panorama ([5cf7a39](https://github.com/ssube/onnx-web/commit/5cf7a39be0210c32a2a280490b2c4756e4799ca9))
* **api:** add feature flag for single-tile panorama highres ([5fb2de8](https://github.com/ssube/onnx-web/commit/5fb2de85c5dc9b791f14382f6b140d88b2720b13))
* **api:** add feature flags, move panoramic tile feature into flags ([def8ad7](https://github.com/ssube/onnx-web/commit/def8ad73c549b5d891c20c77296c1609e293f73e))
* **api:** add flag to launch debugger ([781b341](https://github.com/ssube/onnx-web/commit/781b34151c306d7d40684b6b350611166bcb7a73))
* **api:** add LCM scheduler ([fd97eeb](https://github.com/ssube/onnx-web/commit/fd97eebfa208f24055ce78a8eec16395ec4e043a))
* **api:** add new optimum-based SD converter ([b6ef00e](https://github.com/ssube/onnx-web/commit/b6ef00e437d16b410b154b780d9c0a9ab953e139))
* **api:** add strength param to denoise stage ([768f478](https://github.com/ssube/onnx-web/commit/768f478884422b10ab511dc843151452b9f8204d))
* **api:** add support for DPM SDE scheduler ([2fc5ec9](https://github.com/ssube/onnx-web/commit/2fc5ec930c30021dfdbe5b9e5b8b40da9346ae6f))
* **api:** add tokens to reseed region ([8a94cdb](https://github.com/ssube/onnx-web/commit/8a94cdb385a1808ba172bdb95cffb7c913524340))
* **api:** allow a different prompt for each highres stage ([8ce09d3](https://github.com/ssube/onnx-web/commit/8ce09d307be11d4de0a2699a984fa2555e969616))
* **api:** allow embeddings as a synonym for TI token ([2653dd8](https://github.com/ssube/onnx-web/commit/2653dd812e321e5458713a260e26d8c4e7c9440f))
* **api:** attempt to calculate total steps for chain pipelines ([55ddb9f](https://github.com/ssube/onnx-web/commit/55ddb9fdac8e195e733e24a69670bf62f590b6a6))
* **api:** disable prompt alternatives for panorama to fix regions ([5968577](https://github.com/ssube/onnx-web/commit/59685770e463150e07a10c4bb7a072a4eba3960d))
* **api:** make tile retries configurable ([6fb0366](https://github.com/ssube/onnx-web/commit/6fb0366f529674ba2d47f99a217c0fe1454a79f9))
* **api:** remove deprecated Karras Ve scheduler ([#189](https://github.com/ssube/onnx-web/issues/189)) ([695eeaf](https://github.com/ssube/onnx-web/commit/695eeaf30331ad4f24401e5873c7e861844b3b79))
* **api:** replace legacy SD converter with optimum-based one by default ([9a077fa](https://github.com/ssube/onnx-web/commit/9a077fae1522c4d6db8a39b571c87033a75f2517))
* **api:** skip regions on last timestep ([09f600a](https://github.com/ssube/onnx-web/commit/09f600ab54fd8346ded95d3bc44945754b29f23a))
* **api:** support for SDXL LoRAs ([bbacfd1](https://github.com/ssube/onnx-web/commit/bbacfd1ca0e54e623afc6a83f100ea48eb9e315d))
* **api:** switch to codeformer lib that works with torch 2.x ([7ed30ee](https://github.com/ssube/onnx-web/commit/7ed30ee47019ab83c7fa33babaca5331bbfb1396))
* **api:** update pinned onnxruntime to 0.16.3 ([6a6a3f0](https://github.com/ssube/onnx-web/commit/6a6a3f04bc4adee7b2a2141a3638ba86950a8075))
* **api:** upgrade to latest diffusers, optimum, transformers ([#433](https://github.com/ssube/onnx-web/issues/433)) ([c6de256](https://github.com/ssube/onnx-web/commit/c6de25682dbe9cdafffa5aed3e47510c84a6ce9b))
* **docs:** cover pre-converted models in user guide ([99161c4](https://github.com/ssube/onnx-web/commit/99161c42de5b9975d91723de5a50cfca3fe67037))
* **docs:** set up docs site ([#436](https://github.com/ssube/onnx-web/issues/436)) ([523a2a0](https://github.com/ssube/onnx-web/commit/523a2a0cc74de9a140c58fa98f673e69d768183f))
* **exe:** include pre-converted models in bundle launch scripts ([c85b608](https://github.com/ssube/onnx-web/commit/c85b60819628798d378d81ba47e92cb224f57c3b))
* **gui:** add button to open docs site ([8e7f8c7](https://github.com/ssube/onnx-web/commit/8e7f8c76d20c7d4342cdd27ce666a911cd1b2822))
* **gui:** add row and column tokens for X/Y prompts ([e5a9d57](https://github.com/ssube/onnx-web/commit/e5a9d5772d7a0b119bbe3e71f00f4c60afdf78e8))
* **gui:** add wildcard menu to web UI ([cdbdd9b](https://github.com/ssube/onnx-web/commit/cdbdd9b4e25fc8b0c51d58f95c38292cf388dc99))
* **gui:** highlight tokens that have been used in prompt ([fd34b4a](https://github.com/ssube/onnx-web/commit/fd34b4a76418a7034d620756d0811963411bc30a))
* **gui:** include some default profiles ([#420](https://github.com/ssube/onnx-web/issues/420)) ([193f82e](https://github.com/ssube/onnx-web/commit/193f82e7b4a58871923917806067c487aae8e791))
* **models:** add extras files for pre-converted models ([#437](https://github.com/ssube/onnx-web/issues/437)) ([b2740d3](https://github.com/ssube/onnx-web/commit/b2740d3ad295f1e3f5a6fbf99bb22d81de00f3eb))
* **scripts:** add script for preparing training images ([5d0d904](https://github.com/ssube/onnx-web/commit/5d0d904463f3586489e0d4fea5e5e16cfc2477df))
* show tokens for networks in prompt ([44e4833](https://github.com/ssube/onnx-web/commit/44e483322e41c67e17d80268dd6d14e29668205c))
* split up pre-converted models into full and base sets ([75ac764](https://github.com/ssube/onnx-web/commit/75ac764d428e51be4726164d682a285c1160dbdc))
* split up UNet and VAE tile size and overlap/stride params ([e8d7d9a](https://github.com/ssube/onnx-web/commit/e8d7d9a88186fedcf12ac6ce41819a5c59698715))
* update min CFG for SDXL turbo ([419b281](https://github.com/ssube/onnx-web/commit/419b2811ef5cbcfe2b960e44171d2b6cd24cd575))


### Bug Fixes

* **api:** abandon pretrained loader entirely to fix SD upscaling ([fa38b47](https://github.com/ssube/onnx-web/commit/fa38b474f06d30ef487bf34fe1a6b925f2f657fd))
* **api:** add debugpy to dev deps ([b3cf0ac](https://github.com/ssube/onnx-web/commit/b3cf0acfe9d40d3d67113bb07ffc933a55553c26))
* **api:** add loading path for controlnet ([a716f6d](https://github.com/ssube/onnx-web/commit/a716f6db1f64184167765e250ae74ad5cd342894))
* **api:** add logging along SDXL custom VAE codepath ([ddd3d45](https://github.com/ssube/onnx-web/commit/ddd3d45b79f08d82055a143ea7492444705ab071))
* **api:** add missing param to controlnet pipeline ([1163acc](https://github.com/ssube/onnx-web/commit/1163accb49cdb45f5577b2eca31fba6cb539b37b))
* **api:** add out channels to upscaling config ([e64e514](https://github.com/ssube/onnx-web/commit/e64e514e7fb55cf1c3e7a1285ea7b505d6675253))
* **api:** adjust region strength threshold to support up to 90% UNet overlap ([2a27c3f](https://github.com/ssube/onnx-web/commit/2a27c3ffd1285d156783692bc864a7aac0ad0e7d))
* **api:** allow all supported tensors extensions for VAE files ([f4f3bda](https://github.com/ssube/onnx-web/commit/f4f3bda6f815b68afbe2eded85ee172c3a99d60f))
* **api:** allow numbers in archive filenames ([4eeb68c](https://github.com/ssube/onnx-web/commit/4eeb68cbcf90125c557cf70957218956eaa9af9a))
* **api:** allow PTH tensor files, add helper to check extension ([ebdfa78](https://github.com/ssube/onnx-web/commit/ebdfa78737bce5b723423031c6e57fb63a1c25bc))
* **api:** allow random seed in reseed regions ([798fa5f](https://github.com/ssube/onnx-web/commit/798fa5fc6d07a2ae3294aea618d8a5372ab0fd73))
* **api:** allow SDXL txt2img models in extras file and schema ([6e2896f](https://github.com/ssube/onnx-web/commit/6e2896f7f72995f2d37b3582977e80e72a15d633))
* **api:** allow SDXL VAE in any supported tensor format, ensure new SDXL models get hash file ([1351b2f](https://github.com/ssube/onnx-web/commit/1351b2f3ff69e5866ea49622db612ec02a6b2576))
* **api:** allow spaces in wildcard filenames ([02dd17a](https://github.com/ssube/onnx-web/commit/02dd17aa4f822fc843c550ae9b5e9e61094e379a))
* **api:** avoid padding latents when they are not being tiled ([d94a8d6](https://github.com/ssube/onnx-web/commit/d94a8d6f6eb161bcc97dbdb4cba66d0095e4b217))
* **api:** be more careful with VAE patch flags, add margin to latents if needed ([93e3125](https://github.com/ssube/onnx-web/commit/93e3125e289d32ca2b2c95ed692fa75200c8101e))
* **api:** better handling of alpha channels ([1c3b2f8](https://github.com/ssube/onnx-web/commit/1c3b2f8dfcbdf3e246e6e0edec22c6ff71ced157))
* **api:** blend embeddings into second tokenizer/text encoder for SDXL ([fc02fa6](https://github.com/ssube/onnx-web/commit/fc02fa6be1b8b99d53a1804ccec92db3f07b1b12))
* **api:** build SDXL pipeline to avoid optimum patches ([3f3811e](https://github.com/ssube/onnx-web/commit/3f3811e16abccafd45c350799bea03ba56c7aa56))
* **api:** change default web UI path to match docs ([6bec3b0](https://github.com/ssube/onnx-web/commit/6bec3b0cb9665698e10cead4c7b47bc0b0a3c2b6))
* **api:** change weights filename for new models to match optimum ([ebe813d](https://github.com/ssube/onnx-web/commit/ebe813d0351db32af3a74bba61cd4d2b26c60748))
* **api:** check for web UI files in Windows launch scripts ([2a641b1](https://github.com/ssube/onnx-web/commit/2a641b111ec827477bf811134246163979fb6d7e))
* **api:** complete panorama tiles for SD pipeline ([b54a57b](https://github.com/ssube/onnx-web/commit/b54a57b379fbbae37b954cc6a0bbba3fa807ab7b))
* **api:** consistently handle tile size across premade pipelines ([d78e843](https://github.com/ssube/onnx-web/commit/d78e843af4e53baa1fe23c733e425e803fdcdd17))
* **api:** continue adding tests, fix bugs encountered ([047e58c](https://github.com/ssube/onnx-web/commit/047e58c91680e5d53de2ad7469497603cbf474c7))
* **api:** convert latents to numpy before using ([8d44103](https://github.com/ssube/onnx-web/commit/8d4410305e4d411661c72607c2717690a5c62447))
* **api:** convert SD models without extracting Torch intermediate ([#404](https://github.com/ssube/onnx-web/issues/404)) ([b29837d](https://github.com/ssube/onnx-web/commit/b29837d773115c65b05a2a7cc130069341386055))
* **api:** correct file extension validity check ([c8dd85e](https://github.com/ssube/onnx-web/commit/c8dd85e798564bd0e9bc6f442acaa174c584f098))
* **api:** correct origin point when blending images ([#445](https://github.com/ssube/onnx-web/issues/445)) ([3d245a6](https://github.com/ssube/onnx-web/commit/3d245a663d290a2f5bf33dfaec610fad0d511082))
* **api:** correct VAE extension check during conversion ([4fd5098](https://github.com/ssube/onnx-web/commit/4fd50984f00647605e1bcf1dfc860a513ad307c4))
* **api:** correctly detect unknown embedding format ([98f8abb](https://github.com/ssube/onnx-web/commit/98f8abbacd3c8293f0da9a0831e1d3fe65120ca0))
* **api:** correctly handle completely black mask images ([1818a36](https://github.com/ssube/onnx-web/commit/1818a36c11b9319eddc91cb3fd8d9589d800a04c))
* **api:** correctly handle image stacks in persist stages ([042181b](https://github.com/ssube/onnx-web/commit/042181b9c522dadd75310ba888c5e748ecd778b0))
* **api:** correctly load text encoder 2 and VAE without LoRAs ([56f1925](https://github.com/ssube/onnx-web/commit/56f19256b5cdd2b1d5c01cb6805f163d1a8e4f92))
* **api:** defer txt2img tiling to panorama pipeline when selected ([440e47f](https://github.com/ssube/onnx-web/commit/440e47f736db460994c4715da024baecf618c7d8))
* **api:** detect all mask keys, immediately bubble up cancellation errors ([95a62b1](https://github.com/ssube/onnx-web/commit/95a62b17edc952ee58704a2f489db339843516b0))
* **api:** do not apply prompt expansion patch to SDXL ([bbff191](https://github.com/ssube/onnx-web/commit/bbff1913ef2cf84799c7dcce37e50d2a0a97c265))
* **api:** do not parse tokens when removing them ([1bdfb4a](https://github.com/ssube/onnx-web/commit/1bdfb4ac8ab5ac5e975f2b7223853986c7882970))
* **api:** enable prompt alternatives for SDXL ([6eb014c](https://github.com/ssube/onnx-web/commit/6eb014cec88b33a98c5f307a0f9b76d3a01e670e))
* **api:** enable Unet patch for SDXL ([d48dbf7](https://github.com/ssube/onnx-web/commit/d48dbf7d6e8e31b27d3643c03752546e195b92c2))
* **api:** ensure panorama never generates a negative number of views ([944c92b](https://github.com/ssube/onnx-web/commit/944c92b824609555c6fcbac46467a0571b176e99))
* **api:** ensure pipeline is using selected scheduler ([a90a963](https://github.com/ssube/onnx-web/commit/a90a96376516e968557730456a0e8e83d992ebaf))
* **api:** ensure VAE is loaded on correct device ([d4b0130](https://github.com/ssube/onnx-web/commit/d4b013068dc6065cf1973d6d35f28f51b607fcd8))
* **api:** feather all edges by default ([c7cff78](https://github.com/ssube/onnx-web/commit/c7cff78784e4837378ebd82a0e0a0678b85615bd))
* **api:** GC during SDXL conversion ([a5a60d3](https://github.com/ssube/onnx-web/commit/a5a60d3e15bc85472b1df0d57fdfb332214bdf62))
* **api:** handle blending images of different sizes better ([de28ecd](https://github.com/ssube/onnx-web/commit/de28ecdfad01c5ad55ebd62884025b7cfe8677ba))
* **api:** handle blending numpy arrays ([83ebd77](https://github.com/ssube/onnx-web/commit/83ebd77c3d4fe61d05d2f5c16905a705b9edc35e))
* **api:** handle empty prompts when parsing ([14ddfb4](https://github.com/ssube/onnx-web/commit/14ddfb43bb26cf539613748bf7ec78f3e2508ccb))
* **api:** handle HF repos in new SD converter ([29ccd16](https://github.com/ssube/onnx-web/commit/29ccd1643727935c8e4405531e0c3a6b23a4ac95))
* **api:** handle images with alpha channels better ([b1328fd](https://github.com/ssube/onnx-web/commit/b1328fdfdb747cd563762a91d9bbf0c9a37cf2e2))
* **api:** handle models with integer timestamps ([abeedde](https://github.com/ssube/onnx-web/commit/abeeddeeb271b7bfbdec792ae84e1ace555fd974))
* **api:** include SD upscaling in diffusion prefixes ([293a1bb](https://github.com/ssube/onnx-web/commit/293a1bb18462e8ad475fa2d3f80210aaa5dd1540))
* **api:** increase max tile size for output and grid stages to max ([5ffe8b2](https://github.com/ssube/onnx-web/commit/5ffe8b26faae6080c5f643522c505960d707b048))
* **api:** load lists without empty items ([9e930a9](https://github.com/ssube/onnx-web/commit/9e930a91d5c331acf78da0c6676e64727bf38128))
* **api:** load pretrained VAE from original path ([e7da2cf](https://github.com/ssube/onnx-web/commit/e7da2cf8a6d0a3d6d455ac4248453a55aa9d7034))
* **api:** load replacement VAE from single file for SD v1/v2 ([c99481f](https://github.com/ssube/onnx-web/commit/c99481f4848d18028d2d6fcfb591fac08fa94016))
* **api:** make argument for skipping base models work correctly ([50d51a3](https://github.com/ssube/onnx-web/commit/50d51a3921dfdc519b8799c318f4de6ce4c755be))
* **api:** make request parsing consistent between JSON and forms ([a33c88e](https://github.com/ssube/onnx-web/commit/a33c88e67072330e68f2190b7724f1fccb1b37f9))
* **api:** make sure all file types are covered ([#432](https://github.com/ssube/onnx-web/issues/432)) ([95d8f4a](https://github.com/ssube/onnx-web/commit/95d8f4a5986f27255828481ff0b7c5f485584ce3))
* **api:** make sure diffusion models have a valid prefix ([46d9fc0](https://github.com/ssube/onnx-web/commit/46d9fc0dd40a2b1c657dd7733b30ffa11101bb01))
* **api:** make sure new SD converter does not produce extra files ([15b9b51](https://github.com/ssube/onnx-web/commit/15b9b51ed59848025042d45164c2772c54e9a4d1))
* **api:** make sure stage params are declared for all txt2img pipelines ([b31227e](https://github.com/ssube/onnx-web/commit/b31227ecb3d4156088c5ec1c134a837cb9c071bd))
* **api:** make tile blending symmetrical, correct bottom/right gradients ([7106e96](https://github.com/ssube/onnx-web/commit/7106e96e776f45f2f3df508f0108c95cf43fe116))
* **api:** match inpaint source and mask formats ([7ca5dc1](https://github.com/ssube/onnx-web/commit/7ca5dc12a44b369254ee253e573ca4d01079ba04))
* **api:** match SDXL keys per LoRA ([74832fc](https://github.com/ssube/onnx-web/commit/74832fc61bd0b940ff3925c0183cc11ba14befe7))
* **api:** only consume one retry per error ([911f87f](https://github.com/ssube/onnx-web/commit/911f87f7ec5c066d700acd1510d24439be319204))
* **api:** only fetch diffusion models if they have not already been converted ([#398](https://github.com/ssube/onnx-web/issues/398)) ([9c1fcd1](https://github.com/ssube/onnx-web/commit/9c1fcd16fa31318b85aa5e42175c93e4421d1f89))
* **api:** only remove one retry after each tile failure ([e7aad28](https://github.com/ssube/onnx-web/commit/e7aad281b0e35cc97166261b77a7a2cef57497ad))
* **api:** only run SDXL LoRA node matching on XL models ([ea9023c](https://github.com/ssube/onnx-web/commit/ea9023c2eb2c141975045f01c594251740ad085b))
* **api:** only use optimum's fp16 mode for SDXL export when torch fp16 is enabled ([eb3f147](https://github.com/ssube/onnx-web/commit/eb3f1479f27bfe0035343f96818400129e3743a5))
* **api:** override pipeline models if pipeline ignored components ([6b31075](https://github.com/ssube/onnx-web/commit/6b310756167a4689f5c3d33c2179ac0eaea69099))
* **api:** parse embedding/TI tokens correctly ([76e28d9](https://github.com/ssube/onnx-web/commit/76e28d962dc084aa299b979bf7330b4621a7e96a))
* **api:** pass correct outscale to highres stages ([6ecdae4](https://github.com/ssube/onnx-web/commit/6ecdae44a2efb455364575be66c8cf6d02c9ff07))
* **api:** pass replacement VAE to diffusers conversion ([8e1f188](https://github.com/ssube/onnx-web/commit/8e1f188d8fa9724c7dc808e21b6af4ab4de684a0))
* **api:** provide some necessary SDXL config ([02447f5](https://github.com/ssube/onnx-web/commit/02447f5fd6e909e7da0633dffd2b7124df85bf45))
* **api:** remove redundant torch version pin ([27bd307](https://github.com/ssube/onnx-web/commit/27bd307cd8f43b4e58deadd2b1599917d6e4f344))
* **api:** remove still-random seed from stage kwargs ([a79d835](https://github.com/ssube/onnx-web/commit/a79d8351933254e81f266ad6a21edd2e14baded0))
* **api:** report chain progress using a new callback if none was provided ([f9acf9b](https://github.com/ssube/onnx-web/commit/f9acf9b50f58c324b38eac1ea17057949b866943))
* **api:** resize blend mask to match source ([2c2eda8](https://github.com/ssube/onnx-web/commit/2c2eda8c3c41df2b373c941366a95cc3b3056d84))
* **api:** resize latents to complete panorama blocks ([103d1a4](https://github.com/ssube/onnx-web/commit/103d1a449a058a65139d95c15ab5f349e41d928f))
* **api:** resolve XL VAE within model folder ([cf2cf51](https://github.com/ssube/onnx-web/commit/cf2cf51b17f47ad9703014024ad18ea0a98cd9fa))
* **api:** restore additional ORT options for multi-GPU machines ([b398d65](https://github.com/ssube/onnx-web/commit/b398d65624277b3ca5c051960e4bd04c6e24375e))
* **api:** restore single-tile code path ([828c951](https://github.com/ssube/onnx-web/commit/828c9511a6dc860bf0dfb7b1c113fce861744c06))
* **api:** revert torch to 2.0.1 for ROCm due to MIopen errors ([#444](https://github.com/ssube/onnx-web/issues/444)) ([0aab130](https://github.com/ssube/onnx-web/commit/0aab1301aa1f991cd52190cd88088dc6e69befce))
* **api:** run blend pipeline in RGB mode ([#439](https://github.com/ssube/onnx-web/issues/439)) ([9e73470](https://github.com/ssube/onnx-web/commit/9e734706f1e92a8ed456f7ae5d8c039ef7d05fec))
* **api:** set VAE attn processor during conversion ([0ecae65](https://github.com/ssube/onnx-web/commit/0ecae65f886ecd6cb2ea7d4e41c8336e13f5ee3a))
* **api:** silence controlnet registration warnings ([ccff9a3](https://github.com/ssube/onnx-web/commit/ccff9a3136635c580e9471474c0ad17af6a59039))
* **api:** support normal LoRA keys in SDXL LoRAs ([60615e0](https://github.com/ssube/onnx-web/commit/60615e097bcbcf0c8c0142ba69cf1301a0932361))
* **api:** switch pipeline ctor based on VAE presence, improve panorama logging ([9231128](https://github.com/ssube/onnx-web/commit/92311281df17cc4e34d9ad419a89cb2b7b8b4496))
* **api:** test LoRA blending code ([52fdf4f](https://github.com/ssube/onnx-web/commit/52fdf4f48ae939bf0d4ed039eccd7f3a9063196c))
* **api:** tile stage masks ([1fbee0a](https://github.com/ssube/onnx-web/commit/1fbee0ae52b4749fc2f55af315a961818aa6e059))
* **api:** trim whitespace from model names because it breaks things ([#376](https://github.com/ssube/onnx-web/issues/376)) ([4da4cd9](https://github.com/ssube/onnx-web/commit/4da4cd95a55bd52f1b733d087b251156aafb4000))
* **api:** turn alternatives back off for SDXL ([3ffbc00](https://github.com/ssube/onnx-web/commit/3ffbc00390d95a4a03096807b168e6b96fd2c14b))
* **api:** unload UNet before CNet conversion ([9ffe266](https://github.com/ssube/onnx-web/commit/9ffe266384794df1147f074b9eddf46057bddde6))
* **api:** update arpeggio parser and boto for s3 ([0e7e479](https://github.com/ssube/onnx-web/commit/0e7e4795f510b30a58a813e7eae88ca747402be4))
* **api:** update codeformer patches for new lib ([3e1db70](https://github.com/ssube/onnx-web/commit/3e1db707ac79265546e8be4bbe432be9b8f8ba08))
* **api:** update controlnet lib ([a0ee620](https://github.com/ssube/onnx-web/commit/a0ee62033638d6de7545e60a8199957cebae2641))
* **api:** update dependencies for SDXL ([7e73045](https://github.com/ssube/onnx-web/commit/7e730452f36e23d89a534e6b8ca395038fbfac13))
* **api:** update deprecated import from diffusers ([3ffb30f](https://github.com/ssube/onnx-web/commit/3ffb30f1217aa66a705a382410cc7e3059b2d612))
* **api:** update deprecated imports from diffusers ([b6aed05](https://github.com/ssube/onnx-web/commit/b6aed0542c558ecdba4e0da61f281a2cd5f635e0))
* **api:** update flask and pin werkzeug ([#414](https://github.com/ssube/onnx-web/issues/414)) ([0155236](https://github.com/ssube/onnx-web/commit/0155236744ae8bb2d036f9a90987fe1e1043f871))
* **api:** update HF hub version ([#433](https://github.com/ssube/onnx-web/issues/433)) ([0364543](https://github.com/ssube/onnx-web/commit/0364543bad9213f41aa97a16e3e466f0e843ceaa))
* **api:** update minimum image size for SDXL base ([58795de](https://github.com/ssube/onnx-web/commit/58795de00d23658a788a1f9b3ccfa67e5aa92e4a))
* **api:** upgrade safetensors for SDXL ([b37b49e](https://github.com/ssube/onnx-web/commit/b37b49e33d490cd83305d691803314f30c6db9b4))
* **api:** use correct post-fetch path when converting from checkpoints ([#432](https://github.com/ssube/onnx-web/issues/432)) ([133c4a2](https://github.com/ssube/onnx-web/commit/133c4a20bdaa08c89ea7078fa7f973b623cc938c))
* **api:** use full-size latents for all panorama pipelines ([5824149](https://github.com/ssube/onnx-web/commit/5824149cc097aad0fcb92d0d1ac5eac5f51ed48c))
* **api:** use Torch pipelines while loading models for conversion ([5d3a7d7](https://github.com/ssube/onnx-web/commit/5d3a7d77a5b3f6bd20cd4082b722eca3d8c65409))
* **api:** use upstream SD upscaling pipeline as base for in-tree one ([d3a4cc8](https://github.com/ssube/onnx-web/commit/d3a4cc8fd20ae156e986f9afa9414070aae17163))
* **api:** various controlnet fixes ([ba9982a](https://github.com/ssube/onnx-web/commit/ba9982af5114804d8a4551c43578556181c520fe))
* **api:** write tests for embedding/inversion blending ([e9b1375](https://github.com/ssube/onnx-web/commit/e9b13754406929049bd30b69b63e88ce4bc000c7))
* **build:** add vscode config for API testing ([db82c6b](https://github.com/ssube/onnx-web/commit/db82c6b760257c13f3138d96a539812aed0526ed))
* **build:** copy web UI output to server default path after bundling ([a1fc606](https://github.com/ssube/onnx-web/commit/a1fc60641f8c7bf6c80f24497002d689ddf3556f))
* **build:** sort imports in tests ([d8ea005](https://github.com/ssube/onnx-web/commit/d8ea00582e85e8467b465a04c0c302bd26839b4f))
* **docs:** add conversion error to user guide ([#404](https://github.com/ssube/onnx-web/issues/404)) ([108c502](https://github.com/ssube/onnx-web/commit/108c502869141c6bd36876cd5b7c4bda90ab7d24))
* **docs:** add links from getting started to other docs ([e373e13](https://github.com/ssube/onnx-web/commit/e373e134f1cb2a14ec2e85a18b34945137ec611b))
* **docs:** add missing web UI setup step ([6e614aa](https://github.com/ssube/onnx-web/commit/6e614aa1e05a284ffcbc24dd09e56d628be429b8))
* **docs:** add note about MIopen errors ([#444](https://github.com/ssube/onnx-web/issues/444)) ([a4c4877](https://github.com/ssube/onnx-web/commit/a4c4877064f6b90c7e699901e7f933ce861b5ae7))
* **docs:** add SDXL folders to pre-converted readme ([35cc16a](https://github.com/ssube/onnx-web/commit/35cc16ab0f2ddd7a4734adc440ed3c7a118d4644))
* **docs:** add usage instructions to pre-converted models ([1f778ab](https://github.com/ssube/onnx-web/commit/1f778abd69b06fb532eaf5ca308c835dc12a3f3b))
* **docs:** cover grid mode in user guide ([7097b18](https://github.com/ssube/onnx-web/commit/7097b1802cf9487701d93c74d4c088b070214c89))
* **docs:** describe reseed tokens ([c0a4fb6](https://github.com/ssube/onnx-web/commit/c0a4fb6cada9179a2247f0690ab79eea64837777))
* **docs:** note LCM in readme ([1d65479](https://github.com/ssube/onnx-web/commit/1d6547977c5fdadcb474952cf0e49ac8c20f7fec))
* **docs:** replace relative links with GH ones ([c94c3fa](https://github.com/ssube/onnx-web/commit/c94c3fa01510b7511898bf038d36f5adc4503e8a))
* **docs:** update readme screenshot for SDXL ([d378415](https://github.com/ssube/onnx-web/commit/d3784158fa3fd293b9bea97bb3b753286d159534))
* **docs:** update tile parameters in user guide ([a6cb630](https://github.com/ssube/onnx-web/commit/a6cb63020610efbe89c15a206df6b0b8e9e263bc))
* **exe:** include more package metadata ([452e18d](https://github.com/ssube/onnx-web/commit/452e18daaaadb4a1055e3bc6a48f7d6892dabf09))
* **exe:** include necessary codeformer and timm sources in bundle ([b8405a7](https://github.com/ssube/onnx-web/commit/b8405a7e71546a0cf054df1dc72ebc0f0f3db214))
* **gui:** add state migrations for new unet/vae params ([#427](https://github.com/ssube/onnx-web/issues/427)) ([5680dd7](https://github.com/ssube/onnx-web/commit/5680dd704ef8a9a309aba328ff9c9d56903f3db5))
* **gui:** add string for LCM scheduler ([0b31ad0](https://github.com/ssube/onnx-web/commit/0b31ad0ab63cafdc1f8e9327b2d32d20ae258faa))
* **gui:** add strings for XL pipelines ([ebdc6a0](https://github.com/ssube/onnx-web/commit/ebdc6a00fec495223208dbaf1f8079d8fca53c92))
* **gui:** avoid crashing when copying source image to a tab with a mask canvas ([a3fad5c](https://github.com/ssube/onnx-web/commit/a3fad5c541df78586cbd07acd88ee5523e8aeb1d))
* **gui:** dedupe and sort available prompt tokens ([35171e6](https://github.com/ssube/onnx-web/commit/35171e6f1284cdce4cd5cd1f1819b5f78aecb48d))
* **gui:** expand grid ranges while building pipeline ([38d3999](https://github.com/ssube/onnx-web/commit/38d3999088d10d843a7779320dba8e9ee32b73f3))
* **gui:** handle missing prompts when parsing tokens ([7132f10](https://github.com/ssube/onnx-web/commit/7132f10e9de949f47dd94e7a771aebea7a44c48c))
* **gui:** make model controls on upscale tab work ([e933dc6](https://github.com/ssube/onnx-web/commit/e933dc6d50796aae6a028d22a63561f2ef220320))
* **gui:** make overlap params decimal inputs ([59e1a1a](https://github.com/ssube/onnx-web/commit/59e1a1a4c2550648c6ed2873adb318dee3b27f50))
* **gui:** make prompt input perform better with large LoRA/wildcard lists ([e0929ba](https://github.com/ssube/onnx-web/commit/e0929ba87098afee294985db20a30dfe0f085793))
* **gui:** make UI error screen more likely to show correct API hostname ([11c0ab9](https://github.com/ssube/onnx-web/commit/11c0ab9882244c3e7cd9d1e2742a16c8c33899e5))
* **gui:** reduce renders when changing prompt and size params ([1541818](https://github.com/ssube/onnx-web/commit/1541818c1977a0ce4fbcc70ff7f0386dec19528b))
* **gui:** use new grid seeds for every generation ([90d1812](https://github.com/ssube/onnx-web/commit/90d1812decee63f46a510c403f5ad0572da37bae))
* increase step limits for SDXL ([44851e3](https://github.com/ssube/onnx-web/commit/44851e3785074c228b1ebcb7740ffec29e3c6200))
* **models:** include correction and upscaling models in preconverted list ([83058f5](https://github.com/ssube/onnx-web/commit/83058f5a101a146452bb75c0a093f65a00803a14))
* **models:** update attn parameter name in CNet ([f73dce5](https://github.com/ssube/onnx-web/commit/f73dce507ced912e14c9f0d757fbb65b02d17989))
* **models:** use a real domain for pre-converted models ([9f11256](https://github.com/ssube/onnx-web/commit/9f1125643b9dc2ff28b8a6620b788de45266ed3d))
* **scripts:** improve MSE logging in release tests ([8df6ec2](https://github.com/ssube/onnx-web/commit/8df6ec231fc7686f9a5353afef6a84e01754645f))
* **scripts:** log node name differences in onnx models ([f6db421](https://github.com/ssube/onnx-web/commit/f6db4216317eee79b43141c1550965021abb8039))
* **scripts:** update test MSE and references for recent tiling changes ([74cb100](https://github.com/ssube/onnx-web/commit/74cb1002365163b918cc046ee67742ca052e56cc))
* **tests:** add release tests for SDXL, LCM, and turbo ([68a3f13](https://github.com/ssube/onnx-web/commit/68a3f13f62242b49fb0a5364709e00361cddb9be))
* **tests:** expand worker tests ([5a51770](https://github.com/ssube/onnx-web/commit/5a517704ea2b1de1f7a3f2b62ebdb4a2db2f31b1))

## [0.10.0](https://github.com/ssube/onnx-web/compare/v0.9.0...v0.10.0) (2023-08-23)


### Features

* add admin endpoint to restart image workers ([#207](https://github.com/ssube/onnx-web/issues/207)) ([df0e7dc](https://github.com/ssube/onnx-web/commit/df0e7dc57e7d221cb7f20d81b74490147f0758c4))
* add img2img loopback ([#331](https://github.com/ssube/onnx-web/issues/331)) ([00fb64b](https://github.com/ssube/onnx-web/commit/00fb64ba82b597862fd8b09bbee2405dc7bda9db))
* add menu for source image filters ([4df28a5](https://github.com/ssube/onnx-web/commit/4df28a5ce708967a10648297c96a2a989b991bae))
* add method parameter for highres mode ([f451d8d](https://github.com/ssube/onnx-web/commit/f451d8db7473c6e4849ef7fb9d18a7b99014ed21))
* add parameter for ControlNet selection ([9e017ee](https://github.com/ssube/onnx-web/commit/9e017ee35d2cec55aaabd695b9203d027e8e337c))
* add parameter for highres iterations ([#316](https://github.com/ssube/onnx-web/issues/316)) ([7f504a5](https://github.com/ssube/onnx-web/commit/7f504a5b5b4510d2e69abf5b88f341c34c1a1c47))
* add tiled VAE parameter to client ([7e5380d](https://github.com/ssube/onnx-web/commit/7e5380db434ad33dadb02eb4e195a76359c606d6))
* add UNet stride as its own parameter ([3b02fc5](https://github.com/ssube/onnx-web/commit/3b02fc5768f508325a3e5bd022bfe01789cf99bd))
* **api:** add chain pipeline stages to load images from S3 or URL ([#184](https://github.com/ssube/onnx-web/issues/184), [#185](https://github.com/ssube/onnx-web/issues/185)) ([2eaf85a](https://github.com/ssube/onnx-web/commit/2eaf85a43efdcfcbe63a391922b7866b6253d2e2))
* **api:** add endpoints to manage extras file ([d39c792](https://github.com/ssube/onnx-web/commit/d39c7920a2bcb3f04d470662fa472db67a4e98b4))
* **api:** add env vars for controlnet conversion and opset ([0d51d61](https://github.com/ssube/onnx-web/commit/0d51d617281bc13822e899418b46f70184026827))
* **api:** add highres to img2img mode for all pipelines ([ad35c41](https://github.com/ssube/onnx-web/commit/ad35c41c9de3195c0fd80f57226c046223548ed2))
* **api:** add img2img mode to panorama pipeline ([47d80b0](https://github.com/ssube/onnx-web/commit/47d80b07b3a7a72c8eadde685b28a6e58d790082))
* **api:** add initial support for BSRGAN and SwinIR upscaling ([#153](https://github.com/ssube/onnx-web/issues/153), [#154](https://github.com/ssube/onnx-web/issues/154)) ([62aa7e8](https://github.com/ssube/onnx-web/commit/62aa7e84732a907942a67f5c430220af7aa48937))
* **api:** add inpaint to panorama pipeline ([71b9518](https://github.com/ssube/onnx-web/commit/71b95182a195d7347ac3e9b778e1a053b1b19601))
* **api:** add linear blend stage for chain pipeline ([#183](https://github.com/ssube/onnx-web/issues/183)) ([e3540ac](https://github.com/ssube/onnx-web/commit/e3540ac43572053d598bedc6053600cffc8e3071))
* **api:** add list pipelines endpoint ([6b51041](https://github.com/ssube/onnx-web/commit/6b51041ee8d4fcbf2ef29c5808e41f00816d4633))
* **api:** add lock to conversion endpoint ([e96bd0f](https://github.com/ssube/onnx-web/commit/e96bd0fca4cc65f4b6fb107fc2e5746626882e58))
* **api:** add optimization for max attention slicing ([#355](https://github.com/ssube/onnx-web/issues/355)) ([dc6bf33](https://github.com/ssube/onnx-web/commit/dc6bf330c1c7fc920d93e82d45b7383a5c4b63dc))
* **api:** add option for CPU-only conversion on systems with CUDA ([3f00da9](https://github.com/ssube/onnx-web/commit/3f00da9681da261bff30074f6da521f25dc26e44))
* **api:** add option to reload CNet for conversion ([9c28154](https://github.com/ssube/onnx-web/commit/9c28154dee05a0d6e58fe20633d72a65d3a92218))
* **api:** add panorama pipeline for ONNX ([214af7f](https://github.com/ssube/onnx-web/commit/214af7fe6a1e7a57f6b9fedbecce793f7577a315))
* **api:** add params for more SwinIR models ([2a7621c](https://github.com/ssube/onnx-web/commit/2a7621c195c01000badf74073fd95803fffbb99a))
* **api:** add params for SwinIR large models ([7f6da8e](https://github.com/ssube/onnx-web/commit/7f6da8eecae536dc7d761e031afc79cdafd6e23b))
* **api:** add setup scripts for Windows ([1cd436d](https://github.com/ssube/onnx-web/commit/1cd436d6434c73e36e0c2af8cb5930ac1593c935))
* **api:** add source image filters for controlnet and others ([80d00e4](https://github.com/ssube/onnx-web/commit/80d00e4477aebe14982206dfa814de4a1378fbdc))
* **api:** add support for highres images ([cdaf1b8](https://github.com/ssube/onnx-web/commit/cdaf1b8e5d6669e865e21669b60e836d2bb0d3fe))
* **api:** add support for negative embeds ([#348](https://github.com/ssube/onnx-web/issues/348)) ([7b0095a](https://github.com/ssube/onnx-web/commit/7b0095a66583d34bbfa61f0a7d70fa5ead1f5c5e))
* **api:** add support for PyTorch 2.0 ([#292](https://github.com/ssube/onnx-web/issues/292)) ([34f1973](https://github.com/ssube/onnx-web/commit/34f19737070a75df76e7cd234b135b3980f6927c))
* **api:** add support for wildcards ([c8a9dd4](https://github.com/ssube/onnx-web/commit/c8a9dd4475da55113259b2c330687d726d485f27))
* **api:** add SwinIR real x4 to base models ([6570d19](https://github.com/ssube/onnx-web/commit/6570d19fa3295baf8ba201ba93f193a60add98d6))
* **api:** add system notifications when image jobs finish ([#329](https://github.com/ssube/onnx-web/issues/329)) ([d0e4b8d](https://github.com/ssube/onnx-web/commit/d0e4b8da29fe82152ce81afebbe5f0dc9312d571))
* **api:** add tile size and stride to image parameters ([95725ff](https://github.com/ssube/onnx-web/commit/95725fff79fdc14930f84d100223e6df0db8e11e))
* **api:** add tiled VAE wrapper ([64a753e](https://github.com/ssube/onnx-web/commit/64a753e06496130a90167b7ba2630dd8a6c0e5e5))
* **api:** allow converting inpaint models ([#356](https://github.com/ssube/onnx-web/issues/356)) ([dbd9a18](https://github.com/ssube/onnx-web/commit/dbd9a186ae6ec2eadc530f603ac720d10d297e64))
* **api:** allow offloading individual models to CPU ([#330](https://github.com/ssube/onnx-web/issues/330)) ([cad87b9](https://github.com/ssube/onnx-web/commit/cad87b97f42e559ccc40895964414051ba1b9f09))
* **api:** apply overlap to highres upscaling stage ([ed953f5](https://github.com/ssube/onnx-web/commit/ed953f518a9097fad7726e4054e8187177167b53))
* **api:** convert CNet for existing diffusion models ([0dd8272](https://github.com/ssube/onnx-web/commit/0dd82722853499ee3599f1e566f5b041f6e1b1cc))
* **api:** create hash file for models without one ([7c8dc7a](https://github.com/ssube/onnx-web/commit/7c8dc7a6b619995deb01e23ec619e7fe18425502))
* **api:** do not repeat wildcard values ([e65de81](https://github.com/ssube/onnx-web/commit/e65de8115e6cf961cd1f889f156271f914fbc76a))
* **api:** embed image parameters in EXIF data ([#383](https://github.com/ssube/onnx-web/issues/383)) ([7e21b95](https://github.com/ssube/onnx-web/commit/7e21b9539ebe8244d5002f91e8c6e7deaa892cf8))
* **api:** experimental support for LoHA networks ([35432f1](https://github.com/ssube/onnx-web/commit/35432f1ab27b773a9ec25458a77585d10551ee71))
* **api:** histogram equalization and blending for highres tiling ([6317094](https://github.com/ssube/onnx-web/commit/6317094c5f0762469136cae7ac945d9979653166))
* **api:** ignore comments and empty lines in wildcard files ([17a7101](https://github.com/ssube/onnx-web/commit/17a710197cdad1828d6c5c78c46cba4cdaea9c1b))
* **api:** implement spiral tile order for non-square images ([c8382dc](https://github.com/ssube/onnx-web/commit/c8382dc6899ca3be9922e997bb68396eea59275e))
* **api:** include version number in logs ([003a350](https://github.com/ssube/onnx-web/commit/003a350a6c65b88fdd6e4d3db728f60fa3639bf3))
* **api:** load wildcards from markup files ([5df9aa2](https://github.com/ssube/onnx-web/commit/5df9aa2af7cb1bfaedd0541c26653ddbb40aa3eb))
* **api:** make chain pipeline work without a source image ([af416c2](https://github.com/ssube/onnx-web/commit/af416c252ddc50060fe9af70adc65cdc2ebe9a23))
* **api:** make chain stages into classes with max tile size and step count estimate ([2913cd0](https://github.com/ssube/onnx-web/commit/2913cd03826b9257abdb7a7660f08a6acc170958))
* **api:** make pipeline stages support multiple images ([3718525](https://github.com/ssube/onnx-web/commit/37185252a5a148dc4593eb53fc10f795f172738a))
* **api:** parse alternative groups in prompts ([b249936](https://github.com/ssube/onnx-web/commit/b24993696394d65b811810302a0de05f039e621d))
* **api:** pass tile size param to most pipeline stages ([d8ec93a](https://github.com/ssube/onnx-web/commit/d8ec93a619d644937c54a03c7ecd6e1253c3987e))
* **api:** read model hash from file ([e3a458a](https://github.com/ssube/onnx-web/commit/e3a458a7368ac5f3a8d134d9a3d3f56ce229436d))
* **api:** remove size restrictions on most pipelines ([5e1b700](https://github.com/ssube/onnx-web/commit/5e1b70091c2d6a7f35da0eda6ca37887fe17e258))
* **api:** start adding support for multiple prompt parsers ([0f12988](https://github.com/ssube/onnx-web/commit/0f1298824c720673c4c4691924036f5427cd33b0))
* **api:** start using chain pipelines for all images ([fd3e65e](https://github.com/ssube/onnx-web/commit/fd3e65eafcf88f5508c7484cc1bda5770fa62957))
* **api:** support 3x3 kernels in LoRA and LoCONs ([7e3ca8a](https://github.com/ssube/onnx-web/commit/7e3ca8ab015ae6405ed1c2389ebb726b96440aa9))
* **api:** support wildcards in nested folders ([865b25e](https://github.com/ssube/onnx-web/commit/865b25e6d7fbde77c40450c5cd3873cecb828ba0))
* **api:** switch API server to Waitress ([#159](https://github.com/ssube/onnx-web/issues/159)) ([76860f6](https://github.com/ssube/onnx-web/commit/76860f649a46c8b11390dc47c4030c1f370f7bb4))
* **api:** update requirements for torch 2.0 ([89ebbb8](https://github.com/ssube/onnx-web/commit/89ebbb8536a5365ea9152e177285515d5db1e694))
* **api:** write model hashes to image exif ([062b1c4](https://github.com/ssube/onnx-web/commit/062b1c47aa309fa04ee89ba72c283a63828d3da8))
* **exe:** add file with API version and commit to bundle ([94688ab](https://github.com/ssube/onnx-web/commit/94688ab3c768af25e9783b3f36870a98e5c3b26c))
* **exe:** add specs and launch scripts for Windows EXE bundle ([#305](https://github.com/ssube/onnx-web/issues/305)) ([205ff3e](https://github.com/ssube/onnx-web/commit/205ff3e40383de42668a04ab7e55ab7a8dd5f5e2))
* experimentally add TensorRT runtime ([f420a3a](https://github.com/ssube/onnx-web/commit/f420a3a6125c3b656aa0f154de9eab2261e5b9f6))
* **gui:** add a tab for managing the extra models ([#365](https://github.com/ssube/onnx-web/issues/365)) ([6e78f40](https://github.com/ssube/onnx-web/commit/6e78f40f093d07f5f9936d00b6386e519ab5b73b))
* **gui:** add ability to save profiles for img2txt and txt2txt ([4009ed8](https://github.com/ssube/onnx-web/commit/4009ed8443df4a84750a309661904bbbec29a0ac))
* **gui:** add button to download image metadata JSON ([be39609](https://github.com/ssube/onnx-web/commit/be396099ef6c78ae99a115290332502ae796d443))
* **gui:** add extras endpoints to client ([a0fdffa](https://github.com/ssube/onnx-web/commit/a0fdffab23161a5af7e46a1f19ccaf0378a524f4))
* **gui:** add highres control to most tabs ([27954f3](https://github.com/ssube/onnx-web/commit/27954f3e65c570721ccb368dfa7ebf4d6fe7cd45))
* **gui:** add highres parameters ([ba09748](https://github.com/ssube/onnx-web/commit/ba09748e94b8044359998d71903b35ebacd67618))
* **gui:** add profile download button ([a6e0461](https://github.com/ssube/onnx-web/commit/a6e04611f241c3f09652bc07fecc303ffbc07e08))
* **gui:** add tile and stride params ([d63130c](https://github.com/ssube/onnx-web/commit/d63130cd75c5f3408575060fa19c6327f0c59a6b))
* **gui:** load and parse most parameters from image, text, or json ([079d4aa](https://github.com/ssube/onnx-web/commit/079d4aa6028882ebc1bb01bd48a7e30b21ad5f9e))
* **gui:** move model controls into each tab ([f14f197](https://github.com/ssube/onnx-web/commit/f14f197264ba2b1f2bc9b396eb02490a341e7d9b))
* **gui:** remove generic SD pipeline option ([ca2e436](https://github.com/ssube/onnx-web/commit/ca2e436f0623e18b4cfe8a0363fcfcf10508acf7))
* **gui:** sort lists by visible labels after i18n ([7f28c0f](https://github.com/ssube/onnx-web/commit/7f28c0f1940dfc41591e7f221ee14e30a0fbc70d))
* make enabling highres a parameter of its own ([99c91a3](https://github.com/ssube/onnx-web/commit/99c91a301c9c59da03461c59b7800a6c12fff295))
* make pipeline type a request parameter ([2af1530](https://github.com/ssube/onnx-web/commit/2af1530a7eb745a10df8140a864f087c7ddbe3e4))
* **scripts:** add json and parquet support to prompt book parser ([2121c7a](https://github.com/ssube/onnx-web/commit/2121c7aa5d5ffecf240145822ce188e82f8159a1))
* **scripts:** add release tests for panorama and upscaling with correction ([f53e8c1](https://github.com/ssube/onnx-web/commit/f53e8c1761675052d69b2ed315ea23f3c6fcfd5d))
* **scripts:** add retries to release tests ([bbd779a](https://github.com/ssube/onnx-web/commit/bbd779a9c6baea2c9dd5fc473730f7547db45b3c))
* **scripts:** add script to parse prompt books ([de8105e](https://github.com/ssube/onnx-web/commit/de8105ec6017c2da417ca55e1de606474c77fef3))


### Bug Fixes

* **api:** add arpeggio parser to base requirements ([5ede554](https://github.com/ssube/onnx-web/commit/5ede55499aede0a0b87f8ebc55b9a4839ef71d78))
* **api:** add coloredlogs to base deps ([27c6e71](https://github.com/ssube/onnx-web/commit/27c6e71890cbb0c490c9b34865f037ff46634dfc))
* **api:** add conversion to Windows bundle ep ([a291dc8](https://github.com/ssube/onnx-web/commit/a291dc89800968325376862753316ad82bae320d))
* **api:** add convertible pipelines to extras schema ([a57d90c](https://github.com/ssube/onnx-web/commit/a57d90ca020cbc919c47a1c75a3dfbd0911dbab4))
* **api:** add env var for admin token ([a03f89a](https://github.com/ssube/onnx-web/commit/a03f89a62c401aada632c23846d7b7f065839219))
* **api:** add missing arguments to prompt patch ([#336](https://github.com/ssube/onnx-web/issues/336)) ([dd77166](https://github.com/ssube/onnx-web/commit/dd771663ef1f7e6fc5f4204edb9e5cacd2fecc6e))
* **api:** add model image size and version hint to extras file ([bc71583](https://github.com/ssube/onnx-web/commit/bc71583393088b7402a5193904eb4b2484cd9bb2))
* **api:** add name filter and MSE multiplier args to release tests ([5378619](https://github.com/ssube/onnx-web/commit/5378619ef2dba37c240d5151ea1e693741750179))
* **api:** add non-square txt2img test ([fcaeb8c](https://github.com/ssube/onnx-web/commit/fcaeb8cb42fbced130fdfe13fdac56da564bfbd1))
* **api:** add pre-converted ControlNets to base sources, add missing ControlNet strings ([161913b](https://github.com/ssube/onnx-web/commit/161913bb7ee5fda19d7bb574e056a6bc3f917a5f))
* **api:** add progress bars to release tests ([5d18779](https://github.com/ssube/onnx-web/commit/5d18779e27e7c6f87f384e38eb1fee42548ddb77))
* **api:** add pytorch_lightning to optional reqs ([#366](https://github.com/ssube/onnx-web/issues/366)) ([852c57c](https://github.com/ssube/onnx-web/commit/852c57c08a7f9e8ee4f378f45c15cae6dbca6515))
* **api:** add requirements files for optional deps ([ae9f6c2](https://github.com/ssube/onnx-web/commit/ae9f6c2f35c3861c8422e557320d2f95e654c116))
* **api:** add version for omegaconf ([9d08676](https://github.com/ssube/onnx-web/commit/9d08676caaa356f8c08b2558a19a368236466902))
* **api:** allow more LoRA/TI filenames ([d699c75](https://github.com/ssube/onnx-web/commit/d699c75283da7e2a042aca08eeba8fcc2ec90e21))
* **api:** always use accumulating progress counters ([0573721](https://github.com/ssube/onnx-web/commit/0573721d1216c7b2fb85e2bb1c3a4fc0ff599aa5))
* **api:** apply FP16 patches to SD upscaling pipeline ([464bfd0](https://github.com/ssube/onnx-web/commit/464bfd01b8ff65c5502dfe45ad2f9c2a5a2b1986))
* **api:** avoid passing cache path before sanitizing config name ([86d458a](https://github.com/ssube/onnx-web/commit/86d458a0c675aa7ae87526a77d5edad1134cae1b))
* **api:** better handling for errors while converting checkpoint to torch ([#165](https://github.com/ssube/onnx-web/issues/165)) ([ff9ce03](https://github.com/ssube/onnx-web/commit/ff9ce03af5565d8c9f422ce59207f6a96390b450))
* **api:** blend LoHA and LoRA weights for 1x1 kernels ([f0109d3](https://github.com/ssube/onnx-web/commit/f0109d3406b396094f95ec32850e446a534b0509))
* **api:** build sum tokens for TIs using emb_params key ([5f54181](https://github.com/ssube/onnx-web/commit/5f5418132b39223f27e0b7c57536a683842f909c))
* **api:** call venv during setup scripts ([#378](https://github.com/ssube/onnx-web/issues/378)) ([3e96609](https://github.com/ssube/onnx-web/commit/3e966096cecc2a7aab64ff9729af280603f409a5))
* **api:** check diffusers version before imports ([#336](https://github.com/ssube/onnx-web/issues/336)) ([95841ff](https://github.com/ssube/onnx-web/commit/95841ffe2be6a657ad588a8b868f78ba2b2dcd0c))
* **api:** check GTK import individually ([95e75ff](https://github.com/ssube/onnx-web/commit/95e75ffd24fc803a2b196485d8ab2e196c1e6f8b))
* **api:** collate CNet after unloading UNet ([b6a4cba](https://github.com/ssube/onnx-web/commit/b6a4cbaae1dbf5f2447cc3fbf8e42b0eb352a231))
* **api:** collect final images from SD upscale stage ([3798ea7](https://github.com/ssube/onnx-web/commit/3798ea77e76c6f8f9f4a7003ba79b1ff2f63b86d))
* **api:** convert hidden states to fp32 before doing normalization on the CPU ([#309](https://github.com/ssube/onnx-web/issues/309)) ([85b3324](https://github.com/ssube/onnx-web/commit/85b332467e1faab416d329ac090b5b31d01df95e))
* **api:** correct dict types for 3.8 ([7caaa9e](https://github.com/ssube/onnx-web/commit/7caaa9ed40c6329fc1b5271a92a18cad5f4ddbfd))
* **api:** correct name of torch extraction var ([4810ca8](https://github.com/ssube/onnx-web/commit/4810ca858a8148849090461c5ae971852128295a))
* **api:** correct parameter names for BSRGAN, use RRDB from BasicSR for Real ESRGAN ([e0e6b74](https://github.com/ssube/onnx-web/commit/e0e6b74b98c8ef5bbed21548a0053d148716a996))
* **api:** correct return value after fully converting checkpoints ([e9e9d75](https://github.com/ssube/onnx-web/commit/e9e9d75f9df67df25be80f77f95bcbefa9575014))
* **api:** correct slashes in launch scripts ([c96dd81](https://github.com/ssube/onnx-web/commit/c96dd814a87c490a5d549e6ec2370e436a435259))
* **api:** correct type of model field in extras ([23fb752](https://github.com/ssube/onnx-web/commit/23fb752bb63e55fbfc4bdc5aa6a5648559ff2f07))
* **api:** correctly blend LoRAs into UNet during conversion ([25176fe](https://github.com/ssube/onnx-web/commit/25176fea4df493eafee629514ae5fbb7e4d0a1c2))
* **api:** correctly disable source filtering when none is selected ([eeaba37](https://github.com/ssube/onnx-web/commit/eeaba37fa9b10227a415cd37843c869945c6ad7e))
* **api:** correctly handle sliced kernels ([7db53a8](https://github.com/ssube/onnx-web/commit/7db53a82df3fb1cf5e915fa52942db40a500c835))
* **api:** correctly pass noise level to SD upscaling ([dde1e2d](https://github.com/ssube/onnx-web/commit/dde1e2daade2224362380c866ce728407c03e902))
* **api:** define tile size for logging ([7c1b85f](https://github.com/ssube/onnx-web/commit/7c1b85f79357e9f72802a2a3d4f3e64fabc4f462))
* **api:** do not downscale source images for panorama pipeline ([d9f7971](https://github.com/ssube/onnx-web/commit/d9f7971d0a440a777a3d3500dab5149da11f8a08))
* **api:** do not overlap tiles by default ([8215a1b](https://github.com/ssube/onnx-web/commit/8215a1bf8a8df5c020df9b3a5a14389643c82e1f))
* **api:** do not overlap upscale tiles during highres ([d98ecc0](https://github.com/ssube/onnx-web/commit/d98ecc023dcad5f1bf6c86d6827825a9aa8f6a04))
* **api:** download pretrained models from HF correctly ([#371](https://github.com/ssube/onnx-web/issues/371)) ([d66bf9e](https://github.com/ssube/onnx-web/commit/d66bf9e54fd96a2f7a0f0305b992d8c514967d1f))
* **api:** ensure gradient points are always in order ([82a80bb](https://github.com/ssube/onnx-web/commit/82a80bb60b64bb1b37ae9d4db03a8d51248470cd))
* **api:** ensure spiral grid coords are always whole pixels ([1cfc538](https://github.com/ssube/onnx-web/commit/1cfc538018428da0d48b20d93fa67a0076c6cd37))
* **api:** fully qualify HF models ([#371](https://github.com/ssube/onnx-web/issues/371)) ([da6aa15](https://github.com/ssube/onnx-web/commit/da6aa15afcbf5def8d65f1f81fb0642210dd7882))
* **api:** generate latents before tiling ([60aa8ab](https://github.com/ssube/onnx-web/commit/60aa8ab4c041f6cb50a56993b694afb60ef7b7f4))
* **api:** generate new latents for partial tiles ([3d4c77d](https://github.com/ssube/onnx-web/commit/3d4c77d5d054fb917b4ffcd9eab8b48556b295f1))
* **api:** get admin token from correct server object ([6fecb1e](https://github.com/ssube/onnx-web/commit/6fecb1ee8b5d70b1f340c6e7ba8810ca516b8538))
* **api:** handle 3x3 kernels in LoHA networks ([bd03edc](https://github.com/ssube/onnx-web/commit/bd03edc2ad10b86bde7ed23ebdd3442312aaab77))
* **api:** handle blending of mismatched kernels ([719b349](https://github.com/ssube/onnx-web/commit/719b34967fb9841ebd838581a927c5ca65f0e124))
* **api:** handle empty negative prompts in exif data ([7cbb419](https://github.com/ssube/onnx-web/commit/7cbb4197ba6af8a4faf4ebf258c6bd228854b0bb))
* **api:** handle empty prompts ([#340](https://github.com/ssube/onnx-web/issues/340)) ([9bb612f](https://github.com/ssube/onnx-web/commit/9bb612f54e8957895159bde05eb2bb5f6b5cd111))
* **api:** handle mixed tensors for ControlNet on CPU ([3196535](https://github.com/ssube/onnx-web/commit/31965356d8a4d3804a8f15f47897f2f5bda884a5))
* **api:** handle more SwinIR models ([1506f51](https://github.com/ssube/onnx-web/commit/1506f51ff41d940dd38756e7cd89987aa801fbd8))
* **api:** handle panoramic outpainting output ([c0dd4e9](https://github.com/ssube/onnx-web/commit/c0dd4e96dc90ae49e601fa94a6207457ae16ba13))
* **api:** handle unlimited size stages correctly ([3edf5e6](https://github.com/ssube/onnx-web/commit/3edf5e6c4df91332cd0d4133e5b40bfd41da6763))
* **api:** improve handling of non-square images around tile size ([d9dd1e4](https://github.com/ssube/onnx-web/commit/d9dd1e4b57dd4c174fad000555f5f11b02abdc19))
* **api:** improve summing of mismatched weights ([3e8f4b3](https://github.com/ssube/onnx-web/commit/3e8f4b3edf097d0c8c6832315519f69a8bd85e02))
* **api:** keep aspect ratio of mask for non-square sources ([#373](https://github.com/ssube/onnx-web/issues/373)) ([c8bc175](https://github.com/ssube/onnx-web/commit/c8bc175239124bb1ebca598b8e9e671e6555420c))
* **api:** keep ControlNet metadata after lookup ([17e7b6a](https://github.com/ssube/onnx-web/commit/17e7b6aff26c56bde45ed0b0ea7ba5b02d96a7c6))
* **api:** keep kernel slices within bounds ([5713957](https://github.com/ssube/onnx-web/commit/5713957026af52c880bc3b9d85efebee7ec4650d))
* **api:** keep network tokens while replacing wildcards in the saved prompt ([f7fc442](https://github.com/ssube/onnx-web/commit/f7fc442ba5af5f8a40d597776b645e33df85fd6b))
* **api:** limit fp16 ops for v2.1 models ([#364](https://github.com/ssube/onnx-web/issues/364)) ([572a515](https://github.com/ssube/onnx-web/commit/572a5159ad0eb61630f84995c295136acc7e885a))
* **api:** limit latent padding to tile size ([b92853d](https://github.com/ssube/onnx-web/commit/b92853d4384fcb0c43b265ff6e6a4037fc641ecf))
* **api:** load local custom VAE from within model path ([24f1ecc](https://github.com/ssube/onnx-web/commit/24f1ecc0eb49a7cfd5be894993c315b022692290))
* **api:** log number of tiles contributing to each image pixel ([5d13629](https://github.com/ssube/onnx-web/commit/5d13629ee83ccb5f77603c40b4a293b3a302ab2d))
* **api:** log tile size and overlap ([eef055e](https://github.com/ssube/onnx-web/commit/eef055eddd4deb072b626b3c344ea300488713cb))
* **api:** make img2img blend work with LPW ([197dc48](https://github.com/ssube/onnx-web/commit/197dc48b06ea7a452745b2ea10cd584a899125d4))
* **api:** make LPW pipeline valid again ([d47dab8](https://github.com/ssube/onnx-web/commit/d47dab81825dfb141f448fb62ad09dd835868adb))
* **api:** make panorama switch mode based on kwargs ([4b84188](https://github.com/ssube/onnx-web/commit/4b84188f6e3eb87ba5f8c5662abcc57d9bb46ecf))
* **api:** make panorama work with prompt alternatives ([c6fc860](https://github.com/ssube/onnx-web/commit/c6fc860484d3e2c4fccbeb06628c1763bac0d643))
* **api:** make pix2pix work with scheduler with float sigma ([982dc10](https://github.com/ssube/onnx-web/commit/982dc10e640ac87fe470845d4ccbd5ed6f7d7d49))
* **api:** make SD upscaling compatible with multi-prompt patch ([9c337df](https://github.com/ssube/onnx-web/commit/9c337df7dfb15563693df319d2f430354702f094))
* **api:** make SD upscaling work with negative prompt ([0d60406](https://github.com/ssube/onnx-web/commit/0d60406eca829197d158cf910f5ffe528179ae25))
* **api:** make sure UNet wrapper always has embeds defined ([b8b73d8](https://github.com/ssube/onnx-web/commit/b8b73d8592bc5d1401085c880a7fd3a823412ef2))
* **api:** make tiling compatible with source stages ([8781f7f](https://github.com/ssube/onnx-web/commit/8781f7fda0f3e8523b8b4d17a9d4913b4d93432b))
* **api:** mark panorama outpainting tests as very slow, update refs ([f20afeb](https://github.com/ssube/onnx-web/commit/f20afeb58f3623cb41938d08bfb9497141ec2c12))
* **api:** match ControlNet selection against model names ([8d47b71](https://github.com/ssube/onnx-web/commit/8d47b71183072d1b3948171203f458e948e9e4aa))
* **api:** match LPW parameter order ([d2baa32](https://github.com/ssube/onnx-web/commit/d2baa323ab8c4c309f230975c3c1db38a1af762c))
* **api:** match mask and image size before adding noise ([#373](https://github.com/ssube/onnx-web/issues/373)) ([23aaf65](https://github.com/ssube/onnx-web/commit/23aaf656d37f46f5e8d02cd3c724a3747721c5f3))
* **api:** match panorama img2img parameter check to numpy code path ([c8e1519](https://github.com/ssube/onnx-web/commit/c8e1519419a08bb41e7d529d6bec8a57f6f4d43e))
* **api:** match size of existing latent patch ([cf95ad2](https://github.com/ssube/onnx-web/commit/cf95ad2f0e3da1ef1bd4cedd597bad00e67ffde7))
* **api:** open web browser when launching Windows bundle ([fea9185](https://github.com/ssube/onnx-web/commit/fea918570753f297dbe908e90dff15e1ac3c8738))
* **api:** pad partial latents when working with tiles ([6b1ce37](https://github.com/ssube/onnx-web/commit/6b1ce37592efbd9a1cad132cd0450073add52121))
* **api:** parse config files as JSON or YAML depending on extension ([#370](https://github.com/ssube/onnx-web/issues/370)) ([b6692f0](https://github.com/ssube/onnx-web/commit/b6692f068eff9bb1c3ecce843ccf03bf09dad0c1))
* **api:** pass additional params to new stages ([7a73c9f](https://github.com/ssube/onnx-web/commit/7a73c9ff61943151f42bde237e0c5dd6910e8cc2))
* **api:** pass batch size and eta params to txt2img stage ([89dbf81](https://github.com/ssube/onnx-web/commit/89dbf813358a165866d848f791e0a728f6eacc2a))
* **api:** pass correct text model type when converting v2 checkpoints ([#360](https://github.com/ssube/onnx-web/issues/360)) ([2690eaf](https://github.com/ssube/onnx-web/commit/2690eafe0994528f183a9caa38c28b6ea6dfd8a8))
* **api:** pass inpaint param to checkpoint extraction ([e64b813](https://github.com/ssube/onnx-web/commit/e64b813ac086e22cc7506d6cd1e3b5182ead25cf))
* **api:** pass mask and sources to blending pipeline in correct order ([934dabb](https://github.com/ssube/onnx-web/commit/934dabb39e267f42272b0ab147be727316d0ca0a))
* **api:** pass overlap params to tile calculation ([7736430](https://github.com/ssube/onnx-web/commit/7736430fe78fd032b4db1286d49832d550b7d5d5))
* **api:** pass strength to LPW pipe from img2img blend ([a9fa767](https://github.com/ssube/onnx-web/commit/a9fa76737e583121cf87e559f2c5883bec8e67ca))
* **api:** pass upscale params to correction stages ([5556478](https://github.com/ssube/onnx-web/commit/5556478669e8f82b03412c4ac2f7d75090856a6d))
* **api:** pin pip dependencies, add requirements to renovate ([03402db](https://github.com/ssube/onnx-web/commit/03402dba67c00d0859b8d8fc17008b8794f0a602))
* **api:** print border size in expected order ([7b4ce44](https://github.com/ssube/onnx-web/commit/7b4ce44f51e0b309409f0f95da910820a45385f3))
* **api:** rely on pipeline cache for highres and loopback ([4ea372d](https://github.com/ssube/onnx-web/commit/4ea372d53ab1dbbe63b4001815d80334e22be961))
* **api:** remove device and patch calls to fix SD upscaling ([eb100f6](https://github.com/ssube/onnx-web/commit/eb100f647d42c1d325cc40abc5598af5639ec47c))
* **api:** remove inner loops in upscale stages ([12698d3](https://github.com/ssube/onnx-web/commit/12698d38eb486714df13623c386a49ae043bcd8c))
* **api:** remove nested tiling in highres ([a7be651](https://github.com/ssube/onnx-web/commit/a7be651032fa13210845a70b8093e6797370f867))
* **api:** remove size limit on inpainting stage ([f782f39](https://github.com/ssube/onnx-web/commit/f782f39cce01f2dc43b3787e4eeb6ed9168dccb7))
* **api:** remove tile size limit for img2img and outpaint stages ([15c26cd](https://github.com/ssube/onnx-web/commit/15c26cd74b58a923c5a468ef0741081a08ee7c20))
* **api:** remove traces of highres from blend pipeline ([4ac25f0](https://github.com/ssube/onnx-web/commit/4ac25f065040570c9094df451125b157f0f7a439))
* **api:** remove trailing space from param name ([ac2eceb](https://github.com/ssube/onnx-web/commit/ac2eceb0ac4fe0f921979d731d8ce0d2c3749b3d))
* **api:** remove unintentional tuple in img2img pipe ([fed4315](https://github.com/ssube/onnx-web/commit/fed43150959c2c23c7e91abeb135c7e3e13d5776))
* **api:** repair progress for API pipelines ([d9f251c](https://github.com/ssube/onnx-web/commit/d9f251c88beb7119890ea080b30af0c2dccd0331))
* **api:** replace unknown wildcards with empty string ([fa3a36e](https://github.com/ssube/onnx-web/commit/fa3a36ed25491a707c87483297d0d0ea49530632))
* **api:** resolve SD upscaling model relative to models path ([ec7d563](https://github.com/ssube/onnx-web/commit/ec7d563c58b8284bba32e3b9086854265df902cd))
* **api:** restart workers on HIP memory errors ([e0e0999](https://github.com/ssube/onnx-web/commit/e0e09996dec3255d5d664988134d6251490f42c1))
* **api:** restart workers on MIOPEN memory errors ([6aac0fe](https://github.com/ssube/onnx-web/commit/6aac0fe56ba961307be5a5e9dbb7cccce38308b7))
* **api:** restore inpaint pipeline option ([b076326](https://github.com/ssube/onnx-web/commit/b076326ab36a413cf79674857cef0fdab07b4b9f))
* **api:** restore old checkpoint conversion code path ([339441c](https://github.com/ssube/onnx-web/commit/339441cb164e87bd4f982a014d935d9842b2d7dd))
* **api:** restore use of config key when converting from checkpoints ([5760be7](https://github.com/ssube/onnx-web/commit/5760be710af3c9ce1e2af2ea2d236d45736c340e))
* **api:** return correct output from tiled VAE ([b4dfc44](https://github.com/ssube/onnx-web/commit/b4dfc44bc6c32ad4b24d1f7e38d5602d92b6b7a7))
* **api:** run GC during diffusers conversion, add flag to skip ControlNet ([#369](https://github.com/ssube/onnx-web/issues/369)) ([e2035c3](https://github.com/ssube/onnx-web/commit/e2035c3fbf9228d82d3ce34effc54ee29e3d6e18))
* **api:** run image workers as daemon procs ([1bfc7be](https://github.com/ssube/onnx-web/commit/1bfc7bee32d59d6b86062e04999cee656c54d447))
* **api:** run PyTorch GC on ROCm devices ([#323](https://github.com/ssube/onnx-web/issues/323)) ([00be4f4](https://github.com/ssube/onnx-web/commit/00be4f4721c09fbf9fa61f80bfa1c8fde7bc9c61))
* **api:** save prompt with wildcards replaced in EXIF data ([2cc4fee](https://github.com/ssube/onnx-web/commit/2cc4feefe96af4e415031e41872a9d5e7ff3fca5))
* **api:** scope patched imports and run GC after patching ([579c5f9](https://github.com/ssube/onnx-web/commit/579c5f9e97f487dc87826962c84935db3ef82741))
* **api:** send tile filters as correct type ([b816307](https://github.com/ssube/onnx-web/commit/b816307994b9a98a3ce98a2ee8812a75f02a2e84))
* **api:** share loaded pipeline when running loopback or highres after img2img ([0a75f96](https://github.com/ssube/onnx-web/commit/0a75f961dc3f2f69b17735c03a6e2e6a23e2efc0))
* **api:** skip gradient blending when tiles do not overlap ([732b07e](https://github.com/ssube/onnx-web/commit/732b07eb4601bcae51c5d979794ead37b25784aa))
* **api:** skip loading custom VAE after torch extraction ([#379](https://github.com/ssube/onnx-web/issues/379)) ([00b1bec](https://github.com/ssube/onnx-web/commit/00b1bec7a9d992c043a329316ea6d12643d1b999))
* **api:** skip prompt parsing patch when using LPW ([dcea248](https://github.com/ssube/onnx-web/commit/dcea248b7ba31cfea49e187387aff03a420acb14))
* **api:** specify input channels when converting inpainting models ([#356](https://github.com/ssube/onnx-web/issues/356)) ([0175d7e](https://github.com/ssube/onnx-web/commit/0175d7edcfdb1d4912494f1378421559cace4b76))
* **api:** split up worker name and job name to avoid logging false failures ([dfe9f6e](https://github.com/ssube/onnx-web/commit/dfe9f6ee4446e3a141e02948ee70dcab353d223a))
* **api:** store both pre-parse and parsed prompts ([#320](https://github.com/ssube/onnx-web/issues/320)) ([6e7f202](https://github.com/ssube/onnx-web/commit/6e7f202b8df50c6a1d19e00802f9b85dcc188c59))
* **api:** strip trailing newlines when reading hash from file ([16cf5bb](https://github.com/ssube/onnx-web/commit/16cf5bb8635932fa12cdd3945b7c79a5736d521a))
* **api:** support multiple outputs from txt2img stage ([6425a91](https://github.com/ssube/onnx-web/commit/6425a91fe3e230ff642b00bd3679b624b76bf9bf))
* **api:** swap dimensions for non-upscaling highres modes ([f8d59ab](https://github.com/ssube/onnx-web/commit/f8d59ab65aadda13577b6a4d19604934548d3cc5))
* **api:** switch back to torch extraction for now ([#379](https://github.com/ssube/onnx-web/issues/379)) ([3adafea](https://github.com/ssube/onnx-web/commit/3adafeaa3dca5c30b93b139ec9afcce2ca14b52e))
* **api:** switch between available pipelines ([b20df68](https://github.com/ssube/onnx-web/commit/b20df6813135c071efab7dec4f9dd56f69d8d1e0))
* **api:** switch to diffusers ckpt loading, add more pipelines to conversion ([#337](https://github.com/ssube/onnx-web/issues/337), [#356](https://github.com/ssube/onnx-web/issues/356)) ([4c12615](https://github.com/ssube/onnx-web/commit/4c126153f571f3ca579dfa67a294944c3689b609))
* **api:** tile stages based on input image or size param ([c9a1ace](https://github.com/ssube/onnx-web/commit/c9a1ace40bec1c2e138453565102356771b46aad))
* **api:** unwrap results of img2img chain ([42e6f35](https://github.com/ssube/onnx-web/commit/42e6f356a9e773982a50b4fd6e21cfdd60400672))
* **api:** update latent window size on VAE patches ([98386cb](https://github.com/ssube/onnx-web/commit/98386cb3850ebab918458dd996148d26a1f671c8))
* **api:** update panorama params when using cached pipeline ([55a1e46](https://github.com/ssube/onnx-web/commit/55a1e46fc3e0d2f25a9a17a3ad8d2cf4fb86dc1b))
* **api:** update VAE tiling params every time pipeline is used ([98f99b1](https://github.com/ssube/onnx-web/commit/98f99b1523f9b13d09f5b014085b4517fdb5e47c))
* **api:** use consistent cache key for each model type ([47b1094](https://github.com/ssube/onnx-web/commit/47b10945ffd0410c669f0b9b77cf18a4cd564bf2))
* **api:** use correct case for PNG metadata ([dc9048c](https://github.com/ssube/onnx-web/commit/dc9048c76f60dad0f696ef069f355653e994cfc7))
* **api:** use correct latents for scheduler noise ([bc946bb](https://github.com/ssube/onnx-web/commit/bc946bb0850c93399bf0b8d192c0989a15f96972))
* **api:** use correct model for SwinIR ([e166989](https://github.com/ssube/onnx-web/commit/e1669891116680d91396e417e6c98dfa3e633e84))
* **api:** use correct params for default outpainting borders ([#345](https://github.com/ssube/onnx-web/issues/345)) ([c7aea34](https://github.com/ssube/onnx-web/commit/c7aea34b28d18e64a38fbc13117730fde79d748f))
* **api:** use correct tile size for highres upscaling ([12e489b](https://github.com/ssube/onnx-web/commit/12e489b76188d5620074ba1b1f6d356fb420f460))
* **api:** use correct weight pairs in LoHA ([7f7476b](https://github.com/ssube/onnx-web/commit/7f7476bcbb20f603de24fd9c0b84cb7d14dad35c))
* **api:** use diffusion model name without path when looking up hashes ([0029943](https://github.com/ssube/onnx-web/commit/0029943c7d83eb89721992845e1b8e9941bec22f))
* **api:** use existing progress counter for highres and loopback ([5dfb09b](https://github.com/ssube/onnx-web/commit/5dfb09bd3c3900054ba0597e37d928b7ed183c94))
* **api:** use img2img pipeline for loopback when controlnet was originally selected ([93b0226](https://github.com/ssube/onnx-web/commit/93b02261b2b594cda63dd8ccd907045f2ec80382))
* **api:** use kwargs for chain stages ([2d10252](https://github.com/ssube/onnx-web/commit/2d102525648a451a4b2804b5f8901d15650f6418))
* **api:** use min/max from config for more params ([56ff902](https://github.com/ssube/onnx-web/commit/56ff9022da4bbdd4ff25f363eed50cb3cd9fa361))
* **api:** use padding token for prompt padding ([2fe6a87](https://github.com/ssube/onnx-web/commit/2fe6a878185366bc48b80171e61f827042df7053))
* **api:** use slice multiplication for 3x3 kernels without CP decomp ([a46f00a](https://github.com/ssube/onnx-web/commit/a46f00aeb447644961166ab366f6806ab4af9745))
* **api:** use tile size for all highres scaling methods ([7b0bed7](https://github.com/ssube/onnx-web/commit/7b0bed7aeaa8a624884809e43180151ddc4c135d))
* **api:** use upscaling method param in highres ([c515d25](https://github.com/ssube/onnx-web/commit/c515d25dd4686f1113073632c5888762204e2422))
* **api:** use VAE model dtype when converting sample ([395a632](https://github.com/ssube/onnx-web/commit/395a6329466597c55f599cce28c4694284f5d42b))
* **api:** use Waitress for Windows bundle ([9a2f35e](https://github.com/ssube/onnx-web/commit/9a2f35e181ffa8c23dca6ac4b7d9636dcf2b0014))
* **api:** wait for worker to become idle before enqueueing next job ([#286](https://github.com/ssube/onnx-web/issues/286)) ([cfdd926](https://github.com/ssube/onnx-web/commit/cfdd926fff0b94deb66f01d74d947bf5c328e637))
* **build:** copy extras file into image from models dir ([170e1c7](https://github.com/ssube/onnx-web/commit/170e1c7a708b4a34bdcf6eb1367293e324a55bb3))
* **build:** copy schemas into containers ([b43cb26](https://github.com/ssube/onnx-web/commit/b43cb26d060c0682b12b8a34b5c9c197fdbb962c))
* **build:** install CPU deps during CI ([1853214](https://github.com/ssube/onnx-web/commit/18532144098ac159545d6bc6b48547ee08b1e716))
* **build:** move images to large runners, use image root path ([75a239f](https://github.com/ssube/onnx-web/commit/75a239f736bd1109ca0754f0ae17cd0d8a8b1c7d))
* **build:** move python builds to larger runners ([00fc584](https://github.com/ssube/onnx-web/commit/00fc584c99e97250d9e0660b24451a9225919ec0))
* **build:** run tests on python 3.8 and 3.9 ([#354](https://github.com/ssube/onnx-web/issues/354)) ([08a23ed](https://github.com/ssube/onnx-web/commit/08a23eda65de52dc72ed39cfc49e35a7c73c9c7a))
* **build:** use 3.8 packages in AMD linux requirements file to match ROCm base image ([10fa36c](https://github.com/ssube/onnx-web/commit/10fa36c1c1991da049570d33a0bc1e69335e4cb6))
* **deps:** replace dependency react-query with @tanstack/react-query ^4.0.5 ([f53518a](https://github.com/ssube/onnx-web/commit/f53518ad245dcb274a1fe9997ae52a7beca71301))
* **docs:** add output image size table to user guide ([e8ac20b](https://github.com/ssube/onnx-web/commit/e8ac20b51cfbb88e9f8d70eff95a3aaead83c8da))
* **docs:** add overlap diagrams ([f4153aa](https://github.com/ssube/onnx-web/commit/f4153aaba8067670e4a67267b49d6a71080bf960))
* **docs:** add VC redist and security note to Windows setup ([ee3774b](https://github.com/ssube/onnx-web/commit/ee3774b70af46ec221eb847681ca551cf6b41c8d))
* **docs:** move container setup to server guide, link to setup methods from readme ([968058b](https://github.com/ssube/onnx-web/commit/968058bf359744150c0dd06696d40bc8870ece20))
* **docs:** note security option on bundle launch scripts ([f4c7f02](https://github.com/ssube/onnx-web/commit/f4c7f0203486d0b858d55cca7826ad5658f37094))
* **exe:** add build script for Windows bundle ([a76ded2](https://github.com/ssube/onnx-web/commit/a76ded2a98abcd716dab1c4a5780d32ee6e283e4))
* **exe:** add missing gfpgan folders ([#315](https://github.com/ssube/onnx-web/issues/315)) ([2a7a068](https://github.com/ssube/onnx-web/commit/2a7a0682bdb04061ea8e2598931114e9de68c125))
* **exe:** add omegaconf to bundle ([4c7e48b](https://github.com/ssube/onnx-web/commit/4c7e48b33e39c8a54ee3d8e8c98c3aa4324fe012))
* **exe:** add pytorch_lightning to Windows bundle ([#366](https://github.com/ssube/onnx-web/issues/366)) ([25e0ece](https://github.com/ssube/onnx-web/commit/25e0ece8e2cbb76d488ed7cbe8b11e53418a9c15))
* **exe:** add version info to bundle build script ([6e11218](https://github.com/ssube/onnx-web/commit/6e1121820fc08e25463e1fc368f0df771314f451))
* **exe:** add win10 notification package to bundle ([d100d75](https://github.com/ssube/onnx-web/commit/d100d759081be66058e06f8371a62f8f8754859f))
* **exe:** capture omegaconf version info ([963c507](https://github.com/ssube/onnx-web/commit/963c507f8ce7dac0d99f1fc0871ed62e85cc5405))
* **exe:** copy entrypoint script to correct location before bundling ([124014b](https://github.com/ssube/onnx-web/commit/124014b8b5028c02dd4488d818083433e9c75f34))
* **exe:** include launch scripts and readme in bundle build ([c0cebcf](https://github.com/ssube/onnx-web/commit/c0cebcf06dd1a814556f7b18eb85e60ad5c355d9))
* **exe:** include realesrgan and coloredlogs in bundles ([9b05b6b](https://github.com/ssube/onnx-web/commit/9b05b6bf5c4563686ddf25c88c62aadd5200551f))
* **exe:** load extras file from model path again ([26bd8cd](https://github.com/ssube/onnx-web/commit/26bd8cde47ebc2514692cd9167ef1a7ddfe94256))
* **exe:** remove broken venv activation ([ff57a48](https://github.com/ssube/onnx-web/commit/ff57a481ab777edfe624649f5557f7dad291d486))
* **exe:** set default model cache to 0 for Windows bundle ([e89f2fc](https://github.com/ssube/onnx-web/commit/e89f2fc4d005f566bd2088b9571c441632b3efad))
* **gui:** add missing pipeline labels ([e09b4a4](https://github.com/ssube/onnx-web/commit/e09b4a4094d6acd221f3ec808d37765e6af8d74a))
* **gui:** add strings for highres iterations ([8beb099](https://github.com/ssube/onnx-web/commit/8beb0996d47c1d15a5eedcf5422b10e79dcd6dd9))
* **gui:** add strings for save menu ([b4db21e](https://github.com/ssube/onnx-web/commit/b4db21eebdc312e0fb34eeda3dbde7a2236f9209))
* **gui:** add strings for SwinIR real large models ([d95d342](https://github.com/ssube/onnx-web/commit/d95d342d5a9e5d146f3184bb8c43e93db15dee76))
* **gui:** attempt to decode unicode EXIF tags ([27a21df](https://github.com/ssube/onnx-web/commit/27a21dfa625c29edf865ff4db5e31419bee733a0))
* **gui:** close save menu after selecting an option ([b8aef2c](https://github.com/ssube/onnx-web/commit/b8aef2cd3213170a992b775410c77f2fd54bff61))
* **gui:** correct label for diffusion models in image card ([5eb2128](https://github.com/ssube/onnx-web/commit/5eb2128c8510c40f590bfd9893158f0c658182b7))
* **gui:** draw source to canvas immediately on change ([#372](https://github.com/ssube/onnx-web/issues/372)) ([59075a7](https://github.com/ssube/onnx-web/commit/59075a752afb9c3164fb262f205a20e9739768f3))
* **gui:** handle partial extras file without totally crashing ([52b7521](https://github.com/ssube/onnx-web/commit/52b7521d77df43f179d204df20690002a955ffd0))
* **gui:** improve render performance ([64ea060](https://github.com/ssube/onnx-web/commit/64ea060ec9c62423db1588e3f39dc946deed2d99))
* **gui:** limit stride to lesser of tiles and server values ([3c1e154](https://github.com/ssube/onnx-web/commit/3c1e1542a5deff12f878febd5f861b2057e2146a))
* **gui:** localize pipeline and controlnet menus ([953e772](https://github.com/ssube/onnx-web/commit/953e772a504b0a21dc43a5ec33253319c39a3ce7))
* **gui:** make sure models have correct prefix ([4ba1768](https://github.com/ssube/onnx-web/commit/4ba1768198d52a009a3c2eb4868f1f1cc264fdf7))
* **gui:** replace divider below tabs, outline restart button ([b85a8aa](https://github.com/ssube/onnx-web/commit/b85a8aa868f38cd98df947ba6349ba15e7fb6e44))
* **gui:** send UNet stride to backend as integer ([a3ec880](https://github.com/ssube/onnx-web/commit/a3ec88007ff8fd9f31cdf7f31728811975120ee1))
* increase max image sizes ([5d5bfdb](https://github.com/ssube/onnx-web/commit/5d5bfdbbcc26489e623f8fb673f7fd08667a8edb))
* limit UNet stride to tile size ([e68e405](https://github.com/ssube/onnx-web/commit/e68e405633c102e2b50ee1b121ae481a2e34e9e8))
* **scripts:** add more release tests ([cbc4166](https://github.com/ssube/onnx-web/commit/cbc4166f1086b9c47e61a12f41222ee8a4a90463))
* **scripts:** add test ref for img2img panorama ([44ad515](https://github.com/ssube/onnx-web/commit/44ad5150b23d9ec132edf695e59f4732fd2689d4))
* **scripts:** correct model paths in test scripts ([e12f3c2](https://github.com/ssube/onnx-web/commit/e12f3c2801122ac383d2a12b15b086e5a14e74fd))
* **scripts:** do not use source filter for img2img tests ([e283b27](https://github.com/ssube/onnx-web/commit/e283b2770a7d77df7e509a60430f431987eb45f8))
* **scripts:** only mark release tests as failed after retrying ([c399430](https://github.com/ssube/onnx-web/commit/c399430274629a6ccf1404b61507a5cee9d42514))
* **scripts:** restore MSE calculation, update some test refs ([55614cd](https://github.com/ssube/onnx-web/commit/55614cd9a101beb0fe71440416946cb39802ba80))
* **scripts:** show data shape in initializer diff ([b4095cc](https://github.com/ssube/onnx-web/commit/b4095cc2db6d7920bce3e3bd8a543abdb1f280a7))

## [0.9.0](https://github.com/ssube/onnx-web/compare/v0.8.1...v0.9.0) (2023-03-28)


### Features

* **api:** add conversion script for LoRAs from sd-scripts ([#213](https://github.com/ssube/onnx-web/issues/213)) ([4c17edb](https://github.com/ssube/onnx-web/commit/4c17edb2673956833d0c769fdd35879c65a75dde))
* **api:** add error flag to image ready response ([7cf5554](https://github.com/ssube/onnx-web/commit/7cf5554beff501988c0e1c740170d4e57e0c8e5e))
* **api:** add flag for ORT float16 optimizations ([1c631c2](https://github.com/ssube/onnx-web/commit/1c631c28d3571827442b083cbf1d1345b6cc19c7))
* **api:** add optimization for internal fp16 conversion ([afa8f5e](https://github.com/ssube/onnx-web/commit/afa8f5e706ab347f9e4d52738777ad85b0176489))
* **api:** add pending field to image ready response ([8cbdad3](https://github.com/ssube/onnx-web/commit/8cbdad3a712eec6ba484407e1184e4946b8c4664))
* **api:** add section to extras file for additional networks ([e3bf04a](https://github.com/ssube/onnx-web/commit/e3bf04ab8f259485193693feae475729c02c5d35))
* **api:** add server setting for CUDA memory limit ([#211](https://github.com/ssube/onnx-web/issues/211)) ([aec540a](https://github.com/ssube/onnx-web/commit/aec540a524898b78b85dac5603322ae72ec1b3b7))
* **api:** add trace log level ([959798e](https://github.com/ssube/onnx-web/commit/959798eabbd956920a19e241a83f16725b71f7ff))
* **api:** blend LoRAs and Textual Inversions from extras file ([84bd852](https://github.com/ssube/onnx-web/commit/84bd852837df9791fbc75fdc09b3c586070a0501))
* **api:** blend ONNX models in memory ([2a8c85c](https://github.com/ssube/onnx-web/commit/2a8c85cb3e892b3e39868c06046a282def7b5aff))
* **api:** blend Textual Inversions from prompt ([506cf9f](https://github.com/ssube/onnx-web/commit/506cf9f65f8cbb5224ebd72377ec0004a9448585))
* **api:** build a single token for multi-layer Textual Inversions ([#212](https://github.com/ssube/onnx-web/issues/212)) ([5dd14c1](https://github.com/ssube/onnx-web/commit/5dd14c19ce02ec9092cd3daea0dd97d8ec246c07))
* **api:** check device worker pool and recycle on a regular interval ([#284](https://github.com/ssube/onnx-web/issues/284)) ([e552a55](https://github.com/ssube/onnx-web/commit/e552a5560f606857792c93e5d54c86473e883cdb))
* **api:** detect Textual Inversion type from keys ([#262](https://github.com/ssube/onnx-web/issues/262)) ([0732058](https://github.com/ssube/onnx-web/commit/0732058aa89faeedac192e23989006319336d9d6))
* **api:** load i18n labels from additional networks ([f8f36e6](https://github.com/ssube/onnx-web/commit/f8f36e602c6182b7d66f51b4eb0a3dda9ac9fdf5))
* **api:** load Textual Inversions from prompt ([a2e21f4](https://github.com/ssube/onnx-web/commit/a2e21f427f70f010a7fff40b7db4b724eda66df8))
* **api:** parse LoRA names from prompt ([143904f](https://github.com/ssube/onnx-web/commit/143904fc519c4f3aeeb1336fce1b2fca3d4d42e8))
* **api:** parse LoRA weights from prompt ([a7f77a0](https://github.com/ssube/onnx-web/commit/a7f77a033dce5c763093de46f7b28acbcc499a17))
* **api:** pin pytorch versions and update nightly ORT ([dca8a97](https://github.com/ssube/onnx-web/commit/dca8a97796c0b127186ded982aabf18a398b4d45))
* **api:** split up status endpoint by job status ([ccf8d51](https://github.com/ssube/onnx-web/commit/ccf8d51e08a64b23eb1dfd6b268eae31a40cc5c8))
* **gui:** add error status to image card ([6226778](https://github.com/ssube/onnx-web/commit/6226778cfbfa340eabaf64d84a24a9c60a43fe86))
* **gui:** add menus to add LoRA and Textual Inversion tokens ([b195b59](https://github.com/ssube/onnx-web/commit/b195b59301d37452ceb2d3bdc51588b7d0d1509e))
* **gui:** add retry function to error card ([8979064](https://github.com/ssube/onnx-web/commit/89790645cbaf74b7cad2d7e7fd693665db13caa4))
* **scripts:** add env debug script ([#191](https://github.com/ssube/onnx-web/issues/191)) ([84718e5](https://github.com/ssube/onnx-web/commit/84718e5928919bef73b02166d6330e79515dd1da))
* **scripts:** add model type guessing script ([#210](https://github.com/ssube/onnx-web/issues/210)) ([17e4fd7](https://github.com/ssube/onnx-web/commit/17e4fd7b061cfdd853a9e873310be41902666587))
* show additional networks in client ([2d11210](https://github.com/ssube/onnx-web/commit/2d112104fb5df1d260fc00948f2a2f8ea3d7aace))


### Bug Fixes

* **api:** add base token for Textual Inversion as sum layer ([19d4d55](https://github.com/ssube/onnx-web/commit/19d4d554c3f382ee1cee7c104d24c6f7f67d8dc3))
* **api:** add HF hub download to fetch logic for Inversion concepts ([ae3bcf3](https://github.com/ssube/onnx-web/commit/ae3bcf3b8ba7de8f58c367bf7dda19f972409fb0))
* **api:** add theoretical support for 3x3 conv in LoRA ([315e5a3](https://github.com/ssube/onnx-web/commit/315e5a383771b5875dbaec623520d980d1b6904d))
* **api:** allow dash in network names ([645da3d](https://github.com/ssube/onnx-web/commit/645da3d1a676f08cf043e91338a217a3fc7319a1))
* **api:** always reset job counter when creating new device worker ([2b179be](https://github.com/ssube/onnx-web/commit/2b179bebacac99bbcc4ec270d408a2e6447fa948))
* **api:** apply fp16 optimizations to LoRA and Textual Inversion blending ([0315a8c](https://github.com/ssube/onnx-web/commit/0315a8cbc623e22b5b88a09fc0bc88d18d24d399))
* **api:** assume inversion tokens are embeddings for now ([e5862d1](https://github.com/ssube/onnx-web/commit/e5862d178cdeafa15d108adea162a668fdea0693))
* **api:** attempt to read progress updates from recycled workers ([2d2283e](https://github.com/ssube/onnx-web/commit/2d2283e1ebb7381876b5d0a35ef2a9bb78865c3e))
* **api:** avoid loading encoder twice when using LoRAs and inversions together ([af326a7](https://github.com/ssube/onnx-web/commit/af326a784f657aa333dfd12426b50acac1ff024b))
* **api:** better error handling around tensor loading ([8acc15f](https://github.com/ssube/onnx-web/commit/8acc15f52e0aecb909bcfbe3c1929835131c95ef))
* **api:** bump default model cache to 5 ([#242](https://github.com/ssube/onnx-web/issues/242)) ([a9456f4](https://github.com/ssube/onnx-web/commit/a9456f4a16fefeb59ff5ad447960607b2bfbfb52))
* **api:** clear job cancelled flag when worker starts a new job ([#269](https://github.com/ssube/onnx-web/issues/269)) ([aefa5b4](https://github.com/ssube/onnx-web/commit/aefa5b4613c043811a00488bf731671dd2347609))
* **api:** close queues after stopping workers ([e1219cc](https://github.com/ssube/onnx-web/commit/e1219cca907ebab5057f0e0f944cfd4c9c3c1283))
* **api:** combine names for ONNX fp16 optimization ([c2f8fb1](https://github.com/ssube/onnx-web/commit/c2f8fb1d3128a0ff9b0acf67943985afd3a0a562))
* **api:** convert back to model format after blending, convert samples as needed ([#274](https://github.com/ssube/onnx-web/issues/274)) ([c8aad85](https://github.com/ssube/onnx-web/commit/c8aad8554ed39a564b94c72a163e374b5a496e3c))
* **api:** correctly load server env for conversion ([b8f8163](https://github.com/ssube/onnx-web/commit/b8f816323e64ed7d23baff6f7e1196c9d636f12f))
* **api:** disable internal fp16 for VAE encoder ([#290](https://github.com/ssube/onnx-web/issues/290)) ([73e9cf8](https://github.com/ssube/onnx-web/commit/73e9cf8b66e6e0f11bbab1a484e12c3e4d12dcaa))
* **api:** do not assume file extension for additional networks ([b797b3d](https://github.com/ssube/onnx-web/commit/b797b3d61636024116eadbf5900e12f19dd8af7f))
* **api:** do not move jobs from pending to running until progress is reported ([27500ec](https://github.com/ssube/onnx-web/commit/27500eccb570d78004f97062ddb4404f2c0a8016))
* **api:** download additional networks to their own subdir in models ([32b2a76](https://github.com/ssube/onnx-web/commit/32b2a76a0b64bc91810a69df991d311226e1e93e))
* **api:** embed Inversion concepts using their name ([fe498b1](https://github.com/ssube/onnx-web/commit/fe498b16f0a31033aa1a6d559564683e885e0163))
* **api:** enqueue next job when previous one finishes and after recycling worker ([14ade83](https://github.com/ssube/onnx-web/commit/14ade839377d64a874f1bc9d6ba29e0bb00a8d33))
* **api:** fetch sources and additional networks by default ([0e43acc](https://github.com/ssube/onnx-web/commit/0e43acc0f7747980e4bf8b820708a48032e789be))
* **api:** filter out temporary files from model lists ([#271](https://github.com/ssube/onnx-web/issues/271)) ([1971226](https://github.com/ssube/onnx-web/commit/19712262e6e8c8d0f42ca2e95040baf80cd520f9))
* **api:** handle CUDA memory errors in workers ([b2eb406](https://github.com/ssube/onnx-web/commit/b2eb406197d208c135d51a2347a5b073ec3490f7))
* **api:** handle more out-of-memory errors in the workers ([c8c5e9f](https://github.com/ssube/onnx-web/commit/c8c5e9f42e5b885be215c3576e9703b7cc81ee5a))
* **api:** include worker totals in status endpoint ([36bfcca](https://github.com/ssube/onnx-web/commit/36bfccae09e29383c6c9b23f4edd0217f7eb6e15))
* **api:** increment job counter for worker when it starts a new job ([#283](https://github.com/ssube/onnx-web/issues/283)) ([55e44e8](https://github.com/ssube/onnx-web/commit/55e44e8ac9842e5c514ab07811130bdd8cf58ed6))
* **api:** load blending tensors onto CPU ([3300853](https://github.com/ssube/onnx-web/commit/33008531e976e6aa61750609d0e46efefc555ff4))
* **api:** maintain list of pending jobs ([15b6e03](https://github.com/ssube/onnx-web/commit/15b6e036e1a71a31067cccb27421d1eb5a9f81fa))
* **api:** make format list in schema match code ([580d621](https://github.com/ssube/onnx-web/commit/580d621209ed72c726b62ab71480fb23bd31d7d1))
* **api:** move imports of patches modules into function ([c943a55](https://github.com/ssube/onnx-web/commit/c943a55a44c2630d8ec7fb6924d54ec35e38e8cb))
* **api:** move model conversion messages to trace level ([9f0a6f1](https://github.com/ssube/onnx-web/commit/9f0a6f134e97354468c030cf4dcd76371dc4f1cd))
* **api:** move prompt parsing logs to trace level ([ed8a7c8](https://github.com/ssube/onnx-web/commit/ed8a7c893411ae8458465979b3ed48f4968abf74))
* **api:** only remove running jobs from running state ([2e89fd4](https://github.com/ssube/onnx-web/commit/2e89fd43d3223177bc9a157a9b9a8fa1a06c5638))
* **api:** provide noise parameter to SD upscaling ([#196](https://github.com/ssube/onnx-web/issues/196)) ([f336cc5](https://github.com/ssube/onnx-web/commit/f336cc5d024ba61d041cf59c009c36b5e0f0397d))
* **api:** remove prefix before downloading for HF hub ([f779fbd](https://github.com/ssube/onnx-web/commit/f779fbd5cc74e6abab3dcee00090454238395d4c))
* **api:** restart worker threads if they crash ([4dd68ea](https://github.com/ssube/onnx-web/commit/4dd68ea6b64113431910d157e7b735908fab57a7))
* **api:** restart worker threads when their respective queues are full ([95a61f3](https://github.com/ssube/onnx-web/commit/95a61f3573ff621262daea890c476044bc679c1c))
* **api:** restore python 3.8 compatibility ([1d44f98](https://github.com/ssube/onnx-web/commit/1d44f985a48165ae485ae5d250bc7f96945b0405))
* **api:** restrict CLIP skip token to integers, allow negative LoRA and Inversion weights ([27bd10d](https://github.com/ssube/onnx-web/commit/27bd10d2f7e29a6c4cc6eeb161afe386ab1cf198))
* **api:** track last progress within worker ([588c8c7](https://github.com/ssube/onnx-web/commit/588c8c7fdb4007f8d83ece40ebdac06f94089298))
* **api:** update LPW pipeline ([#298](https://github.com/ssube/onnx-web/issues/298)) ([93fcfd1](https://github.com/ssube/onnx-web/commit/93fcfd142284e1f5c96381714ac03abc780d076c))
* **api:** use exception level logs ([226710a](https://github.com/ssube/onnx-web/commit/226710a015014cf6ed3ba8b93904a85e29284a98))
* **api:** use lock when restarting workers ([88f4713](https://github.com/ssube/onnx-web/commit/88f4713e235ef80c132e3fcc72399d8c1ba31752))
* **api:** use ORT session for correct device when loading blended nets ([9f9b73b](https://github.com/ssube/onnx-web/commit/9f9b73b780d926dff240741ee3ef90c72d4b10a7))
* **api:** use Torch JIT and fallback loading ([0762269](https://github.com/ssube/onnx-web/commit/07622690dc01f632489eba806fa2dda48232ac5a))
* **api:** watch for progress events from leaking workers ([4ddd69b](https://github.com/ssube/onnx-web/commit/4ddd69ba07ce73c8829787f358fddf6ea6065000))
* **build:** allow long-running jobs to be interrupted ([641456f](https://github.com/ssube/onnx-web/commit/641456fd42e8ff132e1d8926ea2efe0d4f482346))
* **build:** install wheel for basicsr ([d9bae80](https://github.com/ssube/onnx-web/commit/d9bae80778bc5b2b4ff74c11d65ab97d363a4290))
* **build:** make sure Torch is installed first in containers ([4de8c16](https://github.com/ssube/onnx-web/commit/4de8c160c92149a4c4f5c021896082eb3b3119f0))
* **build:** pin Torch to 1.x for now ([a21750f](https://github.com/ssube/onnx-web/commit/a21750ff8eabbf2b756e7c0a52301a4618c8adf3))
* **buil:** limit torchvision versions to match torch ([fc9245f](https://github.com/ssube/onnx-web/commit/fc9245f4ee01de070dc4811ca7b3728ad749867c))
* **deps:** update dependency i18next to v22.4.13 ([35ebb2a](https://github.com/ssube/onnx-web/commit/35ebb2af7b33c4835e53538fd8b4092ac7ab429f))
* **deps:** update dependency react-query to v3.39.3 ([92cb6ac](https://github.com/ssube/onnx-web/commit/92cb6acdf9d968ec53f7f479b395e2e2d1af9501))
* **docs:** add check scripts to user guide ([fca9ba8](https://github.com/ssube/onnx-web/commit/fca9ba893caba50d2e0433525fcfce88651b4183))
* **docs:** add more runtimes to memory usage table ([c0ece24](https://github.com/ssube/onnx-web/commit/c0ece2453d98b9604cd6f2e708d13b57c6ca9cfb))
* **docs:** describe LoRA and Textual Inversion tokens in user guide ([74dc0e9](https://github.com/ssube/onnx-web/commit/74dc0e9484d36aac1a914a4bbf61c9e91008da36))
* **docs:** explain CLIP skip, describe tokens better ([b99c8c8](https://github.com/ssube/onnx-web/commit/b99c8c8bae944f8c35e5e8232402eb4bd659d56e))
* **docs:** explain extras file format in user guide ([a1c3b28](https://github.com/ssube/onnx-web/commit/a1c3b28bee5c7d118677073ca269fa520e18dd9f))
* **docs:** explain how to optimize models ([31e841a](https://github.com/ssube/onnx-web/commit/31e841ab4a3930b1623d12823491613289da682a))
* **gui:** add progress bar to menus while loading ([#216](https://github.com/ssube/onnx-web/issues/216)) ([0ab52f0](https://github.com/ssube/onnx-web/commit/0ab52f0c24bd2577b66ef3303f7d6c3004e0c0af))
* **gui:** add prompt tokens to correct tab ([#296](https://github.com/ssube/onnx-web/issues/296)) ([d19bbfc](https://github.com/ssube/onnx-web/commit/d19bbfc1d39c40915b56adc1bfe1ec62d975eb47))
* **gui:** only enable blend tab's generate button with two source images ([#235](https://github.com/ssube/onnx-web/issues/235)) ([3f9789a](https://github.com/ssube/onnx-web/commit/3f9789a0a8621f7381b09e709480022856bfa8aa))
* **gui:** remove images from history beyond limit ([#267](https://github.com/ssube/onnx-web/issues/267)) ([ba07671](https://github.com/ssube/onnx-web/commit/ba0767179cdb1b64b95927a12e4d8e01383c4b5c))
* **gui:** remove prompt length error condition ([#268](https://github.com/ssube/onnx-web/issues/268)) ([382316f](https://github.com/ssube/onnx-web/commit/382316f0c9cc21a660718faf757f47822c7240bc))
* **gui:** split base models and additional options ([7553040](https://github.com/ssube/onnx-web/commit/755304059515f34c21cb1752ed7b09a57d9024ff))
* **scripts:** check for ORT modules ([c465b61](https://github.com/ssube/onnx-web/commit/c465b61fb5af0e7c1d710fd37a3946f0abdb9b52))
* **scripts:** check Torch CUDA devices ([#242](https://github.com/ssube/onnx-web/issues/242)) ([391a707](https://github.com/ssube/onnx-web/commit/391a707c846109fd05ab03f302400e99bd8931d7))
* **scripts:** diff model nodes as well ([8cf6f22](https://github.com/ssube/onnx-web/commit/8cf6f2215d9ee854371e6eca571bd6b747acc973))
* **tests:** add reference image for UniPC scheduler ([cf429ad](https://github.com/ssube/onnx-web/commit/cf429ad715252a8ed573a9a78a3b3240d6cf40e7))
* **tests:** make release tests fail if image was not successful ([#287](https://github.com/ssube/onnx-web/issues/287)) ([d7e5480](https://github.com/ssube/onnx-web/commit/d7e548037af81db5d157b367a977b09f661ea108))

### [0.8.1](https://github.com/ssube/onnx-web/compare/v0.8.0...v0.8.1) (2023-03-11)


### Bug Fixes

* **api:** make cache global within each worker process ([#227](https://github.com/ssube/onnx-web/issues/227)) ([575cb88](https://github.com/ssube/onnx-web/commit/575cb8831b0038b43df36751cd0a94c4ee6a9d3b))
* **api:** only run GC when a diffusion model has been replaced ([cb2b054](https://github.com/ssube/onnx-web/commit/cb2b054fde9e20be5aa6b15fa4f9887434efcfb0))
* **api:** remove unused num_workers logic from server ([01d3519](https://github.com/ssube/onnx-web/commit/01d3519aa3f475183311ab4ae72e8cc4eb03d2ed))
* **docs:** remove reference to removed num_workers server variable ([db61697](https://github.com/ssube/onnx-web/commit/db6169705ba2656f131ca56e4e6d99f5965a9a74))
* **tests:** clear cache between tests ([919f88c](https://github.com/ssube/onnx-web/commit/919f88c7d06bd6a1695c2f01df93c9c3ccbb4caa))

## [0.8.0](https://github.com/ssube/onnx-web/compare/v0.7.1...v0.8.0) (2023-03-11)


### Features

* add a way to select textual inversions ([2e7de16](https://github.com/ssube/onnx-web/commit/2e7de16778c8805319b7f3cc6cba7ef7e7432bc7))
* add eta parameter (fixes [#194](https://github.com/ssube/onnx-web/issues/194)) ([c1189aa](https://github.com/ssube/onnx-web/commit/c1189aad965766fe8d89f1f87046976b7ff1ee3f))
* add parameter to run correction before upscaling ([#132](https://github.com/ssube/onnx-web/issues/132)) ([ecf3c03](https://github.com/ssube/onnx-web/commit/ecf3c03f0f8433a554dc395bda01217ee8349516))
* add support for UniPC multistep scheduler ([#226](https://github.com/ssube/onnx-web/issues/226)) ([fe437e8](https://github.com/ssube/onnx-web/commit/fe437e8cd40f166a17e1dc19f60aa47ffc0ccf49))
* allow users to add their own labels for models ([#144](https://github.com/ssube/onnx-web/issues/144)) ([5d459ab](https://github.com/ssube/onnx-web/commit/5d459ab17c6f6ede6e563e11d4294591c426d90c))
* **api:** add a way to pass extra args to the conversion script ([35303c7](https://github.com/ssube/onnx-web/commit/35303c7d20114eb0a2d70f3fbb54b1e6576d5d3d))
* **api:** add an option to remove temporary Torch files after converting to ONNX ([#122](https://github.com/ssube/onnx-web/issues/122)) ([25c41c8](https://github.com/ssube/onnx-web/commit/25c41c8d6677bbf008c1c9b109f234f352e26a80))
* **api:** add batch size to txt2img and img2img pipelines ([#195](https://github.com/ssube/onnx-web/issues/195)) ([5f3b848](https://github.com/ssube/onnx-web/commit/5f3b84827b3e1db0585f0ef5dd11ad8cbfcbc4b2))
* **api:** add flag to disable progress bars ([#158](https://github.com/ssube/onnx-web/issues/158)) ([b4e66ef](https://github.com/ssube/onnx-web/commit/b4e66ef502a965a0c4e67f5c66fab7021d000c48))
* **api:** add option for custom VAE to extras file ([#145](https://github.com/ssube/onnx-web/issues/145)) ([2c66cc5](https://github.com/ssube/onnx-web/commit/2c66cc58c5ab2e2add9e150ba3798d6537bf550d))
* **api:** add range syntax to expand numbered tokens ([#179](https://github.com/ssube/onnx-web/issues/179)) ([0a4f83a](https://github.com/ssube/onnx-web/commit/0a4f83ac0f1ceca57b824593f57348affb5abcad))
* **api:** add requirements file for each platform ([#193](https://github.com/ssube/onnx-web/issues/193)) ([31054c4](https://github.com/ssube/onnx-web/commit/31054c4ee3874e17f612be4cb32856515bd024c7))
* **api:** add support for custom tokens for textual inversions ([#179](https://github.com/ssube/onnx-web/issues/179)) ([39d3661](https://github.com/ssube/onnx-web/commit/39d36618e6378b91b4d44dd00c6959c796b3a5c2))
* **api:** add support for extremely long prompts ([66c4248](https://github.com/ssube/onnx-web/commit/66c42485cb96a8f1db9ddab2b4076e915c12d89e))
* **api:** add txt2txt endpoint ([44393e3](https://github.com/ssube/onnx-web/commit/44393e37706494dbc82dd54a16a9575986efa705))
* **api:** collect labels from textual inversions ([#144](https://github.com/ssube/onnx-web/issues/144)) ([00fa9c5](https://github.com/ssube/onnx-web/commit/00fa9c58076f2338f625bed2e7bccb0951dc4bd1))
* **api:** convert Textual Inversion weights ([a31f7b9](https://github.com/ssube/onnx-web/commit/a31f7b9e1f10dfcb9b3f1fec8adace07622de664))
* **api:** enable ONNX optimizations through env ([5b4c370](https://github.com/ssube/onnx-web/commit/5b4c370a1b6b3e809be34c14ab43978918973b23))
* **api:** enable optimizations for SD pipelines based on env vars ([#155](https://github.com/ssube/onnx-web/issues/155)) ([ab6462d](https://github.com/ssube/onnx-web/commit/ab6462d095fe2305fd5a8e6ab9ac794662880a99))
* **api:** initial support for textual inversion embeddings from civitai and others ([#179](https://github.com/ssube/onnx-web/issues/179)) ([46aac26](https://github.com/ssube/onnx-web/commit/46aac263d5194e52e5e744767cc9c1a3f3222d88))
* **api:** log CUDA memory stats ([#141](https://github.com/ssube/onnx-web/issues/141)) ([005650a](https://github.com/ssube/onnx-web/commit/005650a9a228093e44f22fc9868d8804c810b173))
* **api:** look for an index file when checking for converted models ([#222](https://github.com/ssube/onnx-web/issues/222)) ([843e2f1](https://github.com/ssube/onnx-web/commit/843e2f1ff32d7e2037f2192131d1135bf0f56a5f))
* **api:** prefer chain stage parameters over request parameters ([#138](https://github.com/ssube/onnx-web/issues/138)) ([7b8ced0](https://github.com/ssube/onnx-web/commit/7b8ced0f686f79cd13c05b6ec62f85c252391d3a))
* **api:** remove Flask app from global scope ([06c74a7](https://github.com/ssube/onnx-web/commit/06c74a7a96b73facd19a7ed575252679748eac41))
* **api:** support ckpt inversions by splitting multivector embeddings into multiple tokens ([be1c8cd](https://github.com/ssube/onnx-web/commit/be1c8cd79f0075d4b1d2d45c0db5eaf07f587fc5))
* **api:** support custom VAE for diffusers models ([d42de16](https://github.com/ssube/onnx-web/commit/d42de16a844a1abdb87c8e52473a61708232cd17))
* **api:** use ONNX for Real ESRGAN v3 model ([2c9d96d](https://github.com/ssube/onnx-web/commit/2c9d96d2eec8f4f042d76d1d7db281a44c0d5e15))
* **build:** add livereloading to esbuild ([b1544a3](https://github.com/ssube/onnx-web/commit/b1544a32e592cd1e75e458c77d0ae63ceff67447))
* **build:** make GUI dev server use port 8000 everywhere ([763bdcf](https://github.com/ssube/onnx-web/commit/763bdcf0acd12d5431ae2951ba1a4e248a29ed24))
* **docs:** add conversion guide ([b952c88](https://github.com/ssube/onnx-web/commit/b952c8835f2be2dbd2d830c2c3535d18032b6424))
* **gui:** add i18next and start localization ([5bfaddd](https://github.com/ssube/onnx-web/commit/5bfaddd388f0e153f691740b1d913b3cb1665872))
* **gui:** add loading spinner while fetching server params ([aed5e1b](https://github.com/ssube/onnx-web/commit/aed5e1bf12e4b8896aa3569646a32aaafc9fcade))
* **gui:** add local params and API stub so client can load without a server ([#181](https://github.com/ssube/onnx-web/issues/181)) ([d5a3b0f](https://github.com/ssube/onnx-web/commit/d5a3b0fed85e02639a4e079eeb11feee0a0ed3ca))
* **gui:** add prompt to upscale tab (fixes [#187](https://github.com/ssube/onnx-web/issues/187)) ([34832f0](https://github.com/ssube/onnx-web/commit/34832f0171d5d13446eaec1067dceff7a7a5b1d5))
* **gui:** add warning when model does not support inpainting ([#54](https://github.com/ssube/onnx-web/issues/54)) ([643f7bb](https://github.com/ssube/onnx-web/commit/643f7bbd01019df52d4942fde4e3ea4155e6cf74))
* **gui:** display multiple images on card ([061718b](https://github.com/ssube/onnx-web/commit/061718b4777371383001dcdc0982f186282c924d))
* **gui:** export/import client state from settings tab ([#161](https://github.com/ssube/onnx-web/issues/161)) ([4d62404](https://github.com/ssube/onnx-web/commit/4d62404970f578b68b61d533c15ff08567afde90))
* **gui:** translate most of the client ([3760093](https://github.com/ssube/onnx-web/commit/3760093617dd3747a4ccfb5c1b578b8422aec385))
* **test:** add release regression testing script ([9a7770f](https://github.com/ssube/onnx-web/commit/9a7770fe4811f0f5eea67c7d4ed16313d7938b04))


### Bug Fixes

* **api:** add error handling for optimizations ([118695d](https://github.com/ssube/onnx-web/commit/118695d68cd7cc37df1de66ffe66c0f83dc6c819))
* **api:** add missing params to SD upscale ([0deaa88](https://github.com/ssube/onnx-web/commit/0deaa8898de603dac8288d28704e0a27897bd903))
* **api:** add sources section to extras schema ([9e47979](https://github.com/ssube/onnx-web/commit/9e479795fa0a385ceeb7a9b3790000728f60b5c7))
* **api:** add worker PID to log messages ([cb460a0](https://github.com/ssube/onnx-web/commit/cb460a0c59d50915bbe3405c6ec94b236fef1bc4))
* **api:** attempt to recycle leaking workers when a job finishes ([4ae4ce1](https://github.com/ssube/onnx-web/commit/4ae4ce176ca6cb4528c7ee22f53dd1b617efa581))
* **api:** attempt to validate extra translation strings ([b198b3b](https://github.com/ssube/onnx-web/commit/b198b3baff582f0a404f8887827ed5eb1c213e4f))
* **api:** better logging when converting textual inversions ([9a0d205](https://github.com/ssube/onnx-web/commit/9a0d2051fb9473ed37f279bf49b18724db3a14f1))
* **api:** check for cache rather than converted model before fetch ([c0b8873](https://github.com/ssube/onnx-web/commit/c0b88733b8115d7e2921878b30e9da15dfced3ad))
* **api:** continue converting other models after an error in one ([#166](https://github.com/ssube/onnx-web/issues/166)) ([c74d22a](https://github.com/ssube/onnx-web/commit/c74d22aa4208d7dc5541e820f9b12b2f3eeec137))
* **api:** convert Real ESRGAN v3 using same arch as runtime ([338fc23](https://github.com/ssube/onnx-web/commit/338fc237c7c7c8043881472fc593930f8cb83166))
* **api:** correct blending mask (fixes [#188](https://github.com/ssube/onnx-web/issues/188)) ([f561dfa](https://github.com/ssube/onnx-web/commit/f561dfae832dfb0c6f0e6e81bfa7dd16ceac3afd))
* **api:** correct continuation syntax for Windows launch scripts ([6c47542](https://github.com/ssube/onnx-web/commit/6c47542d46c69f245a22182619155728c11d5d39))
* **api:** correct conversion imports ([628812f](https://github.com/ssube/onnx-web/commit/628812fb0b7b068c15adcc74e2f0765e3ba14c31))
* **api:** correct device for VRAM check ([cf8ca34](https://github.com/ssube/onnx-web/commit/cf8ca348458483fdf4562d55c589a32d1af28be8))
* **api:** correct imports ([10fbafa](https://github.com/ssube/onnx-web/commit/10fbafaff07cccbfbe21ed21ca529b8d196ac08a))
* **api:** correct VAE config check ([555de5e](https://github.com/ssube/onnx-web/commit/555de5e07d490980929ef3b5c5657363de2952dc))
* **api:** correctly handle missing inversion param ([3626d69](https://github.com/ssube/onnx-web/commit/3626d69f40d9ae78d0c2fb2da8834368ca20ef8d))
* **api:** create conversion context from environment vars ([15060e6](https://github.com/ssube/onnx-web/commit/15060e6c7d456061522181e71f710f8c3ce40420))
* **api:** disable HF hub progress ([8dd55cc](https://github.com/ssube/onnx-web/commit/8dd55cc5567842cd95ebbb935fcaaaa1affd108c))
* **api:** disable progress in diffusers pipelines ([b2de114](https://github.com/ssube/onnx-web/commit/b2de114c8c71679959ff7c9a93a69c1d17f34f2b))
* **api:** enable optimizations during model conversion ([fd013c8](https://github.com/ssube/onnx-web/commit/fd013c88ef6f00ccd65d345c4da181a50c9a1aea))
* **api:** exit worker on memory allocation errors ([57fed94](https://github.com/ssube/onnx-web/commit/57fed943377bf17506863fafc17e8662e770b53b))
* **api:** fallback to PyTorch if tensors fail to load with JIT ([b3c8fce](https://github.com/ssube/onnx-web/commit/b3c8fce16b73ee2d3da75c5a190fd33ff600e676))
* **api:** finished job notification should not block worker ([edc55ae](https://github.com/ssube/onnx-web/commit/edc55ae8b49d11e20f4fd69a05ab22de5f6f74e4))
* **api:** improve cache logging ([cfc20d3](https://github.com/ssube/onnx-web/commit/cfc20d3133b63803da660df2056c12936defa0c3))
* **api:** include bottom margin when calculating output size ([da3d95f](https://github.com/ssube/onnx-web/commit/da3d95ff491fa2158e11f8f4f8116571b7641f5c))
* **api:** include cache keys in logs ([55576ae](https://github.com/ssube/onnx-web/commit/55576ae87cd6e9f59e790f6884d3772ad7dee8b6))
* **api:** load LPW pipeline from local source ([#224](https://github.com/ssube/onnx-web/issues/224)) ([6e71775](https://github.com/ssube/onnx-web/commit/6e717757827df051dd753a357ba4b910a61b8448))
* **api:** load tokenizer with textual inversions ([4b77a00](https://github.com/ssube/onnx-web/commit/4b77a00ca7a0ed8a563e13eb6b0dba454198c1c1))
* **api:** log correct token when converting Textual Inversions ([30b08c6](https://github.com/ssube/onnx-web/commit/30b08c6d6d3af2e2171702347649e67a65baf28e))
* **api:** log number of active threads when running GC ([#170](https://github.com/ssube/onnx-web/issues/170)) ([d09446c](https://github.com/ssube/onnx-web/commit/d09446ca68ec696cb96d0f37bf0220b7914e9350))
* **api:** make size params iterable ([3ca02d4](https://github.com/ssube/onnx-web/commit/3ca02d48755a7153f9aa0645b987b9d35189ea47))
* **api:** make stage-specific source image optional in GFPGAN stage ([#233](https://github.com/ssube/onnx-web/issues/233)) ([6bdaa4a](https://github.com/ssube/onnx-web/commit/6bdaa4a4edd734b58e1f463a5397aa2fe4a8006e))
* **api:** mark all convert methods as no_grad ([21fc7c5](https://github.com/ssube/onnx-web/commit/21fc7c5968fbcf2f07d889823f0f45d75f7b8138))
* **api:** match format in schema for sd-concepts ([6542646](https://github.com/ssube/onnx-web/commit/654264600545e1de252e983644356a0863be1773))
* **api:** move prompt splitting logging to debug level ([21c6070](https://github.com/ssube/onnx-web/commit/21c60709bce0c530138c429f91d5c9ed9e9dad80))
* **api:** only convert VAE once when coming from checkpoints ([7a1f831](https://github.com/ssube/onnx-web/commit/7a1f8318efc5b90e4d9d4d873470419324386f4c))
* **api:** only remove converted VAE if it exists ([56a8262](https://github.com/ssube/onnx-web/commit/56a826228d93f6919c67806437f870e6010dec6a))
* **api:** only run CUDA GC on CUDA devices ([e03b637](https://github.com/ssube/onnx-web/commit/e03b637f543dabd823dfb5f516aacc2857629fee))
* **api:** only run GC is devices are passed ([30978e3](https://github.com/ssube/onnx-web/commit/30978e3e5bce42d6e52d3d0853aa31ce7688bbcd))
* **api:** patch VAE for SD upscaling on older versions of diffusers ([#234](https://github.com/ssube/onnx-web/issues/234)) ([e960ee1](https://github.com/ssube/onnx-web/commit/e960ee1d8510b2378292ab80d6851bb2dc541e25))
* **api:** prevent workers from blocking on their progress queues ([3a4928e](https://github.com/ssube/onnx-web/commit/3a4928e59b72d8be126ed15ea765f31a180eef69))
* **api:** report accurate size when face correction is run twice ([c459e96](https://github.com/ssube/onnx-web/commit/c459e9652381ac0054ded68c774e10e5aeaf4fca))
* **api:** resize images to min dimensions by padding if necessary ([#172](https://github.com/ssube/onnx-web/issues/172)) ([0e108da](https://github.com/ssube/onnx-web/commit/0e108daa0fa99c45432a68d037511d972d5b1fbb))
* **api:** restore separate upscale and correction stages ([f534fbb](https://github.com/ssube/onnx-web/commit/f534fbb92cf7b83c0d3de614fb24de35d99a3041))
* **api:** reuse ORT session params for each device ([b532570](https://github.com/ssube/onnx-web/commit/b532570f54d33ba7cd9facc84513ada11f6d59f5))
* **api:** run shape inference before converting models to fp16 ([dbf9eaf](https://github.com/ssube/onnx-web/commit/dbf9eaf1a4714c6a827e5077e4c7bd0983fdc394))
* **api:** run torch gc alongside python ([#156](https://github.com/ssube/onnx-web/issues/156)) ([0ed4af1](https://github.com/ssube/onnx-web/commit/0ed4af18ad5370097024e26a610a1ed768a83691))
* **api:** sanitize filenames in user input ([12fb7f5](https://github.com/ssube/onnx-web/commit/12fb7f52bb17208f82cf6b3274acb4b90bfdc717))
* **api:** show VRAM percent in logs ([39b9741](https://github.com/ssube/onnx-web/commit/39b9741b24fabf380ec8149418eeb2d562b113e3))
* **api:** support loading VAE from CKPT files ([ca1b22d](https://github.com/ssube/onnx-web/commit/ca1b22d44deacd434a319d8cb7caf779e1bad6c1))
* **api:** track and repeatedly attempt to recycle leaking workers ([#219](https://github.com/ssube/onnx-web/issues/219)) ([7a3a81a](https://github.com/ssube/onnx-web/commit/7a3a81a4ef7119c1d38e11cc789ef4555e98da0e))
* **api:** track completed jobs for each device worker ([#170](https://github.com/ssube/onnx-web/issues/170)) ([1f3a5f6](https://github.com/ssube/onnx-web/commit/1f3a5f6f3c1b399438927b393593d3b33ca4bf4c))
* **api:** track currently active worker for each device ([c0a01ef](https://github.com/ssube/onnx-web/commit/c0a01efef423274a38fcf2dc98c6844d6877e8bf))
* **api:** track items removed from cache ([af1c3c7](https://github.com/ssube/onnx-web/commit/af1c3c7839bb444c59a90f9120c6cba73af88fd3))
* **api:** unwrap state dict from VAE ([37b173d](https://github.com/ssube/onnx-web/commit/37b173d0d1643393c542ec8663182d257dbfe04e))
* **api:** update SD upscaling pipeline ([3d73b9e](https://github.com/ssube/onnx-web/commit/3d73b9e6219e4e9bcce8208d2b9095c1924b630b))
* **api:** use pipeline class name in cache key ([339868d](https://github.com/ssube/onnx-web/commit/339868de4d5a918e7f8eb4bf8825c64e6d59ce2e))
* **api:** use server model path while converting SD checkpoints ([#221](https://github.com/ssube/onnx-web/issues/221)) ([c45915e](https://github.com/ssube/onnx-web/commit/c45915e5587c25e7b2d87cf20b2afa2a16222be5))
* **api:** use stage source when available ([ac1f744](https://github.com/ssube/onnx-web/commit/ac1f7449bb50463b10635a388431d0d1a324a954))
* **api:** write external weights into same directory as optimized model ([74aae1b](https://github.com/ssube/onnx-web/commit/74aae1b027b78b8200d734a919050d0bc6c49973))
* **build:** add make target for watch mode ([3dde3b9](https://github.com/ssube/onnx-web/commit/3dde3b9237ff1d81fea42ce3ecd89d7d8165f708))
* **build:** disable preview rules in black ([f8658c8](https://github.com/ssube/onnx-web/commit/f8658c88cd229b3208560e66fad73c256b9e292a))
* **build:** Explicitly set esbuild serve host/port ([035446e](https://github.com/ssube/onnx-web/commit/035446ecbc4d93efaad318d25f97b5485378e6c8))
* **build:** install cv2 deps ([26f4b7e](https://github.com/ssube/onnx-web/commit/26f4b7e5b9f9fbe1d0dd2279817086027fa8eafa))
* **build:** reset old coverage before running tests ([6e8d51b](https://github.com/ssube/onnx-web/commit/6e8d51b9fad96dd987436e927ef3df22a57d9df2))
* **build:** use platform-specific requirements for containers ([05c628d](https://github.com/ssube/onnx-web/commit/05c628d8a6f79a11d833d637ed944a65141578ed))
* **build:** use separate cache for pip packaging jobs ([8435b18](https://github.com/ssube/onnx-web/commit/8435b18829c33c367441bed2f78387e96ac01eee))
* **docs:** describe blending tab ([a3b4b73](https://github.com/ssube/onnx-web/commit/a3b4b73dba2a0a5c36531c8f18fa40f37f36e2a8))
* **docs:** describe dev watch mode ([3c001a9](https://github.com/ssube/onnx-web/commit/3c001a985fbb0b089151c1582fa2aed625db577a))
* **docs:** describe ONNX_WEB_EXTRA_ARGS and _EXTRA_MODELS in admin guide ([719fbc3](https://github.com/ssube/onnx-web/commit/719fbc35e437bd4724cd0b6c1d79055a7cf41d40))
* **docs:** explain converting Textual Inversions, using layer tokens, and prompt range syntax ([#179](https://github.com/ssube/onnx-web/issues/179)) ([7800581](https://github.com/ssube/onnx-web/commit/78005812f3d7f0e2fd0733adad03d3238d29274b))
* **docs:** note about checking LoRA metadata keys ([7ef63e1](https://github.com/ssube/onnx-web/commit/7ef63e14c497f58e9d96a55a7418ff25f8f6326d))
* **gui:** better spacing around prompt controls ([ad08349](https://github.com/ssube/onnx-web/commit/ad08349fbe476bacd06be368bcd73d653654d1ec))
* **gui:** create logger sooner and use it more ([344d17a](https://github.com/ssube/onnx-web/commit/344d17a7b14ae9f8b0ce0ed8c1f28f5655e77a48))
* **gui:** load server strings into correct namespaces ([a0dfc06](https://github.com/ssube/onnx-web/commit/a0dfc060da330448d41d182a68c11fd2e25c86c4))
* **gui:** move pre tag into a valid location ([aec44aa](https://github.com/ssube/onnx-web/commit/aec44aaaebc8881f5d33fc0d824659b71931180d))
* **gui:** remove empty option and fix labels for none in mask filter ([#228](https://github.com/ssube/onnx-web/issues/228)) ([3f18b3b](https://github.com/ssube/onnx-web/commit/3f18b3b92635831d254660bd67da0ab50b8100af))
* **gui:** send correct values for upscale order ([d0b8045](https://github.com/ssube/onnx-web/commit/d0b80451ada230870ac20ebc61e700591ba4bd37))
* **gui:** set tile order to value rather than index ([#229](https://github.com/ssube/onnx-web/issues/229)) ([171b9b0](https://github.com/ssube/onnx-web/commit/171b9b04f7ab9b88d6d674735bf5acf7b826ec19))
* **gui:** start French translation ([2b319c4](https://github.com/ssube/onnx-web/commit/2b319c48e405e154fdbf95b41dafd9d31f90b9df))
* **gui:** translate the initial progress screen ([af05e05](https://github.com/ssube/onnx-web/commit/af05e05ea6bdefbf1205448c84e8c48ec3bfe51b))
* **scripts:** pass protocol and port to all test scripts ([b44e644](https://github.com/ssube/onnx-web/commit/b44e644f9e9cf5851117b5f62a8f62c35d70a23c))
* **scripts:** reduce steps/time on leak test ([6204829](https://github.com/ssube/onnx-web/commit/62048298d7d0bf9ea295b6c8188c3fa4f1118c3a))
* **scripts:** update release tests with support for batches ([6809d2d](https://github.com/ssube/onnx-web/commit/6809d2da825d3ebdfc131369398514a92ab83e2c))
* **tests:** add release test for partial blending ([312d8d2](https://github.com/ssube/onnx-web/commit/312d8d251a0918d7e942ece63d0377e580685a65))
* **tests:** make release tests more strict, update DEIS reference ([3d0f243](https://github.com/ssube/onnx-web/commit/3d0f2434af830e38a46e13423c4274891595550a))
* **tests:** update blend refs for release tests ([5825097](https://github.com/ssube/onnx-web/commit/58250976d4188915e4a518a276e22b002837ddc6))
* **tests:** use correct endpoint in release tests for blend mode ([d794835](https://github.com/ssube/onnx-web/commit/d794835d20eb27bf571514d8d6018f9ee97ddb4f))

### [0.7.1](https://github.com/ssube/onnx-web/compare/v0.7.0...v0.7.1) (2023-02-16)

* **api:** remove unused import

## [0.7.0](https://github.com/ssube/onnx-web/compare/v0.6.1...v0.7.0) (2023-02-16)


### Features

* add iPNDM scheduler ([f2d0025](https://github.com/ssube/onnx-web/commit/f2d00255457bb1c847ca12538d0ee82f596a0c98))
* add support for DEIS multistep scheduler ([6b6f2f0](https://github.com/ssube/onnx-web/commit/6b6f2f0eff7faf1f37b480c89a782e4df3361571))
* **api:** add a way to download models from civitai or other https sources ([#117](https://github.com/ssube/onnx-web/issues/117)) ([9f20248](https://github.com/ssube/onnx-web/commit/9f202486c2bc91457bd04c1808fd5beed9ed6c5f))
* **api:** add an option for custom checkpoint config to extras file (fixes [#130](https://github.com/ssube/onnx-web/issues/130)) ([d6201c9](https://github.com/ssube/onnx-web/commit/d6201c9d32fc538510e18e1adf1be7958c3d6a23))
* **api:** add GFPGAN and Real ESRGAN to model cache ([0709c1d](https://github.com/ssube/onnx-web/commit/0709c1dbf026018b53338754ca2386cd8e02d3db))
* **api:** add model cache for diffusion models ([e9472bc](https://github.com/ssube/onnx-web/commit/e9472bc005c2bda9c652595cfc0122ac23fff36b))
* **api:** add option to use any available platform ([ea3b065](https://github.com/ssube/onnx-web/commit/ea3b065d8034af2c03ba70b2b839336e1ba08688))
* **api:** add tmux launch script ([45ad18c](https://github.com/ssube/onnx-web/commit/45ad18cefe8ec819e91790e733852290860f4375))
* **api:** collect progress from chain pipelines ([#90](https://github.com/ssube/onnx-web/issues/90)) ([d9fc908](https://github.com/ssube/onnx-web/commit/d9fc9085924367159793ccfb8f3560a10dce64be))
* **api:** convert from SD checkpoints ([#117](https://github.com/ssube/onnx-web/issues/117)) ([4f71348](https://github.com/ssube/onnx-web/commit/4f71348f984e5778984ca916a03c285c0117a415))
* **api:** intercept model downloads in libs and use cached copy (fixes [#95](https://github.com/ssube/onnx-web/issues/95)) ([1179092](https://github.com/ssube/onnx-web/commit/1179092028ddcd1d08ffb53fed18cb2a66c9ee69))
* **api:** make any platform optional ([9551e4a](https://github.com/ssube/onnx-web/commit/9551e4a9b9c63817cb9967e3b376457c83795184))
* **api:** pass tile order to inpaint and outpaint pipelines ([3a29082](https://github.com/ssube/onnx-web/commit/3a290822eb3a5038753d1643a93c0f6acc247387))
* **build:** add dry run jobs for packaging ([1d56530](https://github.com/ssube/onnx-web/commit/1d5653023797b118ea413d4dc8d6b8909fcb6c38))
* **gui:** add a reset all button to settings and error screen (fixes [#116](https://github.com/ssube/onnx-web/issues/116)) ([8f0a8e6](https://github.com/ssube/onnx-web/commit/8f0a8e6fdbc7c4b8c3d16131307e587d11402e60))
* **gui:** add blend tab and copy button ([4abbb00](https://github.com/ssube/onnx-web/commit/4abbb00fd0adb692b01ff531eae5402af5342e1c))
* **gui:** add download button to mask ([#135](https://github.com/ssube/onnx-web/issues/135)) ([3544e23](https://github.com/ssube/onnx-web/commit/3544e238cfd09df95b67d16d24b7ee92e3c5a11e))
* **gui:** add tile order as an inpaint parameter ([#107](https://github.com/ssube/onnx-web/issues/107)) ([51651ab](https://github.com/ssube/onnx-web/commit/51651abd085e4b89df1f48e93d858270a1c743ea))
* **gui:** add undo button to mask canvas ([bb05395](https://github.com/ssube/onnx-web/commit/bb05395563169f26dc6df0fb28cef88a2041afd7))
* implement blend tab and copy buttons ([#62](https://github.com/ssube/onnx-web/issues/62)) ([7fa1783](https://github.com/ssube/onnx-web/commit/7fa1783be485e2bba916bf7a641b96f2bcc6f37c))
* show model in image card, use labels for model and scheduler ([#104](https://github.com/ssube/onnx-web/issues/104)) ([27a3fa8](https://github.com/ssube/onnx-web/commit/27a3fa8f516cebeec3a3a8d0f25cb0e321851807))


### Bug Fixes

* **api:** accumulate progress from inpaint pipelines ([#90](https://github.com/ssube/onnx-web/issues/90)) ([034be32](https://github.com/ssube/onnx-web/commit/034be3266eb4cefcdb513a92677884d5286a63d9))
* **api:** add v2 conversion config ([84079e4](https://github.com/ssube/onnx-web/commit/84079e4490530903dd331a3bf4b8d8d0c2892213))
* **api:** always fill inpaint/outpaint mask with white ([1f06b50](https://github.com/ssube/onnx-web/commit/1f06b502d581b9422ce64ce30a46447a492be6f1))
* **api:** base model cache size on number of workers ([c61f200](https://github.com/ssube/onnx-web/commit/c61f200bc2cce79d184e461371ca19721b4dfd81))
* **api:** bypass model cache entirely when limit is 0 ([df5fb93](https://github.com/ssube/onnx-web/commit/df5fb93bc0c14c50ebfdd0a32147e5cd7acc9d08))
* **api:** convert blend sources to the same size as the mask ([d1b2506](https://github.com/ssube/onnx-web/commit/d1b250660e7649bb3e50c78b58a0ac364138ed0a))
* **api:** correctly cache diffusers scheduler ([9c5043e](https://github.com/ssube/onnx-web/commit/9c5043e9d0e516b06dc3de989826ebc7cedd5e0b))
* **api:** correctly handle partial extras files ([9d1c5dc](https://github.com/ssube/onnx-web/commit/9d1c5dca521e70e43b58d66b46981396c33a4a71))
* **api:** include any platform option ([d7383d1](https://github.com/ssube/onnx-web/commit/d7383d1101b8a06a5dbe1a1d94858c30dfd6840e))
* **api:** launch with included extras if user does not provide their own ([2cc6048](https://github.com/ssube/onnx-web/commit/2cc604823b28321c111ddd62f87f22a8ab5f43e2))
* **api:** load Real ESRGAN PTH from cache ([51d5359](https://github.com/ssube/onnx-web/commit/51d53597c0acd164417cc14d6699c3b32a0788fe))
* **api:** make diffusion model config optional again ([4cc1d63](https://github.com/ssube/onnx-web/commit/4cc1d63cec080851b79be99b97bd7b3aaa7d3ad9))
* **api:** make SD upscaling compatible with more schedulers ([2b29b09](https://github.com/ssube/onnx-web/commit/2b29b099f0ec9bb0d23df87036f8430798a6e4fc))
* **api:** make tmux launch script executable ([1de591e](https://github.com/ssube/onnx-web/commit/1de591e15f538c970b1b97c2a8b61a74e7f106eb))
* **api:** make venv has been loaded in launch script ([d8d5bcd](https://github.com/ssube/onnx-web/commit/d8d5bcd92739224a21afc4b1891b6f5d9ac8e22b))
* **api:** move all unet tensors to the training device ([#119](https://github.com/ssube/onnx-web/issues/119)) ([45b0916](https://github.com/ssube/onnx-web/commit/45b09168dd26ecddb0210c18033323ea41eae334))
* **api:** pass both device and session options to ORT ([#38](https://github.com/ssube/onnx-web/issues/38)) ([8a2a917](https://github.com/ssube/onnx-web/commit/8a2a9174ba01095850c53875b1082cfc87755da9))
* **api:** pass device options to ORT session ([#38](https://github.com/ssube/onnx-web/issues/38)) ([d473a0f](https://github.com/ssube/onnx-web/commit/d473a0fd2db1fc5bfca207b8e5c248673c5e7338))
* **api:** patch download fn in facexlib ([#134](https://github.com/ssube/onnx-web/issues/134)) ([c6b2751](https://github.com/ssube/onnx-web/commit/c6b2751cc12b3ba1b80f30babf0fa976341ac304))
* **api:** patch more download paths ([#134](https://github.com/ssube/onnx-web/issues/134)) ([05756b2](https://github.com/ssube/onnx-web/commit/05756b2b088048fd8eb1ae0d18db9d8f2fe2028d))
* **api:** patch various download fns to use cache ([#95](https://github.com/ssube/onnx-web/issues/95)) ([8ea33e9](https://github.com/ssube/onnx-web/commit/8ea33e9874ccd51fc0ae444cf477f6ffc3ba7fd8))
* **api:** remove alpha channel after blending but before upscaling (fixes [#148](https://github.com/ssube/onnx-web/issues/148)) ([32a4bbc](https://github.com/ssube/onnx-web/commit/32a4bbcd6412e8ee85816cdd7d1a66d11982376c))
* **api:** remove any from device pool ([db06f4a](https://github.com/ssube/onnx-web/commit/db06f4a9c3f5063e6828615d532ad4485eb59c73))
* **api:** remove finished jobs from worker pool ([#124](https://github.com/ssube/onnx-web/issues/124)) ([feb4603](https://github.com/ssube/onnx-web/commit/feb4603171f8e2f538bf339fb8990ca7506ac9c9))
* **api:** remove inpaint post-multiply ([#150](https://github.com/ssube/onnx-web/issues/150)) ([b5eeb44](https://github.com/ssube/onnx-web/commit/b5eeb44c62b2db3801b607094992ce699e5297ec))
* **api:** report correct image size for blend tab ([d60ec52](https://github.com/ssube/onnx-web/commit/d60ec521867c62e0c974e087df184a87bbac6a77))
* **api:** restore python 3.8 compatibility ([#146](https://github.com/ssube/onnx-web/issues/146)) ([3e5edb1](https://github.com/ssube/onnx-web/commit/3e5edb1c39117637b4dce681f0e41fe6d0f59aa7))
* **api:** run garbage collection after job errors ([b3e4076](https://github.com/ssube/onnx-web/commit/b3e4076775e746e665d9d07384bb8efd7da971a5))
* **api:** separate Real ESRGAN upsampler from GFPGAN stage ([#87](https://github.com/ssube/onnx-web/issues/87)) ([82487f5](https://github.com/ssube/onnx-web/commit/82487f5771895f581cad5b5144ee84a0db274175))
* **api:** skip model download if final converted version already exists (fixes [#139](https://github.com/ssube/onnx-web/issues/139)) ([7f6fa22](https://github.com/ssube/onnx-web/commit/7f6fa22b4ee85476687d30f4ed6b0e348d4891e2))
* **api:** split up base and extras launch scripts ([4b18578](https://github.com/ssube/onnx-web/commit/4b1857883f586a53a10242b7dff018f5e80087ab))
* **api:** use correct var for diffusion scheduler cache ([aaf82a4](https://github.com/ssube/onnx-web/commit/aaf82a42f14a27bb9107d90ac04a799bccbc3f37))
* **build:** copy readme into packages ([#114](https://github.com/ssube/onnx-web/issues/114)) ([d5bf2b0](https://github.com/ssube/onnx-web/commit/d5bf2b033804fa1a39aaab701cde9c918616b8e9))
* **build:** correct base job names for package dry runs ([3b65518](https://github.com/ssube/onnx-web/commit/3b65518efc662026648e8d4439004d34245a3723))
* **build:** install packaging tools in job ([33188f6](https://github.com/ssube/onnx-web/commit/33188f6eaad2ea5652694f2e3edf4e852c78cdf0))
* **build:** move pip cache into project dir ([baa7f91](https://github.com/ssube/onnx-web/commit/baa7f912a16e846da9cfa82af859ed83af3a3c96))
* **build:** use auth for twine upload ([bbcd812](https://github.com/ssube/onnx-web/commit/bbcd812f837580fba691372ff6d460a1a44b68a4))
* **docs:** cover extra models in user guide ([24c542a](https://github.com/ssube/onnx-web/commit/24c542a952394d7f31e09f37bc578c54e389d8bb))
* **docs:** describe how to get model ID from Civitai ([#117](https://github.com/ssube/onnx-web/issues/117)) ([92ede99](https://github.com/ssube/onnx-web/commit/92ede9928bfb7fd9b3605ead08942c969d999265))
* **docs:** link to SD models on HF hub ([41fad09](https://github.com/ssube/onnx-web/commit/41fad09d93152fcf7544f5b8f48b6feb8a406696))
* **docs:** note launch-extras script ([cc7cafa](https://github.com/ssube/onnx-web/commit/cc7cafabfd08483bbffc79f0c52dfc50444f6878))
* **gui:** capitalize tile order options ([6a6f482](https://github.com/ssube/onnx-web/commit/6a6f4821789642ae9da5d612028b348a72a7ad0e))
* **gui:** correct react update during render ([3c7a3e5](https://github.com/ssube/onnx-web/commit/3c7a3e54b9f34b84acfbb3d15f7500185fe78067))
* **gui:** get tile orders from server params ([0356c31](https://github.com/ssube/onnx-web/commit/0356c317c9f6823c4a03c5459d05ec607ee36ea8))
* **gui:** remove duplicate dots caused by mouse click and down handlers both firing ([fa0cd8e](https://github.com/ssube/onnx-web/commit/fa0cd8eaa4407e05971121dbc6c9992c84628095))
* **gui:** switch back to indeterminate progress when reported steps exceed estimate ([#90](https://github.com/ssube/onnx-web/issues/90)) ([b85c806](https://github.com/ssube/onnx-web/commit/b85c806ba7f80a81d7a80b773dbd846ed2444163))

### [0.6.1](https://github.com/ssube/onnx-web/compare/v0.6.0...v0.6.1) (2023-02-07)

## [0.6.0](https://github.com/ssube/onnx-web/compare/v0.5.0...v0.6.0) (2023-02-07)


### Features

* add face outscale as its own parameter ([#111](https://github.com/ssube/onnx-web/issues/111)) ([de4e7b0](https://github.com/ssube/onnx-web/commit/de4e7b0dc9b820da61a1dbe1be3dbffda68af5cb))
* **api:** add a way for the server to disable certain platforms ([#83](https://github.com/ssube/onnx-web/issues/83)) ([67d51a9](https://github.com/ssube/onnx-web/commit/67d51a96e3e9087adfaf5058dbe5edf914b78d32))
* **api:** add CodeFormer stage for chain pipelines ([e059f11](https://github.com/ssube/onnx-web/commit/e059f11253eebc638d71053735b39a61672f8f67))
* **api:** add CodeFormer to automatic upscale ([0a9f108](https://github.com/ssube/onnx-web/commit/0a9f1081566b4454c6a2ce8a89bf6443331770bd))
* **api:** add CodeFormer to conversion script ([a2a0028](https://github.com/ssube/onnx-web/commit/a2a0028bd464e6d937a5fef62feee53a0ef5c533))
* **api:** add img2img and inpaint chain stages ([dcbd059](https://github.com/ssube/onnx-web/commit/dcbd059082a3376ac7ffa4b9907c7c23de05bffc))
* **api:** add inpaint as a chain stage ([4579e96](https://github.com/ssube/onnx-web/commit/4579e96cc157f2c3ad4a47e53ecfdbfdd15706ba))
* **api:** add launch script for Windows ([fa7e5e8](https://github.com/ssube/onnx-web/commit/fa7e5e8ab97769b9dbeef48618d75f8b8bb987a2))
* **api:** add progress to ready endpoint ([294c831](https://github.com/ssube/onnx-web/commit/294c831d02564e15784e1ab6719962c6e5b42b1f))
* **api:** add provider for each available CUDA device ([#38](https://github.com/ssube/onnx-web/issues/38)) ([98b6e4d](https://github.com/ssube/onnx-web/commit/98b6e4dd03593f86ce5fddbd4e120242146ae9ed))
* **api:** add reduce stages, noise source ([c905fbb](https://github.com/ssube/onnx-web/commit/c905fbb72811ffe3cad4e9faa714e87e1774b104))
* **api:** add s3 upload chain stage ([8d57d11](https://github.com/ssube/onnx-web/commit/8d57d113cd21c900cfccd4cc07baac07ea21ddbf))
* **api:** add save-to-disk stage ([779457b](https://github.com/ssube/onnx-web/commit/779457b5463db86eead9f5790e39267bd763a5e2))
* **api:** add status endpoint ([157ed6d](https://github.com/ssube/onnx-web/commit/157ed6da70c4b702ead8c8c6bb19a97eee6cbe4d))
* **api:** create model path if needed during convert script ([6c22cb1](https://github.com/ssube/onnx-web/commit/6c22cb1cbf202e923533b2b22227d4c78ca6dea1))
* **api:** distribute jobs to devices using round-robin ([#38](https://github.com/ssube/onnx-web/issues/38)) ([5e0231c](https://github.com/ssube/onnx-web/commit/5e0231c01b0008c7a0394e94a55a55601124437d))
* **api:** enable LPW custom pipeline ([#27](https://github.com/ssube/onnx-web/issues/27)) ([7b506cb](https://github.com/ssube/onnx-web/commit/7b506cb6d335ee89c1c0c405ab4ac48ef5b1f769))
* **api:** implement spiral grid for outpainting ([a4d3f18](https://github.com/ssube/onnx-web/commit/a4d3f18a48782e067540a3897f2a6651ea84a947))
* **api:** implement upscaling and correction as a chain pipeline ([bcaf0f7](https://github.com/ssube/onnx-web/commit/bcaf0f73e618002d0d199227ff4f98fdeab67d74))
* **api:** initial support for Stable Diffusion upscaling ([#66](https://github.com/ssube/onnx-web/issues/66)) ([819af82](https://github.com/ssube/onnx-web/commit/819af824b047db4c5af471e9c8e306215a0a2d10))
* **api:** load source and mask images for chain pipelines ([#88](https://github.com/ssube/onnx-web/issues/88)) ([1de2a51](https://github.com/ssube/onnx-web/commit/1de2a51db54f155849746e15769da47b405b5f46))
* **api:** load-balance background jobs between devices ([efee374](https://github.com/ssube/onnx-web/commit/efee374c164f6db7ef8a8b109e8382f3ab5b7aee))
* **api:** log errors from background jobs ([53f4924](https://github.com/ssube/onnx-web/commit/53f492459f304cf04f2967d66e1f1a4b7c969230))
* **api:** make LPW an image parameter ([fb376c6](https://github.com/ssube/onnx-web/commit/fb376c6b62751c5479963ea713d8489c21fb0752))
* **api:** parse chain pipeline from request ([151ebff](https://github.com/ssube/onnx-web/commit/151ebff23794ce262826c5cba3416cbac666448e))
* **api:** parse named tile sizes ([8f1cbc8](https://github.com/ssube/onnx-web/commit/8f1cbc83f8b1de9025fd8c34471f79d2b1623503))
* **api:** provide a way for users to add models to the convert list ([#70](https://github.com/ssube/onnx-web/issues/70)) ([c837830](https://github.com/ssube/onnx-web/commit/c83783004310af095d509d991a9ae35b2b00d951))
* **api:** provide a way to override log settings ([406e0f0](https://github.com/ssube/onnx-web/commit/406e0f0cf9686f011bdbe0900f2454d38b0cbb79))
* **api:** remove client-side request mutex ([4e7bfd7](https://github.com/ssube/onnx-web/commit/4e7bfd79d767c3f20db8140d2f2988a1bedd618e))
* **api:** save image params along with image ([#81](https://github.com/ssube/onnx-web/issues/81)) ([6697c2e](https://github.com/ssube/onnx-web/commit/6697c2eb6aef239afbdd766e657c98b115d3a95f))
* **api:** save output of each stage in debug mode ([680adc7](https://github.com/ssube/onnx-web/commit/680adc70eaa8b8ce5cec24ee4bf250e89ffdedda))
* **api:** server setting to select image format ([6ce1309](https://github.com/ssube/onnx-web/commit/6ce13096edba7349b46d9e1727058e2694fe1035))
* **api:** set default platform for each container (fixes [#82](https://github.com/ssube/onnx-web/issues/82)) ([f4fc627](https://github.com/ssube/onnx-web/commit/f4fc6271bc6a67f5941cfbe3991d85efeb8ea769))
* **api:** start implementing chain pipelines ([71ff3bb](https://github.com/ssube/onnx-web/commit/71ff3bb1c482e1410b46a42da3e73e34bada7b3c))
* **api:** switch inpaint mode to upscale stage ([50d6dbb](https://github.com/ssube/onnx-web/commit/50d6dbb451c5e027c216c2c14e2c17a5b12d27f7))
* **api:** switch to device pool for background workers ([6426cff](https://github.com/ssube/onnx-web/commit/6426cff741ad41254336f0351dcbe8ace1d13453))
* **api:** switch to python logging ([4547bce](https://github.com/ssube/onnx-web/commit/4547bcef505aaf0e3cdd8c792700b06cedaf0c7d))
* **api:** synthesize a mask for outpaint stages ([5119a98](https://github.com/ssube/onnx-web/commit/5119a982dbfa75afe002cbd198934bc77b7530f1))
* **api:** use per-tile latents for outpainting ([483a1ba](https://github.com/ssube/onnx-web/commit/483a1bad683dee4f46fefdafeddbd44446264106))
* **build:** add basic codespaces definition ([#25](https://github.com/ssube/onnx-web/issues/25)) ([7c96145](https://github.com/ssube/onnx-web/commit/7c96145397c24946105b17db0e42f6f1bc65dee5))
* **build:** run Python lint during CI ([79eaad6](https://github.com/ssube/onnx-web/commit/79eaad67f2ff6ef81368e77c586b8085e3a8232b))
* **docs:** note debug mode, server env vars ([ce63ef6](https://github.com/ssube/onnx-web/commit/ce63ef66dd9720d9871819dc0dd78f79a34b4b07))
* **docs:** start a developer guide ([39a422f](https://github.com/ssube/onnx-web/commit/39a422f2e504838a268944ade0dffb8aa39a1748))
* **gui:** add cancel button to loading card ([f5039d8](https://github.com/ssube/onnx-web/commit/f5039d800dfd800a85fbc9538f2817423183aaa0))
* **gui:** add cancel to API client ([900a95e](https://github.com/ssube/onnx-web/commit/900a95eb61de9af2e32eb7724f41c63ff8cee147))
* **gui:** add LPW flag to model settings ([c47209c](https://github.com/ssube/onnx-web/commit/c47209cfbfd943ab0972467975d3b564ca551d76))
* **gui:** navigate to appropriate tab when copying image (fixes [#80](https://github.com/ssube/onnx-web/issues/80)) ([1e477f7](https://github.com/ssube/onnx-web/commit/1e477f7548eccdca39dc298ca895a93258a0e092))
* **gui:** save tabs and allow linking ([#80](https://github.com/ssube/onnx-web/issues/80)) ([e6e9914](https://github.com/ssube/onnx-web/commit/e6e9914ca0fb710f95d9691e494bda5a50831ede))


### Bug Fixes

* **api:** add device index to job status endpoint ([ae434f5](https://github.com/ssube/onnx-web/commit/ae434f5c11fa1fda188901cd4e7338179fef8bb9))
* **api:** additional logging around model load ops ([ea69753](https://github.com/ssube/onnx-web/commit/ea69753bfd78b6e8c8e49d9757be6fa79c9e22f5))
* **api:** avoid circular deps in diffusion pipeline cache ([c7a6ec4](https://github.com/ssube/onnx-web/commit/c7a6ec45d869d7e09ff5152e092333ca9efc3f8b))
* **api:** avoid setting device on schedulers that do not support it ([d636ce3](https://github.com/ssube/onnx-web/commit/d636ce3eefb3033ff1aada1a24116b765403a2fe))
* **api:** calculate outpaint overlap factor before adding margins ([b6fd288](https://github.com/ssube/onnx-web/commit/b6fd288842e04dd1ac89025ece7827ebd6b4051c))
* **api:** convert images to ndarray before passing to GFPGAN ([39f84c4](https://github.com/ssube/onnx-web/commit/39f84c4a49f48060cd5e3d0b04f6718712bac41e))
* **api:** convert size to JSON ([83992d9](https://github.com/ssube/onnx-web/commit/83992d91937b867490707ed05b8aed0fb83e36d6))
* **api:** convert spiral grid coordinates to offsets ([6f1ffaa](https://github.com/ssube/onnx-web/commit/6f1ffaa0439398409b8e08e8e97d37a9189547d4))
* **api:** correct caching for upscaling models ([ee495a8](https://github.com/ssube/onnx-web/commit/ee495a8d93646a40596ab2e894872e3b946eaa4e))
* **api:** correct import error ([59b8055](https://github.com/ssube/onnx-web/commit/59b80559263e48d7ea137682bc73f0aba3104d3d))
* **api:** correct order for img2img params ([6fcfe4f](https://github.com/ssube/onnx-web/commit/6fcfe4f8782a16bbf924fb9e52baaa0b4f705bcb))
* **api:** correct python cmd for Windows ([a901cc4](https://github.com/ssube/onnx-web/commit/a901cc44bdc268ee49c2566ad2cac9711c8c503e))
* **api:** correctly create model path ([f302be7](https://github.com/ssube/onnx-web/commit/f302be7f506bff1b8a7f11d11ebf89319896ec13))
* **api:** correctly make output directory ([33bb56d](https://github.com/ssube/onnx-web/commit/33bb56dd247ad08c00136ebbcf6847427024200f))
* **api:** default to first available device when there are no other jobs ([bf3f227](https://github.com/ssube/onnx-web/commit/bf3f227d662a375132f2d0f420e41bf3922c5f88))
* **api:** drop unused parameter from inpaint pipeline ([a3eed7a](https://github.com/ssube/onnx-web/commit/a3eed7a0958c5029f671caf84d8dbe9b215930ff))
* **api:** embed LPW pipeline (fixes [#96](https://github.com/ssube/onnx-web/issues/96)) ([7c5f9ba](https://github.com/ssube/onnx-web/commit/7c5f9baeb7dd1c3b6ba1b88d84f66ec0a7a376c8))
* **api:** exclude finished jobs when load balancing ([ed2e15a](https://github.com/ssube/onnx-web/commit/ed2e15a67ec018b85690cd1057487d0facf16bb0))
* **api:** fully switch between LPW and regular ONNX pipelines ([5f35a28](https://github.com/ssube/onnx-web/commit/5f35a2853ba42edcb9014421e08670ec601cebd6))
* **api:** handle partial params when formatting output ([c19f39f](https://github.com/ssube/onnx-web/commit/c19f39f9b40197a95f06cfd6ee38a7c12427e344))
* **api:** include face correction outscale in final image size ([7db5472](https://github.com/ssube/onnx-web/commit/7db5472531498a1af3709bbed02c592bf7053377))
* **api:** keep chain pipeline images and use request size ([9d0609f](https://github.com/ssube/onnx-web/commit/9d0609fefea253c4e71017d0cd3276db77553288))
* **api:** log number of background workers on startup ([732aa27](https://github.com/ssube/onnx-web/commit/732aa27b927976f050bacf38e2573d79081cecc1))
* **api:** log stacktrace from job errors ([bf1378b](https://github.com/ssube/onnx-web/commit/bf1378bf96c20b667f1b35b4265f8ae0017c40f5))
* **api:** make sure each pipeline has its own list of stages ([b1ba09a](https://github.com/ssube/onnx-web/commit/b1ba09af3ee8d23d8948007d2de0adca70986671))
* **api:** make sure each upscale/correction model gets its own stage ([833fc5c](https://github.com/ssube/onnx-web/commit/833fc5c2f864b4d0d6d52bc01e0fb7732cc08e06))
* **api:** move chain body to form field ([bef50d8](https://github.com/ssube/onnx-web/commit/bef50d89b1db890149dab5e8c2550d4427b6934a))
* **api:** only run one form of outpaint tiling ([811b664](https://github.com/ssube/onnx-web/commit/811b6640a8fdfac3deb67e6edfda8234a69a0fbc))
* **api:** only try to load extras when a path is provided ([#112](https://github.com/ssube/onnx-web/issues/112)) ([ad10806](https://github.com/ssube/onnx-web/commit/ad108060ed8da22eaf31007af06b5153ae5018e8))
* **api:** parse border and upscale in chain stages ([18803db](https://github.com/ssube/onnx-web/commit/18803db6ed83bf0521dc0e4792f0b528f26e12fd))
* **api:** pass current device when loading GFPGAN ([c7e0041](https://github.com/ssube/onnx-web/commit/c7e0041229e9b9b617310c1e9c67d3a48d5b0efa))
* **api:** pass device ID in provider params ([37dd892](https://github.com/ssube/onnx-web/commit/37dd8927bfc8d5e2f8e1bf5b2776e26279889014))
* **api:** pass job context and device to upscaling ([3637f64](https://github.com/ssube/onnx-web/commit/3637f642c694d1a7f96fc51e895cf7a49967fa7c))
* **api:** pass outscale factor to CodeFormer (fixes [#100](https://github.com/ssube/onnx-web/issues/100)) ([ca2f0a6](https://github.com/ssube/onnx-web/commit/ca2f0a6404c86e0162671fcf31817803485664ea))
* **api:** pass prompt to upscaling pipeline ([6a0f881](https://github.com/ssube/onnx-web/commit/6a0f8811206fec513af960be0da8fc5b39644a4e))
* **api:** pin outscale for GFPGAN to 1 to avoid sparse tiling ([c34ddac](https://github.com/ssube/onnx-web/commit/c34ddacf5526068c9e69e19ba5ca1d3d8026ff08))
* **api:** prefer device with lower index when queue is tied ([13510db](https://github.com/ssube/onnx-web/commit/13510dbacd1590116fde64adb0f1587953918e61))
* **api:** preserve new pixels after outpainting ([7083505](https://github.com/ssube/onnx-web/commit/708350548351911a7d84482fdb29621e08360119))
* **api:** remove background upscaler from GFPGAN stage ([#108](https://github.com/ssube/onnx-web/issues/108)) ([24ab52b](https://github.com/ssube/onnx-web/commit/24ab52bf0dcb5de20e71aeaf911f9d381f4f38c6))
* **api:** remove reference to undeclared var ([6c9b0c9](https://github.com/ssube/onnx-web/commit/6c9b0c9c1ecd310e4c3a09e10a4285d4a3e3483a))
* **api:** remove unused flask-executor package ([3a91347](https://github.com/ssube/onnx-web/commit/3a91347709d9a83aebbad9a5a1925b9da3ae7037))
* **api:** replace some numpy RNGs with torch equivalent ([401df84](https://github.com/ssube/onnx-web/commit/401df840691bbc4b3ab88c720f3c92d8c5a760a4))
* **api:** respect model selection when running inpaint/outpaint stages ([a1298f1](https://github.com/ssube/onnx-web/commit/a1298f15653197880b05c6dbd6561002861a07e6))
* **api:** restore denoise code path for Real ESRGAN v3 ([#109](https://github.com/ssube/onnx-web/issues/109)) ([ae5cf1f](https://github.com/ssube/onnx-web/commit/ae5cf1fd28d05587e3d942d045a41241e2af3a18))
* **api:** return JSON params after image requests ([2123d42](https://github.com/ssube/onnx-web/commit/2123d42c450b2afda975551eb4529f41b82bcdb4))
* **api:** run background ESRGAN on same device as GFPGAN ([1dfd9e7](https://github.com/ssube/onnx-web/commit/1dfd9e72ef8a7fb847d8a36164ad7020616c1354))
* **api:** run garbage collection after each model change ([066b1a0](https://github.com/ssube/onnx-web/commit/066b1a0230ec95d7ab4f31165e2358638d11b217))
* **api:** set CUDA device in ORT session ([04a2faf](https://github.com/ssube/onnx-web/commit/04a2faffd964a507d27ea3e425311e9011d05f65))
* **api:** set minimum image dimensions to 256 ([#79](https://github.com/ssube/onnx-web/issues/79)) ([ecec0a2](https://github.com/ssube/onnx-web/commit/ecec0a2e56e0956039be75e54bfec81ac90e55c8))
* **api:** show indeterminate spinner until progress has been determined ([88815b3](https://github.com/ssube/onnx-web/commit/88815b353724f71449943ac047a278c11b506e3e))
* **api:** split up and cache upscaling and correction stages ([56a4ace](https://github.com/ssube/onnx-web/commit/56a4acee2a734539e24b62eb8609ff5658cab466))
* **api:** supply missing parameter to GFPGAN ([d5e5588](https://github.com/ssube/onnx-web/commit/d5e55889399f0a641c7c32ac953bf2b801dedb0e))
* **api:** switch between spiral and grid tiling based on outpaint margins ([#101](https://github.com/ssube/onnx-web/issues/101)) ([6fe278c](https://github.com/ssube/onnx-web/commit/6fe278c744041cf5b7d33299f6e576b9f5dce76a))
* **api:** switch RNG based on LPW parameter ([f3983a7](https://github.com/ssube/onnx-web/commit/f3983a7917036c0586a23a20309e623f9abba2bf))
* **api:** tile mask during outpaint stage ([d6193a9](https://github.com/ssube/onnx-web/commit/d6193a9a479701b96ba77bbb9e31fd38892596d1))
* **api:** update SD upscale pipeline ([49b3aa6](https://github.com/ssube/onnx-web/commit/49b3aa68bbe297b77ba275a2ddb401b40f704b56))
* **api:** use first available platform if requested one does not exist ([15c651b](https://github.com/ssube/onnx-web/commit/15c651b31a1cceca45635d156e3c7aff2b6c081e))
* **api:** use grid tiling when inpaint margin is 0 ([d6c1244](https://github.com/ssube/onnx-web/commit/d6c1244d7249c39c897dde396fb9292f050f3e7d))
* **api:** use requested size for initial chain pipeline input ([0050cea](https://github.com/ssube/onnx-web/commit/0050cea6947d0753ef1f7d8ea9c57ed10daa450a))
* **api:** use server image format when building output name ([e533dad](https://github.com/ssube/onnx-web/commit/e533dad4baf0d71307f82638bc2e042ab778de78))
* **api:** use SRVGG net for Real ESRGAN v3 ([de4a381](https://github.com/ssube/onnx-web/commit/de4a3818a08aa0de741caca3ff31ccfddb1d6975))
* **api:** variable name in GFPGAN ([1ca7edb](https://github.com/ssube/onnx-web/commit/1ca7edb4a84573c94c4ed87d678c0b4d6001875d))
* **api:** write border and upscale to params file ([b1eec69](https://github.com/ssube/onnx-web/commit/b1eec6907a71cd0f289fb322860806966dff528f))
* **build:** disable ROCm container ([c0e5f43](https://github.com/ssube/onnx-web/commit/c0e5f435ee022189b6f73e39d8ff84fd884d5425))
* **build:** include extras and logging config in containers ([e1ce3d2](https://github.com/ssube/onnx-web/commit/e1ce3d21361b24a5cf57efc74dc4e46ec0c25e1a))
* **build:** install dev deps in API test job ([1f65da8](https://github.com/ssube/onnx-web/commit/1f65da88b0f4a78830365894f259d202e03425dc))
* **build:** mark additional targets as phony ([9f9736c](https://github.com/ssube/onnx-web/commit/9f9736c30c4f8c22a46782b176c7bb796206335c))
* **build:** sh-friendly syntax ([d1ed5c4](https://github.com/ssube/onnx-web/commit/d1ed5c48e8a733d4ffaad47b65c001a09b47b072))
* **docs:** add checkboxes to release test plan ([69ebb1c](https://github.com/ssube/onnx-web/commit/69ebb1cb65557770d05b783398b4ea7e46987819))
* **docs:** add duplicate device error to user guide ([f6dbab3](https://github.com/ssube/onnx-web/commit/f6dbab3422076f7aba4ec8a2c56f44429b6f4059))
* **docs:** add PyTorch to ROCm setup section ([43787f0](https://github.com/ssube/onnx-web/commit/43787f085e0b8f557c2a1af33c0e1ca609e54e72))
* **docs:** correct syntax for skip argument to convert script ([480129c](https://github.com/ssube/onnx-web/commit/480129cc71869471ec944c292753526f4df300b8))
* **docs:** describe ROCm setup ([dad0564](https://github.com/ssube/onnx-web/commit/dad056404de7b86f105fa7e188b683914859854f))
* **docs:** explain how to convert your own models ([27da3c3](https://github.com/ssube/onnx-web/commit/27da3c333407972a4904ea4dbc728b0409b95b45))
* **docs:** start a guide for chain pipelines ([2baf6ed](https://github.com/ssube/onnx-web/commit/2baf6ed212a650c149892b3637e4498009f699fa))
* **gui:** clear loading state for image when it enters history ([7181d62](https://github.com/ssube/onnx-web/commit/7181d62fbadcc71d0ae02d4ff6ea109583c8b9da))
* **gui:** load remaining defaults from server params ([88e4f74](https://github.com/ssube/onnx-web/commit/88e4f74efe958b5c43d32731ae103ea19c5ca40a))
* **gui:** move image card labels to tooltip ([2bc679e](https://github.com/ssube/onnx-web/commit/2bc679ea973e23b610a28a8d78ba139d6170e554))
* **gui:** only send outscale when needed ([35445ff](https://github.com/ssube/onnx-web/commit/35445ff0f6892dd24ba28b25520ab204253db6d4))
* **gui:** only send scale when upscale is enabled ([#106](https://github.com/ssube/onnx-web/issues/106)) ([13de863](https://github.com/ssube/onnx-web/commit/13de86377fe4fb99bbc3eb18b33cb81b27d316bd))
* **gui:** query for each loading image separately ([0eee464](https://github.com/ssube/onnx-web/commit/0eee4648917f664011736cfc48a895662f2219cd))
* **gui:** show indeterminate spinner when progress is not available ([4abd0cb](https://github.com/ssube/onnx-web/commit/4abd0cb8a31d13cf57e33dcc5dbc70545fac6af2))
* **gui:** split upscaling and face correction controls ([b8ffe3f](https://github.com/ssube/onnx-web/commit/b8ffe3ffa8cccb238b7ea595c96ff20c6e0fc6c4))

## [0.5.0](https://github.com/ssube/onnx-web/compare/v0.4.0...v0.5.0) (2023-01-24)


### Features

* add additional Real ESRGAN models, strings for them ([d52c22e](https://github.com/ssube/onnx-web/commit/d52c22e58b4b62463c3d14bbbe930f1b90640209))
* add fill color control to inpaint ([3679735](https://github.com/ssube/onnx-web/commit/3679735d86e982c18ae9534118567b2a24990868))
* add outscaling option ([8d3ebed](https://github.com/ssube/onnx-web/commit/8d3ebede5a402499f285f1b06d367c8e9b8b2126))
* add ROCm provider to list ([#10](https://github.com/ssube/onnx-web/issues/10)) ([3bcd7a8](https://github.com/ssube/onnx-web/commit/3bcd7a8156328dbc0087efc12450abf22df443fd))
* add upscale controls to client, params to server ([d1e4fa9](https://github.com/ssube/onnx-web/commit/d1e4fa9cf1da5188b71d34d8a1753ba0e6186009))
* add upscaling tab and endpoint ([4aeee60](https://github.com/ssube/onnx-web/commit/4aeee60b19ac843e703f1eaf7ca50353eb386ee4))
* add version check to parameters ([be3a17b](https://github.com/ssube/onnx-web/commit/be3a17b2ffa9f78ab96a9a1659ce22a0ab0279d2))
* **api:** add basic upscaling ([77cb84c](https://github.com/ssube/onnx-web/commit/77cb84c60eb3272cb16525c4f6157367342b1726))
* **api:** add conversion script for models ([e59449f](https://github.com/ssube/onnx-web/commit/e59449fec1137cd1e8dfe688330b86f6154f9da0))
* **api:** add ESRGAN/GFPGAN deps ([9f43837](https://github.com/ssube/onnx-web/commit/9f4383716e04464825e032b0ead3c4efc1cbf64f))
* **api:** add ONNX implementation of Real ESRGAN net ([9519fc1](https://github.com/ssube/onnx-web/commit/9519fc16e993f314118cd4c9597e395fccc4300b))
* **api:** add option for HuggingFace token in convert script ([45a3ddc](https://github.com/ssube/onnx-web/commit/45a3ddc2a9dd2a5ccacf8bace8d681f16f8d81f7))
* **api:** add strength param to inpaint, remove same from upscale ([5ba752e](https://github.com/ssube/onnx-web/commit/5ba752e526ff4cb04baceeb8ee97bc9961350345))
* **api:** add support for Stable Diffusion models to conversion script ([decb281](https://github.com/ssube/onnx-web/commit/decb2813c6078664661138273d34f4e0b90ea6fb))
* **api:** backend support for multiple GPUs in diffusion pipelines ([a868c8c](https://github.com/ssube/onnx-web/commit/a868c8cf6bd249571700b0d1fbf6b2ea2cc54d09))
* **api:** return all types of models ([ee6308a](https://github.com/ssube/onnx-web/commit/ee6308a0918a865bfde2615d9a75e86f8796bb89))
* **api:** split up test scripts for diffusers and real esrgan ([48963fa](https://github.com/ssube/onnx-web/commit/48963fa591413905403adc343b8ac2124ec0eca5))
* **api:** start adding model sources to convert script ([4d0898a](https://github.com/ssube/onnx-web/commit/4d0898a52cf95566101a7085474d0607bdc6872a))
* **build:** add DirectML and ROCm images ([b18567c](https://github.com/ssube/onnx-web/commit/b18567ca43fab9408730e08926b0eeb43fb7ff8e))
* **build:** compile ONNX runtime with ROCm support ([a8bc371](https://github.com/ssube/onnx-web/commit/a8bc3714785bfc9b495406ef16366142c02f3c7a))
* **build:** run convert script when container starts ([a8769a5](https://github.com/ssube/onnx-web/commit/a8769a5919ead33d3328ff75ca09bc68168933ab))
* **docs:** add platform/model compatibility list ([b22f156](https://github.com/ssube/onnx-web/commit/b22f15600bb8f80a6c906fb25471d1f4a2ff7314))
* **gui:** add API server to settings ([d402db8](https://github.com/ssube/onnx-web/commit/d402db85092b9923b7a16b7b26ee1c035809ab4b))
* **gui:** add blend strength to inpainting controls ([691aeab](https://github.com/ssube/onnx-web/commit/691aeabfd93dc6df801306c8dee37d0a8be6e7d2))
* **gui:** add invert button to inpaint mask (fixes [#65](https://github.com/ssube/onnx-web/issues/65)) ([9e31445](https://github.com/ssube/onnx-web/commit/9e31445ccc36f9a47496331d307678faf793cb9a))
* **gui:** add menus for upscaling and correction models ([0080d86](https://github.com/ssube/onnx-web/commit/0080d86d91fbb476684a0e8614a3950c25cede06))
* **gui:** add validation to numeric inputs, token counter to prompt ([a1b16bb](https://github.com/ssube/onnx-web/commit/a1b16bb435f1890d83175ad7317bc42693efc15e))
* **run:** add Docker Compose files for API containers ([2a6df0f](https://github.com/ssube/onnx-web/commit/2a6df0f3aa52585b6dfb15c02bcb2cf66160c388))


### Bug Fixes

* **api:** actually return the filtered list of platforms ([facd69f](https://github.com/ssube/onnx-web/commit/facd69f452d5dc921da5a220c4b515833e443cb3))
* **api:** add an option to skip certain models during conversion ([556d5b8](https://github.com/ssube/onnx-web/commit/556d5b84d6b7e969b4249a6f2819959e2c571843))
* **api:** add extra models to convert script ([e083411](https://github.com/ssube/onnx-web/commit/e0834110fc31e9d8f42b5a2b1e624a7fdf425ad4))
* **api:** add missing params to load stub ([fe65746](https://github.com/ssube/onnx-web/commit/fe657468bf3ae6011690eac1de07a1842dc9e82f))
* **api:** check if output file exists for ready endpoint ([#57](https://github.com/ssube/onnx-web/issues/57)) ([b2e7ad5](https://github.com/ssube/onnx-web/commit/b2e7ad599ff0e866ea729538db8ab6a93b6976bb))
* **api:** check image size before blending ([08dbc0c](https://github.com/ssube/onnx-web/commit/08dbc0c7380c5110361d2be19c5c684b96a3266e))
* **api:** convert back to PIL after upscaling ([45d65d1](https://github.com/ssube/onnx-web/commit/45d65d1342d9d1b63f0aee06fc760c0bc9ebff40))
* **api:** convert image to numpy before upscaling ([1fe6fa9](https://github.com/ssube/onnx-web/commit/1fe6fa91fb051f9f82aa63e6b1e8d5d7c6a52587))
* **api:** copy checkpoints into correct location, handle more models ([353a655](https://github.com/ssube/onnx-web/commit/353a65513f273b5530a04fb55dc9ef85b4b57948))
* **api:** correct denoise max, add missing face strength param ([227056d](https://github.com/ssube/onnx-web/commit/227056d97686480a41b1fb5d8f282e26e0737956))
* **api:** correct name for kwargs ([9bff64c](https://github.com/ssube/onnx-web/commit/9bff64c7c9e1cad7440e6484550ff3a4006974bf))
* **api:** correct output paths, read strength from params ([a76793d](https://github.com/ssube/onnx-web/commit/a76793d1058fce99f7abfbe4414834b68bdce0f7))
* **api:** correct stub method name ([f493246](https://github.com/ssube/onnx-web/commit/f493246192ae33218ae9c0afb1516afded54cf73))
* **api:** dedupe models after removing extension ([c0ca7cf](https://github.com/ssube/onnx-web/commit/c0ca7cf62f85eb7a8c16d9d9ddcf8c2a39017d5e))
* **api:** enable tiling when fixing faces after upscaling ([ba3eff5](https://github.com/ssube/onnx-web/commit/ba3eff5c038e05be682eab126e1cbdc194ac5a14))
* **api:** explicitly delete pipeline results after saving ([dddadfc](https://github.com/ssube/onnx-web/commit/dddadfc9a256f1cd8ebbcd9313618b70a61dc7ce))
* **api:** filter platforms based on available providers (fixes [#69](https://github.com/ssube/onnx-web/issues/69)) ([c768cd8](https://github.com/ssube/onnx-web/commit/c768cd8f42d31787160cff5751b90f7cbbe2d63d))
* **api:** generate correct latents for non-square images ([86fb2ae](https://github.com/ssube/onnx-web/commit/86fb2ae28e2cdd2cd04d29a6095cdb0718d81cfb))
* **api:** get all server paths from environ ([4809e00](https://github.com/ssube/onnx-web/commit/4809e009820dc28768edc5e2242e869b9a281541))
* **api:** get ESRGAN/GFPGAN paths from server context, clean up test scripts ([120056f](https://github.com/ssube/onnx-web/commit/120056f878593989d83fdf0c5f8f59bcf8f8d0bc))
* **api:** get upscale params from request ([1f0c19a](https://github.com/ssube/onnx-web/commit/1f0c19af04e403f0ae78181544d0daddc4a967f6))
* **api:** handle parameters correctly when list of valid values is empty (fixes [#72](https://github.com/ssube/onnx-web/issues/72)) ([2921eba](https://github.com/ssube/onnx-web/commit/2921eba1f641891313daa9df7717f8c014296db5))
* **api:** include model scale ([dba6113](https://github.com/ssube/onnx-web/commit/dba6113c0983d1796b6550e7435bdb66897a9852))
* **api:** join globs to avoid py 3.10-only args ([0273dea](https://github.com/ssube/onnx-web/commit/0273dea2a68196f60a352da06aa10d7d14c3a322))
* **api:** leave pipelines on default device unless specified ([505cacf](https://github.com/ssube/onnx-web/commit/505cacfbc2a588f4890906268fed8e6062b9fa1c))
* **api:** load upscaling model from models dir ([806503c](https://github.com/ssube/onnx-web/commit/806503c7091f5c082bd65c24aa2a25bce48833c2))
* **api:** look up noise coordinates correctly ([1283bc3](https://github.com/ssube/onnx-web/commit/1283bc3d3f8ba40bd6c77ddb7bbe750b33456647))
* **api:** pass hardware platform to upscaling pipeline ([#77](https://github.com/ssube/onnx-web/issues/77)) ([f319e6a](https://github.com/ssube/onnx-web/commit/f319e6a49b7ad5f27e7410b6e77a51756782a116))
* **api:** pass image size to upscale job ([cf6a151](https://github.com/ssube/onnx-web/commit/cf6a15154890aa5180dc8826f83af04b7969893c))
* **api:** pass model to ONNX instances ([d406cd4](https://github.com/ssube/onnx-web/commit/d406cd4e99c92955c5e8fc5be2b2a3d4483d5e2d))
* **api:** pass txt2img dimensions in correct order ([be16f33](https://github.com/ssube/onnx-web/commit/be16f33151760ec64fccdf7b245cd0cd11e1000b))
* **api:** pass upscale params when creating RESRGAN ([091c4e6](https://github.com/ssube/onnx-web/commit/091c4e6109e5e276ac59228df0c091fc9e583477))
* **api:** premultiply noise before compositing ([b496e71](https://github.com/ssube/onnx-web/commit/b496e7121ce04e60b8126d5b6b59a91c51b84630))
* **api:** put conversion RNG on training device ([#67](https://github.com/ssube/onnx-web/issues/67)) ([abc1ae5](https://github.com/ssube/onnx-web/commit/abc1ae511245649e3c7498e1564f5330b72c71b0))
* **api:** report accurate image size when upscaling ([9a2e7ad](https://github.com/ssube/onnx-web/commit/9a2e7adfb89a96a91caeb2436c29873c9b70dc45))
* **api:** report accurate sizes ([4bf6875](https://github.com/ssube/onnx-web/commit/4bf68759d72b089082ddd490b110f91f0c4e5de9))
* **api:** resolve face correction model relative to model path ([5a01fe4](https://github.com/ssube/onnx-web/commit/5a01fe4cb0c40fac4bf7511a716f5be6badf8302))
* **api:** return structured error when image parameters are missing (fixes [#76](https://github.com/ssube/onnx-web/issues/76)) ([b62c7d3](https://github.com/ssube/onnx-web/commit/b62c7d3742a014f44ce199b78b6f70dc8e29844b))
* **api:** run GC after changing pipeline ([#58](https://github.com/ssube/onnx-web/issues/58)) ([4a3bb97](https://github.com/ssube/onnx-web/commit/4a3bb9734218ede79f632b208a54da510d01ea00))
* **api:** skip upscaling if scale is 1 ([b7c85aa](https://github.com/ssube/onnx-web/commit/b7c85aa51b36a3a01a369835629b745604515855))
* **api:** sort models without discarding ([b09feda](https://github.com/ssube/onnx-web/commit/b09feda47427a6a2d79c7006a5d3d6f1cab7bc8d))
* **api:** trim model names relative to model path ([4472a6f](https://github.com/ssube/onnx-web/commit/4472a6fd24fe59359009499b2f105d9ee2168c81))
* **api:** unload old model before loading next one ([9e26ee5](https://github.com/ssube/onnx-web/commit/9e26ee5b8541317c44d471a498261a2053628ddc))
* **api:** use correct base path for debug images ([634d2e8](https://github.com/ssube/onnx-web/commit/634d2e8ce63f57b108c09a8c2faa32274e4a5d1a))
* **api:** use correct coordinate system for outpainting ([a5d3ffc](https://github.com/ssube/onnx-web/commit/a5d3ffcc737e76ad8acacfded05927782737172c))
* **api:** use correct scale for background correction ([073ff8e](https://github.com/ssube/onnx-web/commit/073ff8e02f993ea3348a9564a94bda1a04ad514d))
* **api:** use training device when loading Real ESRGAN model ([#67](https://github.com/ssube/onnx-web/issues/67)) ([8c9c99e](https://github.com/ssube/onnx-web/commit/8c9c99eeb549e3748465f2cf8bbfdca1b62d7508))
* **api:** validate request params better, esp model path ([876b54a](https://github.com/ssube/onnx-web/commit/876b54a7a87d6610a1ea0223c5e315e73d6aa2f1))
* **build:** add cv2 deps to CPU image ([77d68bf](https://github.com/ssube/onnx-web/commit/77d68bf6ac7fe27b2357da90d4fd0356fa3dc8b9))
* **build:** add cv2 deps to CUDA and ROCm images ([52484e6](https://github.com/ssube/onnx-web/commit/52484e6e1f85973ec2eeb69cd64288340a814ad6))
* **build:** add launcher script and use for API images ([88f9b62](https://github.com/ssube/onnx-web/commit/88f9b624ec6bd844209e9aadc38b9dc23702d5c1))
* **build:** add params file to other images ([5286c4f](https://github.com/ssube/onnx-web/commit/5286c4f596e6ffc027107cfc707f4c9aa341f858))
* **build:** correct venv path in containers ([348a4e2](https://github.com/ssube/onnx-web/commit/348a4e2405529922b5db3b1b109f06aedb771d51))
* **build:** install prebuilt ROCm ORT ([5c026c4](https://github.com/ssube/onnx-web/commit/5c026c43d4336a527a8b318bb321532c2b4085b2))
* **build:** remove DirectML container until a package can be found ([c7bcc62](https://github.com/ssube/onnx-web/commit/c7bcc62a3ebb8ec8cbeaff82e60ac00d543a89c7))
* **build:** share layers from main image in feature branches ([455bfdd](https://github.com/ssube/onnx-web/commit/455bfddbc112fcc24b2f7dafee70912daebee511))
* **build:** use and cache venv for API job ([46e0fe2](https://github.com/ssube/onnx-web/commit/46e0fe2cf72795efd63c196fa0e1521973fe2fbe))
* **build:** use cached docker images to avoid rebuilding layers ([3f1bc0e](https://github.com/ssube/onnx-web/commit/3f1bc0e1b0fe64cc34d911a70e37fb3b4ac9e874))
* **docs:** add podman rocm command to admin guide ([fe9206c](https://github.com/ssube/onnx-web/commit/fe9206c894ec250e31d05347c1dc92bde22bc595))
* **docs:** add server admin guide, cross-link with user guide ([5d0aa60](https://github.com/ssube/onnx-web/commit/5d0aa60f1b6a3e28b681c6474230133b335df0a4))
* **docs:** list correct packages in readme, move errors to user guide ([b1e7ab0](https://github.com/ssube/onnx-web/commit/b1e7ab0a3e51baaddc276857c3a25f92d379f39c))
* **docs:** note that image parameters are not persisted when reloading ([700d31e](https://github.com/ssube/onnx-web/commit/700d31e2b87674f4063c4cc361d6e7e1bc81c6a5))
* **gui:** add server version indicator to settings ([7b49b55](https://github.com/ssube/onnx-web/commit/7b49b551d56ca51bb5a5b0658fbc545228b46a4e))
* **gui:** align background image when it is larger than canvas ([99982c6](https://github.com/ssube/onnx-web/commit/99982c6a1920f2d4683477ca37b92fb61398c311))
* **gui:** bump state version for new output path ([246aa3d](https://github.com/ssube/onnx-web/commit/246aa3dd15431ed9b6137f52b1b9403dca4613dd))
* **gui:** correct labels for Nvidia platforms ([0afd25f](https://github.com/ssube/onnx-web/commit/0afd25f25b69bebddc4ae0833cdf6d022e8f61dd))
* **gui:** correct menu state for additional models ([7cd0345](https://github.com/ssube/onnx-web/commit/7cd0345cd237f3541c40eb95f44d7d11c34d95ab))
* **gui:** correct state for face correction button ([3a3e92a](https://github.com/ssube/onnx-web/commit/3a3e92abb6e5a9609b12ff868fc9656de5dbdae1))
* **gui:** disable face correction strength slider when option is not selected ([7c60621](https://github.com/ssube/onnx-web/commit/7c60621fe2f0a2683604ec2c4f55574be1de85f1))
* **gui:** do not persist upscale image source ([dc84bec](https://github.com/ssube/onnx-web/commit/dc84becf693d6acb6b4d23c0059b02b8d7103d99))
* **gui:** draw single clicks and avoid blending mask with itself ([5e23f84](https://github.com/ssube/onnx-web/commit/5e23f84e5a20053f935e9be9eef9d87c028fc926))
* **gui:** emphasize the generate buttons, align fill color picker ([64663f5](https://github.com/ssube/onnx-web/commit/64663f5eeca8d2f37680c38b08a5db1adc405308))
* **gui:** make all image cards show at the default size ([20ed8f6](https://github.com/ssube/onnx-web/commit/20ed8f60dc0e8dde61627527025e10b12cf871f9))
* **gui:** mask canvas should not tile small images ([f1484dc](https://github.com/ssube/onnx-web/commit/f1484dc075fca73bf8a908d8c06b4ced945f0957))
* **gui:** only enable generate buttons after image sources exist ([#64](https://github.com/ssube/onnx-web/issues/64)) ([4898197](https://github.com/ssube/onnx-web/commit/4898197f7738c17c9ac19be9ccdbfa400e0f2939))
* **gui:** only send upscaling params when it is enabled ([5d2c22a](https://github.com/ssube/onnx-web/commit/5d2c22a64ae75b465bea763317bd4cb7ba5b02e6))
* **gui:** only show inpaint image once ([d6f2c62](https://github.com/ssube/onnx-web/commit/d6f2c626f67faba361fbdbb7ba64d0604f85e5dc))
* **gui:** populate empty select menus with first valid value ([0d1f236](https://github.com/ssube/onnx-web/commit/0d1f23609601f3c9aeab9268b9002a23a5bc6007))
* **gui:** prevent client image history from accumulating indefinitely ([df7bba4](https://github.com/ssube/onnx-web/commit/df7bba47dd892db9b590ebcf5e31c468f3c59e04))
* **gui:** read image size from its own field ([4d6560a](https://github.com/ssube/onnx-web/commit/4d6560aaba1a0964193ea5c8d72408dc4ed72296))
* **gui:** reduce rendering when adjusting image controls ([4615614](https://github.com/ssube/onnx-web/commit/4615614e5e22ee58006c2751a9b3725ebb6b4c70))
* **gui:** remove unused strength param from upscale ([d2c7fa9](https://github.com/ssube/onnx-web/commit/d2c7fa97e79267b4694556e0019c0abd63bd229a))
* **gui:** send blend strength for inpainting ([521fa88](https://github.com/ssube/onnx-web/commit/521fa88e0598196fda5ee28e65485e81adf08bda))
* **gui:** send upscale params ([5e5d748](https://github.com/ssube/onnx-web/commit/5e5d748c0b8f69eae27ce77e58b7f31d64918c4a))
* **gui:** set a reasonable timeout on the initial params fetch ([50fe17b](https://github.com/ssube/onnx-web/commit/50fe17bce15b597dcc53351969eb10ae9af71c72))
* **gui:** set initial fill color ([ce11165](https://github.com/ssube/onnx-web/commit/ce11165d0f72f2b63383bbaabf0e5dd9ff86e482))
* **gui:** swap toggle buttons for decent checkboxes ([46026d9](https://github.com/ssube/onnx-web/commit/46026d9aa0b22eed0addc861ff7d9c3fdadcf098))
* **gui:** use blur event on fill color for better perf ([b66cb8f](https://github.com/ssube/onnx-web/commit/b66cb8fcd6e9953ba939ab1d7b1775dd1df68151))
* move output path out of API route (for [#7](https://github.com/ssube/onnx-web/issues/7)) ([cb005d3](https://github.com/ssube/onnx-web/commit/cb005d3b5d6c5360ddbc3ad3ecd4f0cfcae486b4))
* send missing model params, add face strength control ([0e27cc8](https://github.com/ssube/onnx-web/commit/0e27cc830d8917ba083b255df667dacd17db0737))

## [0.4.0](https://github.com/ssube/onnx-web/compare/v0.3.0...v0.4.0) (2023-01-15)


### Features

* add gaussian multiply to mask filters ([40080ad](https://github.com/ssube/onnx-web/commit/40080ad46b4e0b846c92daf8e7e049bb171eaa55))
* add noise source with solid color ([5bb3f6c](https://github.com/ssube/onnx-web/commit/5bb3f6c558583fc7a135c36efb851a64646d7a57))
* **api:** add a mask filter to blend outpainting edges ([6c07d12](https://github.com/ssube/onnx-web/commit/6c07d124e0ce287b22baeaf15cba383f899d0adc))
* **api:** add endpoints for blend and noise settings ([a8f0a7a](https://github.com/ssube/onnx-web/commit/a8f0a7a7eb7e6f9ae62414c0dea034266aa8e3b3))
* **api:** add endpoints to serve GUI bundle ([88fde63](https://github.com/ssube/onnx-web/commit/88fde63e07f56a2312e38b8f87afb077368101f0))
* **api:** add helper to expand images for outpainting ([66dc532](https://github.com/ssube/onnx-web/commit/66dc5322d002c6fd2855f3594b3af39f30d86aad))
* **api:** add normal and uniform noise sources ([9376de8](https://github.com/ssube/onnx-web/commit/9376de880ec24a022e24a231e1b0314e3891f986))
* **api:** add original source and gaussian blur noise sources ([77470a6](https://github.com/ssube/onnx-web/commit/77470a610a240bdd38d5a5dc3b8842203ec48755))
* **api:** add parameters for noise source and blend op to inpaint ([e403980](https://github.com/ssube/onnx-web/commit/e403980a44cdec152f3eceae9320c3976717c5a7))
* **api:** add ready endpoint to check output status ([55e8b80](https://github.com/ssube/onnx-web/commit/55e8b800d288379fa52caa50e7d5e89cad1ab811))
* **api:** blend outpainting border with noise ([1e24018](https://github.com/ssube/onnx-web/commit/1e24018b577cc199011ea007b0371b16bd4ca349))
* **api:** limit simultaneous image workers (fixes [#15](https://github.com/ssube/onnx-web/issues/15)) ([e872eea](https://github.com/ssube/onnx-web/commit/e872eeacec63da96c30b22253d8bfc4f2be6f344))
* **api:** move txt2img into a background task ([0ef4d60](https://github.com/ssube/onnx-web/commit/0ef4d60b04fa56f7dd466f034973626a4b1df981))
* **api:** put all image pipelines on background tasks ([7e35b7b](https://github.com/ssube/onnx-web/commit/7e35b7b34f7e94488fdb14f6cb6bae3775aa9845))
* **api:** take outpainting dimensions from query params ([d9bbb9b](https://github.com/ssube/onnx-web/commit/d9bbb9bb5a92dbe933ed44feca395ebf441c331f))
* **build:** embed GUI bundle in API containers ([6eaf92a](https://github.com/ssube/onnx-web/commit/6eaf92a7486554c01837c8d364329dc10f76c3e7))
* **common:** add pod definitions for API ([e0589e2](https://github.com/ssube/onnx-web/commit/e0589e2809655d9e4ec1b2c82563b399d90dbc39))
* **gui:** add copy to source buttons to image card ([028d39c](https://github.com/ssube/onnx-web/commit/028d39c808b4c47eed060c94bc13dc4505d3dbd0))
* **gui:** add error message when server is not available (fixes [#48](https://github.com/ssube/onnx-web/issues/48)) ([65f2f4d](https://github.com/ssube/onnx-web/commit/65f2f4d953e48d5ed2294fbde06021dbc98eab1f))
* **gui:** add fill with white, toggle for outpainting ([0d53fdf](https://github.com/ssube/onnx-web/commit/0d53fdfe5308d2dbd98ee92763f18181f8e10050))
* **gui:** add menus for noise source and blend mode ([d3ad43b](https://github.com/ssube/onnx-web/commit/d3ad43bef4914df77a95e65ff353e3f7862df6e3))
* **gui:** add outpainting dimension controls to inpaint tab ([9e2921d](https://github.com/ssube/onnx-web/commit/9e2921d3de6bf782d0c25efd15122d09de199341))
* **gui:** add outpainting to API client and state ([6cd98bb](https://github.com/ssube/onnx-web/commit/6cd98bb96002f3177c08eeec4fa174b1cb7156ae))
* **gui:** add selector for mask filter ([2a30a04](https://github.com/ssube/onnx-web/commit/2a30a04e460089dadd7cb2cf167aab1a729ebf7f))
* **gui:** add slider for brush strength (fixes [#30](https://github.com/ssube/onnx-web/issues/30)) ([56ac6c6](https://github.com/ssube/onnx-web/commit/56ac6c6bc753f401077e2e6004169b482c6e39be))
* **gui:** add update instructions to error screen ([f00f36b](https://github.com/ssube/onnx-web/commit/f00f36b5b154b3683ab5ef859c142dacafa3bf8d))
* **gui:** get API root from query string if available ([f834997](https://github.com/ssube/onnx-web/commit/f83499763a510f1bc6984f9e33c997babd946a7b))
* **gui:** implement image polling on the client ([c36dadd](https://github.com/ssube/onnx-web/commit/c36daddf66f19dbeab58034b8b7c35b85eca5706))
* **gui:** produce noise based on source image histogram ([b24b1eb](https://github.com/ssube/onnx-web/commit/b24b1eb96190ee969f9aa6f9c8320a9c949b312b))
* **gui:** replace mask to grayscale with fill button ([3ad3299](https://github.com/ssube/onnx-web/commit/3ad3299734ea189f57ccebda2f35b0c8beecadb7))
* **gui:** save source and mask images while changing tabs ([4e82241](https://github.com/ssube/onnx-web/commit/4e82241491504412d45022dca3c045103104266e))
* **gui:** show mask brush preview (fixes [#39](https://github.com/ssube/onnx-web/issues/39)) ([a87dc45](https://github.com/ssube/onnx-web/commit/a87dc451fd10476a76cd23c0a1be57ef628f94f3))
* **gui:** show source behind mask with offscreen painting ([e915ab5](https://github.com/ssube/onnx-web/commit/e915ab5b8d204cdab53af9e798fcee74be790aa6))
* **gui:** split mask canvas into its own component ([1183216](https://github.com/ssube/onnx-web/commit/1183216a83f977309c75628cfc2ab9ff595e22a9))
* move API routes under prefix ([b477a99](https://github.com/ssube/onnx-web/commit/b477a9937ce11d3ce34a8165cc1f02da3bbd404a))


### Bug Fixes

* **api:** add missing origin argument to noise sources ([4675f89](https://github.com/ssube/onnx-web/commit/4675f89bb7c17153c4e6e4fc0d513ce6224ce0c5))
* **api:** add time to filenames (for [#55](https://github.com/ssube/onnx-web/issues/55)) ([16108ae](https://github.com/ssube/onnx-web/commit/16108ae1724debd8edba997999c467232a4aa741))
* **api:** always apply mask filter for inpainting ([e4020cf](https://github.com/ssube/onnx-web/commit/e4020cf3f6d0817ba04eb30f17c7cf1b587d31b7))
* **api:** blend source and noise in correct order ([eedea93](https://github.com/ssube/onnx-web/commit/eedea93adeab356422a349ff785fc1e30f157b69))
* **api:** clean up background jobs once they are ready (for [#55](https://github.com/ssube/onnx-web/issues/55)) ([9c93e16](https://github.com/ssube/onnx-web/commit/9c93e16698d2277026b76dd56068bcfd55de53cb))
* **api:** convert mask before blending source ([f142418](https://github.com/ssube/onnx-web/commit/f1424187077eceafbe5a49f1f80dfdb75726aa05))
* **api:** correct endpoint name for blend ops ([0ed11af](https://github.com/ssube/onnx-web/commit/0ed11af34bc81d40734b71393e93e8740e4ad4b1))
* **api:** correct type of provider in output path ([b1aca92](https://github.com/ssube/onnx-web/commit/b1aca928ab2b384689f5138235db34644083eb78))
* **api:** fill gaussian blur with noise first ([e2d17e1](https://github.com/ssube/onnx-web/commit/e2d17e18335cdb6d53b4abfa13e96ed94dd63bf0))
* **api:** get default params from file, enforce minimum params ([e8b580a](https://github.com/ssube/onnx-web/commit/e8b580a5deaa661009e2b7084a5db8fb30093611))
* **api:** include all parameters in output path ([e429baf](https://github.com/ssube/onnx-web/commit/e429bafeef04cb581a91ad2b3d21aa018f7cde63))
* **api:** limit outpainting using image size params ([34fa3f6](https://github.com/ssube/onnx-web/commit/34fa3f6341c1e239c6e57aa59238e284b2ace9ce))
* **api:** make all path vars relative to API dir ([360a151](https://github.com/ssube/onnx-web/commit/360a1518676af9ab7bc52de47bb5f0826b4dce23))
* **api:** reduce copies, fix function signatures ([f5ed77a](https://github.com/ssube/onnx-web/commit/f5ed77a349e1b6a785334a5fbb4b521174eec794))
* **api:** resize images after getting request params ([c29c92e](https://github.com/ssube/onnx-web/commit/c29c92ed90a46b1c7b335ca5b4b6b4e3adfd4585))
* **api:** restore inpainting without outpainting ([09c9b2c](https://github.com/ssube/onnx-web/commit/09c9b2c028363d7a03045abd905d67525fc9b41a))
* **api:** reuse results of blur modes ([ef06b45](https://github.com/ssube/onnx-web/commit/ef06b4559936d1ba8ef67c6ed64af966474883f5))
* **api:** send CORS more consistently ([fa82ac1](https://github.com/ssube/onnx-web/commit/fa82ac18ab9eb4dd3549b28061fba8642f4e69e8))
* **api:** set default mask filter to none, matching the client ([df6b071](https://github.com/ssube/onnx-web/commit/df6b07194b3a8dd2fa4bbc040946de26a2ab56b6))
* **api:** use correct param name for platform ([a3029c3](https://github.com/ssube/onnx-web/commit/a3029c30a603c36a3aeb09543e01c146e0720cce))
* **api:** use full-image compositing, write debug images to output dir ([081a96d](https://github.com/ssube/onnx-web/commit/081a96d536b50255f91f1597a66f1de15de3d126))
* **api:** use same parameter name as GUI for negative prompt ([dc33b7c](https://github.com/ssube/onnx-web/commit/dc33b7c8876a33bd2b5891268c24d5b262cac68d))
* **build:** correct path to pip requirements ([f46647c](https://github.com/ssube/onnx-web/commit/f46647cf6dd09550b87a4bb0be8eab7002e33648))
* **build:** correct paths for GUI bundle ([6c11f52](https://github.com/ssube/onnx-web/commit/6c11f52006b5251b9743ece6e70e285cf3ae3af0))
* **build:** install torch before other packages in CPU container ([e025dbb](https://github.com/ssube/onnx-web/commit/e025dbb87d40802736ae9d60d0601898b3eab6b7))
* **build:** install torch before other packages in CUDA container ([b60ccd5](https://github.com/ssube/onnx-web/commit/b60ccd506b93959b44b4e9b571c76034c93b6c5f))
* **docs:** add links to GUI client at GH pages ([47f9eb1](https://github.com/ssube/onnx-web/commit/47f9eb1391e43b0a5e59329853eda116745b0bc5))
* **docs:** note NodeJS dependency for building GUI, note about ONNX DML upgrading numpy ([74eaac3](https://github.com/ssube/onnx-web/commit/74eaac371dab335f503ee8757c98b3563fa799a3))
* **gui:** avoid saving mask while actively painting ([d5f8838](https://github.com/ssube/onnx-web/commit/d5f8838ceb5bc9bc344d326c4fc8714281014ceb))
* **gui:** break up state into slices for each tab ([689a6a1](https://github.com/ssube/onnx-web/commit/689a6a183fce968793626d262022bde629e19c04))
* **gui:** clear loading data after card leaves ([600ebae](https://github.com/ssube/onnx-web/commit/600ebae73aac30c7923f122b0652321765ac4753))
* **gui:** correct label for blur mode ([1c2c8b2](https://github.com/ssube/onnx-web/commit/1c2c8b2689c2155e27a5f5dcd190dea2ec1377bf))
* **gui:** disable react profiling in default bundle ([1bb0a3a](https://github.com/ssube/onnx-web/commit/1bb0a3aed85ccda33baad6ba62dd5e2f47369f0c))
* **gui:** do not persist loading flag ([dcfce81](https://github.com/ssube/onnx-web/commit/dcfce81fedffe7e67805f1822f0aec39687fedd4))
* **gui:** history is not iterable error when loading existing state ([7885bbf](https://github.com/ssube/onnx-web/commit/7885bbfbdd55b6d84e6dfcac50e3c365300e76f8))
* **gui:** improve API link example ([c09eb75](https://github.com/ssube/onnx-web/commit/c09eb75ab44fc18eca150e527a67bd254177b1d4))
* **gui:** improve performance while using image controls ([35e2e1d](https://github.com/ssube/onnx-web/commit/35e2e1dda643f5d44dd6a218535a4b85bc28c2e5))
* **gui:** invalidate loading query after mutations ([fa639ef](https://github.com/ssube/onnx-web/commit/fa639efff3fb9597d8214aa310a9760d0bd5a220))
* **gui:** load config relative to current page (fixes [#43](https://github.com/ssube/onnx-web/issues/43)) ([2e5c786](https://github.com/ssube/onnx-web/commit/2e5c7867a4cd644e40b1264ecf33b61182ca5b88))
* **gui:** prevent mask canvas from going into a save loop ([4dc915d](https://github.com/ssube/onnx-web/commit/4dc915d5c93dcce7ab6b3cc7035bd3c6fbb1500e))
* **gui:** restore delete image button ([68eb8eb](https://github.com/ssube/onnx-web/commit/68eb8eb9b2dd87fe17c9f462decbe0d3cf74cd60))
* **gui:** send CFG to API as decimal ([ef33301](https://github.com/ssube/onnx-web/commit/ef33301d6b1740736e991127b5030d17bbb6dd45))
* **gui:** send strength for img2img requests ([26a8ce7](https://github.com/ssube/onnx-web/commit/26a8ce7095be43fce9da7a2cb9c396b8b4186e27))

## [0.3.0](https://github.com/ssube/onnx-web/compare/v0.2.1...v0.3.0) (2023-01-12)


### Features

* **api:** add inpaint endpoint ([182ce6d](https://github.com/ssube/onnx-web/commit/182ce6de90361c2eb5d47861ab13570c8186db18))
* **api:** add params endpoint, defaults file ([03fd728](https://github.com/ssube/onnx-web/commit/03fd728ab049187274c7208f530eaa9755d6ae98))
* **api:** set up venv in CUDA container, add onnxruntime-gpu ([a3fe2ca](https://github.com/ssube/onnx-web/commit/a3fe2ca559e8c668b44220b41c4cdd2ada317e01))
* **build:** add github status jobs (fixes [#28](https://github.com/ssube/onnx-web/issues/28)) ([c8b2abc](https://github.com/ssube/onnx-web/commit/c8b2abc110059d71b400aec30e3746b11c1b342d))
* **build:** replace Buster image with CUDA-based Ubuntu ([07c18c2](https://github.com/ssube/onnx-web/commit/07c18c2245ec6f0063ed2278976c6704dd7f1404))
* **build:** upload pip package (fixes [#29](https://github.com/ssube/onnx-web/issues/29)) ([8452b73](https://github.com/ssube/onnx-web/commit/8452b7384cb4ee4a50b7887cf0fadbd6e2c9d684))
* **gui:** add inpaint call to API client ([15ab44f](https://github.com/ssube/onnx-web/commit/15ab44f2ad03fa691b8b9df6edc426d8f0cb71ce))
* **gui:** add inpaint tab and basic image mask component ([11b9295](https://github.com/ssube/onnx-web/commit/11b9295efc8ebe8edac445e25a92cba8e143baae))
* **gui:** display source images after selection ([f49fc96](https://github.com/ssube/onnx-web/commit/f49fc960c91ac786aacdb8662856c645da07d9bc))
* **gui:** implement mask painting, flood fill ([5e71292](https://github.com/ssube/onnx-web/commit/5e712923db6a898275b22d35d0015eec6ee567aa))
* **gui:** load and merge server params with config ([37efd51](https://github.com/ssube/onnx-web/commit/37efd513416b605c0d231432a88b292fc5275670))
* **gui:** persist image control state (fixes [#11](https://github.com/ssube/onnx-web/issues/11)) ([07fa81a](https://github.com/ssube/onnx-web/commit/07fa81a66bce91850093c9718ff4d4aed05aa2e6))
* **gui:** share image history between tabs, add setting to adjust length of history (fixes [#22](https://github.com/ssube/onnx-web/issues/22)) ([662bf42](https://github.com/ssube/onnx-web/commit/662bf42454c31df6f439d440f0f2cfe4d59397da))


### Bug Fixes

* **api:** add latents to inpaint, remove strength ([131cff6](https://github.com/ssube/onnx-web/commit/131cff6ba46dd35477333ee7998a4b304f89b4eb))
* **api:** allow decimal CFG ([2f3b5c0](https://github.com/ssube/onnx-web/commit/2f3b5c06c7cd6b0864bac94666f5aa9f02abe25f))
* **api:** omit negative prompt from pipeline ([9bb01cc](https://github.com/ssube/onnx-web/commit/9bb01cc01d47f39f3dda94bf228497f9cb70ded1))
* **api:** pass seed when calculating inpaint filenames ([d20fb91](https://github.com/ssube/onnx-web/commit/d20fb910739b24cb295e4d5c38a470f866774d5d))
* **api:** rename to avoid shadowing type ([48f42e5](https://github.com/ssube/onnx-web/commit/48f42e56fe1bcf495f7dfe4062330d83e486f664))
* **api:** use correct dict for type hints ([4abf760](https://github.com/ssube/onnx-web/commit/4abf760716fc3baef44da8da323d28939e386e97))
* **build:** add venv to CPU image ([362b732](https://github.com/ssube/onnx-web/commit/362b7327072aab7cc5ab3fcf50a3a46733db29cb))
* **build:** define template for curl jobs ([9f7e16b](https://github.com/ssube/onnx-web/commit/9f7e16b62f8b646d508314ab666e038dd5bc0dff))
* **build:** put Github status jobs in correct stages ([e704db5](https://github.com/ssube/onnx-web/commit/e704db50b1783cb6b24b32b58e2e49bc66c2a320))
* bump package versions to 0.2.1 ([760b162](https://github.com/ssube/onnx-web/commit/760b162a5578ff5c5a091e6281f55452b520d157))
* **docs:** describe how to install inpainting model ([2332c44](https://github.com/ssube/onnx-web/commit/2332c44cee05e1b98821041c6ca343cef606bea2))
* **gui:** allow decimal steps for CFG ([2ff4aee](https://github.com/ssube/onnx-web/commit/2ff4aee8873194b932e47d7c20dd8ea91396094c))
* **gui:** consistently load image controls from server params ([4a6458d](https://github.com/ssube/onnx-web/commit/4a6458d8f68e0ee262db1bbb94944d099152720a))
* **gui:** default mask brush to white/full replacement ([63758b0](https://github.com/ssube/onnx-web/commit/63758b0e21314de96f1f3f6a82ac475ea44cfcf6))
* **gui:** handle cancel from file input ([6b3c0fe](https://github.com/ssube/onnx-web/commit/6b3c0fea45e1ab8fc0ff249e125fa0c7d344e47c))
* **gui:** move seed control onto same line with cfg and steps ([1aa2181](https://github.com/ssube/onnx-web/commit/1aa2181d901b7ab86e3268fe20aac2aeeda50946))

### [0.2.1](https://github.com/ssube/onnx-web/compare/v0.2.0...v0.2.1) (2023-01-08)


### Bug Fixes

* **gui:** allow max safe seed constant ([477d89b](https://github.com/ssube/onnx-web/commit/477d89b6fc8ae61031f25573c9edaad84fcbf4d2))

## [0.2.0](https://github.com/ssube/onnx-web/compare/v0.1.0...v0.2.0) (2023-01-08)


### Features

* **api:** add image with pytorch CUDA ([a721008](https://github.com/ssube/onnx-web/commit/a721008d94d34f655d8749f9fc8fa9f801950427))
* **api:** add img2img endpoint ([09ce654](https://github.com/ssube/onnx-web/commit/09ce6546beac735369a4535646bb1362ff0eaac3))
* **api:** experimentally add CUDA provider and Nvidia platform ([8359bd5](https://github.com/ssube/onnx-web/commit/8359bd5b9969051dde4686223f602cdb77b15901))
* **api:** switch to package structure ([599e0ee](https://github.com/ssube/onnx-web/commit/599e0ee2d0df405062f660af5adae4aaa2fcdb3d))
* **api:** use hash of params as output filename ([e82379c](https://github.com/ssube/onnx-web/commit/e82379c61f7bfafaf102379cddd6fb7407dc99e2))
* **gui:** add download and delete buttons to image history ([e605c9f](https://github.com/ssube/onnx-web/commit/e605c9f66b4bbcf76b8b7ff113792c62087c2716))
* **gui:** add seed to image controls with random button (fixes [#16](https://github.com/ssube/onnx-web/issues/16)) ([4585792](https://github.com/ssube/onnx-web/commit/45857924928817fd0913af215cfed6be25903dcf))
* **gui:** add sliders to numeric inputs ([c5e0439](https://github.com/ssube/onnx-web/commit/c5e0439aa5994c2ca25828589178e3ad91c7d1cc))
* **gui:** add strength to img2img controls ([2328c5f](https://github.com/ssube/onnx-web/commit/2328c5f46a76d7d08067f9fc3a9611000cdda83f))
* **gui:** implement img2img tab ([98a8db1](https://github.com/ssube/onnx-web/commit/98a8db16a33f1e389ecf3cd9237cbdedd38d3b59))
* **gui:** put in a proper loading card ([3ec8f7c](https://github.com/ssube/onnx-web/commit/3ec8f7c2fcfc3b21d75f17b9ac31d424ce4fdd1a))
* implement negative prompts ([f2e2b20](https://github.com/ssube/onnx-web/commit/f2e2b20f18bc8ec1e452ae5ba7929f7ad7ad81f2))
* make additional schedulers available in UI ([93e53f6](https://github.com/ssube/onnx-web/commit/93e53f6dc3d312f348df156780d5f89712f1c087))


### Bug Fixes

* **api:** adjust output path for module structure ([c6662d1](https://github.com/ssube/onnx-web/commit/c6662d155da9176e799fd8979ed7be289982b593))
* **api:** clamp im2img strength ([282a7cf](https://github.com/ssube/onnx-web/commit/282a7cfa2af5ff0c02dd3a33f43858ca9f5c0b4d))
* **api:** defer first model load until first request ([0232c71](https://github.com/ssube/onnx-web/commit/0232c7180c16cc6a497b28be1d1381bd89e099c5))
* **api:** hash full range of seed values ([057eea2](https://github.com/ssube/onnx-web/commit/057eea25ef52de4f945f40a805ec2bb6cd46f9e6))
* **api:** keep strength as a float ([926f77b](https://github.com/ssube/onnx-web/commit/926f77b3b0758a16196392a505d5ca695e54422b))
* **api:** remove prompt from output name ([0d4c0a5](https://github.com/ssube/onnx-web/commit/0d4c0a5942a150cbb407a621f4a6c85eef1f41b6))
* **api:** seed rng for each image ([8c133e9](https://github.com/ssube/onnx-web/commit/8c133e9230eb0ecaefcabd3209d926603eea6903))
* **api:** typesafe param hashing ([f4ca6a0](https://github.com/ssube/onnx-web/commit/f4ca6a0547d5414da25c395b38ae628c97198964))
* **api:** update serve app name, add module entrypoint ([b59519c](https://github.com/ssube/onnx-web/commit/b59519cb7e1300e39c1e6bb7c704b701e7ffc36a))
* **build:** automatically push after tagging releases ([55d4354](https://github.com/ssube/onnx-web/commit/55d435489a2ef8d93c5082229c6bf6fd09d57201))
* **docs:** add section with known errors ([067a9b3](https://github.com/ssube/onnx-web/commit/067a9b39812f6ef9dae7255bcb8e28797aed0872))
* **docs:** begin clarifying packages for each environment ([#19](https://github.com/ssube/onnx-web/issues/19)) ([f99438e](https://github.com/ssube/onnx-web/commit/f99438e623891af122495af6cceefeb6991454a4))
* **docs:** include onnxruntime in list of common deps ([6442e68](https://github.com/ssube/onnx-web/commit/6442e68e676271a1d5ae1ddefac9e8995f48cb9d))
* **docs:** move ONNX DML package to Windows setup ([16c8b54](https://github.com/ssube/onnx-web/commit/16c8b54b1a558afe7299b7e970ddd599976b166c))
* **docs:** note cloning and fix test script name in readme ([9973bf1](https://github.com/ssube/onnx-web/commit/9973bf1bfc423194c353fbb2d50336d88dabc8de))
* **docs:** note python3 command and venv "name cmd" error in readme ([f119cb4](https://github.com/ssube/onnx-web/commit/f119cb41000784abb4ea62ea31487e4da37ed2b2))
* **gui:** add npm ignore ([8f7c1e7](https://github.com/ssube/onnx-web/commit/8f7c1e705b0329b3d537827564008033607c2e82))
* **gui:** add strings for more stable diffusion models, nvidia GPUs ([33fd5f1](https://github.com/ssube/onnx-web/commit/33fd5f1b532e76d8b0777a60e2815c5b49e1fcc5))
* **gui:** bind dev server to localhost by default, open binding in containers ([fc988e4](https://github.com/ssube/onnx-web/commit/fc988e4b5bc4d29a3a71121538f8d362490c3212))
* **gui:** disable img2img tab for now, consistent quotes in jsx ([de48450](https://github.com/ssube/onnx-web/commit/de48450730bf59177372f81e322a77754e1c8636))
* **gui:** handle decimal inputs correctly ([d5c4040](https://github.com/ssube/onnx-web/commit/d5c4040b073bbd94076ccce9f7212efe25958254))
* **gui:** key image history by order ([17e62fb](https://github.com/ssube/onnx-web/commit/17e62fb8e393bdccfc33577ba8584ac72e8bb5b1))
* **gui:** limit seed to safe values, prep for more settings ([3dfbb00](https://github.com/ssube/onnx-web/commit/3dfbb0061b02e8950d40abc2840622ac471de119))
* **gui:** send seed with img2img requests ([4894e0d](https://github.com/ssube/onnx-web/commit/4894e0ddd691cd642b7e2af91e439c603a5cc796))
* **gui:** switch txt2img to post on client ([e454203](https://github.com/ssube/onnx-web/commit/e4542031c4262b1a12be639e5bad747763eb3e8b))

## 0.1.0 (2023-01-06)


### Features

* add model and output directories 41d93c9
* add vscode workspace with subdir roots 4088bf4
* **api:** add endpoint to get previous outputs 50221af
* **api:** add endpoint to list models 4cb6ce8
* **api:** add endpoints to list platforms/accelerators and pipeline schedulers c70728d
* **api:** add introspection to index endpoint 8c985e9
* **api:** add option to switch between AMD hardware and CPU software rendering 668e46a
* **api:** add remaining inputs params to response bbd0e93
* **api:** cache pipeline between requests (part of [#5](undefined/undefined/undefined/issues/5)) 82e7fbf
* **api:** cache pipeline when changing scheduler, make txt2img logging more verbose cab13f6
* **build:** add basic CI c6579b7
* **build:** add basic python CI 8d3ca31
* **build:** add bundle to JS build, add API image jobs 6d560af
* **build:** add git multi-push target 917f6ce
* **build:** add nginx-based GUI images 5e9890f
* **build:** add release target ce759ca
* **build:** add root makefile and common targets 3be185d
* **build:** put image base OS at the end of the image tag 7b8f96f
* **docs:** add readme note about monorepo paths b20f200
* **docs:** notes about bundling UI, ONNX_WEB paths for server b22f50f
* **gui:** add labels to dropdowns d3f4607
* **gui:** get default params and prompt from config 561fcb4
* **gui:** get platforms and schedulers from server ce06837
* **gui:** load models from server 46e047b
* **gui:** make an image card component showing params b5d67b4
* **gui:** move platform selector outside of mode tabs 45a097a
* **gui:** set up react-query for better request handling b13d46c
* **gui:** show recent image history 764a097
* **image:** add preliminary container files 8f77bb8
* return json struct with output path instead of image data, load images from outputs endpoint 4668841


### Bug Fixes

* **api:** add numpy version restriction to requirements ca0da31
* **api:** add recommended venv name to git ignore 5a82f39
* **api:** improve image layer order 5482978
* **api:** match model and output paths from readme c036c6f
* **api:** match model path from readme 6004f76
* **build:** add base OS to image tags 11e61d0
* **build:** add stub API unit test 1cd3bd8
* **build:** correct base OS for GUI nginx image 91c6f47
* **build:** correct output filename for JS ep 9a10f52
* **build:** install coverage in python build 32c7701
* **build:** make image suffix part of the name 150a81e
* **build:** pull GUI images from hub 03362f3
* **build:** remove bash shebang e900479
* **build:** remove unittest from CI install list, add coverage output to git ignore 16b7bde
* **build:** run GUI image build in correct subdir 86a3968
* **build:** use correct path for image script 7dcb0d1
* **build:** use CPU version of pytorch in hypothetical alpine API image af40bff
* **docs:** add numpy to install list 7f90461
* **docs:** add section about custom config a0172f8
* **docs:** describe current features 33eb7cd
* **docs:** explain running containers 08270f2
* **docs:** note DirectML for Windows 9a5ec9c
* **docs:** note numpy version requirements in readme 1f26858
* **docs:** update readme to use nginx image for GUI 37253cc
* **gui:** copy bundle to correct path within nginx image 225f5f1
* **gui:** correct paths in nginx image 7f23711
* **gui:** dedupe query lists into a component 1c9eed3
* **gui:** make more space for scheduler in image card 7c08c4b
* **gui:** prevent dropdown border from overlapping with label 26e886b
* **gui:** remove paragraph wrapping image details 0376499
* **gui:** run dev server from node image ee6cf50
* **gui:** show parameters in a grid in the image card a950343
* **gui:** switch default API host to localhost 5f1bb4a
* **gui:** switch default platform to AMD 29c4908
* **lint:** style issues in gui cd36172
