Este repositório visa armazenar testes e documentações para servir de preparatório para a Certificação Laravel. <br>
Para inscrever-se na certificação, acesse o link: https://certification.laravel.com/ <br>

Abaixo os temas que devem ser estudados, cada tema terá um diretório com conteúdos e referências. <br>
Provavelmente você terá dificuldade em seguir isso se não tiver o mínimo de experiência com algum Framework PHP. <br>

Se, assim como eu, sua intenção não é ter um Certificado Laravel mas sim ter mais conhecimento para desenvolver com mais qualidade e agilidade, esse repositório também servirá para você.

Atenção! Isso está em construção ainda não vá com tanta sede ao pote. <br> 
Coisas boas não são feitas do dia pra noite.

## PHP
Version 7.1+<br>
Composer<br>
Autoloading Standards<br>

## Architecture
Request Lifecycle<br>
Service Container Binding and Resolution<br>
Service Providers<br>
Facades<br>
HTTP Verbs<br>

## [Routing](/Manual/Routing/readme.md)
Redirects<br>
Route Parameters<br>
Named Routes<br>
Route Groups<br>
Route Model Binding<br>
Rate Limiting<br>

## Middleware
Defining / Registering Middleware<br>
Middleware Parameters<br>

## Controllers
Defining Controllers<br>
Controller Namespacing<br>
Single Action Controllers<br>
Middleware<br>
Resource Controllers<br>
Dependency Injection<br>
Route Caching<br>

## Requests
PSR-7 Requests<br>
Request Path and Method<br>
Retrieving Input<br>
Uploaded Files<br>
Proxy Configuration<br>

## Responses
Attaching Headers / Cookies<br>
Encryption<br>
Redirects<br>
Flash Data<br>
Response Types<br>
Response Macros<br>

## Views
Creating Views<br>
Passing Data to Views<br>
View Composer<br>

## URL Generation
Named Routes<br>
Controller Actions<br>
Default Values<br>

## Sessions
Configuration<br>
Storing Data<br>
Retrieving Data<br>
Deleting Data<br>
Flash Data<br>
Custom Drivers<br>
 <br>

## Validation
Form Requests<br>
Manually Creating Validators<br>
Error Messages<br>
Validation Rules<br>
Custom Rules<br>

## Logging
Configuration<br>
Writing to Specific Channels<br>
Creating Custom Channels<br>

## Frontend
Blade Templating<br>
Localization<br>
Asset Compilation<br>

## Security
Authentication<br>
Authorization<br>
Encryption / Hashing<br>
CSRF Protection<br>
XSS Protection<br>

## Artisan Console
Generating Commands<br>
Command I/O<br>
Registering Commands<br>
Executing Commands<br>

## Websockets
Broadcasting Events<br>
Receiving Events<br>
Broadcasting Channels<br>
Presence Channels<br>
Client Events<br>

## Caching
Drivers / Configuration<br>
Storing Items<br>
Retrieving Items<br>
Cache Tags<br>
Creating Custom Drivers<br>

## Collections
Creating / Extending Collections<br>
Collection Methods<br>
Higher-order Messages<br>

## Events
Registering Events / Listeners<br>
Queued Listeners<br>
Dispatching Events<br>
Subscribing to Events<br>

## File Storage
Configuration / Drivers<br>
Storing / Retrieving Files<br>
Custom Filesystems<br>

## Helper Methods
Arrays / Objects<br>
Paths<br>
Strings<br>
URLs<br>
Misc<br>

## Mail
Drivers / Configuration<br>
Generating Mailables<br>
Writing Mail<br>
Sending Mail<br>
Markdown<br>
Local Development<br>

## Notifications
Creating Notifications<br>
Sending Notifications<br>
Mail Notifications<br>
Markdown<br>
Database Notifications<br>
Broadcast Notifications<br>
SMS Notifications<br>
Slack Notifications<br>
Custom Channels<br>

## Package Development
Discovery<br>
Service Providers<br>
Resources<br>
Commands<br>
Assets<br>
Publishing File Groups<br>

## Queues
Drivers / Configurations<br>
Creating / Dispatching Jobs<br>
Running Queue Workers<br>
Supervisor<br>
Handling Failed Jobs<br>

## Task Scheduling
Scheduling Artisan Commands<br>
Scheduling Queue Jobs<br>
Scheduling Shell Commands<br>
Time Zones<br>
Preventing Task Overlaps<br>
Maintenance Mode<br>

## Database
Query Builder<br>
Pagination<br>
Migrations<br>
Seeding<br>

## Eloquent ORM
Conventions<br>
Relationships<br>
Eloquent Collections<br>
Mutators / Accessors<br>
API Resources<br>
Serialization<br>
Scopes<br>

## Testing
Creating / Running Tests<br>
HTTP Tests<br>
Session / Authentication<br>
Testing File Uploads<br>
Available Assertions<br>
Browser Tests / Dusk<br>
Data Factories<br>
Fakes / Mocking<br>
