# Solution generated by Gemini on 11/6/2024
# May not be the best solution, not even "a" solution...
# Use it with caution <https://gemini.google.com/faq#coding>

# https://github.com/squillero/computer-sciences
# Free for personal or classroom use; see 'LICENSE' for details.

from datetime import datetime, timedelta
import pytz


def parse_event(line):
    """Parses an event line from the file."""
    time_str, tz_name, description = line.strip().split(": ", 2)
    time = datetime.strptime(time_str, "%H:%M").time()
    is_yesterday, is_tomorrow = False, False
    if time_str.startswith("yesterday"):
        time -= timedelta(days=1)
        is_yesterday = True
    elif time_str.startswith("tomorrow"):
        time += timedelta(days=1)
        is_tomorrow = True
    return time, tz_name, description, is_yesterday, is_tomorrow


def parse_timezones(filename):
    """Parses the timezones file into a dictionary."""
    timezones = {}
    with open(filename) as f:
        for line in f:
            name, offset, desc = line.strip().split(": ")
            offset = pytz.FixedOffset(int(offset[3:]) * (-1 if offset[0] == "-" else 1))
            if ":" in offset:
                offset += timedelta(minutes=int(offset[5:]))
            timezones[name] = pytz.timezone(offset), desc
    return timezones


def main():
    # Parse timezones
    timezones = parse_timezones("timezones.lst")

    # Parse events
    events = []
    with open("today.lst") as f:
        for line in f:
            time, tz_name, desc, is_yesterday, is_tomorrow = parse_event(line)
            timezone, _ = timezones[tz_name]
            event_time = timezone.localize(datetime.combine(datetime.now().date(), time))
            events.append((event_time, desc, is_yesterday, is_tomorrow))

    # Sort events by UTC time
    events.sort()

    # Print sorted events
    for event_time, desc, is_yesterday, is_tomorrow in events:
        if is_yesterday:
            print(f"yesterday {event_time.strftime('%H:%M')}: {desc}")
        elif is_tomorrow:
            print(f"tomorrow {event_time.strftime('%H:%M')}: {desc}")
        else:
            print(f"{event_time.strftime('%H:%M')}: {desc} ({timezones[tz_name][1]})")


if __name__ == "__main__":
    main()
