Compilers and Integrated Development Environments (IDEs)
========================================================

## Compilers

The course focuses on the C language. The reference is **C11** ([ISO/IEC 9899:2011](https://en.wikipedia.org/wiki/C11_(C_standard_revision))), as the **C18** ([ISO/IEC 9899:2018](https://en.wikipedia.org/wiki/C18_(C_standard_revision))) did not introduce new features. Valid compilers include recent [gcc](https://gcc.gnu.org/) and [Clang](https://clang.llvm.org/).

## IDEs

### Code::Blocks

* Site: [http://codeblocks.org/](http://codeblocks.org/).

Free, open source, cross platform IDE for C, C++, and Fortran. Some setup packages with *mingw* in their name include a *gcc* compiler, but a compiler could also be added at a later time.

Code::Blocks runs on most Windows and Linux boxes, but several problems have been reported on Mac's, especially the newest ones. Available in all Politecnico labs.

### CodeLite

* Site: [http://www.codelite.org/](http://www.codelite.org/).

Free, open source, cross platform IDE for C, C++, PHP, and Node.js. Compiler and debugger must be downloaded separately.

CodeLite runs smoothly with all recent Windows (7, 8, 10), Mac OS X, Linux. Not available in Politecnico labs.

### XCode

* Site: [https://developer.apple.com/xcode/](https://developer.apple.com/xcode/)

The official IDE from Apple, available for free. Extremely powerful, with tons of features that will not be used in the course. It only works on Mac computers.

**Note**: Installing XCode could be required to get a working C compiler on a Mac box, even if you plan to use CodeLite.

### VisualStudio

* Site: [https://www.visualstudio.com/](https://www.visualstudio.com/)

The official IDE from Microsoft. Available in a multitude of versions, some free. Extremely powerful, with tons of features that will not be used in the course. It only works with Microsoft OS. Double check whether the compiler is fully compliant with the ISO/IEC standard.

### Online IDEs

* Site: [https://www.codechef.com/ide](https://www.codechef.com/ide)
* Site: [https://www.tutorialspoint.com/compile_c_online.php](https://www.tutorialspoint.com/compile_c_online.php)

Several sites are offering free, online IDEs for C. They may be useful to check code on-the-fly from a portable device.
