// Copyright 2020 The SQLFlow Authors. All rights reserved.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package testdata

// ODPSSparseColumnSQL is .sql format data sample to test odps training with sparse samples.
var ODPSSparseColumnSQL = `DROP TABLE IF EXISTS sparse_column_test;
CREATE TABLE sparse_column_test (
       id int,
       user_id  bigint,
       l int,
	   user_space_stat string,
	   user_behavior_stat string,
	   space_stat string,
	   deep_id string);
INSERT INTO sparse_column_test VALUES
("1","2088702753661540","0","3,5,10,21,28,31,36,40,47,50,56,64,73,75,82,87,90,94,109,111,118,125,131,143,151,158,161,168,178,188,193,199,203,212,216,221,228,235,243,251,259,261,273,279,284,294,301,304","5,14,24,34,38,43,50,62,67,73,87,96,105,115,121,131,138,146,156,160,170,182,186,199,206,214,218,228,238,244,250,260,270,273,286,294,297,305,313,319,329,333,342,350,360,369,376,383,392,399,408,415,420,423,430,438,445,454,464,470,478,490,500,508","3,15,25,30,41,43,58,67,75,77,92,101,110,119,128,137,146,155,163,171,173,188,197,205,210,223,225,233,248,257,259,273,282,286,291,302,310,317,326,338,347,357,366,375,379,391,400,408,417","13,420,429,439,443,449,460,470,479,487,504,508,546,560,582,916,926,934,951,960,969,972,981,985,999,1002,1007,1010,1021,1471,1476,1484,1496,1498,1508,1513,1527,1537,1548,1553,1567,1577,1583,1592,1605,1614,1617,1626,1636,1651,1656,1671,1675,1686,1699,1700,1704,1715,1722,1736,1742,1753,1761,1772,1778,1787,1804,1814,1820,1826,1843,1849,1854,1864,1868,1877,1883,1893,1910,1913,1927,1932,1947,1951,1967,1970,1982,1994,2005,2015,2019,2062,2064,2084,2111,2122,2124,2133,2142,2158,2162,2194,2208,2218,2234,2241,2257,2291,2303,2310,2314,2322,2332,2342,2352,2367,2371,2380,2398,2403,2417,2420,2462,2474,2477,2480,2489,2499,2513,2516,2524,2533,2536,2546,2558,2570,2598,2608,2618,2628,2634,2641,2651,2658,2667,2670,2679,2683,2686,2690,2693,2697,2705,2711,2714,2721,2725,2728,2740,2886,2891,2892,2896,2900,2903,2908,2910,2916,2919,2922,2924,2928,2931,2934,2943,2953,2954,2968,2970,2973,2978,2980,2989,2994,2998,3000,3008,3011,3014,3018,3020,3027,3040,3048,3059,3062,3070,3081,3086,3092,3102,3111,3116,3126,3136,3147,3150,3157,3160,3169,3177,3185,3187,3188,3193,3214,3215,3220,3227,3236,3245,3254,3263,3275,3280,3291,3296,3302,3310,3316,3317,3326,3332,3341,3348,3351,3359,3367,3374,3382,3385,3390,3399,3406,3408,3409,3418,3424,3433,3442,3448,3457,3466,3467,3476,3485,3492,3495,3497,3503,3506,3508,3513,3521,3527,3536,3541,3546,3554,3558,3563,3569,3575,3582,3606,3611,3617,3622,3651,3691,3702,3731,3748,3811,3906,5038,5043,5051,5057,5065,5071,5077,5088,5092,5097,5103,5111,5116,5125,5132,5136,5146,5149,5160,5164,5169,5181,5185,5193,5197,5206,5211,5217,5228,5231,5239,5247,5254,5262,5267,5275,5285,5291,5299,5312,5314,5321,5329,5337,5342,5348,5356,5369,5372,5380,5388,5397,5402,5410,5418,5430,5434,5441,5447,5455,5468,5471,5479,5486,5492,5500,5508,5516,5528,5532,5539,5550,5555,5567,5574,5579,5587,5595,5603,5608,5619,5624,5630,5636,5643,5654,5657,5663,5673,5678,5684,5690,5698,5702,5715,5723,5726,5735,5745,5748,5755,5768,5770,5778,5786,5792,5800,5813,5816,5823,5834,5838,5846,5851,5862,5871,5874,5881,5887,5892,5902,5912,5915,5922,5931,5936,5942,5950,5961,5966,5975,5980,5988,5996,6001,6009,6015,6022,6029,6034,6040,6048,6056,6063,6070,6078,6086,6094,6104,6110,6118,6123,6133,6139,6145,6152,6164,6169,6174,6182,6189,6197,6204,6212,6223,6229,6238,6246,6249,6258,6266,6271,6277,6287,6292,6300,6308,6315,6322,6327,6335,6343,6349,6357,6365,6375,6381,6394,6402,6407,6413,6419,6432,6435,6448,6451,6461,6465,6472,6478,6491,6494,6502,6508,6516,6525,6529,6540,6551,6553,6567,6569,6575,6588,6590,6596,6609,6612,6619,6627,6635,6643,6651,6659,6670,6675,6681,6687,6694,6702,6709,6713,6721,6731,6739,6744,6751,6759,6767,6775,6783,6795,6799,6804,6814,6819,6832,6835,6843,6853,6860,6866,6870,6875,6882,6887,6895,6915,6918,6932,6940,6948,6955,6963,6971,6979,6985,6992,7000,7006,7012,7019,7031,7039,7040,7047,7055,7062,7070,7085,7093,7099,7104,7119,7120,7127,7151,7171,7176,7180,7188,7192,7199,7205,7213,7217,7221,7228,7233,7240,7246,7253,7260,7264,7268,7281,7289,7305,7309,7317,7322,7326,7332,7350,7354,7362,7366,7370,7377,7404,7409,7416,7420,7422,7428,7435,7440,7446,7452,7458,7465,7470,7475,7480,7484,7493,7499,7514,7520,7526,7532,7577,7583,7621,7627,7641,7645,7650,7656,7714,7719,7725,7729,7769,7775,7783,7789,7793,7798,7826,7832,7875,7880,7937,7944,8024,8031,8122,8124,8167,8174,8180,8186,8193,8203,8206,8212,8234,8244,8269,8287,8306,8317,8327,8369,8384,8496,8550,8578,8598,9450,9456,9464,9474,9481,9489,9497,9504,9512,9520,9527,9537,9543,9551,9563,9570,9575,9582,9590,9597,9609,9613,9621,9628,9636,9644,9651,9658,9666,9674,9687,9692,9697,9705,9712,9723,9730,9736,9749,9753,9764,9769,9773,9781,9792,9797,9810,9819,9821,9829,9838,9845,9852,9860,9868,9880,9884,9892,9900,9909,9914,9927,9930,9938,9946,9958,9966,9971,9978,9986,9994,10003,10010,10018,10026,10036,10042,10054,10058,10068,10073,10081,10088,10097,10102,10110,10119,10126,10133,10141,10152,10157,10166,10177,10180,10188,10196,10203,10216,10219,10227,10235,10243,10251,10256,10269,10272,10282,10287,10294,10302,10310,10325,10327,10335,10343,10355,10359,10367,10375,10381,10389,10397,10405,10412,10420,10428,10436,10443,10451,10459,10467,10474,10482,10495,10498,10509,10514,10521,10532,10539,10544,10552,10559,10568,10573,10581,10593,10601,10604,10612,10619,10627,10635,10640,10653,10656,10668,10672,10680,10686,10691,10698,10706,10714,10721,10734,10737,10744,10752,10763,10767,10775,10785,10794,10803,10806,10814,10822,10830,10838,10845,10857,10866,10869,10877,10885,10892,10903,10907,10915,10922,10930,10937,10944,10952,10966,10967,10975,10983,10991,10999,11007,11013,11025,11035,11037,11050,11057,11061,11067,11073,11082,11089,11102,11106,11117,11120,11131,11138,11146,11149,11156,11163,11170,11176,11188,11192,11199,11211,11214,11222,11230,11242,11250,11254,11262,11267,11274,11285,11291,11296,11307,11312,11325,11328,11339,11343,11351,11360,11367,11375,11379,11383,11390,11396,11404,11410,11418,11433,11436,11441,11449,11457,11464,11472,11480,11488,11497,11503,11510,11518,11524,11531,11539,11552,11560,11561,11568,11571,11579,11587,11594,11601,11609,11617,11623,11628,11643,11644,11651,11658,11660,11669,11676,11683,11695,11701,11716,11720,11736,11737,11746,11756,11765,11775,11779,11787,11797,11807,11816,11826,11834,11843,11851,11863,11869,11878,11887,11895,11912,11913,11928,11930,11939,11949,11953,11962,11973,11980,11988,11999,12006,12016,12025,12399,12404,12415,12423,12439,12449,12457,12461,12471,12482,12488,12495,12506,12512,12522,12526,12537,12548,12556,12563,12571,12575,12585,12593,12601,12611,12621,12626,12635,12644,12653,12663,12669,12677,12690,12696,12705,12715,12725,12731,12741,12748,12759,12764,12773,12783,12789,12797,12803,12814,12821,12827,12839,12848,12858,12865,12874,12883,12893,12899,12910,12919,12925,12933,12938,12948,12956,12967,12972,12984,12989,12998,13004,13017,13027,13034,13039,13052,13054,13065,13073,13081,13088,13100,13105,13111,13118,13126,13134,13145,13154,13162,13169,13181,13184,13191,13202,13211,13216,13229,13237,13243,13251,13259,13268,13278,13286,13295,13303,13313,13321,13329,13338,13348,13354,13362,13373,13379,13385,13397,13404,13412,13419,13430,13438,13446,13452,13462,13470,13479,13487,13492,13499,13511,13519,13527,13536,13543,13553,13564,13570,13578,13585,13593,13602,13611,13621,13628,13637,13643,13655,13657,13666,13677,13687,13693,13699,13705,13716,13728,13735,13740,13746,13753,13764,13772,13783,13792,13801,13810,13817,13828,13834,13845,13853,13858,13872,13882,13886,13895,13905,13913,13918,13927,13939,13944,13955,13963,13974,13980,13989,13995,14006,14015,14024,14030,14038,14051,14056,14060,14072,14078,14083,14094,14102,14113,14122,14128,14135,14140,14147,14156,14167,14176,14182,14190,14200,14211,14214,14224,14235,14238,14248,14256,14266,14274,14283,14292,14303,14307,14316,14322,14329,14340,14347,14356,14363,14373,14382,14391,14400,14410,14415,14426,14434,14443,14448,14456,14463,14475,14484,14493,14498,14511,14518,14525,14533,14544,14546,14559,14563,14575,14582,14593,14600,14605,14646,14665,14673,14690,14706,14745,14765,14774,14789,14823,14866,14877,14883,14898,14901,14921,14931,14938,14942,14958,14976,15013"),
("2","2088612358484070","0","1,5,9,18,23,31,36,40,44,50,55,59,68,75,82,87,90,94,105,111,115,122,128,138,146,154,160,168,173,182,190,196,201,207,216,218,225,230,239,246,254,261,270,276,283,289,298,304","4,13,24,32,39,43,50,61,67,75,87,96,103,113,120,130,138,147,155,160,171,180,186,198,205,213,219,228,239,243,251,259,270,275,287,293,299,305,312,319,328,333,342,349,360,369,375,383,392,399,407,414,420,423,431,438,445,455,463,471,478,488,499,508","3,15,24,30,40,44,57,66,75,79,91,100,109,118,127,136,145,154,163,170,175,187,196,205,210,222,227,235,247,256,260,273,281,287,293,303,310,318,327,338,347,356,365,374,379,387,399,408,416","290,421,429,440,443,449,460,471,480,487,506,528,547,560,582,916,928,934,951,962,970,971,978,984,994,1002,1008,1010,1021,1471,1474,1483,1494,1498,1508,1513,1525,1534,1546,1552,1564,1574,1581,1589,1602,1608,1617,1630,1637,1646,1655,1665,1676,1685,1695,1700,1703,1712,1722,1733,1742,1752,1761,1771,1778,1787,1801,1812,1817,1826,1835,1845,1854,1863,1867,1876,1883,1893,1902,1912,1925,1932,1943,1951,1962,1970,1979,1990,1998,2010,2019,2056,2064,2106,2111,2121,2124,2133,2142,2153,2162,2182,2212,2218,2228,2238,2252,2286,2295,2306,2314,2322,2333,2347,2353,2366,2374,2380,2390,2401,2414,2420,2460,2470,2476,2480,2488,2496,2507,2515,2523,2533,2536,2545,2551,2562,2598,2608,2618,2627,2633,2641,2651,2658,2667,2670,2679,2682,2685,2690,2693,2696,2705,2711,2714,2719,2725,2728,2731,2886,2889,2892,2896,2900,2903,2907,2910,2916,2919,2922,2924,2928,2931,2934,2942,2951,2954,2967,2970,2973,2978,2980,2988,2994,2996,3000,3008,3011,3014,3017,3020,3028,3039,3047,3057,3063,3070,3078,3092,3103,3110,3117,3127,3137,3145,3150,3157,3160,3169,3177,3184,3186,3188,3193,3214,3215,3219,3227,3236,3245,3254,3263,3272,3280,3289,3296,3302,3310,3315,3317,3326,3332,3341,3348,3351,3359,3367,3374,3382,3385,3390,3399,3406,3407,3409,3418,3424,3433,3442,3448,3457,3466,3467,3476,3485,3492,3495,3497,3503,3506,3508,3513,3521,3527,3537,3547,3553,3561,3563,3570,3576,3581,3587,3623,3673,3704,3732,3891,3975,3986,4123,5035,5043,5051,5057,5065,5071,5077,5084,5092,5097,5103,5110,5116,5124,5128,5136,5142,5149,5155,5163,5169,5177,5185,5193,5197,5205,5210,5216,5223,5231,5239,5247,5254,5260,5267,5275,5283,5291,5299,5307,5314,5321,5329,5337,5342,5348,5356,5364,5372,5380,5388,5396,5402,5410,5418,5425,5433,5440,5447,5455,5463,5471,5479,5486,5492,5500,5508,5516,5524,5532,5539,5547,5555,5563,5571,5579,5587,5595,5603,5608,5616,5624,5630,5636,5641,5649,5657,5663,5671,5678,5684,5690,5696,5702,5710,5718,5726,5734,5740,5748,5755,5763,5770,5778,5785,5792,5800,5808,5816,5823,5829,5837,5843,5851,5859,5866,5874,5881,5887,5892,5900,5907,5915,5922,5929,5936,5942,5950,5958,5966,5974,5980,5988,5996,6001,6009,6015,6022,6029,6034,6040,6048,6056,6063,6070,6078,6086,6094,6099,6107,6115,6123,6131,6139,6145,6152,6160,6168,6174,6182,6189,6197,6204,6212,6220,6229,6233,6241,6249,6255,6263,6271,6277,6285,6292,6300,6308,6315,6322,6327,6335,6341,6349,6357,6365,6373,6381,6389,6397,6405,6413,6419,6427,6435,6443,6451,6457,6465,6472,6478,6486,6494,6501,6508,6516,6522,6529,6537,6545,6553,6561,6569,6575,6582,6590,6596,6604,6612,6619,6627,6635,6643,6651,6659,6666,6674,6681,6687,6694,6701,6708,6713,6721,6728,6736,6744,6751,6759,6767,6775,6783,6791,6799,6804,6812,6819,6827,6835,6843,6851,6860,6866,6870,6875,6882,6887,6895,6908,6916,6932,6940,6948,6955,6963,6971,6977,6983,6990,6998,7006,7012,7019,7024,7032,7040,7047,7055,7062,7070,7085,7093,7099,7104,7112,7120,7127,7150,7171,7176,7180,7187,7192,7200,7204,7211,7240,7247,7254,7260,7265,7269,7273,7277,7278,7285,7305,7310,7317,7323,7327,7332,7351,7355,7358,7363,7369,7377,7402,7407,7446,7451,7460,7467,7470,7475,7493,7499,7504,7510,7513,7518,7524,7529,7595,7602,7622,7628,7638,7644,7662,7667,7678,7684,7727,7731,7734,7739,7749,7754,7784,7790,7838,7844,7873,7879,8161,8165,8173,8179,8186,8202,8212,8266,8277,8344,8366,9448,9456,9464,9473,9481,9489,9497,9504,9512,9519,9527,9535,9543,9551,9559,9567,9575,9582,9590,9597,9605,9613,9621,9628,9636,9644,9651,9658,9666,9674,9682,9690,9697,9705,9712,9720,9728,9736,9744,9752,9759,9766,9773,9781,9789,9797,9805,9813,9821,9829,9836,9845,9852,9860,9868,9876,9884,9892,9900,9907,9914,9922,9930,9938,9946,9954,9962,9970,9978,9986,9994,10001,10010,10018,10026,10034,10042,10050,10058,10065,10073,10081,10088,10096,10102,10110,10118,10126,10133,10141,10149,10157,10165,10172,10180,10188,10196,10203,10211,10219,10227,10235,10243,10251,10256,10264,10272,10279,10287,10294,10302,10310,10319,10327,10335,10343,10351,10358,10366,10373,10381,10389,10397,10404,10412,10420,10428,10436,10443,10451,10459,10467,10474,10482,10490,10498,10506,10514,10521,10530,10538,10544,10552,10559,10566,10573,10581,10588,10596,10604,10611,10619,10627,10635,10640,10648,10656,10664,10672,10680,10686,10691,10698,10706,10714,10721,10729,10737,10744,10752,10759,10767,10775,10783,10790,10798,10806,10814,10822,10830,10838,10845,10853,10861,10869,10877,10885,10892,10899,10907,10915,10922,10930,10937,10944,10952,10960,10967,10975,10983,10991,10999,11007,11013,11021,11029,11037,11045,11053,11061,11066,11073,11081,11089,11097,11105,11112,11120,11126,11134,11141,11149,11156,11163,11169,11176,11184,11192,11198,11206,11214,11222,11230,11238,11246,11254,11262,11267,11274,11282,11290,11296,11304,11312,11320,11328,11336,11343,11351,11358,11367,11375,11379,11383,11390,11396,11404,11410,11418,11426,11434,11441,11449,11457,11464,11472,11480,11488,11495,11501,11508,11516,11524,11531,11539,11545,11553,11561,11568,11571,11579,11587,11594,11601,11609,11617,11623,11628,11636,11644,11651,11658,11660,11668,11676,11683,11692,11701,11710,11719,11728,11737,11745,11754,11763,11773,11778,11787,11796,11806,11815,11825,11834,11842,11851,11860,11868,11877,11886,11895,11904,11913,11921,11930,11939,11947,11953,11961,11970,11979,11988,11996,12006,12015,12025,12401,12406,12418,12421,12431,12440,12447,12456,12464,12474,12480,12487,12494,12505,12515,12520,12527,12540,12548,12554,12565,12572,12578,12589,12595,12601,12614,12623,12626,12638,12647,12657,12666,12671,12677,12689,12699,12708,12717,12723,12734,12743,12751,12761,12765,12772,12783,12792,12800,12802,12817,12822,12828,12841,12850,12859,12868,12877,12886,12895,12899,12911,12917,12926,12935,12939,12951,12959,12969,12971,12983,12993,13001,13004,13019,13025,13036,13040,13050,13054,13064,13076,13082,13090,13099,13108,13111,13119,13127,13137,13145,13156,13165,13169,13181,13186,13192,13200,13213,13217,13227,13235,13246,13249,13262,13271,13276,13288,13297,13306,13313,13323,13332,13341,13350,13355,13362,13373,13382,13387,13396,13406,13412,13420,13432,13439,13448,13452,13464,13472,13479,13489,13492,13502,13511,13521,13530,13539,13546,13556,13564,13573,13577,13587,13592,13602,13614,13623,13629,13640,13644,13653,13657,13667,13680,13686,13692,13699,13708,13719,13727,13735,13740,13748,13758,13767,13774,13785,13794,13803,13812,13820,13826,13837,13843,13851,13860,13864,13872,13884,13886,13900,13904,13915,13920,13928,13941,13945,13958,13963,13973,13983,13992,13995,14009,14018,14027,14032,14039,14049,14057,14062,14074,14076,14085,14093,14105,14114,14121,14128,14135,14140,14150,14156,14170,14179,14184,14191,14199,14209,14215,14222,14233,14241,14251,14258,14269,14276,14286,14295,14303,14306,14318,14323,14332,14338,14348,14357,14366,14376,14385,14394,14403,14412,14415,14428,14437,14443,14449,14456,14463,14478,14486,14495,14499,14509,14520,14524,14536,14542,14546,14561,14563,14574,14586,14595,14603,14605,14617,14629,14636,14642,14651,14661,14671,14679,14682,14696,14698,14713,14715,14726,14735,14745,14753,14758,14771,14780,14785,14795,14800,14812,14821,14823,14835,14841,14853,14870,14880,14887,14892,14904,14909,14921,14929,14936,14946,14953,14961,14969,14979,14988,14998,15003,15009,15029"),
("3","2088702373793640","0","0,5,9,17,26,31,36,40,42,50,53,62,70,75,82,87,90,94,106,111,115,120,128,140,145,153,160,168,175,186,190,195,201,207,215,218,224,234,238,245,253,261,268,276,283,291,296,304","2,11,21,28,35,43,50,58,64,73,84,93,101,109,118,128,135,143,153,160,167,176,184,195,202,210,218,224,235,241,246,256,268,273,283,291,297,304,310,317,325,333,339,346,357,367,373,379,390,396,405,411,419,422,427,435,443,452,460,467,475,486,496,505","1,15,24,27,40,42,57,66,75,76,91,100,109,118,127,136,145,154,163,170,172,187,196,205,209,222,225,233,247,257,258,273,281,284,291,300,308,316,324,338,347,356,365,374,378,390,399,408,416","371,416,426,434,442,449,457,466,480,484,502,533,547,574,657,916,926,934,950,958,967,971,978,984,992,1001,1006,1010,1021,1471,1474,1483,1491,1498,1508,1513,1526,1534,1543,1552,1564,1574,1580,1593,1602,1607,1617,1626,1636,1645,1655,1668,1675,1685,1695,1700,1704,1712,1722,1732,1742,1752,1761,1771,1778,1787,1800,1807,1816,1826,1835,1846,1854,1863,1868,1876,1883,1893,1902,1912,1924,1932,1942,1951,1960,1970,1979,1989,1998,2008,2019,2054,2064,2077,2111,2122,2124,2133,2142,2152,2162,2193,2208,2218,2228,2238,2250,2285,2295,2308,2314,2322,2332,2342,2352,2365,2371,2380,2390,2401,2415,2422,2459,2466,2477,2480,2488,2496,2505,2515,2523,2533,2536,2545,2551,2580,2598,2608,2618,2627,2633,2641,2651,2658,2667,2670,2679,2682,2685,2691,2693,2696,2705,2711,2714,2718,2725,2728,2731,2886,2889,2892,2895,2900,2903,2908,2910,2916,2919,2922,2925,2928,2932,2934,2943,2952,2954,2962,2968,2970,2973,2976,2980,2989,2993,2996,3002,3008,3011,3014,3018,3020,3030,3039,3047,3057,3066,3070,3077,3089,3092,3105,3110,3116,3126,3136,3145,3150,3157,3160,3169,3177,3185,3187,3188,3193,3214,3215,3219,3227,3236,3245,3254,3263,3275,3280,3289,3296,3302,3310,3316,3317,3326,3332,3341,3348,3351,3359,3367,3374,3382,3385,3390,3399,3406,3408,3409,3418,3424,3433,3442,3448,3457,3466,3467,3476,3485,3492,3495,3497,3503,3506,3508,3513,3521,3527,3535,3546,3563,3582,3587,3673,5035,5043,5051,5057,5065,5071,5077,5084,5092,5097,5103,5110,5116,5124,5128,5136,5142,5149,5155,5163,5169,5177,5185,5193,5197,5205,5210,5216,5223,5231,5239,5247,5254,5260,5267,5275,5283,5291,5299,5307,5314,5321,5329,5337,5342,5348,5356,5364,5372,5380,5388,5396,5402,5410,5418,5425,5433,5440,5447,5455,5463,5471,5479,5486,5492,5500,5508,5516,5524,5532,5539,5547,5555,5563,5571,5579,5587,5595,5603,5608,5616,5624,5630,5636,5641,5649,5657,5663,5671,5678,5684,5690,5696,5702,5710,5718,5726,5734,5740,5748,5755,5763,5770,5778,5785,5792,5800,5808,5816,5823,5829,5837,5843,5851,5859,5866,5874,5881,5887,5892,5900,5907,5915,5922,5929,5936,5942,5950,5958,5966,5974,5980,5988,5996,6001,6009,6015,6022,6029,6034,6040,6048,6056,6063,6070,6078,6086,6094,6099,6107,6115,6123,6131,6139,6145,6152,6160,6168,6174,6182,6189,6197,6204,6212,6220,6229,6233,6241,6249,6255,6263,6271,6277,6285,6292,6300,6308,6315,6322,6327,6335,6341,6349,6357,6365,6373,6381,6389,6397,6405,6413,6419,6427,6435,6443,6451,6457,6465,6472,6478,6486,6494,6501,6508,6516,6522,6529,6537,6545,6553,6561,6569,6575,6582,6590,6596,6604,6612,6619,6627,6635,6643,6651,6659,6666,6674,6681,6687,6694,6701,6708,6713,6721,6728,6736,6744,6751,6759,6767,6775,6783,6791,6799,6804,6812,6819,6827,6835,6843,6851,6860,6866,6870,6875,6882,6887,6895,6908,6916,6932,6940,6948,6955,6963,6971,6977,6983,6990,6998,7006,7012,7019,7024,7032,7040,7047,7055,7062,7070,7085,7093,7099,7104,7112,7120,7127,7150,7169,7172,7178,7185,7190,7197,7202,7209,7239,7245,7252,7259,7262,7266,7278,7284,7302,7308,7349,7353,7358,7363,7371,7378,7770,7776,8159,8164,8166,8172,8178,8185,8190,8201,8212,8377,9448,9456,9464,9473,9481,9489,9497,9504,9512,9519,9527,9535,9543,9551,9559,9567,9575,9582,9590,9597,9605,9613,9621,9628,9636,9644,9651,9658,9666,9674,9682,9690,9697,9705,9712,9720,9728,9736,9744,9752,9759,9766,9773,9781,9789,9797,9805,9813,9821,9829,9836,9845,9852,9860,9868,9876,9884,9892,9900,9907,9914,9922,9930,9938,9946,9954,9962,9970,9978,9986,9994,10001,10010,10018,10026,10034,10042,10050,10058,10065,10073,10081,10088,10096,10102,10110,10118,10126,10133,10141,10149,10157,10165,10172,10180,10188,10196,10203,10211,10219,10227,10235,10243,10251,10256,10264,10272,10279,10287,10294,10302,10310,10319,10327,10335,10343,10351,10358,10366,10373,10381,10389,10397,10404,10412,10420,10428,10436,10443,10451,10459,10467,10474,10482,10490,10498,10506,10514,10521,10530,10538,10544,10552,10559,10566,10573,10581,10588,10596,10604,10611,10619,10627,10635,10640,10648,10656,10664,10672,10680,10686,10691,10698,10706,10714,10721,10729,10737,10744,10752,10759,10767,10775,10783,10790,10798,10806,10814,10822,10830,10838,10845,10853,10861,10869,10877,10885,10892,10899,10907,10915,10922,10930,10937,10944,10952,10960,10967,10975,10983,10991,10999,11007,11013,11021,11029,11037,11045,11053,11061,11066,11073,11081,11089,11097,11105,11112,11120,11126,11134,11141,11149,11156,11163,11169,11176,11184,11192,11198,11206,11214,11222,11230,11238,11246,11254,11262,11267,11274,11282,11290,11296,11304,11312,11320,11328,11336,11343,11351,11358,11367,11375,11379,11383,11390,11396,11404,11410,11418,11426,11434,11441,11449,11457,11464,11472,11480,11488,11495,11501,11508,11516,11524,11531,11539,11545,11553,11561,11568,11571,11579,11587,11594,11601,11609,11617,11623,11628,11636,11644,11651,11658,11660,11668,11676,11683,11692,11701,11710,11719,11728,11737,11745,11754,11763,11773,11778,11787,11796,11806,11815,11825,11834,11842,11851,11860,11868,11877,11886,11895,11904,11913,11921,11930,11939,11947,11953,11961,11970,11979,11988,11996,12006,12015,12025,12401,12405,12418,12420,12438,12448,12456,12463,12474,12481,12485,12494,12505,12515,12521,12527,12539,12547,12555,12565,12570,12577,12587,12594,12601,12614,12623,12624,12639,12648,12657,12666,12673,12678,12689,12699,12706,12717,12724,12734,12743,12752,12761,12767,12770,12784,12792,12800,12804,12816,12821,12828,12841,12850,12859,12868,12877,12886,12894,12899,12910,12918,12923,12935,12940,12951,12960,12967,12970,12984,12993,13001,13006,13019,13026,13036,13040,13051,13055,13065,13076,13079,13089,13099,13108,13112,13122,13129,13137,13142,13156,13165,13167,13179,13184,13193,13203,13213,13217,13228,13236,13246,13252,13262,13271,13274,13288,13297,13306,13314,13323,13332,13341,13350,13357,13363,13372,13383,13386,13398,13407,13414,13417,13432,13437,13448,13453,13464,13472,13478,13489,13494,13499,13511,13520,13530,13539,13546,13556,13564,13573,13578,13585,13594,13599,13614,13620,13626,13640,13645,13654,13658,13668,13680,13683,13692,13699,13707,13720,13724,13734,13737,13746,13757,13768,13772,13785,13794,13803,13812,13819,13827,13837,13844,13853,13858,13874,13885,13889,13899,13904,13912,13922,13929,13940,13944,13958,13964,13973,13983,13992,13996,14009,14018,14027,14031,14039,14050,14054,14061,14074,14079,14086,14096,14106,14112,14121,14127,14133,14140,14150,14157,14170,14179,14184,14191,14197,14210,14215,14222,14234,14238,14252,14256,14269,14276,14286,14295,14302,14308,14317,14322,14331,14341,14346,14355,14367,14376,14385,14393,14401,14412,14416,14428,14437,14441,14449,14459,14465,14478,14486,14495,14500,14511,14520,14521,14536,14543,14546,14561,14564,14574,14586,14595,14603,14606,14618,14627,14634,14640,14653,14660,14669,14677,14682,14696,14701,14712,14715,14725,14734,14743,14752,14760,14770,14779,14787,14791,14800,14811,14819,14827,14836,14853,14860,14867,14880,14887,14897,14904,14921,14927,14933,14945,14954,14961,14971,14979,14988,14996,15001,15010,15019,15028"),
("4","2088902937310720","0","0,5,9,17,25,31,36,40,42,50,53,61,69,75,82,87,90,94,106,111,115,123,128,139,149,155,160,168,175,186,190,195,201,207,215,218,225,232,239,247,255,261,270,276,283,291,299,304","4,12,22,32,38,43,50,60,66,74,85,95,102,113,119,129,137,143,154,160,169,180,184,197,205,213,218,227,237,243,246,258,268,273,285,292,298,304,310,318,327,333,340,348,359,367,375,382,390,398,407,413,419,422,429,437,443,453,462,467,477,488,498,506","3,15,25,29,40,43,57,66,75,77,91,101,110,118,127,137,145,154,163,170,173,187,196,205,210,223,225,233,247,257,259,273,282,286,292,302,310,316,326,338,347,356,366,374,379,391,399,408,416","186,421,431,440,444,449,460,471,479,489,505,524,546,561,617,916,930,934,951,961,969,972,979,984,998,1001,1007,1010,1021,1471,1477,1483,1491,1498,1508,1513,1530,1534,1543,1552,1565,1575,1583,1594,1603,1608,1617,1634,1642,1646,1657,1665,1682,1685,1699,1700,1703,1712,1722,1736,1742,1752,1761,1771,1778,1787,1803,1814,1819,1826,1835,1845,1854,1863,1867,1876,1883,1893,1902,1912,1930,1932,1943,1951,1961,1970,1982,1990,1998,2009,2023,2054,2064,2084,2111,2121,2124,2133,2142,2153,2162,2173,2216,2218,2235,2238,2254,2286,2295,2310,2314,2322,2339,2350,2359,2368,2379,2380,2390,2407,2417,2424,2461,2474,2476,2480,2488,2503,2505,2515,2523,2533,2536,2545,2551,2563,2598,2608,2618,2627,2633,2641,2651,2658,2667,2670,2679,2682,2686,2691,2693,2696,2705,2711,2714,2718,2725,2728,2731,2886,2889,2892,2895,2900,2903,2907,2910,2916,2919,2922,2925,2928,2931,2934,2942,2951,2954,2963,2967,2970,2973,2976,2980,2989,2993,2996,2999,3008,3011,3014,3017,3020,3027,3041,3049,3059,3067,3070,3079,3085,3092,3107,3111,3116,3127,3137,3149,3150,3157,3160,3169,3177,3185,3187,3188,3193,3214,3215,3219,3227,3236,3245,3254,3263,3276,3280,3289,3296,3302,3310,3316,3317,3326,3332,3341,3348,3351,3359,3367,3374,3382,3385,3390,3399,3406,3408,3409,3418,3424,3433,3442,3448,3457,3466,3467,3476,3485,3492,3495,3497,3503,3506,3508,3513,3521,3527,3536,3541,3547,3555,3560,3564,3576,3582,3588,3608,3617,3692,3704,3892,3987,5035,5043,5051,5057,5065,5071,5077,5084,5093,5097,5103,5110,5116,5124,5134,5136,5142,5149,5158,5163,5172,5177,5185,5193,5199,5205,5210,5216,5223,5231,5239,5247,5255,5260,5267,5275,5288,5291,5299,5312,5314,5321,5329,5337,5342,5348,5356,5364,5372,5380,5388,5396,5402,5410,5418,5425,5435,5441,5447,5455,5468,5471,5479,5486,5492,5500,5514,5516,5527,5538,5539,5547,5555,5563,5571,5579,5587,5598,5603,5608,5616,5624,5630,5636,5642,5649,5658,5663,5671,5678,5684,5690,5697,5702,5715,5724,5726,5734,5746,5748,5755,5769,5770,5778,5785,5792,5800,5814,5816,5823,5834,5837,5848,5851,5864,5866,5874,5881,5887,5892,5901,5907,5915,5922,5930,5936,5942,5950,5958,5966,5975,5980,5988,5996,6001,6009,6015,6022,6029,6034,6040,6048,6056,6063,6076,6078,6086,6094,6099,6107,6115,6123,6131,6139,6145,6152,6165,6168,6174,6182,6189,6197,6204,6212,6222,6229,6235,6243,6250,6257,6263,6271,6277,6285,6292,6300,6308,6318,6322,6327,6335,6342,6349,6357,6365,6373,6381,6395,6397,6408,6413,6419,6432,6435,6443,6451,6462,6465,6472,6478,6489,6494,6502,6508,6516,6522,6529,6537,6545,6553,6567,6569,6575,6588,6590,6596,6608,6612,6619,6627,6635,6643,6651,6659,6672,6674,6681,6687,6694,6702,6708,6719,6721,6728,6736,6744,6751,6759,6767,6775,6783,6791,6799,6804,6813,6819,6832,6835,6843,6853,6860,6866,6870,6875,6882,6894,6895,6902,6908,6918,6926,6932,6940,6948,6955,6963,6973,6979,6983,6992,7000,7006,7018,7019,7031,7039,7040,7047,7055,7062,7070,7077,7085,7093,7099,7106,7119,7120,7127,7137,7145,7151,7160,7171,7175,7179,7186,7191,7198,7204,7212,7215,7220,7252,7259,7262,7266,7272,7277,7278,7285,7304,7309,7316,7321,7349,7354,7361,7364,7417,7421,7435,7440,7458,7464,7470,7475,7493,7498,7619,7626,7750,7754,7781,7787,7794,7799,7851,7857,7938,7944,8080,8087,8090,8096,8123,8126,8161,8165,8174,8180,8185,8201,8278,8345,9453,9462,9464,9474,9481,9489,9497,9504,9513,9520,9533,9536,9543,9551,9559,9567,9575,9582,9590,9603,9605,9613,9621,9628,9636,9644,9651,9658,9666,9674,9682,9691,9697,9705,9712,9720,9731,9736,9749,9752,9765,9768,9773,9781,9789,9797,9805,9813,9821,9829,9837,9845,9852,9860,9868,9876,9884,9898,9900,9908,9914,9928,9930,9938,9946,9960,9967,9971,9978,9988,9994,10002,10010,10018,10026,10035,10042,10050,10058,10065,10073,10081,10088,10096,10102,10110,10118,10126,10133,10141,10149,10157,10165,10176,10180,10188,10199,10203,10217,10219,10227,10235,10243,10251,10256,10270,10272,10284,10287,10294,10302,10310,10325,10327,10335,10343,10351,10358,10366,10373,10381,10389,10397,10405,10412,10420,10428,10436,10443,10451,10459,10467,10474,10482,10490,10498,10506,10515,10521,10535,10538,10544,10552,10559,10567,10573,10581,10594,10598,10604,10611,10619,10627,10635,10640,10648,10656,10664,10672,10680,10686,10691,10698,10706,10715,10721,10734,10737,10744,10752,10763,10767,10775,10783,10795,10800,10806,10814,10822,10830,10838,10845,10853,10863,10869,10877,10885,10892,10899,10907,10915,10922,10930,10937,10944,10955,10960,10967,10975,10983,10991,10999,11007,11013,11021,11035,11038,11047,11053,11061,11067,11073,11081,11089,11097,11105,11112,11120,11126,11134,11146,11149,11159,11163,11169,11176,11189,11192,11198,11211,11214,11222,11230,11238,11251,11254,11262,11267,11274,11282,11290,11296,11304,11312,11325,11328,11336,11343,11351,11360,11367,11375,11379,11383,11390,11403,11404,11411,11420,11426,11436,11443,11449,11457,11464,11472,11480,11489,11497,11501,11510,11518,11524,11538,11539,11552,11560,11561,11568,11571,11579,11587,11594,11601,11609,11617,11623,11629,11643,11644,11651,11658,11662,11669,11678,11683,11693,11701,11711,11720,11736,11737,11746,11756,11765,11775,11779,11787,11797,11807,11816,11826,11834,11843,11851,11861,11869,11878,11887,11895,11912,11913,11922,11930,11939,11949,11953,11962,11971,11980,11988,11999,12006,12016,12025,12401,12407,12416,12440,12446,12454,12462,12473,12478,12486,12495,12501,12514,12517,12529,12538,12547,12552,12564,12571,12578,12587,12594,12599,12612,12622,12628,12638,12647,12655,12665,12670,12678,12685,12698,12708,12716,12721,12733,12742,12751,12760,12766,12773,12779,12791,12799,12806,12815,12821,12829,12840,12849,12859,12867,12876,12885,12895,12901,12911,12916,12923,12934,12941,12950,12958,12968,12970,12980,12992,12999,13005,13018,13023,13035,13042,13047,13056,13065,13075,13081,13089,13096,13107,13114,13119,13129,13138,13145,13156,13164,13172,13180,13186,13193,13203,13212,13219,13225,13232,13244,13252,13261,13270,13276,13287,13296,13306,13309,13322,13332,13340,13350,13355,13364,13372,13381,13388,13393,13406,13412,13421,13431,13436,13447,13452,13463,13472,13478,13489,13493,13499,13511,13521,13529,13539,13547,13555,13564,13573,13579,13587,13593,13602,13613,13623,13627,13638,13646,13651,13658,13667,13679,13684,13693,13701,13709,13717,13723,13732,13741,13748,13755,13766,13775,13785,13793,13803,13811,13819,13823,13836,13841,13849,13858,13874,13884,13888,13897,13905,13914,13920,13930,13940,13944,13957,13963,13970,13982,13990,13995,14008,14017,14026,14033,14039,14047,14055,14073,14080,14087,14095,14106,14112,14118,14128,14134,14143,14151,14159,14169,14178,14182,14192,14201,14207,14216,14225,14230,14238,14252,14258,14268,14275,14285,14294,14303,14309,14315,14323,14332,14340,14347,14355,14365,14375,14384,14393,14403,14411,14417,14427,14436,14441,14450,14456,14464,14477,14485,14494,14500,14507,14519,14523,14535,14540,14546,14560,14564,14574,14584,14595,14602,14605,14613,14626,14631,14641,14651,14659,14669,14676,14682,14695,14698,14711,14715,14725,14733,14745,14751,14759,14769,14777,14785,14795,14800,14810,14819,14823,14851,14859,14868,14879,14886,14893,14903,14921,14929,14935,14944,14952,14960,14978,14987,14998,15004,15009,15018,15028"),
("5","2088222069313410","0","3,5,9,21,28,31,36,40,47,50,56,64,73,75,82,87,90,94,109,111,116,125,131,143,151,159,160,168,178,188,191,199,202,211,216,219,228,235,243,251,259,261,273,277,284,294,302,304","6,14,24,34,39,43,50,61,67,75,87,97,105,115,122,131,138,147,156,160,172,182,185,198,206,214,219,228,239,244,249,260,271,274,287,294,300,305,313,319,330,333,342,350,361,370,376,384,393,399,408,415,420,423,431,439,445,454,464,471,478,490,499,508","3,15,25,30,41,43,58,67,75,77,92,101,110,119,128,137,146,155,163,171,173,188,197,205,210,223,225,233,248,257,259,273,282,286,291,302,310,316,326,338,347,357,366,375,379,391,400,408,417","38,420,429,438,443,449,460,469,480,487,503,508,547,560,582,916,927,934,951,959,968,972,977,984,995,1001,1008,1010,1020,1471,1477,1483,1491,1498,1508,1513,1528,1534,1543,1552,1563,1573,1583,1589,1601,1607,1617,1626,1636,1645,1655,1668,1676,1685,1694,1700,1706,1712,1722,1734,1742,1752,1761,1771,1778,1787,1802,1809,1818,1826,1835,1846,1854,1863,1869,1876,1883,1893,1902,1912,1924,1932,1942,1951,1960,1970,1979,1989,1998,2008,2022,2054,2064,2081,2111,2122,2124,2133,2142,2152,2162,2173,2208,2218,2228,2238,2250,2285,2295,2307,2314,2322,2332,2342,2352,2368,2373,2380,2390,2402,2416,2428,2462,2468,2477,2480,2488,2496,2505,2515,2523,2533,2536,2545,2551,2569,2598,2608,2618,2627,2633,2641,2651,2658,2663,2667,2671,2679,2682,2687,2691,2693,2696,2705,2711,2714,2718,2725,2728,2732,2886,2889,2892,2895,2900,2903,2907,2910,2915,2916,2919,2922,2925,2928,2931,2934,2938,2942,2951,2954,2958,2967,2970,2973,2976,2980,2988,2993,2996,2999,3008,3011,3014,3017,3020,3025,3040,3048,3057,3062,3072,3077,3087,3094,3102,3111,3117,3125,3135,3145,3150,3157,3160,3169,3177,3184,3187,3188,3193,3214,3215,3219,3227,3236,3245,3254,3263,3272,3280,3289,3296,3302,3310,3316,3317,3326,3332,3341,3348,3351,3359,3367,3374,3382,3385,3390,3399,3406,3407,3409,3418,3424,3433,3442,3448,3457,3466,3467,3476,3485,3492,3495,3497,3503,3506,3508,3513,3521,3527,3536,3541,3548,3554,3558,3563,3569,3581,3590,3606,3612,3623,3640,3673,3708,3714,3731,3833,3839,3854,3913,4233,4287,4320,4347,5035,5043,5051,5057,5065,5071,5077,5084,5092,5097,5103,5110,5116,5124,5129,5136,5142,5150,5155,5163,5169,5177,5185,5193,5197,5205,5210,5216,5227,5231,5239,5250,5254,5260,5267,5275,5285,5291,5302,5307,5314,5321,5329,5337,5342,5348,5356,5364,5372,5380,5388,5396,5402,5410,5418,5426,5434,5440,5447,5455,5464,5471,5479,5487,5492,5500,5508,5516,5528,5532,5539,5547,5555,5563,5571,5580,5587,5595,5603,5613,5616,5624,5630,5636,5642,5649,5657,5663,5671,5678,5684,5690,5696,5702,5710,5720,5726,5734,5741,5748,5755,5765,5770,5778,5785,5792,5800,5814,5816,5823,5829,5837,5844,5851,5859,5868,5874,5881,5887,5892,5901,5907,5915,5922,5929,5936,5942,5950,5958,5966,5975,5980,5988,5996,6004,6009,6015,6023,6029,6034,6040,6048,6056,6063,6070,6078,6086,6094,6099,6107,6115,6123,6131,6139,6145,6152,6161,6169,6174,6182,6189,6197,6204,6212,6222,6229,6239,6241,6249,6255,6263,6271,6277,6285,6292,6304,6308,6315,6322,6327,6335,6343,6349,6357,6366,6373,6381,6389,6397,6405,6413,6419,6429,6435,6449,6451,6457,6465,6472,6478,6488,6494,6501,6508,6516,6522,6529,6537,6545,6553,6561,6570,6575,6582,6590,6596,6606,6612,6625,6628,6635,6649,6651,6659,6669,6675,6681,6687,6694,6701,6708,6713,6721,6728,6736,6744,6751,6759,6767,6775,6783,6791,6799,6804,6813,6819,6827,6835,6843,6853,6860,6866,6870,6875,6882,6887,6895,6915,6919,6932,6940,6948,6962,6963,6971,6977,6986,6993,7000,7006,7012,7019,7031,7039,7040,7047,7055,7064,7070,7085,7093,7099,7104,7112,7120,7127,7151,7171,7175,7180,7188,7192,7199,7205,7213,7214,7220,7239,7246,7253,7260,7263,7267,7273,7277,7281,7289,7305,7310,7316,7322,7325,7331,7351,7355,7360,7364,7370,7377,7416,7421,7423,7428,7434,7440,7457,7463,7471,7476,7493,7499,7502,7508,7526,7532,7620,7626,7641,7646,7662,7667,7724,7728,7783,7789,7795,7799,7840,7845,7852,7857,8070,8074,8090,8097,8123,8126,8167,8174,8180,8184,8193,8200,8234,8239,8245,8277,8288,8298,8317,8326,8344,8420,8548,9449,9456,9464,9474,9482,9489,9497,9508,9512,9519,9527,9535,9543,9551,9559,9567,9576,9588,9590,9597,9605,9613,9621,9628,9636,9644,9651,9658,9666,9674,9683,9691,9697,9705,9712,9720,9728,9736,9745,9752,9762,9766,9773,9781,9789,9797,9805,9818,9821,9829,9838,9845,9852,9860,9868,9876,9884,9892,9900,9907,9914,9922,9931,9938,9946,9958,9964,9970,9978,9986,9994,10002,10010,10018,10026,10035,10042,10050,10058,10065,10073,10081,10088,10096,10102,10110,10118,10126,10133,10141,10149,10157,10166,10177,10180,10188,10196,10203,10217,10219,10227,10235,10243,10251,10256,10267,10272,10280,10287,10294,10302,10311,10319,10327,10335,10343,10351,10358,10366,10373,10385,10389,10397,10404,10412,10420,10428,10436,10443,10451,10459,10467,10474,10482,10490,10499,10506,10514,10521,10533,10538,10544,10552,10559,10567,10573,10581,10590,10596,10604,10612,10619,10627,10635,10640,10648,10656,10664,10672,10680,10686,10691,10701,10706,10714,10721,10729,10737,10744,10752,10761,10767,10775,10783,10790,10800,10806,10816,10822,10830,10838,10845,10853,10861,10869,10877,10891,10893,10899,10907,10915,10922,10930,10937,10944,10952,10960,10967,10975,10983,10991,10999,11007,11013,11021,11029,11037,11051,11055,11061,11067,11073,11081,11089,11103,11105,11112,11120,11126,11134,11141,11149,11156,11163,11169,11176,11184,11192,11198,11208,11214,11222,11230,11238,11246,11254,11262,11267,11274,11282,11290,11297,11304,11312,11320,11332,11336,11343,11351,11360,11367,11375,11379,11383,11390,11396,11404,11410,11418,11433,11437,11441,11449,11457,11464,11479,11480,11488,11495,11503,11510,11518,11524,11531,11539,11552,11560,11561,11568,11571,11579,11589,11594,11601,11609,11617,11623,11628,11636,11644,11651,11658,11660,11669,11676,11683,11697,11701,11716,11720,11736,11738,11746,11756,11766,11775,11779,11787,11797,11807,11816,11831,11834,11843,11851,11861,11869,11878,11887,11895,11909,11913,11922,11930,11939,11949,11954,11963,11975,11985,11988,11998,12006,12017,12025,12399,12408,12417,12426,12438,12443,12452,12460,12472,12479,12484,12497,12506,12513,12519,12527,12538,12548,12551,12564,12573,12580,12585,12592,12604,12611,12621,12624,12635,12644,12655,12665,12674,12676,12688,12698,12704,12716,12722,12732,12742,12747,12760,12763,12770,12780,12791,12795,12802,12816,12824,12829,12839,12847,12855,12867,12876,12885,12890,12900,12907,12915,12926,12933,12943,12950,12956,12966,12970,12982,12990,13002,13008,13018,13025,13034,13041,13047,13054,13064,13073,13081,13087,13100,13107,13111,13124,13132,13137,13142,13155,13163,13167,13181,13185,13195,13198,13210,13218,13226,13232,13244,13251,13261,13270,13273,13286,13295,13305,13309,13322,13330,13340,13349,13352,13364,13374,13378,13385,13393,13403,13409,13417,13431,13437,13447,13452,13461,13471,13478,13488,13491,13503,13507,13516,13529,13538,13542,13555,13564,13572,13577,13587,13591,13604,13613,13619,13630,13636,13647,13652,13657,13668,13676,13682,13689,13702,13710,13720,13727,13734,13740,13749,13756,13768,13773,13784,13792,13802,13810,13817,13824,13835,13844,13851,13857,13877,13880,13886,13898,13903,13912,13924,13931,13940,13946,13955,13963,13973,13981,13992,13994,14009,14016,14025,14034,14038,14048,14054,14066,14071,14076,14089,14093,14101,14113,14119,14125,14137,14139,14151,14155,14169,14178,14184,14194,14197,14208,14216,14221,14230,14238,14248,14257,14268,14273,14285,14294,14297,14305,14319,14324,14331,14337,14348,14356,14363,14374,14384,14393,14400,14411,14414,14427,14436,14441,14450,14461,14463,14476,14483,14494,14503,14506,14519,14522,14533,14539,14560,14563,14574,14586,14594,14600,14605,14624,14632,14643,14652,14657,14667,14675,14684,14692,14708,14717,14725,14731,14742,14748,14760,14767,14775,14788,14790,14798,14807,14815,14836,14852,14859,14869,14879,14886,14903,14921,14925,14937,14942,14955,14958,14973,14979,14987,14997,15001,15008,15018,15027"),
("6","2088712261105430","0","0,5,9,20,28,31,36,40,45,50,53,63,72,75,82,87,90,94,109,111,115,124,129,143,151,158,160,168,177,188,190,198,201,208,215,218,228,235,242,250,258,261,271,276,283,294,300,304","6,16,26,34,40,45,52,63,68,76,89,98,105,115,122,132,140,146,157,161,173,182,186,200,208,216,220,229,239,244,250,261,272,275,287,295,302,305,314,319,330,334,343,351,362,371,376,385,394,401,408,416,420,423,431,440,447,455,465,469,478,491,501,510","1,15,24,27,40,42,57,66,75,76,91,100,109,118,127,136,145,154,163,170,172,187,196,205,209,222,225,232,247,257,258,273,281,284,291,300,308,316,324,338,347,356,365,374,377,390,399,408,416","253,417,431,436,445,450,458,467,480,489,506,527,547,570,822,916,925,934,952,962,970,971,975,983,993,1001,1006,1010,1021,1471,1474,1482,1491,1498,1507,1513,1525,1534,1543,1551,1561,1572,1580,1589,1600,1607,1617,1626,1636,1645,1655,1665,1675,1686,1693,1700,1703,1714,1722,1734,1748,1759,1761,1772,1778,1787,1802,1809,1818,1826,1835,1845,1854,1864,1867,1877,1883,1893,1902,1920,1922,1939,1942,1956,1960,1970,1981,1989,1998,2008,2019,2054,2071,2074,2111,2121,2124,2133,2142,2152,2162,2173,2208,2218,2230,2241,2250,2285,2295,2307,2314,2322,2332,2342,2352,2364,2371,2380,2390,2400,2413,2420,2459,2468,2476,2480,2494,2496,2505,2516,2531,2533,2536,2546,2551,2562,2598,2608,2618,2628,2634,2641,2651,2658,2667,2670,2679,2682,2685,2690,2693,2697,2705,2711,2714,2720,2725,2728,2738,2886,2889,2892,2895,2900,2903,2907,2910,2916,2919,2922,2925,2928,2931,2934,2942,2950,2954,2961,2967,2970,2973,2976,2980,2988,2993,2996,2999,3008,3011,3014,3017,3020,3030,3041,3049,3058,3063,3070,3080,3087,3092,3104,3111,3117,3128,3138,3147,3150,3157,3160,3169,3177,3185,3187,3188,3193,3214,3215,3219,3227,3236,3245,3254,3263,3272,3280,3289,3296,3302,3310,3316,3317,3326,3332,3341,3348,3351,3359,3367,3374,3382,3385,3390,3399,3406,3408,3409,3418,3424,3433,3442,3448,3457,3466,3467,3476,3485,3492,3495,3497,3503,3506,3508,3513,3521,3527,3539,3547,3553,3561,3563,3569,3577,3582,3587,3659,3676,3710,3734,3791,3794,3836,3859,3887,3951,3971,3997,4038,4061,4199,4217,4251,5035,5043,5051,5057,5065,5071,5077,5084,5092,5097,5103,5110,5116,5124,5128,5136,5142,5149,5155,5163,5169,5177,5185,5193,5197,5205,5210,5216,5223,5231,5239,5247,5254,5260,5267,5275,5283,5291,5299,5307,5314,5321,5329,5337,5342,5348,5356,5364,5372,5380,5388,5396,5402,5410,5418,5425,5433,5440,5447,5455,5463,5471,5479,5486,5492,5500,5508,5516,5524,5532,5539,5547,5555,5563,5571,5579,5587,5595,5603,5608,5616,5624,5630,5636,5641,5649,5657,5663,5671,5678,5684,5690,5696,5702,5710,5718,5726,5734,5740,5748,5755,5763,5770,5778,5785,5792,5800,5808,5816,5823,5829,5837,5843,5851,5859,5866,5874,5881,5887,5892,5900,5907,5915,5922,5929,5936,5942,5950,5958,5966,5974,5980,5988,5996,6001,6009,6015,6022,6029,6034,6040,6048,6056,6063,6070,6078,6086,6094,6099,6107,6115,6123,6131,6139,6145,6152,6160,6168,6174,6182,6189,6197,6204,6212,6220,6229,6233,6241,6249,6255,6263,6271,6277,6285,6292,6300,6308,6315,6322,6327,6335,6341,6349,6357,6365,6373,6381,6389,6397,6405,6413,6419,6427,6435,6443,6451,6457,6465,6472,6478,6486,6494,6501,6508,6516,6522,6529,6537,6545,6553,6561,6569,6575,6582,6590,6596,6604,6612,6619,6627,6635,6643,6651,6659,6666,6674,6681,6687,6694,6701,6708,6713,6721,6728,6736,6744,6751,6759,6767,6775,6783,6791,6799,6804,6812,6819,6827,6835,6843,6851,6860,6866,6870,6875,6882,6887,6895,6908,6916,6932,6940,6948,6955,6963,6971,6977,6983,6990,6998,7006,7012,7019,7024,7032,7040,7047,7055,7062,7070,7085,7093,7099,7104,7112,7120,7127,7150,7171,7177,7182,7188,7194,7201,7203,7210,7214,7220,7240,7247,7254,7260,7262,7266,7274,7277,7279,7286,7305,7312,7314,7319,7327,7332,7349,7356,7359,7363,7373,7380,7404,7409,7427,7431,7434,7440,7447,7452,7493,7500,7504,7510,7524,7530,7547,7551,7578,7583,7622,7628,7638,7644,7663,7667,7683,7688,7690,7696,7702,7708,7744,7746,7784,7790,7862,7868,7901,7906,7908,7914,7937,7943,8007,8011,8149,8153,8161,8165,8174,8180,8184,8200,8254,9448,9456,9464,9473,9481,9489,9497,9504,9512,9519,9527,9535,9543,9551,9559,9567,9575,9582,9590,9597,9605,9613,9621,9628,9636,9644,9651,9658,9666,9674,9682,9690,9697,9705,9712,9720,9728,9736,9744,9752,9759,9766,9773,9781,9789,9797,9805,9813,9821,9829,9836,9845,9852,9860,9868,9876,9884,9892,9900,9907,9914,9922,9930,9938,9946,9954,9962,9970,9978,9986,9994,10001,10010,10018,10026,10034,10042,10050,10058,10065,10073,10081,10088,10096,10102,10110,10118,10126,10133,10141,10149,10157,10165,10172,10180,10188,10196,10203,10211,10219,10227,10235,10243,10251,10256,10264,10272,10279,10287,10294,10302,10310,10319,10327,10335,10343,10351,10358,10366,10373,10381,10389,10397,10404,10412,10420,10428,10436,10443,10451,10459,10467,10474,10482,10490,10498,10506,10514,10521,10530,10538,10544,10552,10559,10566,10573,10581,10588,10596,10604,10611,10619,10627,10635,10640,10648,10656,10664,10672,10680,10686,10691,10698,10706,10714,10721,10729,10737,10744,10752,10759,10767,10775,10783,10790,10798,10806,10814,10822,10830,10838,10845,10853,10861,10869,10877,10885,10892,10899,10907,10915,10922,10930,10937,10944,10952,10960,10967,10975,10983,10991,10999,11007,11013,11021,11029,11037,11045,11053,11061,11066,11073,11081,11089,11097,11105,11112,11120,11126,11134,11141,11149,11156,11163,11169,11176,11184,11192,11198,11206,11214,11222,11230,11238,11246,11254,11262,11267,11274,11282,11290,11296,11304,11312,11320,11328,11336,11343,11351,11358,11367,11375,11379,11383,11390,11396,11404,11410,11418,11426,11434,11441,11449,11457,11464,11472,11480,11488,11495,11501,11508,11516,11524,11531,11539,11545,11553,11561,11568,11571,11579,11587,11594,11601,11609,11617,11623,11628,11636,11644,11651,11658,11660,11668,11676,11683,11692,11701,11710,11719,11728,11737,11745,11754,11763,11773,11778,11787,11796,11806,11815,11825,11834,11842,11851,11860,11868,11877,11886,11895,11904,11913,11921,11930,11939,11947,11953,11961,11970,11979,11988,11996,12006,12015,12025,12398,12403,12413,12438,12445,12452,12459,12468,12478,12487,12493,12505,12508,12518,12525,12535,12547,12550,12561,12569,12581,12584,12591,12600,12607,12620,12624,12632,12653,12663,12669,12676,12688,12696,12703,12714,12721,12730,12740,12758,12770,12789,12794,12813,12819,12832,12837,12847,12856,12865,12875,12883,12889,12901,12906,12913,12923,12932,12943,12947,12953,12964,12980,12986,12997,13006,13016,13033,13038,13046,13054,13067,13069,13078,13086,13100,13105,13110,13118,13132,13135,13142,13153,13160,13167,13180,13183,13196,13204,13210,13220,13226,13231,13239,13251,13259,13268,13278,13284,13294,13301,13311,13320,13327,13338,13347,13355,13364,13371,13378,13384,13395,13412,13417,13430,13436,13444,13453,13459,13469,13479,13486,13491,13499,13511,13515,13528,13534,13540,13553,13564,13567,13581,13583,13595,13605,13608,13618,13626,13636,13648,13655,13658,13666,13675,13686,13694,13701,13710,13714,13725,13733,13743,13745,13762,13770,13782,13791,13800,13809,13815,13824,13831,13843,13853,13855,13876,13887,13894,13905,13910,13918,13931,13939,13951,13964,13977,13987,13994,14006,14013,14020,14033,14037,14047,14055,14069,14089,14096,14108,14120,14126,14133,14139,14151,14166,14175,14183,14195,14197,14207,14214,14221,14229,14254,14266,14272,14283,14292,14302,14316,14326,14328,14342,14346,14353,14370,14379,14391,14398,14408,14424,14434,14442,14452,14455,14464,14472,14483,14491,14503,14507,14517,14522,14532,14539,14549,14557,14574,14581,14592,14599,14605,14623,14632,14654,14658,14666,14686,14691,14706,14725,14740,14762,14766,14790,14807,14814,14875,14900,14932,14941,14975,15007,15025"),
("7","2088702473867530","1","3,7,10,21,29,31,36,40,47,50,56,65,73,76,84,87,90,95,109,112,119,127,132,143,151,159,161,170,179,188,194,199,204,213,216,222,228,236,243,251,259,262,273,280,286,294,303,304","6,16,25,34,41,45,51,62,69,77,88,97,105,115,122,132,139,148,157,160,173,182,188,199,207,215,221,230,239,244,251,261,271,277,287,295,301,305,314,322,330,333,343,351,361,370,376,385,393,401,408,416,420,423,431,439,447,456,465,472,480,491,500,509","3,15,25,29,41,43,58,67,75,77,92,101,110,119,128,137,146,155,163,170,173,188,197,205,210,223,225,233,248,257,259,273,282,286,291,302,310,316,326,338,347,357,366,374,379,391,400,408,417","99,418,426,436,442,449,458,467,480,485,501,522,545,563,684,916,929,934,949,957,965,971,977,987,999,1004,1007,1010,1021,1471,1474,1486,1495,1500,1510,1513,1529,1538,1547,1552,1562,1572,1583,1594,1600,1610,1617,1631,1637,1648,1656,1667,1678,1685,1698,1700,1704,1718,1722,1735,1742,1752,1761,1771,1778,1787,1803,1813,1819,1826,1838,1846,1854,1863,1868,1876,1883,1898,1908,1912,1928,1932,1944,1951,1964,1970,1982,1991,2002,2012,2022,2061,2064,2074,2111,2122,2128,2133,2142,2154,2162,2196,2212,2218,2233,2245,2249,2287,2298,2308,2314,2322,2334,2345,2354,2367,2375,2380,2395,2404,2416,2420,2461,2473,2477,2480,2488,2501,2512,2515,2523,2533,2536,2545,2554,2563,2598,2608,2618,2627,2633,2641,2651,2658,2667,2670,2679,2682,2686,2691,2693,2696,2705,2711,2714,2721,2725,2728,2742,2886,2891,2892,2896,2900,2903,2908,2910,2916,2919,2922,2924,2928,2931,2934,2943,2952,2954,2967,2970,2973,2978,2980,2989,2994,2998,3000,3008,3011,3014,3018,3020,3028,3041,3049,3058,3066,3070,3081,3085,3092,3107,3111,3116,3128,3138,3146,3150,3157,3160,3169,3177,3185,3187,3188,3193,3214,3215,3225,3227,3236,3245,3254,3264,3277,3284,3292,3296,3304,3310,3316,3319,3326,3332,3343,3348,3351,3361,3367,3374,3382,3385,3390,3399,3406,3408,3409,3418,3424,3433,3442,3448,3463,3466,3473,3476,3485,3492,3495,3498,3503,3506,3509,3513,3522,3527,3538,3542,3549,3555,3561,3566,3570,3577,3585,3587,3607,3624,3639,3647,3654,3664,3673,3687,3703,3708,3755,3795,3853,3892,3936,3950,3987,4002,4012,4057,4131,4147,4209,4258,5035,5043,5051,5057,5065,5071,5077,5084,5094,5098,5103,5110,5119,5124,5134,5136,5142,5151,5155,5163,5169,5177,5185,5193,5202,5205,5210,5216,5223,5231,5239,5253,5256,5261,5267,5278,5288,5295,5299,5309,5319,5323,5329,5337,5342,5348,5356,5367,5372,5380,5388,5396,5402,5412,5418,5425,5435,5440,5447,5455,5469,5471,5482,5486,5492,5500,5508,5518,5525,5538,5539,5547,5555,5563,5571,5579,5593,5595,5604,5611,5616,5624,5632,5636,5642,5649,5657,5669,5671,5678,5686,5690,5696,5702,5715,5724,5732,5734,5746,5752,5755,5769,5770,5778,5786,5792,5805,5808,5816,5823,5829,5837,5849,5856,5859,5869,5874,5881,5889,5892,5903,5907,5920,5922,5932,5936,5943,5950,5958,5966,5974,5980,5989,5996,6001,6010,6015,6022,6031,6035,6040,6048,6056,6063,6070,6078,6086,6094,6100,6107,6116,6123,6131,6139,6146,6152,6166,6168,6175,6182,6189,6197,6204,6212,6223,6229,6233,6241,6249,6256,6263,6271,6277,6285,6292,6300,6308,6321,6323,6327,6335,6344,6349,6361,6365,6373,6381,6395,6397,6407,6413,6419,6427,6435,6444,6451,6457,6465,6472,6478,6487,6494,6502,6508,6516,6522,6529,6537,6545,6557,6561,6569,6575,6587,6590,6601,6605,6613,6619,6629,6635,6649,6651,6659,6672,6675,6682,6687,6695,6701,6708,6719,6721,6728,6736,6745,6757,6759,6767,6775,6783,6791,6799,6804,6813,6819,6830,6837,6843,6854,6860,6866,6870,6875,6882,6887,6895,6912,6919,6930,6932,6940,6948,6960,6963,6971,6979,6984,6993,7001,7006,7017,7019,7029,7039,7040,7047,7055,7065,7070,7085,7093,7099,7106,7115,7120,7127,7141,7149,7152,7164,7171,7177,7182,7188,7194,7201,7205,7213,7215,7221,7241,7248,7254,7260,7265,7269,7271,7277,7279,7287,7304,7310,7317,7323,7328,7333,7349,7355,7360,7363,7370,7378,7404,7408,7416,7420,7422,7428,7447,7452,7460,7467,7469,7474,7493,7499,7504,7510,7524,7530,7543,7549,7578,7583,7596,7603,7622,7628,7639,7644,7661,7666,7727,7730,7736,7740,7751,7755,7769,7775,7784,7790,7795,7799,7937,7943,8149,8153,8161,8165,8167,8175,8181,8188,8193,8196,8204,8207,8222,8234,8245,8248,8254,8267,8271,8288,8292,8307,8313,8317,8323,8340,8351,8354,8367,8384,8405,8458,8507,8548,8550,8578,9453,9456,9464,9474,9482,9489,9497,9507,9512,9519,9533,9538,9543,9551,9562,9567,9577,9582,9590,9603,9605,9617,9621,9628,9636,9645,9652,9658,9671,9674,9682,9692,9701,9705,9713,9723,9729,9740,9749,9752,9765,9767,9773,9781,9789,9797,9805,9813,9822,9829,9838,9845,9853,9860,9869,9876,9884,9892,9901,9907,9915,9925,9930,9938,9951,9960,9968,9970,9978,9992,9994,10003,10010,10018,10026,10036,10044,10050,10058,10065,10073,10083,10088,10096,10102,10110,10118,10126,10133,10142,10149,10163,10165,10176,10180,10188,10202,10203,10211,10221,10227,10238,10243,10251,10256,10270,10273,10285,10290,10294,10305,10312,10319,10327,10335,10349,10351,10359,10366,10375,10381,10391,10397,10406,10412,10421,10428,10436,10443,10454,10465,10467,10477,10487,10490,10498,10509,10516,10522,10535,10538,10544,10553,10559,10567,10573,10582,10593,10596,10604,10612,10619,10627,10635,10640,10648,10656,10666,10672,10682,10686,10691,10704,10706,10714,10721,10733,10742,10745,10752,10760,10767,10776,10783,10790,10798,10806,10814,10822,10831,10838,10845,10853,10861,10869,10883,10891,10892,10899,10907,10915,10922,10931,10938,10949,10952,10960,10967,10975,10984,10991,10999,11007,11013,11023,11035,11040,11046,11056,11063,11066,11073,11082,11089,11099,11105,11114,11120,11126,11134,11141,11150,11156,11163,11169,11176,11184,11192,11198,11206,11214,11225,11230,11238,11250,11260,11262,11268,11279,11282,11290,11296,11304,11312,11326,11328,11336,11348,11352,11361,11367,11375,11379,11383,11390,11396,11404,11411,11424,11430,11437,11447,11449,11457,11466,11476,11480,11488,11497,11502,11511,11518,11524,11537,11539,11550,11558,11561,11568,11571,11581,11590,11594,11606,11610,11617,11623,11630,11639,11644,11651,11658,11666,11670,11682,11683,11693,11701,11711,11721,11730,11737,11746,11757,11766,11775,11781,11787,11799,11812,11819,11826,11834,11848,11851,11860,11871,11881,11887,11895,11908,11913,11921,11930,11939,11949,11953,11962,11971,11982,11989,11999,12006,12017,12026,12399,12409,12414,12435,12443,12452,12464,12471,12477,12487,12498,12504,12511,12517,12525,12536,12548,12552,12562,12572,12581,12585,12591,12600,12610,12621,12624,12634,12644,12653,12664,12673,12676,12690,12697,12704,12715,12720,12732,12741,12748,12758,12764,12770,12784,12790,12796,12802,12814,12819,12831,12839,12848,12856,12866,12875,12885,12890,12903,12911,12914,12926,12933,12943,12948,12955,12964,12971,12984,12989,12999,13004,13016,13025,13034,13039,13047,13054,13066,13072,13080,13088,13099,13106,13110,13118,13132,13139,13142,13154,13161,13167,13181,13183,13196,13201,13210,13221,13226,13232,13243,13250,13260,13269,13278,13285,13295,13304,13314,13321,13328,13339,13348,13354,13361,13373,13377,13384,13395,13403,13409,13417,13431,13439,13446,13453,13461,13470,13480,13487,13492,13500,13509,13517,13529,13535,13543,13554,13564,13571,13581,13588,13594,13599,13610,13618,13627,13636,13648,13650,13657,13671,13676,13687,13694,13703,13710,13715,13725,13732,13737,13745,13758,13763,13775,13783,13792,13800,13809,13814,13824,13833,13843,13853,13855,13877,13879,13886,13896,13905,13915,13918,13932,13937,13949,13954,13963,13968,13980,13988,13994,14007,14016,14024,14034,14037,14046,14056,14070,14076,14089,14095,14101,14113,14117,14127,14134,14140,14153,14156,14168,14177,14182,14194,14197,14206,14219,14222,14231,14237,14248,14257,14267,14273,14285,14294,14299,14306,14319,14324,14333,14340,14347,14356,14360,14373,14381,14390,14398,14409,14414,14425,14435,14444,14453,14455,14463,14476,14484,14493,14503,14509,14518,14521,14532,14540,14546,14559,14563,14575,14583,14593,14599,14605,14640,14654,14657,14666,14673,14692,14708,14742,14747,14761,14767,14776,14788,14790,14798,14808,14816,14833,14850,14860,14877,14883,14902,14918,14930,14942,14954,14973,14977,14986,14999,15001,15016,15025"),
("8","2088902521894800","0","0,5,9,17,24,31,36,40,42,50,53,60,68,75,82,87,90,94,105,111,115,121,128,138,146,153,160,168,173,184,190,195,201,207,215,218,224,231,238,245,254,261,268,276,283,290,296,304","6,13,23,29,38,46,52,60,67,76,86,95,104,110,120,129,138,147,154,162,169,177,186,197,205,212,220,227,237,242,249,259,269,277,285,292,299,305,311,319,328,334,340,348,359,368,374,382,391,398,406,414,420,423,429,437,445,454,462,471,478,488,498,507","0,15,24,27,39,42,57,66,75,77,90,99,109,118,126,135,143,152,162,169,173,185,194,204,207,222,225,233,246,256,258,272,280,283,291,300,307,316,323,338,347,355,365,374,377,388,399,408,416","85,422,431,441,442,449,460,471,480,489,506,523,547,567,716,916,928,934,951,962,970,972,976,984,996,1001,1007,1010,1021,1471,1475,1483,1495,1498,1510,1513,1528,1536,1547,1552,1562,1570,1581,1592,1598,1612,1617,1631,1638,1651,1655,1668,1681,1685,1693,1700,1704,1712,1722,1732,1742,1752,1761,1771,1778,1787,1803,1807,1816,1826,1842,1847,1854,1863,1868,1876,1883,1893,1909,1912,1929,1932,1943,1951,1966,1970,1979,1991,1998,2015,2024,2062,2064,2077,2111,2122,2124,2133,2142,2157,2162,2174,2214,2218,2228,2238,2255,2291,2302,2307,2314,2322,2337,2346,2357,2366,2378,2380,2398,2406,2416,2422,2460,2466,2477,2480,2488,2496,2513,2515,2523,2533,2536,2545,2556,2564,2598,2608,2618,2627,2633,2641,2651,2658,2667,2670,2679,2682,2685,2690,2693,2696,2705,2711,2714,2718,2725,2728,2731,2886,2889,2892,2895,2900,2903,2907,2910,2916,2919,2922,2925,2928,2931,2934,2942,2951,2954,2967,2970,2973,2976,2980,2989,2993,2996,3000,3008,3011,3014,3017,3020,3029,3040,3048,3057,3063,3070,3078,3086,3092,3103,3111,3116,3126,3136,3146,3150,3157,3160,3169,3177,3185,3187,3188,3193,3214,3215,3220,3227,3236,3245,3254,3263,3275,3280,3291,3296,3302,3310,3316,3317,3326,3332,3341,3348,3351,3359,3367,3374,3382,3385,3390,3399,3406,3408,3409,3418,3424,3433,3442,3448,3457,3466,3467,3476,3485,3492,3495,3497,3503,3506,3508,3513,3521,3527,3535,3548,3553,3558,3564,3569,3576,3584,3652,3703,3766,3795,3890,3896,3951,3986,4101,4218,5035,5043,5051,5057,5065,5071,5077,5084,5092,5097,5103,5110,5116,5124,5128,5136,5142,5149,5155,5163,5169,5177,5185,5193,5197,5205,5210,5216,5223,5231,5239,5247,5254,5260,5267,5275,5283,5291,5299,5307,5314,5321,5329,5337,5342,5348,5356,5364,5372,5380,5388,5396,5402,5410,5418,5425,5433,5440,5447,5455,5463,5471,5479,5486,5492,5500,5508,5516,5524,5532,5539,5547,5555,5563,5571,5579,5587,5595,5603,5608,5616,5624,5630,5636,5641,5649,5657,5663,5671,5678,5684,5690,5696,5702,5710,5718,5726,5734,5740,5748,5755,5763,5770,5778,5785,5792,5800,5808,5816,5823,5829,5837,5843,5851,5859,5866,5874,5881,5887,5892,5900,5907,5915,5922,5929,5936,5942,5950,5958,5966,5974,5980,5988,5996,6001,6009,6015,6022,6029,6034,6040,6048,6056,6063,6070,6078,6086,6094,6099,6107,6115,6123,6131,6139,6145,6152,6160,6168,6174,6182,6189,6197,6204,6212,6220,6229,6233,6241,6249,6255,6263,6271,6277,6285,6292,6300,6308,6315,6322,6327,6335,6341,6349,6357,6365,6373,6381,6389,6397,6405,6413,6419,6427,6435,6443,6451,6457,6465,6472,6478,6486,6494,6501,6508,6516,6522,6529,6537,6545,6553,6561,6569,6575,6582,6590,6596,6604,6612,6619,6627,6635,6643,6651,6659,6666,6674,6681,6687,6694,6701,6708,6713,6721,6728,6736,6744,6751,6759,6767,6775,6783,6791,6799,6804,6812,6819,6827,6835,6843,6851,6860,6866,6870,6875,6882,6887,6895,6908,6916,6932,6940,6948,6955,6963,6971,6977,6983,6990,6998,7006,7012,7019,7024,7032,7040,7047,7055,7062,7070,7085,7093,7099,7104,7112,7120,7127,7150,7171,7175,7179,7186,7191,7199,7202,7208,7215,7220,7226,7232,7240,7246,7253,7260,7262,7266,7271,7277,7278,7285,7304,7309,7315,7321,7325,7331,7350,7354,7360,7364,7370,7377,7382,7387,7406,7410,7416,7420,7423,7428,7435,7440,7458,7465,7468,7473,7481,7485,7491,7497,7524,7530,7580,7585,7619,7626,7638,7644,7713,7719,7725,7729,7781,7787,7793,7798,7884,7890,7984,7991,8080,8086,8123,8125,8149,8153,8161,8165,8167,8174,8179,8186,8190,8234,8243,8269,8281,8291,8312,8326,8339,8366,8404,8507,8609,9448,9456,9464,9473,9481,9489,9497,9504,9512,9519,9527,9535,9543,9551,9559,9567,9575,9582,9590,9597,9605,9613,9621,9628,9636,9644,9651,9658,9666,9674,9682,9690,9697,9705,9712,9720,9728,9736,9744,9752,9759,9766,9773,9781,9789,9797,9805,9813,9821,9829,9836,9845,9852,9860,9868,9876,9884,9892,9900,9907,9914,9922,9930,9938,9946,9954,9962,9970,9978,9986,9994,10001,10010,10018,10026,10034,10042,10050,10058,10065,10073,10081,10088,10096,10102,10110,10118,10126,10133,10141,10149,10157,10165,10172,10180,10188,10196,10203,10211,10219,10227,10235,10243,10251,10256,10264,10272,10279,10287,10294,10302,10310,10319,10327,10335,10343,10351,10358,10366,10373,10381,10389,10397,10404,10412,10420,10428,10436,10443,10451,10459,10467,10474,10482,10490,10498,10506,10514,10521,10530,10538,10544,10552,10559,10566,10573,10581,10588,10596,10604,10611,10619,10627,10635,10640,10648,10656,10664,10672,10680,10686,10691,10698,10706,10714,10721,10729,10737,10744,10752,10759,10767,10775,10783,10790,10798,10806,10814,10822,10830,10838,10845,10853,10861,10869,10877,10885,10892,10899,10907,10915,10922,10930,10937,10944,10952,10960,10967,10975,10983,10991,10999,11007,11013,11021,11029,11037,11045,11053,11061,11066,11073,11081,11089,11097,11105,11112,11120,11126,11134,11141,11149,11156,11163,11169,11176,11184,11192,11198,11206,11214,11222,11230,11238,11246,11254,11262,11267,11274,11282,11290,11296,11304,11312,11320,11328,11336,11343,11351,11358,11367,11375,11379,11383,11390,11396,11404,11410,11418,11426,11434,11441,11449,11457,11464,11472,11480,11488,11495,11501,11508,11516,11524,11531,11539,11545,11553,11561,11568,11571,11579,11587,11594,11601,11609,11617,11623,11628,11636,11644,11651,11658,11660,11668,11676,11683,11692,11701,11710,11719,11728,11737,11745,11754,11763,11773,11778,11787,11796,11806,11815,11825,11834,11842,11851,11860,11868,11877,11886,11895,11904,11913,11921,11930,11939,11947,11953,11961,11970,11979,11988,11996,12006,12015,12025,12397,12405,12411,12449,12453,12459,12469,12480,12486,12494,12504,12510,12517,12525,12535,12547,12556,12560,12570,12578,12591,12599,12609,12619,12625,12633,12641,12650,12661,12669,12677,12695,12703,12713,12725,12729,12739,12745,12757,12764,12772,12782,12787,12812,12819,12828,12836,12846,12856,12863,12873,12882,12889,12898,12908,12917,12922,12931,12939,12946,12953,12965,12982,12987,12996,13007,13015,13025,13032,13039,13048,13054,13067,13070,13080,13086,13098,13103,13110,13118,13128,13137,13146,13152,13160,13169,13180,13183,13193,13204,13209,13218,13227,13231,13239,13252,13258,13266,13278,13283,13293,13301,13311,13318,13327,13337,13346,13352,13366,13371,13384,13397,13400,13421,13428,13435,13443,13454,13459,13467,13478,13485,13491,13502,13512,13515,13526,13534,13552,13564,13568,13581,13586,13594,13605,13609,13618,13627,13634,13647,13654,13657,13669,13675,13685,13695,13698,13707,13713,13724,13733,13742,13745,13761,13774,13781,13790,13799,13808,13824,13832,13844,13852,13855,13874,13888,13894,13912,13918,13930,13937,13952,13960,13978,13986,13995,14004,14013,14021,14030,14037,14050,14068,14085,14095,14110,14121,14126,14132,14150,14155,14166,14175,14181,14193,14199,14210,14217,14229,14245,14254,14264,14282,14290,14303,14306,14317,14324,14328,14342,14350,14355,14360,14371,14380,14390,14399,14408,14414,14423,14432,14440,14450,14455,14464,14473,14482,14490,14502,14507,14516,14525,14531,14543,14546,14556,14563,14573,14581,14591,14598,14605"),
("9","2088702847738000","1","0,5,9,17,23,31,36,40,42,50,53,60,68,75,82,87,90,94,104,111,115,121,128,138,146,153,160,168,173,184,190,195,201,207,215,218,224,231,238,245,254,261,268,276,283,289,296,304","5,12,22,30,38,44,51,59,66,75,85,94,104,111,119,129,137,148,154,161,169,178,185,196,204,212,219,228,236,242,250,259,268,274,284,292,299,305,311,319,328,334,340,348,358,367,374,381,390,398,406,413,420,423,428,436,444,453,462,473,477,488,497,506","2,15,24,28,40,43,57,66,75,77,91,100,109,118,127,136,145,154,163,170,173,187,196,205,208,222,225,233,247,256,259,273,281,285,292,301,309,316,325,338,347,356,365,374,378,390,399,408,416","64,422,430,441,444,449,456,471,479,488,506,534,546,573,593,916,929,940,947,962,970,972,975,985,994,1001,1008,1010,1021,1471,1474,1485,1491,1498,1508,1513,1527,1535,1543,1554,1561,1570,1580,1590,1599,1607,1617,1626,1636,1645,1656,1669,1675,1686,1697,1700,1707,1712,1722,1734,1746,1755,1761,1772,1778,1788,1803,1809,1818,1826,1835,1848,1854,1864,1869,1877,1883,1894,1902,1916,1927,1938,1942,1951,1960,1970,1981,1989,1998,2008,2025,2054,2068,2077,2111,2122,2126,2133,2142,2152,2162,2172,2208,2218,2230,2238,2255,2285,2295,2309,2314,2322,2332,2342,2352,2368,2371,2380,2390,2404,2416,2423,2463,2471,2477,2480,2489,2498,2505,2516,2528,2533,2536,2546,2551,2562,2598,2608,2618,2628,2634,2641,2651,2658,2662,2667,2670,2679,2682,2686,2691,2693,2696,2705,2711,2714,2718,2725,2728,2731,2886,2889,2892,2895,2900,2903,2907,2910,2914,2916,2919,2922,2925,2928,2932,2934,2939,2942,2952,2954,2958,2967,2970,2973,2976,2980,2989,2993,2996,3004,3008,3011,3014,3018,3020,3027,3040,3048,3059,3065,3070,3080,3085,3093,3105,3111,3116,3128,3138,3147,3150,3157,3160,3169,3177,3185,3187,3188,3193,3214,3215,3221,3227,3236,3247,3254,3263,3273,3280,3291,3297,3302,3310,3316,3317,3326,3333,3341,3348,3351,3359,3367,3377,3382,3385,3390,3399,3406,3408,3409,3418,3424,3433,3442,3448,3457,3466,3467,3476,3485,3492,3495,3497,3503,3506,3508,3513,3521,3527,3553,5035,5043,5051,5057,5065,5071,5077,5084,5092,5097,5103,5110,5116,5124,5128,5136,5142,5149,5155,5163,5169,5177,5185,5193,5197,5205,5210,5216,5223,5231,5239,5247,5254,5260,5267,5275,5283,5291,5299,5307,5314,5321,5329,5337,5342,5348,5356,5364,5372,5380,5388,5396,5402,5410,5418,5425,5433,5440,5447,5455,5463,5471,5479,5486,5492,5500,5508,5516,5524,5532,5539,5547,5555,5563,5571,5579,5587,5595,5603,5608,5616,5624,5630,5636,5641,5649,5657,5663,5671,5678,5684,5690,5696,5702,5710,5718,5726,5734,5740,5748,5755,5763,5770,5778,5785,5792,5800,5808,5816,5823,5829,5837,5843,5851,5859,5866,5874,5881,5887,5892,5900,5907,5915,5922,5929,5936,5942,5950,5958,5966,5974,5980,5988,5996,6001,6009,6015,6022,6029,6034,6040,6048,6056,6063,6070,6078,6086,6094,6099,6107,6115,6123,6131,6139,6145,6152,6160,6168,6174,6182,6189,6197,6204,6212,6220,6229,6233,6241,6249,6255,6263,6271,6277,6285,6292,6300,6308,6315,6322,6327,6335,6341,6349,6357,6365,6373,6381,6389,6397,6405,6413,6419,6427,6435,6443,6451,6457,6465,6472,6478,6486,6494,6501,6508,6516,6522,6529,6537,6545,6553,6561,6569,6575,6582,6590,6596,6604,6612,6619,6627,6635,6643,6651,6659,6666,6674,6681,6687,6694,6701,6708,6713,6721,6728,6736,6744,6751,6759,6767,6775,6783,6791,6799,6804,6812,6819,6827,6835,6843,6851,6860,6866,6870,6875,6882,6887,6895,6908,6916,6932,6940,6948,6955,6963,6971,6977,6983,6990,6998,7006,7012,7019,7024,7032,7040,7047,7055,7062,7070,7085,7093,7099,7104,7112,7120,7127,7150,7170,7173,7178,7187,7190,7197,7202,7210,7238,7244,7251,7260,7280,7287,7303,7308,7349,7353,7369,7376,7416,7420,7423,7428,7491,7497,7502,7508,7524,7530,7543,7549,7639,7645,7661,7666,7681,7687,7769,7776,7795,7800,7896,7903,7937,7943,8069,8073,8122,8124,8166,8174,8180,8185,8190,8201,8234,8246,8289,8317,9448,9456,9464,9473,9481,9489,9497,9504,9512,9519,9527,9535,9543,9551,9559,9567,9575,9582,9590,9597,9605,9613,9621,9628,9636,9644,9651,9658,9666,9674,9682,9690,9697,9705,9712,9720,9728,9736,9744,9752,9759,9766,9773,9781,9789,9797,9805,9813,9821,9829,9836,9845,9852,9860,9868,9876,9884,9892,9900,9907,9914,9922,9930,9938,9946,9954,9962,9970,9978,9986,9994,10001,10010,10018,10026,10034,10042,10050,10058,10065,10073,10081,10088,10096,10102,10110,10118,10126,10133,10141,10149,10157,10165,10172,10180,10188,10196,10203,10211,10219,10227,10235,10243,10251,10256,10264,10272,10279,10287,10294,10302,10310,10319,10327,10335,10343,10351,10358,10366,10373,10381,10389,10397,10404,10412,10420,10428,10436,10443,10451,10459,10467,10474,10482,10490,10498,10506,10514,10521,10530,10538,10544,10552,10559,10566,10573,10581,10588,10596,10604,10611,10619,10627,10635,10640,10648,10656,10664,10672,10680,10686,10691,10698,10706,10714,10721,10729,10737,10744,10752,10759,10767,10775,10783,10790,10798,10806,10814,10822,10830,10838,10845,10853,10861,10869,10877,10885,10892,10899,10907,10915,10922,10930,10937,10944,10952,10960,10967,10975,10983,10991,10999,11007,11013,11021,11029,11037,11045,11053,11061,11066,11073,11081,11089,11097,11105,11112,11120,11126,11134,11141,11149,11156,11163,11169,11176,11184,11192,11198,11206,11214,11222,11230,11238,11246,11254,11262,11267,11274,11282,11290,11296,11304,11312,11320,11328,11336,11343,11351,11358,11367,11375,11379,11383,11390,11396,11404,11410,11418,11426,11434,11441,11449,11457,11464,11472,11480,11488,11495,11501,11508,11516,11524,11531,11539,11545,11553,11561,11568,11571,11579,11587,11594,11601,11609,11617,11623,11628,11636,11644,11651,11658,11660,11668,11676,11683,11692,11701,11710,11719,11728,11737,11745,11754,11763,11773,11778,11787,11796,11806,11815,11825,11834,11842,11851,11860,11868,11877,11886,11895,11904,11913,11921,11930,11939,11947,11953,11961,11970,11979,11988,11996,12006,12015,12025,12401,12406,12418,12420,12440,12448,12454,12461,12474,12480,12486,12494,12506,12514,12521,12526,12539,12547,12554,12565,12571,12577,12587,12593,12601,12613,12623,12625,12637,12647,12656,12666,12672,12677,12689,12699,12708,12717,12723,12734,12743,12751,12761,12764,12773,12783,12792,12799,12802,12817,12821,12829,12841,12850,12859,12868,12877,12886,12895,12899,12910,12917,12925,12935,12939,12951,12958,12969,12970,12982,12992,13001,13005,13019,13027,13036,13040,13051,13054,13065,13075,13079,13088,13099,13108,13110,13120,13128,13136,13147,13156,13165,13169,13180,13184,13192,13201,13213,13217,13227,13236,13245,13251,13262,13271,13277,13288,13297,13306,13312,13323,13332,13341,13350,13357,13363,13372,13382,13385,13397,13406,13413,13421,13432,13437,13448,13453,13464,13472,13479,13489,13491,13500,13511,13521,13530,13539,13545,13556,13564,13573,13579,13586,13593,13603,13614,13623,13627,13640,13644,13653,13658,13668,13680,13685,13693,13699,13707,13719,13728,13735,13740,13746,13754,13767,13775,13785,13794,13803,13812,13820,13827,13837,13844,13852,13859,13872,13884,13887,13899,13907,13914,13920,13928,13941,13943,13958,13963,13973,13983,13991,13995,14009,14018,14027,14030,14039,14049,14054,14061,14073,14076,14086,14095,14104,14112,14121,14127,14134,14139,14149,14156,14170,14179,14184,14191,14199,14209,14215,14221,14234,14239,14251,14256,14269,14277,14286,14295,14302,14306,14318,14323,14330,14341,14347,14355,14367,14376,14385,14394,14403,14412,14415,14428,14437,14441,14450,14457,14464,14478,14486,14495,14499,14509,14520,14522,14536,14542,14546,14561,14565,14574,14585,14595,14603,14605,14615,14624,14632,14643,14651,14657,14669,14676,14683,14693,14700,14709,14717,14724,14733,14745,14749,14759,14768,14776,14786,14795,14799,14808,14817,14834,14852,14860,14869,14879,14886,14903,14920,14929,14936,14945,14953,14960,14969,14978,14988,14998,15003,15008,15018,15028"),
("10","2088422633181180","0","2,5,9,20,27,31,36,40,45,50,55,63,72,75,82,87,90,94,109,111,115,125,128,141,151,158,160,168,177,188,190,198,201,207,216,218,228,234,241,249,257,261,271,276,283,294,301,304","5,15,25,33,39,44,51,62,68,75,88,97,104,114,122,131,138,148,157,160,171,181,186,199,206,214,220,228,239,243,251,260,270,276,287,295,299,305,313,319,329,333,343,350,361,369,375,384,392,399,407,416,420,423,431,439,445,454,465,472,479,490,500,509","1,15,25,27,40,42,58,66,75,76,91,100,110,118,127,136,145,154,163,170,172,187,196,205,208,222,224,232,247,257,258,273,281,284,291,300,308,316,324,338,347,356,366,374,377,390,400,408,417","6,420,425,439,445,450,459,469,479,483,504,529,546,574,848,916,930,934,950,960,968,972,976,986,996,1001,1007,1010,1020,1471,1476,1486,1491,1498,1508,1513,1528,1536,1543,1551,1562,1570,1582,1592,1599,1607,1617,1630,1641,1645,1657,1668,1679,1685,1695,1700,1704,1712,1722,1735,1742,1752,1761,1771,1778,1790,1803,1812,1819,1826,1835,1846,1854,1863,1868,1876,1883,1893,1902,1912,1926,1932,1942,1951,1960,1970,1982,1989,1998,2008,2021,2054,2064,2076,2111,2122,2124,2133,2142,2152,2162,2175,2212,2218,2233,2238,2253,2285,2295,2308,2314,2322,2336,2347,2357,2367,2374,2380,2390,2403,2416,2422,2461,2470,2477,2480,2488,2499,2505,2515,2523,2533,2536,2545,2551,2565,2598,2608,2618,2627,2633,2641,2651,2658,2667,2670,2679,2682,2687,2690,2693,2696,2705,2711,2714,2718,2725,2728,2732,2886,2889,2892,2895,2900,2903,2907,2910,2916,2919,2922,2924,2929,2931,2934,2942,2950,2954,2968,2971,2973,2976,2980,2987,2993,2996,2999,3008,3011,3014,3017,3020,3025,3039,3047,3059,3062,3070,3081,3092,3105,3110,3116,3126,3135,3148,3151,3157,3160,3169,3177,3185,3187,3188,3193,3214,3215,3225,3227,3236,3250,3257,3263,3274,3285,3293,3300,3306,3311,3316,3317,3327,3334,3346,3348,3351,3360,3367,3375,3382,3385,3393,3400,3406,3408,3409,3418,3427,3436,3443,3448,3463,3466,3469,3478,3485,3492,3495,3497,3503,3506,3508,3513,3521,3527,3537,3542,3547,3555,3558,3564,3572,3576,3588,3608,3611,3620,3639,3657,3692,3715,3749,3755,3762,3766,3773,3807,3842,3851,3865,3869,3881,3892,3945,3987,4100,4180,4320,5035,5043,5051,5057,5065,5071,5077,5084,5092,5097,5103,5110,5116,5124,5128,5136,5142,5149,5155,5163,5169,5177,5185,5193,5197,5205,5210,5216,5230,5231,5239,5247,5254,5260,5267,5275,5283,5291,5299,5307,5314,5321,5329,5338,5342,5348,5356,5364,5372,5380,5388,5396,5409,5410,5418,5427,5433,5440,5447,5455,5464,5471,5479,5486,5492,5500,5508,5516,5524,5532,5539,5547,5555,5563,5571,5579,5587,5595,5603,5615,5616,5624,5630,5636,5641,5649,5657,5663,5671,5678,5684,5690,5696,5702,5710,5719,5726,5734,5741,5748,5755,5764,5770,5778,5785,5792,5800,5808,5816,5824,5829,5837,5843,5851,5865,5866,5874,5881,5887,5892,5900,5907,5915,5922,5930,5936,5942,5950,5958,5966,5974,5980,5988,5996,6001,6009,6015,6022,6029,6034,6040,6048,6056,6063,6070,6078,6086,6094,6099,6107,6115,6123,6131,6139,6145,6152,6160,6169,6174,6182,6189,6197,6204,6212,6221,6229,6233,6241,6249,6255,6263,6271,6277,6285,6292,6300,6308,6315,6322,6327,6335,6342,6349,6357,6365,6373,6381,6390,6397,6405,6413,6419,6427,6435,6443,6451,6458,6465,6472,6478,6486,6494,6501,6510,6516,6522,6529,6537,6545,6553,6561,6569,6575,6589,6590,6596,6607,6612,6619,6628,6642,6643,6653,6659,6666,6674,6681,6687,6694,6702,6708,6713,6721,6728,6736,6744,6751,6759,6767,6775,6783,6791,6799,6804,6812,6819,6827,6835,6843,6852,6860,6866,6870,6875,6882,6887,6895,6908,6916,6924,6932,6940,6948,6962,6963,6971,6977,6983,6991,6999,7006,7018,7019,7031,7039,7040,7054,7055,7063,7070,7085,7093,7099,7105,7112,7120,7128,7137,7143,7151,7160,7171,7176,7180,7188,7193,7200,7205,7213,7217,7221,7229,7233,7240,7246,7252,7260,7263,7267,7272,7277,7282,7289,7291,7298,7304,7309,7317,7322,7337,7343,7350,7354,7369,7375,7417,7421,7428,7459,7465,7468,7473,7493,7499,7527,7533,7549,7607,7612,7621,7626,7642,7646,7726,7731,7783,7789,7795,7800,7851,7857,7937,7944,8080,8086,8104,8109,8123,8126,8167,8174,8180,8185,8193,8201,8206,8214,8235,8237,8244,8287,8296,8306,8318,8420,8467,8469,9448,9456,9464,9473,9481,9489,9498,9511,9512,9519,9527,9536,9543,9551,9559,9567,9575,9582,9590,9597,9605,9613,9621,9628,9636,9644,9651,9665,9666,9674,9684,9690,9697,9705,9712,9720,9728,9736,9745,9752,9759,9766,9773,9781,9789,9797,9805,9820,9821,9829,9837,9845,9859,9860,9868,9876,9884,9892,9900,9907,9914,9922,9930,9938,9946,9954,9963,9971,9978,9986,9994,10002,10010,10018,10026,10034,10042,10050,10058,10065,10073,10081,10088,10096,10102,10110,10118,10126,10133,10141,10149,10157,10166,10172,10180,10190,10196,10203,10211,10219,10227,10235,10243,10251,10256,10266,10274,10279,10287,10294,10302,10311,10319,10327,10335,10343,10351,10358,10366,10373,10381,10389,10397,10404,10412,10420,10428,10436,10443,10451,10459,10467,10474,10482,10490,10498,10506,10514,10521,10530,10538,10544,10552,10559,10566,10573,10581,10589,10596,10604,10611,10619,10627,10635,10640,10648,10656,10664,10672,10680,10686,10691,10698,10706,10714,10721,10729,10737,10744,10752,10762,10767,10775,10783,10797,10798,10806,10814,10822,10830,10838,10845,10853,10861,10869,10877,10885,10892,10899,10907,10915,10922,10930,10937,10944,10952,10960,10967,10975,10983,10991,10999,11007,11013,11021,11036,11037,11045,11053,11061,11066,11073,11081,11089,11097,11105,11112,11120,11126,11134,11141,11149,11156,11163,11169,11176,11185,11192,11198,11206,11214,11222,11230,11238,11246,11254,11262,11268,11274,11282,11290,11296,11304,11312,11321,11328,11336,11343,11351,11359,11367,11375,11379,11383,11390,11396,11404,11410,11420,11426,11434,11441,11449,11457,11464,11479,11480,11488,11495,11501,11509,11517,11524,11538,11539,11552,11560,11561,11568,11578,11579,11588,11594,11601,11609,11617,11623,11629,11636,11644,11652,11658,11660,11669,11678,11683,11692,11701,11710,11720,11729,11737,11746,11755,11764,11774,11779,11787,11797,11814,11817,11826,11834,11850,11851,11860,11870,11878,11887,11895,11905,11913,11921,11930,11939,11948,11953,11962,11970,11980,11988,11997,12006,12016,12025,12401,12406,12418,12420,12429,12436,12447,12455,12463,12474,12480,12485,12497,12501,12515,12520,12529,12539,12546,12554,12565,12570,12576,12588,12595,12603,12614,12623,12624,12639,12648,12657,12666,12672,12680,12688,12699,12707,12717,12723,12734,12743,12752,12761,12766,12770,12783,12792,12800,12804,12817,12823,12828,12841,12850,12859,12868,12877,12886,12894,12899,12906,12918,12923,12935,12941,12951,12960,12966,12970,12984,12993,13000,13007,13019,13025,13036,13042,13050,13055,13064,13076,13079,13091,13098,13108,13113,13119,13131,13137,13142,13156,13165,13167,13179,13187,13191,13202,13213,13216,13227,13235,13246,13250,13262,13271,13274,13288,13297,13306,13313,13323,13332,13341,13350,13358,13363,13372,13383,13387,13397,13407,13414,13417,13432,13437,13448,13451,13463,13472,13477,13489,13495,13499,13508,13520,13530,13539,13547,13556,13564,13573,13576,13586,13595,13599,13614,13621,13626,13640,13646,13653,13660,13667,13680,13682,13690,13700,13706,13719,13724,13731,13737,13748,13755,13767,13774,13785,13794,13803,13812,13819,13826,13837,13844,13851,13859,13863,13876,13885,13889,13899,13903,13914,13922,13929,13940,13943,13958,13965,13972,13983,13992,13997,14009,14018,14027,14030,14041,14049,14054,14060,14072,14078,14087,14096,14106,14112,14121,14124,14134,14140,14150,14157,14170,14179,14184,14190,14197,14209,14215,14222,14233,14238,14252,14258,14269,14276,14286,14295,14303,14308,14315,14322,14332,14340,14345,14355,14367,14376,14385,14393,14401,14412,14416,14428,14437,14443,14449,14456,14465,14478,14486,14495,14498,14510,14520,14522,14536,14542,14547,14561,14565,14573,14586,14595,14603,14606,14617,14624,14631,14645,14648,14660,14670,14679,14682,14695,14701,14711,14719,14723,14736,14743,14752,14761,14770,14777,14783,14795,14802,14809,14819,14824,14837,14841,14853,14858,14866,14880,14888,14892,14905,14909,14921,14930,14933,14946,14952,14963,14971,14980,14988,14994,15005,15012,15017,15030")`
