// Copyright 2020 The SQLFlow Authors. All rights reserved.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package testdata

// HousingSQL is .sql format data sample of boston housing dataset.
var HousingSQL = `CREATE DATABASE IF NOT EXISTS housing;
DROP TABLE IF EXISTS housing.train;
CREATE TABLE housing.train (
       f1  float,
       f2  float,
       f3  float,
	   f4  int,
	   f5  float,
	   f6  float,
	   f7  float,
	   f8  float,
	   f9  int,
	   f10 bigint,
	   f11 float,
	   f12 float,
	   f13 float,
       target double);
INSERT INTO housing.train VALUES
(1.232470,0.000000,8.140000,0.000000,0.538000,6.142000,91.700000,3.976900,4.000000,307.000000,21.000000,396.900000,18.720000,15.200000),
(0.021770,82.500000,2.030000,0.000000,0.415000,7.610000,15.700000,6.270000,2.000000,348.000000,14.700000,395.380000,3.110000,42.300000),
(4.898220,0.000000,18.100000,0.000000,0.631000,4.970000,100.000000,1.332500,24.000000,666.000000,20.200000,375.520000,3.260000,50.000000),
(0.039610,0.000000,5.190000,0.000000,0.515000,6.037000,34.500000,5.985300,5.000000,224.000000,20.200000,396.900000,8.010000,21.100000),
(3.693110,0.000000,18.100000,0.000000,0.713000,6.376000,88.400000,2.567100,24.000000,666.000000,20.200000,391.430000,14.650000,17.700000),
(0.283920,0.000000,7.380000,0.000000,0.493000,5.708000,74.300000,4.721100,5.000000,287.000000,19.600000,391.130000,11.740000,18.500000),
(9.187020,0.000000,18.100000,0.000000,0.700000,5.536000,100.000000,1.580400,24.000000,666.000000,20.200000,396.900000,23.600000,11.300000),
(4.097400,0.000000,19.580000,0.000000,0.871000,5.468000,100.000000,1.411800,5.000000,403.000000,14.700000,396.900000,26.420000,15.600000),
(2.155050,0.000000,19.580000,0.000000,0.871000,5.628000,100.000000,1.516600,5.000000,403.000000,14.700000,169.270000,16.650000,15.600000),
(1.628640,0.000000,21.890000,0.000000,0.624000,5.019000,100.000000,1.439400,4.000000,437.000000,21.200000,396.900000,34.410000,14.400000),
(9.595710,0.000000,18.100000,0.000000,0.693000,6.404000,100.000000,1.639000,24.000000,666.000000,20.200000,376.110000,20.310000,12.100000),
(18.811000,0.000000,18.100000,0.000000,0.597000,4.628000,100.000000,1.553900,24.000000,666.000000,20.200000,28.790000,34.370000,17.900000),
(0.139140,0.000000,4.050000,0.000000,0.510000,5.572000,88.500000,2.596100,5.000000,296.000000,16.600000,396.900000,14.690000,23.100000),
(3.836840,0.000000,18.100000,0.000000,0.770000,6.251000,91.100000,2.295500,24.000000,666.000000,20.200000,350.650000,14.190000,19.900000),
(0.387350,0.000000,25.650000,0.000000,0.581000,5.613000,95.600000,1.757200,2.000000,188.000000,19.100000,359.290000,27.260000,15.700000),
(73.534100,0.000000,18.100000,0.000000,0.679000,5.957000,100.000000,1.802600,24.000000,666.000000,20.200000,16.450000,20.620000,8.800000),
(6.538760,0.000000,18.100000,1.000000,0.631000,7.016000,97.500000,1.202400,24.000000,666.000000,20.200000,392.050000,2.960000,50.000000),
(0.064660,70.000000,2.240000,0.000000,0.400000,6.345000,20.100000,7.827800,5.000000,358.000000,14.800000,368.240000,4.970000,22.500000),
(0.034450,82.500000,2.030000,0.000000,0.415000,6.162000,38.400000,6.270000,2.000000,348.000000,14.700000,393.770000,7.430000,24.100000),
(0.148660,0.000000,8.560000,0.000000,0.520000,6.727000,79.900000,2.777800,5.000000,384.000000,20.900000,394.760000,9.420000,27.500000),
(37.661900,0.000000,18.100000,0.000000,0.679000,6.202000,78.700000,1.862900,24.000000,666.000000,20.200000,18.820000,14.520000,10.900000),
(0.027630,75.000000,2.950000,0.000000,0.428000,6.595000,21.800000,5.401100,3.000000,252.000000,18.300000,395.630000,4.320000,30.800000),
(0.017780,95.000000,1.470000,0.000000,0.403000,7.135000,13.900000,7.653400,3.000000,402.000000,17.000000,384.300000,4.450000,32.900000),
(0.006320,18.000000,2.310000,0.000000,0.538000,6.575000,65.200000,4.090000,1.000000,296.000000,15.300000,396.900000,4.980000,24.000000),
(0.030410,0.000000,5.190000,0.000000,0.515000,5.895000,59.600000,5.615000,5.000000,224.000000,20.200000,394.810000,10.560000,18.500000),
(9.823490,0.000000,18.100000,0.000000,0.671000,6.794000,98.800000,1.358000,24.000000,666.000000,20.200000,396.900000,21.240000,13.300000),
(0.088290,12.500000,7.870000,0.000000,0.524000,6.012000,66.600000,5.560500,5.000000,311.000000,15.200000,395.600000,12.430000,22.900000),
(0.027290,0.000000,7.070000,0.000000,0.469000,7.185000,61.100000,4.967100,2.000000,242.000000,17.800000,392.830000,4.030000,34.700000),
(0.671910,0.000000,8.140000,0.000000,0.538000,5.813000,90.300000,4.682000,4.000000,307.000000,21.000000,376.880000,14.810000,16.600000),
(0.177830,0.000000,9.690000,0.000000,0.585000,5.569000,73.500000,2.399900,6.000000,391.000000,19.200000,395.770000,15.100000,17.500000),
(0.045900,52.500000,5.320000,0.000000,0.405000,6.315000,45.600000,7.317200,6.000000,293.000000,16.600000,396.900000,7.600000,22.300000),
(5.090170,0.000000,18.100000,0.000000,0.713000,6.297000,91.800000,2.368200,24.000000,666.000000,20.200000,385.090000,17.270000,16.100000),
(7.752230,0.000000,18.100000,0.000000,0.713000,6.301000,83.700000,2.783100,24.000000,666.000000,20.200000,272.210000,16.230000,14.900000),
(1.053930,0.000000,8.140000,0.000000,0.538000,5.935000,29.300000,4.498600,4.000000,307.000000,21.000000,386.850000,6.580000,23.100000),
(0.033590,75.000000,2.950000,0.000000,0.428000,7.024000,15.800000,5.401100,3.000000,252.000000,18.300000,395.620000,1.980000,34.900000),
(0.341090,0.000000,7.380000,0.000000,0.493000,6.415000,40.100000,4.721100,5.000000,287.000000,19.600000,396.900000,6.120000,25.000000),
(0.840540,0.000000,8.140000,0.000000,0.538000,5.599000,85.700000,4.454600,4.000000,307.000000,21.000000,303.420000,16.510000,13.900000),
(1.151720,0.000000,8.140000,0.000000,0.538000,5.701000,95.000000,3.787200,4.000000,307.000000,21.000000,358.770000,18.350000,13.100000),
(0.351140,0.000000,7.380000,0.000000,0.493000,6.041000,49.900000,4.721100,5.000000,287.000000,19.600000,396.900000,7.700000,20.400000),
(0.101530,0.000000,12.830000,0.000000,0.437000,6.279000,74.500000,4.052200,5.000000,398.000000,18.700000,373.660000,11.970000,20.000000),
(0.150860,0.000000,27.740000,0.000000,0.609000,5.454000,92.700000,1.820900,4.000000,711.000000,20.100000,395.090000,18.060000,15.200000),
(0.159360,0.000000,6.910000,0.000000,0.448000,6.211000,6.500000,5.720900,3.000000,233.000000,17.900000,394.460000,7.440000,24.700000),
(0.050830,0.000000,5.190000,0.000000,0.515000,6.316000,38.100000,6.458400,5.000000,224.000000,20.200000,389.710000,5.680000,22.200000),
(11.087400,0.000000,18.100000,0.000000,0.718000,6.411000,100.000000,1.858900,24.000000,666.000000,20.200000,318.750000,15.020000,16.700000),
(13.359800,0.000000,18.100000,0.000000,0.693000,5.887000,94.700000,1.782100,24.000000,666.000000,20.200000,396.900000,16.350000,12.700000),
(0.750260,0.000000,8.140000,0.000000,0.538000,5.924000,94.100000,4.399600,4.000000,307.000000,21.000000,394.330000,16.300000,15.600000),
(0.329820,0.000000,21.890000,0.000000,0.624000,5.822000,95.400000,2.469900,4.000000,437.000000,21.200000,388.690000,15.030000,18.400000),
(1.002450,0.000000,8.140000,0.000000,0.538000,6.674000,87.300000,4.239000,4.000000,307.000000,21.000000,380.230000,11.980000,21.000000),
(0.656650,20.000000,3.970000,0.000000,0.647000,6.842000,100.000000,2.010700,5.000000,264.000000,13.000000,391.930000,6.900000,30.100000),
(6.962150,0.000000,18.100000,0.000000,0.700000,5.713000,97.000000,1.926500,24.000000,666.000000,20.200000,394.430000,17.110000,15.100000),
(0.061510,0.000000,5.190000,0.000000,0.515000,5.968000,58.500000,4.812200,5.000000,224.000000,20.200000,396.900000,9.290000,18.700000),
(14.420800,0.000000,18.100000,0.000000,0.740000,6.461000,93.300000,2.002600,24.000000,666.000000,20.200000,27.490000,18.050000,9.600000),
(0.511830,0.000000,6.200000,0.000000,0.507000,7.358000,71.600000,4.148000,8.000000,307.000000,17.400000,390.070000,4.730000,31.500000),
(0.042970,52.500000,5.320000,0.000000,0.405000,6.565000,22.900000,7.317200,6.000000,293.000000,16.600000,371.720000,9.510000,24.800000),
(2.313900,0.000000,19.580000,0.000000,0.605000,5.880000,97.300000,2.388700,5.000000,403.000000,14.700000,348.130000,12.030000,19.100000),
(0.068990,0.000000,25.650000,0.000000,0.581000,5.870000,69.700000,2.257700,2.000000,188.000000,19.100000,389.150000,14.370000,22.000000),
(8.492130,0.000000,18.100000,0.000000,0.584000,6.348000,86.100000,2.052700,24.000000,666.000000,20.200000,83.450000,17.640000,14.500000),
(7.367110,0.000000,18.100000,0.000000,0.679000,6.193000,78.100000,1.935600,24.000000,666.000000,20.200000,96.730000,21.520000,11.000000),
(0.096040,40.000000,6.410000,0.000000,0.447000,6.854000,42.800000,4.267300,4.000000,254.000000,17.600000,396.900000,2.980000,32.000000),
(0.066640,0.000000,4.050000,0.000000,0.510000,6.546000,33.100000,3.132300,5.000000,296.000000,16.600000,390.960000,5.330000,29.400000),
(0.071650,0.000000,25.650000,0.000000,0.581000,6.004000,84.100000,2.197400,2.000000,188.000000,19.100000,377.670000,14.270000,20.300000),
(0.114600,20.000000,6.960000,0.000000,0.464000,6.538000,58.700000,3.917500,3.000000,223.000000,18.600000,394.960000,7.730000,24.400000),
(10.233000,0.000000,18.100000,0.000000,0.614000,6.185000,96.700000,2.170500,24.000000,666.000000,20.200000,379.700000,18.030000,14.600000),
(0.171200,0.000000,8.560000,0.000000,0.520000,5.836000,91.900000,2.211000,5.000000,384.000000,20.900000,395.670000,18.660000,19.500000),
(4.752370,0.000000,18.100000,0.000000,0.713000,6.525000,86.500000,2.435800,24.000000,666.000000,20.200000,50.920000,18.130000,14.100000),
(5.581070,0.000000,18.100000,0.000000,0.713000,6.436000,87.900000,2.315800,24.000000,666.000000,20.200000,100.190000,16.220000,14.300000),
(0.976170,0.000000,21.890000,0.000000,0.624000,5.757000,98.400000,2.346000,4.000000,437.000000,21.200000,262.760000,17.310000,15.600000),
(22.051100,0.000000,18.100000,0.000000,0.740000,5.818000,92.400000,1.866200,24.000000,666.000000,20.200000,391.450000,22.110000,10.500000),
(9.916550,0.000000,18.100000,0.000000,0.693000,5.852000,77.800000,1.500400,24.000000,666.000000,20.200000,338.160000,29.970000,6.300000),
(0.375780,0.000000,10.590000,1.000000,0.489000,5.404000,88.600000,3.665000,4.000000,277.000000,18.600000,395.240000,23.980000,19.300000),
(0.171420,0.000000,6.910000,0.000000,0.448000,5.682000,33.800000,5.100400,3.000000,233.000000,17.900000,396.900000,10.210000,19.300000),
(11.160400,0.000000,18.100000,0.000000,0.740000,6.629000,94.600000,2.124700,24.000000,666.000000,20.200000,109.850000,23.270000,13.400000),
(0.086640,45.000000,3.440000,0.000000,0.437000,7.178000,26.300000,6.479800,5.000000,398.000000,15.200000,390.490000,2.870000,36.400000),
(0.318270,0.000000,9.900000,0.000000,0.544000,5.914000,83.200000,3.998600,4.000000,304.000000,18.400000,390.700000,18.330000,17.800000),
(1.612820,0.000000,8.140000,0.000000,0.538000,6.096000,96.900000,3.759800,4.000000,307.000000,21.000000,248.310000,20.340000,13.500000),
(0.211240,12.500000,7.870000,0.000000,0.524000,5.631000,100.000000,6.082100,5.000000,311.000000,15.200000,386.630000,29.930000,16.500000),
(15.860300,0.000000,18.100000,0.000000,0.679000,5.896000,95.400000,1.909600,24.000000,666.000000,20.200000,7.680000,24.390000,8.300000),
(0.881250,0.000000,21.890000,0.000000,0.624000,5.637000,94.700000,1.979900,4.000000,437.000000,21.200000,396.900000,18.340000,14.300000),
(0.171710,25.000000,5.130000,0.000000,0.453000,5.966000,93.400000,6.818500,8.000000,284.000000,19.700000,378.080000,14.440000,16.000000),
(3.321050,0.000000,19.580000,1.000000,0.871000,5.403000,100.000000,1.321600,5.000000,403.000000,14.700000,396.900000,26.820000,13.400000),
(0.129320,0.000000,13.920000,0.000000,0.437000,6.678000,31.100000,5.960400,4.000000,289.000000,16.000000,396.900000,6.270000,28.600000),
(0.540500,20.000000,3.970000,0.000000,0.575000,7.470000,52.600000,2.872000,5.000000,264.000000,13.000000,390.300000,3.160000,43.500000),
(0.802710,0.000000,8.140000,0.000000,0.538000,5.456000,36.600000,3.796500,4.000000,307.000000,21.000000,288.990000,11.690000,20.200000),
(0.010960,55.000000,2.250000,0.000000,0.389000,6.453000,31.900000,7.307300,1.000000,300.000000,15.300000,394.720000,8.230000,22.000000),
(0.590050,0.000000,21.890000,0.000000,0.624000,6.372000,97.900000,2.327400,4.000000,437.000000,21.200000,385.760000,11.120000,23.000000),
(0.037380,0.000000,5.190000,0.000000,0.515000,6.310000,38.500000,6.458400,5.000000,224.000000,20.200000,389.400000,6.750000,20.700000),
(5.872050,0.000000,18.100000,0.000000,0.693000,6.405000,96.000000,1.676800,24.000000,666.000000,20.200000,396.900000,19.370000,12.500000),
(0.035100,95.000000,2.680000,0.000000,0.416100,7.853000,33.200000,5.118000,4.000000,224.000000,14.700000,392.780000,3.810000,48.500000),
(2.368620,0.000000,19.580000,0.000000,0.871000,4.926000,95.700000,1.460800,5.000000,403.000000,14.700000,391.710000,29.530000,14.600000),
(7.050420,0.000000,18.100000,0.000000,0.614000,6.103000,85.100000,2.021800,24.000000,666.000000,20.200000,2.520000,23.290000,13.400000),
(5.708180,0.000000,18.100000,0.000000,0.532000,6.750000,74.900000,3.331700,24.000000,666.000000,20.200000,393.070000,7.740000,23.700000),
(0.020090,95.000000,2.680000,0.000000,0.416100,8.034000,31.900000,5.118000,4.000000,224.000000,14.700000,390.550000,2.880000,50.000000),
(0.081990,0.000000,13.920000,0.000000,0.437000,6.009000,42.300000,5.502700,4.000000,289.000000,16.000000,396.900000,10.400000,21.700000),
(0.065880,0.000000,2.460000,0.000000,0.488000,7.765000,83.300000,2.741000,3.000000,193.000000,17.800000,395.560000,7.560000,39.800000),
(0.120830,0.000000,2.890000,0.000000,0.445000,8.069000,76.000000,3.495200,2.000000,276.000000,18.000000,396.900000,4.210000,38.700000),
(0.102900,30.000000,4.930000,0.000000,0.428000,6.358000,52.900000,7.035500,6.000000,300.000000,16.600000,372.750000,11.220000,22.200000),
(0.031500,95.000000,1.470000,0.000000,0.403000,6.975000,15.300000,7.653400,3.000000,402.000000,17.000000,396.900000,4.560000,34.900000),
(0.051880,0.000000,4.490000,0.000000,0.449000,6.015000,45.100000,4.427200,3.000000,247.000000,18.500000,395.990000,12.860000,22.500000),
(0.021870,60.000000,2.930000,0.000000,0.401000,6.800000,9.900000,6.219600,1.000000,265.000000,15.600000,393.370000,5.030000,31.100000),
(0.029850,0.000000,2.180000,0.000000,0.458000,6.430000,58.700000,6.062200,3.000000,222.000000,18.700000,394.120000,5.210000,28.700000),
(0.061290,20.000000,3.330000,1.000000,0.442900,7.645000,49.700000,5.211900,5.000000,216.000000,14.900000,377.070000,3.010000,46.000000),
(0.575290,0.000000,6.200000,0.000000,0.507000,8.337000,73.300000,3.838400,8.000000,307.000000,17.400000,385.910000,2.470000,41.700000),
(0.475470,0.000000,9.900000,0.000000,0.544000,6.113000,58.800000,4.001900,4.000000,304.000000,18.400000,396.230000,12.730000,21.000000),
(0.127440,0.000000,6.910000,0.000000,0.448000,6.770000,2.900000,5.720900,3.000000,233.000000,17.900000,385.410000,4.840000,26.600000),
(51.135800,0.000000,18.100000,0.000000,0.597000,5.757000,100.000000,1.413000,24.000000,666.000000,20.200000,2.600000,10.110000,15.000000),
(0.140300,22.000000,5.860000,0.000000,0.431000,6.487000,13.000000,7.396700,7.000000,330.000000,19.100000,396.280000,5.900000,24.400000),
(6.393120,0.000000,18.100000,0.000000,0.584000,6.162000,97.400000,2.206000,24.000000,666.000000,20.200000,302.760000,24.100000,13.300000),
(0.122690,0.000000,6.910000,0.000000,0.448000,6.069000,40.000000,5.720900,3.000000,233.000000,17.900000,389.390000,9.550000,21.200000),
(8.792120,0.000000,18.100000,0.000000,0.584000,5.565000,70.600000,2.063500,24.000000,666.000000,20.200000,3.650000,17.160000,11.700000),
(0.174460,0.000000,10.590000,1.000000,0.489000,5.960000,92.100000,3.877100,4.000000,277.000000,18.600000,393.250000,17.270000,21.700000),
(0.263630,0.000000,8.560000,0.000000,0.520000,6.229000,91.200000,2.545100,5.000000,384.000000,20.900000,391.230000,15.550000,19.400000),
(2.010190,0.000000,19.580000,0.000000,0.605000,7.929000,96.200000,2.045900,5.000000,403.000000,14.700000,369.300000,3.700000,50.000000),
(0.100840,0.000000,10.010000,0.000000,0.547000,6.715000,81.600000,2.677500,6.000000,432.000000,17.800000,395.590000,10.160000,22.800000),
(0.289600,0.000000,9.690000,0.000000,0.585000,5.390000,72.900000,2.798600,6.000000,391.000000,19.200000,396.900000,21.140000,19.700000),
(0.020550,85.000000,0.740000,0.000000,0.410000,6.383000,35.700000,9.187600,2.000000,313.000000,17.300000,396.900000,5.770000,24.700000),
(0.069050,0.000000,2.180000,0.000000,0.458000,7.147000,54.200000,6.062200,3.000000,222.000000,18.700000,396.900000,5.330000,36.200000),
(7.022590,0.000000,18.100000,0.000000,0.718000,6.006000,95.300000,1.874600,24.000000,666.000000,20.200000,319.980000,15.700000,14.200000),
(0.170040,12.500000,7.870000,0.000000,0.524000,6.004000,85.900000,6.592100,5.000000,311.000000,15.200000,386.710000,17.100000,18.900000),
(0.171340,0.000000,10.010000,0.000000,0.547000,5.928000,88.200000,2.463100,6.000000,432.000000,17.800000,344.910000,15.760000,18.300000),
(0.106590,80.000000,1.910000,0.000000,0.413000,5.936000,19.500000,10.585700,4.000000,334.000000,22.000000,376.040000,5.570000,20.600000),
(0.054250,0.000000,4.050000,0.000000,0.510000,6.315000,73.400000,3.317500,5.000000,296.000000,16.600000,395.600000,6.290000,24.600000),
(0.725800,0.000000,8.140000,0.000000,0.538000,5.727000,69.500000,3.796500,4.000000,307.000000,21.000000,390.950000,11.280000,18.200000),
(15.177200,0.000000,18.100000,0.000000,0.740000,6.152000,100.000000,1.914200,24.000000,666.000000,20.200000,9.320000,26.450000,8.700000),
(0.015380,90.000000,3.750000,0.000000,0.394000,7.454000,34.200000,6.336100,3.000000,244.000000,15.900000,386.340000,3.110000,44.000000),
(88.976200,0.000000,18.100000,0.000000,0.671000,6.968000,91.900000,1.416500,24.000000,666.000000,20.200000,396.900000,17.210000,10.400000),
(1.387990,0.000000,8.140000,0.000000,0.538000,5.950000,82.000000,3.990000,4.000000,307.000000,21.000000,232.600000,27.710000,13.200000),
(0.056460,0.000000,12.830000,0.000000,0.437000,6.232000,53.700000,5.014100,5.000000,398.000000,18.700000,386.400000,12.340000,21.200000),
(0.090680,45.000000,3.440000,0.000000,0.437000,6.951000,21.500000,6.479800,5.000000,398.000000,15.200000,377.680000,5.100000,37.000000),
(0.785700,20.000000,3.970000,0.000000,0.647000,7.014000,84.600000,2.132900,5.000000,264.000000,13.000000,384.070000,14.790000,30.700000),
(0.062110,40.000000,1.250000,0.000000,0.429000,6.490000,44.400000,8.792100,1.000000,335.000000,19.700000,396.900000,5.980000,22.900000),
(0.188360,0.000000,6.910000,0.000000,0.448000,5.786000,33.300000,5.100400,3.000000,233.000000,17.900000,396.900000,14.150000,20.000000),
(0.144760,0.000000,10.010000,0.000000,0.547000,5.731000,65.200000,2.759200,6.000000,432.000000,17.800000,391.500000,13.610000,19.300000),
(0.462960,0.000000,6.200000,0.000000,0.504000,7.412000,76.900000,3.671500,8.000000,307.000000,17.400000,376.140000,5.250000,31.700000),
(0.078750,45.000000,3.440000,0.000000,0.437000,6.782000,41.100000,3.788600,5.000000,398.000000,15.200000,393.870000,6.680000,32.000000),
(0.178990,0.000000,9.690000,0.000000,0.585000,5.670000,28.800000,2.798600,6.000000,391.000000,19.200000,393.290000,17.600000,23.100000),
(0.098490,0.000000,25.650000,0.000000,0.581000,5.879000,95.800000,2.006300,2.000000,188.000000,19.100000,379.380000,17.580000,18.800000),
(15.874400,0.000000,18.100000,0.000000,0.671000,6.545000,99.100000,1.519200,24.000000,666.000000,20.200000,396.900000,21.080000,10.900000),
(0.611540,20.000000,3.970000,0.000000,0.647000,8.704000,86.900000,1.801000,5.000000,264.000000,13.000000,389.700000,5.120000,50.000000),
(0.103280,25.000000,5.130000,0.000000,0.453000,5.927000,47.200000,6.932000,8.000000,284.000000,19.700000,396.900000,9.220000,19.600000),
(67.920800,0.000000,18.100000,0.000000,0.693000,5.683000,100.000000,1.425400,24.000000,666.000000,20.200000,384.970000,22.980000,5.000000),
(0.253870,0.000000,6.910000,0.000000,0.448000,5.399000,95.300000,5.870000,3.000000,233.000000,17.900000,396.900000,30.810000,14.400000),
(0.128020,0.000000,8.560000,0.000000,0.520000,6.474000,97.100000,2.432900,5.000000,384.000000,20.900000,395.240000,12.270000,19.800000),
(8.644760,0.000000,18.100000,0.000000,0.693000,6.193000,92.600000,1.791200,24.000000,666.000000,20.200000,396.900000,15.170000,13.800000),
(1.192940,0.000000,21.890000,0.000000,0.624000,6.326000,97.700000,2.271000,4.000000,437.000000,21.200000,396.900000,12.260000,19.600000),
(0.060760,0.000000,11.930000,0.000000,0.573000,6.976000,91.000000,2.167500,1.000000,273.000000,21.000000,396.900000,5.640000,23.900000),
(0.164390,22.000000,5.860000,0.000000,0.431000,6.433000,49.100000,7.826500,7.000000,330.000000,19.100000,374.710000,9.520000,24.500000),
(0.126500,25.000000,5.130000,0.000000,0.453000,6.762000,43.400000,7.980900,8.000000,284.000000,19.700000,395.580000,9.500000,25.000000),
(4.348790,0.000000,18.100000,0.000000,0.580000,6.167000,84.000000,3.033400,24.000000,666.000000,20.200000,396.900000,16.290000,19.900000),
(14.050700,0.000000,18.100000,0.000000,0.597000,6.657000,100.000000,1.527500,24.000000,666.000000,20.200000,35.050000,21.220000,17.200000),
(0.191860,0.000000,7.380000,0.000000,0.493000,6.431000,14.700000,5.415900,5.000000,287.000000,19.600000,393.680000,5.080000,24.600000),
(8.200580,0.000000,18.100000,0.000000,0.713000,5.936000,80.300000,2.779200,24.000000,666.000000,20.200000,3.500000,16.940000,13.500000),
(0.028990,40.000000,1.250000,0.000000,0.429000,6.939000,34.500000,8.792100,1.000000,335.000000,19.700000,389.850000,5.890000,26.600000),
(0.115040,0.000000,2.890000,0.000000,0.445000,6.163000,69.600000,3.495200,2.000000,276.000000,18.000000,391.830000,11.340000,21.400000),
(0.047410,0.000000,11.930000,0.000000,0.573000,6.030000,80.800000,2.505000,1.000000,273.000000,21.000000,396.900000,7.880000,11.900000),
(0.136420,0.000000,10.590000,0.000000,0.489000,5.891000,22.300000,3.945400,4.000000,277.000000,18.600000,396.900000,10.870000,22.600000),
(1.496320,0.000000,19.580000,0.000000,0.871000,5.404000,100.000000,1.591600,5.000000,403.000000,14.700000,341.600000,13.280000,19.600000),
(41.529200,0.000000,18.100000,0.000000,0.693000,5.531000,85.400000,1.607400,24.000000,666.000000,20.200000,329.460000,27.380000,8.500000),
(0.082440,30.000000,4.930000,0.000000,0.428000,6.481000,18.500000,6.189900,6.000000,300.000000,16.600000,379.410000,6.360000,23.700000),
(13.522200,0.000000,18.100000,0.000000,0.631000,3.863000,100.000000,1.510600,24.000000,666.000000,20.200000,131.420000,13.330000,23.100000),
(0.217190,0.000000,10.590000,1.000000,0.489000,5.807000,53.800000,3.652600,4.000000,277.000000,18.600000,390.940000,16.030000,22.400000),
(0.196570,22.000000,5.860000,0.000000,0.431000,6.226000,79.200000,8.055500,7.000000,330.000000,19.100000,376.140000,10.150000,20.500000),
(0.056600,0.000000,3.410000,0.000000,0.489000,7.007000,86.300000,3.421700,2.000000,270.000000,17.800000,396.900000,5.500000,23.600000),
(0.772990,0.000000,8.140000,0.000000,0.538000,6.495000,94.400000,4.454700,4.000000,307.000000,21.000000,387.940000,12.800000,18.400000),
(0.221880,20.000000,6.960000,1.000000,0.464000,7.691000,51.800000,4.366500,3.000000,223.000000,18.600000,390.770000,6.580000,35.200000),
(0.018700,85.000000,4.150000,0.000000,0.429000,6.516000,27.700000,8.535300,4.000000,351.000000,17.900000,392.430000,6.360000,23.100000),
(11.951100,0.000000,18.100000,0.000000,0.659000,5.608000,100.000000,1.285200,24.000000,666.000000,20.200000,332.090000,12.130000,27.900000),
(0.033060,0.000000,5.190000,0.000000,0.515000,6.059000,37.300000,4.812200,5.000000,224.000000,20.200000,396.140000,8.510000,20.600000),
(0.127570,30.000000,4.930000,0.000000,0.428000,6.393000,7.800000,7.035500,6.000000,300.000000,16.600000,374.710000,5.190000,23.700000),
(0.041130,25.000000,4.860000,0.000000,0.426000,6.727000,33.500000,5.400700,4.000000,281.000000,19.000000,396.900000,5.290000,28.000000),
(0.105740,0.000000,27.740000,0.000000,0.609000,5.983000,98.800000,1.868100,4.000000,711.000000,20.100000,390.110000,18.070000,13.600000),
(0.053720,0.000000,13.920000,0.000000,0.437000,6.549000,51.000000,5.960400,4.000000,289.000000,16.000000,392.850000,7.390000,27.100000),
(0.091780,0.000000,4.050000,0.000000,0.510000,6.416000,84.100000,2.646300,5.000000,296.000000,16.600000,395.500000,9.040000,23.600000),
(4.835670,0.000000,18.100000,0.000000,0.583000,5.905000,53.200000,3.152300,24.000000,666.000000,20.200000,388.220000,11.450000,20.600000),
(0.043010,80.000000,1.910000,0.000000,0.413000,5.663000,21.900000,10.585700,4.000000,334.000000,22.000000,382.800000,8.050000,18.200000),
(0.093780,12.500000,7.870000,0.000000,0.524000,5.889000,39.000000,5.450900,5.000000,311.000000,15.200000,390.500000,15.710000,21.700000),
(0.352330,0.000000,21.890000,0.000000,0.624000,6.454000,98.400000,1.849800,4.000000,437.000000,21.200000,394.080000,14.590000,17.100000),
(11.812300,0.000000,18.100000,0.000000,0.718000,6.824000,76.500000,1.794000,24.000000,666.000000,20.200000,48.450000,22.740000,8.400000),
(0.141500,0.000000,6.910000,0.000000,0.448000,6.169000,6.600000,5.720900,3.000000,233.000000,17.900000,383.370000,5.810000,25.300000),
(2.379340,0.000000,19.580000,0.000000,0.871000,6.130000,100.000000,1.419100,5.000000,403.000000,14.700000,172.910000,27.800000,13.800000),
(0.110270,25.000000,5.130000,0.000000,0.453000,6.456000,67.800000,7.225500,8.000000,284.000000,19.700000,396.900000,6.730000,22.200000),
(5.666370,0.000000,18.100000,0.000000,0.740000,6.219000,100.000000,2.004800,24.000000,666.000000,20.200000,395.690000,16.590000,18.400000),
(0.090650,20.000000,6.960000,1.000000,0.464000,5.920000,61.500000,3.917500,3.000000,223.000000,18.600000,391.340000,13.650000,20.700000),
(0.412380,0.000000,6.200000,0.000000,0.504000,7.163000,79.900000,3.215700,8.000000,307.000000,17.400000,372.080000,6.360000,31.600000),
(0.069110,45.000000,3.440000,0.000000,0.437000,6.739000,30.800000,6.479800,5.000000,398.000000,15.200000,389.710000,4.690000,30.500000),
(0.083870,0.000000,12.830000,0.000000,0.437000,5.874000,36.600000,4.502600,5.000000,398.000000,18.700000,396.060000,9.100000,20.300000),
(20.084900,0.000000,18.100000,0.000000,0.700000,4.368000,91.200000,1.439500,24.000000,666.000000,20.200000,285.830000,30.630000,8.800000),
(0.150980,0.000000,10.010000,0.000000,0.547000,6.021000,82.600000,2.747400,6.000000,432.000000,17.800000,394.510000,10.300000,19.200000),
(0.261690,0.000000,9.900000,0.000000,0.544000,6.023000,90.400000,2.834000,4.000000,304.000000,18.400000,396.300000,11.720000,19.400000),
(0.402020,0.000000,9.900000,0.000000,0.544000,6.382000,67.200000,3.532500,4.000000,304.000000,18.400000,395.210000,10.360000,23.100000),
(0.114250,0.000000,13.890000,1.000000,0.550000,6.373000,92.400000,3.363300,5.000000,276.000000,16.400000,393.740000,10.500000,23.000000),
(0.955770,0.000000,8.140000,0.000000,0.538000,6.047000,88.800000,4.453400,4.000000,307.000000,21.000000,306.380000,17.280000,14.800000),
(0.520140,20.000000,3.970000,0.000000,0.647000,8.398000,91.500000,2.288500,5.000000,264.000000,13.000000,386.860000,5.910000,48.800000),
(0.084470,0.000000,4.050000,0.000000,0.510000,5.859000,68.700000,2.701900,5.000000,296.000000,16.600000,393.230000,9.640000,22.600000),
(0.075030,33.000000,2.180000,0.000000,0.472000,7.420000,71.900000,3.099200,7.000000,222.000000,18.400000,396.900000,6.470000,33.400000),
(0.299160,20.000000,6.960000,0.000000,0.464000,5.856000,42.100000,4.429000,3.000000,223.000000,18.600000,388.650000,13.000000,21.100000),
(1.251790,0.000000,8.140000,0.000000,0.538000,5.570000,98.100000,3.797900,4.000000,307.000000,21.000000,376.570000,21.020000,13.600000),
(0.009060,90.000000,2.970000,0.000000,0.400000,7.088000,20.800000,7.307300,1.000000,285.000000,15.300000,394.720000,7.850000,32.200000),
(23.648200,0.000000,18.100000,0.000000,0.671000,6.380000,96.200000,1.386100,24.000000,666.000000,20.200000,396.900000,23.690000,13.100000),
(0.049810,21.000000,5.640000,0.000000,0.439000,5.998000,21.400000,6.814700,4.000000,243.000000,16.800000,396.900000,8.430000,23.400000),
(0.064170,0.000000,5.960000,0.000000,0.499000,5.933000,68.200000,3.360300,5.000000,279.000000,19.200000,396.900000,9.680000,18.900000),
(0.044620,25.000000,4.860000,0.000000,0.426000,6.619000,70.400000,5.400700,4.000000,281.000000,19.000000,395.630000,7.220000,23.900000),
(2.779740,0.000000,19.580000,0.000000,0.871000,4.903000,97.800000,1.345900,5.000000,403.000000,14.700000,396.900000,29.290000,11.800000),
(0.092520,30.000000,4.930000,0.000000,0.428000,6.606000,42.200000,6.189900,6.000000,300.000000,16.600000,383.780000,7.370000,23.300000),
(0.761620,20.000000,3.970000,0.000000,0.647000,5.560000,62.800000,1.986500,5.000000,264.000000,13.000000,392.400000,10.450000,22.800000),
(0.852040,0.000000,8.140000,0.000000,0.538000,5.965000,89.200000,4.012300,4.000000,307.000000,21.000000,392.530000,13.830000,19.600000),
(4.871410,0.000000,18.100000,0.000000,0.614000,6.484000,93.600000,2.305300,24.000000,666.000000,20.200000,396.210000,18.680000,16.700000),
(6.717720,0.000000,18.100000,0.000000,0.713000,6.749000,92.600000,2.323600,24.000000,666.000000,20.200000,0.320000,17.440000,13.400000),
(0.241030,0.000000,7.380000,0.000000,0.493000,6.083000,43.700000,5.415900,5.000000,287.000000,19.600000,396.900000,12.790000,22.200000),
(0.130580,0.000000,10.010000,0.000000,0.547000,5.872000,73.100000,2.477500,6.000000,432.000000,17.800000,338.630000,15.370000,20.400000),
(0.173310,0.000000,9.690000,0.000000,0.585000,5.707000,54.000000,2.381700,6.000000,391.000000,19.200000,396.900000,12.010000,21.800000),
(0.083080,0.000000,2.460000,0.000000,0.488000,5.604000,89.800000,2.987900,3.000000,193.000000,17.800000,391.000000,13.980000,26.400000),
(9.513630,0.000000,18.100000,0.000000,0.713000,6.728000,94.100000,2.496100,24.000000,666.000000,20.200000,6.680000,18.710000,14.900000),
(0.079500,60.000000,1.690000,0.000000,0.411000,6.579000,35.900000,10.710300,4.000000,411.000000,18.300000,370.780000,5.490000,24.100000),
(2.300400,0.000000,19.580000,0.000000,0.605000,6.319000,96.100000,2.100000,5.000000,403.000000,14.700000,297.090000,11.100000,23.800000),
(7.992480,0.000000,18.100000,0.000000,0.700000,5.520000,100.000000,1.533100,24.000000,666.000000,20.200000,396.900000,24.560000,12.300000),
(0.079780,40.000000,6.410000,0.000000,0.447000,6.482000,32.100000,4.140300,4.000000,254.000000,17.600000,396.900000,7.190000,29.100000),
(0.080140,0.000000,5.960000,0.000000,0.499000,5.850000,41.500000,3.934200,5.000000,279.000000,19.200000,396.900000,8.770000,21.000000),
(0.132620,0.000000,8.560000,0.000000,0.520000,5.851000,96.700000,2.106900,5.000000,384.000000,20.900000,394.050000,16.470000,19.500000),
(1.425020,0.000000,19.580000,0.000000,0.871000,6.510000,100.000000,1.765900,5.000000,403.000000,14.700000,364.310000,7.390000,23.300000),
(0.369200,0.000000,9.900000,0.000000,0.544000,6.567000,87.300000,3.602300,4.000000,304.000000,18.400000,395.690000,9.280000,23.800000),
(8.248090,0.000000,18.100000,0.000000,0.713000,7.393000,99.300000,2.452700,24.000000,666.000000,20.200000,375.870000,16.740000,17.800000),
(8.151740,0.000000,18.100000,0.000000,0.700000,5.390000,98.900000,1.728100,24.000000,666.000000,20.200000,396.900000,20.850000,11.500000),
(0.158760,0.000000,10.810000,0.000000,0.413000,5.961000,17.500000,5.287300,4.000000,305.000000,19.200000,376.940000,9.880000,21.700000),
(0.627390,0.000000,8.140000,0.000000,0.538000,5.834000,56.500000,4.498600,4.000000,307.000000,21.000000,395.620000,8.470000,19.900000),
(4.541920,0.000000,18.100000,0.000000,0.770000,6.398000,88.000000,2.518200,24.000000,666.000000,20.200000,374.560000,7.790000,25.000000),
(0.032370,0.000000,2.180000,0.000000,0.458000,6.998000,45.800000,6.062200,3.000000,222.000000,18.700000,394.630000,2.940000,33.400000),
(0.035020,80.000000,4.950000,0.000000,0.411000,6.861000,27.900000,5.116700,4.000000,245.000000,19.200000,396.900000,3.330000,28.500000),
(7.839320,0.000000,18.100000,0.000000,0.655000,6.209000,65.400000,2.963400,24.000000,666.000000,20.200000,396.900000,13.220000,21.400000),
(1.342840,0.000000,19.580000,0.000000,0.605000,6.066000,100.000000,1.757300,5.000000,403.000000,14.700000,353.890000,6.430000,24.300000),
(4.555870,0.000000,18.100000,0.000000,0.718000,3.561000,87.900000,1.613200,24.000000,666.000000,20.200000,354.700000,7.120000,27.500000),
(0.100000,34.000000,6.090000,0.000000,0.433000,6.982000,17.700000,5.491700,7.000000,329.000000,16.100000,390.430000,4.860000,33.100000),
(0.259150,0.000000,21.890000,0.000000,0.624000,5.693000,96.000000,1.788300,4.000000,437.000000,21.200000,392.110000,17.190000,16.200000),
(0.045600,0.000000,13.890000,1.000000,0.550000,5.888000,56.000000,3.112100,5.000000,276.000000,16.400000,392.800000,13.510000,23.300000),
(0.331470,0.000000,6.200000,0.000000,0.507000,8.247000,70.400000,3.651900,8.000000,307.000000,17.400000,378.950000,3.950000,48.300000),
(0.042030,28.000000,15.040000,0.000000,0.464000,6.442000,53.600000,3.665900,4.000000,270.000000,18.200000,395.010000,8.160000,22.900000),
(0.492980,0.000000,9.900000,0.000000,0.544000,6.635000,82.500000,3.317500,4.000000,304.000000,18.400000,396.900000,4.540000,22.800000),
(2.446680,0.000000,19.580000,0.000000,0.871000,5.272000,94.000000,1.736400,5.000000,403.000000,14.700000,88.630000,16.140000,13.100000),
(4.668830,0.000000,18.100000,0.000000,0.713000,5.976000,87.900000,2.580600,24.000000,666.000000,20.200000,10.480000,19.010000,12.700000),
(4.261310,0.000000,18.100000,0.000000,0.770000,6.112000,81.300000,2.509100,24.000000,666.000000,20.200000,390.740000,12.670000,22.600000),
(19.609100,0.000000,18.100000,0.000000,0.671000,7.313000,97.900000,1.316300,24.000000,666.000000,20.200000,396.900000,13.440000,15.000000),
(1.126580,0.000000,19.580000,1.000000,0.871000,5.012000,88.000000,1.610200,5.000000,403.000000,14.700000,343.280000,12.120000,15.300000),
(24.393800,0.000000,18.100000,0.000000,0.700000,4.652000,100.000000,1.467200,24.000000,666.000000,20.200000,396.900000,28.280000,10.500000),
(0.330450,0.000000,6.200000,0.000000,0.507000,6.086000,61.500000,3.651900,8.000000,307.000000,17.400000,376.750000,10.880000,24.000000),
(0.142310,0.000000,10.010000,0.000000,0.547000,6.254000,84.200000,2.256500,6.000000,432.000000,17.800000,388.740000,10.450000,18.500000),
(0.407710,0.000000,6.200000,1.000000,0.507000,6.164000,91.300000,3.048000,8.000000,307.000000,17.400000,395.240000,21.460000,21.700000),
(0.034270,0.000000,5.190000,0.000000,0.515000,5.869000,46.300000,5.231100,5.000000,224.000000,20.200000,396.900000,9.800000,19.500000),
(0.104690,40.000000,6.410000,1.000000,0.447000,7.267000,49.000000,4.787200,4.000000,254.000000,17.600000,389.250000,6.050000,33.200000),
(5.293050,0.000000,18.100000,0.000000,0.700000,6.051000,82.500000,2.167800,24.000000,666.000000,20.200000,378.380000,18.760000,23.200000),
(38.351800,0.000000,18.100000,0.000000,0.693000,5.453000,100.000000,1.489600,24.000000,666.000000,20.200000,396.900000,30.590000,5.000000),
(15.575700,0.000000,18.100000,0.000000,0.580000,5.926000,71.000000,2.908400,24.000000,666.000000,20.200000,368.740000,18.130000,19.100000),
(1.130810,0.000000,8.140000,0.000000,0.538000,5.713000,94.100000,4.233000,4.000000,307.000000,21.000000,360.170000,22.600000,12.700000),
(2.449530,0.000000,19.580000,0.000000,0.605000,6.402000,95.200000,2.262500,5.000000,403.000000,14.700000,330.040000,11.320000,22.300000),
(17.866700,0.000000,18.100000,0.000000,0.671000,6.223000,100.000000,1.386100,24.000000,666.000000,20.200000,393.740000,21.780000,10.200000),
(15.288000,0.000000,18.100000,0.000000,0.671000,6.649000,93.300000,1.344900,24.000000,666.000000,20.200000,363.020000,23.240000,13.900000),
(28.655800,0.000000,18.100000,0.000000,0.597000,5.155000,100.000000,1.589400,24.000000,666.000000,20.200000,210.970000,20.080000,16.300000),
(1.413850,0.000000,19.580000,1.000000,0.871000,6.129000,96.000000,1.749400,5.000000,403.000000,14.700000,321.020000,15.120000,17.000000),
(0.106120,30.000000,4.930000,0.000000,0.428000,6.095000,65.100000,6.336100,6.000000,300.000000,16.600000,394.620000,12.400000,20.100000),
(0.066420,0.000000,4.050000,0.000000,0.510000,6.860000,74.400000,2.915300,5.000000,296.000000,16.600000,391.270000,6.920000,29.900000),
(7.403890,0.000000,18.100000,0.000000,0.597000,5.617000,97.900000,1.454700,24.000000,666.000000,20.200000,314.640000,26.400000,17.200000),
(0.078860,80.000000,4.950000,0.000000,0.411000,7.148000,27.700000,5.116700,4.000000,245.000000,19.200000,396.900000,3.560000,37.300000),
(0.035780,20.000000,3.330000,0.000000,0.442900,7.820000,64.500000,4.694700,5.000000,216.000000,14.900000,387.310000,3.760000,45.400000),
(2.330990,0.000000,19.580000,0.000000,0.871000,5.186000,93.800000,1.529600,5.000000,403.000000,14.700000,356.990000,28.320000,17.800000),
(0.070220,0.000000,4.050000,0.000000,0.510000,6.020000,47.200000,3.554900,5.000000,296.000000,16.600000,393.230000,10.110000,23.200000),
(0.055610,70.000000,2.240000,0.000000,0.400000,7.041000,10.000000,7.827800,5.000000,358.000000,14.800000,371.580000,4.740000,29.000000),
(0.039320,0.000000,3.410000,0.000000,0.489000,6.405000,73.900000,3.092100,2.000000,270.000000,17.800000,393.550000,8.200000,22.000000),
(0.325430,0.000000,21.890000,0.000000,0.624000,6.431000,98.800000,1.812500,4.000000,437.000000,21.200000,396.900000,15.390000,18.000000),
(1.207420,0.000000,19.580000,0.000000,0.605000,5.875000,94.600000,2.425900,5.000000,403.000000,14.700000,292.290000,14.430000,17.400000),
(0.037680,80.000000,1.520000,0.000000,0.404000,7.274000,38.300000,7.309000,2.000000,329.000000,12.600000,392.200000,6.620000,34.600000),
(0.019650,80.000000,1.760000,0.000000,0.385000,6.230000,31.500000,9.089200,1.000000,241.000000,18.200000,341.600000,12.930000,20.100000),
(0.028750,28.000000,15.040000,0.000000,0.464000,6.211000,28.900000,3.665900,4.000000,270.000000,18.200000,396.330000,6.210000,25.000000),
(3.535010,0.000000,19.580000,1.000000,0.871000,6.152000,82.600000,1.745500,5.000000,403.000000,14.700000,88.010000,15.020000,15.600000),
(0.036590,25.000000,4.860000,0.000000,0.426000,6.302000,32.200000,5.400700,4.000000,281.000000,19.000000,396.900000,6.720000,24.800000),
(0.049320,33.000000,2.180000,0.000000,0.472000,6.849000,70.300000,3.182700,7.000000,222.000000,18.400000,396.900000,7.530000,28.200000),
(3.673670,0.000000,18.100000,0.000000,0.583000,6.312000,51.900000,3.991700,24.000000,666.000000,20.200000,388.620000,10.580000,21.200000),
(0.095120,0.000000,12.830000,0.000000,0.437000,6.286000,45.000000,4.502600,5.000000,398.000000,18.700000,383.230000,8.940000,21.400000),
(0.167600,0.000000,7.380000,0.000000,0.493000,6.426000,52.300000,4.540400,5.000000,287.000000,19.600000,396.900000,7.200000,23.800000),
(0.825260,20.000000,3.970000,0.000000,0.647000,7.327000,94.500000,2.078800,5.000000,264.000000,13.000000,393.420000,11.250000,31.000000),
(0.190730,22.000000,5.860000,0.000000,0.431000,6.718000,17.500000,7.826500,7.000000,330.000000,19.100000,393.740000,6.560000,26.200000),
(0.135540,12.500000,6.070000,0.000000,0.409000,5.594000,36.800000,6.498000,4.000000,345.000000,18.900000,396.900000,13.090000,17.400000),
(0.091030,0.000000,2.460000,0.000000,0.488000,7.155000,92.200000,2.700600,3.000000,193.000000,17.800000,394.120000,4.820000,37.900000),
(0.784200,0.000000,8.140000,0.000000,0.538000,5.990000,81.700000,4.257900,4.000000,307.000000,21.000000,386.750000,14.670000,17.500000),
(0.435710,0.000000,10.590000,1.000000,0.489000,5.344000,100.000000,3.875000,4.000000,277.000000,18.600000,396.900000,23.090000,20.000000),
(24.801700,0.000000,18.100000,0.000000,0.693000,5.349000,96.000000,1.702800,24.000000,666.000000,20.200000,396.900000,19.770000,8.300000),
(0.025430,55.000000,3.780000,0.000000,0.484000,6.696000,56.400000,5.732100,5.000000,370.000000,17.600000,396.900000,7.180000,23.900000),
(13.678100,0.000000,18.100000,0.000000,0.740000,5.935000,87.900000,1.820600,24.000000,666.000000,20.200000,68.950000,34.020000,8.400000),
(11.108100,0.000000,18.100000,0.000000,0.668000,4.906000,100.000000,1.174200,24.000000,666.000000,20.200000,396.900000,34.770000,13.800000),
(16.811800,0.000000,18.100000,0.000000,0.700000,5.277000,98.100000,1.426100,24.000000,666.000000,20.200000,396.900000,30.810000,7.200000),
(13.913400,0.000000,18.100000,0.000000,0.713000,6.208000,95.000000,2.222200,24.000000,666.000000,20.200000,100.630000,15.170000,11.700000),
(9.724180,0.000000,18.100000,0.000000,0.740000,6.406000,97.200000,2.065100,24.000000,666.000000,20.200000,385.960000,19.520000,17.100000),
(0.269380,0.000000,9.900000,0.000000,0.544000,6.266000,82.800000,3.262800,4.000000,304.000000,18.400000,393.390000,7.900000,21.600000),
(9.232300,0.000000,18.100000,0.000000,0.631000,6.216000,100.000000,1.169100,24.000000,666.000000,20.200000,366.150000,9.530000,50.000000),
(6.444050,0.000000,18.100000,0.000000,0.584000,6.425000,74.800000,2.200400,24.000000,666.000000,20.200000,97.950000,12.030000,16.100000),
(0.131170,0.000000,8.560000,0.000000,0.520000,6.127000,85.200000,2.122400,5.000000,384.000000,20.900000,387.690000,14.090000,20.400000),
(0.045270,0.000000,11.930000,0.000000,0.573000,6.120000,76.700000,2.287500,1.000000,273.000000,21.000000,396.900000,9.080000,20.600000),
(0.169020,0.000000,25.650000,0.000000,0.581000,5.986000,88.400000,1.992900,2.000000,188.000000,19.100000,385.020000,14.810000,21.400000),
(0.042940,28.000000,15.040000,0.000000,0.464000,6.249000,77.300000,3.615000,4.000000,270.000000,18.200000,396.900000,10.590000,20.600000),
(0.550070,20.000000,3.970000,0.000000,0.647000,7.206000,91.600000,1.930100,5.000000,264.000000,13.000000,387.890000,8.100000,36.500000),
(7.672020,0.000000,18.100000,0.000000,0.693000,5.747000,98.900000,1.633400,24.000000,666.000000,20.200000,393.100000,19.920000,8.500000),
(0.044170,70.000000,2.240000,0.000000,0.400000,6.871000,47.400000,7.827800,5.000000,358.000000,14.800000,390.860000,6.070000,24.800000),
(12.802300,0.000000,18.100000,0.000000,0.740000,5.854000,96.600000,1.895600,24.000000,666.000000,20.200000,240.520000,23.790000,10.800000),
(3.696950,0.000000,18.100000,0.000000,0.718000,4.963000,91.400000,1.752300,24.000000,666.000000,20.200000,316.030000,14.000000,21.900000),
(0.150380,0.000000,25.650000,0.000000,0.581000,5.856000,97.000000,1.944400,2.000000,188.000000,19.100000,370.310000,25.410000,17.300000),
(0.013600,75.000000,4.000000,0.000000,0.410000,5.888000,47.600000,7.319700,3.000000,469.000000,21.100000,396.900000,14.800000,18.900000),
(0.068880,0.000000,2.460000,0.000000,0.488000,6.144000,62.200000,2.597900,3.000000,193.000000,17.800000,396.900000,9.450000,36.200000),
(6.288070,0.000000,18.100000,0.000000,0.740000,6.341000,96.400000,2.072000,24.000000,666.000000,20.200000,318.010000,17.790000,14.900000),
(0.637960,0.000000,8.140000,0.000000,0.538000,6.096000,84.500000,4.461900,4.000000,307.000000,21.000000,380.020000,10.260000,18.200000),
(0.040110,80.000000,1.520000,0.000000,0.404000,7.287000,34.100000,7.309000,2.000000,329.000000,12.600000,396.900000,4.080000,33.300000),
(2.818380,0.000000,18.100000,0.000000,0.532000,5.762000,40.300000,4.098300,24.000000,666.000000,20.200000,392.920000,10.420000,21.800000),
(0.088730,21.000000,5.640000,0.000000,0.439000,5.963000,45.700000,6.814700,4.000000,243.000000,16.800000,395.560000,13.450000,19.700000),
(0.014320,100.000000,1.320000,0.000000,0.411000,6.816000,40.500000,8.324800,5.000000,256.000000,15.100000,392.900000,3.950000,31.600000),
(0.214090,22.000000,5.860000,0.000000,0.431000,6.438000,8.900000,7.396700,7.000000,330.000000,19.100000,377.070000,3.590000,24.800000),
(0.043790,80.000000,3.370000,0.000000,0.398000,5.787000,31.100000,6.611500,4.000000,337.000000,16.100000,396.900000,10.240000,19.400000),
(0.091640,0.000000,10.810000,0.000000,0.413000,6.065000,7.800000,5.287300,4.000000,305.000000,19.200000,390.910000,5.520000,22.800000),
(10.834200,0.000000,18.100000,0.000000,0.679000,6.782000,90.800000,1.819500,24.000000,666.000000,20.200000,21.570000,25.790000,7.500000),
(0.315330,0.000000,6.200000,0.000000,0.504000,8.266000,78.300000,2.894400,8.000000,307.000000,17.400000,385.050000,4.140000,44.800000),
(0.224380,0.000000,9.690000,0.000000,0.585000,6.027000,79.700000,2.498200,6.000000,391.000000,19.200000,396.900000,14.330000,16.800000),
(0.222120,0.000000,10.010000,0.000000,0.547000,6.092000,95.400000,2.548000,6.000000,432.000000,17.800000,396.900000,17.090000,18.700000),
(0.526930,0.000000,6.200000,0.000000,0.504000,8.725000,83.000000,2.894400,8.000000,307.000000,17.400000,382.000000,4.630000,50.000000),
(0.013810,80.000000,0.460000,0.000000,0.422000,7.875000,32.000000,5.648400,4.000000,255.000000,14.400000,394.230000,2.970000,50.000000),
(6.654920,0.000000,18.100000,0.000000,0.713000,6.317000,83.000000,2.734400,24.000000,666.000000,20.200000,396.900000,13.990000,19.500000),
(0.139600,0.000000,8.560000,0.000000,0.520000,6.167000,90.000000,2.421000,5.000000,384.000000,20.900000,392.690000,12.330000,20.100000),
(8.267250,0.000000,18.100000,1.000000,0.668000,5.875000,89.600000,1.129600,24.000000,666.000000,20.200000,347.880000,8.880000,50.000000),
(0.061620,0.000000,4.390000,0.000000,0.442000,5.898000,52.300000,8.013600,3.000000,352.000000,18.800000,364.610000,12.670000,17.200000),
(3.678220,0.000000,18.100000,0.000000,0.770000,5.362000,96.200000,2.103600,24.000000,666.000000,20.200000,380.790000,10.190000,20.800000),
(0.211610,0.000000,8.560000,0.000000,0.520000,6.137000,87.400000,2.714700,5.000000,384.000000,20.900000,394.470000,13.440000,19.300000),
(1.223580,0.000000,19.580000,0.000000,0.605000,6.943000,97.400000,1.877300,5.000000,403.000000,14.700000,363.430000,4.590000,41.300000),
(0.629760,0.000000,8.140000,0.000000,0.538000,5.949000,61.800000,4.707500,4.000000,307.000000,21.000000,396.900000,8.260000,20.400000),
(0.043370,21.000000,5.640000,0.000000,0.439000,6.115000,63.000000,6.814700,4.000000,243.000000,16.800000,393.970000,9.430000,20.500000),
(8.055790,0.000000,18.100000,0.000000,0.584000,5.427000,95.400000,2.429800,24.000000,666.000000,20.200000,352.580000,18.140000,13.800000),
(0.024980,0.000000,1.890000,0.000000,0.518000,6.540000,59.700000,6.266900,1.000000,422.000000,15.900000,389.960000,8.650000,16.500000),
(0.050590,0.000000,4.490000,0.000000,0.449000,6.389000,48.000000,4.779400,3.000000,247.000000,18.500000,396.900000,9.620000,23.900000),
(2.378570,0.000000,18.100000,0.000000,0.583000,5.871000,41.900000,3.724000,24.000000,666.000000,20.200000,370.730000,13.340000,20.600000),
(0.441780,0.000000,6.200000,0.000000,0.504000,6.552000,21.400000,3.375100,8.000000,307.000000,17.400000,380.340000,3.760000,31.500000),
(0.154450,25.000000,5.130000,0.000000,0.453000,6.145000,29.200000,7.814800,8.000000,284.000000,19.700000,390.680000,6.860000,23.300000),
(4.222390,0.000000,18.100000,1.000000,0.770000,5.803000,89.000000,1.904700,24.000000,666.000000,20.200000,353.040000,14.640000,16.800000),
(0.290900,0.000000,21.890000,0.000000,0.624000,6.174000,93.600000,1.611900,4.000000,437.000000,21.200000,388.080000,24.160000,14.000000),
(0.540110,20.000000,3.970000,0.000000,0.647000,7.203000,81.800000,2.112100,5.000000,264.000000,13.000000,392.800000,9.590000,33.800000),
(0.055150,33.000000,2.180000,0.000000,0.472000,7.236000,41.100000,4.022000,7.000000,222.000000,18.400000,393.680000,6.930000,36.100000),
(9.390630,0.000000,18.100000,0.000000,0.740000,5.627000,93.900000,1.817200,24.000000,666.000000,20.200000,396.900000,22.880000,12.800000),
(0.268380,0.000000,9.690000,0.000000,0.585000,5.794000,70.600000,2.892700,6.000000,391.000000,19.200000,396.900000,14.100000,18.300000),
(0.149320,25.000000,5.130000,0.000000,0.453000,5.741000,66.200000,7.225400,8.000000,284.000000,19.700000,395.110000,13.150000,18.700000),
(4.422280,0.000000,18.100000,0.000000,0.584000,6.003000,94.500000,2.540300,24.000000,666.000000,20.200000,331.290000,21.320000,19.100000),
(0.447910,0.000000,6.200000,1.000000,0.507000,6.726000,66.500000,3.651900,8.000000,307.000000,17.400000,360.200000,8.050000,29.000000),
(0.614700,0.000000,6.200000,0.000000,0.507000,6.618000,80.800000,3.272100,8.000000,307.000000,17.400000,396.900000,7.600000,30.100000),
(1.519020,0.000000,19.580000,1.000000,0.605000,8.375000,93.900000,2.162000,5.000000,403.000000,14.700000,388.450000,3.320000,50.000000),
(1.463360,0.000000,19.580000,0.000000,0.605000,7.489000,90.800000,1.970900,5.000000,403.000000,14.700000,374.430000,1.730000,50.000000),
(0.035370,34.000000,6.090000,0.000000,0.433000,6.590000,40.400000,5.491700,7.000000,329.000000,16.100000,395.750000,9.500000,22.000000),
(20.716200,0.000000,18.100000,0.000000,0.659000,4.138000,100.000000,1.178100,24.000000,666.000000,20.200000,370.220000,23.340000,11.900000),
(0.382140,0.000000,6.200000,0.000000,0.504000,8.040000,86.500000,3.215700,8.000000,307.000000,17.400000,387.380000,3.130000,37.600000),
(0.015010,90.000000,1.210000,1.000000,0.401000,7.923000,24.800000,5.885000,1.000000,198.000000,13.600000,395.520000,3.160000,50.000000),
(2.242360,0.000000,19.580000,0.000000,0.605000,5.854000,91.800000,2.422000,5.000000,403.000000,14.700000,395.110000,11.640000,22.700000),
(0.087070,0.000000,12.830000,0.000000,0.437000,6.140000,45.800000,4.090500,5.000000,398.000000,18.700000,386.960000,10.270000,20.800000),
(0.035840,80.000000,3.370000,0.000000,0.398000,6.290000,17.800000,6.611500,4.000000,337.000000,16.100000,396.900000,4.670000,23.500000),
(0.036150,80.000000,4.950000,0.000000,0.411000,6.630000,23.400000,5.116700,4.000000,245.000000,19.200000,396.900000,4.700000,27.900000),
(5.669980,0.000000,18.100000,1.000000,0.631000,6.683000,96.800000,1.356700,24.000000,666.000000,20.200000,375.330000,3.730000,50.000000),
(0.066170,0.000000,3.240000,0.000000,0.460000,5.868000,25.800000,5.214600,4.000000,430.000000,16.900000,382.440000,9.970000,19.300000),
(0.082650,0.000000,13.920000,0.000000,0.437000,6.127000,18.400000,5.502700,4.000000,289.000000,16.000000,396.900000,8.580000,23.900000),
(0.067240,0.000000,3.240000,0.000000,0.460000,6.333000,17.200000,5.214600,4.000000,430.000000,16.900000,375.210000,7.340000,22.600000),
(5.441140,0.000000,18.100000,0.000000,0.713000,6.655000,98.200000,2.355200,24.000000,666.000000,20.200000,355.290000,17.730000,15.200000),
(0.107930,0.000000,8.560000,0.000000,0.520000,6.195000,54.400000,2.777800,5.000000,384.000000,20.900000,393.490000,13.000000,21.700000),
(0.340060,0.000000,21.890000,0.000000,0.624000,6.458000,98.900000,2.118500,4.000000,437.000000,21.200000,395.040000,12.600000,19.200000),
(0.081870,0.000000,2.890000,0.000000,0.445000,7.820000,36.900000,3.495200,2.000000,276.000000,18.000000,393.530000,3.570000,43.800000),
(0.349400,0.000000,9.900000,0.000000,0.544000,5.972000,76.700000,3.102500,4.000000,304.000000,18.400000,396.240000,9.970000,20.300000),
(0.068600,0.000000,2.890000,0.000000,0.445000,7.416000,62.500000,3.495200,2.000000,276.000000,18.000000,396.900000,6.190000,33.200000),
(3.163600,0.000000,18.100000,0.000000,0.655000,5.759000,48.200000,3.066500,24.000000,666.000000,20.200000,334.400000,14.130000,19.900000),
(0.251990,0.000000,10.590000,0.000000,0.489000,5.783000,72.700000,4.354900,4.000000,277.000000,18.600000,389.430000,18.060000,22.500000),
(0.013010,35.000000,1.520000,0.000000,0.442000,7.241000,49.300000,7.037900,1.000000,284.000000,15.500000,394.740000,5.490000,32.700000),
(0.109590,0.000000,11.930000,0.000000,0.573000,6.794000,89.300000,2.388900,1.000000,273.000000,21.000000,393.450000,6.480000,22.000000),
(0.050230,35.000000,6.060000,0.000000,0.437900,5.706000,28.400000,6.640700,1.000000,304.000000,16.900000,394.020000,12.430000,17.100000),
(3.774980,0.000000,18.100000,0.000000,0.655000,5.952000,84.700000,2.871500,24.000000,666.000000,20.200000,22.010000,17.150000,19.000000),
(0.224890,12.500000,7.870000,0.000000,0.524000,6.377000,94.300000,6.346700,5.000000,311.000000,15.200000,392.520000,20.450000,15.000000),
(2.635480,0.000000,9.900000,0.000000,0.544000,4.973000,37.800000,2.519400,4.000000,304.000000,18.400000,350.450000,12.640000,16.100000),
(0.520580,0.000000,6.200000,1.000000,0.507000,6.631000,76.500000,4.148000,8.000000,307.000000,17.400000,388.450000,9.540000,25.100000),
(0.289550,0.000000,10.590000,0.000000,0.489000,5.412000,9.800000,3.587500,4.000000,277.000000,18.600000,348.930000,29.550000,23.700000),
(0.070130,0.000000,13.890000,0.000000,0.550000,6.642000,85.100000,3.421100,5.000000,276.000000,16.400000,392.780000,9.690000,28.700000),
(0.057800,0.000000,2.460000,0.000000,0.488000,6.980000,58.400000,2.829000,3.000000,193.000000,17.800000,396.900000,5.040000,37.200000),
(0.046840,0.000000,3.410000,0.000000,0.489000,6.417000,66.100000,3.092300,2.000000,270.000000,17.800000,392.180000,8.810000,22.600000),
(4.812130,0.000000,18.100000,0.000000,0.713000,6.701000,90.000000,2.597500,24.000000,666.000000,20.200000,255.230000,16.420000,16.400000),
(0.053600,21.000000,5.640000,0.000000,0.439000,6.511000,21.100000,6.814700,4.000000,243.000000,16.800000,396.900000,5.280000,25.000000),
(0.125790,45.000000,3.440000,0.000000,0.437000,6.556000,29.100000,4.566700,5.000000,398.000000,15.200000,382.840000,4.560000,29.800000),
(0.790410,0.000000,9.900000,0.000000,0.544000,6.122000,52.800000,2.640300,4.000000,304.000000,18.400000,396.900000,5.980000,22.100000),
(0.322640,0.000000,21.890000,0.000000,0.624000,5.942000,93.500000,1.966900,4.000000,437.000000,21.200000,378.250000,16.900000,17.400000),
(0.557780,0.000000,21.890000,0.000000,0.624000,6.335000,98.200000,2.110700,4.000000,437.000000,21.200000,394.670000,16.960000,18.100000),
(0.046660,80.000000,1.520000,0.000000,0.404000,7.107000,36.600000,7.309000,2.000000,329.000000,12.600000,354.310000,8.610000,30.300000),
(0.031130,0.000000,4.390000,0.000000,0.442000,6.014000,48.500000,8.013600,3.000000,352.000000,18.800000,385.640000,10.530000,17.500000),
(0.175050,0.000000,5.960000,0.000000,0.499000,5.966000,30.200000,3.847300,5.000000,279.000000,19.200000,393.430000,10.130000,24.700000),
(9.924850,0.000000,18.100000,0.000000,0.740000,6.251000,96.600000,2.198000,24.000000,666.000000,20.200000,388.520000,16.440000,12.600000),
(0.114320,0.000000,8.560000,0.000000,0.520000,6.781000,71.300000,2.856100,5.000000,384.000000,20.900000,395.580000,7.670000,26.500000),
(0.053020,0.000000,3.410000,0.000000,0.489000,7.079000,63.100000,3.414500,2.000000,270.000000,17.800000,396.060000,5.700000,28.700000),
(0.249800,0.000000,21.890000,0.000000,0.624000,5.857000,98.200000,1.668600,4.000000,437.000000,21.200000,392.040000,21.320000,13.300000),
(25.940600,0.000000,18.100000,0.000000,0.679000,5.304000,89.100000,1.647500,24.000000,666.000000,20.200000,127.360000,26.640000,10.400000),
(0.135870,0.000000,10.590000,1.000000,0.489000,6.064000,59.100000,4.239200,4.000000,277.000000,18.600000,381.320000,14.660000,24.400000),
(0.303470,0.000000,7.380000,0.000000,0.493000,6.312000,28.900000,5.415900,5.000000,287.000000,19.600000,396.900000,6.150000,23.000000),
(6.801170,0.000000,18.100000,0.000000,0.713000,6.081000,84.400000,2.717500,24.000000,666.000000,20.200000,396.900000,14.700000,20.000000),
(8.982960,0.000000,18.100000,1.000000,0.770000,6.212000,97.400000,2.122200,24.000000,666.000000,20.200000,377.730000,17.600000,17.800000),
(45.746100,0.000000,18.100000,0.000000,0.693000,4.519000,100.000000,1.658200,24.000000,666.000000,20.200000,88.270000,36.980000,7.000000),
(10.671800,0.000000,18.100000,0.000000,0.740000,6.459000,94.800000,1.987900,24.000000,666.000000,20.200000,43.060000,23.980000,11.800000),
(0.229690,0.000000,10.590000,0.000000,0.489000,6.326000,52.500000,4.354900,4.000000,277.000000,18.600000,394.870000,10.970000,24.400000),
(18.498200,0.000000,18.100000,0.000000,0.668000,4.138000,100.000000,1.137000,24.000000,666.000000,20.200000,396.900000,37.970000,13.800000),
(0.219770,0.000000,6.910000,0.000000,0.448000,5.602000,62.000000,6.087700,3.000000,233.000000,17.900000,396.900000,16.200000,19.400000),
(0.162110,20.000000,6.960000,0.000000,0.464000,6.240000,16.300000,4.429000,3.000000,223.000000,18.600000,396.900000,6.590000,25.200000),
(0.034660,35.000000,6.060000,0.000000,0.437900,6.031000,23.300000,6.640700,1.000000,304.000000,16.900000,362.250000,7.830000,19.400000),
(2.149180,0.000000,19.580000,0.000000,0.871000,5.709000,98.500000,1.623200,5.000000,403.000000,14.700000,261.950000,15.790000,19.400000),
(0.014390,60.000000,2.930000,0.000000,0.401000,6.604000,18.800000,6.219600,1.000000,265.000000,15.600000,376.700000,4.380000,29.100000);


DROP TABLE IF EXISTS housing.test;
CREATE TABLE housing.test (
	f1  float,
	f2  float,
	f3  float,
	f4  int,
	f5  float,
	f6  float,
	f7  float,
	f8  float,
	f9  int,
	f10 bigint,
	f11 float,
	f12 float,
	f13 float,
	target double);
INSERT INTO housing.test VALUES
(18.084600,0.000000,18.100000,0.000000,0.679000,6.434000,100.000000,1.834700,24.000000,666.000000,20.200000,27.250000,29.050000,7.200000),
(0.123290,0.000000,10.010000,0.000000,0.547000,5.913000,92.900000,2.353400,6.000000,432.000000,17.800000,394.950000,16.210000,18.800000),
(0.054970,0.000000,5.190000,0.000000,0.515000,5.985000,45.400000,4.812200,5.000000,224.000000,20.200000,396.900000,9.740000,19.000000),
(1.273460,0.000000,19.580000,1.000000,0.605000,6.250000,92.600000,1.798400,5.000000,403.000000,14.700000,338.920000,5.500000,27.000000),
(0.071510,0.000000,4.490000,0.000000,0.449000,6.121000,56.800000,3.747600,3.000000,247.000000,18.500000,395.150000,8.440000,22.200000),
(0.279570,0.000000,9.690000,0.000000,0.585000,5.926000,42.600000,2.381700,6.000000,391.000000,19.200000,396.900000,13.590000,24.500000),
(0.030490,55.000000,3.780000,0.000000,0.484000,6.874000,28.100000,6.465400,5.000000,370.000000,17.600000,387.970000,4.610000,31.200000),
(0.035510,25.000000,4.860000,0.000000,0.426000,6.167000,46.700000,5.400700,4.000000,281.000000,19.000000,390.640000,7.510000,22.900000),
(0.092990,0.000000,25.650000,0.000000,0.581000,5.961000,92.900000,2.086900,2.000000,188.000000,19.100000,378.090000,17.930000,20.500000),
(3.568680,0.000000,18.100000,0.000000,0.580000,6.437000,75.000000,2.896500,24.000000,666.000000,20.200000,393.370000,14.360000,23.200000),
(0.228760,0.000000,8.560000,0.000000,0.520000,6.405000,85.400000,2.714700,5.000000,384.000000,20.900000,70.800000,10.630000,18.600000),
(1.354720,0.000000,8.140000,0.000000,0.538000,6.072000,100.000000,4.175000,4.000000,307.000000,21.000000,376.730000,13.040000,14.500000),
(0.544520,0.000000,21.890000,0.000000,0.624000,6.151000,97.900000,1.668700,4.000000,437.000000,21.200000,396.900000,18.460000,17.800000),
(0.056020,0.000000,2.460000,0.000000,0.488000,7.831000,53.600000,3.199200,3.000000,193.000000,17.800000,392.630000,4.450000,50.000000),
(12.048200,0.000000,18.100000,0.000000,0.614000,5.648000,87.600000,1.951200,24.000000,666.000000,20.200000,291.550000,14.100000,20.800000),
(0.339830,22.000000,5.860000,0.000000,0.431000,6.108000,34.900000,8.055500,7.000000,330.000000,19.100000,390.180000,9.160000,24.300000),
(0.088260,0.000000,10.810000,0.000000,0.413000,6.417000,6.600000,5.287300,4.000000,305.000000,19.200000,383.730000,6.720000,24.200000),
(0.045440,0.000000,3.240000,0.000000,0.460000,6.144000,32.200000,5.873600,4.000000,430.000000,16.900000,368.570000,9.090000,19.800000),
(5.691750,0.000000,18.100000,0.000000,0.583000,6.114000,79.800000,3.545900,24.000000,666.000000,20.200000,392.680000,14.980000,19.100000),
(5.201770,0.000000,18.100000,1.000000,0.770000,6.127000,83.400000,2.722700,24.000000,666.000000,20.200000,395.430000,11.480000,22.700000),
(15.023400,0.000000,18.100000,0.000000,0.614000,5.304000,97.300000,2.100700,24.000000,666.000000,20.200000,349.480000,24.910000,12.000000),
(12.247200,0.000000,18.100000,0.000000,0.584000,5.837000,59.700000,1.997600,24.000000,666.000000,20.200000,24.650000,15.690000,10.200000),
(0.097440,0.000000,5.960000,0.000000,0.499000,5.841000,61.400000,3.377900,5.000000,279.000000,19.200000,377.560000,11.410000,20.000000),
(0.191330,22.000000,5.860000,0.000000,0.431000,5.605000,70.200000,7.954900,7.000000,330.000000,19.100000,389.130000,18.460000,18.500000),
(0.035480,80.000000,3.640000,0.000000,0.392000,5.876000,19.100000,9.220300,1.000000,315.000000,16.400000,395.180000,9.250000,20.900000),
(5.824010,0.000000,18.100000,0.000000,0.532000,6.242000,64.700000,3.424200,24.000000,666.000000,20.200000,396.900000,10.740000,23.000000),
(0.623560,0.000000,6.200000,1.000000,0.507000,6.879000,77.700000,3.272100,8.000000,307.000000,17.400000,390.390000,9.930000,27.500000),
(0.017090,90.000000,2.020000,0.000000,0.410000,6.728000,36.100000,12.126500,5.000000,187.000000,17.000000,384.460000,4.500000,30.100000),
(9.338890,0.000000,18.100000,0.000000,0.679000,6.380000,95.600000,1.968200,24.000000,666.000000,20.200000,60.720000,24.080000,9.500000),
(0.057890,12.500000,6.070000,0.000000,0.409000,5.878000,21.400000,6.498000,4.000000,345.000000,18.900000,396.210000,8.100000,22.000000),
(0.131580,0.000000,10.010000,0.000000,0.547000,6.176000,72.500000,2.730100,6.000000,432.000000,17.800000,393.300000,12.040000,21.200000),
(10.062300,0.000000,18.100000,0.000000,0.584000,6.833000,94.300000,2.088200,24.000000,666.000000,20.200000,81.330000,19.690000,14.100000),
(0.061270,40.000000,6.410000,1.000000,0.447000,6.826000,27.600000,4.862800,4.000000,254.000000,17.600000,393.450000,4.160000,33.100000),
(0.195390,0.000000,10.810000,0.000000,0.413000,6.245000,6.200000,5.287300,4.000000,305.000000,19.200000,377.170000,7.540000,23.400000),
(13.075100,0.000000,18.100000,0.000000,0.580000,5.713000,56.700000,2.823700,24.000000,666.000000,20.200000,396.900000,14.760000,20.100000),
(22.597100,0.000000,18.100000,0.000000,0.700000,5.000000,89.500000,1.518400,24.000000,666.000000,20.200000,396.900000,31.990000,7.400000),
(2.733970,0.000000,19.580000,0.000000,0.871000,5.597000,94.900000,1.525700,5.000000,403.000000,14.700000,351.850000,21.450000,15.400000),
(1.800280,0.000000,19.580000,0.000000,0.605000,5.877000,79.200000,2.425900,5.000000,403.000000,14.700000,227.610000,12.140000,23.800000),
(0.111320,0.000000,27.740000,0.000000,0.609000,5.983000,83.500000,2.109900,4.000000,711.000000,20.100000,396.900000,13.350000,20.100000),
(0.015010,80.000000,2.010000,0.000000,0.435000,6.635000,29.700000,8.344000,4.000000,280.000000,17.000000,390.940000,5.990000,24.500000),
(0.019510,17.500000,1.380000,0.000000,0.416100,7.104000,59.500000,9.222900,3.000000,216.000000,18.600000,393.240000,8.050000,33.000000),
(0.122040,0.000000,2.890000,0.000000,0.445000,6.625000,57.800000,3.495200,2.000000,276.000000,18.000000,357.980000,6.650000,28.400000),
(9.329090,0.000000,18.100000,0.000000,0.713000,6.185000,98.700000,2.261600,24.000000,666.000000,20.200000,396.900000,18.130000,14.100000),
(0.298190,0.000000,6.200000,0.000000,0.504000,7.686000,17.000000,3.375100,8.000000,307.000000,17.400000,377.510000,3.920000,46.700000),
(0.100080,0.000000,2.460000,0.000000,0.488000,6.563000,95.600000,2.847000,3.000000,193.000000,17.800000,396.900000,5.680000,32.500000),
(0.060470,0.000000,2.460000,0.000000,0.488000,6.153000,68.800000,3.279700,3.000000,193.000000,17.800000,387.110000,13.150000,29.600000),
(0.054790,33.000000,2.180000,0.000000,0.472000,6.616000,58.100000,3.370000,7.000000,222.000000,18.400000,393.360000,8.930000,28.400000),
(0.245220,0.000000,9.900000,0.000000,0.544000,5.782000,71.700000,4.031700,4.000000,304.000000,18.400000,396.900000,15.940000,19.800000),
(5.821150,0.000000,18.100000,0.000000,0.713000,6.513000,89.900000,2.801600,24.000000,666.000000,20.200000,393.820000,10.290000,20.200000),
(0.198020,0.000000,10.590000,0.000000,0.489000,6.182000,42.400000,3.945400,4.000000,277.000000,18.600000,393.630000,9.470000,25.000000),
(0.013110,90.000000,1.220000,0.000000,0.403000,7.249000,21.900000,8.696600,5.000000,226.000000,17.900000,395.930000,4.810000,35.400000),
(0.141030,0.000000,13.920000,0.000000,0.437000,5.790000,58.000000,6.320000,4.000000,289.000000,16.000000,396.900000,15.840000,20.300000),
(11.577900,0.000000,18.100000,0.000000,0.700000,5.036000,97.000000,1.770000,24.000000,666.000000,20.200000,396.900000,25.680000,9.700000),
(0.988430,0.000000,8.140000,0.000000,0.538000,5.813000,100.000000,4.095200,4.000000,307.000000,21.000000,394.540000,19.880000,14.500000),
(0.083700,45.000000,3.440000,0.000000,0.437000,7.185000,38.900000,4.566700,5.000000,398.000000,15.200000,396.900000,5.390000,34.900000),
(0.057350,0.000000,4.490000,0.000000,0.449000,6.630000,56.100000,4.437700,3.000000,247.000000,18.500000,392.300000,6.530000,26.600000),
(14.236200,0.000000,18.100000,0.000000,0.693000,6.343000,100.000000,1.574100,24.000000,666.000000,20.200000,396.900000,20.320000,7.200000),
(0.578340,20.000000,3.970000,0.000000,0.575000,8.297000,67.000000,2.421600,5.000000,264.000000,13.000000,384.540000,7.440000,50.000000),
(0.056440,40.000000,6.410000,1.000000,0.447000,6.758000,32.900000,4.077600,4.000000,254.000000,17.600000,396.900000,3.530000,32.400000),
(0.027310,0.000000,7.070000,0.000000,0.469000,6.421000,78.900000,4.967100,2.000000,242.000000,17.800000,396.900000,9.140000,21.600000),
(4.646890,0.000000,18.100000,0.000000,0.614000,6.980000,67.600000,2.532900,24.000000,666.000000,20.200000,374.680000,11.660000,29.800000),
(8.716750,0.000000,18.100000,0.000000,0.693000,6.471000,98.800000,1.725700,24.000000,666.000000,20.200000,391.980000,17.120000,13.100000),
(14.438300,0.000000,18.100000,0.000000,0.597000,6.852000,100.000000,1.465500,24.000000,666.000000,20.200000,179.360000,19.780000,27.500000),
(0.239120,0.000000,9.690000,0.000000,0.585000,6.019000,65.300000,2.409100,6.000000,391.000000,19.200000,396.900000,12.920000,21.200000),
(0.181590,0.000000,7.380000,0.000000,0.493000,6.376000,54.300000,4.540400,5.000000,287.000000,19.600000,396.900000,6.870000,23.100000),
(0.048190,80.000000,3.640000,0.000000,0.392000,6.108000,32.000000,9.220300,1.000000,315.000000,16.400000,392.890000,6.570000,21.900000),
(7.526010,0.000000,18.100000,0.000000,0.713000,6.417000,98.300000,2.185000,24.000000,666.000000,20.200000,304.210000,19.310000,13.000000),
(0.038710,52.500000,5.320000,0.000000,0.405000,6.209000,31.300000,7.317200,6.000000,293.000000,16.600000,396.900000,7.140000,23.200000),
(0.207460,0.000000,27.740000,0.000000,0.609000,5.093000,98.000000,1.822600,4.000000,711.000000,20.100000,318.430000,29.680000,8.100000),
(25.046100,0.000000,18.100000,0.000000,0.693000,5.987000,100.000000,1.588800,24.000000,666.000000,20.200000,396.900000,26.770000,5.600000),
(3.849700,0.000000,18.100000,1.000000,0.770000,6.395000,91.000000,2.505200,24.000000,666.000000,20.200000,391.340000,13.270000,21.700000),
(0.082210,22.000000,5.860000,0.000000,0.431000,6.957000,6.800000,8.906700,7.000000,330.000000,19.100000,386.090000,3.530000,29.600000),
(4.038410,0.000000,18.100000,0.000000,0.532000,6.229000,90.700000,3.099300,24.000000,666.000000,20.200000,395.330000,12.870000,19.600000),
(0.183370,0.000000,27.740000,0.000000,0.609000,5.414000,98.300000,1.755400,4.000000,711.000000,20.100000,344.050000,23.970000,7.000000),
(0.092660,34.000000,6.090000,0.000000,0.433000,6.495000,18.400000,5.491700,7.000000,329.000000,16.100000,383.610000,8.670000,26.400000),
(0.117470,12.500000,7.870000,0.000000,0.524000,6.009000,82.900000,6.226700,5.000000,311.000000,15.200000,396.900000,13.270000,18.900000),
(0.128160,12.500000,6.070000,0.000000,0.409000,5.885000,33.000000,6.498000,4.000000,345.000000,18.900000,396.900000,8.790000,20.900000),
(0.140520,0.000000,10.590000,0.000000,0.489000,6.375000,32.300000,3.945400,4.000000,277.000000,18.600000,385.810000,9.380000,28.100000),
(0.037050,20.000000,3.330000,0.000000,0.442900,6.968000,37.200000,5.244700,5.000000,216.000000,14.900000,392.230000,4.590000,35.400000),
(14.333700,0.000000,18.100000,0.000000,0.700000,4.880000,100.000000,1.589500,24.000000,666.000000,20.200000,372.920000,30.620000,10.200000),
(0.537000,0.000000,6.200000,0.000000,0.504000,5.981000,68.100000,3.671500,8.000000,307.000000,17.400000,378.350000,11.650000,24.300000),
(0.534120,20.000000,3.970000,0.000000,0.647000,7.520000,89.400000,2.139800,5.000000,264.000000,13.000000,388.370000,7.260000,43.100000),
(0.206080,22.000000,5.860000,0.000000,0.431000,5.593000,76.500000,7.954900,7.000000,330.000000,19.100000,372.490000,12.500000,17.600000),
(9.966540,0.000000,18.100000,0.000000,0.740000,6.485000,100.000000,1.978400,24.000000,666.000000,20.200000,386.730000,18.850000,15.400000),
(0.253560,0.000000,9.900000,0.000000,0.544000,5.705000,77.700000,3.945000,4.000000,304.000000,18.400000,396.420000,11.500000,16.200000),
(0.144550,12.500000,7.870000,0.000000,0.524000,6.172000,96.100000,5.950500,5.000000,311.000000,15.200000,396.900000,19.150000,27.100000),
(14.333700,0.000000,18.100000,0.000000,0.614000,6.229000,88.000000,1.951200,24.000000,666.000000,20.200000,383.320000,13.110000,21.400000),
(0.110690,0.000000,13.890000,1.000000,0.550000,5.951000,93.800000,2.889300,5.000000,276.000000,16.400000,396.900000,17.920000,21.500000),
(0.062630,0.000000,11.930000,0.000000,0.573000,6.593000,69.100000,2.478600,1.000000,273.000000,21.000000,391.990000,9.670000,22.400000),
(5.731160,0.000000,18.100000,0.000000,0.532000,7.061000,77.000000,3.410600,24.000000,666.000000,20.200000,395.280000,7.010000,25.000000),
(0.229270,0.000000,6.910000,0.000000,0.448000,6.030000,85.500000,5.689400,3.000000,233.000000,17.900000,392.740000,18.800000,16.600000),
(0.072440,60.000000,1.690000,0.000000,0.411000,5.884000,18.500000,10.710300,4.000000,411.000000,18.300000,392.330000,7.790000,18.600000),
(0.113290,30.000000,4.930000,0.000000,0.428000,6.897000,54.300000,6.336100,6.000000,300.000000,16.600000,391.250000,11.380000,22.000000),
(0.368940,22.000000,5.860000,0.000000,0.431000,8.259000,8.400000,8.906700,7.000000,330.000000,19.100000,396.900000,3.540000,42.800000),
(0.210380,20.000000,3.330000,0.000000,0.442900,6.812000,32.200000,4.100700,5.000000,216.000000,14.900000,396.900000,4.850000,35.100000),
(1.656600,0.000000,19.580000,0.000000,0.871000,6.122000,97.300000,1.618000,5.000000,403.000000,14.700000,372.800000,14.100000,21.500000),
(0.663510,20.000000,3.970000,0.000000,0.647000,7.333000,100.000000,1.894600,5.000000,264.000000,13.000000,383.290000,7.790000,36.000000),
(3.474280,0.000000,18.100000,1.000000,0.718000,8.780000,82.900000,1.904700,24.000000,666.000000,20.200000,354.550000,5.290000,21.900000),
(0.078960,0.000000,12.830000,0.000000,0.437000,6.273000,6.000000,4.251500,5.000000,398.000000,18.700000,394.920000,6.780000,24.100000),
(1.833770,0.000000,19.580000,1.000000,0.605000,7.802000,98.200000,2.040700,5.000000,403.000000,14.700000,389.610000,1.920000,50.000000),
(0.358090,0.000000,6.200000,1.000000,0.507000,6.951000,88.500000,2.861700,8.000000,307.000000,17.400000,391.700000,9.710000,26.700000),
(2.924000,0.000000,19.580000,0.000000,0.605000,6.101000,93.000000,2.283400,5.000000,403.000000,14.700000,240.160000,9.810000,25.000000);`
