// Copyright 2020 The SQLFlow Authors. All rights reserved.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package testdata

// FundSQL is the SQL statements to prepare fund test data.
const FundSQL = `
DROP DATABASE IF EXISTS fund;

CREATE DATABASE IF NOT EXISTS fund;

DROP TABLE IF EXISTS fund.train;

CREATE TABLE IF NOT EXISTS fund.train (
  time VARCHAR(255),
  purchase DOUBLE,
  redeem DOUBLE
);

INSERT INTO fund.train VALUES
("2014-04-01",453320585,277429358),
("2014-04-02",355347118,272612066),
("2014-04-03",363877120,266605457),
("2014-04-04",251895894,200192637),
("2014-04-05",202336542,163199682),
("2014-04-06",129477254,139576683),
("2014-04-07",196936223,176966561),
("2014-04-08",354770149,250015131),
("2014-04-09",383347565,289330278),
("2014-04-10",386567460,286914864),
("2014-04-11",237829882,277077434),
("2014-04-12",177642053,123295320),
("2014-04-13",208172985,178934722),
("2014-04-14",309853269,415986984),
("2014-04-15",428681231,285293076),
("2014-04-16",387847838,255914640),
("2014-04-17",355792647,265341592),
("2014-04-18",239300383,225952909),
("2014-04-19",268729366,146374940),
("2014-04-20",191259529,161057781),
("2014-04-21",301134667,295635256),
("2014-04-22",285248757,268810141),
("2014-04-23",313677307,278470936),
("2014-04-24",318358891,224536754),
("2014-04-25",220927432,227764292),
("2014-04-26",151625415,158122962),
("2014-04-27",146837951,191915377),
("2014-04-28",324937272,327724735),
("2014-04-29",330607104,307578349),
("2014-04-30",260091330,281835975),
("2014-05-01",193045106,143362755),
("2014-05-02",125336258,121222064),
("2014-05-03",185094488,199568043),
("2014-05-04",303087562,413222034),
("2014-05-05",370924149,309330781),
("2014-05-06",318002728,341108696),
("2014-05-07",417327518,239372999),
("2014-05-08",392838756,273187499),
("2014-05-09",281479009,247743971),
("2014-05-10",287240171,147248328),
("2014-05-11",182424063,152945581),
("2014-05-12",325108597,293952908),
("2014-05-13",275241493,257918375),
("2014-05-14",305474522,316225442),
("2014-05-15",313367089,238307643),
("2014-05-16",231967423,282094916),
("2014-05-17",170983868,145854372),
("2014-05-18",164419642,153440019),
("2014-05-19",259077930,293791406),
("2014-05-20",453955303,260040720),
("2014-05-21",297799722,250223726),
("2014-05-22",344636549,251108485),
("2014-05-23",249546195,229000787),
("2014-05-24",160073254,154409868),
("2014-05-25",166943526,231004758),
("2014-05-26",344890868,274707572),
("2014-05-27",299049555,321965845),
("2014-05-28",276134813,415891684),
("2014-05-29",320549863,313827800),
("2014-05-30",226547701,312802179),
("2014-05-31",146823669,142862063),
("2014-06-01",183489775,149829253),
("2014-06-02",158219402,170409506),
("2014-06-03",270887462,385622582),
("2014-06-04",274460744,303978838),
("2014-06-05",380042567,355645445),
("2014-06-06",301413900,274862067),
("2014-06-07",187801995,146203577),
("2014-06-08",302171269,169525332),
("2014-06-09",366114374,287520152),
("2014-06-10",354031597,298190025),
("2014-06-11",327661453,246127540),
("2014-06-12",332365185,236467885),
("2014-06-13",216923770,386799040),
("2014-06-14",181574530,229916191),
("2014-06-15",166080126,116623756),
("2014-06-16",387308484,492349489),
("2014-06-17",270350693,502560223),
("2014-06-18",335262709,421920230),
("2014-06-19",338609087,284956260),
("2014-06-20",251582530,286583065),
("2014-06-21",177999186,231003775),
("2014-06-22",147180819,361285652),
("2014-06-23",232227670,373779624),
("2014-06-24",245450766,428471509),
("2014-06-25",264663201,547295931),
("2014-06-26",297628039,418742109),
("2014-06-27",264282703,399444352),
("2014-06-28",153826161,283400236),
("2014-06-29",158801540,261170799),
("2014-06-30",334054112,456547794),
("2014-07-01",384428753,374164541),
("2014-07-02",384555819,328950951),
("2014-07-03",297894643,289009780),
("2014-07-04",211649838,264494550),
("2014-07-05",169383796,272535138),
("2014-07-06",199569025,195530758),
("2014-07-07",272182847,317612569),
("2014-07-08",224240103,340453063),
("2014-07-09",278005555,269642881),
("2014-07-10",283095921,326009240),
("2014-07-11",208671021,240050748),
("2014-07-12",177644343,149081488),
("2014-07-13",179759885,199459990),
("2014-07-14",254797524,284753279),
("2014-07-15",334810012,261722182),
("2014-07-16",394890140,234775948),
("2014-07-17",253011280,298279385),
("2014-07-18",208959595,208671287),
("2014-07-19",210318023,155464283),
("2014-07-20",176449304,174462836),
("2014-07-21",378088594,434191479),
("2014-07-22",243084133,369043423),
("2014-07-23",265461894,308353077),
("2014-07-24",277044480,347622431),
("2014-07-25",181641088,262874791),
("2014-07-26",128268053,282653341),
("2014-07-27",151406251,166610652),
("2014-07-28",371762756,345986909),
("2014-07-29",228093046,303480103),
("2014-07-30",209917272,250117716),
("2014-07-31",191728916,277194379),
("2014-08-01",374884735,252540858),
("2014-08-02",189092130,172250225),
("2014-08-03",173825397,127125217),
("2014-08-04",330640884,322907524),
("2014-08-05",394780870,221706539),
("2014-08-06",288821016,282346594),
("2014-08-07",247646474,253659514),
("2014-08-08",233903717,311648757),
("2014-08-09",160262764,163611708),
("2014-08-10",259534870,189909225),
("2014-08-11",331550471,418603336),
("2014-08-12",258493673,309754858),
("2014-08-13",261506619,303975517),
("2014-08-14",257702660,211939431),
("2014-08-15",244551620,236516007),
("2014-08-16",215059736,219214339),
("2014-08-17",149978271,139564084),
("2014-08-18",298499146,259169016),
("2014-08-19",266401973,254929877),
("2014-08-20",308378692,202452782),
("2014-08-21",251763517,219963356),
("2014-08-22",246316056,179349206),
("2014-08-23",141412027,199377531),
("2014-08-24",130195484,191080151),
("2014-08-25",309574223,312413411),
("2014-08-26",306945089,285478563),
("2014-08-27",302194801,468164147),
("2014-08-28",245082751,297893861),
("2014-08-29",267554713,273756380),
("2014-08-30",199708772,196374134),
("2014-08-31",275090213,292943033);
`
