// Copyright 2020 The SQLFlow Authors. All rights reserved.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package testdata

// ODPSFeatureMapSQL is .sql format data sample to test odps training with sparse samples.
var ODPSFeatureMapSQL = `DROP TABLE IF EXISTS test_sparse_with_fm;
CREATE TABLE test_sparse_with_fm (
	user_id bigint,
	label int,
	dense string,
	deep string,
	item string);

INSERT INTO test_sparse_with_fm VALUES
("2088202442010302","1","0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0","70\0021\0010\0022\0015\0023\00110\0024\0010\0025\0011\0026\00117\0027\0010\0028\00113\0029\00143\00210\00112\00211\00186\00212\00124\00213\001218\00214\00117\00215\00127\00216\0015\00217\0011\00221\00110\00223\0010\00224\0010\00225\0010\00226\0011\00227\0011\00228\00118\00229\0015\00231\00126\00231\00118\00231\00153\00232\00187\00232\001275\00232\001162\00232\001289\00232\001174\00232\001219\00232\001333\00232\001287\00232\00162\00232\001157\00232\001331\00232\001264\00232\00122\00232\001290\00232\00159\00232\00135\00232\001106\00232\00125\00232\001324\00232\001329\00232\001319\00232\00112\00233\0010\00233\0013\00233\001139\00234\0018\00234\001125\00234\001111\00234\00142\00234\001110\00234\00123\00234\001118\00234\00182\00234\001175\00234\001147\00234\00194\00234\00171\00234\00128\00234\001112\00234\00170\00234\00159\00234\001174\00234\001100\00234\001171\00234\00154\00234\00144\00234\00126\00235\00129\00235\00136\00235\00141\00235\00120\00235\00135\00235\00158\00235\00134\00235\00162\00235\00126\00236\00112\00236\00124\00236\0016\00236\0018\00236\00132\00236\00118\00236\00113\00236\00131\00236\001109\00237\00189\00237\00191\00237\00179\00237\00167\00237\00156\00237\00139\00237\0014\002141\00112\002143\0018\002143\0014\002143\0019\002143\0013\002144\0012\002144\0011\002144\0019\002145\00119\002145\0012\002145\00110\002145\00111\002145\00122\002145\00115\002145\0010\002146\0011\002146\00181\002147\0019\002147\00175\002147\00188\002147\00153\002147\00165\002147\00144\002147\00146\002147\00120\002147\00142\002147\0014\002147\00158\002147\00119\002147\00162\002147\00110\002147\00173\002147\00112\002147\00183\002147\00170\002147\00182\002147\0013\002147\00113\002147\00174\002147\00141\002147\00168\002147\00184\002147\00163\002147\00123\002147\00143\002147\00134\002147\0011\002147\00121\002147\00161\002147\0010\002147\00171\002147\00157\002147\00167\002147\00159\002147\00164\002147\00137\002147\00154\002147\00160\002147\00114\002147\00186\002147\001169\002148\001116\002148\001128\002148\0016\002148\00114\002148\001147\002148\00125\002148\00168\002148\001117\002148\001129\002148\0015\002148\001140\002148\00190\002148\001164\002148\00138\002148\00144\002148\00111\002148\00157\002148\00174\002148\0014\002148\001123\002148\00194\002149\001286\002149\001420\002149\001233\002149\001337\002149\001251\002149\001204\002149\001170\002149\00116\002149\00162\002149\00167\002149\001333\002149\001412\002149\001373\002149\00149\002149\001207\002149\001194\002149\001360\002149\001221\002149\001298\002149\00147\002149\001350\002149\00122\002149\0019\002149\001270\002149\001343\002149\001238\002149\001142\002149\001287\002149\001366\002149\00120\002150\00179\002150\00124\002150\001133\002150\00166\002150\00127\002150\001124\002150\001149\002150\001203\002150\001148\002150\001162\002150\00156\002150\00198\002150\001135\002150\0011\002150\0019\002150\001151\002151\001111\002151\00172\002151\001229\002151\00193\002151\001425\002151\001433\002151\001221\002151\001317\002151\001254\002151\001429\002151\001242\002151\001441\002151\001460\002151\001653\002152\001262\002152\001328\002152\001112\002152\001313\002152\001295\002152\001732\002152\001566\002152\001816\002152\001156\002152\00185\002152\00178\002152\001583\002152\001636\002152\001340\002152\00110\002152\001569\002152\001772\002152\001140\002152\001717\002152\001785\002152\001190\002152\001713\002152\001141\002152\001658\002152\001155\002152\001708\002152\00164\002152\001301\002152\001260\002152\001292\002152\00128\002152\001419\002152\001802\002152\001241\002153\001421\002153\001482\002153\001539\002153\001373\002153\001390\002153\00185\002153\00133\002153\001459\002153\001231\002153\001498\002153\001513\002153\001212\002153\001316\002153\001404\002153\001225\002153\001367\002153\001544\002153\00120\002153\001382\002153\001108\002153\001366\002153\001307\002153\001475\002153\001284\002154\00147\002154\001904\002154\001818\002154\001717\002154\001348\002154\001922\002154\001214\002154\001461\002154\001894\002154\001511\002154\001185\002154\001212\002154\001693\002154\001824\002154\001501\002154\001504\002154\001593\002154\001586\002154\001754\002154\001532\002154\001496\002154\001513\002154\001329\002154\001830\002154\001870\002154\001149\002154\001955\002154\001198\002154\001619\002154\0010\002155\00127\002155\00126\002155\0014\002155\00128\002155\00124\002155\00158\002155\00155\002155\00136\002155\0013\002155\00139\002155\0017\002155\00145\002155\00132\002155\00110\002155\00138\002155\00117\002155\0018\002155\00122\002155\00123\002155\00114\002155\00120\002155\00156\002155\00149\002155\00140\002155\00148\002155\00150\002155\00125\002155\00121\002155\00143\002155\00133\002156\00140\002156\00122\002156\00143\002156\0014\002156\00139\002156\00132\002156\0016\002156\00148\002156\00128\002156\0012\002156\0010\002156\00134\002156\00120\002156\00117\002156\00137\002156\00142\002156\00147\002156\0019\002156\0018\002156\00137\002157\00118\002157\00122\002157\00113\002157\00125\002157\00132\002157\00120\002157\00121\002157\0013\002157\0012\002157\0019\002157\00138\002157\00134\002157\0010\002157\00126\002157\00130\002157\00117\002157\0016\002157\00127\002157\00112\002157\00136\002157\00139\002158\00136\002158\00118\002158\00189\002158\001109\002158\00169\002158\00146\002158\00126\002158\00120\002158\00183\002158\0011\002158\001103\002158\00125\002158\00171\002158\00175\002158\00149\002158\00162\002158\001100\002158\001126\002158\00152\002158\00186\002158\001107\002158\00198\002158\00199\002158\001118\002158\00180\002158\0015\002158\00174\002158\001113\002158\0010\002158\00129\002158\001124\002158\00137\002158\00192\002158\00132\002158\00194\002158\00113\002158\00160\002158\00197\002158\001120\002158\00151\002158\00179\002158\0014\002158\00131\002158\00144\002158\00158\002158\0013\002158\00182\002158\0012\002158\001127\002158\00163\002158\00114\002158\00157\002158\00177\002158\001104\002158\00128\002158\001119\002158\001106\002158\00115\002158\0017\002158\0016\002158\0018\002158\00170\002158\0019\002158\001112\002158\001115\002158\00185\002158\00155\002158\00138\002158\001116\002158\00124\002159\00131\002159\00144\002159\00135\002159\00120\002159\00130\002159\0012\002159\00123\002159\0016\002159\00110\002159\00142\002159\00140\002159\00150\002159\0017\002159\00159\002160\00127\002160\00152\002160\00130\002160\00183\002160\00157\002160\00133\002160\00184\002160\00186\002160\0011\002160\00122\002160\00166\002160\00153\002160\00142\002160\00185\002161\00196\002161\00162\002161\001128\002161\00125\002161\00186\002161\001130\002161\00194\002161\00167\002161\001125\002161\00136\002161\00148\002161\0017\002161\001124\002161\00189\002161\00172\002161\00170\002161\001134\002161\00144\002161\001122\002161\00110\002161\00159\002161\00156\002161\00143\002161\00142\002161\001108\002161\00113\002161\00139\002161\001102\002161\001132\002161\00138\002162\00161\002162\00165\002162\00117\002162\00145\002162\00131\002162\00157\002162\00149\002162\00153\002162\00120\002162\00179\002162\00125\002162\00172\002162\00162\002162\00116\002162\00150\002162\00126\002162\00137\002162\00181\002162\0014\002162\00111\002162\001158\002163\00135\002163\00195\002163\00111\002163\001190\002163\001172\002163\0017\002163\00199\002163\001182\002163\00110\002163\001161\002163\001129\002163\001101\002163\001167\002163\001105\002163\00138\002163\00143\002163\00132\002163\001148\002163\001183\002163\00185\002163\001143\002163\001169\002163\001164\002163\0016\002163\0015\002163\00114\002163\001111\002163\001170\002163\001185\002163\001153\002163\00144\002163\00115\002163\00160\002163\001162\002163\001140\002163\00175\002163\00197\002163\001118\002163\001165\002163\00182\002163\00164\002163\00172\002163\00173\002163\001166\002163\00192\002163\00126\002163\001106\002163\00196\002163\001171\002163\001180\002163\001156\002163\001123\002163\001128\002163\0013\002163\001144\002163\00149\002163\001117\002163\00166\002163\00130\002163\001142\002163\00180\002163\00189\002163\00141\002163\001100\002163\00190\002163\00121\002163\00155\002163\0010\002163\00161\002163\00190\002164\001125\002164\00141\002164\00130\002164\00168\002164\0015\002164\001182\002164\00119\002164\00166\002164\0017\002165\001113\002165\00156\002165\001118\002165\001104\002165\00173\002165\00186\002165\00153\002165\00198\002165\00181\002165\00168\002165\001200\002166\001185\002166\00180\002166\0018\002166\00156\002166\0019\002166\0017\002166\001188\002166\00160\002166\001144\002166\00195\002166\0011\002166\00132\002166\00120\002166\0016\002166\001198\002166\001182\002166\00113\002166\001682\002167\001570\002167\001633\002167\001617\002167\001562\002167\001567\002167\001622\002167\001552\002167\001604\002167\001568\002167\001643\002167\001594\002167\001597\002167\001651\002167\001671\002167\001632\002167\001642\002167\001650\002167\00117\002167\00121\002167\001389\002167\001203\002167\00129\002167\001119\002167\001301\002167\001289\002167\00170\002167\001512\002167\00127\002167\001213\002167\001360\002167\001178\002167\001145\002167\001447\002167\001236\002167\001162\002167\001147\002167\001270\002167\00113\002167\001190\002167\001164\002167\001440\002167\001476\002167\001227\002167\001466\002167\001195\002167\001151\002167\001155\002167\001250\002167\00193\002167\00177\002167\001401\002167\001309\002167\001407\002167\00186\002167\00140\002167\001134\002167\001166\002167\001517\002167\001478\002167\001357\002167\00184\002167\001273\002167\001122\002167\001542\002167\00164\002167\001322\002167\001208\002167\001313\002167\001106\002167\001348\002167\001288\002167\001471\002167\001332\002167\001422\002167\001544\002167\00155\002167\001373\002167\001168\002167\001395\002167\001462\002167\001549\002167\001316\002167\0012\002168\001272\002168\001269\002168\001279\002168\001277\002168\001276\002168\001280\002168\0017\002168\001152\002168\00170\002168\00127\002168\00187\002168\001257\002168\00174\002168\001139\002168\001166\002168\001212\002168\001199\002168\00125\002168\001147\002168\00192\002168\001104\002168\001157\002168\00195\002168\00119\002168\001263\002168\001164\002168\001192\002168\001180\002168\001236\002168\001165\002168\001105\002168\001135\002168\001163\002168\00137\002168\00199\002168\00178\002168\001262\002168\001186\002168\001118\002168\001226\002168\001140\002168\001225\002168\00154\002168\001204\002168\001189\002168\00163\002168\001128\002168\001254\002168\001233\002168\001817\002169\0011\002169\00113\002169\001698\002169\001732\002169\001808\002169\001766\002169\001735\002169\001759\002169\001762\002169\001796\002169\001814\002169\001742\002169\001757\002169\001708\002169\001780\002169\001746\002169\001801\002169\001813\002169\00153\002169\00163\002169\00193\002169\00199\002169\001141\002169\001243\002169\001306\002169\001646\002169\001142\002169\001484\002169\001232\002169\001649\002169\00121\002169\001301\002169\00173\002169\001337\002169\001428\002169\001119\002169\001392\002169\001259\002169\001399\002169\001236\002169\00127\002169\001267\002169\001377\002169\001650\002169\001678\002169\001682\002169\001303\002169\001372\002169\001544\002169\00145\002169\00156\002169\001615\002169\00148\002169\001315\002169\001287\002169\001353\002169\001314\002169\001561\002169\001608\002169\00187\002169\00191\002169\001659\002169\001633\002169\001101\002169\00177\002169\001123\002169\001584\002169\001162\002169\001398\002169\001265\002169\001460\002169\001469\002169\00139\002169\001361\002169\001515\002169\001289\002169\001680\002169\001419\002169\001434\002169\001357\002169\001381\002169\001693\002169\001139\002169\001158\002169\001441\002169\001260\002169\001331\002169\001607\002169\001335\002169\001180\002169\001410\002169\001424\002169\001431\002169\001588\002169\001458\002169\001697\002169\001147\002169\001391\002169\001462\002169\001387\002169\001311\002169\001378\002169\00163\002170\00165\002170\00168\002170\00181\002170\0010\002170\00140\002170\00131\002170\00113\002170\00152\002170\00160\002170\00129\002170\00110\002170\00122\002170\00126\002170\00139\002170\0010\002171\0011\002171\00122\002172\0012\002172\0016\002172\00114\002172\00116\002172\001253\002173\001241\002173\001236\002173\001245\002173\001213\002173\001229\002173\001215\002173\001235\002173\001250\002173\001230\002173\001216\002173\001247\002173\001252\002173\00140\002173\00117\002173\00185\002173\00112\002173\00155\002173\001156\002173\0010\002173\00119\002173\0014\002173\0019\002173\001196\002173\001174\002173\001201\002173\00191\002173\001133\002173\00148\002173\00175\002173\001208\002173\001193\002173\001119\002173\001161\002173\00168\002173\00125\002173\00178\002173\001127\002173\001189\002173\00170\002173\00141\002173\001129\002173\001177\002173\001107\002173\001115\002173\00156\002173\001160\002173\001163\002173\00154\002173\001126\002173\00198\002173\001150\002173\00161\002173\001171\002173\00179\002173\001195\002173\001175\002173\00172\002173\001151\002173\00150\002173\001145\002173\00174\002173\001118\002173\00192\002173\00163\002173\001205\002173\001181\002173\001154\002173\001143\002173\001199\002173\00164\002173\001173\002173\00120\002173\00146\002173\00132\002173\00110\002173\001124\002173\00152\002173\00130\002173\00169\002173\001185\002173\0015\002174\0014\002174\00165\002175\0015\002175\00128\002175\00124\002175\0014\002175\00144\002175\0010\002176\00136\002176\00140\002176\00134\002176\00124\002176\0014\002176\00127\002176\00115\002176\00118\002176\00133\002176\00116\002176\0013\002176\00120\002176\0012\002176\00113\002176\00122\002176\00189\002177\00187\002177\00197\002177\00190\002177\001103\002177\00196\002177\00156\002177\00118\002177\00166\002177\00144\002177\00132\002177\00116\002177\0013\002177\00168\002177\00140\002177\00153\002177\0011863\002178\0011882\002178\0014\002178\0015\002178\0011636\002178\0011792\002178\0011720\002178\0011641\002178\0011707\002178\0011713\002178\0011703\002178\0011848\002178\0011685\002178\0011739\002178\0011814\002178\0011778\002178\0011762\002178\0011660\002178\0011664\002178\0011654\002178\0011751\002178\0011725\002178\0011842\002178\0011753\002178\0011765\002178\0011815\002178\0011764\002178\0011661\002178\0011690\002178\0011821\002178\0011783\002178\0011768\002178\0011833\002178\0011874\002178\0011806\002178\0011836\002178\0011868\002178\00127\002178\001955\002178\00114\002178\00136\002178\001408\002178\0011043\002178\001990\002178\0011422\002178\001220\002178\001330\002178\001263\002178\001280\002178\001905\002178\001549\002178\0011466\002178\00152\002178\0011041\002178\00163\002178\001239\002178\001528\002178\001415\002178\0011464\002178\001538\002178\001563\002178\001717\002178\001472\002178\001379\002178\001876\002178\001672\002178\0011078\002178\001308\002178\001886\002178\001811\002178\001712\002178\00138\002178\001100\002178\001177\002178\0011058\002178\0011101\002178\0011446\002178\0011572\002178\0011056\002178\001141\002178\001969\002178\0011012\002178\001785\002178\0011497\002178\00116\002178\00159\002178\001325\002178\001768\002178\001796\002178\001975\002178\001894\002178\001910\002178\00119\002178\001135\002178\001375\002178\001996\002178\001260\002178\001452\002178\0011441\002178\001154\002178\001128\002178\001936\002178\0011237\002178\0011153\002178\001544\002178\0011183\002178\001844\002178\001869\002178\0011037\002178\001486\002178\0011235\002178\001763\002178\001688\002178\0011542\002178\0011227\002178\0011137\002178\0011631\002178\0011008\002178\001264\002178\0011197\002178\001606\002178\0011493\002178\0011561\002178\0011520\002178\0011303\002178\00186\002178\001228\002178\001389\002178\0011308\002178\001362\002178\001575\002178\001599\002178\001671\002178\001597\002178\00166\002178\001710\002178\001611\002178\00120\002178\001461\002178\001377\002178\001314\002178\001899\002178\001821\002178\0011295\002178\0011099\002178\001999\002178\001898\002178\001670\002178\001572\002178\0011061\002178\0011217\002178\0011150\002178\00144\002178\001637\002178\001659\002178\0011272\002178\001152\002178\001112\002178\001510\002178\001579\002178\001482\002178\001258\002178\001210\002178\001407\002178\0011135\002178\0011069\002178\001730\002178\0011215\002178\0011233\002178\0011430\002178\0011362\002178\001162\002178\001183\002178\001429\002178\001354\002178\001972\002178\001866\002178\0011387\002178\001804\002178\001150\002178\0011030\002178\0011397\002178\0011595\002178\001536\002178\0011181\002178\001592\002178\001989\002178\001887\002178\0011610\002178\0011632\002178\001775\002178\001802\002178\001824\002178\0011594\002178\0011428\002178\0011447\002178\001497\002178\0011329\002178\0011244\002178\001326\002178\0011412\002178\001586\002178\001511\002178\001350\002178\0011508\002178\0011577\002178\00139\002178\001521\002178\001767\002178\0011256\002178\0011164\002178\0011207\002178\001446\002178\001370\002178\001860\002178\001609\002178\0011418\002178\0011602\002178\00167\002178\001436\002178\0011211\002178\0011255\002178\0011276\002178\001369\002178\001735\002178\0011129\002178\0011373\002178\0011064\002178\0011220\002178\0011007\002178\0011608\002178\001400\002178\001925\002178\001357\002178\0011097\002178\0011515\002178\0011611\002178\0011096\002178\0011617\002178\001809\002178\001583\002178\001655\002178\001958\002178\0011494\002178\0011236\002178\001163\002178\001174\002178\001568\002178\001743\002178\0011426\002178\0011442\002178\0011407\002178\001129\002178\00135\002179\00129\002179\00137\002179\00132\002179\0010\002179\00117\002179\00115\002179\00114\002179\00119\002179\00111\002179\0015\002179\0010\002180\00159\002180\00162\002180\00156\002180\00167\002180\00132\002180\0015\002180\00116\002180\00126\002180\0019\002180\0016\002180\00139\002180\00136\002180\00123\002180\00153\002180\00111\002180\00140\002180\00138\002180\00152\002180\0017\002180\00135\002180\001142\002181\001104\002181\001100\002181\001125\002181\001110\002181\001136\002181\00159\002181\00178\002181\00177\002181\00163\002181\00111\002181\00139\002181\00122\002181\00195\002181\00158\002181\00155\002181\00187\002181\00145\002181\0011\002181\00153\002181\00181\002181","117"),
("2088622540891083","1","0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0","34\0021\0016\0022\0012\0023\0010\0024\0019\0025\0011\0026\00111\0027\00114\0028\00114\0029\001154\00210\00115\00211\001175\00212\0017\00213\00112\00214\00130\00215\001289\00216\0012\00217\0011\00221\00123\00223\0010\00224\0010\00225\0011\00226\0011\00227\0011\00228\00145\00229\00129\00231\00113\00231\00124\00231\001135\00232\00112\00233\0012\00233\0013\00233\00193\00234\001107\00234\00141\00234\001148\00234\001128\00234\00115\00234\001118\00234\001183\00234\001186\00234\00113\00234\00194\00234\00171\00234\00128\00234\001112\00234\00170\00234\00159\00234\001174\00234\001100\00234\001171\00234\00154\00234\00144\00234\00119\00235\00174\00235\00168\00235\00178\00235\00113\00235\00133\00235\00166\00235\00130\00235\00176\00235\00116\00236\00117\00236\0016\00236\0018\00236\00132\00236\00118\00236\00113\00236\00131\00236\001109\00237\00189\00237\00191\00237\00179\00237\00167\00237\00156\00237\00139\00237\0015\002141\0014\002143\00112\002143\0011\002144\0013\002144\0012\002145\00110\002145\00122\002145\0016\002145\0011\002146\0010\002146\00181\002147\00189\002147\00147\002147\00150\002147\00179\002147\00165\002147\00144\002147\00146\002147\00120\002147\00142\002147\0014\002147\00158\002147\00119\002147\00162\002147\00110\002147\00173\002147\00112\002147\00136\002147\00170\002147\00182\002147\0013\002147\00113\002147\00174\002147\00141\002147\00168\002147\00184\002147\00163\002147\00123\002147\00143\002147\00134\002147\0011\002147\00121\002147\00161\002147\0010\002147\00171\002147\00157\002147\00167\002147\00159\002147\00127\002147\00126\002148\00121\002148\001128\002148\0016\002148\00114\002148\001147\002148\00125\002148\00119\002148\00162\002148\00196\002148\0015\002148\001140\002148\00159\002148\00113\002148\00169\002148\00124\002150\001115\002150\00166\002150\001107\002150\00144\002150\001192\002150\001163\002151\001111\002151\001339\002151\00193\002151\00114\002151\001291\002151\001144\002151\001329\002151\001330\002151\001450\002151\001583\002152\001636\002152\001490\002153\00128\002153\001529\002153\001243\002153\001373\002153\001158\002153\00110\002153\001399\002153\00161\002153\001287\002153\001424\002153\001104\002153\001431\002153\001129\002153\001536\002154\00121\002154\001143\002154\001859\002154\001408\002154\00155\002154\001654\002154\001275\002154\001645\002154\001391\002154\001233\002154\001801\002154\001876\002154\001299\002154\0011004\002154\001390\002154\00117\002154\0010\002155\00127\002155\00126\002155\0014\002155\00128\002155\00124\002155\00144\002155\00155\002155\00136\002155\0013\002155\00139\002155\0017\002155\00145\002155\00132\002155\00110\002155\00138\002155\00117\002155\0018\002155\00122\002155\00123\002155\00114\002155\00120\002155\00156\002155\0015\002155\00140\002155\00148\002155\00150\002155\00125\002155\00141\002155\00143\002155\00133\002156\00121\002156\0015\002156\00124\002156\0014\002156\00139\002156\00132\002156\0016\002156\00129\002156\0011\002156\00123\002156\00111\002156\00136\002156\00120\002156\00131\002156\00147\002156\0019\002156\0018\002156\00137\002157\00118\002157\00122\002157\00113\002157\00123\002157\00132\002157\00120\002157\00121\002157\0013\002157\00135\002157\0019\002157\00138\002157\0015\002157\0010\002157\00126\002157\00130\002157\00117\002157\0016\002157\00127\002157\00131\002157\00136\002157\00139\002158\00136\002158\00118\002158\00189\002158\001109\002158\00169\002158\00146\002158\00126\002158\00120\002158\00183\002158\0011\002158\001103\002158\00125\002158\00133\002158\00175\002158\00149\002158\00162\002158\001100\002158\001126\002158\00152\002158\00186\002158\001107\002158\00198\002158\00199\002158\001118\002158\001117\002158\0015\002158\00174\002158\001113\002158\0010\002158\00129\002158\001124\002158\00137\002158\00116\002158\00132\002158\00194\002158\00113\002158\00160\002158\00197\002158\001120\002158\00151\002158\00193\002158\0014\002158\00110\002158\00144\002158\00158\002158\0013\002158\00182\002158\0012\002158\001127\002158\00163\002158\00114\002158\00157\002158\00177\002158\001104\002158\00128\002158\001119\002158\001106\002158\00115\002158\0017\002158\0016\002158\0018\002158\00170\002158\0019\002158\001112\002158\001115\002158\00185\002158\00155\002158\00138\002158\001116\002158\00124\002159\00131\002159\00144\002159\00152\002159\00120\002159\00134\002159\0012\002159\00147\002159\0016\002159\00110\002159\00142\002159\00125\002159\00150\002159\00141\002159\00152\002160\00131\002160\00183\002160\00157\002160\00110\002160\00184\002160\00186\002160\00177\002160\00154\002160\00166\002160\00146\002160\00161\002160\00185\002161\00196\002161\00162\002161\001128\002161\00125\002161\00186\002161\00138\002161\00194\002161\00167\002161\001125\002161\00136\002161\00148\002161\0017\002161\001124\002161\00189\002161\00172\002161\00170\002161\001134\002161\00144\002161\001122\002161\00110\002161\00159\002161\00156\002161\00143\002161\00142\002161\001108\002161\00113\002161\00139\002161\0014\002161\001132\002161\00138\002162\00161\002162\00165\002162\00117\002162\00145\002162\00131\002162\00157\002162\00149\002162\00153\002162\00120\002162\00179\002162\00125\002162\00172\002162\00162\002162\00116\002162\00150\002162\00126\002162\00137\002162\00181\002162\0014\002162\00111\002162\001158\002163\00135\002163\00195\002163\00111\002163\001190\002163\001172\002163\0017\002163\00199\002163\001182\002163\00110\002163\001161\002163\001129\002163\001101\002163\001167\002163\001105\002163\00138\002163\00143\002163\00132\002163\001148\002163\001183\002163\00185\002163\001143\002163\001169\002163\001164\002163\0016\002163\0015\002163\00114\002163\001111\002163\001170\002163\001185\002163\001153\002163\00144\002163\00115\002163\00160\002163\001162\002163\001140\002163\00175\002163\00197\002163\001118\002163\001165\002163\00182\002163\00164\002163\00172\002163\00173\002163\001166\002163\00192\002163\00126\002163\001106\002163\00196\002163\001171\002163\001180\002163\001156\002163\001123\002163\001128\002163\0013\002163\001144\002163\00149\002163\001117\002163\00166\002163\00130\002163\001142\002163\00180\002163\00189\002163\00141\002163\001100\002163\00190\002163\00121\002163\00155\002163\0010\002163\00161\002163\001209\002164\001125\002164\00141\002164\00148\002164\001222\002164\0018\002164\001106\002165\001113\002165\00156\002165\00115\002165\00133\002165\00196\002165\00179\002165\00129\002165\00111\002165\001216\002166\001185\002166\001191\002166\00118\002166\00181\002166\00199\002166\0017\002166\001202\002166\001119\002166\00130\002166\00195\002166\00112\002166\00132\002166\00197\002166\0016\002166\001198\002166\001182\002166\00146\002166\001682\002167\001582\002167\001646\002167\001644\002167\001562\002167\001607\002167\001622\002167\001585\002167\001639\002167\001667\002167\001630\002167\001659\002167\001597\002167\001610\002167\001586\002167\001591\002167\001670\002167\001672\002167\0015\002167\00121\002167\001389\002167\00181\002167\00171\002167\001337\002167\001380\002167\001441\002167\001546\002167\001329\002167\001547\002167\001175\002167\001232\002167\001178\002167\001408\002167\001377\002167\00145\002167\001425\002167\001204\002167\001270\002167\00189\002167\001388\002167\001221\002167\001365\002167\0016\002167\001160\002167\001409\002167\001195\002167\001215\002167\001295\002167\001515\002167\001216\002167\001311\002167\001524\002167\001224\002167\001282\002167\00135\002167\00116\002167\00119\002167\001394\002167\001341\002167\001263\002167\001357\002167\001239\002167\001307\002167\001342\002167\001477\002167\001146\002167\001322\002167\001446\002167\001313\002167\00179\002167\001259\002167\001364\002167\001336\002167\001363\002167\001452\002167\001537\002167\001219\002167\001484\002167\00176\002167\001310\002167\001233\002167\001456\002167\001128\002167\0012\002168\001272\002168\001271\002168\001279\002168\001275\002168\001274\002168\001280\002168\0017\002168\001152\002168\00170\002168\00127\002168\001115\002168\001235\002168\00174\002168\001139\002168\001166\002168\001195\002168\001229\002168\00125\002168\001147\002168\00192\002168\001104\002168\00198\002168\00195\002168\001116\002168\001247\002168\001107\002168\001192\002168\001239\002168\001224\002168\00136\002168\001105\002168\001135\002168\001163\002168\00137\002168\00199\002168\00178\002168\001262\002168\001186\002168\001118\002168\001226\002168\001109\002168\001112\002168\001172\002168\001184\002168\001189\002168\00163\002168\001100\002168\001254\002168\001268\002168\001817\002169\0011\002169\00113\002169\00119\002169\001732\002169\001798\002169\001766\002169\001724\002169\001759\002169\001783\002169\001796\002169\001812\002169\001742\002169\001745\002169\001708\002169\001780\002169\001746\002169\001791\002169\001810\002169\00134\002169\00163\002169\00193\002169\00169\002169\001104\002169\001194\002169\001255\002169\001646\002169\001142\002169\001484\002169\001184\002169\001649\002169\001681\002169\001301\002169\00173\002169\001337\002169\001428\002169\001119\002169\001392\002169\001209\002169\001351\002169\001152\002169\001117\002169\001267\002169\001377\002169\001666\002169\001687\002169\001695\002169\001416\002169\001132\002169\001291\002169\00145\002169\00156\002169\001583\002169\00148\002169\001315\002169\001287\002169\001299\002169\001314\002169\001561\002169\001599\002169\00161\002169\00191\002169\001659\002169\001633\002169\00122\002169\00149\002169\001123\002169\001582\002169\001162\002169\001150\002169\001265\002169\001403\002169\001677\002169\001696\002169\001361\002169\001625\002169\001239\002169\001672\002169\001419\002169\001434\002169\001470\002169\001581\002169\001531\002169\001139\002169\001158\002169\001441\002169\001218\002169\001331\002169\001570\002169\001335\002169\001180\002169\001410\002169\001424\002169\001373\002169\001588\002169\001401\002169\001697\002169\001118\002169\001391\002169\001462\002169\001387\002169\001311\002169\001378\002169\00164\002170\00165\002170\00190\002170\00181\002170\0010\002170\00134\002170\00120\002170\00113\002170\00145\002170\00160\002170\00129\002170\00161\002170\00122\002170\00117\002170\00162\002170\0010\002171\0011\002171\00122\002172\0012\002172\0013\002172\00114\002172\00116\002172\001253\002173\001241\002173\001210\002173\001245\002173\001213\002173\001225\002173\001224\002173\001235\002173\001250\002173\001230\002173\001216\002173\001247\002173\001252\002173\00140\002173\00117\002173\00185\002173\00112\002173\00155\002173\001156\002173\0017\002173\00119\002173\0014\002173\0015\002173\001196\002173\001174\002173\001201\002173\00191\002173\001133\002173\00148\002173\00142\002173\001208\002173\001193\002173\001119\002173\001161\002173\001152\002173\00125\002173\00178\002173\001127\002173\001189\002173\00170\002173\001138\002173\001129\002173\001177\002173\001107\002173\001115\002173\00156\002173\001160\002173\001114\002173\00154\002173\001126\002173\00198\002173\001150\002173\00161\002173\001171\002173\00179\002173\001195\002173\001175\002173\00172\002173\001151\002173\00150\002173\001145\002173\00174\002173\001118\002173\00192\002173\00163\002173\001205\002173\00158\002173\001154\002173\001111\002173\001199\002173\00164\002173\001173\002173\00120\002173\00146\002173\00132\002173\00110\002173\001124\002173\00152\002173\00130\002173\00169\002173\001185\002173\0015\002174\0014\002174\00165\002175\0012\002175\00128\002175\00121\002175\0014\002175\00144\002175\0010\002176\00136\002176\00140\002176\00134\002176\00124\002176\0014\002176\00127\002176\00115\002176\00118\002176\00133\002176\00116\002176\0013\002176\00120\002176\0012\002176\00113\002176\00122\002176\00181\002177\00187\002177\00197\002177\00190\002177\001103\002177\001101\002177\00156\002177\00118\002177\00166\002177\00144\002177\00132\002177\00116\002177\0013\002177\00168\002177\00140\002177\00153\002177\0011876\002178\0011882\002178\0014\002178\0015\002178\0011640\002178\0011643\002178\0011763\002178\0011637\002178\0011752\002178\0011713\002178\0011703\002178\0011848\002178\0011685\002178\0011662\002178\0011814\002178\0011823\002178\0011762\002178\0011679\002178\0011664\002178\0011654\002178\0011751\002178\0011680\002178\0011842\002178\0011753\002178\0011765\002178\0011815\002178\0011764\002178\0011661\002178\0011690\002178\0011821\002178\0011783\002178\0011768\002178\0011794\002178\0011874\002178\0011785\002178\0011836\002178\0011868\002178\00127\002178\001955\002178\00114\002178\00136\002178\001408\002178\001194\002178\001494\002178\0011422\002178\00171\002178\001651\002178\001263\002178\001280\002178\001527\002178\0011060\002178\001577\002178\001355\002178\0011041\002178\00163\002178\001239\002178\001528\002178\001415\002178\0011464\002178\001538\002178\001449\002178\001717\002178\001472\002178\001600\002178\001876\002178\001931\002178\0011078\002178\001841\002178\001886\002178\001940\002178\001966\002178\0011436\002178\001100\002178\001416\002178\0011058\002178\0011101\002178\0011025\002178\0011572\002178\0011056\002178\001590\002178\001969\002178\001884\002178\001785\002178\0011111\002178\00116\002178\00159\002178\001747\002178\001435\002178\001199\002178\0011098\002178\001894\002178\001910\002178\0011198\002178\001135\002178\00196\002178\001996\002178\001260\002178\001452\002178\001891\002178\001154\002178\001191\002178\001703\002178\0011237\002178\0011153\002178\001544\002178\0011183\002178\0011095\002178\0011117\002178\001422\002178\001486\002178\0011235\002178\001763\002178\0011273\002178\001868\002178\0011227\002178\0011353\002178\0011631\002178\001180\002178\001442\002178\0011085\002178\001606\002178\001630\002178\001908\002178\0011520\002178\0011196\002178\00186\002178\001587\002178\001737\002178\001709\002178\00155\002178\001575\002178\001599\002178\001671\002178\001848\002178\001159\002178\001710\002178\001986\002178\00120\002178\001461\002178\001377\002178\001403\002178\001771\002178\0011054\002178\0011295\002178\0011319\002178\0011337\002178\0011023\002178\001670\002178\001572\002178\0011061\002178\0011217\002178\001649\002178\00129\002178\001340\002178\0011017\002178\0011375\002178\001152\002178\001112\002178\001510\002178\001827\002178\001728\002178\001119\002178\001210\002178\001407\002178\0011135\002178\0011180\002178\001405\002178\001601\002178\0011550\002178\0011600\002178\0011362\002178\001310\002178\001183\002178\001429\002178\001354\002178\001972\002178\001866\002178\0011068\002178\001804\002178\001218\002178\001906\002178\0011193\002178\0011549\002178\001536\002178\0011181\002178\001716\002178\0011113\002178\001887\002178\001941\002178\0011632\002178\0011261\002178\001802\002178\0011396\002178\0011214\002178\0011428\002178\0011447\002178\001497\002178\0011329\002178\0011244\002178\001326\002178\0011210\002178\001586\002178\001511\002178\001350\002178\0011010\002178\0011038\002178\00168\002178\001642\002178\0011336\002178\0011256\002178\0011164\002178\0011207\002178\001446\002178\001370\002178\001860\002178\0011087\002178\001858\002178\0011602\002178\00167\002178\001436\002178\0011211\002178\0011255\002178\0011526\002178\001369\002178\001735\002178\0011241\002178\0011373\002178\0011064\002178\0011220\002178\0011007\002178\0011267\002178\001622\002178\001342\002178\001357\002178\001845\002178\0011515\002178\0011459\002178\0011534\002178\0011617\002178\001809\002178\001583\002178\0011009\002178\001958\002178\0011494\002178\0011432\002178\001163\002178\001174\002178\001453\002178\001618\002178\0011426\002178\0011442\002178\0011407\002178\001129\002178\00135\002179\00127\002179\00137\002179\00132\002179\0012\002179\00121\002179\00115\002179\00114\002179\00119\002179\0018\002179\0015\002179\0010\002180\00159\002180\00162\002180\00156\002180\00167\002180\00132\002180\0015\002180\00116\002180\00126\002180\0019\002180\0016\002180\00139\002180\00136\002180\00123\002180\00153\002180\00111\002180\00140\002180\00138\002180\00152\002180\0017\002180\00135\002180\001142\002181\001113\002181\001111\002181\001112\002181\001126\002181\001114\002181\00119\002181\00157\002181\00177\002181\00123\002181\00149\002181\0018\002181\0015\002181\00184\002181\00112\002181\0019\002181\00173\002181\00176\002181\00179\002181\00164\002181\00160\002181","46"),
("2088612841110110","1","0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0","57\0021\0012\0022\0010\0023\0013\0024\0014\0025\0011\0026\00118\0027\0017\0028\00119\0029\00199\00210\00120\00211\001134\00212\0019\00213\001228\00214\0015\00215\001198\00216\0012\00217\0011\00221\00123\00223\0010\00224\0010\00225\0010\00226\0010\00227\0011\00228\00143\00229\0015\00231\00126\00231\00121\00231\001179\00232\00112\00233\0015\00233\0013\00233\00180\00234\001107\00234\00155\00234\00146\00234\001128\00234\00150\00234\001118\00234\00179\00234\001186\00234\00113\00234\00194\00234\00171\00234\00128\00234\00190\00234\00170\00234\00159\00234\001174\00234\001100\00234\001171\00234\00154\00234\00144\00234\00119\00235\00174\00235\00168\00235\00185\00235\00113\00235\00133\00235\00166\00235\00152\00235\00176\00235\00112\00236\0015\00236\0016\00236\0018\00236\00132\00236\00118\00236\00113\00236\00131\00236\001109\00237\00189\00237\00191\00237\00179\00237\00167\00237\00156\00237\00139\00237\0013\002141\0017\002143\0014\002143\0013\002144\0011\002144\0017\002145\0016\002145\00110\002145\00121\002145\0010\002146\00148\002147\0019\002147\00147\002147\00188\002147\00153\002147\00165\002147\00144\002147\00146\002147\00120\002147\00142\002147\0014\002147\00158\002147\00119\002147\00162\002147\00110\002147\00173\002147\00138\002147\00136\002147\00176\002147\00182\002147\00149\002147\00113\002147\00174\002147\00141\002147\00168\002147\00184\002147\00163\002147\00123\002147\00143\002147\00134\002147\0011\002147\00121\002147\00161\002147\0010\002147\00171\002147\00157\002147\00167\002147\00159\002147\00114\002147\00186\002147\001143\002148\001122\002148\00172\002148\0016\002148\00114\002148\001147\002148\00129\002148\00119\002148\00162\002148\00127\002148\00165\002148\001126\002148\00142\002148\00113\002148\00169\002148\001195\002150\001115\002150\00166\002150\00144\002150\001192\002150\001389\002151\001345\002151\00131\002151\001246\002151\001122\002151\001271\002151\00198\002151\00183\002151\001352\002151\001221\002151\001213\002151\001191\002151\001128\002151\001138\002151\001360\002151\001296\002151\00149\002151\00191\002151\001583\002152\001636\002152\001232\002152\001474\002152\001301\002152\001260\002152\00128\002152\001419\002152\001802\002152\001241\002153\001421\002153\001529\002153\001243\002153\001373\002153\001158\002153\001210\002153\001368\002153\001445\002153\001287\002153\001424\002153\001104\002153\001431\002153\001348\002153\001100\002154\00121\002154\001143\002154\001859\002154\001713\002154\001697\002154\001399\002154\001214\002154\001661\002154\001237\002154\001925\002154\00190\002154\001543\002154\001440\002154\00157\002154\001968\002154\001812\002154\0010\002155\00127\002155\00126\002155\0014\002155\00128\002155\00124\002155\00144\002155\00155\002155\00136\002155\0013\002155\00139\002155\0017\002155\00145\002155\00132\002155\00110\002155\00138\002155\00117\002155\0018\002155\00122\002155\00123\002155\00114\002155\00120\002155\00156\002155\0015\002155\00140\002155\00148\002155\00150\002155\00125\002155\00141\002155\00143\002155\00133\002156\00121\002156\00122\002156\00143\002156\0014\002156\00139\002156\00132\002156\0016\002156\00147\002156\0018\002156\00137\002157\00118\002157\00122\002157\00113\002157\00123\002157\00132\002157\00120\002157\00121\002157\0013\002157\00135\002157\0019\002157\00138\002157\0015\002157\0010\002157\00126\002157\00130\002157\00117\002157\0016\002157\00127\002157\00131\002157\00136\002157\00139\002158\00136\002158\00118\002158\00189\002158\001109\002158\00169\002158\00146\002158\00126\002158\00120\002158\00183\002158\0011\002158\001103\002158\00125\002158\00133\002158\00175\002158\00149\002158\00162\002158\001100\002158\001126\002158\00152\002158\00186\002158\001107\002158\00198\002158\00199\002158\001118\002158\001117\002158\0015\002158\00166\002158\001113\002158\0010\002158\00129\002158\001124\002158\00137\002158\00116\002158\00132\002158\00194\002158\00113\002158\00160\002158\00197\002158\001120\002158\00151\002158\00193\002158\0014\002158\00110\002158\00144\002158\00158\002158\0013\002158\00182\002158\0012\002158\001127\002158\00163\002158\00114\002158\00157\002158\00177\002158\001104\002158\00128\002158\001119\002158\001106\002158\00115\002158\0017\002158\0016\002158\0018\002158\00170\002158\0019\002158\001112\002158\001115\002158\00185\002158\00155\002158\00138\002158\001116\002158\00124\002159\00128\002159\00144\002159\00135\002159\00120\002159\00134\002159\0012\002159\00147\002159\0016\002159\00110\002159\00142\002159\00125\002159\00150\002159\00141\002159\00152\002160\00131\002160\00183\002160\00157\002160\00110\002160\00184\002160\00186\002160\00177\002160\00154\002160\00166\002160\00146\002160\00161\002160\00185\002161\00196\002161\00162\002161\001128\002161\00125\002161\00186\002161\00138\002161\00194\002161\00167\002161\001125\002161\00136\002161\00148\002161\0017\002161\001124\002161\00189\002161\00172\002161\00170\002161\001134\002161\00144\002161\001122\002161\00110\002161\00159\002161\00156\002161\00143\002161\00142\002161\001108\002161\00113\002161\00139\002161\0014\002161\001132\002161\00138\002162\00161\002162\00165\002162\00117\002162\00145\002162\00131\002162\00157\002162\00149\002162\00153\002162\00120\002162\00179\002162\00125\002162\00172\002162\00162\002162\00116\002162\00150\002162\00126\002162\00137\002162\00181\002162\0014\002162\00111\002162\001158\002163\00135\002163\00195\002163\00111\002163\001190\002163\001172\002163\0017\002163\00199\002163\001182\002163\00110\002163\001161\002163\001129\002163\001101\002163\001167\002163\001105\002163\00138\002163\00143\002163\00132\002163\001148\002163\001183\002163\00185\002163\001143\002163\001169\002163\001164\002163\0016\002163\0015\002163\00114\002163\001111\002163\001170\002163\001185\002163\001153\002163\00144\002163\00115\002163\00160\002163\001162\002163\001140\002163\00175\002163\00197\002163\001118\002163\001165\002163\00182\002163\00164\002163\00172\002163\00173\002163\001166\002163\00192\002163\00126\002163\001106\002163\00196\002163\001171\002163\001180\002163\001156\002163\001123\002163\001128\002163\0013\002163\001144\002163\00149\002163\001117\002163\00166\002163\00130\002163\001142\002163\00180\002163\00189\002163\00141\002163\001100\002163\00190\002163\00121\002163\00155\002163\0010\002163\00161\002163\00141\002164\00148\002164\0018\002164\00134\002165\001105\002165\00156\002165\00160\002165\00133\002165\00196\002165\0019\002165\001119\002165\001117\002165\001168\002166\001185\002166\001127\002166\00118\002166\00156\002166\0019\002166\001175\002166\001202\002166\00195\002166\00153\002166\00132\002166\001181\002166\0016\002166\001134\002166\001182\002166\001193\002166\001681\002167\001582\002167\001606\002167\001579\002167\001562\002167\001567\002167\001622\002167\001585\002167\001626\002167\001649\002167\001588\002167\001594\002167\001597\002167\001610\002167\001586\002167\001591\002167\001670\002167\001672\002167\00117\002167\00121\002167\001424\002167\00181\002167\001192\002167\001337\002167\001380\002167\001406\002167\001510\002167\001285\002167\001534\002167\001175\002167\001232\002167\00188\002167\001145\002167\001377\002167\001201\002167\001382\002167\001425\002167\001204\002167\001270\002167\00167\002167\001388\002167\001221\002167\001237\002167\001454\002167\00152\002167\001240\002167\00160\002167\001449\002167\001295\002167\001515\002167\001216\002167\00177\002167\001503\002167\001266\002167\001282\002167\00122\002167\001470\002167\00132\002167\001308\002167\001473\002167\001263\002167\001357\002167\001239\002167\001307\002167\001297\002167\001477\002167\00164\002167\001278\002167\001372\002167\001313\002167\001545\002167\00179\002167\001259\002167\001364\002167\001336\002167\001363\002167\001298\002167\001537\002167\001219\002167\001402\002167\00158\002167\001310\002167\001400\002167\001428\002167\001390\002167\0012\002168\001272\002168\001269\002168\001279\002168\001277\002168\001276\002168\001280\002168\0017\002168\001120\002168\00170\002168\00134\002168\001146\002168\001251\002168\00174\002168\001139\002168\001166\002168\001170\002168\001176\002168\00125\002168\001147\002168\00192\002168\00179\002168\001125\002168\00195\002168\00115\002168\001217\002168\001107\002168\001192\002168\001239\002168\001224\002168\001108\002168\00160\002168\001135\002168\001163\002168\00137\002168\001127\002168\00178\002168\001262\002168\001186\002168\001118\002168\001226\002168\001109\002168\001112\002168\001172\002168\001184\002168\001189\002168\00163\002168\001128\002168\001254\002168\001267\002168\001817\002169\0011\002169\00117\002169\001698\002169\001732\002169\001711\002169\001766\002169\001735\002169\001759\002169\001802\002169\001796\002169\001814\002169\001755\002169\001757\002169\001708\002169\001780\002169\001746\002169\001801\002169\001813\002169\00153\002169\00163\002169\00193\002169\00199\002169\001186\002169\001243\002169\001306\002169\001646\002169\001142\002169\001574\002169\001591\002169\001649\002169\00121\002169\001355\002169\00173\002169\001395\002169\001428\002169\001119\002169\001392\002169\001259\002169\001592\002169\001236\002169\00127\002169\001267\002169\001377\002169\001524\002169\001576\002169\00159\002169\001124\002169\001132\002169\001241\002169\00145\002169\00156\002169\001615\002169\00148\002169\001171\002169\001287\002169\001353\002169\001314\002169\001561\002169\001369\002169\00142\002169\00191\002169\001659\002169\001633\002169\00130\002169\001405\002169\001123\002169\001178\002169\001162\002169\001195\002169\001265\002169\001460\002169\001602\002169\001307\002169\001361\002169\001625\002169\001289\002169\001580\002169\001419\002169\001434\002169\001565\002169\001581\002169\001610\002169\001139\002169\001158\002169\001441\002169\001260\002169\001331\002169\001607\002169\001335\002169\001229\002169\001410\002169\001478\002169\001486\002169\001588\002169\001341\002169\001697\002169\001147\002169\001391\002169\001462\002169\001387\002169\001128\002169\001437\002169\00163\002170\00167\002170\00189\002170\00181\002170\0010\002170\00134\002170\00120\002170\00113\002170\00148\002170\00160\002170\00129\002170\00161\002170\00122\002170\00121\002170\00162\002170\0010\002171\0011\002171\00122\002172\0012\002172\0015\002172\00114\002172\00116\002172\001253\002173\001241\002173\001236\002173\001245\002173\001213\002173\001225\002173\001244\002173\001235\002173\001250\002173\001230\002173\001216\002173\001247\002173\001252\002173\00140\002173\00117\002173\001164\002173\00112\002173\00155\002173\001156\002173\001197\002173\00119\002173\0014\002173\0015\002173\001196\002173\001174\002173\001201\002173\00191\002173\001133\002173\00148\002173\00142\002173\001208\002173\001193\002173\001119\002173\001161\002173\001104\002173\00125\002173\00178\002173\001127\002173\001189\002173\00170\002173\001138\002173\001129\002173\001177\002173\001107\002173\001115\002173\00156\002173\001160\002173\001114\002173\00154\002173\001126\002173\00198\002173\001150\002173\00161\002173\001171\002173\00179\002173\001195\002173\001175\002173\00172\002173\001151\002173\00150\002173\001145\002173\00174\002173\001118\002173\00192\002173\00163\002173\001205\002173\001140\002173\001154\002173\00176\002173\001199\002173\00164\002173\001173\002173\00120\002173\00146\002173\00132\002173\00110\002173\001124\002173\00152\002173\00130\002173\00169\002173\001185\002173\0015\002174\0014\002174\00170\002175\0010\002175\00128\002175\00112\002175\00154\002175\00144\002175\0010\002176\00136\002176\00140\002176\00134\002176\00124\002176\0014\002176\00127\002176\00115\002176\00118\002176\00133\002176\00116\002176\0013\002176\00120\002176\0012\002176\00113\002176\00122\002176\00181\002177\00187\002177\00197\002177\00190\002177\001103\002177\001101\002177\00156\002177\00118\002177\00166\002177\00144\002177\00132\002177\00116\002177\0013\002177\00168\002177\00140\002177\00153\002177\0011875\002178\0013\002178\0014\002178\0015\002178\0011771\002178\0011651\002178\0011642\002178\0011645\002178\0011707\002178\0011713\002178\0011767\002178\0011848\002178\0011685\002178\0011662\002178\0011814\002178\0011676\002178\0011762\002178\0011660\002178\0011683\002178\0011671\002178\0011751\002178\0011704\002178\0011842\002178\0011753\002178\0011765\002178\0011851\002178\0011788\002178\0011661\002178\0011690\002178\0011821\002178\0011783\002178\0011791\002178\0011813\002178\0011874\002178\0011705\002178\0011669\002178\0011868\002178\00127\002178\0011082\002178\00130\002178\00136\002178\001118\002178\0011043\002178\001865\002178\001888\002178\001383\002178\001651\002178\001263\002178\001701\002178\001527\002178\0011173\002178\001700\002178\001451\002178\0011041\002178\00163\002178\00145\002178\001650\002178\001415\002178\001697\002178\001538\002178\00157\002178\001717\002178\001472\002178\001480\002178\0011338\002178\0011170\002178\0011078\002178\001308\002178\001886\002178\0011385\002178\001712\002178\0011565\002178\001100\002178\001416\002178\0011058\002178\0011101\002178\001645\002178\0011572\002178\0011462\002178\001473\002178\001969\002178\0011130\002178\0011271\002178\0011419\002178\00116\002178\00159\002178\001747\002178\001768\002178\001274\002178\001975\002178\0011141\002178\001910\002178\0011479\002178\001359\002178\00196\002178\001409\002178\001260\002178\001452\002178\0011441\002178\001154\002178\001265\002178\001467\002178\0011237\002178\0011451\002178\001198\002178\0011290\002178\001844\002178\001869\002178\001782\002178\001486\002178\0011235\002178\0011252\002178\001688\002178\0011589\002178\0011500\002178\0011440\002178\001299\002178\0011008\002178\001264\002178\0011085\002178\001856\002178\0011493\002178\0011504\002178\0011520\002178\0011196\002178\00186\002178\001965\002178\001389\002178\0011308\002178\00191\002178\001575\002178\001599\002178\001671\002178\001976\002178\00166\002178\001835\002178\001986\002178\00120\002178\001461\002178\001377\002178\001314\002178\001771\002178\001695\002178\0011295\002178\0011490\002178\0011337\002178\0011143\002178\001670\002178\001572\002178\0011174\002178\0011217\002178\001649\002178\00129\002178\001516\002178\0011017\002178\0011457\002178\001384\002178\001112\002178\001510\002178\001579\002178\001980\002178\001339\002178\001210\002178\0011333\002178\0011135\002178\0011472\002178\001730\002178\001979\002178\001878\002178\0011430\002178\0011362\002178\001396\002178\001183\002178\001429\002178\001354\002178\0011203\002178\0011226\002178\0011532\002178\001138\002178\001218\002178\0011149\002178\0011537\002178\0011549\002178\001536\002178\0011181\002178\001592\002178\0011113\002178\001887\002178\0011578\002178\001345\002178\0011261\002178\0011172\002178\0011080\002178\0011214\002178\0011428\002178\0011447\002178\001497\002178\0011555\002178\0011510\002178\001326\002178\0011547\002178\001586\002178\001255\002178\001350\002178\0011010\002178\0011270\002178\001236\002178\001769\002178\001519\002178\0011256\002178\0011461\002178\0011207\002178\001446\002178\001470\002178\001860\002178\0011403\002178\0011221\002178\0011036\002178\00167\002178\001436\002178\0011211\002178\0011255\002178\0011526\002178\001706\002178\001735\002178\0011129\002178\0011373\002178\0011064\002178\0011220\002178\0011238\002178\0011575\002178\001622\002178\001795\002178\001569\002178\001845\002178\0011571\002178\0011291\002178\0011534\002178\0011545\002178\001809\002178\001583\002178\001423\002178\0011306\002178\0011494\002178\0011562\002178\001163\002178\001174\002178\001453\002178\001870\002178\0011426\002178\0011442\002178\0011485\002178\001129\002178\00135\002179\00127\002179\00137\002179\00132\002179\0010\002179\00117\002179\00115\002179\00114\002179\00119\002179\0018\002179\0015\002179\0010\002180\00159\002180\00162\002180\00156\002180\00167\002180\00132\002180\0015\002180\00116\002180\00126\002180\0019\002180\0016\002180\00139\002180\00136\002180\00123\002180\00153\002180\00111\002180\00140\002180\00138\002180\00152\002180\0017\002180\00135\002180\001142\002181\001113\002181\001111\002181\001112\002181\001126\002181\001114\002181\00119\002181\00157\002181\00177\002181\00123\002181\00149\002181\0018\002181\0015\002181\00184\002181\00112\002181\0019\002181\00173\002181\00176\002181\00179\002181\00164\002181\00160\002181","153"),
("2088212427359421","1","0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0","37\0021\0013\0022\0012\0023\0018\0024\0014\0025\0011\0026\00129\0027\00124\0028\00110\0029\001146\00210\00118\00211\001237\00212\00114\00213\001107\00214\0010\00215\001123\00216\0011\00217\0011\00221\00123\00223\0010\00224\0010\00225\0010\00226\0010\00227\0011\00228\00136\00229\0015\00231\00126\00231\00131\00231\001382\00232\00112\00233\0015\00233\00139\00233\00155\00233\00117\00233\00121\00234\00193\00234\0015\00234\00141\00234\001148\00234\001188\00234\00115\00234\001118\00234\001183\00234\001186\00234\001141\00234\00194\00234\00171\00234\00128\00234\001112\00234\00170\00234\001119\00234\001174\00234\001100\00234\001171\00234\00154\00234\00144\00234\00119\00235\00174\00235\00161\00235\00133\00235\00151\00235\00176\00235\00116\00236\0010\00236\0012\00236\0018\00236\00132\00236\00118\00236\00113\00236\00131\00236\001109\00237\00189\00237\00191\00237\00179\00237\00167\00237\00156\00237\00139\00237\0015\002141\0011\002143\00112\002143\0015\002143\0014\002143\0011\002144\0013\002144\00110\002145\00116\002145\0012\002145\0011\002145\00117\002145\00122\002145\0010\002146\0011\002146\00181\002147\0019\002147\00147\002147\00150\002147\00179\002147\00165\002147\00144\002147\00146\002147\00120\002147\00142\002147\0014\002147\00158\002147\00119\002147\00162\002147\00110\002147\00173\002147\00138\002147\00136\002147\00176\002147\0016\002147\00149\002147\00113\002147\00174\002147\00141\002147\00168\002147\00184\002147\00163\002147\00123\002147\00143\002147\00134\002147\0011\002147\00121\002147\00161\002147\00166\002147\00171\002147\00157\002147\00167\002147\00159\002147\00114\002147\00127\002147\001169\002148\00121\002148\00180\002148\0016\002148\00114\002148\001147\002148\00175\002148\00119\002148\00162\002148\00196\002148\0015\002148\001140\002148\00190\002148\001164\002148\00169\002148\001172\002149\001224\002149\00156\002149\001332\002149\001213\002149\001153\002149\001401\002149\00182\002149\001268\002149\001124\002149\00173\002149\001266\002149\001203\002149\001111\002149\001392\002149\001330\002149\001214\002150\001183\002150\00171\002150\00134\002150\001218\002150\00124\002150\00122\002150\00166\002150\00144\002150\001192\002150\001163\002151\00131\002151\001332\002151\001123\002151\001271\002151\001477\002151\001267\002151\001433\002151\001292\002151\001272\002151\001289\002151\001185\002151\00159\002151\001194\002151\001237\002151\001460\002151\001583\002152\001636\002152\001490\002153\001421\002153\001529\002153\001284\002153\001373\002153\001390\002153\00110\002153\001399\002153\00161\002153\001147\002153\001101\002153\001113\002153\00118\002153\001229\002153\00140\002153\001780\002154\001921\002154\001675\002154\00168\002154\001507\002154\001298\002154\00167\002154\001111\002154\001175\002154\001858\002154\001996\002154\001544\002154\001942\002154\001548\002154\001732\002154\001779\002154\001724\002154\0010\002155\00127\002155\00126\002155\0014\002155\00128\002155\00124\002155\00144\002155\00155\002155\00136\002155\0013\002155\00139\002155\0017\002155\00145\002155\00132\002155\00110\002155\00138\002155\00117\002155\0018\002155\00122\002155\00123\002155\00114\002155\00120\002155\00156\002155\00149\002155\00140\002155\00148\002155\00150\002155\00125\002155\00141\002155\00143\002155\00118\002156\00140\002156\00122\002156\00143\002156\00130\002156\00139\002156\00132\002156\0016\002156\00129\002156\00135\002156\00141\002156\00111\002156\00136\002156\00120\002156\00117\002156\00145\002156\00142\002156\00147\002156\0019\002156\0018\002156\00137\002157\00118\002157\00122\002157\00113\002157\00123\002157\00132\002157\00120\002157\00121\002157\0013\002157\00135\002157\0019\002157\00138\002157\0015\002157\0010\002157\00126\002157\00130\002157\00117\002157\0016\002157\00127\002157\00131\002157\00136\002157\00139\002158\00136\002158\00118\002158\00189\002158\001109\002158\00169\002158\00146\002158\00126\002158\00120\002158\00183\002158\0011\002158\001103\002158\00125\002158\00133\002158\00175\002158\00149\002158\00162\002158\001100\002158\001126\002158\00152\002158\00186\002158\001107\002158\00198\002158\00199\002158\001118\002158\001117\002158\0015\002158\00174\002158\001113\002158\0010\002158\00129\002158\001124\002158\00137\002158\00192\002158\00132\002158\00194\002158\00113\002158\00160\002158\00197\002158\001120\002158\00151\002158\00193\002158\0014\002158\00110\002158\00144\002158\00158\002158\0013\002158\00182\002158\0012\002158\001127\002158\001110\002158\00114\002158\00157\002158\00177\002158\001104\002158\00128\002158\001119\002158\001106\002158\00115\002158\0017\002158\0016\002158\0018\002158\00170\002158\0019\002158\001112\002158\001115\002158\00185\002158\00155\002158\00138\002158\001116\002158\00124\002159\00131\002159\00144\002159\00135\002159\00120\002159\00130\002159\0012\002159\00123\002159\0016\002159\00110\002159\00142\002159\00140\002159\00150\002159\0017\002159\00159\002160\00136\002160\00152\002160\00131\002160\00183\002160\00157\002160\00110\002160\00184\002160\00186\002160\00177\002160\00154\002160\00166\002160\00146\002160\00161\002160\00185\002161\00196\002161\00162\002161\001128\002161\00125\002161\00186\002161\00138\002161\00194\002161\00167\002161\001125\002161\00136\002161\00148\002161\0017\002161\001124\002161\00189\002161\00172\002161\00170\002161\001134\002161\00144\002161\001122\002161\00110\002161\00159\002161\00156\002161\00143\002161\00142\002161\001108\002161\00113\002161\00139\002161\0014\002161\001132\002161\00138\002162\00161\002162\00165\002162\00117\002162\00145\002162\00131\002162\00157\002162\00149\002162\00153\002162\00120\002162\00179\002162\00125\002162\00172\002162\00162\002162\00116\002162\00150\002162\00126\002162\00137\002162\00181\002162\0014\002162\00111\002162\001158\002163\00135\002163\00195\002163\00111\002163\001190\002163\001172\002163\0017\002163\00199\002163\001182\002163\00110\002163\001161\002163\001129\002163\001101\002163\001167\002163\001105\002163\00138\002163\00143\002163\00132\002163\001148\002163\001183\002163\00185\002163\001143\002163\001169\002163\001164\002163\0016\002163\0015\002163\00114\002163\001111\002163\001170\002163\001185\002163\001153\002163\00144\002163\00115\002163\00160\002163\001162\002163\001140\002163\00175\002163\00197\002163\001118\002163\001165\002163\00182\002163\00164\002163\00172\002163\00173\002163\001166\002163\00192\002163\00126\002163\001106\002163\00196\002163\001171\002163\001180\002163\001156\002163\001123\002163\001128\002163\0013\002163\001144\002163\00149\002163\001117\002163\00166\002163\00130\002163\001142\002163\00180\002163\00189\002163\00141\002163\001100\002163\00190\002163\00121\002163\00155\002163\0010\002163\00161\002163\001228\002164\001125\002164\00141\002164\00130\002164\00168\002164\0018\002164\00134\002165\00161\002165\00156\002165\00146\002165\00133\002165\00196\002165\00176\002165\001115\002165\001107\002165\001169\002166\001185\002166\001109\002166\001103\002166\00181\002166\0019\002166\0017\002166\001188\002166\00195\002166\001123\002166\00132\002166\001137\002166\00185\002166\001134\002166\001182\002166\00194\002166\001681\002167\001638\002167\001646\002167\001631\002167\001562\002167\001567\002167\001622\002167\001613\002167\001626\002167\001568\002167\001630\002167\001648\002167\001597\002167\001610\002167\001641\002167\001591\002167\001670\002167\001672\002167\00142\002167\00121\002167\001475\002167\00181\002167\00129\002167\001337\002167\001380\002167\001143\002167\00137\002167\001444\002167\0018\002167\001175\002167\001232\002167\001210\002167\001207\002167\001414\002167\00145\002167\001425\002167\001204\002167\001270\002167\001152\002167\001388\002167\001221\002167\001365\002167\001476\002167\001227\002167\001370\002167\001107\002167\001215\002167\001295\002167\001515\002167\001216\002167\001104\002167\001320\002167\001353\002167\001282\002167\00165\002167\0019\002167\001167\002167\001132\002167\001517\002167\001306\002167\001357\002167\001283\002167\001307\002167\001297\002167\001535\002167\00185\002167\001322\002167\001372\002167\001313\002167\00179\002167\001259\002167\001364\002167\001379\002167\001363\002167\001474\002167\001537\002167\001219\002167\001526\002167\00158\002167\001310\002167\001462\002167\001428\002167\001163\002167\0012\002168\001272\002168\001269\002168\001279\002168\001277\002168\001274\002168\001280\002168\0017\002168\001152\002168\00170\002168\00127\002168\00187\002168\001251\002168\00174\002168\001139\002168\001166\002168\001212\002168\001248\002168\00125\002168\001147\002168\00192\002168\001104\002168\001125\002168\00195\002168\00119\002168\001259\002168\001107\002168\001192\002168\001239\002168\001236\002168\00129\002168\00160\002168\001135\002168\001163\002168\00137\002168\001127\002168\00178\002168\001262\002168\001186\002168\001118\002168\001226\002168\001109\002168\001112\002168\001172\002168\001184\002168\001189\002168\00163\002168\001100\002168\001254\002168\001233\002168\001817\002169\0011\002169\00115\002169\001698\002169\001732\002169\001711\002169\001766\002169\001735\002169\001799\002169\001792\002169\001716\002169\001814\002169\001755\002169\001757\002169\001708\002169\001780\002169\001746\002169\001729\002169\001813\002169\00134\002169\00140\002169\00193\002169\00199\002169\001186\002169\001194\002169\001255\002169\001646\002169\001142\002169\001220\002169\001550\002169\001649\002169\00121\002169\001301\002169\00173\002169\001549\002169\001428\002169\001119\002169\001392\002169\001259\002169\001457\002169\001286\002169\001691\002169\001215\002169\001377\002169\001420\002169\001536\002169\001695\002169\00164\002169\001132\002169\001291\002169\00145\002169\001354\002169\001336\002169\00176\002169\001315\002169\001287\002169\001353\002169\001314\002169\001561\002169\001571\002169\001359\002169\001264\002169\001659\002169\001633\002169\00122\002169\001345\002169\001123\002169\001279\002169\001162\002169\001398\002169\001265\002169\001356\002169\001564\002169\001256\002169\001361\002169\001596\002169\001114\002169\001680\002169\001419\002169\001488\002169\001522\002169\001581\002169\001573\002169\001139\002169\001158\002169\001441\002169\001260\002169\001106\002169\001607\002169\001335\002169\001334\002169\001465\002169\001606\002169\001173\002169\001588\002169\001458\002169\001102\002169\001147\002169\001501\002169\001595\002169\001387\002169\001311\002169\001578\002169\00163\002170\00167\002170\00189\002170\00181\002170\0010\002170\00140\002170\00120\002170\00113\002170\00152\002170\00160\002170\00129\002170\00110\002170\00122\002170\00126\002170\00139\002170\0010\002171\0011\002171\00122\002172\0012\002172\0016\002172\00114\002172\00116\002172\001253\002173\001241\002173\001236\002173\001245\002173\001213\002173\001225\002173\001215\002173\001235\002173\001250\002173\001230\002173\001216\002173\001247\002173\001252\002173\00140\002173\00117\002173\00167\002173\00112\002173\00155\002173\001156\002173\00111\002173\00129\002173\0014\002173\0015\002173\001196\002173\001174\002173\001201\002173\00191\002173\001133\002173\00148\002173\00142\002173\001208\002173\001193\002173\001119\002173\001161\002173\00186\002173\00125\002173\00178\002173\001127\002173\001189\002173\00170\002173\001138\002173\001129\002173\001177\002173\001107\002173\001115\002173\00156\002173\001160\002173\001114\002173\00154\002173\001126\002173\00198\002173\001150\002173\00161\002173\001171\002173\00179\002173\001195\002173\001175\002173\00172\002173\001151\002173\00150\002173\001145\002173\00174\002173\001118\002173\00192\002173\00163\002173\001205\002173\001169\002173\001154\002173\00176\002173\001199\002173\00164\002173\001173\002173\00120\002173\00146\002173\00132\002173\00110\002173\001124\002173\00152\002173\00130\002173\001105\002173\001185\002173\0015\002174\0014\002174\00165\002175\0012\002175\00128\002175\00118\002175\0014\002175\00144\002175\0010\002176\00136\002176\00140\002176\00134\002176\00124\002176\0014\002176\00127\002176\00115\002176\00118\002176\00133\002176\00116\002176\0013\002176\00120\002176\0012\002176\00113\002176\00122\002176\00186\002177\00187\002177\00197\002177\00190\002177\001103\002177\001110\002177\00156\002177\00118\002177\00175\002177\00144\002177\00132\002177\00116\002177\0013\002177\00168\002177\00140\002177\00153\002177\0011867\002178\0011882\002178\0014\002178\0015\002178\0011644\002178\0011792\002178\0011665\002178\0011672\002178\0011707\002178\0011713\002178\0011724\002178\0011848\002178\0011685\002178\0011739\002178\0011814\002178\0011676\002178\0011762\002178\0011660\002178\0011664\002178\0011816\002178\0011751\002178\0011725\002178\0011678\002178\0011753\002178\0011686\002178\0011647\002178\0011764\002178\0011661\002178\0011690\002178\0011821\002178\0011783\002178\0011812\002178\0011861\002178\0011658\002178\0011785\002178\0011736\002178\0011868\002178\00127\002178\001955\002178\00114\002178\00136\002178\001636\002178\001194\002178\001393\002178\001633\002178\001220\002178\001529\002178\001263\002178\001280\002178\0011029\002178\0011060\002178\0011383\002178\001355\002178\0011041\002178\001151\002178\001508\002178\001528\002178\001525\002178\0011464\002178\001538\002178\001449\002178\001717\002178\001472\002178\001600\002178\0011231\002178\001931\002178\0011296\002178\001392\002178\001758\002178\0011285\002178\001712\002178\00138\002178\001216\002178\001328\002178\001463\002178\0011101\002178\001645\002178\0011572\002178\0011380\002178\001287\002178\001969\002178\0011012\002178\001558\002178\0011554\002178\00122\002178\00197\002178\001175\002178\001435\002178\001199\002178\0011209\002178\0011254\002178\001910\002178\0011538\002178\001135\002178\00196\002178\001996\002178\001260\002178\001452\002178\0011513\002178\00142\002178\001265\002178\001205\002178\0011237\002178\001677\002178\001198\002178\0011290\002178\0011205\002178\001869\002178\0011037\002178\001857\002178\0011235\002178\0011355\002178\001814\002178\0011589\002178\0011599\002178\0011512\002178\001487\002178\001253\002178\001264\002178\0011304\002178\001606\002178\001630\002178\0011265\002178\0011520\002178\0011196\002178\00186\002178\001228\002178\001490\002178\001709\002178\001362\002178\001575\002178\001599\002178\001361\002178\001597\002178\00166\002178\001710\002178\001611\002178\00120\002178\001461\002178\001849\002178\001314\002178\001771\002178\0011279\002178\0011295\002178\0011490\002178\001999\002178\001898\002178\001670\002178\001572\002178\001282\002178\0011217\002178\001649\002178\001322\002178\00178\002178\0011017\002178\0011457\002178\001221\002178\001112\002178\001510\002178\0011302\002178\001482\002178\001540\002178\001210\002178\001635\002178\0011135\002178\0011533\002178\001855\002178\001601\002178\0011233\002178\0011560\002178\0011362\002178\001498\002178\001183\002178\001539\002178\001354\002178\001972\002178\001513\002178\0011583\002178\001804\002178\001150\002178\001906\002178\0011537\002178\0011549\002178\001536\002178\0011181\002178\001716\002178\001989\002178\0011246\002178\0011178\002178\001345\002178\001775\002178\001932\002178\001824\002178\0011491\002178\0011428\002178\0011447\002178\001992\002178\0011329\002178\0011566\002178\001326\002178\0011547\002178\001586\002178\001756\002178\001350\002178\0011508\002178\0011577\002178\001165\002178\001521\002178\0011022\002178\0011256\002178\0011378\002178\0011207\002178\001446\002178\001585\002178\001860\002178\001609\002178\001858\002178\0011602\002178\00167\002178\001201\002178\0011211\002178\0011255\002178\0011276\002178\001369\002178\001735\002178\0011129\002178\0011373\002178\0011064\002178\0011220\002178\0011344\002178\0011608\002178\001503\002178\0011165\002178\001357\002178\0011208\002178\0011275\002178\0011072\002178\0011585\002178\0011545\002178\001809\002178\001583\002178\001655\002178\0011402\002178\0011494\002178\0011236\002178\001163\002178\001174\002178\001568\002178\001618\002178\0011426\002178\0011442\002178\0011407\002178\001129\002178\00125\002179\00127\002179\00137\002179\00132\002179\0010\002179\00117\002179\00115\002179\00114\002179\00119\002179\0018\002179\0015\002179\0010\002180\00159\002180\00162\002180\00156\002180\00167\002180\00132\002180\0015\002180\00116\002180\00126\002180\0019\002180\0016\002180\00139\002180\00136\002180\00123\002180\00153\002180\00111\002180\00140\002180\00138\002180\00152\002180\0017\002180\00135\002180\001142\002181\001113\002181\001111\002181\001112\002181\001126\002181\001114\002181\00119\002181\00157\002181\00177\002181\00123\002181\00149\002181\0018\002181\0015\002181\00184\002181\00112\002181\0019\002181\00173\002181\00176\002181\00179\002181\00164\002181\00160\002181","132"),
("2088922151623074","1","0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0","49\0021\0015\0022\0011\0023\00111\0024\0018\0025\0010\0026\0016\0027\00117\0028\0014\0029\001379\00210\00129\00211\001144\00212\00117\00213\00125\00214\00128\00215\001299\00216\0010\00217\0011\00221\00123\00223\0010\00224\0010\00225\0010\00226\0010\00227\0011\00228\00119\00229\0015\00231\00126\00231\0018\00231\001357\00232\00112\00233\0015\00233\0013\00233\00165\00234\00163\00234\0015\00234\00134\00234\001148\00234\001173\00234\00153\00234\001118\00234\001178\00234\001186\00234\001181\00234\00194\00234\00171\00234\00128\00234\001112\00234\00170\00234\00159\00234\001174\00234\001100\00234\001171\00234\00154\00234\00144\00234\00126\00235\00174\00235\00161\00235\00133\00235\00151\00235\00176\00235\00116\00236\00119\00236\00115\00236\0012\00236\0018\00236\00132\00236\00118\00236\00113\00236\00131\00236\001109\00237\00189\00237\00191\00237\00179\00237\00167\00237\00156\00237\00139\00237\0015\002141\0017\002143\0015\002143\0014\002143\0010\002143\00112\002143\0013\002143\0013\002144\0011\002144\00122\002145\00116\002145\0017\002145\0012\002145\0013\002145\0010\002146\0011\002146\00148\002147\00189\002147\00147\002147\00188\002147\00153\002147\00165\002147\00144\002147\00146\002147\00120\002147\00142\002147\0014\002147\00158\002147\00119\002147\00162\002147\00110\002147\00173\002147\00138\002147\00136\002147\00182\002147\0013\002147\00113\002147\00174\002147\00141\002147\00168\002147\00184\002147\00155\002147\00123\002147\00143\002147\00134\002147\0011\002147\00121\002147\00161\002147\0010\002147\00171\002147\00157\002147\00117\002147\00159\002147\00114\002147\00127\002147\001143\002148\001122\002148\00172\002148\0016\002148\00114\002148\001147\002148\001162\002148\00119\002148\00162\002148\001160\002148\00143\002148\00193\002148\00177\002148\00113\002148\00181\002148\00181\002150\00159\002150\00196\002150\00144\002150\001192\002150\001209\002151\001127\002151\001243\002151\001217\002151\001330\002151\001222\002151\001583\002152\001636\002152\001490\002153\001421\002153\001529\002153\001271\002153\001373\002153\001150\002153\001406\002153\001442\002153\001374\002153\0016\002153\001520\002153\001502\002153\001215\002153\001115\002153\001267\002153\001746\002154\00131\002154\001479\002154\001554\002154\001320\002154\001697\002154\001399\002154\001308\002154\001652\002154\001591\002154\001281\002154\001820\002154\001876\002154\00132\002154\001128\002154\001509\002154\001963\002154\001523\002154\001738\002154\001138\002154\001636\002154\001337\002154\0010\002155\00127\002155\00126\002155\0014\002155\00128\002155\00124\002155\00144\002155\00155\002155\00136\002155\0013\002155\00139\002155\0017\002155\00145\002155\00132\002155\00110\002155\00138\002155\00117\002155\0018\002155\00122\002155\00123\002155\00114\002155\00120\002155\00156\002155\0015\002155\00140\002155\00148\002155\00150\002155\00125\002155\00141\002155\00143\002155\00118\002156\00121\002156\0015\002156\00124\002156\00130\002156\00125\002156\00132\002156\0016\002156\00142\002156\00147\002156\0019\002156\0018\002156\00137\002157\00118\002157\00122\002157\00113\002157\00123\002157\00132\002157\00120\002157\00121\002157\0013\002157\00135\002157\0019\002157\00138\002157\0015\002157\0010\002157\00126\002157\00130\002157\00117\002157\0016\002157\00127\002157\00131\002157\00136\002157\00139\002158\00136\002158\00118\002158\00189\002158\001109\002158\00169\002158\00146\002158\00126\002158\00120\002158\00183\002158\0011\002158\001103\002158\00125\002158\00133\002158\00175\002158\00149\002158\00162\002158\001100\002158\001126\002158\00152\002158\00186\002158\001107\002158\00198\002158\00199\002158\001118\002158\001117\002158\0015\002158\00166\002158\001113\002158\0010\002158\00129\002158\001124\002158\00137\002158\00116\002158\00132\002158\00194\002158\00113\002158\00160\002158\00197\002158\001120\002158\00151\002158\00193\002158\0014\002158\00110\002158\00144\002158\00158\002158\0013\002158\00182\002158\0012\002158\001127\002158\00163\002158\00114\002158\00157\002158\00177\002158\001104\002158\00128\002158\001119\002158\001106\002158\00115\002158\0017\002158\0016\002158\0018\002158\00170\002158\0019\002158\001112\002158\001115\002158\00185\002158\00155\002158\00138\002158\001116\002158\00124\002159\00131\002159\00144\002159\00135\002159\00120\002159\00130\002159\0012\002159\00147\002159\0016\002159\00110\002159\00142\002159\00125\002159\00150\002159\00141\002159\00152\002160\00131\002160\00183\002160\00157\002160\00110\002160\00184\002160\00186\002160\00177\002160\00154\002160\00166\002160\00146\002160\00161\002160\00185\002161\00196\002161\00162\002161\001128\002161\00125\002161\00186\002161\00138\002161\00194\002161\00167\002161\001125\002161\00136\002161\00148\002161\0017\002161\001124\002161\00189\002161\00172\002161\00170\002161\001134\002161\00144\002161\001122\002161\00110\002161\00159\002161\00156\002161\00143\002161\00142\002161\001108\002161\00113\002161\00139\002161\0014\002161\001132\002161\00138\002162\00161\002162\00165\002162\00117\002162\00145\002162\00131\002162\00157\002162\00149\002162\00153\002162\00120\002162\00179\002162\00125\002162\00172\002162\00162\002162\00116\002162\00150\002162\00126\002162\00137\002162\00181\002162\0014\002162\00111\002162\001158\002163\00135\002163\00195\002163\00111\002163\001190\002163\001172\002163\0017\002163\00199\002163\001182\002163\00110\002163\001161\002163\001129\002163\001101\002163\001167\002163\001105\002163\00138\002163\00143\002163\00132\002163\001148\002163\001183\002163\00185\002163\001143\002163\001169\002163\001164\002163\0016\002163\0015\002163\00114\002163\001111\002163\001170\002163\001185\002163\001153\002163\00144\002163\00115\002163\00160\002163\001162\002163\001140\002163\00175\002163\00197\002163\001118\002163\001165\002163\00182\002163\00164\002163\00172\002163\00173\002163\001166\002163\00192\002163\00126\002163\001106\002163\00196\002163\001171\002163\001180\002163\001156\002163\001123\002163\001128\002163\0013\002163\001144\002163\00149\002163\001117\002163\00166\002163\00130\002163\001142\002163\00180\002163\00189\002163\00141\002163\001100\002163\00190\002163\00121\002163\00155\002163\0010\002163\00161\002163\00141\002164\00196\002164\001216\002164\001111\002165\00144\002165\00128\002165\00171\002165\00127\002165\0019\002165\001119\002165\001117\002165\00138\002166\00175\002166\001204\002166\001147\002166\00181\002166\0019\002166\001188\002166\00195\002166\001213\002166\00132\002166\00197\002166\00185\002166\001134\002166\001182\002166\00194\002166\001681\002167\001582\002167\001559\002167\001579\002167\001562\002167\001607\002167\001622\002167\001576\002167\001626\002167\001584\002167\001578\002167\001608\002167\001597\002167\001610\002167\001586\002167\001591\002167\001670\002167\001672\002167\00117\002167\00121\002167\001453\002167\00181\002167\00138\002167\001337\002167\001380\002167\001441\002167\001528\002167\001329\002167\0014\002167\001175\002167\001232\002167\00188\002167\001145\002167\001377\002167\00183\002167\001425\002167\001204\002167\001270\002167\00167\002167\001388\002167\001221\002167\001142\002167\0016\002167\00194\002167\001284\002167\001195\002167\001417\002167\001295\002167\001515\002167\001216\002167\00177\002167\001481\002167\001309\002167\001282\002167\0017\002167\001470\002167\00119\002167\001265\002167\001251\002167\001263\002167\001357\002167\001239\002167\001307\002167\001297\002167\001477\002167\001146\002167\001278\002167\001372\002167\001313\002167\001545\002167\00179\002167\001259\002167\001364\002167\001336\002167\001363\002167\001298\002167\001537\002167\001219\002167\001463\002167\00158\002167\001310\002167\001480\002167\001428\002167\001128\002167\0018\002168\001272\002168\001271\002168\001279\002168\001277\002168\001276\002168\001280\002168\00116\002168\001152\002168\00170\002168\00127\002168\001146\002168\001221\002168\00174\002168\001139\002168\001166\002168\00186\002168\001149\002168\00125\002168\001147\002168\00192\002168\001104\002168\00175\002168\00195\002168\00168\002168\001217\002168\001107\002168\001192\002168\001239\002168\001258\002168\00146\002168\00160\002168\001135\002168\001163\002168\00137\002168\001127\002168\00178\002168\001262\002168\001186\002168\001118\002168\001226\002168\001140\002168\001112\002168\001172\002168\001219\002168\001208\002168\00163\002168\001100\002168\001260\002168\001255\002168\001817\002169\0011\002169\00113\002169\00119\002169\001732\002169\001798\002169\001766\002169\001715\002169\001759\002169\001783\002169\001796\002169\001804\002169\001731\002169\001745\002169\001708\002169\001780\002169\001746\002169\001791\002169\001800\002169\00125\002169\00128\002169\00143\002169\001435\002169\001497\002169\001551\002169\001597\002169\001646\002169\001142\002169\001484\002169\001184\002169\001649\002169\001681\002169\001301\002169\00173\002169\001337\002169\001428\002169\001119\002169\001392\002169\001209\002169\001399\002169\001236\002169\00127\002169\001167\002169\001377\002169\001420\002169\001489\002169\00137\002169\00164\002169\00197\002169\001241\002169\00145\002169\00156\002169\001583\002169\00148\002169\001315\002169\001287\002169\001299\002169\001314\002169\001561\002169\001599\002169\00161\002169\00191\002169\001659\002169\001633\002169\001685\002169\00149\002169\001123\002169\001582\002169\001162\002169\001398\002169\001265\002169\001403\002169\001469\002169\001696\002169\001361\002169\001558\002169\001239\002169\001672\002169\001419\002169\001434\002169\001522\002169\001541\002169\001531\002169\001139\002169\001158\002169\001441\002169\001260\002169\001331\002169\001570\002169\001335\002169\001180\002169\001410\002169\001424\002169\001373\002169\001588\002169\001341\002169\001697\002169\001147\002169\001391\002169\001462\002169\001387\002169\001311\002169\001378\002169\00164\002170\00188\002170\00189\002170\00178\002170\0012\002170\00118\002170\00120\002170\00113\002170\00124\002170\0013\002170\00129\002170\00155\002170\00122\002170\00143\002170\00162\002170\0010\002171\0011\002171\00122\002172\0012\002172\00120\002172\00114\002172\00116\002172\001253\002173\001241\002173\001236\002173\001245\002173\001213\002173\001225\002173\001224\002173\001235\002173\001250\002173\001230\002173\001216\002173\001247\002173\001252\002173\00140\002173\00117\002173\00185\002173\00112\002173\00155\002173\001156\002173\0013\002173\00119\002173\0014\002173\0015\002173\001196\002173\001174\002173\001201\002173\00191\002173\001133\002173\00148\002173\00142\002173\001208\002173\001193\002173\001119\002173\001161\002173\00168\002173\00125\002173\00178\002173\001127\002173\001189\002173\00170\002173\001138\002173\001129\002173\001177\002173\001107\002173\001115\002173\00156\002173\001160\002173\001114\002173\00154\002173\001126\002173\00198\002173\001150\002173\00161\002173\001171\002173\00179\002173\001195\002173\001175\002173\00172\002173\001151\002173\00150\002173\001145\002173\00174\002173\001118\002173\00192\002173\00163\002173\001205\002173\001140\002173\001154\002173\001158\002173\001199\002173\00164\002173\001173\002173\00120\002173\00146\002173\00132\002173\00110\002173\001124\002173\00152\002173\00130\002173\00169\002173\001185\002173\0015\002174\0014\002174\00164\002175\0015\002175\00128\002175\00115\002175\00158\002175\00152\002175\0010\002176\00136\002176\00140\002176\00134\002176\00124\002176\0014\002176\00127\002176\00115\002176\00118\002176\00133\002176\00116\002176\0013\002176\00120\002176\0012\002176\00113\002176\00122\002176\00181\002177\00187\002177\00197\002177\00190\002177\001103\002177\001101\002177\00156\002177\00128\002177\00146\002177\00144\002177\00132\002177\00116\002177\0013\002177\00168\002177\00140\002177\00153\002177\0011863\002178\0011882\002178\0014\002178\0015\002178\0011771\002178\0011792\002178\0011720\002178\0011637\002178\0011707\002178\0011713\002178\0011703\002178\0011848\002178\0011685\002178\0011739\002178\0011814\002178\0011778\002178\0011762\002178\0011660\002178\0011664\002178\0011760\002178\0011773\002178\0011680\002178\0011842\002178\0011753\002178\0011765\002178\0011815\002178\0011721\002178\0011661\002178\0011690\002178\0011821\002178\0011783\002178\0011768\002178\0011748\002178\0011874\002178\0011785\002178\0011836\002178\0011868\002178\00127\002178\001955\002178\00114\002178\001593\002178\001408\002178\0011043\002178\001393\002178\0011422\002178\001220\002178\001330\002178\001263\002178\001280\002178\001776\002178\001438\002178\0011466\002178\00152\002178\0011041\002178\00163\002178\001239\002178\001251\002178\0011361\002178\0011464\002178\001538\002178\001449\002178\001717\002178\001472\002178\001379\002178\001751\002178\001672\002178\0011078\002178\001715\002178\001758\002178\001684\002178\001712\002178\0011347\002178\001100\002178\001177\002178\0011058\002178\0011101\002178\001645\002178\0011572\002178\0011056\002178\001141\002178\001969\002178\001884\002178\001785\002178\001987\002178\00122\002178\00159\002178\00175\002178\001768\002178\001796\002178\001975\002178\001894\002178\001910\002178\0011198\002178\001135\002178\00196\002178\001996\002178\001260\002178\001452\002178\0011557\002178\001154\002178\001128\002178\001936\002178\0011237\002178\0011153\002178\001544\002178\0011183\002178\001844\002178\001869\002178\001254\002178\001486\002178\0011235\002178\001662\002178\0011273\002178\0011116\002178\0011227\002178\0011137\002178\0011631\002178\0011008\002178\001264\002178\0011085\002178\001606\002178\0011493\002178\0011504\002178\0011520\002178\0011467\002178\00186\002178\001471\002178\001389\002178\001709\002178\00123\002178\001575\002178\001599\002178\001671\002178\001597\002178\00166\002178\001710\002178\001611\002178\00120\002178\001461\002178\001377\002178\001314\002178\001176\002178\0011054\002178\0011188\002178\0011099\002178\001999\002178\001898\002178\001670\002178\001572\002178\0011061\002178\0011217\002178\001649\002178\00129\002178\001516\002178\0011017\002178\0011044\002178\001152\002178\001112\002178\001510\002178\001579\002178\001482\002178\001119\002178\001210\002178\0011333\002178\0011135\002178\0011069\002178\001730\002178\001601\002178\0011492\002178\0011430\002178\0011362\002178\001162\002178\001183\002178\001429\002178\001354\002178\001972\002178\001866\002178\0011068\002178\001804\002178\001150\002178\001906\002178\0011193\002178\0011549\002178\001536\002178\0011181\002178\001592\002178\001989\002178\001887\002178\0011578\002178\0011632\002178\001775\002178\001802\002178\001824\002178\0011214\002178\0011428\002178\0011447\002178\001616\002178\0011329\002178\0011244\002178\001326\002178\0011210\002178\001586\002178\001511\002178\001350\002178\0011010\002178\0011038\002178\00124\002178\001521\002178\0011336\002178\0011256\002178\0011277\002178\0011207\002178\001446\002178\001370\002178\001860\002178\001960\002178\001858\002178\0011602\002178\00167\002178\001436\002178\0011211\002178\0011255\002178\0011276\002178\001369\002178\001735\002178\0011129\002178\0011373\002178\0011064\002178\0011220\002178\0011007\002178\0011154\002178\001400\002178\001342\002178\001357\002178\001845\002178\0011515\002178\0011459\002178\0011487\002178\0011545\002178\001809\002178\001583\002178\0011009\002178\001958\002178\0011494\002178\0011236\002178\001163\002178\001174\002178\001568\002178\001618\002178\0011426\002178\0011442\002178\0011407\002178\001129\002178\00135\002179\00127\002179\00137\002179\00132\002179\0010\002179\00121\002179\00115\002179\00114\002179\00119\002179\0018\002179\0015\002179\0010\002180\00159\002180\00162\002180\00156\002180\00167\002180\00132\002180\0015\002180\00116\002180\00126\002180\0019\002180\0016\002180\00139\002180\00136\002180\00123\002180\00153\002180\00111\002180\00140\002180\00138\002180\00152\002180\0017\002180\00135\002180\001142\002181\001113\002181\001111\002181\001112\002181\001126\002181\001114\002181\00119\002181\00157\002181\00177\002181\00123\002181\00149\002181\0018\002181\0015\002181\00184\002181\00112\002181\0019\002181\00173\002181\00176\002181\00179\002181\00164\002181\00160\002181","78"),
("2088012780663397","1","0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0","73\0021\0010\0022\0015\0023\0010\0024\00110\0025\0010\0026\00125\0027\0011\0028\0010\0029\001294\00210\0010\00211\001327\00212\00126\00213\00153\00214\00124\00215\001162\00216\0010\00217\0011\00221\0010\00224\0011\00225\0011\00226\0010\00227\0011\00228\00149\00229\0015\00231\00113\00231\0012\00231\001317\00232\00161\00232\00196\00232\00160\00232\001291\00232\0017\00232\001244\00232\001375\00232\001314\00232\001110\00232\001113\00232\001264\00232\001227\00232\001276\00232\001187\00232\00117\00232\001319\00232\00112\00233\00142\00233\00136\00233\00122\00233\00130\00233\00127\00234\001151\00234\00152\00234\00141\00234\001148\00234\001188\00234\00115\00234\001118\00234\00130\00234\001186\00234\00113\00234\00194\00234\00171\00234\00128\00234\001112\00234\00170\00234\00159\00234\001174\00234\001100\00234\001171\00234\00154\00234\00144\00234\00126\00235\00174\00235\00161\00235\00133\00235\00151\00235\00176\00235\00126\00236\00112\00236\00125\00236\0012\00236\0018\00236\00132\00236\00118\00236\00113\00236\00131\00236\001109\00237\00189\00237\00191\00237\00179\00237\00167\00237\00156\00237\00139\00237\0015\002141\0015\002143\0010\002143\00112\002143\0017\002143\0014\002143\0016\002143\0013\002144\0011\002144\00110\002145\00117\002145\0017\002145\0013\002145\00121\002145\00122\002145\0018\002145\00120\002145\00116\002145\00113\002145\0010\002146\0011\002146\00148\002147\0019\002147\00147\002147\00188\002147\00153\002147\00165\002147\00144\002147\00146\002147\00120\002147\00142\002147\00170\002147\00182\002147\0013\002147\00113\002147\00174\002147\00141\002147\00168\002147\00184\002147\00163\002147\00123\002147\00143\002147\00134\002147\0011\002147\00121\002147\00161\002147\0010\002147\00171\002147\00157\002147\00167\002147\00159\002147\00186\002147\001143\002148\001122\002148\00172\002148\0016\002148\00114\002148\001147\002148\00125\002148\001155\002148\001144\002148\00196\002148\00131\002148\001140\002148\00190\002148\001164\002148\00169\002148\00178\002149\001224\002149\00156\002149\001223\002149\001213\002149\001153\002149\001201\002149\00182\002149\001268\002149\001169\002149\00173\002149\001266\002149\001277\002149\001111\002149\001363\002149\001101\002149\001221\002149\001350\002149\001322\002149\001142\002149\00120\002150\00179\002150\00181\002150\00191\002150\001210\002150\001130\002150\001218\002150\00124\002150\00122\002150\001160\002150\001107\002150\00111\002150\00116\002150\001204\002150\00143\002150\001171\002150\001104\002150\001153\002150\001175\002150\00119\002150\00140\002150\00178\002150\001163\002151\001245\002151\001241\002151\001477\002151\00124\002151\001352\002151\001221\002151\001405\002151\001403\002151\001244\002151\001238\002151\001424\002151\001583\002152\001636\002152\001490\002153\001421\002153\001529\002153\001284\002153\001373\002153\001390\002153\00136\002153\001214\002153\001499\002153\001199\002153\001394\002153\00135\002153\001101\002153\001113\002153\00118\002153\00142\002153\001129\002153\001371\002153\001238\002153\00122\002153\001432\002153\001332\002153\001516\002153\001224\002153\001407\002154\001458\002154\001309\002154\001163\002154\001999\002154\001346\002154\001527\002154\001308\002154\001322\002154\001166\002154\001503\002154\001340\002154\001398\002154\001708\002154\001216\002154\001116\002154\001498\002154\001221\002154\001681\002154\001454\002154\001599\002154\001956\002154\001330\002154\001965\002154\001670\002154\001265\002154\001172\002154\001162\002154\001109\002154\001636\002154\001489\002154\001694\002154\0010\002155\00127\002155\00126\002155\0014\002155\00128\002155\00124\002155\00144\002155\00155\002155\00136\002155\0013\002155\00139\002155\0017\002155\00145\002155\00132\002155\00110\002155\00138\002155\00117\002155\0018\002155\00122\002155\00123\002155\00114\002155\00120\002155\00156\002155\0015\002155\00140\002155\00148\002155\00150\002155\00125\002155\00141\002155\00143\002155\00133\002156\00140\002156\0015\002156\00143\002156\00130\002156\00125\002156\00132\002156\0016\002156\00112\002156\00147\002156\0019\002156\0018\002156\00137\002157\00118\002157\00122\002157\00113\002157\00123\002157\00132\002157\00120\002157\00121\002157\0013\002157\00135\002157\0019\002157\00138\002157\0015\002157\0010\002157\00126\002157\00130\002157\00117\002157\0016\002157\00127\002157\00131\002157\00136\002157\00139\002158\00136\002158\00118\002158\00189\002158\001109\002158\00169\002158\00146\002158\00126\002158\00120\002158\00183\002158\0011\002158\001103\002158\00125\002158\00133\002158\00175\002158\00149\002158\00162\002158\001100\002158\001126\002158\00152\002158\00186\002158\001107\002158\00198\002158\00199\002158\001118\002158\001117\002158\0015\002158\00166\002158\001113\002158\0010\002158\00129\002158\001124\002158\00137\002158\00116\002158\00132\002158\00194\002158\00113\002158\00160\002158\00197\002158\001120\002158\00151\002158\00193\002158\0014\002158\00110\002158\00144\002158\00158\002158\0013\002158\00182\002158\0012\002158\001127\002158\00163\002158\00114\002158\00157\002158\00177\002158\001104\002158\00128\002158\001119\002158\001106\002158\00115\002158\0017\002158\0016\002158\0018\002158\00170\002158\0019\002158\001112\002158\001115\002158\00185\002158\00155\002158\00138\002158\001116\002158\00124\002159\00131\002159\00144\002159\00135\002159\00120\002159\00130\002159\0012\002159\00147\002159\0016\002159\00110\002159\00142\002159\00125\002159\00150\002159\00141\002159\00152\002160\00131\002160\00183\002160\00157\002160\00110\002160\00184\002160\00186\002160\00177\002160\00154\002160\00166\002160\00146\002160\00161\002160\00185\002161\00196\002161\00162\002161\001128\002161\00125\002161\00186\002161\00138\002161\00194\002161\00167\002161\001125\002161\00136\002161\00148\002161\0017\002161\001124\002161\00189\002161\00172\002161\00170\002161\001134\002161\00144\002161\001122\002161\00110\002161\00159\002161\00156\002161\00143\002161\00142\002161\001108\002161\00113\002161\00139\002161\0014\002161\001132\002161\00138\002162\00161\002162\00165\002162\00117\002162\00145\002162\00131\002162\00157\002162\00149\002162\00153\002162\00120\002162\00179\002162\00125\002162\00172\002162\00162\002162\00116\002162\00150\002162\00126\002162\00137\002162\00181\002162\0014\002162\00111\002162\001158\002163\00135\002163\00195\002163\00111\002163\001190\002163\001172\002163\0017\002163\00199\002163\001182\002163\00110\002163\001161\002163\001129\002163\001101\002163\001167\002163\001105\002163\00138\002163\00143\002163\00132\002163\001148\002163\001183\002163\00185\002163\001143\002163\001169\002163\001164\002163\0016\002163\0015\002163\00114\002163\001111\002163\001170\002163\001185\002163\001153\002163\00144\002163\00115\002163\00160\002163\001162\002163\001140\002163\00175\002163\00197\002163\001118\002163\001165\002163\00182\002163\00164\002163\00172\002163\00173\002163\001166\002163\00192\002163\00126\002163\001106\002163\00196\002163\001171\002163\001180\002163\001156\002163\001123\002163\001128\002163\0013\002163\001144\002163\00149\002163\001117\002163\00166\002163\00130\002163\001142\002163\00180\002163\00189\002163\00141\002163\001100\002163\00190\002163\00121\002163\00155\002163\0010\002163\00161\002163\00141\002164\00130\002164\0015\002164\001106\002164\00119\002164\00122\002164\00117\002165\0013\002165\00156\002165\00160\002165\00133\002165\00153\002165\0019\002165\001119\002165\001117\002165\00124\002166\00175\002166\001191\002166\001103\002166\00156\002166\00199\002166\0017\002166\001188\002166\00195\002166\00112\002166\00132\002166\001137\002166\0016\002166\00111\002166\001182\002166\00194\002166\001681\002167\001563\002167\001619\002167\001617\002167\001562\002167\001567\002167\001622\002167\001627\002167\001580\002167\001667\002167\001630\002167\001594\002167\001597\002167\001624\002167\001671\002167\001605\002167\001678\002167\001677\002167\00117\002167\00121\002167\001302\002167\001108\002167\00129\002167\001381\002167\001450\002167\001205\002167\00137\002167\001467\002167\0013\002167\001213\002167\001232\002167\001148\002167\001145\002167\001414\002167\001236\002167\001292\002167\001460\002167\001242\002167\001270\002167\00150\002167\001423\002167\001262\002167\001365\002167\001454\002167\00169\002167\001240\002167\001195\002167\001181\002167\001340\002167\001515\002167\001256\002167\001267\002167\001320\002167\001309\002167\001326\002167\00147\002167\00140\002167\001134\002167\001100\002167\001517\002167\001392\002167\001357\002167\001239\002167\001351\002167\001297\002167\001499\002167\00164\002167\001322\002167\001469\002167\001313\002167\00179\002167\001259\002167\001404\002167\001379\002167\001403\002167\001387\002167\001537\002167\001260\002167\001330\002167\001135\002167\001310\002167\001462\002167\001543\002167\001230\002167\0014\002168\001272\002168\001269\002168\001279\002168\001275\002168\001274\002168\001280\002168\0017\002168\001152\002168\00170\002168\00127\002168\00187\002168\001251\002168\00174\002168\001131\002168\001166\002168\001212\002168\001215\002168\00125\002168\001147\002168\00192\002168\001104\002168\001125\002168\00195\002168\00119\002168\001263\002168\001164\002168\001192\002168\00194\002168\001236\002168\00136\002168\001133\002168\001135\002168\001163\002168\00137\002168\001127\002168\00178\002168\001262\002168\001186\002168\001118\002168\001226\002168\001109\002168\001168\002168\001172\002168\001204\002168\001208\002168\00163\002168\001128\002168\001260\002168\001233\002168\001817\002169\0011\002169\0019\002169\001698\002169\001732\002169\001808\002169\001766\002169\001715\002169\001781\002169\001751\002169\001796\002169\001804\002169\001721\002169\001757\002169\001708\002169\001780\002169\001746\002169\001811\002169\001810\002169\00134\002169\00140\002169\00166\002169\00199\002169\001497\002169\001194\002169\001255\002169\001646\002169\001142\002169\001484\002169\001232\002169\001649\002169\00121\002169\001413\002169\00173\002169\001337\002169\001428\002169\001119\002169\001392\002169\001259\002169\001399\002169\001286\002169\001117\002169\001267\002169\001377\002169\001650\002169\001670\002169\001673\002169\001251\002169\001485\002169\001241\002169\00145\002169\001153\002169\001615\002169\00148\002169\001315\002169\001287\002169\001353\002169\001314\002169\001561\002169\001667\002169\00187\002169\00191\002169\001659\002169\001633\002169\001685\002169\00177\002169\001123\002169\001584\002169\001162\002169\001398\002169\001265\002169\001460\002169\001469\002169\00139\002169\001361\002169\001625\002169\001199\002169\001638\002169\001419\002169\001434\002169\001357\002169\001494\002169\001676\002169\001139\002169\001158\002169\001441\002169\001260\002169\001331\002169\001607\002169\001335\002169\001180\002169\001410\002169\001424\002169\001486\002169\001588\002169\001458\002169\001102\002169\001147\002169\001391\002169\001557\002169\001387\002169\001311\002169\001378\002169\00163\002170\00188\002170\00189\002170\00181\002170\0010\002170\00140\002170\00120\002170\00113\002170\00145\002170\00160\002170\00129\002170\0018\002170\00122\002170\00121\002170\00139\002170\0010\002171\0011\002171\00122\002172\0012\002172\0013\002172\00114\002172\00116\002172\001253\002173\001241\002173\001236\002173\001245\002173\001213\002173\001225\002173\001220\002173\001235\002173\001250\002173\001230\002173\001216\002173\001247\002173\001252\002173\00140\002173\00117\002173\00185\002173\00112\002173\00155\002173\001156\002173\0017\002173\00119\002173\0014\002173\0015\002173\001196\002173\001174\002173\001201\002173\00191\002173\001133\002173\00148\002173\00142\002173\001208\002173\001193\002173\001119\002173\001161\002173\001121\002173\00125\002173\00178\002173\001127\002173\001189\002173\00170\002173\001138\002173\001129\002173\001177\002173\001107\002173\001115\002173\00156\002173\001160\002173\001114\002173\00154\002173\001126\002173\00198\002173\001150\002173\00161\002173\001171\002173\00179\002173\001195\002173\001175\002173\00172\002173\001151\002173\00150\002173\001145\002173\00174\002173\001118\002173\00192\002173\00163\002173\001205\002173\001155\002173\001154\002173\00176\002173\001199\002173\00164\002173\001173\002173\00120\002173\00146\002173\00132\002173\00110\002173\001124\002173\00152\002173\00130\002173\00169\002173\001185\002173\0015\002174\0014\002174\00165\002175\0015\002175\00131\002175\00121\002175\0014\002175\00144\002175\0010\002176\00136\002176\00140\002176\00134\002176\00124\002176\0014\002176\00127\002176\00115\002176\00118\002176\00133\002176\00116\002176\0013\002176\00120\002176\0012\002176\00113\002176\00122\002176\001105\002177\00187\002177\00197\002177\00190\002177\001103\002177\00188\002177\00156\002177\00118\002177\00166\002177\00144\002177\00132\002177\00116\002177\0013\002177\00168\002177\00140\002177\00153\002177\0011863\002178\0011882\002178\0016\002178\0015\002178\0011771\002178\0011792\002178\0011720\002178\0011637\002178\0011707\002178\0011713\002178\0011703\002178\0011848\002178\0011685\002178\0011681\002178\0011814\002178\0011778\002178\0011762\002178\0011660\002178\0011664\002178\0011816\002178\0011751\002178\0011680\002178\0011842\002178\0011753\002178\0011765\002178\0011700\002178\0011721\002178\0011661\002178\0011690\002178\0011821\002178\0011783\002178\0011768\002178\0011726\002178\0011874\002178\0011785\002178\0011836\002178\0011868\002178\00127\002178\001955\002178\00114\002178\00136\002178\001408\002178\0011043\002178\001393\002178\0011422\002178\001220\002178\001330\002178\001263\002178\001280\002178\001417\002178\001438\002178\0011383\002178\00152\002178\0011041\002178\00163\002178\001239\002178\001251\002178\0011361\002178\0011464\002178\001538\002178\001449\002178\001717\002178\001472\002178\001379\002178\0011121\002178\001672\002178\0011078\002178\001160\002178\001758\002178\0011177\002178\001712\002178\0011242\002178\001100\002178\001177\002178\0011058\002178\0011101\002178\001645\002178\0011572\002178\0011056\002178\001141\002178\001969\002178\001884\002178\001785\002178\001862\002178\00122\002178\00159\002178\001747\002178\001768\002178\001796\002178\001975\002178\0011021\002178\001910\002178\0011198\002178\001135\002178\00196\002178\001996\002178\001260\002178\001452\002178\0011251\002178\001154\002178\001128\002178\001936\002178\0011237\002178\0011153\002178\001544\002178\0011183\002178\001844\002178\001869\002178\001254\002178\001486\002178\0011235\002178\001763\002178\0011273\002178\0011116\002178\0011227\002178\0011137\002178\0011631\002178\0011008\002178\001264\002178\0011085\002178\001606\002178\0011493\002178\0011504\002178\0011520\002178\0011467\002178\00186\002178\001965\002178\001389\002178\001709\002178\00123\002178\001575\002178\001599\002178\001671\002178\001721\002178\00166\002178\001710\002178\001611\002178\00120\002178\001461\002178\001377\002178\001314\002178\001176\002178\0011054\002178\0011188\002178\0011099\002178\001999\002178\001898\002178\001670\002178\001572\002178\0011061\002178\0011217\002178\001649\002178\00129\002178\001516\002178\0011017\002178\0011044\002178\001152\002178\001112\002178\001510\002178\001579\002178\001482\002178\001119\002178\001210\002178\0011333\002178\0011135\002178\0011069\002178\001730\002178\001601\002178\0011492\002178\0011430\002178\0011362\002178\001162\002178\001183\002178\001429\002178\001354\002178\001972\002178\001866\002178\0011068\002178\001804\002178\001150\002178\001906\002178\0011193\002178\0011549\002178\001536\002178\0011181\002178\001592\002178\001989\002178\001887\002178\0011578\002178\0011632\002178\001775\002178\001802\002178\0011536\002178\0011214\002178\0011428\002178\0011447\002178\001497\002178\0011329\002178\0011244\002178\001326\002178\0011412\002178\001586\002178\001511\002178\001350\002178\0011010\002178\001913\002178\001108\002178\001521\002178\0011336\002178\0011256\002178\0011164\002178\0011207\002178\001446\002178\001370\002178\001860\002178\001830\002178\001858\002178\0011602\002178\00167\002178\001436\002178\0011211\002178\0011255\002178\0011377\002178\001369\002178\001735\002178\0011129\002178\0011373\002178\0011064\002178\0011220\002178\0011007\002178\0011575\002178\001400\002178\001342\002178\001357\002178\001845\002178\0011515\002178\0011525\002178\0011534\002178\0011545\002178\001809\002178\001583\002178\0011345\002178\001958\002178\0011494\002178\0011236\002178\001163\002178\001174\002178\001453\002178\001618\002178\0011356\002178\0011442\002178\0011407\002178\001129\002178\00135\002179\00127\002179\00137\002179\00132\002179\0011\002179\00117\002179\00115\002179\00114\002179\00119\002179\0018\002179\0015\002179\0010\002180\00159\002180\00162\002180\00156\002180\00167\002180\00132\002180\0015\002180\00116\002180\00126\002180\0019\002180\0016\002180\00139\002180\00136\002180\00123\002180\00153\002180\00111\002180\00140\002180\00138\002180\00152\002180\0017\002180\00135\002180\001142\002181\001113\002181\001129\002181\001101\002181\001126\002181\001136\002181\00119\002181\00157\002181\00177\002181\00123\002181\00149\002181\00147\002181\0015\002181\0010\002181\00151\002181\0019\002181\00173\002181\00176\002181\00179\002181\00164\002181\00160\002181","123"),
("2088412861518042","1","0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0","15\0021\0016\0022\0012\0023\0019\0024\0011\0025\0011\0026\00124\0027\0014\0028\00116\0029\001352\00210\00124\00211\001246\00212\00120\00213\001125\00214\0012\00215\00182\00216\0010\00217\0011\00221\00123\00223\0010\00224\0010\00225\0011\00226\0010\00227\0011\00228\0015\00229\00129\00231\00113\00231\0012\00231\00130\00232\001249\00232\00160\00232\001302\00232\001190\00232\001304\00232\001358\00232\001113\00232\00144\00232\001383\00232\001187\00232\001141\00232\001376\00232\00112\00233\0015\00233\00121\00233\00123\00233\00130\00233\001143\00234\001146\00234\0015\00234\001153\00234\001115\00234\001128\00234\00150\00234\001118\00234\00131\00234\001175\00234\001147\00234\00194\00234\00171\00234\00128\00234\001112\00234\00170\00234\001119\00234\001174\00234\00143\00234\00154\00234\00111\00234\00119\00235\00174\00235\00161\00235\00133\00235\00151\00235\00176\00235\00126\00236\00116\00236\00119\00236\0012\00236\0018\00236\00132\00236\00118\00236\00113\00236\00131\00236\001109\00237\00189\00237\00191\00237\00179\00237\00167\00237\00156\00237\00139\00237\0014\002141\0019\002143\0014\002143\0010\002143\00112\002143\0011\002144\0013\002144\00115\002145\0012\002145\0019\002145\0013\002145\0015\002145\00110\002145\00122\002145\0011\002146\0010\002146\00181\002147\0019\002147\00147\002147\00188\002147\00153\002147\00165\002147\00144\002147\00146\002147\00120\002147\00142\002147\0014\002147\00158\002147\00119\002147\00162\002147\00110\002147\00173\002147\00138\002147\00136\002147\00170\002147\00182\002147\00149\002147\00113\002147\00118\002147\00141\002147\00168\002147\00184\002147\00163\002147\00130\002147\00143\002147\00134\002147\0011\002147\00121\002147\00161\002147\0010\002147\00171\002147\00157\002147\00167\002147\00159\002147\00127\002147\00198\002148\001106\002148\00172\002148\0016\002148\00114\002148\001147\002148\00175\002148\001155\002148\001144\002148\001118\002148\00165\002148\001126\002148\00142\002148\00113\002148\00169\002148\00181\002150\00191\002150\00182\002150\00149\002150\00146\002150\00124\002150\001115\002150\00196\002150\00111\002150\001161\002150\001188\002150\001215\002150\001171\002150\001165\002150\001216\002150\00138\002150\00119\002150\00144\002150\00178\002150\001111\002151\001123\002151\00198\002151\001199\002151\00127\002151\00112\002151\001403\002151\001244\002151\001274\002151\00135\002151\001583\002152\001636\002152\001232\002152\00164\002152\001301\002152\001260\002152\001292\002152\00128\002152\001419\002152\001802\002152\001241\002153\001421\002153\001529\002153\001243\002153\001373\002153\001158\002153\001219\002153\001287\002153\001450\002153\001104\002153\001277\002153\00141\002153\001329\002153\0013\002154\001676\002154\001723\002154\001777\002154\001720\002154\0011034\002154\001922\002154\001411\002154\001576\002154\00137\002154\001996\002154\0011\002154\001876\002154\00132\002154\001222\002154\001277\002154\00185\002154\001172\002154\001162\002154\001875\002154\001353\002154\001489\002154\001694\002154\0011009\002154\001393\002154\001429\002154\0010\002155\00127\002155\00126\002155\0014\002155\00128\002155\00124\002155\00144\002155\00155\002155\00136\002155\0013\002155\00139\002155\0017\002155\00145\002155\00132\002155\00110\002155\00138\002155\00117\002155\0018\002155\00122\002155\00123\002155\00114\002155\00120\002155\00156\002155\0015\002155\00140\002155\00148\002155\00150\002155\00125\002155\00141\002155\00143\002155\00118\002156\00121\002156\0015\002156\00124\002156\00130\002156\00125\002156\00132\002156\0016\002156\00147\002156\0018\002156\00137\002157\00118\002157\00122\002157\00113\002157\00123\002157\00132\002157\00120\002157\00121\002157\0013\002157\00135\002157\0019\002157\00138\002157\0015\002157\0010\002157\00126\002157\00130\002157\00117\002157\0016\002157\00127\002157\00131\002157\00136\002157\00139\002158\00136\002158\00118\002158\00189\002158\001109\002158\00169\002158\00146\002158\00126\002158\00120\002158\00183\002158\0011\002158\001103\002158\00125\002158\00133\002158\00175\002158\00149\002158\00162\002158\001100\002158\001126\002158\00152\002158\00186\002158\001107\002158\00198\002158\00199\002158\001118\002158\001117\002158\0015\002158\00166\002158\001113\002158\0010\002158\00129\002158\001124\002158\00137\002158\00116\002158\00132\002158\00194\002158\00113\002158\00160\002158\00197\002158\001120\002158\00151\002158\00193\002158\0014\002158\00110\002158\00144\002158\00158\002158\0013\002158\00182\002158\0012\002158\001127\002158\00163\002158\00114\002158\00157\002158\00177\002158\001104\002158\00128\002158\001119\002158\001106\002158\00115\002158\0017\002158\0016\002158\0018\002158\00170\002158\0019\002158\001112\002158\001115\002158\00185\002158\00155\002158\00138\002158\001116\002158\00124\002159\00131\002159\00144\002159\00135\002159\00120\002159\00134\002159\0012\002159\00147\002159\0016\002159\00110\002159\00142\002159\00125\002159\00150\002159\00141\002159\00152\002160\00131\002160\00183\002160\00157\002160\00110\002160\00184\002160\00186\002160\00177\002160\00154\002160\00166\002160\00146\002160\00161\002160\00185\002161\00196\002161\00162\002161\001128\002161\00125\002161\00186\002161\00138\002161\00194\002161\00167\002161\001125\002161\00136\002161\00148\002161\0017\002161\001124\002161\00189\002161\00172\002161\00170\002161\001134\002161\00144\002161\001122\002161\00110\002161\00159\002161\00156\002161\00143\002161\00142\002161\001108\002161\00113\002161\00139\002161\0014\002161\001132\002161\00138\002162\00161\002162\00165\002162\00117\002162\00145\002162\00131\002162\00157\002162\00149\002162\00153\002162\00120\002162\00179\002162\00125\002162\00172\002162\00162\002162\00116\002162\00150\002162\00126\002162\00137\002162\00181\002162\0014\002162\00111\002162\001158\002163\00135\002163\00195\002163\00111\002163\001190\002163\001172\002163\0017\002163\00199\002163\001182\002163\00110\002163\001161\002163\001129\002163\001101\002163\001167\002163\001105\002163\00138\002163\00143\002163\00132\002163\001148\002163\001183\002163\00185\002163\001143\002163\001169\002163\001164\002163\0016\002163\0015\002163\00114\002163\001111\002163\001170\002163\001185\002163\001153\002163\00144\002163\00115\002163\00160\002163\001162\002163\001140\002163\00175\002163\00197\002163\001118\002163\001165\002163\00182\002163\00164\002163\00172\002163\00173\002163\001166\002163\00192\002163\00126\002163\001106\002163\00196\002163\001171\002163\001180\002163\001156\002163\001123\002163\001128\002163\0013\002163\001144\002163\00149\002163\001117\002163\00166\002163\00130\002163\001142\002163\00180\002163\00189\002163\00141\002163\001100\002163\00190\002163\00121\002163\00155\002163\0010\002163\00161\002163\00141\002164\001169\002164\0018\002164\001221\002164\00143\002164\001175\002164\001111\002165\001113\002165\00156\002165\0016\002165\00133\002165\00127\002165\00138\002165\00175\002165\001117\002165\001166\002166\001185\002166\001157\002166\001138\002166\00181\002166\00199\002166\0017\002166\001202\002166\00160\002166\001122\002166\00195\002166\001139\002166\00132\002166\001181\002166\00185\002166\001134\002166\001182\002166\00194\002166\001681\002167\001625\002167\001646\002167\001579\002167\001562\002167\001567\002167\001622\002167\001599\002167\001653\002167\001660\002167\001616\002167\001594\002167\001597\002167\001610\002167\001614\002167\001591\002167\001670\002167\001672\002167\0015\002167\00121\002167\001389\002167\00181\002167\00129\002167\001337\002167\001380\002167\001172\002167\001528\002167\001410\002167\001534\002167\001175\002167\001232\002167\001116\002167\001408\002167\001414\002167\001201\002167\001292\002167\001425\002167\001204\002167\001270\002167\00189\002167\001388\002167\001221\002167\001365\002167\001454\002167\00152\002167\001240\002167\001107\002167\001181\002167\001295\002167\001515\002167\001216\002167\001355\002167\001524\002167\001224\002167\001282\002167\00147\002167\001470\002167\001167\002167\001100\002167\001517\002167\001263\002167\001357\002167\001239\002167\001307\002167\001297\002167\001535\002167\00164\002167\001322\002167\001412\002167\001313\002167\001538\002167\00179\002167\001259\002167\001364\002167\001336\002167\001363\002167\001343\002167\001544\002167\001219\002167\001463\002167\00176\002167\001310\002167\001462\002167\001479\002167\001128\002167\0014\002168\001272\002168\001269\002168\001279\002168\001275\002168\001276\002168\001280\002168\0017\002168\001246\002168\00170\002168\00127\002168\001115\002168\001251\002168\00174\002168\001139\002168\001166\002168\001195\002168\001248\002168\00125\002168\001147\002168\00192\002168\00159\002168\001157\002168\00195\002168\00115\002168\001253\002168\001207\002168\001192\002168\00172\002168\001224\002168\00136\002168\00160\002168\001135\002168\001163\002168\00137\002168\001127\002168\00178\002168\001262\002168\001186\002168\001118\002168\001226\002168\001109\002168\001143\002168\001172\002168\001184\002168\001208\002168\00163\002168\001100\002168\001254\002168\001268\002168\001817\002169\0011\002169\00113\002169\00119\002169\001732\002169\001798\002169\001766\002169\001715\002169\001759\002169\001762\002169\001796\002169\001794\002169\001731\002169\001745\002169\001708\002169\001780\002169\001746\002169\001791\002169\001800\002169\00120\002169\00128\002169\00143\002169\001435\002169\001104\002169\001149\002169\001597\002169\001646\002169\001142\002169\001484\002169\001184\002169\001649\002169\001681\002169\001301\002169\00173\002169\001337\002169\001428\002169\001119\002169\001392\002169\001209\002169\001399\002169\001400\002169\001683\002169\001167\002169\001377\002169\001666\002169\001678\002169\001682\002169\001303\002169\001430\002169\001192\002169\00145\002169\001153\002169\001583\002169\00148\002169\001315\002169\001287\002169\001299\002169\001314\002169\001561\002169\001599\002169\00161\002169\00191\002169\001659\002169\001633\002169\001685\002169\00149\002169\001123\002169\001582\002169\001162\002169\001398\002169\001265\002169\001403\002169\001469\002169\001696\002169\001361\002169\001558\002169\001239\002169\001672\002169\001419\002169\001434\002169\001357\002169\001494\002169\001693\002169\001139\002169\001158\002169\001441\002169\001260\002169\001331\002169\001570\002169\001335\002169\001180\002169\001410\002169\001424\002169\001373\002169\001588\002169\001401\002169\001102\002169\001147\002169\001391\002169\001557\002169\001387\002169\001168\002169\001378\002169\00163\002170\00188\002170\00189\002170\00181\002170\0010\002170\00140\002170\00120\002170\00113\002170\00141\002170\00160\002170\00129\002170\0014\002170\00122\002170\00154\002170\00162\002170\0010\002171\0011\002171\00122\002172\0012\002172\0015\002172\00114\002172\00116\002172\001253\002173\001241\002173\001236\002173\001245\002173\001213\002173\001225\002173\001215\002173\001235\002173\001250\002173\001230\002173\001216\002173\001247\002173\001252\002173\00140\002173\00117\002173\00151\002173\00112\002173\00155\002173\001156\002173\0013\002173\00119\002173\0014\002173\0015\002173\001196\002173\001174\002173\001201\002173\00191\002173\001133\002173\00148\002173\00157\002173\001208\002173\001193\002173\001119\002173\001161\002173\001104\002173\00125\002173\00178\002173\001127\002173\001189\002173\00170\002173\001138\002173\001129\002173\001177\002173\001107\002173\001115\002173\00156\002173\001160\002173\001114\002173\00154\002173\001126\002173\00198\002173\001150\002173\00161\002173\001171\002173\00179\002173\001195\002173\001175\002173\00172\002173\001151\002173\00150\002173\001145\002173\00174\002173\001118\002173\00192\002173\00163\002173\001205\002173\001140\002173\001154\002173\00176\002173\001199\002173\00164\002173\001173\002173\00120\002173\00146\002173\00132\002173\00110\002173\001124\002173\00152\002173\00130\002173\00169\002173\001185\002173\0015\002174\0014\002174\00170\002175\0010\002175\00128\002175\00112\002175\00154\002175\00144\002175\0010\002176\00136\002176\00140\002176\00134\002176\00124\002176\0014\002176\00127\002176\00115\002176\00118\002176\00133\002176\00116\002176\0013\002176\00120\002176\0012\002176\00113\002176\00122\002176\00186\002177\00187\002177\00197\002177\00190\002177\001103\002177\00185\002177\00156\002177\00123\002177\0014\002177\00144\002177\00132\002177\00116\002177\0013\002177\00168\002177\00140\002177\00153\002177\0011863\002178\0011882\002178\0014\002178\0015\002178\0011636\002178\0011643\002178\0011763\002178\0011637\002178\0011657\002178\0011713\002178\0011703\002178\0011848\002178\0011685\002178\0011681\002178\0011735\002178\0011841\002178\0011762\002178\0011660\002178\0011664\002178\0011654\002178\0011751\002178\0011680\002178\0011842\002178\0011753\002178\0011765\002178\0011815\002178\0011721\002178\0011661\002178\0011690\002178\0011821\002178\0011783\002178\0011768\002178\0011726\002178\0011874\002178\0011785\002178\0011836\002178\0011868\002178\00127\002178\001955\002178\00114\002178\00136\002178\001256\002178\0011043\002178\001393\002178\001633\002178\001220\002178\001330\002178\001263\002178\001280\002178\001417\002178\001549\002178\0011466\002178\001451\002178\0011041\002178\00163\002178\001239\002178\001329\002178\001415\002178\0011464\002178\001538\002178\001449\002178\001717\002178\001472\002178\001379\002178\0011231\002178\001672\002178\0011078\002178\001231\002178\001758\002178\0011385\002178\001712\002178\0011436\002178\001100\002178\001177\002178\0011058\002178\0011101\002178\001645\002178\0011572\002178\0011056\002178\001141\002178\001969\002178\001884\002178\001785\002178\0011111\002178\00116\002178\00159\002178\001747\002178\001768\002178\001926\002178\001975\002178\001894\002178\001910\002178\0011198\002178\001135\002178\00196\002178\001996\002178\001260\002178\001452\002178\0011138\002178\001154\002178\001128\002178\001936\002178\0011237\002178\0011153\002178\001544\002178\0011183\002178\001844\002178\001869\002178\001531\002178\001486\002178\0011235\002178\001432\002178\0011273\002178\0011204\002178\0011227\002178\0011137\002178\0011631\002178\0011008\002178\001935\002178\0011085\002178\001606\002178\0011493\002178\0011504\002178\0011520\002178\0011467\002178\001130\002178\001158\002178\001389\002178\001709\002178\00155\002178\00161\002178\001599\002178\001671\002178\001721\002178\00166\002178\001710\002178\001611\002178\00120\002178\001461\002178\001377\002178\001403\002178\001899\002178\0011054\002178\0011295\002178\0011212\002178\001999\002178\001898\002178\001798\002178\001572\002178\0011061\002178\0011217\002178\001649\002178\00129\002178\001259\002178\0011017\002178\0011272\002178\001221\002178\001241\002178\001510\002178\001579\002178\001482\002178\001119\002178\001210\002178\0011333\002178\0011135\002178\0011069\002178\001730\002178\001601\002178\0011492\002178\0011430\002178\0011362\002178\001162\002178\001183\002178\001429\002178\001354\002178\001972\002178\001991\002178\0011068\002178\001804\002178\001150\002178\001906\002178\0011193\002178\0011549\002178\001658\002178\0011181\002178\001592\002178\001989\002178\001887\002178\0011610\002178\0011632\002178\001775\002178\001802\002178\0011396\002178\0011214\002178\0011428\002178\0011447\002178\001497\002178\0011329\002178\0011437\002178\001326\002178\00132\002178\001586\002178\001511\002178\001350\002178\0011010\002178\0011157\002178\00139\002178\001521\002178\0011336\002178\0011445\002178\0011277\002178\0011207\002178\001446\002178\001470\002178\001860\002178\0011087\002178\001858\002178\0011602\002178\00167\002178\001436\002178\0011211\002178\0011255\002178\0011460\002178\001369\002178\001735\002178\0011241\002178\0011373\002178\0011064\002178\0011220\002178\0011007\002178\0011575\002178\001400\002178\001342\002178\001357\002178\001845\002178\0011515\002178\0011390\002178\0011534\002178\0011545\002178\001809\002178\001583\002178\0011345\002178\001958\002178\0011494\002178\0011236\002178\001163\002178\001174\002178\001453\002178\001618\002178\0011426\002178\0011442\002178\0011407\002178\001129\002178\00135\002179\00127\002179\00137\002179\00132\002179\0010\002179\00117\002179\00115\002179\00114\002179\00119\002179\0018\002179\0015\002179\0010\002180\00159\002180\00162\002180\00156\002180\00167\002180\00132\002180\0015\002180\00116\002180\00126\002180\0019\002180\0016\002180\00139\002180\00136\002180\00123\002180\00153\002180\00111\002180\00140\002180\00138\002180\00152\002180\0017\002180\00135\002180\001142\002181\001113\002181\001111\002181\001112\002181\001126\002181\001114\002181\00119\002181\00157\002181\00177\002181\00123\002181\00149\002181\0018\002181\0015\002181\00184\002181\00112\002181\0019\002181\00173\002181\00176\002181\00179\002181\00164\002181\00160\002181","113"),
("2088302393629373","1","0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0","58\0021\0010\0022\0015\0023\0018\0024\0019\0025\0011\0026\00130\0027\00120\0028\0011\0029\00162\00210\0016\00211\00128\00212\00115\00213\001224\00214\0013\00215\001313\00216\0012\00217\0010\00218\0011\00219\0011\00220\0010\00221\00122\00222\00110\00223\0010\00224\0010\00225\0010\00226\0011\00227\0011\00228\00136\00229\0015\00231\00126\00231\00131\00231\00153\00232\00112\00233\0015\00233\0013\00233\001139\00234\0018\00234\001106\00234\00149\00234\00142\00234\00186\00234\00162\00234\001118\00234\001152\00234\001186\00234\001147\00234\00194\00234\00171\00234\00128\00234\001112\00234\00170\00234\00159\00234\001174\00234\001100\00234\001171\00234\00154\00234\00144\00234\00126\00235\00129\00235\00125\00235\0018\00235\00114\00235\00144\00235\00154\00235\00149\00235\00176\00235\00112\00236\0011\00236\0016\00236\0018\00236\00132\00236\00118\00236\00113\00236\00131\00236\001109\00237\00189\00237\00191\00237\00179\00237\00167\00237\00156\00237\00139\00237\0015\002141\00112\002143\0015\002143\0014\002143\0017\002143\0011\002143\0013\002144\0011\002144\0017\002145\00116\002145\0012\002145\00122\002145\0011\002145\0011\002146\0010\002146\00181\002147\0019\002147\00147\002147\00188\002147\00153\002147\00165\002147\00144\002147\00146\002147\00120\002147\00142\002147\0014\002147\00158\002147\00119\002147\00162\002147\00110\002147\00173\002147\00112\002147\00183\002147\00177\002147\00187\002147\00156\002147\00170\002147\00182\002147\00149\002147\00113\002147\00174\002147\00141\002147\00168\002147\00184\002147\00163\002147\00123\002147\00143\002147\00134\002147\0011\002147\00121\002147\00161\002147\0010\002147\00171\002147\00157\002147\00167\002147\00159\002147\00114\002147\00186\002147\001169\002148\00121\002148\001128\002148\0016\002148\00114\002148\001147\002148\00175\002148\00119\002148\00162\002148\00194\002148\00131\002148\001140\002148\00190\002148\00113\002148\00169\002148\00158\002150\001143\002150\00129\002150\001115\002150\001160\002150\00144\002150\001192\002150\001204\002151\001230\002151\001245\002151\001401\002151\001339\002151\001426\002151\001419\002151\001267\002151\001352\002151\00116\002151\001391\002151\001381\002151\001351\002151\001138\002151\001208\002151\00148\002151\001274\002151\001460\002151\001583\002152\001636\002152\001490\002153\001421\002153\001482\002153\001284\002153\001373\002153\00174\002153\00133\002153\001459\002153\001231\002153\001185\002153\001266\002153\001101\002153\001113\002153\00198\002153\001415\002153\001284\002154\00147\002154\00164\002154\001862\002154\001717\002154\0011034\002154\001845\002154\001275\002154\001366\002154\00114\002154\001145\002154\001529\002154\001203\002154\001695\002154\0011031\002154\001614\002154\001984\002154\001221\002154\001681\002154\001454\002154\001599\002154\001956\002154\001330\002154\001965\002154\001670\002154\0011035\002154\0010\002155\00127\002155\00126\002155\0014\002155\00128\002155\00124\002155\00144\002155\00155\002155\00136\002155\0013\002155\00139\002155\0017\002155\00145\002155\00132\002155\00110\002155\00138\002155\00117\002155\0018\002155\00122\002155\00115\002155\00114\002155\00120\002155\00156\002155\0015\002155\00130\002155\00148\002155\00150\002155\00125\002155\00141\002155\00143\002155\00133\002156\00121\002156\0015\002156\00124\002156\0014\002156\00139\002156\00132\002156\0016\002156\00129\002156\00135\002156\00141\002156\00111\002156\00134\002156\00120\002156\00147\002156\0018\002156\00137\002157\00118\002157\00122\002157\00113\002157\00123\002157\00132\002157\00120\002157\00121\002157\0013\002157\00135\002157\0019\002157\00138\002157\0015\002157\0010\002157\00126\002157\00130\002157\00117\002157\0016\002157\00127\002157\00131\002157\00136\002157\00139\002158\00136\002158\00118\002158\00189\002158\001109\002158\00169\002158\00146\002158\00126\002158\00120\002158\00183\002158\0011\002158\001103\002158\00125\002158\00133\002158\00175\002158\00149\002158\00162\002158\001100\002158\001126\002158\00152\002158\00186\002158\001107\002158\00198\002158\00199\002158\001118\002158\001117\002158\0015\002158\00174\002158\001113\002158\0010\002158\00129\002158\001124\002158\00137\002158\00116\002158\00132\002158\00194\002158\00113\002158\00160\002158\00197\002158\001120\002158\00151\002158\00193\002158\0014\002158\00110\002158\00144\002158\00158\002158\0013\002158\00182\002158\0012\002158\001127\002158\00163\002158\00114\002158\00157\002158\00177\002158\001104\002158\00128\002158\001119\002158\001106\002158\00115\002158\0017\002158\0016\002158\0018\002158\00170\002158\0019\002158\001112\002158\001115\002158\00185\002158\00155\002158\00138\002158\001116\002158\00124\002159\00128\002159\00144\002159\00135\002159\00120\002159\00134\002159\0012\002159\00123\002159\0016\002159\00110\002159\00142\002159\00125\002159\00150\002159\00141\002159\00152\002160\00130\002160\00183\002160\00157\002160\00133\002160\00184\002160\00186\002160\0011\002160\00154\002160\00166\002160\00153\002160\00161\002160\00185\002161\00196\002161\00162\002161\001128\002161\00125\002161\00186\002161\00138\002161\00194\002161\00167\002161\001125\002161\00136\002161\00148\002161\0017\002161\001124\002161\00189\002161\00172\002161\00170\002161\001134\002161\00144\002161\001122\002161\00110\002161\00159\002161\00156\002161\00143\002161\00142\002161\001108\002161\00113\002161\00139\002161\0014\002161\001132\002161\00138\002162\00161\002162\00165\002162\00117\002162\00145\002162\00131\002162\00157\002162\00149\002162\00153\002162\00120\002162\00179\002162\00125\002162\00172\002162\00162\002162\00116\002162\00150\002162\00126\002162\00137\002162\00181\002162\0014\002162\00111\002162\001158\002163\00135\002163\00195\002163\00111\002163\001190\002163\001172\002163\0017\002163\00199\002163\001182\002163\00110\002163\001161\002163\001129\002163\001101\002163\001167\002163\001105\002163\00138\002163\00143\002163\00132\002163\001148\002163\001183\002163\00185\002163\001143\002163\001169\002163\001164\002163\0016\002163\0015\002163\00114\002163\001127\002163\001170\002163\001185\002163\001153\002163\00144\002163\00115\002163\00160\002163\001162\002163\001140\002163\00175\002163\00197\002163\001118\002163\001165\002163\00182\002163\00164\002163\00172\002163\00173\002163\001166\002163\00192\002163\00126\002163\001106\002163\00196\002163\001171\002163\001180\002163\001156\002163\001123\002163\001128\002163\0013\002163\001144\002163\00149\002163\001117\002163\00166\002163\00130\002163\001142\002163\00180\002163\00189\002163\00141\002163\001100\002163\00190\002163\00121\002163\00155\002163\0010\002163\00161\002163\00190\002164\001125\002164\00141\002164\00130\002164\001235\002164\0018\002164\001111\002165\0013\002165\00156\002165\00145\002165\00133\002165\0014\002165\001122\002165\00154\002165\00183\002165\001196\002166\001163\002166\001185\002166\001109\002166\001177\002166\001180\002166\00156\002166\0019\002166\001175\002166\001124\002166\00128\002166\001188\002166\00149\002166\00195\002166\001123\002166\00132\002166\00129\002166\00185\002166\001198\002166\00196\002166\00194\002166\0010\002167\001555\002167\001553\002167\001589\002167\001562\002167\001567\002167\001622\002167\001640\002167\001590\002167\001584\002167\001656\002167\001594\002167\001597\002167\001610\002167\001654\002167\001591\002167\001670\002167\001672\002167\0015\002167\00121\002167\001346\002167\00181\002167\00129\002167\001381\002167\001380\002167\001289\002167\00170\002167\001512\002167\00139\002167\001415\002167\001232\002167\001178\002167\001408\002167\001447\002167\00162\002167\001359\002167\001204\002167\001314\002167\001118\002167\001388\002167\001221\002167\001440\002167\0016\002167\001125\002167\001466\002167\001107\002167\001299\002167\001295\002167\001515\002167\001216\002167\001355\002167\001401\002167\001224\002167\001282\002167\00186\002167\001514\002167\001166\002167\001517\002167\001500\002167\001396\002167\001144\002167\001307\002167\001156\002167\001542\002167\00164\002167\001322\002167\001208\002167\001313\002167\00179\002167\001259\002167\001364\002167\001254\002167\001363\002167\001422\002167\001544\002167\001260\002167\001330\002167\001168\002167\001310\002167\001462\002167\001549\002167\001316\002167\0019\002168\001272\002168\001269\002168\001279\002168\001277\002168\001274\002168\001280\002168\0017\002168\001152\002168\00170\002168\00127\002168\00187\002168\001257\002168\00174\002168\001139\002168\001166\002168\001170\002168\001248\002168\001147\002168\00192\002168\001104\002168\001183\002168\00195\002168\00119\002168\001263\002168\001136\002168\001192\002168\001239\002168\001236\002168\00162\002168\00160\002168\001135\002168\001163\002168\00147\002168\00199\002168\00178\002168\001262\002168\001186\002168\001118\002168\001226\002168\001109\002168\001112\002168\001172\002168\001184\002168\001222\002168\00183\002168\001128\002168\001254\002168\001268\002168\001817\002169\0011\002169\00113\002169\001698\002169\001732\002169\001730\002169\001766\002169\001724\002169\001759\002169\001773\002169\001796\002169\001794\002169\001731\002169\001757\002169\001708\002169\001780\002169\001746\002169\001719\002169\001800\002169\00120\002169\001296\002169\001364\002169\001435\002169\001104\002169\001551\002169\001597\002169\001646\002169\001142\002169\001532\002169\001396\002169\001649\002169\00121\002169\001355\002169\00173\002169\001395\002169\001428\002169\001119\002169\001392\002169\001259\002169\001399\002169\001236\002169\001683\002169\001568\002169\001377\002169\001675\002169\001687\002169\001695\002169\001416\002169\00197\002169\001192\002169\00145\002169\00156\002169\001615\002169\00148\002169\001315\002169\001287\002169\001353\002169\001314\002169\001561\002169\001627\002169\001254\002169\00191\002169\001659\002169\001633\002169\001685\002169\001108\002169\001123\002169\001584\002169\001162\002169\001398\002169\001265\002169\001460\002169\001469\002169\001121\002169\001361\002169\001515\002169\001289\002169\001689\002169\001419\002169\001434\002169\001470\002169\001541\002169\001693\002169\001139\002169\001158\002169\001441\002169\001260\002169\001331\002169\001607\002169\001335\002169\001280\002169\001410\002169\001478\002169\001486\002169\001588\002169\001401\002169\001697\002169\001147\002169\001391\002169\001462\002169\001387\002169\001311\002169\001437\002169\00163\002170\00170\002170\00189\002170\00181\002170\0010\002170\00140\002170\00131\002170\00113\002170\00152\002170\00160\002170\00129\002170\0018\002170\00122\002170\00126\002170\00162\002170\0010\002171\0011\002171\00122\002172\0012\002172\0016\002172\00114\002172\00116\002172\001253\002173\001241\002173\001210\002173\001245\002173\001213\002173\001225\002173\001215\002173\001235\002173\001250\002173\001230\002173\001216\002173\001247\002173\001252\002173\00140\002173\00117\002173\00185\002173\00112\002173\00155\002173\001156\002173\0011\002173\00119\002173\0014\002173\0015\002173\001196\002173\001174\002173\001201\002173\00191\002173\001133\002173\00148\002173\00142\002173\001208\002173\001193\002173\001119\002173\001161\002173\00168\002173\00125\002173\00178\002173\001127\002173\001189\002173\00170\002173\001138\002173\001129\002173\001177\002173\001107\002173\001115\002173\00156\002173\001160\002173\001114\002173\00154\002173\001126\002173\00198\002173\001150\002173\00161\002173\001171\002173\00179\002173\001195\002173\001175\002173\00172\002173\001151\002173\00150\002173\001145\002173\00174\002173\001118\002173\00192\002173\00163\002173\001205\002173\001181\002173\001154\002173\001128\002173\001199\002173\00164\002173\001173\002173\00120\002173\00146\002173\00132\002173\00110\002173\001124\002173\00152\002173\00130\002173\00169\002173\001185\002173\0015\002174\0014\002174\00165\002175\0015\002175\00128\002175\00121\002175\0014\002175\00144\002175\0010\002176\00136\002176\00140\002176\00134\002176\00124\002176\0014\002176\0019\002176\00115\002176\00118\002176\00133\002176\00116\002176\0013\002176\00120\002176\0012\002176\00113\002176\00122\002176\00198\002177\00187\002177\00197\002177\00190\002177\001103\002177\00192\002177\00156\002177\00118\002177\00172\002177\00144\002177\00132\002177\00116\002177\0013\002177\00168\002177\00140\002177\00153\002177\0011863\002178\0011882\002178\0014\002178\0015\002178\0011636\002178\0011792\002178\0011720\002178\0011637\002178\0011707\002178\0011713\002178\0011703\002178\0011848\002178\0011685\002178\0011739\002178\0011814\002178\0011741\002178\0011762\002178\0011660\002178\0011664\002178\0011816\002178\0011751\002178\0011680\002178\0011842\002178\0011753\002178\0011765\002178\0011815\002178\0011721\002178\0011661\002178\0011690\002178\0011821\002178\0011783\002178\0011768\002178\0011726\002178\0011874\002178\0011749\002178\0011782\002178\0011868\002178\00127\002178\001955\002178\00118\002178\00136\002178\001337\002178\0011043\002178\001393\002178\0011422\002178\001220\002178\001330\002178\001263\002178\001280\002178\0011148\002178\001438\002178\0011383\002178\00152\002178\0011041\002178\00163\002178\001239\002178\001329\002178\001415\002178\0011297\002178\001538\002178\00157\002178\001717\002178\001472\002178\001379\002178\0011001\002178\001672\002178\0011078\002178\001308\002178\001758\002178\001940\002178\001712\002178\0011509\002178\001100\002178\001177\002178\0011058\002178\0011101\002178\001645\002178\0011572\002178\0011056\002178\001141\002178\001969\002178\001884\002178\001785\002178\0011223\002178\00116\002178\00159\002178\001747\002178\001768\002178\001796\002178\001975\002178\001894\002178\001910\002178\0011198\002178\001135\002178\00196\002178\001996\002178\001260\002178\001452\002178\0011441\002178\001154\002178\001128\002178\001936\002178\0011237\002178\0011368\002178\001544\002178\0011183\002178\001844\002178\001869\002178\001654\002178\001486\002178\0011235\002178\001763\002178\0011273\002178\0011204\002178\0011227\002178\0011137\002178\0011631\002178\0011008\002178\001264\002178\0011085\002178\001606\002178\0011493\002178\0011504\002178\0011520\002178\0011467\002178\00186\002178\001228\002178\001389\002178\001709\002178\00123\002178\001575\002178\001599\002178\001671\002178\001597\002178\00166\002178\001710\002178\001611\002178\00120\002178\001461\002178\001377\002178\001314\002178\0011024\002178\0011054\002178\0011188\002178\0011212\002178\001999\002178\001898\002178\001670\002178\001572\002178\0011061\002178\0011217\002178\001649\002178\00129\002178\001431\002178\0011017\002178\0011044\002178\001221\002178\001112\002178\001510\002178\001579\002178\001482\002178\001790\002178\001210\002178\0011333\002178\0011135\002178\0011069\002178\001730\002178\001601\002178\0011492\002178\0011430\002178\0011362\002178\001162\002178\001183\002178\001429\002178\001354\002178\001972\002178\001866\002178\0011068\002178\001804\002178\001150\002178\001906\002178\0011300\002178\0011549\002178\001536\002178\0011181\002178\001592\002178\001989\002178\001887\002178\0011067\002178\0011632\002178\001775\002178\001802\002178\001824\002178\0011214\002178\0011428\002178\0011447\002178\001497\002178\0011329\002178\0011510\002178\001326\002178\00132\002178\001586\002178\001511\002178\001350\002178\0011010\002178\0011372\002178\001108\002178\001521\002178\0011336\002178\0011256\002178\0011164\002178\0011207\002178\001446\002178\001285\002178\001860\002178\0011087\002178\001858\002178\0011602\002178\00167\002178\001436\002178\0011211\002178\0011255\002178\0011276\002178\001369\002178\001735\002178\0011129\002178\0011373\002178\0011064\002178\0011220\002178\0011007\002178\0011575\002178\001400\002178\001342\002178\001357\002178\001845\002178\0011515\002178\001945\002178\0011534\002178\0011545\002178\001809\002178\001583\002178\001423\002178\001958\002178\0011494\002178\0011236\002178\001163\002178\001174\002178\001453\002178\001743\002178\0011426\002178\0011442\002178\0011407\002178\001129\002178\00135\002179\00129\002179\00137\002179\00132\002179\0010\002179\00117\002179\00115\002179\00114\002179\00119\002179\00111\002179\0015\002179\0010\002180\00159\002180\00162\002180\00156\002180\00167\002180\00132\002180\0015\002180\00116\002180\00126\002180\0019\002180\0016\002180\00139\002180\00136\002180\00123\002180\00153\002180\00111\002180\00140\002180\00138\002180\00152\002180\0017\002180\00135\002180\001143\002181\001113\002181\001111\002181\001112\002181\001126\002181\001114\002181\00119\002181\00157\002181\00190\002181\00123\002181\00149\002181\0018\002181\0015\002181\00184\002181\00112\002181\0019\002181\00173\002181\00176\002181\00179\002181\00164\002181\00160\002181\0019\002187","49"),
("2088412448611803","1","0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0","34\0021\0016\0022\0016\0023\0016\0024\0019\0025\0010\0026\00120\0027\00123\0028\00115\0029\001332\00210\0019\00211\001321\00212\0015\00213\001122\00214\0019\00215\001347\00216\0011\00217\0013\00218\0011\00219\0011\00220\0010\00221\0016\00222\0017\00223\0010\00224\0010\00225\0011\00226\0010\00227\0011\00228\00121\00229\0015\00231\00126\00231\00124\00231\001179\00232\00112\00233\0012\00233\0013\00233\001143\00234\001146\00234\0015\00234\001153\00234\001115\00234\001167\00234\001165\00234\00176\00234\00194\00234\001179\00234\00128\00234\001112\00234\00170\00234\00124\00234\001174\00234\00143\00234\00154\00234\00111\00234\00119\00235\00174\00235\00176\00235\00116\00236\00125\00236\00118\00236\00113\00236\00131\00236\001109\00237\00139\00237\0013\002141\0015\002143\0014\002143\0011\002144\00116\002145\00110\002145\0010\002146\00148\002147\00189\002147\00147\002147\00188\002147\00153\002147\00165\002147\00144\002147\00146\002147\00120\002147\00142\002147\0014\002147\00158\002147\00119\002147\00162\002147\00110\002147\00173\002147\00138\002147\00183\002147\00126\002147\00187\002147\00156\002147\00176\002147\00182\002147\00149\002147\00113\002147\00118\002147\00141\002147\00168\002147\00184\002147\00163\002147\00123\002147\00143\002147\00134\002147\0011\002147\00121\002147\00161\002147\0010\002147\00171\002147\00157\002147\00167\002147\00159\002147\00114\002147\00127\002147\001143\002148\001122\002148\00172\002148\0016\002148\00114\002148\001147\002148\00125\002148\00119\002148\00162\002148\00127\002148\00165\002148\001126\002148\00177\002148\00113\002148\00181\002148\00124\002150\001115\002150\00166\002150\00144\002150\001192\002150\001151\002151\001111\002151\001339\002151\001419\002151\00124\002151\001322\002151\00150\002151\001313\002151\001469\002151\001428\002151\001118\002151\001437\002151\001583\002152\001636\002152\001490\002153\001421\002153\001529\002153\001243\002153\001373\002153\001158\002153\001200\002153\001450\002153\001104\002153\001431\002153\001197\002153\001100\002154\001676\002154\001675\002154\001777\002154\001713\002154\001867\002154\001938\002154\001174\002154\001661\002154\001883\002154\0011039\002154\001191\002154\001543\002154\001440\002154\00157\002154\001968\002154\001812\002154\0010\002155\00127\002155\00126\002155\0014\002155\00128\002155\00124\002155\00144\002155\00155\002155\00136\002155\0013\002155\00139\002155\0017\002155\00145\002155\00132\002155\00110\002155\00138\002155\00117\002155\0018\002155\00122\002155\00123\002155\00114\002155\00120\002155\00156\002155\0015\002155\00140\002155\00148\002155\00150\002155\00125\002155\00141\002155\00143\002155\00118\002156\00121\002156\0015\002156\00124\002156\00130\002156\00125\002156\00132\002156\0016\002156\00131\002156\00147\002156\0019\002156\0018\002156\00137\002157\00118\002157\00122\002157\00113\002157\00123\002157\00132\002157\00120\002157\00121\002157\0013\002157\00135\002157\0019\002157\00138\002157\0015\002157\0010\002157\00126\002157\00130\002157\00117\002157\0016\002157\00127\002157\00131\002157\00136\002157\00139\002158\00136\002158\00118\002158\00189\002158\001109\002158\00169\002158\00146\002158\00126\002158\00120\002158\00183\002158\0011\002158\001103\002158\00125\002158\00133\002158\00175\002158\00149\002158\00162\002158\001100\002158\001126\002158\00152\002158\00186\002158\001107\002158\00198\002158\00199\002158\001118\002158\001117\002158\0015\002158\00166\002158\001113\002158\0010\002158\00129\002158\001124\002158\00137\002158\00116\002158\00132\002158\00194\002158\00113\002158\00160\002158\00197\002158\001120\002158\00151\002158\00193\002158\0014\002158\00110\002158\00144\002158\00158\002158\0013\002158\00182\002158\0012\002158\001127\002158\00163\002158\00114\002158\00157\002158\00177\002158\001104\002158\00128\002158\001119\002158\001106\002158\00115\002158\0017\002158\0016\002158\0018\002158\00170\002158\0019\002158\001112\002158\001115\002158\00185\002158\00155\002158\00138\002158\001116\002158\00124\002159\00131\002159\00144\002159\00152\002159\00120\002159\00134\002159\0012\002159\00147\002159\0016\002159\00110\002159\00142\002159\00125\002159\00150\002159\00141\002159\00152\002160\00131\002160\00183\002160\00157\002160\00110\002160\00184\002160\00186\002160\00177\002160\00154\002160\00166\002160\00146\002160\00161\002160\00185\002161\00196\002161\00162\002161\001128\002161\00125\002161\00186\002161\00138\002161\00194\002161\00167\002161\001125\002161\00136\002161\00148\002161\0017\002161\001124\002161\00189\002161\00172\002161\00170\002161\001134\002161\00144\002161\001122\002161\00110\002161\00159\002161\00156\002161\00143\002161\00142\002161\001108\002161\00113\002161\00139\002161\0014\002161\001132\002161\00138\002162\00161\002162\00165\002162\00117\002162\00145\002162\00131\002162\00157\002162\00149\002162\00153\002162\00120\002162\00179\002162\00125\002162\00172\002162\00162\002162\00116\002162\00150\002162\00126\002162\00137\002162\00181\002162\0014\002162\00111\002162\001158\002163\00135\002163\00195\002163\00111\002163\001190\002163\001172\002163\0017\002163\00199\002163\001182\002163\00110\002163\001161\002163\001129\002163\001101\002163\001167\002163\001105\002163\00138\002163\00143\002163\00132\002163\001148\002163\001183\002163\00185\002163\001143\002163\001169\002163\001164\002163\0016\002163\0015\002163\00114\002163\001111\002163\001170\002163\001185\002163\001153\002163\00144\002163\00115\002163\00160\002163\001162\002163\001140\002163\00175\002163\00197\002163\001118\002163\001165\002163\00182\002163\00164\002163\00172\002163\00173\002163\001166\002163\00192\002163\00126\002163\001106\002163\00196\002163\001171\002163\001180\002163\001156\002163\001123\002163\001128\002163\0013\002163\001144\002163\00149\002163\001117\002163\00166\002163\00130\002163\001142\002163\00180\002163\00189\002163\00141\002163\001100\002163\00190\002163\00121\002163\00155\002163\0010\002163\00161\002163\00141\002164\00148\002164\0018\002164\001106\002165\00161\002165\00156\002165\00115\002165\00133\002165\00196\002165\0019\002165\001119\002165\001117\002165\00145\002166\001216\002166\00175\002166\001143\002166\00178\002166\001174\002166\00181\002166\0019\002166\0017\002166\001202\002166\00195\002166\001171\002166\00132\002166\001181\002166\00185\002166\00158\002166\001156\002166\00146\002166\001681\002167\001611\002167\001606\002167\001579\002167\001562\002167\001607\002167\001622\002167\001576\002167\001626\002167\001649\002167\001616\002167\001594\002167\001597\002167\001610\002167\001586\002167\001591\002167\001670\002167\001672\002167\00159\002167\00121\002167\001497\002167\00181\002167\00171\002167\001337\002167\001380\002167\001406\002167\001487\002167\001329\002167\001534\002167\001175\002167\001232\002167\00166\002167\001245\002167\001377\002167\001201\002167\00191\002167\001425\002167\001204\002167\001270\002167\00150\002167\001388\002167\001221\002167\001237\002167\001454\002167\00152\002167\001240\002167\001195\002167\001181\002167\001295\002167\001515\002167\001216\002167\001136\002167\001458\002167\00174\002167\001282\002167\0017\002167\001470\002167\001197\002167\001265\002167\001296\002167\001263\002167\001357\002167\001239\002167\001307\002167\001297\002167\001499\002167\00164\002167\001322\002167\001372\002167\001313\002167\001411\002167\00179\002167\001259\002167\001364\002167\001336\002167\001363\002167\001253\002167\001537\002167\001219\002167\001402\002167\00158\002167\001310\002167\001198\002167\001428\002167\00197\002167\0012\002168\001272\002168\001269\002168\001279\002168\001277\002168\001276\002168\001280\002168\0017\002168\001152\002168\00170\002168\00127\002168\001115\002168\001251\002168\00174\002168\001139\002168\001166\002168\001170\002168\001215\002168\001147\002168\00113\002168\00179\002168\001125\002168\00195\002168\001116\002168\001247\002168\001107\002168\001192\002168\001239\002168\001224\002168\00136\002168\001105\002168\001135\002168\001163\002168\00147\002168\001127\002168\00178\002168\001262\002168\001186\002168\001118\002168\001226\002168\001109\002168\001112\002168\001172\002168\001184\002168\001189\002168\00183\002168\001100\002168\001260\002168\001267\002168\001817\002169\0011\002169\00117\002169\001698\002169\001732\002169\001754\002169\001766\002169\001735\002169\001759\002169\001762\002169\001796\002169\001812\002169\001767\002169\001757\002169\001708\002169\001780\002169\001746\002169\001801\002169\001813\002169\00134\002169\00163\002169\00193\002169\00199\002169\001141\002169\001243\002169\001306\002169\001646\002169\001142\002169\001484\002169\001232\002169\001649\002169\00121\002169\001355\002169\00173\002169\001337\002169\001428\002169\001119\002169\001392\002169\001259\002169\001399\002169\001236\002169\00160\002169\001267\002169\001377\002169\001650\002169\001678\002169\001673\002169\001303\002169\001372\002169\001291\002169\00145\002169\00156\002169\001615\002169\00148\002169\001315\002169\001287\002169\001353\002169\001314\002169\001561\002169\001608\002169\00187\002169\00191\002169\001659\002169\001633\002169\001685\002169\00177\002169\001123\002169\001178\002169\001162\002169\001398\002169\001265\002169\001460\002169\001469\002169\00139\002169\001361\002169\001625\002169\001289\002169\001638\002169\001419\002169\001434\002169\001357\002169\001581\002169\001693\002169\001139\002169\001158\002169\001441\002169\001260\002169\001331\002169\001607\002169\001335\002169\001280\002169\001410\002169\001424\002169\001486\002169\001588\002169\001401\002169\001697\002169\001348\002169\001391\002169\001462\002169\001387\002169\001311\002169\001378\002169\00166\002170\00167\002170\00189\002170\00181\002170\0010\002170\00134\002170\00120\002170\00113\002170\00141\002170\00160\002170\00129\002170\0014\002170\00122\002170\00154\002170\00162\002170\0010\002171\0011\002171\00122\002172\0012\002172\0013\002172\00114\002172\00116\002172\001253\002173\001241\002173\001236\002173\001245\002173\001213\002173\001225\002173\001244\002173\001235\002173\001250\002173\001230\002173\001216\002173\001247\002173\001252\002173\00140\002173\00117\002173\00151\002173\00112\002173\00155\002173\001156\002173\0013\002173\00119\002173\0014\002173\0015\002173\001196\002173\001174\002173\001201\002173\00191\002173\001133\002173\00148\002173\00142\002173\001208\002173\001193\002173\001119\002173\001161\002173\00168\002173\00125\002173\00178\002173\001127\002173\001189\002173\00170\002173\001138\002173\001129\002173\001177\002173\001107\002173\001115\002173\00156\002173\001160\002173\001146\002173\00154\002173\001126\002173\00198\002173\001150\002173\00161\002173\001171\002173\00179\002173\001195\002173\001175\002173\00172\002173\001151\002173\00150\002173\001145\002173\00174\002173\001118\002173\00192\002173\00163\002173\001205\002173\001140\002173\001154\002173\00176\002173\001199\002173\00164\002173\001173\002173\00120\002173\00146\002173\00132\002173\00110\002173\001124\002173\00152\002173\00130\002173\00169\002173\001185\002173\0015\002174\0014\002174\00165\002175\0015\002175\00128\002175\00115\002175\00158\002175\00144\002175\0010\002176\00136\002176\00140\002176\00134\002176\00124\002176\0014\002176\00127\002176\00115\002176\00118\002176\00133\002176\00116\002176\0013\002176\00120\002176\0012\002176\00113\002176\00122\002176\00181\002177\00187\002177\00197\002177\00190\002177\001103\002177\001101\002177\00156\002177\00118\002177\00175\002177\00144\002177\00132\002177\00116\002177\0013\002177\00168\002177\00140\002177\00153\002177\0011863\002178\0011882\002178\0014\002178\0015\002178\0011771\002178\0011792\002178\0011720\002178\0011637\002178\0011707\002178\0011713\002178\0011703\002178\0011848\002178\0011685\002178\0011681\002178\0011814\002178\0011778\002178\0011762\002178\0011660\002178\0011664\002178\0011816\002178\0011751\002178\0011680\002178\0011842\002178\0011753\002178\0011765\002178\0011815\002178\0011721\002178\0011661\002178\0011690\002178\0011821\002178\0011783\002178\0011768\002178\0011726\002178\0011874\002178\0011785\002178\0011836\002178\0011868\002178\00127\002178\001955\002178\00114\002178\00136\002178\001408\002178\0011043\002178\001393\002178\0011422\002178\001220\002178\001330\002178\001263\002178\001280\002178\001648\002178\001438\002178\0011383\002178\00152\002178\0011041\002178\00163\002178\001239\002178\001329\002178\001415\002178\0011464\002178\001538\002178\001449\002178\001717\002178\001472\002178\001379\002178\0011001\002178\001672\002178\0011078\002178\001841\002178\001758\002178\001940\002178\001712\002178\0011347\002178\001100\002178\001177\002178\0011058\002178\0011101\002178\001645\002178\0011572\002178\0011056\002178\001141\002178\001969\002178\001884\002178\001785\002178\001862\002178\00116\002178\00159\002178\001747\002178\001768\002178\001796\002178\001975\002178\001894\002178\001910\002178\0011198\002178\001135\002178\00196\002178\001996\002178\001260\002178\001452\002178\0011138\002178\001154\002178\001128\002178\001936\002178\0011237\002178\0011153\002178\001544\002178\0011183\002178\001844\002178\001869\002178\001333\002178\001486\002178\0011235\002178\001763\002178\0011273\002178\0011204\002178\0011227\002178\0011137\002178\0011631\002178\0011008\002178\001264\002178\0011085\002178\001606\002178\0011493\002178\0011450\002178\0011520\002178\0011467\002178\00186\002178\001711\002178\001389\002178\001709\002178\00123\002178\001575\002178\001599\002178\001671\002178\001721\002178\00166\002178\001710\002178\001611\002178\00120\002178\001461\002178\001377\002178\001314\002178\0011024\002178\0011054\002178\0011188\002178\0011099\002178\001999\002178\001898\002178\001670\002178\001572\002178\0011061\002178\0011217\002178\001649\002178\00129\002178\001516\002178\0011017\002178\0011044\002178\001152\002178\001112\002178\001510\002178\001579\002178\0011416\002178\001119\002178\001210\002178\001407\002178\0011135\002178\0011069\002178\001730\002178\001601\002178\0011492\002178\0011430\002178\0011362\002178\001162\002178\001183\002178\001429\002178\001354\002178\001972\002178\001866\002178\0011068\002178\001804\002178\001150\002178\001906\002178\0011193\002178\0011549\002178\001536\002178\0011181\002178\001592\002178\0011113\002178\001887\002178\0011578\002178\0011632\002178\001775\002178\001802\002178\0011536\002178\0011214\002178\0011428\002178\0011447\002178\001497\002178\0011329\002178\0011244\002178\001326\002178\0011317\002178\001586\002178\001511\002178\001350\002178\0011010\002178\0011038\002178\00168\002178\001521\002178\0011336\002178\0011256\002178\0011164\002178\0011207\002178\001446\002178\001285\002178\001860\002178\001830\002178\001858\002178\0011602\002178\00167\002178\001436\002178\0011211\002178\0011255\002178\0011377\002178\001369\002178\001735\002178\0011129\002178\0011373\002178\0011064\002178\0011220\002178\0011007\002178\0011522\002178\001400\002178\001342\002178\001357\002178\001845\002178\0011515\002178\0011525\002178\0011534\002178\0011545\002178\001809\002178\001583\002178\0011127\002178\001958\002178\0011494\002178\0011236\002178\001163\002178\001174\002178\001453\002178\001618\002178\0011426\002178\0011442\002178\0011407\002178\001129\002178\00135\002179\00127\002179\00137\002179\00132\002179\0010\002179\00117\002179\00115\002179\00114\002179\00119\002179\0018\002179\0015\002179\0010\002180\00159\002180\00162\002180\00156\002180\00167\002180\00132\002180\0015\002180\00116\002180\00126\002180\0019\002180\0016\002180\00139\002180\00136\002180\00123\002180\00153\002180\00111\002180\00140\002180\00138\002180\00152\002180\0017\002180\00135\002180\001142\002181\001113\002181\001111\002181\001112\002181\001126\002181\001114\002181\00119\002181\00157\002181\00177\002181\00123\002181\00149\002181\0018\002181\0015\002181\00184\002181\00112\002181\0019\002181\00173\002181\00176\002181\00179\002181\00164\002181\00160\002181","54"),
("2088102020375963","1","0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0","65\0021\0014\0022\0015\0023\0015\0024\0012\0025\0010\0026\00128\0027\00118\0028\0017\0029\001243\00210\0018\00211\001241\00212\0013\00213\001212\00214\00129\00215\001152\00216\0011\00217\0010\00218\0011\00221\0019\00222\0010\00224\0010\00225\0010\00226\0011\00227\0011\00228\00124\00229\00129\00231\00113\00231\00128\00231\001111\00232\001310\00232\001180\00232\001359\00232\001136\00232\001118\00232\001219\00232\001257\00232\001120\00232\001119\00232\001157\00232\001326\00232\001264\00232\00156\00232\00125\00232\001316\00232\001214\00232\001319\00232\00112\00233\0015\00233\00138\00233\00140\00233\00124\00233\00140\00234\00156\00234\001106\00234\00118\00234\001109\00234\001128\00234\00150\00234\001118\00234\001187\00234\001186\00234\001147\00234\00194\00234\00171\00234\00128\00234\001112\00234\00170\00234\00159\00234\001174\00234\001100\00234\001171\00234\00154\00234\00144\00234\00126\00235\00157\00235\00161\00235\00133\00235\00151\00235\00176\00235\00126\00236\00112\00236\00125\00236\0012\00236\0018\00236\00132\00236\00118\00236\00113\00236\00131\00236\001109\00237\00189\00237\00191\00237\00179\00237\00167\00237\00156\00237\00139\00237\0015\002141\0015\002143\0017\002143\0016\002143\00112\002143\0010\002143\0014\002143\0012\002143\0013\002144\0011\002144\0010\002144\00122\002145\00120\002145\0017\002145\00112\002145\0012\002145\0013\002145\00116\002145\00110\002145\00113\002145\0010\002146\0011\002146\00181\002147\0019\002147\00175\002147\00188\002147\00153\002147\00165\002147\00144\002147\00146\002147\00120\002147\00142\002147\00170\002147\0016\002147\0013\002147\00113\002147\00174\002147\00141\002147\00168\002147\00184\002147\00155\002147\00123\002147\00143\002147\00134\002147\0011\002147\00121\002147\00161\002147\0010\002147\00171\002147\00157\002147\00117\002147\00159\002147\00164\002147\00137\002147\00128\002147\0015\002147\00186\002147\001102\002148\001115\002148\00180\002148\0016\002148\00114\002148\001147\002148\00125\002148\001155\002148\001144\002148\00196\002148\0015\002148\00193\002148\00159\002148\00113\002148\00169\002148\00144\002148\00111\002148\00157\002148\00174\002148\0014\002148\00194\002149\001224\002149\00156\002149\001233\002149\00143\002149\001255\002149\001204\002149\001170\002149\00116\002149\00162\002149\001262\002149\001281\002149\001412\002149\001373\002149\001419\002149\001207\002149\001221\002149\001383\002149\001316\002149\001350\002149\00186\002149\001132\002149\001322\002149\001104\002149\001405\002149\001142\002149\001287\002149\001366\002149\00120\002150\00179\002150\00181\002150\00159\002150\00136\002150\00149\002150\001139\002150\00124\002150\00122\002150\00166\002150\001197\002150\001221\002150\001119\002150\001203\002150\001211\002150\001141\002150\001205\002150\00198\002150\001179\002150\0011\002150\0019\002150\001389\002151\00131\002151\001122\002151\001229\002151\00198\002151\001219\002151\001433\002151\001476\002151\00112\002151\001161\002151\001461\002151\001296\002151\00143\002151\001443\002151\001583\002152\001636\002152\001241\002153\001182\002153\001529\002153\001324\002153\001373\002153\00174\002153\00185\002153\001102\002153\001459\002153\001231\002153\001447\002153\001147\002153\00137\002153\001462\002153\00118\002153\001118\002153\001348\002153\001358\002153\00183\002153\001304\002153\001426\002153\001148\002153\001156\002153\001517\002153\001381\002153\001475\002153\00184\002154\001761\002154\001309\002154\001528\002154\001772\002154\001604\002154\001845\002154\001308\002154\001253\002154\001788\002154\001503\002154\001534\002154\0011007\002154\001708\002154\001465\002154\001823\002154\001176\002154\001221\002154\001681\002154\001454\002154\001902\002154\001956\002154\001330\002154\001965\002154\00179\002154\001866\002154\001172\002154\001162\002154\001875\002154\001353\002154\001489\002154\001694\002154\0011009\002154\001393\002154\001337\002154\0016\002155\00113\002155\00126\002155\0014\002155\00128\002155\00124\002155\00144\002155\00155\002155\00136\002155\0013\002155\00139\002155\00147\002155\00129\002155\00132\002155\00110\002155\00138\002155\0019\002155\0018\002155\00122\002155\00123\002155\00119\002155\00154\002155\00156\002155\00149\002155\00140\002155\00159\002155\00150\002155\00125\002155\00141\002155\00143\002155\00133\002156\00140\002156\0015\002156\00143\002156\0014\002156\00139\002156\00132\002156\0016\002156\00129\002156\00128\002156\00123\002156\00111\002156\00136\002156\00120\002156\00113\002156\00137\002156\00131\002156\00147\002156\0019\002156\0018\002156\00137\002157\00118\002157\00116\002157\00113\002157\00123\002157\00132\002157\00120\002157\00121\002157\0017\002157\00135\002157\0019\002157\00138\002157\0015\002157\0010\002157\00126\002157\00130\002157\00117\002157\0016\002157\00127\002157\00131\002157\00136\002157\00139\002158\00136\002158\00118\002158\00189\002158\001109\002158\00169\002158\00146\002158\00126\002158\00120\002158\00183\002158\0011\002158\001103\002158\00125\002158\00171\002158\00175\002158\00148\002158\00162\002158\001100\002158\001126\002158\00152\002158\00186\002158\001107\002158\00198\002158\00199\002158\001118\002158\001117\002158\0015\002158\00174\002158\001113\002158\0010\002158\00129\002158\001124\002158\00137\002158\00116\002158\00132\002158\00194\002158\00113\002158\00160\002158\00197\002158\001120\002158\00151\002158\00193\002158\0014\002158\00110\002158\00144\002158\00158\002158\0013\002158\00182\002158\0012\002158\001127\002158\00163\002158\00114\002158\00157\002158\00172\002158\001104\002158\00128\002158\001119\002158\001106\002158\00115\002158\0017\002158\0016\002158\0018\002158\00170\002158\0019\002158\001112\002158\001115\002158\00185\002158\00155\002158\00138\002158\001116\002158\00124\002159\00128\002159\00144\002159\00135\002159\00120\002159\00130\002159\0012\002159\00147\002159\0016\002159\00110\002159\00142\002159\00125\002159\00121\002159\00115\002159\00156\002160\00127\002160\00152\002160\00126\002160\00112\002160\00157\002160\00158\002160\00129\002160\00186\002160\00155\002160\00122\002160\00166\002160\00151\002160\00142\002160\00130\002161\00112\002161\00162\002161\001128\002161\00125\002161\00186\002161\00138\002161\00194\002161\00167\002161\001125\002161\00136\002161\001117\002161\001103\002161\001124\002161\00189\002161\00172\002161\00163\002161\001134\002161\00144\002161\001122\002161\00173\002161\00165\002161\00156\002161\00123\002161\00142\002161\001129\002161\00113\002161\00139\002161\0014\002161\001132\002161\00138\002162\00161\002162\00165\002162\00117\002162\00145\002162\00131\002162\00157\002162\00149\002162\00153\002162\00120\002162\00179\002162\00125\002162\00172\002162\00162\002162\00116\002162\00150\002162\00126\002162\00137\002162\00181\002162\0014\002162\00111\002162\001158\002163\00135\002163\00195\002163\00111\002163\001190\002163\001172\002163\0017\002163\00199\002163\001182\002163\00110\002163\001161\002163\001129\002163\001101\002163\001167\002163\001105\002163\00138\002163\00143\002163\00132\002163\001148\002163\001183\002163\00185\002163\001143\002163\001169\002163\001164\002163\0016\002163\0015\002163\00114\002163\00133\002163\001170\002163\001185\002163\001153\002163\00144\002163\00115\002163\00160\002163\001162\002163\001140\002163\00175\002163\00197\002163\001118\002163\001165\002163\00182\002163\00164\002163\00172\002163\00173\002163\001166\002163\00192\002163\00126\002163\001106\002163\00196\002163\001171\002163\001180\002163\001156\002163\001123\002163\001128\002163\0013\002163\001144\002163\00149\002163\001117\002163\00166\002163\00130\002163\001142\002163\00180\002163\00189\002163\00141\002163\001100\002163\00190\002163\00121\002163\00155\002163\0010\002163\00161\002163\001157\002164\001125\002164\00141\002164\00130\002164\00114\002164\0018\002164\001113\002164\00143\002164\00180\002164\001111\002165\001113\002165\00156\002165\001118\002165\001104\002165\00133\002165\00153\002165\00176\002165\001115\002165\00183\002165\0014\002166\00175\002166\00127\002166\00118\002166\00156\002166\00199\002166\001175\002166\001188\002166\001116\002166\001126\002166\00195\002166\001172\002166\00132\002166\001151\002166\00185\002166\00111\002166\001182\002166\001149\002166\0011\002167\001570\002167\001553\002167\001589\002167\001562\002167\001567\002167\001622\002167\001640\002167\001590\002167\001584\002167\001656\002167\001621\002167\001597\002167\001669\002167\001676\002167\001645\002167\001615\002167\001623\002167\00130\002167\00121\002167\001389\002167\001281\002167\00129\002167\001153\002167\001516\002167\001172\002167\00125\002167\001467\002167\00127\002167\001213\002167\001399\002167\001178\002167\001174\002167\001179\002167\00162\002167\001229\002167\001374\002167\001358\002167\00167\002167\001226\002167\00173\002167\001440\002167\0016\002167\001125\002167\001511\002167\001107\002167\001255\002167\001185\002167\001339\002167\001123\002167\001267\002167\001276\002167\001309\002167\001368\002167\00186\002167\001491\002167\001166\002167\001517\002167\001350\002167\001277\002167\00163\002167\001196\002167\001186\002167\001548\002167\00185\002167\001322\002167\001208\002167\001313\002167\00179\002167\001259\002167\001509\002167\001448\002167\001527\002167\001387\002167\001544\002167\00172\002167\001373\002167\001168\002167\001310\002167\001462\002167\001551\002167\001194\002167\0018\002168\001272\002168\001269\002168\001279\002168\001275\002168\001274\002168\001280\002168\0017\002168\001152\002168\00170\002168\00127\002168\00187\002168\001257\002168\00174\002168\001139\002168\001166\002168\001212\002168\001240\002168\00125\002168\001147\002168\00192\002168\001104\002168\001157\002168\00195\002168\00119\002168\001179\002168\001136\002168\001192\002168\00194\002168\001236\002168\00162\002168\00160\002168\001135\002168\001163\002168\00137\002168\00199\002168\00178\002168\001262\002168\001186\002168\001118\002168\001226\002168\001140\002168\001168\002168\001172\002168\001204\002168\001208\002168\00163\002168\001128\002168\001260\002168\001233\002168\001817\002169\0011\002169\00113\002169\001733\002169\001732\002169\001720\002169\001701\002169\001735\002169\001789\002169\001762\002169\001796\002169\001814\002169\001742\002169\001757\002169\001708\002169\001780\002169\001746\002169\001729\002169\001810\002169\00153\002169\00163\002169\00193\002169\001134\002169\001141\002169\001243\002169\001306\002169\001646\002169\001142\002169\001220\002169\001591\002169\001649\002169\00157\002169\001413\002169\00173\002169\001549\002169\001428\002169\001119\002169\001392\002169\001129\002169\001399\002169\001152\002169\001691\002169\001267\002169\001377\002169\001650\002169\001678\002169\001682\002169\001303\002169\001485\002169\001192\002169\00145\002169\001198\002169\001394\002169\001190\002169\001315\002169\001287\002169\001562\002169\001314\002169\001561\002169\001571\002169\00142\002169\001264\002169\001327\002169\001671\002169\001136\002169\001345\002169\001123\002169\001178\002169\001162\002169\001552\002169\001318\002169\001460\002169\001469\002169\001307\002169\001361\002169\001625\002169\001461\002169\001689\002169\001419\002169\001174\002169\001415\002169\001494\002169\001693\002169\001139\002169\001158\002169\001495\002169\001260\002169\001331\002169\001539\002169\001335\002169\001334\002169\001410\002169\001606\002169\001173\002169\001617\002169\001401\002169\00147\002169\001147\002169\001391\002169\001513\002169\001387\002169\001311\002169\001578\002169\00176\002170\00188\002170\00175\002170\00181\002170\0010\002170\00140\002170\00120\002170\00113\002170\00152\002170\00160\002170\00129\002170\0016\002170\00122\002170\00126\002170\00139\002170\0010\002171\0011\002171\00122\002172\0012\002172\0016\002172\00114\002172\00116\002172\001253\002173\001241\002173\001236\002173\001245\002173\001213\002173\001225\002173\001215\002173\001235\002173\001250\002173\001230\002173\001216\002173\001247\002173\001252\002173\00140\002173\00117\002173\00185\002173\00112\002173\00155\002173\001156\002173\00111\002173\00119\002173\0014\002173\00115\002173\001196\002173\001174\002173\001201\002173\00191\002173\001133\002173\00148\002173\00196\002173\001208\002173\001193\002173\001119\002173\001161\002173\001121\002173\00125\002173\00178\002173\001127\002173\001189\002173\00170\002173\00141\002173\001129\002173\001177\002173\001107\002173\001115\002173\00156\002173\001160\002173\001163\002173\00154\002173\001126\002173\00198\002173\001150\002173\00161\002173\001182\002173\00179\002173\001195\002173\001175\002173\00172\002173\001151\002173\00150\002173\001145\002173\00174\002173\001118\002173\00192\002173\00163\002173\001205\002173\00158\002173\001154\002173\00197\002173\00190\002173\00164\002173\001173\002173\00138\002173\00146\002173\00132\002173\00118\002173\001124\002173\00152\002173\00130\002173\00187\002173\001185\002173\0015\002174\0014\002174\00165\002175\0015\002175\00128\002175\00124\002175\0014\002175\00144\002175\0010\002176\00136\002176\00140\002176\00134\002176\00124\002176\0014\002176\00127\002176\00115\002176\00118\002176\00133\002176\00116\002176\0013\002176\00120\002176\0012\002176\00113\002176\00122\002176\001100\002177\00187\002177\00197\002177\00190\002177\001103\002177\00196\002177\00156\002177\00118\002177\0014\002177\00144\002177\00132\002177\00116\002177\0013\002177\00168\002177\00140\002177\00153\002177\0011873\002178\0011882\002178\0016\002178\0019\002178\0011644\002178\0011638\002178\0011787\002178\0011641\002178\0011774\002178\0011713\002178\0011724\002178\0011848\002178\0011685\002178\0011648\002178\0011652\002178\0011800\002178\0011762\002178\0011660\002178\0011664\002178\0011716\002178\0011751\002178\0011704\002178\0011856\002178\0011775\002178\0011831\002178\0011815\002178\0011788\002178\0011661\002178\0011690\002178\0011821\002178\0011783\002178\0011812\002178\0011770\002178\0011658\002178\0011785\002178\0011836\002178\0011868\002178\00127\002178\0011194\002178\00114\002178\00136\002178\001408\002178\0011043\002178\001614\002178\001759\002178\00171\002178\001330\002178\001263\002178\001280\002178\001527\002178\0011173\002178\001825\002178\001451\002178\0011041\002178\00163\002178\001239\002178\001528\002178\001901\002178\0011464\002178\001538\002178\001449\002178\001717\002178\001472\002178\001600\002178\0011338\002178\001931\002178\0011078\002178\001160\002178\001886\002178\0011385\002178\001712\002178\0011436\002178\001294\002178\001416\002178\0011171\002178\0011101\002178\0011360\002178\0011572\002178\0011056\002178\001473\002178\001307\002178\0011243\002178\001914\002178\0011111\002178\00190\002178\00159\002178\001175\002178\001187\002178\001274\002178\0011098\002178\001894\002178\001910\002178\0011198\002178\001135\002178\001375\002178\001996\002178\001260\002178\001452\002178\0011138\002178\001301\002178\001128\002178\001936\002178\0011237\002178\0011153\002178\001272\002178\0011290\002178\001973\002178\0011117\002178\001422\002178\001486\002178\0011235\002178\001763\002178\001814\002178\0011589\002178\0011227\002178\0011137\002178\001153\002178\0011008\002178\001442\002178\0011085\002178\001606\002178\001630\002178\0011504\002178\0011574\002178\0011196\002178\001130\002178\001228\002178\001389\002178\0011089\002178\00135\002178\00137\002178\001599\002178\001671\002178\001976\002178\001390\002178\001710\002178\001986\002178\00120\002178\001461\002178\001377\002178\001403\002178\001523\002178\001360\002178\0011295\002178\0011212\002178\0011337\002178\0011023\002178\0011379\002178\001572\002178\0011061\002178\0011217\002178\001777\002178\00129\002178\001186\002178\0011249\002178\001562\002178\001152\002178\001241\002178\001879\002178\001579\002178\001853\002178\001430\002178\001210\002178\0011333\002178\0011135\002178\0011180\002178\001981\002178\001601\002178\0011550\002178\0011430\002178\0011362\002178\001310\002178\001183\002178\001539\002178\001354\002178\001972\002178\001866\002178\0011179\002178\001804\002178\001295\002178\0011030\002178\0011397\002178\001877\002178\001536\002178\0011181\002178\001592\002178\0011113\002178\0011246\002178\0011610\002178\001126\002178\0011147\002178\0011059\002178\0011191\002178\0011214\002178\0011428\002178\0011447\002178\001741\002178\0011329\002178\0011244\002178\001326\002178\00150\002178\001586\002178\001883\002178\001350\002178\0011010\002178\0011038\002178\001236\002178\001642\002178\001411\002178\0011256\002178\0011164\002178\0011410\002178\001446\002178\001707\002178\001860\002178\0011087\002178\001858\002178\0011269\002178\00167\002178\001436\002178\0011211\002178\001664\002178\0011526\002178\001706\002178\001735\002178\0011241\002178\0011373\002178\0011384\002178\0011220\002178\0011344\002178\0011608\002178\001503\002178\001434\002178\001692\002178\001845\002178\0011515\002178\0011390\002178\0011313\002178\0011634\002178\001139\002178\001583\002178\001423\002178\0011086\002178\0011551\002178\0011342\002178\001163\002178\001174\002178\001817\002178\001618\002178\001764\002178\0011442\002178\0011407\002178\001129\002178\00135\002179\00129\002179\00137\002179\00132\002179\0010\002179\00117\002179\00115\002179\00114\002179\00119\002179\00111\002179\0015\002179\0010\002180\00159\002180\00166\002180\00156\002180\00167\002180\00132\002180\0015\002180\00116\002180\00126\002180\0019\002180\0016\002180\00139\002180\00136\002180\00128\002180\00153\002180\00111\002180\00140\002180\00143\002180\00152\002180\0017\002180\00135\002180\001142\002181\001132\002181\001124\002181\001130\002181\001139\002181\001133\002181\00152\002181\00172\002181\00177\002181\00134\002181\0016\002181\00132\002181\00110\002181\00197\002181\00142\002181\00148\002181\00180\002181\00137\002181\0011\002181\00144\002181\00174\002181","69");


DROP TABLE IF EXISTS test_sparse_with_fm_feature_map;
CREATE TABLE test_sparse_with_fm_feature_map (
       id int,
       feature int,
       feature_crc64 string,
	   feature_type string,
	   group int);
INSERT INTO test_sparse_with_fm_feature_map VALUES
("0","0","11900436907799928259","deep","1"),
("1","1","12523075054379199353","deep","1"),
("2","2","12970809883905413942","deep","1"),
("3","3","13195037981053451093","deep","1"),
("4","4","13385939889608890000","deep","1"),
("5","5","13532299078143658982","deep","1"),
("6","6","13558626632232213024","deep","1"),
("7","7","14016979659352714956","deep","1"),
("8","8","14108891737466869004","deep","1"),
("9","9","14363340110908491750","deep","1"),
("10","10","14389032724088477343","deep","1"),
("11","11","14481948610036576390","deep","1"),
("12","12","14500567513445082812","deep","1"),
("13","13","14677494044763758669","deep","1"),
("14","14","14739084698829642509","deep","1"),
("15","15","14858110399220556954","deep","1"),
("16","16","14923765247300446520","deep","1"),
("17","17","14926879953368256218","deep","1"),
("18","18","14938832865768365159","deep","1"),
("19","19","14944585215447612955","deep","1"),
("20","20","15117724122656541530","deep","1"),
("21","21","15213717236309515557","deep","1"),
("22","22","15251543403401282901","deep","1"),
("23","23","15260044424911849366","deep","1"),
("24","24","15275090150729660753","deep","1"),
("25","25","15338347866493261418","deep","1"),
("26","26","15340328186365523990","deep","1"),
("27","27","15365131841905099299","deep","1"),
("28","28","15371083260087667484","deep","1"),
("29","29","15387247782093231235","deep","1"),
("30","30","15464426141047100152","deep","1"),
("31","31","15571980528525396017","deep","1"),
("32","32","15580005362283926887","deep","1"),
("33","33","15611882237414481542","deep","1"),
("34","34","15690674455830032450","deep","1"),
("35","35","15707230612115416008","deep","1"),
("36","36","15722659137672778679","deep","1"),
("37","37","15740109173153527462","deep","1"),
("38","38","15750711785034987339","deep","1"),
("39","39","15780116558238481769","deep","1"),
("40","40","15787656662013492719","deep","1"),
("41","41","15801230816814024202","deep","1"),
("42","42","15841692501295874148","deep","1"),
("43","43","15873378936871284881","deep","1"),
("44","44","15905753126772495421","deep","1"),
("45","45","15918400845569681902","deep","1"),
("46","46","15935504392660693916","deep","1"),
("47","47","15954341910419274987","deep","1"),
("48","48","15988663863384768322","deep","1"),
("49","49","16021371956888579666","deep","1"),
("50","50","16040663769749089080","deep","1"),
("51","51","16042764485415646487","deep","1"),
("52","52","16073504848129298520","deep","1"),
("53","53","16122817043437143201","deep","1"),
("54","54","16234814670127161338","deep","1"),
("55","55","16345686792310514084","deep","1"),
("56","56","16373841705079121494","deep","1"),
("57","57","16419360932843141696","deep","1"),
("58","58","16475736165174658431","deep","1"),
("59","59","16514255012442147819","deep","1"),
("60","60","16569199446223353230","deep","1"),
("61","61","16615700103285678650","deep","1"),
("62","62","16736778569529533427","deep","1"),
("63","63","16738758889401795999","deep","1"),
("64","64","16749679384409005070","deep","1"),
("65","65","16764747002876923709","deep","1"),
("66","66","16814621299998888307","deep","1"),
("67","67","16834959953246972150","deep","1"),
("68","68","16845469469424731914","deep","1"),
("69","69","17046903665807341138","deep","1"),
("70","70","17076762738407731207","deep","1"),
("71","71","17211073792617335639","deep","1"),
("72","72","17331695841832873873","deep","1"),
("73","73","17336203868088060177","deep","1"),
("74","74","17509842224878934725","deep","1"),
("75","75","17674502007522371383","deep","1"),
("76","76","17794137081838844279","deep","1"),
("77","77","2820583102685109715","deep","1"),
("0","0","11402357626967961602","deep","10"),
("1","1","11642584319913348451","deep","10"),
("2","2","12041564518914719515","deep","10"),
("3","3","12049639424413255660","deep","10"),
("4","4","12143581889844710259","deep","10"),
("5","5","12152075734008628229","deep","10"),
("6","6","12278404978423396629","deep","10"),
("7","7","12304000243456971117","deep","10"),
("8","8","12332762412519716074","deep","10"),
("9","9","12460537179378189147","deep","10"),
("10","10","12471579371058118610","deep","10"),
("11","11","12487891308655131445","deep","10"),
("12","12","12544996703820272238","deep","10"),
("13","13","12606477424952609008","deep","10"),
("14","14","12686173316312028957","deep","10"),
("15","15","12700088121592752891","deep","10"),
("16","16","12728118001600518294","deep","10"),
("17","17","12767959845001094728","deep","10"),
("18","18","12816952852009797362","deep","10"),
("19","19","12905455933627765714","deep","10"),
("20","20","12951775944883451028","deep","10"),
("21","21","12960877425570375429","deep","10"),
("22","22","13067889963548835662","deep","10"),
("23","23","13093265903469838180","deep","10"),
("24","24","13105421840212227008","deep","10"),
("25","25","13165950947177012254","deep","10"),
("26","26","13197348633629839813","deep","10"),
("27","27","13208847246633053115","deep","10"),
("28","28","13214249152083604644","deep","10"),
("29","29","13224007956509704571","deep","10"),
("30","30","13235212283379509171","deep","10"),
("31","31","13249108028699011374","deep","10"),
("32","32","13261502350515193903","deep","10"),
("33","33","13432467707258083835","deep","10"),
("34","34","13495964104699229695","deep","10"),
("35","35","13523737176936521114","deep","10"),
("36","36","13609148319841123025","deep","10"),
("37","37","13645523917658859993","deep","10"),
("38","38","13706182723985944065","deep","10"),
("39","39","13719290274895884417","deep","10"),
("40","40","13728391759877776114","deep","10"),
("41","41","13748328311690325089","deep","10"),
("42","42","13796006671220676671","deep","10"),
("43","43","13799466229637367467","deep","10"),
("44","44","13806146935949223705","deep","10"),
("45","45","13813198262890095799","deep","10"),
("46","46","13841300107287973729","deep","10"),
("47","47","13857118140903800711","deep","10"),
("48","48","13863634666121147610","deep","10"),
("49","49","13869181860941792727","deep","10"),
("50","50","13885880305671578372","deep","10"),
("51","51","13911139135312385325","deep","10"),
("52","52","13977388160423809352","deep","10"),
("53","53","14001462527834096608","deep","10"),
("54","54","14006444615619963011","deep","10"),
("55","55","14019295363054396675","deep","10"),
("56","56","14056552246690428311","deep","10"),
("57","57","14071727671870538524","deep","10"),
("58","58","14099066215434653356","deep","10"),
("59","59","14136197576129343160","deep","10"),
("60","60","14162650653159239034","deep","10"),
("61","61","14171179853759703522","deep","10"),
("62","62","14172623245687085403","deep","10"),
("63","63","14180082972410837559","deep","10"),
("64","64","14180758012379163343","deep","10"),
("65","65","14187863583186030410","deep","10"),
("66","66","14201920212178388259","deep","10"),
("67","67","14289838420332826141","deep","10"),
("68","68","14301047798327923740","deep","10"),
("69","69","14301322322327547982","deep","10"),
("70","70","14308957643732647245","deep","10"),
("71","71","14323583556180740802","deep","10"),
("72","72","14328653688545014319","deep","10"),
("73","73","14355862528451863029","deep","10"),
("74","74","14380211888889509995","deep","10"),
("75","75","14383215783024469322","deep","10"),
("76","76","14388141500722985256","deep","10"),
("77","77","14413040373892648878","deep","10"),
("78","78","14428705450611233952","deep","10"),
("79","79","14435870886906610110","deep","10"),
("80","80","14437191756818341660","deep","10"),
("81","81","14441238310624951126","deep","10"),
("82","82","14446358514729229918","deep","10"),
("83","83","14469009256640887049","deep","10"),
("84","84","14491834718529555282","deep","10"),
("85","85","14508973622057113814","deep","10"),
("86","86","14519593075463387944","deep","10"),
("87","87","14522170853586316951","deep","10"),
("88","88","14531234855910306634","deep","10"),
("89","89","14533604683841033517","deep","10"),
("90","90","14543832502967487840","deep","10"),
("91","91","14551417752632581828","deep","10"),
("92","92","14560546537705068247","deep","10"),
("93","93","14566497960182603728","deep","10"),
("94","94","14567032757611161627","deep","10"),
("95","95","14598872150083814268","deep","10"),
("96","96","14606947055582350413","deep","10"),
("97","97","14610810347180464452","deep","10"),
("98","98","14620633938650028411","deep","10"),
("99","99","14635216952409797892","deep","10"),
("100","100","14642795029023210681","deep","10"),
("101","101","14649236103039221023","deep","10"),
("102","102","14654841032832052439","deep","10"),
("103","103","14656871424444320286","deep","10"),
("104","104","14660498160586244626","deep","10"),
("105","105","14662918064551944080","deep","10"),
("106","106","14665900066036796155","deep","10"),
("107","107","14672594236135091659","deep","10"),
("108","108","14676502677918256032","deep","10"),
("109","109","14676567464961720064","deep","10"),
("110","110","14683103756607818719","deep","10"),
("111","111","14683213689541365789","deep","10"),
("112","112","14685741400219256817","deep","10"),
("113","113","14686717907962607094","deep","10"),
("114","114","14696690500490453463","deep","10"),
("115","115","14699862941530449460","deep","10"),
("116","116","14736750083536768541","deep","10"),
("117","117","14738143408019112443","deep","10"),
("118","118","14741220631429020127","deep","10"),
("119","119","14742266973046160139","deep","10"),
("120","120","14755449493566871815","deep","10"),
("121","121","14761943251429775457","deep","10"),
("122","122","14764521029552704464","deep","10"),
("123","123","14771998472505606878","deep","10"),
("124","124","14774026737896519229","deep","10"),
("125","125","14776064792740968100","deep","10"),
("126","126","14805816058629166595","deep","10"),
("127","127","14809550115597749980","deep","10"),
("128","128","14812914452089385167","deep","10"),
("129","129","14820492038522298131","deep","10"),
("130","130","14830120268881763227","deep","10"),
("131","131","14831059293967211490","deep","10"),
("132","132","14833624483008037236","deep","10"),
("133","133","14857718621142043544","deep","10"),
("134","134","14859856819466502965","deep","10"),
("135","135","14905282951526823054","deep","10"),
("136","136","14932145303043934995","deep","10"),
("137","137","14956449517591498923","deep","10"),
("138","138","14963924834323045841","deep","10"),
("139","139","14973502992942505662","deep","10"),
("140","140","14974931669566428786","deep","10"),
("141","141","14982566990971528049","deep","10"),
("142","142","14985211682359276584","deep","10"),
("143","143","15000724421931457633","deep","10"),
("144","144","15009855333225299548","deep","10"),
("145","145","15020025542654938334","deep","10"),
("146","146","15022533482609110310","deep","10"),
("147","147","15048715747327570764","deep","10"),
("148","148","15051090496813252588","deep","10"),
("149","149","15054167724518127568","deep","10"),
("150","150","15091604379256463305","deep","10"),
("151","151","15095605916743327791","deep","10"),
("152","152","15098090599162556685","deep","10"),
("153","153","15100056203731360500","deep","10"),
("154","154","15100178725747010831","deep","10"),
("155","155","15106822828400268356","deep","10"),
("156","156","15123978573452641141","deep","10"),
("157","157","15128536671447832720","deep","10"),
("158","158","15149171737050680761","deep","10"),
("159","159","15151684732425113032","deep","10"),
("160","160","15154718931871325878","deep","10"),
("161","161","15164382518667337492","deep","10"),
("162","162","15164774157242124595","deep","10"),
("163","163","15175389358205687733","deep","10"),
("164","164","15184455482456065616","deep","10"),
("165","165","15197492709311716408","deep","10"),
("166","166","15200230492108197760","deep","10"),
("167","167","15213925042703024078","deep","10"),
("168","168","15218323136024663312","deep","10"),
("169","169","15220850846702554340","deep","10"),
("170","170","15222389456260024534","deep","10"),
("171","171","15237125301641665161","deep","10"),
("172","172","15281452403942984642","deep","10"),
("173","173","15295516210281990986","deep","10"),
("174","174","15296063601087619442","deep","10"),
("175","175","15304045410882455474","deep","10"),
("176","176","15313269413585030206","deep","10"),
("177","177","15318729058302735330","deep","10"),
("178","178","15329945969959675895","deep","10"),
("179","179","15332034096544130041","deep","10"),
("180","180","15346097902883136385","deep","10"),
("181","181","15356715230068055019","deep","10"),
("182","182","15357104742421486626","deep","10"),
("183","183","15357250031791580214","deep","10"),
("184","184","15362197642140203400","deep","10"),
("185","185","15374857945724525846","deep","10"),
("186","186","15375392747448051041","deep","10"),
("187","187","15378469970857958725","deep","10"),
("188","188","15396507001728626178","deep","10"),
("189","189","15403447521031615197","deep","10"),
("190","190","15413328847473365455","deep","10"),
("191","191","15415856558151256483","deep","10"),
("192","192","15417249878338633089","deep","10"),
("193","193","15438522015366372371","deep","10"),
("194","194","15439907668026600657","deep","10"),
("195","195","15441995794611054803","deep","10"),
("196","196","15448042434718678597","deep","10"),
("197","197","15455617894930236065","deep","10"),
("198","198","15456225146929406316","deep","10"),
("199","199","15457106437042668280","deep","10"),
("200","200","15461237540026526238","deep","10"),
("201","201","15482509677054265520","deep","10"),
("202","202","15482791378400538257","deep","10"),
("203","203","15485464378448522873","deep","10"),
("204","204","15491465868371096333","deep","10"),
("205","205","15492404893456544596","deep","10"),
("206","206","15493597018919245317","deep","10"),
("207","207","15494101385761178935","deep","10"),
("208","208","15496029507672080736","deep","10"),
("209","209","15498062025505704079","deep","10"),
("210","210","15510707613786567768","deep","10"),
("211","211","15523420244902589043","deep","10"),
("212","212","15523744840642218560","deep","10"),
("213","213","15525283454494656050","deep","10"),
("214","214","15536340361478044270","deep","10"),
("215","215","15536450294411591340","deep","10"),
("216","216","15541116203413941789","deep","10"),
("217","217","15551453125836045947","deep","10"),
("218","218","15571683968076970920","deep","10"),
("219","219","15577735529739549655","deep","10"),
("220","220","15577953273680255595","deep","10"),
("221","221","15584489565326354250","deep","10"),
("222","222","15586952488960781246","deep","10"),
("223","223","15600041913777792809","deep","10"),
("224","224","15605002108913551960","deep","10"),
("225","225","15608129404063464919","deep","10"),
("226","226","15627717637868673123","deep","10"),
("227","227","15630832343936482821","deep","10"),
("228","228","15648643286506675636","deep","10"),
("229","229","15657991116398293552","deep","10"),
("230","230","15671685666993119870","deep","10"),
("231","231","15678221958639218525","deep","10"),
("232","232","15681313893057617670","deep","10"),
("233","233","15681913481824606897","deep","10"),
("234","234","15691431774955557627","deep","10"),
("235","235","15692920317067989842","deep","10"),
("236","236","15697318410389629076","deep","10"),
("237","237","15702036513058373000","deep","10"),
("238","238","15702743908537553801","deep","10"),
("239","239","15702930392253738225","deep","10"),
("240","240","15716560155805100511","deep","10"),
("241","241","15727872289387096685","deep","10"),
("242","242","15742939907855015324","deep","10"),
("243","243","15744478517412485518","deep","10"),
("244","244","15761429107606255624","deep","10"),
("245","245","15761632136243502807","deep","10"),
("246","246","15765590649766672455","deep","10"),
("247","247","15775376758578334400","deep","10"),
("248","248","15779841765164793162","deep","10"),
("249","249","15786327985070886542","deep","10"),
("250","250","15790726078392525776","deep","10"),
("251","251","15805113309163074138","deep","10"),
("252","252","15821184735464937776","deep","10"),
("253","253","15830690443808752541","deep","10"),
("254","254","15836310088905042714","deep","10"),
("255","255","15837394407655551861","deep","10"),
("256","256","15838933017213022055","deep","10"),
("257","257","15840318674168217637","deep","10"),
("258","258","15850429508289847157","deep","10"),
("259","259","15850921286049677514","deep","10"),
("260","260","15858614346721930372","deep","10"),
("261","261","15860499444669137335","deep","10"),
("262","262","15861099029141159266","deep","10"),
("263","263","15869281741351886985","deep","10"),
("264","264","15878240058890073294","deep","10"),
("265","265","15881329871382084239","deep","10"),
("266","266","15884738872173237231","deep","10"),
("267","267","15905411420433987286","deep","10"),
("268","268","15913154548551278123","deep","10"),
("269","269","15928126949389108449","deep","10"),
("270","270","15933277584080011522","deep","10"),
("271","271","15938781754936961801","deep","10"),
("272","272","15939331271963945753","deep","10"),
("273","273","15949334299373383699","deep","10"),
("274","274","15953025822558772071","deep","10"),
("275","275","15968078725723231953","deep","10"),
("276","276","15969032466112138973","deep","10"),
("277","277","15972145045958593175","deep","10"),
("278","278","15976276153237418429","deep","10"),
("279","279","15977107367315707822","deep","10"),
("280","280","15978146535881166635","deep","10"),
("281","281","15979193371973773768","deep","10"),
("282","282","15987724694500626456","deep","10"),
("283","283","15993821406348255525","deep","10"),
("284","284","16000573315713704624","deep","10"),
("285","285","16024719647514104407","deep","10"),
("286","286","16037692087326291167","deep","10"),
("287","287","16042957580800663547","deep","10"),
("288","288","16043349215080483354","deep","10"),
("289","289","16049004220908287341","deep","10"),
("290","290","16055460005932789144","deep","10"),
("291","291","16064633941190325897","deep","10"),
("292","292","16067053840861058055","deep","10"),
("293","293","16076067771445042463","deep","10"),
("294","294","16080294096353956030","deep","10"),
("295","295","16084265198959228939","deep","10"),
("296","296","16092991882596180490","deep","10"),
("297","297","16094422685441459110","deep","10"),
("298","298","16103449205107546779","deep","10"),
("299","299","16112088338641558337","deep","10"),
("300","300","16117073431648083537","deep","10"),
("301","301","16131222277344838198","deep","10"),
("302","302","16139284589466303786","deep","10"),
("303","303","16154422536283479281","deep","10"),
("304","304","16154957333712037180","deep","10"),
("305","305","16156840309732855943","deep","10"),
("306","306","16157924624188397794","deep","10"),
("307","307","16162547509227053405","deep","10"),
("308","308","16178647244189153124","deep","10"),
("309","309","16181284887800591222","deep","10"),
("310","310","16186247209157705869","deep","10"),
("311","311","16195253472214541957","deep","10"),
("312","312","16201862218431252964","deep","10"),
("313","313","16204442122775537467","deep","10"),
("314","314","16205870799399460591","deep","10"),
("315","315","16206967707232072999","deep","10"),
("316","316","16211917439507084385","deep","10"),
("317","317","16219017963483625749","deep","10"),
("318","318","16235571993547653811","deep","10"),
("319","319","16236878973498856543","deep","10"),
("320","320","16237255896770184889","deep","10"),
("321","321","16237695476568654475","deep","10"),
("322","322","16249461905252578992","deep","10"),
("323","323","16254474298349698914","deep","10"),
("324","324","16262057426088404702","deep","10"),
("325","325","16269692747493503965","deep","10"),
("326","326","16278555847401601961","deep","10"),
("327","327","16284615076591329016","deep","10"),
("328","328","16287238000604341061","deep","10"),
("329","329","16292677388712794604","deep","10"),
("330","330","16302853009877888156","deep","10"),
("331","331","16303856822006800451","deep","10"),
("332","332","16304298528026625533","deep","10"),
("333","333","16312576457867441565","deep","10"),
("334","334","16326118051565025975","deep","10"),
("335","335","16345749309333929017","deep","10"),
("336","336","16375442835954973917","deep","10"),
("337","337","16393948580627276976","deep","10"),
("338","338","16409847417468452304","deep","10"),
("339","339","16411883346091545679","deep","10"),
("340","340","16420999546376896133","deep","10"),
("341","341","16422538155934366327","deep","10"),
("342","342","16427658360038645119","deep","10"),
("343","343","16436232706529192645","deep","10"),
("344","344","16444307612027728790","deep","10"),
("345","345","16446242781714941028","deep","10"),
("346","346","16451312914079214545","deep","10"),
("347","347","16467919142104603378","deep","10"),
("348","348","16469455629735685372","deep","10"),
("349","349","16471473427970882662","deep","10"),
("350","350","16471970747036505843","deep","10"),
("351","351","16477143149102145406","deep","10"),
("352","352","16508965695755016498","deep","10"),
("353","353","16556811731781036041","deep","10"),
("354","354","16560393322032877343","deep","10"),
("355","355","16573415833585069378","deep","10"),
("356","356","16573511055510124987","deep","10"),
("357","357","16579780356818442366","deep","10"),
("358","358","16587552094494688074","deep","10"),
("359","359","16591118969443070619","deep","10"),
("360","360","16617448645458012861","deep","10"),
("361","361","16623997526186214777","deep","10"),
("362","362","16628932547452734702","deep","10"),
("363","363","16634212756230565839","deep","10"),
("364","364","16640099391664637288","deep","10"),
("365","365","16647039906672659011","deep","10"),
("366","366","16659341137080108723","deep","10"),
("367","367","16670839750083322025","deep","10"),
("368","368","16687993368914339314","deep","10"),
("369","369","16692111887111061307","deep","10"),
("370","370","16699160213126241900","deep","10"),
("371","371","16720967147582539081","deep","10"),
("372","372","16721371370944462149","deep","10"),
("373","373","16730500160311915864","deep","10"),
("374","374","16730595377942004177","deep","10"),
("375","375","16744671773363113782","deep","10"),
("376","376","16779638456690712086","deep","10"),
("377","377","16789583749127963733","deep","10"),
("378","378","16793652195584680451","deep","10"),
("379","379","16822022726072638305","deep","10"),
("380","380","16840664882721120513","deep","10"),
("381","381","16844233883890858554","deep","10"),
("382","382","16868972756681937127","deep","10"),
("383","383","16872446540221586855","deep","10"),
("384","384","16878383243100696283","deep","10"),
("385","385","16883988177188494995","deep","10"),
("386","386","16911369610850999311","deep","10"),
("387","387","16921866542241623110","deep","10"),
("388","388","16935501227347940337","deep","10"),
("389","389","16939973901461547419","deep","10"),
("390","390","16964263396410685294","deep","10"),
("391","391","16972556041554960083","deep","10"),
("392","392","16979936140656418688","deep","10"),
("393","393","16996650175393999095","deep","10"),
("394","394","17001649983703983052","deep","10"),
("395","395","17006155883737813860","deep","10"),
("396","396","17018299235693066723","deep","10"),
("397","397","17033878884235100004","deep","10"),
("398","398","17051632087538139224","deep","10"),
("399","399","17057728799385768293","deep","10"),
("400","400","17070274248481588728","deep","10"),
("401","401","17084900156634714989","deep","10"),
("402","402","17089553476554962177","deep","10"),
("403","403","17090996868482344058","deep","10"),
("404","404","17122871617391543217","deep","10"),
("405","405","17140574748954577162","deep","10"),
("406","406","17146621389062200956","deep","10"),
("407","407","17162251109344239512","deep","10"),
("408","408","17185840880636312202","deep","10"),
("409","409","17233990080189654886","deep","10"),
("410","410","17256143507330656132","deep","10"),
("411","411","17270717217522421622","deep","10"),
("412","412","17281871472652220947","deep","10"),
("413","413","17316728223046272181","deep","10"),
("414","414","17329815521641928248","deep","10"),
("415","415","17366725046478854406","deep","10"),
("416","416","17426262930396830618","deep","10"),
("417","417","17462060832097685611","deep","10"),
("418","418","17491357802883955763","deep","10"),
("419","419","17518189719519476127","deep","10"),
("420","420","17529796143529848299","deep","10"),
("421","421","17535892855377477368","deep","10"),
("422","422","17604019801089459863","deep","10"),
("423","423","17604459385182896745","deep","10"),
("424","424","17640856875650740965","deep","10"),
("425","425","17641831257172735746","deep","10"),
("426","426","17651459487532200842","deep","10"),
("427","427","17784889255923510606","deep","10"),
("428","428","17791975060301625917","deep","10"),
("429","429","17809570389447435584","deep","10"),
("430","430","17926675631159629252","deep","10"),
("431","431","17943389665897209659","deep","10"),
("432","432","17950879697932215334","deep","10"),
("433","433","17965051310983413252","deep","10"),
("434","434","17966040407808866790","deep","10"),
("435","435","17968033316763232623","deep","10"),
("436","436","18082221339739070952","deep","10"),
("437","437","18084199533389978028","deep","10"),
("438","438","18332206837110557728","deep","10"),
("439","439","2596438163693575258","deep","10"),
("440","440","3283980738909860279","deep","10"),
("441","441","3462726710722910358","deep","10"),
("442","442","3679298845332760485","deep","10"),
("443","443","3962040377431741088","deep","10"),
("444","444","4107648854214850233","deep","10"),
("445","445","9560279963623141436","deep","10"),
("446","446","9839027625762405873","deep","10"),
("0","0","13226682056085141440","deep","11"),
("1","1","14241396025583592416","deep","11"),
("2","2","14299364994632844915","deep","11"),
("3","3","14588695506519784769","deep","11"),
("4","4","14700353692596376574","deep","11"),
("5","5","14867455757741152467","deep","11"),
("6","6","14871963783996338771","deep","11"),
("7","7","14880095934286561390","deep","11"),
("8","8","15245937303115854639","deep","11"),
("9","9","15295682365608288583","deep","11"),
("10","10","15410750042656533205","deep","11"),
("11","11","15461570412640256503","deep","11"),
("12","12","15607033600053272060","deep","11"),
("13","13","15679761667724140972","deep","11"),
("14","14","15750978425928134412","deep","11"),
("15","15","15761250900764171948","deep","11"),
("16","16","15772692268975698776","deep","11"),
("17","17","16039843974260306102","deep","11"),
("18","18","16042266000152393756","deep","11"),
("19","19","16132797342866307163","deep","11"),
("20","20","16225236166358034610","deep","11"),
("21","21","16253421518303200893","deep","11"),
("22","22","16385007378798427234","deep","11"),
("23","23","16493648206953620446","deep","11"),
("24","24","16551265636487843177","deep","11"),
("25","25","16567869738291876514","deep","11"),
("26","26","16714324148751701105","deep","11"),
("27","27","16997642497968260382","deep","11"),
("28","28","17592949278330065139","deep","11"),
("29","29","17593388862423502021","deep","11"),
("30","30","17936304961046546601","deep","11"),
("31","31","4234398141117420007","deep","11"),
("0","0","10703616045927434118","deep","12"),
("1","1","11660839167558270854","deep","12"),
("2","2","11774023378405196888","deep","12"),
("3","3","11871314590320491912","deep","12"),
("4","4","12004767130361212229","deep","12"),
("5","5","12009142456328408206","deep","12"),
("6","6","12037448199772902028","deep","12"),
("7","7","12115240858502251633","deep","12"),
("8","8","12135509183401078620","deep","12"),
("9","9","12192577095908317399","deep","12"),
("10","10","12382126878622470536","deep","12"),
("11","11","12404079102448861305","deep","12"),
("12","12","12563251551465194641","deep","12"),
("13","13","12563545846188537935","deep","12"),
("14","14","12628118506034241146","deep","12"),
("15","15","12634215213586902919","deep","12"),
("16","16","12726674682506685423","deep","12"),
("17","17","12732114066320171670","deep","12"),
("18","18","12832078282578418606","deep","12"),
("19","19","12848684510603807439","deep","12"),
("20","20","12871625831255651746","deep","12"),
("21","21","12879093095936214164","deep","12"),
("22","22","12882060386412574778","deep","12"),
("23","23","12945225010767442626","deep","12"),
("24","24","12967596177554182516","deep","12"),
("25","25","12999325632798320791","deep","12"),
("26","26","13104729232870053974","deep","12"),
("27","27","13141272012707991782","deep","12"),
("28","28","13244697419128817889","deep","12"),
("29","29","13267933034504005490","deep","12"),
("30","30","13301802814293958682","deep","12"),
("31","31","13322033656534883655","deep","12"),
("32","32","13507170630623938801","deep","12"),
("33","33","13537910989042623538","deep","12"),
("34","34","13579818191673210861","deep","12"),
("35","35","13582822964807473489","deep","12"),
("36","36","13675701372392637818","deep","12"),
("37","37","13747397319274358354","deep","12"),
("38","38","13762226256064731798","deep","12"),
("39","39","13830808375877945937","deep","12"),
("40","40","13837916072906168500","deep","12"),
("41","41","13901008737165891117","deep","12"),
("42","42","13927408251349590390","deep","12"),
("43","43","13999104198231310926","deep","12"),
("44","44","14049453926063758749","deep","12"),
("45","45","14104008843196565257","deep","12"),
("46","46","14135284007633742485","deep","12"),
("47","47","14136337887207692759","deep","12"),
("48","48","14170582464047618801","deep","12"),
("49","49","14178672084849613703","deep","12"),
("50","50","14281201485853719089","deep","12"),
("51","51","14291868884778642998","deep","12"),
("52","52","14326112586914233035","deep","12"),
("53","53","14331790355801512983","deep","12"),
("54","54","14342299876274240043","deep","12"),
("55","55","14348359105463967098","deep","12"),
("56","56","14353394756096030102","deep","12"),
("57","57","14356464311978789466","deep","12"),
("58","58","14371040152686877748","deep","12"),
("59","59","14379064986445408618","deep","12"),
("60","60","14392976786505473755","deep","12"),
("61","61","14425580354516225499","deep","12"),
("62","62","14443833007401210692","deep","12"),
("63","63","14453900817559145374","deep","12"),
("64","64","14455484087121166077","deep","12"),
("65","65","14490283592723530837","deep","12"),
("66","66","14534190881655132488","deep","12"),
("67","67","14542845605196938808","deep","12"),
("68","68","14564896762636574008","deep","12"),
("69","69","14575564157266530621","deep","12"),
("70","70","14628675686766922544","deep","12"),
("71","71","14639559999994655158","deep","12"),
("72","72","14655834454933765979","deep","12"),
("73","73","14657812648584673055","deep","12"),
("74","74","14660000918649137751","deep","12"),
("75","75","14671449459912345778","deep","12"),
("76","76","14685129299498680635","deep","12"),
("77","77","14690236910225888870","deep","12"),
("78","78","14733197996725393763","deep","12"),
("79","79","14741712482022399494","deep","12"),
("80","80","14770035066991707569","deep","12"),
("81","81","14776571358637806224","deep","12"),
("82","82","14779106242367378451","deep","12"),
("83","83","14785585289221790632","deep","12"),
("84","84","14795674992029832566","deep","12"),
("85","85","14795748321304780923","deep","12"),
("86","86","14815886067842005783","deep","12"),
("87","87","14837547712928209376","deep","12"),
("88","88","14873395690664036940","deep","12"),
("89","89","14924951764787177120","deep","12"),
("90","90","14927089963111636541","deep","12"),
("91","91","14958394549565796691","deep","12"),
("92","92","14969488943502054221","deep","12"),
("93","93","14982071875255776670","deep","12"),
("94","94","15007871800672486716","deep","12"),
("95","95","15011273624116991213","deep","12"),
("96","96","15011331359089177512","deep","12"),
("97","97","15012862305414466682","deep","12"),
("98","98","15042281793921419869","deep","12"),
("99","99","15054769508045054005","deep","12"),
("100","100","15065372119926513882","deep","12"),
("101","101","15066311145011962145","deep","12"),
("102","102","15073838659704869834","deep","12"),
("103","103","15074388176731853786","deep","12"),
("104","104","15078908792069143351","deep","12"),
("105","105","15081473981109969097","deep","12"),
("106","106","15084520769638285204","deep","12"),
("107","107","15092103897376990992","deep","12"),
("108","108","15106277636649544406","deep","12"),
("109","109","15113376034404730274","deep","12"),
("110","110","15120853477357632688","deep","12"),
("111","111","15146239875844415675","deep","12"),
("112","112","15151758891575162769","deep","12"),
("113","113","15153290328080951764","deep","12"),
("114","114","15162808625506869790","deep","12"),
("115","115","15170885652931794135","deep","12"),
("116","116","15172034754430800018","deep","12"),
("117","117","15172372068822870854","deep","12"),
("118","118","15209261337050545431","deep","12"),
("119","119","15220905243718819617","deep","12"),
("120","120","15230870784175388253","deep","12"),
("121","121","15244010280732405091","deep","12"),
("122","122","15262198142278958956","deep","12"),
("123","123","15262797731045948183","deep","12"),
("124","124","15273319836305811208","deep","12"),
("125","125","15274014642702888748","deep","12"),
("126","126","15308821325651902003","deep","12"),
("127","127","15314223231102453532","deep","12"),
("128","128","15328894289440630127","deep","12"),
("129","129","15338025200734472042","deep","12"),
("130","130","15340285095731651855","deep","12"),
("131","131","15341981583741318898","deep","12"),
("132","132","15355728332297505987","deep","12"),
("133","133","15368361335791233711","deep","12"),
("134","134","15382387659472338041","deep","12"),
("135","135","15383499278313441910","deep","12"),
("136","136","15386466568789802524","deep","12"),
("137","137","15392550691555328332","deep","12"),
("138","138","15399209505217077318","deep","12"),
("139","139","15452550538102381207","deep","12"),
("140","140","15469264572839961614","deep","12"),
("141","141","15474262254928590075","deep","12"),
("142","142","15479919382682782262","deep","12"),
("143","143","15480921068590339061","deep","12"),
("144","144","15510110228369450343","deep","12"),
("145","145","15521754135037724529","deep","12"),
("146","146","15530343196831730812","deep","12"),
("147","147","15536048270104572778","deep","12"),
("148","148","15536329971450845515","deep","12"),
("149","149","15564745652123853703","deep","12"),
("150","150","15575420228395426107","deep","12"),
("151","151","15598063792960434743","deep","12"),
("152","152","15612799634047108074","deep","12"),
("153","153","15628926677689737107","deep","12"),
("154","154","15629403740146108707","deep","12"),
("155","155","15638821894092016183","deep","12"),
("156","156","15643821698107032844","deep","12"),
("157","157","15650575733693837439","deep","12"),
("158","158","15664102612087963092","deep","12"),
("159","159","15668171058544679810","deep","12"),
("160","160","15672249967862144293","deep","12"),
("161","161","15673289136427603106","deep","12"),
("162","162","15675256867217762417","deep","12"),
("163","163","15678838457469603719","deep","12"),
("164","164","15679777482555051982","deep","12"),
("165","165","15686473778874702982","deep","12"),
("166","166","15692864781150708049","deep","12"),
("167","167","15695379898451528520","deep","12"),
("168","168","15714729454874158825","deep","12"),
("169","169","15731348271981650919","deep","12"),
("170","170","15739922618472198445","deep","12"),
("171","171","15742407305186394635","deep","12"),
("172","172","15743489493420580990","deep","12"),
("173","173","15752410332595832581","deep","12"),
("174","174","15758507040148494354","deep","12"),
("175","175","15762196441407494526","deep","12"),
("176","176","15770655313658702158","deep","12"),
("177","177","15781315664807315630","deep","12"),
("178","178","15798031825766251533","deep","12"),
("179","179","15807160610838737952","deep","12"),
("180","180","15811508632420371911","deep","12"),
("181","181","15820183122390929987","deep","12"),
("182","182","15821671664503362202","deep","12"),
("183","183","15822271253270351429","deep","12"),
("184","184","15835358547571040200","deep","12"),
("185","185","15854167890534690544","deep","12"),
("186","186","15855099738273490312","deep","12"),
("187","187","15867479641389965578","deep","12"),
("188","188","15869126061954594642","deep","12"),
("189","189","15872692936902977187","deep","12"),
("190","190","15885782361719988750","deep","12"),
("191","191","15899022617212886725","deep","12"),
("192","192","15907941325871815524","deep","12"),
("193","193","15922069919254285900","deep","12"),
("194","194","15932182879597270916","deep","12"),
("195","195","15953402818663649427","deep","12"),
("196","196","15968043442120234445","deep","12"),
("197","197","15988419573731253006","deep","12"),
("198","198","16013600152542156661","deep","12"),
("199","199","16015750939948719343","deep","12"),
("200","200","16023610227727905044","deep","12"),
("201","201","16023667962700091343","deep","12"),
("202","202","16072068433013082483","deep","12"),
("203","203","16080186362475313466","deep","12"),
("204","204","16105431724034713857","deep","12"),
("205","205","16127201175833109024","deep","12"),
("206","206","16143915214865656727","deep","12"),
("207","207","16162941342561777718","deep","12"),
("208","208","16164477830192859712","deep","12"),
("209","209","16183330063254899540","deep","12"),
("210","210","16194778608813074863","deep","12"),
("211","211","16205930737721518692","deep","12"),
("212","212","16211382710617108200","deep","12"),
("213","213","16215059522794005111","deep","12"),
("214","214","16220102350772716610","deep","12"),
("215","215","16220167137816180642","deep","12"),
("216","216","16231226171020924358","deep","12"),
("217","217","16233646070691656516","deep","12"),
("218","218","16233861688411006960","deep","12"),
("219","219","16248315002808477615","deep","12"),
("220","220","16273558238146522510","deep","12"),
("221","221","16275538558018785082","deep","12"),
("222","222","16281647858948517412","deep","12"),
("223","223","16282529144766812080","deep","12"),
("224","224","16283628178820779984","deep","12"),
("225","225","16287195053769162529","deep","12"),
("226","226","16296758497085163593","deep","12"),
("227","227","16300045796908628897","deep","12"),
("228","228","16305874693075546751","deep","12"),
("229","229","16308512336686984849","deep","12"),
("230","230","16328098444270837557","deep","12"),
("231","231","16345094184649657997","deep","12"),
("232","232","16347219793892014157","deep","12"),
("233","233","16348316697429659269","deep","12"),
("234","234","16356124612590414138","deep","12"),
("235","235","16380110939717261576","deep","12"),
("236","236","16401330878783640087","deep","12"),
("237","237","16413524302478898225","deep","12"),
("238","238","16413928525840821293","deep","12"),
("239","239","16416948014278542678","deep","12"),
("240","240","16440647714209195142","deep","12"),
("241","241","16459817009349021521","deep","12"),
("242","242","16462409502775409285","deep","12"),
("243","243","16463506406313054397","deep","12"),
("244","244","16471033921005962086","deep","12"),
("245","245","16488643961160263214","deep","12"),
("246","246","16490225594681428246","deep","12"),
("247","247","16494796281758723086","deep","12"),
("248","248","16515908414112910023","deep","12"),
("249","249","16526954858235550478","deep","12"),
("250","250","16549336487883038133","deep","12"),
("251","251","16569461649633127028","deep","12"),
("252","252","16571989356016050760","deep","12"),
("253","253","16584180649194986106","deep","12"),
("254","254","16597672175447532537","deep","12"),
("255","255","16602765075166249311","deep","12"),
("256","256","16613838823674451784","deep","12"),
("257","257","16630645954115732304","deep","12"),
("258","258","16654445797526395318","deep","12"),
("259","259","16657415214224111428","deep","12"),
("260","260","16661481534459472650","deep","12"),
("261","261","16662267602647679005","deep","12"),
("262","262","16662767047934657682","deep","12"),
("263","263","16667872532440510421","deep","12"),
("264","264","16669368122329253073","deep","12"),
("265","265","16675557925585614959","deep","12"),
("266","266","16691232796052703849","deep","12"),
("267","267","16691622308406135456","deep","12"),
("268","268","16697623798328708916","deep","12"),
("269","269","16700803291439982646","deep","12"),
("270","270","16713238803307288715","deep","12"),
("271","271","16728898958470918848","deep","12"),
("272","272","16755241227862931647","deep","12"),
("273","273","16771001522211605034","deep","12"),
("274","274","16771882812324866998","deep","12"),
("275","275","16778383747534419135","deep","12"),
("276","276","16788451557692353817","deep","12"),
("277","277","16798015005303322177","deep","12"),
("278","278","16810258496443618294","deep","12"),
("279","279","16816477730306897694","deep","12"),
("280","280","16824944270085253646","deep","12"),
("281","281","16836001177068641866","deep","12"),
("282","282","16847645083736916052","deep","12"),
("283","283","16868280149339764093","deep","12"),
("284","284","16901650488137705904","deep","12"),
("285","285","16916811198014357360","deep","12"),
("286","286","16918861841940909492","deep","12"),
("287","287","16941123075794102312","deep","12"),
("288","288","16949040098545474312","deep","12"),
("289","289","16965804205023059994","deep","12"),
("290","290","16979940465932678690","deep","12"),
("291","291","16999607075843160954","deep","12"),
("292","292","17020843856434353718","deep","12"),
("293","293","17025791466782976904","deep","12"),
("294","294","17027380148080452373","deep","12"),
("295","295","17052558600670000532","deep","12"),
("296","296","17056689703653858490","deep","12"),
("297","297","17081320765437778193","deep","12"),
("298","298","17083509035502242889","deep","12"),
("299","299","17107648319526332235","deep","12"),
("300","300","17107663034829790992","deep","12"),
("301","301","17107698391266337510","deep","12"),
("302","302","17111779422510190193","deep","12"),
("303","303","17116177520126796723","deep","12"),
("304","304","17156743596236400915","deep","12"),
("305","305","17163337627149653165","deep","12"),
("306","306","17207650014147513889","deep","12"),
("307","307","17219698144177711143","deep","12"),
("308","308","17221836342502170564","deep","12"),
("309","309","17241422450086023272","deep","12"),
("310","310","17266163444803490045","deep","12"),
("311","311","17269745035055331347","deep","12"),
("312","312","17276830843728413954","deep","12"),
("313","313","17300630687139076968","deep","12"),
("314","314","17301070266937546554","deep","12"),
("315","315","17306517322573148417","deep","12"),
("316","316","17312224522067345879","deep","12"),
("317","317","17322242260485275286","deep","12"),
("318","318","17330367237723816706","deep","12"),
("319","319","17330771461085739774","deep","12"),
("320","320","17346921267787844768","deep","12"),
("321","321","17383918347022678215","deep","12"),
("322","322","17386995570432585899","deep","12"),
("323","323","17394485602467591574","deep","12"),
("324","324","17409096795317259078","deep","12"),
("325","325","17523674330646529014","deep","12"),
("326","326","17526816341099900730","deep","12"),
("327","327","17644962873303941411","deep","12"),
("328","328","17695934078258518417","deep","12"),
("329","329","17841801489033457042","deep","12"),
("330","330","17872087552350213436","deep","12"),
("331","331","18004418290982522592","deep","12"),
("332","332","18014046521341987688","deep","12"),
("333","333","18246783182252368862","deep","12"),
("334","334","2506616411218779862","deep","12"),
("335","335","2875188024887744201","deep","12"),
("336","336","2915411324295800446","deep","12"),
("337","337","3099540774567754475","deep","12"),
("338","338","3493469268196499601","deep","12"),
("339","339","4433707823490158028","deep","12"),
("340","340","5500326321164737790","deep","12"),
("0","0","12558476813351716671","deep","13"),
("1","1","12588190592287045856","deep","13"),
("2","2","13000315829151226582","deep","13"),
("3","3","13088199069687921422","deep","13"),
("4","4","13388917382645224207","deep","13"),
("5","5","13777425548126737521","deep","13"),
("6","6","14197387305415660691","deep","13"),
("7","7","14243983180108074424","deep","13"),
("8","8","14361470756827051204","deep","13"),
("9","9","14541972591957777592","deep","13"),
("10","10","14774139969412423058","deep","13"),
("11","11","15071312052849398355","deep","13"),
("12","12","15153783205368234374","deep","13"),
("13","13","15316752037012829517","deep","13"),
("14","14","15366771627799854999","deep","13"),
("15","15","15375417934385547756","deep","13"),
("16","16","15415057243624344128","deep","13"),
("17","17","15425927666891547924","deep","13"),
("18","18","15469707378387238949","deep","13"),
("19","19","15540946908240642942","deep","13"),
("20","20","15823166227698201611","deep","13"),
("21","21","16089815692362230815","deep","13"),
("22","22","16092287785699356448","deep","13"),
("23","23","16246900014794110005","deep","13"),
("24","24","16302466796106813308","deep","13"),
("25","25","16354883519210127691","deep","13"),
("26","26","16608227941337794888","deep","13"),
("27","27","16622464341432456838","deep","13"),
("28","28","16683144279073128496","deep","13"),
("29","29","16850028600277198449","deep","13"),
("30","30","16928968234284198441","deep","13"),
("31","31","17392348503670584406","deep","13"),
("0","0","11490170300298661426","deep","14"),
("1","1","11569903670021016093","deep","14"),
("2","2","11590590933585224905","deep","14"),
("3","3","11691581725031860097","deep","14"),
("4","4","11750665313847907966","deep","14"),
("5","5","11873332465684205508","deep","14"),
("6","6","12013225690922132691","deep","14"),
("7","7","12204002946945598475","deep","14"),
("8","8","12209148044625676020","deep","14"),
("9","9","12312535968388600113","deep","14"),
("10","10","12402065625194956721","deep","14"),
("11","11","12486211803542409379","deep","14"),
("12","12","12499394324063121055","deep","14"),
("13","13","12510104742656772506","deep","14"),
("14","14","12618932054528150142","deep","14"),
("15","15","12745298785895787852","deep","14"),
("16","16","12773691694919385487","deep","14"),
("17","17","12837882898757608887","deep","14"),
("18","18","12843284804208160416","deep","14"),
("19","19","12901379296198754747","deep","14"),
("20","20","12925452788904705998","deep","14"),
("21","21","13001343508162034387","deep","14"),
("22","22","13097388815481401889","deep","14"),
("23","23","13123059045830780405","deep","14"),
("24","24","13170606538985712958","deep","14"),
("25","25","13267935233558909996","deep","14"),
("26","26","13371028866893458091","deep","14"),
("27","27","13409149324413601433","deep","14"),
("28","28","13428096779400696870","deep","14"),
("29","29","13446643722714058061","deep","14"),
("30","30","13447376007474070319","deep","14"),
("31","31","13482072757489536504","deep","14"),
("32","32","13539634573977961136","deep","14"),
("33","33","13542031706294250037","deep","14"),
("34","34","13559170609821808569","deep","14"),
("35","35","13622335234176676417","deep","14"),
("36","36","13670771551106713900","deep","14"),
("37","37","13731069153740602446","deep","14"),
("38","38","13777808982660972886","deep","14"),
("39","39","13796668393069661209","deep","14"),
("40","40","13818639043887699557","deep","14"),
("41","41","13856465215274434197","deep","14"),
("42","42","13887862897432294460","deep","14"),
("43","43","13940555483972337262","deep","14"),
("44","44","13978838076682355741","deep","14"),
("45","45","13985886398402569038","deep","14"),
("46","46","13994915918994348208","deep","14"),
("47","47","14062103839620882440","deep","14"),
("48","48","14081844540142832727","deep","14"),
("49","49","14088835617071359550","deep","14"),
("50","50","14150373587290350090","deep","14"),
("51","51","14165621467041072655","deep","14"),
("52","52","14204436730958293537","deep","14"),
("53","53","14222726862206213448","deep","14"),
("54","54","14231828342893137849","deep","14"),
("55","55","14291988194113743069","deep","14"),
("56","56","14316047850515538864","deep","14"),
("57","57","14351454117936574050","deep","14"),
("58","58","14478079783296041240","deep","14"),
("59","59","14497935828486993363","deep","14"),
("60","60","14508443222738364927","deep","14"),
("61","61","14524103377901995060","deep","14"),
("62","62","14538716696973018060","deep","14"),
("63","63","14601843838669983894","deep","14"),
("64","64","14617460969869919189","deep","14"),
("65","65","14635214177467925705","deep","14"),
("66","66","14641280579709333959","deep","14"),
("67","67","14681664762790245850","deep","14"),
("68","68","14687124403212983678","deep","14"),
("69","69","14696790116230350788","deep","14"),
("70","70","14721579056466467340","deep","14"),
("71","71","14722033351568395683","deep","14"),
("72","72","14745233610507036766","deep","14"),
("73","73","14748368083003598220","deep","14"),
("74","74","14770903840856415282","deep","14"),
("75","75","14777562654518164268","deep","14"),
("76","76","14778047384501684188","deep","14"),
("77","77","14783609294625788062","deep","14"),
("78","78","14802851040041259497","deep","14"),
("79","79","14820995881919085820","deep","14"),
("80","80","14829083372204757930","deep","14"),
("81","81","14836169180877840537","deep","14"),
("82","82","14837000399251097226","deep","14"),
("83","83","14840569400420835267","deep","14"),
("84","84","14864477050543689855","deep","14"),
("85","85","14869424660892313041","deep","14"),
("86","86","14870478540466263315","deep","14"),
("87","87","14871028057493247267","deep","14"),
("88","88","14877564349139345922","deep","14"),
("89","89","14919456836466474488","deep","14"),
("90","90","14930500279663423442","deep","14"),
("91","91","14930515869671218204","deep","14"),
("92","92","14948753807252744640","deep","14"),
("93","93","14949779507736796891","deep","14"),
("94","94","14972900139053144423","deep","14"),
("95","95","14988118583901982178","deep","14"),
("96","96","15005821719759983419","deep","14"),
("97","97","15006847420244035670","deep","14"),
("98","98","15011383629884087293","deep","14"),
("99","99","15013963534228371796","deep","14"),
("100","100","15041416597118558525","deep","14"),
("101","101","15052191802755674008","deep","14"),
("102","102","15057688925836313850","deep","14"),
("103","103","15059372829058844928","deep","14"),
("104","104","15059374955280200424","deep","14"),
("105","105","15072302244907336850","deep","14"),
("106","106","15073998737211971189","deep","14"),
("107","107","15074894742628691910","deep","14"),
("108","108","15086046867242168443","deep","14"),
("109","109","15096064609955065146","deep","14"),
("110","110","15098094997272365697","deep","14"),
("111","111","15120356231125558517","deep","14"),
("112","112","15128106536589497849","deep","14"),
("113","113","15144118591878319517","deep","14"),
("114","114","15149653197616861373","deep","14"),
("115","115","15150057425273751737","deep","14"),
("116","116","15152193497376855662","deep","14"),
("117","117","15155258131704660085","deep","14"),
("118","118","15166769333789976648","deep","14"),
("119","119","15177973660659781248","deep","14"),
("120","120","15178470979725404429","deep","14"),
("121","121","15185463692694786923","deep","14"),
("122","122","15186158499091864463","deep","14"),
("123","123","15201736021412542248","deep","14"),
("124","124","15209690526821816262","deep","14"),
("125","125","15213771562360636241","deep","14"),
("126","126","15225523275741102001","deep","14"),
("127","127","15228237470135177453","deep","14"),
("128","128","15234002404601561214","deep","14"),
("129","129","15242092025403556116","deep","14"),
("130","130","15249784591600341853","deep","14"),
("131","131","15269300865310404826","deep","14"),
("132","132","15272977673192334441","deep","14"),
("133","133","15278964452106416440","deep","14"),
("134","134","15279463897393395117","deep","14"),
("135","135","15285854895374432888","deep","14"),
("136","136","15297498802042707074","deep","14"),
("137","137","15313773256981817895","deep","14"),
("138","138","15316255817474658589","deep","14"),
("139","139","15324988046712370260","deep","14"),
("140","140","15341154690644322211","deep","14"),
("141","141","15348642600752939686","deep","14"),
("142","142","15352638592639044052","deep","14"),
("143","143","15355728405131054997","deep","14"),
("144","144","15356451816792120112","deep","14"),
("145","145","15361247420861802091","deep","14"),
("146","146","15370291656757040018","deep","14"),
("147","147","15374357976992401240","deep","14"),
("148","148","15388998600448986258","deep","14"),
("149","149","15408572118950735705","deep","14"),
("150","150","15432921479388382671","deep","14"),
("151","151","15436879992911552319","deep","14"),
("152","152","15443524091269842548","deep","14"),
("153","153","15456561318125493340","deep","14"),
("154","154","15466227031142860450","deep","14"),
("155","155","15468313031505959100","deep","14"),
("156","156","15479869383776325997","deep","14"),
("157","157","15510661940156371505","deep","14"),
("158","158","15514070940947524497","deep","14"),
("159","159","15516598647330448229","deep","14"),
("160","160","15553703533277473250","deep","14"),
("161","161","15554085373808789241","deep","14"),
("162","162","15555681726928380326","deep","14"),
("163","163","15560789337655588561","deep","14"),
("164","164","15581756180639681910","deep","14"),
("165","165","15586474283308425834","deep","14"),
("166","166","15592129284841262525","deep","14"),
("167","167","15597076895189885711","deep","14"),
("168","168","15620131860463465910","deep","14"),
("169","169","15625397353937838290","deep","14"),
("170","170","15633768676086105929","deep","14"),
("171","171","15638934026080467759","deep","14"),
("172","172","15655588199624506371","deep","14"),
("173","173","15676262874106611922","deep","14"),
("174","174","15695554691262088632","deep","14"),
("175","175","15704726500298269889","deep","14"),
("176","176","15707645845255980724","deep","14"),
("177","177","15711162652759325290","deep","14"),
("178","178","15719194529999199301","deep","14"),
("179","179","15742944305964824336","deep","14"),
("180","180","15744972567060769391","deep","14"),
("181","181","15755150314447218439","deep","14"),
("182","182","15765659834919945499","deep","14"),
("183","183","15768737058329853183","deep","14"),
("184","184","15773295156325044762","deep","14"),
("185","185","15784409798280619281","deep","14"),
("186","186","15786332383180695554","deep","14"),
("187","187","15790396577194701280","deep","14"),
("188","188","15794357216939226424","deep","14"),
("189","189","15799512773185084438","deep","14"),
("190","190","15801051387037521928","deep","14"),
("191","191","15803435930271707568","deep","14"),
("192","192","15829921362812458459","deep","14"),
("193","193","15839976583888289880","deep","14"),
("194","194","15905857524563621380","deep","14"),
("195","195","15912661631890431250","deep","14"),
("196","196","15915578850626786589","deep","14"),
("197","197","15916178435098808520","deep","14"),
("198","198","15920641315463911786","deep","14"),
("199","199","15929120444324370999","deep","14"),
("200","200","15929323468666650886","deep","14"),
("201","201","15936314059709645180","deep","14"),
("202","202","15943401990309115987","deep","14"),
("203","203","15947373092914388896","deep","14"),
("204","204","15960113903120308194","deep","14"),
("205","205","15969022148918489228","deep","14"),
("206","206","15972149444068402187","deep","14"),
("207","207","15991795412845796690","deep","14"),
("208","208","16006970838025906903","deep","14"),
("209","209","16021300333824268966","deep","14"),
("210","210","16024111867774820931","deep","14"),
("211","211","16026102650507831268","deep","14"),
("212","212","16039177360021384074","deep","14"),
("213","213","16059957719289292999","deep","14"),
("214","214","16060399425309118081","deep","14"),
("215","215","16062203724325943994","deep","14"),
("216","216","16079251658371157909","deep","14"),
("217","217","16098455925423694626","deep","14"),
("218","218","16099480374390727386","deep","14"),
("219","219","16119005951668794350","deep","14"),
("220","220","16120998856328192887","deep","14"),
("221","221","16125102659221456123","deep","14"),
("222","222","16140680185837101204","deep","14"),
("223","223","16144848771478861176","deep","14"),
("224","224","16149918903843134693","deep","14"),
("225","225","16154477001838326272","deep","14"),
("226","226","16155401315915283074","deep","14"),
("227","227","16164482155469119714","deep","14"),
("228","228","16164986522311053332","deep","14"),
("229","229","16172167548614224252","deep","14"),
("230","230","16184228267726524767","deep","14"),
("231","231","16192680092201421962","deep","14"),
("232","232","16194818290525881383","deep","14"),
("233","233","16207428526665165850","deep","14"),
("234","234","16209394131233969665","deep","14"),
("235","235","16213415301284280553","deep","14"),
("236","236","16225998233038003002","deep","14"),
("237","237","16231163583032364832","deep","14"),
("238","238","16231617878134293175","deep","14"),
("239","239","16234183071470086217","deep","14"),
("240","240","16238703686807375782","deep","14"),
("241","241","16267061628213230375","deep","14"),
("242","242","16275648568080848458","deep","14"),
("243","243","16279325375962778073","deep","14"),
("244","244","16281100540976437966","deep","14"),
("245","245","16285206470091056698","deep","14"),
("246","246","16286143368955149465","deep","14"),
("247","247","16299780184577789484","deep","14"),
("248","248","16304837727859959740","deep","14"),
("249","249","16305292022961888083","deep","14"),
("250","250","16310449705429101593","deep","14"),
("251","251","16314970325061358454","deep","14"),
("252","252","16320907027940467882","deep","14"),
("253","253","16323248254902174486","deep","14"),
("254","254","16372522967552117153","deep","14"),
("255","255","16373722136496161015","deep","14"),
("256","256","16387244097630299023","deep","14"),
("257","257","16400735619587878158","deep","14"),
("258","258","16416164140850273533","deep","14"),
("259","259","16427612686408448856","deep","14"),
("260","260","16429987440189097976","deep","14"),
("261","261","16439364399788914616","deep","14"),
("262","262","16450365698021472033","deep","14"),
("263","263","16465331046788024626","deep","14"),
("264","264","16474555049490599358","deep","14"),
("265","265","16482592472331233489","deep","14"),
("266","266","16483633767118047798","deep","14"),
("267","267","16542839877949745998","deep","14"),
("268","268","16543171651036024010","deep","14"),
("269","269","16547202614834838714","deep","14"),
("270","270","16556424495611025246","deep","14"),
("271","271","16573472429656239161","deep","14"),
("272","272","16585518433465080919","deep","14"),
("273","273","16590084198987420818","deep","14"),
("274","274","16610902040913231757","deep","14"),
("275","275","16617905216743362016","deep","14"),
("276","276","16621411557090991521","deep","14"),
("277","277","16622011145857980748","deep","14"),
("278","278","16646712531696190011","deep","14"),
("279","279","16666496126611497078","deep","14"),
("280","280","16674413149362869078","deep","14"),
("281","281","16698225581855635353","deep","14"),
("282","282","16708338542198620369","deep","14"),
("283","283","16727362547968353160","deep","14"),
("284","284","16751164517600371670","deep","14"),
("285","285","16784540393409139009","deep","14"),
("286","286","16799608011877057648","deep","14"),
("287","287","16800647180442516461","deep","14"),
("288","288","16828902852147005008","deep","14"),
("289","289","16837541985681016566","deep","14"),
("290","290","16855137314826826233","deep","14"),
("291","291","16861833611146477233","deep","14"),
("292","292","16881369646990324666","deep","14"),
("293","293","16891627896703403270","deep","14"),
("294","294","16893071288630785151","deep","14"),
("295","295","16906803321883513483","deep","14"),
("296","296","16984498636761419279","deep","14"),
("297","297","17020736122555711154","deep","14"),
("298","298","17028386159264269174","deep","14"),
("299","299","17028760952019274728","deep","14"),
("300","300","17033037348668193570","deep","14"),
("301","301","17049043992221560472","deep","14"),
("302","302","17051621770344489479","deep","14"),
("303","303","17068350524680495939","deep","14"),
("304","304","17152122910252649810","deep","14"),
("305","305","17176766561118672774","deep","14"),
("306","306","17202609385223706896","deep","14"),
("307","307","17212664606299538317","deep","14"),
("308","308","17215242384422467324","deep","14"),
("309","309","17279348160084138931","deep","14"),
("310","310","17283369334429417115","deep","14"),
("311","311","17299579002325063904","deep","14"),
("312","312","17361659312224389901","deep","14"),
("313","313","17362258896696411832","deep","14"),
("314","314","17431764451587279472","deep","14"),
("315","315","17444507388014554266","deep","14"),
("316","316","17448918070418296761","deep","14"),
("317","317","17463054327032948161","deep","14"),
("318","318","17470739720178052699","deep","14"),
("319","319","17485850362609666176","deep","14"),
("320","320","17539950984640544341","deep","14"),
("321","321","17556555086444577678","deep","14"),
("322","322","17557104603471561630","deep","14"),
("323","323","17568176225758408607","deep","14"),
("324","324","17687311859082870122","deep","14"),
("325","325","17716658897314178253","deep","14"),
("326","326","17719626187790538867","deep","14"),
("327","327","17772737712995963494","deep","14"),
("328","328","17816610520195354632","deep","14"),
("329","329","17944787388489362573","deep","14"),
("330","330","2227870948134419931","deep","14"),
("331","331","2813709502810311937","deep","14"),
("332","332","2975191918563830361","deep","14"),
("333","333","3092457164949576374","deep","14"),
("334","334","3115416912593068260","deep","14"),
("335","335","3209027609233212143","deep","14"),
("336","336","3214723805112139670","deep","14"),
("337","337","3903655993122579771","deep","14"),
("338","338","4402969664126377797","deep","14"),
("0","0","4800115444347608419","deep","141"),
("1","1","4900117138968790073","deep","141"),
("2","2","5000118833589971727","deep","141"),
("3","3","5100120528211153381","deep","141"),
("4","4","5200122222832335035","deep","141"),
("5","5","5300123917453516689","deep","141"),
("0","0","10503435637060225373","deep","143"),
("1","1","2543570752288624229","deep","143"),
("2","2","2815927416446850895","deep","143"),
("3","3","3560156448162894884","deep","143"),
("4","4","3593293943192835818","deep","143"),
("5","5","3693295637814017472","deep","143"),
("6","6","3732511417699939896","deep","143"),
("7","7","3761862167619436849","deep","143"),
("8","8","3770337584791707240","deep","143"),
("9","9","3808163751883474584","deep","143"),
("10","10","3924734191872143057","deep","143"),
("11","11","4209872860582379857","deep","143"),
("12","12","9460103448432018851","deep","143"),
("0","0","2365520690695071239","deep","144"),
("1","1","2458436576643170286","deep","144"),
("2","2","2908844401922402195","deep","144"),
("3","3","3986216016826899376","deep","144"),
("0","0","10210518556629700228","deep","145"),
("1","1","10338863477353277718","deep","145"),
("2","2","10717612838408691105","deep","145"),
("3","3","2975014898938984924","deep","145"),
("4","4","3138894447008792249","deep","145"),
("5","5","3215241587589404477","deep","145"),
("6","6","3508160867074834128","deep","145"),
("7","7","3570336394604248438","deep","145"),
("8","8","3590899009931451423","deep","145"),
("9","9","3593990948644817864","deep","145"),
("10","10","3679821030214801600","deep","145"),
("11","11","3731124003960689322","deep","145"),
("12","12","3753076232082047387","deep","145"),
("13","13","3809868276857590451","deep","145"),
("14","14","3964959694630071104","deep","145"),
("15","15","4014560342456747465","deep","145"),
("16","16","4031129087824234284","deep","145"),
("17","17","4062564256934963857","deep","145"),
("18","18","4088615943291822184","deep","145"),
("19","19","5200146412436284601","deep","145"),
("20","20","5600153190921011217","deep","145"),
("21","21","9845940812920452055","deep","145"),
("22","22","9938856698868551102","deep","145"),
("0","0","2151347883161447223","deep","146"),
("1","1","3476726797491556808","deep","146"),
("0","0","11958933751114562504","deep","147"),
("1","1","12681905365401293264","deep","147"),
("2","2","12844120065914823946","deep","147"),
("3","3","13037951782288721453","deep","147"),
("4","4","13139436477716542498","deep","147"),
("5","5","13142109477764527114","deep","147"),
("6","6","13170176840430194531","deep","147"),
("7","7","13199177390271765893","deep","147"),
("8","8","13273840627629847043","deep","147"),
("9","9","13675217963242474304","deep","147"),
("10","10","13832287570370894737","deep","147"),
("11","11","13918155134598780487","deep","147"),
("12","12","13960394110315645822","deep","147"),
("13","13","14026518847800225789","deep","147"),
("14","14","14070117130999992685","deep","147"),
("15","15","14376932155804924539","deep","147"),
("16","16","14452218239464937998","deep","147"),
("17","17","14601702592633297147","deep","147"),
("18","18","14648999111632332738","deep","147"),
("19","19","14709361501309685316","deep","147"),
("20","20","14814707856589732025","deep","147"),
("21","21","14838053404898466696","deep","147"),
("22","22","14907673814277836347","deep","147"),
("23","23","14925312163092373556","deep","147"),
("24","24","14993049600745891740","deep","147"),
("25","25","15001514014302892196","deep","147"),
("26","26","15008562336023105493","deep","147"),
("27","27","15008679321027930296","deep","147"),
("28","28","15015163414712668180","deep","147"),
("29","29","15173116438175706073","deep","147"),
("30","30","15214662437113097870","deep","147"),
("31","31","15248047491214498438","deep","147"),
("32","32","15282146778684330892","deep","147"),
("33","33","15323157975898197494","deep","147"),
("34","34","15354989700843701815","deep","147"),
("35","35","15442733189021128595","deep","147"),
("36","36","15455488714530506650","deep","147"),
("37","37","15456479937577315684","deep","147"),
("38","38","15488354686486514843","deep","147"),
("39","39","15491431909896422527","deep","147"),
("40","40","15526728244383910643","deep","147"),
("41","41","15544619985884484508","deep","147"),
("42","42","15556089997918677531","deep","147"),
("43","43","15629164553979283212","deep","147"),
("44","44","15631049651926490175","deep","147"),
("45","45","15641262755749485741","deep","147"),
("46","46","15737097986655295623","deep","147"),
("47","47","15776021057284708079","deep","147"),
("48","48","15824406816589207758","deep","147"),
("49","49","15867506144682495802","deep","147"),
("50","50","15884711957179906566","deep","147"),
("51","51","15953935810724501469","deep","147"),
("52","52","15993792369428536660","deep","147"),
("53","53","16008649911482897679","deep","147"),
("54","54","16030087590195014834","deep","147"),
("55","55","16123827031284189546","deep","147"),
("56","56","16126514742340665623","deep","147"),
("57","57","16132559256226933921","deep","147"),
("58","58","16134429643165649423","deep","147"),
("59","59","16207664203899807449","deep","147"),
("60","60","16316317621137103922","deep","147"),
("61","61","16317401935592645773","deep","147"),
("62","62","16318832738437924393","deep","147"),
("63","63","16337966677141204254","deep","147"),
("64","64","16373385533644342701","deep","147"),
("65","65","16375913240027266433","deep","147"),
("66","66","16490636064726629957","deep","147"),
("67","67","16496537415464160163","deep","147"),
("68","68","16496587487204165438","deep","147"),
("69","69","16512189903100641976","deep","147"),
("70","70","16537980529244315327","deep","147"),
("71","71","16593020180655609051","deep","147"),
("72","72","16610665577246456697","deep","147"),
("73","73","16691483261424353215","deep","147"),
("74","74","16696885166874904744","deep","147"),
("75","75","16697030456244998332","deep","147"),
("76","76","16816678123938541785","deep","147"),
("77","77","16830849736989739703","deep","147"),
("78","78","16841359257462466763","deep","147"),
("79","79","17044798947586577785","deep","147"),
("80","80","17081131651010957973","deep","147"),
("81","81","17082720332308433442","deep","147"),
("82","82","17137714833534676832","deep","147"),
("83","83","17297422084274535363","deep","147"),
("84","84","17382702648817535147","deep","147"),
("85","85","17409911493019351153","deep","147"),
("86","86","17586064967111046172","deep","147"),
("87","87","17730162134427279845","deep","147"),
("88","88","17863873604164862346","deep","147"),
("89","89","3323009603423866989","deep","147"),
("0","0","11398472231592157973","deep","148"),
("1","1","11666747860211564660","deep","148"),
("2","2","11943392680462916194","deep","148"),
("3","3","12335287075086171947","deep","148"),
("4","4","12641113003065650263","deep","148"),
("5","5","12762372119411112442","deep","148"),
("6","6","12863362910857747634","deep","148"),
("7","7","12910634536280984472","deep","148"),
("8","8","12947471610842265574","deep","148"),
("9","9","13046521691295895704","deep","148"),
("10","10","13055291398896542093","deep","148"),
("11","11","13065725954053465125","deep","148"),
("12","12","13084347858387663048","deep","148"),
("13","13","13141083997808623815","deep","148"),
("14","14","13158641840001564172","deep","148"),
("15","15","13435286664547883002","deep","148"),
("16","16","13566066200245651407","deep","148"),
("17","17","13580656756257198446","deep","148"),
("18","18","13671795350970282104","deep","148"),
("19","19","13675624165131152926","deep","148"),
("20","20","13722089465756931828","deep","148"),
("21","21","13731335361109613812","deep","148"),
("22","22","13785158868186744067","deep","148"),
("23","23","13800890987740486727","deep","148"),
("24","24","13868430938062550552","deep","148"),
("25","25","13952852979846731629","deep","148"),
("26","26","14008816811469676801","deep","148"),
("27","27","14070992338999091111","deep","148"),
("28","28","14123524046161245563","deep","148"),
("29","29","14136011760284879699","deep","148"),
("30","30","14187108488180798537","deep","148"),
("31","31","14231580879852211606","deep","148"),
("32","32","14341122764549418538","deep","148"),
("33","33","14500700315926978243","deep","148"),
("34","34","14514349716336754227","deep","148"),
("35","35","14550292911702670104","deep","148"),
("36","36","14551576298956499640","deep","148"),
("37","37","14583033356422369169","deep","148"),
("38","38","14595154815727514780","deep","148"),
("39","39","14607800404008378469","deep","148"),
("40","40","14648104210038031566","deep","148"),
("41","41","14679898452325633873","deep","148"),
("42","42","14694569510663810468","deep","148"),
("43","43","14763627818229060202","deep","148"),
("44","44","14774390434784072424","deep","148"),
("45","45","14778846267372865253","deep","148"),
("46","46","14795486972835497303","deep","148"),
("47","47","14830858762819289272","deep","148"),
("48","48","14904655425367567215","deep","148"),
("49","49","14906231521877906719","deep","148"),
("50","50","14907624842065283325","deep","148"),
("51","51","14925927562395306497","deep","148"),
("52","52","15010486020450634019","deep","148"),
("53","53","15035274960686750571","deep","148"),
("54","54","15052096806431489848","deep","148"),
("55","55","15060628128958342536","deep","148"),
("56","56","15094777488168180265","deep","148"),
("57","57","15095327005195164217","deep","148"),
("58","58","15108117882846121494","deep","148"),
("59","59","15145064890340949666","deep","148"),
("60","60","15177798157714000236","deep","148"),
("61","61","15186957377668078232","deep","148"),
("62","62","15191867505358799404","deep","148"),
("63","63","15241887091850857590","deep","148"),
("64","64","15288352396771603788","deep","148"),
("65","65","15291211876240805532","deep","148"),
("66","66","15345030796925410960","deep","148"),
("67","67","15395989412797884705","deep","148"),
("68","68","15406496802754288973","deep","148"),
("69","69","15483644731121533609","deep","148"),
("70","70","15484289465778605874","deep","148"),
("71","71","15493757691464518625","deep","148"),
("72","72","15508990851616815137","deep","148"),
("73","73","15544766374782030349","deep","148"),
("74","74","15550983482423954253","deep","148"),
("75","75","15555983286438970914","deep","148"),
("76","76","15563531057741130184","deep","148"),
("77","77","15583154647982884906","deep","148"),
("78","78","15610631299275477535","deep","148"),
("79","79","15644622780033118415","deep","148"),
("80","80","15655290178958042324","deep","148"),
("81","81","15680296858839897520","deep","148"),
("82","82","15699820305601641692","deep","148"),
("83","83","15726639637450026091","deep","148"),
("84","84","15728619957322288663","deep","148"),
("85","85","15730502933343107426","deep","148"),
("86","86","15746270895218929133","deep","148"),
("87","87","15777517746700902984","deep","148"),
("88","88","15797841684645528070","deep","148"),
("89","89","15817966842100649669","deep","148"),
("90","90","15834628683171836601","deep","148"),
("91","91","15875930760024609169","deep","148"),
("92","92","15881463239541795529","deep","148"),
("93","93","15913864738123535383","deep","148"),
("94","94","15918262831445174617","deep","148"),
("95","95","15935122155552848612","deep","148"),
("96","96","15946743294866679541","deep","148"),
("97","97","15947170285583045866","deep","148"),
("98","98","15958335003573592956","deep","148"),
("99","99","15958337129794948452","deep","148"),
("100","100","15978567972035873425","deep","148"),
("101","101","15990211878704147611","deep","148"),
("102","102","16006216396036159017","deep","148"),
("103","103","16016286332415449195","deep","148"),
("104","104","16021659632602013149","deep","148"),
("105","105","16026903659600367829","deep","148"),
("106","106","16040685760298134140","deep","148"),
("107","107","16063351217513250028","deep","148"),
("108","108","16079450956770317043","deep","148"),
("109","109","16101175262678629172","deep","148"),
("110","110","16108370999990291553","deep","148"),
("111","111","16139098773621840325","deep","148"),
("112","112","16139550942502413172","deep","148"),
("113","113","16182984169903334724","deep","148"),
("114","114","16195629762479165709","deep","148"),
("115","115","16207823181879456551","deep","148"),
("116","116","16214431923801200262","deep","148"),
("117","117","16226907048842731137","deep","148"),
("118","118","16236533152980840737","deep","148"),
("119","119","16261923803910334716","deep","148"),
("120","120","16305744417443332379","deep","148"),
("121","121","16331414643497743599","deep","148"),
("122","122","16362207204172756403","deep","148"),
("123","123","16377892533205625762","deep","148"),
("124","124","16385369976158528176","deep","148"),
("125","125","16451618871699614145","deep","148"),
("126","126","16465738291084418588","deep","148"),
("127","127","16480474136466059215","deep","148"),
("128","128","16509611098283809726","deep","148"),
("129","129","16518742009577651641","deep","148"),
("130","130","16547047757317112759","deep","148"),
("131","131","16566693726094507262","deep","148"),
("132","132","16570250138182142042","deep","148"),
("133","133","16598128890910269539","deep","148"),
("134","134","16601590085367816006","deep","148"),
("135","135","16656235971982967131","deep","148"),
("136","136","16659047510228486392","deep","148"),
("137","137","16675212032234050143","deep","148"),
("138","138","16732894244516769610","deep","148"),
("139","139","16740419632988321803","deep","148"),
("140","140","16753002564742044252","deep","148"),
("141","141","16767246632363854522","deep","148"),
("142","142","16771255213332062149","deep","148"),
("143","143","16786430638512172362","deep","148"),
("144","144","16803144677544720065","deep","148"),
("145","145","16849435258193487865","deep","148"),
("146","146","16852916709260285913","deep","148"),
("147","147","16915047086604649889","deep","148"),
("148","148","16926186626430990457","deep","148"),
("149","149","16937403538087931022","deep","148"),
("150","150","16939838153062121937","deep","148"),
("151","151","16962049315175309482","deep","148"),
("152","152","16968196094467976530","deep","148"),
("153","153","17031308520861483607","deep","148"),
("154","154","17051446271693675763","deep","148"),
("155","155","17072104104650967061","deep","148"),
("156","156","17148415888795032771","deep","148"),
("157","157","17163603903057246245","deep","148"),
("158","158","17223481227588648789","deep","148"),
("159","159","17333256446234356423","deep","148"),
("160","160","17352829964736105870","deep","148"),
("161","161","17382191718270872758","deep","148"),
("162","162","17475107604218971805","deep","148"),
("163","163","17651273667392770085","deep","148"),
("164","164","17672935312478973678","deep","148"),
("165","165","17834123437804116104","deep","148"),
("166","166","17873892446405211302","deep","148"),
("167","167","2196245565069417885","deep","148"),
("168","168","2234766538558262769","deep","148"),
("169","169","3972032304678759379","deep","148"),
("0","0","10896346711124799105","deep","149"),
("1","1","11502174605272132048","deep","149"),
("2","2","11850440411384367386","deep","149"),
("3","3","11966754043602561875","deep","149"),
("4","4","11993375888119491915","deep","149"),
("5","5","11998483503141667446","deep","149"),
("6","6","12016003862676705789","deep","149"),
("7","7","12034625767010903712","deep","149"),
("8","8","12124536884119707427","deep","149"),
("9","9","12344771115602995708","deep","149"),
("10","10","12357258825431662548","deep","149"),
("11","11","12444810292882079376","deep","149"),
("12","12","12493108497788671766","deep","149"),
("13","13","12495086691439578842","deep","149"),
("14","14","12599206899962515193","deep","149"),
("15","15","12600890803185046271","deep","149"),
("16","16","12631887973669172288","deep","149"),
("17","17","12685331271960874927","deep","149"),
("18","18","12807942518442590172","deep","149"),
("19","19","12824843036896355003","deep","149"),
("20","20","12846519401580984649","deep","149"),
("21","21","12904244637827398954","deep","149"),
("22","22","12921839962678241325","deep","149"),
("23","23","12931893057532717250","deep","149"),
("24","24","12993042005578776008","deep","149"),
("25","25","13047142631904621469","deep","149"),
("26","26","13160364325409449517","deep","149"),
("27","27","13291068900086381190","deep","149"),
("28","28","13302530030431692478","deep","149"),
("29","29","13321390319839684102","deep","149"),
("30","30","13403595787194131698","deep","149"),
("31","31","13484355736399841917","deep","149"),
("32","32","13570843141709001179","deep","149"),
("33","33","13574799529010815331","deep","149"),
("34","34","13578918042912570028","deep","149"),
("35","35","13604969733564395651","deep","149"),
("36","36","13705998003373965561","deep","149"),
("37","37","13723079662109837619","deep","149"),
("38","38","13794723415325164680","deep","149"),
("39","39","13836702578050897234","deep","149"),
("40","40","13844814966207335393","deep","149"),
("41","41","13857997482433079773","deep","149"),
("42","42","13887748748321278268","deep","149"),
("43","43","13910376722878492142","deep","149"),
("44","44","13925537432755143598","deep","149"),
("45","45","13961458735470952223","deep","149"),
("46","46","14004976512049122267","deep","149"),
("47","47","14023560933725418176","deep","149"),
("48","48","14040642588166322938","deep","149"),
("49","49","14041242176933312165","deep","149"),
("50","50","14058345724024324179","deep","149"),
("51","51","14101848785299035466","deep","149"),
("52","52","14115031301524779846","deep","149"),
("53","53","14137001956637785490","deep","149"),
("54","54","14140254774729040281","deep","149"),
("55","55","14141082987881638173","deep","149"),
("56","56","14148783975329504769","deep","149"),
("57","57","14191068096936453142","deep","149"),
("58","58","14194794980853355328","deep","149"),
("59","59","14251870070707242602","deep","149"),
("60","60","14273539253750256457","deep","149"),
("61","61","14291082380639738057","deep","149"),
("62","62","14295186183533001293","deep","149"),
("63","63","14330007581785473305","deep","149"),
("64","64","14347183088971630550","deep","149"),
("65","65","14359808915118709779","deep","149"),
("66","66","14363313133539951084","deep","149"),
("67","67","14386693159285928972","deep","149"),
("68","68","14400169970235016646","deep","149"),
("69","69","14409763718862271229","deep","149"),
("70","70","14411916632490189407","deep","149"),
("71","71","14428520734294222744","deep","149"),
("72","72","14443191792632399339","deep","149"),
("73","73","14496647680006205239","deep","149"),
("74","74","14507092413435468267","deep","149"),
("75","75","14514885617587731675","deep","149"),
("76","76","14515889425421676674","deep","149"),
("77","77","14566465706287367307","deep","149"),
("78","78","14578915937753099429","deep","149"),
("79","79","14586971076822883818","deep","149"),
("80","80","14607266701812305527","deep","149"),
("81","81","14635032236092786684","deep","149"),
("82","82","14636014155571591727","deep","149"),
("83","83","14639091378981499411","deep","149"),
("84","84","14642660380151237452","deep","149"),
("85","85","14644038989330122597","deep","149"),
("86","86","14663172928033402458","deep","149"),
("87","87","14671797346263955259","deep","149"),
("88","88","14676382748644708856","deep","149"),
("89","89","14677928535548827545","deep","149"),
("90","90","14685946191960709920","deep","149"),
("91","91","14703137293449629223","deep","149"),
("92","92","14703649323523743865","deep","149"),
("93","93","14710735132196826472","deep","149"),
("94","94","14713365108281116250","deep","149"),
("95","95","14775490564070525285","deep","149"),
("96","96","14788527790926176077","deep","149"),
("97","97","14814767300436323005","deep","149"),
("98","98","14817129955315368689","deep","149"),
("99","99","14835272670971839516","deep","149"),
("100","100","14845595703433414856","deep","149"),
("101","101","14883369676858788725","deep","149"),
("102","102","14895028294535554372","deep","149"),
("103","103","14897173670206662288","deep","149"),
("104","104","14917679040742178799","deep","149"),
("105","105","14928845880659114089","deep","149"),
("106","106","14928883363317016103","deep","149"),
("107","107","14929287586678939171","deep","149"),
("108","108","14933389263350846911","deep","149"),
("109","109","14948861105180688618","deep","149"),
("110","110","14950103302383394614","deep","149"),
("111","111","14954076526915055723","deep","149"),
("112","112","14956214725239515144","deep","149"),
("113","113","14967148235502917028","deep","149"),
("114","114","14973244947350546097","deep","149"),
("115","115","14981285371116871729","deep","149"),
("116","116","14994372669712527796","deep","149"),
("117","117","14994495191728178127","deep","149"),
("118","118","14996021212203545060","deep","149"),
("119","119","15004000900071992892","deep","149"),
("120","120","15022238833358552032","deep","149"),
("121","121","15023192573747459052","deep","149"),
("122","122","15029244135410037787","deep","149"),
("123","123","15039796675551492389","deep","149"),
("124","124","15044073072200411231","deep","149"),
("125","125","15066176423306439906","deep","149"),
("126","126","15090523657522731376","deep","149"),
("127","127","15095473394092710058","deep","149"),
("128","128","15102507004804431894","deep","149"),
("129","129","15104060329665360845","deep","149"),
("130","130","15116708048462547326","deep","149"),
("131","131","15124782949666116175","deep","149"),
("132","132","15137270663789750311","deep","149"),
("133","133","15144486167530164448","deep","149"),
("134","134","15146052960472499961","deep","149"),
("135","135","15146444594752319768","deep","149"),
("136","136","15152980886398418423","deep","149"),
("137","137","15154629433184402983","deep","149"),
("138","138","15154923723612778981","deep","149"),
("139","139","15164039923898129435","deep","149"),
("140","140","15169110051967435656","deep","149"),
("141","141","15169267934714599801","deep","149"),
("142","142","15181301349441338298","deep","149"),
("143","143","15211212615708121842","deep","149"),
("144","144","15225520645030466205","deep","149"),
("145","145","15225678523482663054","deep","149"),
("146","146","15234412874646762925","deep","149"),
("147","147","15235012463413752152","deep","149"),
("148","148","15238825683271860916","deep","149"),
("149","149","15241403461394789923","deep","149"),
("150","150","15243491592274211365","deep","149"),
("151","151","15260190911708333015","deep","149"),
("152","152","15267131431011322034","deep","149"),
("153","153","15273777655590967759","deep","149"),
("154","154","15276145357300339146","deep","149"),
("155","155","15282199045184273377","deep","149"),
("156","156","15299020890929012654","deep","149"),
("157","157","15304959724324444874","deep","149"),
("158","158","15313634214295002950","deep","149"),
("159","159","15318090042588828483","deep","149"),
("160","160","15332224177277091683","deep","149"),
("161","161","15338825251671687074","deep","149"),
("162","162","15345313597799135950","deep","149"),
("163","163","15350983318930398694","deep","149"),
("164","164","15357077900261704971","deep","149"),
("165","165","15358496118319847626","deep","149"),
("166","166","15371545934257601679","deep","149"),
("167","167","15378069636821597073","deep","149"),
("168","168","15383847160370084095","deep","149"),
("169","169","15387256156866269791","deep","149"),
("170","170","15387416161539822136","deep","149"),
("171","171","15388259968995182086","deep","149"),
("172","172","15392378487191904079","deep","149"),
("173","173","15393757096370789224","deep","149"),
("174","174","15397823416606150446","deep","149"),
("175","175","15465104428641417495","deep","149"),
("176","176","15466989530883591754","deep","149"),
("177","177","15471158116525351726","deep","149"),
("178","178","15472097141610799989","deep","149"),
("179","179","15486123465291904319","deep","149"),
("180","180","15488651175969795347","deep","149"),
("181","181","15517023832679108697","deep","149"),
("182","182","15533015760929016842","deep","149"),
("183","183","15549837606673756119","deep","149"),
("184","184","15550387119405772775","deep","149"),
("185","185","15552257506344488277","deep","149"),
("186","186","15567980322330226946","deep","149"),
("187","187","15573255115077636021","deep","149"),
("188","188","15574091745186347476","deep","149"),
("189","189","15577111233624068861","deep","149"),
("190","190","15580136259072615774","deep","149"),
("191","191","15592676166862643385","deep","149"),
("192","192","15593318775298360154","deep","149"),
("193","193","15597292004124988559","deep","149"),
("194","194","15604363097494612409","deep","149"),
("195","195","15612560520713831589","deep","149"),
("196","196","15617572918105918807","deep","149"),
("197","197","15620529745721531656","deep","149"),
("198","198","15621518842546985194","deep","149"),
("199","199","15633297856018045676","deep","149"),
("200","200","15648958011181675809","deep","149"),
("201","201","15670120215275868021","deep","149"),
("202","202","15688654565212158655","deep","149"),
("203","203","15689218793247634068","deep","149"),
("204","204","15691354865350737993","deep","149"),
("205","205","15700217965258835989","deep","149"),
("206","206","15714607322250739847","deep","149"),
("207","207","15727202843086565557","deep","149"),
("208","208","15733784280622747250","deep","149"),
("209","209","15746228970782686548","deep","149"),
("210","210","15753979280541593176","deep","149"),
("211","211","15760790096187316073","deep","149"),
("212","212","15770578331220333514","deep","149"),
("213","213","15794232885260902940","deep","149"),
("214","214","15819114916905752309","deep","149"),
("215","215","15820104013731205847","deep","149"),
("216","216","15826924137239900031","deep","149"),
("217","217","15828585268813020556","deep","149"),
("218","218","15838984856352200546","deep","149"),
("219","219","15841230861388851541","deep","149"),
("220","220","15846178467442507431","deep","149"),
("221","221","15866853146219580278","deep","149"),
("222","222","15867118831383968701","deep","149"),
("223","223","15868549634229247321","deep","149"),
("224","224","15870917340233586004","deep","149"),
("225","225","15872962442854345312","deep","149"),
("226","226","15884114571762789141","deep","149"),
("227","227","15897593504638265015","deep","149"),
("228","228","15909345218018730775","deep","149"),
("229","229","15909784802112167657","deep","149"),
("230","230","15922982033641370794","deep","149"),
("231","231","15924865005367222261","deep","149"),
("232","232","15936566647007682746","deep","149"),
("233","233","15946621872378481463","deep","149"),
("234","234","15962346810290608332","deep","149"),
("235","235","15976091432625439925","deep","149"),
("236","236","15976423205711717937","deep","149"),
("237","237","15978459138629778608","deep","149"),
("238","238","15982967164884964912","deep","149"),
("239","239","15992095949957451331","deep","149"),
("240","240","15995123101627353740","deep","149"),
("241","241","16000280788389534546","deep","149"),
("242","242","16003198007125889885","deep","149"),
("243","243","16012436725131923374","deep","149"),
("244","244","16019976828906934324","deep","149"),
("245","245","16020418534926759406","deep","149"),
("246","246","16022504539584825352","deep","149"),
("247","247","16030566851706290940","deep","149"),
("248","248","16038266960154854235","deep","149"),
("249","249","16043214570503477421","deep","149"),
("250","250","16049216060426050881","deep","149"),
("251","251","16060260378327335840","deep","149"),
("252","252","16061761509521871316","deep","149"),
("253","253","16064291342126150544","deep","149"),
("254","254","16071427222539238426","deep","149"),
("255","255","16077594258441157055","deep","149"),
("256","256","16083676254985327367","deep","149"),
("257","257","16089080286657234392","deep","149"),
("258","258","16090119450927725909","deep","149"),
("259","259","16098194356426262054","deep","149"),
("260","260","16098209071729720811","deep","149"),
("261","261","16100578899660447694","deep","149"),
("262","262","16102115387291529688","deep","149"),
("263","263","16107222998018737923","deep","149"),
("264","264","16111339389994104420","deep","149"),
("265","265","16143605773183123386","deep","149"),
("266","266","16153833592309577709","deep","149"),
("267","267","16154772617395025972","deep","149"),
("268","268","16158354207646867274","deep","149"),
("269","269","16160977135954846615","deep","149"),
("270","270","16170987211140594998","deep","149"),
("271","271","16177141657960410366","deep","149"),
("272","272","16193090562246623673","deep","149"),
("273","273","16197598588501809977","deep","149"),
("274","274","16198253786019630007","deep","149"),
("275","275","16205743818054635682","deep","149"),
("276","276","16210366703093291293","deep","149"),
("277","277","16214764796414930527","deep","149"),
("278","278","16216290821185264756","deep","149"),
("279","279","16230093178492282648","deep","149"),
("280","280","16231681864084725413","deep","149"),
("281","281","16234945566915850225","deep","149"),
("282","282","16235047836617216271","deep","149"),
("283","283","16245050864026654217","deep","149"),
("284","284","16256925099422770308","deep","149"),
("285","285","16271488351048755329","deep","149"),
("286","286","16273213444322409947","deep","149"),
("287","287","16273373448995962292","deep","149"),
("288","288","16275791222445338954","deep","149"),
("289","289","16277487714749973293","deep","149"),
("290","290","16283037035791973906","deep","149"),
("291","291","16289537971001526043","deep","149"),
("292","292","16293546551969733670","deep","149"),
("293","293","16301181877669800229","deep","149"),
("294","294","16301621457468269815","deep","149"),
("295","295","16304698680878177499","deep","149"),
("296","296","16321520526622916776","deep","149"),
("297","297","16326360325964381092","deep","149"),
("298","298","16326764553621271456","deep","149"),
("299","299","16329450138456392037","deep","149"),
("300","300","16330331428569654001","deep","149"),
("301","301","16334060434412944387","deep","149"),
("302","302","16338421045076681607","deep","149"),
("303","303","16345456782009758939","deep","149"),
("304","304","16356673693666699504","deep","149"),
("305","305","16361716521645411003","deep","149"),
("306","306","16366728919037498221","deep","149"),
("307","307","16379376633539717406","deep","149"),
("308","308","16392175183012790299","deep","149"),
("309","309","16392961251200996654","deep","149"),
("310","310","16393106540571090242","deep","149"),
("311","311","16407242797185741642","deep","149"),
("312","312","16413192093441921627","deep","149"),
("313","313","16419680439569370503","deep","149"),
("314","314","16460691641078204401","deep","149"),
("315","315","16473281620608237287","deep","149"),
("316","316","16480315231319959123","deep","149"),
("317","317","16485437557350626115","deep","149"),
("318","318","16490984752171271232","deep","149"),
("319","319","16511203005330092944","deep","149"),
("320","320","16518743109105103894","deep","149"),
("321","321","16523409013812487047","deep","149"),
("322","322","16523703308535830341","deep","149"),
("323","323","16536343975261739089","deep","149"),
("324","324","16540966860300394700","deep","149"),
("325","325","16544189373080395972","deep","149"),
("326","326","16545178469905849510","deep","149"),
("327","327","16552214206838926842","deep","149"),
("328","328","16558107890049308728","deep","149"),
("329","329","16560036011960210529","deep","149"),
("330","330","16566182791252877577","deep","149"),
("331","331","16567829211817506641","deep","149"),
("332","332","16572886755099676897","deep","149"),
("333","333","16574170142353506433","deep","149"),
("334","334","16579877341847703895","deep","149"),
("335","335","16601603773977371520","deep","149"),
("336","336","16602138575700896715","deep","149"),
("337","337","16604118895573159287","deep","149"),
("338","338","16606609119298181005","deep","149"),
("339","339","16608637384689093356","deep","149"),
("340","340","16609678679475907665","deep","149"),
("341","341","16620672925637187349","deep","149"),
("342","342","16622369417941821688","deep","149"),
("343","343","16635860939899400823","deep","149"),
("344","344","16640968554921576354","deep","149"),
("345","345","16644472769047850363","deep","149"),
("346","346","16661091590450309753","deep","149"),
("347","347","16664608393658687023","deep","149"),
("348","348","16666696520243141169","deep","149"),
("349","349","16675812716233524327","deep","149"),
("350","350","16690935947747241065","deep","149"),
("351","351","16707664697788280229","deep","149"),
("352","352","16725353118342822713","deep","149"),
("353","353","16738390345198473505","deep","149"),
("354","354","16745932570899872655","deep","149"),
("355","355","16752561958249671423","deep","149"),
("356","356","16755985670049315876","deep","149"),
("357","357","16782423157071416988","deep","149"),
("358","358","16789898473802963906","deep","149"),
("359","359","16802935700658614698","deep","149"),
("360","360","16807508513957265034","deep","149"),
("361","361","16812563931018079794","deep","149"),
("362","362","16815091637401003526","deep","149"),
("363","363","16833286551018835124","deep","149"),
("364","364","16847970198439114980","deep","149"),
("365","365","16866150396753487821","deep","149"),
("366","366","16891343560351527441","deep","149"),
("367","367","16927726335515912904","deep","149"),
("368","368","16954508184706395289","deep","149"),
("369","369","16958531480978061673","deep","149"),
("370","370","16958626702903117282","deep","149"),
("371","371","16984309518039631763","deep","149"),
("372","372","17004931998855343839","deep","149"),
("373","373","17021191738490995903","deep","149"),
("374","374","17029625721461372078","deep","149"),
("375","375","17032263360777842880","deep","149"),
("376","376","17051542588851216329","deep","149"),
("377","377","17066023207634249002","deep","149"),
("378","378","17106911887127432569","deep","149"),
("379","379","17108954863526836381","deep","149"),
("380","380","17114611995575995864","deep","149"),
("381","381","17122102027611001539","deep","149"),
("382","382","17124617144911822010","deep","149"),
("383","383","17132692050410358155","deep","149"),
("384","384","17133254152224478072","deep","149"),
("385","385","17147280475905582402","deep","149"),
("386","386","17159192193959600507","deep","149"),
("387","387","17169152197405343615","deep","149"),
("388","388","17174049736013961526","deep","149"),
("389","389","17198303878821520179","deep","149"),
("390","390","17209456003434996712","deep","149"),
("391","391","17219229523164555396","deep","149"),
("392","392","17230568135789183649","deep","149"),
("393","393","17268127316838137013","deep","149"),
("394","394","17268164799496039027","deep","149"),
("395","395","17288345569996958725","deep","149"),
("396","396","17322544996651834433","deep","149"),
("397","397","17328641708499463502","deep","149"),
("398","398","17331134058445840716","deep","149"),
("399","399","17389228550436435047","deep","149"),
("400","400","17415960332181879453","deep","149"),
("401","401","17419137694776830391","deep","149"),
("402","402","17450427570222499080","deep","149"),
("403","403","17482157029761604651","deep","149"),
("404","404","17488203669869228445","deep","149"),
("405","405","17498858475417081797","deep","149"),
("406","406","17502280060995370754","deep","149"),
("407","407","17507937193044530237","deep","149"),
("408","408","17513434316125170079","deep","149"),
("409","409","17517550708100536576","deep","149"),
("410","410","17578577134130945003","deep","149"),
("411","411","17579126646862961659","deep","149"),
("412","412","17758766493576409667","deep","149"),
("413","413","17774931015581973418","deep","149"),
("414","414","17794210243655346867","deep","149"),
("415","415","17802784594440861689","deep","149"),
("416","416","17819403411548353783","deep","149"),
("417","417","17919405106169535437","deep","149"),
("418","418","18092054361839989151","deep","149"),
("419","419","18139104535929298523","deep","149"),
("420","420","2774999414894646833","deep","149"),
("421","421","2846657879118465355","deep","149"),
("422","422","3501062963599776738","deep","149"),
("423","423","3583801106456394033","deep","149"),
("424","424","4227126516599873939","deep","149"),
("425","425","4238206190937705416","deep","149"),
("426","426","4333519213497060660","deep","149"),
("427","427","4619352684309407704","deep","149"),
("428","428","4912271959499870059","deep","149"),
("0","0","12021633464739431805","deep","15"),
("1","1","12604467250576028479","deep","15"),
("2","2","12707398753015668733","deep","15"),
("3","3","12965953055571910211","deep","15"),
("4","4","12966904669739461735","deep","15"),
("5","5","14436208157630149387","deep","15"),
("6","6","14509918144779823342","deep","15"),
("7","7","14606403036192627726","deep","15"),
("8","8","14712977630413474044","deep","15"),
("9","9","14803183912654989762","deep","15"),
("10","10","14955855426461770961","deep","15"),
("11","11","15107320103797359978","deep","15"),
("12","12","15146647402083662798","deep","15"),
("13","13","15171438468541134846","deep","15"),
("14","14","15309720625356012187","deep","15"),
("15","15","15536001496946924262","deep","15"),
("16","16","15689286489481223506","deep","15"),
("17","17","15781321085316060589","deep","15"),
("18","18","16046778424517389072","deep","15"),
("19","19","16074744731643423858","deep","15"),
("20","20","16110982217437715733","deep","15"),
("21","21","16141268280754472127","deep","15"),
("22","22","16175193673590223418","deep","15"),
("23","23","16177570553592228034","deep","15"),
("24","24","16228100048232012662","deep","15"),
("25","25","16330631579752440840","deep","15"),
("26","26","16583036972499692478","deep","15"),
("27","27","16618283235247175319","deep","15"),
("28","28","16710822202218913316","deep","15"),
("29","29","16818019638446724647","deep","15"),
("30","30","16861285193646945534","deep","15"),
("31","31","17435884069311453718","deep","15"),
("32","32","17835303852406261664","deep","15"),
("0","0","10024675785164012308","deep","150"),
("1","1","11766056947490573280","deep","150"),
("2","2","12177230570187202482","deep","150"),
("3","3","12278221361633837674","deep","150"),
("4","4","12320460337350703009","deep","150"),
("5","5","12416011740688884658","deep","150"),
("6","6","12456967329151920457","deep","150"),
("7","7","12482562594185494945","deep","150"),
("8","8","12507976016764399477","deep","150"),
("9","9","12520131953506788305","deep","150"),
("10","10","12563322543391205164","deep","150"),
("11","11","12610337361043968018","deep","150"),
("12","12","12661677821742725050","deep","150"),
("13","13","12667774529295386823","deep","150"),
("14","14","12806222232089609333","deep","150"),
("15","15","12941120290279067027","deep","150"),
("16","16","13077884089850758459","deep","150"),
("17","17","13110383316807778302","deep","150"),
("18","18","13173804748933120134","deep","150"),
("19","19","13196507688806138036","deep","150"),
("20","20","13209690209326849712","deep","150"),
("21","21","13334003781727776318","deep","150"),
("22","22","13384280175990308488","deep","150"),
("23","23","13427908764501328903","deep","150"),
("24","24","13513998654767478124","deep","150"),
("25","25","13553580689471889073","deep","150"),
("26","26","13630164871394223529","deep","150"),
("27","27","13651566707784261637","deep","150"),
("28","28","13669456323063480006","deep","150"),
("29","29","13692779104017771420","deep","150"),
("30","30","13938683565850438217","deep","150"),
("31","31","13991760613618619627","deep","150"),
("32","32","14006993287885383610","deep","150"),
("33","33","14044819454977150954","deep","150"),
("34","34","14083302945808093824","deep","150"),
("35","35","14103257920317323082","deep","150"),
("36","36","14161917519342696127","deep","150"),
("37","37","14177936751978166290","deep","150"),
("38","38","14182609834032197938","deep","150"),
("39","39","14183433875058806132","deep","150"),
("40","40","14198767178691113194","deep","150"),
("41","41","14202270518113051198","deep","150"),
("42","42","14241211309266581208","deep","150"),
("43","43","14263312538446221683","deep","150"),
("44","44","14372443018139889756","deep","150"),
("45","45","14381471659732365625","deep","150"),
("46","46","14386674492384629469","deep","150"),
("47","47","14407786624738816406","deep","150"),
("48","48","14412364489162759741","deep","150"),
("49","49","14498576901444559293","deep","150"),
("50","50","14541018905798671811","deep","150"),
("51","51","14583563179854150375","deep","150"),
("52","52","14606228637069266263","deep","150"),
("53","53","14615827436821813845","deep","150"),
("54","54","14639374184150191697","deep","150"),
("55","55","14645093968431525124","deep","150"),
("56","56","14665166932220253248","deep","150"),
("57","57","14665736215675988956","deep","150"),
("58","58","14693509283618313079","deep","150"),
("59","59","14700133619842818848","deep","150"),
("60","60","14846635971526325922","deep","150"),
("61","61","14861711257521392881","deep","150"),
("62","62","14867858036814059929","deep","150"),
("63","63","14889923909557153886","deep","150"),
("64","64","14893917775221902756","deep","150"),
("65","65","14981446475317876327","deep","150"),
("66","66","15018735714464762980","deep","150"),
("67","67","15030344264696490648","deep","150"),
("68","68","15054960611176951594","deep","150"),
("69","69","15074801945359412256","deep","150"),
("70","70","15100434688755921462","deep","150"),
("71","71","15119114332357272980","deep","150"),
("72","72","15150966313912028882","deep","150"),
("73","73","15151551183080592056","deep","150"),
("74","74","15162170636486866186","deep","150"),
("75","75","15164053608212717653","deep","150"),
("76","76","15166568729808505420","deep","150"),
("77","77","15192910999200518219","deep","150"),
("78","78","15196370063141741894","deep","150"),
("79","79","15217539934763082426","deep","150"),
("80","80","15258103884651331122","deep","150"),
("81","81","15262516693276429113","deep","150"),
("82","82","15285372590046688923","deep","150"),
("83","83","15338228892948472892","deep","150"),
("84","84","15366586834354327485","deep","150"),
("85","85","15371092734388158293","deep","150"),
("86","86","15389787093292968568","deep","150"),
("87","87","15394450871778996225","deep","150"),
("88","88","15428774950965845056","deep","150"),
("89","89","15429606169339101745","deep","150"),
("90","90","15452256911250758876","deep","150"),
("91","91","15464058696371229911","deep","150"),
("92","92","15471656535118427160","deep","150"),
("93","93","15475615048641596808","deep","150"),
("94","94","15484254182175608366","deep","150"),
("95","95","15485735056760892261","deep","150"),
("96","96","15513443341954719648","deep","150"),
("97","97","15524608055650299442","deep","150"),
("98","98","15564572425361493503","deep","150"),
("99","99","15570119620182138620","deep","150"),
("100","100","15574640235519428185","deep","150"),
("101","101","15582998968585592563","deep","150"),
("102","102","15619164825152202025","deep","150"),
("103","103","15643901567426957806","deep","150"),
("104","104","15647217472514410685","deep","150"),
("105","105","15653978681152896479","deep","150"),
("106","106","15669094735319964722","deep","150"),
("107","107","15693068473364708899","deep","150"),
("108","108","15730015476564569775","deep","150"),
("109","109","15739786874367740259","deep","150"),
("110","110","15838799472163468375","deep","150"),
("111","111","15849871094450315352","deep","150"),
("112","112","15850687597520113284","deep","150"),
("113","113","15855310482558768895","deep","150"),
("114","114","15864527437485033190","deep","150"),
("115","115","15868882506842977586","deep","150"),
("116","116","15875368731044038262","deep","150"),
("117","117","15877614736080689257","deep","150"),
("118","118","15884447444376519406","deep","150"),
("119","119","15885639569839220127","deep","150"),
("120","120","15907712486063657225","deep","150"),
("121","121","15908262003090641177","deep","150"),
("122","122","15919841122715451331","deep","150"),
("123","123","15932061846501304191","deep","150"),
("124","124","15946622971905933716","deep","150"),
("125","125","15951800910982398807","deep","150"),
("126","126","15958886719655481414","deep","150"),
("127","127","15972523530983154137","deep","150"),
("128","128","15972805232329426874","deep","150"),
("129","129","15976973822266154142","deep","150"),
("130","130","15985452951126613355","deep","150"),
("131","131","15989519271361974577","deep","150"),
("132","132","15990666246639624964","deep","150"),
("133","133","15994734693096341682","deep","150"),
("134","134","16005244209274101446","deep","150"),
("135","135","16005337304977801559","deep","150"),
("136","136","16025525123255031694","deep","150"),
("137","137","16047686213628213964","deep","150"),
("138","138","16058338897249679116","deep","150"),
("139","139","16092662976436527947","deep","150"),
("140","140","16096764653108435687","deep","150"),
("141","141","16100687805900091521","deep","150"),
("142","142","16102153969476883955","deep","150"),
("143","143","16132135564092924355","deep","150"),
("144","144","16145707588377133046","deep","150"),
("145","145","16171832113828439905","deep","150"),
("146","146","16172381630855423857","deep","150"),
("147","147","16173076437252501397","deep","150"),
("148","148","16192504666384157256","deep","150"),
("149","149","16250064356651226392","deep","150"),
("150","150","16259253002917254606","deep","150"),
("151","151","16261326418493217291","deep","150"),
("152","152","16294536748322639461","deep","150"),
("153","153","16319875205585739965","deep","150"),
("154","154","16322844622283456075","deep","150"),
("155","155","16326376140795292102","deep","150"),
("156","156","16375367025877606536","deep","150"),
("157","157","16387668251990088952","deep","150"),
("158","158","16396734380535434131","deep","150"),
("159","159","16412753613170904294","deep","150"),
("160","160","16418250736251544136","deep","150"),
("161","161","16468282911825705583","deep","150"),
("162","162","16471505428900674151","deep","150"),
("163","163","16484996950858253286","deep","150"),
("164","164","16494060948887275673","deep","150"),
("165","165","16495543949693915064","deep","150"),
("166","166","16503626522719599529","deep","150"),
("167","167","16533427856052836003","deep","150"),
("168","168","16545526057823038532","deep","150"),
("169","169","16607209807592622485","deep","150"),
("170","170","16642508264006498801","deep","150"),
("171","171","16676215917196511448","deep","150"),
("172","172","16697533200114333768","deep","150"),
("173","173","16719649140302465704","deep","150"),
("174","174","16758062307079119014","deep","150"),
("175","175","16765065482909249273","deep","150"),
("176","176","16766099729919753145","deep","150"),
("177","177","16770722614958408756","deep","150"),
("178","178","16777194119561043379","deep","150"),
("179","179","16785333807808076260","deep","150"),
("180","180","16789364771606890964","deep","150"),
("181","181","16821789033248106779","deep","150"),
("182","182","16853958072585681936","deep","150"),
("183","183","16883856754065329515","deep","150"),
("184","184","16893922438001908701","deep","150"),
("185","185","16928781318912282727","deep","150"),
("186","186","16938894279255267743","deep","150"),
("187","187","16941753758724469487","deep","150"),
("188","188","16945430570901366398","deep","150"),
("189","189","16972654126111673865","deep","150"),
("190","190","16981732839444155009","deep","150"),
("191","191","16994877877306964671","deep","150"),
("192","192","17009649074830184520","deep","150"),
("193","193","17012473202157807042","deep","150"),
("194","194","17027206917023124877","deep","150"),
("195","195","17028732941793459106","deep","150"),
("196","196","17045351758900951200","deep","150"),
("197","197","17053521882029575658","deep","150"),
("198","198","17072228825721521898","deep","150"),
("199","199","17088270825711435318","deep","150"),
("200","200","17167564615635320399","deep","150"),
("201","201","17177082913061238425","deep","150"),
("202","202","17202970883056355585","deep","150"),
("203","203","17243312171743910696","deep","150"),
("204","204","17263607796733332405","deep","150"),
("205","205","17308469700758177081","deep","150"),
("206","206","17419088722564277369","deep","150"),
("207","207","17524542394376015827","deep","150"),
("208","208","17557466101304210319","deep","150"),
("209","209","17590199368677260889","deep","150"),
("210","210","17643200965244105742","deep","150"),
("211","211","17650236697882215778","deep","150"),
("212","212","17680622904678982722","deep","150"),
("213","213","17735712627830281721","deep","150"),
("214","214","17794161271442793845","deep","150"),
("215","215","17867443777695601650","deep","150"),
("216","216","18162760189497320202","deep","150"),
("217","217","18314320084462997532","deep","150"),
("218","218","2299341397458870486","deep","150"),
("219","219","2723002729984166528","deep","150"),
("220","220","3856158870142072952","deep","150"),
("221","221","9760099736075945789","deep","150"),
("222","222","9931759899215913261","deep","150"),
("0","0","10510513744746174913","deep","151"),
("1","1","11132910384260994675","deep","151"),
("2","2","11492380517243034613","deep","151"),
("3","3","11556534234128388703","deep","151"),
("4","4","11752581240363905155","deep","151"),
("5","5","11786288889258950506","deep","151"),
("6","6","11807965249648612856","deep","151"),
("7","7","12130179369403989867","deep","151"),
("8","8","12208266322856682766","deep","151"),
("9","9","12228240353032166459","deep","151"),
("10","10","12252589713469813425","deep","151"),
("11","11","12280200654812197003","deep","151"),
("12","12","12313375628205072655","deep","151"),
("13","13","12370406062349376716","deep","151"),
("14","14","12432581589878791026","deep","151"),
("15","15","12460686430907393161","deep","151"),
("16","16","12489724467701833833","deep","151"),
("17","17","12520464826120518570","deep","151"),
("18","18","12528207958532776703","deep","151"),
("19","19","12601187292668326775","deep","151"),
("20","20","12674529664409643671","deep","151"),
("21","21","12674823954838019669","deep","151"),
("22","22","12755289613615353890","deep","151"),
("23","23","12761348842805080945","deep","151"),
("24","24","12763327032161020725","deep","151"),
("25","25","12794104877532574772","deep","151"),
("26","26","12805566012172853356","deep","151"),
("27","27","12829915368315533026","deep","151"),
("28","28","12853845790087798167","deep","151"),
("29","29","12868473824462279924","deep","151"),
("30","30","12897492801295498865","deep","151"),
("31","31","13111667803589060091","deep","151"),
("32","32","13119410936001318224","deep","151"),
("33","33","13120400032826771762","deep","151"),
("34","34","13127904780165236194","deep","151"),
("35","35","13135284874971727503","deep","151"),
("36","36","13169393044130441692","deep","151"),
("37","37","13171170335365457081","deep","151"),
("38","38","13196471305675688275","deep","151"),
("39","39","13243104667320971318","deep","151"),
("40","40","13247517475946069309","deep","151"),
("41","41","13270145450503283183","deep","151"),
("42","42","13309693003475483619","deep","151"),
("43","43","13327945652065501516","deep","151"),
("44","44","13388399793714482734","deep","151"),
("45","45","13401544827282325100","deep","151"),
("46","46","13403560503591134190","deep","151"),
("47","47","13414727347803036776","deep","151"),
("48","48","13416743019816878570","deep","151"),
("49","49","13442832188831638911","deep","151"),
("50","50","13446494285705077065","deep","151"),
("51","51","13468170646094739415","deep","151"),
("52","52","13494498200183293457","deep","151"),
("53","53","13532324367275060801","deep","151"),
("54","54","13541388365304083188","deep","151"),
("55","55","13554570885824794864","deep","151"),
("56","56","13556016403973532241","deep","151"),
("57","57","13608634025197771015","deep","151"),
("58","58","13635330835030505083","deep","151"),
("59","59","13641058286838986830","deep","151"),
("60","60","13708015878737679157","deep","151"),
("61","61","13714075107927406212","deep","151"),
("62","62","13756933924725545059","deep","151"),
("63","63","13770536258615974565","deep","151"),
("64","64","13775261538631366984","deep","151"),
("65","65","13790384765850116426","deep","151"),
("66","66","13816712319938670468","deep","151"),
("67","67","13845474489001415425","deep","151"),
("68","68","13852321908305737035","deep","151"),
("69","69","13892199598323359812","deep","151"),
("70","70","13895781188575201114","deep","151"),
("71","71","13940253584541581479","deep","151"),
("72","72","14005967807929480311","deep","151"),
("73","73","14016001136355204480","deep","151"),
("74","74","14055949911763636483","deep","151"),
("75","75","14071934666961863429","deep","151"),
("76","76","14083028177603850362","deep","151"),
("77","77","14120141115601859883","deep","151"),
("78","78","14128634959765777853","deep","151"),
("79","79","14154283297465049117","deep","151"),
("80","80","14217397850079911690","deep","151"),
("81","81","14233287848085851199","deep","151"),
("82","82","14277485251024871854","deep","151"),
("83","83","14287567776486265293","deep","151"),
("84","84","14294768569218187969","deep","151"),
("85","85","14329020684014924273","deep","151"),
("86","86","14341126058836808001","deep","151"),
("87","87","14348211867509890608","deep","151"),
("88","88","14348594202516673720","deep","151"),
("89","89","14353260107224056873","deep","151"),
("90","90","14396583401691431355","deep","151"),
("91","91","14396743406364983700","deep","151"),
("92","92","14401141499686622934","deep","151"),
("93","93","14419408863580099588","deep","151"),
("94","94","14419870336028676426","deep","151"),
("95","95","14428018566507193632","deep","151"),
("96","96","14472445812288523663","deep","151"),
("97","97","14477465872912791905","deep","151"),
("98","98","14497199396088093697","deep","151"),
("99","99","14514837744902630906","deep","151"),
("100","100","14528034976431834043","deep","151"),
("101","101","14533986394614402228","deep","151"),
("102","102","14536014660005314579","deep","151"),
("103","103","14549159693573156945","deep","151"),
("104","104","14552274399640966643","deep","151"),
("105","105","14583469057456547019","deep","151"),
("106","106","14592028692938603084","deep","151"),
("107","107","14612216511215833219","deep","151"),
("108","108","14616882415923216372","deep","151"),
("109","109","14618862735795478944","deep","151"),
("110","110","14656089318415224357","deep","151"),
("111","111","14657186221952869469","deep","151"),
("112","112","14663759121552534133","deep","151"),
("113","113","14671814260622318522","deep","151"),
("114","114","14703543715866456797","deep","151"),
("115","115","14726923745907401981","deep","151"),
("116","116","14730970299714011447","deep","151"),
("117","117","14752037281883148050","deep","151"),
("118","118","14762187724884035080","deep","151"),
("119","119","14767762224090242215","deep","151"),
("120","120","14776871372304314936","deep","151"),
("121","121","14777910536574806453","deep","151"),
("122","122","14786007334723449850","deep","151"),
("123","123","14811193320974840975","deep","151"),
("124","124","14827842572963924646","deep","151"),
("125","125","14829483452222760886","deep","151"),
("126","126","14845647974228324637","deep","151"),
("127","127","14848175684906215665","deep","151"),
("128","128","14863690550699752210","deep","151"),
("129","129","14870226842345850865","deep","151"),
("130","130","14873808432597692167","deep","151"),
("131","131","14889960365521152657","deep","151"),
("132","132","14895457488601792499","deep","151"),
("133","133","14906696292908840316","deep","151"),
("134","134","14910632913781902712","deep","151"),
("135","135","14913672654533908382","deep","151"),
("136","136","14926797435787466463","deep","151"),
("137","137","14927894339325111575","deep","151"),
("138","138","14930826273364925671","deep","151"),
("139","139","14931917635596777959","deep","151"),
("140","140","14935384371360117250","deep","151"),
("141","141","14935933888387101202","deep","151"),
("142","142","14939003444269860566","deep","151"),
("143","143","14942470180033199857","deep","151"),
("144","144","14943069764505221788","deep","151"),
("145","145","14957046016446320843","deep","151"),
("146","146","14972663151941223434","deep","151"),
("147","147","14976794254925081392","deep","151"),
("148","148","14977928641120628518","deep","151"),
("149","149","14986834764992421352","deep","151"),
("150","150","14997025097166006365","deep","151"),
("151","151","14998505971751290260","deep","151"),
("152","152","15002414413534454633","deep","151"),
("153","153","15003109219931532173","deep","151"),
("154","154","15005541708684367592","deep","151"),
("155","155","15012027928590460972","deep","151"),
("156","156","15021749254653626181","deep","151"),
("157","157","15022203549755554524","deep","151"),
("158","158","15026162063278724172","deep","151"),
("159","159","15034888746915675723","deep","151"),
("160","160","15036881655870041556","deep","151"),
("161","161","15042032290560944629","deep","151"),
("162","162","15045441291352097621","deep","151"),
("163","163","15048033784778485385","deep","151"),
("164","164","15059200624695420675","deep","151"),
("165","165","15060081914808682639","deep","151"),
("166","166","15096484456401819858","deep","151"),
("167","167","15098442883623975178","deep","151"),
("168","168","15098515333899620234","deep","151"),
("169","169","15098550690336166752","deep","151"),
("170","170","15100985305310357667","deep","151"),
("171","171","15103563083433286674","deep","151"),
("172","172","15105051625545718889","deep","151"),
("173","173","15107082017157986736","deep","151"),
("174","174","15107094606240089997","deep","151"),
("175","175","15118138924141374956","deep","151"),
("176","176","15123230944860788429","deep","151"),
("177","177","15124835220461025956","deep","151"),
("178","178","15143866889462939771","deep","151"),
("179","179","15151848699257775803","deep","151"),
("180","180","15156406797252967382","deep","151"),
("181","181","15157049405688684151","deep","151"),
("182","182","15161527001357246174","deep","151"),
("183","183","15164149929665225515","deep","151"),
("184","184","15164200001405230790","deep","151"),
("185","185","15171690033440236465","deep","151"),
("186","186","15197310192049609706","deep","151"),
("187","187","15201037071671544596","deep","151"),
("188","188","15201990812060451616","deep","151"),
("189","189","15220670451366835838","deep","151"),
("190","190","15222661234099846175","deep","151"),
("191","191","15235843754620557851","deep","151"),
("192","192","15242894202562126644","deep","151"),
("193","193","15249525716133280908","deep","151"),
("194","194","15254538109230400830","deep","151"),
("195","195","15257959694808689787","deep","151"),
("196","196","15265437137761592201","deep","151"),
("197","197","15268144615246820034","deep","151"),
("198","198","15271156926337892924","deep","151"),
("199","199","15273245052922347070","deep","151"),
("200","200","15298473577251900504","deep","151"),
("201","201","15298850496228261554","deep","151"),
("202","202","15303076821137175121","deep","151"),
("203","203","15313086896322923504","deep","151"),
("204","204","15329590858941913587","deep","151"),
("205","205","15330312965429585849","deep","151"),
("206","206","15352559483979319912","deep","151"),
("207","207","15376163966279884063","deep","151"),
("208","208","15378289575522240223","deep","151"),
("209","209","15387712655318069936","deep","151"),
("210","210","15387857944688163524","deep","151"),
("211","211","15388369974762278166","deep","151"),
("212","212","15395405711695355498","deep","151"),
("213","213","15396778779568447819","deep","151"),
("214","214","15421126013784739289","deep","151"),
("215","215","15427187369195821840","deep","151"),
("216","216","15434005362188193232","deep","151"),
("217","217","15458404790070878177","deep","151"),
("218","218","15466991729938496260","deep","151"),
("219","219","15472149412405709770","deep","151"),
("220","220","15478693371578956745","deep","151"),
("221","221","15500457286366526384","deep","151"),
("222","222","15517069055697708041","deep","151"),
("223","223","15521627153692899620","deep","151"),
("224","224","15532229765574359497","deep","151"),
("225","225","15533630133538046540","deep","151"),
("226","226","15537791675698463371","deep","151"),
("227","227","15539771995570725943","deep","151"),
("228","228","15551978004053120046","deep","151"),
("229","229","15561938007498863154","deep","151"),
("230","230","15562877032584311417","deep","151"),
("231","231","15564024007861961804","deep","151"),
("232","232","15567160606579878754","deep","151"),
("233","233","15568584232078508879","deep","151"),
("234","234","15596355178094444802","deep","151"),
("235","235","15608548597494735644","deep","151"),
("236","236","15615142628407987894","deep","151"),
("237","237","15622068428112550860","deep","151"),
("238","238","15642820478720223704","deep","151"),
("239","239","15643687053530026911","deep","151"),
("240","240","15644733885327666748","deep","151"),
("241","241","15645787769196584318","deep","151"),
("242","242","15649304572404961588","deep","151"),
("243","243","15650830597175295817","deep","151"),
("244","244","15651711882993590485","deep","151"),
("245","245","15662597025859220334","deep","151"),
("246","246","15672210540915226673","deep","151"),
("247","247","15682293066376620112","deep","151"),
("248","248","15688217184468593575","deep","151"),
("249","249","15695815023215790824","deep","151"),
("250","250","15696841602699146376","deep","151"),
("251","251","15698776772386358614","deep","151"),
("252","252","15702416101905353511","deep","151"),
("253","253","15709487190980010065","deep","151"),
("254","254","15719614866626453838","deep","151"),
("255","255","15733301749694131836","deep","151"),
("256","256","15738638872396186629","deep","151"),
("257","257","15747278005930198187","deep","151"),
("258","258","15747328073375236166","deep","151"),
("259","259","15752920418380931617","deep","151"),
("260","260","15754363810308313498","deep","151"),
("261","261","15782134756324249421","deep","151"),
("262","262","15783233786083250029","deep","151"),
("263","263","15788620976230342801","deep","151"),
("264","264","15789170493257326753","deep","151"),
("265","265","15793289011454048746","deep","151"),
("266","266","15795317272549993801","deep","151"),
("267","267","15797189785710064799","deep","151"),
("268","268","15802952593955093064","deep","151"),
("269","269","15818459792221481289","deep","151"),
("270","270","15818864019878371653","deep","151"),
("271","271","15827930144128749536","deep","151"),
("272","272","15834574246782007061","deep","151"),
("273","273","15839240151489390214","deep","151"),
("274","274","15851238209779582193","deep","151"),
("275","275","15875969415043512446","deep","151"),
("276","276","15877472672459403418","deep","151"),
("277","277","15883675064797868565","deep","151"),
("278","278","15884608548577524004","deep","151"),
("279","279","15884651572541218842","deep","151"),
("280","280","15893782483835060757","deep","151"),
("281","281","15897595703693169521","deep","151"),
("282","282","15901712095668536018","deep","151"),
("283","283","15906327932930881192","deep","151"),
("284","284","15917969709082832586","deep","151"),
("285","285","15926111527846188259","deep","151"),
("286","286","15928589162489106716","deep","151"),
("287","287","15930127776341544206","deep","151"),
("288","288","15930177848081549481","deep","151"),
("289","289","15934575941403188715","deep","151"),
("290","290","15939096556740478280","deep","151"),
("291","291","15950263396657413570","deep","151"),
("292","292","15951731686455561500","deep","151"),
("293","293","15962015110037879330","deep","151"),
("294","294","15963338106170966376","deep","151"),
("295","295","15967562304858524447","deep","151"),
("296","296","15969492557285749040","deep","151"),
("297","297","15970481654111202578","deep","151"),
("298","298","15970921233909672164","deep","151"),
("299","299","15974502824161513466","deep","151"),
("300","300","15975371525192672169","deep","151"),
("301","301","15990069883621443486","deep","151"),
("302","302","15993197178771356445","deep","151"),
("303","303","15994136203856804708","deep","151"),
("304","304","15999133885945433169","deep","151"),
("305","305","16007273574192466050","deep","151"),
("306","306","16010192919150176885","deep","151"),
("307","307","16016946954736981480","deep","151"),
("308","308","16018882124424193718","deep","151"),
("309","309","16027896055008178126","deep","151"),
("310","310","16029687764942900778","deep","151"),
("311","311","16030129470962725860","deep","151"),
("312","312","16031412858216555396","deep","151"),
("313","313","16036585255987227663","deep","151"),
("314","314","16046746161848862458","deep","151"),
("315","315","16052137604438666222","deep","151"),
("316","316","16057740412305109438","deep","151"),
("317","317","16059928678074606838","deep","151"),
("318","318","16061216317771147366","deep","151"),
("319","319","16066524835209214584","deep","151"),
("320","320","16068849517249858429","deep","151"),
("321","321","16070438198547333898","deep","151"),
("322","322","16094737487244975589","deep","151"),
("323","323","16096657941628729070","deep","151"),
("324","324","16132455847624551359","deep","151"),
("325","325","16134651780921197079","deep","151"),
("326","326","16137563458351759594","deep","151"),
("327","327","16140495392391573690","deep","151"),
("328","328","16145708687904585299","deep","151"),
("329","329","16148780374303667455","deep","151"),
("330","330","16157756822229749849","deep","151"),
("331","331","16162300204921482671","deep","151"),
("332","332","16215301797193360228","deep","151"),
("333","333","16220813635577458827","deep","151"),
("334","334","16223513940011005461","deep","151"),
("335","335","16230479348594825937","deep","151"),
("336","336","16231538769474569035","deep","151"),
("337","337","16241990550680142500","deep","151"),
("338","338","16257715492887236665","deep","151"),
("339","339","16269402419224238393","deep","151"),
("340","340","16276877740250752607","deep","151"),
("341","341","16281500620994440922","deep","151"),
("342","342","16285459134517610570","deep","151"),
("343","343","16289540170056430549","deep","151"),
("344","344","16290918774940348398","deep","151"),
("345","345","16306252078572655460","deep","151"),
("346","346","16308290137712071627","deep","151"),
("347","347","16331982174410543067","deep","151"),
("348","348","16332956555932537848","deep","151"),
("349","349","16336488074444373875","deep","151"),
("350","350","16338972761158570065","deep","151"),
("351","351","16346997594917100935","deep","151"),
("352","352","16367330702564424658","deep","151"),
("353","353","16374820734599430333","deep","151"),
("354","354","16376906734962528983","deep","151"),
("355","355","16379140155212044013","deep","151"),
("356","356","16398663601973788185","deep","151"),
("357","357","16401146162466628879","deep","151"),
("358","358","16417370545665734425","deep","151"),
("359","359","16424948132098647389","deep","151"),
("360","360","16440620876344380783","deep","151"),
("361","361","16451715265985671017","deep","151"),
("362","362","16474315936157322873","deep","151"),
("363","363","16477337550816399754","deep","151"),
("364","364","16484340726646530013","deep","151"),
("365","365","16488994042271809905","deep","151"),
("366","366","16527319654650555926","deep","151"),
("367","367","16560695534754290561","deep","151"),
("368","368","16570263899625246566","deep","151"),
("369","369","16571255122672055600","deep","151"),
("370","370","16580920835689422710","deep","151"),
("371","371","16582956764312516085","deep","151"),
("372","372","16585976252750237470","deep","151"),
("373","373","16594894961409166269","deep","151"),
("374","374","16603679384313271415","deep","151"),
("375","375","16609081289763822944","deep","151"),
("376","376","16620675124692091855","deep","151"),
("377","377","16631732031675480075","deep","151"),
("378","378","16657524784040508922","deep","151"),
("379","379","16664156297611663186","deep","151"),
("380","380","16665549617799039792","deep","151"),
("381","381","16669183406012241865","deep","151"),
("382","382","16690940273023501067","deep","151"),
("383","383","16691941954636090570","deep","151"),
("384","384","16695606177730884220","deep","151"),
("385","385","16704684891063365364","deep","151"),
("386","386","16706063500242250509","deep","151"),
("387","387","16711625410366354383","deep","151"),
("388","388","16711770699736447971","deep","151"),
("389","389","16717107818143535468","deep","151"),
("390","390","16722388026921366605","deep","151"),
("391","391","16728229512170387720","deep","151"),
("392","392","16730867155781825818","deep","151"),
("393","393","16731401957505351013","deep","151"),
("394","394","16732845349432732894","deep","151"),
("395","395","16737795081707744280","deep","151"),
("396","396","16743450087535548267","deep","151"),
("397","397","16744930962120832162","deep","151"),
("398","398","16748115992242931420","deep","151"),
("399","399","16769132902672062748","deep","151"),
("400","400","16774777445639118970","deep","151"),
("401","401","16778249098662445906","deep","151"),
("402","402","16785284835595523238","deep","151"),
("403","403","16803002686756983236","deep","151"),
("404","404","16806614707595448819","deep","151"),
("405","405","16827242109966115836","deep","151"),
("406","406","16849438556775844624","deep","151"),
("407","407","16882317117813956078","deep","151"),
("408","408","16905482016021083347","deep","151"),
("409","409","16907055986310067355","deep","151"),
("410","410","16910147925023433796","deep","151"),
("411","411","16919653633367248561","deep","151"),
("412","412","16928782418439734980","deep","151"),
("413","413","16939934543053211513","deep","151"),
("414","414","16942319090582364449","deep","151"),
("415","415","16950458778829397330","deep","151"),
("416","416","16966009001059480393","deep","151"),
("417","417","16969738006902770779","deep","151"),
("418","418","16978751933191787891","deep","151"),
("419","419","16994316870725329711","deep","151"),
("420","420","17000413582572958780","deep","151"),
("421","421","17001467462146909054","deep","151"),
("422","422","17015601596835172254","deep","151"),
("423","423","17017689723419626400","deep","151"),
("424","424","17036713724894391895","deep","151"),
("425","425","17038751784033808062","deep","151"),
("426","426","17043909466501021572","deep","151"),
("427","427","17049406589581661414","deep","151"),
("428","428","17051399498536027247","deep","151"),
("429","429","17067014503514607046","deep","151"),
("430","430","17101966475833713889","deep","151"),
("431","431","17105939704660342294","deep","151"),
("432","432","17126647609357638867","deep","151"),
("433","433","17161064779953220515","deep","151"),
("434","434","17168165299634794583","deep","151"),
("435","435","17179159550091041563","deep","151"),
("436","436","17187234455589577708","deep","151"),
("437","437","17214016300485092797","deep","151"),
("438","438","17236827051365269569","deep","151"),
("439","439","17281688955390114245","deep","151"),
("440","440","17290218151695611437","deep","151"),
("441","441","17293844892132503073","deep","151"),
("442","442","17304354412605230133","deep","151"),
("443","443","17314567512133258403","deep","151"),
("444","444","17393846586753684727","deep","151"),
("445","445","17496735065229630143","deep","151"),
("446","446","17498860674471986303","deep","151"),
("447","447","17517992486953910668","deep","151"),
("448","448","17548842782601109771","deep","151"),
("449","449","17586119436960860459","deep","151"),
("450","450","17588257635285319880","deep","151"),
("451","451","17595198150293341603","deep","151"),
("452","452","17625498928913556754","deep","151"),
("453","453","17663909969468854568","deep","151"),
("454","454","17687074871970949133","deep","151"),
("455","455","17703289461421550863","deep","151"),
("456","456","17721542110011568760","deep","151"),
("457","457","17749300466945401422","deep","151"),
("458","458","17828629613305833021","deep","151"),
("459","459","17839623863762080001","deep","151"),
("460","460","17850291258392036614","deep","151"),
("461","461","17895702679443865242","deep","151"),
("462","462","17904231880044329730","deep","151"),
("463","463","17927496921731467549","deep","151"),
("464","464","17942607564163081026","deep","151"),
("465","465","18014316100126904823","deep","151"),
("466","466","2751347059908981913","deep","151"),
("467","467","3046663467415733169","deep","151"),
("468","468","3401063468033499590","deep","151"),
("469","469","3438889635125266934","deep","151"),
("470","470","3693982747518929241","deep","151"),
("471","471","3708154360570127159","deep","151"),
("472","472","3731114108213619045","deep","151"),
("473","473","3931117497455982353","deep","151"),
("474","474","4312263990827684641","deep","151"),
("475","475","4450786658937711179","deep","151"),
("476","476","4505181571396965342","deep","151"),
("477","477","5012275853175956219","deep","151"),
("0","0","10717604042189073081","deep","152"),
("1","1","11095085316696679584","deep","152"),
("2","2","11225827369736545975","deep","152"),
("3","3","11273831284214762367","deep","152"),
("4","4","11380918787509026628","deep","152"),
("5","5","11460652157231381295","deep","152"),
("6","6","11476801963933486289","deep","152"),
("7","7","11499467421148602177","deep","152"),
("8","8","11510966038446782775","deep","152"),
("9","9","11563658624986825577","deep","152"),
("10","10","11636306186036097637","deep","152"),
("11","11","11660949836902120601","deep","152"),
("12","12","11730211173104617518","deep","152"),
("13","13","11772118375735204841","deep","152"),
("14","14","11781914662819206782","deep","152"),
("15","15","11826218997766083006","deep","152"),
("16","16","11919742524532155780","deep","152"),
("17","17","11966757342184918634","deep","152"),
("18","18","12059673232427984977","deep","152"),
("19","19","12089681301791690160","deep","152"),
("20","20","12097793689948128319","deep","152"),
("21","21","12150867732495650932","deep","152"),
("22","22","12187285864096582913","deep","152"),
("23","23","12216010550501425856","deep","152"),
("24","24","12290416980089033022","deep","152"),
("25","25","12314034051471700434","deep","152"),
("26","26","12316012245122607510","deep","152"),
("27","27","12330221340831707442","deep","152"),
("28","28","12330934574220432561","deep","152"),
("29","29","12345763511010806005","deep","152"),
("30","30","12351202899119259548","deep","152"),
("31","31","12387289257633913517","deep","152"),
("32","32","12394099198575300409","deep","152"),
("33","33","12408270811626498327","deep","152"),
("34","34","12415024842918335626","deep","152"),
("35","35","12420464231026789169","deep","152"),
("36","36","12450178014257085650","deep","152"),
("37","37","12451899395842551446","deep","152"),
("38","38","12487709890920476996","deep","152"),
("39","39","12499171021265788284","deep","152"),
("40","40","12527551734321053430","deep","152"),
("41","41","12544082997030638235","deep","152"),
("42","42","12563324742446109670","deep","152"),
("43","43","12575555644504302526","deep","152"),
("44","44","12606296007217954559","deep","152"),
("45","45","12630607884997699511","deep","152"),
("46","46","12630645367655601525","deep","152"),
("47","47","12649154824016093406","deep","152"),
("48","48","12667739245692389315","deep","152"),
("49","49","12682605665140664773","deep","152"),
("50","50","12699869216905229132","deep","152"),
("51","51","12739673577647903552","deep","152"),
("52","52","12854597601366910257","deep","152"),
("53","53","12893043609539951113","deep","152"),
("54","54","12908698223397788422","deep","152"),
("55","55","12922869840743953636","deep","152"),
("56","56","12928929065638713395","deep","152"),
("57","57","12929223360362056689","deep","152"),
("58","58","12929955645122068947","deep","152"),
("59","59","12941085006676069519","deep","152"),
("60","60","12957691234701458352","deep","152"),
("61","61","12966755237025448035","deep","152"),
("62","62","12968401653295109803","deep","152"),
("63","63","12980632559648269955","deep","152"),
("64","64","12985339658701743944","deep","152"),
("65","65","12987680881368483252","deep","152"),
("66","66","13030908953910802125","deep","152"),
("67","67","13035027472107524118","deep","152"),
("68","68","13062344123021531698","deep","152"),
("69","69","13076478253414827602","deep","152"),
("70","70","13097459807407412412","deep","152"),
("71","71","13108701616935119026","deep","152"),
("72","72","13115055136553222079","deep","152"),
("73","73","13120857553677507854","deep","152"),
("74","74","13142371783172262363","deep","152"),
("75","75","13149163301416968972","deep","152"),
("76","76","13154602685230455219","deep","152"),
("77","77","13208703311556300680","deep","152"),
("78","78","13244057381015975095","deep","152"),
("79","79","13281589257679366441","deep","152"),
("80","80","13284023872653557356","deep","152"),
("81","81","13294495910468382402","deep","152"),
("82","82","13302533329014049237","deep","152"),
("83","83","13336021652796522618","deep","152"),
("84","84","13337999846447429694","deep","152"),
("85","85","13354568596109883809","deep","152"),
("86","86","13355225915554092039","deep","152"),
("87","87","13359638724179190030","deep","152"),
("88","88","13381352567226754394","deep","152"),
("89","89","13389427472725290539","deep","152"),
("90","90","13393089565303761397","deep","152"),
("91","91","13401915182553957379","deep","152"),
("92","92","13448473578883436394","deep","152"),
("93","93","13474801132971990436","deep","152"),
("94","94","13514035335554593143","deep","152"),
("95","95","13518153853751315136","deep","152"),
("96","96","13530879948653775677","deep","152"),
("97","97","13568173440243373322","deep","152"),
("98","98","13580661154367007458","deep","152"),
("99","99","13592398152444014461","deep","152"),
("100","100","13608929415153599266","deep","152"),
("101","101","13628246125884874729","deep","152"),
("102","102","13633973581988323772","deep","152"),
("103","103","13706001301956322320","deep","152"),
("104","104","13709625916171858460","deep","152"),
("105","105","13748897601412363181","deep","152"),
("106","106","13753548795111254873","deep","152"),
("107","107","13762374412361450855","deep","152"),
("108","108","13768433641551177910","deep","152"),
("109","109","13785697193315742269","deep","152"),
("110","110","13845769878957243676","deep","152"),
("111","111","13872591332732016275","deep","152"),
("112","112","13880628755572650406","deep","152"),
("113","113","13891211601025358527","deep","152"),
("114","114","13899740801625823015","deep","152"),
("115","115","13908971981675046242","deep","152"),
("116","116","13962083511175438165","deep","152"),
("117","117","13983303450241816676","deep","152"),
("118","118","13993080681659564182","deep","152"),
("119","119","13997199195561318879","deep","152"),
("120","120","14001830622831458815","deep","152"),
("121","121","14010959407903945234","deep","152"),
("122","122","14011333330249582079","deep","152"),
("123","123","14041779398239890818","deep","152"),
("124","124","14049335092022696530","deep","152"),
("125","125","14069427822240176410","deep","152"),
("126","126","14070397152636878192","deep","152"),
("127","127","14072535350961337613","deep","152"),
("128","128","14082603161119272295","deep","152"),
("129","129","14084018373956756153","deep","152"),
("130","130","14094471984779933620","deep","152"),
("131","131","14143101962772804022","deep","152"),
("132","132","14179037980792071404","deep","152"),
("133","133","14209396008498940325","deep","152"),
("134","134","14216481817172022932","deep","152"),
("135","135","14229626850739865298","deep","152"),
("136","136","14234567283741839989","deep","152"),
("137","137","14238121569608119273","deep","152"),
("138","138","14240098888554690344","deep","152"),
("139","139","14241125463743078600","deep","152"),
("140","140","14242642184945408838","deep","152"),
("141","141","14244787560616516754","deep","152"),
("142","142","14251281318479420396","deep","152"),
("143","143","14252270415304873934","deep","152"),
("144","144","14254236019873677749","deep","152"),
("145","145","14278914152471911226","deep","152"),
("146","146","14279646437231923484","deep","152"),
("147","147","14280078843978711871","deep","152"),
("148","148","14284976382587329782","deep","152"),
("149","149","14285010860024572999","deep","152"),
("150","150","14293065999094357388","deep","152"),
("151","151","14305272007576751491","deep","152"),
("152","152","14306268281748853524","deep","152"),
("153","153","14312307744509828823","deep","152"),
("154","154","14329021783542376526","deep","152"),
("155","155","14330617642186500490","deep","152"),
("156","156","14336019547637052019","deep","152"),
("157","157","14337703450859583097","deep","152"),
("158","158","14342078776826779074","deep","152"),
("159","159","14349202063862796399","deep","152"),
("160","160","14385577661680533367","deep","152"),
("161","161","14386127178707517319","deep","152"),
("162","162","14386529275848084891","deep","152"),
("163","163","14392625987695713960","deep","152"),
("164","164","14393782266541368338","deep","152"),
("165","165","14397134013950900264","deep","152"),
("166","166","14402570401133662306","deep","152"),
("167","167","14403735092640462951","deep","152"),
("168","168","14404834122399463559","deep","152"),
("169","169","14413774723708499610","deep","152"),
("170","170","14418463400065293316","deep","152"),
("171","171","14447116122080023732","deep","152"),
("172","172","14465478213423088874","deep","152"),
("173","173","14474484966660424787","deep","152"),
("174","174","14483953192346337538","deep","152"),
("175","175","14498724394164524683","deep","152"),
("176","176","14512311133752192131","deep","152"),
("177","177","14519251653055181150","deep","152"),
("178","178","14524908780809373337","deep","152"),
("179","179","14531610128254317336","deep","152"),
("180","180","14533583270779931413","deep","152"),
("181","181","14536954784618215095","deep","152"),
("182","182","14537004856358220370","deep","152"),
("183","183","14542047684336931869","deep","152"),
("184","184","14542119648727044396","deep","152"),
("185","185","14543601009197860820","deep","152"),
("186","186","14544640177763319633","deep","152"),
("187","187","14547060077434051791","deep","152"),
("188","188","14549198275758511212","deep","152"),
("189","189","14550576010233060352","deep","152"),
("190","190","14551740701739860997","deep","152"),
("191","191","14557787341847484791","deep","152"),
("192","192","14568440021173982647","deep","152"),
("193","193","14580877663557611508","deep","152"),
("194","194","14591640280112623730","deep","152"),
("195","195","14592629376938077268","deep","152"),
("196","196","14600184196016546975","deep","152"),
("197","197","14602539308643815101","deep","152"),
("198","198","14606120898895656403","deep","152"),
("199","199","14625362644311127838","deep","152"),
("200","200","14633424960727560722","deep","152"),
("201","201","14639975967677118134","deep","152"),
("202","202","14641968876631483967","deep","152"),
("203","203","14652558899430840583","deep","152"),
("204","204","14655650838144207024","deep","152"),
("205","205","14660221525221501864","deep","152"),
("206","206","14681443590509235871","deep","152"),
("207","207","14682307160098380281","deep","152"),
("208","208","14686536485932985349","deep","152"),
("209","209","14691107173010280189","deep","152"),
("210","210","14693035299216149286","deep","152"),
("211","211","14695613077339078293","deep","152"),
("212","212","14696604300385887327","deep","152"),
("213","213","14699189255855464829","deep","152"),
("214","214","14708760237128276155","deep","152"),
("215","215","14720843723595019927","deep","152"),
("216","216","14729872369482463092","deep","152"),
("217","217","14744448205895584078","deep","152"),
("218","218","14749164186637939802","deep","152"),
("219","219","14752300781060889456","deep","152"),
("220","220","14754553503006388070","deep","152"),
("221","221","14757189016101503376","deep","152"),
("222","222","14757665203853538971","deep","152"),
("223","223","14758654300678992509","deep","152"),
("224","224","14762750926225607250","deep","152"),
("225","225","14779452376176051692","deep","152"),
("226","226","14797045574805538567","deep","152"),
("227","227","14798548832221429539","deep","152"),
("228","228","14816836837247993954","deep","152"),
("229","229","14835531191857836933","deep","152"),
("230","230","14835970775951273815","deep","152"),
("231","231","14837963680610672352","deep","152"),
("232","232","14839552366203115117","deep","152"),
("233","233","14841090975760585311","deep","152"),
("234","234","14846198590782760842","deep","152"),
("235","235","14851158785918519993","deep","152"),
("236","236","14853089034050777290","deep","152"),
("237","237","14858194522851597325","deep","152"),
("238","238","14860679209565793515","deep","152"),
("239","239","14869131034040690710","deep","152"),
("240","240","14870777454605319774","deep","152"),
("241","241","14873759460385139145","deep","152"),
("242","242","14880910051806718488","deep","152"),
("243","243","14881337042523084813","deep","152"),
("244","244","14891464718169528586","deep","152"),
("245","245","14897611501757162930","deep","152"),
("246","246","14901178376705545475","deep","152"),
("247","247","14906125987054168661","deep","152"),
("248","248","14906530210416091729","deep","152"),
("249","249","14927910154156022585","deep","152"),
("250","250","14930314463818959981","deep","152"),
("251","251","14939004543797312819","deep","152"),
("252","252","14956058019148319558","deep","152"),
("253","253","14970843936269965460","deep","152"),
("254","254","14974802449793135108","deep","152"),
("255","255","14975696324693533037","deep","152"),
("256","256","14976181054677052957","deep","152"),
("257","257","14976288861389244531","deep","152"),
("258","258","14980349644613780225","deep","152"),
("259","259","14981303385002687245","deep","152"),
("260","260","14982342549273178762","deep","152"),
("261","261","14988374474077343799","deep","152"),
("262","262","14988387063159447060","deep","152"),
("263","263","15005650614924011419","deep","152"),
("264","264","15014773988261043072","deep","152"),
("265","265","15017294521592285605","deep","152"),
("266","266","15021750354181078434","deep","152"),
("267","267","15031270773533384660","deep","152"),
("268","268","15031430778206937005","deep","152"),
("269","269","15032259870358838198","deep","152"),
("270","270","15037417557121019004","deep","152"),
("271","271","15042472974181833764","deep","152"),
("272","272","15048973909391385901","deep","152"),
("273","273","15049595386513515084","deep","152"),
("274","274","15051501615774309633","deep","152"),
("275","275","15057613042925397459","deep","152"),
("276","276","15074239037379538048","deep","152"),
("277","277","15077736078454130858","deep","152"),
("278","278","15081744659422338485","deep","152"),
("279","279","15083830659785437135","deep","152"),
("280","280","15088830468095421092","deep","152"),
("281","281","15092507275977350707","deep","152"),
("282","282","15094435397888252508","deep","152"),
("283","283","15101585989309831851","deep","152"),
("284","284","15106144091599990726","deep","152"),
("285","285","15111589016719269797","deep","152"),
("286","286","15112592828848182092","deep","152"),
("287","287","15115012728518914250","deep","152"),
("288","288","15119131246715636243","deep","152"),
("289","289","15125225832341909816","deep","152"),
("290","290","15138812571929577264","deep","152"),
("291","291","15139909475467222376","deep","152"),
("292","292","15149871605134320980","deep","152"),
("293","293","15152544605182305596","deep","152"),
("294","294","15155087026868688085","deep","152"),
("295","295","15157115292259600436","deep","152"),
("296","296","15161623318514786740","deep","152"),
("297","297","15169552934643229297","deep","152"),
("298","298","15184338847469907903","deep","152"),
("299","299","15186693964392143325","deep","152"),
("300","300","15195772677724624469","deep","152"),
("301","301","15205508714796281139","deep","152"),
("302","302","15205654008461342023","deep","152"),
("303","303","15209627232993003132","deep","152"),
("304","304","15213743624968369629","deep","152"),
("305","305","15221673236801844890","deep","152"),
("306","306","15240365469485299669","deep","152"),
("307","307","15243040591459672485","deep","152"),
("308","308","15244765689028294399","deep","152"),
("309","309","15252508817145585236","deep","152"),
("310","310","15259391597181420660","deep","152"),
("311","311","15266535140826689566","deep","152"),
("312","312","15267576435613503875","deep","152"),
("313","313","15274820122738783331","deep","152"),
("314","314","15280267174079417898","deep","152"),
("315","315","15283834049027800443","deep","152"),
("316","316","15289410674455363074","deep","152"),
("317","317","15290949288307800564","deep","152"),
("318","318","15294466091516177834","deep","152"),
("319","319","15298035092685915875","deep","152"),
("320","320","15299413701864801020","deep","152"),
("321","321","15299465895531194495","deep","152"),
("322","322","15302982703034539061","deep","152"),
("323","323","15305952119732255171","deep","152"),
("324","324","15307583824993425478","deep","152"),
("325","325","15317703833112720931","deep","152"),
("326","326","15321127544912365384","deep","152"),
("327","327","15328920744769661496","deep","152"),
("328","328","15329764552225021446","deep","152"),
("329","329","15330321242303686597","deep","152"),
("330","330","15336288254789016840","deep","152"),
("331","331","15336417954151315666","deep","152"),
("332","332","15336850356603136757","deep","152"),
("333","333","15337826864346487034","deep","152"),
("334","334","15338828550254043833","deep","152"),
("335","335","15339313280237563753","deep","152"),
("336","336","15340916676838497979","deep","152"),
("337","337","15343778286824022515","deep","152"),
("338","338","15351853188027591364","deep","152"),
("339","339","15353846096981957197","deep","152"),
("340","340","15361978737452679641","deep","152"),
("341","341","15363459612037963536","deep","152"),
("342","342","15367482912604597216","deep","152"),
("343","343","15374568716982712527","deep","152"),
("344","344","15377191645290691868","deep","152"),
("345","345","15378742848225232619","deep","152"),
("346","346","15379292360957249275","deep","152"),
("347","347","15381712260627981433","deep","152"),
("348","348","15386285073926631769","deep","152"),
("349","349","15387317194715780145","deep","152"),
("350","350","15391875292710971724","deep","152"),
("351","351","15393368756378358880","deep","152"),
("352","352","15393760390658178687","deep","152"),
("353","353","15394455197055256227","deep","152"),
("354","354","15401835296156714832","deep","152"),
("355","355","15403481716721343896","deep","152"),
("356","356","15406661205537650330","deep","152"),
("357","357","15414590821666092887","deep","152"),
("358","358","15417170726010377390","deep","152"),
("359","359","15417545523060350240","deep","152"),
("360","360","15418709339862814880","deep","152"),
("361","361","15421691341347666955","deep","152"),
("362","362","15428215043911662349","deep","152"),
("363","363","15434259557797930647","deep","152"),
("364","364","15439271955190017865","deep","152"),
("365","365","15441799661572941597","deep","152"),
("366","366","15450936114172576336","deep","152"),
("367","367","15452419114979215727","deep","152"),
("368","368","15453408211804669265","deep","152"),
("369","369","15453516018516860839","deep","152"),
("370","370","15466588601809058149","deep","152"),
("371","371","15470988821352052879","deep","152"),
("372","372","15475669441362894789","deep","152"),
("373","373","15476716277455501922","deep","152"),
("374","374","15482755250035977396","deep","152"),
("375","375","15483744346861430934","deep","152"),
("376","376","15484306452970518147","deep","152"),
("377","377","15490350962561819149","deep","152"),
("378","378","15492273547461895422","deep","152"),
("379","379","15500970415968093279","deep","152"),
("380","380","15501397410979426900","deep","152"),
("381","381","15502278696797721568","deep","152"),
("382","382","15502401223108339195","deep","152"),
("383","383","15505074218861356515","deep","152"),
("384","384","15506517610788738396","deep","152"),
("385","385","15509926611579891388","deep","152"),
("386","386","15522667417490843390","deep","152"),
("387","387","15523563422907564111","deep","152"),
("388","388","15525209843472193175","deep","152"),
("389","389","15527724960773013646","deep","152"),
("390","390","15533286870897117520","deep","152"),
("391","391","15535654576901456203","deep","152"),
("392","392","15536266750455581395","deep","152"),
("393","393","15539677873173122587","deep","152"),
("394","394","15540262746636653057","deep","152"),
("395","395","15541374365477756926","deep","152"),
("396","396","15542898259731768363","deep","152"),
("397","397","15557474100439856645","deep","152"),
("398","398","15557915806459681727","deep","152"),
("399","399","15563425522917392126","deep","152"),
("400","400","15570578240560326965","deep","152"),
("401","401","15571113037988884864","deep","152"),
("402","402","15575778946991235313","deep","152"),
("403","403","15577707068902137114","deep","152"),
("404","404","15579200532569524270","deep","152"),
("405","405","15588548362461142186","deep","152"),
("406","406","15592237759425175062","deep","152"),
("407","407","15597345374447350593","deep","152"),
("408","408","15601911139969690492","deep","152"),
("409","409","15602242913055968504","deep","152"),
("410","410","15603377299251515630","deep","152"),
("411","411","15612066500230565167","deep","152"),
("412","412","15612613891036193623","deep","152"),
("413","413","15614154631109986609","deep","152"),
("414","414","15625146751049910797","deep","152"),
("415","415","15631749955960828980","deep","152"),
("416","416","15631857762673020554","deep","152"),
("417","417","15632152053101396552","deep","152"),
("418","418","15635816276196190202","deep","152"),
("419","419","15642648984492020351","deep","152"),
("420","420","15644237665789495820","deep","152"),
("421","421","15648316575106960303","deep","152"),
("422","422","15652422504221579035","deep","152"),
("423","423","15653851180845502159","deep","152"),
("424","424","15674189834093586002","deep","152"),
("425","425","15675635352242323379","deep","152"),
("426","426","15677505734886071585","deep","152"),
("427","427","15687387065622789139","deep","152"),
("428","428","15688550057082323840","deep","152"),
("429","429","15691677352232236799","deep","152"),
("430","430","15698835611180964462","deep","152"),
("431","431","15701905167063723826","deep","152"),
("432","432","15701962902035910125","deep","152"),
("433","433","15702294675122188137","deep","152"),
("434","434","15702562490802899352","deep","152"),
("435","435","15703393709176156041","deep","152"),
("436","436","15706925227687992068","deep","152"),
("437","437","15708499193682008780","deep","152"),
("438","438","15710811286640549364","deep","152"),
("439","439","15717030520503828764","deep","152"),
("440","440","15720605062979359629","deep","152"),
("441","441","15738250459570207275","deep","152"),
("442","442","15742916364277590428","deep","152"),
("443","443","15744786751216305930","deep","152"),
("444","444","15744896684149853000","deep","152"),
("445","445","15751382908350913676","deep","152"),
("446","446","15762000231240865014","deep","152"),
("447","447","15766570918318159854","deep","152"),
("448","448","15772509751713592074","deep","152"),
("449","449","15778496526332706777","deep","152"),
("450","450","15780692463924319793","deep","152"),
("451","451","15781638536786078493","deep","152"),
("452","452","15800867693119446667","deep","152"),
("453","453","15804289278697735624","deep","152"),
("454","454","15807793497118976929","deep","152"),
("455","455","15810493797257556267","deep","152"),
("456","456","15814452310780725915","deep","152"),
("457","457","15814467026084184672","deep","152"),
("458","458","15814894016800550997","deep","152"),
("459","459","15817529534190633599","deep","152"),
("460","460","15819891698889179458","deep","152"),
("461","461","15826218739464650432","deep","152"),
("462","462","15828480760683185741","deep","152"),
("463","463","15831658127573103975","deep","152"),
("464","464","15832609741740655499","deep","152"),
("465","465","15835672249847104426","deep","152"),
("466","466","15846291703253378556","deep","152"),
("467","467","15854271386826859092","deep","152"),
("468","468","15856301774144159643","deep","152"),
("469","469","15856396996069215252","deep","152"),
("470","470","15865915293495133278","deep","152"),
("471","471","15870531126462511156","deep","152"),
("472","472","15870972836777303534","deep","152"),
("473","473","15873392736448035692","deep","152"),
("474","474","15879502033082800726","deep","152"),
("475","475","15883178845259697637","deep","152"),
("476","476","15885157038910604713","deep","152"),
("477","477","15886645576728069632","deep","152"),
("478","478","15892539259938451518","deep","152"),
("479","479","15894237878464441353","deep","152"),
("480","480","15897702488006425148","deep","152"),
("481","481","15902260586001616727","deep","152"),
("482","482","15906941206012458637","deep","152"),
("483","483","15907822496125720601","deep","152"),
("484","484","15911326710251994610","deep","152"),
("485","485","15913023202556628949","deep","152"),
("486","486","15916289035904076553","deep","152"),
("487","487","15916382127312809370","deep","152"),
("488","488","15916728615702546139","deep","152"),
("489","489","15920123722238203017","deep","152"),
("490","490","15926075144715738498","deep","152"),
("491","491","15926406917802016510","deep","152"),
("492","492","15938600337202307352","deep","152"),
("493","493","15942616585697663299","deep","152"),
("494","494","15956642909378767629","deep","152"),
("495","495","15962400180612970366","deep","152"),
("496","496","15971094927192780023","deep","152"),
("497","497","15986647271349251286","deep","152"),
("498","498","15994736892151246188","deep","152"),
("499","499","16002276995926257138","deep","152"),
("500","500","16006220794145968029","deep","152"),
("501","501","16006235505154459490","deep","152"),
("502","502","16008815413793711289","deep","152"),
("503","503","16012425308410821376","deep","152"),
("504","504","16013039612481269360","deep","152"),
("505","505","16016463324280913813","deep","152"),
("506","506","16023830834300269157","deep","152"),
("507","507","16023938641012460731","deep","152"),
("508","508","16029435764093100573","deep","152"),
("509","509","16043167797345828905","deep","152"),
("510","510","16043180386427932166","deep","152"),
("511","511","16044611189273210786","deep","152"),
("512","512","16044754352421948878","deep","152"),
("513","513","16045600286098664324","deep","152"),
("514","514","16047738484423123745","deep","152"),
("515","515","16048127996776555352","deep","152"),
("516","516","16048230262182954102","deep","152"),
("517","517","16060883517990966111","deep","152"),
("518","518","16061310513002299732","deep","152"),
("519","519","16065283737533960841","deep","152"),
("520","520","16065319093970507359","deep","152"),
("521","521","16066967640756491919","deep","152"),
("522","522","16067261931184867917","deep","152"),
("523","523","16067421935858420262","deep","152"),
("524","524","16068303225971682226","deep","152"),
("525","525","16071820029180059496","deep","152"),
("526","526","16078955909593147378","deep","152"),
("527","527","16083036945131967357","deep","152"),
("528","528","16083426453190431668","deep","152"),
("529","529","16087595043127158936","deep","152"),
("530","530","16088584139952612474","deep","152"),
("531","531","16089031387278230380","deep","152"),
("532","532","16092115658464448501","deep","152"),
("533","533","16092492581735776847","deep","152"),
("534","534","16092772982203624027","deep","152"),
("535","535","16093104755289902039","deep","152"),
("536","536","16093307783927149222","deep","152"),
("537","537","16099259202109717407","deep","152"),
("538","538","16104698590218170950","deep","152"),
("539","539","16111344814797816675","deep","152"),
("540","540","16113922592920745682","deep","152"),
("541","541","16118870203269368868","deep","152"),
("542","542","16122949112586833351","deep","152"),
("543","543","16124379915432111971","deep","152"),
("544","544","16124475137357167580","deep","152"),
("545","545","16126410307044379818","deep","152"),
("546","546","16131625728778746923","deep","152"),
("547","547","16134060343752937838","deep","152"),
("548","548","16136096272376031213","deep","152"),
("549","549","16138993238798102267","deep","152"),
("550","550","16143673858808944177","deep","152"),
("551","551","16152810311408578916","deep","152"),
("552","552","16155657206090644695","deep","152"),
("553","553","16156111501192573038","deep","152"),
("554","554","16161312207623481386","deep","152"),
("555","555","16168317509674967141","deep","152"),
("556","556","16177478855850400633","deep","152"),
("557","557","16179911344603236052","deep","152"),
("558","558","16187451448378247002","deep","152"),
("559","559","16189243158312969654","deep","152"),
("560","560","16190636478500346260","deep","152"),
("561","561","16194580276720057151","deep","152"),
("562","562","16195144504755532564","deep","152"),
("563","563","16198271799905445523","deep","152"),
("564","564","16199580080735073812","deep","152"),
("565","565","16203111603541877135","deep","152"),
("566","566","16204100700367330673","deep","152"),
("567","567","16205639309924800867","deep","152"),
("568","568","16206896218135998324","deep","152"),
("569","569","16208377092721282219","deep","152"),
("570","570","16220373029085085998","deep","152"),
("571","571","16221911638642556192","deep","152"),
("572","572","16225493228894397494","deep","152"),
("573","573","16227511031424562080","deep","152"),
("574","574","16228058422230190536","deep","152"),
("575","575","16230428250160917419","deep","152"),
("576","576","16239052668391470220","deep","152"),
("577","577","16240041765216923758","deep","152"),
("578","578","16242034674171289591","deep","152"),
("579","579","16252544194644016651","deep","152"),
("580","580","16254777610598564385","deep","152"),
("581","581","16256316224451001875","deep","152"),
("582","582","16258705689240142456","deep","152"),
("583","583","16259737810029290832","deep","152"),
("584","584","16263211589273973264","deep","152"),
("585","585","16266448817357433293","deep","152"),
("586","586","16270284808864952610","deep","152"),
("587","587","16270297397947055871","deep","152"),
("588","588","16279631337878144969","deep","152"),
("589","589","16281999039587516356","deep","152"),
("590","590","16282990262634325390","deep","152"),
("591","591","16283040334374330665","deep","152"),
("592","592","16284528876486762880","deep","152"),
("593","593","16286399259130511086","deep","152"),
("594","594","16287950462065051837","deep","152"),
("595","595","16290625584039424653","deep","152"),
("596","596","16293043357488801315","deep","152"),
("597","597","16296027489489976182","deep","152"),
("598","598","16297566103342413672","deep","152"),
("599","599","16302136790419708512","deep","152"),
("600","600","16308218782668911528","deep","152"),
("601","601","16310306913548332970","deep","152"),
("602","602","16312689330561163114","deep","152"),
("603","603","16319327887613660519","deep","152"),
("604","604","16321416018493081961","deep","152"),
("605","605","16324383304674475279","deep","152"),
("606","606","16327462654305738459","deep","152"),
("607","607","16328356533501103684","deep","152"),
("608","608","16339413440484491904","deep","152"),
("609","609","16345713180969368156","deep","152"),
("610","610","16348090056676405476","deep","152"),
("611","611","16353599768839148579","deep","152"),
("612","612","16359256900888308062","deep","152"),
("613","613","16359739504650472486","deep","152"),
("614","614","16363750211840035609","deep","152"),
("615","615","16370251147049587746","deep","152"),
("616","616","16372294127743958854","deep","152"),
("617","617","16377336955722670353","deep","152"),
("618","618","16378995961074435382","deep","152"),
("619","619","16390436839105462385","deep","152"),
("620","620","16391975452957899875","deep","152"),
("621","621","16392524969984883827","deep","152"),
("622","622","16392964549783353413","deep","152"),
("623","623","16394610970347982477","deep","152"),
("624","624","16398511744603998530","deep","152"),
("625","625","16412206295198824848","deep","152"),
("626","626","16413182802942175125","deep","152"),
("627","627","16419387321501995768","deep","152"),
("628","628","16419791544863918836","deep","152"),
("629","629","16420391133630908063","deep","152"),
("630","630","16420925935354433258","deep","152"),
("631","631","16422369327281815139","deep","152"),
("632","632","16433920138246389212","deep","152"),
("633","633","16438925483567198697","deep","152"),
("634","634","16442479773728445277","deep","152"),
("635","635","16444630556840040663","deep","152"),
("636","636","16446515659082214922","deep","152"),
("637","637","16448041679557581855","deep","152"),
("638","638","16451166848486139318","deep","152"),
("639","639","16453001878988308302","deep","152"),
("640","640","16458644291439041732","deep","152"),
("641","641","16459755914575112897","deep","152"),
("642","642","16462725326977861711","deep","152"),
("643","643","16464154007896752131","deep","152"),
("644","644","16464156134118107627","deep","152"),
("645","645","16472793141430763689","deep","152"),
("646","646","16473392725902785620","deep","152"),
("647","647","16476362142600501730","deep","152"),
("648","648","16476909529111162890","deep","152"),
("649","649","16488942948132868683","deep","152"),
("650","650","16489399369456152522","deep","152"),
("651","651","16496470462825776372","deep","152"),
("652","652","16498116879095438140","deep","152"),
("653","653","16504278377986531241","deep","152"),
("654","654","16505816987544001435","deep","152"),
("655","655","16506113404193732929","deep","152"),
("656","656","16507100374797830971","deep","152"),
("657","657","16519793243780067786","deep","152"),
("658","658","16526943835201647129","deep","152"),
("659","659","16529898536595904482","deep","152"),
("660","660","16530448049327921138","deep","152"),
("661","661","16531878856468167054","deep","152"),
("662","662","16534406562851090786","deep","152"),
("663","663","16534910929693024404","deep","152"),
("664","664","16536347273844095848","deep","152"),
("665","665","16538442448204860431","deep","152"),
("666","666","16542104545078298585","deep","152"),
("667","667","16547159962139113345","deep","152"),
("668","668","16557619410871835130","deep","152"),
("669","669","16560357193668316482","deep","152"),
("670","670","16565146925564742819","deep","152"),
("671","671","16568128927049594894","deep","152"),
("672","672","16569263313245142020","deep","152"),
("673","673","16577915035861256839","deep","152"),
("674","674","16580442746539147867","deep","152"),
("675","675","16597526037020908300","deep","152"),
("676","676","16600660999697969579","deep","152"),
("677","677","16602091802543248199","deep","152"),
("678","678","16610671074883717962","deep","152"),
("679","679","16613655202589925533","deep","152"),
("680","680","16617706807521827998","deep","152"),
("681","681","16617719396603931259","deep","152"),
("682","682","16624807331498369362","deep","152"),
("683","683","16625246911296838948","deep","152"),
("684","684","16633431749728922163","deep","152"),
("685","685","16635314725749740926","deep","152"),
("686","686","16658220689965038715","deep","152"),
("687","687","16665256426898116047","deep","152"),
("688","688","16666749890565503203","deep","152"),
("689","689","16668115910662285087","deep","152"),
("690","690","16669277596948426935","deep","152"),
("691","691","16669669235523214038","deep","152"),
("692","692","16678198436123678526","deep","152"),
("693","693","16681377924939984960","deep","152"),
("694","694","16690002343170537761","deep","152"),
("695","695","16693958730472351913","deep","152"),
("696","696","16703976473185248616","deep","152"),
("697","697","16708484499440434920","deep","152"),
("698","698","16714191698934632382","deep","152"),
("699","699","16714299505646823956","deep","152"),
("700","700","16718712314271921947","deep","152"),
("701","701","16721839609421834906","deep","152"),
("702","702","16726455446684180080","deep","152"),
("703","703","16733875150369928899","deep","152"),
("704","704","16743942964822830877","deep","152"),
("705","705","16760150506497122170","deep","152"),
("706","706","16763184710238302312","deep","152"),
("707","707","16767740682012138395","deep","152"),
("708","708","16771821717550958374","deep","152"),
("709","709","16777196318615947885","deep","152"),
("710","710","16783855132277696871","deep","152"),
("711","711","16787424133447434912","deep","152"),
("712","712","16787828361104325276","deep","152"),
("713","713","16787936167816516850","deep","152"),
("714","714","16796502851074883352","deep","152"),
("715","715","16804687685211999271","deep","152"),
("716","716","16807497097236163036","deep","152"),
("717","717","16815744596490354787","deep","152"),
("718","718","16823819497693923636","deep","152"),
("719","719","16826738842651634471","deep","152"),
("720","720","16827338431418623698","deep","152"),
("721","721","16830747427914809394","deep","152"),
("722","722","16837795749635022691","deep","152"),
("723","723","16838837044421837000","deep","152"),
("724","724","16838851759725295757","deep","152"),
("725","725","16845937564103411068","deep","152"),
("726","726","16847461462652389801","deep","152"),
("727","727","16848573081493493670","deep","152"),
("728","728","16850111695345931160","deep","152"),
("729","729","16851542498191209780","deep","152"),
("730","730","16869737411809041378","deep","152"),
("731","731","16870126919867505689","deep","152"),
("732","732","16885300218826260406","deep","152"),
("733","733","16892388153720698509","deep","152"),
("734","734","16901120378663442884","deep","152"),
("735","735","16904384085789534992","deep","152"),
("736","736","16905533187288540875","deep","152"),
("737","737","16909649579263907372","deep","152"),
("738","738","16951544192812391434","deep","152"),
("739","739","16959523876385871970","deep","152"),
("740","740","16965116221391567421","deep","152"),
("741","741","16979756844848152439","deep","152"),
("742","742","16995321782381694259","deep","152"),
("743","743","17007463003820624330","deep","152"),
("744","744","17007967370662557948","deep","152"),
("745","745","17011044594072465632","deep","152"),
("746","746","17013732309423909005","deep","152"),
("747","747","17018522041320335342","deep","152"),
("748","748","17026769536279559797","deep","152"),
("749","749","17030273754700801102","deep","152"),
("750","750","17030713334499270688","deep","152"),
("751","751","17031262851526254640","deep","152"),
("752","752","17034294924751111990","deep","152"),
("753","753","17041757652400555647","deep","152"),
("754","754","17045793542049292588","deep","152"),
("755","755","17049420278191216928","deep","152"),
("756","756","17050007277876102894","deep","152"),
("757","757","17050851081036495548","deep","152"),
("758","758","17070642343478950935","deep","152"),
("759","759","17073661831916672320","deep","152"),
("760","760","17075040436800590169","deep","152"),
("761","761","17077273857050105199","deep","152"),
("762","762","17078327736624055473","deep","152"),
("763","763","17082191028222169512","deep","152"),
("764","764","17086952154854608274","deep","152"),
("765","765","17091804543278175851","deep","152"),
("766","766","17101967575361166142","deep","152"),
("767","767","17105976160624341065","deep","152"),
("768","768","17115164806890369279","deep","152"),
("769","769","17126663424188549877","deep","152"),
("770","770","17127210810699211037","deep","152"),
("771","771","17134753040695577483","deep","152"),
("772","772","17134846136399277596","deep","152"),
("773","773","17141492360978923321","deep","152"),
("774","774","17149421972812398582","deep","152"),
("775","775","17152441461250119967","deep","152"),
("776","776","17165586494817962333","deep","152"),
("777","777","17169494936601126706","deep","152"),
("778","778","17188347173958133830","deep","152"),
("779","779","17188774164674500155","deep","152"),
("780","780","17212051795443741235","deep","152"),
("781","781","17220568406962102462","deep","152"),
("782","782","17225623824022917222","deep","152"),
("783","783","17232320120342568222","deep","152"),
("784","784","17235729116838753918","deep","152"),
("785","785","17239210567905551966","deep","152"),
("786","786","17246296372283667277","deep","152"),
("787","787","17257500699153471877","deep","152"),
("788","788","17265588189439143987","deep","152"),
("789","789","17269546702962313635","deep","152"),
("790","790","17269561418265772392","deep","152"),
("791","791","17275658130113401461","deep","152"),
("792","792","17286700321793330924","deep","152"),
("793","793","17303963873557895283","deep","152"),
("794","794","17310904388565917006","deep","152"),
("795","795","17347741463127198108","deep","152"),
("796","796","17364600787234872103","deep","152"),
("797","797","17378627110915976433","deep","152"),
("798","798","17395780729746993722","deep","152"),
("799","799","17401387790056147930","deep","152"),
("800","800","17402426958621606743","deep","152"),
("801","801","17446299765820997881","deep","152"),
("802","802","17455978063625500956","deep","152"),
("803","803","17464002897384031826","deep","152"),
("804","804","17513595493159723687","deep","152"),
("805","805","17516469692227351484","deep","152"),
("806","806","17530201721185112520","deep","152"),
("807","807","17542747170280932955","deep","152"),
("808","808","17555819753573130265","deep","152"),
("809","809","17576052722035410734","deep","152"),
("810","810","17578030915686317810","deep","152"),
("811","811","17588808247544788789","deep","152"),
("812","812","17609920379898975726","deep","152"),
("813","813","17656385680524754628","deep","152"),
("814","814","17667442587508142848","deep","152"),
("815","815","17703385782874058725","deep","152"),
("816","816","17757925988998373772","deep","152"),
("817","817","17763862691877483200","deep","152"),
("818","818","17791793642566971468","deep","152"),
("819","819","17794213542237703626","deep","152"),
("820","820","17827042031535809805","deep","152"),
("821","821","17829619809658738812","deep","152"),
("822","822","17848703676622013398","deep","152"),
("823","823","17851830971771926357","deep","152"),
("824","824","17871903935560654481","deep","152"),
("825","825","17904232979571781983","deep","152"),
("826","826","17904283051311787258","deep","152"),
("827","827","17911868300976881246","deep","152"),
("828","828","17927483305955461045","deep","152"),
("829","829","17943208248162555210","deep","152"),
("830","830","17997748454286870257","deep","152"),
("831","831","18037517458592998159","deep","152"),
("832","832","18077481824009224924","deep","152"),
("833","833","2485175372704940382","deep","152"),
("834","834","2513518598807336218","deep","152"),
("835","835","2719912990325704593","deep","152"),
("836","836","2932491259270805850","deep","152"),
("837","837","3075007797340548554","deep","152"),
("838","838","3212835659053497552","deep","152"),
("839","839","3231801541032240568","deep","152"),
("840","840","3479808840457852972","deep","152"),
("841","841","3508152070855216104","deep","152"),
("842","842","3508846877252293644","deep","152"),
("843","843","3801071346045678459","deep","152"),
("844","844","3947687346645888721","deep","152"),
("845","845","4240606621836351076","deep","152"),
("846","846","4309867958038847993","deep","152"),
("847","847","9831760399354668817","deep","152"),
("0","0","10331769976282996636","deep","153"),
("1","1","11003159622806519032","deep","153"),
("2","2","11281907289240750765","deep","153"),
("3","3","11619738540196063071","deep","153"),
("4","4","11637296382389003428","deep","153"),
("5","5","11726826043490327332","deep","153"),
("6","6","11776237993459379087","deep","153"),
("7","7","11866061940694111693","deep","153"),
("8","8","11897791400233217264","deep","153"),
("9","9","11903850625127977023","deep","153"),
("10","10","11928199985565623989","deep","153"),
("11","11","11969725732188731501","deep","153"),
("12","12","12009949031596787746","deep","153"),
("13","13","12020126778983236794","deep","153"),
("14","14","12036276585685341788","deep","153"),
("15","15","12058942042900457676","deep","153"),
("16","16","12147776893309736744","deep","153"),
("17","17","12184613967871017846","deep","153"),
("18","18","12206290328260680196","deep","153"),
("19","19","12249462491153449476","deep","153"),
("20","20","12253581009350171469","deep","153"),
("21","21","12267020337641357129","deep","153"),
("22","22","12270149754717658288","deep","153"),
("23","23","12320131862846781756","deep","153"),
("24","24","12448200920133630827","deep","153"),
("25","25","12490640798266387849","deep","153"),
("26","26","12551864711628250635","deep","153"),
("27","27","12586028781846579825","deep","153"),
("28","28","12586686105585755351","deep","153"),
("29","29","12599211298072324205","deep","153"),
("30","30","12603825009113313883","deep","153"),
("31","31","12677536632303843509","deep","153"),
("32","32","12696740899356380226","deep","153"),
("33","33","12698518190591395615","deep","153"),
("34","34","12701191186344412935","deep","153"),
("35","35","12717465645578491052","deep","153"),
("36","36","12724551449956606363","deep","153"),
("37","37","12771441619372363390","deep","153"),
("38","38","12786726977486020673","deep","153"),
("39","39","12799872011053863039","deep","153"),
("40","40","12813348822002950713","deep","153"),
("41","41","12891103998074398304","deep","153"),
("42","42","12908004520823130431","deep","153"),
("43","43","12917763325249230358","deep","153"),
("44","44","12998523274454940577","deep","153"),
("45","45","13004250730558389620","deep","153"),
("46","46","13041382091253079424","deep","153"),
("47","47","13058264187010163972","deep","153"),
("48","48","13093048098309766674","deep","153"),
("49","49","13128896076045594238","deep","153"),
("50","50","13168737919446170672","deep","153"),
("51","51","13178878179879750410","deep","153"),
("52","52","13180599565760183502","deep","153"),
("53","53","13206232313451660004","deep","153"),
("54","54","13211634218902211533","deep","153"),
("55","55","13245085060026782900","deep","153"),
("56","56","13292099873384578458","deep","153"),
("57","57","13292431650765823766","deep","153"),
("58","58","13328204658890880006","deep","153"),
("59","59","13354237918256090754","deep","153"),
("60","60","13378919051780015732","deep","153"),
("61","61","13395782091870845845","deep","153"),
("62","62","13412056546809956666","deep","153"),
("63","63","13456016908407255093","deep","153"),
("64","64","13467716423826360082","deep","153"),
("65","65","13487746363651393368","deep","153"),
("66","66","13488403687390568894","deep","153"),
("67","67","13490381881041475970","deep","153"),
("68","68","13516014628732952472","deep","153"),
("69","69","13521817045857238247","deep","153"),
("70","70","13525535048085258698","deep","153"),
("71","71","13541058791272709682","deep","153"),
("72","72","13562040349560261788","deep","153"),
("73","73","13564093504232005596","deep","153"),
("74","74","13594502093859379617","deep","153"),
("75","75","13608016383171402009","deep","153"),
("76","76","13622807837303873439","deep","153"),
("77","77","13639376586966327554","deep","153"),
("78","78","13639670877394703552","deep","153"),
("79","79","13652320718118278233","deep","153"),
("80","80","13715066403807764256","deep","153"),
("81","81","13749887797765268972","deep","153"),
("82","82","13769549360845425533","deep","153"),
("83","83","13776252834511725028","deep","153"),
("84","84","13804977520916567971","deep","153"),
("85","85","13826067760620647656","deep","153"),
("86","86","13848328990178873180","deep","153"),
("87","87","13868179623634370537","deep","153"),
("88","88","13879678240932551135","deep","153"),
("89","89","13891796695017037949","deep","153"),
("90","90","13923541744563938282","deep","153"),
("91","91","13925504348207050596","deep","153"),
("92","92","13943099673057892967","deep","153"),
("93","93","14010382815609482808","deep","153"),
("94","94","14019152523210129197","deep","153"),
("95","95","14045754601298307481","deep","153"),
("96","96","14051871079574688306","deep","153"),
("97","97","14080076554263800816","deep","153"),
("98","98","14102272122074226303","deep","153"),
("99","99","14105276895208488931","deep","153"),
("100","100","14129663738304037911","deep","153"),
("101","101","14131035165841307265","deep","153"),
("102","102","14165511711744898179","deep","153"),
("103","103","14195203602325087408","deep","153"),
("104","104","14200170974807495054","deep","153"),
("105","105","14203878092295645484","deep","153"),
("106","106","14204946816743392573","deep","153"),
("107","107","14210348722193944102","deep","153"),
("108","108","14219869145841217624","deep","153"),
("109","109","14229665432925219565","deep","153"),
("110","110","14231049449544592180","deep","153"),
("111","111","14231606143918224627","deep","153"),
("112","112","14233051662066962004","deep","153"),
("113","113","14239076409524478546","deep","153"),
("114","114","14240137466445077315","deep","153"),
("115","115","14246234178292706384","deep","153"),
("116","116","14285011959552025252","deep","153"),
("117","117","14287165747884279435","deep","153"),
("118","118","14314287037688188152","deep","153"),
("119","119","14365734430394800753","deep","153"),
("120","120","14399727606904740281","deep","153"),
("121","121","14417475402767292031","deep","153"),
("122","122","14458226326552224976","deep","153"),
("123","123","14465861647957324239","deep","153"),
("124","124","14479593681210052571","deep","153"),
("125","125","14482465749761357576","deep","153"),
("126","126","14489711563107992528","deep","153"),
("127","127","14494774157515455783","deep","153"),
("128","128","14509797115978823913","deep","153"),
("129","129","14531019181266557920","deep","153"),
("130","130","14551566202290998847","deep","153"),
("131","131","14552261008688076387","deep","153"),
("132","132","14601659122352972686","deep","153"),
("133","133","14606831520123644953","deep","153"),
("134","134","14620857843804749283","deep","153"),
("135","135","14627394135450847938","deep","153"),
("136","136","14628493165209848546","deep","153"),
("137","137","14645047199568843904","deep","153"),
("138","138","14647574905951767636","deep","153"),
("139","139","14659348511982340648","deep","153"),
("140","140","14664326427642217353","deep","153"),
("141","141","14670812647548310733","deep","153"),
("142","142","14676943836833183019","deep","153"),
("143","143","14679941432620797152","deep","153"),
("144","144","14693478104763426621","deep","153"),
("145","145","14707649717814624539","deep","153"),
("146","146","14708673296372288590","deep","153"),
("147","147","14720794751382466905","deep","153"),
("148","148","14737016522474684426","deep","153"),
("149","149","14745438402248489869","deep","153"),
("150","150","14769398250332705228","deep","153"),
("151","151","14779308186333410357","deep","153"),
("152","152","14785020436952900818","deep","153"),
("153","153","14787540965989176055","deep","153"),
("154","154","14795630586791170957","deep","153"),
("155","155","14795912288137443694","deep","153"),
("156","156","14811233002687647495","deep","153"),
("157","157","14815760795371585555","deep","153"),
("158","158","14833941483866458221","deep","153"),
("159","159","14837575272079660294","deep","153"),
("160","160","14844451000044217985","deep","153"),
("161","161","14845600101543223868","deep","153"),
("162","162","14859351901224703956","deep","153"),
("163","163","14882311648868195842","deep","153"),
("164","164","14884025857401980439","deep","153"),
("165","165","14885014954227433977","deep","153"),
("166","166","14885419177589357045","deep","153"),
("167","167","14889925081918155149","deep","153"),
("168","168","14903671826179374942","deep","153"),
("169","169","14925261020989933479","deep","153"),
("170","170","14926322572385999369","deep","153"),
("171","171","14942097582038131513","deep","153"),
("172","172","14944487176397610152","deep","153"),
("173","173","14947030477083295942","deep","153"),
("174","174","14957539993261055706","deep","153"),
("175","175","14962755414995422811","deep","153"),
("176","176","14982293581355593036","deep","153"),
("177","177","14997504358677282471","deep","153"),
("178","178","15003073936328534665","deep","153"),
("179","179","15007579840657332769","deep","153"),
("180","180","15008121685862201105","deep","153"),
("181","181","15009060715242616664","deep","153"),
("182","182","15011213624575567546","deep","153"),
("183","183","15015207494535283712","deep","153"),
("184","184","15015317427468830782","deep","153"),
("185","185","15025666943268005497","deep","153"),
("186","186","15036819067881482030","deep","153"),
("187","187","15045508273155498863","deep","153"),
("188","188","15052007082143695504","deep","153"),
("189","189","15055671305238489154","deep","153"),
("190","190","15066130753971210939","deep","153"),
("191","191","15068721121176243207","deep","153"),
("192","192","15075209467303692083","deep","153"),
("193","193","15078322047150146285","deep","153"),
("194","194","15089943186463977214","deep","153"),
("195","195","15092458303764797685","deep","153"),
("196","196","15094436497415704761","deep","153"),
("197","197","15095425594241158299","deep","153"),
("198","198","15108073313038344780","deep","153"),
("199","199","15108635414852464697","deep","153"),
("200","200","15118236340826367775","deep","153"),
("201","201","15123530439564727730","deep","153"),
("202","202","15125943626621579565","deep","153"),
("203","203","15135844254759313407","deep","153"),
("204","204","15136336032519143764","deep","153"),
("205","205","15137874646371581254","deep","153"),
("206","206","15142932189653751510","deep","153"),
("207","207","15149041490583483840","deep","153"),
("208","208","15154523898360664925","deep","153"),
("209","209","15161182712022413911","deep","153"),
("210","210","15164606423822058364","deep","153"),
("211","211","15167575840519774474","deep","153"),
("212","212","15169272328529441517","deep","153"),
("213","213","15171534354042944122","deep","153"),
("214","214","15174315160803120312","deep","153"),
("215","215","15179327553900240234","deep","153"),
("216","216","15204997784249618750","deep","153"),
("217","217","15209628332520455385","deep","153"),
("218","218","15214575942869078571","deep","153"),
("219","219","15215615111434537384","deep","153"),
("220","220","15217608016093935921","deep","153"),
("221","221","15219241847576461724","deep","153"),
("222","222","15228320565203910164","deep","153"),
("223","223","15237384563232932551","deep","153"),
("224","224","15240513984604201006","deep","153"),
("225","225","15243386053155506011","deep","153"),
("226","226","15243481275080561620","deep","153"),
("227","227","15262015625016852254","deep","153"),
("228","228","15268724510418606515","deep","153"),
("229","229","15282702888581061066","deep","153"),
("230","230","15284826371602061730","deep","153"),
("231","231","15287418865028449494","deep","153"),
("232","232","15292915992404056632","deep","153"),
("233","233","15296375060640247603","deep","153"),
("234","234","15297032380084455833","deep","153"),
("235","235","15307541900557182893","deep","153"),
("236","236","15312489510905806079","deep","153"),
("237","237","15322212958895359488","deep","153"),
("238","238","15339379166808480038","deep","153"),
("239","239","15358021327751929542","deep","153"),
("240","240","15358902613570224210","deep","153"),
("241","241","15366590132936684244","deep","153"),
("242","242","15367737108214334631","deep","153"),
("243","243","15370171723188525546","deep","153"),
("244","244","15393906783850691824","deep","153"),
("245","245","15397488374102533126","deep","153"),
("246","246","15400847298858713547","deep","153"),
("247","247","15408532692003818085","deep","153"),
("248","248","15414152337100108258","deep","153"),
("249","249","15414981429252009451","deep","153"),
("250","250","15415581018018998678","deep","153"),
("251","251","15429205240264568140","deep","153"),
("252","252","15431145951257573202","deep","153"),
("253","253","15434115367955289312","deep","153"),
("254","254","15438941281631192106","deep","153"),
("255","255","15439222982977464843","deep","153"),
("256","256","15450879474432874994","deep","153"),
("257","257","15458956506152766635","deep","153"),
("258","258","15460335111036684484","deep","153"),
("259","259","15460652998457400974","deep","153"),
("260","260","15464169801665778244","deep","153"),
("261","261","15466886117986241896","deep","153"),
("262","262","15467593513465422697","deep","153"),
("263","263","15499418190634616581","deep","153"),
("264","264","15505529613490737111","deep","153"),
("265","265","15511908026684638917","deep","153"),
("266","266","15516074490400010689","deep","153"),
("267","267","15516132225372196988","deep","153"),
("268","268","15517071254752612547","deep","153"),
("269","269","15527068740856257669","deep","153"),
("270","270","15532796192664739416","deep","153"),
("271","271","15540668069526028378","deep","153"),
("272","272","15556486103141855360","deep","153"),
("273","273","15558263394376870749","deep","153"),
("274","274","15563478816111237854","deep","153"),
("275","275","15563586627118396724","deep","153"),
("276","276","15572665340450877868","deep","153"),
("277","277","15579736433820501718","deep","153"),
("278","278","15582598039511058958","deep","153"),
("279","279","15587228592076862889","deep","153"),
("280","280","15590353761005420352","deep","153"),
("281","281","15593872690435153118","deep","153"),
("282","282","15596234855133698977","deep","153"),
("283","283","15596746885207813619","deep","153"),
("284","284","15598335570800256384","deep","153"),
("285","285","15605421375178371695","deep","153"),
("286","286","15606360400263819958","deep","153"),
("287","287","15619507564347985116","deep","153"),
("288","288","15631309349468456151","deep","153"),
("289","289","15648412896559468165","deep","153"),
("290","290","15654401797399938364","deep","153"),
("291","291","15663920094825856390","deep","153"),
("292","292","15665350897671135010","deep","153"),
("293","293","15673975315901687811","deep","153"),
("294","294","15676076031568245218","deep","153"),
("295","295","15689808064820973550","deep","153"),
("296","296","15691251456748355431","deep","153"),
("297","297","15699436295180438646","deep","153"),
("298","298","15709599327263428937","deep","153"),
("299","299","15718063740820429393","deep","153"),
("300","300","15738743336857489885","deep","153"),
("301","301","15740686174071850443","deep","153"),
("302","302","15742367951073026025","deep","153"),
("303","303","15743201295667638210","deep","153"),
("304","304","15744202977280227713","deep","153"),
("305","305","15756943787486147011","deep","153"),
("306","306","15783662980149488156","deep","153"),
("307","307","15786644981634340231","deep","153"),
("308","308","15787122048385679127","deep","153"),
("309","309","15796858085457335797","deep","153"),
("310","310","15820607857127993536","deep","153"),
("311","311","15821489147241255500","deep","153"),
("312","312","15846292802780830809","deep","153"),
("313","313","15852439582073497857","deep","153"),
("314","314","15854417775724404933","deep","153"),
("315","315","15856692386025043503","deep","153"),
("316","316","15856787603655131816","deep","153"),
("317","317","15864327707430142766","deep","153"),
("318","318","15880492229435706517","deep","153"),
("319","319","15882018254206040746","deep","153"),
("320","320","15884450742958876165","deep","153"),
("321","321","15889666164693243270","deep","153"),
("322","322","15891109556620625151","deep","153"),
("323","323","15905990691372359366","deep","153"),
("324","324","15910286514992632554","deep","153"),
("325","325","15911327809779446863","deep","153"),
("326","326","15912424713317091975","deep","153"),
("327","327","15915004621956343774","deep","153"),
("328","328","15917329299702020323","deep","153"),
("329","329","15921063846851103533","deep","153"),
("330","330","15929522723397278461","deep","153"),
("331","331","15930129975396448712","deep","153"),
("332","332","15930621753156279069","deep","153"),
("333","333","15931681174036022167","deep","153"),
("334","334","15932547748845825374","deep","153"),
("335","335","15932657681779372444","deep","153"),
("336","336","15933696850344831257","deep","153"),
("337","337","15935019846477918303","deep","153"),
("338","338","15937655363868000905","deep","153"),
("339","339","15947615367313744013","deep","153"),
("340","340","15951399986202832498","deep","153"),
("341","341","15963889822252854834","deep","153"),
("342","342","15966575411382942711","deep","153"),
("343","343","15966857112729215448","deep","153"),
("344","344","15967298818749040530","deep","153"),
("345","345","15969384819112139180","deep","153"),
("346","346","15972476757825505621","deep","153"),
("347","347","15978181831098347587","deep","153"),
("348","348","15982474243929150743","deep","153"),
("349","349","15990217376341408876","deep","153"),
("350","350","15992318092007966283","deep","153"),
("351","351","16006821478145442213","deep","153"),
("352","352","16009471710838983572","deep","153"),
("353","353","16018377830415809110","deep","153"),
("354","354","16020458289473114936","deep","153"),
("355","355","16034088057319444518","deep","153"),
("356","356","16036083088200198551","deep","153"),
("357","357","16043766355123947593","deep","153"),
("358","358","16047726994868472737","deep","153"),
("359","359","16048179163749045584","deep","153"),
("360","360","16049877782275035419","deep","153"),
("361","361","16050217222888461751","deep","153"),
("362","362","16066821324692495088","deep","153"),
("363","363","16075006163124578303","deep","153"),
("364","364","16080899846334960189","deep","153"),
("365","365","16081702459444229303","deep","153"),
("366","366","16085124045022518260","deep","153"),
("367","367","16087054293154775557","deep","153"),
("368","368","16092543748708267079","deep","153"),
("369","369","16107277467868552210","deep","153"),
("370","370","16110854136565438571","deep","153"),
("371","371","16122460560575810743","deep","153"),
("372","372","16124383141180919720","deep","153"),
("373","373","16134998342144482858","deep","153"),
("374","374","16140532947883024714","deep","153"),
("375","375","16160778505427408444","deep","153"),
("376","376","16162157114606293589","deep","153"),
("377","377","16167264725333501824","deep","153"),
("378","378","16179522931777256698","deep","153"),
("379","379","16180459834936316761","deep","153"),
("380","380","16186716547162530879","deep","153"),
("381","381","16208925583054362928","deep","153"),
("382","382","16213873193402986114","deep","153"),
("383","383","16216844736322057720","deep","153"),
("384","384","16237369868991358691","deep","153"),
("385","385","16246716393709583754","deep","153"),
("386","386","16248074746279217318","deep","153"),
("387","387","16253681806588371526","deep","153"),
("388","388","16257261270618857332","deep","153"),
("389","389","16260780200048590098","deep","153"),
("390","390","16263322626029939883","deep","153"),
("391","391","16263870012540601043","deep","153"),
("392","392","16266716907222666822","deep","153"),
("393","393","16268270232083595773","deep","153"),
("394","394","16268320303823601048","deep","153"),
("395","395","16270516237120246768","deep","153"),
("396","396","16270783227458028044","deep","153"),
("397","397","16279140659645766865","deep","153"),
("398","398","16280021945464061533","deep","153"),
("399","399","16291615780392330444","deep","153"),
("400","400","16298166787341887856","deep","153"),
("401","401","16300195052732800207","deep","153"),
("402","402","16307888109110085769","deep","153"),
("403","403","16335001731386846166","deep","153"),
("404","404","16351557891967197020","deep","153"),
("405","405","16352107404699213676","deep","153"),
("406","406","16352597056237688537","deep","153"),
("407","407","16359647508474224626","deep","153"),
("408","408","16368819317510405883","deep","153"),
("409","409","16370302318317045274","deep","153"),
("410","410","16372230440227947075","deep","153"),
("411","411","16375797315176329620","deep","153"),
("412","412","16386509864286303863","deep","153"),
("413","413","16394062552848450778","deep","153"),
("414","414","16397034095767522384","deep","153"),
("415","415","16408344103128163062","deep","153"),
("416","416","16418838904002464069","deep","153"),
("417","417","16418961430313081696","deep","153"),
("418","418","16420819223874726641","deep","153"),
("419","419","16428309255909732316","deep","153"),
("420","420","16431878257079470357","deep","153"),
("421","421","16431986068086629227","deep","153"),
("422","422","16435942455388443379","deep","153"),
("423","423","16436396750490371722","deep","153"),
("424","424","16446719782951947062","deep","153"),
("425","425","16450071044475946459","deep","153"),
("426","426","16459742298799106393","deep","153"),
("427","427","16469920041890588145","deep","153"),
("428","428","16483449046506069294","deep","153"),
("429","429","16500110887577256226","deep","153"),
("430","430","16512598601700890362","deep","153"),
("431","431","16513799896866289720","deep","153"),
("432","432","16525341538128165156","deep","153"),
("433","433","16526345345962110155","deep","153"),
("434","434","16546518453230848829","deep","153"),
("435","435","16559159119956757577","deep","153"),
("436","436","16570657737254938175","deep","153"),
("437","437","16579282155485490976","deep","153"),
("438","438","16582366426671709097","deep","153"),
("439","439","16590339062468879196","deep","153"),
("440","440","16591488163967885079","deep","153"),
("441","441","16599455258459262354","deep","153"),
("442","442","16604071095721607528","deep","153"),
("443","443","16608152131260427507","deep","153"),
("444","444","16610622102671164940","deep","153"),
("445","445","16616731399305929974","deep","153"),
("446","446","16617722622352739008","deep","153"),
("447","447","16618097419402711858","deep","153"),
("448","448","16639419623875489119","deep","153"),
("449","449","16650521681043927673","deep","153"),
("450","450","16651590280216304000","deep","153"),
("451","451","16653945392843572126","deep","153"),
("452","452","16664268429600114762","deep","153"),
("453","453","16675767046898295360","deep","153"),
("454","454","16678249603096168758","deep","153"),
("455","455","16681276759061038463","deep","153"),
("456","456","16683841948101864209","deep","153"),
("457","457","16690500761763613195","deep","153"),
("458","458","16693470178461329305","deep","153"),
("459","459","16697159575425362181","deep","153"),
("460","460","16700006470107427960","deep","153"),
("461","461","16740375063180545089","deep","153"),
("462","462","16761205489893491993","deep","153"),
("463","463","16772654035451667316","deep","153"),
("464","464","16784297937824974206","deep","153"),
("465","465","16797495169354177343","deep","153"),
("466","466","16800022880032068371","deep","153"),
("467","467","16800570270837696827","deep","153"),
("468","468","16809541177457986397","deep","153"),
("469","469","16813167913599910737","deep","153"),
("470","470","16816626981836101708","deep","153"),
("471","471","16825216043630107991","deep","153"),
("472","472","16828732851133452557","deep","153"),
("473","473","16830308943348824765","deep","153"),
("474","474","16831955363913453829","deep","153"),
("475","475","16838945950661480827","deep","153"),
("476","476","16847020856160016972","deep","153"),
("477","477","16883712637056237190","deep","153"),
("478","478","16894489968914708169","deep","153"),
("479","479","16905923799169424735","deep","153"),
("480","480","16917582416846190382","deep","153"),
("481","481","16922783123277098730","deep","153"),
("482","482","16926806423843732410","deep","153"),
("483","483","16938947645282662481","deep","153"),
("484","484","16949564972467581115","deep","153"),
("485","485","16960024421200302900","deep","153"),
("486","486","16962104884552576022","deep","153"),
("487","487","16975185131076954356","deep","153"),
("488","488","16977178040031320189","deep","153"),
("489","489","16980147456729036299","deep","153"),
("490","490","16986841626827331803","deep","153"),
("491","491","16996297263431141293","deep","153"),
("492","492","17015004207123087533","deep","153"),
("493","493","17052536083786478879","deep","153"),
("494","494","17067566219596495504","deep","153"),
("495","495","17076725439550573500","deep","153"),
("496","496","17079267861236955989","deep","153"),
("497","497","17127211910226663290","deep","153"),
("498","498","17156963176114861785","deep","153"),
("499","499","17177181429273683497","deep","153"),
("500","500","17179319627598142918","deep","153"),
("501","501","17188398340930624062","deep","153"),
("502","502","17209070893486341413","deep","153"),
("503","503","17221119023516538667","deep","153"),
("504","504","17240346053628551345","deep","153"),
("505","505","17244758862253649336","deep","153"),
("506","506","17251844670926731943","deep","153"),
("507","507","17275094997310411005","deep","153"),
("508","508","17316108325040600399","deep","153"),
("509","509","17317539127885879019","deep","153"),
("510","510","17326775719670557012","deep","153"),
("511","511","17330684161453721385","deep","153"),
("512","512","17349975978609198095","deep","153"),
("513","513","17406386567377261348","deep","153"),
("514","514","17418996803516545815","deep","153"),
("515","515","17421084930100999961","deep","153"),
("516","516","17442796646927208829","deep","153"),
("517","517","17455819158479400864","deep","153"),
("518","518","17460487193703106809","deep","153"),
("519","519","17475113101856233070","deep","153"),
("520","520","17501844879306710180","deep","153"),
("521","521","17555835568404041275","deep","153"),
("522","522","17601846573927891834","deep","153"),
("523","523","17619549709785893075","deep","153"),
("524","524","17640676553148571473","deep","153"),
("525","525","17664865908912666094","deep","153"),
("526","526","17688066167851307177","deep","153"),
("527","527","17693223850318520687","deep","153"),
("528","528","17710926986176521928","deep","153"),
("529","529","17764817531793842473","deep","153"),
("530","530","17819357737918157520","deep","153"),
("531","531","17867447076277958409","deep","153"),
("532","532","17981585031808758759","deep","153"),
("533","533","18177484618157858831","deep","153"),
("534","534","2172596508666109724","deep","153"),
("535","535","2241857840573639345","deep","153"),
("536","536","2496256146570224112","deep","153"),
("537","537","3053056668746642742","deep","153"),
("538","538","3075008896868000807","deep","153"),
("539","539","3301063972467222442","deep","153"),
("540","540","3339584945956067326","deep","153"),
("541","541","4110560470426047182","deep","153"),
("542","542","4461868532330447162","deep","153"),
("543","543","4547698613900430898","deep","153"),
("544","544","5074453579760275035","deep","153"),
("0","0","10024680183273821320","deep","154"),
("1","1","10989978206108226905","deep","154"),
("2","2","11096076612577037628","deep","154"),
("3","3","11102173320129699401","deep","154"),
("4","4","11182895790972474902","deep","154"),
("5","5","11240001186137615695","deep","154"),
("6","6","11269714965072944880","deep","154"),
("7","7","11389984984592953521","deep","154"),
("8","8","11462632549937192877","deep","154"),
("9","9","11473142070409919937","deep","154"),
("10","10","11474825969337483719","deep","154"),
("11","11","11498480523378053145","deep","154"),
("12","12","11513641233254704601","deep","154"),
("13","13","11674134556477736783","deep","154"),
("14","14","11774098768441016423","deep","154"),
("15","15","11829225969955250140","deep","154"),
("16","16","11964049058533936510","deep","154"),
("17","17","11966064734842745600","deep","154"),
("18","18","12039701397012438494","deep","154"),
("19","19","12046787201390553805","deep","154"),
("20","20","12069728526337365408","deep","154"),
("21","21","12100468889051017441","deep","154"),
("22","22","12110903439912973177","deep","154"),
("23","23","12114032861284241632","deep","154"),
("24","24","12121156152615226253","deep","154"),
("25","25","12162368548848736036","deep","154"),
("26","26","12176540161899933954","deep","154"),
("27","27","12206986234185209989","deep","154"),
("28","28","12229232748439976756","deep","154"),
("29","29","12234597171232626271","deep","154"),
("30","30","12236281074455157349","deep","154"),
("31","31","12253838916648097706","deep","154"),
("32","32","12260924725321180313","deep","154"),
("33","33","12290713469572313526","deep","154"),
("34","34","12293386469620298142","deep","154"),
("35","35","12294099703009023261","deep","154"),
("36","36","12297799278245396133","deep","154"),
("37","37","12301185507387138572","deep","154"),
("38","38","12310981794471140513","deep","154"),
("39","39","12365044938139083960","deep","154"),
("40","40","12370152548866292195","deep","154"),
("41","41","12395090494455658453","deep","154"),
("42","42","12415064524631142146","deep","154"),
("43","43","12437729981846258034","deep","154"),
("44","44","12474861346835915134","deep","154"),
("45","45","12481615378127752433","deep","154"),
("46","46","12486028186752850424","deep","154"),
("47","47","12499868026717770330","deep","154"),
("48","48","12506953835390852937","deep","154"),
("49","49","12511366644015950928","deep","154"),
("50","50","12513382320324760018","deep","154"),
("51","51","12534639737754073247","deep","154"),
("52","52","12538025966895815686","deep","154"),
("53","53","12560359651024653562","deep","154"),
("54","54","12567777232784014181","deep","154"),
("55","55","12600896300822307536","deep","154"),
("56","56","12624513372204974948","deep","154"),
("57","57","12639674082081626404","deep","154"),
("58","58","12647748987580162549","deep","154"),
("59","59","12683634443678924831","deep","154"),
("60","60","12737040263607692752","deep","154"),
("61","61","12737991877775244276","deep","154"),
("62","62","12754266332714355097","deep","154"),
("63","63","12797732790330467671","deep","154"),
("64","64","12801851304232222368","deep","154"),
("65","65","12818751826980954495","deep","154"),
("66","66","12828929570072436247","deep","154"),
("67","67","12833618246429229953","deep","154"),
("68","68","12835026281920065316","deep","154"),
("69","69","12857235317811897365","deep","154"),
("70","70","12861685609094897370","deep","154"),
("71","71","12868771413473012681","deep","154"),
("72","72","12871825869528477108","deep","154"),
("73","73","12886986579405128564","deep","154"),
("74","74","12923529363538033668","deep","154"),
("75","75","12929225559416961195","deep","154"),
("76","76","12930946941002426991","deep","154"),
("77","77","12961318047971898998","deep","154"),
("78","78","12972816660975112300","deep","154"),
("79","79","13017728636739962251","deep","154"),
("80","80","13019174154888699628","deep","154"),
("81","81","13019412539962493329","deep","154"),
("82","82","13024851928070946872","deep","154"),
("83","83","13086989972942459168","deep","154"),
("84","84","13088435491091196545","deep","154"),
("85","85","13092429356755945415","deep","154"),
("86","86","13093086680495120941","deep","154"),
("87","87","13094075777320574479","deep","154"),
("88","88","13094113259978476493","deep","154"),
("89","89","13097737874194012633","deep","154"),
("90","90","13115789620368138843","deep","154"),
("91","91","13123532752780396976","deep","154"),
("92","92","13133347462561079200","deep","154"),
("93","93","13155593981110813263","deep","154"),
("94","94","13161358919872164320","deep","154"),
("95","95","13166066018925638309","deep","154"),
("96","96","13174798243868382684","deep","154"),
("97","97","13178259438325929151","deep","154"),
("98","98","13181921535199367305","deep","154"),
("99","99","13188731476140754197","deep","154"),
("100","100","13189426282537831737","deep","154"),
("101","101","13199185086963931664","deep","154"),
("102","102","13211635318429663786","deep","154"),
("103","103","13255595675731994917","deep","154"),
("104","104","13278880974028384317","deep","154"),
("105","105","13279907553511739869","deep","154"),
("106","106","13283331265311384322","deep","154"),
("107","107","13295068263388391325","deep","154"),
("108","108","13315060724850489893","deep","154"),
("109","109","13320130852919796114","deep","154"),
("110","110","13321157432403151666","deep","154"),
("111","111","13325275950599873659","deep","154"),
("112","112","13347190696063329710","deep","154"),
("113","113","13348179792888783248","deep","154"),
("114","114","13391370382773200107","deep","154"),
("115","115","13399901709595020091","deep","154"),
("116","116","13416051516297125085","deep","154"),
("117","117","13423794644414415922","deep","154"),
("118","118","13432288488578333892","deep","154"),
("119","119","13434009874458766984","deep","154"),
("120","120","13440363394076870037","deep","154"),
("121","121","13474638276228049598","deep","154"),
("122","122","13488809889279247516","deep","154"),
("123","123","13529178478057397349","deep","154"),
("124","124","13529198244486149105","deep","154"),
("125","125","13542086470283517487","deep","154"),
("126","126","13544815375686084400","deep","154"),
("127","127","13546499278908615478","deep","154"),
("128","128","13551569411272888995","deep","154"),
("129","129","13559681795134359858","deep","154"),
("130","130","13563068024276102297","deep","154"),
("131","131","13581652450247365502","deep","154"),
("132","132","13588700771967578799","deep","154"),
("133","133","13592819290164300792","deep","154"),
("134","134","13595824063298563420","deep","154"),
("135","135","13649887202671539571","deep","154"),
("136","136","13655233202767508803","deep","154"),
("137","137","13706992597836680364","deep","154"),
("138","138","13737660996160219870","deep","154"),
("139","139","13743757708007848939","deep","154"),
("140","140","13757669512362881372","deep","154"),
("141","141","13758990382274612922","deep","154"),
("142","142","13768711704042810835","deep","154"),
("143","143","13801879504384005288","deep","154"),
("144","144","13801924164388555797","deep","154"),
("145","145","13803570580658217565","deep","154"),
("146","146","13810380525894571753","deep","154"),
("147","147","13823563042120316133","deep","154"),
("148","148","13854426801553954502","deep","154"),
("149","149","13854541785612794571","deep","154"),
("150","150","13855949821103629934","deep","154"),
("151","151","13918984746096198956","deep","154"),
("152","152","13922503675525931722","deep","154"),
("153","153","13939217714558479425","deep","154"),
("154","154","13940371867182778307","deep","154"),
("155","155","13945773772633329836","deep","154"),
("156","156","13954378424435130881","deep","154"),
("157","157","13970542946440694632","deep","154"),
("158","158","13992658886628826568","deep","154"),
("159","159","13995736114333701548","deep","154"),
("160","160","14008968702299451203","deep","154"),
("161","161","14015454047501208578","deep","154"),
("162","162","14029919950980782494","deep","154"),
("163","163","14056423099750683643","deep","154"),
("164","164","14109324548542550650","deep","154"),
("165","165","14114322230631179111","deep","154"),
("166","166","14125489070548114401","deep","154"),
("167","167","14126038587575098353","deep","154"),
("168","168","14128932548776510610","deep","154"),
("169","169","14138671591068826077","deep","154"),
("170","170","14139386159599688077","deep","154"),
("171","171","14142772388741430516","deep","154"),
("172","172","14148739401226760759","deep","154"),
("173","173","14153319391872059590","deep","154"),
("174","174","14159378616766819349","deep","154"),
("175","175","14177925560080180540","deep","154"),
("176","176","14179025464543517153","deep","154"),
("177","177","14180029276672429448","deep","154"),
("178","178","14186565568318528103","deep","154"),
("179","179","14191073594573714407","deep","154"),
("180","180","14202825307954180167","deep","154"),
("181","181","14215494919401473900","deep","154"),
("182","182","14216412051836814911","deep","154"),
("183","183","14217401148662268449","deep","154"),
("184","184","14218455032531186019","deep","154"),
("185","185","14227079450761738820","deep","154"),
("186","186","14241127662797983106","deep","154"),
("187","187","14254837807695571482","deep","154"),
("188","188","14261358505038908079","deep","154"),
("189","189","14266394159965938379","deep","154"),
("190","190","14266458942714435115","deep","154"),
("191","191","14289694558089622716","deep","154"),
("192","192","14294752101371792972","deep","154"),
("193","193","14304285109806202459","deep","154"),
("194","194","14306270480803758030","deep","154"),
("195","195","14307789328227443764","deep","154"),
("196","196","14308828496792902577","deep","154"),
("197","197","14311340613168031547","deep","154"),
("198","198","14316413746457996565","deep","154"),
("199","199","14328474465570297080","deep","154"),
("200","200","14331039654611122826","deep","154"),
("201","201","14337980173914111845","deep","154"),
("202","202","14344199407777391245","deep","154"),
("203","203","14352556014622200127","deep","154"),
("204","204","14361780017324774859","deep","154"),
("205","205","14369964855756858074","deep","154"),
("206","206","14372932146233218688","deep","154"),
("207","207","14375950755671636772","deep","154"),
("208","208","14382999081686817365","deep","154"),
("209","209","14384025656875205621","deep","154"),
("210","210","14384603352992087596","deep","154"),
("211","211","14404222021678887377","deep","154"),
("212","212","14405225833807799672","deep","154"),
("213","213","14408780119674078956","deep","154"),
("214","214","14420950771719926541","deep","154"),
("215","215","14428526231931484009","deep","154"),
("216","216","14451126902103135865","deep","154"),
("217","217","14452276003602141748","deep","154"),
("218","218","14453719395529523629","deep","154"),
("219","219","14456234517125311396","deep","154"),
("220","220","14469821261007946140","deep","154"),
("221","221","14476530146409700401","deep","154"),
("222","222","14484944488226695582","deep","154"),
("223","223","14510335139156189561","deep","154"),
("224","224","14515894923058937939","deep","154"),
("225","225","14516284435412369546","deep","154"),
("226","226","14519253852110085656","deep","154"),
("227","227","14528932149914588731","deep","154"),
("228","228","14538533080183459105","deep","154"),
("229","229","14542064598695295132","deep","154"),
("230","230","14544642376818224139","deep","154"),
("231","231","14546240361683703599","deep","154"),
("232","232","14548109112581563430","deep","154"),
("233","233","14552667210576755009","deep","154"),
("234","234","14554220535437683960","deep","154"),
("235","235","14575542744205428517","deep","154"),
("236","236","14578901668961608938","deep","154"),
("237","237","14588125675959150966","deep","154"),
("238","238","14593585316381888794","deep","154"),
("239","239","14595600992690697884","deep","154"),
("240","240","14602714101454375213","deep","154"),
("241","241","14603690609197725490","deep","154"),
("242","242","14603703198279828751","deep","154"),
("243","243","14607771644736545469","deep","154"),
("244","244","14608796097998545525","deep","154"),
("245","245","14612791215180313886","deep","154"),
("246","246","14615297033208097662","deep","154"),
("247","247","14620866120678850031","deep","154"),
("248","248","14641089785573126509","deep","154"),
("249","249","14651584590742394812","deep","154"),
("250","250","14661747618530417807","deep","154"),
("251","251","14667259461209483702","deep","154"),
("252","252","14668798070766953896","deep","154"),
("253","253","14669275133223325496","deep","154"),
("254","254","14685989172255873199","deep","154"),
("255","255","14689066395665780883","deep","154"),
("256","256","14689395167826367394","deep","154"),
("257","257","14690559859333168039","deep","154"),
("258","258","14692105646237286728","deep","154"),
("259","259","14696606499440791833","deep","154"),
("260","260","14698049891368173714","deep","154"),
("261","261","14700180551735822873","deep","154"),
("262","262","14709643726296442625","deep","154"),
("263","263","14712171432679366357","deep","154"),
("264","264","14719841235816676133","deep","154"),
("265","265","14720311120926399238","deep","154"),
("266","266","14720830332642129671","deep","154"),
("267","267","14721395439676908385","deep","154"),
("268","268","14722349180065815405","deep","154"),
("269","269","14725366537987213998","deep","154"),
("270","270","14729325051510383646","deep","154"),
("271","271","14740541963167324211","deep","154"),
("272","272","14745100065457483086","deep","154"),
("273","273","14746199095216483694","deep","154"),
("274","274","14747577700100401543","deep","154"),
("275","275","14751094507603746109","deep","154"),
("276","276","14754273996420052543","deep","154"),
("277","277","14762203612548495100","deep","154"),
("278","278","14765742308406979622","deep","154"),
("279","279","14771819253825856935","deep","154"),
("280","280","14795493570000210821","deep","154"),
("281","281","14808229329080837120","deep","154"),
("282","282","14811638329871990112","deep","154"),
("283","283","14821851429400018382","deep","154"),
("284","284","14822847703572120415","deep","154"),
("285","285","14827895943286286680","deep","154"),
("286","286","14827948141247647451","deep","154"),
("287","287","14828497653979664107","deep","154"),
("288","288","14830314968252682833","deep","154"),
("289","289","14836976782840123320","deep","154"),
("290","290","14838405463759013740","deep","154"),
("291","291","14839114981164582741","deep","154"),
("292","292","14839122158511231236","deep","154"),
("293","293","14839836266604292360","deep","154"),
("294","294","14840543657788505865","deep","154"),
("295","295","14848570617768392231","deep","154"),
("296","296","14850598883159304582","deep","154"),
("297","297","14852687009743758728","deep","154"),
("298","298","14854225623596196218","deep","154"),
("299","299","14856096006239944424","deep","154"),
("300","300","14864198211829075291","deep","154"),
("301","301","14871379238132246211","deep","154"),
("302","302","14871833537529141850","deep","154"),
("303","303","14876219041768677823","deep","154"),
("304","304","14888374978511066651","deep","154"),
("305","305","14889428862379984221","deep","154"),
("306","306","14903108697671351782","deep","154"),
("307","307","14908231027996986070","deep","154"),
("308","308","14910159149907887871","deep","154"),
("309","309","14911090507466187814","deep","154"),
("310","310","14916745508999024505","deep","154"),
("311","311","14919223147936910258","deep","154"),
("312","312","14922792149106648299","deep","154"),
("313","313","14928851378296375354","deep","154"),
("314","314","14929890546861834167","deep","154"),
("315","315","14936883259831216661","deep","154"),
("316","316","14947581089342764851","deep","154"),
("317","317","14949024485565114028","deep","154"),
("318","318","14960083518769857744","deep","154"),
("319","319","14961767417697421526","deep","154"),
("320","320","14964736834395137636","deep","154"),
("321","321","14966677545388142698","deep","154"),
("322","322","14971395648056886622","deep","154"),
("323","323","14975960923398726696","deep","154"),
("324","324","14976343258405509808","deep","154"),
("325","325","14981305584057591751","deep","154"),
("326","326","14981852970568252911","deep","154"),
("327","327","14983831164219159987","deep","154"),
("328","328","14988391388435707062","deep","154"),
("329","329","14988881039974181923","deep","154"),
("330","330","14993511592539985854","deep","154"),
("331","331","15001132198641626360","deep","154"),
("332","332","15008122785389653358","deep","154"),
("333","333","15012203820928473337","deep","154"),
("334","334","15015173237626189447","deep","154"),
("335","335","15018300532776102406","deep","154"),
("336","336","15021804746902376415","deep","154"),
("337","337","15022698626097741640","deep","154"),
("338","338","15030896053611928116","deep","154"),
("339","339","15034854562840130468","deep","154"),
("340","340","15035441562525016434","deep","154"),
("341","341","15036430659350469972","deep","154"),
("342","342","15039412665130289343","deep","154"),
("343","343","15052045664329049771","deep","154"),
("344","344","15056661501591394945","deep","154"),
("345","345","15057600526676843208","deep","154"),
("346","346","15061234314890045281","deep","154"),
("347","347","15063494209887225094","deep","154"),
("348","348","15071237338004515931","deep","154"),
("349","349","15074661049804160384","deep","154"),
("350","350","15074806343469221268","deep","154"),
("351","351","15083378563738413298","deep","154"),
("352","352","15086362695739588165","deep","154"),
("353","353","15090096752708171550","deep","154"),
("354","354","15091518251985446179","deep","154"),
("355","355","15092911576467790081","deep","154"),
("356","356","15093448500117703476","deep","154"),
("357","357","15094784085332893783","deep","154"),
("358","358","15098446182206331937","deep","154"),
("359","359","15099839502393708543","deep","154"),
("360","360","15105654508600097579","deep","154"),
("361","361","15106094092693534461","deep","154"),
("362","362","15114733226227546019","deep","154"),
("363","363","15121833745909120087","deep","154"),
("364","364","15122758059986076889","deep","154"),
("365","365","15129201255928475431","deep","154"),
("366","366","15135355702748290799","deep","154"),
("367","367","15136005358960318005","deep","154"),
("368","368","15144469776812285757","deep","154"),
("369","369","15149469580827302418","deep","154"),
("370","370","15149527320094456013","deep","154"),
("371","371","15153108910346297315","deep","154"),
("372","372","15158937806513215169","deep","154"),
("373","373","15160071318004426290","deep","154"),
("374","374","15162122836635314427","deep","154"),
("375","375","15163111933460767965","deep","154"),
("376","376","15163214203162134011","deep","154"),
("377","377","15167576940047226727","deep","154"),
("378","378","15178621257948511686","deep","154"),
("379","379","15180332465556604782","deep","154"),
("380","380","15181256775338594288","deep","154"),
("381","381","15183301877959353596","deep","154"),
("382","382","15188357295020168356","deep","154"),
("383","383","15189933391530507860","deep","154"),
("384","384","15201871588627158044","deep","154"),
("385","385","15216713114499634749","deep","154"),
("386","386","15219682531197350859","deep","154"),
("387","387","15237335591020379529","deep","154"),
("388","388","15237877440520215161","deep","154"),
("389","389","15238831180909122181","deep","154"),
("390","390","15243337085237920285","deep","154"),
("391","391","15246856014667653051","deep","154"),
("392","392","15248884280058565402","deep","154"),
("393","393","15249044284732117747","deep","154"),
("394","394","15252121508142025431","deep","154"),
("395","395","15253552310987304051","deep","154"),
("396","396","15253991890785773637","deep","154"),
("397","397","15261575018524479425","deep","154"),
("398","398","15267232146278671612","deep","154"),
("399","399","15267563919364949624","deep","154"),
("400","400","15267736513120605230","deep","154"),
("401","401","15268147913829176793","deep","154"),
("402","402","15276310859611152756","deep","154"),
("403","403","15277314671740065051","deep","154"),
("404","404","15277754255833501933","deep","154"),
("405","405","15278303768565518589","deep","154"),
("406","406","15289947675233792775","deep","154"),
("407","407","15295349580684344304","deep","154"),
("408","408","15298918581854082345","deep","154"),
("409","409","15307036507021346032","deep","154"),
("410","410","15310670295234548105","deep","154"),
("411","411","15311501513607804794","deep","154"),
("412","412","15319136835012904057","deep","154"),
("413","413","15324097034443630504","deep","154"),
("414","414","15324804425627844009","deep","154"),
("415","415","15326170445724625893","deep","154"),
("416","416","15329254716910844014","deep","154"),
("417","417","15333335752449663993","deep","154"),
("418","418","15334822168340740712","deep","154"),
("419","419","15337829063401391540","deep","154"),
("420","420","15341907972718856023","deep","154"),
("421","421","15344927461156577408","deep","154"),
("422","422","15353408716238392117","deep","154"),
("423","423","15355546914562851538","deep","154"),
("424","424","15369169010587065504","deep","154"),
("425","425","15372578007083251200","deep","154"),
("426","426","15373140113192338413","deep","154"),
("427","427","15383305271496684200","deep","154"),
("428","428","15383744851295153786","deep","154"),
("429","429","15386395083988695145","deep","154"),
("430","430","15393416105618313720","deep","154"),
("431","431","15395888203250406649","deep","154"),
("432","432","15397974203613505299","deep","154"),
("433","433","15400501909996429031","deep","154"),
("434","434","15413041817786456642","deep","154"),
("435","435","15417655528827446320","deep","154"),
("436","436","15426626435447735890","deep","154"),
("437","437","15427068141467560972","deep","154"),
("438","438","15427175952474719842","deep","154"),
("439","439","15428165049300173380","deep","154"),
("440","440","15428619344402101723","deep","154"),
("441","441","15429610567448910757","deep","154"),
("442","442","15431292344450086339","deep","154"),
("443","443","15432138273831834489","deep","154"),
("444","444","15435707275001572530","deep","154"),
("445","445","15436146859095009412","deep","154"),
("446","446","15440263251070375909","deep","154"),
("447","447","15440385773086026240","deep","154"),
("448","448","15446764186279928046","deep","154"),
("449","449","15453503502268306588","deep","154"),
("450","450","15455938117242497503","deep","154"),
("451","451","15456269890328775515","deep","154"),
("452","452","15460076401867971252","deep","154"),
("453","453","15460950514634584721","deep","154"),
("454","454","15465124641582137517","deep","154"),
("455","455","15465159998018684035","deep","154"),
("456","456","15466592927085318151","deep","154"),
("457","457","15467486806280683376","deep","154"),
("458","458","15472102639248061254","deep","154"),
("459","459","15473641253100498744","deep","154"),
("460","460","15474082959120323826","deep","154"),
("461","461","15475619446751405820","deep","154"),
("462","462","15479685766986767042","deep","154"),
("463","463","15479750549735263778","deep","154"),
("464","464","15484698160083886964","deep","154"),
("465","465","15486288967602717929","deep","154"),
("466","466","15487225870761777992","deep","154"),
("467","467","15488360256957325118","deep","154"),
("468","468","15489256258079078543","deep","154"),
("469","469","15491943973430521916","deep","154"),
("470","470","15496796361854089493","deep","154"),
("471","471","15499326194458368721","deep","154"),
("472","472","15500850093007347454","deep","154"),
("473","473","15501507416746522980","deep","154"),
("474","474","15501903976876265024","deep","154"),
("475","475","15506801515484882935","deep","154"),
("476","476","15510571419070512663","deep","154"),
("477","477","15513056101489741557","deep","154"),
("478","478","15514594715342179047","deep","154"),
("479","479","15516083257454611262","deep","154"),
("480","480","15525761555259114337","deep","154"),
("481","481","15526590647411015530","deep","154"),
("482","482","15530159648580753571","deep","154"),
("483","483","15538249269382748473","deep","154"),
("484","484","15540669169053480631","deep","154"),
("485","485","15545285006315825805","deep","154"),
("486","486","15550000982763214233","deep","154"),
("487","487","15552767370823683160","deep","154"),
("488","488","15553851685279225011","deep","154"),
("489","489","15558078010188138578","deep","154"),
("490","490","15559348812654832149","deep","154"),
("491","491","15559398880099870128","deep","154"),
("492","492","15560952209255766375","deep","154"),
("493","493","15562049112793411487","deep","154"),
("494","494","15563906910650023728","deep","154"),
("495","495","15570030922588247519","deep","154"),
("496","496","15575623267593942970","deep","154"),
("497","497","15577224537973521700","deep","154"),
("498","498","15577614050326953307","deep","154"),
("499","499","15578640625515341563","deep","154"),
("500","500","15585191632464898975","deep","154"),
("501","501","15585691077751877652","deep","154"),
("502","502","15591346079284714343","deep","154"),
("503","503","15595209375177795678","deep","154"),
("504","504","15595854109834867943","deep","154"),
("505","505","15596293689633337529","deep","154"),
("506","506","15597897086234271755","deep","154"),
("507","507","15599862690803075570","deep","154"),
("508","508","15605530285712982818","deep","154"),
("509","509","15607307576947998207","deep","154"),
("510","510","15617513628699716040","deep","154"),
("511","511","15618959146848453417","deep","154"),
("512","512","15622635959025350328","deep","154"),
("513","513","15622686026470388307","deep","154"),
("514","514","15623127736785180685","deep","154"),
("515","515","15625655443168104417","deep","154"),
("516","516","15629613956691274065","deep","154"),
("517","517","15629734352485568900","deep","154"),
("518","518","15633145475203110092","deep","154"),
("519","519","15638640476357361734","deep","154"),
("520","520","15639739506116362342","deep","154"),
("521","521","15641717699767269418","deep","154"),
("522","522","15645286700937007459","deep","154"),
("523","523","15648760484476657187","deep","154"),
("524","524","15653853379900406665","deep","154"),
("525","525","15653911119167560260","deep","154"),
("526","526","15654807120289313685","deep","154"),
("527","527","15657384902707209988","deep","154"),
("528","528","15657774410765674299","deep","154"),
("529","529","15657882221772833169","deep","154"),
("530","530","15658908796961221425","deep","154"),
("531","531","15671114809738582824","deep","154"),
("532","532","15671519033100505892","deep","154"),
("533","533","15671664322470599480","deep","154"),
("534","534","15672999907685789787","deep","154"),
("535","535","15688220483050950334","deep","154"),
("536","536","15692683359121086304","deep","154"),
("537","537","15694864581409240563","deep","154"),
("538","538","15699279516255694050","deep","154"),
("539","539","15705266290874808753","deep","154"),
("540","540","15706927426742896574","deep","154"),
("541","541","15708061812938443700","deep","154"),
("542","542","15713558936019083542","deep","154"),
("543","543","15718853034757443497","deep","154"),
("544","544","15720549527062077836","deep","154"),
("545","545","15723639335259121485","deep","154"),
("546","546","15726703973881893204","deep","154"),
("547","547","15728024843793624754","deep","154"),
("548","548","15734229362353445397","deep","154"),
("549","549","15740940373976555154","deep","154"),
("550","550","15742225887451740186","deep","154"),
("551","551","15747613077598832958","deep","154"),
("552","552","15751277296398659312","deep","154"),
("553","553","15756851795604866447","deep","154"),
("554","554","15770092051097764422","deep","154"),
("555","555","15771081147923217960","deep","154"),
("556","556","15777777444242868960","deep","154"),
("557","557","15778498725387611283","deep","154"),
("558","558","15778766541068322498","deep","154"),
("559","559","15779156049126786809","deep","154"),
("560","560","15779647826886617166","deep","154"),
("561","561","15780599441054168690","deep","154"),
("562","562","15787635177987246022","deep","154"),
("563","563","15788076888302038400","deep","154"),
("564","564","15794720986660328629","deep","154"),
("565","565","15797193084292421558","deep","154"),
("566","566","15801763771369716398","deep","154"),
("567","567","15801871578081907972","deep","154"),
("568","568","15802261090435339579","deep","154"),
("569","569","15802810603167356235","deep","154"),
("570","570","15804683116327427233","deep","154"),
("571","571","15807860478922378171","deep","154"),
("572","572","15807918218189531766","deep","154"),
("573","573","15816043191133105890","deep","154"),
("574","574","15816592708160089842","deep","154"),
("575","575","15817438641836805288","deep","154"),
("576","576","15822639348267713636","deep","154"),
("577","577","15823960218179445186","deep","154"),
("578","578","15828698577457440691","deep","154"),
("579","579","15834577545364363820","deep","154"),
("580","580","15837561673070571391","deep","154"),
("581","581","15839685156091572055","deep","154"),
("582","582","15839697745173675316","deep","154"),
("583","583","15840796774932675924","deep","154"),
("584","584","15844647481743653998","deep","154"),
("585","585","15851349319369097822","deep","154"),
("586","586","15851853686211031440","deep","154"),
("587","587","15852230605187392490","deep","154"),
("588","588","15855799610652097827","deep","154"),
("589","589","15856838774922589344","deep","154"),
("590","590","15857792515311496364","deep","154"),
("591","591","15860797288445758992","deep","154"),
("592","592","15869154720633497813","deep","154"),
("593","593","15875590868799585918","deep","154"),
("594","594","15878718163949498877","deep","154"),
("595","595","15880111484136875483","deep","154"),
("596","596","15882127160445684573","deep","154"),
("597","597","15882566740244154159","deep","154"),
("598","598","15883960064726498061","deep","154"),
("599","599","15890548554333957487","deep","154"),
("600","600","15892245042343624530","deep","154"),
("601","601","15893748299759515502","deep","154"),
("602","602","15896715590235876116","deep","154"),
("603","603","15904293172373821784","deep","154"),
("604","604","15907932501892816681","deep","154"),
("605","605","15909948178201625771","deep","154"),
("606","606","15910287614520084807","deep","154"),
("607","607","15910404599524909610","deep","154"),
("608","608","15913856619984790144","deep","154"),
("609","609","15918269428609888135","deep","154"),
("610","610","15922387942511642832","deep","154"),
("611","611","15922495753518801702","deep","154"),
("612","612","15923534917789293219","deep","154"),
("613","613","15930622852683731322","deep","154"),
("614","614","15932708853046829972","deep","154"),
("615","615","15935033535087473817","deep","154"),
("616","616","15944099659337851700","deep","154"),
("617","617","15945796151642486039","deep","154"),
("618","618","15952297086852038176","deep","154"),
("619","619","15955266503549754286","deep","154"),
("620","620","15957844281672683293","deep","154"),
("621","621","15962018408620236089","deep","154"),
("622","622","15965991637446864494","deep","154"),
("623","623","15966858212256667701","deep","154"),
("624","624","15969438116600952204","deep","154"),
("625","625","15977035955348149453","deep","154"),
("626","626","15984613541781062417","deep","154"),
("627","627","15987089054497592674","deep","154"),
("628","628","15990550248955139141","deep","154"),
("629","629","15991661867796243010","deep","154"),
("630","630","15992211380528259666","deep","154"),
("631","631","15992493086169499699","deep","154"),
("632","632","16001217643585095754","deep","154"),
("633","633","16002864064149724818","deep","154"),
("634","634","16003963093908725426","deep","154"),
("635","635","16005233896375418997","deep","154"),
("636","636","16005833480847440928","deep","154"),
("637","637","16006287775949369271","deep","154"),
("638","638","16006332926134419605","deep","154"),
("639","639","16006787221236347948","deep","154"),
("640","640","16006822577672894466","deep","154"),
("641","641","16010196217732533644","deep","154"),
("642","642","16010888897908255688","deep","154"),
("643","643","16018481195349660113","deep","154"),
("644","644","16019859804528545258","deep","154"),
("645","645","16020531843571179541","deep","154"),
("646","646","16024527835457283907","deep","154"),
("647","647","16026518618190294244","deep","154"),
("648","648","16028925928778923141","deep","154"),
("649","649","16029583252518098667","deep","154"),
("650","650","16037181095560263212","deep","154"),
("651","651","16037780680032285143","deep","154"),
("652","652","16041131941556284540","deep","154"),
("653","653","16043622165281306258","deep","154"),
("654","654","16050760171915749636","deep","154"),
("655","655","16057246391821843016","deep","154"),
("656","656","16059332392184941666","deep","154"),
("657","657","16060481493683947549","deep","154"),
("658","658","16060777910333679043","deep","154"),
("659","659","16061927011832684926","deep","154"),
("660","660","16062193997875498906","deep","154"),
("661","661","16066969839811396425","deep","154"),
("662","662","16074522532668510636","deep","154"),
("663","663","16078076818534789920","deep","154"),
("664","664","16079565360647222135","deep","154"),
("665","665","16084085975984511700","deep","154"),
("666","666","16090514460918418781","deep","154"),
("667","667","16095622075940594312","deep","154"),
("668","668","16095779954392791161","deep","154"),
("669","669","16097065467867976193","deep","154"),
("670","670","16099406690534715501","deep","154"),
("671","671","16099630656908801939","deep","154"),
("672","672","16099738463620993513","deep","154"),
("673","673","16102158367586692967","deep","154"),
("674","674","16108312814406508335","deep","154"),
("675","675","16116307213283447628","deep","154"),
("676","676","16117296310108901166","deep","154"),
("677","677","16118337600600748179","deep","154"),
("678","678","16133462958335820413","deep","154"),
("679","679","16136085882348832458","deep","154"),
("680","680","16144722889661488520","deep","154"),
("681","681","16149670500010111706","deep","154"),
("682","682","16157102797072931082","deep","154"),
("683","683","16160217503140740780","deep","154"),
("684","684","16165285509283658801","deep","154"),
("685","685","16167373635868112947","deep","154"),
("686","686","16169346288213227199","deep","154"),
("687","687","16170407835314325793","deep","154"),
("688","688","16170445317972227807","deep","154"),
("689","689","16175500735033042567","deep","154"),
("690","690","16180620939137321359","deep","154"),
("691","691","16185033743467452054","deep","154"),
("692","692","16187496667101879050","deep","154"),
("693","693","16188588033628698634","deep","154"),
("694","694","16189684937166343746","deep","154"),
("695","695","16192214769770622974","deep","154"),
("696","696","16197819703858421686","deep","154"),
("697","697","16199155289073611993","deep","154"),
("698","698","16206788484257355760","deep","154"),
("699","699","16208329224331148746","deep","154"),
("700","700","16209318321156602284","deep","154"),
("701","701","16210761713083984165","deep","154"),
("702","702","16213341617428268668","deep","154"),
("703","703","16220427426101351275","deep","154"),
("704","704","16226471935692652277","deep","154"),
("705","705","16231542068056925794","deep","154"),
("706","706","16234403678042450330","deep","154"),
("707","707","16236100166052117373","deep","154"),
("708","708","16237370968518810944","deep","154"),
("709","709","16238505354714358070","deep","154"),
("710","710","16241539554160570916","deep","154"),
("711","711","16242543366289483211","deep","154"),
("712","712","16247851879432583133","deep","154"),
("713","713","16252706398372473502","deep","154"),
("714","714","16255673684553866820","deep","154"),
("715","715","16256273273320856047","deep","154"),
("716","716","16262774208530408184","deep","154"),
("717","717","16263201199246774509","deep","154"),
("718","718","16264348174524424896","deep","154"),
("719","719","16264789884839217274","deep","154"),
("720","720","16265996721310409456","deep","154"),
("721","721","16266291011738785454","deep","154"),
("722","722","16266985818135862994","deep","154"),
("723","723","16267440113237791337","deep","154"),
("724","724","16267924843221311257","deep","154"),
("725","725","16268256616307589269","deep","154"),
("726","726","16275906653016147289","deep","154"),
("727","727","16278376624426884722","deep","154"),
("728","728","16281064339778328095","deep","154"),
("729","729","16287390555010869130","deep","154"),
("730","730","16292605976745236235","deep","154"),
("731","731","16295544958561360768","deep","154"),
("732","732","16296029688544880688","deep","154"),
("733","733","16300050862890158872","deep","154"),
("734","734","16300587786540072267","deep","154"),
("735","735","16301591598668984562","deep","154"),
("736","736","16302124274171154261","deep","154"),
("737","737","16303822888402176800","deep","154"),
("738","738","16306790178878537414","deep","154"),
("739","739","16307086595528268908","deep","154"),
("740","740","16307793991007449709","deep","154"),
("741","741","16312729012273969634","deep","154"),
("742","742","16314282337134898585","deep","154"),
("743","743","16315429312412548972","deep","154"),
("744","744","16318960830924384999","deep","154"),
("745","745","16319734314325455389","deep","154"),
("746","746","16320283827057472045","deep","154"),
("747","747","16324508030039997412","deep","154"),
("748","748","16330444732919106840","deep","154"),
("749","749","16331877661985740956","deep","154"),
("750","750","16331985472992899826","deep","154"),
("751","751","16332959854514894607","deep","154"),
("752","752","16334909739505565602","deep","154"),
("753","753","16341945476438642934","deep","154"),
("754","754","16343484085996113128","deep","154"),
("755","755","16343627249144851220","deep","154"),
("756","756","16345058056285097136","deep","154"),
("757","757","16345512351387025479","deep","154"),
("758","758","16354700997653053693","deep","154"),
("759","759","16356666602221857508","deep","154"),
("760","760","16358752606879923454","deep","154"),
("761","761","16367773580945251003","deep","154"),
("762","762","16376252709805710216","deep","154"),
("763","763","16376947516202787756","deep","154"),
("764","764","16377055327209946626","deep","154"),
("765","765","16381909841854869699","deep","154"),
("766","766","16382017648567061273","deep","154"),
("767","767","16384048040179329120","deep","154"),
("768","768","16386415741888700507","deep","154"),
("769","769","16395150097347767674","deep","154"),
("770","770","16396081454906067617","deep","154"),
("771","771","16400551998503351907","deep","154"),
("772","772","16401578577986707459","deep","154"),
("773","773","16405095385490052025","deep","154"),
("774","774","16406646584129625480","deep","154"),
("775","775","16411204682124817059","deep","154"),
("776","776","16412693224237249274","deep","154"),
("777","777","16414736200636653086","deep","154"),
("778","778","16420285525973620995","deep","154"),
("779","779","16422213647884522796","deep","154"),
("780","780","16432476819152556341","deep","154"),
("781","781","16433870139339932947","deep","154"),
("782","782","16435568757865922782","deep","154"),
("783","783","16451171173762399320","deep","154"),
("784","784","16456776107850198032","deep","154"),
("785","785","16460292911058575302","deep","154"),
("786","786","16462285820012941135","deep","154"),
("787","787","16464208400618050112","deep","154"),
("788","788","16465797086210492877","deep","154"),
("789","789","16467190406397869483","deep","154"),
("790","790","16469421696131061721","deep","154"),
("791","791","16469825923787952085","deep","154"),
("792","792","16470802431531302362","deep","154"),
("793","793","16484496982126128680","deep","154"),
("794","794","16488006122102324926","deep","154"),
("795","795","16490535954706604154","deep","154"),
("796","796","16492636670373161561","deep","154"),
("797","797","16496580468592872452","deep","154"),
("798","798","16498183865193806678","deep","154"),
("799","799","16509740217464173575","deep","154"),
("800","800","16510181923483998657","deep","154"),
("801","801","16511171020309452195","deep","154"),
("802","802","16518964224461715603","deep","154"),
("803","803","16521825830152272843","deep","154"),
("804","804","16523854095543185194","deep","154"),
("805","805","16526881247213087603","deep","154"),
("806","806","16528419861065525093","deep","154"),
("807","807","16529365933927283793","deep","154"),
("808","808","16533382182422639740","deep","154"),
("809","809","16534421350988098553","deep","154"),
("810","810","16545480384192842269","deep","154"),
("811","811","16549155070148383684","deep","154"),
("812","812","16551670187449204155","deep","154"),
("813","813","16552673999578116450","deep","154"),
("814","814","16553165777337946807","deep","154"),
("815","815","16556133067814307421","deep","154"),
("816","816","16562619287720400801","deep","154"),
("817","817","16563876195931598258","deep","154"),
("818","818","16566795540889309093","deep","154"),
("819","819","16567139903057690366","deep","154"),
("820","820","16572299716041226668","deep","154"),
("821","821","16581471525077407925","deep","154"),
("822","822","16583559651661862071","deep","154"),
("823","823","16584988328285785195","deep","154"),
("824","824","16586087358044785803","deep","154"),
("825","825","16591476674413234071","deep","154"),
("826","826","16592370553608599296","deep","154"),
("827","827","16597038584537337945","deep","154"),
("828","828","16599564168993873477","deep","154"),
("829","829","16600460170115626902","deep","154"),
("830","830","16611330593382830698","deep","154"),
("831","831","16614791787840377165","deep","154"),
("832","832","16617723721880191261","deep","154"),
("833","833","16620236717254623532","deep","154"),
("834","834","16623378727707995248","deep","154"),
("835","835","16624463042163537099","deep","154"),
("836","836","16634864751629105289","deep","154"),
("837","837","16638943660946569772","deep","154"),
("838","838","16639932757772023310","deep","154"),
("839","839","16639984955733384081","deep","154"),
("840","840","16648059856936952930","deep","154"),
("841","841","16648449369290384537","deep","154"),
("842","842","16650522780571379926","deep","154"),
("843","843","16656792086174664601","deep","154"),
("844","844","16658612401373374828","deep","154"),
("845","845","16663574722730489475","deep","154"),
("846","846","16668732409492670281","deep","154"),
("847","847","16677196823049670737","deep","154"),
("848","848","16677918929537342999","deep","154"),
("849","849","16678895437280693276","deep","154"),
("850","850","16682319149080337729","deep","154"),
("851","851","16682426960087496599","deep","154"),
("852","852","16684015641384972068","deep","154"),
("853","853","16689417546835523597","deep","154"),
("854","854","16689967059567540253","deep","154"),
("855","855","16697002796500617585","deep","154"),
("856","856","16697442380594054467","deep","154"),
("857","857","16699565863615055131","deep","154"),
("858","858","16703084793044787897","deep","154"),
("859","859","16710075379792814895","deep","154"),
("860","860","16711616119866607881","deep","154"),
("861","861","16717161188465897502","deep","154"),
("862","862","16718114928854804522","deep","154"),
("863","863","16718165000594809797","deep","154"),
("864","864","16723769930387641213","deep","154"),
("865","865","16724761153434450247","deep","154"),
("866","866","16726239901798378646","deep","154"),
("867","867","16727338931557379254","deep","154"),
("868","868","16753960776074309294","deep","154"),
("869","869","16758628811298015239","deep","154"),
("870","870","16761206589420944246","deep","154"),
("871","871","16761648295440769328","deep","154"),
("872","872","16765217296610507369","deep","154"),
("873","873","16771224327838873653","deep","154"),
("874","874","16771261810496775667","deep","154"),
("875","875","16783417751534131791","deep","154"),
("876","876","16784406848359585329","deep","154"),
("877","877","16789404526153246494","deep","154"),
("878","878","16791399561328967823","deep","154"),
("879","879","16806118565185794197","deep","154"),
("880","880","16806120691407149693","deep","154"),
("881","881","16808206691770248343","deep","154"),
("882","882","16813009008453810645","deep","154"),
("883","883","16819705304773461645","deep","154"),
("884","884","16823713890036636568","deep","154"),
("885","885","16831363926745194588","deep","154"),
("886","886","16835365459937091778","deep","154"),
("887","887","16844348955639484609","deep","154"),
("888","888","16847476250789397568","deep","154"),
("889","889","16865021508195201960","deep","154"),
("890","890","16865621092667223891","deep","154"),
("891","891","16865716310297312204","deep","154"),
("892","892","16868538311403579230","deep","154"),
("893","893","16879303054179946948","deep","154"),
("894","894","16879755223060519795","deep","154"),
("895","895","16883873741257241788","deep","154"),
("896","896","16893878894888035230","deep","154"),
("897","897","16907059284892424114","deep","154"),
("898","898","16914709321600982134","deep","154"),
("899","899","16921687319266905871","deep","154"),
("900","900","16928281350180158121","deep","154"),
("901","901","16934295429184834842","deep","154"),
("902","902","16935322008668190394","deep","154"),
("903","903","16938840938097923160","deep","154"),
("904","904","16939779963183371423","deep","154"),
("905","905","16950462077411754089","deep","154"),
("906","906","16954513682343656554","deep","154"),
("907","907","16966107517271925465","deep","154"),
("908","908","16969191788458143586","deep","154"),
("909","909","16970678204349220305","deep","154"),
("910","910","16971669427396029339","deep","154"),
("911","911","16984264948231855049","deep","154"),
("912","912","16986403146556314470","deep","154"),
("913","913","16986952659288331126","deep","154"),
("914","914","16995323981436598765","deep","154"),
("915","915","17001528499996419408","deep","154"),
("916","916","17005537080964627035","deep","154"),
("917","917","17013062469436179228","deep","154"),
("918","918","17020208139302803630","deep","154"),
("919","919","17025218410473535352","deep","154"),
("920","920","17028202538179742923","deep","154"),
("921","921","17031329833329655882","deep","154"),
("922","922","17035288346852825530","deep","154"),
("923","923","17043862693343373056","deep","154"),
("924","924","17046050963407837752","deep","154"),
("925","925","17046894770863197702","deep","154"),
("926","926","17047979085318739553","deep","154"),
("927","927","17050009476931007400","deep","154"),
("928","928","17053967986159209752","deep","154"),
("929","929","17054515376964838208","deep","154"),
("930","930","17101580266357606337","deep","154"),
("931","931","17118525934996421502","deep","154"),
("932","932","17122092809944804047","deep","154"),
("933","933","17125611739374536813","deep","154"),
("934","934","17128739034524449772","deep","154"),
("935","935","17129143262181340136","deep","154"),
("936","936","17130132354711826378","deep","154"),
("937","937","17142338367489187777","deep","154"),
("938","938","17142780073509012859","deep","154"),
("939","939","17142925362879106447","deep","154"),
("940","940","17154986081991406962","deep","154"),
("941","941","17156562178501746466","deep","154"),
("942","942","17165576104790763578","deep","154"),
("943","943","17168997690369052535","deep","154"),
("944","944","17181740626796327329","deep","154"),
("945","945","17193347050806699501","deep","154"),
("946","946","17201826179667158714","deep","154"),
("947","947","17209071993013793666","deep","154"),
("948","948","17224732148177423799","deep","154"),
("949","949","17233810861509904943","deep","154"),
("950","950","17238713321673477795","deep","154"),
("951","951","17244759961781101589","deep","154"),
("952","952","17252005775127736541","deep","154"),
("953","953","17256366385791473761","deep","154"),
("954","954","17259885315221206527","deep","154"),
("955","955","17263612194843141417","deep","154"),
("956","956","17271541810971583974","deep","154"),
("957","957","17277184223422317404","deep","154"),
("958","958","17284124742725306423","deep","154"),
("959","959","17287252037875219382","deep","154"),
("960","960","17326618940745812416","deep","154"),
("961","961","17329586231222173030","deep","154"),
("962","962","17355818563385671463","deep","154"),
("963","963","17356368080412655415","deep","154"),
("964","964","17359055791469131492","deep","154"),
("965","965","17363014304992301140","deep","154"),
("966","966","17369015794914874600","deep","154"),
("967","967","17378079797238864283","deep","154"),
("968","968","17415466384532162041","deep","154"),
("969","969","17416015897264178697","deep","154"),
("970","970","17426083711717080675","deep","154"),
("971","971","17441793934325748787","deep","154"),
("972","972","17446741544674371973","deep","154"),
("973","973","17449833483387738414","deep","154"),
("974","974","17454831161181399579","deep","154"),
("975","975","17461916969854482186","deep","154"),
("976","976","17467524030163636394","deep","154"),
("977","977","17471105620415477696","deep","154"),
("978","978","17494305875059151483","deep","154"),
("979","979","17500292653973233482","deep","154"),
("980","980","17502285558632632019","deep","154"),
("981","981","17507942690681791502","deep","154"),
("982","982","17515418007413338420","deep","154"),
("983","983","17520538211517617212","deep","154"),
("984","984","17524107212687355253","deep","154"),
("985","985","17525535889311278377","deep","154"),
("986","986","17526584847330273710","deep","154"),
("987","987","17536690144441077702","deep","154"),
("988","988","17559890399084751489","deep","154"),
("989","989","17574528900614948307","deep","154"),
("990","990","17587271837042223101","deep","154"),
("991","991","17594162280310239549","deep","154"),
("992","992","17607394868275989204","deep","154"),
("993","993","17608883410388421419","deep","154"),
("994","994","17611865416168240790","deep","154"),
("995","995","17618451775259377424","deep","154"),
("996","996","17620539906138798866","deep","154"),
("997","997","17636704428144362617","deep","154"),
("998","998","17664412713338190004","deep","154"),
("999","999","17667005206764577768","deep","154"),
("1000","1000","17672048034743289267","deep","154"),
("1001","1001","17681176819815775686","deep","154"),
("1002","1002","17697196052451245849","deep","154"),
("1003","1003","17700260686779050272","deep","154"),
("1004","1004","17741618372382653643","deep","154"),
("1005","1005","17781128442696952065","deep","154"),
("1006","1006","17781582737798880408","deep","154"),
("1007","1007","17802240575051139002","deep","154"),
("1008","1008","17852287465928759206","deep","154"),
("1009","1009","17867852403462301026","deep","154"),
("1010","1010","17935525054072355178","deep","154"),
("1011","1011","17941671833365022226","deep","154"),
("1012","1012","17975943714590510286","deep","154"),
("1013","1013","18050702173873647045","deep","154"),
("1014","1014","18292063253014581020","deep","154"),
("1015","1015","18301141966347062164","deep","154"),
("1016","1016","2027683937807530372","deep","154"),
("1017","1017","2751350358491338672","deep","154"),
("1018","1018","2812831079623675442","deep","154"),
("1019","1019","3070321320038659354","deep","154"),
("1020","1020","3098664550436022486","deep","154"),
("1021","1021","3108842293527504238","deep","154"),
("1022","1022","3137185523924867370","deep","154"),
("1023","1023","3156151401608643090","deep","154"),
("1024","1024","3215234990424690959","deep","154"),
("1025","1025","3307456074270679762","deep","154"),
("1026","1026","3346671854156602186","deep","154"),
("1027","1027","3477413907196468577","deep","154"),
("1028","1028","3532503630347767576","deep","154"),
("1029","1029","3546675243398965494","deep","154"),
("1030","1030","3586898542807021739","deep","154"),
("1031","1031","3686900237428203393","deep","154"),
("1032","1032","3708157659152483918","deep","154"),
("1033","1033","3779121321274192196","deep","154"),
("1034","1034","3800378742998472721","deep","154"),
("1035","1035","3817642294763037080","deep","154"),
("1036","1036","3993296323567753422","deep","154"),
("1037","1037","4088609346127108666","deep","154"),
("1038","1038","4131124185280702420","deep","154"),
("1039","1039","4581532014854901625","deep","154"),
("0","0","10596348224425967661","deep","155"),
("1","1","11646487232004903444","deep","155"),
("2","2","12449192216013988871","deep","155"),
("3","3","12929921461046523692","deep","155"),
("4","4","13730172063652666448","deep","155"),
("5","5","13786764549744389298","deep","155"),
("6","6","13989127592940106789","deep","155"),
("7","7","14054381218583764788","deep","155"),
("8","8","14125050590277097068","deep","155"),
("9","9","14182558082582805433","deep","155"),
("10","10","14288656489051616156","deep","155"),
("11","11","14481574073915864153","deep","155"),
("12","12","14701178286045538926","deep","155"),
("13","13","14891465890530529849","deep","155"),
("14","14","14958641226369928116","deep","155"),
("15","15","14974818333162627832","deep","155"),
("16","16","15014717915830357861","deep","155"),
("17","17","15060194119630683225","deep","155"),
("18","18","15095992025626505514","deep","155"),
("19","19","15193516081309801415","deep","155"),
("20","20","15202530011893785823","deep","155"),
("21","21","15222667758431010683","deep","155"),
("22","22","15226771561324273919","deep","155"),
("23","23","15339770873921848855","deep","155"),
("24","24","15343889392118570848","deep","155"),
("25","25","15381166046478321536","deep","155"),
("26","26","15394406301971219511","deep","155"),
("27","27","15489902092263603061","deep","155"),
("28","28","15572163172663848756","deep","155"),
("29","29","15634135671556015883","deep","155"),
("30","30","15667049589030673855","deep","155"),
("31","31","15768539821469320428","deep","155"),
("32","32","15778218123568790799","deep","155"),
("33","33","15840233646424652764","deep","155"),
("34","34","15904402082908432907","deep","155"),
("35","35","15908252785424443685","deep","155"),
("36","36","15926115925955997271","deep","155"),
("37","37","15933056440964018994","deep","155"),
("38","38","16001291197683160359","deep","155"),
("39","39","16042526361271113399","deep","155"),
("40","40","16061218589659600882","deep","155"),
("41","41","16176013868929576758","deep","155"),
("42","42","16290481467030332328","deep","155"),
("43","43","16308771598278252239","deep","155"),
("44","44","16334029548919755891","deep","155"),
("45","45","16352599255292593043","deep","155"),
("46","46","16529316961714730771","deep","155"),
("47","47","16545479357498939026","deep","155"),
("48","48","16710344295000978363","deep","155"),
("49","49","16716123119427890942","deep","155"),
("50","50","16808612014659623664","deep","155"),
("51","51","16986953758815783379","deep","155"),
("52","52","16995924665436072949","deep","155"),
("53","53","17078223228494220658","deep","155"),
("54","54","17149852266406088962","deep","155"),
("55","55","17316454886263886178","deep","155"),
("56","56","17492218848002149590","deep","155"),
("57","57","17765858899414205792","deep","155"),
("58","58","17817966616785685420","deep","155"),
("59","59","3814551455577122892","deep","155"),
("0","0","11873845854346628599","deep","156"),
("1","1","12990414189175826473","deep","156"),
("2","2","13760400616820352791","deep","156"),
("3","3","14129008077106363473","deep","156"),
("4","4","14355303173820234480","deep","156"),
("5","5","14400872469029292661","deep","156"),
("6","6","14586539189421612707","deep","156"),
("7","7","14743059283818016484","deep","156"),
("8","8","14826309461043715717","deep","156"),
("9","9","14995499162592445931","deep","156"),
("10","10","15028797537000275215","deep","156"),
("11","11","15170156917225060240","deep","156"),
("12","12","15289400357261713329","deep","156"),
("13","13","15358503815012013397","deep","156"),
("14","14","15404419598610808347","deep","156"),
("15","15","15428729350169197803","deep","156"),
("16","16","15470111933643567223","deep","156"),
("17","17","15472602157368588941","deep","156"),
("18","18","15521133206043182208","deep","156"),
("19","19","15540377077680009139","deep","156"),
("20","20","15553464376275665206","deep","156"),
("21","21","15577668443048251288","deep","156"),
("22","22","15584754251721333895","deep","156"),
("23","23","15593486476664078270","deep","156"),
("24","24","15623019998611570825","deep","156"),
("25","25","15651983070090207469","deep","156"),
("26","26","15675077644243045178","deep","156"),
("27","27","15738147050967824713","deep","156"),
("28","28","15753322476147934926","deep","156"),
("29","29","16039705459692298626","deep","156"),
("30","30","16084030440067229907","deep","156"),
("31","31","16129933634583921596","deep","156"),
("32","32","16134157833271479667","deep","156"),
("33","33","16141633154297993881","deep","156"),
("34","34","16169898000000148361","deep","156"),
("35","35","16191522166723417236","deep","156"),
("36","36","16445624051775303213","deep","156"),
("37","37","16483452345088426053","deep","156"),
("38","38","16502144577771880832","deep","156"),
("39","39","16606509009278155202","deep","156"),
("40","40","16639387566021299360","deep","156"),
("41","41","16993882788564121390","deep","156"),
("42","42","17153934401472361194","deep","156"),
("43","43","17441796133380653293","deep","156"),
("44","44","17513050378537516043","deep","156"),
("45","45","17649839071685006228","deep","156"),
("46","46","17727484314822906749","deep","156"),
("47","47","18044607661080922482","deep","156"),
("48","48","3608158163586206770","deep","156"),
("0","0","12303231052121968179","deep","157"),
("1","1","12698167698242421278","deep","157"),
("2","2","13192498402461049600","deep","157"),
("3","3","14064464718377664648","deep","157"),
("4","4","14635979193285616653","deep","157"),
("5","5","14716159324448056697","deep","157"),
("6","6","14852926129240406926","deep","157"),
("7","7","15077747889325804300","deep","157"),
("8","8","15159994250127623942","deep","157"),
("9","9","15168083870929618844","deep","157"),
("10","10","15199850808831659133","deep","157"),
("11","11","15205455742919457845","deep","157"),
("12","12","15332254002034580641","deep","157"),
("13","13","15420099755618406171","deep","157"),
("14","14","15445892507983435018","deep","157"),
("15","15","15482677384583355349","deep","157"),
("16","16","15489655382249279086","deep","157"),
("17","17","15557340621941436499","deep","157"),
("18","18","15832506693828859634","deep","157"),
("19","19","15932573175493505320","deep","157"),
("20","20","16015369053322308914","deep","157"),
("21","21","16055667322341136483","deep","157"),
("22","22","16077876353938001236","deep","157"),
("23","23","16212844736181748490","deep","157"),
("24","24","16244626389387247536","deep","157"),
("25","25","16280262164488161984","deep","157"),
("26","26","16341890301211947838","deep","157"),
("27","27","16373900161218900589","deep","157"),
("28","28","16388353475616371244","deep","157"),
("29","29","16432840586886210366","deep","157"),
("30","30","16509079916459663724","deep","157"),
("31","31","16519363344336948850","deep","157"),
("32","32","16571108028397628950","deep","157"),
("33","33","16594907871808291964","deep","157"),
("34","34","16672316563784970082","deep","157"),
("35","35","16673905245082445551","deep","157"),
("36","36","16781780942786271663","deep","157"),
("37","37","16847421079857669768","deep","157"),
("38","38","16987683556544809681","deep","157"),
("39","39","17609282534558621962","deep","157"),
("40","40","3009239723076523127","deep","157"),
("0","0","11739802242123203034","deep","158"),
("1","1","11786692411538960061","deep","158"),
("2","2","11954271539140107554","deep","158"),
("3","3","12243767102530925456","deep","158"),
("4","4","12338422801351105174","deep","158"),
("5","5","12583958007439591945","deep","158"),
("6","6","12656643051146766019","deep","158"),
("7","7","12725209580952185396","deep","158"),
("8","8","12910328128049592963","deep","158"),
("9","9","12987425980381865028","deep","158"),
("10","10","12991838789006963019","deep","158"),
("11","11","13174246853398483956","deep","158"),
("12","12","13340836884174177911","deep","158"),
("13","13","13619584546313442348","deep","158"),
("14","14","13690129269769768801","deep","158"),
("15","15","13796227676238579524","deep","158"),
("16","16","13908767642608933118","deep","158"),
("17","17","13911360136035320882","deep","158"),
("18","18","14049737514775253832","deep","158"),
("19","19","14091617413020279137","deep","158"),
("20","20","14092238890142408320","deep","158"),
("21","21","14179989916276645362","deep","158"),
("22","22","14318532350815423656","deep","158"),
("23","23","14339551387465910480","deep","158"),
("24","24","14528343276786787989","deep","158"),
("25","25","14558175045001616040","deep","158"),
("26","26","14572235850414930883","deep","158"),
("27","27","14593328216340366064","deep","158"),
("28","28","14596015927396842141","deep","158"),
("29","29","14773755960859624429","deep","158"),
("30","30","14831375516615202656","deep","158"),
("31","31","14847444816695710798","deep","158"),
("32","32","15022204970600029211","deep","158"),
("33","33","15039373304734505257","deep","158"),
("34","34","15085773818316820127","deep","158"),
("35","35","15090821572145453863","deep","158"),
("36","36","15117003832568947021","deep","158"),
("37","37","15169515773302349717","deep","158"),
("38","38","15171104454599825186","deep","158"),
("39","39","15203983015637936640","deep","158"),
("40","40","15226621168467490510","deep","158"),
("41","41","15246864599790518744","deep","158"),
("42","42","15250933046247235462","deep","158"),
("43","43","15254846409585354776","deep","158"),
("44","44","15281173963673908818","deep","158"),
("45","45","15289090986425280818","deep","158"),
("46","46","15293367383074199660","deep","158"),
("47","47","15295895093752090688","deep","158"),
("48","48","15320380861870949507","deep","158"),
("49","49","15322077354175583846","deep","158"),
("50","50","15392877299935550957","deep","158"),
("51","51","15399760079971386381","deep","158"),
("52","52","15404925429965748211","deep","158"),
("53","53","15427468365165213768","deep","158"),
("54","54","15443753282965072354","deep","158"),
("55","55","15449302604007072967","deep","158"),
("56","56","15467555252597090864","deep","158"),
("57","57","15468494277682539127","deep","158"),
("58","58","15524904870745569676","deep","158"),
("59","59","15552981110805151532","deep","158"),
("60","60","15564307130052709228","deep","158"),
("61","61","15579148655925185933","deep","158"),
("62","62","15582732372398382731","deep","158"),
("63","63","15611212014771925012","deep","158"),
("64","64","15614397044894024270","deep","158"),
("65","65","15642659768669790550","deep","158"),
("66","66","15656745957839403971","deep","158"),
("67","67","15686143067810717377","deep","158"),
("68","68","15712982651973386061","deep","158"),
("69","69","15723492172446113121","deep","158"),
("70","70","15731554484567578709","deep","158"),
("71","71","15746142914357770252","deep","158"),
("72","72","15782083979207363337","deep","158"),
("73","73","15822931760958207562","deep","158"),
("74","74","15833439155209579126","deep","158"),
("75","75","15862590832330788394","deep","158"),
("76","76","15874834323471084511","deep","158"),
("77","77","15892155614502802465","deep","158"),
("78","78","15994532058609665943","deep","158"),
("79","79","16009700436013465719","deep","158"),
("80","80","16065793966998709717","deep","158"),
("81","81","16075791453102354839","deep","158"),
("82","82","16091622075800285082","deep","158"),
("83","83","16104551495943744300","deep","158"),
("84","84","16124834536146030044","deep","158"),
("85","85","16125427072841741538","deep","158"),
("86","86","16126270880297101488","deep","158"),
("87","87","16247009910222497229","deep","158"),
("88","88","16267228163381318941","deep","158"),
("89","89","16280864974708991664","deep","158"),
("90","90","16280972781421183238","deep","158"),
("91","91","16313786555415830660","deep","158"),
("92","92","16314197830849031461","deep","158"),
("93","93","16354155148488947789","deep","158"),
("94","94","16408745422058300815","deep","158"),
("95","95","16414134738426749083","deep","158"),
("96","96","16425243843371498074","deep","158"),
("97","97","16425791234177126530","deep","158"),
("98","98","16439912775488319173","deep","158"),
("99","99","16515675046900368227","deep","158"),
("100","100","16554345021447495521","deep","158"),
("101","101","16588812263783082444","deep","158"),
("102","102","16606502806264013128","deep","158"),
("103","103","16607052323290997080","deep","158"),
("104","104","16640332981469676106","deep","158"),
("105","105","16645318070181234010","deep","158"),
("106","106","16674202761259629298","deep","158"),
("107","107","16755937091987334298","deep","158"),
("108","108","16851380688613324373","deep","158"),
("109","109","16856061312919133579","deep","158"),
("110","110","16867547336840243620","deep","158"),
("111","111","16881399765887266787","deep","158"),
("112","112","16893340089205272467","deep","158"),
("113","113","16923076639790012205","deep","158"),
("114","114","16951851393639893127","deep","158"),
("115","115","16958432835471042116","deep","158"),
("116","116","17004333908061345605","deep","158"),
("117","117","17122053449549019961","deep","158"),
("118","118","17142176485077753360","deep","158"),
("119","119","17165988917570519635","deep","158"),
("120","120","17182580430292449711","deep","158"),
("121","121","17203375504863817393","deep","158"),
("122","122","17293603679755440363","deep","158"),
("123","123","17946592672399964587","deep","158"),
("124","124","2858838081188288433","deep","158"),
("125","125","3594384570882789846","deep","158"),
("126","126","3746384049941904058","deep","158"),
("127","127","4334619736934084965","deep","158"),
("0","0","11542804725542554607","deep","159"),
("1","1","11914468277924885387","deep","159"),
("2","2","12181022520663858982","deep","159"),
("3","3","13091053388746035075","deep","159"),
("4","4","13432764772824275673","deep","159"),
("5","5","13968546258350207479","deep","159"),
("6","6","14029332177380434005","deep","159"),
("7","7","14163773809951640564","deep","159"),
("8","8","14178891986045097007","deep","159"),
("9","9","14247588215212815210","deep","159"),
("10","10","14367800985646170081","deep","159"),
("11","11","14488914812621538672","deep","159"),
("12","12","14539446433482678796","deep","159"),
("13","13","14584018968634102415","deep","159"),
("14","14","14771244065012644411","deep","159"),
("15","15","14773759186608432178","deep","159"),
("16","16","14887945083362915011","deep","159"),
("17","17","14972626063433892864","deep","159"),
("18","18","15091884218774004710","deep","159"),
("19","19","15093350378055829848","deep","159"),
("20","20","15113156355801743992","deep","159"),
("21","21","15259940408831523803","deep","159"),
("22","22","15316033939816767801","deep","159"),
("23","23","15337096000430949463","deep","159"),
("24","24","15425596955827562319","deep","159"),
("25","25","15461901350591706426","deep","159"),
("26","26","15468495377209991380","deep","159"),
("27","27","15471500150344254008","deep","159"),
("28","28","15552274814853422984","deep","159"),
("29","29","15596852891310639427","deep","159"),
("30","30","15690946484021731932","deep","159"),
("31","31","15708260107526301566","deep","159"),
("32","32","15763884628106158464","deep","159"),
("33","33","15830862472319135076","deep","159"),
("34","34","15833058409910748092","deep","159"),
("35","35","15869238156437886372","deep","159"),
("36","36","15926463947397322000","deep","159"),
("37","37","15984573154691375088","deep","159"),
("38","38","16076339943435435548","deep","159"),
("39","39","16383942866046177759","deep","159"),
("40","40","16484348788324249777","deep","159"),
("41","41","16492877988924714265","deep","159"),
("42","42","16601064521977979134","deep","159"),
("43","43","16670672342275245524","deep","159"),
("44","44","16938750483563197852","deep","159"),
("45","45","16942332073815039154","deep","159"),
("46","46","17093696607670617621","deep","159"),
("47","47","17144315782929665034","deep","159"),
("48","48","17144705290988129345","deep","159"),
("49","49","17217000826636839108","deep","159"),
("50","50","17696593563547438603","deep","159"),
("51","51","17873361337414614310","deep","159"),
("52","52","2720316512605714148","deep","159"),
("53","53","4279531117605205515","deep","159"),
("0","0","11309448338184576073","deep","16"),
("1","1","11652768660169543721","deep","16"),
("2","2","11842556823662523263","deep","16"),
("3","3","11885490605776466138","deep","16"),
("4","4","12021340273838508060","deep","16"),
("5","5","12087891127335118347","deep","16"),
("6","6","12245949831288992318","deep","16"),
("7","7","12335479492390316222","deep","16"),
("8","8","12457451837829536224","deep","16"),
("9","9","12510106941711677012","deep","16"),
("10","10","12571330855073539798","deep","16"),
("11","11","12714228849150762313","deep","16"),
("12","12","12781768799472826138","deep","16"),
("13","13","12862566231336438371","deep","16"),
("14","14","12888617917693296698","deep","16"),
("15","15","12976664573693013915","deep","16"),
("16","16","12981077382318111906","deep","16"),
("17","17","13008850454555403325","deep","16"),
("18","18","13035509781730235379","deep","16"),
("19","19","13042301295679974692","deep","16"),
("20","20","13098674406085103227","deep","16"),
("21","21","13134522379525963495","deep","16"),
("22","22","13215977135128751254","deep","16"),
("23","23","13216966231954204792","deep","16"),
("24","24","13291554503996481914","deep","16"),
("25","25","13308198214679772761","deep","16"),
("26","26","13355783190492607328","deep","16"),
("27","27","13373009259599269673","deep","16"),
("28","28","13378116874621445204","deep","16"),
("29","29","13431816980683621827","deep","16"),
("30","30","13461844114303516037","deep","16"),
("31","31","13521309159127043717","deep","16"),
("32","32","13573763360593292818","deep","16"),
("33","33","13588997399744892631","deep","16"),
("34","34","13617924624606482932","deep","16"),
("35","35","13626418468770400902","deep","16"),
("36","36","13635938888122707128","deep","16"),
("37","37","13668895825266092642","deep","16"),
("38","38","13688925769386093224","deep","16"),
("39","39","13716242416005133508","deep","16"),
("40","40","13763551524086272360","deep","16"),
("41","41","13775450653058187204","deep","16"),
("42","42","13862102649433423638","deep","16"),
("43","43","13884863328573595135","deep","16"),
("44","44","13901467430377628472","deep","16"),
("45","45","13929847264433590317","deep","16"),
("46","46","13992022791963004627","deep","16"),
("47","47","14017194067205904291","deep","16"),
("48","48","14150513902663666985","deep","16"),
("49","49","14166628352929225461","deep","16"),
("50","50","14196379614522456660","deep","16"),
("51","51","14199896422025801226","deep","16"),
("52","52","14202022031268157386","deep","16"),
("53","53","14297354815961297090","deep","16"),
("54","54","14304440624634379697","deep","16"),
("55","55","14317660623518026091","deep","16"),
("56","56","14323098375585623963","deep","16"),
("57","57","14342232309993936528","deep","16"),
("58","58","14356418638348593203","deep","16"),
("59","59","14384789168836551057","deep","16"),
("60","60","14410539026808223124","deep","16"),
("61","61","14412554703117032214","deep","16"),
("62","62","14414951835433321115","deep","16"),
("63","63","14483736983883782437","deep","16"),
("64","64","14493257407531055959","deep","16"),
("65","65","14495945118587532036","deep","16"),
("66","66","14501736536391515172","deep","16"),
("67","67","14501894414843712021","deep","16"),
("68","68","14526525476627631724","deep","16"),
("69","69","14528663674952091145","deep","16"),
("70","70","14534195279764941500","deep","16"),
("71","71","14535164610161643282","deep","16"),
("72","72","14535214677606681261","deep","16"),
("73","73","14535604189960112868","deep","16"),
("74","74","14539268413054906518","deep","16"),
("75","75","14539302890492149735","deep","16"),
("76","76","14541209124047911580","deep","16"),
("77","77","14546388699165232342","deep","16"),
("78","78","14581615195483963427","deep","16"),
("79","79","14597340137691057592","deep","16"),
("80","80","14610962233715271558","deep","16"),
("81","81","14614104244168643274","deep","16"),
("82","82","14637209281182228748","deep","16"),
("83","83","14647322241525213764","deep","16"),
("84","84","14648348821008569316","deep","16"),
("85","85","14653309020439295763","deep","16"),
("86","86","14656878021609033804","deep","16"),
("87","87","14666945831766968486","deep","16"),
("88","88","14671012152002329708","deep","16"),
("89","89","14673981568700045818","deep","16"),
("90","90","14679983058622619278","deep","16"),
("91","91","14695266290514921065","deep","16"),
("92","92","14699758731057279903","deep","16"),
("93","93","14722974580003715748","deep","16"),
("94","94","14724405382848994368","deep","16"),
("95","95","14728139439817577753","deep","16"),
("96","96","14739139097714312203","deep","16"),
("97","97","14742658031439012265","deep","16"),
("98","98","14748298317668390199","deep","16"),
("99","99","14807461408831360857","deep","16"),
("100","100","14808305216286720807","deep","16"),
("101","101","14815391020664836118","deep","16"),
("102","102","14816917045435170347","deep","16"),
("103","103","14819017761101727754","deep","16"),
("104","104","14837147887676095320","deep","16"),
("105","105","14864384031968506048","deep","16"),
("106","106","14882528873846332371","deep","16"),
("107","107","14883560990340513451","deep","16"),
("108","108","14886205681728261986","deep","16"),
("109","109","14891652737363863849","deep","16"),
("110","110","14901755903958345049","deep","16"),
("111","111","14902355488430366980","deep","16"),
("112","112","14904885325329613504","deep","16"),
("113","113","14912323159403258408","deep","16"),
("114","114","14940695816112571758","deep","16"),
("115","115","14950041519782834178","deep","16"),
("116","116","14955856525989223214","deep","16"),
("117","117","14974498686932672718","deep","16"),
("118","118","14981087176540132144","deep","16"),
("119","119","14997801211277712551","deep","16"),
("120","120","15005289117091362730","deep","16"),
("121","121","15008258533789078840","deep","16"),
("122","122","15020906248291298025","deep","16"),
("123","123","15060660541588934466","deep","16"),
("124","124","15065861248019842814","deep","16"),
("125","125","15069884544291509198","deep","16"),
("126","126","15095519418204341196","deep","16"),
("127","127","15103862135088621260","deep","16"),
("128","128","15111229645107976604","deep","16"),
("129","129","15136602579808320325","deep","16"),
("130","130","15144108201851120762","deep","16"),
("131","131","15149667985753869140","deep","16"),
("132","132","15154565524362487051","deep","16"),
("133","133","15156753794426951747","deep","16"),
("134","134","15176334980455849514","deep","16"),
("135","135","15192609435394960335","deep","16"),
("136","136","15194529889778713816","deep","16"),
("137","137","15216898930344098210","deep","16"),
("138","138","15224376373297000624","deep","16"),
("139","139","15233013380609656686","deep","16"),
("140","140","15241422185415826339","deep","16"),
("141","141","15253246349071937155","deep","16"),
("142","142","15255289329766308263","deep","16"),
("143","143","15277832264965773820","deep","16"),
("144","144","15278381777697790476","deep","16"),
("145","145","15300686035514678134","deep","16"),
("146","146","15303265939858962637","deep","16"),
("147","147","15305698428611798056","deep","16"),
("148","148","15320873853791908269","deep","16"),
("149","149","15336034563668559725","deep","16"),
("150","150","15348632210725740931","deep","16"),
("151","151","15351172506190767924","deep","16"),
("152","152","15354287212258577622","deep","16"),
("153","153","15387462189946420570","deep","16"),
("154","154","15389535601227415959","deep","16"),
("155","155","15391016475812699854","deep","16"),
("156","156","15433363258241756763","deep","16"),
("157","157","15436000901853194861","deep","16"),
("158","158","15442926705852725123","deep","16"),
("159","159","15446510422325921921","deep","16"),
("160","160","15452163297637403116","deep","16"),
("161","161","15472835845898153171","deep","16"),
("162","162","15476796485642678315","deep","16"),
("163","163","15484921458586252439","deep","16"),
("164","164","15485483564695339652","deep","16"),
("165","165","15510274631152811700","deep","16"),
("166","166","15517213019939477927","deep","16"),
("167","167","15524943563269632799","deep","16"),
("168","168","15528352559765818495","deep","16"),
("169","169","15545910401958758852","deep","16"),
("170","170","15596479509772768286","deep","16"),
("171","171","15610715905572462940","deep","16"),
("172","172","15618863261346644141","deep","16"),
("173","173","15626735138207933103","deep","16"),
("174","174","15628931071504578823","deep","16"),
("175","175","15632984806952804080","deep","16"),
("176","176","15639975393700831078","deep","16"),
("177","177","15650592720885749712","deep","16"),
("178","178","15664267014871324449","deep","16"),
("179","179","15684287780698691802","deep","16"),
("180","180","15687415075848604761","deep","16"),
("181","181","15701001819731239505","deep","16"),
("182","182","15706551140773240118","deep","16"),
("183","183","15710775339460798189","deep","16"),
("184","184","15713195239131530347","deep","16"),
("185","185","15725842957928716828","deep","16"),
("186","186","15747077608003586800","deep","16"),
("187","187","15750876116853204103","deep","16"),
("188","188","15751917411640018412","deep","16"),
("189","189","15752452213363543607","deep","16"),
("190","190","15771656476121113028","deep","16"),
("191","191","15771708669787506503","deep","16"),
("192","192","15777305936348156895","deep","16"),
("193","193","15777413747355315765","deep","16"),
("194","194","15781372256583518117","deep","16"),
("195","195","15795852875366550790","deep","16"),
("196","196","15798034097654705049","deep","16"),
("197","197","15808703622800984454","deep","16"),
("198","198","15814092939169432722","deep","16"),
("199","199","15829923561867362965","deep","16"),
("200","200","15841906904854096187","deep","16"),
("201","201","15858967432276380659","deep","16"),
("202","202","15860947747853675935","deep","16"),
("203","203","15865611530634670888","deep","16"),
("204","204","15866103308394501245","deep","16"),
("205","205","15874727726625054046","deep","16"),
("206","206","15882862493317131986","deep","16"),
("207","207","15910633439333067909","deep","16"),
("208","208","15915538025717996257","deep","16"),
("209","209","15921035148798636099","deep","16"),
("210","210","15952922486789938519","deep","16"),
("211","211","15953579810529114045","deep","16"),
("212","212","15954411028902370734","deep","16"),
("213","213","15962538128067300354","deep","16"),
("214","214","15965959713645589311","deep","16"),
("215","215","15976722330200601533","deep","16"),
("216","216","15985309265773252320","deep","16"),
("217","217","15989159972584230394","deep","16"),
("218","218","15990416880795427851","deep","16"),
("219","219","15990698582141700588","deep","16"),
("220","220","15995256680136892167","deep","16"),
("221","221","16013604550651965673","deep","16"),
("222","222","16017026136230254630","deep","16"),
("223","223","16019216528221107526","deep","16"),
("224","224","16023029752374183586","deep","16"),
("225","225","16033682435995648738","deep","16"),
("226","226","16061550725863028470","deep","16"),
("227","227","16092730668375150089","deep","16"),
("228","228","16096796988610511311","deep","16"),
("229","229","16100770213142172420","deep","16"),
("230","230","16102358898734615185","deep","16"),
("231","231","16102454116364703498","deep","16"),
("232","232","16131813743678114890","deep","16"),
("233","233","16137752577073547110","deep","16"),
("234","234","16140134994086377254","deep","16"),
("235","235","16158532932046488739","deep","16"),
("236","236","16188174265001140164","deep","16"),
("237","237","16191813590225167765","deep","16"),
("238","238","16196763326795146447","deep","16"),
("239","239","16208861528565348976","deep","16"),
("240","240","16212963205237256716","deep","16"),
("241","241","16220453237272262391","deep","16"),
("242","242","16221552267031262999","deep","16"),
("243","243","16243703563655941453","deep","16"),
("244","244","16253989117754582075","deep","16"),
("245","245","16256836012436647854","deep","16"),
("246","246","16257997703017756998","deep","16"),
("247","247","16266636836551768556","deep","16"),
("248","248","16307525511749984827","deep","16"),
("249","249","16326074576989734218","deep","16"),
("250","250","16346235095176369631","deep","16"),
("251","251","16348225877909379968","deep","16"),
("252","252","16374553427702966714","deep","16"),
("253","253","16400990914725067826","deep","16"),
("254","254","16409412308613340740","deep","16"),
("255","255","16413383406923646353","deep","16"),
("256","256","16417928920131701967","deep","16"),
("257","257","16419027949890702575","deep","16"),
("258","258","16434043370397260443","deep","16"),
("259","259","16437682695621288044","deep","16"),
("260","260","16461922123125387940","deep","16"),
("261","261","16469022642806962008","deep","16"),
("262","262","16472029542162580132","deep","16"),
("263","263","16474665059552662734","deep","16"),
("264","264","16475104639351132320","deep","16"),
("265","265","16510417815363434689","deep","16"),
("266","266","16523550259849173794","deep","16"),
("267","267","16526422328400478799","deep","16"),
("268","268","16529941262125178861","deep","16"),
("269","269","16533018485535086545","deep","16"),
("270","270","16540608661050102770","deep","16"),
("271","271","16542734270292458930","deep","16"),
("272","272","16548447006797481920","deep","16"),
("273","273","16576110146101226269","deep","16"),
("274","274","16581107823894887434","deep","16"),
("275","275","16584039757934701530","deep","16"),
("276","276","16585176270351604152","deep","16"),
("277","277","16591567272627609219","deep","16"),
("278","278","16611850312829894963","deep","16"),
("279","279","16612882433619043339","deep","16"),
("280","280","16637186643871639971","deep","16"),
("281","281","16637736156603656627","deep","16"),
("282","282","16642683766952279813","deep","16"),
("283","283","16675562323695423971","deep","16"),
("284","284","16682504969219768486","deep","16"),
("285","285","16709432107780344459","deep","16"),
("286","286","16712803621618628141","deep","16"),
("287","287","16716480429500557756","deep","16"),
("288","288","16723016721146656411","deep","16"),
("289","289","16724946973573881004","deep","16"),
("290","290","16730492042173170625","deep","16"),
("291","291","16741601147117919616","deep","16"),
("292","292","16753852301490396757","deep","16"),
("293","293","16764361821963123817","deep","16"),
("294","294","16764923928072211030","deep","16"),
("295","295","16767279040699479156","deep","16"),
("296","296","16783443562705042907","deep","16"),
("297","297","16797679962799704857","deep","16"),
("298","298","16802187989054891161","deep","16"),
("299","299","16804433994091542156","deep","16"),
("300","300","16828919766505368271","deep","16"),
("301","301","16850191903533107553","deep","16"),
("302","302","16851020995685008746","deep","16"),
("303","303","16878108138919137064","deep","16"),
("304","304","16881185362329044748","deep","16"),
("305","305","16916338529372827476","deep","16"),
("306","306","16926443826483631468","deep","16"),
("307","307","16931940949564271310","deep","16"),
("308","308","16936007269799632532","deep","16"),
("309","309","16954714213491578772","deep","16"),
("310","310","16989008862071510089","deep","16"),
("311","311","16996548965846521039","deep","16"),
("312","312","17001604382907335799","deep","16"),
("313","313","17024964646519529227","deep","16"),
("314","314","17028533647689267268","deep","16"),
("315","315","17035459447393830234","deep","16"),
("316","316","17040579651498109026","deep","16"),
("317","317","17095496776598785123","deep","16"),
("318","318","17107103200609157295","deep","16"),
("319","319","17120849949165344384","deep","16"),
("320","320","17148570823441275032","deep","16"),
("321","321","17168144341943024479","deep","16"),
("322","322","17198480476999786148","deep","16"),
("323","323","17234488455114198761","deep","16"),
("324","324","17291945879974869147","deep","16"),
("325","325","17330386351137084475","deep","16"),
("326","326","17343568867362828855","deep","16"),
("327","327","17367158634359934249","deep","16"),
("328","328","17384861770217935490","deep","16"),
("329","329","17401625876695521172","deep","16"),
("330","330","17416591225462073765","deep","16"),
("331","331","17418179911054516530","deep","16"),
("332","332","17437473850136381440","deep","16"),
("333","333","17475262538865214066","deep","16"),
("334","334","17484928247587613880","deep","16"),
("335","335","17516592920083255419","deep","16"),
("336","336","17524682540885250321","deep","16"),
("337","337","17550071065593388804","deep","16"),
("338","338","17612051232012704251","deep","16"),
("339","339","17668180119434494767","deep","16"),
("340","340","17710564384521453690","deep","16"),
("341","341","17754047683662380517","deep","16"),
("342","342","17773678937136316263","deep","16"),
("343","343","17774278525903305490","deep","16"),
("344","344","17847952666435933102","deep","16"),
("345","345","17990850660513155617","deep","16"),
("346","346","18083166961989232733","deep","16"),
("347","347","2327874841810506091","deep","16"),
("348","348","2991762862986221686","deep","16"),
("349","349","3414729393409407484","deep","16"),
("350","350","3507645279357506531","deep","16"),
("351","351","3972224721982903654","deep","16"),
("352","352","3995879276023473080","deep","16"),
("353","353","4017831499849863849","deep","16"),
("354","354","4241489443132796583","deep","16"),
("355","355","4462055451997330172","deep","16"),
("356","356","9560286560787854954","deep","16"),
("0","0","11590809735253255956","deep","160"),
("1","1","11719154660271800742","deep","160"),
("2","2","11987724579319583427","deep","160"),
("3","3","12735008067091091843","deep","160"),
("4","4","12840079894076547014","deep","160"),
("5","5","12889823617131876781","deep","160"),
("6","6","12989074600001398598","deep","160"),
("7","7","12994513988109852141","deep","160"),
("8","8","13298600107512217082","deep","160"),
("9","9","13346860829760907458","deep","160"),
("10","10","13645219493059823356","deep","160"),
("11","11","13753953416918716681","deep","160"),
("12","12","13794142234594562413","deep","160"),
("13","13","13855363147030733698","deep","160"),
("14","14","14043643001982529269","deep","160"),
("15","15","14086401189415125037","deep","160"),
("16","16","14138104679129714301","deep","160"),
("17","17","14211367418953770350","deep","160"),
("18","18","14249597813702428058","deep","160"),
("19","19","14262750024616918919","deep","160"),
("20","20","14348545624454692142","deep","160"),
("21","21","14363170657903482398","deep","160"),
("22","22","14425201770767139125","deep","160"),
("23","23","14441511582142796464","deep","160"),
("24","24","14462753413859282227","deep","160"),
("25","25","14485346910979252884","deep","160"),
("26","26","14494463106969636042","deep","160"),
("27","27","14837364490289221865","deep","160"),
("28","28","14898955144355105705","deep","160"),
("29","29","14927765258936500441","deep","160"),
("30","30","15023650561582315598","deep","160"),
("31","31","15058055143095793985","deep","160"),
("32","32","15060048052050159818","deep","160"),
("33","33","15086425673583751839","deep","160"),
("34","34","15259559663532692769","deep","160"),
("35","35","15260453542728057994","deep","160"),
("36","36","15309938327496590985","deep","160"),
("37","37","15324217751554947773","deep","160"),
("38","38","15340506096454587412","deep","160"),
("39","39","15344340787083681172","deep","160"),
("40","40","15399915235923532795","deep","160"),
("41","41","15407397600431390150","deep","160"),
("42","42","15445186284865255480","deep","160"),
("43","43","15453970712064327922","deep","160"),
("44","44","15618480279487748755","deep","160"),
("45","45","15637114772904049939","deep","160"),
("46","46","15670275035288434130","deep","160"),
("47","47","15672897963596413471","deep","160"),
("48","48","15749714114582412799","deep","160"),
("49","49","15825034675679669475","deep","160"),
("50","50","15868300230879890362","deep","160"),
("51","51","15895724688506089516","deep","160"),
("52","52","15939612211008939411","deep","160"),
("53","53","15941547380696151649","deep","160"),
("54","54","15953246896115256638","deep","160"),
("55","55","15959627435530513940","deep","160"),
("56","56","15988437550111908676","deep","160"),
("57","57","16002616830690254914","deep","160"),
("58","58","16053248590736438292","deep","160"),
("59","59","16069912558028980720","deep","160"),
("60","60","16227423875472193531","deep","160"),
("61","61","16268711237021507342","deep","160"),
("62","62","16333868766035773727","deep","160"),
("63","63","16367232057057405101","deep","160"),
("64","64","16413160429738303312","deep","160"),
("65","65","16415580329409035470","deep","160"),
("66","66","16443541714980115315","deep","160"),
("67","67","16482753539027078241","deep","160"),
("68","68","16527833182697661561","deep","160"),
("69","69","16544451999805153655","deep","160"),
("70","70","16625759339816492330","deep","160"),
("71","71","16787778683514891445","deep","160"),
("72","72","16827583044257565865","deep","160"),
("73","73","16854524898121600595","deep","160"),
("74","74","16919524552978637427","deep","160"),
("75","75","16995884282641352916","deep","160"),
("76","76","17125637238855765769","deep","160"),
("77","77","17126064233867099390","deep","160"),
("78","78","17141189587307204328","deep","160"),
("79","79","17146844588840041019","deep","160"),
("80","80","17148275395980286935","deep","160"),
("81","81","17204793791460541762","deep","160"),
("82","82","17219969216640651975","deep","160"),
("83","83","17338063555178299181","deep","160"),
("84","84","17433521867107748013","deep","160"),
("85","85","17733931178628183339","deep","160"),
("86","86","2743972166173735827","deep","160"),
("0","0","11588413702464419308","deep","161"),
("1","1","11654964555961029595","deep","161"),
("2","2","11859380753828490894","deep","161"),
("3","3","11991806714385855659","deep","161"),
("4","4","12020863169582009318","deep","161"),
("5","5","12124489478418727112","deep","161"),
("6","6","12226925788014099681","deep","161"),
("7","7","12593519208032156944","deep","161"),
("8","8","12819155344965996754","deep","161"),
("9","9","12898888718983318717","deep","161"),
("10","10","12941071785050634459","deep","161"),
("11","11","13208414222199169905","deep","161"),
("12","12","13261764136773355529","deep","161"),
("13","13","13378628867190400000","deep","161"),
("14","14","13392468707155319906","deep","161"),
("15","15","13458105429142280683","deep","161"),
("16","16","13465485528243739288","deep","161"),
("17","17","13484689791001308709","deep","161"),
("18","18","13821951762795852603","deep","161"),
("19","19","13845223981829638917","deep","161"),
("20","20","13849599307796834894","deep","161"),
("21","21","13879018800598755377","deep","161"),
("22","22","14135432778609181938","deep","161"),
("23","23","14153650949761956618","deep","161"),
("24","24","14276757681396723746","deep","161"),
("25","25","14292467908300359154","deep","161"),
("26","26","14309731460064923513","deep","161"),
("27","27","14326495566542509195","deep","161"),
("28","28","14359164051167063029","deep","161"),
("29","29","14409038348289027627","deep","161"),
("30","30","14424359067134198724","deep","161"),
("31","31","14451640357316692490","deep","161"),
("32","32","14530037655938324321","deep","161"),
("33","33","14610592940465931686","deep","161"),
("34","34","14629287295075774665","deep","161"),
("35","35","14692501991170647788","deep","161"),
("36","36","14701970216856560539","deep","161"),
("37","37","14757047346630788981","deep","161"),
("38","38","14815608722805414916","deep","161"),
("39","39","14817646781944831083","deep","161"),
("40","40","14818673361428186635","deep","161"),
("41","41","14893459120801918116","deep","161"),
("42","42","14975632156623756697","deep","161"),
("43","43","14982698198868087548","deep","161"),
("44","44","15019131045772478286","deep","161"),
("45","45","15043824768378506525","deep","161"),
("46","46","15057469247233327568","deep","161"),
("47","47","15130262101947660512","deep","161"),
("48","48","15203826309546741054","deep","161"),
("49","49","15253845896038799240","deep","161"),
("50","50","15262043323552985716","deep","161"),
("51","51","15262420246824314062","deep","161"),
("52","52","15296894662211582184","deep","161"),
("53","53","15308004257336831000","deep","161"),
("54","54","15310084720689104122","deep","161"),
("55","55","15314590620722934930","deep","161"),
("56","56","15384537881633627652","deep","161"),
("57","57","15405528317315094197","deep","161"),
("58","58","15420104153728215183","deep","161"),
("59","59","15430159379099013900","deep","161"),
("60","60","15452917927722862605","deep","161"),
("61","61","15457395523391424628","deep","161"),
("62","62","15524466459013134057","deep","161"),
("63","63","15524468585234489553","deep","161"),
("64","64","15530455364148571552","deep","161"),
("65","65","15598835410237806505","deep","161"),
("66","66","15599277116257631587","deep","161"),
("67","67","15602698701835920544","deep","161"),
("68","68","15705350629150643557","deep","161"),
("69","69","15712170748364370445","deep","161"),
("70","70","15726462757209863198","deep","161"),
("71","71","15763994633873254544","deep","161"),
("72","72","15768796954851784142","deep","161"),
("73","73","15825021059903662971","deep","161"),
("74","74","15860666009002243352","deep","161"),
("75","75","15884024146393081284","deep","161"),
("76","76","15899686427778066913","deep","161"),
("77","77","15928056958266024767","deep","161"),
("78","78","15936079665803200141","deep","161"),
("79","79","15963305347234863104","deep","161"),
("80","80","16014434426346669663","deep","161"),
("81","81","16034949096155222869","deep","161"),
("82","82","16042192783280502325","deep","161"),
("83","83","16060335498936973152","deep","161"),
("84","84","16066786362406520014","deep","161"),
("85","85","16082403497901422605","deep","161"),
("86","86","16116271151470020301","deep","161"),
("87","87","16183835995367882879","deep","161"),
("88","88","16187792382669697031","deep","161"),
("89","89","16209734428223747804","deep","161"),
("90","90","16222367431717475528","deep","161"),
("91","91","16225898950229311555","deep","161"),
("92","92","16248659625074515756","deep","161"),
("93","93","16256626723860860327","deep","161"),
("94","94","16270810925994161506","deep","161"),
("95","95","16304176338942181080","deep","161"),
("96","96","16330900453160477166","deep","161"),
("97","97","16345569385277298265","deep","161"),
("98","98","16390885584404071284","deep","161"),
("99","99","16397531808983717009","deep","161"),
("100","100","16448005694872670834","deep","161"),
("101","101","16466820445276808648","deep","161"),
("102","102","16493371965739449128","deep","161"),
("103","103","16494016700396521393","deep","161"),
("104","104","16501554677950176847","deep","161"),
("105","105","16515583127852636673","deep","161"),
("106","106","16531308065764763542","deep","161"),
("107","107","16557527808846158714","deep","161"),
("108","108","16560105591264055017","deep","161"),
("109","109","16567798647641340579","deep","161"),
("110","110","16641472792468935487","deep","161"),
("111","111","16678654224903630566","deep","161"),
("112","112","16733839165685017878","deep","161"),
("113","113","16742303579242018334","deep","161"),
("114","114","16772177367145867160","deep","161"),
("115","115","16810430524954000829","deep","161"),
("116","116","16824666925048662779","deep","161"),
("117","117","16834230368364663843","deep","161"),
("118","118","16852937316351577379","deep","161"),
("119","119","16870517925898960993","deep","161"),
("120","120","16884761993520771263","deep","161"),
("121","121","16910886518972078122","deep","161"),
("122","122","16977620144496684011","deep","161"),
("123","123","17010900798380395741","deep","161"),
("124","124","17123645429428852189","deep","161"),
("125","125","17163854017828416973","deep","161"),
("126","126","17299264106091989309","deep","161"),
("127","127","17383151350447612487","deep","161"),
("128","128","17398326775627722700","deep","161"),
("129","129","17407890218943723764","deep","161"),
("130","130","17536067082942764409","deep","161"),
("131","131","17643154586237028670","deep","161"),
("132","132","17694567497211430758","deep","161"),
("133","133","2692670287660333062","deep","161"),
("134","134","3061241901329297401","deep","161"),
("135","135","5012682674038322533","deep","161"),
("0","0","11414044160440984755","deep","162"),
("1","1","12277935575154030954","deep","162"),
("2","2","12376948172949759070","deep","162"),
("3","3","12426930281078882538","deep","162"),
("4","4","12554010241540278071","deep","162"),
("5","5","12751579015808450464","deep","162"),
("6","6","12787132698820934734","deep","162"),
("7","7","12891509719409312365","deep","162"),
("8","8","13131317469394350093","deep","162"),
("9","9","13357410027651473742","deep","162"),
("10","10","13878600961460825805","deep","162"),
("11","11","13992609213334360033","deep","162"),
("12","12","14040063610785592473","deep","162"),
("13","13","14071903003258245114","deep","162"),
("14","14","14142519686809716798","deep","162"),
("15","15","14178895284627453766","deep","162"),
("16","16","14352960632134694639","deep","162"),
("17","17","14436428063120599987","deep","162"),
("18","18","14513172249716486788","deep","162"),
("19","19","14535982996301696264","deep","162"),
("20","20","14627329967381071598","deep","162"),
("21","21","14674200370368076869","deep","162"),
("22","22","14714324740457855979","deep","162"),
("23","23","14745989412953497518","deep","162"),
("24","24","14765735525210902571","deep","162"),
("25","25","14821202167338562620","deep","162"),
("26","26","14906495320963665665","deep","162"),
("27","27","14920286729524403263","deep","162"),
("28","28","14978740784872370153","deep","162"),
("29","29","15075600473335147387","deep","162"),
("30","30","15166538165632339358","deep","162"),
("31","31","15186219495141247675","deep","162"),
("32","32","15228713693161753668","deep","162"),
("33","33","15233284380239048508","deep","162"),
("34","34","15343196010860935291","deep","162"),
("35","35","15387680991614451621","deep","162"),
("36","36","15395193791003900553","deep","162"),
("37","37","15533091981066106407","deep","162"),
("38","38","15538091785081123068","deep","162"),
("39","39","15540669563204052075","deep","162"),
("40","40","15580988084537163929","deep","162"),
("41","41","15594183189845011570","deep","162"),
("42","42","15610789417870400403","deep","162"),
("43","43","15670532456646979294","deep","162"),
("44","44","15671029775712602475","deep","162"),
("45","45","15691549367076110622","deep","162"),
("46","46","15696592199349789417","deep","162"),
("47","47","15735075690180732287","deep","162"),
("48","48","15754713991430978470","deep","162"),
("49","49","15798802416349720052","deep","162"),
("50","50","15804206448021627077","deep","162"),
("51","51","15847737688386236387","deep","162"),
("52","52","15877973684257954802","deep","162"),
("53","53","15885456048765812157","deep","162"),
("54","54","15921961345945847951","deep","162"),
("55","55","15926813734369415528","deep","162"),
("56","56","15966981128422889476","deep","162"),
("57","57","15974458571375791890","deep","162"),
("58","58","15986077584468267323","deep","162"),
("59","59","16043732496660392068","deep","162"),
("60","60","16045163299505670688","deep","162"),
("61","61","16047141493156577764","deep","162"),
("62","62","16060446531397972475","deep","162"),
("63","63","16158042216308950789","deep","162"),
("64","64","16175370555116979180","deep","162"),
("65","65","16241062885854770760","deep","162"),
("66","66","16250423304828491937","deep","162"),
("67","67","16443498763849969487","deep","162"),
("68","68","16477758055993354286","deep","162"),
("69","69","16480380984301333627","deep","162"),
("70","70","16517657638661084315","deep","162"),
("71","71","16638396668586480056","deep","162"),
("72","72","16640924374969403788","deep","162"),
("73","73","16672214250415072477","deep","162"),
("74","74","16695022875073893753","deep","162"),
("75","75","16841784160749230307","deep","162"),
("76","76","16917533843079176100","deep","162"),
("77","77","16932817074971477887","deep","162"),
("78","78","17005941702772088843","deep","162"),
("79","79","17033150542678937553","deep","162"),
("80","80","17064490489864611517","deep","162"),
("81","81","17208877026054266247","deep","162"),
("82","82","17219986130999015238","deep","162"),
("83","83","17321526439472634382","deep","162"),
("84","84","17443152296522117615","deep","162"),
("85","85","17456224879814314925","deep","162"),
("86","86","17474529726365693593","deep","162"),
("87","87","17508786892287722896","deep","162"),
("88","88","17989530852623716474","deep","162"),
("0","0","11202580736085795116","deep","163"),
("1","1","11481328402520026849","deep","163"),
("2","2","11940800225828281145","deep","163"),
("3","3","12005980526491958083","deep","163"),
("4","4","12022549271859444902","deep","163"),
("5","5","12145510714124118442","deep","163"),
("6","6","12255690156131749144","deep","163"),
("7","7","12454704448548658914","deep","163"),
("8","8","12461333835898457682","deep","163"),
("9","9","12532040685954724680","deep","163"),
("10","10","12713791426607070091","deep","163"),
("11","11","12715437847171699155","deep","163"),
("12","12","12724263464421895137","deep","163"),
("13","13","12862786132531921675","deep","163"),
("14","14","12876882784562282861","deep","163"),
("15","15","12906014205074240548","deep","163"),
("16","16","13057644428389174734","deep","163"),
("17","17","13122548861321155957","deep","163"),
("18","18","13151586893820629333","deep","163"),
("19","19","13164493546609645294","deep","163"),
("20","20","13403312199769229484","deep","163"),
("21","21","13639820886191628586","deep","163"),
("22","22","13707398319171594425","deep","163"),
("23","23","13718859453811873009","deep","163"),
("24","24","13725688450419514336","deep","163"),
("25","25","13802292398770600548","deep","163"),
("26","26","13845753805261420123","deep","163"),
("27","27","13849307216423363402","deep","163"),
("28","28","13936126394818800676","deep","163"),
("29","29","13957816218994902292","deep","163"),
("30","30","13993194307326039455","deep","163"),
("31","31","14162877151519435856","deep","163"),
("32","32","14180434998007343509","deep","163"),
("33","33","14218406454469204441","deep","163"),
("34","34","14258724975802316295","deep","163"),
("35","35","14283029186054912927","deep","163"),
("36","36","14308195049562357825","deep","163"),
("37","37","14355597249052229494","deep","163"),
("38","38","14367805383755979093","deep","163"),
("39","39","14399145330941653057","deep","163"),
("40","40","14424215972524042346","deep","163"),
("41","41","14466803266248248452","deep","163"),
("42","42","14476921148146188409","deep","163"),
("43","43","14549994829502458085","deep","163"),
("44","44","14634394982931499206","deep","163"),
("45","45","14634416875581606458","deep","163"),
("46","46","14687933503148257454","deep","163"),
("47","47","14689976483842628562","deep","163"),
("48","48","14697012216480738598","deep","163"),
("49","49","14754629646014961329","deep","163"),
("50","50","14812189336282030465","deep","163"),
("51","51","14814571757589827905","deep","163"),
("52","52","14866679470666340237","deep","163"),
("53","53","14876364950112459103","deep","163"),
("54","54","14897028194805205167","deep","163"),
("55","55","14923102652811474047","deep","163"),
("56","56","14926729388953398387","deep","163"),
("57","57","14937224194122666690","deep","163"),
("58","58","14959058432964525889","deep","163"),
("59","59","14992313912978998393","deep","163"),
("60","60","15042346092848127136","deep","163"),
("61","61","15042883016498040531","deep","163"),
("62","62","15067634478371222365","deep","163"),
("63","63","15100940030125700144","deep","163"),
("64","64","15106449742288443247","deep","163"),
("65","65","15154503724211697618","deep","163"),
("66","66","15154930719223031239","deep","163"),
("67","67","15161431654432583376","deep","163"),
("68","68","15164609017027534314","deep","163"),
("69","69","15205367118159115754","deep","163"),
("70","70","15236252770242861375","deep","163"),
("71","71","15264523161545775975","deep","163"),
("72","72","15267484910716343765","deep","163"),
("73","73","15270619869098437748","deep","163"),
("74","74","15326041365336014759","deep","163"),
("75","75","15343911678919249544","deep","163"),
("76","76","15353264920546322226","deep","163"),
("77","77","15355350920909420876","deep","163"),
("78","78","15356485307104968002","deep","163"),
("79","79","15391893700747358684","deep","163"),
("80","80","15409783316026577053","deep","163"),
("81","81","15442099770955601294","deep","163"),
("82","82","15446383835131668456","deep","163"),
("83","83","15468557024406454162","deep","163"),
("84","84","15479498947331002313","deep","163"),
("85","85","15480091484026713807","deep","163"),
("86","86","15487192008003255171","deep","163"),
("87","87","15489220273394167522","deep","163"),
("88","88","15490161424700971281","deep","163"),
("89","89","15501305886082266790","deep","163"),
("90","90","15560424442516057701","deep","163"),
("91","91","15581147062516813031","deep","163"),
("92","92","15586189890495524530","deep","163"),
("93","93","15602311388537393443","deep","163"),
("94","94","15610004449209646301","deep","163"),
("95","95","15628588870885942210","deep","163"),
("96","96","15638214975024051810","deep","163"),
("97","97","15690762272194001024","deep","163"),
("98","98","15694720785717170672","deep","163"),
("99","99","15765427640068404966","deep","163"),
("100","100","15778622745376252607","deep","163"),
("101","101","15787970570972903227","deep","163"),
("102","102","15835437557506238928","deep","163"),
("103","103","15842033714640846674","deep","163"),
("104","104","15890954271373904252","deep","163"),
("105","105","15937035605247011667","deep","163"),
("106","106","15947193091729241838","deep","163"),
("107","107","15963305420068412114","deep","163"),
("108","108","15988643873036545322","deep","163"),
("109","109","16006693497284283332","deep","163"),
("110","110","16006788714914371645","deep","163"),
("111","111","16014986142428558121","deep","163"),
("112","112","16016307012340289671","deep","163"),
("113","113","16034055294088373950","deep","163"),
("114","114","16070357562631162561","deep","163"),
("115","115","16094611705438721214","deep","163"),
("116","116","16111750608966279746","deep","163"),
("117","117","16136943772564319366","deep","163"),
("118","118","16188406755278726729","deep","163"),
("119","119","16204558688202187219","deep","163"),
("120","120","16208127689371925260","deep","163"),
("121","121","16209724038196549049","deep","163"),
("122","122","16217863726443581930","deep","163"),
("123","123","16225353758478587605","deep","163"),
("124","124","16250627428698224077","deep","163"),
("125","125","16284826859648067081","deep","163"),
("126","126","16308749225074380426","deep","163"),
("127","127","16328967478233202138","deep","163"),
("128","128","16330506092085639628","deep","163"),
("129","129","16360761720520804445","deep","163"),
("130","130","16365109746397405700","deep","163"),
("131","131","16403095918162725389","deep","163"),
("132","132","16449596575225050809","deep","163"),
("133","133","16476767932473997505","deep","163"),
("134","134","16485834061019342684","deep","163"),
("135","135","16493469382424441947","deep","163"),
("136","136","16502000709246261931","deep","163"),
("137","137","16563479304157243205","deep","163"),
("138","138","16565177922683233040","deep","163"),
("139","139","16571114625562342468","deep","163"),
("140","140","16583820079331715248","deep","163"),
("141","141","16637263381918385183","deep","163"),
("142","142","16638395641892576813","deep","163"),
("143","143","16640498483780489716","deep","163"),
("144","144","16656050827936960979","deep","163"),
("145","145","16683272261220880246","deep","163"),
("146","146","16690857510885974234","deep","163"),
("147","147","16699828417506263804","deep","163"),
("148","148","16720204549117282365","deep","163"),
("149","149","16727247333826670134","deep","163"),
("150","150","16792340080092439783","deep","163"),
("151","151","16810043215950441024","deep","163"),
("152","152","16836275548113939457","deep","163"),
("153","153","16844849894604486983","deep","163"),
("154","154","16883775095750222231","deep","163"),
("155","155","16917692821058825202","deep","163"),
("156","156","16938257562607383683","deep","163"),
("157","157","16951402596175226049","deep","163"),
("158","158","16991771189248343178","deep","163"),
("159","159","16994790673391097267","deep","163"),
("160","160","16995714987468054069","deep","163"),
("161","161","17003804603975081675","deep","163"),
("162","162","17055427591363041383","deep","163"),
("163","163","17085676172021895763","deep","163"),
("164","164","17106398792022651093","deep","163"),
("165","165","17131125075731626405","deep","163"),
("166","166","17145713501226850652","deep","163"),
("167","167","17157465214607316412","deep","163"),
("168","168","17164551023280399019","deep","163"),
("169","169","17168963831905497010","deep","163"),
("170","170","17173629736612880163","deep","163"),
("171","171","17186616891728525680","deep","163"),
("172","172","17238079874442933043","deep","163"),
("173","173","17282602337854351387","deep","163"),
("174","174","17286668658089712609","deep","163"),
("175","175","17292605365263789333","deep","163"),
("176","176","17331090982316087699","deep","163"),
("177","177","17379035031305795000","deep","163"),
("178","178","17383261356214708567","deep","163"),
("179","179","17404765122848715311","deep","163"),
("180","180","17572502128902059653","deep","163"),
("181","181","17604231588441165224","deep","163"),
("182","182","17650696889066944126","deep","163"),
("183","183","17672908051180131671","deep","163"),
("184","184","17702709384513368145","deep","163"),
("185","185","17721351545456817649","deep","163"),
("186","186","17736966550435397448","deep","163"),
("187","187","17928440743372263564","deep","163"),
("188","188","17988478072577218453","deep","163"),
("189","189","18081393958525317500","deep","163"),
("190","190","2909244625620054991","deep","163"),
("191","191","3285596850064212181","deep","163"),
("0","0","10103831277033088763","deep","164"),
("1","1","10802575057128520753","deep","164"),
("2","2","11203570932438700907","deep","164"),
("3","3","11488415306425594413","deep","164"),
("4","4","11863046149284285807","deep","164"),
("5","5","11866469861083930260","deep","164"),
("6","6","12200877400239598113","deep","164"),
("7","7","12284034481761597233","deep","164"),
("8","8","12324952591861698314","deep","164"),
("9","9","12335005686716174239","deep","164"),
("10","10","12357671143931290127","deep","164"),
("11","11","12461334935425909935","deep","164"),
("12","12","12520543172478963631","deep","164"),
("13","13","12554250821374008982","deep","164"),
("14","14","12688379107850585108","deep","164"),
("15","15","12778365185980225555","deep","164"),
("16","16","12817142971534511719","deep","164"),
("17","17","12837117001709995412","deep","164"),
("18","18","12900613399151141272","deep","164"),
("19","19","12908080663831703690","deep","164"),
("20","20","12930289699723535739","deep","164"),
("21","21","12942483119123826581","deep","164"),
("22","22","12984722094840691916","deep","164"),
("23","23","12995507483045114691","deep","164"),
("24","24","13098932889465940798","deep","164"),
("25","25","13197576231517488888","deep","164"),
("26","26","13238407171743518860","deep","164"),
("27","27","13252960240802196589","deep","164"),
("28","28","13359352937699383310","deep","164"),
("29","29","13430059792050617604","deep","164"),
("30","30","13453001112702461911","deep","164"),
("31","31","13473982670990014017","deep","164"),
("32","32","13578673037673022081","deep","164"),
("33","33","13581070169989310982","deep","164"),
("34","34","13733689490129698706","deep","164"),
("35","35","13738667401494608115","deep","164"),
("36","36","13820583629545972712","deep","164"),
("37","37","13837152379208426827","deep","164"),
("38","38","13902952516658409981","deep","164"),
("39","39","13926477371336680581","deep","164"),
("40","40","14010790731704334079","deep","164"),
("41","41","14037083804060677608","deep","164"),
("42","42","14102146119739822976","deep","164"),
("43","43","14173935162325243625","deep","164"),
("44","44","14216723650774125616","deep","164"),
("45","45","14277310497006064457","deep","164"),
("46","46","14304237635566640430","deep","164"),
("47","47","14455115313217343481","deep","164"),
("48","48","14474394541290716930","deep","164"),
("49","49","14507237741597314570","deep","164"),
("50","50","14516129150165648647","deep","164"),
("51","51","14542910999356131032","deep","164"),
("52","52","14654679122661237203","deep","164"),
("53","53","14659641444018351850","deep","164"),
("54","54","14684819896607900009","deep","164"),
("55","55","14707065536158330771","deep","164"),
("56","56","14731270481930220154","deep","164"),
("57","57","14791957467347202249","deep","164"),
("58","58","14803515945838924642","deep","164"),
("59","59","14828744470168478076","deep","164"),
("60","60","14855621536989048774","deep","164"),
("61","61","14869697932410158379","deep","164"),
("62","62","14887243185520995475","deep","164"),
("63","63","14895975414758707146","deep","164"),
("64","64","14907474027761920448","deep","164"),
("65","65","14911165555242276116","deep","164"),
("66","66","14949873008152338128","deep","164"),
("67","67","14956359232353398804","deep","164"),
("68","68","14989895112835718488","deep","164"),
("69","69","15030740768365207217","deep","164"),
("70","70","15068516863716969286","deep","164"),
("71","71","15075775266145707499","deep","164"),
("72","72","15077703388056609300","deep","164"),
("73","73","15111623239586567767","deep","164"),
("74","74","15147858599159504146","deep","164"),
("75","75","15151927045616220864","deep","164"),
("76","76","15156485143611412443","deep","164"),
("77","77","15173184467340501389","deep","164"),
("78","78","15179685402550053526","deep","164"),
("79","79","15198774191068283053","deep","164"),
("80","80","15237699387919051005","deep","164"),
("81","81","15241376200095947916","deep","164"),
("82","82","15270073582115228841","deep","164"),
("83","83","15271660137191348814","deep","164"),
("84","84","15310427455589919917","deep","164"),
("85","85","15345334282018943722","deep","164"),
("86","86","15364967661714234964","deep","164"),
("87","87","15369134125429606736","deep","164"),
("88","88","15373496862314699452","deep","164"),
("89","89","15406802414069177231","deep","164"),
("90","90","15414841958836199562","deep","164"),
("91","91","15417073252864359096","deep","164"),
("92","92","15432984674492670389","deep","164"),
("93","93","15445445909573672446","deep","164"),
("94","94","15454899419956126440","deep","164"),
("95","95","15464434554611891423","deep","164"),
("96","96","15469635265337767067","deep","164"),
("97","97","15471570435024979305","deep","164"),
("98","98","15497248328606538845","deep","164"),
("99","99","15524080249537026505","deep","164"),
("100","100","15530069150377496704","deep","164"),
("101","101","15531665499202120493","deep","164"),
("102","102","15557350444854957766","deep","164"),
("103","103","15585751410224507197","deep","164"),
("104","104","15588957378083445710","deep","164"),
("105","105","15593196292074462538","deep","164"),
("106","106","15645301883224586670","deep","164"),
("107","107","15670092949682058718","deep","164"),
("108","108","15674895266365621020","deep","164"),
("109","109","15680110688099988125","deep","164"),
("110","110","15696716920420344254","deep","164"),
("111","111","15701837120229655750","deep","164"),
("112","112","15706343024558453854","deep","164"),
("113","113","15733551864465302564","deep","164"),
("114","114","15747138608347937308","deep","164"),
("115","115","15748275120764839930","deep","164"),
("116","116","15769495059831218441","deep","164"),
("117","117","15777597265420349308","deep","164"),
("118","118","15784070896244339427","deep","164"),
("119","119","15802815322594187681","deep","164"),
("120","120","15812283548280100432","deep","164"),
("121","121","15812333620020105707","deep","164"),
("122","122","15824035261660566192","deep","164"),
("123","123","15827444258156751888","deep","164"),
("124","124","15854682528670518112","deep","164"),
("125","125","15859845756738491742","deep","164"),
("126","126","15864938656457208516","deep","164"),
("127","127","15867263334202885065","deep","164"),
("128","128","15887494176443810038","deep","164"),
("129","129","15927957987147015480","deep","164"),
("130","130","15952262197399612112","deep","164"),
("131","131","15989194489590981527","deep","164"),
("132","132","16001804725730265994","deep","164"),
("133","133","16005199006922992933","deep","164"),
("134","134","16007793626570736193","deep","164"),
("135","135","16028853560963562359","deep","164"),
("136","136","16032409973051197139","deep","164"),
("137","137","16052091302560105456","deep","164"),
("138","138","16055675019033302254","deep","164"),
("139","139","16057653208389242034","deep","164"),
("140","140","16060183045288488558","deep","164"),
("141","141","16065785853154931774","deep","164"),
("142","142","16068712245888953046","deep","164"),
("143","143","16103127290263179198","deep","164"),
("144","144","16113197226642469376","deep","164"),
("145","145","16122369035678650633","deep","164"),
("146","146","16123749766783923978","deep","164"),
("147","147","16131045651870564205","deep","164"),
("148","148","16156078810795051480","deep","164"),
("149","149","16171789037698686888","deep","164"),
("150","150","16179866065123611233","deep","164"),
("151","151","16186979178182255858","deep","164"),
("152","152","16191080854854163598","deep","164"),
("153","153","16201635521216973696","deep","164"),
("154","154","16208626107965000694","deep","164"),
("155","155","16213588433617082637","deep","164"),
("156","156","16217105236825459907","deep","164"),
("157","157","16218696044344290872","deep","164"),
("158","158","16218803855351449742","deep","164"),
("159","159","16231386782810204895","deep","164"),
("160","160","16251522407421041555","deep","164"),
("161","161","16264265343848316349","deep","164"),
("162","162","16264864928320338280","deep","164"),
("163","163","16274428375931306640","deep","164"),
("164","164","16274760149017584652","deep","164"),
("165","165","16304026680627295931","deep","164"),
("166","166","16311155513264073376","deep","164"),
("167","167","16351084522243753623","deep","164"),
("168","168","16352515325089032243","deep","164"),
("169","169","16357021225122863051","deep","164"),
("170","170","16358075108991780621","deep","164"),
("171","171","16372688428062803621","deep","164"),
("172","172","16385393881832176401","deep","164"),
("173","173","16386222973984077594","deep","164"),
("174","174","16411114183921560192","deep","164"),
("175","175","16413641890304483924","deep","164"),
("176","176","16437795889632032027","deep","164"),
("177","177","16456033827213558463","deep","164"),
("178","178","16457527286585978323","deep","164"),
("179","179","16468292029362346041","deep","164"),
("180","180","16488962455696707896","deep","164"),
("181","181","16492775675554816660","deep","164"),
("182","182","16501510031013883827","deep","164"),
("183","183","16529158450719202123","deep","164"),
("184","184","16544456397914962667","deep","164"),
("185","185","16549122306917313116","deep","164"),
("186","186","16563040823886225872","deep","164"),
("187","187","16576171142150609481","deep","164"),
("188","188","16578361538436429673","deep","164"),
("189","189","16593876404229966218","deep","164"),
("190","190","16610136143865618282","deep","164"),
("191","191","16631153054294749610","deep","164"),
("192","192","16632302155793755493","deep","164"),
("193","193","16634295064748121326","deep","164"),
("194","194","16639337892726832825","deep","164"),
("195","195","16672560811638358256","deep","164"),
("196","196","16676679329835080249","deep","164"),
("197","197","16707464838438815320","deep","164"),
("198","198","16712073008174012174","deep","164"),
("199","199","16762444624361599953","deep","164"),
("200","200","16769140920681250953","deep","164"),
("201","201","16796701790283629256","deep","164"),
("202","202","16798890060348093952","deep","164"),
("203","203","16808945281423925373","deep","164"),
("204","204","16811048123311838276","deep","164"),
("205","205","16813026316962745352","deep","164"),
("206","206","16826063543818396144","deep","164"),
("207","207","16843312384574469042","deep","164"),
("208","208","16845854806260851531","deep","164"),
("209","209","16927589136988556531","deep","164"),
("210","210","16950254594203672419","deep","164"),
("211","211","16954373112400394412","deep","164"),
("212","212","16955961793697869881","deep","164"),
("213","213","16996865188494512205","deep","164"),
("214","214","17007322506710911198","deep","164"),
("215","215","17007387293754375230","deep","164"),
("216","216","17009952482795200976","deep","164"),
("217","217","17056367715975941899","deep","164"),
("218","218","17073506619503500431","deep","164"),
("219","219","17141646154297586187","deep","164"),
("220","220","17258364014172671040","deep","164"),
("221","221","17294209861392175812","deep","164"),
("222","222","17333669859966468959","deep","164"),
("223","223","17392572802975876722","deep","164"),
("224","224","17447148365536738287","deep","164"),
("225","225","17551830680168761851","deep","164"),
("226","226","17605236500097529772","deep","164"),
("227","227","17617365132454356582","deep","164"),
("228","228","17629036343508192786","deep","164"),
("229","229","17630025440333646324","deep","164"),
("230","230","17649708891768942841","deep","164"),
("231","231","17653213105895216850","deep","164"),
("232","232","17728438449362385213","deep","164"),
("233","233","17797699785564882130","deep","164"),
("234","234","17805189817599887805","deep","164"),
("235","235","17941089557401935002","deep","164"),
("236","236","3453471367621187925","deep","164"),
("237","237","4758287666624094525","deep","164"),
("238","238","4805596774705233377","deep","164"),
("0","0","11542811322707268125","deep","165"),
("1","1","12146207719576100488","deep","165"),
("2","2","12878367980128859462","deep","165"),
("3","3","12914748633366856725","deep","165"),
("4","4","12944205604531711926","deep","165"),
("5","5","13261768534883164541","deep","165"),
("6","6","13278631570679027358","deep","165"),
("7","7","13400309625689871362","deep","165"),
("8","8","13601302111757688208","deep","165"),
("9","9","13829995709967651242","deep","165"),
("10","10","13926608170226431660","deep","165"),
("11","11","13942519596149710249","deep","165"),
("12","12","13942592921129691310","deep","165"),
("13","13","14005427408439136817","deep","165"),
("14","14","14122378061508200202","deep","165"),
("15","15","14125916757366684724","deep","165"),
("16","16","14186519189311451031","deep","165"),
("17","17","14280488959128467648","deep","165"),
("18","18","14312717863954551896","deep","165"),
("19","19","14314696057605458972","deep","165"),
("20","20","14376936367883370018","deep","165"),
("21","21","14399594287141675644","deep","165"),
("22","22","14568800068878700445","deep","165"),
("23","23","14573232643932550192","deep","165"),
("24","24","14605102341716456352","deep","165"),
("25","25","14618839421799510387","deep","165"),
("26","26","14655619247274137719","deep","165"),
("27","27","14666148529880649239","deep","165"),
("28","28","14739456419889755622","deep","165"),
("29","29","14741888908642591041","deep","165"),
("30","30","14757663922589690481","deep","165"),
("31","31","14811055022920032349","deep","165"),
("32","32","14847604980104618652","deep","165"),
("33","33","14890775807855251051","deep","165"),
("34","34","14894063107678716355","deep","165"),
("35","35","14923250141236472141","deep","165"),
("36","36","14925619969167199024","deep","165"),
("37","37","14937226393177571196","deep","165"),
("38","38","15005071637543280954","deep","165"),
("39","39","15017719356340467435","deep","165"),
("40","40","15047910202027135516","deep","165"),
("41","41","15084747272293449322","deep","165"),
("42","42","15095899396906925855","deep","165"),
("43","43","15098377035844811608","deep","165"),
("44","44","15120183974596076085","deep","165"),
("45","45","15218551837734731936","deep","165"),
("46","46","15261043909533882433","deep","165"),
("47","47","15263024229406145005","deep","165"),
("48","48","15273923257937336376","deep","165"),
("49","49","15303674523825534871","deep","165"),
("50","50","15306412306622016223","deep","165"),
("51","51","15317469213605404443","deep","165"),
("52","52","15416150038314854547","deep","165"),
("53","53","15424079654443297104","deep","165"),
("54","54","15466509069715306361","deep","165"),
("55","55","15511433630267292277","deep","165"),
("56","56","15515833849810287007","deep","165"),
("57","57","15518469367200369609","deep","165"),
("58","58","15688520592433610031","deep","165"),
("59","59","15708216632951009809","deep","165"),
("60","60","15717830148007016148","deep","165"),
("61","61","15770831740278893705","deep","165"),
("62","62","15770939551286052575","deep","165"),
("63","63","15781876062475145960","deep","165"),
("64","64","15792543457105102573","deep","165"),
("65","65","15804794615772547010","deep","165"),
("66","66","15808058322898639118","deep","165"),
("67","67","15872971633224534780","deep","165"),
("68","68","15874472764419070256","deep","165"),
("69","69","15931028646852194393","deep","165"),
("70","70","15931043357860685854","deep","165"),
("71","71","15953586293060151411","deep","165"),
("72","72","15964296715948770158","deep","165"),
("73","73","15979928562452164210","deep","165"),
("74","74","16046717796727600902","deep","165"),
("75","75","16052656630123033122","deep","165"),
("76","76","16056223505071415667","deep","165"),
("77","77","16063273957307951756","deep","165"),
("78","78","16064140532117754963","deep","165"),
("79","79","16065946957355936372","deep","165"),
("80","80","16077350352729061361","deep","165"),
("81","81","16106647319220364217","deep","165"),
("82","82","16110164126723708783","deep","165"),
("83","83","16146561612896585707","deep","165"),
("84","84","16149154106322973471","deep","165"),
("85","85","16151277593638941431","deep","165"),
("86","86","16176470757236981051","deep","165"),
("87","87","16238927986112668098","deep","165"),
("88","88","16257670286241160856","deep","165"),
("89","89","16285443358478452275","deep","165"),
("90","90","16300661807622257326","deep","165"),
("91","91","16327335845805580841","deep","165"),
("92","92","16345038981663582082","deep","165"),
("93","93","16370377438926682586","deep","165"),
("94","94","16418648339447712958","deep","165"),
("95","95","16453065510043294606","deep","165"),
("96","96","16473644966895311844","deep","165"),
("97","97","16493376363849258140","deep","165"),
("98","98","16520693010468298424","deep","165"),
("99","99","16592873691628506176","deep","165"),
("100","100","16605629217137884231","deep","165"),
("101","101","16607060019983162851","deep","165"),
("102","102","16617689936250184746","deep","165"),
("103","103","16686901196417709092","deep","165"),
("104","104","16706981207982747653","deep","165"),
("105","105","16736775497834640986","deep","165"),
("106","106","16742480571107482952","deep","165"),
("107","107","16770081049589118765","deep","165"),
("108","108","16784265251722419944","deep","165"),
("109","109","16820662742190264164","deep","165"),
("110","110","16838755386106729716","deep","165"),
("111","111","16861508393424785597","deep","165"),
("112","112","16953982573353059562","deep","165"),
("113","113","16982744742415804519","deep","165"),
("114","114","17013420318085992520","deep","165"),
("115","115","17042782071620759408","deep","165"),
("116","116","17050417393025858671","deep","165"),
("117","117","17084125046215871318","deep","165"),
("118","118","17183527152070063745","deep","165"),
("119","119","17249833786878303309","deep","165"),
("120","120","17252253686549035467","deep","165"),
("121","121","17276992559340114040","deep","165"),
("122","122","17306793892673350514","deep","165"),
("123","123","17346173384626046809","deep","165"),
("124","124","17382606231530437547","deep","165"),
("125","125","17411853130576702424","deep","165"),
("126","126","17453210816180305795","deep","165"),
("127","127","17610330495048731503","deep","165"),
("128","128","17618370044110721130","deep","165"),
("129","129","2744672470208074632","deep","165"),
("130","130","2906849692358670596","deep","165"),
("131","131","4010967795722136348","deep","165"),
("0","0","11542812422234720378","deep","166"),
("1","1","11965447175276660868","deep","166"),
("2","2","11967462851585469958","deep","166"),
("3","3","11997214113178701157","deep","166"),
("4","4","12055965928908471014","deep","166"),
("5","5","12266478838623561382","deep","166"),
("6","6","12275961779612932890","deep","166"),
("7","7","12349598437487658488","deep","166"),
("8","8","12383049282907197151","deep","166"),
("9","9","12407398639049876821","deep","166"),
("10","10","12448154613960102765","deep","166"),
("11","11","12594513802494871747","deep","166"),
("12","12","12604272611215938970","deep","166"),
("13","13","12698928305741151392","deep","166"),
("14","14","12751545931260357462","deep","166"),
("15","15","13029304496574168361","deep","166"),
("16","16","13205985104862240255","deep","166"),
("17","17","13211092719884415786","deep","166"),
("18","18","13250565307540812194","deep","166"),
("19","19","13278670152864381625","deep","166"),
("20","20","13294944607803492446","deep","166"),
("21","21","13337146100862455767","deep","166"),
("22","22","13389801209039563851","deep","166"),
("23","23","13425230243815042294","deep","166"),
("24","24","13675928970280286893","deep","166"),
("25","25","13721501270710003871","deep","166"),
("26","26","13749346303042440521","deep","166"),
("27","27","13910315048386021336","deep","166"),
("28","28","13978607054191816471","deep","166"),
("29","29","14001238029674721846","deep","166"),
("30","30","14102958104955677795","deep","166"),
("31","31","14108340248272444864","deep","166"),
("32","32","14115280763280466587","deep","166"),
("33","33","14167840649532519062","deep","166"),
("34","34","14265848560494998878","deep","166"),
("35","35","14283956794419259192","deep","166"),
("36","36","14288969187516379114","deep","166"),
("37","37","14312718963482004149","deep","166"),
("38","38","14352683328898230914","deep","166"),
("39","39","14468784758481512287","deep","166"),
("40","40","14483447274588204557","deep","166"),
("41","41","14497618887639402475","deep","166"),
("42","42","14502726502661578006","deep","166"),
("43","43","14539526090269989798","deep","166"),
("44","44","14578269394092065449","deep","166"),
("45","45","14583411486551484197","deep","166"),
("46","46","14599152018766373124","deep","166"),
("47","47","14609047239463619496","deep","166"),
("48","48","14630339138625143238","deep","166"),
("49","49","14634400407735211461","deep","166"),
("50","50","14667169031544808549","deep","166"),
("51","51","14678343053103359630","deep","166"),
("52","52","14690529295157001977","deep","166"),
("53","53","14709611035898921067","deep","166"),
("54","54","14756668387334878934","deep","166"),
("55","55","14759065519651167835","deep","166"),
("56","56","14759630626685946549","deep","166"),
("57","57","14790825280206559629","deep","166"),
("58","58","14817102762555108396","deep","166"),
("59","59","14832827704762202561","deep","166"),
("60","60","14839363996408301216","deep","166"),
("61","61","14839524001081853561","deep","166"),
("62","62","14841893829012580444","deep","166"),
("63","63","14848003129942312774","deep","166"),
("64","64","14848979637685663051","deep","166"),
("65","65","14849527028491291507","deep","166"),
("66","66","14852106932835576010","deep","166"),
("67","67","14871788258049517031","deep","166"),
("68","68","14873238827323547407","deep","166"),
("69","69","14884840200208626580","deep","166"),
("70","70","14888407075157009125","deep","166"),
("71","71","14904413718710376027","deep","166"),
("72","72","14908040459147267663","deep","166"),
("73","73","14912142135819175403","deep","166"),
("74","74","14912144262040530899","deep","166"),
("75","75","14914194415786583206","deep","166"),
("76","76","14934425258027508179","deep","166"),
("77","77","14940809082956864751","deep","166"),
("78","78","15000956345095366710","deep","166"),
("79","79","15019686060436723503","deep","166"),
("80","80","15038780385965778558","deep","166"),
("81","81","15040466415409665132","deep","166"),
("82","82","15041310222865025082","deep","166"),
("83","83","15096435298157903303","deep","166"),
("84","84","15131294174773310033","deep","166"),
("85","85","15131843691800293985","deep","166"),
("86","86","15151871505403971775","deep","166"),
("87","87","15200957608116374522","deep","166"),
("88","88","15209986254003817687","deep","166"),
("89","89","15227069544485578120","deep","166"),
("90","90","15228168578539546024","deep","166"),
("91","91","15236697774845043216","deep","166"),
("92","92","15245444719386213644","deep","166"),
("93","93","15250991914206858761","deep","166"),
("94","94","15318519275446819325","deep","166"),
("95","95","15335722961722874593","deep","166"),
("96","96","15342650891943760351","deep","166"),
("97","97","15349244922857012601","deep","166"),
("98","98","15357226732651848633","deep","166"),
("99","99","15391144457960451604","deep","166"),
("100","100","15397298904780266972","deep","166"),
("101","101","15407808425252994032","deep","166"),
("102","102","15417472007754038350","deep","166"),
("103","103","15445288103955024607","deep","166"),
("104","104","15452830333951391053","deep","166"),
("105","105","15465865434585686349","deep","166"),
("106","106","15473550827730790887","deep","166"),
("107","107","15480586564663868219","deep","166"),
("108","108","15495322405750541550","deep","166"),
("109","109","15521100442812111640","deep","166"),
("110","110","15530179160439560080","deep","166"),
("111","111","15573502450611967266","deep","166"),
("112","112","15602104615001159878","deep","166"),
("113","113","15609950012819816761","deep","166"),
("114","114","15630130783320736459","deep","166"),
("115","115","15638002660182025421","deep","166"),
("116","116","15642164198047474956","deep","166"),
("117","117","15647833914883770404","deep","166"),
("118","118","15671430733952153531","deep","166"),
("119","119","15675446982447509478","deep","166"),
("120","120","15680005080442701057","deep","166"),
("121","121","15719369861386905891","deep","166"),
("122","122","15782584553186811718","deep","166"),
("123","123","15840151910981029174","deep","166"),
("124","124","15844602202264029179","deep","166"),
("125","125","15869750219971985761","deep","166"),
("126","126","15870942345434686482","deep","166"),
("127","127","15911456223582929903","deep","166"),
("128","128","15913181321151551817","deep","166"),
("129","129","15928062455903286032","deep","166"),
("130","130","15984688662390699729","deep","166"),
("131","131","16025281217542936000","deep","166"),
("132","132","16037040598450550080","deep","166"),
("133","133","16070850517046961477","deep","166"),
("134","134","16073877668716863886","deep","166"),
("135","135","16085428479681437959","deep","166"),
("136","136","16085868059479907545","deep","166"),
("137","137","16094050771690635264","deep","166"),
("138","138","16099000508260613946","deep","166"),
("139","139","16106258906394384863","deep","166"),
("140","140","16110764810723182967","deep","166"),
("141","141","16123751965838828484","deep","166"),
("142","142","16131929136743763379","deep","166"),
("143","143","16140611294241469775","deep","166"),
("144","144","16153648521097120567","deep","166"),
("145","145","16167739631821688929","deep","166"),
("146","146","16169863114842689593","deep","166"),
("147","147","16202626817097331740","deep","166"),
("148","148","16224794955246824447","deep","166"),
("149","149","16238381699129459191","deep","166"),
("150","150","16244930575562693811","deep","166"),
("151","151","16247553503870673152","deep","166"),
("152","152","16272784154421582082","deep","166"),
("153","153","16299139008600730846","deep","166"),
("154","154","16307495615445539728","deep","166"),
("155","155","16310133259056977826","deep","166"),
("156","156","16314191911765190728","deep","166"),
("157","157","16352032794160416829","deep","166"),
("158","158","16361646309216423168","deep","166"),
("159","159","16363734435800877314","deep","166"),
("160","160","16378787338965337196","deep","166"),
("161","161","16388912888390425473","deep","166"),
("162","162","16411066311236459423","deep","166"),
("163","163","16414705640755454320","deep","166"),
("164","164","16466103836426397651","deep","166"),
("165","165","16491948782457819973","deep","166"),
("166","166","16512619208792181828","deep","166"),
("167","167","16513118654079160505","deep","166"),
("168","168","16519107554919630704","deep","166"),
("169","169","16526755465406833228","deep","166"),
("170","170","16536354265159380810","deep","166"),
("171","171","16546986307647758201","deep","166"),
("172","172","16580783637162066337","deep","166"),
("173","173","16602003576228444848","deep","166"),
("174","174","16604533408832724076","deep","166"),
("175","175","16635381578258567683","deep","166"),
("176","176","16655517202869404343","deep","166"),
("177","177","16667660550529689910","deep","166"),
("178","178","16676189751130154398","deep","166"),
("179","179","16691365176310264611","deep","166"),
("180","180","16788824449245063776","deep","166"),
("181","181","16795433191166807487","deep","166"),
("182","182","16825184457055005982","deep","166"),
("183","183","16841935974450488403","deep","166"),
("184","184","16857608718696221797","deep","166"),
("185","185","16859052110623603678","deep","166"),
("186","186","16868610016928779214","deep","166"),
("187","187","16879616852172162159","deep","166"),
("188","188","16884217974131048576","deep","166"),
("189","189","16885806655428524045","deep","166"),
("190","190","16898454374225710526","deep","166"),
("191","191","16967505634014649823","deep","166"),
("192","192","17017005134086641571","deep","166"),
("193","193","17017994230912095109","deep","166"),
("194","194","17020961521388455723","deep","166"),
("195","195","17058443326311841794","deep","166"),
("196","196","17157360706477481597","deep","166"),
("197","197","17178740650217412453","deep","166"),
("198","198","17293222963621626780","deep","166"),
("199","199","17294257210632130652","deep","166"),
("200","200","17300793502278229307","deep","166"),
("201","201","17347698382702477795","deep","166"),
("202","202","17445172370940735717","deep","166"),
("203","203","17543757973725130212","deep","166"),
("204","204","17548705584073753398","deep","166"),
("205","205","17672961417207526409","deep","166"),
("206","206","17689075871768052181","deep","166"),
("207","207","17796567598424239510","deep","166"),
("208","208","17819363629705990229","deep","166"),
("209","209","17832011348503176710","deep","166"),
("210","210","18052699875088393334","deep","166"),
("211","211","18114275813850818417","deep","166"),
("212","212","1835175372860553195","deep","166"),
("213","213","2065919124816568536","deep","166"),
("214","214","2568324730238765707","deep","166"),
("215","215","3123422926495972976","deep","166"),
("216","216","3137594539547170894","deep","166"),
("217","217","3323426315738336284","deep","166"),
("218","218","3594393367102407870","deep","166"),
("219","219","4231534899819154894","deep","166"),
("0","0","10038866090181898527","deep","167"),
("1","1","10131781980424964870","deep","167"),
("2","2","10224697866373063917","deep","167"),
("3","3","10716352448553049992","deep","167"),
("4","4","10903173321569668920","deep","167"),
("5","5","10932924587457867415","deep","167"),
("6","6","11002185919365397036","deep","167"),
("7","7","11009271728038479643","deep","167"),
("8","8","11089994194586287848","deep","167"),
("9","9","11102187613986578690","deep","167"),
("10","10","11119745460474486343","deep","167"),
("11","11","11189006792382015964","deep","167"),
("12","12","11196092601055098571","deep","167"),
("13","13","11263670034035064410","deep","167"),
("14","14","11266761968453463555","deep","167"),
("15","15","11276815067602906776","deep","167"),
("16","16","11289008487003197618","deep","167"),
("17","17","11306566333491105271","deep","167"),
("18","18","11318759752891396113","deep","167"),
("19","19","11325845557269511424","deep","167"),
("20","20","11375827665398634892","deep","167"),
("21","21","11380240474023732883","deep","167"),
("22","22","11382913474071717499","deep","167"),
("23","23","11413653832490402236","deep","167"),
("24","24","11450490902756716042","deep","167"),
("25","25","11452593744644628945","deep","167"),
("26","26","11453582841470082483","deep","167"),
("27","27","11463635940619525704","deep","167"),
("28","28","11475829360019816546","deep","167"),
("29","29","11490419916031363585","deep","167"),
("30","30","11493387202212756903","deep","167"),
("31","31","11505580625908015041","deep","167"),
("32","32","11512666430286130352","deep","167"),
("33","33","11566767056611975813","deep","167"),
("34","34","11567061347040351811","deep","167"),
("35","35","11569734347088336427","deep","167"),
("36","36","11600474705507021164","deep","167"),
("37","37","11639414617661247873","deep","167"),
("38","38","11640403714486701411","deep","167"),
("39","39","11650456813636144632","deep","167"),
("40","40","11662650233036435474","deep","167"),
("41","41","11673159753509162534","deep","167"),
("42","42","11680208075229375831","deep","167"),
("43","43","11692401498924633969","deep","167"),
("44","44","11699487303302749280","deep","167"),
("45","45","11721163663692411630","deep","167"),
("46","46","11735335281038576844","deep","167"),
("47","47","11756555215809988059","deep","167"),
("48","48","11758989830784178974","deep","167"),
("49","49","11759684637181256514","deep","167"),
("50","50","11787295578523640092","deep","167"),
("51","51","11821165358313593284","deep","167"),
("52","52","11823143551964500360","deep","167"),
("53","53","11826235490677866801","deep","167"),
("54","54","11827224587503320339","deep","167"),
("55","55","11835336975659758498","deep","167"),
("56","56","11837277686652763560","deep","167"),
("57","57","11849471106053054402","deep","167"),
("58","58","11854578721075229933","deep","167"),
("59","59","11867028948245994759","deep","167"),
("60","60","11879222371941252897","deep","167"),
("61","61","11886308176319368208","deep","167"),
("62","62","11907984536709030558","deep","167"),
("63","63","11922156149760228476","deep","167"),
("64","64","11940408798350246373","deep","167"),
("65","65","11943376088826606987","deep","167"),
("66","66","11945810703800797902","deep","167"),
("67","67","11974116451540259020","deep","167"),
("68","68","12007986231330212212","deep","167"),
("69","69","12009964424981119288","deep","167"),
("70","70","12013056363694485729","deep","167"),
("71","71","12014045460519939267","deep","167"),
("72","72","12022157844381410130","deep","167"),
("73","73","12027559749831961659","deep","167"),
("74","74","12034645558505044266","deep","167"),
("75","75","12036291979069673330","deep","167"),
("76","76","12041399594091848861","deep","167"),
("77","77","12044823301596526018","deep","167"),
("78","78","12053849821262613687","deep","167"),
("79","79","12060973112593598308","deep","167"),
("80","80","12066043240662904529","deep","167"),
("81","81","12069466952462548982","deep","167"),
("82","82","12073129049335987136","deep","167"),
("83","83","12094805409725649486","deep","167"),
("84","84","12108977022776847404","deep","167"),
("85","85","12127229671366865301","deep","167"),
("86","86","12130196961843225915","deep","167"),
("87","87","12130653383166509754","deep","167"),
("88","88","12132631576817416830","deep","167"),
("89","89","12160937324556877948","deep","167"),
("90","90","12161393745880161787","deep","167"),
("91","91","12168479554553244394","deep","167"),
("92","92","12175565358931359705","deep","167"),
("93","93","12194807104346831140","deep","167"),
("94","94","12196785297997738216","deep","167"),
("95","95","12199877236711104657","deep","167"),
("96","96","12200866333536558195","deep","167"),
("97","97","12207000523747121982","deep","167"),
("98","98","12208978717398029058","deep","167"),
("99","99","12214380622848580587","deep","167"),
("100","100","12220477334696209656","deep","167"),
("101","101","12221466431521663194","deep","167"),
("102","102","12223112852086292258","deep","167"),
("103","103","12228220462813500493","deep","167"),
("104","104","12231644174613144946","deep","167"),
("105","105","12240670694279232615","deep","167"),
("106","106","12247793981315249940","deep","167"),
("107","107","12252864113679523457","deep","167"),
("108","108","12256287825479167910","deep","167"),
("109","109","12259949922352606064","deep","167"),
("110","110","12281626282742268414","deep","167"),
("111","111","12295797895793466332","deep","167"),
("112","112","12299221607593110785","deep","167"),
("113","113","12314050544383484229","deep","167"),
("114","114","12317017834859844843","deep","167"),
("115","115","12317474256183128682","deep","167"),
("116","116","12319452449834035758","deep","167"),
("117","117","12337047774684878129","deep","167"),
("118","118","12347758197573496876","deep","167"),
("119","119","12348214618896780715","deep","167"),
("120","120","12355300423274896026","deep","167"),
("121","121","12362386231947978633","deep","167"),
("122","122","12368482943795607702","deep","167"),
("123","123","12381627977363450068","deep","167"),
("124","124","12381959750449728080","deep","167"),
("125","125","12383606171014357144","deep","167"),
("126","126","12387687206553177123","deep","167"),
("127","127","12390654497029537737","deep","167"),
("128","128","12393821396763740910","deep","167"),
("129","129","12395799590414647986","deep","167"),
("130","130","12401201495865199515","deep","167"),
("131","131","12406309110887375046","deep","167"),
("132","132","12407298207712828584","deep","167"),
("133","133","12408287304538282122","deep","167"),
("134","134","12409933725102911186","deep","167"),
("135","135","12415041335830119421","deep","167"),
("136","136","12418465047629763874","deep","167"),
("137","137","12434614854331868868","deep","167"),
("138","138","12439684986696142385","deep","167"),
("139","139","12443108698495786838","deep","167"),
("140","140","12446770795369224992","deep","167"),
("141","141","12468447155758887342","deep","167"),
("142","142","12474875640692794423","deep","167"),
("143","143","12477967575111193568","deep","167"),
("144","144","12482618768810085260","deep","167"),
("145","145","12486042480609729713","deep","167"),
("146","146","12500871417400103157","deep","167"),
("147","147","12504295129199747610","deep","167"),
("148","148","12506273322850654686","deep","167"),
("149","149","12522879550876043519","deep","167"),
("150","150","12523868647701497057","deep","167"),
("151","151","12529965359549126126","deep","167"),
("152","152","12534579070590115804","deep","167"),
("153","153","12535035491913399643","deep","167"),
("154","154","12542121296291514954","deep","167"),
("155","155","12549207104964597561","deep","167"),
("156","156","12555303816812226630","deep","167"),
("157","157","12558271102993619948","deep","167"),
("158","158","12568448850380068996","deep","167"),
("159","159","12568780623466347008","deep","167"),
("160","160","12570427044030976072","deep","167"),
("161","161","12574508079569796051","deep","167"),
("162","162","12578958370852796056","deep","167"),
("163","163","12580642269780359838","deep","167"),
("164","164","12588022368881818443","deep","167"),
("165","165","12593129983903993974","deep","167"),
("166","166","12594119080729447512","deep","167"),
("167","167","12596754593824562818","deep","167"),
("168","168","12601862208846738349","deep","167"),
("169","169","12605285920646382802","deep","167"),
("170","170","12629929571512405766","deep","167"),
("171","171","12661696509414446055","deep","167"),
("172","172","12664788448127812496","deep","167"),
("173","173","12669439641826704188","deep","167"),
("174","174","12672863353626348641","deep","167"),
("175","175","12673852450451802179","deep","167"),
("176","176","12685056773026639483","deep","167"),
("177","177","12687692290416722085","deep","167"),
("178","178","12693094195867273614","deep","167"),
("179","179","12709700423892662447","deep","167"),
("180","180","12710689520718115985","deep","167"),
("181","181","12716786232565745054","deep","167"),
("182","182","12721399939311767436","deep","167"),
("183","183","12721856364930018571","deep","167"),
("184","184","12728942169308133882","deep","167"),
("185","185","12736027977981216489","deep","167"),
("186","186","12742124685533878262","deep","167"),
("187","187","12744102879184785338","deep","167"),
("188","188","12745091976010238876","deep","167"),
("189","189","12755269723396687924","deep","167"),
("190","190","12755601496482965936","deep","167"),
("191","191","12757247917047595000","deep","167"),
("192","192","12761328952586414979","deep","167"),
("193","193","12765779239574447688","deep","167"),
("194","194","12767463142796978766","deep","167"),
("195","195","12776489662463066435","deep","167"),
("196","196","12779950856920612902","deep","167"),
("197","197","12783575466841181746","deep","167"),
("198","198","12785058467647821137","deep","167"),
("199","199","12788683081863357277","deep","167"),
("200","200","12792106793663001730","deep","167"),
("201","201","12805251827230844096","deep","167"),
("202","202","12811680312164751177","deep","167"),
("203","203","12816750444529024694","deep","167"),
("204","204","12841099804966671660","deep","167"),
("205","205","12851609321144431424","deep","167"),
("206","206","12856260514843323116","deep","167"),
("207","207","12859684226642967569","deep","167"),
("208","208","12871877646043258411","deep","167"),
("209","209","12878925972058439004","deep","167"),
("210","210","12879915068883892542","deep","167"),
("211","211","12891451164545007858","deep","167"),
("212","212","12896521296909281375","deep","167"),
("213","213","12897510393734734913","deep","167"),
("214","214","12898536973218090465","deep","167"),
("215","215","12903607105582363982","deep","167"),
("216","216","12905253521852025750","deep","167"),
("217","217","12908677233651670203","deep","167"),
("218","218","12915763042324752810","deep","167"),
("219","219","12919425139198190964","deep","167"),
("220","220","12922848850997835417","deep","167"),
("221","221","12924827044648742493","deep","167"),
("222","222","12928945558550497190","deep","167"),
("223","223","12930923752201404266","deep","167"),
("224","224","12931912849026857804","deep","167"),
("225","225","12942090596413306852","deep","167"),
("226","226","12942422369499584864","deep","167"),
("227","227","12944068790064213928","deep","167"),
("228","228","12948149821308066611","deep","167"),
("229","229","12952600112591066616","deep","167"),
("230","230","12954284015813597694","deep","167"),
("231","231","12966771729937231830","deep","167"),
("232","232","12971184534267362525","deep","167"),
("233","233","12971879340664440065","deep","167"),
("234","234","12975503954879976205","deep","167"),
("235","235","12984367054788074201","deep","167"),
("236","236","12992072700247463024","deep","167"),
("237","237","12998501185181370105","deep","167"),
("238","238","13003571317545643622","deep","167"),
("239","239","13006244317593628238","deep","167"),
("240","240","13015107413206758938","deep","167"),
("241","241","13018199351920125379","deep","167"),
("242","242","13027920677983290588","deep","167"),
("243","243","13029279026257956856","deep","167"),
("244","244","13038430194161050352","deep","167"),
("245","245","13046505099659586497","deep","167"),
("246","246","13047494196485040035","deep","167"),
("247","247","13058698519059877339","deep","167"),
("248","248","13065746845075057932","deep","167"),
("249","249","13066735941900511470","deep","167"),
("250","250","13070197136358057937","deep","167"),
("251","251","13078272037561626786","deep","167"),
("252","252","13083342169925900303","deep","167"),
("253","253","13084368749409255855","deep","167"),
("254","254","13085357846234709393","deep","167"),
("255","255","13090427978598982910","deep","167"),
("256","256","13092074394868644678","deep","167"),
("257","257","13094840782929113605","deep","167"),
("258","258","13102583915341371738","deep","167"),
("259","259","13105588688475634366","deep","167"),
("260","260","13106246012214809892","deep","167"),
("261","261","13109669724014454345","deep","167"),
("262","262","13111647913370394125","deep","167"),
("263","263","13115109107827940592","deep","167"),
("264","264","13115766431567116118","deep","167"),
("265","265","13117744625218023194","deep","167"),
("266","266","13118733722043476732","deep","167"),
("267","267","13128911469429925780","deep","167"),
("268","268","13129243242516203792","deep","167"),
("269","269","13130889658785865560","deep","167"),
("270","270","13138431888782232006","deep","167"),
("271","271","13139420985607685544","deep","167"),
("272","272","13141104888830216622","deep","167"),
("273","273","13153592598658883462","deep","167"),
("274","274","13158005407283981453","deep","167"),
("275","275","13158700213681058993","deep","167"),
("276","276","13163113022306156984","deep","167"),
("277","277","13171187927804693129","deep","167"),
("278","278","13171845247248901359","deep","167"),
("279","279","13178893573264081952","deep","167"),
("280","280","13185322058197989033","deep","167"),
("281","281","13190392190562262550","deep","167"),
("282","282","13192407866871071640","deep","167"),
("283","283","13193065186315279870","deep","167"),
("284","284","13201928286223377866","deep","167"),
("285","285","13205020224936744307","deep","167"),
("286","286","13214741546704942220","deep","167"),
("287","287","13215110802449122246","deep","167"),
("288","288","13216099899274575784","deep","167"),
("289","289","13225251067177669280","deep","167"),
("290","290","13233325972676205425","deep","167"),
("291","291","13234315069501658963","deep","167"),
("292","292","13252567718091676860","deep","167"),
("293","293","13253556814917130398","deep","167"),
("294","294","13257018005079709569","deep","167"),
("295","295","13259653522469792171","deep","167"),
("296","296","13265092910578245714","deep","167"),
("297","297","13265750234317421240","deep","167"),
("298","298","13271189622425874783","deep","167"),
("299","299","13277248847320634542","deep","167"),
("300","300","13278895267885263606","deep","167"),
("301","301","13279683462294825457","deep","167"),
("302","302","13281661655945732533","deep","167"),
("303","303","13292409561492253294","deep","167"),
("304","304","13293066880936461524","deep","167"),
("305","305","13298468786387013053","deep","167"),
("306","306","13301929980844559520","deep","167"),
("307","307","13303576401409188584","deep","167"),
("308","308","13304565498234642122","deep","167"),
("309","309","13305554595060095660","deep","167"),
("310","310","13309673113256817653","deep","167"),
("311","311","13315732338151577412","deep","167"),
("312","312","13316064115532822720","deep","167"),
("313","313","13319193532609123879","deep","167"),
("314","314","13325252761798850934","deep","167"),
("315","315","13326241858624304472","deep","167"),
("316","316","13327925761846835550","deep","167"),
("317","317","13340413471675502390","deep","167"),
("318","318","13344826280300600381","deep","167"),
("319","319","13345521086697677921","deep","167"),
("320","320","13349933895322775912","deep","167"),
("321","321","13358008796526344761","deep","167"),
("322","322","13358666120265520287","deep","167"),
("323","323","13372142931214607961","deep","167"),
("324","324","13375234869927974402","deep","167"),
("325","325","13377213063578881478","deep","167"),
("326","326","13379228735592723272","deep","167"),
("327","327","13383309771131543251","deep","167"),
("328","328","13388749159239996794","deep","167"),
("329","329","13391841097953363235","deep","167"),
("330","330","13400942578640287636","deep","167"),
("331","331","13401562419721561148","deep","167"),
("332","332","13401931675465741174","deep","167"),
("333","333","13402920772291194712","deep","167"),
("334","334","13412071940194288208","deep","167"),
("335","335","13421135938223310595","deep","167"),
("336","336","13422162517706666147","deep","167"),
("337","337","13432302782435213181","deep","167"),
("338","338","13439388591108295788","deep","167"),
("339","339","13443838878096328497","deep","167"),
("340","340","13446474395486411099","deep","167"),
("341","341","13451913783594864642","deep","167"),
("342","342","13452571107334040168","deep","167"),
("343","343","13458010495442493711","deep","167"),
("344","344","13464069720337253470","deep","167"),
("345","345","13466504335311444385","deep","167"),
("346","346","13468482528962351461","deep","167"),
("347","347","13477909560302173376","deep","167"),
("348","348","13479230430213904926","deep","167"),
("349","349","13485289659403631981","deep","167"),
("350","350","13488750853861178448","deep","167"),
("351","351","13490397274425807512","deep","167"),
("352","352","13491386371251261050","deep","167"),
("353","353","13492375468076714588","deep","167"),
("354","354","13496493986273436581","deep","167"),
("355","355","13502553211168196340","deep","167"),
("356","356","13502884984254474352","deep","167"),
("357","357","13507992599276649883","deep","167"),
("358","358","13512073634815469862","deep","167"),
("359","359","13513062731640923400","deep","167"),
("360","360","13531647153317219309","deep","167"),
("361","361","13532341959714296849","deep","167"),
("362","362","13536754768339394840","deep","167"),
("363","363","13551915478216046296","deep","167"),
("364","364","13552904575041499834","deep","167"),
("365","365","13558963804231226889","deep","167"),
("366","366","13562055742944593330","deep","167"),
("367","367","13564033932300533110","deep","167"),
("368","368","13566049608609342200","deep","167"),
("369","369","13570130644148162179","deep","167"),
("370","370","13575570032256615722","deep","167"),
("371","371","13578661970969982163","deep","167"),
("372","372","13582324063548453021","deep","167"),
("373","373","13587763451656906564","deep","167"),
("374","374","13588383292738180076","deep","167"),
("375","375","13588752548482360102","deep","167"),
("376","376","13589741645307813640","deep","167"),
("377","377","13606967714414475985","deep","167"),
("378","378","13607956811239929523","deep","167"),
("379","379","13608983390723285075","deep","167"),
("380","380","13616488138061749507","deep","167"),
("381","381","13619123655451832109","deep","167"),
("382","382","13626209459829947420","deep","167"),
("383","383","13630659751112947425","deep","167"),
("384","384","13633295268503030027","deep","167"),
("385","385","13638734656611483570","deep","167"),
("386","386","13639391980350659096","deep","167"),
("387","387","13644831364164145343","deep","167"),
("388","388","13652868787004779474","deep","167"),
("389","389","13655303401978970389","deep","167"),
("390","390","13664730433318792304","deep","167"),
("391","391","13666051303230523854","deep","167"),
("392","392","13675571726877797376","deep","167"),
("393","393","13677218147442426440","deep","167"),
("394","394","13678207244267879978","deep","167"),
("395","395","13683314854995088213","deep","167"),
("396","396","13694813472293268811","deep","167"),
("397","397","13698894507832088790","deep","167"),
("398","398","13699883604657542328","deep","167"),
("399","399","13718468026333838237","deep","167"),
("400","400","13719162832730915777","deep","167"),
("401","401","13723575641356013768","deep","167"),
("402","402","13737747254407211686","deep","167"),
("403","403","13738736351232665224","deep","167"),
("404","404","13739725448058118762","deep","167"),
("405","405","13745784677247845817","deep","167"),
("406","406","13748876611666244962","deep","167"),
("407","407","13752870481625961128","deep","167"),
("408","408","13756951517164781107","deep","167"),
("409","409","13762390905273234650","deep","167"),
("410","410","13765482843986601091","deep","167"),
("411","411","13765520326644503105","deep","167"),
("412","412","13769144936565071949","deep","167"),
("413","413","13774584324673525492","deep","167"),
("414","414","13793788587431094913","deep","167"),
("415","415","13794777684256548451","deep","167"),
("416","416","13795804263739904003","deep","167"),
("417","417","13800874396104177520","deep","167"),
("418","418","13803309011078368435","deep","167"),
("419","419","13817480624129566353","deep","167"),
("420","420","13825555529628102498","deep","167"),
("421","421","13826212853367278024","deep","167"),
("422","422","13831652237180764271","deep","167"),
("423","423","13839689660021398402","deep","167"),
("424","424","13842124274995589317","deep","167"),
("425","425","13849867407407847450","deep","167"),
("426","426","13862392599894416304","deep","167"),
("427","427","13864039020459045368","deep","167"),
("428","428","13866511118091138297","deep","167"),
("429","429","13869146631186253603","deep","167"),
("430","430","13870135728011707141","deep","167"),
("431","431","13873559439811351594","deep","167"),
("432","432","13881634345309887739","deep","167"),
("433","433","13886704477674161256","deep","167"),
("434","434","13905288899350457165","deep","167"),
("435","435","13905983705747534705","deep","167"),
("436","436","13910396514372632696","deep","167"),
("437","437","13924568127423830614","deep","167"),
("438","438","13925557224249284152","deep","167"),
("439","439","13926546321074737690","deep","167"),
("440","440","13932605545969497449","deep","167"),
("441","441","13935697484682863890","deep","167"),
("442","442","13939691354642580056","deep","167"),
("443","443","13949211778289853578","deep","167"),
("444","444","13952303717003220019","deep","167"),
("445","445","13952341199661122033","deep","167"),
("446","446","13955965809581690877","deep","167"),
("447","447","13980609460447713841","deep","167"),
("448","448","13982625136756522931","deep","167"),
("449","449","13987695269120796448","deep","167"),
("450","450","13990129884094987363","deep","167"),
("451","451","14012376402644721426","deep","167"),
("452","452","14018473110197383199","deep","167"),
("453","453","14028945148012208245","deep","167"),
("454","454","14043116761063406163","deep","167"),
("455","455","14049213472911035232","deep","167"),
("456","456","14053331991107757225","deep","167"),
("457","457","14055967504202872531","deep","167"),
("458","458","14060380312827970522","deep","167"),
("459","459","14068455218326506667","deep","167"),
("460","460","14073525350690780184","deep","167"),
("461","461","14092109772367076093","deep","167"),
("462","462","14092804578764153633","deep","167"),
("463","463","14111389000440449542","deep","167"),
("464","464","14112378097265903080","deep","167"),
("465","465","14113367194091356618","deep","167"),
("466","466","14136032651306472506","deep","167"),
("467","467","14139124590019838947","deep","167"),
("468","468","14139162068382773665","deep","167"),
("469","469","14142786682598309805","deep","167"),
("470","470","14143118455684587817","deep","167"),
("471","471","14169446009773141859","deep","167"),
("472","472","14176950757111606291","deep","167"),
("473","473","14199197271366373058","deep","167"),
("474","474","14205293983214002127","deep","167"),
("475","475","14215766021028827173","deep","167"),
("476","476","14229937634080025091","deep","167"),
("477","477","14234056152276747084","deep","167"),
("478","478","14236034345927654160","deep","167"),
("479","479","14240152859829408857","deep","167"),
("480","480","14242788377219491459","deep","167"),
("481","481","14247201185844589450","deep","167"),
("482","482","14255276091343125595","deep","167"),
("483","483","14278930645383695021","deep","167"),
("484","484","14298209873457068470","deep","167"),
("485","485","14299198970282522008","deep","167"),
("486","486","14300188062813008250","deep","167"),
("487","487","14306703713326019144","deep","167"),
("488","488","14322853520028124138","deep","167"),
("489","489","14325945458741490579","deep","167"),
("490","490","14325982941399392593","deep","167"),
("491","491","14329939328701206745","deep","167"),
("492","492","14349181074116678180","deep","167"),
("493","493","14356266882789760787","deep","167"),
("494","494","14363771630128225219","deep","167"),
("495","495","14386018144382991986","deep","167"),
("496","496","14392114856230621055","deep","167"),
("497","497","14402586894045446101","deep","167"),
("498","498","14416758507096644019","deep","167"),
("499","499","14420877025293366012","deep","167"),
("500","500","14422855218944273088","deep","167"),
("501","501","14423844311474759330","deep","167"),
("502","502","14426973732846027785","deep","167"),
("503","503","14434022058861208378","deep","167"),
("504","504","14442096964359744523","deep","167"),
("505","505","14465751518400313949","deep","167"),
("506","506","14475966744149697715","deep","167"),
("507","507","14485030742178720102","deep","167"),
("508","508","14486019839004173640","deep","167"),
("509","509","14487008935829627178","deep","167"),
("510","510","14493524586342638072","deep","167"),
("511","511","14509674393044743066","deep","167"),
("512","512","14512766331758109507","deep","167"),
("513","513","14512803814416011521","deep","167"),
("514","514","14516760201717825673","deep","167"),
("515","515","14527927041634760963","deep","167"),
("516","516","14550592498849876851","deep","167"),
("517","517","14572839017399610914","deep","167"),
("518","518","14578935729247239983","deep","167"),
("519","519","14589407767062065029","deep","167"),
("520","520","14603579380113262947","deep","167"),
("521","521","14607697898309984940","deep","167"),
("522","522","14610665184491378258","deep","167"),
("523","523","14613794605862646713","deep","167"),
("524","524","14620842931877827306","deep","167"),
("525","525","14662787617166316643","deep","167"),
("526","526","14671851615195339030","deep","167"),
("527","527","14672840712020792568","deep","167"),
("528","528","14680345459359257000","deep","167"),
("529","529","14696495266061361994","deep","167"),
("530","530","14699587204774728435","deep","167"),
("531","531","14699624687432630449","deep","167"),
("532","532","14703581074734444601","deep","167"),
("533","533","14737413371866495779","deep","167"),
("534","534","14773261349602323343","deep","167"),
("535","535","14794518767031636572","deep","167"),
("536","536","14800615478879265641","deep","167"),
("537","537","14802593672530172717","deep","167"),
("538","538","14849608490182935571","deep","167"),
("539","539","14858672488211957958","deep","167"),
("540","540","14867166332375875928","deep","167"),
("541","541","14960082218323974975","deep","167"),
("542","542","14981339640048255500","deep","167"),
("543","543","14987436351895884569","deep","167"),
("544","544","14989414545546791645","deep","167"),
("545","545","15036429363199554499","deep","167"),
("546","546","15053987205392494856","deep","167"),
("547","547","15146903091340593903","deep","167"),
("548","548","15168160513064874428","deep","167"),
("549","549","15174257224912503497","deep","167"),
("550","550","15223250231921206131","deep","167"),
("551","551","15361078097929122425","deep","167"),
("552","552","2041869844715607579","deep","167"),
("553","553","2120614121907476004","deep","167"),
("554","554","2127699926285591315","deep","167"),
("555","555","2206444199182492444","deep","167"),
("556","556","2227701620906772969","deep","167"),
("557","557","2265527787998540313","deep","167"),
("558","558","2306445893803674098","deep","167"),
("559","559","2344272065190408738","deep","167"),
("560","560","2351357869568524049","deep","167"),
("561","561","2396269845333374000","deep","167"),
("562","562","2399361784046740441","deep","167"),
("563","563","2430102146760392474","deep","167"),
("564","564","2451359564189705703","deep","167"),
("565","565","2482099926903357736","deep","167"),
("566","566","2567930008473341472","deep","167"),
("567","567","2575015812851456783","deep","167"),
("568","568","2613536786340301667","deep","167"),
("569","569","2619927788616306734","deep","167"),
("570","570","2653760090043325208","deep","167"),
("571","571","2675017507472638437","deep","167"),
("572","572","2705757870186290470","deep","167"),
("573","573","2791587951756274206","deep","167"),
("574","574","2806454371204549664","deep","167"),
("575","575","2837194729623234401","deep","167"),
("576","576","2843585731899239468","deep","167"),
("577","577","2877418033326257942","deep","167"),
("578","578","2882106705388084352","deep","167"),
("579","579","2884503837704373253","deep","167"),
("580","580","2898675455050538467","deep","167"),
("581","581","2929415813469223204","deep","167"),
("582","582","3008160086366124333","deep","167"),
("583","583","3030112314487482398","deep","167"),
("584","584","3060852677201134431","deep","167"),
("585","585","3067243675182172202","deep","167"),
("586","586","3092287842016896708","deep","167"),
("587","587","3099373646395012019","deep","167"),
("588","588","3105764648671017086","deep","167"),
("589","589","3108161780987305987","deep","167"),
("590","590","3122333398333471201","deep","167"),
("591","591","3137199817781746659","deep","167"),
("592","592","3145987952374040627","deep","167"),
("593","593","3153073756752155938","deep","167"),
("594","594","3160854371822316085","deep","167"),
("595","595","3192289536638078362","deep","167"),
("596","596","3231818029649057067","deep","167"),
("597","597","3253770257770415132","deep","167"),
("598","598","3284510620484067165","deep","167"),
("599","599","3290901618465104936","deep","167"),
("600","600","3315945785299829442","deep","167"),
("601","601","3323031593972912049","deep","167"),
("602","602","3329422591953949820","deep","167"),
("603","603","3331819728565206017","deep","167"),
("604","604","3345991341616403935","deep","167"),
("605","605","3360857761064679393","deep","167"),
("606","606","3369645895656973361","deep","167"),
("607","607","3376731700035088672","deep","167"),
("608","608","3384512315105248819","deep","167"),
("609","609","3415947479921011096","deep","167"),
("610","610","3446687842634663129","deep","167"),
("611","611","3455475977226957097","deep","167"),
("612","612","3508168563766999899","deep","167"),
("613","613","3514559566043004966","deep","167"),
("614","614","3539603728582762176","deep","167"),
("615","615","3546689537255844783","deep","167"),
("616","616","3553080539531849850","deep","167"),
("617","617","3555477671848138751","deep","167"),
("618","618","3584515704347612127","deep","167"),
("619","619","3593303838939906095","deep","167"),
("620","620","3600389643318021406","deep","167"),
("621","621","3608170258388181553","deep","167"),
("622","622","3617653199377553061","deep","167"),
("623","623","3639605423203943830","deep","167"),
("624","624","3670345785917595863","deep","167"),
("625","625","3679133920509889831","deep","167"),
("626","626","3700391342234170356","deep","167"),
("627","627","3738217509325937700","deep","167"),
("628","628","3763261671865694910","deep","167"),
("629","629","3770347480538777517","deep","167"),
("630","630","3776738482814782584","deep","167"),
("631","631","3779135615131071485","deep","167"),
("632","632","3808173647630544861","deep","167"),
("633","633","3816961782222838829","deep","167"),
("634","634","3824047590895921436","deep","167"),
("635","635","3831828201671114287","deep","167"),
("636","636","3863263366486876564","deep","167"),
("637","637","3894003729200528597","deep","167"),
("638","638","3902791863792822565","deep","167"),
("639","639","3924049285517103090","deep","167"),
("640","640","3961875452608870434","deep","167"),
("641","641","3986919615148627644","deep","167"),
("642","642","3994005423821710251","deep","167"),
("643","643","4000396426097715318","deep","167"),
("644","644","4002793558414004219","deep","167"),
("645","645","4031831590913477595","deep","167"),
("646","646","4040619725505771563","deep","167"),
("647","647","4047705534178854170","deep","167"),
("648","648","4055486144954047021","deep","167"),
("649","649","4086226507667699054","deep","167"),
("650","650","4086921309769809298","deep","167"),
("651","651","4117661672483461331","deep","167"),
("652","652","4126449807075755299","deep","167"),
("653","653","4147707228800035824","deep","167"),
("654","654","4210577558431560378","deep","167"),
("655","655","4217663367104642985","deep","167"),
("656","656","4224054369380648052","deep","167"),
("657","657","4226451501696936953","deep","167"),
("658","658","4255489534196410329","deep","167"),
("659","659","4279144088236979755","deep","167"),
("660","660","4309884450950631788","deep","167"),
("661","661","4310579253052742032","deep","167"),
("662","662","4341319615766394065","deep","167"),
("663","663","4434235506009460408","deep","167"),
("664","664","4441321310387575719","deep","167"),
("665","665","4479147477479343063","deep","167"),
("666","666","4502802031519912489","deep","167"),
("667","667","4533542394233564522","deep","167"),
("668","668","4534237200630642062","deep","167"),
("669","669","4564977559049326799","deep","167"),
("670","670","4572063367722409406","deep","167"),
("671","671","4657893449292393142","deep","167"),
("672","672","4664979253670508453","deep","167"),
("673","673","4726459974802845223","deep","167"),
("674","674","4788635502332259533","deep","167"),
("675","675","4795721311005342140","deep","167"),
("676","676","4881551392575325876","deep","167"),
("677","677","4888637196953441187","deep","167"),
("678","678","5019379254288274874","deep","167"),
("679","679","5105209335858258610","deep","167"),
("680","680","5112295140236373921","deep","167"),
("681","681","9853034313990733137","deep","167"),
("682","682","9945950204233799480","deep","167"),
("0","0","10060124611433631305","deep","168"),
("1","1","10153040497381730352","deep","168"),
("2","2","10238870578951714088","deep","168"),
("3","3","10331786469194780431","deep","168"),
("4","4","10424702355142879478","deep","168"),
("5","5","10517618245385945821","deep","168"),
("6","6","10610534131334044868","deep","168"),
("7","7","10616351853459320591","deep","168"),
("8","8","10703450021577111211","deep","168"),
("9","9","10796365907525210258","deep","168"),
("10","10","10803172726475939519","deep","168"),
("11","11","10989993599492558447","deep","168"),
("12","12","11156583630268252402","deep","168"),
("13","13","11163669434646367713","deep","168"),
("14","14","11176814472509177375","deep","168"),
("15","15","11311675043745765759","deep","168"),
("16","16","11363635345525796303","deep","168"),
("17","17","11387327382224267743","deep","168"),
("18","18","11461658846496070881","deep","168"),
("19","19","11498495916762384687","deep","168"),
("20","20","11550456218542415231","deep","168"),
("21","21","11574148250945919375","deep","168"),
("22","22","11635334681649880147","deep","168"),
("23","23","11648479719512689809","deep","168"),
("24","24","11685316789779003615","deep","168"),
("25","25","11714078958841748572","deep","168"),
("26","26","11737277091559034159","deep","168"),
("27","27","11753883319584422992","deep","168"),
("28","28","11760969123962538303","deep","168"),
("29","29","11822155554666499075","deep","168"),
("30","30","11835300592529308737","deep","168"),
("31","31","11858992629227780177","deep","168"),
("32","32","11873164242278978095","deep","168"),
("33","33","11924097960280685791","deep","168"),
("34","34","11940704192601041920","deep","168"),
("35","35","11947789996979157231","deep","168"),
("36","36","11972139357416804197","deep","168"),
("37","37","11997809587766182713","deep","168"),
("38","38","12008976427683118003","deep","168"),
("39","39","12022121465545927665","deep","168"),
("40","40","12045813497949431809","deep","168"),
("41","41","12059985115295597023","deep","168"),
("42","42","12082650572510712911","deep","168"),
("43","43","12110918833297304719","deep","168"),
("44","44","12127525065617660848","deep","168"),
("45","45","12134610869995776159","deep","168"),
("46","46","12158960230433423125","deep","168"),
("47","47","12184630460782801641","deep","168"),
("48","48","12189738071510009876","deep","168"),
("49","49","12195797300699736931","deep","168"),
("50","50","12199221012499381384","deep","168"),
("51","51","12208942334267579297","deep","168"),
("52","52","12227564242896744516","deep","168"),
("53","53","12232634370966050737","deep","168"),
("54","54","12246805988312215951","deep","168"),
("55","55","12269471445527331839","deep","168"),
("56","56","12281959155355998679","deep","168"),
("57","57","12306308515793645645","deep","168"),
("58","58","12314345934339312480","deep","168"),
("59","59","12321431743012395087","deep","168"),
("60","60","12325550261209117080","deep","168"),
("61","61","12330657876231292611","deep","168"),
("62","62","12345781103450042053","deep","168"),
("63","63","12358963619675786433","deep","168"),
("64","64","12371451333799420569","deep","168"),
("65","65","12376558944526628804","deep","168"),
("66","66","12382618173716355859","deep","168"),
("67","67","12386041885516000312","deep","168"),
("68","68","12395763207284198225","deep","168"),
("69","69","12419455243982669665","deep","168"),
("70","70","12427492666823303796","deep","168"),
("71","71","12433626857033867583","deep","168"),
("72","72","12447228316219961084","deep","168"),
("73","73","12456292314248983471","deep","168"),
("74","74","12462351543438710526","deep","168"),
("75","75","12468780028372617607","deep","168"),
("76","76","12493129388810264573","deep","168"),
("77","77","12501166807355931408","deep","168"),
("78","78","12503839807403916024","deep","168"),
("79","79","12508252616029014015","deep","168"),
("80","80","12512371134225736008","deep","168"),
("81","81","12517478744952944243","deep","168"),
("82","82","12532601976466660981","deep","168"),
("83","83","12545784492692405361","deep","168"),
("84","84","12563379817543247732","deep","168"),
("85","85","12569439046732974787","deep","168"),
("86","86","12572862758532619240","deep","168"),
("87","87","12574840952183526316","deep","168"),
("88","88","12582584080300817153","deep","168"),
("89","89","12606276116999288593","deep","168"),
("90","90","12614313539839922724","deep","168"),
("91","91","12620447730050486511","deep","168"),
("92","92","12621399344218038035","deep","168"),
("93","93","12629273347300682493","deep","168"),
("94","94","12634049189236580012","deep","168"),
("95","95","12637016479712940626","deep","168"),
("96","96","12643113187265602399","deep","168"),
("97","97","12649172416455329454","deep","168"),
("98","98","12655600901389236535","deep","168"),
("99","99","12668783417614980915","deep","168"),
("100","100","12674548356376331972","deep","168"),
("101","101","12679950261826883501","deep","168"),
("102","102","12684363066157014196","deep","168"),
("103","103","12687987680372550336","deep","168"),
("104","104","12695073489045632943","deep","168"),
("105","105","12699192007242354936","deep","168"),
("106","106","12704299617969563171","deep","168"),
("107","107","12708712426594661162","deep","168"),
("108","108","12719422849483279909","deep","168"),
("109","109","12731948041969848763","deep","168"),
("110","110","12732605365709024289","deep","168"),
("111","111","12750200690559866660","deep","168"),
("112","112","12751189787385320198","deep","168"),
("113","113","12756259919749593715","deep","168"),
("114","114","12759683631549238168","deep","168"),
("115","115","12761661825200145244","deep","168"),
("116","116","12769404953317436081","deep","168"),
("117","117","12793096990015907521","deep","168"),
("118","118","12797215508212629514","deep","168"),
("119","119","12807268603067105439","deep","168"),
("120","120","12816094220317301421","deep","168"),
("121","121","12820870062253198940","deep","168"),
("122","122","12823837352729559554","deep","168"),
("123","123","12829934060282221327","deep","168"),
("124","124","12835993289471948382","deep","168"),
("125","125","12842421774405855463","deep","168"),
("126","126","12845057287500970769","deep","168"),
("127","127","12855604290631599843","deep","168"),
("128","128","12861369229392950900","deep","168"),
("129","129","12866771130548535133","deep","168"),
("130","130","12871183939173633124","deep","168"),
("131","131","12872830359738262188","deep","168"),
("132","132","12874808553389169264","deep","168"),
("133","133","12886012875964006568","deep","168"),
("134","134","12891120490986182099","deep","168"),
("135","135","12895076878287996251","deep","168"),
("136","136","12895533299611280090","deep","168"),
("137","137","12906243718204931541","deep","168"),
("138","138","12908021013734914226","deep","168"),
("139","139","12909667430004575994","deep","168"),
("140","140","12918768914986467691","deep","168"),
("141","141","12922192626786112144","deep","168"),
("142","142","12937021563576485588","deep","168"),
("143","143","12938010660401939126","deep","168"),
("144","144","12943080792766212643","deep","168"),
("145","145","12946504504565857096","deep","168"),
("146","146","12948482698216764172","deep","168"),
("147","147","12964757153155874993","deep","168"),
("148","148","12979917863032526449","deep","168"),
("149","149","12983341574832170902","deep","168"),
("150","150","12992405572861193289","deep","168"),
("151","151","12994089476083724367","deep","168"),
("152","152","13002915093333920349","deep","168"),
("153","153","13007690935269817868","deep","168"),
("154","154","13008717510458206124","deep","168"),
("155","155","13010658221451211186","deep","168"),
("156","156","13016754933298840255","deep","168"),
("157","157","13029242647422474391","deep","168"),
("158","158","13053592003565154061","deep","168"),
("159","159","13058004812190252052","deep","168"),
("160","160","13061629426405788192","deep","168"),
("161","161","13072833748980625496","deep","168"),
("162","162","13077941364002801027","deep","168"),
("163","163","13081897751304615179","deep","168"),
("164","164","13082354172627899018","deep","168"),
("165","165","13093064591221550469","deep","168"),
("166","166","13096488303021194922","deep","168"),
("167","167","13109013499802731072","deep","168"),
("168","168","13124831533418558054","deep","168"),
("169","169","13129901665782831571","deep","168"),
("170","170","13133325377582476024","deep","168"),
("171","171","13135303566938415804","deep","168"),
("172","172","13144073278834029489","deep","168"),
("173","173","13151578026172493921","deep","168"),
("174","174","13152898896084225471","deep","168"),
("175","175","13166738736049145377","deep","168"),
("176","176","13170162447848789830","deep","168"),
("177","177","13170857254245867370","deep","168"),
("178","178","13189735966350539277","deep","168"),
("179","179","13193854484547261270","deep","168"),
("180","180","13194511803991469500","deep","168"),
("181","181","13197479094467830114","deep","168"),
("182","182","13203575806315459183","deep","168"),
("183","183","13216063516144126023","deep","168"),
("184","184","13217747419366657101","deep","168"),
("185","185","13244825685206870980","deep","168"),
("186","186","13264762237019419955","deep","168"),
("187","187","13268718624321234107","deep","168"),
("188","188","13269175045644517946","deep","168"),
("189","189","13273826235048442342","deep","168"),
("190","190","13283309176037813850","deep","168"),
("191","191","13295834372819350000","deep","168"),
("192","192","13307658536475460816","deep","168"),
("193","193","13311652406435176982","deep","168"),
("194","194","13316722534504483203","deep","168"),
("195","195","13320146246304127656","deep","168"),
("196","196","13330894151850648417","deep","168"),
("197","197","13339719764805877103","deep","168"),
("198","198","13353559609065764305","deep","168"),
("199","199","13356983320865408758","deep","168"),
("200","200","13366047318894431145","deep","168"),
("201","201","13380675353268912902","deep","168"),
("202","202","13381332677008088428","deep","168"),
("203","203","13390396679332078111","deep","168"),
("204","204","13404568292383276029","deep","168"),
("205","205","13414746039769725077","deep","168"),
("206","206","13431646558223489908","deep","168"),
("207","207","13455995918661136874","deep","168"),
("208","208","13460647108065061270","deep","168"),
("209","209","13482655241541001632","deep","168"),
("210","210","13494479409492079744","deep","168"),
("211","211","13498473279451795910","deep","168"),
("212","212","13506967119320746584","deep","168"),
("213","213","13526540637822496031","deep","168"),
("214","214","13540380482082383233","deep","168"),
("215","215","13543804193882027686","deep","168"),
("216","216","13552868191911050073","deep","168"),
("217","217","13567496226285531830","deep","168"),
("218","218","13577217552348697039","deep","168"),
("219","219","13591389165399894957","deep","168"),
("220","220","13601566908491376709","deep","168"),
("221","221","13618467431240108836","deep","168"),
("222","222","13647467981081680198","deep","168"),
("223","223","13656950922071051706","deep","168"),
("224","224","13669476114557620560","deep","168"),
("225","225","13685294148173447542","deep","168"),
("226","226","13691847281344360450","deep","168"),
("227","227","13713361510839114959","deep","168"),
("228","228","13717480029035836952","deep","168"),
("229","229","13730625062603679318","deep","168"),
("230","230","13739689064927669001","deep","168"),
("231","231","13754317099302150758","deep","168"),
("232","232","13764038425365315967","deep","168"),
("233","233","13772607230550070669","deep","168"),
("234","234","13788387781507995637","deep","168"),
("235","235","13805288304256727764","deep","168"),
("236","236","13856296987574239488","deep","168"),
("237","237","13878668154360979378","deep","168"),
("238","238","13900182383855733887","deep","168"),
("239","239","13904958225791631406","deep","168"),
("240","240","13917445935620298246","deep","168"),
("241","241","13922591033300375791","deep","168"),
("242","242","13959428103566689597","deep","168"),
("243","243","13992109177273346692","deep","168"),
("244","244","14006280790324544610","deep","168"),
("245","245","14065489027377598306","deep","168"),
("246","246","14087003256872352815","deep","168"),
("247","247","14091121775069074808","deep","168"),
("248","248","14104266808636917174","deep","168"),
("249","249","14109411906316994719","deep","168"),
("250","250","14166442336166331484","deep","168"),
("251","251","14178930050289965620","deep","168"),
("252","252","14193101663341163538","deep","168"),
("253","253","14277942648085693736","deep","168"),
("254","254","14279626547013257518","deep","168"),
("255","255","14296232779333613647","deep","168"),
("256","256","14320876430199636611","deep","168"),
("257","257","14365750919011617252","deep","168"),
("258","258","14379922536357782466","deep","168"),
("259","259","14464763521102312664","deep","168"),
("260","260","14466447420029876446","deep","168"),
("261","261","14483053652350232575","deep","168"),
("262","262","14514783107594370850","deep","168"),
("263","263","14651584389823964296","deep","168"),
("264","264","14669874521071884207","deep","168"),
("265","265","14701603980610989778","deep","168"),
("266","266","14856695394088503135","deep","168"),
("267","267","15043516267105122063","deep","168"),
("268","268","15230337140121740991","deep","168"),
("269","269","2289183441566561992","deep","168"),
("270","270","2434791918349671137","deep","168"),
("271","271","2512841384849494726","deep","168"),
("272","272","3083813524372078570","deep","168"),
("273","273","3307471467655011304","deep","168"),
("274","274","3660169138058599068","deep","168"),
("275","275","3801088938484914507","deep","168"),
("276","276","3883827081341531802","deep","168"),
("277","277","4024746881767847241","deep","168"),
("278","278","4107485024624464536","deep","168"),
("279","279","4354797521947966696","deep","168"),
("280","280","4757896243441027049","deep","168"),
("281","281","4981554186723959783","deep","168"),
("0","0","10053039902288000951","deep","169"),
("1","1","10138869983857984687","deep","169"),
("2","2","10145955792531067294","deep","169"),
("3","3","10160127405582265212","deep","169"),
("4","4","10231785874101051030","deep","169"),
("5","5","10253043295825331555","deep","169"),
("6","6","10324701760049150077","deep","169"),
("7","7","10345959181773430602","deep","169"),
("8","8","10417617650292216420","deep","169"),
("9","9","10438875067721529649","deep","169"),
("10","10","10510533536240315467","deep","169"),
("11","11","10531790957964595992","deep","169"),
("12","12","10603449426483381810","deep","169"),
("13","13","10624706843912695039","deep","169"),
("14","14","10696365312431480857","deep","169"),
("15","15","10717622734155761382","deep","169"),
("16","16","10802184729177938234","deep","169"),
("17","17","10810538620103860429","deep","169"),
("18","18","10903454510346926772","deep","169"),
("19","19","10996370396295025819","deep","169"),
("20","20","11063668839552638312","deep","169"),
("21","21","11080932395612169967","deep","169"),
("22","22","11195105703284549539","deep","169"),
("23","23","11240017679049399490","deep","169"),
("24","24","11249500615743803702","deep","169"),
("25","25","11250489712569257240","deep","169"),
("26","26","11267753264333821599","deep","169"),
("27","27","11273849976181450668","deep","169"),
("28","28","11287326787130538342","deep","169"),
("29","29","11332933564997498537","deep","169"),
("30","30","11381926576301168467","deep","169"),
("31","31","11425849455240564880","deep","169"),
("32","32","11426838547771051122","deep","169"),
("33","33","11436321488760422630","deep","169"),
("34","34","11437310585585876168","deep","169"),
("35","35","11449504009281134306","deep","169"),
("36","36","11454574137350440527","deep","169"),
("37","37","11459681752372616058","deep","169"),
("38","38","11460670849198069596","deep","169"),
("39","39","11473853365423813976","deep","169"),
("40","40","11474147655852189974","deep","169"),
("41","41","11487330176372901650","deep","169"),
("42","42","11504593728137466009","deep","169"),
("43","43","11510984730413471076","deep","169"),
("44","44","11519754438014117465","deep","169"),
("45","45","11563639834295611864","deep","169"),
("46","46","11568747449317787395","deep","169"),
("47","47","11573855060044995630","deep","169"),
("48","48","11599487807736472132","deep","169"),
("49","49","11605584519584101201","deep","169"),
("50","50","11612670323962216512","deep","169"),
("51","51","11613659420787670050","deep","169"),
("52","52","11623142361777041558","deep","169"),
("53","53","11624131458602495096","deep","169"),
("54","54","11628249976799217089","deep","169"),
("55","55","11636324878002785938","deep","169"),
("56","56","11637313974828239476","deep","169"),
("57","57","11641395010367059455","deep","169"),
("58","58","11642421589850415007","deep","169"),
("59","59","11646502625389234986","deep","169"),
("60","60","11647491722214688524","deep","169"),
("61","61","11654577526592803835","deep","169"),
("62","62","11660674238440432904","deep","169"),
("63","63","11660968528868808902","deep","169"),
("64","64","11683339695655548792","deep","169"),
("65","65","11691414601154084937","deep","169"),
("66","66","11697805603430090004","deep","169"),
("67","67","11706575311030736393","deep","169"),
("68","68","11728251671420398743","deep","169"),
("69","69","11734642673696403810","deep","169"),
("70","70","11750460707312230792","deep","169"),
("71","71","11755568318039439027","deep","169"),
("72","72","11760675933061614558","deep","169"),
("73","73","11770158874050986066","deep","169"),
("74","74","11774115261352800218","deep","169"),
("75","75","11780249451563364005","deep","169"),
("76","76","11786308680753091060","deep","169"),
("77","77","11792405392600720129","deep","169"),
("78","78","11799491196978835440","deep","169"),
("79","79","11800480293804288978","deep","169"),
("80","80","11809963234793660486","deep","169"),
("81","81","11810952331619114024","deep","169"),
("82","82","11815070849815836017","deep","169"),
("83","83","11824134847844858404","deep","169"),
("84","84","11828215883383678383","deep","169"),
("85","85","11833323498405853914","deep","169"),
("86","86","11834312595231307452","deep","169"),
("87","87","11841398399609422763","deep","169"),
("88","88","11847495111457051832","deep","169"),
("89","89","11847789401885427830","deep","169"),
("90","90","11870160568672167720","deep","169"),
("91","91","11878235474170703865","deep","169"),
("92","92","11883343084897912100","deep","169"),
("93","93","11884626472151741636","deep","169"),
("94","94","11889734087173917167","deep","169"),
("95","95","11893396184047355321","deep","169"),
("96","96","11896819895846999774","deep","169"),
("97","97","11906997638938481526","deep","169"),
("98","98","11915072544437017671","deep","169"),
("99","99","11921463546713022738","deep","169"),
("100","100","11937281580328849720","deep","169"),
("101","101","11942389191056057955","deep","169"),
("102","102","11947496806078233486","deep","169"),
("103","103","11956979747067604994","deep","169"),
("104","104","11958300616979336544","deep","169"),
("105","105","11960936134369419146","deep","169"),
("106","106","11967070324579982933","deep","169"),
("107","107","11973129553769709988","deep","169"),
("108","108","11979226265617339057","deep","169"),
("109","109","11987301166820907906","deep","169"),
("110","110","11996784107810279414","deep","169"),
("111","111","11997773204635732952","deep","169"),
("112","112","12001891722832454945","deep","169"),
("113","113","12010955720861477332","deep","169"),
("114","114","12014085142232745787","deep","169"),
("115","115","12015036756400297311","deep","169"),
("116","116","12020144371422472842","deep","169"),
("117","117","12021133468247926380","deep","169"),
("118","118","12021170950905828394","deep","169"),
("119","119","12024100754429319698","deep","169"),
("120","120","12028219272626041691","deep","169"),
("121","121","12034315984473670760","deep","169"),
("122","122","12034610274902046758","deep","169"),
("123","123","12052900406149966669","deep","169"),
("124","124","12056981441688786648","deep","169"),
("125","125","12065056342892355497","deep","169"),
("126","126","12070163957914531028","deep","169"),
("127","127","12071447345168360564","deep","169"),
("128","128","12076260669762160097","deep","169"),
("129","129","12076554960190536095","deep","169"),
("130","130","12080217057063974249","deep","169"),
("131","131","12083640768863618702","deep","169"),
("132","132","12093818511955100454","deep","169"),
("133","133","12107001028180844834","deep","169"),
("134","134","12108284419729641666","deep","169"),
("135","135","12124102453345468648","deep","169"),
("136","136","12129210064072676883","deep","169"),
("137","137","12134317679094852414","deep","169"),
("138","138","12134649452181130426","deep","169"),
("139","139","12137284969571213028","deep","169"),
("140","140","12143800620084223922","deep","169"),
("141","141","12145121489995955472","deep","169"),
("142","142","12146767910560584536","deep","169"),
("143","143","12147757007386038074","deep","169"),
("144","144","12153891197596601861","deep","169"),
("145","145","12159950426786328916","deep","169"),
("146","146","12166047134338990689","deep","169"),
("147","147","12171154749361166220","deep","169"),
("148","148","12174122039837526834","deep","169"),
("149","149","12181958560262269278","deep","169"),
("150","150","12182653366659346818","deep","169"),
("151","151","12184594077652351880","deep","169"),
("152","152","12188712591554106577","deep","169"),
("153","153","12197776593878096260","deep","169"),
("154","154","12200906015249364715","deep","169"),
("155","155","12201857629416916239","deep","169"),
("156","156","12206965244439091770","deep","169"),
("157","157","12207954341264545308","deep","169"),
("158","158","12210959110103840640","deep","169"),
("159","159","12215040145642660619","deep","169"),
("160","160","12221136857490289688","deep","169"),
("161","161","12221431147918665686","deep","169"),
("162","162","12222125954315743226","deep","169"),
("163","163","12239721279166585597","deep","169"),
("164","164","12243802314705405576","deep","169"),
("165","165","12251877215908974425","deep","169"),
("166","166","12258268218184979492","deep","169"),
("167","167","12261397639556247947","deep","169"),
("168","168","12263081542778779025","deep","169"),
("169","169","12263375833207155023","deep","169"),
("170","170","12267037930080593177","deep","169"),
("171","171","12270461637585270334","deep","169"),
("172","172","12280639384971719382","deep","169"),
("173","173","12282655061280528472","deep","169"),
("174","174","12293821901197463762","deep","169"),
("175","175","12295105288451293298","deep","169"),
("176","176","12299918613045092831","deep","169"),
("177","177","12310923322067120280","deep","169"),
("178","178","12313395419699213209","deep","169"),
("179","179","12316030937089295811","deep","169"),
("180","180","12320481228372295816","deep","169"),
("181","181","12321138552111471342","deep","169"),
("182","182","12321470325197749354","deep","169"),
("183","183","12324105842587831956","deep","169"),
("184","184","12329964169361667324","deep","169"),
("185","185","12330621493100842850","deep","169"),
("186","186","12331942363012574400","deep","169"),
("187","187","12333588779282236168","deep","169"),
("188","188","12334577876107689706","deep","169"),
("189","189","12340712070613220789","deep","169"),
("190","190","12346771299802947844","deep","169"),
("191","191","12352868007355609617","deep","169"),
("192","192","12354313525504346994","deep","169"),
("193","193","12357975622377785148","deep","169"),
("194","194","12368779433278888206","deep","169"),
("195","195","12369474239675965746","deep","169"),
("196","196","12371414950668970808","deep","169"),
("197","197","12375533464570725505","deep","169"),
("198","198","12384597466894715188","deep","169"),
("199","199","12387726888265983643","deep","169"),
("200","200","12388678502433535167","deep","169"),
("201","201","12393786113160743402","deep","169"),
("202","202","12394775209986196940","deep","169"),
("203","203","12397779983120459568","deep","169"),
("204","204","12401861018659279547","deep","169"),
("205","205","12405616503545202012","deep","169"),
("206","206","12407957730506908616","deep","169"),
("207","207","12408252020935284614","deep","169"),
("208","208","12408946827332362154","deep","169"),
("209","209","12413359635957460145","deep","169"),
("210","210","12423574861706843911","deep","169"),
("211","211","12426542152183204525","deep","169"),
("212","212","12430623187722024504","deep","169"),
("213","213","12438698088925593353","deep","169"),
("214","214","12445089091201598420","deep","169"),
("215","215","12448218512572866875","deep","169"),
("216","216","12449902415795397953","deep","169"),
("217","217","12451223285707129503","deep","169"),
("218","218","12453858798802244809","deep","169"),
("219","219","12457282510601889262","deep","169"),
("220","220","12460706222401533715","deep","169"),
("221","221","12467460257988338310","deep","169"),
("222","222","12469475934297147400","deep","169"),
("223","223","12480642774214082690","deep","169"),
("224","224","12481926161467912226","deep","169"),
("225","225","12486739486061711759","deep","169"),
("226","226","12497744195083739208","deep","169"),
("227","227","12500216292715832137","deep","169"),
("228","228","12502851810105914739","deep","169"),
("229","229","12507302101388914744","deep","169"),
("230","230","12508291198214368282","deep","169"),
("231","231","12510926715604450884","deep","169"),
("232","232","12516785042378286252","deep","169"),
("233","233","12518763236029193328","deep","169"),
("234","234","12520409652298855096","deep","169"),
("235","235","12521398749124308634","deep","169"),
("236","236","12525517267321030627","deep","169"),
("237","237","12525554749978932641","deep","169"),
("238","238","12533592172819566772","deep","169"),
("239","239","12537710686721321469","deep","169"),
("240","240","12539688880372228545","deep","169"),
("241","241","12541134398520965922","deep","169"),
("242","242","12544796495394404076","deep","169"),
("243","243","12555600306295507134","deep","169"),
("244","244","12556295112692584674","deep","169"),
("245","245","12558235823685589736","deep","169"),
("246","246","12560707917022715369","deep","169"),
("247","247","12562354337587344433","deep","169"),
("248","248","12571418339911334116","deep","169"),
("249","249","12573558664457149033","deep","169"),
("250","250","12574547761282602571","deep","169"),
("251","251","12580606986177362330","deep","169"),
("252","252","12581596083002815868","deep","169"),
("253","253","12584600856137078496","deep","169"),
("254","254","12588681891675898475","deep","169"),
("255","255","12592437376561820940","deep","169"),
("256","256","12594778603523527544","deep","169"),
("257","257","12595072893951903542","deep","169"),
("258","258","12595767700348981082","deep","169"),
("259","259","12600180504679111777","deep","169"),
("260","260","12603842601552549931","deep","169"),
("261","261","12610395734723462839","deep","169"),
("262","262","12613363025199823453","deep","169"),
("263","263","12617444060738643432","deep","169"),
("264","264","12625518961942212281","deep","169"),
("265","265","12629969253225212286","deep","169"),
("266","266","12631909964218217348","deep","169"),
("267","267","12635039385589485803","deep","169"),
("268","268","12636723284517049585","deep","169"),
("269","269","12637055061898294893","deep","169"),
("270","270","12638044154428781135","deep","169"),
("271","271","12644103383618508190","deep","169"),
("272","272","12647232804989776645","deep","169"),
("273","273","12647527095418152643","deep","169"),
("274","274","12654281131004957238","deep","169"),
("275","275","12656296807313766328","deep","169"),
("276","276","12667463647230701618","deep","169"),
("277","277","12668747034484531154","deep","169"),
("278","278","12673560359078330687","deep","169"),
("279","279","12687037165732451065","deep","169"),
("280","280","12694122974405533672","deep","169"),
("281","281","12697747584326102516","deep","169"),
("282","282","12698535783030631663","deep","169"),
("283","283","12703605911099937884","deep","169"),
("284","284","12705584104750844960","deep","169"),
("285","285","12707230525315474024","deep","169"),
("286","286","12712338140337649555","deep","169"),
("287","287","12717777528446103098","deep","169"),
("288","288","12720413041541218404","deep","169"),
("289","289","12724531559737940397","deep","169"),
("290","290","12726509753388847473","deep","169"),
("291","291","12727955271537584850","deep","169"),
("292","292","12729970947846393940","deep","169"),
("293","293","12731617368411023004","deep","169"),
("294","294","12742421179312126062","deep","169"),
("295","295","12743115981414236306","deep","169"),
("296","296","12745056692407241368","deep","169"),
("297","297","12747528790039334297","deep","169"),
("298","298","12753625501886963366","deep","169"),
("299","299","12754614598712416904","deep","169"),
("300","300","12758239212927953044","deep","169"),
("301","301","12758695634251236883","deep","169"),
("302","302","12760379537473767961","deep","169"),
("303","303","12767427859193981258","deep","169"),
("304","304","12775502764692517403","deep","169"),
("305","305","12777280055927532792","deep","169"),
("306","306","12779258249578439868","deep","169"),
("307","307","12781599472245179176","deep","169"),
("308","308","12781893766968522470","deep","169"),
("309","309","12782588569070632714","deep","169"),
("310","310","12785023184044823629","deep","169"),
("311","311","12786707087267354707","deep","169"),
("312","312","12787001377695730705","deep","169"),
("313","313","12790663474569168859","deep","169"),
("314","314","12791451668978730710","deep","169"),
("315","315","12794087186368813312","deep","169"),
("316","316","12804264929460295064","deep","169"),
("317","317","12812339834958831209","deep","169"),
("318","318","12816790126241831214","deep","169"),
("319","319","12818730837234836276","deep","169"),
("320","320","12821860258606104731","deep","169"),
("321","321","12823544157533668513","deep","169"),
("322","322","12823875930619946525","deep","169"),
("323","323","12824865027445400063","deep","169"),
("324","324","12834053678006395573","deep","169"),
("325","325","12834347968434771571","deep","169"),
("326","326","12843117676035417960","deep","169"),
("327","327","12846541387835062413","deep","169"),
("328","328","12854284520247320546","deep","169"),
("329","329","12855567907501150082","deep","169"),
("330","330","12860381232094949615","deep","169"),
("331","331","12864337615101796471","deep","169"),
("332","332","12873858038749069993","deep","169"),
("333","333","12877939074287889972","deep","169"),
("334","334","12880943847422152600","deep","169"),
("335","335","12883579360517267906","deep","169"),
("336","336","12885356656047250591","deep","169"),
("337","337","12888448590465649736","deep","169"),
("338","338","12890426784116556812","deep","169"),
("339","339","12892404977767463888","deep","169"),
("340","340","12899159013354268483","deep","169"),
("341","341","12899196496012170497","deep","169"),
("342","342","12904598401462722026","deep","169"),
("343","343","12907233914557837332","deep","169"),
("344","344","12911352432754559325","deep","169"),
("345","345","12913330626405466401","deep","169"),
("346","346","12914776144554203778","deep","169"),
("347","347","12916791820863012868","deep","169"),
("348","348","12918438241427641932","deep","169"),
("349","349","12929242048033777694","deep","169"),
("350","350","12929936854430855234","deep","169"),
("351","351","12934349663055953225","deep","169"),
("352","352","12940446374903582294","deep","169"),
("353","353","12941435471729035832","deep","169"),
("354","354","12945060085944571972","deep","169"),
("355","355","12945516507267855811","deep","169"),
("356","356","12946543086751211363","deep","169"),
("357","357","12947200406195419593","deep","169"),
("358","358","12954248732210600186","deep","169"),
("359","359","12962323637709136331","deep","169"),
("360","360","12964100928944151720","deep","169"),
("361","361","12965784832166682798","deep","169"),
("362","362","12966079122595058796","deep","169"),
("363","363","12968420345261798104","deep","169"),
("364","364","12968714639985141398","deep","169"),
("365","365","12969409442087251642","deep","169"),
("366","366","12971844057061442557","deep","169"),
("367","367","12973527960283973635","deep","169"),
("368","368","12973822250712349633","deep","169"),
("369","369","12977283445169896100","deep","169"),
("370","370","12978272541995349638","deep","169"),
("371","371","12980908059385432240","deep","169"),
("372","372","12991085802476913992","deep","169"),
("373","373","12993101478785723082","deep","169"),
("374","374","12999160707975450137","deep","169"),
("375","375","13003610999258450142","deep","169"),
("376","376","13005551710251455204","deep","169"),
("377","377","13008681131622723659","deep","169"),
("378","378","13010365030550287441","deep","169"),
("379","379","13010696803636565453","deep","169"),
("380","380","13011685900462018991","deep","169"),
("381","381","13020874551023014501","deep","169"),
("382","382","13021168841451390499","deep","169"),
("383","383","13029938549052036888","deep","169"),
("384","384","13033362260851681341","deep","169"),
("385","385","13041105393263939474","deep","169"),
("386","386","13042388780517769010","deep","169"),
("387","387","13048191197642054785","deep","169"),
("388","388","13051158488118415399","deep","169"),
("389","389","13060678911765688921","deep","169"),
("390","390","13064759947304508900","deep","169"),
("391","391","13065786526787864452","deep","169"),
("392","392","13066080817216240450","deep","169"),
("393","393","13067764720438771528","deep","169"),
("394","394","13072177524768902223","deep","169"),
("395","395","13075269463482268664","deep","169"),
("396","396","13077247657133175740","deep","169"),
("397","397","13079225850784082816","deep","169"),
("398","398","13079920657181160356","deep","169"),
("399","399","13084333465806258347","deep","169"),
("400","400","13085979886370887411","deep","169"),
("401","401","13086017369028789425","deep","169"),
("402","402","13091419270184373658","deep","169"),
("403","403","13096526885206549189","deep","169"),
("404","404","13098173305771178253","deep","169"),
("405","405","13100151499422085329","deep","169"),
("406","406","13103612693879631796","deep","169"),
("407","407","13105259114444260860","deep","169"),
("408","408","13116062921050396622","deep","169"),
("409","409","13121170536072572153","deep","169"),
("410","410","13123843536120556769","deep","169"),
("411","411","13127267247920201222","deep","169"),
("412","412","13128256344745654760","deep","169"),
("413","413","13132337380284474739","deep","169"),
("414","414","13133363955472862995","deep","169"),
("415","415","13134021279212038521","deep","169"),
("416","416","13141069605227219114","deep","169"),
("417","417","13150921801960770648","deep","169"),
("418","418","13152605700888334430","deep","169"),
("419","419","13154252121452963494","deep","169"),
("420","420","13156029412687978883","deep","169"),
("421","421","13158664930078061485","deep","169"),
("422","422","13160348833300592563","deep","169"),
("423","423","13160643123728968561","deep","169"),
("424","424","13160680606386870575","deep","169"),
("425","425","13164104318186515028","deep","169"),
("426","426","13165093415011968566","deep","169"),
("427","427","13167728932402051168","deep","169"),
("428","428","13168185353725335007","deep","169"),
("429","429","13170201030034144097","deep","169"),
("430","430","13177906675493532920","deep","169"),
("431","431","13179922351802342010","deep","169"),
("432","432","13185981580992069065","deep","169"),
("433","433","13190431872275069070","deep","169"),
("434","434","13191089191719277300","deep","169"),
("435","435","13192372583268074132","deep","169"),
("436","436","13195502000344375291","deep","169"),
("437","437","13197185903566906369","deep","169"),
("438","438","13198506773478637919","deep","169"),
("439","439","13207695424039633429","deep","169"),
("440","440","13207989714468009427","deep","169"),
("441","441","13218737615719562892","deep","169"),
("442","442","13220183133868300269","deep","169"),
("443","443","13227926266280558402","deep","169"),
("444","444","13229209653534387938","deep","169"),
("445","445","13235012070658673713","deep","169"),
("446","446","13237979361135034327","deep","169"),
("447","447","13247499784782307849","deep","169"),
("448","448","13251580820321127828","deep","169"),
("449","449","13252607399804483380","deep","169"),
("450","450","13252901690232859378","deep","169"),
("451","451","13254585589160423160","deep","169"),
("452","452","13258998397785521151","deep","169"),
("453","453","13262090336498887592","deep","169"),
("454","454","13264068530149794668","deep","169"),
("455","455","13266046723800701744","deep","169"),
("456","456","13266741530197779284","deep","169"),
("457","457","13271154338822877275","deep","169"),
("458","458","13272838237750441057","deep","169"),
("459","459","13278240143200992586","deep","169"),
("460","460","13283347758223168117","deep","169"),
("461","461","13284994178787797181","deep","169"),
("462","462","13289444470070797186","deep","169"),
("463","463","13292079987460879788","deep","169"),
("464","464","13302883794067015550","deep","169"),
("465","465","13310664409137175697","deep","169"),
("466","466","13314088120936820150","deep","169"),
("467","467","13315077217762273688","deep","169"),
("468","468","13319158249006126371","deep","169"),
("469","469","13320184828489481923","deep","169"),
("470","470","13320842152228657449","deep","169"),
("471","471","13337742674977389576","deep","169"),
("472","472","13339426573904953358","deep","169"),
("473","473","13341072994469582422","deep","169"),
("474","474","13342850285704597811","deep","169"),
("475","475","13345485803094680413","deep","169"),
("476","476","13347169706317211491","deep","169"),
("477","477","13347463996745587489","deep","169"),
("478","478","13347501479403489503","deep","169"),
("479","479","13350925191203133956","deep","169"),
("480","480","13351914288028587494","deep","169"),
("481","481","13354549805418670096","deep","169"),
("482","482","13355006226741953935","deep","169"),
("483","483","13357021903050763025","deep","169"),
("484","484","13357973517218314549","deep","169"),
("485","485","13364727548510151848","deep","169"),
("486","486","13366743224818960938","deep","169"),
("487","487","13377252740996720702","deep","169"),
("488","488","13377910064735896228","deep","169"),
("489","489","13379687360265878913","deep","169"),
("490","490","13382322873360994219","deep","169"),
("491","491","13384006776583525297","deep","169"),
("492","492","13385327646495256847","deep","169"),
("493","493","13386773164643994224","deep","169"),
("494","494","13394516297056252357","deep","169"),
("495","495","13405558488736181820","deep","169"),
("496","496","13407004006884919197","deep","169"),
("497","497","13416030526551006866","deep","169"),
("498","498","13421832943675292641","deep","169"),
("499","499","13434320657798926777","deep","169"),
("500","500","13438401693337746756","deep","169"),
("501","501","13439428268526135012","deep","169"),
("502","502","13439722563249478306","deep","169"),
("503","503","13441406462177042088","deep","169"),
("504","504","13445819270802140079","deep","169"),
("505","505","13448911209515506520","deep","169"),
("506","506","13450889403166413596","deep","169"),
("507","507","13452867596817320672","deep","169"),
("508","508","13453562403214398212","deep","169"),
("509","509","13457975211839496203","deep","169"),
("510","510","13465061016217611514","deep","169"),
("511","511","13470168631239787045","deep","169"),
("512","512","13471815051804416109","deep","169"),
("513","513","13476265343087416114","deep","169"),
("514","514","13478900856182531420","deep","169"),
("515","515","13486774859265175878","deep","169"),
("516","516","13489704667083634478","deep","169"),
("517","517","13497485282153794625","deep","169"),
("518","518","13500908993953439078","deep","169"),
("519","519","13501898086483925320","deep","169"),
("520","520","13505979122022745299","deep","169"),
("521","521","13507005701506100851","deep","169"),
("522","522","13507663025245276377","deep","169"),
("523","523","13526247446921572286","deep","169"),
("524","524","13529671158721216739","deep","169"),
("525","525","13532306676111299341","deep","169"),
("526","526","13533990579333830419","deep","169"),
("527","527","13534322352420108431","deep","169"),
("528","528","13537746064219752884","deep","169"),
("529","529","13538735161045206422","deep","169"),
("530","530","13541827099758572863","deep","169"),
("531","531","13541864582416474877","deep","169"),
("532","532","13544794385939966181","deep","169"),
("533","533","13553564097835579866","deep","169"),
("534","534","13564073614013339630","deep","169"),
("535","535","13564730937752515156","deep","169"),
("536","536","13566508228987530545","deep","169"),
("537","537","13569143746377613147","deep","169"),
("538","538","13570827649600144225","deep","169"),
("539","539","13572148519511875775","deep","169"),
("540","540","13579690749508242221","deep","169"),
("541","541","13581337170072871285","deep","169"),
("542","542","13592379361752800748","deep","169"),
("543","543","13621141530815545705","deep","169"),
("544","544","13625222562059398388","deep","169"),
("545","545","13626249141542753940","deep","169"),
("546","546","13626543431971129938","deep","169"),
("547","547","13628227335193661016","deep","169"),
("548","548","13632640143818759007","deep","169"),
("549","549","13635732082532125448","deep","169"),
("550","550","13637710276183032524","deep","169"),
("551","551","13639688469833939600","deep","169"),
("552","552","13640383276231017140","deep","169"),
("553","553","13644796084856115131","deep","169"),
("554","554","13650892792408776904","deep","169"),
("555","555","13651881889234230442","deep","169"),
("556","556","13656989504256405973","deep","169"),
("557","557","13663086216104035042","deep","169"),
("558","558","13673595732281794806","deep","169"),
("559","559","13676525540100253406","deep","169"),
("560","560","13684306150875446257","deep","169"),
("561","561","13687729862675090710","deep","169"),
("562","562","13688718959500544248","deep","169"),
("563","563","13692799995039364227","deep","169"),
("564","564","13693826574522719779","deep","169"),
("565","565","13694483898261895305","deep","169"),
("566","566","13713068319938191214","deep","169"),
("567","567","13716492031737835667","deep","169"),
("568","568","13719127549127918269","deep","169"),
("569","569","13721143225436727359","deep","169"),
("570","570","13722132322262180897","deep","169"),
("571","571","13724566937236371812","deep","169"),
("572","572","13725556034061825350","deep","169"),
("573","573","13728685451138126509","deep","169"),
("574","574","13731615258956585109","deep","169"),
("575","575","13740384970852198794","deep","169"),
("576","576","13753329102004149473","deep","169"),
("577","577","13755964619394232075","deep","169"),
("578","578","13757648522616763153","deep","169"),
("579","579","13758969392528494703","deep","169"),
("580","580","13766511622524861149","deep","169"),
("581","581","13768158038794522917","deep","169"),
("582","582","13771125329270883531","deep","169"),
("583","583","13782623946569064129","deep","169"),
("584","584","13807962399537197337","deep","169"),
("585","585","13812043435076017316","deep","169"),
("586","586","13813070014559372868","deep","169"),
("587","587","13813364304987748866","deep","169"),
("588","588","13814059111384826406","deep","169"),
("589","589","13815048208210279944","deep","169"),
("590","590","13822552955548744376","deep","169"),
("591","591","13824531149199651452","deep","169"),
("592","592","13831616953577766763","deep","169"),
("593","593","13838702762250849370","deep","169"),
("594","594","13843810377273024901","deep","169"),
("595","595","13849907084825686674","deep","169"),
("596","596","13860416605298413734","deep","169"),
("597","597","13863346413116872334","deep","169"),
("598","598","13866475834488140789","deep","169"),
("599","599","13874550735691709638","deep","169"),
("600","600","13875539832517163176","deep","169"),
("601","601","13879620868055983155","deep","169"),
("602","602","13880647447539338707","deep","169"),
("603","603","13881304771278514233","deep","169"),
("604","604","13899889192954810142","deep","169"),
("605","605","13903312904754454595","deep","169"),
("606","606","13907964098453346287","deep","169"),
("607","607","13908953190983832529","deep","169"),
("608","608","13911387810252990740","deep","169"),
("609","609","13912376902783476982","deep","169"),
("610","610","13915506324154745437","deep","169"),
("611","611","13918436131973204037","deep","169"),
("612","612","13940149975020768401","deep","169"),
("613","613","13953332491246512781","deep","169"),
("614","614","13954978911811141845","deep","169"),
("615","615","13969444819585683057","deep","169"),
("616","616","13999890887575991796","deep","169"),
("617","617","14000879984401445334","deep","169"),
("618","618","14009373828565363304","deep","169"),
("619","619","14011352022216270380","deep","169"),
("620","620","14018437826594385691","deep","169"),
("621","621","14024534538442014760","deep","169"),
("622","622","14025523635267468298","deep","169"),
("623","623","14030631250289643829","deep","169"),
("624","624","14036727957842305602","deep","169"),
("625","625","14047237478315032662","deep","169"),
("626","626","14053296707504759717","deep","169"),
("627","627","14061371608708328566","deep","169"),
("628","628","14062360705533782104","deep","169"),
("629","629","14066441741072602083","deep","169"),
("630","630","14067468320555957635","deep","169"),
("631","631","14090133777771073523","deep","169"),
("632","632","14094784967174997919","deep","169"),
("633","633","14097219582149188834","deep","169"),
("634","634","14099197775800095910","deep","169"),
("635","635","14102327197171364365","deep","169"),
("636","636","14104962714561446967","deep","169"),
("637","637","14126970848037387329","deep","169"),
("638","638","14140153364263131709","deep","169"),
("639","639","14141799784827760773","deep","169"),
("640","640","14156265692602301985","deep","169"),
("641","641","14186711760592610724","deep","169"),
("642","642","14187700857418064262","deep","169"),
("643","643","14196194701581982232","deep","169"),
("644","644","14197221281065337784","deep","169"),
("645","645","14211355411458633688","deep","169"),
("646","646","14216757316909185217","deep","169"),
("647","647","14217452123306262757","deep","169"),
("648","648","14223548830858924530","deep","169"),
("649","649","14235009965499203114","deep","169"),
("650","650","14240117580521378645","deep","169"),
("651","651","14248192481724947494","deep","169"),
("652","652","14249181578550401032","deep","169"),
("653","653","14252310999921669487","deep","169"),
("654","654","14254289193572576563","deep","169"),
("655","655","14276954650787692451","deep","169"),
("656","656","14284040455165807762","deep","169"),
("657","657","14286018648816714838","deep","169"),
("658","658","14289148070187983293","deep","169"),
("659","659","14304271297406732735","deep","169"),
("660","660","14313791721054006257","deep","169"),
("661","661","14326974237279750637","deep","169"),
("662","662","14383015574598601160","deep","169"),
("663","663","14384042149786989416","deep","169"),
("664","664","14403578189925804145","deep","169"),
("665","665","14404272992027914389","deep","169"),
("666","666","14426938449243030277","deep","169"),
("667","667","14435013354741566422","deep","169"),
("668","668","14439131872938288415","deep","169"),
("669","669","14441110066589195491","deep","169"),
("670","670","14463775523804311379","deep","169"),
("671","671","14470861328182426690","deep","169"),
("672","672","14476958040030055759","deep","169"),
("673","673","14500612594070625185","deep","169"),
("674","674","14570863022803608344","deep","169"),
("675","675","14613759322259649205","deep","169"),
("676","676","14625952745954907343","deep","169"),
("677","677","14627930939605814419","deep","169"),
("678","678","14650596396820930307","deep","169"),
("679","679","14657682201199045618","deep","169"),
("680","680","14663778913046674687","deep","169"),
("681","681","14682325852065068582","deep","169"),
("682","682","14687433467087244113","deep","169"),
("683","683","14688422563912697651","deep","169"),
("684","684","14757683895820227272","deep","169"),
("685","685","14796499159737448154","deep","169"),
("686","686","14812773614676558975","deep","169"),
("687","687","14837417265542581939","deep","169"),
("688","688","14844503074215664546","deep","169"),
("689","689","14850599786063293615","deep","169"),
("690","690","14874254340103863041","deep","169"),
("691","691","14875243436929316579","deep","169"),
("692","692","14944504768836846200","deep","169"),
("693","693","14999594487693177903","deep","169"),
("694","694","15037420659079912543","deep","169"),
("695","695","15061075213120481969","deep","169"),
("696","696","15075246826171679887","deep","169"),
("697","697","15175248520792861541","deep","169"),
("698","698","1648951073958868076","deep","169"),
("699","699","1848954463201231384","deep","169"),
("700","700","1872609017241800810","deep","169"),
("701","701","1941870349149330431","deep","169"),
("702","702","2072612406484164118","deep","169"),
("703","703","2096266960524733544","deep","169"),
("704","704","2148959547064776346","deep","169"),
("705","705","2165528292432263165","deep","169"),
("706","706","2296270349767096852","deep","169"),
("707","707","2319924903807666278","deep","169"),
("708","708","2341877131929024343","deep","169"),
("709","709","2389186235715195899","deep","169"),
("710","710","2513537290774024519","deep","169"),
("711","711","2519928293050029586","deep","169"),
("712","712","2520623099447107126","deep","169"),
("713","713","2543582847090599012","deep","169"),
("714","714","2565535075211957077","deep","169"),
("715","715","2599367372344008255","deep","169"),
("716","716","2606453181017090862","deep","169"),
("717","717","2612844183293095929","deep","169"),
("718","718","2692283262587074598","deep","169"),
("719","719","2727712297362553041","deep","169"),
("720","720","2743586236332962320","deep","169"),
("721","721","2744281042730039860","deep","169"),
("722","722","2767240790373531746","deep","169"),
("723","723","2789193018494889811","deep","169"),
("724","724","2823025315626940989","deep","169"),
("725","725","2830111124300023596","deep","169"),
("726","726","2836502126576028663","deep","169"),
("727","727","2867937291391790940","deep","169"),
("728","728","2915941205870007332","deep","169"),
("729","729","2951370240645485775","deep","169"),
("730","730","2967244179615895054","deep","169"),
("731","731","2967938986012972594","deep","169"),
("732","732","2970336118329261495","deep","169"),
("733","733","2990898733656464480","deep","169"),
("734","734","3012850961777822545","deep","169"),
("735","735","3046683258909873723","deep","169"),
("736","736","3053769067582956330","deep","169"),
("737","737","3060160069858961397","deep","169"),
("738","738","3091595234674723674","deep","169"),
("739","739","3108858786439288033","deep","169"),
("740","740","3175028183928418509","deep","169"),
("741","741","3190902122898827788","deep","169"),
("742","742","3191596929295905328","deep","169"),
("743","743","3193994061612194229","deep","169"),
("744","744","3214556676939397214","deep","169"),
("745","745","3246686648152237031","deep","169"),
("746","746","3260858265498402245","deep","169"),
("747","747","3270341202192806457","deep","169"),
("748","748","3277427010865889064","deep","169"),
("749","749","3283818013141894131","deep","169"),
("750","750","3285207621641081915","deep","169"),
("751","751","3315253177957656408","deep","169"),
("752","752","3332516729722220767","deep","169"),
("753","753","3398686127211351243","deep","169"),
("754","754","3414560066181760522","deep","169"),
("755","755","3415254872578838062","deep","169"),
("756","756","3417652004895126963","deep","169"),
("757","757","3470344595730137061","deep","169"),
("758","758","3484516208781334979","deep","169"),
("759","759","3493999149770706487","deep","169"),
("760","760","3501084954148821798","deep","169"),
("761","761","3508865569218981945","deep","169"),
("762","762","3538911121240589142","deep","169"),
("763","763","3556174673005153501","deep","169"),
("764","764","3622344070494283977","deep","169"),
("765","765","3624741202810572878","deep","169"),
("766","766","3638218013759660552","deep","169"),
("767","767","3638912815861770796","deep","169"),
("768","768","3641309952473026993","deep","169"),
("769","769","3708174152064267713","deep","169"),
("770","770","3717657093053639221","deep","169"),
("771","771","3724742897431754532","deep","169"),
("772","772","3732523512501914679","deep","169"),
("773","773","3762569064523521876","deep","169"),
("774","774","3779832620583053531","deep","169"),
("775","775","3846002013777216711","deep","169"),
("776","776","3848399146093505612","deep","169"),
("777","777","3861875957042593286","deep","169"),
("778","778","3862570759144703530","deep","169"),
("779","779","3864967895755959727","deep","169"),
("780","780","3886920119582350496","deep","169"),
("781","781","3941315036336571955","deep","169"),
("782","782","3956181455784847413","deep","169"),
("783","783","3986227012101421906","deep","169"),
("784","784","3993312816479537217","deep","169"),
("785","785","4003490563865986265","deep","169"),
("786","786","4072057089376438346","deep","169"),
("787","787","4088625839038892461","deep","169"),
("788","788","4110578062865283230","deep","169"),
("789","789","4164972979619504689","deep","169"),
("790","790","4179839399067780147","deep","169"),
("791","791","4200402014394983132","deep","169"),
("792","792","4209884955384354640","deep","169"),
("793","793","4216970759762469951","deep","169"),
("794","794","4227148507148918999","deep","169"),
("795","795","4295715032659371080","deep","169"),
("796","796","4302800841332453687","deep","169"),
("797","797","4334236006148215964","deep","169"),
("798","798","4374459309851239505","deep","169"),
("799","799","4388630922902437423","deep","169"),
("800","800","4403497342350712881","deep","169"),
("801","801","4424059957677915866","deep","169"),
("802","802","4433542898667287374","deep","169"),
("803","803","4440628703045402685","deep","169"),
("804","804","4450806450431851733","deep","169"),
("805","805","4519372980237271110","deep","169"),
("806","806","4526458784615386421","deep","169"),
("807","807","4557893953726115994","deep","169"),
("808","808","4598117253134172239","deep","169"),
("809","809","4612288866185370157","deep","169"),
("810","810","4627155285633645615","deep","169"),
("811","811","4647717900960848600","deep","169"),
("812","812","4674464393714784467","deep","169"),
("813","813","4850813228916578349","deep","169"),
("814","814","4898122336997717201","deep","169"),
("815","815","5074471172199511083","deep","169"),
("816","816","5298129115482443817","deep","169"),
("817","817","9753034818424455989","deep","169"),
("818","818","9845950708667522332","deep","169"),
("819","819","9938866594615621379","deep","169"),
("820","820","9960124016339901904","deep","169"),
("0","0","11460841271658201515","deep","17"),
("1","1","14503750307007117718","deep","17"),
("2","2","14872409965254489171","deep","17"),
("3","3","15525825952910347016","deep","17"),
("4","4","16418991566760252814","deep","17"),
("5","5","16688550582633489037","deep","17"),
("0","0","10988017604896555877","deep","170"),
("1","1","10996092510395092022","deep","170"),
("2","2","11174838477913174805","deep","170"),
("3","3","11180935189760803874","deep","170"),
("4","4","11288022688760100839","deep","170"),
("5","5","11367756062777422802","deep","170"),
("6","6","11474843561776719767","deep","170"),
("7","7","11554576931499074434","deep","170"),
("8","8","11661664434793338695","deep","170"),
("9","9","11741397804515693362","deep","170"),
("10","10","11848485307809957623","deep","170"),
("11","11","12035306180826576551","deep","170"),
("12","12","12106307325606186843","deep","170"),
("13","13","12226539862468293470","deep","170"),
("14","14","12293128194327838475","deep","170"),
("15","15","12479949067344457403","deep","170"),
("16","16","12666769940361076331","deep","170"),
("17","17","12805624381557380881","deep","170"),
("18","18","12853590813377695259","deep","170"),
("19","19","12877282850076166699","deep","170"),
("20","20","12926275861379836629","deep","170"),
("21","21","12992445254573999809","deep","170"),
("22","22","13005258519350531459","deep","170"),
("23","23","13040411686394314187","deep","170"),
("24","24","13064103723092785627","deep","170"),
("25","25","13113096734396455557","deep","170"),
("26","26","13179266127590618737","deep","170"),
("27","27","13192079388072183091","deep","170"),
("28","28","13227232559410933115","deep","170"),
("29","29","13240415075636677495","deep","170"),
("30","30","13250924596109404555","deep","170"),
("31","31","13299917603118107189","deep","170"),
("32","32","13329249930340923859","deep","170"),
("33","33","13366087000607237665","deep","170"),
("34","34","13414053432427552043","deep","170"),
("35","35","13427235948653296423","deep","170"),
("36","36","13437745469126023483","deep","170"),
("37","37","13486738476134726117","deep","170"),
("38","38","13516070803357542787","deep","170"),
("39","39","13548951486322042441","deep","170"),
("40","40","13600874305444170971","deep","170"),
("41","41","13624566342142642411","deep","170"),
("42","42","13673559349151345045","deep","170"),
("43","43","13702891676374161715","deep","170"),
("44","44","13787695178460789899","deep","170"),
("45","45","13811387210864294043","deep","170"),
("46","46","13860380222167963973","deep","170"),
("47","47","13889712545095813347","deep","170"),
("48","48","13998208083880912971","deep","170"),
("49","49","14047201095184582901","deep","170"),
("50","50","14076533418112432275","deep","170"),
("51","51","14142132657441491038","deep","170"),
("52","52","14185028956897531899","deep","170"),
("53","53","14234021968201201829","deep","170"),
("54","54","14263354291129051203","deep","170"),
("55","55","14328953530458109966","deep","170"),
("56","56","14335012759647837021","deep","170"),
("57","57","14371849829914150827","deep","170"),
("58","58","14515774403474728894","deep","170"),
("59","59","14702595276491347822","deep","170"),
("60","60","14782328646213702489","deep","170"),
("61","61","14889416149507966750","deep","170"),
("62","62","15006681395893712763","deep","170"),
("63","63","2282099836243351187","deep","170"),
("64","64","2505757779526283921","deep","170"),
("65","65","2506452585923361461","deep","170"),
("66","66","2729415722809216655","deep","170"),
("67","67","2730110529206294195","deep","170"),
("68","68","2892287751356890159","deep","170"),
("69","69","2953073666092149389","deep","170"),
("70","70","2953768472489226929","deep","170"),
("71","71","3115945694639822893","deep","170"),
("72","72","3176731609375082123","deep","170"),
("73","73","3177426415772159663","deep","170"),
("74","74","3243595813261290139","deep","170"),
("75","75","3339603637922755627","deep","170"),
("76","76","3400389552658014857","deep","170"),
("77","77","3401084359055092397","deep","170"),
("78","78","3467253756544222873","deep","170"),
("79","79","3563261581205688361","deep","170"),
("80","80","3624047495940947591","deep","170"),
("81","81","3690911699827155607","deep","170"),
("82","82","3755484359672858818","deep","170"),
("83","83","3786919524488621095","deep","170"),
("84","84","3914569643110088341","deep","170"),
("85","85","3979142302955791552","deep","170"),
("86","86","4010577467771553829","deep","170"),
("87","87","4202800246238724286","deep","170"),
("88","88","4426458189521657020","deep","170"),
("89","89","4588635411672252984","deep","170"),
("90","90","4812293354955185718","deep","170"),
("0","0","13229249335247194458","deep","171"),
("1","1","13308688414541173127","deep","171"),
("0","0","11016363030053856219","deep","172"),
("1","1","11203183903070475147","deep","172"),
("2","2","11362650646810151777","deep","172"),
("3","3","11390004776087094075","deep","172"),
("4","4","11549471519826770705","deep","172"),
("5","5","11576825649103713003","deep","172"),
("6","6","11763646522120331931","deep","172"),
("7","7","12096826583671719841","deep","172"),
("8","8","12283647456688338769","deep","172"),
("9","9","12468490136054050621","deep","172"),
("10","10","12470468329704957697","deep","172"),
("11","11","12657289202721576625","deep","172"),
("12","12","12844110071443228257","deep","172"),
("13","13","13030930944459847185","deep","172"),
("14","14","13367735620226771235","deep","172"),
("15","15","13554556493243390163","deep","172"),
("16","16","13739399172609102015","deep","172"),
("17","17","14886451058086510642","deep","172"),
("18","18","15073271931103129570","deep","172"),
("19","19","15260092804119748498","deep","172"),
("20","20","15446913677136367426","deep","172"),
("21","21","2620628092650645539","deep","172"),
("22","22","4316975752966008364","deep","172"),
("23","23","4540633696248941098","deep","172"),
("0","0","10895105017530813589","deep","173"),
("1","1","11081925886252465221","deep","173"),
("2","2","11118762960813746323","deep","173"),
("3","3","11268746759269084149","deep","173"),
("4","4","11342420904096679057","deep","173"),
("5","5","11398499719778464298","deep","173"),
("6","6","11418768044677291285","deep","173"),
("7","7","11455567632285703077","deep","173"),
("8","8","11529241777113297985","deep","173"),
("9","9","11585320592795083226","deep","173"),
("10","10","11611685625246571986","deep","173"),
("11","11","11642388505302322005","deep","173"),
("12","12","11696820904714445478","deep","173"),
("13","13","11710992517765643396","deep","173"),
("14","14","11716062650129916913","deep","173"),
("15","15","11772141465811702154","deep","173"),
("16","16","11790431597059622065","deep","173"),
("17","17","11790725887487998063","deep","173"),
("18","18","11798506498263190914","deep","173"),
("19","19","11829209378318940933","deep","173"),
("20","20","11856563511890850527","deep","173"),
("21","21","11883641773436097110","deep","173"),
("22","22","11897813390782262324","deep","173"),
("23","23","11902883518851568545","deep","173"),
("24","24","11944828204140057882","deep","173"),
("25","25","11965059046380982855","deep","173"),
("26","26","11977252470076240993","deep","173"),
("27","27","11977546760504616991","deep","173"),
("28","28","11985327371279809842","deep","173"),
("29","29","12016030251335559861","deep","173"),
("30","30","12040417094431108841","deep","173"),
("31","31","12043384380612502159","deep","173"),
("32","32","12116069428614643529","deep","173"),
("33","33","12131649077156676810","deep","173"),
("34","34","12164073343092859921","deep","173"),
("35","35","12164367633521235919","deep","173"),
("36","36","12199921316533720189","deep","173"),
("37","37","12202851124352178789","deep","173"),
("38","38","12230205253629121087","deep","173"),
("39","39","12274878844320177337","deep","173"),
("40","40","12297745203951184912","deep","173"),
("41","41","12318469950173295738","deep","173"),
("42","42","12347232119236040695","deep","173"),
("43","43","12367794734563243680","deep","173"),
("44","44","12386742189550339117","deep","173"),
("45","45","12389671997368797717","deep","173"),
("46","46","12396795284404815042","deep","173"),
("47","47","12417026126645740015","deep","173"),
("48","48","12423541777158750909","deep","173"),
("49","49","12444141875143855908","deep","173"),
("50","50","12445788295708484972","deep","173"),
("51","51","12461699717336796265","deep","173"),
("52","52","12488722077822427847","deep","173"),
("53","53","12505290823189914666","deep","173"),
("54","54","12514354825513904349","deep","173"),
("55","55","12517778537313548802","deep","173"),
("56","56","12531950150364746720","deep","173"),
("57","57","12534052992252659623","deep","173"),
("58","58","12554321317151486610","deep","173"),
("59","59","12576492870385416645","deep","173"),
("60","60","12583616157421433970","deep","173"),
("61","61","12595114774719614568","deep","173"),
("62","62","12610362650175369837","deep","173"),
("63","63","12611389229658725389","deep","173"),
("64","64","12621442324513201314","deep","173"),
("65","65","12630962748160474836","deep","173"),
("66","66","12632609168725103900","deep","173"),
("67","67","12648520590353415193","deep","173"),
("68","68","12653628205375590724","deep","173"),
("69","69","12654323011772668264","deep","173"),
("70","70","12655274625940219788","deep","173"),
("71","71","12675542950839046775","deep","173"),
("72","72","12689677081232342679","deep","173"),
("73","73","12704599406035200434","deep","173"),
("74","74","12705294212432277974","deep","173"),
("75","75","12720873865269278551","deep","173"),
("76","76","12723546861022295871","deep","173"),
("77","77","12741142185873138242","deep","173"),
("78","78","12749179608713772373","deep","173"),
("79","79","12764340318590423829","deep","173"),
("80","80","12770437030438052898","deep","173"),
("81","81","12781935643441266200","deep","173"),
("82","82","12797183523191988765","deep","173"),
("83","83","12819430041741722828","deep","173"),
("84","84","12829282234180307066","deep","173"),
("85","85","12835341463370034121","deep","173"),
("86","86","12840449078392209652","deep","173"),
("87","87","12841143884789287192","deep","173"),
("88","88","12842095498956838716","deep","173"),
("89","89","12862363819560698407","deep","173"),
("90","90","12870895146382518391","deep","173"),
("91","91","12871846760550069915","deep","173"),
("92","92","12874519760598054531","deep","173"),
("93","93","12876497954248961607","deep","173"),
("94","94","12891420279051819362","deep","173"),
("95","95","12905591896397984576","deep","173"),
("96","96","12907694733990930183","deep","173"),
("97","97","12910367734038914799","deep","173"),
("98","98","12960681615254316279","deep","173"),
("99","99","12968756516457885128","deep","173"),
("100","100","12984004396208607693","deep","173"),
("101","101","12985325266120339243","deep","173"),
("102","102","13022162336386653049","deep","173"),
("103","103","13022199819044555063","deep","173"),
("104","104","13027269951408828580","deep","173"),
("105","105","13027964753510938824","deep","173"),
("106","106","13028916371973457644","deep","173"),
("107","107","13047169020563475541","deep","173"),
("108","108","13057716019399137319","deep","173"),
("109","109","13058667633566688843","deep","173"),
("110","110","13061340633614673459","deep","173"),
("111","111","13097188607055533727","deep","173"),
("112","112","13147502488270935207","deep","173"),
("113","113","13155577389474504056","deep","173"),
("114","114","13166086909947231116","deep","173"),
("115","115","13168722427337313718","deep","173"),
("116","116","13170825269225226621","deep","173"),
("117","117","13172146139136958171","deep","173"),
("118","118","13189447173559424544","deep","173"),
("119","119","13194849079009976073","deep","173"),
("120","120","13209020692061173991","deep","173"),
("121","121","13214090824425447508","deep","173"),
("122","122","13214785626527557752","deep","173"),
("123","123","13215737240695109276","deep","173"),
("124","124","13216763820178464828","deep","173"),
("125","125","13248161506631292387","deep","173"),
("126","126","13261638313285412765","deep","173"),
("127","127","13270169640107232749","deep","173"),
("128","128","13284009480072152655","deep","173"),
("129","129","13289411385522704184","deep","173"),
("130","130","13352907782963850044","deep","173"),
("131","131","13357646142241845549","deep","173"),
("132","132","13358967012153577099","deep","173"),
("133","133","13372605949702605318","deep","173"),
("134","134","13376268046576043472","deep","173"),
("135","135","13381669947731627705","deep","173"),
("136","136","13400911693147099140","deep","173"),
("137","137","13401606499544176680","deep","173"),
("138","138","13402558113711728204","deep","173"),
("139","139","13403584693195083756","deep","173"),
("140","140","13451588607673300148","deep","173"),
("141","141","13456990513123851677","deep","173"),
("142","142","13465521835650704365","deep","173"),
("143","143","13470830353088771583","deep","173"),
("144","144","13476232258539323112","deep","173"),
("145","145","13527240941856834836","deep","173"),
("146","146","13539728655980468972","deep","173"),
("147","147","13545787880875228731","deep","173"),
("148","148","13559426822719224246","deep","173"),
("149","149","13563088915297695104","deep","173"),
("150","150","13573598435770422164","deep","173"),
("151","151","13581673341268958309","deep","173"),
("152","152","13587732566163718068","deep","173"),
("153","153","13588427372560795608","deep","173"),
("154","154","13635773963299836474","deep","173"),
("155","155","13638409480689919076","deep","173"),
("156","156","13638703771118295074","deep","173"),
("157","157","13652342708667323293","deep","173"),
("158","158","13657651226105390511","deep","173"),
("159","159","13663053131555942040","deep","173"),
("160","160","13689712454435806798","deep","173"),
("161","161","13700879298647709384","deep","173"),
("162","162","13714061814873453764","deep","173"),
("163","163","13726549528997087900","deep","173"),
("164","164","13732608753891847659","deep","173"),
("165","165","13746247695735843174","deep","173"),
("166","166","13760419308787041092","deep","173"),
("167","167","13774553439180336996","deep","173"),
("168","168","13775248245577414536","deep","173"),
("169","169","13825230353706538004","deep","173"),
("170","170","13825524644134914002","deep","173"),
("171","171","13826551223618269554","deep","173"),
("172","172","13839163581683942221","deep","173"),
("173","173","13852878773411856300","deep","173"),
("174","174","13880614362991245705","deep","173"),
("175","175","13901871784715526230","deep","173"),
("176","176","13913370397718739532","deep","173"),
("177","177","13922559048279735042","deep","173"),
("178","178","13933068568752462102","deep","173"),
("179","179","13947240181803660020","deep","173"),
("180","180","13961374312196955924","deep","173"),
("181","181","14012051222428189636","deep","173"),
("182","182","14013372092339921186","deep","173"),
("183","183","14025984454700561149","deep","173"),
("184","184","14039699646428475228","deep","173"),
("185","185","14072580333687942178","deep","173"),
("186","186","14100191270735358460","deep","173"),
("187","187","14109379921296353970","deep","173"),
("188","188","14122856727950474348","deep","173"),
("189","189","14127964342972649879","deep","173"),
("190","190","14134061054820278948","deep","173"),
("191","191","14148195185213574852","deep","173"),
("192","192","14200192965356540114","deep","173"),
("193","193","14212805327717180077","deep","173"),
("194","194","14287012143751977388","deep","173"),
("195","195","14293108855599606457","deep","173"),
("196","196","14308688504141639738","deep","173"),
("197","197","14309677600967093276","deep","173"),
("198","198","14314785215989268807","deep","173"),
("199","199","14328625055954188713","deep","173"),
("200","200","14387013838373159042","deep","173"),
("201","201","14457683210066491322","deep","173"),
("202","202","14479929728616225385","deep","173"),
("203","203","14496498473983712204","deep","173"),
("204","204","14501606089005887735","deep","173"),
("205","205","14513799508406178577","deep","173"),
("206","206","14700620381422797505","deep","173"),
("207","207","14887441254439416433","deep","173"),
("208","208","14923251745222374687","deep","173"),
("209","209","1834787248259842478","deep","173"),
("210","210","2020619020156040572","deep","173"),
("211","211","2058445191542775212","deep","173"),
("212","212","2244276967733940602","deep","173"),
("213","213","2444280356976303910","deep","173"),
("214","214","2467934911016873336","deep","173"),
("215","215","2499370075832635613","deep","173"),
("216","216","2572625277699881400","deep","173"),
("217","217","2667938300259236644","deep","173"),
("218","218","2691592854299806070","deep","173"),
("219","219","2713545078126196839","deep","173"),
("220","220","2723028019115568347","deep","173"),
("221","221","2891596243542169378","deep","173"),
("222","222","2906462662990444836","deep","173"),
("223","223","2937203021409129573","deep","173"),
("224","224","2946685962398501081","deep","173"),
("225","225","2984512129490268425","deep","173"),
("226","226","2999378548938543883","deep","173"),
("227","227","3130120606273377570","deep","173"),
("228","228","3170343905681433815","deep","173"),
("229","229","3208170077068168455","deep","173"),
("230","230","3215950687843361306","deep","173"),
("231","231","3223036492221476617","deep","173"),
("232","232","3353778549556310304","deep","173"),
("233","233","3394001848964366549","deep","173"),
("234","234","3431828020351101189","deep","173"),
("235","235","3432522822453211433","deep","173"),
("236","236","3493308741483437959","deep","173"),
("237","237","3577436492839243038","deep","173"),
("238","238","3655485963634033923","deep","173"),
("239","239","3656180765736144167","deep","173"),
("240","240","3716966684766370693","deep","173"),
("241","241","3754792851858138037","deep","173"),
("242","242","3879838713314044197","deep","173"),
("243","243","3940624628049303427","deep","173"),
("244","244","3972059792865065704","deep","173"),
("245","245","4181546123096800520","deep","173"),
("246","246","4195717736147998438","deep","173"),
("247","247","4379152380022874927","deep","173"),
("248","248","4419375683725898468","deep","173"),
("249","249","4602810323305807661","deep","173"),
("250","250","4633550686019459694","deep","173"),
("251","251","4826468266588740395","deep","173"),
("252","252","4919384156831806738","deep","173"),
("253","253","9745953412156149690","deep","173"),
("254","254","9838869298104248737","deep","173"),
("255","255","9931785184052347784","deep","173"),
("0","0","11704602615017090582","deep","174"),
("1","1","11891423488033709510","deep","174"),
("2","2","12078244361050328438","deep","174"),
("3","3","12265065234066947366","deep","174"),
("4","4","13162332524588760904","deep","174"),
("5","5","2530111538073739899","deep","174"),
("6","6","2753769481356672633","deep","174"),
("7","7","2977427424639605367","deep","174"),
("8","8","3201085367922538101","deep","174"),
("9","9","3424743311205470835","deep","174"),
("10","10","3648401254488403569","deep","174"),
("11","11","3872059197771336303","deep","174"),
("12","12","4095717141054269037","deep","174"),
("0","0","10816362939393849670","deep","175"),
("1","1","10909278829636916013","deep","175"),
("2","2","11003183812410468598","deep","175"),
("3","3","11096099702653534941","deep","175"),
("4","4","11188026491776180450","deep","175"),
("5","5","11190004685427087526","deep","175"),
("6","6","11282920575670153869","deep","175"),
("7","7","11373858267967345840","deep","175"),
("8","8","11374847364792799378","deep","175"),
("9","9","11469741444391805501","deep","175"),
("10","10","11560679140983964768","deep","175"),
("11","11","11597516211250278574","deep","175"),
("12","12","11656562317408424429","deep","175"),
("13","13","11747500014000583696","deep","175"),
("14","14","11784337084266897502","deep","175"),
("15","15","11843383190425043357","deep","175"),
("16","16","11934320887017202624","deep","175"),
("17","17","11971157957283516430","deep","175"),
("18","18","12030204063441662285","deep","175"),
("19","19","12121141760033821552","deep","175"),
("20","20","12157978830300135358","deep","175"),
("21","21","12217024936458281213","deep","175"),
("22","22","12307962633050440480","deep","175"),
("23","23","12344799703316754286","deep","175"),
("24","24","12403845809474900141","deep","175"),
("25","25","12494783501772092112","deep","175"),
("26","26","12531620576333373214","deep","175"),
("27","27","12590666682491519069","deep","175"),
("28","28","12605626489952278838","deep","175"),
("29","29","12681604374788711040","deep","175"),
("30","30","12718441449349992142","deep","175"),
("31","31","12792447362968897766","deep","175"),
("32","32","12868425247805329968","deep","175"),
("33","33","12979268235985516694","deep","175"),
("34","34","13055246120821948896","deep","175"),
("35","35","13293863875860608695","deep","175"),
("36","36","13480684748877227623","deep","175"),
("37","37","13481673841407713865","deep","175"),
("38","38","13667505617598879255","deep","175"),
("39","39","13668494714424332793","deep","175"),
("40","40","13854326490615498183","deep","175"),
("41","41","13855315587440951721","deep","175"),
("42","42","14041147363632117111","deep","175"),
("43","43","14042136460457570649","deep","175"),
("44","44","14191131166382422233","deep","175"),
("45","45","14227968236648736039","deep","175"),
("46","46","14228957333474189577","deep","175"),
("47","47","14312809221393266237","deep","175"),
("48","48","14377952039399041161","deep","175"),
("49","49","14414789109665354967","deep","175"),
("50","50","14415778206490808505","deep","175"),
("51","51","14499630094409885165","deep","175"),
("52","52","14564772912415660089","deep","175"),
("53","53","14601609982681973895","deep","175"),
("54","54","14602599079507427433","deep","175"),
("55","55","14686450967426504093","deep","175"),
("56","56","14751593785432279017","deep","175"),
("57","57","14788430855698592823","deep","175"),
("58","58","14789419952524046361","deep","175"),
("59","59","14873271840443123021","deep","175"),
("60","60","14975251728715211751","deep","175"),
("61","61","15060092713459741949","deep","175"),
("62","62","15246913582181393581","deep","175"),
("63","63","2792291554372969770","deep","175"),
("64","64","3015949497655902504","deep","175"),
("65","65","3239607440938835238","deep","175"),
("66","66","3817665384839534393","deep","175"),
("67","67","4041323328122467127","deep","175"),
("68","68","4264981271405399861","deep","175"),
("69","69","4488639214688332595","deep","175"),
("70","70","4712297157971265329","deep","175"),
("0","0","10103448645774672015","deep","176"),
("1","1","10196364536017738358","deep","176"),
("2","2","11295115094597896964","deep","176"),
("3","3","11910999205590363463","deep","176"),
("4","4","12037747392965480984","deep","176"),
("5","5","12097820078606982391","deep","176"),
("6","6","12213401421770197326","deep","176"),
("7","7","12224568265982099912","deep","176"),
("8","8","12358315092156228931","deep","176"),
("9","9","12400222294786816254","deep","176"),
("10","10","12411389138998718840","deep","176"),
("11","11","12515803642244998485","deep","176"),
("12","12","12587043167803435182","deep","176"),
("13","13","12655315407180478561","deep","176"),
("14","14","12842136275902130193","deep","176"),
("15","15","13126285847786913455","deep","176"),
("16","16","13244540190998113006","deep","176"),
("17","17","13313106720803532383","deep","176"),
("18","18","13341412464248026205","deep","176"),
("19","19","13431361064014731934","deep","176"),
("20","20","13442403255694661397","deep","176"),
("21","21","13499927593820151311","deep","176"),
("22","22","13514756530610524755","deep","176"),
("23","23","13528233337264645133","deep","176"),
("24","24","13571129636720685994","deep","176"),
("25","25","13618181937031350862","deep","176"),
("26","26","13629224128711280325","deep","176"),
("27","27","13671131331341867648","deep","176"),
("28","28","13701577403627143683","deep","176"),
("29","29","13715054210281264061","deep","176"),
("30","30","13805002810047969790","deep","176"),
("31","31","13816045001727899253","deep","176"),
("32","32","13888398272348795315","deep","176"),
("33","33","13937723056738743257","deep","176"),
("34","34","13973533551816668807","deep","176"),
("35","35","2320627406896909589","deep","176"),
("36","36","3569659180646406946","deep","176"),
("37","37","3793317123929339680","deep","176"),
("38","38","4016975067212272414","deep","176"),
("39","39","4240633010495205148","deep","176"),
("40","40","4457899951502132815","deep","176"),
("41","41","4681557899080032845","deep","176"),
("42","42","9460123239926159405","deep","176"),
("43","43","9553039125874258452","deep","176"),
("0","0","11174450814014169066","deep","177"),
("1","1","11361271687030787994","deep","177"),
("2","2","11398108757297101800","deep","177"),
("3","3","11412280370348299718","deep","177"),
("4","4","11548092560047406922","deep","177"),
("5","5","11584929630313720728","deep","177"),
("6","6","11599101243364918646","deep","177"),
("7","7","11680850289396082403","deep","177"),
("8","8","11734913433064025850","deep","177"),
("9","9","11771750503330339656","deep","177"),
("10","10","11808587573596653462","deep","177"),
("11","11","11845424643862967268","deep","177"),
("12","12","11883250810954734612","deep","177"),
("13","13","11921734306080644778","deep","177"),
("14","14","11958571376346958584","deep","177"),
("15","15","11995408446613272390","deep","177"),
("16","16","12001505158460901459","deep","177"),
("17","17","12032245516879586196","deep","177"),
("18","18","12033234613705039734","deep","177"),
("19","19","12069082587145900002","deep","177"),
("20","20","12090302526212278513","deep","177"),
("21","21","12108555174802296410","deep","177"),
("22","22","12145392249363577512","deep","177"),
("23","23","12220055486721658662","deep","177"),
("24","24","12255903460162518930","deep","177"),
("25","25","12295376047818915338","deep","177"),
("26","26","12332213122380196440","deep","177"),
("27","27","12405887262912824052","deep","177"),
("28","28","12406876359738277590","deep","177"),
("29","29","12482196920835534266","deep","177"),
("30","30","12519033991101848072","deep","177"),
("31","31","12593697232754896518","deep","177"),
("32","32","12616400172627914420","deep","177"),
("33","33","12669017793852153194","deep","177"),
("34","34","12705854864118467000","deep","177"),
("35","35","12742691938679748102","deep","177"),
("36","36","12780518105771515446","deep","177"),
("37","37","12803221045644533348","deep","177"),
("38","38","12855838666868772122","deep","177"),
("39","39","12892675737135085928","deep","177"),
("40","40","12940059810532028808","deep","177"),
("41","41","12966349881962680836","deep","177"),
("42","42","12967338978788134374","deep","177"),
("43","43","12990041914366184980","deep","177"),
("44","44","13056630250520697281","deep","177"),
("45","45","13079496610151704856","deep","177"),
("46","46","13094456417612464625","deep","177"),
("47","47","13154159847509786006","deep","177"),
("48","48","13166353271205044144","deep","177"),
("49","49","13176862787382803908","deep","177"),
("50","50","13201543920906728886","deep","177"),
("51","51","13243451123537316209","deep","177"),
("52","52","13281277290629083553","deep","177"),
("53","53","13285928484327975245","deep","177"),
("54","54","13287374002476712622","deep","177"),
("55","55","13303154553434637590","deep","177"),
("56","56","13321738975110933499","deep","177"),
("57","57","13363683660399422836","deep","177"),
("58","58","13388364793923347814","deep","177"),
("59","59","13430271996553935137","deep","177"),
("60","60","13468098163645702481","deep","177"),
("61","61","13526812496717570324","deep","177"),
("62","62","13575185666939966742","deep","177"),
("63","63","13654919036662321409","deep","177"),
("64","64","13762006539956585670","deep","177"),
("65","65","13841739909678940337","deep","177"),
("66","66","13991723712429245459","deep","177"),
("67","67","14028560782695559265","deep","177"),
("68","68","14098811211428542424","deep","177"),
("69","69","14178544585445864387","deep","177"),
("70","70","14215381655712178193","deep","177"),
("71","71","14285632084445161352","deep","177"),
("72","72","14365365454167516019","deep","177"),
("73","73","14402202528728797121","deep","177"),
("74","74","14472452957461780280","deep","177"),
("75","75","14552186327184134947","deep","177"),
("76","76","14589023401745416049","deep","177"),
("77","77","14659273830478399208","deep","177"),
("78","78","14775844270467067681","deep","177"),
("79","79","2373220022801609132","deep","177"),
("80","80","2496876271463360212","deep","177"),
("81","81","2709454540408461469","deep","177"),
("82","82","2785801680989073697","deep","177"),
("83","83","2821230715764552140","deep","177"),
("84","84","2933112483691394203","deep","177"),
("85","85","3044888659047484874","deep","177"),
("86","86","3156770426974326937","deep","177"),
("87","87","3222939824463457413","deep","177"),
("88","88","3268546602330417608","deep","177"),
("89","89","3380428370257259671","deep","177"),
("90","90","3392202850992168688","deep","177"),
("91","91","3456775510837871899","deep","177"),
("92","92","3492204545613350342","deep","177"),
("93","93","3604086313540192405","deep","177"),
("94","94","3615165992172991178","deep","177"),
("95","95","3680433454120804633","deep","177"),
("96","96","3715862488896283076","deep","177"),
("97","97","3770257405650504535","deep","177"),
("98","98","3827744256823125139","deep","177"),
("99","99","3939520436474183106","deep","177"),
("100","100","4051402204401025169","deep","177"),
("101","101","4070262489514049497","deep","177"),
("102","102","4127749344981637397","deep","177"),
("103","103","4249008461327099576","deep","177"),
("104","104","4258491398021503788","deep","177"),
("105","105","4275060147683957903","deep","177"),
("106","106","4293920432796982231","deep","177"),
("107","107","4362486962602401608","deep","177"),
("108","108","4472666404610032310","deep","177"),
("109","109","4482149341304436522","deep","177"),
("110","110","4517578376079914965","deep","177"),
("111","111","4696324347892965044","deep","177"),
("112","112","4741236323657814995","deep","177"),
("0","0","10018214499493874813","deep","178"),
("1","1","10111130389736941156","deep","178"),
("2","2","10204046275685040203","deep","178"),
("3","3","10296962165928106546","deep","178"),
("4","4","10318219587652387071","deep","178"),
("5","5","10339477005081700300","deep","178"),
("6","6","10411135473600486118","deep","178"),
("7","7","10432392895324766643","deep","178"),
("8","8","10504051359548585165","deep","178"),
("9","9","10525308781272865690","deep","178"),
("10","10","10596967249791651508","deep","178"),
("11","11","10618224671515932033","deep","178"),
("12","12","10711140557464031080","deep","178"),
("13","13","10804056447707097423","deep","178"),
("14","14","10896693348227810420","deep","178"),
("15","15","10896972333655196470","deep","178"),
("16","16","10940616222872239537","deep","178"),
("17","17","11026446304442223273","deep","178"),
("18","18","11083514216949462052","deep","178"),
("19","19","11088621831971637583","deep","178"),
("20","20","11095707640644720190","deep","178"),
("21","21","11109879253695918108","deep","178"),
("22","22","11127437095888858465","deep","178"),
("23","23","11133533807736487534","deep","178"),
("24","24","11202795139644017155","deep","178"),
("25","25","11212278080633388663","deep","178"),
("26","26","11213267177458842201","deep","178"),
("27","27","11214256274284295739","deep","178"),
("28","28","11226449693684586581","deep","178"),
("29","29","11233535502357669188","deep","178"),
("30","30","11270335089966080980","deep","178"),
("31","31","11275442704988256511","deep","178"),
("32","32","11296700126712537036","deep","178"),
("33","33","11305193970876455006","deep","178"),
("34","34","11314257968905477393","deep","178"),
("35","35","11320354680753106462","deep","178"),
("36","36","11344009234793675888","deep","178"),
("37","37","11357191751019420268","deep","178"),
("38","38","11360283689732786709","deep","178"),
("39","39","11389616012660636083","deep","178"),
("40","40","11400088050475461129","deep","178"),
("41","41","11401077147300914667","deep","178"),
("42","42","11405195665497636660","deep","178"),
("43","43","11413270566701205509","deep","178"),
("44","44","11420356375374288116","deep","178"),
("45","45","11435936023916321397","deep","178"),
("46","46","11457155962982699908","deep","178"),
("47","47","11457193445640601922","deep","178"),
("48","48","11464279254313684529","deep","178"),
("49","49","11473762191008088741","deep","178"),
("50","50","11483520999729155964","deep","178"),
("51","51","11492014843893073934","deep","178"),
("52","52","11493003936423560176","deep","178"),
("53","53","11498111551445735707","deep","178"),
("54","54","11501078841922096321","deep","178"),
("55","55","11507175553769725390","deep","178"),
("56","56","11519368973170016232","deep","178"),
("57","57","11528851914159387740","deep","178"),
("58","58","11530830107810294816","deep","178"),
("59","59","11537915912188410127","deep","178"),
("60","60","11543023527210585658","deep","178"),
("61","61","11544012624036039196","deep","178"),
("62","62","11547104562749405637","deep","178"),
("63","63","11549082756400312713","deep","178"),
("64","64","11553201270302067410","deep","178"),
("65","65","11557195140261783576","deep","178"),
("66","66","11563254369451510631","deep","178"),
("67","67","11575447788851801473","deep","178"),
("68","68","11576436885677255011","deep","178"),
("69","69","11580849694302353002","deep","178"),
("70","70","11583941633015719443","deep","178"),
("71","71","11586908923492080057","deep","178"),
("72","72","11592016538514255588","deep","178"),
("73","73","11605199054739999968","deep","178"),
("74","74","11607177248390907044","deep","178"),
("75","75","11611590057016005035","deep","178"),
("76","76","11622756896932940325","deep","178"),
("77","77","11643976835999318836","deep","178"),
("78","78","11644014318657220850","deep","178"),
("79","79","11650111030504849919","deep","178"),
("80","80","11651100127330303457","deep","178"),
("81","81","11659593967199254131","deep","178"),
("82","82","11660288773596331671","deep","178"),
("83","83","11660583064024707669","deep","178"),
("84","84","11667374582269414278","deep","178"),
("85","85","11670341872745774892","deep","178"),
("86","86","11674754681370872883","deep","178"),
("87","87","11678835712614725566","deep","178"),
("88","88","11679824809440179104","deep","178"),
("89","89","11684932424462354635","deep","178"),
("90","90","11687899714938715249","deep","178"),
("91","91","11693996426786344318","deep","178"),
("92","92","11698114940688099015","deep","178"),
("93","93","11706189846186635160","deep","178"),
("94","94","11715672787176006668","deep","178"),
("95","95","11717650980826913744","deep","178"),
("96","96","11722758591554121979","deep","178"),
("97","97","11724736785205029055","deep","178"),
("98","98","11729844400227204586","deep","178"),
("99","99","11730833497052658124","deep","178"),
("100","100","11733925435766024565","deep","178"),
("101","101","11735903629416931641","deep","178"),
("102","102","11740022143318686338","deep","178"),
("103","103","11743026916452948966","deep","178"),
("104","104","11744016013278402504","deep","178"),
("105","105","11750075242468129559","deep","178"),
("106","106","11752509857442320474","deep","178"),
("107","107","11762268661868420401","deep","178"),
("108","108","11763257758693873939","deep","178"),
("109","109","11766681470493518392","deep","178"),
("110","110","11767670567318971930","deep","178"),
("111","111","11773729796508698985","deep","178"),
("112","112","11773767279166600999","deep","178"),
("113","113","11778837407235907220","deep","178"),
("114","114","11793998121407525972","deep","178"),
("115","115","11798116635309280669","deep","178"),
("116","116","11798410930032623963","deep","178"),
("117","117","11809577769949559253","deep","178"),
("118","118","11828162191625855162","deep","178"),
("119","119","11829846094848386240","deep","178"),
("120","120","11830797709015937764","deep","178"),
("121","121","11830835191673839778","deep","178"),
("122","122","11835248000298937769","deep","178"),
("123","123","11836931903521468847","deep","178"),
("124","124","11837920996051955089","deep","178"),
("125","125","11846414840215873059","deep","178"),
("126","126","11847109646612950599","deep","178"),
("127","127","11847403937041326597","deep","178"),
("128","128","11852511552063502128","deep","178"),
("129","129","11853206358460579668","deep","178"),
("130","130","11861575550092524515","deep","178"),
("131","131","11865656585631344494","deep","178"),
("132","132","11866645682456798032","deep","178"),
("133","133","11866683165114700046","deep","178"),
("134","134","11871753297478973563","deep","178"),
("135","135","11872742394304427101","deep","178"),
("136","136","11874720587955334177","deep","178"),
("137","137","11880817295507995950","deep","178"),
("138","138","11884935813704717943","deep","178"),
("139","139","11891032525552347012","deep","178"),
("140","140","11893010719203254088","deep","178"),
("141","141","11900515466541718520","deep","178"),
("142","142","11902493660192625596","deep","178"),
("143","143","11904471849548565376","deep","178"),
("144","144","11909579464570740907","deep","178"),
("145","145","11911557658221647983","deep","178"),
("146","146","11916665273243823514","deep","178"),
("147","147","11917654370069277052","deep","178"),
("148","148","11920746308782643493","deep","178"),
("149","149","11921078081868921505","deep","178"),
("150","150","11921772883971031749","deep","178"),
("151","151","11922724498138583273","deep","178"),
("152","152","11923751077621938825","deep","178"),
("153","153","11926843016335305266","deep","178"),
("154","154","11928821209986212342","deep","178"),
("155","155","11928858692644114356","deep","178"),
("156","156","11929847789469567894","deep","178"),
("157","157","11930836886295021432","deep","178"),
("158","158","11935249694920119423","deep","178"),
("159","159","11936896115484748487","deep","178"),
("160","160","11938341633633485864","deep","178"),
("161","161","11939330730458939402","deep","178"),
("162","162","11942003726211956722","deep","178"),
("163","163","11947111341234132253","deep","178"),
("164","164","11949089534885039329","deep","178"),
("165","165","11950078631710492867","deep","178"),
("166","166","11953502343510137320","deep","178"),
("167","167","11954491440335590858","deep","178"),
("168","168","11959599055357766389","deep","178"),
("169","169","11960550669525317913","deep","178"),
("170","170","11960588152183219927","deep","178"),
("171","171","11976862607122330748","deep","178"),
("172","172","11980818994424144900","deep","178"),
("173","173","11983253609398335815","deep","178"),
("174","174","11983948411500446059","deep","178"),
("175","175","11985231798754275595","deep","178"),
("176","176","11990339413776451126","deep","178"),
("177","177","11994420449315271105","deep","178"),
("178","178","11996398642966178181","deep","178"),
("179","179","11997425222449533733","deep","178"),
("180","180","12000517161162900174","deep","178"),
("181","181","12004511026827649044","deep","178"),
("182","182","12014983064642474090","deep","178"),
("183","183","12015677871039551630","deep","178"),
("184","184","12016666967865005168","deep","178"),
("185","185","12017618582032556692","deep","178"),
("186","186","12017656064690458706","deep","178"),
("187","187","12022068873315556697","deep","178"),
("188","188","12023752772243120479","deep","178"),
("189","189","12024741869068574017","deep","178"),
("190","190","12033930519629569527","deep","178"),
("191","191","12039332425080121056","deep","178"),
("192","192","12040027231477198596","deep","178"),
("193","193","12048396423109143443","deep","178"),
("194","194","12051820134908787896","deep","178"),
("195","195","12052477458647963422","deep","178"),
("196","196","12052514941305865436","deep","178"),
("197","197","12053466555473416960","deep","178"),
("198","198","12058574170495592491","deep","178"),
("199","199","12058905943581870503","deep","178"),
("200","200","12059563267321046029","deep","178"),
("201","201","12059600749978948043","deep","178"),
("202","202","12061541460971953105","deep","178"),
("203","203","12067638168524614878","deep","178"),
("204","204","12071756686721336871","deep","178"),
("205","205","12076169495346434862","deep","178"),
("206","206","12077853398568965940","deep","178"),
("207","207","12079831592219873016","deep","178"),
("208","208","12087336335263370152","deep","178"),
("209","209","12089314528914277228","deep","178"),
("210","210","12090341108397632780","deep","178"),
("211","211","12091292722565184304","deep","178"),
("212","212","12096400337587359835","deep","178"),
("213","213","12098378531238266911","deep","178"),
("214","214","12103486146260442442","deep","178"),
("215","215","12104475243085895980","deep","178"),
("216","216","12107567177504295125","deep","178"),
("217","217","12107898954885540433","deep","178"),
("218","218","12108593756987650677","deep","178"),
("219","219","12109545371155202201","deep","178"),
("220","220","12110534467980655739","deep","178"),
("221","221","12110571950638557753","deep","178"),
("222","222","12113663889351924194","deep","178"),
("223","223","12114690468835279746","deep","178"),
("224","224","12115642083002831270","deep","178"),
("225","225","12115679565660733284","deep","178"),
("226","226","12117657759311640360","deep","178"),
("227","227","12121081471111284813","deep","178"),
("228","228","12122070567936738351","deep","178"),
("229","229","12123716988501367415","deep","178"),
("230","230","12124173409824651254","deep","178"),
("231","231","12125162506650104792","deep","178"),
("232","232","12126151603475558330","deep","178"),
("233","233","12128824599228575650","deep","178"),
("234","234","12133932214250751181","deep","178"),
("235","235","12135910407901658257","deep","178"),
("236","236","12136899504727111795","deep","178"),
("237","237","12140323216526756248","deep","178"),
("238","238","12141312313352209786","deep","178"),
("239","239","12146382445716483303","deep","178"),
("240","240","12146419924079418021","deep","178"),
("241","241","12147409020904871559","deep","178"),
("242","242","12152516635927047090","deep","178"),
("243","243","12158907638203052157","deep","178"),
("244","244","12163683480138949676","deep","178"),
("245","245","12167639863145796532","deep","178"),
("246","246","12170074478119987447","deep","178"),
("247","247","12170769284517064987","deep","178"),
("248","248","12172052671770894523","deep","178"),
("249","249","12177160286793070054","deep","178"),
("250","250","12181241322331890033","deep","178"),
("251","251","12183219515982797109","deep","178"),
("252","252","12184246095466152661","deep","178"),
("253","253","12187338034179519102","deep","178"),
("254","254","12188327131004972640","deep","178"),
("255","255","12191331899844267972","deep","178"),
("256","256","12201803937659093018","deep","178"),
("257","257","12202498744056170558","deep","178"),
("258","258","12203487840881624096","deep","178"),
("259","259","12204476937707077634","deep","178"),
("260","260","12206911552681268549","deep","178"),
("261","261","12208889746332175625","deep","178"),
("262","262","12220751392646188455","deep","178"),
("263","263","12221045683074564453","deep","178"),
("264","264","12224175104445832908","deep","178"),
("265","265","12226153298096739984","deep","178"),
("266","266","12226848100198850228","deep","178"),
("267","267","12235217296125762371","deep","178"),
("268","268","12238346717497030826","deep","178"),
("269","269","12238641007925406824","deep","178"),
("270","270","12239298331664582350","deep","178"),
("271","271","12240287428490035888","deep","178"),
("272","272","12245395043512211419","deep","178"),
("273","273","12245432526170113433","deep","178"),
("274","274","12245726816598489431","deep","178"),
("275","275","12246384140337664957","deep","178"),
("276","276","12248362333988572033","deep","178"),
("277","277","12251823524151151204","deep","178"),
("278","278","12254459041541233806","deep","178"),
("279","279","12254915462864517645","deep","178"),
("280","280","12257882753340878259","deep","178"),
("281","281","12258577559737955799","deep","178"),
("282","282","12258909332824233811","deep","178"),
("283","283","12262990368363053790","deep","178"),
("284","284","12264674271585584868","deep","178"),
("285","285","12266652465236491944","deep","178"),
("286","286","12272054366392076177","deep","178"),
("287","287","12274157208279989080","deep","178"),
("288","288","12276135401930896156","deep","178"),
("289","289","12278113595581803232","deep","178"),
("290","290","12283221210603978763","deep","178"),
("291","291","12285199404254885839","deep","178"),
("292","292","12290307014982094074","deep","178"),
("293","293","12291296111807547612","deep","178"),
("294","294","12294388050520914053","deep","178"),
("295","295","12295414630004269605","deep","178"),
("296","296","12296366244171821129","deep","178"),
("297","297","12297355340997274667","deep","178"),
("298","298","12297392823655176681","deep","178"),
("299","299","12300484762368543122","deep","178"),
("300","300","12301511341851898674","deep","178"),
("301","301","12302462956019450198","deep","178"),
("302","302","12302500438677352212","deep","178"),
("303","303","12304478632328259288","deep","178"),
("304","304","12307902344127903741","deep","178"),
("305","305","12308891440953357279","deep","178"),
("306","306","12310537857223019047","deep","178"),
("307","307","12310994282841270182","deep","178"),
("308","308","12311983379666723720","deep","178"),
("309","309","12312972476492177258","deep","178"),
("310","310","12315645472245194578","deep","178"),
("311","311","12320753087267370109","deep","178"),
("312","312","12322731280918277185","deep","178"),
("313","313","12323720377743730723","deep","178"),
("314","314","12327144089543375176","deep","178"),
("315","315","12328133186368828714","deep","178"),
("316","316","12333203314438134935","deep","178"),
("317","317","12333240797096036949","deep","178"),
("318","318","12334229893921490487","deep","178"),
("319","319","12344739414394217547","deep","178"),
("320","320","12345728511219671085","deep","178"),
("321","321","12350504353155568604","deep","178"),
("322","322","12354460736162415460","deep","178"),
("323","323","12356895351136606375","deep","178"),
("324","324","12357590157533683915","deep","178"),
("325","325","12358873544787513451","deep","178"),
("326","326","12361546544835498067","deep","178"),
("327","327","12363981159809688982","deep","178"),
("328","328","12368062195348508961","deep","178"),
("329","329","12370040388999416037","deep","178"),
("330","330","12371029485824869575","deep","178"),
("331","331","12371066968482771589","deep","178"),
("332","332","12374158902901170734","deep","178"),
("333","333","12375147999726624272","deep","178"),
("334","334","12376174579209979824","deep","178"),
("335","335","12378152772860886900","deep","178"),
("336","336","12385657520199351332","deep","178"),
("337","337","12388624810675711946","deep","178"),
("338","338","12389319617072789486","deep","178"),
("339","339","12390308713898243024","deep","178"),
("340","340","12391297810723696562","deep","178"),
("341","341","12393732425697887477","deep","178"),
("342","342","12395416324625451259","deep","178"),
("343","343","12395710615053827257","deep","178"),
("344","344","12399829133250549250","deep","178"),
("345","345","12407572265662807383","deep","178"),
("346","346","12407866556091183381","deep","178"),
("347","347","12410995977462451836","deep","178"),
("348","348","12412974171113358912","deep","178"),
("349","349","12413668973215469156","deep","178"),
("350","350","12414989843127200706","deep","178"),
("351","351","12422038169142381299","deep","178"),
("352","352","12425461880942025752","deep","178"),
("353","353","12426119204681201278","deep","178"),
("354","354","12426156687339103292","deep","178"),
("355","355","12427108301506654816","deep","178"),
("356","356","12432215916528830347","deep","178"),
("357","357","12432253394891765065","deep","178"),
("358","358","12432547689615108359","deep","178"),
("359","359","12433205013354283885","deep","178"),
("360","360","12437655300342316594","deep","178"),
("361","361","12438644397167770132","deep","178"),
("362","362","12441279914557852734","deep","178"),
("363","363","12441736335881136573","deep","178"),
("364","364","12444703626357497187","deep","178"),
("365","365","12445398432754574727","deep","178"),
("366","366","12445730205840852739","deep","178"),
("367","367","12449811241379672718","deep","178"),
("368","368","12451495144602203796","deep","178"),
("369","369","12452484237132690038","deep","178"),
("370","370","12453473333958143576","deep","178"),
("371","371","12458875239408695105","deep","178"),
("372","372","12460978081296608008","deep","178"),
("373","373","12462004660779963560","deep","178"),
("374","374","12464934468598422160","deep","178"),
("375","375","12470042083620597691","deep","178"),
("376","376","12472020277271504767","deep","178"),
("377","377","12477127887998713002","deep","178"),
("378","378","12478116984824166540","deep","178"),
("379","379","12479562502972903917","deep","178"),
("380","380","12481208923537532981","deep","178"),
("381","381","12482235503020888533","deep","178"),
("382","382","12483187117188440057","deep","178"),
("383","383","12484176214013893595","deep","178"),
("384","384","12484213696671795609","deep","178"),
("385","385","12487305635385162050","deep","178"),
("386","386","12489283829036069126","deep","178"),
("387","387","12491299505344878216","deep","178"),
("388","388","12494723217144522669","deep","178"),
("389","389","12495712313969976207","deep","178"),
("390","390","12497358730239637975","deep","178"),
("391","391","12497815151562921814","deep","178"),
("392","392","12498804248388375352","deep","178"),
("393","393","12499136025769620660","deep","178"),
("394","394","12499793345213828890","deep","178"),
("395","395","12499830827871730904","deep","178"),
("396","396","12502466345261813506","deep","178"),
("397","397","12506221830147735971","deep","178"),
("398","398","12506916636544813511","deep","178"),
("399","399","12507573960283989037","deep","178"),
("400","400","12508563057109442575","deep","178"),
("401","401","12509552153934896113","deep","178"),
("402","402","12510541250760349651","deep","178"),
("403","403","12513964962559994104","deep","178"),
("404","404","12520024187454753863","deep","178"),
("405","405","12520061670112655877","deep","178"),
("406","406","12521050766938109415","deep","178"),
("407","407","12537656994963498248","deep","178"),
("408","408","12538608613426017068","deep","178"),
("409","409","12543716224153225303","deep","178"),
("410","410","12544411030550302843","deep","178"),
("411","411","12544742803636580855","deep","178"),
("412","412","12545694417804132379","deep","178"),
("413","413","12548367417852116995","deep","178"),
("414","414","12550802032826307910","deep","178"),
("415","415","12554225744625952363","deep","178"),
("416","416","12554883068365127889","deep","178"),
("417","417","12555214841451405901","deep","178"),
("418","418","12556861262016034965","deep","178"),
("419","419","12557850358841488503","deep","178"),
("420","420","12557887837204423221","deep","178"),
("421","421","12560979775917789662","deep","178"),
("422","422","12561968872743243200","deep","178"),
("423","423","12562006355401145214","deep","178"),
("424","424","12562995452226598752","deep","178"),
("425","425","12564973645877505828","deep","178"),
("426","426","12571489296390516722","deep","178"),
("427","427","12572478393215970260","deep","178"),
("428","428","12575483166350232888","deep","178"),
("429","429","12576140490089408414","deep","178"),
("430","430","12577129582619894656","deep","178"),
("431","431","12578118679445348194","deep","178"),
("432","432","12578575105063599329","deep","178"),
("433","433","12580553294419539109","deep","178"),
("434","434","12582237197642070187","deep","178"),
("435","435","12582531488070446185","deep","178"),
("436","436","12583226294467523725","deep","178"),
("437","437","12586650006267168178","deep","178"),
("438","438","12592051911717719707","deep","178"),
("439","439","12592746718114797247","deep","178"),
("440","440","12594393138679426311","deep","178"),
("441","441","12594687429107802309","deep","178"),
("442","442","12597816850479070764","deep","178"),
("443","443","12599795039835010544","deep","178"),
("444","444","12599832522492912558","deep","178"),
("445","445","12601810716143819634","deep","178"),
("446","446","12603457136708448698","deep","178"),
("447","447","12608859042159000227","deep","178"),
("448","448","12612282753958644680","deep","178"),
("449","449","12612940077697820206","deep","178"),
("450","450","12612977560355722220","deep","178"),
("451","451","12613929174523273744","deep","178"),
("452","452","12617390368980820211","deep","178"),
("453","453","12618085171082930455","deep","178"),
("454","454","12619036785250481979","deep","178"),
("455","455","12619074267908383993","deep","178"),
("456","456","12619368562631727287","deep","178"),
("457","457","12620025882075935517","deep","178"),
("458","458","12623487076533481984","deep","178"),
("459","459","12624476173358935522","deep","178"),
("460","460","12625465270184389060","deep","178"),
("461","461","12627111690749018124","deep","178"),
("462","462","12628100787574471662","deep","178"),
("463","463","12628557208897755501","deep","178"),
("464","464","12631524499374116115","deep","178"),
("465","465","12632219305771193655","deep","178"),
("466","466","12632551078857471667","deep","178"),
("467","467","12636632114396291646","deep","178"),
("468","468","12638316013323855428","deep","178"),
("469","469","12639305110149308966","deep","178"),
("470","470","12640294206974762504","deep","178"),
("471","471","12645696112425314033","deep","178"),
("472","472","12647141630574051410","deep","178"),
("473","473","12647798954313226936","deep","178"),
("474","474","12648788051138680474","deep","178"),
("475","475","12651755341615041088","deep","178"),
("476","476","12656862956637216619","deep","178"),
("477","477","12658841150288123695","deep","178"),
("478","478","12661313243625249328","deep","178"),
("479","479","12663948761015331930","deep","178"),
("480","480","12666383375989522845","deep","178"),
("481","481","12668029796554151909","deep","178"),
("482","482","12668399052298331935","deep","178"),
("483","483","12669056376037507461","deep","178"),
("484","484","12670007990205058985","deep","178"),
("485","485","12671034569688414537","deep","178"),
("486","486","12672480087837151914","deep","178"),
("487","487","12674126508401780978","deep","178"),
("488","488","12676104702052688054","deep","178"),
("489","489","12678120374066529848","deep","178"),
("490","490","12682533182691627839","deep","178"),
("491","491","12684179603256256903","deep","178"),
("492","492","12684636024579540742","deep","178"),
("493","493","12685625121404994280","deep","178"),
("494","494","12685956894491272292","deep","178"),
("495","495","12686614218230447818","deep","178"),
("496","496","12686651700888349832","deep","178"),
("497","497","12687309024627525358","deep","178"),
("498","498","12689287218278432434","deep","178"),
("499","499","12692748412735978901","deep","178"),
("500","500","12693042703164354899","deep","178"),
("501","501","12693737509561432439","deep","178"),
("502","502","12694394833300607965","deep","178"),
("503","503","12695383930126061503","deep","178"),
("504","504","12696373026951515041","deep","178"),
("505","505","12697362123776968579","deep","178"),
("506","506","12700785831281645736","deep","178"),
("507","507","12703220450550803947","deep","178"),
("508","508","12706845060471372791","deep","178"),
("509","509","12706882543129274805","deep","178"),
("510","510","12707871639954728343","deep","178"),
("511","511","12714957448627810950","deep","178"),
("512","512","12722793969052553394","deep","178"),
("513","513","12723488771154663638","deep","178"),
("514","514","12724477867980117176","deep","178"),
("515","515","12725429482147668700","deep","178"),
("516","516","12728102482195653316","deep","178"),
("517","517","12730537097169844231","deep","178"),
("518","518","12731231903566921771","deep","178"),
("519","519","12731563676653199783","deep","178"),
("520","520","12732515290820751307","deep","178"),
("521","521","12734199194043282385","deep","178"),
("522","522","12735188290868735923","deep","178"),
("523","523","12737622905842926838","deep","178"),
("524","524","12740057520817117753","deep","178"),
("525","525","12741046617642571291","deep","178"),
("526","526","12741703941381746817","deep","178"),
("527","527","12742035714468024829","deep","178"),
("528","528","12743682130737686597","deep","178"),
("529","529","12744671227563140135","deep","178"),
("530","530","12747800648934408590","deep","178"),
("531","531","12748789745759862128","deep","178"),
("532","532","12748827228417764142","deep","178"),
("533","533","12749816325243217680","deep","178"),
("534","534","12758310169407135650","deep","178"),
("535","535","12761314942541398278","deep","178"),
("536","536","12761972261985606508","deep","178"),
("537","537","12762304039366851816","deep","178"),
("538","538","12762923880448125328","deep","178"),
("539","539","12762961358811060046","deep","178"),
("540","540","12763950455636513584","deep","178"),
("541","541","12765395973785250961","deep","178"),
("542","542","12767374167436158037","deep","178"),
("543","543","12768400746919513589","deep","178"),
("544","544","12769020588000787101","deep","178"),
("545","545","12769058070658689115","deep","178"),
("546","546","12769352361087065113","deep","178"),
("547","547","12770047167484142653","deep","178"),
("548","548","12778578494305962637","deep","178"),
("549","549","12778872784734338635","deep","178"),
("550","550","12781214007401077943","deep","178"),
("551","551","12781508302124421237","deep","178"),
("552","552","12784637719200722396","deep","178"),
("553","553","12784969496581967704","deep","178"),
("554","554","12786615912851629472","deep","178"),
("555","555","12786653395509531486","deep","178"),
("556","556","12788631589160438562","deep","178"),
("557","557","12790278009725067626","deep","178"),
("558","558","12795147239673449456","deep","178"),
("559","559","12795679915175619155","deep","178"),
("560","560","12796136336498902994","deep","178"),
("561","561","12799103626975263608","deep","178"),
("562","562","12799141109633165622","deep","178"),
("563","563","12799760950714439134","deep","178"),
("564","564","12799798433372341148","deep","178"),
("565","565","12800750047539892672","deep","178"),
("566","566","12802233048346532063","deep","178"),
("567","567","12804211241997439139","deep","178"),
("568","568","12804906044099549383","deep","178"),
("569","569","12805895140925002921","deep","178"),
("570","570","12806189431353378919","deep","178"),
("571","571","12806846755092554445","deep","178"),
("572","572","12810307949550100912","deep","178"),
("573","573","12811297046375554450","deep","178"),
("574","574","12813932563765637052","deep","178"),
("575","575","12814921660591090590","deep","178"),
("576","576","12815378081914374429","deep","178"),
("577","577","12815709855000652441","deep","178"),
("578","578","12818345372390735043","deep","178"),
("579","579","12818382855048637057","deep","178"),
("580","580","12819371951874090595","deep","178"),
("581","581","12823452987412910574","deep","178"),
("582","582","12823490465775845292","deep","178"),
("583","583","12825136886340474356","deep","178"),
("584","584","12826125983165927894","deep","178"),
("585","585","12827115079991381432","deep","178"),
("586","586","12828104176816834970","deep","178"),
("587","587","12832516985441932961","deep","178"),
("588","588","12832973406765216800","deep","178"),
("589","589","12833962503590670338","deep","178"),
("590","590","12834619827329845864","deep","178"),
("591","591","12835608924155299402","deep","178"),
("592","592","12835646406813201416","deep","178"),
("593","593","12838576214631660016","deep","178"),
("594","594","12840059215438299407","deep","178"),
("595","595","12843683829653835547","deep","178"),
("596","596","12848134116641868256","deep","178"),
("597","597","12849123213467321794","deep","178"),
("598","598","12850769634031950858","deep","178"),
("599","599","12851758730857404396","deep","178"),
("600","600","12853204249006141773","deep","178"),
("601","601","12854230828489497325","deep","178"),
("602","602","12854850669570770837","deep","178"),
("603","603","12855219925314950863","deep","178"),
("604","604","12855877249054126389","deep","178"),
("605","605","12857855442705033465","deep","178"),
("606","606","12858311864028317304","deep","178"),
("607","607","12859300960853770842","deep","178"),
("608","608","12860947381418399906","deep","178"),
("609","609","12861316637162579932","deep","178"),
("610","610","12862925575069306982","deep","178"),
("611","611","12868364958882793229","deep","178"),
("612","612","12869354055708246767","deep","178"),
("613","613","12871456897596159670","deep","178"),
("614","614","12872777767507891220","deep","178"),
("615","615","12873472573904968760","deep","178"),
("616","616","12874129897644144286","deep","178"),
("617","617","12876108091295051362","deep","178"),
("618","618","12878580188927144291","deep","178"),
("619","619","12879569285752597829","deep","178"),
("620","620","12880558382578051367","deep","178"),
("621","621","12881215706317226893","deep","178"),
("622","622","12882204803142680431","deep","178"),
("623","623","12883193895673166673","deep","178"),
("624","624","12884971191203149358","deep","178"),
("625","625","12887606704298264664","deep","178"),
("626","626","12890041319272455579","deep","178"),
("627","627","12893665933487991719","deep","178"),
("628","628","12893703416145893733","deep","178"),
("629","629","12894692512971347271","deep","178"),
("630","630","12895148934294631110","deep","178"),
("631","631","12901778321644429878","deep","178"),
("632","632","12909320547345829028","deep","178"),
("633","633","12909614837774205026","deep","178"),
("634","634","12910309644171282566","deep","178"),
("635","635","12911298740996736104","deep","178"),
("636","636","12912250355164287628","deep","178"),
("637","637","12914923355212272244","deep","178"),
("638","638","12917357970186463159","deep","178"),
("639","639","12918052776583540699","deep","178"),
("640","640","12918384549669818711","deep","178"),
("641","641","12919336163837370235","deep","178"),
("642","642","12921020067059901313","deep","178"),
("643","643","12922009163885354851","deep","178"),
("644","644","12924443778859545766","deep","178"),
("645","645","12925889297008283143","deep","178"),
("646","646","12927867490659190219","deep","178"),
("647","647","12928524810103398449","deep","178"),
("648","648","12928856587484643757","deep","178"),
("649","649","12929883162673032013","deep","178"),
("650","650","12930503003754305525","deep","178"),
("651","651","12931492100579759063","deep","178"),
("652","652","12932975101386398454","deep","178"),
("653","653","12934621521951027518","deep","178"),
("654","654","12935610618776481056","deep","178"),
("655","655","12935648101434383070","deep","178"),
("656","656","12936637198259836608","deep","178"),
("657","657","12948135811263049910","deep","178"),
("658","658","12948793135002225436","deep","178"),
("659","659","12949124908088503448","deep","178"),
("660","660","12949782231827678974","deep","178"),
("661","661","12950771328653132512","deep","178"),
("662","662","12952216846801869889","deep","178"),
("663","663","12954195040452776965","deep","178"),
("664","664","12954232523110678979","deep","178"),
("665","665","12955221619936132517","deep","178"),
("666","666","12955841461017406029","deep","178"),
("667","667","12955878943675308043","deep","178"),
("668","668","12956173234103684041","deep","178"),
("669","669","12956868040500761581","deep","178"),
("670","670","12960291752300406034","deep","178"),
("671","671","12962269945951313110","deep","178"),
("672","672","12963715464100050487","deep","178"),
("673","673","12965399367322581565","deep","178"),
("674","674","12965693657750957563","deep","178"),
("675","675","12968034880417696871","deep","178"),
("676","676","12968329175141040165","deep","178"),
("677","677","12970801268478165798","deep","178"),
("678","678","12971458592217341324","deep","178"),
("679","679","12973436785868248400","deep","178"),
("680","680","12973474268526150414","deep","178"),
("681","681","12975452462177057490","deep","178"),
("682","682","12977098882741686554","deep","178"),
("683","683","12981968112690068384","deep","178"),
("684","684","12982957209515521922","deep","178"),
("685","685","12985961982649784550","deep","178"),
("686","686","12986581823731058062","deep","178"),
("687","687","12986619306388960076","deep","178"),
("688","688","12989053921363150991","deep","178"),
("689","689","12991032110719090771","deep","178"),
("690","690","12991726917116168311","deep","178"),
("691","691","12992058690202446323","deep","178"),
("692","692","12992716013941621849","deep","178"),
("693","693","12993667628109173373","deep","178"),
("694","694","12997128822566719840","deep","178"),
("695","695","12998117919392173378","deep","178"),
("696","696","13000753436782255980","deep","178"),
("697","697","13001541631191817831","deep","178"),
("698","698","13002198954930993357","deep","178"),
("699","699","13002236437588895371","deep","178"),
("700","700","13002530728017271369","deep","178"),
("701","701","13005166245407353971","deep","178"),
("702","702","13005203728065255985","deep","178"),
("703","703","13010273856134562206","deep","178"),
("704","704","13010311338792464220","deep","178"),
("705","705","13011957759357093284","deep","178"),
("706","706","13012946856182546822","deep","178"),
("707","707","13013935953008000360","deep","178"),
("708","708","13014925049833453898","deep","178"),
("709","709","13016702341068469287","deep","178"),
("710","710","13018348761633098351","deep","178"),
("711","711","13019337858458551889","deep","178"),
("712","712","13019794279781835728","deep","178"),
("713","713","13020783376607289266","deep","178"),
("714","714","13021440700346464792","deep","178"),
("715","715","13022429797171918330","deep","178"),
("716","716","13022467279829820344","deep","178"),
("717","717","13023418893997371868","deep","178"),
("718","718","13026880088454918335","deep","178"),
("719","719","13030504698375487179","deep","178"),
("720","720","13034954989658487184","deep","178"),
("721","721","13035944086483940722","deep","178"),
("722","722","13037590507048569786","deep","178"),
("723","723","13038579603874023324","deep","178"),
("724","724","13040025122022760701","deep","178"),
("725","725","13040062604680662715","deep","178"),
("726","726","13041051701506116253","deep","178"),
("727","727","13041671542587389765","deep","178"),
("728","728","13042040798331569791","deep","178"),
("729","729","13042698122070745317","deep","178"),
("730","730","13043687218896198855","deep","178"),
("731","731","13044676315721652393","deep","178"),
("732","732","13045132737044936232","deep","178"),
("733","733","13046121833870389770","deep","178"),
("734","734","13048137510179198860","deep","178"),
("735","735","13049783926448860628","deep","178"),
("736","736","13055185831899412157","deep","178"),
("737","737","13056174928724865695","deep","178"),
("738","738","13058277770612778598","deep","178"),
("739","739","13059598640524510148","deep","178"),
("740","740","13060293446921587688","deep","178"),
("741","741","13060950770660763214","deep","178"),
("742","742","13062928964311670290","deep","178"),
("743","743","13065401061943763219","deep","178"),
("744","744","13067379255594670295","deep","178"),
("745","745","13068036575038878525","deep","178"),
("746","746","13069025671864332063","deep","178"),
("747","747","13069319966587675357","deep","178"),
("748","748","13070014768689785601","deep","178"),
("749","749","13071792059924800990","deep","178"),
("750","750","13074427577314883592","deep","178"),
("751","751","13076862192289074507","deep","178"),
("752","752","13077888771772430059","deep","178"),
("753","753","13081513385987966199","deep","178"),
("754","754","13081969807311250038","deep","178"),
("755","755","13085631904184688192","deep","178"),
("756","756","13088599190366081510","deep","178"),
("757","757","13095152323536994418","deep","178"),
("758","758","13096103937704545942","deep","178"),
("759","759","13096435710790823954","deep","178"),
("760","760","13098119614013355032","deep","178"),
("761","761","13099071228180906556","deep","178"),
("762","762","13101543325812999485","deep","178"),
("763","763","13102200649552175011","deep","178"),
("764","764","13102238132210077025","deep","178"),
("765","765","13104178843203082087","deep","178"),
("766","766","13104873649600159627","deep","178"),
("767","767","13105205422686437639","deep","178"),
("768","768","13106157036853989163","deep","178"),
("769","769","13107840940076520241","deep","178"),
("770","770","13108629134486082092","deep","178"),
("771","771","13111264647581197398","deep","178"),
("772","772","13112710170024902071","deep","178"),
("773","773","13114688359380841851","deep","178"),
("774","774","13115345683120017377","deep","178"),
("775","775","13115383165777919391","deep","178"),
("776","776","13115677456206295389","deep","178"),
("777","777","13116704035689650941","deep","178"),
("778","778","13117323876770924453","deep","178"),
("779","779","13118806877577563844","deep","178"),
("780","780","13119795974403017382","deep","178"),
("781","781","13121442394967646446","deep","178"),
("782","782","13122431491793099984","deep","178"),
("783","783","13122468974451001998","deep","178"),
("784","784","13122800747537280010","deep","178"),
("785","785","13131951915440373506","deep","178"),
("786","786","13132978490628761762","deep","178"),
("787","787","13134956684279668838","deep","178"),
("788","788","13135614008018844364","deep","178"),
("789","789","13136603104844297902","deep","178"),
("790","790","13137592201669751440","deep","178"),
("791","791","13140064299301844369","deep","178"),
("792","792","13141015913469395893","deep","178"),
("793","793","13141053396127297907","deep","178"),
("794","794","13142042492952751445","deep","178"),
("795","795","13142699816691926971","deep","178"),
("796","796","13142994107120302969","deep","178"),
("797","797","13143688913517380509","deep","178"),
("798","798","13147112625317024962","deep","178"),
("799","799","13149090818967932038","deep","178"),
("800","800","13149547240291215877","deep","178"),
("801","801","13150536337116669415","deep","178"),
("802","802","13152220236044233197","deep","178"),
("803","803","13152514530767576491","deep","178"),
("804","804","13155844850259769337","deep","178"),
("805","805","13157622141494784726","deep","178"),
("806","806","13158279465233960252","deep","178"),
("807","807","13160257658884867328","deep","178"),
("808","808","13160295141542769342","deep","178"),
("809","809","13161941562107398406","deep","178"),
("810","810","13162273335193676418","deep","178"),
("811","811","13169778082532140850","deep","178"),
("812","812","13172782855666403478","deep","178"),
("813","813","13173440175110611708","deep","178"),
("814","814","13175874790084802623","deep","178"),
("815","815","13177852983735709699","deep","178"),
("816","816","13177890466393611713","deep","178"),
("817","817","13178547790132787239","deep","178"),
("818","818","13178879563219065251","deep","178"),
("819","819","13179536886958240777","deep","178"),
("820","820","13183949695583338768","deep","178"),
("821","821","13184938792408792306","deep","178"),
("822","822","13188362504208436759","deep","178"),
("823","823","13189019827947612285","deep","178"),
("824","824","13189057310605514299","deep","178"),
("825","825","13189351601033890297","deep","178"),
("826","826","13191987118423972899","deep","178"),
("827","827","13192024601081874913","deep","178"),
("828","828","13197094729151181134","deep","178"),
("829","829","13197132211809083148","deep","178"),
("830","830","13198121308634536686","deep","178"),
("831","831","13198778632373712212","deep","178"),
("832","832","13199767729199165750","deep","178"),
("833","833","13200756826024619288","deep","178"),
("834","834","13203523214085088215","deep","178"),
("835","835","13205169634649717279","deep","178"),
("836","836","13206158731475170817","deep","178"),
("837","837","13206615152798454656","deep","178"),
("838","838","13207604249623908194","deep","178"),
("839","839","13208261573363083720","deep","178"),
("840","840","13208630829107263746","deep","178"),
("841","841","13209250670188537258","deep","178"),
("842","842","13209288152846439272","deep","178"),
("843","843","13210239767013990796","deep","178"),
("844","844","13213700961471537263","deep","178"),
("845","845","13216373957224554583","deep","178"),
("846","846","13217325571392106107","deep","178"),
("847","847","13221775862675106112","deep","178"),
("848","848","13222764959500559650","deep","178"),
("849","849","13224411380065188714","deep","178"),
("850","850","13226845995039379629","deep","178"),
("851","851","13226883477697281643","deep","178"),
("852","852","13227872574522735181","deep","178"),
("853","853","13228861671348188719","deep","178"),
("854","854","13229518995087364245","deep","178"),
("855","855","13230508091912817783","deep","178"),
("856","856","13231953610061555160","deep","178"),
("857","857","13232942706887008698","deep","178"),
("858","858","13234958378900850492","deep","178"),
("859","859","13236604799465479556","deep","178"),
("860","860","13237593896290933094","deep","178"),
("861","861","13242006704916031085","deep","178"),
("862","862","13242463126239314924","deep","178"),
("863","863","13242995801741484623","deep","178"),
("864","864","13245098643629397526","deep","178"),
("865","865","13246419513541129076","deep","178"),
("866","866","13247114319938206616","deep","178"),
("867","867","13247771643677382142","deep","178"),
("868","868","13249548934912397531","deep","178"),
("869","869","13250538031737851069","deep","178"),
("870","870","13252221934960382147","deep","178"),
("871","871","13254200124316321927","deep","178"),
("872","872","13254857448055497453","deep","178"),
("873","873","13255846544880950991","deep","178"),
("874","874","13258612932941419918","deep","178"),
("875","875","13261248450331502520","deep","178"),
("876","876","13263683065305693435","deep","178"),
("877","877","13263720547963595449","deep","178"),
("878","878","13264709644789048987","deep","178"),
("879","879","13268334259004585127","deep","178"),
("880","880","13268790680327868966","deep","178"),
("881","881","13270806356636678056","deep","178"),
("882","882","13272452777201307120","deep","178"),
("883","883","13275420063382700438","deep","178"),
("884","884","13281935713895711332","deep","178"),
("885","885","13281973196553613346","deep","178"),
("886","886","13282924810721164870","deep","178"),
("887","887","13282962293379066884","deep","178"),
("888","888","13283256583807442882","deep","178"),
("889","889","13284940487029973960","deep","178"),
("890","890","13285892101197525484","deep","178"),
("891","891","13288364198829618413","deep","178"),
("892","892","13289021522568793939","deep","178"),
("893","893","13289059005226695953","deep","178"),
("894","894","13290342392480525489","deep","178"),
("895","895","13292026295703056567","deep","178"),
("896","896","13292977909870608091","deep","178"),
("897","897","13295450007502701020","deep","178"),
("898","898","13297096423772362788","deep","178"),
("899","899","13298085520597816326","deep","178"),
("900","900","13299531038746553703","deep","178"),
("901","901","13301509232397460779","deep","178"),
("902","902","13301546715055362793","deep","178"),
("903","903","13302166556136636305","deep","178"),
("904","904","13302204038794538319","deep","178"),
("905","905","13302498329222914317","deep","178"),
("906","906","13303193135619991857","deep","178"),
("907","907","13303524908706269869","deep","178"),
("908","908","13305627750594182772","deep","178"),
("909","909","13306616847419636310","deep","178"),
("910","910","13308595041070543386","deep","178"),
("911","911","13308632523728445400","deep","178"),
("912","912","13309252364809718912","deep","178"),
("913","913","13309621620553898938","deep","178"),
("914","914","13318772784162025138","deep","178"),
("915","915","13318810266819927152","deep","178"),
("916","916","13322434881035463292","deep","178"),
("917","917","13322766654121741304","deep","178"),
("918","918","13323423977860916830","deep","178"),
("919","919","13324413074686370368","deep","178"),
("920","920","13325896075493009759","deep","178"),
("921","921","13326885172318463297","deep","178"),
("922","922","13327836786486014821","deep","178"),
("923","923","13327874269143916835","deep","178"),
("924","924","13328863365969370373","deep","178"),
("925","925","13329520689708545899","deep","178"),
("926","926","13329814980136921897","deep","178"),
("927","927","13330509786533999437","deep","178"),
("928","928","13333933498333643890","deep","178"),
("929","929","13335911691984550966","deep","178"),
("930","930","13336368113307834805","deep","178"),
("931","931","13337357210133288343","deep","178"),
("932","932","13339041109060852125","deep","178"),
("933","933","13339335403784195419","deep","178"),
("934","934","13344443014511403654","deep","178"),
("935","935","13345100338250579180","deep","178"),
("936","936","13347078531901486256","deep","178"),
("937","937","13347116014559388270","deep","178"),
("938","938","13348762435124017334","deep","178"),
("939","939","13349094208210295346","deep","178"),
("940","940","13356598955548759778","deep","178"),
("941","941","13356636438206661792","deep","178"),
("942","942","13359603724388055110","deep","178"),
("943","943","13360261048127230636","deep","178"),
("944","944","13362695663101421551","deep","178"),
("945","945","13363722242584777103","deep","178"),
("946","946","13364673856752328627","deep","178"),
("947","947","13364711339410230641","deep","178"),
("948","948","13365368663149406167","deep","178"),
("949","949","13366357759974859705","deep","178"),
("950","950","13370770568599957696","deep","178"),
("951","951","13371759665425411234","deep","178"),
("952","952","13375183377225055687","deep","178"),
("953","953","13375878183622133227","deep","178"),
("954","954","13376172474050509225","deep","178"),
("955","955","13377161570875962763","deep","178"),
("956","956","13378807991440591827","deep","178"),
("957","957","13378845469803526545","deep","178"),
("958","958","13382963988000248538","deep","178"),
("959","959","13383953084825702076","deep","178"),
("960","960","13384942181651155614","deep","178"),
("961","961","13385599505390331140","deep","178"),
("962","962","13386588602215784678","deep","178"),
("963","963","13390344087101707143","deep","178"),
("964","964","13391990507666336207","deep","178"),
("965","965","13392979604491789745","deep","178"),
("966","966","13393436025815073584","deep","178"),
("967","967","13394425122640527122","deep","178"),
("968","968","13394462605298429136","deep","178"),
("969","969","13395082446379702648","deep","178"),
("970","970","13395451702123882674","deep","178"),
("971","971","13396071543205156186","deep","178"),
("972","972","13397098122688511738","deep","178"),
("973","973","13400521830193188895","deep","178"),
("974","974","13403194830241173511","deep","178"),
("975","975","13403489120669549509","deep","178"),
("976","976","13409585832517178578","deep","178"),
("977","977","13413666868055998557","deep","178"),
("978","978","13413704350713900571","deep","178"),
("979","979","13414693447539354109","deep","178"),
("980","980","13415682544364807647","deep","178"),
("981","981","13417328960634469415","deep","178"),
("982","982","13418774483078174088","deep","178"),
("983","983","13419763579903627626","deep","178"),
("984","984","13421779251917469420","deep","178"),
("985","985","13423425672482098484","deep","178"),
("986","986","13428827577932650013","deep","178"),
("987","987","13429283999255933852","deep","178"),
("988","988","13429816674758103551","deep","178"),
("989","989","13432946096129372006","deep","178"),
("990","990","13433240386557748004","deep","178"),
("991","991","13433935192954825544","deep","178"),
("992","992","13434592516694001070","deep","178"),
("993","993","13436369807929016459","deep","178"),
("994","994","13437358904754469997","deep","178"),
("995","995","13439042803682033779","deep","178"),
("996","996","13440983514675038841","deep","178"),
("997","997","13441020997332940855","deep","178"),
("998","998","13441678321072116381","deep","178"),
("999","999","13445433805958038846","deep","178"),
("1000","1000","13449552324154760839","deep","178"),
("1001","1001","13450503938322312363","deep","178"),
("1002","1002","13450541420980214377","deep","178"),
("1003","1003","13451530517805667915","deep","178"),
("1004","1004","13455155132021204055","deep","178"),
("1005","1005","13455611553344487894","deep","178"),
("1006","1006","13456638132827843446","deep","178"),
("1007","1007","13457627229653296984","deep","178"),
("1008","1008","13458247070734570496","deep","178"),
("1009","1009","13459273645922958752","deep","178"),
("1010","1010","13459605419009236764","deep","178"),
("1011","1011","13462240936399319366","deep","178"),
("1012","1012","13468756586912330260","deep","178"),
("1013","1013","13468794069570232274","deep","178"),
("1014","1014","13469745683737783798","deep","178"),
("1015","1015","13469783166395685812","deep","178"),
("1016","1016","13470077456824061810","deep","178"),
("1017","1017","13472750456872046426","deep","178"),
("1018","1018","13475185071846237341","deep","178"),
("1019","1019","13475842395585412867","deep","178"),
("1020","1020","13475879878243314881","deep","178"),
("1021","1021","13477163265497144417","deep","178"),
("1022","1022","13478847164424708199","deep","178"),
("1023","1023","13483917296788981716","deep","178"),
("1024","1024","13484906393614435254","deep","178"),
("1025","1025","13486351911763172631","deep","178"),
("1026","1026","13488330105414079707","deep","178"),
("1027","1027","13488367588071981721","deep","178"),
("1028","1028","13489024911811157247","deep","178"),
("1029","1029","13489319202239533245","deep","178"),
("1030","1030","13490014008636610785","deep","178"),
("1031","1031","13490345781722888797","deep","178"),
("1032","1032","13492448623610801700","deep","178"),
("1033","1033","13493437720436255238","deep","178"),
("1034","1034","13494464299919610790","deep","178"),
("1035","1035","13495415914087162314","deep","178"),
("1036","1036","13495453396745064328","deep","178"),
("1037","1037","13496073237826337840","deep","178"),
("1038","1038","13496442493570517866","deep","178"),
("1039","1039","13505593657178644066","deep","178"),
("1040","1040","13505631139836546080","deep","178"),
("1041","1041","13508560947655004680","deep","178"),
("1042","1042","13509255754052082220","deep","178"),
("1043","1043","13509550044480458218","deep","178"),
("1044","1044","13509587527138360232","deep","178"),
("1045","1045","13510244850877535758","deep","178"),
("1046","1046","13512716948509628687","deep","178"),
("1047","1047","13513706045335082225","deep","178"),
("1048","1048","13514657659502633749","deep","178"),
("1049","1049","13514695142160535763","deep","178"),
("1050","1050","13516341562725164827","deep","178"),
("1051","1051","13516635853153540825","deep","178"),
("1052","1052","13517330659550618365","deep","178"),
("1053","1053","13520754371350262818","deep","178"),
("1054","1054","13521743463880749060","deep","178"),
("1055","1055","13522732560706202598","deep","178"),
("1056","1056","13523188986324453733","deep","178"),
("1057","1057","13524178083149907271","deep","178"),
("1058","1058","13525824499419569039","deep","178"),
("1059","1059","13525861982077471053","deep","178"),
("1060","1060","13526156272505847051","deep","178"),
("1061","1061","13529818369379285205","deep","178"),
("1062","1062","13531921211267198108","deep","178"),
("1063","1063","13533899404918105184","deep","178"),
("1064","1064","13533936887576007198","deep","178"),
("1065","1065","13535915081226914274","deep","178"),
("1066","1066","13543419828565378706","deep","178"),
("1067","1067","13543457306928313424","deep","178"),
("1068","1068","13544446403753766962","deep","178"),
("1069","1069","13545435500579220500","deep","178"),
("1070","1070","13547081921143849564","deep","178"),
("1071","1071","13549516536118040479","deep","178"),
("1072","1072","13550543115601396031","deep","178"),
("1073","1073","13551494729768947555","deep","178"),
("1074","1074","13551532212426849569","deep","178"),
("1075","1075","13552189536166025095","deep","178"),
("1076","1076","13557591441616576624","deep","178"),
("1077","1077","13558580538442030162","deep","178"),
("1078","1078","13561015153416221077","deep","178"),
("1079","1079","13562004250241674615","deep","178"),
("1080","1080","13562699052343784859","deep","178"),
("1081","1081","13562993347067128153","deep","178"),
("1082","1082","13563982443892581691","deep","178"),
("1083","1083","13565666342820145473","deep","178"),
("1084","1084","13566122764143429312","deep","178"),
("1085","1085","13568758281533511914","deep","178"),
("1086","1086","13569784861016867466","deep","178"),
("1087","1087","13571763054667774542","deep","178"),
("1088","1088","13572420378406950068","deep","178"),
("1089","1089","13577164960118326071","deep","178"),
("1090","1090","13578811380682955135","deep","178"),
("1091","1091","13580256898831692512","deep","178"),
("1092","1092","13581245995657146050","deep","178"),
("1093","1093","13581903319396321576","deep","178"),
("1094","1094","13583918991410163370","deep","178"),
("1095","1095","13587342703209807823","deep","178"),
("1096","1096","13587380185867709837","deep","178"),
("1097","1097","13590015703257792439","deep","178"),
("1098","1098","13590309993686168437","deep","178"),
("1099","1099","13595417608708343968","deep","178"),
("1100","1100","13596406705533797506","deep","178"),
("1101","1101","13599498644247163947","deep","178"),
("1102","1102","13600487741072617485","deep","178"),
("1103","1103","13600525223730519499","deep","178"),
("1104","1104","13601514320555973037","deep","178"),
("1105","1105","13602503417381426575","deep","178"),
("1106","1106","13605595351799825720","deep","178"),
("1107","1107","13606584448625279258","deep","178"),
("1108","1108","13608600124934088348","deep","178"),
("1109","1109","13610246545498717412","deep","178"),
("1110","1110","13615648450949268941","deep","178"),
("1111","1111","13616104872272552780","deep","178"),
("1112","1112","13616637547774722479","deep","178"),
("1113","1113","13619766969145990934","deep","178"),
("1114","1114","13620061259574366932","deep","178"),
("1115","1115","13620756065971444472","deep","178"),
("1116","1116","13623190680945635387","deep","178"),
("1117","1117","13624179777771088925","deep","178"),
("1118","1118","13625863676698652707","deep","178"),
("1119","1119","13627841870349559783","deep","178"),
("1120","1120","13632254678974657774","deep","178"),
("1121","1121","13637324811338931291","deep","178"),
("1122","1122","13637362293996833305","deep","178"),
("1123","1123","13638351390822286843","deep","178"),
("1124","1124","13642432426361106822","deep","178"),
("1125","1125","13643459005844462374","deep","178"),
("1126","1126","13644448098374948616","deep","178"),
("1127","1127","13646094518939577680","deep","178"),
("1128","1128","13646426292025855692","deep","178"),
("1129","1129","13647083615765031218","deep","178"),
("1130","1130","13655577459928949188","deep","178"),
("1131","1131","13655614942586851202","deep","178"),
("1132","1132","13656566556754402726","deep","178"),
("1133","1133","13656604039412304740","deep","178"),
("1134","1134","13656898329840680738","deep","178"),
("1135","1135","13658582233063211816","deep","178"),
("1136","1136","13659571329888665354","deep","178"),
("1137","1137","13660027751211949193","deep","178"),
("1138","1138","13662005944862856269","deep","178"),
("1139","1139","13662663268602031795","deep","178"),
("1140","1140","13662700751259933809","deep","178"),
("1141","1141","13663984138513763345","deep","178"),
("1142","1142","13665668037441327127","deep","178"),
("1143","1143","13670738169805600644","deep","178"),
("1144","1144","13673172784779791559","deep","178"),
("1145","1145","13675150978430698635","deep","178"),
("1146","1146","13675188461088600649","deep","178"),
("1147","1147","13675845784827776175","deep","178"),
("1148","1148","13676140075256152173","deep","178"),
("1149","1149","13676834881653229713","deep","178"),
("1150","1150","13677166654739507725","deep","178"),
("1151","1151","13679269496627420628","deep","178"),
("1152","1152","13680258593452874166","deep","178"),
("1153","1153","13681247690278327704","deep","178"),
("1154","1154","13681285172936229718","deep","178"),
("1155","1155","13682236787103781242","deep","178"),
("1156","1156","13682274269761683256","deep","178"),
("1157","1157","13683263366587136794","deep","178"),
("1158","1158","13692414530195262994","deep","178"),
("1159","1159","13696076627068701148","deep","178"),
("1160","1160","13696408400154979160","deep","178"),
("1161","1161","13699537821526247615","deep","178"),
("1162","1162","13700526918351701153","deep","178"),
("1163","1163","13701516015177154691","deep","178"),
("1164","1164","13702505112002608229","deep","178"),
("1165","1165","13703162431446816459","deep","178"),
("1166","1166","13707575240071914450","deep","178"),
("1167","1167","13708564336897367988","deep","178"),
("1168","1168","13709553433722821526","deep","178"),
("1169","1169","13710009855046105365","deep","178"),
("1170","1170","13710998951871558903","deep","178"),
("1171","1171","13712645372436187967","deep","178"),
("1172","1172","13712682855094089981","deep","178"),
("1173","1173","13712977145522465979","deep","178"),
("1174","1174","13716639242395904133","deep","178"),
("1175","1175","13718742084283817036","deep","178"),
("1176","1176","13720757760592626126","deep","178"),
("1177","1177","13730240697287030338","deep","178"),
("1178","1178","13730278179944932352","deep","178"),
("1179","1179","13731267276770385890","deep","178"),
("1180","1180","13732256373595839428","deep","178"),
("1181","1181","13732913697335014954","deep","178"),
("1182","1182","13736337409134659407","deep","178"),
("1183","1183","13737326505960112945","deep","178"),
("1184","1184","13737363988618014959","deep","178"),
("1185","1185","13738315602785566483","deep","178"),
("1186","1186","13739010409182644023","deep","178"),
("1187","1187","13744412314633195552","deep","178"),
("1188","1188","13745401411458649090","deep","178"),
("1189","1189","13747836026432840005","deep","178"),
("1190","1190","13748825123258293543","deep","178"),
("1191","1191","13749519925360403787","deep","178"),
("1192","1192","13749814220083747081","deep","178"),
("1193","1193","13750509022185857325","deep","178"),
("1194","1194","13750803312614233323","deep","178"),
("1195","1195","13752487215836764401","deep","178"),
("1196","1196","13752943637160048240","deep","178"),
("1197","1197","13755579154550130842","deep","178"),
("1198","1198","13755910927636408854","deep","178"),
("1199","1199","13756605734033486394","deep","178"),
("1200","1200","13758583927684393470","deep","178"),
("1201","1201","13763985833134944999","deep","178"),
("1202","1202","13767077771848311440","deep","178"),
("1203","1203","13770739864426782298","deep","178"),
("1204","1204","13773174479400973213","deep","178"),
("1205","1205","13774163576226426751","deep","178"),
("1206","1206","13774201058884328765","deep","178"),
("1207","1207","13776179252535235841","deep","178"),
("1208","1208","13776836576274411367","deep","178"),
("1209","1209","13777130866702787365","deep","178"),
("1210","1210","13777168349360689379","deep","178"),
("1211","1211","13777825673099864905","deep","178"),
("1212","1212","13782238481724962896","deep","178"),
("1213","1213","13786319517263782875","deep","178"),
("1214","1214","13786356999921684889","deep","178"),
("1215","1215","13788335189277624669","deep","178"),
("1216","1216","13789324286103078207","deep","178"),
("1217","1217","13790313382928531745","deep","178"),
("1218","1218","13792416224816444648","deep","178"),
("1219","1219","13793405321641898186","deep","178"),
("1220","1220","13794431901125253738","deep","178"),
("1221","1221","13795420997950707276","deep","178"),
("1222","1222","13802469323965887869","deep","178"),
("1223","1223","13802925745289171708","deep","178"),
("1224","1224","13806587842162609862","deep","178"),
("1225","1225","13806882132590985860","deep","178"),
("1226","1226","13807576934693096104","deep","178"),
("1227","1227","13810011553962254315","deep","178"),
("1228","1228","13811000646492740557","deep","178"),
("1229","1229","13812684549715271635","deep","178"),
("1230","1230","13819075551991276702","deep","178"),
("1231","1231","13824145684355550219","deep","178"),
("1232","1232","13824183167013452233","deep","178"),
("1233","1233","13825172263838905771","deep","178"),
("1234","1234","13829253299377725750","deep","178"),
("1235","1235","13830242396203179288","deep","178"),
("1236","1236","13830279874566114006","deep","178"),
("1237","1237","13831231488733665530","deep","178"),
("1238","1238","13831268971391567544","deep","178"),
("1239","1239","13832915391956196608","deep","178"),
("1240","1240","13833247165042474620","deep","178"),
("1241","1241","13833904488781650146","deep","178"),
("1242","1242","13840751912380939052","deep","178"),
("1243","1243","13842398332945568116","deep","178"),
("1244","1244","13842435815603470130","deep","178"),
("1245","1245","13843387429771021654","deep","178"),
("1246","1246","13843424912428923668","deep","178"),
("1247","1247","13843719202857299666","deep","178"),
("1248","1248","13845403106079830744","deep","178"),
("1249","1249","13846392202905284282","deep","178"),
("1250","1250","13846848624228568121","deep","178"),
("1251","1251","13848826817879475197","deep","178"),
("1252","1252","13849484141618650723","deep","178"),
("1253","1253","13849521619981585441","deep","178"),
("1254","1254","13850805011530382273","deep","178"),
("1255","1255","13851499813632492517","deep","178"),
("1256","1256","13852488910457946055","deep","178"),
("1257","1257","13857559042822219572","deep","178"),
("1258","1258","13859993657796410487","deep","178"),
("1259","1259","13861971851447317563","deep","178"),
("1260","1260","13862009334105219577","deep","178"),
("1261","1261","13862666657844395103","deep","178"),
("1262","1262","13862960948272771101","deep","178"),
("1263","1263","13863655754669848641","deep","178"),
("1264","1264","13863987527756126653","deep","178"),
("1265","1265","13866090369644039556","deep","178"),
("1266","1266","13868068563294946632","deep","178"),
("1267","1267","13868106045952848646","deep","178"),
("1268","1268","13869057660120400170","deep","178"),
("1269","1269","13869095142778302184","deep","178"),
("1270","1270","13870084235308788426","deep","178"),
("1271","1271","13879235403211881922","deep","178"),
("1272","1272","13883229273171598088","deep","178"),
("1273","1273","13886321211884964529","deep","178"),
("1274","1274","13886358694542866543","deep","178"),
("1275","1275","13887347791368320081","deep","178"),
("1276","1276","13888336888193773619","deep","178"),
("1277","1277","13889325980724259861","deep","178"),
("1278","1278","13894396113088533378","deep","178"),
("1279","1279","13895385209913986916","deep","178"),
("1280","1280","13896830728062724293","deep","178"),
("1281","1281","13897819824888177831","deep","178"),
("1282","1282","13899503728110708909","deep","178"),
("1283","1283","13899798018539084907","deep","178"),
("1284","1284","13907578633609245054","deep","178"),
("1285","1285","13917061570303649266","deep","178"),
("1286","1286","13917099052961551280","deep","178"),
("1287","1287","13918088149787004818","deep","178"),
("1288","1288","13919077246612458356","deep","178"),
("1289","1289","13919734570351633882","deep","178"),
("1290","1290","13924147378976731873","deep","178"),
("1291","1291","13924184861634633887","deep","178"),
("1292","1292","13925136475802185411","deep","178"),
("1293","1293","13925831282199262951","deep","178"),
("1294","1294","13931233187649814480","deep","178"),
("1295","1295","13932222280180300722","deep","178"),
("1296","1296","13934656899449458933","deep","178"),
("1297","1297","13935645991979945175","deep","178"),
("1298","1298","13936340798377022715","deep","178"),
("1299","1299","13936635088805398713","deep","178"),
("1300","1300","13937329895202476253","deep","178"),
("1301","1301","13937624185630852251","deep","178"),
("1302","1302","13939308088853383329","deep","178"),
("1303","1303","13939764510176667168","deep","178"),
("1304","1304","13942400027566749770","deep","178"),
("1305","1305","13942731800653027782","deep","178"),
("1306","1306","13943426607050105322","deep","178"),
("1307","1307","13945404800701012398","deep","178"),
("1308","1308","13950806706151563927","deep","178"),
("1309","1309","13953898644864930368","deep","178"),
("1310","1310","13957560737443401226","deep","178"),
("1311","1311","13959995352417592141","deep","178"),
("1312","1312","13960984449243045679","deep","178"),
("1313","1313","13961021931900947693","deep","178"),
("1314","1314","13963000125551854769","deep","178"),
("1315","1315","13963657449291030295","deep","178"),
("1316","1316","13963951739719406293","deep","178"),
("1317","1317","13963989222377308307","deep","178"),
("1318","1318","13964646546116483833","deep","178"),
("1319","1319","13969059354741581824","deep","178"),
("1320","1320","13973140390280401803","deep","178"),
("1321","1321","13973177868643336521","deep","178"),
("1322","1322","13975156062294243597","deep","178"),
("1323","1323","13976145159119697135","deep","178"),
("1324","1324","13979237097833063576","deep","178"),
("1325","1325","13980226194658517114","deep","178"),
("1326","1326","13981252774141872666","deep","178"),
("1327","1327","13982241870967326204","deep","178"),
("1328","1328","13989746618305790636","deep","178"),
("1329","1329","13992419614058807956","deep","178"),
("1330","1330","13993408710884261494","deep","178"),
("1331","1331","13993703005607604788","deep","178"),
("1332","1332","13994397807709715032","deep","178"),
("1333","1333","13995386904535168570","deep","178"),
("1334","1334","13996832422683905947","deep","178"),
("1335","1335","13997821519509359485","deep","178"),
("1336","1336","14002472713208251177","deep","178"),
("1337","1337","14005896425007895630","deep","178"),
("1338","1338","14010966557372169147","deep","178"),
("1339","1339","14011993136855524699","deep","178"),
("1340","1340","14016074168099377382","deep","178"),
("1341","1341","14017063264924830920","deep","178"),
("1342","1342","14017100747582732934","deep","178"),
("1343","1343","14018052361750284458","deep","178"),
("1344","1344","14018089844408186472","deep","178"),
("1345","1345","14019736264972815536","deep","178"),
("1346","1346","14020068038059093548","deep","178"),
("1347","1347","14027572785397557980","deep","178"),
("1348","1348","14029219205962187044","deep","178"),
("1349","1349","14029256688620089058","deep","178"),
("1350","1350","14030245785445542596","deep","178"),
("1351","1351","14032223979096449672","deep","178"),
("1352","1352","14033213075921903210","deep","178"),
("1353","1353","14033669497245187049","deep","178"),
("1354","1354","14035647690896094125","deep","178"),
("1355","1355","14036305010340302355","deep","178"),
("1356","1356","14036342492998204369","deep","178"),
("1357","1357","14037625880252033905","deep","178"),
("1358","1358","14038320686649111445","deep","178"),
("1359","1359","14039309783474564983","deep","178"),
("1360","1360","14046814530813029415","deep","178"),
("1361","1361","14048792724463936491","deep","178"),
("1362","1362","14048830207121838505","deep","178"),
("1363","1363","14049487530861014031","deep","178"),
("1364","1364","14049781821289390029","deep","178"),
("1365","1365","14050476627686467569","deep","178"),
("1366","1366","14050808400772745581","deep","178"),
("1367","1367","14052911242660658484","deep","178"),
("1368","1368","14054889436311565560","deep","178"),
("1369","1369","14054926914674500278","deep","178"),
("1370","1370","14055878533137019098","deep","178"),
("1371","1371","14055916011499953816","deep","178"),
("1372","1372","14056905108325407354","deep","178"),
("1373","1373","14057562432064582880","deep","178"),
("1374","1374","14066056276228500850","deep","178"),
("1375","1375","14070050146188217016","deep","178"),
("1376","1376","14073142084901583457","deep","178"),
("1377","1377","14075157756915425251","deep","178"),
("1378","1378","14076146853740878789","deep","178"),
("1379","1379","14081216986105152306","deep","178"),
("1380","1380","14083651601079343221","deep","178"),
("1381","1381","14084640697904796759","deep","178"),
("1382","1382","14086324601127327837","deep","178"),
("1383","1383","14086618891555703835","deep","178"),
("1384","1384","14094399502330896686","deep","178"),
("1385","1385","14103882443320268194","deep","178"),
("1386","1386","14103919925978170208","deep","178"),
("1387","1387","14104909022803623746","deep","178"),
("1388","1388","14105898119629077284","deep","178"),
("1389","1389","14110968251993350801","deep","178"),
("1390","1390","14111005734651252815","deep","178"),
("1391","1391","14111957348818804339","deep","178"),
("1392","1392","14118054056371466112","deep","178"),
("1393","1393","14119043153196919650","deep","178"),
("1394","1394","14121477768171110565","deep","178"),
("1395","1395","14122466864996564103","deep","178"),
("1396","1396","14123161671393641643","deep","178"),
("1397","1397","14124150768219095181","deep","178"),
("1398","1398","14124445058647471179","deep","178"),
("1399","1399","14126585383193286096","deep","178"),
("1400","1400","14129220900583368698","deep","178"),
("1401","1401","14129552673669646710","deep","178"),
("1402","1402","14130247480066724250","deep","178"),
("1403","1403","14132225673717631326","deep","178"),
("1404","1404","14137627579168182855","deep","178"),
("1405","1405","14140719513586582000","deep","178"),
("1406","1406","14146816225434211069","deep","178"),
("1407","1407","14146853708092113083","deep","178"),
("1408","1408","14147805322259664607","deep","178"),
("1409","1409","14147842804917566621","deep","178"),
("1410","1410","14149820998568473697","deep","178"),
("1411","1411","14150478322307649223","deep","178"),
("1412","1412","14150810095393927235","deep","178"),
("1413","1413","14155880227758200752","deep","178"),
("1414","1414","14159961259002053435","deep","178"),
("1415","1415","14159998741659955449","deep","178"),
("1416","1416","14162966032136316063","deep","178"),
("1417","1417","14168073647158491594","deep","178"),
("1418","1418","14169062743983945132","deep","178"),
("1419","1419","14176567491322409564","deep","178"),
("1420","1420","14179240487075426884","deep","178"),
("1421","1421","14180229583900880422","deep","178"),
("1422","1422","14180523874329256420","deep","178"),
("1423","1423","14181218680726333960","deep","178"),
("1424","1424","14183653295700524875","deep","178"),
("1425","1425","14184642392525978413","deep","178"),
("1426","1426","14186326295748509491","deep","178"),
("1427","1427","14192717298024514558","deep","178"),
("1428","1428","14196835816221236551","deep","178"),
("1429","1429","14197787430388788075","deep","178"),
("1430","1430","14198814005577176331","deep","178"),
("1431","1431","14203884137941449848","deep","178"),
("1432","1432","14203921620599351862","deep","178"),
("1433","1433","14204873234766903386","deep","178"),
("1434","1434","14204910717424805400","deep","178"),
("1435","1435","14206888911075712476","deep","178"),
("1436","1436","14214393658414176908","deep","178"),
("1437","1437","14216077561636707986","deep","178"),
("1438","1438","14217066658462161524","deep","178"),
("1439","1439","14219044847818101304","deep","178"),
("1440","1440","14220490370261805977","deep","178"),
("1441","1441","14222468559617745757","deep","178"),
("1442","1442","14223163366014823297","deep","178"),
("1443","1443","14224446753268652833","deep","178"),
("1444","1444","14225141559665730373","deep","178"),
("1445","1445","14226130656491183911","deep","178"),
("1446","1446","14233635403829648343","deep","178"),
("1447","1447","14233672886487550357","deep","178"),
("1448","1448","14235651080138457433","deep","178"),
("1449","1449","14236308403877632959","deep","178"),
("1450","1450","14239732115677277412","deep","178"),
("1451","1451","14241710305033217192","deep","178"),
("1452","1452","14241747787691119206","deep","178"),
("1453","1453","14242699401858670730","deep","178"),
("1454","1454","14242736884516572744","deep","178"),
("1455","1455","14243725981342026282","deep","178"),
("1456","1456","14252877149245119778","deep","178"),
("1457","1457","14256871019204835944","deep","178"),
("1458","1458","14259962957918202385","deep","178"),
("1459","1459","14260989533106590641","deep","178"),
("1460","1460","14261978629932044179","deep","178"),
("1461","1461","14262967726757497717","deep","178"),
("1462","1462","14270472474095962149","deep","178"),
("1463","1463","14271461570921415687","deep","178"),
("1464","1464","14272450667746869225","deep","178"),
("1465","1465","14273145474143946765","deep","178"),
("1466","1466","14273439764572322763","deep","178"),
("1467","1467","14276569185943591218","deep","178"),
("1468","1468","14281220375347515614","deep","178"),
("1469","1469","14290703316336887122","deep","178"),
("1470","1470","14290740798994789136","deep","178"),
("1471","1471","14291729895820242674","deep","178"),
("1472","1472","14292718992645696212","deep","178"),
("1473","1473","14297789125009969729","deep","178"),
("1474","1474","14297826607667871743","deep","178"),
("1475","1475","14308298641187729493","deep","178"),
("1476","1476","14309982544410260571","deep","178"),
("1477","1477","14310971641235714109","deep","178"),
("1478","1478","14311265931664090107","deep","178"),
("1479","1479","14316373546686265638","deep","178"),
("1480","1480","14317068353083343178","deep","178"),
("1481","1481","14319046546734250254","deep","178"),
("1482","1482","14324448447889834487","deep","178"),
("1483","1483","14327540386603200928","deep","178"),
("1484","1484","14333637098450829997","deep","178"),
("1485","1485","14333674581108732011","deep","178"),
("1486","1486","14334626195276283535","deep","178"),
("1487","1487","14334663677934185549","deep","178"),
("1488","1488","14336641871585092625","deep","178"),
("1489","1489","14337630968410546163","deep","178"),
("1490","1490","14342701096479852384","deep","178"),
("1491","1491","14346819614676574377","deep","178"),
("1492","1492","14348797808327481453","deep","178"),
("1493","1493","14352878843866301432","deep","178"),
("1494","1494","14353905423349656984","deep","178"),
("1495","1495","14354894520175110522","deep","178"),
("1496","1496","14355883617000564060","deep","178"),
("1497","1497","14363388364339028492","deep","178"),
("1498","1498","14366061360092045812","deep","178"),
("1499","1499","14367050456917499350","deep","178"),
("1500","1500","14370474168717143803","deep","178"),
("1501","1501","14373147168765128419","deep","178"),
("1502","1502","14379538171041133486","deep","178"),
("1503","1503","14385634878593795259","deep","178"),
("1504","1504","14389715914132615238","deep","178"),
("1505","1505","14390705010958068776","deep","178"),
("1506","1506","14390742493615970790","deep","178"),
("1507","1507","14391731590441424328","deep","178"),
("1508","1508","14393709784092331404","deep","178"),
("1509","1509","14401214531430795836","deep","178"),
("1510","1510","14402898430358359618","deep","178"),
("1511","1511","14403887527183813156","deep","178"),
("1512","1512","14407311238983457609","deep","178"),
("1513","1513","14409289432634364685","deep","178"),
("1514","1514","14409984239031442225","deep","178"),
("1515","1515","14410973335856895763","deep","178"),
("1516","1516","14411267626285271761","deep","178"),
("1517","1517","14411962432682349301","deep","178"),
("1518","1518","14420456276846267271","deep","178"),
("1519","1519","14422471953155076361","deep","178"),
("1520","1520","14426552984398929044","deep","178"),
("1521","1521","14428531178049836120","deep","178"),
("1522","1522","14428568660707738134","deep","178"),
("1523","1523","14429557757533191672","deep","178"),
("1524","1524","14430546854358645210","deep","178"),
("1525","1525","14447810406123209569","deep","178"),
("1526","1526","14448799502948663107","deep","178"),
("1527","1527","14449788599774116645","deep","178"),
("1528","1528","14457293347112581077","deep","178"),
("1529","1529","14459271540763488153","deep","178"),
("1530","1530","14459966347160565693","deep","178"),
("1531","1531","14463390058960210146","deep","178"),
("1532","1532","14478550768836861602","deep","178"),
("1533","1533","14479539865662315140","deep","178"),
("1534","1534","14484647476389523375","deep","178"),
("1535","1535","14495119514204348421","deep","178"),
("1536","1536","14496803417426879499","deep","178"),
("1537","1537","14497792514252333037","deep","178"),
("1538","1538","14503194419702884566","deep","178"),
("1539","1539","14503889226099962106","deep","178"),
("1540","1540","14511269320906453415","deep","178"),
("1541","1541","14514361259619819856","deep","178"),
("1542","1542","14520457971467448925","deep","178"),
("1543","1543","14520495454125350939","deep","178"),
("1544","1544","14521447068292902463","deep","178"),
("1545","1545","14521484550950804477","deep","178"),
("1546","1546","14523462744601711553","deep","178"),
("1547","1547","14524451841427165091","deep","178"),
("1548","1548","14533640487693193305","deep","178"),
("1549","1549","14534629584518646843","deep","178"),
("1550","1550","14535618681344100381","deep","178"),
("1551","1551","14540726296366275912","deep","178"),
("1552","1552","14541715393191729450","deep","178"),
("1553","1553","14542704490017182988","deep","178"),
("1554","1554","14550209233060680124","deep","178"),
("1555","1555","14552882233108664740","deep","178"),
("1556","1556","14557295041733762731","deep","178"),
("1557","1557","14559273235384669807","deep","178"),
("1558","1558","14559968041781747347","deep","178"),
("1559","1559","14566359044057752414","deep","178"),
("1560","1560","14572455751610414187","deep","178"),
("1561","1561","14576536787149234166","deep","178"),
("1562","1562","14577563366632589718","deep","178"),
("1563","1563","14578552463458043256","deep","178"),
("1564","1564","14580530657108950332","deep","178"),
("1565","1565","14588035404447414764","deep","178"),
("1566","1566","14589719303374978546","deep","178"),
("1567","1567","14590708400200432084","deep","178"),
("1568","1568","14594132112000076537","deep","178"),
("1569","1569","14596110305650983613","deep","178"),
("1570","1570","14596805112048061153","deep","178"),
("1571","1571","14597794208873514691","deep","178"),
("1572","1572","14607277149862886199","deep","178"),
("1573","1573","14609292821876727993","deep","178"),
("1574","1574","14613373857415547972","deep","178"),
("1575","1575","14615389533724357062","deep","178"),
("1576","1576","14616378630549810600","deep","178"),
("1577","1577","14617367727375264138","deep","178"),
("1578","1578","14627545474761713186","deep","178"),
("1579","1579","14634631279139828497","deep","178"),
("1580","1580","14635620375965282035","deep","178"),
("1581","1581","14644114220129200005","deep","178"),
("1582","1582","14650210931976829074","deep","178"),
("1583","1583","14665371641853480530","deep","178"),
("1584","1584","14666360738678934068","deep","178"),
("1585","1585","14671468349406142303","deep","178"),
("1586","1586","14681940387220967349","deep","178"),
("1587","1587","14690015292719503494","deep","178"),
("1588","1588","14690710094821613738","deep","178"),
("1589","1589","14707278844484067853","deep","178"),
("1590","1590","14707316327141969867","deep","178"),
("1591","1591","14708305423967423405","deep","178"),
("1592","1592","14710283613323363185","deep","178"),
("1593","1593","14711272710148816723","deep","178"),
("1594","1594","14720461360709812233","deep","178"),
("1595","1595","14721450457535265771","deep","178"),
("1596","1596","14727547169382894840","deep","178"),
("1597","1597","14728536266208348378","deep","178"),
("1598","1598","14737030106077299052","deep","178"),
("1599","1599","14744115914750381659","deep","178"),
("1600","1600","14759276624627033115","deep","178"),
("1601","1601","14764384239649208646","deep","178"),
("1602","1602","14766362433300115722","deep","178"),
("1603","1603","14774856277464033692","deep","178"),
("1604","1604","14776540176391597474","deep","178"),
("1605","1605","14780952985016695465","deep","178"),
("1606","1606","14783625985064680081","deep","178"),
("1607","1607","14800194730432166900","deep","178"),
("1608","1608","14802210406740975990","deep","178"),
("1609","1609","14804188600391883066","deep","178"),
("1610","1610","14814366343483364818","deep","178"),
("1611","1611","14821452152156447425","deep","178"),
("1612","1612","14830935093145818933","deep","178"),
("1613","1613","14837031800698480706","deep","178"),
("1614","1614","14852192514870099458","deep","178"),
("1615","1615","14858289222422761231","deep","178"),
("1616","1616","14894137200158588795","deep","178"),
("1617","1617","14895126292689075037","deep","178"),
("1618","1618","14907282233726431161","deep","178"),
("1619","1619","14914368038104546472","deep","178"),
("1620","1620","14930936787767000587","deep","178"),
("1621","1621","14951205112665827574","deep","178"),
("1622","1622","14952194209491281112","deep","178"),
("1623","1623","14961677146185685324","deep","178"),
("1624","1624","14967773858033314393","deep","178"),
("1625","1625","14989031279757594918","deep","178"),
("1626","1626","15023852673715099634","deep","178"),
("1627","1627","15045110095439380159","deep","178"),
("1628","1628","15080958068880240427","deep","178"),
("1629","1629","15081947165705693965","deep","178"),
("1630","1630","15138025985682446502","deep","178"),
("1631","1631","15154594731049933321","deep","178"),
("1632","1632","15261682234344197582","deep","178"),
("1633","1633","15267778941896859355","deep","178"),
("1634","1634","15268768038722312893","deep","178"),
("1635","1635","15454599814913478283","deep","178"),
("1636","1636","1742470591888319428","deep","178"),
("1637","1637","1749556400561402035","deep","178"),
("1638","1638","1928302368079484818","deep","178"),
("1639","1639","1949559789803765343","deep","178"),
("1640","1640","1966128535171252162","deep","178"),
("1641","1641","1973214343844334769","deep","178"),
("1642","1642","2114134144270650208","deep","178"),
("1643","1643","2151960311362417552","deep","178"),
("1644","1644","2189786478454184896","deep","178"),
("1645","1645","2196872287127267503","deep","178"),
("1646","1646","2214135838891831862","deep","178"),
("1647","1647","2249564873667310305","deep","178"),
("1648","1648","2314137533513013516","deep","178"),
("1649","1649","2337792087553582942","deep","178"),
("1650","1650","2349566568288491959","deep","178"),
("1651","1651","2375618254645350286","deep","178"),
("1652","1652","2407053423756079859","deep","178"),
("1653","1653","2413444421737117630","deep","178"),
("1654","1654","2414139228134195170","deep","178"),
("1655","1655","2420530230410200237","deep","178"),
("1656","1656","2421225036807277777","deep","178"),
("1657","1657","2437793782174764596","deep","178"),
("1658","1658","2449568262909673613","deep","178"),
("1659","1659","2473222816950243039","deep","178"),
("1660","1660","2489791562317729858","deep","178"),
("1661","1661","2528312535806574742","deep","178"),
("1662","1662","2537795476795946250","deep","178"),
("1663","1663","2542484153152739956","deep","178"),
("1664","1664","2544881285469028857","deep","178"),
("1665","1665","2561450030836515676","deep","178"),
("1666","1666","2585799391274162642","deep","178"),
("1667","1667","2599276197928283020","deep","178"),
("1668","1668","2630711367039012593","deep","178"),
("1669","1669","2635400039100839003","deep","178"),
("1670","1670","2637102365020050364","deep","178"),
("1671","1671","2637797171417127904","deep","178"),
("1672","1672","2644188173693132971","deep","178"),
("1673","1673","2644882980090210511","deep","178"),
("1674","1674","2661451725457697330","deep","178"),
("1675","1675","2673226206192606347","deep","178"),
("1676","1676","2685801085895344296","deep","178"),
("1677","1677","2696880760233175773","deep","178"),
("1678","1678","2699972698946542214","deep","178"),
("1679","1679","2713449509895629888","deep","178"),
("1680","1680","2737798866038309558","deep","178"),
("1681","1681","2761453420078878984","deep","178"),
("1682","1682","2766142096435672690","deep","178"),
("1683","1683","2768539228751961591","deep","178"),
("1684","1684","2785107974119448410","deep","178"),
("1685","1685","2799279587170646328","deep","178"),
("1686","1686","2799974393567723868","deep","178"),
("1687","1687","2809457334557095376","deep","178"),
("1688","1688","2814146006618921786","deep","178"),
("1689","1689","2822934141211215754","deep","178"),
("1690","1690","2844886369332573819","deep","178"),
("1691","1691","2854369310321945327","deep","178"),
("1692","1692","2859057982383771737","deep","178"),
("1693","1693","2860760312597950394","deep","178"),
("1694","1694","2861455114700060638","deep","178"),
("1695","1695","2867846116976065705","deep","178"),
("1696","1696","2885804475137707604","deep","178"),
("1697","1697","2896884149475539081","deep","178"),
("1698","1698","2899976088188905522","deep","178"),
("1699","1699","2909459029178277030","deep","178"),
("1700","1700","2920538703516108507","deep","178"),
("1701","1701","2923630642229474948","deep","178"),
("1702","1702","2937107453178562622","deep","178"),
("1703","1703","2940199391891929063","deep","178"),
("1704","1704","2961456809321242292","deep","178"),
("1705","1705","2989800039718605424","deep","178"),
("1706","1706","2992197172034894325","deep","178"),
("1707","1707","3015851726075463751","deep","178"),
("1708","1708","3022937534748546358","deep","178"),
("1709","1709","3023632336850656602","deep","178"),
("1710","1710","3033115277840028110","deep","178"),
("1711","1711","3046592088789115784","deep","178"),
("1712","1712","3068544312615506553","deep","178"),
("1713","1713","3070941444931795454","deep","178"),
("1714","1714","3078027253604878061","deep","178"),
("1715","1715","3082715925666704471","deep","178"),
("1716","1716","3085113057982993372","deep","178"),
("1717","1717","3091504060258998439","deep","178"),
("1718","1718","3120542092758471815","deep","178"),
("1719","1719","3133116972461209764","deep","178"),
("1720","1720","3139507974737214831","deep","178"),
("1721","1721","3144196646799041241","deep","178"),
("1722","1722","3147288585512407682","deep","178"),
("1723","1723","3160765396461495356","deep","178"),
("1724","1724","3163857335174861797","deep","178"),
("1725","1725","3185114756899142322","deep","178"),
("1726","1726","3185809559001252566","deep","178"),
("1727","1727","3213457983001538158","deep","178"),
("1728","1728","3215855115317827059","deep","178"),
("1729","1729","3239509669358396485","deep","178"),
("1730","1730","3246595478031479092","deep","178"),
("1731","1731","3256773221122960844","deep","178"),
("1732","1732","3270250032072048518","deep","178"),
("1733","1733","3292202255898439287","deep","178"),
("1734","1734","3294599388214728188","deep","178"),
("1735","1735","3301685196887810795","deep","178"),
("1736","1736","3306373868949637205","deep","178"),
("1737","1737","3308771005560893402","deep","178"),
("1738","1738","3315162003541931173","deep","178"),
("1739","1739","3339511363979578139","deep","178"),
("1740","1740","3344200040336371845","deep","178"),
("1741","1741","3356774915744142498","deep","178"),
("1742","1742","3363165918020147565","deep","178"),
("1743","1743","3367854594376941271","deep","178"),
("1744","1744","3370946528795340416","deep","178"),
("1745","1745","3384423339744428090","deep","178"),
("1746","1746","3387515278457794531","deep","178"),
("1747","1747","3408772700182075056","deep","178"),
("1748","1748","3409467502284185300","deep","178"),
("1749","1749","3437115926284470892","deep","178"),
("1750","1750","3439513058600759793","deep","178"),
("1751","1751","3446598867273842400","deep","178"),
("1752","1752","3463167612641329219","deep","178"),
("1753","1753","3463862419038406759","deep","178"),
("1754","1754","3470253421314411826","deep","178"),
("1755","1755","3480431164405893578","deep","178"),
("1756","1756","3515860199181372021","deep","178"),
("1757","1757","3518257331497660922","deep","178"),
("1758","1758","3525343140170743529","deep","178"),
("1759","1759","3530031816527537235","deep","178"),
("1760","1760","3532428948843826136","deep","178"),
("1761","1761","3563169307262510873","deep","178"),
("1762","1762","3580432859027075232","deep","178"),
("1763","1763","3586823861303080299","deep","178"),
("1764","1764","3591512537659874005","deep","178"),
("1765","1765","3601690280751355757","deep","178"),
("1766","1766","3608081283027360824","deep","178"),
("1767","1767","3611173221740727265","deep","178"),
("1768","1768","3615861893802553675","deep","178"),
("1769","1769","3632430643465007790","deep","178"),
("1770","1770","3633125449862085330","deep","178"),
("1771","1771","3662476199781582283","deep","178"),
("1772","1772","3663171001883692527","deep","178"),
("1773","1773","3670256810556775134","deep","178"),
("1774","1774","3686825555924261953","deep","178"),
("1775","1775","3687520362321339493","deep","178"),
("1776","1776","3693911364597344560","deep","178"),
("1777","1777","3704089107688826312","deep","178"),
("1778","1778","3711174916361908919","deep","178"),
("1779","1779","3739518142464304755","deep","178"),
("1780","1780","3741915279075560952","deep","178"),
("1781","1781","3749001083453676263","deep","178"),
("1782","1782","3753689759810469969","deep","178"),
("1783","1783","3756781698523836410","deep","178"),
("1784","1784","3786827250545443607","deep","178"),
("1785","1785","3791515926902237313","deep","178"),
("1786","1786","3804090802310007966","deep","178"),
("1787","1787","3810481804586013033","deep","178"),
("1788","1788","3815170480942806739","deep","178"),
("1789","1789","3825348224034288491","deep","178"),
("1790","1790","3834831165023659999","deep","178"),
("1791","1791","3839519841380453705","deep","178"),
("1792","1792","3848307971677780377","deep","178"),
("1793","1793","3856088586747940524","deep","178"),
("1794","1794","3856783393145018064","deep","178"),
("1795","1795","3893914753839707868","deep","178"),
("1796","1796","3910483499207194687","deep","178"),
("1797","1797","3911178305604272227","deep","178"),
("1798","1798","3917569307880277294","deep","178"),
("1799","1799","3927747055266726342","deep","178"),
("1800","1800","3934832859644841653","deep","178"),
("1801","1801","3963176090042204785","deep","178"),
("1802","1802","3965573222358493686","deep","178"),
("1803","1803","3977347703093402703","deep","178"),
("1804","1804","3980439641806769144","deep","178"),
("1805","1805","4010485193828376341","deep","178"),
("1806","1806","4015173870185170047","deep","178"),
("1807","1807","4027748749887907996","deep","178"),
("1808","1808","4034139747868945767","deep","178"),
("1809","1809","4038828424225739473","deep","178"),
("1810","1810","4049006167317221225","deep","178"),
("1811","1811","4058489108306592733","deep","178"),
("1812","1812","4063177784663386439","deep","178"),
("1813","1813","4080441336427950798","deep","178"),
("1814","1814","4103401084071442684","deep","178"),
("1815","1815","4104095890468520224","deep","178"),
("1816","1816","4110486892744525291","deep","178"),
("1817","1817","4117572697122640602","deep","178"),
("1818","1818","4134141442490127421","deep","178"),
("1819","1819","4134836248887204961","deep","178"),
("1820","1820","4141227251163210028","deep","178"),
("1821","1821","4149007861938402879","deep","178"),
("1822","1822","4151404998549659076","deep","178"),
("1823","1823","4158490802927774387","deep","178"),
("1824","1824","4186834033325137519","deep","178"),
("1825","1825","4189231165641426420","deep","178"),
("1826","1826","4204097585089701878","deep","178"),
("1827","1827","4234143141406276371","deep","178"),
("1828","1828","4238831813468102781","deep","178"),
("1829","1829","4251406693170840730","deep","178"),
("1830","1830","4262486367508672207","deep","178"),
("1831","1831","4272664114895121255","deep","178"),
("1832","1832","4286835727946319173","deep","178"),
("1833","1833","4304099279710883532","deep","178"),
("1834","1834","4327059027354375418","deep","178"),
("1835","1835","4327753833751452958","deep","178"),
("1836","1836","4331747699416201828","deep","178"),
("1837","1837","4334144836027458025","deep","178"),
("1838","1838","4341230640405573336","deep","178"),
("1839","1839","4358494192170137695","deep","178"),
("1840","1840","4372665809516302909","deep","178"),
("1841","1841","4382148746210707121","deep","178"),
("1842","1842","4396320363556872335","deep","178"),
("1843","1843","4410491976608070253","deep","178"),
("1844","1844","4427755528372634612","deep","178"),
("1845","1845","4462489756751035515","deep","178"),
("1846","1846","4475064636453773464","deep","178"),
("1847","1847","4496322058178053989","deep","178"),
("1848","1848","4505804994872458201","deep","178"),
("1849","1849","4510493671229251907","deep","178"),
("1850","1850","4527757222993816266","deep","178"),
("1851","1851","4551411777034385692","deep","178"),
("1852","1852","4555405646994101858","deep","178"),
("1853","1853","4582152135453070429","deep","178"),
("1854","1854","4596323752799235643","deep","178"),
("1855","1855","4605806689493639855","deep","178"),
("1856","1856","4619978306839805069","deep","178"),
("1857","1857","4651413471655567346","deep","178"),
("1858","1858","4698722579736706198","deep","178"),
("1859","1859","4719980001460986723","deep","178"),
("1860","1860","4734151614512184641","deep","178"),
("1861","1861","4751415166276749000","deep","178"),
("1862","1862","4775069720317318426","deep","178"),
("1863","1863","4800753161679980567","deep","178"),
("1864","1864","4805810083030970459","deep","178"),
("1865","1865","4819981696082168377","deep","178"),
("1866","1866","4875071414938500080","deep","178"),
("1867","1867","4900754856301162221","deep","178"),
("1868","1868","4927069195081465342","deep","178"),
("1869","1869","4975073109559681734","deep","178"),
("1870","1870","4998727663600251160","deep","178"),
("1871","1871","5000756550922343875","deep","178"),
("1872","1872","5098729358221432814","deep","178"),
("1873","1873","5100758245543525529","deep","178"),
("1874","1874","5198731052842614468","deep","178"),
("1875","1875","5200759940164707183","deep","178"),
("1876","1876","5300761634785888837","deep","178"),
("1877","1877","5400763329407070491","deep","178"),
("1878","1878","5500765024028252145","deep","178"),
("1879","1879","5600766718649433799","deep","178"),
("1880","1880","9560720869836527593","deep","178"),
("1881","1881","9653636755784626640","deep","178"),
("1882","1882","9739466837354610376","deep","178"),
("1883","1883","9832382723302709423","deep","178"),
("1884","1884","9860725953700072555","deep","178"),
("1885","1885","9925298613545775766","deep","178"),
("1886","1886","9953641839648171602","deep","178"),
("0","0","11677847715316724281","deep","179"),
("1","1","11864668588333343209","deep","179"),
("2","2","12051489461349962137","deep","179"),
("3","3","12238310334366581065","deep","179"),
("4","4","12425131207383199993","deep","179"),
("5","5","12433243591244670856","deep","179"),
("6","6","12611952080399818921","deep","179"),
("7","7","12620064464261289784","deep","179"),
("8","8","12781546884309775504","deep","179"),
("9","9","12798772953416437849","deep","179"),
("10","10","12806885337277908712","deep","179"),
("11","11","12968367753031427136","deep","179"),
("12","12","12985593826433056777","deep","179"),
("13","13","13155188626048046064","deep","179"),
("14","14","13212712964173535978","deep","179"),
("15","15","13291000815747153268","deep","179"),
("16","16","13399533837190154906","deep","179"),
("17","17","13431920616173468707","deep","179"),
("18","18","13477821688763772196","deep","179"),
("19","19","13529286793404567759","deep","179"),
("20","20","13586354705911806538","deep","179"),
("21","21","13618741489190087635","deep","179"),
("22","22","13664642561780391124","deep","179"),
("23","23","13805562362206706563","deep","179"),
("24","24","14089749412454424543","deep","179"),
("25","25","1842473386036953335","deep","179"),
("26","26","2066131329319886069","deep","179"),
("27","27","2475621048793984193","deep","179"),
("28","28","2492884600558548552","deep","179"),
("29","29","2699278992076916927","deep","179"),
("30","30","2716542548136448582","deep","179"),
("31","31","2922936935359849661","deep","179"),
("32","32","3363861823944677358","deep","179"),
("33","33","3477340325219979390","deep","179"),
("34","34","3587519767227610092","deep","179"),
("35","35","3762478993930216190","deep","179"),
("36","36","3811177710510542826","deep","179"),
("37","37","4412890208451811407","deep","179"),
("0","0","12393957639443294870","deep","18"),
("1","1","14359937644906842275","deep","18"),
("2","2","15323845469544528885","deep","18"),
("3","3","17526273421237630296","deep","18"),
("0","0","10118218393169960973","deep","180"),
("1","1","11381543310511971740","deep","180"),
("2","2","11550111534938572771","deep","180"),
("3","3","11568364183528590668","deep","180"),
("4","4","11755185056545209596","deep","180"),
("5","5","12031259718636489417","deep","180"),
("6","6","12122730090730818383","deep","180"),
("7","7","12126848604632573080","deep","180"),
("8","8","12145433030603836285","deep","180"),
("9","9","12178151582673428098","deep","180"),
("10","10","12218080591653108345","deep","180"),
("11","11","12276175083643702676","deep","180"),
("12","12","12309550963747437311","deep","180"),
("13","13","12313669477649192008","deep","180"),
("14","14","12332253899325487917","deep","180"),
("15","15","12364972455690047026","deep","180"),
("16","16","12387306139818884902","deep","180"),
("17","17","12404901464669727273","deep","180"),
("18","18","12496371832469088943","deep","180"),
("19","19","12500490350665810936","deep","180"),
("20","20","12551793328706665954","deep","180"),
("21","21","12574127012835503830","deep","180"),
("22","22","12591722337686346201","deep","180"),
("23","23","12634199698477005237","deep","180"),
("24","24","12683192705485707871","deep","180"),
("25","25","12738614201723284882","deep","180"),
("26","26","12747145524250137570","deep","180"),
("27","27","12760947885852122758","deep","180"),
("28","28","12821020571493624165","deep","180"),
("29","29","12933966397266756498","deep","180"),
("30","30","13007841440215275797","deep","180"),
("31","31","13120787270283375426","deep","180"),
("32","32","13209584642329719776","deep","180"),
("33","33","13225896579926732611","deep","180"),
("34","34","13307608143299994354","deep","180"),
("35","35","13358285053531228066","deep","180"),
("36","36","13396442998004240718","deep","180"),
("37","37","13412717452943351539","deep","180"),
("38","38","13416342067158887679","deep","180"),
("39","39","13546426796459578544","deep","180"),
("40","40","13581285677369952570","deep","180"),
("41","41","13583263866725892350","deep","180"),
("42","42","13599538325959970467","deep","180"),
("43","43","13603162935880539311","deep","180"),
("44","44","13733247669476197472","deep","180"),
("45","45","13768106546091604202","deep","180"),
("46","46","13770084739742511278","deep","180"),
("47","47","13920068542492816400","deep","180"),
("48","48","13954927419108223130","deep","180"),
("49","49","13956905612759130206","deep","180"),
("50","50","14106889415509435328","deep","180"),
("51","51","14141748292124842058","deep","180"),
("52","52","14683626489498402933","deep","180"),
("53","53","14796115893948251427","deep","180"),
("54","54","14982936766964870355","deep","180"),
("55","55","2035392070428653585","deep","180"),
("56","56","2592887394707182459","deep","180"),
("57","57","2816545342285082489","deep","180"),
("58","58","3040203285568015223","deep","180"),
("59","59","3063857839608584649","deep","180"),
("60","60","3263861228850947957","deep","180"),
("61","61","3287515782891517383","deep","180"),
("62","62","3508081787461083676","deep","180"),
("63","63","3511173726174450117","deep","180"),
("64","64","3731739730744016410","deep","180"),
("65","65","3734831669457382851","deep","180"),
("66","66","3955397674026949144","deep","180"),
("67","67","4163181678339472599","deep","180"),
("68","68","4386839621622405333","deep","180"),
("69","69","4610497564905338067","deep","180"),
("70","70","4834155508188270801","deep","180"),
("0","0","11281542715418242339","deep","181"),
("1","1","11481546104660605647","deep","181"),
("2","2","11668366977677224575","deep","181"),
("3","3","11676860817546175249","deep","181"),
("4","4","11828860296605289461","deep","181"),
("5","5","11860589751849427736","deep","181"),
("6","6","11863681690562794177","deep","181"),
("7","7","11952516545267040541","deep","181"),
("8","8","11963683385183975831","deep","181"),
("9","9","11978844099355594583","deep","181"),
("10","10","12047410624866046664","deep","181"),
("11","11","12050502563579413105","deep","181"),
("12","12","12102500348017345663","deep","181"),
("13","13","12139337418283659469","deep","181"),
("14","14","12144739323734210998","deep","181"),
("15","15","12150504258200594759","deep","181"),
("16","16","12165664972372213511","deep","181"),
("17","17","12234231497882665592","deep","181"),
("18","18","12289321221033964591","deep","181"),
("19","19","12294723122189548824","deep","181"),
("20","20","12337325131217213687","deep","181"),
("21","21","12352485841093865143","deep","181"),
("22","22","12421052370899284520","deep","181"),
("23","23","12442728731288946870","deep","181"),
("24","24","12476142089755616223","deep","181"),
("25","25","12481543995206167752","deep","181"),
("26","26","12524146004233832615","deep","181"),
("27","27","12539306714110484071","deep","181"),
("28","28","12629549604305565798","deep","181"),
("29","29","12662962962772235151","deep","181"),
("30","30","12668364868222786680","deep","181"),
("31","31","12675488159553771301","deep","181"),
("32","32","12710966877250451543","deep","181"),
("33","33","12726127587127102999","deep","181"),
("34","34","12816370477322184726","deep","181"),
("35","35","12849783835788854079","deep","181"),
("36","36","12855185741239405608","deep","181"),
("37","37","12862309032570390229","deep","181"),
("38","38","12870802872439340903","deep","181"),
("39","39","12897787750267070471","deep","181"),
("40","40","12912948460143721927","deep","181"),
("41","41","13003191350338803654","deep","181"),
("42","42","13036604708805473007","deep","181"),
("43","43","13042006614256024536","deep","181"),
("44","44","13047151711936102081","deep","181"),
("45","45","13049129901292041861","deep","181"),
("46","46","13057623745455959831","deep","181"),
("47","47","13084608623283689399","deep","181"),
("48","48","13099769333160340855","deep","181"),
("49","49","13134590727117845571","deep","181"),
("50","50","13190012223355422582","deep","181"),
("51","51","13223425581822091935","deep","181"),
("52","52","13228827487272643464","deep","181"),
("53","53","13233972580657753713","deep","181"),
("54","54","13244444618472578759","deep","181"),
("55","55","13286590206176959783","deep","181"),
("56","56","13376833096372041510","deep","181"),
("57","57","13395417518048337419","deep","181"),
("58","58","13410246454838710863","deep","181"),
("59","59","13415648360289262392","deep","181"),
("60","60","13419804356848919103","deep","181"),
("61","61","13420793453674372641","deep","181"),
("62","62","13431265491489197687","deep","181"),
("63","63","13563653969388660438","deep","181"),
("64","64","13570777256424677763","deep","181"),
("65","65","13582238391064956347","deep","181"),
("66","66","13602469233305881320","deep","181"),
("67","67","13606625229865538031","deep","181"),
("68","68","13607614326690991569","deep","181"),
("69","69","13618086364505816615","deep","181"),
("70","70","13750474838110312070","deep","181"),
("71","71","13757598129441296691","deep","181"),
("72","72","13769059264081575275","deep","181"),
("73","73","13787349395329495186","deep","181"),
("74","74","13793446102882156959","deep","181"),
("75","75","13944419002457915619","deep","181"),
("76","76","13946397196108822695","deep","181"),
("77","77","13954891035977773369","deep","181"),
("78","78","13955880132803226907","deep","181"),
("79","79","13962014327308757990","deep","181"),
("80","80","13974170264051146818","deep","181"),
("81","81","13980266975898775887","deep","181"),
("82","82","14131239875474534547","deep","181"),
("83","83","14133218069125441623","deep","181"),
("84","84","14135652684099632538","deep","181"),
("85","85","14141711908994392297","deep","181"),
("86","86","14148835200325376918","deep","181"),
("87","87","14160991137067765746","deep","181"),
("88","88","14318060748491153475","deep","181"),
("89","89","14322473552821284170","deep","181"),
("90","90","14328532782011011225","deep","181"),
("91","91","14335656073341995846","deep","181"),
("92","92","14504881617212805107","deep","181"),
("93","93","14509294425837903098","deep","181"),
("94","94","14522476946358614774","deep","181"),
("95","95","14696115298854522026","deep","181"),
("96","96","14709297819375233702","deep","181"),
("97","97","14882936171871140954","deep","181"),
("98","98","14896118688096885334","deep","181"),
("99","99","15082939561113504262","deep","181"),
("100","100","1935391475334924184","deep","181"),
("101","101","2028307361283023231","deep","181"),
("102","102","2159049418617856918","deep","181"),
("103","103","2251965304565955965","deep","181"),
("104","104","2299969219044172357","deep","181"),
("105","105","2382707361900789652","deep","181"),
("106","106","2523627162327105091","deep","181"),
("107","107","2606365305183722386","deep","181"),
("108","108","2707061806201981580","deep","181"),
("109","109","2747285105610037825","deep","181"),
("110","110","2930719749484914314","deep","181"),
("111","111","2960765305801488807","deep","181"),
("112","112","3053681191749587854","deep","181"),
("113","113","3101685106227804246","deep","181"),
("114","114","3123637330054195015","deep","181"),
("115","115","3154377692767847048","deep","181"),
("116","116","3184423249084421541","deep","181"),
("117","117","3277339135032520588","deep","181"),
("118","118","3325343049510736980","deep","181"),
("119","119","3347295277632095045","deep","181"),
("120","120","3408081192367354275","deep","181"),
("121","121","3500997078315453322","deep","181"),
("122","122","3549000992793669714","deep","181"),
("123","123","3570953220915027779","deep","181"),
("124","124","3631739135650287009","deep","181"),
("125","125","3724655021598386056","deep","181"),
("126","126","3732435636668546203","deep","181"),
("127","127","3772658936076602448","deep","181"),
("128","128","3794611164197960513","deep","181"),
("129","129","3855397078933219743","deep","181"),
("130","130","3948312969176286086","deep","181"),
("131","131","3956093579951478937","deep","181"),
("132","132","3996316879359535182","deep","181"),
("133","133","4018269107480893247","deep","181"),
("134","134","4179751523234411671","deep","181"),
("135","135","4219974822642467916","deep","181"),
("136","136","4241927050763825981","deep","181"),
("137","137","4403409466517344405","deep","181"),
("138","138","4465584994046758715","deep","181"),
("139","139","4627067409800277139","deep","181"),
("140","140","4689242937329691449","deep","181"),
("141","141","4912900880612624183","deep","181"),
("142","142","5700771716147939508","deep","181"),
("143","143","9360720774881553748","deep","181"),
("144","144","9453636665124620091","deep","181"),
("145","145","9546552551072719138","deep","181"),
("146","146","9639468441315785481","deep","181"),
("147","147","9732384327263884528","deep","181"),
("148","148","9825300217506950871","deep","181"),
("149","149","9918216103455049918","deep","181"),
("0","0","10111229342912676630","deep","187"),
("1","1","10132486764636957155","deep","187"),
("2","2","10146658377688155073","deep","187"),
("3","3","10204145233155742973","deep","187"),
("4","4","10232488459258138809","deep","187"),
("5","5","10304146927776924627","deep","187"),
("6","6","10325404349501205152","deep","187"),
("7","7","10497064512641172624","deep","187"),
("8","8","10995804899199274010","deep","187"),
("9","9","11174550871012324089","deep","187"),
("10","10","11270434047436783750","deep","187"),
("11","11","11360382647203489479","deep","187"),
("12","12","11363349933384882797","deep","187"),
("13","13","11398208814295256823","deep","187"),
("14","14","11438013175037931243","deep","187"),
("15","15","11528950867335123214","deep","187"),
("16","16","11547203515925141111","deep","187"),
("17","17","11548192612750594649","deep","187"),
("18","18","11585029687311875751","deep","187"),
("19","19","11587996977788236365","deep","187"),
("20","20","11621866757578189557","deep","187"),
("21","21","11642097599819114530","deep","187"),
("22","22","11697519091761724245","deep","187"),
("23","23","11715771740351742142","deep","187"),
("24","24","11734024388941760039","deep","187"),
("25","25","11808687630594808485","deep","187"),
("26","26","11865755543102047264","deep","187"),
("27","27","11884339964778343173","deep","187"),
("28","28","11900614419717453994","deep","187"),
("29","29","11902592613368361070","deep","187"),
("30","30","11921177035044656979","deep","187"),
("31","31","11921834358783832505","deep","187"),
("32","32","11938440586809221338","deep","187"),
("33","33","11958671429050146311","deep","187"),
("34","34","11960649622701053387","deep","187"),
("35","35","11961638719526506925","deep","187"),
("36","36","11976266758195955978","deep","187"),
("37","37","11977255855021409516","deep","187"),
("38","38","11995508503611427413","deep","187"),
("39","39","12032345573877741219","deep","187"),
("40","40","12034323767528648295","deep","187"),
("41","41","12069182644144055025","deep","187"),
("42","42","12071160837794962101","deep","187"),
("43","43","12072149934620415639","deep","187"),
("44","44","12089413486384979998","deep","187"),
("45","45","12107008811235822369","deep","187"),
("46","46","12107997908061275907","deep","187"),
("47","47","12126250556651293804","deep","187"),
("48","48","12144834978327589713","deep","187"),
("49","49","12147470495717672315","deep","187"),
("50","50","12148459592543125853","deep","187"),
("51","51","12162098534387121368","deep","187"),
("52","52","12163087631212574906","deep","187"),
("53","53","12184307565983986121","deep","187"),
("54","54","12200913798304342250","deep","187"),
("55","55","12219166446894360147","deep","187"),
("56","56","12222133737370720761","deep","187"),
("57","57","12256003517160673953","deep","187"),
("58","58","12256992613986127491","deep","187"),
("59","59","12275577035662423400","deep","187"),
("60","60","12276234359401598926","deep","187"),
("61","61","12292840587426987759","deep","187"),
("62","62","12294487007991616823","deep","187"),
("63","63","12294818781077894835","deep","187"),
("64","64","12295807877903348373","deep","187"),
("65","65","12313071429667912732","deep","187"),
("66","66","12332313175083384167","deep","187"),
("67","67","12349908499934226538","deep","187"),
("68","68","12358972502258216221","deep","187"),
("69","69","12369150245349697973","deep","187"),
("70","70","12371128439000605049","deep","187"),
("71","71","12378214247673687656","deep","187"),
("72","72","12386745574495507640","deep","187"),
("73","73","12407965513561886151","deep","187"),
("74","74","12414062221114547924","deep","187"),
("75","75","12442824390177292881","deep","187"),
("76","76","12444802583828199957","deep","187"),
("77","77","12462397908679042328","deep","187"),
("78","78","12479661460443606687","deep","187"),
("79","79","12481307881008235751","deep","187"),
("80","80","12481639654094513763","deep","187"),
("81","81","12501870496335438736","deep","187"),
("82","82","12518144951274549557","deep","187"),
("83","83","12521112241750910171","deep","187"),
("84","84","12536729372950845466","deep","187"),
("85","85","12555971118366316901","deep","187"),
("86","86","12592808192927598003","deep","187"),
("87","87","12610403517778440374","deep","187"),
("88","88","12611392614603893912","deep","187"),
("89","89","12614028127699009218","deep","187"),
("90","90","12617489322156555685","deep","187"),
("91","91","12629645263193911809","deep","187"),
("92","92","12631623456844818885","deep","187"),
("93","93","12666482333460225615","deep","187"),
("94","94","12668128754024854679","deep","187"),
("95","95","12674557238958761760","deep","187"),
("96","96","12677192752053877066","deep","187"),
("97","97","12686713175701150588","deep","187"),
("98","98","12705954921116622023","deep","187"),
("99","99","12742791991382935829","deep","187"),
("100","100","12744770185033842905","deep","187"),
("101","101","12745759281859296443","deep","187"),
("102","102","12759398219408324662","deep","187"),
("103","103","12760387316233778200","deep","187"),
("104","104","12763022833623860802","deep","187"),
("105","105","12781607255300156711","deep","187"),
("106","106","12797881710239267532","deep","187"),
("107","107","12816466136210530737","deep","187"),
("108","108","12819433422391924055","deep","187"),
("109","109","12822894616849470522","deep","187"),
("110","110","12824541037414099586","deep","187"),
("111","111","12834061461061373108","deep","187"),
("112","112","12836696978451455710","deep","187"),
("113","113","12842136362264941957","deep","187"),
("114","114","12855281400127751619","deep","187"),
("115","115","12855938723866927145","deep","187"),
("116","116","12861378107680413392","deep","187"),
("117","117","12870898531327686914","deep","187"),
("118","118","12873534048717769516","deep","187"),
("119","119","12892775794133240951","deep","187"),
("120","120","12968428128316775639","deep","187"),
("121","121","12982067070160771154","deep","187"),
("122","122","12984045259516710934","deep","187"),
("123","123","12985034356342164472","deep","187"),
("124","124","12986680776906793536","deep","187"),
("125","125","13009715489866089450","deep","187"),
("126","126","13020882334077992036","deep","187"),
("127","127","13040124079493463471","deep","187"),
("128","128","13056730307518852304","deep","187"),
("129","129","13061344018559841982","deep","187"),
("130","130","13065794305547874691","deep","187"),
("131","131","13069418919763410831","deep","187"),
("132","132","13078939343410684353","deep","187"),
("133","133","13079596667149859879","deep","187"),
("134","134","13097191992000702250","deep","187"),
("135","135","13155249001333394567","deep","187"),
("136","136","13170866132533329862","deep","187"),
("137","137","13190107877948801297","deep","187"),
("138","138","13192086071599708373","deep","187"),
("139","139","13227934049335535937","deep","187"),
("140","140","13244540277360924770","deep","187"),
("141","141","13246186697925553834","deep","187"),
("142","142","13246518471011831846","deep","187"),
("143","143","13247175794751007372","deep","187"),
("144","144","13281377347627238576","deep","187"),
("145","145","13318871741632727908","deep","187"),
("146","146","13320849935283634984","deep","187"),
("147","147","13337456163309023817","deep","187"),
("148","148","13339102583873652881","deep","187"),
("149","149","13346520165633013500","deep","187"),
("150","150","13355708811899041714","deep","187"),
("151","151","13357687005549948790","deep","187"),
("152","152","13373304141044851381","deep","187"),
("153","153","13376928750965420225","deep","187"),
("154","154","13378906944616327301","deep","187"),
("155","155","13394524075816262596","deep","187"),
("156","156","13395181399555438122","deep","187"),
("157","157","13396170496380891660","deep","187"),
("158","158","13402598981314798741","deep","187"),
("159","159","13413765825526701327","deep","187"),
("160","160","13415744014882641107","deep","187"),
("161","161","13416733111708094645","deep","187"),
("162","162","13431361150377543698","deep","187"),
("163","163","13433996663472659004","deep","187"),
("164","164","13468198220643857504","deep","187"),
("165","165","13505692614649346836","deep","187"),
("166","166","13525266133151096283","deep","187"),
("167","167","13526912553715725347","deep","187"),
("168","168","13544507878566567718","deep","187"),
("169","169","13563749623982039153","deep","187"),
("170","170","13589419854331417669","deep","187"),
("171","171","13602564887899260035","deep","187"),
("172","172","13617192926568709088","deep","187"),
("173","173","13619828439663824394","deep","187"),
("174","174","13639401962460541137","deep","187"),
("175","175","13655019093660476432","deep","187"),
("176","176","13655676417399651958","deep","187"),
("177","177","13677228129552308481","deep","187"),
("178","178","13694491681316872840","deep","187"),
("179","179","13714065199818622287","deep","187"),
("180","180","13719172814840797818","deep","187"),
("181","181","13731328751583186646","deep","187"),
("182","182","13805002892115814258","deep","187"),
("183","183","13863059905743473871","deep","187"),
("184","184","13900886072835241215","deep","187"),
("185","185","13954986694866119380","deep","187"),
("186","186","14028660839693714288","deep","187"),
("187","187","14047902585109185723","deep","187"),
("188","188","14087706945851860143","deep","187"),
("189","189","14215481708415365920","deep","187"),
("190","190","14311364889134792877","deep","187"),
("191","191","14326650247248450160","deep","187"),
("192","192","14328628440899357236","deep","187"),
("193","193","14365465511165671042","deep","187"),
("194","194","14402302581431984848","deep","187"),
("195","195","14457392304583283847","deep","187"),
("196","196","14588134357623150238","deep","187"),
("197","197","14597198359947139921","deep","187"),
("198","198","14774955230639769166","deep","187"),
("199","199","14775944327465222704","deep","187"),
("200","200","1835485435307121245","deep","187"),
("201","201","1928401325550187588","deep","187"),
("202","202","2035488824549484553","deep","187"),
("203","203","2149662136516831421","deep","187"),
("204","204","2152059268833120322","deep","187"),
("205","205","2166230881884318240","deep","187"),
("206","206","2221320600740649943","deep","187"),
("207","207","2282801321872986713","deep","187"),
("208","208","2307150682310633679","deep","187"),
("209","209","2335493912707996811","deep","187"),
("210","210","2359148466748566237","deep","187"),
("211","211","2366234271126681548","deep","187"),
("212","212","2442581411707293776","deep","187"),
("213","213","2444978544023582677","deep","187"),
("214","214","2468633098064152103","deep","187"),
("215","215","2485896649828716462","deep","187"),
("216","216","2489890519788432628","deep","187"),
("217","217","2523722821215451102","deep","187"),
("218","218","2537894434266649020","deep","187"),
("219","219","2559151855990929545","deep","187"),
("220","220","2568634792685333757","deep","187"),
("221","221","2582806410031498971","deep","187"),
("222","222","2596978023082696889","deep","187"),
("223","223","2616638707163550149","deep","187"),
("224","224","2630810320214748067","deep","187"),
("225","225","2635498996571541773","deep","187"),
("226","226","2661550682928400100","deep","187"),
("227","227","2666239354990226510","deep","187"),
("228","228","2689893909030795936","deep","187"),
("229","229","2696979717703878543","deep","187"),
("230","230","2716640401784731803","deep","187"),
("231","231","2730117212733819477","deep","187"),
("232","232","2744288825785017395","deep","187"),
("233","233","2744983632182094935","deep","187"),
("234","234","2782809799273862279","deep","187"),
("235","235","2806464353314431705","deep","187"),
("236","236","2823033098681918524","deep","187"),
("237","237","2823727905078996064","deep","187"),
("238","238","2830118907355001131","deep","187"),
("239","239","2852071131181391900","deep","187"),
("240","240","2860859265773685868","deep","187"),
("241","241","2885208626211332834","deep","187"),
("242","242","2914246658710806210","deep","187"),
("243","243","2937901212751375636","deep","187"),
("244","244","2961555766791945062","deep","187"),
("245","245","2992990931607707339","deep","187"),
("246","246","3000076740280789946","deep","187"),
("247","247","3006467742556795013","deep","187"),
("248","248","3007162548953872553","deep","187"),
("249","249","3037902907372557290","deep","187"),
("250","250","3044293909648562357","deep","187"),
("251","251","3047385848361928798","deep","187"),
("252","252","3085212015453696142","deep","187"),
("253","253","3106469437177976667","deep","187"),
("254","254","3120641050229174585","deep","187"),
("255","255","3161559156034308370","deep","187"),
("256","256","3167950158310313437","deep","187"),
("257","257","3223039877166645140","deep","187"),
("258","258","3223734683563722680","deep","187"),
("259","259","3233217624553094188","deep","187"),
("260","260","3240303433226176795","deep","187"),
("261","261","3244297298890925665","deep","187"),
("262","262","3253780239880297173","deep","187"),
("263","263","3267951852931495091","deep","187"),
("264","264","3285910211093136990","deep","187"),
("265","265","3292301213369142057","deep","187"),
("266","266","3306472826420339975","deep","187"),
("267","267","3308175152339551336","deep","187"),
("268","268","3308869958736628876","deep","187"),
("269","269","3309564765133706416","deep","187"),
("270","270","3315955767409711483","deep","187"),
("271","271","3323041571787826794","deep","187"),
("272","272","3332524512777198302","deep","187"),
("273","273","3344298993512107319","deep","187"),
("274","274","3347390932225473760","deep","187"),
("275","275","3353781934501478827","deep","187"),
("276","276","3385217099317241104","deep","187"),
("277","277","3409566459754888070","deep","187"),
("278","278","3416652268427970677","deep","187"),
("279","279","3432526207398379956","deep","187"),
("280","280","3438917209674385023","deep","187"),
("281","281","3440306822468540103","deep","187"),
("282","282","3453783629122660481","deep","187"),
("283","283","3456180761438949382","deep","187"),
("284","284","3463266570112031989","deep","187"),
("285","285","3467955242173858399","deep","187"),
("286","286","3471047180887224840","deep","187"),
("287","287","3477438183163229907","deep","187"),
("288","288","3485218793938422758","deep","187"),
("289","289","3491609796214427825","deep","187"),
("290","290","3501787543600876873","deep","187"),
("291","291","3511270484590248381","deep","187"),
("292","292","3533222708416639150","deep","187"),
("293","293","3540308517089721757","deep","187"),
("294","294","3563963071130291183","deep","187"),
("295","295","3580531816497778002","deep","187"),
("296","296","3601094431824980987","deep","187"),
("297","297","3632529596640743264","deep","187"),
("298","298","3653787018365023789","deep","187"),
("299","299","3670355768027477904","deep","187"),
("300","300","3680533511118959656","deep","187"),
("301","301","3715267739497360559","deep","187"),
("302","302","3733226097659002458","deep","187"),
("303","303","3739617099935007525","deep","187"),
("304","304","3755491043200384100","deep","187"),
("305","305","3756880651699571884","deep","187"),
("306","306","3779840399343063770","deep","187"),
("307","307","3801792627464421835","deep","187"),
("308","308","3825447181504991261","deep","187"),
("309","309","3856187544218643294","deep","187"),
("310","310","3884530770321039130","deep","187"),
("311","311","3886927902637328031","deep","187"),
("312","312","3903496648004814850","deep","187"),
("313","313","3910582456677897457","deep","187"),
("314","314","3911277263074974997","deep","187"),
("315","315","3925448876126172915","deep","187"),
("316","316","3955494432442747408","deep","187"),
("317","317","3956884040941935192","deep","187"),
("318","318","3958586371156113849","deep","187"),
("319","319","3979843792880394374","deep","187"),
("320","320","3980538594982504618","deep","187"),
("321","321","4008187018982790210","deep","187"),
("322","322","4011278957696156651","deep","187"),
("323","323","4038927381696442243","deep","187"),
("324","324","4055496127063929062","deep","187"),
("325","325","4062581935737011669","deep","187"),
("326","326","4089328424195980240","deep","187"),
("327","327","4117671654593343372","deep","187"),
("328","328","4131843267644541290","deep","187"),
("329","329","4141326208633912798","deep","187"),
("330","330","4218368155611602566","deep","187"),
("331","331","4227851092306006778","deep","187"),
("332","332","4241327903255094452","deep","187"),
("333","333","4310589235162624073","deep","187"),
("334","334","4327157984825078188","deep","187"),
("335","335","4348415406549358713","deep","187"),
("336","336","4379850571365120990","deep","187"),
("337","337","4427854485843337382","deep","187"),
("338","338","4455502905548655678","deep","187"),
("339","339","4458594844262022119","deep","187"),
("340","340","4510592624404987381","deep","187"),
("341","341","4558596538883203773","deep","187"),
("342","342","4612991455637425232","deep","187"),
("343","343","4627857875085700690","deep","187"),
("344","344","4641334681739821068","deep","187"),
("345","345","4682252787544954853","deep","187"),
("346","346","4689338596218037460","deep","187"),
("347","347","4812994844879788540","deep","187"),
("348","348","4900853813771864991","deep","187"),
("349","349","4975172067030384504","deep","187"),
("350","350","5700867370741318223","deep","187"),
("351","351","9546648209961065149","deep","187"),
("352","352","9560819823012263067","deep","187"),
("353","353","9825395872100329586","deep","187"),
("354","354","9832481680773412193","deep","187"),
("355","355","9846653293824610111","deep","187"),
("356","356","9918311762343395929","deep","187"),
("0","0","12434495388768401097","deep","19"),
("1","1","16222059932455553376","deep","19"),
("0","0","13447496675584483051","deep","2"),
("1","1","14690092791348392128","deep","2"),
("2","2","14796455178639358034","deep","2"),
("3","3","14980179061817317522","deep","2"),
("4","4","15662904609341548780","deep","2"),
("5","5","15707874320078585030","deep","2"),
("6","6","15895149488197132301","deep","2"),
("7","7","16352188827047518474","deep","2"),
("0","0","14673711438515263292","deep","20"),
("1","1","16253885709152199513","deep","20"),
("0","0","14659865520731147144","deep","21"),
("1","1","14729024587232278015","deep","21"),
("0","0","12910539260321466267","deep","22"),
("1","1","14386196267830256972","deep","22"),
("2","2","14556391146392735311","deep","22"),
("3","3","14762945542584656031","deep","22"),
("4","4","14859870013795930001","deep","22"),
("5","5","15047679979343035171","deep","22"),
("6","6","15524255354037268777","deep","22"),
("7","7","15557186108741773706","deep","22"),
("8","8","15577404361900595418","deep","22"),
("9","9","15732190485629430138","deep","22"),
("10","10","15749504109133999772","deep","22"),
("11","11","16000478699035972790","deep","22"),
("12","12","16142387596287741767","deep","22"),
("13","13","16363063538085822426","deep","22"),
("14","14","16374466933458947415","deep","22"),
("15","15","16433876072927892798","deep","22"),
("16","16","16503815666311437200","deep","22"),
("17","17","16506308020552781710","deep","22"),
("18","18","16683046368108007199","deep","22"),
("19","19","16701203794772969487","deep","22"),
("20","20","17037848465866341192","deep","22"),
("21","21","17038557983271910193","deep","22"),
("22","22","17219759211192238948","deep","22"),
("23","23","17533767851382444983","deep","22"),
("24","24","17539410263833178413","deep","22"),
("0","0","11933502212651881005","deep","23"),
("1","1","12808892244663107802","deep","23"),
("2","2","12955414848660899161","deep","23"),
("3","3","13309889814594469610","deep","23"),
("4","4","13572325539136721212","deep","23"),
("5","5","14166636049621391232","deep","23"),
("6","6","14406884630921918037","deep","23"),
("7","7","14789620680295431799","deep","23"),
("8","8","14839748077794648855","deep","23"),
("9","9","15022437843532442529","deep","23"),
("10","10","15357666422789027075","deep","23"),
("11","11","15537785458180202179","deep","23"),
("12","12","15760989106361206570","deep","23"),
("13","13","15827338760838173676","deep","23"),
("14","14","15910598112061538842","deep","23"),
("15","15","15925816561205343893","deep","23"),
("16","16","15978710346765029876","deep","23"),
("17","17","16182085249845676866","deep","23"),
("18","18","16470006847242478056","deep","23"),
("19","19","16549630284031285653","deep","23"),
("20","20","16637194340563805742","deep","23"),
("21","21","17047673156863357404","deep","23"),
("22","22","17178964726930207747","deep","23"),
("23","23","17425238055688251094","deep","23"),
("24","24","17539865662757526305","deep","23"),
("25","25","2592458587590738381","deep","23"),
("0","0","14326125781243660071","deep","24"),
("1","1","15498516998688505207","deep","24"),
("0","0","15002866524085597588","deep","25"),
("1","1","16588607751676963386","deep","25"),
("0","0","14838212762524568124","deep","26"),
("1","1","14885602377227303828","deep","26"),
("0","0","16012625422407131422","deep","27"),
("1","1","16216506818551067526","deep","27"),
("0","0","16354350495094927534","deep","28"),
("1","1","17284323752899196920","deep","28"),
("0","0","11783106068400907576","deep","29"),
("1","1","12493314105127275781","deep","29"),
("2","2","13029427363739485599","deep","29"),
("3","3","13034534978761661130","deep","29"),
("4","4","13252096210196964795","deep","29"),
("5","5","13307424314127090199","deep","29"),
("6","6","13671344734097162846","deep","29"),
("7","7","14018658930336813956","deep","29"),
("8","8","14079882839403709446","deep","29"),
("9","9","14130121755303306898","deep","29"),
("10","10","14380832364383124733","deep","29"),
("11","11","14594262492834570440","deep","29"),
("12","12","14634189375592895191","deep","29"),
("13","13","14712955541139903572","deep","29"),
("14","14","14735202059689637635","deep","29"),
("15","15","14812373241296858057","deep","29"),
("16","16","14949066716814259929","deep","29"),
("17","17","14997763307173231069","deep","29"),
("18","18","15036485479681719134","deep","29"),
("19","19","15117513240273173272","deep","29"),
("20","20","15189047060554953263","deep","29"),
("21","21","15265748357052450580","deep","29"),
("22","22","15427376062176062592","deep","29"),
("23","23","15490994981632858783","deep","29"),
("24","24","15535077865245807541","deep","29"),
("25","25","15670782243937755875","deep","29"),
("26","26","15747958476670269296","deep","29"),
("27","27","15853926309072445188","deep","29"),
("28","28","15896403665568136928","deep","29"),
("29","29","15935986190453047702","deep","29"),
("30","30","15941922893332157130","deep","29"),
("31","31","15947324798782708659","deep","29"),
("32","32","16113525317204971007","deep","29"),
("33","33","16142235288306355193","deep","29"),
("34","34","16157021205428001095","deep","29"),
("35","35","16163507425334094475","deep","29"),
("36","36","16293355603473562937","deep","29"),
("37","37","16345272881289898643","deep","29"),
("38","38","16553740684089262407","deep","29"),
("39","39","16584748858188658359","deep","29"),
("40","40","16625117451261775488","deep","29"),
("41","41","16706708614545775100","deep","29"),
("42","42","16808701091899967091","deep","29"),
("43","43","16814850001708956931","deep","29"),
("44","44","17036917137473058700","deep","29"),
("45","45","17110699084717877886","deep","29"),
("46","46","17173424129274276148","deep","29"),
("47","47","17209711682513606002","deep","29"),
("48","48","17324239146102870663","deep","29"),
("49","49","17647948855746990326","deep","29"),
("0","0","13544038275275570491","deep","3"),
("1","1","14636932289635447183","deep","3"),
("2","2","14772781961992456401","deep","3"),
("3","3","15399333467614879513","deep","3"),
("4","4","15868260931821910595","deep","3"),
("5","5","16170379320434116225","deep","3"),
("6","6","16608054391853380632","deep","3"),
("0","0","12559901129370990629","deep","31"),
("1","1","12941085105400594931","deep","31"),
("2","2","14564710239350881668","deep","31"),
("3","3","14854922037056116190","deep","31"),
("4","4","15113689831110352616","deep","31"),
("5","5","15165557037186683047","deep","31"),
("6","6","15197381714355876931","deep","31"),
("7","7","15231691078239267005","deep","31"),
("8","8","15340931490866482148","deep","31"),
("9","9","15366659460483014259","deep","31"),
("10","10","15391245372081883628","deep","31"),
("11","11","15580104299942951427","deep","31"),
("12","12","15620789950798887811","deep","31"),
("13","13","15643650769124102562","deep","31"),
("14","14","15734096683661464176","deep","31"),
("15","15","15752788916344918955","deep","31"),
("16","16","15823051934160005375","deep","31"),
("17","17","15854891326632658016","deep","31"),
("18","18","15936482494211624924","deep","31"),
("19","19","15966486856182108581","deep","31"),
("20","20","16018441616656346301","deep","31"),
("21","21","16125441565552703273","deep","31"),
("22","22","16165845510767399624","deep","31"),
("23","23","16311150815433251036","deep","31"),
("24","24","16504572767139432651","deep","31"),
("25","25","16690903988617576718","deep","31"),
("26","26","16818516620286174654","deep","31"),
("27","27","16872117801325041438","deep","31"),
("28","28","17229544953612710268","deep","31"),
("29","29","17431541251809439409","deep","31"),
("30","30","17933492562129708237","deep","31"),
("31","31","17953788191414097242","deep","31"),
("32","32","3290847745914911835","deep","31"),
("0","0","11530171499456329861","deep","32"),
("1","1","11863019787921439759","deep","32"),
("2","2","11880890976209010549","deep","32"),
("3","3","11940356025327505525","deep","32"),
("4","4","11996729131437666764","deep","32"),
("5","5","12040357719948687179","deep","32"),
("6","6","12055518429825338635","deep","32"),
("7","7","12088655924855279569","deep","32"),
("8","8","12158249029849087202","deep","32"),
("9","9","12178185581661636177","deep","32"),
("10","10","12233275300517967880","deep","32"),
("11","11","12270112375079248982","deep","32"),
("12","12","12293347986159469287","deep","32"),
("13","13","12299863636672480181","deep","32"),
("14","14","12337984094192623523","deep","32"),
("15","15","12369419263303353096","deep","32"),
("16","16","12377494164506921945","deep","32"),
("17","17","12434599559672062738","deep","32"),
("18","18","12450141729851161301","deep","32"),
("19","19","12494064608790557714","deep","32"),
("20","20","12533537196446954122","deep","32"),
("21","21","12570830688036551767","deep","32"),
("22","22","12614002855224288343","deep","32"),
("23","23","12685993092534384877","deep","32"),
("24","24","12699175613055096553","deep","32"),
("25","25","12710875128474201542","deep","32"),
("26","26","12773801367755275689","deep","32"),
("27","27","12798150728192922655","deep","32"),
("28","28","12841378800735241528","deep","32"),
("29","29","12876476062424441959","deep","32"),
("30","30","12917725941315853756","deep","32"),
("31","31","12937956783556778729","deep","32"),
("32","32","12973767274339736983","deep","32"),
("33","33","13068698840891612416","deep","32"),
("34","34","13082300295782738621","deep","32"),
("35","35","13089624485234647633","deep","32"),
("36","36","13142372981424240028","deep","32"),
("37","37","13149164499668946637","deep","32"),
("38","38","13161282953753433451","deep","32"),
("39","39","13266724036483068648","deep","32"),
("40","40","13332323275812127411","deep","32"),
("41","41","13358945120329057451","deep","32"),
("42","42","13366725731104250302","deep","32"),
("43","43","13391075091541897268","deep","32"),
("44","44","13466032619328354416","deep","32"),
("45","45","13479215139849066092","deep","32"),
("46","46","13482307074267465237","deep","32"),
("47","47","13486958267966356929","deep","32"),
("48","48","13491790015256836745","deep","32"),
("49","49","13521084859821751401","deep","32"),
("50","50","13542342281546031926","deep","32"),
("51","51","13600855712202008082","deep","32"),
("52","52","13648108910633597341","deep","32"),
("53","53","13701883986306545288","deep","32"),
("54","54","13711605308074743201","deep","32"),
("55","55","13731560286878939755","deep","32"),
("56","56","13766969555225666442","deep","32"),
("57","57","13771490170562956007","deep","32"),
("58","58","13847417497773850405","deep","32"),
("59","59","13860361628925801084","deep","32"),
("60","60","13885662603530999574","deep","32"),
("61","61","13923488770622766918","deep","32"),
("62","62","13952821097845583588","deep","32"),
("63","63","14039640271946053566","deep","32"),
("64","64","14040170022544285762","deep","32"),
("65","65","14054963112717612863","deep","32"),
("66","66","14082574054059996441","deep","32"),
("67","67","14088064004088955084","deep","32"),
("68","68","14091762704620991951","deep","32"),
("69","69","14094767477755254579","deep","32"),
("70","70","14169922983053665911","deep","32"),
("71","71","14180040864951605868","deep","32"),
("72","72","14197166304692725134","deep","32"),
("73","73","14206925109118825061","deep","32"),
("74","74","14248174988010236858","deep","32"),
("75","75","14266427636600254755","deep","32"),
("76","76","14277999578878416414","deep","32"),
("77","77","14308300361793598861","deep","32"),
("78","78","14308752530674171708","deep","32"),
("79","79","14326443077450069688","deep","32"),
("80","80","14355919815043676645","deep","32"),
("81","81","14384514797791253466","deep","32"),
("82","82","14396108632719522377","deep","32"),
("83","83","14411303824328384346","deep","32"),
("84","84","14455154743172635528","deep","32"),
("85","85","14456246105404487816","deep","32"),
("86","86","14456253282751136311","deep","32"),
("87","87","14470330168352745741","deep","32"),
("88","88","14499142404860528677","deep","32"),
("89","89","14514317830040638890","deep","32"),
("90","90","14561325109736591482","deep","32"),
("91","91","14571335670807872394","deep","32"),
("92","92","14575893768803063973","deep","32"),
("93","93","14596551606055322567","deep","32"),
("94","94","14599643544768689008","deep","32"),
("95","95","14610592645039885654","deep","32"),
("96","96","14615308621487274082","deep","32"),
("97","97","14635988347094672632","deep","32"),
("98","98","14644444708600688588","deep","32"),
("99","99","14646548425192937496","deep","32"),
("100","100","14652522615024916234","deep","32"),
("101","101","14666231880923201309","deep","32"),
("102","102","14680308272049343618","deep","32"),
("103","103","14700099534491799005","deep","32"),
("104","104","14706196246339428074","deep","32"),
("105","105","14719378762565172454","deep","32"),
("106","106","14734406772153833583","deep","32"),
("107","107","14751013000179222416","deep","32"),
("108","108","14776286670398858888","deep","32"),
("109","109","14843035011226923534","deep","32"),
("110","110","14859314517291327354","deep","32"),
("111","111","14865698342220683926","deep","32"),
("112","112","14866233143944209121","deep","32"),
("113","113","14887505280971948403","deep","32"),
("114","114","14906104413656735773","deep","32"),
("115","115","14909621221160080339","deep","32"),
("116","116","14910158149104961030","deep","32"),
("117","117","14931378088171339541","deep","32"),
("118","118","14932988662118922262","deep","32"),
("119","119","14944919681868923951","deep","32"),
("120","120","14948386413337295946","deep","32"),
("121","121","14962718035357013505","deep","32"),
("122","122","14964003548832198537","deep","32"),
("123","123","14967775574344216465","deep","32"),
("124","124","14971811463992953406","deep","32"),
("125","125","14975805329657702276","deep","32"),
("126","126","15018796851038798746","deep","32"),
("127","127","15019532847486999826","deep","32"),
("128","128","15039801172385826813","deep","32"),
("129","129","15046959431334554476","deep","32"),
("130","130","15057562043216014353","deep","32"),
("131","131","15088462410603218731","deep","32"),
("132","132","15089248478791425086","deep","32"),
("133","133","15099961023606432033","deep","32"),
("134","134","15107608934093634557","deep","32"),
("135","135","15113048322202088100","deep","32"),
("136","136","15121795262448291232","deep","32"),
("137","137","15131236188043609261","deep","32"),
("138","138","15145876811500194279","deep","32"),
("139","139","15156025128279725813","deep","32"),
("140","140","15156039839288217274","deep","32"),
("141","141","15175771240537130866","deep","32"),
("142","142","15180878851264339101","deep","32"),
("143","143","15183848267962055211","deep","32"),
("144","144","15190896593977235804","deep","32"),
("145","145","15217116337058630976","deep","32"),
("146","146","15241370479866189629","deep","32"),
("147","147","15267979731006049112","deep","32"),
("148","148","15297276701792319264","deep","32"),
("149","149","15305019829909610101","deep","32"),
("150","150","15318403545154997662","deep","32"),
("151","151","15321798651690654540","deep","32"),
("152","152","15323119525897353386","deep","32"),
("153","153","15324058550982801649","deep","32"),
("154","154","15330277780551113753","deep","32"),
("155","155","15335320612824792548","deep","32"),
("156","156","15336309709650246086","deep","32"),
("157","157","15359414746663831560","deep","32"),
("158","158","15360456041450645869","deep","32"),
("159","159","15361942453046755292","deep","32"),
("160","160","15366015821058426951","deep","32"),
("161","161","15367100139808936098","deep","32"),
("162","162","15373746364388581823","deep","32"),
("163","163","15377704877911751471","deep","32"),
("164","164","15389753007941948725","deep","32"),
("165","165","15402852895619708053","deep","32"),
("166","166","15415385755633425227","deep","32"),
("167","167","15427202251762387723","deep","32"),
("168","168","15461019837885947440","deep","32"),
("169","169","15488728123079774827","deep","32"),
("170","170","15490916393144239523","deep","32"),
("171","171","15501865493415436169","deep","32"),
("172","172","15510974641629508890","deep","32"),
("173","173","15518529460707978597","deep","32"),
("174","174","15532311561405744908","deep","32"),
("175","175","15548316078737756314","deep","32"),
("176","176","15556233105784095610","deep","32"),
("177","177","15570916753204375466","deep","32"),
("178","178","15571638859692047728","deep","32"),
("179","179","15573936237347129555","deep","32"),
("180","180","15574390532449057898","deep","32"),
("181","181","15582964883234572720","deep","32"),
("182","182","15587081275209939217","deep","32"),
("183","183","15587790792615508218","deep","32"),
("184","184","15589169401794393363","deep","32"),
("185","185","15612577606630269274","deep","32"),
("186","186","15614507854762526571","deep","32"),
("187","187","15614839627848804583","deep","32"),
("188","188","15616977826173264004","deep","32"),
("189","189","15627499935728094325","deep","32"),
("190","190","15632153251353374217","deep","32"),
("191","191","15633706580509270464","deep","32"),
("192","192","15662951349039212549","deep","32"),
("193","193","15674941744097223504","deep","32"),
("194","194","15675491261124207456","deep","32"),
("195","195","15677029870681677650","deep","32"),
("196","196","15677737266160858451","deep","32"),
("197","197","15678618551979153119","deep","32"),
("198","198","15681096190917038872","deep","32"),
("199","199","15681600557758972490","deep","32"),
("200","200","15706326841467947802","deep","32"),
("201","201","15706766421266417388","deep","32"),
("202","202","15715405554800428946","deep","32"),
("203","203","15715498646209161763","deep","32"),
("204","204","15730016747650096450","deep","32"),
("205","205","15733606005429086072","deep","32"),
("206","206","15738705952924113283","deep","32"),
("207","207","15750210111528086705","deep","32"),
("208","208","15751908725759109244","deep","32"),
("209","209","15754328625429841402","deep","32"),
("210","210","15755477726928847285","deep","32"),
("211","211","15764448633549136855","deep","32"),
("212","212","15768073247764672995","deep","32"),
("213","213","15774012081160105215","deep","32"),
("214","214","15785950278256755399","deep","32"),
("215","215","15786499790988772055","deep","32"),
("216","216","15791323578443319353","deep","32"),
("217","217","15791765284463144435","deep","32"),
("218","218","15807929806468708186","deep","32"),
("219","219","15810392730103135182","deep","32"),
("220","220","15828442350055905896","deep","32"),
("221","221","15830582674601720813","deep","32"),
("222","222","15831961279485638662","deep","32"),
("223","223","15859330128361007013","deep","32"),
("224","224","15860989138007739338","deep","32"),
("225","225","15864450328170318509","deep","32"),
("226","226","15874013775781286869","deep","32"),
("227","227","15874345548867564881","deep","32"),
("228","228","15875160751058937256","deep","32"),
("229","229","15876887970553947370","deep","32"),
("230","230","15884023846672067956","deep","32"),
("231","231","15940599985714443674","deep","32"),
("232","232","15949680825268280314","deep","32"),
("233","233","15952755922456832502","deep","32"),
("234","234","15953235111134559598","deep","32"),
("235","235","15958195310565286045","deep","32"),
("236","236","15963960245031669806","deep","32"),
("237","237","15974028059484571784","deep","32"),
("238","238","15985084966467960004","deep","32"),
("239","239","16002335929150421102","deep","32"),
("240","240","16009718154473235203","deep","32"),
("241","241","16010265545278863659","deep","32"),
("242","242","16010865129750885590","deep","32"),
("243","243","16018940030954454439","deep","32"),
("244","244","16026372328017273815","deep","32"),
("245","245","16026964864712985309","deep","32"),
("246","246","16027456642472815666","deep","32"),
("247","247","16044075459580307760","deep","32"),
("248","248","16055727033775730266","deep","32"),
("249","249","16071502043427862410","deep","32"),
("250","250","16087998338519704173","deep","32"),
("251","251","16097563912352028029","deep","32"),
("252","252","16099822506470782285","deep","32"),
("253","253","16121471562474882617","deep","32"),
("254","254","16124343631026187622","deep","32"),
("255","255","16127420854436095306","deep","32"),
("256","256","16139174694037916562","deep","32"),
("257","257","16140949863346543751","deep","32"),
("258","258","16149684214510643622","deep","32"),
("259","259","16163364049802011183","deep","32"),
("260","260","16164857513469398339","deep","32"),
("261","261","16168374320972742905","deep","32"),
("262","262","16195000413637416641","deep","32"),
("263","263","16195050485377421916","deep","32"),
("264","264","16206215203367969006","deep","32"),
("265","265","16217354738899342278","deep","32"),
("266","266","16219347647853708111","deep","32"),
("267","267","16236393459972533826","deep","32"),
("268","268","16241111562641277750","deep","32"),
("269","269","16250088010567360144","deep","32"),
("270","270","16250687595039382075","deep","32"),
("271","271","16256676495879852274","deep","32"),
("272","272","16258165037992284489","deep","32"),
("273","273","16266694238592748977","deep","32"),
("274","274","16281465436115968826","deep","32"),
("275","275","16284996958922772149","deep","32"),
("276","276","16304570477424521596","deep","32"),
("277","277","16307635111752326019","deep","32"),
("278","278","16327880669296709749","deep","32"),
("279","279","16330298442746086411","deep","32"),
("280","280","16331382757201628262","deep","32"),
("281","281","16331997061272076246","deep","32"),
("282","282","16361733607561848688","deep","32"),
("283","283","16366241638112002288","deep","32"),
("284","284","16366753668186116930","deep","32"),
("285","285","16399024977225058133","deep","32"),
("286","286","16399509707208578053","deep","32"),
("287","287","16405056902029223170","deep","32"),
("288","288","16417335360787262329","deep","32"),
("289","289","16420846626984814071","deep","32"),
("290","290","16424755068767978444","deep","32"),
("291","291","16437900102335820810","deep","32"),
("292","292","16443936952989908084","deep","32"),
("293","293","16450597892873012566","deep","32"),
("294","294","16474830268305834729","deep","32"),
("295","295","16483316444942604379","deep","32"),
("296","296","16500673092410868851","deep","32"),
("297","297","16507708829343946183","deep","32"),
("298","298","16512561217767513760","deep","32"),
("299","299","16528871029143171099","deep","32"),
("300","300","16542725584411549762","deep","32"),
("301","301","16545037677370090346","deep","32"),
("302","302","16545439774510657918","deep","32"),
("303","303","16548019678854942421","deep","32"),
("304","304","16563679834018572554","deep","32"),
("305","305","16567701008363850738","deep","32"),
("306","306","16569131811209129358","deep","32"),
("307","307","16573358136118042925","deep","32"),
("308","308","16578905330938688042","deep","32"),
("309","309","16583960747999502802","deep","32"),
("310","310","16602545169675798711","deep","32"),
("311","311","16606518398502427116","deep","32"),
("312","312","16613764211849062068","deep","32"),
("313","313","16627740463790161123","deep","32"),
("314","314","16657085375800113758","deep","32"),
("315","315","16659123430644562629","deep","32"),
("316","316","16668252220012016344","deep","32"),
("317","317","16691467189959148888","deep","32"),
("318","318","16709597316533516454","deep","32"),
("319","319","16723341938868348047","deep","32"),
("320","320","16730831970903353722","deep","32"),
("321","321","16731323748663184079","deep","32"),
("322","322","16741876288804638681","deep","32"),
("323","323","16758430323163634039","deep","32"),
("324","324","16824774436334808321","deep","32"),
("325","325","16836220855671628148","deep","32"),
("326","326","16842427500452804287","deep","32"),
("327","327","16862065805998017766","deep","32"),
("328","328","16902622708109956025","deep","32"),
("329","329","16910602391683436561","deep","32"),
("330","330","16925569866671344650","deep","32"),
("331","331","16949969298848996891","deep","32"),
("332","332","16974063432688035903","deep","32"),
("333","333","16994281685846857615","deep","32"),
("334","334","17002371306648852517","deep","32"),
("335","335","17013133923203864739","deep","32"),
("336","336","17017054949774165077","deep","32"),
("337","337","17020059722908427705","deep","32"),
("338","338","17023641313160269007","deep","32"),
("339","339","17037177985302898476","deep","32"),
("340","340","17053927380771992697","deep","32"),
("341","341","17055575923263009961","deep","32"),
("342","342","17076153253893671703","deep","32"),
("343","343","17129594430258986142","deep","32"),
("344","344","17177743634107296122","deep","32"),
("345","345","17194751959273252527","deep","32"),
("346","346","17206505798875073783","deep","32"),
("347","347","17216963121386440072","deep","32"),
("348","348","17217952218211893610","deep","32"),
("349","349","17242728569365906901","deep","32"),
("350","350","17257426932089645514","deep","32"),
("351","351","17271063747712285533","deep","32"),
("352","352","17281118968788116954","deep","32"),
("353","353","17293859778994036252","deep","32"),
("354","354","17320469034428863031","deep","32"),
("355","355","17328558650935890637","deep","32"),
("356","356","17377052216952581890","deep","32"),
("357","357","17381133252491401869","deep","32"),
("358","358","17384138025625664497","deep","32"),
("359","359","17398836384054435814","deep","32"),
("360","360","17420485444353503442","deep","32"),
("361","361","17461388834855178470","deep","32"),
("362","362","17484104363810299633","deep","32"),
("363","363","17494706975691759510","deep","32"),
("364","364","17496150367619141391","deep","32"),
("365","365","17512424822558252212","deep","32"),
("366","366","17513559208753799338","deep","32"),
("367","367","17525447334110444247","deep","32"),
("368","368","17586633764814405019","deep","32"),
("369","369","17630129653037435107","deep","32"),
("370","370","17671864261912366824","deep","32"),
("371","371","17701810884615696886","deep","32"),
("372","372","17720503117299151665","deep","32"),
("373","373","17735078953712272651","deep","32"),
("374","374","17743168574514267553","deep","32"),
("375","375","17753236384672202235","deep","32"),
("376","376","17775447546785389780","deep","32"),
("377","377","17804245072284681255","deep","32"),
("378","378","17873910627554133944","deep","32"),
("379","379","17922499415495880806","deep","32"),
("380","380","17927007441751067110","deep","32"),
("381","381","17960875095319664806","deep","32"),
("382","382","17999250779438416102","deep","32"),
("383","383","18053645696192637561","deep","32"),
("384","384","1934729568398602470","deep","32"),
("385","385","2234734652262147432","deep","32"),
("386","386","2541825544798775001","deep","32"),
("387","387","2543527870717986362","deep","32"),
("388","388","2667878925776814982","deep","32"),
("389","389","2913489097181105781","deep","32"),
("390","390","3422285704879308019","deep","32"),
("391","391","3439549256643872378","deep","32"),
("392","392","3545941953541059099","deep","32"),
("393","393","3883773204496371405","deep","32"),
("394","394","4200347038022370482","deep","32"),
("0","0","12012623229896750027","deep","33"),
("1","1","12499135840682283484","deep","33"),
("2","2","12557230332672877815","deep","33"),
("3","3","12802803017124299304","deep","33"),
("4","4","12804542829996379975","deep","33"),
("5","5","13277891975927456191","deep","33"),
("6","6","13571800352238339380","deep","33"),
("7","7","13717427251718128808","deep","33"),
("8","8","13886727765199709393","deep","33"),
("9","9","13895422507484551754","deep","33"),
("10","10","13943758195049046158","deep","33"),
("11","11","14403195540920057237","deep","33"),
("12","12","14648073423269368482","deep","33"),
("13","13","14699111537193797720","deep","33"),
("14","14","14713672662598427245","deep","33"),
("15","15","14757595541537823658","deep","33"),
("16","16","14896035576804897848","deep","33"),
("17","17","14899569221538089371","deep","33"),
("18","18","14988901395307958916","deep","33"),
("19","19","15016270239888359971","deep","33"),
("20","20","15091430800607031598","deep","33"),
("21","21","15116126645139448037","deep","33"),
("22","22","15181429467818775306","deep","33"),
("23","23","15286660474134852883","deep","33"),
("24","24","15315580521649794689","deep","33"),
("25","25","15332841947193003552","deep","33"),
("26","26","15370178462746296035","deep","33"),
("27","27","15405037339361702765","deep","33"),
("28","28","15448358507607721751","deep","33"),
("29","29","15539346271644918997","deep","33"),
("30","30","15549855792117646057","deep","33"),
("31","31","15692191680085781359","deep","33"),
("32","32","15750690399733266054","deep","33"),
("33","33","15812546738963538317","deep","33"),
("34","34","15905462629206604660","deep","33"),
("35","35","15931537082917906244","deep","33"),
("36","36","15950374604971454611","deep","33"),
("37","37","15998768027508135314","deep","33"),
("38","38","16047088999769170961","deep","33"),
("39","39","16156623702824762102","deep","33"),
("40","40","16318923451285975693","deep","33"),
("41","41","16367339641177099653","deep","33"),
("42","42","16368835231065842305","deep","33"),
("43","43","16451681180634651174","deep","33"),
("44","44","16453219794487088664","deep","33"),
("45","45","16455212699146487201","deep","33"),
("46","46","16607054299753404564","deep","33"),
("47","47","16763039592426283146","deep","33"),
("48","48","16792900786953061415","deep","33"),
("49","49","16818064524239150817","deep","33"),
("50","50","16961576822386821316","deep","33"),
("51","51","16967673529939483089","deep","33"),
("52","52","16979706948961188882","deep","33"),
("53","53","17433631577448798061","deep","33"),
("54","54","17589616870121676643","deep","33"),
("55","55","17636667044210986015","deep","33"),
("56","56","2844228860506061117","deep","33"),
("57","57","3555425994057882860","deep","33"),
("0","0","11095051231345659741","deep","34"),
("1","1","11598445933593310450","deep","34"),
("2","2","11703849533665043633","deep","34"),
("3","3","11746451542692708496","deep","34"),
("4","4","11761612252569359952","deep","34"),
("5","5","11860919145088431362","deep","34"),
("6","6","12067714048280533983","deep","34"),
("7","7","12173117648352267166","deep","34"),
("8","8","12182563106683736660","deep","34"),
("9","9","12198456105615367670","deep","34"),
("10","10","12474074346383363652","deep","34"),
("11","11","12494761614242539760","deep","34"),
("12","12","12537952204126956619","deep","34"),
("13","13","12576473177615801503","deep","34"),
("14","14","12647474318100444499","deep","34"),
("15","15","12673801872188998541","deep","34"),
("16","16","12697732293961263682","deep","34"),
("17","17","12751138109595064307","deep","34"),
("18","18","12870381549631717396","deep","34"),
("19","19","12887645101396281755","deep","34"),
("20","20","12985962897089899627","deep","34"),
("21","21","12993048701468014938","deep","34"),
("22","22","13161654408552517983","deep","34"),
("23","23","13215060228481285904","deep","34"),
("24","24","13216706644750947672","deep","34"),
("25","25","13232286297587948249","deep","34"),
("26","26","13234996775998867583","deep","34"),
("27","27","13316013537270019082","deep","34"),
("28","28","13405543194076375690","deep","34"),
("29","29","13471142433405434453","deep","34"),
("30","30","13555945935492062637","deep","34"),
("31","31","13565047416178987038","deep","34"),
("32","32","13633976979295205943","deep","34"),
("33","33","13878616476570723487","deep","34"),
("34","34","14048261842401185170","deep","34"),
("35","35","14054233027012505111","deep","34"),
("36","36","14116446037199821435","deep","34"),
("37","37","14117397651367372959","deep","34"),
("38","38","14125502857882195327","deep","34"),
("39","39","14241748702131234283","deep","34"),
("40","40","14277856488563227332","deep","34"),
("41","41","14364431448270293883","deep","34"),
("42","42","14381000193637780702","deep","34"),
("43","43","14385673275691812350","deep","34"),
("44","44","14387082190181951014","deep","34"),
("45","45","14407059932045623529","deep","34"),
("46","46","14468339458453284414","deep","34"),
("47","47","14497605990062995693","deep","34"),
("48","48","14501659725511220950","deep","34"),
("49","49","14503702701910624762","deep","34"),
("50","50","14762998546515827440","deep","34"),
("51","51","14801482037346770310","deep","34"),
("52","52","14826820490314903518","deep","34"),
("53","53","14856182243849670406","deep","34"),
("54","54","14874201562786154897","deep","34"),
("55","55","14875301467249491510","deep","34"),
("56","56","14889942095001043824","deep","34"),
("57","57","14917758186907062785","deep","34"),
("58","58","14969206454318011391","deep","34"),
("59","59","14992421424265143935","deep","34"),
("60","60","15060142020393847866","deep","34"),
("61","61","15078286862271674189","deep","34"),
("62","62","15079278085318483223","deep","34"),
("63","63","15099840700645686208","deep","34"),
("64","64","15112104448395233906","deep","34"),
("65","65","15132839657478092497","deep","34"),
("66","66","15163140436098307648","deep","34"),
("67","67","15164009137129466351","deep","34"),
("68","68","15200462236348141374","deep","34"),
("69","69","15246869802001733977","deep","34"),
("70","70","15247846309745084254","deep","34"),
("71","71","15253406093647832632","deep","34"),
("72","72","15259610612207653275","deep","34"),
("73","73","15277610160420418714","deep","34"),
("74","74","15293480391997606467","deep","34"),
("75","75","15299539621187333522","deep","34"),
("76","76","15307014937918880440","deep","34"),
("77","77","15323231657885804962","deep","34"),
("78","78","15334570266215465919","deep","34"),
("79","79","15384205885954852618","deep","34"),
("80","80","15385701475843595270","deep","34"),
("81","81","15446288317780566815","deep","34"),
("82","82","15482121580212935622","deep","34"),
("83","83","15495424492232974837","deep","34"),
("84","84","15541232473414545509","deep","34"),
("85","85","15550354210710721491","deep","34"),
("86","86","15578619056412875971","deep","34"),
("87","87","15598799831208762965","deep","34"),
("88","88","15600938025238255090","deep","34"),
("89","89","15650905418063919801","deep","34"),
("90","90","15650920133367378558","deep","34"),
("91","91","15652790520306094060","deep","34"),
("92","92","15653939621805099943","deep","34"),
("93","93","15666520427337466896","deep","34"),
("94","94","15682527066595866502","deep","34"),
("95","95","15694683007633222626","deep","34"),
("96","96","15703799203623605784","deep","34"),
("97","97","15764493856567736199","deep","34"),
("98","98","15798707998526070664","deep","34"),
("99","99","15838730103209451024","deep","34"),
("100","100","15878428783461289366","deep","34"),
("101","101","15889688719081924769","deep","34"),
("102","102","15906892405357980037","deep","34"),
("103","103","15909327020332170952","deep","34"),
("104","104","15912843827835515518","deep","34"),
("105","105","15944063374931927351","deep","34"),
("106","106","15955230219143829937","deep","34"),
("107","107","15987948771213421750","deep","34"),
("108","108","16003768931050604228","deep","34"),
("109","109","16008729130481330675","deep","34"),
("110","110","16014276325301975792","deep","34"),
("111","111","16027031850811353847","deep","34"),
("112","112","16053751039179727696","deep","34"),
("113","113","16054240690718202557","deep","34"),
("114","114","16062172428773033314","deep","34"),
("115","115","16065407534930105143","deep","34"),
("116","116","16083941884866395777","deep","34"),
("117","117","16168940748063122824","deep","34"),
("118","118","16176843059806003363","deep","34"),
("119","119","16201646715345578672","deep","34"),
("120","120","16217811233056175127","deep","34"),
("121","121","16227439463415640223","deep","34"),
("122","122","16230956270918984789","deep","34"),
("123","123","16250142403288658125","deep","34"),
("124","124","16263272725848009030","deep","34"),
("125","125","16289946764031332545","deep","34"),
("126","126","16324848664610434113","deep","34"),
("127","127","16329471549649089724","deep","34"),
("128","128","16355104297340566226","deep","34"),
("129","129","16356093394166019764","deep","34"),
("130","130","16373342230627125366","deep","34"),
("131","131","16399122393910050952","deep","34"),
("132","132","16400111490735504490","deep","34"),
("133","133","16402531390406236648","deep","34"),
("134","134","16443057861931550626","deep","34"),
("135","135","16443449496211370433","deep","34"),
("136","136","16457301925258393600","deep","34"),
("137","137","16469227533272940523","deep","34"),
("138","138","16472354828422853482","deep","34"),
("139","139","16472369543726312239","deep","34"),
("140","140","16490996989366302986","deep","34"),
("141","141","16503045119396500240","deep","34"),
("142","142","16504034216221953778","deep","34"),
("143","143","16539492681604349735","deep","34"),
("144","144","16553172516895717296","deep","34"),
("145","145","16573310263432942156","deep","34"),
("146","146","16599687889261501473","deep","34"),
("147","147","16634386761203355858","deep","34"),
("148","148","16650486496165455577","deep","34"),
("149","149","16685957550629954795","deep","34"),
("150","150","16731368971681783423","deep","34"),
("151","151","16734388455824537512","deep","34"),
("152","152","16736368775696800084","deep","34"),
("153","153","16770186361820359801","deep","34"),
("154","154","16773753236768742346","deep","34"),
("155","155","16785851438538944875","deep","34"),
("156","156","16793449277286142124","deep","34"),
("157","157","16793876272297475745","deep","34"),
("158","158","16824884442101904401","deep","34"),
("159","159","16905449034492483053","deep","34"),
("160","160","16905484386634062275","deep","34"),
("161","161","16937388566150178948","deep","34"),
("162","162","16960574109785361274","deep","34"),
("163","163","16964986918410459265","deep","34"),
("164","164","16971645732072208251","deep","34"),
("165","165","16989898380662226148","deep","34"),
("166","166","16998949793904112570","deep","34"),
("167","167","17000380596749391190","deep","34"),
("168","168","17003412669974248540","deep","34"),
("169","169","17039318382682262403","deep","34"),
("170","170","17053344706363366733","deep","34"),
("171","171","17101493910211676713","deep","34"),
("172","172","17201240382529217709","deep","34"),
("173","173","17207447023015426552","deep","34"),
("174","174","17237733090627150242","deep","34"),
("175","175","17294851074874394296","deep","34"),
("176","176","17296843983828760129","deep","34"),
("177","177","17316512719960597889","deep","34"),
("178","178","17378153445766487004","deep","34"),
("179","179","17481124557085384768","deep","34"),
("180","180","17570521513603751049","deep","34"),
("181","181","17727445831362077894","deep","34"),
("182","182","2719878904974684750","deep","34"),
("183","183","2891539068114652222","deep","34"),
("184","184","3238853260059336036","deep","34"),
("185","185","3322981015710108411","deep","34"),
("186","186","3947653261294868878","deep","34"),
("187","187","4347660039779595494","deep","34"),
("188","188","5100101836244465080","deep","34"),
("0","0","11968702550012258120","deep","35"),
("1","1","12887646200923734008","deep","35"),
("2","2","12922142048523308506","deep","35"),
("3","3","12944475732652146382","deep","35"),
("4","4","12990376805242449871","deep","35"),
("5","5","13022106260486588146","deep","35"),
("6","6","13065697366339706547","deep","35"),
("7","7","13076445267591260012","deep","35"),
("8","8","13264749141414518331","deep","35"),
("9","9","13322806150747210648","deep","35"),
("10","10","13365007643806173969","deep","35"),
("11","11","13552855096306148449","deep","35"),
("12","12","13584672596128693838","deep","35"),
("13","13","13707909031420727088","deep","35"),
("14","14","13828597989606117554","deep","35"),
("15","15","13878595687743035784","deep","35"),
("16","16","13991069502185089516","deep","35"),
("17","17","14009872542506427370","deep","35"),
("18","18","14044456895122209858","deep","35"),
("19","19","14069394836416608820","deep","35"),
("20","20","14402662938251436548","deep","35"),
("21","21","14405740161661344232","deep","35"),
("22","22","14629837689037713848","deep","35"),
("23","23","14636988280459293191","deep","35"),
("24","24","14678880767786421757","deep","35"),
("25","25","14733955775634261999","deep","35"),
("26","26","14780313269547849327","deep","35"),
("27","27","14869218448306385251","deep","35"),
("28","28","14872629571023926443","deep","35"),
("29","29","14921817939142727940","deep","35"),
("30","30","14930686580356618760","deep","35"),
("31","31","14957066328111566277","deep","35"),
("32","32","15016112434269712132","deep","35"),
("33","33","15114040717609898397","deep","35"),
("34","34","15171818151817673473","deep","35"),
("35","35","15188763820456488638","deep","35"),
("36","36","15215638761055703840","deep","35"),
("37","37","15275776233740669279","deep","35"),
("38","38","15384698763242135228","deep","35"),
("39","39","15446982097483741112","deep","35"),
("40","40","15458041130688484828","deep","35"),
("41","41","15459924106709303591","deep","35"),
("42","42","15485654198252223902","deep","35"),
("43","43","15548868894347097025","deep","35"),
("44","44","15583957278642383017","deep","35"),
("45","45","15594185093473870044","deep","35"),
("46","46","15623092551906708589","deep","35"),
("47","47","15673941230550667968","deep","35"),
("48","48","15689346988753587382","deep","35"),
("49","49","15694734178900680154","deep","35"),
("50","50","15701222525028129030","deep","35"),
("51","51","15731081597628519099","deep","35"),
("52","52","15751804217629274429","deep","35"),
("53","53","15770938156332554290","deep","35"),
("54","54","15871060246748030779","deep","35"),
("55","55","15963306219874851039","deep","35"),
("56","56","16009437625487963729","deep","35"),
("57","57","16031872749680270416","deep","35"),
("58","58","16095037374035138264","deep","35"),
("59","59","16123799543097883221","deep","35"),
("60","60","16230409979640808586","deep","35"),
("61","61","16231876138922633724","deep","35"),
("62","62","16256577529055810283","deep","35"),
("63","63","16334370187785159888","deep","35"),
("64","64","16358624326297751245","deep","35"),
("65","65","16388518755334687832","deep","35"),
("66","66","16430463440623177169","deep","35"),
("67","67","16456595633601632348","deep","35"),
("68","68","16548226006074546363","deep","35"),
("69","69","16553570176552911593","deep","35"),
("70","70","16572857067858466066","deep","35"),
("71","71","16603112700588598179","deep","35"),
("72","72","16616243018852981788","deep","35"),
("73","73","16622743954062533925","deep","35"),
("74","74","16647532894298650477","deep","35"),
("75","75","16660665343079356878","deep","35"),
("76","76","16702354801769238261","deep","35"),
("77","77","16749564980532099978","deep","35"),
("78","78","16798008474808785956","deep","35"),
("79","79","16938805753219451064","deep","35"),
("80","80","16974066731270392662","deep","35"),
("81","81","17115521333420233296","deep","35"),
("82","82","17137247765549900921","deep","35"),
("83","83","17498279275443854310","deep","35"),
("84","84","17541775159371917102","deep","35"),
("85","85","17602801585402325529","deep","35"),
("86","86","17839591977465964664","deep","35"),
("87","87","2467878835116808433","deep","35"),
("0","0","10431738685080610700","deep","36"),
("1","1","11653537855799513955","deep","36"),
("2","2","12577464473496159547","deep","36"),
("3","3","14155791124548823523","deep","36"),
("4","4","14317440722322542787","deep","36"),
("5","5","14563250452410653800","deep","36"),
("6","6","14624878589134439654","deep","36"),
("7","7","15049446389937204182","deep","36"),
("8","8","15113550039377520293","deep","36"),
("9","9","15148394200689468266","deep","36"),
("10","10","15207896732465865256","deep","36"),
("11","11","15314155139313261028","deep","36"),
("12","12","15368585412504029005","deep","36"),
("13","13","15570531638960752871","deep","36"),
("14","14","15574648030936119368","deep","36"),
("15","15","15630676774877899334","deep","36"),
("16","16","15633096674548631492","deep","36"),
("17","17","15657898203866851305","deep","36"),
("18","18","15724581761946419215","deep","36"),
("19","19","15809300220380331786","deep","36"),
("20","20","16005357689476596003","deep","36"),
("21","21","16028412654750176202","deep","36"),
("22","22","16029988751260515706","deep","36"),
("23","23","16049736989739276255","deep","36"),
("24","24","16125981860618522437","deep","36"),
("25","25","16233428441384626728","deep","36"),
("26","26","16346966808148437851","deep","36"),
("27","27","16496950606603775677","deep","36"),
("28","28","16841455390819263022","deep","36"),
("29","29","16988803676179485542","deep","36"),
("30","30","17127728441430079652","deep","36"),
("31","31","17247253587107972774","deep","36"),
("32","32","17459904690852555267","deep","36"),
("33","33","17779555747788462028","deep","36"),
("0","0","11203131130047734299","deep","37"),
("1","1","11553537260705784554","deep","37"),
("2","2","12421422541083579623","deep","37"),
("3","3","12487679104151813912","deep","37"),
("4","4","12521349270388957249","deep","37"),
("5","5","12948471801666767054","deep","37"),
("6","6","12952552832910619737","deep","37"),
("7","7","12995067676359180787","deep","37"),
("8","8","13071833755605174840","deep","37"),
("9","9","13141351899578145741","deep","37"),
("10","10","13192360587190624761","deep","37"),
("11","11","13356934941657509626","deep","37"),
("12","12","13500896997875989707","deep","37"),
("13","13","13593775401166186740","deep","37"),
("14","14","13621057570347983807","deep","37"),
("15","15","13678197447245335113","deep","37"),
("16","16","13681251903300799540","deep","37"),
("17","17","13746469682327411196","deep","37"),
("18","18","13781291080579883208","deep","37"),
("19","19","14022506866055756299","deep","37"),
("20","20","14030619254212194458","deep","37"),
("21","21","14051839193278572969","deep","37"),
("22","22","14123917475167076617","deep","37"),
("23","23","14249826906212127187","deep","37"),
("24","24","14273461693823944857","deep","37"),
("25","25","14301824686355092449","deep","37"),
("26","26","14330586855417837406","deep","37"),
("27","27","14372963943158147834","deep","37"),
("28","28","14401566107547340446","deep","37"),
("29","29","14559720033426270026","deep","37"),
("30","30","14616714616658560448","deep","37"),
("31","31","14648149785769290021","deep","37"),
("32","32","14679879241013428296","deep","37"),
("33","33","14752152884012030807","deep","37"),
("34","34","14845018702515091875","deep","37"),
("35","35","14847988119212807985","deep","37"),
("36","36","14863271351105109772","deep","37"),
("37","37","14903639944178226901","deep","37"),
("38","38","14921782655539730432","deep","37"),
("39","39","14923308680310064661","deep","37"),
("40","40","14930283677050296897","deep","37"),
("41","41","15021236963650250926","deep","37"),
("42","42","15130287066292660205","deep","37"),
("43","43","15200517732891858904","deep","37"),
("44","44","15225651035296356729","deep","37"),
("45","45","15239895098623199703","deep","37"),
("46","46","15249790319320446075","deep","37"),
("47","47","15300532016595143819","deep","37"),
("48","48","15302901844525870702","deep","37"),
("49","49","15374141374379274695","deep","37"),
("50","50","15438749390661524424","deep","37"),
("51","51","15441718803064273238","deep","37"),
("52","52","15518642765057431436","deep","37"),
("53","53","15536612886958246657","deep","37"),
("54","54","15552230018158181952","deep","37"),
("55","55","15594879972704496594","deep","37"),
("56","56","15623094750961613095","deep","37"),
("57","57","15652831301546352833","deep","37"),
("58","58","15672180853674015842","deep","37"),
("59","59","15735250256103828081","deep","37"),
("60","60","15767970938689742686","deep","37"),
("61","61","15783585943668322485","deep","37"),
("62","62","15788151709190662384","deep","37"),
("63","63","15797817422208029494","deep","37"),
("64","64","15843783277546829719","deep","37"),
("65","65","15923609742972884499","deep","37"),
("66","66","15939666453971289380","deep","37"),
("67","67","15983431454458488944","deep","37"),
("68","68","15997233811765506836","deep","37"),
("69","69","16017753407423982279","deep","37"),
("70","70","16027022560311607345","deep","37"),
("71","71","16029123275978164752","deep","37"),
("72","72","16084984352014211349","deep","37"),
("73","73","16104226097429682784","deep","37"),
("74","74","16135408166163159899","deep","37"),
("75","75","16148590682388904279","deep","37"),
("76","76","16157777202433576997","deep","37"),
("77","77","16175359942497283403","deep","37"),
("78","78","16211610013078711243","deep","37"),
("79","79","16227934539757827339","deep","37"),
("80","80","16263825537162382445","deep","37"),
("81","81","16277460226563666968","deep","37"),
("82","82","16296154581173509947","deep","37"),
("83","83","16361297399179284871","deep","37"),
("84","84","16374936336728313090","deep","37"),
("85","85","16380446053186023489","deep","37"),
("86","86","16388363075937395489","deep","37"),
("87","87","16442621580715437799","deep","37"),
("88","88","16494461482406206212","deep","37"),
("89","89","16497493555631063562","deep","37"),
("90","90","16548964205872619245","deep","37"),
("91","91","16590958958606146561","deep","37"),
("92","92","16663699615359118734","deep","37"),
("93","93","16703895614676580257","deep","37"),
("94","94","16708663789085329456","deep","37"),
("95","95","16809567026134057359","deep","37"),
("96","96","16810606194699516172","deep","37"),
("97","97","16834248159657982337","deep","37"),
("98","98","16834637672011413944","deep","37"),
("99","99","16848434488012639012","deep","37"),
("100","100","16863703008896449338","deep","37"),
("101","101","16867661518124651690","deep","37"),
("102","102","17007936583893894864","deep","37"),
("103","103","17011001222516666583","deep","37"),
("104","104","17036229742551252721","deep","37"),
("105","105","17115069237373209459","deep","37"),
("106","106","17206301224393744724","deep","37"),
("107","107","17243787950872085736","deep","37"),
("108","108","17328564148573151902","deep","37"),
("109","109","17425501208866529133","deep","37"),
("110","110","17570524812186107808","deep","37"),
("111","111","9852987034310286258","deep","37"),
("0","0","13033977802547671253","deep","4"),
("1","1","14536931694541717782","deep","4"),
("2","2","14744635192232644385","deep","4"),
("3","3","14888399761119670107","deep","4"),
("4","4","14912054315160239533","deep","4"),
("5","5","16376445164615014337","deep","4"),
("6","6","16578881042610213064","deep","4"),
("7","7","16614729020346040628","deep","4"),
("8","8","16841059959381990682","deep","4"),
("9","9","16947952101566156080","deep","4"),
("10","10","17051977092459004118","deep","4"),
("11","11","18019336937556571262","deep","4"),
("0","0","12651111027117955422","deep","5"),
("1","1","15479726360131314212","deep","5"),
("2","2","15491747190070916744","deep","5"),
("3","3","15503903126813305572","deep","5"),
("4","4","15608425441066744087","deep","5"),
("5","5","15686215973574738196","deep","5"),
("6","6","16081129852340748038","deep","5"),
("7","7","16151127184991446035","deep","5"),
("8","8","16414749493690605534","deep","5"),
("9","9","16437018395070946674","deep","5"),
("10","10","16688389545102661736","deep","5"),
("11","11","17066099737592616310","deep","5"),
("0","0","13273787755882580783","deep","6"),
("1","1","16533394448782688945","deep","6"),
("0","0","12273096154172426095","deep","7"),
("1","1","12780903669340142091","deep","7"),
("2","2","13430895945196355483","deep","7"),
("3","3","13431885042021809021","deep","7"),
("4","4","13571083456567691368","deep","7"),
("5","5","13892345962155516855","deep","7"),
("6","6","13949248823158877586","deep","7"),
("7","7","14423788264935050521","deep","7"),
("8","8","14586404192179780066","deep","7"),
("9","9","14744573708066504408","deep","7"),
("10","10","14773240655204193756","deep","7"),
("11","11","14867695155004730293","deep","7"),
("12","12","14894622293565306266","deep","7"),
("13","13","14987912976563378163","deep","7"),
("14","14","14988367271665306506","deep","7"),
("15","15","15151937818298246372","deep","7"),
("16","16","15261070424213269941","deep","7"),
("17","17","15294323778006386949","deep","7"),
("18","18","15449427780566003567","deep","7"),
("19","19","15457013034526064851","deep","7"),
("20","20","15469061164556262105","deep","7"),
("21","21","15579180741075383716","deep","7"),
("22","22","15654393495460448818","deep","7"),
("23","23","15681993973942084631","deep","7"),
("24","24","15863815038648719602","deep","7"),
("25","25","15953801121073327345","deep","7"),
("26","26","16271254114196265594","deep","7"),
("27","27","16751948007087221193","deep","7"),
("28","28","16894469077893115362","deep","7"),
("29","29","17260902493237620280","deep","7"),
("30","30","17500235306987641904","deep","7"),
("0","0","11450455722173211242","deep","8"),
("1","1","11735262613502202734","deep","8"),
("2","2","13364727647234677260","deep","8"),
("3","3","13918141940269353451","deep","8"),
("4","4","14287645401677117558","deep","8"),
("5","5","14769722821006945947","deep","8"),
("6","6","14921392653201137643","deep","8"),
("7","7","15106125399633302425","deep","8"),
("8","8","15135224878793150922","deep","8"),
("9","9","15137365203338965839","deep","8"),
("10","10","15155557990735441941","deep","8"),
("11","11","15426605544426143083","deep","8"),
("12","12","15472029554560074972","deep","8"),
("13","13","15794700095638735822","deep","8"),
("14","14","15862877113090723592","deep","8"),
("15","15","15925602157647121854","deep","8"),
("16","16","15987964164597753292","deep","8"),
("17","17","16005935111841498452","deep","8"),
("18","18","16016379845270761480","deep","8"),
("19","19","16111216189897581304","deep","8"),
("20","20","16125899837317861160","deep","8"),
("21","21","16168783547691798760","deep","8"),
("22","22","16225474536927709193","deep","8"),
("23","23","16403096300817552142","deep","8"),
("24","24","16509661591470394469","deep","8"),
("25","25","16584967437264192388","deep","8"),
("26","26","16590918859741727869","deep","8"),
("27","27","16762081699521104864","deep","8"),
("28","28","16884791875321097244","deep","8"),
("29","29","16935850630378614243","deep","8"),
("30","30","17115081332175184242","deep","8"),
("31","31","3710533900447180012","deep","8"),
("32","32","4705167372495059898","deep","8"),
("0","0","12021134666499904045","deep","9"),
("1","1","13007987523477623784","deep","9"),
("2","2","13488790097785106962","deep","9"),
("3","3","14014300744515856903","deep","9"),
("4","4","14093190306782851620","deep","9"),
("5","5","14118403241104610292","deep","9"),
("6","6","14324483575765850913","deep","9"),
("7","7","14327515648990708263","deep","9"),
("8","8","14762025942602157697","deep","9"),
("9","9","14818704342755964869","deep","9"),
("10","10","14845421404902983222","deep","9"),
("11","11","14923371946379496972","deep","9"),
("12","12","15038953289542711907","deep","9"),
("13","13","15413584132401403301","deep","9"),
("14","14","15434096675988601011","deep","9"),
("15","15","15441355078417339224","deep","9"),
("16","16","15503515890643294777","deep","9"),
("17","17","15504254013312851353","deep","9"),
("18","18","15531131080133422051","deep","9"),
("19","19","15835012048972151609","deep","9"),
("20","20","16031448563266132372","deep","9"),
("21","21","16070089932549272091","deep","9"),
("22","22","16126060941518865758","deep","9"),
("23","23","16393604281083292891","deep","9"),
("24","24","16424866852143399562","deep","9"),
("25","25","16453736827918336093","deep","9"),
("26","26","16547973588073133986","deep","9"),
("27","27","16701591174741673885","deep","9"),
("28","28","16882315335910663744","deep","9"),
("29","29","16939760171689230869","deep","9"),
("30","30","17658895794468442312","deep","9");`
