CREATE DATABASE IF NOT EXISTS carprice;
DROP TABLE IF EXISTS carprice.train;
CREATE TABLE IF NOT EXISTS carprice.train (
engine_hp                       float,
engine_cylinders                float,
number_of_doors                 float,
highway_mpg                     float,
city_mpg                        float,
popularity                      float,
market_category_nums            float,
category_factory_tuner          float,
category_luxury                 float,
category_high_performance       float,
category_performance            float,
category_flex_fuel              float,
category_hatchback              float,
category_hybrid                 float,
category_diesel                 float,
category_exotic                 float,
category_crossover              float,
make_audi                       int,
make_bmw                        int,
make_buick                      int,
make_cadillac                   int,
make_chevrolet                  int,
make_chrysler                   int,
make_dodge                      int,
make_fiat                       int,
make_ford                       int,
make_gmc                        int,
make_genesis                    int,
make_hummer                     int,
make_honda                      int,
make_hyundai                    int,
make_infiniti                   int,
make_kia                        int,
make_land_rover                 int,
make_lexus                      int,
make_lincoln                    int,
make_lotus                      int,
make_mazda                      int,
make_mercedes_benz              int,
make_mitsubishi                 int,
make_nissan                     int,
make_oldsmobile                 int,
make_plymouth                   int,
make_pontiac                    int,
make_porsche                    int,
make_saab                       int,
make_scion                      int,
make_subaru                     int,
make_suzuki                     int,
make_toyota                     int,
make_volkswagen                 int,
make_volvo                      int,
engine_fuel_type_electric       int,
engine_fuel_type_flex_fuel      int,
engine_fuel_type_premium_unleaded_recommended    int,
engine_fuel_type_premium_unleaded_required      int,
engine_fuel_type_regular_unleaded                   int,
transmission_type_automatic     int,
transmission_type_direct_drive  int,
transmission_type_manual        int,
transmission_type_unknown       int,
driven_wheels_four_wheel_drive  int,
driven_wheels_front_wheel_drive                     int,
driven_wheels_rear_wheel_drive  int,
vehicle_size_large              int,
vehicle_size_midsize            int,
vehicle_style_2dr_suv           int,
vehicle_style_4dr_hatchback     int,
vehicle_style_4dr_suv           int,
vehicle_style_cargo_minivan     int,
vehicle_style_cargo_van         int,
vehicle_style_convertible       int,
vehicle_style_convertible_suv   int,
vehicle_style_coupe             int,
vehicle_style_crew_cab_pickup   int,
vehicle_style_extended_cab_pickup                   int,
vehicle_style_passenger_minivan                     int,
vehicle_style_passenger_van     int,
vehicle_style_regular_cab_pickup                    int,
vehicle_style_sedan             int,
vehicle_style_wagon             int,
msrp                            float
);

INSERT INTO carprice.train VALUES
(-0.4365733888687864,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,-0.24015809280958422),
(0.82739698668199,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.597395833057595,0.042116075746094286,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.5676030758135724),
(0.9678381395209652,0.5468721170669484,-1.7393483837445023,-0.6377912452362757,-0.3751882566065713,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0.9018252628726615),
(1.178499868779428,0.5468721170669484,-1.7393483837445023,0.4635227070891796,-0.041876891930035715,1.620318624948003,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.7094031339228553),
(0.7290881796947074,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,0.32236408513753273,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1.0868477985874476),
(-0.08547050677134847,-0.8822407378465996,-1.7393483837445023,0.8306273578643314,0.5136420491975237,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.16514742087710924),
(1.5015145203090707,0.5468721170669484,-1.7393483837445023,0.09641805631402782,-0.3751882566065713,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.14423452408859877),
(-0.4365733888687864,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.06922689629547615,0.10821880031999623,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.08287305561049327),
(-1.9954701853814105,-0.8822407378465996,-1.7393483837445023,1.1977320086394831,0.6247458374230355,-0.9315219716236697,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7901009739613176),
(0.82739698668199,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.18033068452098802,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.5302636132814926),
(0.4762941045845522,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.8469534138740592,0.30721554408934687,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.1012552911226154),
(0.9678381395209652,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.708499621283107,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.6322534946488645),
(0.12519122248711426,0.5468721170669484,-1.7393483837445023,-0.025950160611022774,-0.2640844683810594,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.0605035277269433),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.6247458374230355,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.808495758867913),
(1.529602750876866,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.15298068015554758,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1.1190750845213757),
(0.05497064606762669,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.5136420491975237,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.34220792124351324),
(-0.3944410430170938,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.8469534138740592,0.30721554408934687,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.2507741399407605),
(0.6167352574235273,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.041876891930035715,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.3543405465362861),
(0.82739698668199,1.9759849719804965,-1.7393483837445023,-0.270686594461124,-0.597395833057595,0.042116075746094286,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.1244589369950435),
(1.810485056554816,1.9759849719804965,-1.7393483837445023,-1.2496323298615286,-1.0418109859596425,0.10477595008177217,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.3791841210767166),
(-0.18377931375863107,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.15298068015554758,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.10442434734668782),
(-1.026426230792482,-0.8822407378465996,-1.7393483837445023,-0.025950160611022774,0.18033068452098802,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-0.49191006763462114),
(-1.43370557402551,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,-0.2640844683810594,-0.47706574017809383,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1.7901009739613176),
(-0.015249930351860891,0.5468721170669484,0.6064467288040396,-1.127264112936478,-0.8196034095086188,-0.9356533919095386,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-1.7192767738147559),
(1.0380587159404528,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,0.10821880031999623,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.5681780673214079),
(1.1363675229277355,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.9452933725765659,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.8525364726207718),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.4025382609720118,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.021830784606229794),
(-0.6472351181272491,-0.8822407378465996,0.6064467288040396,2.5437823948150395,2.4024064490312256,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.35168653475349204),
(0.9959263700887603,0.5468721170669484,0.6064467288040396,0.09641805631402782,-0.2640844683810594,-0.37860022336488575,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.9317776815641946),
(-0.45061750415268387,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.6247458374230355,-0.6726196337092204,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.004709333221710845),
(1.262764560482813,0.5468721170669484,-1.7393483837445023,-0.270686594461124,-0.2640844683810594,0.30721554408934687,1.4161194154023549,6.01029080042039,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.9913033744068614),
(-0.7876762709662243,-0.8822407378465996,0.6064467288040396,1.0753637917144325,0.6247458374230355,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.6356058484458997),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,-0.15298068015554758,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-0.2259116596103236,-0.8822407378465996,-1.7393483837445023,0.341154490164129,0.18033068452098802,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1.0568953798959146),
(-0.2961322360298112,0.5468721170669484,-1.7393483837445023,-0.7601594621613263,-0.597395833057595,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-0.3683089474644976),
(0.335852951745577,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.597395833057595,-0.12245216564101576,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.14385537954819963),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.06922689629547615,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.3099806353095853),
(1.0099704853726577,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.2640844683810594,2.8191190778976205,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.8074182723132727),
(1.9509262093937914,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.6885501842009019),
(0.7571764102625025,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.2640844683810594,0.042116075746094286,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1.3985046107955506),
(0.7009999491269124,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1.1858045236316264),
(2.2318085150717417,1.9759849719804965,-1.7393483837445023,-0.5154230283112251,-0.597395833057595,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.855569628943965),
(-0.7174556945467366,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.3751882566065713,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.35200573222733406),
(-1.7426761102712554,-0.8822407378465996,-1.7393483837445023,0.2187862732390784,0.06922689629547615,-0.7077367061391058,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.2187862732390784,0.18033068452098802,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.01760024759528201),
(-0.6472351181272491,-0.8822407378465996,0.6064467288040396,1.3201002255645338,0.5136420491975237,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.064993315145176),
(-1.7286319949873579,-0.8822407378465996,-1.7393483837445023,0.2187862732390784,0.2914344727464999,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.591058656991659,0.5468721170669484,-1.7393483837445023,-1.0048958960114276,-0.597395833057595,-0.8984706093367187,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.057849515944149235),
(-0.8578968473857118,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.5136420491975237,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.11845269534145644),
(1.178499868779428,0.5468721170669484,0.6064467288040396,0.2187862732390784,-0.041876891930035715,-0.9452933725765659,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.1406863233241273),
(0.8976175631014777,0.5468721170669484,0.6064467288040396,0.2187862732390784,-0.041876891930035715,-0.9356533919095386,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.8946215166050776),
(-0.2680440054620162,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.606092521361323),
(-0.2259116596103236,1.9759849719804965,-0.5664508274702313,-1.3720005467865792,-1.0418109859596425,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,-1.7901009739613176),
(1.2206322146311204,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.3751882566065713,-1.0341189087227467,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1.334808328008493),
(-0.8157645015340192,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.06922689629547615,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.4050859678832153),
(-0.2259116596103236,-0.8822407378465996,-1.7393483837445023,0.341154490164129,0.18033068452098802,-1.003821826626375,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.13595329126637454),
(-0.12760285262304102,-0.8822407378465996,0.6064467288040396,-0.025950160611022774,-0.3751882566065713,-0.8172193437146309,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.5147186871251274),
(-1.0685585766441745,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.06922689629547615,-0.9356533919095386,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.24319124913277745),
(1.2206322146311204,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.3751882566065713,-1.0341189087227467,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.3981254662551514),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,-0.15298068015554758,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.22423402211281984),
(1.2206322146311204,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.3751882566065713,-1.0341189087227467,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.1486483586725096),
(1.0661469465082478,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.2640844683810594,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.4085582158133648),
(1.529602750876866,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.9452933725765659,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.6705470932291788),
(-0.15569108319083605,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.7759051408559422,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.21534615802595697),
(0.335852951745577,-0.8822407378465996,0.6064467288040396,-0.025950160611022774,-0.041876891930035715,0.10821880031999623,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.0838146422642545),
(-0.9562056543729944,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.8469534138740592,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.19049015801729532),
(0.9397499089531701,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.3751882566065713,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1.045141899143541),
(-0.6472351181272491,-0.8822407378465996,-1.7393483837445023,0.9529955747893819,0.4025382609720118,1.0618883163080606,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.7577503375209838),
(-0.6472351181272491,-0.16768431038982562,0.6064467288040396,0.7082591409392808,0.2914344727464999,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.3800624282168713),
(2.3160732067751266,1.9759849719804965,0.6064467288040396,-1.127264112936478,-0.8196034095086188,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.4559512833632588),
(0.335852951745577,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,-0.15298068015554758,-1.0341189087227467,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.059928536219108),
(-0.7034115792628391,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.5136420491975237,-0.7759051408559422,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.10707835912948188),
(0.9678381395209652,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.3751882566065713,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.8927257939030819),
(-0.12760285262304102,-0.8822407378465996,0.6064467288040396,-0.025950160611022774,-0.3751882566065713,-0.8172193437146309,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.8620150861307506),
(0.5465146810040398,1.9759849719804965,-0.5664508274702313,-1.3720005467865792,-0.9307071977341307,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0.4438186580704859),
(0.5043823351523472,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.2914344727464999,2.8191190778976205,2.659945347654738,6.01029080042039,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.09380830021551156),
(-0.015249930351860891,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.6247458374230355,0.30721554408934687,3.903771279907121,6.01029080042039,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.1829672142758694),
(0.8695293325336826,0.5468721170669484,0.6064467288040396,0.341154490164129,-0.041876891930035715,0.44010956328479556,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.6242914593004822),
(-1.6162790727161778,-0.8822407378465996,-1.7393483837445023,1.564836659414635,1.1802647785505949,-0.5121828126079793,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.5995871171079803),
(0.27967649060998695,-0.8822407378465996,-1.7393483837445023,-0.39305481138617454,-0.597395833057595,0.10477595008177217,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,-1.518936798667844),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.18033068452098802,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.9260905134582073),
(1.2487204451989156,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.3751882566065713,-1.0341189087227467,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.4371773539162642),
(-0.6472351181272491,-0.16768431038982562,-1.7393483837445023,-0.025950160611022774,0.06922689629547615,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.12799125591799235),
(-1.5039261504449974,-0.8822407378465996,0.6064467288040396,1.564836659414635,1.1802647785505949,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.6124780314815514),
(1.2487204451989156,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.3751882566065713,-0.9356533919095386,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.3177468236905312),
(0.9678381395209652,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.2640844683810594,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.5571828756498324),
(1.641955673148046,0.5468721170669484,0.6064467288040396,0.09641805631402782,-0.2640844683810594,1.0618883163080606,2.659945347654738,6.01029080042039,2.082700496237388,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.8345208322545754),
(-0.2961322360298112,0.5468721170669484,-0.5664508274702313,-1.2496323298615286,-0.708499621283107,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.6472351181272491,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.5136420491975237,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.11124894907387255),
(0.6307793727074248,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.597395833057595,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.13216184586238303),
(-0.3944410430170938,1.9759849719804965,0.6064467288040396,-1.3720005467865792,-0.9307071977341307,-0.8984706093367187,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.8752851450447209),
(0.22350002947439687,0.0,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.4931074483223757),
(0.4762941045845522,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.708499621283107,1.0618883163080606,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1.087606087668246),
(-1.1387791530636622,0.5468721170669484,-0.5664508274702313,-0.6377912452362757,-0.597395833057595,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,-1.7901009739613176),
(2.021146785813279,1.9759849719804965,-1.7393483837445023,-1.4943687637116299,-0.9307071977341307,2.8191190778976205,1.4161194154023549,6.01029080042039,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.4974013887731723),
(-0.5770145417077616,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.06922689629547615,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.22726717843601305),
(-0.15569108319083605,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.3751882566065713,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(0.34989706702947454,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.4025382609720118,-0.6512739622322312,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.2184109541059533),
(0.335852951745577,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.2914344727464999,1.620318624948003,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.42410314196973004),
(1.2487204451989156,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.49121172562037996),
(-0.8157645015340192,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.2914344727464999,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.6617668217334413),
(0.7009999491269124,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.7122529926730855),
(0.7571764102625025,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,-0.7635108799983356,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.164951573909673),
(1.9509262093937914,1.9759849719804965,0.6064467288040396,-0.39305481138617454,-0.597395833057595,-0.9315219716236697,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.46618818595403594),
(-0.6051027722755565,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.4025382609720118,-0.08526938306819591,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.4403464101403365),
(0.8976175631014777,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.15298068015554758,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.8984129620090692),
(-0.9281174238051993,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,-0.2640844683810594,-0.8172193437146309,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.5770145417077616,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.4025382609720118,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.4316860327777131),
(-0.6472351181272491,-0.8822407378465996,-1.7393483837445023,0.8306273578643314,0.5136420491975237,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.37102290631384877),
(1.318941021618403,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.2240981222119407),
(0.05497064606762669,-0.8822407378465996,-1.7393483837445023,0.7082591409392808,0.5136420491975237,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.1503607838015423),
(0.8695293325336826,0.5468721170669484,0.6064467288040396,0.09641805631402782,-0.15298068015554758,0.44010956328479556,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.7114947035922873),
(-0.6472351181272491,-0.16768431038982562,0.6064467288040396,0.7082591409392808,0.2914344727464999,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.3800624282168713),
(-0.6472351181272491,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.18033068452098802,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.10183028263045087),
(-0.08547050677134847,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.4025382609720118,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11282547430202627),
(1.2206322146311204,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.48629204483208316,-0.9452933725765659,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.4174618378155082),
(2.3160732067751266,1.9759849719804965,-1.7393483837445023,-1.2496323298615286,-0.8196034095086188,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0.5605951765134247),
(1.318941021618403,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.4644757608250032),
(-0.9281174238051993,-0.8822407378465996,0.6064467288040396,1.809573093264736,1.069160990325083,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.6307369164872679),
(-0.9702497696568919,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.3751882566065713,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.48470632136703723),
(1.9509262093937914,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1.2491216618782848),
(-0.5067939652882739,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.2914344727464999,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.29255586829274705),
(-0.2118675443264261,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.9315219716236697,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,-0.1029077691850912),
(1.5717350967285584,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,-0.9452933725765659,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.7918733461569075),
(-0.3663528124492988,0.5468721170669484,-1.7393483837445023,-1.0048958960114276,-0.708499621283107,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.3451811305001493),
(-0.6472351181272491,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.4025382609720118,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.32356989169739764),
(0.5043823351523472,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.7449194887119257,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.35054910113229454),
(-1.1809114989153546,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.9580572020995711,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.4202517494991814),
(-0.6051027722755565,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.06922689629547615,-0.37860022336488575,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.35579717763132557),
(-0.4787057347204789,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.18033068452098802,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.08666450101448478),
(0.9397499089531701,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.48629204483208316,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.1355741467259754),
(0.6307793727074248,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.597395833057595,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.6622059133403975),
(0.9678381395209652,0.5468721170669484,-1.7393483837445023,-0.39305481138617454,-0.2640844683810594,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0.22656883642177186),
(1.0099704853726577,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.597395833057595,-0.9693933242441344,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.020497504017596),
(0.335852951745577,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.2640844683810594,-0.6726196337092204,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.26220842321929216),
(-1.7426761102712554,-0.8822407378465996,-1.7393483837445023,0.9529955747893819,0.8469534138740592,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7901009739613176),
(1.178499868779428,1.9759849719804965,0.6064467288040396,-1.0048958960114276,-0.8196034095086188,-0.8172193437146309,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.1816339336872357),
(-0.6472351181272491,-0.8822407378465996,-1.7393483837445023,1.0753637917144325,0.5136420491975237,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.3739961155704849),
(0.4762941045845522,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.597395833057595,0.44010956328479556,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.8927257939030819),
(-0.6472351181272491,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.779636584646301),
(-0.45061750415268387,-0.8822407378465996,0.6064467288040396,1.0753637917144325,0.2914344727464999,-0.37860022336488575,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.27390195690510877),
(1.318941021618403,-0.8822407378465996,-1.7393483837445023,0.341154490164129,0.06922689629547615,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.0028735575862721954),
(-1.2089997294831498,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.18033068452098802,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.6606293881122438),
(-1.6443673032839727,-0.8822407378465996,0.6064467288040396,2.2990459609649383,3.624548119511856,0.32236408513753273,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.3224324580762002),
(-0.6472351181272491,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.2640844683810594,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.27466024598590705),
(0.7571764102625025,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.2640844683810594,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.7770867090813406),
(-0.8157645015340192,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,-0.041876891930035715,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.2951340511674613),
(1.0380587159404528,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,0.19842147656146658,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.8559487734843642),
(0.05497064606762669,1.9759849719804965,0.6064467288040396,-1.3720005467865792,-0.9307071977341307,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-1.673172797702219),
(-0.42252927358488884,-0.8822407378465996,-1.7393483837445023,0.8306273578643314,0.5136420491975237,1.0618883163080606,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.9094081536806445),
(0.05497064606762669,1.9759849719804965,-1.7393483837445023,-1.2496323298615286,-0.9307071977341307,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.684395476098034),
(-0.7034115792628391,-0.8822407378465996,0.6064467288040396,-0.39305481138617454,-0.15298068015554758,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.0016761768985176285),
(1.262764560482813,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.3751882566065713,-0.9452933725765659,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.693295765653128),
(1.6279115578641485,0.5468721170669484,-1.7393483837445023,-0.14831837753607335,-0.2640844683810594,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.8692188323983344),
(-0.6472351181272491,-0.8822407378465996,-1.7393483837445023,0.5858909240142302,0.4025382609720118,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.2872319628856362),
(0.335852951745577,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,-0.19162759163849277),
(1.318941021618403,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.15298068015554758,0.042116075746094286,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.4625800381230074),
(1.1082792923599403,1.9759849719804965,0.6064467288040396,-1.0048958960114276,-0.708499621283107,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.40362933678817586),
(-1.2511320753348423,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.15298068015554758,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.7217474880245871),
(-1.3775291128899199,-0.8822407378465996,-1.7393483837445023,0.341154490164129,0.2914344727464999,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(0.6167352574235273,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.48629204483208316,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.15718538552872705),
(-0.9281174238051993,-0.16768431038982562,-1.7393483837445023,0.2187862732390784,-0.041876891930035715,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.5351325452401244),
(1.529602750876866,0.5468721170669484,-1.7393483837445023,-0.39305481138617454,-0.48629204483208316,-0.9452933725765659,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1.6184084442270588),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.597395833057595,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.1006928490092534),
(0.0690147613515242,0.5468721170669484,-1.7393483837445023,-0.14831837753607335,-0.3751882566065713,-0.9315219716236697,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.4749085103832164),
(-0.4365733888687864,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-0.9315219716236697,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.10745750366988104),
(-0.7174556945467366,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.48629204483208316,-0.9693933242441344,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-0.7876762709662243,-0.8822407378465996,0.6064467288040396,1.0753637917144325,0.5136420491975237,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.4558913362967017),
(-1.1106909224958672,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.6247458374230355,-0.08526938306819591,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.7478326324040487),
(0.335852951745577,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.2914344727464999,-0.47706574017809383,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.080023196860263),
(-0.8859850779535069,-0.8822407378465996,0.6064467288040396,1.564836659414635,1.069160990325083,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.31522871180861634),
(0.7009999491269124,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.45670957244405713),
(-1.349440882322125,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.7358496256485474,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.7429037533788597),
(-0.7736321556823267,-0.8822407378465996,-0.5664508274702313,-0.8825276790863769,-0.48629204483208316,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,-1.7717503782059987),
(0.7290881796947074,0.5468721170669484,0.6064467288040396,0.4635227070891796,0.06922689629547615,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.6470401317244314),
(1.8807056329743037,0.5468721170669484,-1.7393483837445023,-0.14831837753607335,-0.15298068015554758,0.30721554408934687,1.4161194154023549,6.01029080042039,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.3408746406548795),
(-0.6472351181272491,-0.8822407378465996,-1.7393483837445023,0.8306273578643314,0.5136420491975237,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.029413675414212834),
(-0.08547050677134847,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.2914344727464999,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.7027743791631067),
(-0.015249930351860891,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.3751882566065713,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.38004654637534857),
(-0.591058656991659,-0.8822407378465996,0.6064467288040396,1.809573093264736,1.2913685667761068,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.06120186974118449),
(-0.2259116596103236,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.3751882566065713,2.8191190778976205,1.4161194154023549,6.01029080042039,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7368690804892766),
(-0.619146887559454,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,1.0618883163080606,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-1.5179702657288952,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.7358496256485474,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.8725711861953698),
(-1.2089997294831498,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.18033068452098802,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.7637567031008131),
(-0.08547050677134847,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.4025382609720118,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.3994587468437852),
(-0.2118675443264261,-0.8822407378465996,0.6064467288040396,1.0753637917144325,0.5136420491975237,-0.9356533919095386,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.476425088544813),
(0.12519122248711426,1.9759849719804965,-1.7393483837445023,-0.6377912452362757,-0.597395833057595,-1.0341189087227467,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7901009739613176),
(-1.0685585766441745,-0.8822407378465996,0.6064467288040396,1.809573093264736,1.069160990325083,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.07263615301971615),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.7759051408559422,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.10539424131020289),
(-0.3944410430170938,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.7358496256485474,0.30721554408934687,2.659945347654738,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.05892700249878958),
(0.08305887663542172,0.5468721170669484,-1.7393483837445023,-0.6377912452362757,-0.3751882566065713,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7368690804892766),
(1.6279115578641485,0.5468721170669484,-1.7393483837445023,-0.14831837753607335,-0.2640844683810594,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.33235016319313526),
(-1.0685585766441745,-0.8822407378465996,-1.7393483837445023,0.09641805631402782,0.18033068452098802,-0.9356533919095386,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.47067797337226863),
(-0.9562056543729944,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.4025382609720118,-0.7759051408559422,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.6075491524563625),
(0.2656323753260894,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.18033068452098802,-0.7635108799983356,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.877939156827515),
(-0.4365733888687864,-0.8822407378465996,0.6064467288040396,1.0753637917144325,0.5136420491975237,-0.08526938306819591,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.13216184586238303),
(-0.5067939652882739,0.5468721170669484,-1.7393483837445023,-1.2496323298615286,-0.708499621283107,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.7901009739613176),
(1.529602750876866,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.15298068015554758,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1.1190750845213757),
(1.2487204451989156,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.5526331411650426),
(0.8976175631014777,1.9759849719804965,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-1.0341189087227467,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.1058050256074052),
(0.27967649060998695,-0.8822407378465996,-1.7393483837445023,-0.39305481138617454,-0.597395833057595,0.10477595008177217,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,-1.5890785386416872),
(-1.1809114989153546,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.5136420491975237,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.44906673456951696),
(-0.9000291932374044,-0.8822407378465996,-1.7393483837445023,-0.39305481138617454,-0.2640844683810594,0.19842147656146658,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(0.6307793727074248,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.082433964003537),
(-0.8578968473857118,-0.8822407378465996,0.6064467288040396,1.6872048763396854,1.069160990325083,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.3421479741769561),
(0.6307793727074248,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.07756503204490514),
(-0.31017635131370874,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,0.06922689629547615,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.518889277069518),
(0.82739698668199,0.5468721170669484,-0.5664508274702313,-1.0048958960114276,-0.708499621283107,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1.0390755864971546),
(2.3160732067751266,1.9759849719804965,0.6064467288040396,-1.2496323298615286,-0.8196034095086188,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.5130062619960944),
(1.0380587159404528,0.5468721170669484,0.6064467288040396,0.09641805631402782,-0.041876891930035715,0.10821880031999623,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.0148103359116087),
(-0.998338000224687,0.5468721170669484,-1.7393483837445023,-0.5154230283112251,-0.48629204483208316,-0.6354368511364006,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7901009739613176),
(0.6167352574235273,-0.8822407378465996,-1.7393483837445023,0.341154490164129,0.18033068452098802,-0.12245216564101576,1.4161194154023549,6.01029080042039,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.2481201281579664),
(-0.08547050677134847,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.2914344727464999,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.31718438157716916),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.4025382609720118,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.2886885939806757),
(2.512690820749692,1.9759849719804965,0.6064467288040396,-1.3720005467865792,-0.9307071977341307,-0.12245216564101576,1.4161194154023549,6.01029080042039,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.8733894223427251),
(-0.6472351181272491,-0.8822407378465996,-1.7393483837445023,0.7082591409392808,0.5136420491975237,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.2890677385210748),
(-0.1978234290425286,0.5468721170669484,-1.7393483837445023,-1.0048958960114276,-0.597395833057595,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-0.18556127899210634),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.18033068452098802,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.9461851740993623),
(-0.15569108319083605,0.5468721170669484,0.6064467288040396,-1.0048958960114276,-0.597395833057595,0.44010956328479556,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-1.7358833046842388),
(1.4593821744573783,1.9759849719804965,0.6064467288040396,-0.7601594621613263,-0.597395833057595,-0.12245216564101576,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.017843492234802),
(-0.28208812074591366,-0.8822407378465996,0.6064467288040396,1.0753637917144325,0.5136420491975237,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.24774098361756727),
(1.4593821744573783,1.9759849719804965,0.6064467288040396,-0.7601594621613263,-0.597395833057595,-0.12245216564101576,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.080023196860263),
(-0.7876762709662243,-0.8822407378465996,0.6064467288040396,1.0753637917144325,0.6247458374230355,2.8191190778976205,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.49987210298300333),
(0.7712205255464,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.2640844683810594,0.44010956328479556,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.6948123438147246),
(1.318941021618403,1.9759849719804965,0.6064467288040396,-1.127264112936478,-0.708499621283107,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.8123471513384617),
(-1.2511320753348423,-0.8822407378465996,0.6064467288040396,-0.5154230283112251,-0.041876891930035715,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.561748491976145),
(0.05497064606762669,1.9759849719804965,-0.5664508274702313,-1.2496323298615286,-0.9307071977341307,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-1.6814381486829206),
(-1.2792203059026372,0.5468721170669484,-1.7393483837445023,-1.2496323298615286,-0.9307071977341307,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.7901009739613176),
(-0.5067939652882739,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.2914344727464999,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.12952371592111167),
(-0.2961322360298112,-0.8822407378465996,-1.7393483837445023,-0.5154230283112251,-0.2640844683810594,-0.7077367061391058,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(0.335852951745577,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.18033068452098802,1.620318624948003,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.2658040216558475),
(2.3160732067751266,1.9759849719804965,0.6064467288040396,-1.127264112936478,-0.8196034095086188,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.5590785983518282),
(-0.6472351181272491,-0.16768431038982562,0.6064467288040396,0.4635227070891796,0.4025382609720118,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.04457945703017891),
(1.9509262093937914,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.4038126343611388),
(-0.42252927358488884,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.6247458374230355,1.0618883163080606,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.6705470932291788),
(1.4593821744573783,1.9759849719804965,0.6064467288040396,-0.7601594621613263,-0.597395833057595,-0.12245216564101576,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.5323426335564514),
(0.05497064606762669,1.9759849719804965,-1.7393483837445023,-1.2496323298615286,-0.8196034095086188,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.6952390099534498),
(-0.8578968473857118,-0.8822407378465996,-1.7393483837445023,-0.14831837753607335,-0.15298068015554758,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.6602060544205681),
(-0.08547050677134847,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.2914344727464999,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.708461547269094),
(0.6307793727074248,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.597395833057595,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.046794377206016716),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.4025382609720118,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.12799125591799235),
(-0.12760285262304102,0.5468721170669484,-1.7393483837445023,-0.7601594621613263,-0.597395833057595,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.2617693316123359),
(0.12519122248711426,0.5468721170669484,-1.7393483837445023,-0.025950160611022774,-0.2640844683810594,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.1707746419165394),
(-0.3663528124492988,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.597395833057595,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-1.7428595642275833),
(-0.2118675443264261,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.5136420491975237,0.10821880031999623,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.14537195770979622),
(1.529602750876866,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.9452933725765659,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.9624883893365258),
(0.8695293325336826,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.15298068015554758,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.41841597386374274),
(-0.6051027722755565,-0.8822407378465996,-1.7393483837445023,0.7082591409392808,0.4025382609720118,0.10821880031999623,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.5320993889169312),
(1.1082792923599403,1.9759849719804965,0.6064467288040396,-1.0048958960114276,-0.708499621283107,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.5097898080999383),
(-1.5039261504449974,-0.8822407378465996,0.6064467288040396,1.564836659414635,1.1802647785505949,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.5821464682496194),
(1.318941021618403,1.9759849719804965,0.6064467288040396,-1.127264112936478,-0.8196034095086188,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.49121172562037996),
(1.0380587159404528,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.2640844683810594,0.10821880031999623,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.2203066768079491),
(0.9678381395209652,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.3751882566065713,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1.0948098339358299),
(0.4482058740167571,0.5468721170669484,0.6064467288040396,0.09641805631402782,-0.15298068015554758,0.44010956328479556,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.5985096305533399),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.4025382609720118,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.17955491341227703),
(-0.31017635131370874,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.3751882566065713,-0.6512739622322312,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7713712336655993),
(-0.7034115792628391,-0.8822407378465996,0.6064467288040396,-0.270686594461124,-0.15298068015554758,-0.7449194887119257,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.14089805213308623),
(0.9257057936692726,0.5468721170669484,-1.7393483837445023,-0.5154230283112251,-0.3751882566065713,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0.3842929652278191),
(-0.15569108319083605,0.5468721170669484,0.6064467288040396,-1.0048958960114276,-0.708499621283107,0.44010956328479556,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-1.7234473637591465),
(-1.7707643408390503,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,0.06922689629547615,-0.6354368511364006,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-0.08547050677134847,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.18033068452098802,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.10897408183147764),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-1.127264112936478,-0.708499621283107,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.09121423549927461),
(0.335852951745577,-0.16768431038982562,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.47706574017809383,2.659945347654738,6.01029080042039,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1.7901009739613176),
(0.6167352574235273,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.597395833057595,-0.9693933242441344,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-0.5067939652882739,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.2914344727464999,1.620318624948003,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.708461547269094),
(1.2487204451989156,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.6451444090224356),
(1.0099704853726577,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.2640844683810594,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.13178270132198386),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.7358496256485474,0.10821880031999623,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.880912366084151),
(0.1532794530549093,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.3751882566065713,-0.9693933242441344,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.6993620782995144),
(2.3722496679107166,1.9759849719804965,0.6064467288040396,-0.7601594621613263,-0.597395833057595,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.614237854282668),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.06922689629547615,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.6860920193855441),
(0.6307793727074248,0.5468721170669484,0.6064467288040396,-1.0048958960114276,-0.597395833057595,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.16818057720030247),
(-0.4787057347204789,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.18033068452098802,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.11655697263946067),
(1.4593821744573783,0.5468721170669484,0.6064467288040396,0.4635227070891796,0.06922689629547615,1.620318624948003,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.8421037230625585),
(3.991577638060311e-16,-3.7404664476736955,0.6064467288040396,8.78456145799262,9.957464048366033,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.27017045856767435),
(-0.2961322360298112,0.5468721170669484,-1.7393483837445023,-1.0048958960114276,-0.708499621283107,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-0.43541753111514747),
(-0.8859850779535069,-0.8822407378465996,0.6064467288040396,-0.5154230283112251,-0.2640844683810594,-0.47706574017809383,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-0.6472351181272491,-0.8822407378465996,0.6064467288040396,2.5437823948150395,2.4024064490312256,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.4225865638081334),
(-0.9281174238051993,-0.16768431038982562,-1.7393483837445023,0.09641805631402782,-0.041876891930035715,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.010077303853856082),
(2.3160732067751266,1.9759849719804965,0.6064467288040396,-1.2496323298615286,-0.8196034095086188,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.547129270632018),
(0.9678381395209652,0.5468721170669484,-1.7393483837445023,-0.6377912452362757,-0.3751882566065713,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0.850640749918776),
(0.6307793727074248,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.597395833057595,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.4574678615248554),
(0.8976175631014777,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-0.9452933725765659,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.5795524035333823),
(1.0099704853726577,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.597395833057595,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.2540505409034737),
(-0.2259116596103236,-0.8822407378465996,-1.7393483837445023,0.8306273578643314,0.5136420491975237,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.2189859456137888),
(2.2318085150717417,1.9759849719804965,-1.7393483837445023,-0.5154230283112251,-0.597395833057595,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.0830563531834563),
(-0.7876762709662243,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.18033068452098802,-0.5121828126079793,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.06916390508956669),
(-1.1809114989153546,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.6247458374230355,-0.9315219716236697,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.720913370035709),
(-0.3663528124492988,0.5468721170669484,-0.5664508274702313,-1.0048958960114276,-0.708499621283107,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,-0.22082172124922747),
(0.12519122248711426,1.9759849719804965,-0.5664508274702313,-1.2496323298615286,-0.8196034095086188,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0.2561421105729057),
(-0.2118675443264261,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.18033068452098802,-0.9356533919095386,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.6068508104421213),
(-1.349440882322125,-0.8822407378465996,-0.5664508274702313,-0.270686594461124,-0.15298068015554758,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.5677389757144515),
(1.529602750876866,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.3751882566065713,-0.9452933725765659,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.0345258520123648),
(-1.897161378394128,-0.8822407378465996,-1.7393483837445023,0.7082591409392808,0.4025382609720118,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-1.2651761906187398,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.041876891930035715,-0.7449194887119257,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.9333101415673138),
(1.2487204451989156,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.9253322243774089),
(1.8526174024065087,0.5468721170669484,-1.7393483837445023,-0.270686594461124,-0.48629204483208316,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.19282497232624735),
(2.3160732067751266,1.9759849719804965,0.6064467288040396,-1.2496323298615286,-0.8196034095086188,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.8244797766312345),
(1.641955673148046,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.3751882566065713,1.0618883163080606,2.659945347654738,6.01029080042039,2.082700496237388,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.7890234874066773),
(1.529602750876866,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.15298068015554758,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.735759954177833),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.5136420491975237,-0.9693933242441344,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.2041993085382219),
(0.5605587962879373,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.48629204483208316,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.5298844687410934),
(0.335852951745577,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.06922689629547615,-1.0341189087227467,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.5065608048093089),
(-1.026426230792482,0.5468721170669484,-1.7393483837445023,-0.8825276790863769,-0.597395833057595,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-1.7901009739613176),
(0.6167352574235273,0.5468721170669484,0.6064467288040396,0.09641805631402782,0.06922689629547615,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.8601193634287548),
(-1.4056173434577148,0.5468721170669484,-1.7393483837445023,-0.8825276790863769,-0.597395833057595,-0.7759051408559422,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.7901009739613176),
(0.82739698668199,1.9759849719804965,0.6064467288040396,-0.270686594461124,-0.48629204483208316,0.042116075746094286,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.4250447286234913),
(-0.9281174238051993,-0.8822407378465996,0.6064467288040396,-0.5154230283112251,-0.3751882566065713,-0.37860022336488575,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,-0.4892560558518271),
(-0.7736321556823267,-0.8822407378465996,0.6064467288040396,-0.025950160611022774,-0.041876891930035715,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.19807304882527835),
(-0.05738227620355344,0.0,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.5575620201902315),
(1.4312939438895833,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.2640844683810594,0.042116075746094286,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1.4094998024671261),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.2187862732390784,0.18033068452098802,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.019935061904234035),
(0.01283830021593414,0.5468721170669484,0.6064467288040396,0.09641805631402782,-0.2640844683810594,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.4407255546807356),
(-0.45061750415268387,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.4025382609720118,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.3232506942235556),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-1.127264112936478,-0.708499621283107,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.17841747979107955),
(-1.1949556141992521,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,0.4025382609720118,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,-0.35920947849491797),
(-0.3663528124492988,0.5468721170669484,-0.5664508274702313,-1.2496323298615286,-0.9307071977341307,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.40091537793882465),
(-0.12760285262304102,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.597395833057595,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.29816720749065445),
(1.2065880993472229,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.18033068452098802,-0.47706574017809383,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.269595467059839),
(-1.7426761102712554,-0.8822407378465996,-1.7393483837445023,0.7082591409392808,0.7358496256485474,-0.7077367061391058,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.8578968473857118,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,0.06922689629547615,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.6830747449038735),
(0.29372060589388443,-0.8822407378465996,0.6064467288040396,-0.270686594461124,-0.2640844683810594,-0.7759051408559422,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.2948148536936192),
(0.05497064606762669,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.06922689629547615,1.0618883163080606,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1.2961355848877796),
(2.442470244330204,1.9759849719804965,0.6064467288040396,-0.7601594621613263,-0.597395833057595,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.6955706328955229),
(1.529602750876866,0.5468721170669484,-1.7393483837445023,-0.270686594461124,-0.3751882566065713,-0.9452933725765659,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1.5274137545312623),
(4.689528689753807,1.9759849719804965,-1.7393483837445023,-0.5154230283112251,-0.597395833057595,2.8191190778976205,1.4161194154023549,6.01029080042039,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.7594502132555434),
(-0.2259116596103236,0.5468721170669484,-1.7393483837445023,-1.127264112936478,-0.708499621283107,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.746120207275016),
(-0.5770145417077616,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.5136420491975237,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.022209929146628945),
(0.9678381395209652,1.9759849719804965,0.6064467288040396,-1.127264112936478,-0.708499621283107,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.14960249472074402),
(-0.3944410430170938,-0.8822407378465996,-1.7393483837445023,-0.8825276790863769,-0.3751882566065713,-0.47706574017809383,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7901009739613176),
(0.27967649060998695,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.48629204483208316,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.23718488355294812),
(2.2318085150717417,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.2914344727464999,-0.6512739622322312,2.659945347654738,6.01029080042039,2.082700496237388,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.8458951684665499),
(-1.349440882322125,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.7358496256485474,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.813424637893102),
(-0.9000291932374044,-0.8822407378465996,0.6064467288040396,-0.5154230283112251,-0.3751882566065713,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.3523848767677332),
(0.4762941045845522,-0.16768431038982562,0.6064467288040396,-0.14831837753607335,-0.15298068015554758,-0.47706574017809383,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1.6354699485450206),
(-0.7876762709662243,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.5136420491975237,-0.5121828126079793,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.28262228133428924),
(-0.2118675443264261,-0.8822407378465996,0.6064467288040396,1.0753637917144325,0.5136420491975237,-0.9356533919095386,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.5530122857054417),
(1.698132134283636,1.9759849719804965,0.6064467288040396,-0.8825276790863769,-0.597395833057595,0.10821880031999623,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.0910183885318383),
(0.6869558338430148,-0.8822407378465996,0.6064467288040396,-0.270686594461124,-0.15298068015554758,-0.6354368511364006,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.014247893798246754),
(-1.925249608961923,-0.8822407378465996,-1.7393483837445023,1.3201002255645338,1.1802647785505949,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(0.7290881796947074,0.5468721170669484,0.6064467288040396,0.4635227070891796,0.06922689629547615,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.506377507236346),
(-0.6051027722755565,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.4025382609720118,-0.08526938306819591,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.30385437559664175),
(1.262764560482813,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.9452933725765659,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.44306036898968765),
(0.7571764102625025,0.5468721170669484,0.6064467288040396,0.5858909240142302,0.18033068452098802,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.18069234703347448),
(-0.4365733888687864,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.597395833057595,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.014551209430566077),
(-0.15569108319083605,0.5468721170669484,0.6064467288040396,-1.0048958960114276,-0.597395833057595,0.44010956328479556,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.17494523186093008),
(0.19541179890660185,-0.8822407378465996,0.6064467288040396,-0.270686594461124,-0.2640844683810594,-0.8172193437146309,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.10183028263045087),
(0.2656323753260894,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.48629204483208316,-0.47706574017809383,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.5530122857054417),
(-0.2680440054620162,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.3786057971218318),
(-1.9954701853814105,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.6247458374230355,-0.9315219716236697,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-0.6472351181272491,-0.8822407378465996,0.6064467288040396,1.3201002255645338,0.5136420491975237,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.12376071890704457),
(-0.5770145417077616,0.5468721170669484,-0.5664508274702313,-1.4943687637116299,-0.8196034095086188,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,-0.3607260566565146),
(-0.5067939652882739,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.2914344727464999,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.04488277266249824),
(0.9257057936692726,0.5468721170669484,-1.7393483837445023,-0.5154230283112251,-0.3751882566065713,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0.4457143807724817),
(1.2487204451989156,1.9759849719804965,-1.7393483837445023,-0.39305481138617454,-0.48629204483208316,2.8191190778976205,1.4161194154023549,6.01029080042039,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,-1.6725661664375804),
(1.4172498286056856,1.9759849719804965,0.6064467288040396,-1.127264112936478,-0.8196034095086188,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.3058100453651946),
(0.7290881796947074,0.5468721170669484,0.6064467288040396,0.4635227070891796,0.06922689629547615,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.43699405634330124),
(1.0661469465082478,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.2640844683810594,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.4843871238931952),
(-0.7314998098306342,0.5468721170669484,-1.7393483837445023,-0.39305481138617454,-0.2640844683810594,2.8191190778976205,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(1.2206322146311204,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.9452933725765659,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.307509921099754),
(-1.2792203059026372,0.5468721170669484,-1.7393483837445023,-1.2496323298615286,-0.9307071977341307,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.7901009739613176),
(0.9678381395209652,1.9759849719804965,0.6064467288040396,-1.127264112936478,-0.708499621283107,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.018039339202238273),
(1.3891615980378906,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.2640844683810594,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.9473226077205598),
(0.9678381395209652,0.5468721170669484,-1.7393483837445023,-0.39305481138617454,-0.2640844683810594,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0.5829647043969747),
(-1.925249608961923,-0.8822407378465996,-1.7393483837445023,1.3201002255645338,1.1802647785505949,-0.7449194887119257,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.160796865806805),
(0.27967649060998695,0.5468721170669484,0.6064467288040396,-1.0048958960114276,-0.597395833057595,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.13254099040278217),
(-0.6472351181272491,-0.8822407378465996,-1.7393483837445023,0.8306273578643314,0.5136420491975237,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.029413675414212834),
(-0.2118675443264261,0.5468721170669484,-0.5664508274702313,-1.127264112936478,-0.597395833057595,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.15870196369032366),
(1.5717350967285584,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,-0.9452933725765659,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.3605901567556355),
(-1.054514461360277,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.5136420491975237,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.4733319851550627),
(-0.7595880403984292,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,-0.15298068015554758,0.10821880031999623,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.5848004800324134),
(0.82739698668199,0.5468721170669484,-0.5664508274702313,-1.0048958960114276,-0.708499621283107,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0.5052400736151486),
(0.6588676032752199,1.9759849719804965,0.6064467288040396,-1.127264112936478,-0.708499621283107,-0.7635108799983356,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.668834668100146),
(1.318941021618403,1.9759849719804965,0.6064467288040396,-1.0048958960114276,-0.597395833057595,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.4051459149497724),
(1.1082792923599403,1.9759849719804965,0.6064467288040396,-1.0048958960114276,-0.708499621283107,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.22050252377538543),
(0.7009999491269124,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1.1410654678645265),
(1.2487204451989156,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.3835346761470208),
(-1.7145878797034604,-0.8822407378465996,-1.7393483837445023,0.2187862732390784,0.18033068452098802,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.6612792334111466,-0.8822407378465996,0.6064467288040396,-0.025950160611022774,-0.041876891930035715,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,-0.013808802191290492),
(-0.6331910028433516,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.041876891930035715,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.07485107319555397),
(2.9340142792666173,1.9759849719804965,0.6064467288040396,-1.127264112936478,-0.8196034095086188,0.19842147656146658,1.4161194154023549,6.01029080042039,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.947701752260959),
(0.6167352574235273,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.041876891930035715,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.2096906296767729),
(1.0380587159404528,0.5468721170669484,0.6064467288040396,0.8306273578643314,0.06922689629547615,-0.9356533919095386,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.7365182432586312),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.2640844683810594,-0.7635108799983356,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.4472309589340783),
(-0.6753233486950441,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.2914344727464999,-0.7759051408559422,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.23598750286519354),
(-0.6612792334111466,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.041876891930035715,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,-0.02328741570126929),
(-0.4365733888687864,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.6079882440633188),
(-1.2089997294831498,-0.8822407378465996,-1.7393483837445023,1.4424684424895844,1.7357837196781543,0.44010956328479556,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.2136179749816436),
(0.040926530783729174,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.3751882566065713,-0.9315219716236697,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.06802647146836922),
(-1.7426761102712554,-0.8822407378465996,-1.7393483837445023,0.5858909240142302,0.5136420491975237,-0.7077367061391058,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(1.9509262093937914,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.12245216564101576,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.8269379414465923),
(0.6307793727074248,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.20224363876966903),
(1.0099704853726577,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.9693933242441344,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.6453277065953986),
(-0.9562056543729944,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.4025382609720118,-0.7759051408559422,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.34973086498493916),
(0.8976175631014777,1.9759849719804965,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-1.0341189087227467,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.3636233130788287),
(0.335852951745577,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.9693933242441344,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.3922550005762013),
(-1.7005437644195627,-0.8822407378465996,-1.7393483837445023,-0.14831837753607335,0.18033068452098802,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(0.9678381395209652,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.2640844683810594,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.6538647334516161),
(-0.9562056543729944,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.2914344727464999,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.25115328448115964),
(1.1082792923599403,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.4773666751985743),
(0.82739698668199,0.5468721170669484,-0.5664508274702313,-1.0048958960114276,-0.708499621283107,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1.1615392730460807),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.18033068452098802,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.7695038182733575),
(-2.1499554535042833,-0.8822407378465996,0.6064467288040396,1.3201002255645338,1.1802647785505949,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.9000291932374044,-0.8822407378465996,0.6064467288040396,-0.5154230283112251,-0.15298068015554758,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.5142795955181712),
(1.2065880993472229,1.9759849719804965,0.6064467288040396,-0.7601594621613263,-0.48629204483208316,-0.6512739622322312,2.659945347654738,6.01029080042039,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.5883202495608888),
(1.0380587159404528,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,0.10821880031999623,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.7046701018651025),
(-1.32135265175433,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.2914344727464999,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.7892352162156361),
(1.1363675229277355,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.9452933725765659,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.8790765904487124),
(0.6167352574235273,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.15298068015554758,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.7001203673803127),
(-0.16973519847473356,0.5468721170669484,0.6064467288040396,0.341154490164129,0.06922689629547615,-0.7635108799983356,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.8297878001968226),
(1.4593821744573783,0.5468721170669484,0.6064467288040396,0.7082591409392808,0.18033068452098802,1.620318624948003,1.4161194154023549,-0.16638130054040892,2.082700496237388,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.5312051999352538),
(1.2065880993472229,-0.8822407378465996,0.6064467288040396,0.2187862732390784,-0.041876891930035715,-0.47706574017809383,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.5729110993791606),
(-0.9281174238051993,-0.8822407378465996,-1.7393483837445023,1.6872048763396854,1.1802647785505949,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.22126081285618374),
(-1.0685585766441745,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.3751882566065713,-0.9315219716236697,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(0.4060735281650646,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.18033068452098802,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.6629642024211958),
(0.6167352574235273,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.48629204483208316,0.19842147656146658,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.13671158034717285),
(1.318941021618403,1.9759849719804965,0.6064467288040396,-1.127264112936478,-0.8196034095086188,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.4593635842268512),
(-0.5489263111399665,0.5468721170669484,0.6064467288040396,-1.0048958960114276,-0.597395833057595,-0.6512739622322312,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1.7488500479658897),
(-0.562970426423864,-0.8822407378465996,0.6064467288040396,0.2187862732390784,0.2914344727464999,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.693295765653128),
(-0.4365733888687864,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.7358496256485474,0.44010956328479556,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.3839138206874199),
(-1.2792203059026372,-0.8822407378465996,-1.7393483837445023,0.7082591409392808,0.6247458374230355,0.44010956328479556,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7819114518886958),
(-0.7174556945467366,0.5468721170669484,-0.5664508274702313,-1.4943687637116299,-0.8196034095086188,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,-1.7901009739613176),
(0.7571764102625025,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.3751882566065713,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.6891251757087373),
(-1.9954701853814105,-1.5967971653033737,0.6064467288040396,2.054309527114837,1.846887507903666,-0.7759051408559422,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.7743727502319894),
(-1.32135265175433,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.6247458374230355,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.766486543791687),
(-0.9281174238051993,-0.16768431038982562,-1.7393483837445023,0.2187862732390784,-0.041876891930035715,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.3956073543732365),
(0.5465146810040398,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.708499621283107,-0.37860022336488575,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.7748118418389456),
(0.5043823351523472,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,-0.041876891930035715,-0.9693933242441344,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.2483633727974865),
(-0.7314998098306342,0.5468721170669484,-1.7393483837445023,-0.39305481138617454,-0.2640844683810594,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.4365733888687864,1.9759849719804965,-1.7393483837445023,-1.3720005467865792,-0.9307071977341307,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7600727263617046),
(1.318941021618403,1.9759849719804965,0.6064467288040396,-1.0048958960114276,-0.597395833057595,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.5211641443119129),
(1.4734262897412758,0.5468721170669484,-1.7393483837445023,-0.14831837753607335,-0.2640844683810594,0.042116075746094286,2.659945347654738,-0.16638130054040892,2.082700496237388,5.273893579545581,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.6790715706909232),
(-1.4056173434577148,-0.8822407378465996,-1.7393483837445023,-0.6377912452362757,-0.3751882566065713,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.7901009739613176),
(1.0380587159404528,0.5468721170669484,0.6064467288040396,0.4635227070891796,0.06922689629547615,-0.9356533919095386,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.2108280632979704),
(-0.6753233486950441,-0.16768431038982562,0.6064467288040396,0.2187862732390784,0.06922689629547615,-0.47706574017809383,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.044958601570578065),
(-0.8578968473857118,-0.8822407378465996,0.6064467288040396,1.564836659414635,1.069160990325083,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.33835652877296457),
(-0.33826458188150377,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.18033068452098802,0.44010956328479556,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.5617326101346222),
(0.6869558338430148,-0.8822407378465996,0.6064467288040396,-0.39305481138617454,-0.2640844683810594,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.5605951765134247),
(-1.7005437644195627,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.6247458374230355,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(0.34989706702947454,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.5136420491975237,-0.6512739622322312,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.13499915521814),
(-0.6472351181272491,-0.8822407378465996,0.6064467288040396,2.5437823948150395,2.4024064490312256,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.04641523266561756),
(2.3722496679107166,1.9759849719804965,0.6064467288040396,-0.7601594621613263,-0.597395833057595,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.614237854282668),
(0.05497064606762669,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.48629204483208316,-0.7635108799983356,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.765712372869366),
(0.7852646408302975,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.18033068452098802,0.042116075746094286,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.504285937566914),
(0.6729117185591174,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.48629204483208316,-0.9315219716236697,2.659945347654738,6.01029080042039,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.4404063572068936),
(-0.6331910028433516,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.041876891930035715,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.20262278331006817),
(-1.5179702657288952,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.7358496256485474,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.0344659049458076),
(0.8976175631014777,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.15298068015554758,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.6386989518356501),
(-0.9842938849407895,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.7358496256485474,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.04799175789377128),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.4025382609720118,0.10821880031999623,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.6530464973042608),
(2.3160732067751266,1.9759849719804965,0.6064467288040396,-1.2496323298615286,-0.8196034095086188,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1.1964205707628026),
(1.2487204451989156,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.48629204483208316,-1.0341189087227467,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.588835170075925),
(-0.3242204665976062,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.3751882566065713,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-1.2792203059026372,1.9759849719804965,-1.7393483837445023,-1.739105197561731,-1.0418109859596425,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.7901009739613176),
(-0.998338000224687,-0.8822407378465996,-1.7393483837445023,1.1977320086394831,0.7358496256485474,-0.08526938306819591,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.5317202443765321),
(-1.4898820351611,-0.8822407378465996,-1.7393483837445023,0.5858909240142302,0.18033068452098802,-0.9315219716236697,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.5770145417077616,-0.8822407378465996,0.6064467288040396,1.0753637917144325,0.6247458374230355,-0.6354368511364006,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.16015859478536315),
(0.8695293325336826,0.5468721170669484,0.6064467288040396,0.8306273578643314,0.06922689629547615,0.44010956328479556,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.6083673886037179),
(-1.3353967670382274,-0.8822407378465996,0.6064467288040396,2.788518828665141,3.7356519077373678,0.32236408513753273,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.04875004697456958),
(-0.08547050677134847,0.5468721170669484,-1.7393483837445023,-0.025950160611022774,-0.2640844683810594,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.2538072962639537),
(1.262764560482813,0.5468721170669484,-1.7393483837445023,-0.39305481138617454,-0.3751882566065713,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.8093139950152685),
(-0.2118675443264261,-0.8822407378465996,-1.7393483837445023,0.341154490164129,0.18033068452098802,0.10821880031999623,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.3046126646774401),
(1.262764560482813,0.5468721170669484,-1.7393483837445023,-0.270686594461124,-0.2640844683810594,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.3027768890420014),
(1.0661469465082478,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.597395833057595,-0.9693933242441344,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.429594463108281),
(0.335852951745577,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,-0.15298068015554758,-1.0341189087227467,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.7695038182733575),
(-2.262308375775463,-1.5967971653033737,-1.7393483837445023,1.809573093264736,1.5135761432271304,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.7174556945467366,0.5468721170669484,-1.7393483837445023,-0.39305481138617454,-0.48629204483208316,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.3944410430170938,-0.8822407378465996,0.6064467288040396,1.6872048763396854,2.624614025482249,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.5097898080999383),
(0.22350002947439687,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-1.0341189087227467,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.7986979478840922),
(-0.2259116596103236,-0.8822407378465996,-1.7393483837445023,0.8306273578643314,0.5136420491975237,-1.003821826626375,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.3793640862026301),
(-0.4365733888687864,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.7858070335105211),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,-0.15298068015554758,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.41759773771638736),
(-0.5770145417077616,-0.8822407378465996,0.6064467288040396,-0.025950160611022774,-0.041876891930035715,0.10821880031999623,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.6151320432643456),
(0.1532794530549093,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.18033068452098802,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.4483683925552758),
(-0.7876762709662243,-0.8822407378465996,0.6064467288040396,1.564836659414635,0.7358496256485474,2.8191190778976205,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.44300042192313055),
(-1.6584114185678702,-0.8822407378465996,0.6064467288040396,1.3201002255645338,1.069160990325083,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.8725711861953698),
(0.05497064606762669,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.18033068452098802,1.0618883163080606,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.0686488606482885),
(-0.15569108319083605,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.3751882566065713,-0.9693933242441344,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.0028735575862721954),
(-0.9281174238051993,-0.8822407378465996,-1.7393483837445023,1.6872048763396854,1.1802647785505949,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.2428720516589354),
(-1.2089997294831498,-0.8822407378465996,-1.7393483837445023,1.4424684424895844,1.7357837196781543,0.44010956328479556,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.35352231038893067),
(1.5717350967285584,0.5468721170669484,0.6064467288040396,0.2187862732390784,-0.041876891930035715,-0.9452933725765659,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.0913975330722376),
(-0.4084851583009913,-0.8822407378465996,0.6064467288040396,0.8306273578643314,1.6246799314526423,-0.7635108799983356,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.8957589502262752),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.06922689629547615,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09614311452446359),
(-0.3663528124492988,0.5468721170669484,-1.7393483837445023,-0.7601594621613263,-0.597395833057595,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7656840655596122),
(1.5717350967285584,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.2640844683810594,-0.9452933725765659,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.613675412169306),
(-0.6051027722755565,-0.8822407378465996,-1.7393483837445023,0.2187862732390784,-0.041876891930035715,-0.37860022336488575,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.17007629990229822),
(-0.9281174238051993,-0.16768431038982562,-1.7393483837445023,0.09641805631402782,-0.041876891930035715,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.13519500218557623),
(-0.9281174238051993,-0.16768431038982562,-1.7393483837445023,0.09641805631402782,-0.15298068015554758,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.723567381818503),
(-0.18377931375863107,0.5468721170669484,-1.7393483837445023,-1.0048958960114276,-0.708499621283107,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.23219605746120203),
(-1.3353967670382274,-0.8822407378465996,0.6064467288040396,3.1556234794402926,4.1800670606394155,0.32236408513753273,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.06878476054916753),
(0.82739698668199,-0.8822407378465996,-1.7393483837445023,0.341154490164129,0.06922689629547615,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.8487450272167802),
(0.8835734478175801,0.5468721170669484,0.6064467288040396,0.09641805631402782,-0.15298068015554758,-0.9356533919095386,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.1346200106777409),
(-0.6472351181272491,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.4025382609720118,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.34031219854151745),
(1.262764560482813,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.9452933725765659,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.5378465040894757),
(-0.3663528124492988,0.5468721170669484,-0.5664508274702313,-1.2496323298615286,-0.9307071977341307,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.2757976796071045),
(1.2065880993472229,1.9759849719804965,0.6064467288040396,-1.0048958960114276,-0.708499621283107,-0.37860022336488575,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.5533914302458409),
(-1.0685585766441745,-0.8822407378465996,-1.7393483837445023,0.09641805631402782,0.06922689629547615,-0.9356533919095386,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.28489714857668413),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.06922689629547615,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.0634767369835794),
(0.05497064606762669,-0.8822407378465996,0.6064467288040396,0.2187862732390784,-0.2640844683810594,-0.8172193437146309,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.5147186871251274),
(-1.5039261504449974,-0.8822407378465996,0.6064467288040396,1.564836659414635,1.1802647785505949,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.7641358476412122),
(1.178499868779428,1.9759849719804965,0.6064467288040396,-0.270686594461124,-0.48629204483208316,0.042116075746094286,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.7852320420026857),
(-0.2259116596103236,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.06922689629547615,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.19623727318983972),
(0.6307793727074248,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,-0.049069244448411625),
(0.9678381395209652,0.5468721170669484,-1.7393483837445023,-0.6377912452362757,-0.3751882566065713,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0.5878935834221637),
(2.3160732067751266,1.9759849719804965,0.6064467288040396,-1.127264112936478,-0.8196034095086188,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.58656030283353),
(0.335852951745577,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.4025382609720118,-0.47706574017809383,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.7918733461569075),
(-1.7707643408390503,-0.8822407378465996,-0.5664508274702313,-1.127264112936478,-0.48629204483208316,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,-1.7901009739613176),
(-0.15569108319083605,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.2640844683810594,-0.9693933242441344,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.513960398044329),
(1.1363675229277355,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.9452933725765659,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.0004028433764411),
(-0.4365733888687864,-0.8822407378465996,-1.7393483837445023,-0.5154230283112251,-0.3751882566065713,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-0.2443286827539749),
(-0.9562056543729944,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.2914344727464999,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.3042335201370409),
(0.6307793727074248,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.597395833057595,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.528747035119896),
(-1.1528232683475597,-0.8822407378465996,-1.7393483837445023,-0.39305481138617454,-0.15298068015554758,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.7808498471755783),
(0.6167352574235273,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.48629204483208316,0.19842147656146658,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.25690039965370404),
(0.4482058740167571,-0.8822407378465996,-1.7393483837445023,0.9529955747893819,0.4025382609720118,1.620318624948003,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.5719695127253993),
(1.178499868779428,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-0.9356533919095386,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.6093089752574792),
(1.0521028312243503,0.5468721170669484,0.6064467288040396,-1.0048958960114276,-0.708499621283107,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.35054910113229454),
(0.335852951745577,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.2914344727464999,1.620318624948003,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.9018252628726615),
(0.9678381395209652,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.2640844683810594,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.5878935834221637),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.8469534138740592,-0.9693933242441344,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.0031927550601142363),
(1.529602750876866,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.2640844683810594,-0.47706574017809383,1.4161194154023549,-0.16638130054040892,2.082700496237388,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.6752801252869316),
(-0.45061750415268387,-0.8822407378465996,0.6064467288040396,1.0753637917144325,0.2914344727464999,-0.37860022336488575,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.12565644160904033),
(3.991577638060311e-16,-3.7404664476736955,-1.7393483837445023,9.885875410318075,11.290709507072174,-0.5121828126079793,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.4696004868176283),
(1.2487204451989156,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.8828680358527039),
(1.529602750876866,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.9452933725765659,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.6705470932291788),
(1.1082792923599403,1.9759849719804965,0.6064467288040396,-1.0048958960114276,-0.708499621283107,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.5370882150086773),
(-0.6051027722755565,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,-0.15298068015554758,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.052162347838161954),
(1.178499868779428,0.5468721170669484,-1.7393483837445023,0.09641805631402782,-0.3751882566065713,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.2800282166180523),
(0.22350002947439687,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-1.0341189087227467,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.5332967696046859),
(0.05497064606762669,-0.8822407378465996,-1.7393483837445023,0.09641805631402782,-0.2640844683810594,-0.8172193437146309,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1.4007794780379454),
(-0.9281174238051993,-0.16768431038982562,-1.7393483837445023,0.09641805631402782,-0.041876891930035715,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,-0.09797889015990223),
(1.8526174024065087,0.5468721170669484,-1.7393483837445023,-0.270686594461124,-0.48629204483208316,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.4961406046455689),
(-0.5770145417077616,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.2640844683810594,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.5093507164929821),
(1.2487204451989156,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.48629204483208316,-1.0341189087227467,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.8129095934518238),
(-1.4898820351611,-0.8822407378465996,-1.7393483837445023,0.8306273578643314,0.4025382609720118,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(3.991577638060311e-16,-3.7404664476736955,0.6064467288040396,9.02929789184272,11.735124659974222,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.4847662684335944),
(2.3160732067751266,1.9759849719804965,0.6064467288040396,-1.127264112936478,-0.8196034095086188,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.9120621654634387),
(-0.49274985000437643,-0.8822407378465996,0.6064467288040396,0.2187862732390784,0.18033068452098802,0.10821880031999623,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.19845219336567752),
(0.34989706702947454,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.5136420491975237,-0.6512739622322312,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.1767050546620468),
(0.4762941045845522,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.708499621283107,1.0618883163080606,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1.110354760092195),
(-2.1639995687881806,-0.8822407378465996,-1.7393483837445023,2.054309527114837,1.7357837196781543,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.7876762709662243,0.5468721170669484,-1.7393483837445023,-1.0048958960114276,-0.597395833057595,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.7901009739613176),
(-0.2259116596103236,-0.8822407378465996,-1.7393483837445023,0.7082591409392808,0.4025382609720118,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.27964907207765316),
(-0.8157645015340192,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.18033068452098802,-1.003821826626375,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.4850854659074364),
(1.8526174024065087,0.5468721170669484,-1.7393483837445023,-0.39305481138617454,-0.3751882566065713,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.10183028263045087),
(0.8695293325336826,0.5468721170669484,0.6064467288040396,0.341154490164129,-0.041876891930035715,0.44010956328479556,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.40059618046498263),
(-1.1809114989153546,-0.8822407378465996,-0.5664508274702313,1.0753637917144325,0.8469534138740592,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.49342664579621776),
(0.1532794530549093,-0.16768431038982562,0.6064467288040396,-0.14831837753607335,-0.2640844683810594,-0.47706574017809383,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.6212583029772891),
(-0.15569108319083605,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.3751882566065713,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.06922689629547615,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.038832341857634525),
(-0.12760285262304102,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.48629204483208316,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.4752277078570585),
(0.6026911421396298,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.06922689629547615,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.10600087257484153),
(-0.3944410430170938,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.6247458374230355,0.30721554408934687,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.11049065999307425),
(1.0380587159404528,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,2.8191190778976205,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.341632929735678),
(1.2065880993472229,1.9759849719804965,0.6064467288040396,-1.0048958960114276,-0.8196034095086188,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.8783183013679141),
(-0.3944410430170938,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.8469534138740592,0.30721554408934687,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.027837150186059114),
(-0.6331910028433516,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,-0.041876891930035715,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.008500778625702364),
(0.9678381395209652,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.2640844683810594,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.7748118418389456),
(0.9257057936692726,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.3751882566065713,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.9560429321497402),
(0.335852951745577,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.48629204483208316,-0.47706574017809383,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.2961355848877796),
(0.7852646408302975,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.18033068452098802,0.042116075746094286,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.0413504537395495),
(1.5998233272963533,0.5468721170669484,-1.7393483837445023,-0.025950160611022774,-0.15298068015554758,-0.9452933725765659,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.1634349957480765),
(1.318941021618403,1.9759849719804965,-1.7393483837445023,-1.3720005467865792,-0.9307071977341307,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0.08325220015089242),
(0.9257057936692726,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.6963289219763211),
(0.4762941045845522,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.18033068452098802,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.4028710477073775),
(2.0913673622327664,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.597395833057595,-1.0341189087227467,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1.7757534284927068),
(-1.1247350377797647,-0.8822407378465996,-1.7393483837445023,-0.39305481138617454,-0.2640844683810594,-0.7759051408559422,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-1.2370879600509448,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.7358496256485474,-1.003821826626375,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.5044218374677931),
(0.335852951745577,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,-0.15298068015554758,-1.0341189087227467,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.7573711929805846),
(1.2065880993472229,1.9759849719804965,0.6064467288040396,-1.2496323298615286,-0.8196034095086188,-0.37860022336488575,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.7713995409753532),
(-1.897161378394128,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.5136420491975237,-0.08526938306819591,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(2.3160732067751266,1.9759849719804965,0.6064467288040396,-1.2496323298615286,-0.8196034095086188,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.696133075008885),
(1.6279115578641485,0.5468721170669484,-1.7393483837445023,-0.270686594461124,-0.2640844683810594,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1.5895934591567233),
(0.7290881796947074,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.06922689629547615,0.042116075746094286,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.5130062619960944),
(0.4762941045845522,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.48629204483208316,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.5071357963171443),
(0.4762941045845522,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.08526938306819591,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.3251464169255514),
(0.335852951745577,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.06922689629547615,-0.8984706093367187,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.5217265864252751),
(-0.8578968473857118,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.18033068452098802,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.5222416308665533),
(1.262764560482813,0.5468721170669484,-1.7393483837445023,-0.270686594461124,-0.2640844683810594,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.5863770052605671),
(-0.4365733888687864,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.5136420491975237,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.12799125591799235),
(-0.6472351181272491,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.597395833057595,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1.7901009739613176),
(0.5465146810040398,0.0,-1.7393483837445023,-0.5154230283112251,-0.597395833057595,-0.6726196337092204,1.4161194154023549,6.01029080042039,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.2715070716033574),
(1.6279115578641485,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.041876891930035715,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.820871628800206),
(-0.1135587373391435,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.2914344727464999,-0.6512739622322312,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.6667556478251874),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.597395833057595,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.1787366772649216),
(0.19541179890660185,1.9759849719804965,-1.7393483837445023,-1.3720005467865792,-0.9307071977341307,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-1.7901009739613176),
(-0.8859850779535069,-0.8822407378465996,0.6064467288040396,1.3201002255645338,0.9580572020995711,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.279589125011096),
(0.9397499089531701,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.3751882566065713,-0.37860022336488575,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.5602160319730256),
(-0.4787057347204789,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.06922689629547615,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.4028710477073775),
(-0.3663528124492988,0.5468721170669484,-0.5664508274702313,-1.3720005467865792,-0.9307071977341307,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.44360705318776916),
(-0.6472351181272491,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.5136420491975237,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.03965057800498994),
(-0.6472351181272491,-0.8822407378465996,0.6064467288040396,-0.025950160611022774,0.18033068452098802,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.3114372664046248),
(-0.15569108319083605,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.597395833057595,-0.7759051408559422,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.04611191703329824),
(-1.0685585766441745,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.06922689629547615,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.3921950535096442),
(-0.7876762709662243,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.597395833057595,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-1.696907245931206),
(0.39202941288116705,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.48629204483208316,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.03807405277683622),
(-0.7174556945467366,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.597395833057595,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-1.349440882322125,-0.8822407378465996,-1.7393483837445023,-0.270686594461124,-0.15298068015554758,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-0.8217658177818834),
(-0.6472351181272491,-0.16768431038982562,0.6064467288040396,0.4635227070891796,0.4025382609720118,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.0919125775135158),
(0.6167352574235273,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,-0.041876891930035715,0.10821880031999623,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.1890335269222558),
(-0.8859850779535069,0.5468721170669484,-1.7393483837445023,-0.8825276790863769,-0.48629204483208316,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.7901009739613176),
(-1.026426230792482,-0.8822407378465996,-1.7393483837445023,-0.14831837753607335,0.06922689629547615,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-0.7637567031008131),
(-0.5067939652882739,-0.8822407378465996,0.6064467288040396,1.564836659414635,1.069160990325083,1.620318624948003,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.2316810130199238),
(-0.6472351181272491,-0.8822407378465996,0.6064467288040396,1.3201002255645338,0.5136420491975237,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.3706437617734496),
(-1.0685585766441745,-0.8822407378465996,-1.7393483837445023,0.341154490164129,0.18033068452098802,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.7641358476412122),
(-1.026426230792482,-0.8822407378465996,-1.7393483837445023,1.0753637917144325,0.8469534138740592,0.44010956328479556,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.5548480613408804),
(-0.7876762709662243,-0.8822407378465996,0.6064467288040396,1.564836659414635,0.7358496256485474,2.8191190778976205,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.11617782809906153),
(-1.4196614587416125,-0.8822407378465996,-1.7393483837445023,-0.025950160611022774,-0.041876891930035715,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,-0.1844238453709089),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.597395833057595,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.054437215080556864),
(1.0380587159404528,0.5468721170669484,0.6064467288040396,0.8306273578643314,0.06922689629547615,-0.9356533919095386,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.0459001882243393),
(1.0661469465082478,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.2640844683810594,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.5602160319730256),
(0.05497064606762669,-0.8822407378465996,0.6064467288040396,0.7082591409392808,-0.041876891930035715,-0.8172193437146309,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.9795498936544877),
(-0.6612792334111466,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.041876891930035715,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.09235166912047206),
(1.318941021618403,1.9759849719804965,-1.7393483837445023,-0.5154230283112251,-0.48629204483208316,-0.9315219716236697,2.659945347654738,6.01029080042039,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.18334635881626854),
(-0.33826458188150377,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.2640844683810594,0.10821880031999623,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.4634742271046847),
(0.9959263700887603,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.9169910444886277),
(0.7852646408302975,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.18033068452098802,0.042116075746094286,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.1213499517637706),
(1.178499868779428,0.5468721170669484,0.6064467288040396,0.341154490164129,0.18033068452098802,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.9222990680542158),
(0.8976175631014777,1.9759849719804965,-1.7393483837445023,-0.39305481138617454,-0.48629204483208316,-1.0341189087227467,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.4787057347204789,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.18033068452098802,-0.12245216564101576,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.26442334339512996),
(-1.054514461360277,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.8469534138740592,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.42404319490317294),
(0.8976175631014777,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.2640844683810594,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.034904996552764),
(-0.015249930351860891,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.2640844683810594,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.18556127899210634),
(-0.2259116596103236,-0.8822407378465996,-1.7393483837445023,0.7082591409392808,0.4025382609720118,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.1734886007658906),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.2914344727464999,0.10821880031999623,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.6943732522077682),
(1.0521028312243503,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.708499621283107,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.391496711495403),
(-0.08547050677134847,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.4025382609720118,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11282547430202627),
(0.9257057936692726,0.5468721170669484,-1.7393483837445023,-0.270686594461124,-0.2640844683810594,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0.05481635962095602),
(0.6307793727074248,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.3751882566065713,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,-0.1976939042848792),
(-0.15569108319083605,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.3751882566065713,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(3.776661196300468,1.9759849719804965,-1.7393483837445023,-0.5154230283112251,-0.708499621283107,0.19842147656146658,1.4161194154023549,6.01029080042039,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.9393605723721776),
(-1.43370557402551,-0.8822407378465996,0.6064467288040396,-0.39305481138617454,-0.2640844683810594,-0.47706574017809383,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1.7901009739613176),
(0.05497064606762669,-0.8822407378465996,-1.7393483837445023,0.7082591409392808,0.5136420491975237,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.3801223752834284),
(0.9678381395209652,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.2640844683810594,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.8692188323983344),
(0.4482058740167571,0.5468721170669484,0.6064467288040396,0.09641805631402782,-0.15298068015554758,0.44010956328479556,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.8923466493626827),
(-0.8578968473857118,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.5136420491975237,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.8050834580043207),
(1.290852791050608,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,0.042116075746094286,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.3674147584828202),
(1.234676329915018,0.5468721170669484,0.6064467288040396,0.09641805631402782,-0.2640844683810594,-0.9693933242441344,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.6413529636184442),
(1.2487204451989156,-0.8822407378465996,0.6064467288040396,-0.5154230283112251,-0.3751882566065713,-0.6354368511364006,2.659945347654738,6.01029080042039,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.825617210252432),
(3.991577638060311e-16,-0.8822407378465996,0.6064467288040396,1.3201002255645338,2.2913026608057137,-1.0341189087227467,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.6730052580445367),
(-1.2089997294831498,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.18033068452098802,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.8888744014325333),
(-0.2259116596103236,0.5468721170669484,0.6064467288040396,0.09641805631402782,-0.041876891930035715,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.3140912781874189),
(2.3160732067751266,1.9759849719804965,0.6064467288040396,-1.127264112936478,-0.8196034095086188,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.45898443968645203),
(1.2065880993472229,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.18033068452098802,-0.47706574017809383,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1.8079807144266349),
(-0.8859850779535069,-0.8822407378465996,0.6064467288040396,1.564836659414635,1.069160990325083,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.4611993598622898),
(-0.7876762709662243,-0.8822407378465996,-1.7393483837445023,0.9529955747893819,0.6247458374230355,-0.5121828126079793,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.14315703753395842),
(-0.4365733888687864,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.2914344727464999,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.2853362401836404),
(-0.3944410430170938,-0.8822407378465996,0.6064467288040396,1.6872048763396854,2.624614025482249,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.13443671310477792),
(-0.15569108319083605,-0.8822407378465996,-1.7393483837445023,0.2187862732390784,0.06922689629547615,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.3099806353095853),
(-0.1978234290425286,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.06922689629547615,0.042116075746094286,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.8896926375798887),
(0.19541179890660185,1.9759849719804965,-1.7393483837445023,-1.0048958960114276,-0.708499621283107,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-1.7394472633639908),
(0.6307793727074248,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.01917677282343573),
(0.7571764102625025,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.3751882566065713,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.9886493626240673),
(1.318941021618403,1.9759849719804965,-1.7393483837445023,-0.5154230283112251,-0.48629204483208316,-0.9315219716236697,2.659945347654738,6.01029080042039,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11661691970601779),
(-1.4477496893094075,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,0.06922689629547615,-0.7077367061391058,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1.7901009739613176),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.597395833057595,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.04717352174641587),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,-0.15298068015554758,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-1.0685585766441745,-0.8822407378465996,-1.7393483837445023,0.341154490164129,0.2914344727464999,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.6094448751583582),
(0.82739698668199,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.597395833057595,0.042116075746094286,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.6695929571809442),
(0.8695293325336826,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.15298068015554758,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.00931901477305778),
(-0.8017203862501218,-0.8822407378465996,0.6064467288040396,-0.5154230283112251,-0.15298068015554758,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.010456448394255234),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.6247458374230355,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.8539931037158113),
(-0.7876762709662243,-0.8822407378465996,0.6064467288040396,1.6872048763396854,0.8469534138740592,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.42555977306476955),
(-1.054514461360277,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.8469534138740592,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.4126688586911984),
(-0.9281174238051993,-0.8822407378465996,-1.7393483837445023,1.6872048763396854,1.1802647785505949,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.3046726117439972),
(-0.6472351181272491,-0.8822407378465996,-1.7393483837445023,0.5858909240142302,0.4025382609720118,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.12799125591799235),
(-0.4365733888687864,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.597395833057595,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.06127769864926432),
(0.6167352574235273,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.15298068015554758,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.9321568261045937),
(-0.8578968473857118,-0.8822407378465996,-1.7393483837445023,0.9529955747893819,0.5136420491975237,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.7542780895908343),
(3.0744554321055926,1.9759849719804965,-1.7393483837445023,-0.270686594461124,-0.597395833057595,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.533675914145085),
(-0.33826458188150377,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.18033068452098802,0.44010956328479556,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.5731069463465968),
(0.82739698668199,0.5468721170669484,-0.5664508274702313,-1.0048958960114276,-0.708499621283107,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0.7623000720057737),
(1.0380587159404528,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.3751882566065713,-0.7635108799983356,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.6227465738291318),
(-0.9281174238051993,0.5468721170669484,0.6064467288040396,-1.127264112936478,-0.708499621283107,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(1.0521028312243503,0.5468721170669484,0.6064467288040396,-1.127264112936478,-0.8196034095086188,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.30505175628439635),
(-0.9281174238051993,-0.16768431038982562,-1.7393483837445023,0.09641805631402782,-0.15298068015554758,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.8050834580043207),
(-1.4196614587416125,0.0,0.6064467288040396,9.518770759542923,11.735124659974222,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.74599685676861),
(0.4762941045845522,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.7403096886626228),
(-0.08547050677134847,0.5468721170669484,-1.7393483837445023,-0.14831837753607335,-0.2640844683810594,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.29216084191082514),
(0.4482058740167571,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.2914344727464999,1.620318624948003,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1.3909217199875676),
(0.05497064606762669,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.5136420491975237,1.0618883163080606,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.7245689155388213),
(0.4060735281650646,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.041876891930035715,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.6201208693560917),
(-1.4477496893094075,-0.8822407378465996,0.6064467288040396,-0.39305481138617454,-0.15298068015554758,-0.7077367061391058,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1.7901009739613176),
(0.6167352574235273,-0.8822407378465996,0.6064467288040396,-0.025950160611022774,-0.3751882566065713,-0.8172193437146309,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1.064857415244297),
(-0.6472351181272491,-0.8822407378465996,-1.7393483837445023,0.8306273578643314,0.5136420491975237,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.23939980372878591),
(0.6167352574235273,0.5468721170669484,0.6064467288040396,0.09641805631402782,0.06922689629547615,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.5454293948974587),
(0.335852951745577,-0.8822407378465996,-1.7393483837445023,0.8306273578643314,0.18033068452098802,1.620318624948003,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1.7700662603867197),
(1.9509262093937914,1.9759849719804965,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.7966063782146602),
(-0.7736321556823267,0.5468721170669484,-1.7393483837445023,-0.6377912452362757,-0.3751882566065713,-0.7759051408559422,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.6611160013175261),
(0.9678381395209652,0.5468721170669484,-1.7393483837445023,-0.6377912452362757,-0.3751882566065713,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0.47149620951962407),
(0.4060735281650646,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.48629204483208316,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.6739593940927712),
(-0.591058656991659,-0.8822407378465996,0.6064467288040396,1.809573093264736,1.1802647785505949,0.44010956328479556,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.2583570307487435),
(0.2656323753260894,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.597395833057595,-0.37860022336488575,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.2129196329674024),
(-0.9842938849407895,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.7358496256485474,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.18176983358811483),
(-0.7174556945467366,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.3751882566065713,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.6527431816719415),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.2914344727464999,-0.9693933242441344,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.3179426706579675),
(0.6167352574235273,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.597395833057595,-0.9693933242441344,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(0.1532794530549093,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.3751882566065713,-0.9693933242441344,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.5241973006351062),
(1.9509262093937914,1.9759849719804965,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.3985046107955506),
(-0.6472351181272491,-0.8822407378465996,0.6064467288040396,1.0753637917144325,0.5136420491975237,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.053998123473600605),
(1.0380587159404528,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.3751882566065713,0.10821880031999623,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.0989804238802205),
(0.5465146810040398,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.708499621283107,-0.37860022336488575,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.35206567929389115),
(-0.2259116596103236,0.5468721170669484,-1.7393483837445023,-1.0048958960114276,-0.708499621283107,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.7123763431794914),
(0.05497064606762669,-0.8822407378465996,0.6064467288040396,0.7082591409392808,-0.041876891930035715,-0.8172193437146309,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.24969665338612013),
(-0.9000291932374044,-0.8822407378465996,0.6064467288040396,-0.39305481138617454,-0.2640844683810594,0.19842147656146658,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.9562056543729944,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.2914344727464999,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.5010853655122807),
(-0.7174556945467366,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.597395833057595,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.7595880403984292,-0.8822407378465996,-1.7393483837445023,-0.025950160611022774,-0.041876891930035715,-0.7759051408559422,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.06886058945724736),
(-1.1809114989153546,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.6247458374230355,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.48015658688224744),
(-1.2511320753348423,-0.8822407378465996,0.6064467288040396,-0.39305481138617454,-0.041876891930035715,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.6685914234606259),
(-0.4787057347204789,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.18033068452098802,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.2041993085382219),
(-0.7876762709662243,-0.8822407378465996,-1.7393483837445023,0.9529955747893819,0.6247458374230355,-0.5121828126079793,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,-0.04641523266561756),
(2.2318085150717417,1.9759849719804965,-1.7393483837445023,-0.5154230283112251,-0.597395833057595,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.102013580203414),
(1.262764560482813,0.5468721170669484,-1.7393483837445023,-0.39305481138617454,-0.3751882566065713,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.6242914593004822),
(0.12519122248711426,1.9759849719804965,-0.5664508274702313,-1.3720005467865792,-0.8196034095086188,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0.3376581867587234),
(-0.3663528124492988,0.5468721170669484,-0.5664508274702313,-0.8825276790863769,-0.597395833057595,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.40933238673568584),
(-0.31017635131370874,-0.8822407378465996,0.6064467288040396,0.341154490164129,1.4024723550016185,-0.7635108799983356,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.1907334026568153),
(-0.5067939652882739,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.041876891930035715,-0.12245216564101576,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.02865538633341453),
(-0.8157645015340192,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.4025382609720118,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.521483341785755),
(1.318941021618403,1.9759849719804965,0.6064467288040396,-1.127264112936478,-0.8196034095086188,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.7198358834810686),
(0.82739698668199,0.5468721170669484,-0.5664508274702313,-1.0048958960114276,-0.708499621283107,2.8191190778976205,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1.0595493916787089),
(0.9116616783853752,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.8301669447372219),
(1.2487204451989156,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.2640844683810594,-0.9356533919095386,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.3423912188164762),
(1.2065880993472229,1.9759849719804965,0.6064467288040396,-1.3720005467865792,-0.9307071977341307,-1.0341189087227467,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.52400145366767),
(-0.15569108319083605,-0.8822407378465996,-1.7393483837445023,0.2187862732390784,0.06922689629547615,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.15453137374593298),
(-0.7876762709662243,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.06922689629547615,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(2.3160732067751266,1.9759849719804965,0.6064467288040396,-1.2496323298615286,-0.8196034095086188,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.9412562950741733),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,-0.025950160611022774,-0.041876891930035715,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.22201910193698204),
(-0.4084851583009913,-0.8822407378465996,0.6064467288040396,0.8306273578643314,1.6246799314526423,-0.7635108799983356,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.02315151580039),
(-0.6472351181272491,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.2640844683810594,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.19124844709809363),
(-1.026426230792482,0.5468721170669484,-1.7393483837445023,-0.7601594621613263,-0.48629204483208316,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-1.7118455408229325),
(0.6167352574235273,0.5468721170669484,0.6064467288040396,-1.127264112936478,-0.597395833057595,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.12799125591799235),
(-1.6864996491356652,-0.8822407378465996,-1.7393483837445023,0.341154490164129,0.06922689629547615,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.4365733888687864,-0.8822407378465996,-1.7393483837445023,-0.5154230283112251,-0.3751882566065713,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-0.08850027664992344),
(-0.6051027722755565,-0.8822407378465996,-1.7393483837445023,0.8306273578643314,0.4025382609720118,-0.08526938306819591,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.45551219175630253),
(-1.1949556141992521,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,0.4025382609720118,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,-0.3705838147068925),
(-0.15569108319083605,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.2640844683810594,-0.9693933242441344,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.7312102196930431),
(-0.5067939652882739,-0.8822407378465996,-1.7393483837445023,0.341154490164129,0.06922689629547615,0.32236408513753273,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.11352381631626746),
(0.6167352574235273,1.9759849719804965,0.6064467288040396,-0.39305481138617454,-0.597395833057595,0.042116075746094286,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7781200064847043),
(-0.4365733888687864,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.597395833057595,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.08402637107321344),
(-0.4365733888687864,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.6247458374230355,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.5526331411650426),
(0.05497064606762669,-0.8822407378465996,-1.7393483837445023,0.8306273578643314,0.5136420491975237,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.2785116384564557),
(0.2656323753260894,1.9759849719804965,0.6064467288040396,-1.2496323298615286,-0.8196034095086188,-0.37860022336488575,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.404008481328575),
(-0.7314998098306342,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.6247458374230355,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.00395104414091254),
(1.529602750876866,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.47706574017809383,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.6373656712470164),
(-0.4365733888687864,-0.8822407378465996,0.6064467288040396,1.3201002255645338,0.5136420491975237,-0.08526938306819591,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.2924800393846672),
(1.4593821744573783,0.5468721170669484,0.6064467288040396,0.5858909240142302,0.06922689629547615,1.620318624948003,1.4161194154023549,-0.16638130054040892,2.082700496237388,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.6904459069028976),
(-0.6472351181272491,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.4025382609720118,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.3933924341973987),
(0.05497064606762669,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.5136420491975237,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09652225906486274),
(-0.8157645015340192,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,-0.041876891930035715,-0.9315219716236697,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.40432767880241705),
(-1.6162790727161778,-0.8822407378465996,-1.7393483837445023,0.8306273578643314,0.8469534138740592,-0.5121828126079793,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,-0.21285968590084528),
(-0.8578968473857118,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.5136420491975237,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.7542780895908343),
(1.8526174024065087,0.5468721170669484,-1.7393483837445023,-0.270686594461124,-0.48629204483208316,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.6819214294411534),
(-0.7595880403984292,-0.16768431038982562,0.6064467288040396,-0.8825276790863769,-0.48629204483208316,1.0618883163080606,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.4025382609720118,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.3933924341973987),
(1.9509262093937914,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.8965172393070734),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.708499621283107,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.5655240555386137),
(0.335852951745577,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.18033068452098802,1.620318624948003,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.2658040216558475),
(0.8976175631014777,0.5468721170669484,-1.7393483837445023,-0.5154230283112251,-0.3751882566065713,-0.9452933725765659,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.5757609581293909),
(1.698132134283636,1.9759849719804965,0.6064467288040396,-0.8825276790863769,-0.597395833057595,0.10821880031999623,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.4085582158133648),
(-1.32135265175433,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.4025382609720118,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1.7901009739613176),
(-1.349440882322125,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.7358496256485474,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.7542780895908343),
(-1.2511320753348423,-0.8822407378465996,-1.7393483837445023,-0.5154230283112251,-0.041876891930035715,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,-0.6830747449038735),
(-0.4365733888687864,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-0.9315219716236697,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.08812113210952428),
(-0.6612792334111466,-0.8822407378465996,0.6064467288040396,0.2187862732390784,0.06922689629547615,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,-0.17267036461853516),
(0.335852951745577,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,-0.1029077691850912),
(-1.2511320753348423,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.15298068015554758,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.7968181070236192),
(0.05497064606762669,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.5136420491975237,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.45670957244405713),
(1.262764560482813,0.5468721170669484,-1.7393483837445023,-0.39305481138617454,-0.3751882566065713,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1.110354760092195),
(-0.562970426423864,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.4025382609720118,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.21557364475019647),
(-1.3353967670382274,-0.8822407378465996,0.6064467288040396,2.788518828665141,3.7356519077373678,0.32236408513753273,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.10669921458908273),
(0.8414411019658875,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.2640844683810594,0.10821880031999623,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.060124383186544145),
(-1.0685585766441745,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.2914344727464999,-0.9315219716236697,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.6473593291982734),
(1.290852791050608,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,0.042116075746094286,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.3097847883421492),
(0.6167352574235273,1.9759849719804965,0.6064467288040396,-0.39305481138617454,-0.597395833057595,-0.9693933242441344,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1.7740252454483936),
(2.3160732067751266,1.9759849719804965,0.6064467288040396,-1.127264112936478,-0.8196034095086188,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.4309277436969148),
(-0.8578968473857118,-0.8822407378465996,-1.7393483837445023,0.8306273578643314,0.7358496256485474,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,-0.052481545312003997),
(-0.6753233486950441,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,0.2914344727464999,-0.7759051408559422,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.22082172124922747),
(0.6167352574235273,0.5468721170669484,-1.7393483837445023,-0.14831837753607335,-0.3751882566065713,-0.9356533919095386,2.659945347654738,6.01029080042039,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.5378465040894757),
(0.7009999491269124,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1.3219174136349219),
(2.0913673622327664,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,2.8191190778976205,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.3264671481197117),
(0.8695293325336826,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.2640844683810594,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.37329777355624366),
(0.1532794530549093,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.3751882566065713,-0.9452933725765659,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7409638415255875),
(-0.2118675443264261,0.5468721170669484,-0.5664508274702313,-1.127264112936478,-0.597395833057595,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.044958601570578065),
(-0.9281174238051993,0.5468721170669484,-1.7393483837445023,-0.6377912452362757,-0.48629204483208316,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-1.7665181835484902),
(0.9537940242370677,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.041876891930035715,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.795664791560899),
(0.20945591419049936,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.18033068452098802,-1.0341189087227467,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.6559437537265749),
(-0.3663528124492988,0.5468721170669484,0.6064467288040396,-1.0048958960114276,-0.708499621283107,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-1.7480917588850915),
(1.318941021618403,1.9759849719804965,0.6064467288040396,-1.0048958960114276,-0.708499621283107,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.41045393851536055),
(-0.9281174238051993,-0.8822407378465996,-0.5664508274702313,-0.39305481138617454,-0.2640844683810594,-0.7077367061391058,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,-1.7901009739613176),
(0.363941182313372,-0.16768431038982562,0.6064467288040396,-1.127264112936478,-0.8196034095086188,-0.9866075754352547,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.4085582158133648),
(0.34989706702947454,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.18033068452098802,-0.7635108799983356,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.5698779430559673),
(-1.0685585766441745,-0.8822407378465996,0.6064467288040396,1.4424684424895844,0.9580572020995711,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.3532031129150886),
(-0.2259116596103236,-0.8822407378465996,-1.7393483837445023,0.8306273578643314,0.5136420491975237,-1.003821826626375,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.21936509015418798),
(1.2487204451989156,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.691020898410733),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.2187862732390784,-0.041876891930035715,1.0618883163080606,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.985237061760475),
(-0.3663528124492988,0.5468721170669484,-1.7393483837445023,-1.127264112936478,-0.597395833057595,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-1.6778741900031686),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-1.127264112936478,-0.708499621283107,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.27813249391605654),
(1.262764560482813,0.5468721170669484,-1.7393483837445023,-0.270686594461124,-0.2640844683810594,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.8441952927319905),
(-0.5770145417077616,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.2640844683810594,-0.9315219716236697,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.2522907181023571),
(-0.3663528124492988,0.5468721170669484,-0.5664508274702313,-1.127264112936478,-0.708499621283107,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,-0.08774198756912513),
(-1.0685585766441745,-0.8822407378465996,0.6064467288040396,0.2187862732390784,0.18033068452098802,-0.9356533919095386,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7273904669792979),
(-1.3353967670382274,-0.8822407378465996,0.6064467288040396,2.788518828665141,3.7356519077373678,0.32236408513753273,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08552706739328733),
(1.2487204451989156,1.9759849719804965,-1.7393483837445023,-0.5154230283112251,-0.597395833057595,-0.9315219716236697,1.4161194154023549,6.01029080042039,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,-1.216303626521241),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.708499621283107,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.02865538633341453),
(-0.619146887559454,0.5468721170669484,-1.7393483837445023,-0.39305481138617454,-0.3751882566065713,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.32887791526298576),
(0.9678381395209652,1.9759849719804965,-0.5664508274702313,-1.3720005467865792,-1.0418109859596425,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0.8422995700299947),
(-0.08547050677134847,0.5468721170669484,-1.7393483837445023,-0.14831837753607335,-0.2640844683810594,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.36798974999065553),
(0.82739698668199,0.5468721170669484,0.6064467288040396,-1.127264112936478,-0.8196034095086188,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.9488391858821564),
(3.3553377377835427,1.9759849719804965,-1.7393483837445023,-0.270686594461124,-0.48629204483208316,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.8567070625651625),
(-0.5489263111399665,-0.8822407378465996,0.6064467288040396,0.4635227070891796,1.5135761432271304,2.8191190778976205,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.4828705457315986),
(-0.5770145417077616,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.5136420491975237,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.7877027562125168),
(0.335852951745577,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.5136420491975237,-0.47706574017809383,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.3530072659476524),
(-1.32135265175433,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.6247458374230355,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.6754918540958905),
(-0.5067939652882739,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.06922689629547615,-0.9693933242441344,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.16887891921454365),
(1.2487204451989156,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.7626792165461728),
(-1.026426230792482,-0.8822407378465996,-1.7393483837445023,-0.14831837753607335,0.06922689629547615,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-0.7239465263589021),
(0.9678381395209652,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.708499621283107,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.7588877711421812),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.2914344727464999,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.40281110064082043),
(0.7009999491269124,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.24590520798212862),
(1.6279115578641485,0.5468721170669484,-1.7393483837445023,-0.270686594461124,-0.2640844683810594,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1.229406145777529),
(-0.7876762709662243,0.5468721170669484,-1.7393483837445023,-0.8825276790863769,-0.597395833057595,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.2259116596103236,-0.8822407378465996,-1.7393483837445023,0.341154490164129,0.18033068452098802,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1.250259095499482),
(0.82739698668199,0.5468721170669484,-1.7393483837445023,-0.5154230283112251,-0.48629204483208316,-0.9452933725765659,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.5947181851493485),
(-1.1949556141992521,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,0.4025382609720118,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,-0.27693511322830194),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.06922689629547615,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.4085582158133648),
(0.8976175631014777,0.5468721170669484,0.6064467288040396,0.09641805631402782,-0.041876891930035715,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.7877027562125168),
(1.2487204451989156,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.2640844683810594,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.4498849707168724),
(0.12519122248711426,1.9759849719804965,-0.5664508274702313,-1.3720005467865792,-0.8196034095086188,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0.44078550174729275),
(0.335852951745577,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.18033068452098802,1.620318624948003,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1.2316810130199238),
(-0.08547050677134847,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.15298068015554758,-0.8172193437146309,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.8745268559639225),
(-1.4196614587416125,-0.8822407378465996,-1.7393483837445023,0.9529955747893819,0.5136420491975237,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.45061750415268387,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.18033068452098802,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.34973086498493916),
(1.0801910617921453,0.5468721170669484,0.6064467288040396,0.09641805631402782,-0.041876891930035715,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.6440069754012382),
(-1.0966468072119695,-0.8822407378465996,-0.5664508274702313,0.9529955747893819,0.6247458374230355,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.5920042262999973),
(-0.7595880403984292,-0.8822407378465996,0.6064467288040396,-0.6377912452362757,-0.3751882566065713,-0.47706574017809383,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-0.08547050677134847,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.2914344727464999,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.44647266985328),
(-0.4365733888687864,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.4025382609720118,-0.08526938306819591,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.06960299669652295),
(1.3891615980378906,1.9759849719804965,0.6064467288040396,-1.3720005467865792,-0.9307071977341307,-0.6512739622322312,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7376273695700748),
(-0.9281174238051993,0.5468721170669484,-1.7393483837445023,-0.8825276790863769,-0.48629204483208316,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-1.6980446795524033),
(1.0661469465082478,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.2640844683810594,-0.37860022336488575,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.9211616344330182),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,-0.025950160611022774,-0.041876891930035715,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.27585762667366165),
(0.9678381395209652,1.9759849719804965,-0.5664508274702313,-1.3720005467865792,-1.0418109859596425,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0.8422995700299947),
(0.9678381395209652,1.9759849719804965,-0.5664508274702313,-1.3720005467865792,-1.0418109859596425,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0.6982246446783169),
(-0.7174556945467366,0.5468721170669484,0.6064467288040396,-1.0048958960114276,-0.48629204483208316,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.2636650543143316),
(1.6279115578641485,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.041876891930035715,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.2616334317114568),
(1.0099704853726577,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.826179652365794),
(1.178499868779428,1.9759849719804965,0.6064467288040396,-1.3720005467865792,-0.9307071977341307,-1.0341189087227467,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.2608751426306584),
(-0.5067939652882739,-0.8822407378465996,0.6064467288040396,0.2187862732390784,0.18033068452098802,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.16743816996102687),
(-0.8298086168179168,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.18033068452098802,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,-0.2682147887991215),
(1.7402644801353286,1.9759849719804965,0.6064467288040396,-0.6377912452362757,-0.597395833057595,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.6273246156236755),
(1.0661469465082478,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.2914344727464999,1.0618883163080606,2.659945347654738,6.01029080042039,2.082700496237388,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.174809331960051),
(1.0099704853726577,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,2.8191190778976205,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.9931990971088571),
(0.8976175631014777,0.5468721170669484,0.6064467288040396,0.09641805631402782,0.7358496256485474,0.32236408513753273,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.8337625431737772),
(-0.08547050677134847,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.4025382609720118,-0.47500003003515945,1.4161194154023549,6.01029080042039,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.3619234373442691),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,-0.041876891930035715,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.062961692542301),
(0.4762941045845522,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.48629204483208316,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.6512107216688221),
(0.2656323753260894,0.5468721170669484,-0.5664508274702313,-1.2496323298615286,-0.8196034095086188,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,-1.7840346613149312),
(1.0380587159404528,0.5468721170669484,0.6064467288040396,0.09641805631402782,-0.041876891930035715,-0.9356533919095386,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.7617250804979383),
(-0.08547050677134847,0.5468721170669484,-1.7393483837445023,-0.8825276790863769,-0.708499621283107,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-0.3099206882430282),
(1.7402644801353286,1.9759849719804965,0.6064467288040396,-0.6377912452362757,-0.597395833057595,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.5495999848418494),
(1.318941021618403,1.9759849719804965,0.6064467288040396,-1.127264112936478,-0.708499621283107,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.49917376096876215),
(-0.015249930351860891,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.708499621283107,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,-0.0714387723319616),
(-0.49274985000437643,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.48629204483208316,-0.47706574017809383,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(1.4312939438895833,0.5468721170669484,-1.7393483837445023,-0.025950160611022774,-0.2640844683810594,0.042116075746094286,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.7094031339228553),
(0.7571764102625025,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.2640844683810594,0.042116075746094286,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1.2544296854438728),
(0.9678381395209652,0.5468721170669484,-1.7393483837445023,-0.39305481138617454,-0.2640844683810594,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0.26637901316368284),
(1.122323407643838,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.2640844683810594,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1.3901634309067692),
(0.4762941045845522,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.8616359415903514),
(1.0661469465082478,1.9759849719804965,0.6064467288040396,-1.0048958960114276,-0.8196034095086188,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.2750993375928633),
(0.9397499089531701,0.5468721170669484,0.6064467288040396,0.2187862732390784,-0.15298068015554758,0.19842147656146658,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.014247893798246754),
(-0.9281174238051993,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.18033068452098802,-0.7449194887119257,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.6527431816719415),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-0.9452933725765659,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7839588324068512),
(-0.7876762709662243,0.5468721170669484,-1.7393483837445023,-0.8825276790863769,-0.597395833057595,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-1.6975138771958447),
(-2.1078231076525906,-0.8822407378465996,-1.7393483837445023,-0.14831837753607335,0.4025382609720118,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,-1.7901009739613176),
(0.7852646408302975,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.06922689629547615,0.042116075746094286,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.9393605723721776),
(0.5465146810040398,1.9759849719804965,-0.5664508274702313,-1.4943687637116299,-1.0418109859596425,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0.7774658536217397),
(-0.18377931375863107,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.3751882566065713,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.20836989848261256),
(0.4762941045845522,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.6247458374230355,0.30721554408934687,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.222581544050344),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.4025382609720118,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.05778956887759212),
(2.3160732067751266,1.9759849719804965,0.6064467288040396,-1.2496323298615286,-0.8196034095086188,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.7994562369648905),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,-0.041876891930035715,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.7550963257381897),
(0.5043823351523472,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.4025382609720118,1.0618883163080606,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.561536763167186),
(2.3160732067751266,1.9759849719804965,0.6064467288040396,-1.127264112936478,-0.8196034095086188,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.42182827472733514),
(0.6167352574235273,-0.8822407378465996,-1.7393483837445023,0.341154490164129,0.18033068452098802,-0.12245216564101576,1.4161194154023549,6.01029080042039,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.16546661835095128),
(-0.562970426423864,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.4025382609720118,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.4476101034744775),
(-0.029294045635758405,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.48629204483208316,-0.37860022336488575,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-1.7426761102712554,-0.8822407378465996,-1.7393483837445023,0.9529955747893819,0.8469534138740592,-0.7077367061391058,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7901009739613176),
(1.2065880993472229,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.15298068015554758,-0.6512739622322312,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.900308684711065),
(0.6167352574235273,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.041876891930035715,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.571211223644601),
(0.05497064606762669,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.4025382609720118,1.0618883163080606,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.3226757027157203),
(0.4762941045845522,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.48629204483208316,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.6587936124768051),
(1.122323407643838,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.15298068015554758,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.15453137374593298),
(1.529602750876866,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.2640844683810594,-0.47706574017809383,1.4161194154023549,-0.16638130054040892,2.082700496237388,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1.5312051999352538),
(0.6167352574235273,-0.8822407378465996,-1.7393483837445023,0.341154490164129,0.18033068452098802,-0.12245216564101576,1.4161194154023549,6.01029080042039,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.08129653038233954),
(0.9678381395209652,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.708499621283107,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.3240089833043539),
(0.29372060589388443,-0.8822407378465996,-1.7393483837445023,-0.270686594461124,-0.2640844683810594,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.6591727570172042),
(-0.5067939652882739,0.5468721170669484,-1.7393483837445023,-1.2496323298615286,-0.708499621283107,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.7901009739613176),
(0.5043823351523472,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-0.7449194887119257,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.19776973319295904),
(0.5043823351523472,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-0.7449194887119257,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.17758336180220144),
(-0.6472351181272491,-0.8822407378465996,-1.7393483837445023,0.7082591409392808,0.5136420491975237,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.06840561600876838),
(-0.8578968473857118,-0.8822407378465996,-1.7393483837445023,1.1977320086394831,0.5136420491975237,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.6928566740461717),
(0.6167352574235273,1.9759849719804965,0.6064467288040396,-0.39305481138617454,-0.597395833057595,-0.9693933242441344,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-1.6864996491356652,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.06922689629547615,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(1.4593821744573783,0.5468721170669484,-1.7393483837445023,-0.6377912452362757,-0.48629204483208316,0.19842147656146658,1.4161194154023549,6.01029080042039,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7276937826116172),
(-0.6472351181272491,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.5136420491975237,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.24887841723876472),
(0.8695293325336826,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.15298068015554758,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.46505075233283844),
(0.6307793727074248,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,-0.12944788701303184),
(-1.2792203059026372,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.15298068015554758,0.10821880031999623,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.9241348436896544),
(-0.2259116596103236,0.5468721170669484,-1.7393483837445023,-1.0048958960114276,-0.708499621283107,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.7091915290401385),
(-1.32135265175433,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.2914344727464999,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.7437378713677378),
(0.12519122248711426,0.5468721170669484,-1.7393483837445023,-0.14831837753607335,-0.15298068015554758,1.620318624948003,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.9321568261045937),
(0.335852951745577,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.15377308466513467),
(-0.5770145417077616,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.5136420491975237,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.004330188681311692),
(0.05497064606762669,1.9759849719804965,-1.7393483837445023,-1.2496323298615286,-0.9307071977341307,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.6980446795524033),
(-0.4365733888687864,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.4942448819435732),
(1.178499868779428,0.5468721170669484,0.6064467288040396,0.341154490164129,-0.2640844683810594,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.016901905581040818),
(-0.619146887559454,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.3751882566065713,1.0618883163080606,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(1.6279115578641485,0.5468721170669484,-1.7393483837445023,-0.14831837753607335,-0.15298068015554758,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.0360424301739612),
(-0.9281174238051993,-0.16768431038982562,-1.7393483837445023,0.2187862732390784,-0.041876891930035715,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.4714362624530669),
(-0.2259116596103236,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.597395833057595,0.042116075746094286,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(0.6588676032752199,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.597395833057595,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.5742443799677942),
(-0.6472351181272491,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.5136420491975237,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.23598750286519354),
(-0.45061750415268387,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.6247458374230355,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.029732872888054877),
(0.6307793727074248,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.03087030650925233),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,1.4424684424895844,2.513510237256737,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.089697657337678),
(-0.7876762709662243,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(0.6307793727074248,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,-0.007363345004504908),
(0.7852646408302975,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.18033068452098802,0.042116075746094286,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.6381239603278146),
(-0.8578968473857118,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,0.06922689629547615,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.6868661903078651),
(-0.6612792334111466,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.041876891930035715,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.09235166912047206),
(-0.6331910028433516,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.041876891930035715,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.289446883061474),
(1.2487204451989156,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.8601193634287548),
(-1.7145878797034604,-0.8822407378465996,-1.7393483837445023,1.1977320086394831,1.7357837196781543,-1.003821826626375,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.5882127808960057),
(-0.3663528124492988,-0.16768431038982562,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.47706574017809383,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7574945434869904),
(0.82739698668199,0.5468721170669484,-0.5664508274702313,-1.0048958960114276,-0.708499621283107,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1.050449922709129),
(-1.0685585766441745,-0.8822407378465996,0.6064467288040396,1.809573093264736,1.069160990325083,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.2114030548058058),
(-1.1949556141992521,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,0.4025382609720118,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,-0.2955131957078604),
(-0.2259116596103236,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,0.042116075746094286,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7718262071140785),
(-1.026426230792482,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.48629204483208316,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-1.7061583727169454),
(-0.591058656991659,-0.8822407378465996,0.6064467288040396,1.809573093264736,1.1802647785505949,0.44010956328479556,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.18252812266891313),
(0.4762941045845522,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.48629204483208316,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.3858095433894157),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.041876891930035715,1.0618883163080606,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.7729161191369499),
(-0.12760285262304102,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.06922689629547615,-0.8172193437146309,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.24969665338612013),
(-0.2118675443264261,-0.8822407378465996,-0.5664508274702313,0.7082591409392808,0.7358496256485474,-0.08526938306819591,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.1370307778210149),
(0.335852951745577,-0.8822407378465996,0.6064467288040396,0.2187862732390784,0.5136420491975237,-0.47706574017809383,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.9473226077205598),
(-0.2259116596103236,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.06922689629547615,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.12224414074544795),
(-1.4056173434577148,-0.8822407378465996,-1.7393483837445023,-0.270686594461124,-0.15298068015554758,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.7901009739613176),
(-0.4365733888687864,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-0.9315219716236697,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.374056062637042),
(-0.2680440054620162,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.6247458374230355,2.8191190778976205,2.659945347654738,6.01029080042039,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.30309608651584347),
(-1.32135265175433,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.4025382609720118,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1.7901009739613176),
(1.6279115578641485,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.041876891930035715,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.3067516320189558),
(0.8976175631014777,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-1.0341189087227467,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.0371798637951588),
(0.8695293325336826,0.5468721170669484,0.6064467288040396,0.09641805631402782,-0.15298068015554758,0.44010956328479556,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.7342433760162363),
(0.7290881796947074,0.5468721170669484,0.6064467288040396,0.4635227070891796,0.06922689629547615,-0.7635108799983356,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.9473226077205598),
(-0.7876762709662243,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.5136420491975237,-0.5121828126079793,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.19049015801729532),
(1.4734262897412758,0.5468721170669484,0.6064467288040396,0.09641805631402782,-0.2640844683810594,0.042116075746094286,2.659945347654738,-0.16638130054040892,2.082700496237388,5.273893579545581,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.4447602447242471),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.18033068452098802,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.14120136776540557),
(0.5043823351523472,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.7449194887119257,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.2632700279324098),
(1.4593821744573783,1.9759849719804965,0.6064467288040396,-0.7601594621613263,-0.597395833057595,-0.12245216564101576,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.6221998896310503),
(0.4762941045845522,-0.16768431038982562,0.6064467288040396,0.09641805631402782,-0.041876891930035715,-0.47706574017809383,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1.459167737259415),
(-1.6584114185678702,-0.8822407378465996,0.6064467288040396,1.3201002255645338,0.9580572020995711,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.8175952278374927),
(0.8976175631014777,0.5468721170669484,0.6064467288040396,0.2187862732390784,-0.041876891930035715,-0.9356533919095386,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.0731985951330782),
(-0.9281174238051993,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.37860022336488575,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-0.6753233486950441,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.3751882566065713,-0.37860022336488575,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7819872807967756),
(1.1082792923599403,1.9759849719804965,0.6064467288040396,-1.2496323298615286,-0.8196034095086188,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.11017146251923221),
(-0.3944410430170938,-0.8822407378465996,0.6064467288040396,1.1977320086394831,2.4024064490312256,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.10897408183147764),
(-0.08547050677134847,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.4025382609720118,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.1757634680082855),
(-1.6162790727161778,-0.8822407378465996,-1.7393483837445023,1.564836659414635,1.1802647785505949,-0.5121828126079793,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.5844213354920142),
(-0.619146887559454,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,1.0618883163080606,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(0.05497064606762669,1.9759849719804965,0.6064467288040396,-1.4943687637116299,-0.9307071977341307,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-1.63252850297143),
(-1.054514461360277,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.5136420491975237,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.3178827235914104),
(0.4060735281650646,-0.8822407378465996,0.6064467288040396,-0.025950160611022774,-0.041876891930035715,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.6201208693560917),
(-0.45061750415268387,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.5136420491975237,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.18669871261330379),
(-0.3944410430170938,1.9759849719804965,0.6064467288040396,-1.3720005467865792,-0.9307071977341307,-0.8984706093367187,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.5871352943413654),
(-0.4365733888687864,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.7358496256485474,0.44010956328479556,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.058607805024947536),
(-0.9702497696568919,0.5468721170669484,-1.7393483837445023,-0.7601594621613263,-0.3751882566065713,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.5097298610333812),
(-0.7736321556823267,-0.8822407378465996,-0.5664508274702313,-0.8825276790863769,-0.597395833057595,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,-1.7753901657938305),
(1.4312939438895833,0.5468721170669484,-1.7393483837445023,-0.025950160611022774,-0.2640844683810594,0.042116075746094286,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.152439804076501),
(1.8807056329743037,0.5468721170669484,-1.7393483837445023,-0.14831837753607335,-0.15298068015554758,0.30721554408934687,1.4161194154023549,6.01029080042039,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.3408746406548795),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,1.4424684424895844,2.1801988725802017,-0.7635108799983356,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.1687430193136645),
(0.8976175631014777,1.9759849719804965,-0.5664508274702313,-1.2496323298615286,-1.0418109859596425,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0.47452936584281724),
(0.7571764102625025,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.3751882566065713,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.9264696579986064),
(0.9257057936692726,1.9759849719804965,-1.7393483837445023,-1.0048958960114276,-0.708499621283107,1.620318624948003,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.4342359083426734),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.18033068452098802,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.19661641773023886),
(-1.1247350377797647,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,-0.15298068015554758,-0.7759051408559422,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.4365733888687864,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.9315219716236697,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.035040896453643),
(0.19541179890660185,0.5468721170669484,-1.7393483837445023,-0.6377912452362757,-0.597395833057595,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7686413929747256),
(1.178499868779428,1.9759849719804965,0.6064467288040396,-1.0048958960114276,-0.8196034095086188,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.9518723422053496),
(-0.4365733888687864,-0.8822407378465996,-1.7393483837445023,0.9529955747893819,0.6247458374230355,0.44010956328479556,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.0525414923785611),
(-0.534882195856069,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.2914344727464999,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.013868749257847602),
(0.34989706702947454,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.06922689629547615,-0.6512739622322312,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.1634349957480765),
(-1.2089997294831498,-0.8822407378465996,0.6064467288040396,1.3201002255645338,1.2913685667761068,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.531341099836133),
(-0.15569108319083605,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.18033068452098802,0.44010956328479556,1.4161194154023549,6.01029080042039,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.07712594043794888),
(-1.1106909224958672,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.6247458374230355,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.6151320432643456),
(1.0661469465082478,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.2914344727464999,-0.47500003003515945,2.659945347654738,6.01029080042039,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1.015189480452008),
(4.352469922940267,1.9759849719804965,-1.7393483837445023,-0.7601594621613263,-0.708499621283107,2.8191190778976205,1.4161194154023549,6.01029080042039,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.6824838715545154),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.6247458374230355,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.6712454352434201),
(1.318941021618403,1.9759849719804965,0.6064467288040396,-1.127264112936478,-0.8196034095086188,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.5928224624473527),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.7358496256485474,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.42935121846876106),
(0.9397499089531701,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.3751882566065713,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.48552455751439266),
(-0.3663528124492988,0.5468721170669484,0.6064467288040396,-1.127264112936478,-0.708499621283107,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,-0.09380830021551156),
(1.2065880993472229,1.9759849719804965,0.6064467288040396,-0.8825276790863769,-0.708499621283107,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.7114947035922873),
(-1.5039261504449974,-0.8822407378465996,0.6064467288040396,1.0753637917144325,0.7358496256485474,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.8627134281449917),
(1.178499868779428,1.9759849719804965,0.6064467288040396,-0.8825276790863769,-0.708499621283107,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.10638001711524069),
(-0.5770145417077616,-0.8822407378465996,0.6064467288040396,1.0753637917144325,0.6247458374230355,-0.6354368511364006,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.27390195690510877),
(2.3160732067751266,1.9759849719804965,-1.7393483837445023,-1.127264112936478,-0.8196034095086188,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0.26637901316368284),
(0.39202941288116705,-0.8822407378465996,0.6064467288040396,-0.270686594461124,-0.2640844683810594,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.026001374550620467),
(0.05497064606762669,-0.8822407378465996,-1.7393483837445023,0.341154490164129,0.2914344727464999,1.0618883163080606,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.3113013665037456),
(-1.4056173434577148,-0.8822407378465996,-1.7393483837445023,-0.6377912452362757,-0.3751882566065713,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.7901009739613176),
(-0.9281174238051993,0.5468721170669484,-1.7393483837445023,-0.6377912452362757,-0.597395833057595,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.4025382609720118,0.10821880031999623,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.6867903613997852),
(-0.42252927358488884,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.6247458374230355,1.0618883163080606,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.42410314196973004),
(-2.1078231076525906,-0.8822407378465996,-1.7393483837445023,-0.14831837753607335,0.4025382609720118,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,-1.7901009739613176),
(0.8695293325336826,0.5468721170669484,-1.7393483837445023,0.5858909240142302,0.06922689629547615,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.5738652354273951),
(-1.3634849976060224,-0.8822407378465996,-1.7393483837445023,-0.39305481138617454,-0.15298068015554758,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.7765275994150278),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.7358496256485474,0.10821880031999623,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.7823347855803715),
(-0.5067939652882739,0.5468721170669484,-0.5664508274702313,-0.39305481138617454,-0.3751882566065713,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.5136420491975237,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.7667898594240063),
(0.19541179890660185,1.9759849719804965,-1.7393483837445023,-1.4943687637116299,-0.9307071977341307,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-1.789494342696679),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,1.4424684424895844,2.1801988725802017,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.9245739352966107),
(0.1532794530549093,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.3751882566065713,-0.9693933242441344,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.5696946454830044),
(-1.2792203059026372,0.5468721170669484,-1.7393483837445023,-1.2496323298615286,-0.9307071977341307,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.7901009739613176),
(-1.4056173434577148,-0.8822407378465996,-1.7393483837445023,-0.8825276790863769,-0.3751882566065713,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-1.7793332690139816),
(0.4762941045845522,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.6247458374230355,0.30721554408934687,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.3780308056139965),
(-1.349440882322125,-0.8822407378465996,-1.7393483837445023,-0.5154230283112251,-0.3751882566065713,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-0.4680997904975544),
(-0.8578968473857118,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.5136420491975237,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.753519800510036),
(1.9509262093937914,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.6221998896310503),
(-1.0685585766441745,-0.8822407378465996,-1.7393483837445023,0.7082591409392808,0.2914344727464999,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.8490642246906223),
(1.6279115578641485,0.5468721170669484,-1.7393483837445023,-0.14831837753607335,-0.15298068015554758,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.7023952346227076),
(0.12519122248711426,0.5468721170669484,-1.7393483837445023,-0.14831837753607335,-0.15298068015554758,1.620318624948003,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.9169910444886277),
(0.9678381395209652,0.5468721170669484,-1.7393483837445023,-0.39305481138617454,-0.2640844683810594,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0.5768983917505883),
(-0.7174556945467366,0.5468721170669484,-1.7393483837445023,-0.8825276790863769,-0.597395833057595,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(0.4060735281650646,-0.8822407378465996,0.6064467288040396,0.341154490164129,-0.041876891930035715,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.44685181439367916),
(0.7852646408302975,-0.8822407378465996,-1.7393483837445023,0.341154490164129,0.18033068452098802,0.042116075746094286,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.0910183885318383),
(1.2487204451989156,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.2640844683810594,-1.0341189087227467,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.007985734184424),
(-0.2259116596103236,0.5468721170669484,-0.5664508274702313,-1.2496323298615286,-0.9307071977341307,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(0.4482058740167571,-0.8822407378465996,-1.7393483837445023,0.8306273578643314,0.2914344727464999,1.620318624948003,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1.0117771795884156),
(0.4482058740167571,0.5468721170669484,0.6064467288040396,0.09641805631402782,-0.15298068015554758,0.44010956328479556,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.28761110742603535),
(0.9257057936692726,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.6519690107496204),
(-0.08547050677134847,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.2914344727464999,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.029413675414212834),
(1.318941021618403,1.9759849719804965,0.6064467288040396,-1.127264112936478,-0.8196034095086188,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.6546230225324144),
(0.05497064606762669,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.5136420491975237,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.17993405795267617),
(3.776661196300468,1.9759849719804965,0.6064467288040396,-0.270686594461124,-0.597395833057595,0.19842147656146658,1.4161194154023549,6.01029080042039,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.6976496531704814),
(-0.1135587373391435,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.4025382609720118,-0.6512739622322312,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.5833438489373739),
(0.335852951745577,-0.8822407378465996,-1.7393483837445023,0.8306273578643314,0.18033068452098802,1.620318624948003,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.2316810130199238),
(1.318941021618403,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.15298068015554758,0.042116075746094286,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.015189480452008),
(0.12519122248711426,0.5468721170669484,-1.7393483837445023,-0.025950160611022774,-0.3751882566065713,-0.9356533919095386,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.18372550335666768),
(1.318941021618403,1.9759849719804965,-0.5664508274702313,-1.2496323298615286,-0.8196034095086188,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0.6762342613351661),
(1.1082792923599403,1.9759849719804965,0.6064467288040396,-1.0048958960114276,-0.708499621283107,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.16097683093271858),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.7358496256485474,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.40660254604481194),
(-0.15569108319083605,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.2640844683810594,-0.9693933242441344,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.7543380366573914),
(-0.2961322360298112,-0.8822407378465996,-1.7393483837445023,-0.5154230283112251,-0.2640844683810594,-0.7077367061391058,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(0.307764721177782,1.9759849719804965,-1.7393483837445023,-1.3720005467865792,-0.9307071977341307,-0.6512739622322312,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7656082366515322),
(-0.5067939652882739,-0.8822407378465996,0.6064467288040396,0.2187862732390784,0.18033068452098802,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.12071168074232863),
(-1.0966468072119695,-0.8822407378465996,-0.5664508274702313,-0.8825276790863769,-0.597395833057595,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,-1.7901009739613176),
(-1.0685585766441745,-0.8822407378465996,0.6064467288040396,1.809573093264736,1.069160990325083,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.005088477762109997),
(0.4060735281650646,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.041876891930035715,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.3858095433894157),
(1.234676329915018,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.3751882566065713,-0.9693933242441344,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.9950948198108529),
(-1.5179702657288952,-0.8822407378465996,-1.7393483837445023,1.3201002255645338,1.069160990325083,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.1489675561463515),
(1.0099704853726577,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.597395833057595,-0.9693933242441344,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.020497504017596),
(0.9678381395209652,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.3751882566065713,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.357177855892043),
(-0.8017203862501218,-0.8822407378465996,0.6064467288040396,-0.5154230283112251,-0.15298068015554758,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.11282547430202627),
(-0.5067939652882739,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.06922689629547615,-0.9693933242441344,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.07187786393891786),
(-0.9702497696568919,0.5468721170669484,-1.7393483837445023,-0.7601594621613263,-0.3751882566065713,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.5700138429568464),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.7635108799983356,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.4472309589340783),
(-1.4196614587416125,-0.8822407378465996,-1.7393483837445023,0.09641805631402782,0.06922689629547615,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,-0.37968328367647214),
(-0.2259116596103236,0.5468721170669484,-1.7393483837445023,0.09641805631402782,-0.3751882566065713,-0.9315219716236697,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.10296771625164831),
(0.8976175631014777,1.9759849719804965,-1.7393483837445023,-0.6377912452362757,-0.48629204483208316,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1.0390755864971546),
(-1.5179702657288952,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.15298068015554758,1.0618883163080606,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-0.35230869716540125,-0.8822407378465996,0.6064467288040396,-0.270686594461124,-0.15298068015554758,0.10821880031999623,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.03737571076259503),
(-0.18377931375863107,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.22163995739658288),
(-0.6753233486950441,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.2914344727464999,-0.7759051408559422,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.15257570397738013),
(0.5465146810040398,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.9452933725765659,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.3786057971218318),
(-0.4787057347204789,-0.8822407378465996,0.6064467288040396,0.2187862732390784,-0.041876891930035715,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.2231565355581795),
(-0.2259116596103236,-0.8822407378465996,-1.7393483837445023,0.341154490164129,0.18033068452098802,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.006665002990263715),
(-0.7595880403984292,-0.8822407378465996,-1.7393483837445023,0.09641805631402782,-0.041876891930035715,-0.7759051408559422,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.4252564574324502),
(-0.7314998098306342,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.4025382609720118,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.14916340311378776),
(0.05497064606762669,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.5136420491975237,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11244632976162712),
(0.7571764102625025,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.3751882566065713,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.8574653516459607),
(-0.33826458188150377,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.18033068452098802,0.44010956328479556,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12306237689280337),
(0.82739698668199,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.708499621283107,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.5905475952049578),
(-0.9562056543729944,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.8469534138740592,-0.6354368511364006,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.3421479741769561),
(-0.08547050677134847,0.5468721170669484,-1.7393483837445023,-0.8825276790863769,-0.708499621283107,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-0.2871720158190791),
(0.05497064606762669,1.9759849719804965,-0.5664508274702313,-1.3720005467865792,-0.8196034095086188,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-1.6938740896080127),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,1.3201002255645338,0.7358496256485474,-0.08526938306819591,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.8312444312918622),
(1.529602750876866,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.15298068015554758,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1.0963264120974265),
(1.318941021618403,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.18033068452098802,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.2800282166180523),
(-1.5179702657288952,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.7358496256485474,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.0230915687338331),
(-0.4365733888687864,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.184483792437466),
(-0.8578968473857118,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.18033068452098802,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.7816523254076531),
(0.4762941045845522,1.9759849719804965,0.6064467288040396,-0.39305481138617454,-0.48629204483208316,-1.058218860390315,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.7186984498598712),
(-0.5770145417077616,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.5136420491975237,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.12799125591799235),
(0.9257057936692726,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.7164235826174762),
(-1.2089997294831498,-0.8822407378465996,0.6064467288040396,1.3201002255645338,0.9580572020995711,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.5351325452401244),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.48629204483208316,-0.7759051408559422,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.3880244635652535),
(-0.15569108319083605,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.7759051408559422,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.21534615802595697),
(1.2065880993472229,1.9759849719804965,0.6064467288040396,-1.2496323298615286,-0.9307071977341307,-1.0341189087227467,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.4800206869813683),
(-0.45061750415268387,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.5136420491975237,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.04869009990801247),
(-0.8578968473857118,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.7358496256485474,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.39143676442884584),
(0.4762941045845522,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.597395833057595,0.44010956328479556,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.9022044074130607),
(-0.12760285262304102,0.5468721170669484,0.6064467288040396,-1.0048958960114276,-0.597395833057595,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.0532398343928023),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,-0.15298068015554758,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.34973086498493916),
(2.3160732067751266,1.9759849719804965,0.6064467288040396,-1.2496323298615286,-0.8196034095086188,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.6531064443708179),
(0.8976175631014777,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.041876891930035715,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.180117355525639),
(1.0099704853726577,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-0.9693933242441344,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.504665082107313),
(0.7290881796947074,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.15298068015554758,0.32236408513753273,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.9071332864382496),
(0.335852951745577,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.06922689629547615,1.620318624948003,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.0117771795884156),
(-0.14164696790693854,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.4025382609720118,-0.9356533919095386,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.7842904553489244),
(-0.08547050677134847,-0.8822407378465996,-1.7393483837445023,0.2187862732390784,0.2914344727464999,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.5264721678775011),
(-1.5460584962966901,-0.8822407378465996,-1.7393483837445023,1.0753637917144325,1.069160990325083,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.7573112459140275),
(2.6109996277369745,4.834210681807592,0.6064467288040396,-1.6167369806366805,-1.1529147741851544,-0.6512739622322312,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7173052222046803),
(0.9678381395209652,0.5468721170669484,-1.7393483837445023,-0.39305481138617454,-0.2640844683810594,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0.6716845268503763),
(-0.562970426423864,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.4025382609720118,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.14613024679059453),
(-1.0685585766441745,0.5468721170669484,-0.5664508274702313,-0.7601594621613263,-0.597395833057595,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,-1.7901009739613176),
(-0.2259116596103236,-0.8822407378465996,-1.7393483837445023,0.341154490164129,0.18033068452098802,-1.003821826626375,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.29595228731481665),
(-0.591058656991659,-0.8822407378465996,-1.7393483837445023,1.6872048763396854,1.069160990325083,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.30385437559664175),
(-0.9562056543729944,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.6247458374230355,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.06158101428158364),
(0.19541179890660185,1.9759849719804965,-1.7393483837445023,-1.4943687637116299,-0.9307071977341307,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-1.7901009739613176),
(-1.2089997294831498,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.18033068452098802,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.7512449332676411),
(1.178499868779428,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.47706574017809383,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.625991335035042),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.06922689629547615,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.4521598379592673),
(1.290852791050608,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,0.042116075746094286,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.7617250804979383),
(-0.3944410430170938,-0.8822407378465996,0.6064467288040396,1.6872048763396854,2.624614025482249,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.005148424828667107),
(1.4593821744573783,0.5468721170669484,-1.7393483837445023,-0.6377912452362757,-0.597395833057595,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.02487982277094573),
(-1.4477496893094075,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.2914344727464999,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(2.442470244330204,1.9759849719804965,0.6064467288040396,-1.127264112936478,-0.8196034095086188,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.1930082698992102),
(-1.1528232683475597,-0.8822407378465996,0.6064467288040396,1.564836659414635,2.513510237256737,-0.7635108799983356,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.42789458737372155),
(-0.2259116596103236,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.06922689629547615,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.16969715536189905),
(-1.0685585766441745,-0.8822407378465996,-1.7393483837445023,1.6872048763396854,0.8469534138740592,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.5420170940338663),
(0.5605587962879373,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.48629204483208316,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.7801198654045337),
(-0.2680440054620162,0.5468721170669484,0.6064467288040396,-1.2496323298615286,-0.708499621283107,-0.7759051408559422,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.19654058882215902),
(-0.9281174238051993,-0.8822407378465996,0.6064467288040396,1.9319413101897867,1.1802647785505949,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.1639500401893547),
(-0.8578968473857118,-0.8822407378465996,0.6064467288040396,1.564836659414635,1.069160990325083,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.09949546832149885),
(1.0380587159404528,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,2.8191190778976205,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.4127288057577555),
(0.19541179890660185,0.5468721170669484,-1.7393483837445023,0.09641805631402782,-0.15298068015554758,1.620318624948003,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.44685181439367916),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,1.4424684424895844,2.1801988725802017,-0.7635108799983356,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.229406145777529),
(1.0380587159404528,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,2.8191190778976205,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.7710203964349541),
(-0.5770145417077616,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.5136420491975237,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.0028735575862721954),
(0.05497064606762669,1.9759849719804965,-1.7393483837445023,-1.2496323298615286,-0.8196034095086188,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.699182113173601),
(-1.054514461360277,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.2640844683810594,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(1.2487204451989156,-0.8822407378465996,0.6064467288040396,-0.5154230283112251,-0.3751882566065713,-0.6354368511364006,1.4161194154023549,6.01029080042039,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.0910183885318383),
(0.9678381395209652,1.9759849719804965,-1.7393483837445023,-1.0048958960114276,-0.597395833057595,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-0.13323933241702338),
(0.05497064606762669,1.9759849719804965,-1.7393483837445023,-1.3720005467865792,-0.8196034095086188,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.697362219379685),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.4025382609720118,0.10821880031999623,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.8881161123517349),
(-1.7426761102712554,-0.8822407378465996,-1.7393483837445023,0.9529955747893819,0.8469534138740592,-0.7077367061391058,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7901009739613176),
(3.776661196300468,1.9759849719804965,-1.7393483837445023,-0.5154230283112251,-0.708499621283107,0.19842147656146658,1.4161194154023549,6.01029080042039,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.3033393311553636),
(-0.8578968473857118,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.3751882566065713,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.784110490223011),
(1.178499868779428,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.597395833057595,-0.8172193437146309,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.698787086791679),
(-0.2118675443264261,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.9693933242441344,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.12457895505439998),
(-0.4365733888687864,-0.8822407378465996,0.6064467288040396,1.0753637917144325,0.5136420491975237,-0.08526938306819591,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.30385437559664175),
(1.5998233272963533,0.5468721170669484,-1.7393483837445023,-0.025950160611022774,-0.15298068015554758,-0.9452933725765659,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.8752851450447209),
(1.0099704853726577,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.597395833057595,-0.9693933242441344,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.6695929571809442),
(-0.6472351181272491,-0.8822407378465996,-1.7393483837445023,0.7082591409392808,0.4025382609720118,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.42555977306476955),
(0.8695293325336826,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.2640844683810594,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.5806898371545798),
(-0.7314998098306342,0.5468721170669484,-1.7393483837445023,-0.6377912452362757,-0.3751882566065713,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7725844961948767),
(0.335852951745577,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,-0.3084041100814316),
(-1.5039261504449974,-0.8822407378465996,0.6064467288040396,1.564836659414635,1.1802647785505949,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.8771209206801596),
(0.6588676032752199,1.9759849719804965,0.6064467288040396,-1.127264112936478,-0.708499621283107,-0.7635108799983356,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.5945223381819122),
(2.0913673622327664,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-1.0341189087227467,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1.4860869996277548),
(2.021146785813279,1.9759849719804965,0.6064467288040396,-0.6377912452362757,-0.708499621283107,0.19842147656146658,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.4398313656990582),
(-0.4365733888687864,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.5136420491975237,-0.08526938306819591,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.33797738423256546),
(-0.7595880403984292,-0.8822407378465996,0.6064467288040396,-0.8825276790863769,-0.3751882566065713,-0.47706574017809383,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1.7901009739613176),
(-0.3663528124492988,0.5468721170669484,-1.7393483837445023,-1.127264112936478,-0.597395833057595,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-1.7201867207117139),
(-0.8578968473857118,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.2640844683810594,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-0.6472351181272491,1.9759849719804965,-1.7393483837445023,-1.739105197561731,-1.1529147741851544,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.7901009739613176),
(-0.534882195856069,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.5136420491975237,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.13399762149782166),
(-0.23995577489422115,-0.8822407378465996,0.6064467288040396,1.564836659414635,1.7357837196781543,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.2951939982340184),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.2914344727464999,0.10821880031999623,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.9639450204315654),
(0.9678381395209652,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.3751882566065713,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.2912067058625907),
(-0.7595880403984292,0.5468721170669484,-1.7393483837445023,-0.5154230283112251,-0.3751882566065713,-0.9452933725765659,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.06922689629547615,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.24173461803773794),
(-0.7034115792628391,-0.8822407378465996,0.6064467288040396,-0.270686594461124,-0.041876891930035715,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.09646231199830563),
(-0.8578968473857118,-0.8822407378465996,-1.7393483837445023,1.0753637917144325,0.7358496256485474,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.2823030838604472),
(-1.2932644211865347,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.9580572020995711,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.5775967337648295),
(-1.0685585766441745,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.06922689629547615,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.4225266167415763),
(1.0380587159404528,0.5468721170669484,0.6064467288040396,0.8306273578643314,0.06922689629547615,-0.9356533919095386,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.7365182432586312),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.2914344727464999,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.5013886811445999),
(0.9678381395209652,0.5468721170669484,-1.7393483837445023,-0.6377912452362757,-0.3751882566065713,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0.49197001470117824),
(-0.8017203862501218,-0.8822407378465996,0.6064467288040396,-0.5154230283112251,-0.15298068015554758,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.04533774611097722),
(1.2487204451989156,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.513960398044329),
(0.9397499089531701,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.48629204483208316,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.2341517272297549),
(0.12519122248711426,-0.8822407378465996,0.6064467288040396,-0.270686594461124,-0.2640844683810594,-0.8172193437146309,3.903771279907121,6.01029080042039,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(1.178499868779428,1.9759849719804965,-1.7393483837445023,-0.270686594461124,-0.48629204483208316,0.042116075746094286,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.6722469689637385),
(0.34989706702947454,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.4025382609720118,-0.6512739622322312,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.1710178865560594),
(-0.998338000224687,-0.8822407378465996,0.6064467288040396,1.4424684424895844,0.6247458374230355,0.10821880031999623,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.5995871171079803),
(0.82739698668199,0.5468721170669484,-0.5664508274702313,-1.0048958960114276,-0.708499621283107,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0.7448594231474126),
(-0.9562056543729944,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.6247458374230355,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.16015859478536315),
(-0.8157645015340192,-0.8822407378465996,-1.7393483837445023,0.09641805631402782,0.06922689629547615,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.047233468812972974),
(0.8695293325336826,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.2640844683810594,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.7361390987182321),
(-0.6612792334111466,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.041876891930035715,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.08363134469129156),
(-0.3663528124492988,0.5468721170669484,-1.7393483837445023,-0.7601594621613263,-0.597395833057595,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.787219475454284),
(-0.6893674639789417,-0.8822407378465996,-1.7393483837445023,0.09641805631402782,0.06922689629547615,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.5003111945899595),
(-0.16973519847473356,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.041876891930035715,-0.7635108799983356,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.987891073543269),
(1.1082792923599403,1.9759849719804965,0.6064467288040396,-1.0048958960114276,-0.708499621283107,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.35699455831908017),
(-0.8157645015340192,-0.8822407378465996,0.6064467288040396,-0.025950160611022774,0.2914344727464999,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.5722887101992413),
(-0.6472351181272491,-0.8822407378465996,-1.7393483837445023,0.09641805631402782,0.18033068452098802,-0.9356533919095386,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.2507741399407605),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.041876891930035715,1.0618883163080606,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.8335792456008142),
(0.82739698668199,0.5468721170669484,-0.5664508274702313,-1.0048958960114276,-0.708499621283107,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0.7736744082177481),
(0.6167352574235273,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.48629204483208316,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.3156678034155726),
(-0.8578968473857118,0.5468721170669484,-0.5664508274702313,-1.2496323298615286,-0.708499621283107,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,-1.7901009739613176),
(-0.5770145417077616,0.5468721170669484,-0.5664508274702313,-1.3720005467865792,-0.8196034095086188,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,-1.7875227910866034),
(-0.08547050677134847,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.2914344727464999,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.3251464169255514),
(-0.9562056543729944,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.2914344727464999,-0.7449194887119257,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.576914273592111),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.2914344727464999,-0.9693933242441344,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.1552896628267313),
(-1.7707643408390503,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,0.06922689629547615,-0.6354368511364006,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1.7901009739613176),
(-1.2511320753348423,-0.8822407378465996,-1.7393483837445023,-0.39305481138617454,-0.041876891930035715,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,-0.7285720897517718),
(0.05497064606762669,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.06922689629547615,1.0618883163080606,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1.2733869124638304),
(-0.6472351181272491,-0.16768431038982562,0.6064467288040396,0.7082591409392808,0.2914344727464999,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.34973086498493916),
(-2.1499554535042833,-0.8822407378465996,-1.7393483837445023,1.3201002255645338,1.069160990325083,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.8578968473857118,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.18033068452098802,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.9219358053553394),
(0.19541179890660185,0.5468721170669484,-1.7393483837445023,-0.6377912452362757,-0.597395833057595,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7512765730244444),
(-0.9281174238051993,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.597395833057595,-0.37860022336488575,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(1.290852791050608,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,0.042116075746094286,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.7090239893824561),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.7358496256485474,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.3990196552368289),
(-0.3663528124492988,0.5468721170669484,0.6064467288040396,-1.127264112936478,-0.708499621283107,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.3501699565918954),
(0.6167352574235273,0.5468721170669484,0.6064467288040396,0.09641805631402782,0.06922689629547615,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.9814456163564834),
(-1.349440882322125,-0.8822407378465996,0.6064467288040396,-0.5154230283112251,-0.041876891930035715,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.08547050677134847,-0.8822407378465996,0.6064467288040396,-0.7601594621613263,-0.48629204483208316,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,-0.019875114837676924),
(-0.2259116596103236,-0.8822407378465996,-1.7393483837445023,-0.270686594461124,-0.2640844683810594,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7708404313090407),
(-0.7876762709662243,0.5468721170669484,-1.7393483837445023,-0.7601594621613263,-0.48629204483208316,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(1.0099704853726577,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.597395833057595,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.6896876178220994),
(-1.6584114185678702,-0.8822407378465996,0.6064467288040396,2.054309527114837,2.2913026608057137,0.44010956328479556,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.27617682414750366),
(-1.026426230792482,-0.8822407378465996,-1.7393483837445023,-0.14831837753607335,0.06922689629547615,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-0.6022411288907744),
(0.8695293325336826,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.3751882566065713,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.1490275032129087),
(-0.6472351181272491,-0.16768431038982562,0.6064467288040396,0.2187862732390784,-0.041876891930035715,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.4752277078570585),
(-0.998338000224687,-0.8822407378465996,0.6064467288040396,0.2187862732390784,0.06922689629547615,-0.9452933725765659,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.11466124993746492),
(-0.16973519847473356,0.5468721170669484,0.6064467288040396,0.341154490164129,0.06922689629547615,-0.7635108799983356,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.2005911607071933),
(1.178499868779428,1.9759849719804965,0.6064467288040396,-1.127264112936478,-0.8196034095086188,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.3137720807135768),
(-0.2961322360298112,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.3751882566065713,-0.9693933242441344,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.10063290194269629),
(-1.5179702657288952,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.7358496256485474,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.7766476174743843),
(-0.9281174238051993,-0.8822407378465996,-1.7393483837445023,1.564836659414635,1.069160990325083,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.43888977904529697),
(0.12519122248711426,1.9759849719804965,-0.5664508274702313,-1.2496323298615286,-0.8196034095086188,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0.15339394012473553),
(2.3160732067751266,1.9759849719804965,0.6064467288040396,-1.2496323298615286,-0.8196034095086188,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1.2680788888982424),
(-0.6051027722755565,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.06922689629547615,-0.37860022336488575,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.28793030489987737),
(0.22350002947439687,0.0,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.49538231556477064),
(-1.7005437644195627,-0.8822407378465996,-1.7393483837445023,-0.14831837753607335,0.18033068452098802,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(0.335852951745577,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.18033068452098802,1.620318624948003,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1.292344139483788),
(-1.2792203059026372,-0.8822407378465996,-1.7393483837445023,0.5858909240142302,0.5136420491975237,0.44010956328479556,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.7034115792628391,-0.8822407378465996,0.6064467288040396,0.2187862732390784,0.4025382609720118,-0.7759051408559422,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.04457945703017891),
(-0.2259116596103236,0.5468721170669484,-1.7393483837445023,-1.0048958960114276,-0.708499621283107,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.6877319480535464),
(0.4060735281650646,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.18033068452098802,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.07529016480251022),
(1.178499868779428,0.5468721170669484,0.6064467288040396,0.4635227070891796,-0.15298068015554758,-0.37860022336488575,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.7573711929805846),
(-0.08547050677134847,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.4025382609720118,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08249391107009411),
(-0.4787057347204789,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,-0.15298068015554758,0.10821880031999623,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.0904559464184763),
(0.7290881796947074,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,0.32236408513753273,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.7577503375209838),
(-1.2792203059026372,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.06922689629547615,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.784110490223011),
(-0.2259116596103236,0.5468721170669484,-0.5664508274702313,-0.6377912452362757,-0.48629204483208316,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,-0.3436645523385527),
(-0.08547050677134847,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.5136420491975237,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.06656984037332973),
(-0.4787057347204789,-0.8822407378465996,0.6064467288040396,0.2187862732390784,-0.041876891930035715,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.5128229644231316),
(-1.4758379198772025,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.18033068452098802,-0.9315219716236697,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(0.9397499089531701,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.3751882566065713,-0.37860022336488575,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.33272930773353443),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,-0.025950160611022774,-0.041876891930035715,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.01955591736383488),
(2.442470244330204,1.9759849719804965,0.6064467288040396,-0.8825276790863769,-0.708499621283107,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.0182226367752012),
(0.7290881796947074,0.5468721170669484,0.6064467288040396,-0.270686594461124,0.7358496256485474,-0.7635108799983356,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.2870361159182),
(1.0661469465082478,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.2914344727464999,-0.47500003003515945,2.659945347654738,6.01029080042039,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1.127416264410157),
(1.262764560482813,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.3751882566065713,-0.9452933725765659,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.6326326391892636),
(0.6167352574235273,0.5468721170669484,0.6064467288040396,0.09641805631402782,0.06922689629547615,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.31339293617317765),
(-0.3663528124492988,0.5468721170669484,-0.5664508274702313,-1.3720005467865792,-0.9307071977341307,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.006285858449864563),
(-0.562970426423864,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.18033068452098802,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.7994562369648905),
(1.262764560482813,0.5468721170669484,-1.7393483837445023,-0.5154230283112251,-0.3751882566065713,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1.2415387710703016),
(1.0661469465082478,1.9759849719804965,0.6064467288040396,-1.0048958960114276,-0.708499621283107,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.3194592488195641),
(0.6307793727074248,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.48629204483208316,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.3573737028594793),
(-0.7034115792628391,-0.8822407378465996,0.6064467288040396,-0.5154230283112251,-0.15298068015554758,-0.7449194887119257,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.12573227051712016),
(-0.08547050677134847,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.4025382609720118,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.3994587468437852),
(1.529602750876866,0.5468721170669484,0.6064467288040396,0.09641805631402782,-0.15298068015554758,-0.47706574017809383,1.4161194154023549,-0.16638130054040892,2.082700496237388,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1.4819164096833641),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.2914344727464999,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.6378807156882946),
(-0.6472351181272491,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.18334635881626854),
(-0.4365733888687864,-0.8822407378465996,0.6064467288040396,-0.270686594461124,-0.2640844683810594,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,-0.06992219417036498),
(-1.6864996491356652,-0.8822407378465996,-1.7393483837445023,0.341154490164129,0.06922689629547615,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7901009739613176),
(-1.5460584962966901,-0.8822407378465996,-0.5664508274702313,-0.8825276790863769,-0.48629204483208316,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,-1.7901009739613176),
(1.318941021618403,0.5468721170669484,-0.5664508274702313,-1.0048958960114276,-0.708499621283107,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1.3791682392351938),
(-0.6612792334111466,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.041876891930035715,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,-0.02328741570126929),
(-0.8157645015340192,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.18033068452098802,-1.003821826626375,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.5829047573304176),
(0.9678381395209652,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.708499621283107,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.059366094105745844),
(0.08305887663542172,0.5468721170669484,-1.7393483837445023,-0.5154230283112251,-0.3751882566065713,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7109355939259745),
(-0.9281174238051993,-0.16768431038982562,-1.7393483837445023,0.2187862732390784,-0.041876891930035715,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.3501100095253383),
(0.5465146810040398,1.9759849719804965,-0.5664508274702313,-1.4943687637116299,-1.0418109859596425,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0.7186984498598712),
(-0.1135587373391435,-0.8822407378465996,0.6064467288040396,1.3201002255645338,0.6247458374230355,-0.6512739622322312,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.4885577138375859),
(0.335852951745577,0.5468721170669484,-1.7393483837445023,-0.39305481138617454,-0.48629204483208316,-0.9693933242441344,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7901009739613176),
(1.9509262093937914,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.3689313366444167),
(1.0521028312243503,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.708499621283107,-0.9693933242441344,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.45064325979767067),
(-0.7876762709662243,-0.8822407378465996,0.6064467288040396,0.8306273578643314,1.069160990325083,-0.6354368511364006,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.27964907207765316),
(0.335852951745577,-0.8822407378465996,-1.7393483837445023,0.9529955747893819,0.2914344727464999,1.620318624948003,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.5492208403014502),
(-0.6612792334111466,-0.8822407378465996,0.6064467288040396,0.2187862732390784,0.06922689629547615,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,-0.1465093913309937),
(-1.4196614587416125,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.2914344727464999,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.5446111587501032),
(0.8976175631014777,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.15298068015554758,0.44010956328479556,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.4479892480148766),
(0.6307793727074248,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.597395833057595,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.4362357672625029),
(0.335852951745577,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.4025382609720118,-0.47706574017809383,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.387130274583576),
(0.05497064606762669,-0.8822407378465996,-1.7393483837445023,0.5858909240142302,0.18033068452098802,1.0618883163080606,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.3037184756957627),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.18033068452098802,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.014247893798246754),
(-1.2089997294831498,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.18033068452098802,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.9502958169771959),
(-1.3775291128899199,-0.8822407378465996,-1.7393483837445023,0.341154490164129,0.2914344727464999,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(0.12519122248711426,1.9759849719804965,-0.5664508274702313,-1.3720005467865792,-0.8196034095086188,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0.4771833776256113),
(1.2065880993472229,0.5468721170669484,-1.7393483837445023,-0.025950160611022774,-0.15298068015554758,-0.6512739622322312,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.5501624269552114),
(0.6167352574235273,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.597395833057595,-0.9693933242441344,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(0.6167352574235273,0.5468721170669484,0.6064467288040396,0.09641805631402782,0.06922689629547615,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.6531064443708179),
(-0.9281174238051993,-0.16768431038982562,-1.7393483837445023,0.09641805631402782,-0.15298068015554758,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.723567381818503),
(0.9116616783853752,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.7725369745965507),
(-0.2259116596103236,0.5468721170669484,-1.7393483837445023,0.09641805631402782,-0.3751882566065713,-0.9315219716236697,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.5871069870316115),
(0.9678381395209652,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.708499621283107,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.2690330249464769),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-0.9452933725765659,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7839588324068512),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.5136420491975237,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.20527679509286223),
(-0.3663528124492988,0.5468721170669484,-0.5664508274702313,-1.3720005467865792,-0.9307071977341307,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.04457945703017891),
(0.4762941045845522,-0.16768431038982562,0.6064467288040396,0.2187862732390784,-0.041876891930035715,-0.47706574017809383,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.7463760013090093),
(0.2656323753260894,-0.8822407378465996,0.6064467288040396,-0.025950160611022774,0.18033068452098802,-0.7635108799983356,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.9750001591696978),
(0.05497064606762669,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.6247458374230355,1.0618883163080606,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.6515898662092212),
(-0.8578968473857118,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.8469534138740592,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.41418543685279496),
(0.5465146810040398,1.9759849719804965,-0.5664508274702313,-1.4943687637116299,-1.0418109859596425,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0.888176059418292),
(3.991577638060311e-16,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.3751882566065713,-0.12245216564101576,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.9071332864382496),
(-0.45061750415268387,-0.8822407378465996,0.6064467288040396,1.0753637917144325,0.2914344727464999,-0.37860022336488575,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.08470883124593191),
(0.7009999491269124,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.08628535647408563),
(1.0380587159404528,0.5468721170669484,0.6064467288040396,0.8306273578643314,0.06922689629547615,-0.9356533919095386,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.7387931105010261),
(-0.2961322360298112,0.5468721170669484,-1.7393483837445023,-1.0048958960114276,-0.708499621283107,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-0.15409228213897672),
(-0.08547050677134847,0.5468721170669484,-1.7393483837445023,-0.14831837753607335,-0.2640844683810594,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.31111806893078275),
(-1.054514461360277,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.2640844683810594,-0.37860022336488575,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.597395833057595,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.1787366772649216),
(0.8133528713980925,-0.8822407378465996,0.6064467288040396,-0.5154230283112251,-0.3751882566065713,-0.6726196337092204,1.4161194154023549,6.01029080042039,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.3274212841679463),
(-0.2259116596103236,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.9315219716236697,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.17310945622549143),
(-0.6472351181272491,-0.16768431038982562,0.6064467288040396,0.4635227070891796,0.4025382609720118,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.10594092550828442),
(-1.0685585766441745,0.5468721170669484,-1.7393483837445023,-0.8825276790863769,-0.48629204483208316,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.6612792334111466,-0.8822407378465996,0.6064467288040396,0.2187862732390784,0.06922689629547615,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,-0.057031279796793816),
(-0.9000291932374044,-0.8822407378465996,0.6064467288040396,-0.5154230283112251,-0.15298068015554758,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.6132363205623498),
(0.7290881796947074,0.5468721170669484,0.6064467288040396,0.4635227070891796,0.06922689629547615,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.43699405634330124),
(2.442470244330204,1.9759849719804965,0.6064467288040396,-1.3720005467865792,-0.9307071977341307,-0.8172193437146309,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.7818197411390932),
(-1.0685585766441745,-0.8822407378465996,-1.7393483837445023,0.7082591409392808,0.5136420491975237,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.566222397552855),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,0.06922689629547615,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.04912919151496874),
(-0.08547050677134847,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.2914344727464999,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.43737320088370035),
(-0.08547050677134847,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.2914344727464999,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.011913079489294731),
(-0.4365733888687864,-0.8822407378465996,0.6064467288040396,-0.5154230283112251,-0.3751882566065713,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.07680674296410683),
(-1.5460584962966901,-0.8822407378465996,-1.7393483837445023,0.9529955747893819,1.069160990325083,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.6594919544910464),
(-0.6472351181272491,-0.8822407378465996,0.6064467288040396,1.0753637917144325,0.5136420491975237,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.14840511403298945),
(-1.2651761906187398,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.041876891930035715,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.8953956875273987),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,-0.025950160611022774,-0.041876891930035715,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.15339394012473553),
(-0.6753233486950441,-0.8822407378465996,0.6064467288040396,0.2187862732390784,0.18033068452098802,-0.7759051408559422,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.2776934023091003),
(0.8976175631014777,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.15298068015554758,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.5895934591567233),
(-1.2511320753348423,-0.8822407378465996,0.6064467288040396,-0.025950160611022774,-0.15298068015554758,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.7399464259637464),
(-0.2118675443264261,-0.8822407378465996,0.6064467288040396,0.2187862732390784,0.06922689629547615,0.10821880031999623,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.3501100095253383),
(0.9959263700887603,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.3027768890420014),
(1.9509262093937914,1.9759849719804965,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.6654223672365536),
(1.178499868779428,1.9759849719804965,0.6064467288040396,-1.0048958960114276,-0.8196034095086188,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.8718728441811285),
(1.810485056554816,1.9759849719804965,0.6064467288040396,-1.2496323298615286,-0.8196034095086188,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.5818272707757772),
(-0.562970426423864,-0.16768431038982562,0.6064467288040396,-0.39305481138617454,-0.2640844683810594,-0.9356533919095386,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-0.562970426423864,-0.8822407378465996,0.6064467288040396,0.2187862732390784,0.18033068452098802,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.07832332112570344),
(1.318941021618403,-0.8822407378465996,-1.7393483837445023,0.2187862732390784,-0.041876891930035715,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.723248184344661),
(-0.7876762709662243,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.06922689629547615,-0.7759051408559422,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.28118153208077246),
(0.7009999491269124,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1.2354724584239152),
(-0.4365733888687864,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.6247458374230355,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.2872319628856362),
(1.2065880993472229,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.2914344727464999,-0.47706574017809383,1.4161194154023549,-0.16638130054040892,2.082700496237388,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.341632929735678),
(0.8976175631014777,0.5468721170669484,0.6064467288040396,0.09641805631402782,-0.041876891930035715,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.8513990389995744),
(-0.7174556945467366,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.597395833057595,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.2680440054620162,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.597395833057595,-0.7759051408559422,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.43297512421507023),
(0.8133528713980925,-0.8822407378465996,0.6064467288040396,0.4635227070891796,-0.041876891930035715,0.10821880031999623,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.7501674467130007),
(0.7009999491269124,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.8942423720646785),
(-0.31017635131370874,-0.8822407378465996,0.6064467288040396,-0.270686594461124,0.06922689629547615,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.8692188323983344),
(-0.7876762709662243,-0.8822407378465996,0.6064467288040396,1.4424684424895844,0.7358496256485474,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.3421479741769561),
(0.6167352574235273,0.5468721170669484,0.6064467288040396,0.09641805631402782,0.06922689629547615,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.1505440813745051),
(1.529602750876866,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.15298068015554758,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.2407804819895034),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.4025382609720118,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.49197001470117824),
(0.9678381395209652,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.3751882566065713,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.1384114560817324),
(-0.18377931375863107,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.2560821635063486),
(2.0913673622327664,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.48629204483208316,2.8191190778976205,1.4161194154023549,6.01029080042039,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.2824863814334102),
(-0.6472351181272491,1.9759849719804965,-1.7393483837445023,-1.739105197561731,-1.0418109859596425,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-1.7901009739613176),
(0.4060735281650646,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.041876891930035715,-1.0341189087227467,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.816321894315416),
(-1.7426761102712554,-0.8822407378465996,-1.7393483837445023,1.0753637917144325,0.8469534138740592,-0.7077367061391058,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.7876762709662243,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.5136420491975237,-0.5121828126079793,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.1677414855933462),
(-0.5770145417077616,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.18033068452098802,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.11921098442225474),
(1.9509262093937914,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.2855195377566033),
(-0.7174556945467366,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.3751882566065713,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.43541753111514747),
(-0.4365733888687864,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.7358496256485474,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.3061891899055938),
(-0.3663528124492988,0.5468721170669484,0.6064467288040396,-1.0048958960114276,-0.708499621283107,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-1.7377031984781548),
(1.1363675229277355,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.9452933725765659,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.788081900752916),
(1.5717350967285584,0.5468721170669484,0.6064467288040396,0.2187862732390784,-0.041876891930035715,-0.9452933725765659,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.8752851450447209),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,1.0753637917144325,0.7358496256485474,0.10821880031999623,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.3565554667121239),
(0.9678381395209652,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.2640844683810594,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.0561370908151164),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.7358496256485474,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.6227149340723286),
(1.0521028312243503,0.5468721170669484,0.6064467288040396,-1.0048958960114276,-0.708499621283107,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.40211275862657925),
(0.335852951745577,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.15298068015554758,-0.6726196337092204,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.12950783407958896),
(-0.4365733888687864,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,-0.1700163528357411),
(-0.08547050677134847,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.2914344727464999,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.31718438157716916),
(-0.2118675443264261,0.5468721170669484,-0.5664508274702313,-1.127264112936478,-0.597395833057595,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.044958601570578065),
(-1.6584114185678702,-0.8822407378465996,0.6064467288040396,2.054309527114837,2.2913026608057137,0.44010956328479556,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.40432767880241705),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-1.127264112936478,-0.708499621283107,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.28419880656244295),
(-0.6472351181272491,-0.8822407378465996,-1.7393483837445023,1.0753637917144325,0.5136420491975237,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.3952282098328374),
(1.0661469465082478,1.9759849719804965,0.6064467288040396,-0.8825276790863769,-0.8196034095086188,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.08363134469129156),
(-0.5770145417077616,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.2640844683810594,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7825180831533345),
(0.7712205255464,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.3751882566065713,0.44010956328479556,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.8047642605304787),
(0.6869558338430148,0.5468721170669484,-1.7393483837445023,-0.39305481138617454,-0.48629204483208316,-0.7759051408559422,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.26402831701320806),
(1.4172498286056856,1.9759849719804965,0.6064467288040396,-1.2496323298615286,-0.9307071977341307,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.1194542290617748),
(-1.2511320753348423,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.15298068015554758,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.6686672523687058),
(-0.9281174238051993,0.5468721170669484,-1.7393483837445023,-0.7601594621613263,-0.597395833057595,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.6356058484458997),
(0.363941182313372,-0.16768431038982562,0.6064467288040396,-0.7601594621613263,-0.48629204483208316,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.3573737028594793),
(1.2206322146311204,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.3751882566065713,-1.0341189087227467,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.2089323405959747),
(-1.2792203059026372,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.18033068452098802,0.10821880031999623,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.998068029067489),
(-0.4365733888687864,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.0809773329084975),
(-0.6753233486950441,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.2914344727464999,-0.7759051408559422,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.029413675414212834),
(1.4593821744573783,0.5468721170669484,-1.7393483837445023,-0.6377912452362757,-0.48629204483208316,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.5575020731236744),
(0.05497064606762669,-0.8822407378465996,-1.7393483837445023,-0.7601594621613263,-0.597395833057595,1.0618883163080606,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1.743526142558779),
(1.178499868779428,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.15298068015554758,-0.9452933725765659,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.292344139483788),
(-0.2259116596103236,0.5468721170669484,-1.7393483837445023,-0.7601594621613263,-0.48629204483208316,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.7405846969851884),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.7358496256485474,0.10821880031999623,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.3565554667121239),
(-0.7034115792628391,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.5136420491975237,-0.7759051408559422,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.04641523266561756),
(-0.6753233486950441,-0.8822407378465996,0.6064467288040396,0.2187862732390784,0.18033068452098802,-0.7759051408559422,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.31181641094502394),
(1.178499868779428,0.5468721170669484,0.6064467288040396,0.341154490164129,0.06922689629547615,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.0944306893954308),
(-0.562970426423864,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.18033068452098802,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.4381314899644987),
(-0.6331910028433516,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,-0.041876891930035715,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.09532487837710817),
(-0.8578968473857118,-0.8822407378465996,0.6064467288040396,1.564836659414635,0.9580572020995711,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.3686880920048968),
(0.4060735281650646,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.041876891930035715,-1.0341189087227467,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.8563279180247633),
(0.9678381395209652,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.708499621283107,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.47604594400441386),
(0.05497064606762669,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.18033068452098802,1.0618883163080606,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.8184134639848482),
(0.27967649060998695,-0.16768431038982562,0.6064467288040396,-0.270686594461124,-0.2640844683810594,-0.47706574017809383,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7439969978487806),
(-0.6331910028433516,-0.8822407378465996,0.6064467288040396,-0.270686594461124,-0.15298068015554758,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.05822866048454838),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,1.4424684424895844,2.1801988725802017,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.8237214875504363),
(0.335852951745577,0.5468721170669484,-1.7393483837445023,-0.39305481138617454,-0.3751882566065713,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.2648624350020862),
(-0.3663528124492988,0.5468721170669484,0.6064467288040396,-1.2496323298615286,-0.8196034095086188,-0.9356533919095386,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-1.7599968974536249),
(-1.2511320753348423,-0.8822407378465996,-1.7393483837445023,-0.5154230283112251,-0.041876891930035715,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,-0.496459802119411),
(-1.0685585766441745,-0.8822407378465996,-1.7393483837445023,0.7082591409392808,0.2914344727464999,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.7357000071112758),
(-0.4365733888687864,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.6307369164872679),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.4025382609720118,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.4616384514692461),
(-0.2259116596103236,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.15298068015554758,-0.37860022336488575,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.16129602840656063),
(0.7009999491269124,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.6333909282700619),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-0.9452933725765659,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.787674448902763),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.4025382609720118,-0.6512739622322312,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.0459001882243393),
(-0.3242204665976062,0.5468721170669484,-1.7393483837445023,-0.39305481138617454,-0.3751882566065713,1.620318624948003,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.585590408870015),
(-0.08547050677134847,-0.8822407378465996,-1.7393483837445023,0.2187862732390784,0.2914344727464999,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.7194567389406694),
(-0.5067939652882739,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.06922689629547615,-0.5121828126079793,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.2750993375928633),
(0.20945591419049936,-0.8822407378465996,0.6064467288040396,0.2187862732390784,-0.041876891930035715,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.9867536399220715),
(-0.2118675443264261,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,-0.33797738423256546),
(0.7571764102625025,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.3751882566065713,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.910545587301842),
(-1.349440882322125,-0.8822407378465996,0.6064467288040396,-0.5154230283112251,-0.15298068015554758,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-1.7899493161451578),
(-0.9281174238051993,-0.8822407378465996,0.6064467288040396,1.3201002255645338,0.8469534138740592,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.27390195690510877),
(-0.8578968473857118,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.5136420491975237,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.69361496312697),
(0.82739698668199,0.5468721170669484,0.6064467288040396,-1.2496323298615286,-0.9307071977341307,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.523818156094707),
(0.5043823351523472,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-0.7449194887119257,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.3444069595778283),
(0.6588676032752199,-0.8822407378465996,0.6064467288040396,-0.270686594461124,-0.2640844683810594,-0.6726196337092204,2.659945347654738,6.01029080042039,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.14461366862899794),
(-1.5881908421483826,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.7358496256485474,-1.003821826626375,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.9726653448607459),
(0.19541179890660185,1.9759849719804965,-1.7393483837445023,-1.3720005467865792,-0.9307071977341307,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-1.7901009739613176),
(0.5605587962879373,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.48629204483208316,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.3782266525814327),
(-2.1078231076525906,-0.8822407378465996,-1.7393483837445023,-0.14831837753607335,0.4025382609720118,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.3663528124492988,-0.8822407378465996,0.6064467288040396,-0.025950160611022774,0.06922689629547615,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.019495970297277773),
(2.442470244330204,1.9759849719804965,0.6064467288040396,-0.8825276790863769,-0.708499621283107,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.9488391858821564),
(-1.1809114989153546,-0.8822407378465996,0.6064467288040396,1.3201002255645338,0.9580572020995711,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.5036635483869949),
(-1.5039261504449974,-0.8822407378465996,0.6064467288040396,1.564836659414635,1.1802647785505949,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.6610085326526429),
(-0.9281174238051993,-0.16768431038982562,-1.7393483837445023,0.09641805631402782,-0.041876891930035715,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.010077303853856082),
(1.178499868779428,0.5468721170669484,0.6064467288040396,0.341154490164129,-0.041876891930035715,1.620318624948003,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1.641157116651008),
(-0.5067939652882739,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.9315219716236697,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,-1.7822147675210152),
(2.161587938652254,1.9759849719804965,0.6064467288040396,-0.270686594461124,-0.48629204483208316,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.0830563531834563),
(0.05497064606762669,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.4025382609720118,1.0618883163080606,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.9094081536806445),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.5136420491975237,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.34935172044454),
(-0.4365733888687864,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.597395833057595,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.008197462993383043),
(0.335852951745577,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.5136420491975237,-0.47706574017809383,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.5833438489373739),
(-1.1528232683475597,-0.8822407378465996,0.6064467288040396,1.564836659414635,2.624614025482249,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.1860003705990626),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.4025382609720118,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.7137096237681251),
(-0.4365733888687864,-0.8822407378465996,0.6064467288040396,0.2187862732390784,-0.041876891930035715,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.0574862532452728),
(-0.5770145417077616,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.06922689629547615,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.15143827035618265),
(0.29372060589388443,-0.8822407378465996,-1.7393483837445023,-0.270686594461124,-0.2640844683810594,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.7118738481326864),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.2187862732390784,-0.041876891930035715,1.0618883163080606,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.5226807224735096),
(0.05497064606762669,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.18033068452098802,1.0618883163080606,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.4705420734713894),
(2.3722496679107166,1.9759849719804965,0.6064467288040396,-0.6377912452362757,-0.041876891930035715,-0.37860022336488575,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.4910158786529437),
(-0.591058656991659,0.5468721170669484,-1.7393483837445023,-1.0048958960114276,-0.48629204483208316,-0.8984706093367187,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09273081366087121),
(1.234676329915018,0.5468721170669484,0.6064467288040396,0.09641805631402782,-0.2640844683810594,-0.9693933242441344,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.9416354396145725),
(-0.998338000224687,-0.8822407378465996,0.6064467288040396,0.2187862732390784,0.06922689629547615,-0.9452933725765659,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7560537942334737),
(0.82739698668199,0.5468721170669484,-0.5664508274702313,-1.0048958960114276,-0.708499621283107,2.8191190778976205,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1.1543355267784967),
(1.4593821744573783,0.5468721170669484,-1.7393483837445023,0.5858909240142302,0.06922689629547615,1.620318624948003,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.735943251750796),
(0.19541179890660185,1.9759849719804965,-1.7393483837445023,-1.3720005467865792,-0.9307071977341307,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-1.7901009739613176),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.2553238744255503),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.06922689629547615,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.3782266525814327),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-1.0048958960114276,-0.8196034095086188,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.1757634680082855),
(-1.8550290325424355,-0.8822407378465996,0.6064467288040396,1.4424684424895844,1.069160990325083,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.6879277950209827),
(-1.0685585766441745,-0.8822407378465996,0.6064467288040396,1.564836659414635,1.069160990325083,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.2056559396332614),
(-0.9281174238051993,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.48629204483208316,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-1.698651310817042),
(1.0380587159404528,0.5468721170669484,0.6064467288040396,0.4635227070891796,0.06922689629547615,-0.9356533919095386,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.2127237859999662),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.5136420491975237,-0.9693933242441344,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.11693611717985983),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.4025382609720118,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.12603558614943947),
(-0.8578968473857118,-0.8822407378465996,0.6064467288040396,1.564836659414635,0.9580572020995711,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.41797688225678653),
(1.1363675229277355,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.9452933725765659,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.8942423720646785),
(-0.5489263111399665,-0.8822407378465996,0.6064467288040396,0.4635227070891796,1.5135761432271304,2.8191190778976205,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.5128229644231316),
(-0.6472351181272491,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.15298068015554758,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7840346613149312),
(-0.4787057347204789,-0.8822407378465996,0.6064467288040396,1.0753637917144325,0.5136420491975237,-0.9693933242441344,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.7672289510309626),
(-0.6612792334111466,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.041876891930035715,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,-0.05930614703918873),
(-0.2259116596103236,0.5468721170669484,-1.7393483837445023,-1.127264112936478,-0.708499621283107,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.7181393401935585),
(-0.9562056543729944,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.4025382609720118,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.8490642246906223),
(1.5998233272963533,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.9452933725765659,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.7890234874066773),
(2.3160732067751266,1.9759849719804965,0.6064467288040396,-1.2496323298615286,-0.8196034095086188,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.6531064443708179),
(1.262764560482813,0.5468721170669484,-1.7393483837445023,-0.270686594461124,-0.2640844683810594,0.30721554408934687,1.4161194154023549,6.01029080042039,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.9450477404781649),
(-0.8157645015340192,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.06922689629547615,-0.9315219716236697,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.3588303339545188),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.18033068452098802,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.04457945703017891),
(-1.0966468072119695,-0.8822407378465996,-0.5664508274702313,-0.8825276790863769,-0.48629204483208316,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,-1.7901009739613176),
(-0.7876762709662243,0.5468721170669484,-1.7393483837445023,-1.0048958960114276,-0.597395833057595,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.7901009739613176),
(-0.7595880403984292,-0.8822407378465996,0.6064467288040396,-0.8825276790863769,-0.3751882566065713,-0.47706574017809383,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-0.2680440054620162,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.5302636132814926),
(-0.2259116596103236,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.15298068015554758,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.14044307868460726),
(0.08305887663542172,-0.16768431038982562,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.47706574017809383,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(2.3160732067751266,1.9759849719804965,0.6064467288040396,-1.2496323298615286,-0.8196034095086188,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.6902626093299348),
(-1.1809114989153546,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.9580572020995711,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.20110620514847158),
(-0.5208380805721714,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.2914344727464999,-1.003821826626375,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.4850854659074364),
(-1.2651761906187398,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.041876891930035715,-0.7449194887119257,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.861272678891475),
(0.335852951745577,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,-0.1764618100225267),
(1.4312939438895833,0.5468721170669484,-1.7393483837445023,-0.025950160611022774,-0.2640844683810594,0.042116075746094286,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.6976496531704814),
(-0.7876762709662243,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.3751882566065713,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(0.05497064606762669,1.9759849719804965,-0.5664508274702313,-1.127264112936478,-0.8196034095086188,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-1.7038076765664705),
(-0.4365733888687864,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.597395833057595,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.3949248942005181),
(2.442470244330204,1.9759849719804965,0.6064467288040396,-0.8825276790863769,-0.597395833057595,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.472058651632986),
(-0.6472351181272491,-0.8822407378465996,-1.7393483837445023,0.8306273578643314,0.5136420491975237,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,-0.008879923166101516),
(-0.2259116596103236,0.5468721170669484,-0.5664508274702313,-1.2496323298615286,-0.708499621283107,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-1.2089997294831498,-0.16768431038982562,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,1.0618883163080606,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-1.32135265175433,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.7358496256485474,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.5844213354920142),
(1.529602750876866,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.9452933725765659,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.8070391277728736),
(-1.6303231880000753,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.06922689629547615,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.534882195856069,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.18033068452098802,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.4457143807724817),
(-0.2680440054620162,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.06922689629547615,-0.9693933242441344,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.9185076226502242),
(-0.45061750415268387,-0.8822407378465996,0.6064467288040396,1.0753637917144325,0.2914344727464999,-0.37860022336488575,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.2363666474055927),
(0.8976175631014777,1.9759849719804965,-1.7393483837445023,-0.6377912452362757,-0.48629204483208316,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.8498824608379777),
(1.318941021618403,0.5468721170669484,0.6064467288040396,0.4635227070891796,0.06922689629547615,-0.9693933242441344,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.172155320177257),
(-0.6472351181272491,-0.8822407378465996,0.6064467288040396,1.3201002255645338,0.5136420491975237,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.6568978897748093),
(-1.349440882322125,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.7358496256485474,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.7770267620147834),
(-0.4365733888687864,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.2914344727464999,0.44010956328479556,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.00931901477305778),
(0.335852951745577,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.48629204483208316,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7564329387738729),
(-0.7034115792628391,-0.8822407378465996,0.6064467288040396,-0.270686594461124,-0.15298068015554758,-0.7449194887119257,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.2470585234448488),
(1.2065880993472229,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.15298068015554758,-0.6512739622322312,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.0223932267195919),
(-0.6472351181272491,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.4025382609720118,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.12224414074544795),
(-0.2961322360298112,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.708499621283107,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.12641473068983863),
(1.5717350967285584,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.15298068015554758,-0.9452933725765659,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.7729161191369499),
(0.05497064606762669,-0.8822407378465996,0.6064467288040396,0.2187862732390784,-0.041876891930035715,1.0618883163080606,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.6146169988230672),
(0.040926530783729174,0.5468721170669484,0.6064467288040396,0.2187862732390784,-0.2640844683810594,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.4483084454887187),
(-0.7595880403984292,0.5468721170669484,-1.7393483837445023,-0.5154230283112251,-0.3751882566065713,-0.9452933725765659,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.2259116596103236,0.5468721170669484,0.6064467288040396,0.09641805631402782,-0.2640844683810594,-0.9315219716236697,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.2575987416679452),
(-0.8157645015340192,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.06922689629547615,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.4581662035390966),
(-0.45061750415268387,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.6247458374230355,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.027458005645659964),
(-0.4787057347204789,-0.8822407378465996,0.6064467288040396,1.4424684424895844,0.7358496256485474,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.011154790408496429),
(-1.0966468072119695,-0.8822407378465996,-0.5664508274702313,0.9529955747893819,0.6247458374230355,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.5920042262999973),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,1.4424684424895844,2.1801988725802017,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.9473226077205598),
(-0.8578968473857118,-0.8822407378465996,-1.7393483837445023,1.0753637917144325,0.7358496256485474,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.42941116553531816),
(1.1082792923599403,1.9759849719804965,0.6064467288040396,-1.0048958960114276,-0.708499621283107,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.25690039965370404),
(-0.7034115792628391,-0.8822407378465996,0.6064467288040396,-0.5154230283112251,-0.2640844683810594,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.21399711952204273),
(1.178499868779428,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.47706574017809383,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.292344139483788),
(-0.6472351181272491,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.2914344727464999,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.4085582158133648),
(-0.8157645015340192,-0.8822407378465996,-1.7393483837445023,0.09641805631402782,0.06922689629547615,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.2773742048352582),
(0.82739698668199,0.5468721170669484,-0.5664508274702313,-1.0048958960114276,-0.708499621283107,2.8191190778976205,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0.9602135220941309),
(0.05497064606762669,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.3751882566065713,-0.7635108799983356,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.6330117837296628),
(-0.591058656991659,-0.8822407378465996,-1.7393483837445023,1.6872048763396854,1.1802647785505949,0.44010956328479556,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.039271433464590784),
(-0.3663528124492988,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.597395833057595,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-1.7453619181942175),
(0.22350002947439687,0.0,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.47945824486800626),
(-1.2089997294831498,-0.8822407378465996,0.6064467288040396,1.4424684424895844,1.069160990325083,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.3705838147068925),
(1.5015145203090707,0.5468721170669484,-1.7393483837445023,0.09641805631402782,-0.3751882566065713,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.4244822865101292),
(0.9678381395209652,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.3751882566065713,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.9924408080280589),
(-0.3663528124492988,0.5468721170669484,-0.5664508274702313,-1.127264112936478,-0.708499621283107,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,-0.01342965765089134),
(1.4874704050251732,1.9759849719804965,0.6064467288040396,-1.4943687637116299,-1.0418109859596425,-0.6512739622322312,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.75772203021123),
(-0.619146887559454,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,1.0618883163080606,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-0.9000291932374044,-0.8822407378465996,0.6064467288040396,1.3201002255645338,0.8469534138740592,-0.6354368511364006,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.11466124993746492),
(1.9509262093937914,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.6980967254720785,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.738218118993191),
(-1.43370557402551,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,-0.15298068015554758,-0.47706574017809383,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1.7901009739613176),
(-1.349440882322125,-0.8822407378465996,-0.5664508274702313,-0.270686594461124,-0.15298068015554758,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.6852737832381887),
(-0.9281174238051993,-0.8822407378465996,-1.7393483837445023,1.564836659414635,1.069160990325083,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.3478950893495005),
(1.2065880993472229,1.9759849719804965,0.6064467288040396,-1.0048958960114276,-0.708499621283107,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.39073842241460466),
(1.0099704853726577,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.2640844683810594,2.8191190778976205,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.3160469479559717),
(-0.45061750415268387,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.7358496256485474,-0.6726196337092204,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.008500778625702364),
(-0.6612792334111466,-0.8822407378465996,0.6064467288040396,0.2187862732390784,0.06922689629547615,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,-0.03087030650925233),
(0.82739698668199,0.5468721170669484,0.6064467288040396,-1.0048958960114276,-0.708499621283107,-0.9693933242441344,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.7585086266017821),
(-0.9281174238051993,-0.8822407378465996,-1.7393483837445023,0.2187862732390784,-0.15298068015554758,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.3944410430170938,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.7358496256485474,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.2742811014455079),
(-1.9954701853814105,-0.8822407378465996,-1.7393483837445023,0.8306273578643314,0.4025382609720118,-0.9315219716236697,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.3663528124492988,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,-0.041876891930035715,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.11320461884242543),
(0.9959263700887603,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.3751882566065713,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.6402155299972466),
(-0.7174556945467366,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.597395833057595,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.4084851583009913,-0.8822407378465996,0.6064467288040396,0.8306273578643314,1.6246799314526423,-0.7635108799983356,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.6857128748451449),
(-0.5770145417077616,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.5136420491975237,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.023666560241668442),
(1.6279115578641485,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.041876891930035715,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.8489283247897432),
(-0.6753233486950441,-0.8822407378465996,0.6064467288040396,-0.025950160611022774,0.18033068452098802,-0.7759051408559422,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.22082172124922747),
(-0.6472351181272491,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.4025382609720118,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.038832341857634525),
(1.318941021618403,1.9759849719804965,-1.7393483837445023,-0.5154230283112251,-0.48629204483208316,-0.9315219716236697,1.4161194154023549,6.01029080042039,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.4252405755909275),
(-0.5067939652882739,-0.8822407378465996,0.6064467288040396,1.0753637917144325,1.069160990325083,0.44010956328479556,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.2659399215567266),
(0.12519122248711426,0.5468721170669484,-1.7393483837445023,-0.14831837753607335,-0.15298068015554758,1.620318624948003,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.9169910444886277),
(0.05497064606762669,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.041876891930035715,1.0618883163080606,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.2582211308478644),
(-1.32135265175433,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.2914344727464999,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.6830747449038735),
(0.2656323753260894,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.18033068452098802,-0.7635108799983356,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.815759452202054),
(-0.2961322360298112,-0.8822407378465996,-1.7393483837445023,-0.14831837753607335,-0.15298068015554758,-0.7077367061391058,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(1.5998233272963533,0.5468721170669484,-1.7393483837445023,-0.025950160611022774,-0.15298068015554758,-0.9452933725765659,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.0345258520123648),
(0.4482058740167571,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.2914344727464999,1.620318624948003,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1.3150928119077372),
(0.6167352574235273,0.5468721170669484,0.6064467288040396,0.09641805631402782,0.06922689629547615,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.9950948198108529),
(-0.6472351181272491,-0.8822407378465996,0.6064467288040396,-0.025950160611022774,0.18033068452098802,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.3114372664046248),
(-0.5067939652882739,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.06922689629547615,-0.9693933242441344,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.16129602840656063),
(-0.3944410430170938,-0.8822407378465996,0.6064467288040396,1.6872048763396854,2.513510237256737,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.40969564943456227),
(-0.5067939652882739,-0.8822407378465996,0.6064467288040396,-0.270686594461124,-0.041876891930035715,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.03087030650925233),
(0.9678381395209652,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.3751882566065713,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.9192659117310226),
(-0.08547050677134847,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.4025382609720118,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.025562282943664204),
(1.2487204451989156,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.2640844683810594,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.39263414511660044),
(0.1532794530549093,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.3751882566065713,-0.9693933242441344,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.2773742048352582),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.18033068452098802,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.9260905134582073),
(0.9678381395209652,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.3751882566065713,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.2665623107366457),
(-1.4196614587416125,-0.8822407378465996,-1.7393483837445023,0.09641805631402782,0.06922689629547615,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,-0.2507741399407605),
(-0.8578968473857118,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.8469534138740592,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.31181641094502394),
(-0.2118675443264261,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.5136420491975237,-0.9356533919095386,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.33235016319313526),
(-1.1247350377797647,-0.8822407378465996,0.6064467288040396,-0.6377912452362757,-0.3751882566065713,-0.7759051408559422,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(0.335852951745577,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,-0.3084041100814316),
(1.4172498286056856,1.9759849719804965,0.6064467288040396,-1.2496323298615286,-0.9307071977341307,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.5006903391303588),
(-1.5039261504449974,-0.8822407378465996,0.6064467288040396,1.564836659414635,1.1802647785505949,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.6996812757733565),
(-0.4365733888687864,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.43585662272210374),
(-0.4787057347204789,-0.8822407378465996,0.6064467288040396,0.2187862732390784,-0.041876891930035715,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.3368998976779251),
(-1.4056173434577148,-0.8822407378465996,-1.7393483837445023,-0.5154230283112251,-0.2640844683810594,-0.7759051408559422,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.7901009739613176),
(-0.8578968473857118,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.18033068452098802,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.7968181070236192),
(-0.8578968473857118,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.06922689629547615,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.4304886520899585),
(0.82739698668199,0.5468721170669484,-0.5664508274702313,-1.0048958960114276,-0.708499621283107,2.8191190778976205,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0.7820155881065295),
(2.442470244330204,1.9759849719804965,0.6064467288040396,-1.0048958960114276,-0.708499621283107,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.4629591826634065),
(0.82739698668199,1.9759849719804965,0.6064467288040396,-0.6377912452362757,-0.597395833057595,0.042116075746094286,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.578977412025547),
(-0.6051027722755565,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.06922689629547615,-0.37860022336488575,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.41608115955479075),
(-1.9954701853814105,-1.5967971653033737,0.6064467288040396,2.054309527114837,1.846887507903666,-0.7759051408559422,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.7895385318479554),
(0.5184264504362447,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.597395833057595,-0.37860022336488575,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.20154529675542784),
(-0.8578968473857118,-0.8822407378465996,0.6064467288040396,0.2187862732390784,-0.15298068015554758,-0.9693933242441344,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-0.8157645015340192,-0.8822407378465996,-1.7393483837445023,1.4424684424895844,1.069160990325083,0.44010956328479556,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.4289720739283619),
(-0.015249930351860891,0.5468721170669484,-1.7393483837445023,-0.5154230283112251,-0.597395833057595,-0.37860022336488575,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.6504524325880238),
(0.5043823351523472,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-0.7449194887119257,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.04232047162930672),
(0.19541179890660185,1.9759849719804965,-1.7393483837445023,-1.4943687637116299,-0.9307071977341307,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-1.773418614183755),
(1.6279115578641485,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.041876891930035715,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.6062758189342858),
(0.6026911421396298,-0.8822407378465996,0.6064467288040396,-0.025950160611022774,-0.15298068015554758,-0.9693933242441344,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.6610684797192),
(1.318941021618403,1.9759849719804965,0.6064467288040396,-1.0048958960114276,-0.708499621283107,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.29746886547641327),
(0.8414411019658875,1.9759849719804965,0.6064467288040396,-1.127264112936478,-0.8196034095086188,1.0618883163080606,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(2.3160732067751266,1.9759849719804965,0.6064467288040396,-1.2496323298615286,-0.8196034095086188,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.7499715997455645),
(-1.349440882322125,-0.8822407378465996,-1.7393483837445023,0.7082591409392808,0.18033068452098802,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.7876762709662243,-0.8822407378465996,-1.7393483837445023,0.7082591409392808,0.8469534138740592,-0.5121828126079793,2.659945347654738,6.01029080042039,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.42555977306476955),
(-0.3663528124492988,0.5468721170669484,0.6064467288040396,-1.0048958960114276,-0.708499621283107,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-1.7615134756152215),
(0.7571764102625025,0.5468721170669484,0.6064467288040396,0.5858909240142302,0.18033068452098802,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.06391582859053567),
(0.8414411019658875,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.2640844683810594,0.10821880031999623,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.0904559464184763),
(-0.9281174238051993,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.2914344727464999,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.9029785783353818),
(-0.2961322360298112,0.5468721170669484,-1.7393483837445023,-1.0048958960114276,-0.708499621283107,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-0.1203484180434522),
(0.9678381395209652,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.3751882566065713,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.8961380947666743),
(0.34989706702947454,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.4025382609720118,-0.6512739622322312,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.3283628708217075),
(-0.015249930351860891,0.5468721170669484,0.6064467288040396,-1.127264112936478,-0.8196034095086188,-0.7759051408559422,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.7121771637650057),
(-0.5067939652882739,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.041876891930035715,-0.12245216564101576,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.09380830021551156),
(0.82739698668199,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.597395833057595,0.042116075746094286,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.5979346390455045),
(-0.5770145417077616,0.5468721170669484,-0.5664508274702313,-1.4943687637116299,-0.8196034095086188,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,-0.5241373535685491),
(1.178499868779428,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.47706574017809383,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.7169860247308384),
(0.19541179890660185,1.9759849719804965,-1.7393483837445023,-1.4943687637116299,-0.9307071977341307,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.7901009739613176),
(1.5998233272963533,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.9452933725765659,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.838312277658567),
(0.6167352574235273,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.041876891930035715,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.07377358664091362),
(-0.31017635131370874,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,0.06922689629547615,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.2625875677596913),
(-0.6472351181272491,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.15298068015554758,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7723570094706371),
(-0.6472351181272491,-0.8822407378465996,-1.7393483837445023,0.5858909240142302,0.4025382609720118,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.3023977445016023),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,1.0753637917144325,0.7358496256485474,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.33304850520737644),
(-0.9000291932374044,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.8469534138740592,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.2966506293290579),
(-0.3663528124492988,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.597395833057595,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.3274212841679463),
(-0.8578968473857118,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.18033068452098802,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.7020319719238312),
(2.9901907404022072,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.597395833057595,-0.08526938306819591,2.659945347654738,6.01029080042039,2.082700496237388,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.6525314528629824),
(0.8414411019658875,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-0.6512739622322312,2.659945347654738,6.01029080042039,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.6134196181353126),
(-1.2089997294831498,-0.8822407378465996,0.6064467288040396,1.0753637917144325,0.9580572020995711,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.5844213354920142),
(0.335852951745577,-0.16768431038982562,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.47706574017809383,2.659945347654738,6.01029080042039,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1.783200543326053),
(-0.8578968473857118,0.5468721170669484,-0.5664508274702313,-1.2496323298615286,-0.708499621283107,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,-1.7901009739613176),
(-1.4898820351611,-0.8822407378465996,0.6064467288040396,0.341154490164129,-0.15298068015554758,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(1.178499868779428,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.9356533919095386,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.6373656712470164),
(1.5717350967285584,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,-0.9452933725765659,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.2316810130199238),
(0.9678381395209652,1.9759849719804965,-0.5664508274702313,-1.2496323298615286,-1.0418109859596425,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0.8150011631212557),
(0.19541179890660185,0.5468721170669484,-1.7393483837445023,-0.5154230283112251,-0.597395833057595,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7901009739613176),
(0.12519122248711426,-0.8822407378465996,0.6064467288040396,-0.270686594461124,-0.2640844683810594,-0.8172193437146309,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7770584017715867),
(-0.5067939652882739,-0.8822407378465996,0.6064467288040396,-0.39305481138617454,-0.2640844683810594,-0.37860022336488575,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.08319225308433531),
(0.7852646408302975,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.18033068452098802,0.042116075746094286,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.6680763790193478),
(1.178499868779428,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.15298068015554758,1.620318624948003,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.6942373523068892),
(1.9509262093937914,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.2635291544134526),
(0.9257057936692726,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.3399330540011183),
(1.290852791050608,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,0.042116075746094286,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.498977914001326),
(0.6167352574235273,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.48629204483208316,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.10789659527683729),
(-1.2089997294831498,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.2914344727464999,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.9700113330779518),
(-0.3242204665976062,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,-0.451720746352311),
(4.352469922940267,1.9759849719804965,-1.7393483837445023,-0.7601594621613263,-0.708499621283107,2.8191190778976205,1.4161194154023549,6.01029080042039,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.6824838715545154),
(-0.2259116596103236,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.3751882566065713,-0.9356533919095386,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7853237527522883),
(-0.08547050677134847,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.2914344727464999,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.08129653038233954),
(0.5465146810040398,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.597395833057595,-0.37860022336488575,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.6193625802752933),
(-0.3944410430170938,-0.8822407378465996,0.6064467288040396,1.6872048763396854,2.624614025482249,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.07339444210051446),
(2.3160732067751266,1.9759849719804965,0.6064467288040396,-1.127264112936478,-0.8196034095086188,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.58656030283353),
(1.8807056329743037,0.5468721170669484,-1.7393483837445023,-0.14831837753607335,-0.15298068015554758,0.30721554408934687,1.4161194154023549,6.01029080042039,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.6062758189342858),
(-1.1809114989153546,-0.8822407378465996,0.6064467288040396,1.3201002255645338,0.9580572020995711,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.25873617528914267),
(-0.9281174238051993,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.2914344727464999,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.7895385318479554),
(0.8695293325336826,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.2640844683810594,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.5427753831146647),
(-0.4365733888687864,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.6247458374230355,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.14120136776540557),
(-0.8578968473857118,-0.8822407378465996,0.6064467288040396,1.6872048763396854,0.9580572020995711,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.5885919254364049),
(0.5043823351523472,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.3751882566065713,-0.9315219716236697,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.22543140280057442),
(1.2206322146311204,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-1.0341189087227467,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.3981254662551514),
(0.1532794530549093,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.9452933725765659,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.3114972134711819),
(0.16732356833880682,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.2914344727464999,1.620318624948003,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.5681780673214079),
(-1.054514461360277,0.5468721170669484,-1.7393483837445023,-0.14831837753607335,-0.2640844683810594,-0.37860022336488575,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.45061750415268387,-0.8822407378465996,0.6064467288040396,1.0753637917144325,0.2914344727464999,-0.37860022336488575,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.14884420563994571),
(-0.6472351181272491,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.5136420491975237,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.28344051748164467),
(-1.2511320753348423,-0.8822407378465996,-1.7393483837445023,-0.5154230283112251,-0.041876891930035715,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,-0.6527431816719415),
(-0.3663528124492988,0.5468721170669484,-1.7393483837445023,-1.3720005467865792,-0.8196034095086188,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7637883428576164),
(2.3160732067751266,1.9759849719804965,0.6064467288040396,-1.2496323298615286,-0.8196034095086188,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1.2218232549695458),
(0.8695293325336826,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.3751882566065713,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.5662823446194121),
(-1.2089997294831498,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.9580572020995711,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.7550363786716326),
(-0.9281174238051993,0.5468721170669484,-1.7393483837445023,-0.7601594621613263,-0.597395833057595,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-0.8050834580043207),
(1.5717350967285584,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.3751882566065713,-0.9452933725765659,1.4161194154023549,-0.16638130054040892,2.082700496237388,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.8639108088327463),
(1.529602750876866,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.9452933725765659,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.5349966453392454),
(1.6279115578641485,0.5468721170669484,-1.7393483837445023,-0.14831837753607335,-0.2640844683810594,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.8692188323983344),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.597395833057595,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,-0.02290827116087014),
(-1.6162790727161778,-0.8822407378465996,-1.7393483837445023,0.7082591409392808,0.7358496256485474,-0.5121828126079793,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.7292545499244902),
(-0.12760285262304102,0.5468721170669484,-1.7393483837445023,-0.7601594621613263,-0.597395833057595,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.39446992075203907),
(-1.5179702657288952,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.7358496256485474,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.7766476174743843),
(-1.4898820351611,-0.8822407378465996,0.6064467288040396,0.4635227070891796,-0.15298068015554758,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,1.3201002255645338,0.7358496256485474,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.8122872042719046),
(-1.4196614587416125,-0.8822407378465996,-1.7393483837445023,1.0753637917144325,0.6247458374230355,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.597395833057595,-0.7759051408559422,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.10404520280628866),
(0.4762941045845522,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.48629204483208316,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.6512107216688221),
(0.9678381395209652,1.9759849719804965,0.6064467288040396,-1.127264112936478,-0.708499621283107,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.3588902810210759),
(1.318941021618403,1.9759849719804965,-0.5664508274702313,-1.2496323298615286,-0.8196034095086188,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0.40666249311136904),
(-0.2961322360298112,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.708499621283107,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.3140912781874189),
(-0.8157645015340192,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.3751882566065713,-0.6512739622322312,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(0.4762941045845522,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.3751882566065713,-0.37860022336488575,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.26524157954248534),
(-0.3944410430170938,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.6247458374230355,0.30721554408934687,2.659945347654738,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12306237689280337),
(-1.5460584962966901,-0.8822407378465996,-1.7393483837445023,1.0753637917144325,1.069160990325083,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.7853679419035647),
(-1.4898820351611,-0.8822407378465996,-1.7393483837445023,0.5858909240142302,0.18033068452098802,-0.9315219716236697,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.2259116596103236,-0.8822407378465996,-1.7393483837445023,0.7082591409392808,0.4025382609720118,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.02328741570126929),
(-0.2259116596103236,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,-0.20148534968887072),
(-1.1809114989153546,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.9580572020995711,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.4733319851550627),
(-1.1668673836314571,-0.8822407378465996,0.6064467288040396,0.341154490164129,1.5135761432271304,-0.6726196337092204,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.18107149157387362),
(-0.6612792334111466,-0.8822407378465996,0.6064467288040396,-0.025950160611022774,-0.15298068015554758,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.1503607838015423),
(-0.7876762709662243,-0.8822407378465996,0.6064467288040396,1.0753637917144325,0.7358496256485474,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.03655747461523961),
(0.6167352574235273,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.15298068015554758,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1.3090264992613507),
(0.2656323753260894,1.9759849719804965,0.6064467288040396,-1.2496323298615286,-0.9307071977341307,-0.37860022336488575,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.6220165920580873),
(0.9678381395209652,1.9759849719804965,0.6064467288040396,-1.127264112936478,-0.708499621283107,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.24552606344172948),
(0.9397499089531701,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.3751882566065713,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.08249391107009411),
(-0.3803969277331963,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.2914344727464999,0.44010956328479556,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.10177033556389375),
(-0.3242204665976062,-0.8822407378465996,0.6064467288040396,1.9319413101897867,2.06909508435469,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.3406913430819166),
(0.335852951745577,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.18033068452098802,1.620318624948003,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.9662798347405174),
(1.2065880993472229,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.2914344727464999,-0.47706574017809383,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1.7700662603867197),
(-0.33826458188150377,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.2914344727464999,0.10821880031999623,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.3114372664046248),
(0.9116616783853752,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.597395833057595,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.9890285071644666),
(-0.4365733888687864,-0.8822407378465996,0.6064467288040396,-0.270686594461124,-0.2640844683810594,-0.8172193437146309,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.534882195856069,-0.8822407378465996,-1.7393483837445023,-0.39305481138617454,-0.2640844683810594,-0.6726196337092204,1.4161194154023549,6.01029080042039,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.013110460177049298),
(-0.619146887559454,0.5468721170669484,-1.7393483837445023,-0.6377912452362757,-0.3751882566065713,1.0618883163080606,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,-1.7038835054745503),
(-0.6472351181272491,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.3751882566065713,-0.8172193437146309,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.12760285262304102,0.5468721170669484,-1.7393483837445023,-1.0048958960114276,-0.597395833057595,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.28793030489987737),
(0.6167352574235273,-0.8822407378465996,0.6064467288040396,0.2187862732390784,0.06922689629547615,-0.12245216564101576,1.4161194154023549,6.01029080042039,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.04912919151496874),
(0.8695293325336826,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.15298068015554758,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.13254099040278217),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.7759051408559422,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.11297713211818593),
(-2.009514300665308,-1.5967971653033737,0.6064467288040396,0.2187862732390784,0.4025382609720118,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.2914344727464999,0.10821880031999623,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.7288754053840911),
(-0.591058656991659,0.5468721170669484,0.6064467288040396,-1.0048958960114276,-0.597395833057595,-0.8984706093367187,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.45253898249966645),
(-0.15569108319083605,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.3751882566065713,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.763105882684898),
(-1.2370879600509448,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.7358496256485474,-1.003821826626375,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.6488759073598701),
(-0.6472351181272491,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.2640844683810594,-0.9315219716236697,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.3311527825053807),
(0.8695293325336826,0.5468721170669484,-1.7393483837445023,0.09641805631402782,-0.2640844683810594,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.4222074192677343),
(-0.2680440054620162,0.5468721170669484,0.6064467288040396,-1.2496323298615286,-0.708499621283107,-0.7759051408559422,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.5520265099004039),
(1.6279115578641485,0.5468721170669484,-1.7393483837445023,-0.14831837753607335,-0.15298068015554758,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.9677964129021139),
(-0.9562056543729944,-0.8822407378465996,0.6064467288040396,0.2187862732390784,0.2914344727464999,-0.7759051408559422,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.23598750286519354),
(-0.3944410430170938,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.6247458374230355,0.30721554408934687,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.2659399215567266),
(2.3160732067751266,1.9759849719804965,0.6064467288040396,-1.2496323298615286,-0.8196034095086188,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.3632441685384296),
(0.34989706702947454,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.18033068452098802,-0.7635108799983356,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.5171768519404851),
(0.19541179890660185,1.9759849719804965,-1.7393483837445023,-1.2496323298615286,-1.0418109859596425,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-1.7051725969119076),
(-1.0685585766441745,-0.8822407378465996,0.6064467288040396,1.4424684424895844,0.9580572020995711,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.2925399864512243),
(0.335852951745577,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.06922689629547615,-0.8984706093367187,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.7207774701348297),
(0.12519122248711426,0.5468721170669484,-1.7393483837445023,-0.14831837753607335,-0.2640844683810594,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.10107199354965256),
(1.8526174024065087,0.5468721170669484,-1.7393483837445023,-0.270686594461124,-0.3751882566065713,-0.9452933725765659,2.659945347654738,6.01029080042039,2.082700496237388,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.8345208322545754),
(-1.1387791530636622,0.5468721170669484,-0.5664508274702313,-0.6377912452362757,-0.48629204483208316,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.4787057347204789,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.06922689629547615,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.11655697263946067),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,1.0753637917144325,0.7358496256485474,0.10821880031999623,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.7667898594240063),
(-0.4365733888687864,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.4460935253128809),
(0.5043823351523472,-0.8822407378465996,0.6064467288040396,-0.270686594461124,-0.041876891930035715,0.10477595008177217,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.6601143436709656),
(-0.33826458188150377,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.2914344727464999,0.10821880031999623,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.013868749257847602),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.48629204483208316,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.34973086498493916),
(-1.3353967670382274,-0.8822407378465996,0.6064467288040396,2.788518828665141,3.7356519077373678,0.32236408513753273,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.33424588589513105),
(1.2487204451989156,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.2640844683810594,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.2906442637492285),
(-0.5067939652882739,-0.8822407378465996,0.6064467288040396,0.2187862732390784,0.18033068452098802,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.010759764026574557),
(-0.562970426423864,-0.8822407378465996,0.6064467288040396,0.2187862732390784,0.18033068452098802,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.010835592934654387),
(-0.7595880403984292,-0.8822407378465996,0.6064467288040396,-0.39305481138617454,-0.2640844683810594,-0.47706574017809383,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(0.5465146810040398,1.9759849719804965,-0.5664508274702313,-1.4943687637116299,-1.0418109859596425,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0.8294086556564235),
(0.5043823351523472,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-0.7449194887119257,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.025925545642540637),
(-0.7736321556823267,-0.8822407378465996,-0.5664508274702313,-1.0048958960114276,-0.597395833057595,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,-1.7752385079776707),
(-1.897161378394128,-0.8822407378465996,-1.7393483837445023,0.7082591409392808,0.5136420491975237,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(1.9509262093937914,1.9759849719804965,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.5547121614400012),
(-0.5770145417077616,0.5468721170669484,-0.5664508274702313,-1.4943687637116299,-0.8196034095086188,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,-0.31674528997021295),
(2.0913673622327664,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,2.8191190778976205,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1.2733869124638304),
(-0.015249930351860891,0.5468721170669484,-1.7393483837445023,-0.5154230283112251,-0.597395833057595,-0.37860022336488575,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.6921583320319304),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-1.127264112936478,-0.708499621283107,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.5742443799677942),
(-0.2259116596103236,0.5468721170669484,-1.7393483837445023,-1.127264112936478,-0.708499621283107,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.7405846969851884),
(-0.8157645015340192,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,-0.041876891930035715,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.24205381551157998),
(0.335852951745577,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.18033068452098802,1.620318624948003,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1.3188842573117288),
(-0.3663528124492988,0.5468721170669484,-0.5664508274702313,-1.3720005467865792,-0.9307071977341307,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.04457945703017891),
(-0.4365733888687864,-0.8822407378465996,0.6064467288040396,-0.5154230283112251,-0.3751882566065713,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-0.08887942119032259),
(-0.8578968473857118,-0.8822407378465996,-1.7393483837445023,1.0753637917144325,0.7358496256485474,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.05974523864614499),
(0.6167352574235273,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.48629204483208316,0.19842147656146658,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.12419981051400084),
(-0.6472351181272491,-0.8822407378465996,0.6064467288040396,1.3201002255645338,0.5136420491975237,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.24015809280958422),
(-0.4365733888687864,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.597395833057595,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.27359864127278943),
(-0.6472351181272491,-0.8822407378465996,0.6064467288040396,-0.025950160611022774,-0.15298068015554758,-0.47706574017809383,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.32135497152155984),
(-0.8578968473857118,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.6110372822280347),
(-1.5039261504449974,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.6247458374230355,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.9044193275888985),
(0.6729117185591174,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.9315219716236697,2.659945347654738,6.01029080042039,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.28912768558763197),
(0.82739698668199,1.9759849719804965,0.6064467288040396,-0.39305481138617454,-0.48629204483208316,0.042116075746094286,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.5160394183192878),
(-0.9281174238051993,-0.8822407378465996,0.6064467288040396,2.1766777440398877,1.1802647785505949,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.2174094203856351),
(0.12519122248711426,1.9759849719804965,-0.5664508274702313,-1.3720005467865792,-0.8196034095086188,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0.23908060625494387),
(-0.3944410430170938,1.9759849719804965,0.6064467288040396,-1.3720005467865792,-0.9307071977341307,-0.8984706093367187,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.5871352943413654),
(3.991577638060311e-16,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.3751882566065713,-0.12245216564101576,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.1528189486169003),
(-1.1387791530636622,-0.8822407378465996,-1.7393483837445023,-0.270686594461124,0.06922689629547615,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-0.9681156103759561),
(1.4593821744573783,0.5468721170669484,-1.7393483837445023,-0.6377912452362757,-0.48629204483208316,-0.7759051408559422,2.659945347654738,6.01029080042039,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.4861787103773574),
(-0.4365733888687864,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.05557464870175432),
(0.363941182313372,0.5468721170669484,-1.7393483837445023,-0.14831837753607335,-0.2640844683810594,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.16508747381055214),
(-1.026426230792482,-0.8822407378465996,-1.7393483837445023,-0.025950160611022774,0.18033068452098802,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-0.504042692927394),
(1.318941021618403,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.2640844683810594,0.042116075746094286,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.6517731637821842),
(1.0661469465082478,0.5468721170669484,0.6064467288040396,0.341154490164129,-0.15298068015554758,-0.37860022336488575,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.987891073543269),
(-0.6753233486950441,-0.8822407378465996,0.6064467288040396,0.2187862732390784,0.06922689629547615,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.15219655943698096),
(1.2487204451989156,-0.8822407378465996,0.6064467288040396,-0.5154230283112251,-0.3751882566065713,-0.6354368511364006,1.4161194154023549,6.01029080042039,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.7270396297486524),
(-0.2259116596103236,0.5468721170669484,-0.5664508274702313,-0.6377912452362757,-0.48629204483208316,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,-0.4084982687468077),
(0.9678381395209652,0.5468721170669484,-1.7393483837445023,-0.39305481138617454,-0.2640844683810594,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0.6811631403603551),
(-0.4365733888687864,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.48629204483208316,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.27359864127278943),
(-0.9281174238051993,-0.8822407378465996,0.6064467288040396,2.1766777440398877,1.069160990325083,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.2473618390771681),
(1.0521028312243503,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.708499621283107,-0.9693933242441344,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.528747035119896),
(-0.7595880403984292,-0.8822407378465996,0.6064467288040396,-0.6377912452362757,-0.3751882566065713,-0.47706574017809383,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-0.8578968473857118,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.3751882566065713,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.5541656011681619),
(-0.8578968473857118,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.7358496256485474,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.4938057903366169),
(1.9509262093937914,1.9759849719804965,0.6064467288040396,-0.8825276790863769,-0.597395833057595,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.6354699485450206),
(-0.7876762709662243,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.3751882566065713,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1.7901009739613176),
(1.2487204451989156,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.7122529926730855),
(-0.9281174238051993,-0.16768431038982562,-1.7393483837445023,0.09641805631402782,-0.041876891930035715,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.13519500218557623),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,1.564836659414635,0.9580572020995711,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.5135213064373728),
(-0.49274985000437643,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.48629204483208316,-0.47706574017809383,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-0.45061750415268387,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.6247458374230355,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.19813299589183547),
(-0.7876762709662243,0.5468721170669484,0.6064467288040396,-1.0048958960114276,-0.708499621283107,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-1.6703671281032653),
(-0.5067939652882739,-0.8822407378465996,0.6064467288040396,1.9319413101897867,1.1802647785505949,1.620318624948003,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.1672264411520679),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,1.3201002255645338,2.1801988725802017,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.18107149157387362),
(-0.2259116596103236,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.597395833057595,-0.9693933242441344,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.40817907127296565),
(-0.4787057347204789,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.18033068452098802,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.5655240555386137),
(-1.0685585766441745,1.9759849719804965,0.6064467288040396,-0.6377912452362757,-0.597395833057595,0.042116075746094286,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-0.2961322360298112,0.5468721170669484,-1.7393483837445023,-0.7601594621613263,-0.597395833057595,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-0.401673667019623),
(-0.45061750415268387,-0.8822407378465996,0.6064467288040396,1.1977320086394831,0.5136420491975237,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.042623787261626044),
(-2.1078231076525906,0.0,0.6064467288040396,9.151666108767772,11.179605718846663,-0.7759051408559422,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.19807304882527835),
(0.4060735281650646,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.041876891930035715,-1.0341189087227467,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.1975580043840002),
(0.7571764102625025,0.5468721170669484,0.6064467288040396,0.5858909240142302,0.18033068452098802,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.18069234703347448),
(0.6307793727074248,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.48629204483208316,0.30721554408934687,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.25045494246691846),
(1.529602750876866,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.2640844683810594,-0.47706574017809383,1.4161194154023549,-0.16638130054040892,2.082700496237388,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.4098789470075253),
(0.5465146810040398,1.9759849719804965,0.6064467288040396,-1.2496323298615286,-0.9307071977341307,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-1.7546130449799568),
(-0.591058656991659,-0.8822407378465996,0.6064467288040396,1.809573093264736,1.2913685667761068,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.06120186974118449),
(1.2065880993472229,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.18033068452098802,-0.47706574017809383,1.4161194154023549,-0.16638130054040892,2.082700496237388,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.4250447286234913),
(-1.5179702657288952,-0.8822407378465996,-1.7393483837445023,1.0753637917144325,0.8469534138740592,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.1042285003792516),
(0.9678381395209652,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.3751882566065713,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.7569920484401855),
(-0.3663528124492988,0.5468721170669484,0.6064467288040396,-1.127264112936478,-0.708499621283107,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,-0.07105962779156244),
(2.3160732067751266,1.9759849719804965,0.6064467288040396,-1.2496323298615286,-0.8196034095086188,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.7653332283289668),
(-0.15569108319083605,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.18033068452098802,0.44010956328479556,1.4161194154023549,6.01029080042039,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.19086930255769446),
(0.7009999491269124,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1.2240981222119407),
(0.7009999491269124,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1.169880452934862),
(1.3891615980378906,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,2.8191190778976205,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.159643550344085),
(-0.5489263111399665,0.5468721170669484,0.6064467288040396,-1.0048958960114276,-0.597395833057595,-0.6512739622322312,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7806981893594185),
(-0.2118675443264261,-0.8822407378465996,0.6064467288040396,0.2187862732390784,0.06922689629547615,-0.9356533919095386,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.4476101034744775),
(0.4482058740167571,-0.8822407378465996,-1.7393483837445023,0.8306273578643314,0.2914344727464999,1.620318624948003,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.2544296854438728),
(-0.6472351181272491,0.5468721170669484,-1.7393483837445023,-0.39305481138617454,-0.48629204483208316,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7901009739613176),
(1.6279115578641485,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.041876891930035715,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.334808328008493),
(-0.2259116596103236,0.5468721170669484,-1.7393483837445023,-1.0048958960114276,-0.708499621283107,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.6899309863878615),
(-0.534882195856069,0.5468721170669484,-1.7393483837445023,-0.5154230283112251,-0.48629204483208316,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(1.0380587159404528,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.3751882566065713,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.708461547269094),
(-1.1809114989153546,-0.8822407378465996,-0.5664508274702313,1.0753637917144325,0.7358496256485474,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.2773142577687011),
(-0.3663528124492988,-0.16768431038982562,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.47706574017809383,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7816081362563765),
(0.82739698668199,0.5468721170669484,-0.5664508274702313,-1.0048958960114276,-0.708499621283107,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0.6641016360423933),
(0.29372060589388443,-0.8822407378465996,-1.7393483837445023,-0.270686594461124,-0.2640844683810594,0.44010956328479556,1.4161194154023549,6.01029080042039,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.8866594812566955),
(0.39202941288116705,-0.8822407378465996,0.6064467288040396,-0.5154230283112251,-0.3751882566065713,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.15491051828633215),
(-0.619146887559454,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.48629204483208316,1.0618883163080606,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-1.7901009739613176),
(-0.45061750415268387,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.4025382609720118,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.27396190397166587),
(0.335852951745577,-0.8822407378465996,-1.7393483837445023,0.7082591409392808,0.18033068452098802,1.620318624948003,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.2999270302917711),
(-0.5067939652882739,-0.8822407378465996,0.6064467288040396,0.2187862732390784,0.18033068452098802,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.12829457155031168),
(-0.23995577489422115,-0.8822407378465996,0.6064467288040396,1.4424684424895844,1.6246799314526423,0.10821880031999623,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.4995529055091613),
(-1.2370879600509448,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.7358496256485474,-1.003821826626375,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.7095390338237344),
(3.776661196300468,1.9759849719804965,-1.7393483837445023,-0.5154230283112251,-0.708499621283107,0.19842147656146658,1.4161194154023549,6.01029080042039,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.9393605723721776),
(-0.6051027722755565,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.06922689629547615,-0.37860022336488575,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.023726507308225554),
(0.22350002947439687,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-1.0341189087227467,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.8153803076616549),
(0.9257057936692726,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.3751882566065713,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.9560429321497402),
(1.2487204451989156,-0.8822407378465996,0.6064467288040396,-0.5154230283112251,-0.3751882566065713,-0.6354368511364006,1.4161194154023549,6.01029080042039,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.927986236160203),
(1.0661469465082478,0.5468721170669484,0.6064467288040396,0.4635227070891796,-0.15298068015554758,-0.37860022336488575,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.7315893642334423),
(1.262764560482813,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.15298068015554758,-0.7635108799983356,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.2658040216558475),
(-0.562970426423864,-0.16768431038982562,0.6064467288040396,-0.39305481138617454,-0.2640844683810594,-0.9356533919095386,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-0.12760285262304102,-0.8822407378465996,-1.7393483837445023,-0.025950160611022774,-0.15298068015554758,-0.8172193437146309,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1.476608386117776),
(0.7852646408302975,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.18033068452098802,0.042116075746094286,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.9696921356041097),
(-1.2792203059026372,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.7358496256485474,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.789873487237078),
(0.335852951745577,-0.8822407378465996,0.6064467288040396,-0.270686594461124,-0.15298068015554758,0.10821880031999623,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.5833438489373739),
(1.2487204451989156,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,8.094658110932539,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.7350016650970347),
(0.7852646408302975,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.18033068452098802,0.042116075746094286,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.3306377380641023),
(0.8695293325336826,0.5468721170669484,-1.7393483837445023,0.5858909240142302,0.06922689629547615,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.5264721678775011),
(-0.2259116596103236,-0.8822407378465996,-1.7393483837445023,0.341154490164129,0.18033068452098802,-1.003821826626375,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.02290827116087014),
(0.8695293325336826,0.5468721170669484,-1.7393483837445023,0.5858909240142302,0.06922689629547615,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.6648599251231916),
(-0.3663528124492988,0.5468721170669484,-0.5664508274702313,-1.127264112936478,-0.708499621283107,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,-0.031249451049651482),
(2.161587938652254,1.9759849719804965,0.6064467288040396,-0.270686594461124,-0.48629204483208316,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.8559487734843642),
(-0.6472351181272491,-0.8822407378465996,-1.7393483837445023,0.5858909240142302,0.4025382609720118,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.39035927787420555),
(0.9678381395209652,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.2640844683810594,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.5022069172919553),
(1.2206322146311204,1.9759849719804965,0.6064467288040396,-1.0048958960114276,-0.708499621283107,-0.37860022336488575,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.6917791874915313),
(-0.6753233486950441,-0.16768431038982562,0.6064467288040396,0.341154490164129,0.06922689629547615,-0.47706574017809383,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.23453087177015405),
(-0.08547050677134847,0.5468721170669484,-1.7393483837445023,-0.025950160611022774,-0.2640844683810594,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.0816756749227387),
(-0.12760285262304102,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.06922689629547615,-0.8172193437146309,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.3581319919402776),
(-1.0685585766441745,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.06922689629547615,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.5703929874972457),
(-0.6472351181272491,-0.8822407378465996,-1.7393483837445023,0.5858909240142302,0.4025382609720118,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,-0.0009178878177193246),
(-0.4365733888687864,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.18033068452098802,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.3194592488195641),
(-0.9281174238051993,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.2640844683810594,-1.058218860390315,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-0.8157645015340192,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.06922689629547615,-0.9315219716236697,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.3588303339545188),
(-1.6443673032839727,-0.8822407378465996,0.6064467288040396,2.2990459609649383,3.624548119511856,0.32236408513753273,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.39939879977722803),
(-0.4365733888687864,-0.8822407378465996,0.6064467288040396,1.0753637917144325,0.7358496256485474,0.44010956328479556,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.3952881568993945),
(0.8695293325336826,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.2640844683810594,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.6189834357348941),
(1.178499868779428,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.48629204483208316,-0.8172193437146309,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.786369475623883),
(-1.9954701853814105,-0.8822407378465996,-1.7393483837445023,0.8306273578643314,0.5136420491975237,-0.9315219716236697,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.3663528124492988,0.5468721170669484,-0.5664508274702313,-1.127264112936478,-0.708499621283107,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.02903453087381368),
(-0.4787057347204789,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.18033068452098802,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.06391582859053567),
(-0.2118675443264261,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.5136420491975237,-0.9356533919095386,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.5598368874326265),
(-0.6472351181272491,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.5136420491975237,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.22195915487042492),
(-1.32135265175433,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.6247458374230355,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.8271496702555513),
(-0.5067939652882739,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.2914344727464999,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.09160926188119647),
(-0.9281174238051993,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.7077367061391058,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,-1.7901009739613176),
(-1.6162790727161778,-0.8822407378465996,-1.7393483837445023,1.564836659414635,1.1802647785505949,-0.5121828126079793,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,-0.08432968670553276),
(1.4593821744573783,1.9759849719804965,-1.7393483837445023,-0.6377912452362757,-0.597395833057595,2.8191190778976205,1.4161194154023549,6.01029080042039,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.5941590754830357),
(-0.5489263111399665,0.5468721170669484,0.6064467288040396,-1.0048958960114276,-0.597395833057595,-0.6512739622322312,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.772508667286797),
(1.3891615980378906,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,2.8191190778976205,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.159643550344085),
(0.4762941045845522,-0.16768431038982562,0.6064467288040396,0.2187862732390784,-0.041876891930035715,-0.47706574017809383,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.7615417829249753),
(-0.6472351181272491,-0.8822407378465996,-1.7393483837445023,0.7082591409392808,0.4025382609720118,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.038832341857634525),
(-0.4787057347204789,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.18033068452098802,-0.12245216564101576,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.042683734328183155),
(-1.1809114989153546,-0.8822407378465996,0.6064467288040396,1.0753637917144325,0.8469534138740592,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.538923990644116),
(-1.43370557402551,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.2914344727464999,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.4365733888687864,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.597395833057595,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.18260395157699297),
(0.335852951745577,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.06922689629547615,1.620318624948003,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.977654170952492),
(-0.9562056543729944,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.5136420491975237,-0.7759051408559422,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.3648966466009052),
(-0.45061750415268387,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.18033068452098802,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.2663190660971257),
(-0.2118675443264261,-0.8822407378465996,0.6064467288040396,0.2187862732390784,0.06922689629547615,0.10821880031999623,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.35769290033332135),
(0.19541179890660185,0.5468721170669484,-1.7393483837445023,-0.6377912452362757,-0.597395833057595,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7543097293476375),
(-2.009514300665308,-1.5967971653033737,0.6064467288040396,0.5858909240142302,0.8469534138740592,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(0.335852951745577,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,-0.041876891930035715,-0.8984706093367187,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.513764551076893),
(-0.49274985000437643,-0.8822407378465996,0.6064467288040396,-0.270686594461124,0.06922689629547615,0.10821880031999623,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.10562172803444238),
(0.4762941045845522,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.3232506942235556),
(-0.6472351181272491,-0.8822407378465996,0.6064467288040396,2.5437823948150395,2.4024064490312256,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.0035718996005133885),
(1.6279115578641485,1.9759849719804965,0.6064467288040396,-0.5154230283112251,-0.041876891930035715,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.0921558221530359),
(0.8976175631014777,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.15298068015554758,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.6275079131966383),
(1.318941021618403,1.9759849719804965,-1.7393483837445023,-0.5154230283112251,-0.48629204483208316,-0.9315219716236697,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.029413675414212834),
(0.5043823351523472,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,-0.041876891930035715,-0.9693933242441344,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.4485516901282387),
(-0.6472351181272491,1.9759849719804965,-1.7393483837445023,-1.8614734144867817,-1.0418109859596425,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.7736321556823267,-0.8822407378465996,-0.5664508274702313,-0.8825276790863769,-0.48629204483208316,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,-1.7852479238442083),
(-0.9281174238051993,-0.8822407378465996,-1.7393483837445023,-0.14831837753607335,-0.2640844683810594,-0.8172193437146309,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(0.4762941045845522,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.48629204483208316,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.7649540837885677),
(-0.18377931375863107,0.5468721170669484,-1.7393483837445023,-1.0048958960114276,-0.708499621283107,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.0009178878177193246),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.2914344727464999,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.4634742271046847),
(-0.3663528124492988,0.5468721170669484,-0.5664508274702313,-1.0048958960114276,-0.708499621283107,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,-0.22082172124922747),
(-0.9281174238051993,0.5468721170669484,0.6064467288040396,-1.127264112936478,-0.708499621283107,-0.6980967254720785,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(0.8976175631014777,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.15298068015554758,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.3782266525814327),
(0.026882415499831655,0.5468721170669484,0.6064467288040396,-0.025950160611022774,-0.15298068015554758,-0.9452933725765659,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.795664791560899),
(-0.2259116596103236,-0.8822407378465996,-1.7393483837445023,0.09641805631402782,0.06922689629547615,-0.9356533919095386,3.903771279907121,6.01029080042039,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.17342865369933347),
(1.2487204451989156,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.3751882566065713,-0.9356533919095386,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.3329126053064972),
(-0.8298086168179168,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.18033068452098802,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,-0.07105962779156244),
(1.4312939438895833,0.5468721170669484,-1.7393483837445023,-0.025950160611022774,-0.2640844683810594,0.042116075746094286,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1.3909217199875676),
(0.4482058740167571,-0.8822407378465996,-1.7393483837445023,0.7082591409392808,0.2914344727464999,1.620318624948003,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1.1634349957480765),
(-0.9000291932374044,-0.8822407378465996,0.6064467288040396,1.0753637917144325,0.7358496256485474,-0.6354368511364006,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.21323883044124445),
(0.22350002947439687,0.0,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.5067566517767452),
(0.12519122248711426,1.9759849719804965,-0.5664508274702313,-1.2496323298615286,-0.8196034095086188,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0.34410364394550896),
(0.4762941045845522,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,0.18033068452098802,-0.47706574017809383,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.3909217199875676),
(0.8695293325336826,0.5468721170669484,0.6064467288040396,0.09641805631402782,-0.15298068015554758,0.44010956328479556,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.8707354105599311),
(-0.1135587373391435,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.2914344727464999,-0.9452933725765659,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.9131995990846361),
(0.9678381395209652,0.5468721170669484,-1.7393483837445023,-0.39305481138617454,-0.2640844683810594,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0.6352866509720577),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.597395833057595,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.12950783407958896),
(0.799308756114195,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,-0.6726196337092204,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.83547496830281),
(0.9397499089531701,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.48629204483208316,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.6132962676289069),
(1.2065880993472229,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.2640844683810594,-0.6512739622322312,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.8322459650121805),
(-0.8017203862501218,-0.8822407378465996,0.6064467288040396,-0.6377912452362757,-0.15298068015554758,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.12040836511000931),
(-0.15569108319083605,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.7759051408559422,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.006058371725625072),
(0.12519122248711426,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.597395833057595,-0.7759051408559422,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.15104324397426078),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.597395833057595,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.22922284820456593),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,-0.39305481138617454,-0.041876891930035715,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.34031219854151745),
(-0.08547050677134847,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.2914344727464999,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.4009753250053818),
(-0.49274985000437643,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.597395833057595,-0.47706574017809383,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-0.9562056543729944,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.6247458374230355,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.1677414855933462),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-0.7601594621613263,-0.597395833057595,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.17191207553773688),
(0.29372060589388443,-0.8822407378465996,-1.7393483837445023,-0.270686594461124,-0.2640844683810594,0.44010956328479556,1.4161194154023549,6.01029080042039,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0.810830573176865),
(-0.8578968473857118,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.18033068452098802,-0.7449194887119257,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.7285720897517718),
(-0.6051027722755565,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.06922689629547615,-0.37860022336488575,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.43731325381714325),
(-0.28208812074591366,-0.8822407378465996,0.6064467288040396,2.2990459609649383,2.9579253901587848,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.074715173294675),
(-0.4787057347204789,-0.8822407378465996,0.6064467288040396,0.09641805631402782,-0.041876891930035715,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.7899776234549117),
(1.178499868779428,0.5468721170669484,0.6064467288040396,0.341154490164129,0.18033068452098802,0.30721554408934687,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1.0883643767490443),
(0.4060735281650646,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.2914344727464999,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.22505225826017525),
(-0.7314998098306342,-0.8822407378465996,0.6064467288040396,0.4635227070891796,0.2914344727464999,-0.08526938306819591,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.22044257670882833),
(0.335852951745577,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.2640844683810594,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.02107249552543149),
(-1.7286319949873579,-0.8822407378465996,-1.7393483837445023,0.9529955747893819,0.7358496256485474,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.7034115792628391,-0.8822407378465996,0.6064467288040396,-0.5154230283112251,-0.15298068015554758,-0.7449194887119257,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,-0.027154690013340643),
(-0.16973519847473356,0.5468721170669484,0.6064467288040396,-0.025950160611022774,0.06922689629547615,-0.7635108799983356,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.9037209855746573),
(0.5043823351523472,0.5468721170669484,0.6064467288040396,-0.5154230283112251,-0.48629204483208316,-0.7449194887119257,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.32780042870834547),
(-2.009514300665308,-1.5967971653033737,-1.7393483837445023,0.2187862732390784,0.4025382609720118,-0.6354368511364006,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(0.32180883646167946,1.9759849719804965,0.6064467288040396,-0.39305481138617454,-0.48629204483208316,2.8191190778976205,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.3259047060063497),
(0.7009999491269124,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.2640844683810594,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1.074715173294675),
(-0.7174556945467366,0.5468721170669484,-1.7393483837445023,-0.6377912452362757,-0.48629204483208316,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7901009739613176),
(-0.9281174238051993,-0.8822407378465996,0.6064467288040396,0.2187862732390784,-0.15298068015554758,-0.9693933242441344,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7901009739613176),
(-0.2118675443264261,-0.8822407378465996,0.6064467288040396,0.341154490164129,0.18033068452098802,-0.9356533919095386,0.1722934831499719,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.4362357672625029),
(0.9678381395209652,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.3751882566065713,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1.0337675629315664),
(-0.28208812074591366,-0.8822407378465996,0.6064467288040396,2.1766777440398877,3.2912367548353205,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.48893685837798506),
(0.19541179890660185,1.9759849719804965,-1.7393483837445023,-1.2496323298615286,-0.8196034095086188,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,-1.7181393401935585),
(-0.8298086168179168,-0.8822407378465996,0.6064467288040396,0.09641805631402782,0.06922689629547615,-0.6726196337092204,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,-0.41456458139319413),
(1.810485056554816,1.9759849719804965,0.6064467288040396,-1.0048958960114276,-0.8196034095086188,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.8055225496112769),
(-0.4787057347204789,-0.8822407378465996,0.6064467288040396,0.341154490164129,-0.15298068015554758,-0.9693933242441344,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.11055060705963136),
(-1.925249608961923,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.6247458374230355,-0.7449194887119257,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.1115080755549154),
(-0.31017635131370874,-0.8822407378465996,0.6064467288040396,-0.14831837753607335,0.06922689629547615,-0.6980967254720785,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.9662798347405174),
(2.2318085150717417,1.9759849719804965,-1.7393483837445023,-0.5154230283112251,-0.597395833057595,0.19842147656146658,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,5.273893579545581,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0.4843871238931952),
(-0.07142639148745095,0.5468721170669484,-1.7393483837445023,0.2187862732390784,-0.15298068015554758,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.2261297448148156),
(-0.2259116596103236,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.48629204483208316,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.618604291194495),
(0.335852951745577,-0.8822407378465996,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.8984706093367187,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.205140895191983),
(-0.534882195856069,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.2640844683810594,0.19842147656146658,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.16584576289135045),
(0.5184264504362447,0.5468721170669484,0.6064467288040396,-0.6377912452362757,-0.708499621283107,-0.37860022336488575,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0.8028685378284829),
(-0.08547050677134847,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.4025382609720118,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.0009178878177193246),
(-0.4365733888687864,-0.8822407378465996,0.6064467288040396,1.3201002255645338,0.5136420491975237,-0.08526938306819591,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.2924800393846672),
(-0.1135587373391435,-0.8822407378465996,-1.7393483837445023,-0.39305481138617454,-0.597395833057595,0.10477595008177217,2.659945347654738,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1.7107081072017352),
(0.8835734478175801,0.5468721170669484,0.6064467288040396,0.2187862732390784,-0.041876891930035715,-0.9356533919095386,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.8388872691664023),
(-0.3803969277331963,-0.8822407378465996,0.6064467288040396,0.8306273578643314,0.6247458374230355,0.44010956328479556,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.029732872888054877),
(-0.4365733888687864,0.5468721170669484,0.6064467288040396,-0.39305481138617454,-0.3751882566065713,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0.2754784821332625),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.597395833057595,-0.7759051408559422,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.052162347838161954),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.3751882566065713,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-1.7645466319384147),
(0.9678381395209652,0.5468721170669484,-1.7393483837445023,-0.6377912452362757,-0.3751882566065713,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0.6250497483812806),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.7082591409392808,0.4025382609720118,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0.2114030548058058),
(-0.4787057347204789,-0.8822407378465996,0.6064467288040396,0.2187862732390784,-0.041876891930035715,-0.12245216564101576,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.05026662513616619),
(-0.6472351181272491,-0.8822407378465996,0.6064467288040396,0.9529955747893819,0.5136420491975237,-0.47500003003515945,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,-0.21854685400683257),
(0.335852951745577,0.5468721170669484,0.6064467288040396,-0.270686594461124,-0.48629204483208316,-0.47706574017809383,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.0686488606482885),
(-0.08547050677134847,0.5468721170669484,0.6064467288040396,-0.8825276790863769,-0.708499621283107,2.8191190778976205,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,-0.01570452489328625),
(-0.2118675443264261,-0.8822407378465996,-1.7393483837445023,0.2187862732390784,0.18033068452098802,0.10821880031999623,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.3728586819492874),
(-0.2259116596103236,-0.8822407378465996,0.6064467288040396,0.5858909240142302,0.06922689629547615,-0.47500003003515945,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.5602160319730256),
(0.335852951745577,-0.8822407378465996,0.6064467288040396,1.3201002255645338,0.6247458374230355,-0.47706574017809383,1.4161194154023549,-0.16638130054040892,2.082700496237388,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.8487450272167802),
(-0.6051027722755565,-0.8822407378465996,-1.7393483837445023,0.8306273578643314,0.5136420491975237,0.10821880031999623,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-0.45627048083710087),
(0.8976175631014777,0.5468721170669484,0.6064467288040396,-0.14831837753607335,-0.2640844683810594,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1.080402341400662),
(0.39202941288116705,-0.8822407378465996,0.6064467288040396,-0.39305481138617454,-0.2640844683810594,-0.6726196337092204,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,2.1207319867757395,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0.06429497313093481),
(-0.591058656991659,-0.8822407378465996,0.6064467288040396,1.809573093264736,1.2913685667761068,0.44010956328479556,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.17494523186093008),
(-1.6584114185678702,-0.8822407378465996,0.6064467288040396,2.054309527114837,2.2913026608057137,0.44010956328479556,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,2.7034174764489896,5.8759579406621105,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.14537195770979622),
(-0.2961322360298112,0.5468721170669484,-0.5664508274702313,-1.0048958960114276,-0.708499621283107,-0.12245216564101576,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0.15946025277112197),
(2.3160732067751266,1.9759849719804965,0.6064467288040396,-1.2496323298615286,-0.8196034095086188,0.32236408513753273,0.1722934831499719,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,2.967179519791585,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0.6872294530067415),
(2.3160732067751266,1.9759849719804965,0.6064467288040396,-1.2496323298615286,-0.8196034095086188,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1.1964205707628026),
(-1.0966468072119695,-0.8822407378465996,0.6064467288040396,1.3201002255645338,0.6247458374230355,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-0.177220099103325),
(-0.2259116596103236,0.5468721170669484,-1.7393483837445023,-0.7601594621613263,-0.48629204483208316,-0.12245216564101576,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-1.7071441485219832),
(-0.08547050677134847,-0.8822407378465996,-1.7393483837445023,0.4635227070891796,0.4025382609720118,-0.47500003003515945,1.4161194154023549,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,2.2516238951787364,-0.3370203903504429,2.7034174764489896,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.5264721678775011),
(0.7290881796947074,0.5468721170669484,0.6064467288040396,0.341154490164129,0.06922689629547615,0.32236408513753273,-1.071532449102411,-0.16638130054040892,-0.4801458499705562,-0.18961323070272573,-0.4441239063687494,-0.3370203903504429,-0.36990217334598513,-0.17018501665573849,-0.12353826267837224,-0.017399858365729347,-0.47153530301598945,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.7122529926730855),
(0.8695293325336826,0.5468721170669484,-1.7393483837445023,0