-- Copyright 2020 The SQLFlow Authors. All rights reserved.
-- Licensed under the Apache License, Version 2.0 (the "License");
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
-- 
-- http://www.apache.org/licenses/LICENSE-2.0
-- 
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.

CREATE TABLE IF NOT EXISTS titanic_train (
pclass_1 int,
pclass_2 int,
pclass_3 int,
sex_female  int,
sex_male    int,
embarked_c  int,
embarked_q  int,
embarked_s  int,
title_master int,
title_misc  int,
title_miss  int,
title_mr    int,
title_mrs   int,
nosibsp     int,
noparch     int,
nullcabin   int,
cabinalpha  int,
family      int,
isalone     int,
ismother      int,
age         string,
realfare    string,
survived    int
);

INSERT INTO titanic_train VALUES
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,-0.566354634,-0.53813328,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,0,1,1,0,2,0,0,0.608159848,1.554498549,1),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.272726013,-0.488381804,1),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,1,1,0,2,0,0,0.387938383,0.884390395,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.387938383,-0.479168568,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.431883952,-0.449074453,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,0,1.78267433,0.838784876,0),
(0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,5,0,0,-2.034497736,-0.761830656,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,1,0,0,0,3,0,1,-0.199318858,-0.798971054,1),
(0,1,0,1,0,1,0,0,0,0,0,0,1,0,1,0,0,2,0,0,-1.153611875,0.035696555,1),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,1,0,3,0,0,-1.887683426,-0.662204861,1),
(1,0,0,1,0,0,0,1,0,0,1,0,0,1,1,1,0,1,1,0,2.076302951,0.884390395,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.713168944,-0.479168568,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,7,0,0,0.681567004,-0.743193595,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-1.153611875,-0.493600181,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,1,1,0,0,1,1,0,1.856081486,0.106793257,1),
(0,0,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,6,0,0,-2.034497736,-0.714720308,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.179530086,-0.114324413,1),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,1,0,0,2,0,0,0.094309763,-0.409147973,0),
(0,0,1,1,0,1,0,0,0,0,0,0,1,1,1,0,0,1,1,0,-0.137718054,-0.539975927,1),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.387938383,-0.114324413,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,0,0.314531228,-0.114324413,1),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,-1.08020472,-0.48070165,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,-0.125911703,1.544058109,1),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,5,0,0,-1.594054805,-0.761830656,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,0,0,0,7,0,1,0.608159848,-0.742009036,1),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.137718054,-0.539975927,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,0,0,1,0,6,0,0,-0.786576099,2.158273858,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,-0.523986537,-0.491757534,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.138573639,-0.490534016,0),
(1,0,0,0,1,1,0,0,0,1,0,0,0,1,1,0,0,1,1,0,0.754974159,0.970685251,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,0,1,1,1,2,0,0,1.439015326,2.527314335,1),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,0.209209627,-0.501280335,1),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,2.663560192,-0.298589138,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,0,1,0,0,2,0,0,-0.125911703,1.955734987,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,0.901788469,0.843852155,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.44309617,-0.539666362,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.639761789,-0.479168568,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,1,0,0,3,0,0,-0.859983254,-0.409147973,0),
(0,0,1,1,0,1,0,0,0,0,1,0,0,0,1,0,0,2,0,0,-1.153611875,-0.65821123,1),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,1,0,0,2,0,0,0.754974159,-0.374137675,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,0,1,0,0,2,0,0,-0.199318858,-0.298589138,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.138573639,-0.490534016,0),
(0,1,0,1,0,1,0,0,0,0,1,0,0,0,0,0,0,4,0,0,-1.961090581,-0.306342997,1),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,-0.786576099,-0.491757534,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.012674552,-0.479168568,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,0,1,0,0,2,0,0,0.200706181,-0.501280335,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,0.209209627,-0.501280335,1),
(0,0,1,0,1,1,0,0,0,0,0,1,0,0,1,0,0,3,0,0,-0.476867423,-0.539872739,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,1,0,0,2,0,0,-0.859983254,-0.416518562,0),
(0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,6,0,0,-1.667461961,-0.654614909,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.639761789,-0.49759504,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,0,1,1,1,2,0,0,1.415638555,0.81263034,1),
(0,1,0,1,0,0,0,1,0,0,0,0,1,0,1,0,0,2,0,0,-0.052504548,-0.114324413,1),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,0,1,1,2,0,0,2.590153037,1.211615064,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,1.050876188,1.544058109,1),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.639761789,-0.298589138,1),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.089208125,-0.539666362,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,4,0,0,-1.814276271,-0.56116637,1),
(0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,8,0,0,-1.37383334,-0.640400202,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.566354634,-0.539666362,0),
(1,0,0,1,0,0,0,1,0,0,1,0,0,1,1,1,1,1,1,0,0.608159848,1.875734614,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,0,1,1,0,2,0,0,1.122009934,2.003798597,0),
(0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,6,0,0,-1.887683426,-0.729768594,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,0.767417337,0.970685251,0),
(0,0,1,0,1,1,0,0,1,0,0,0,0,0,0,0,0,3,0,0,-1.579092727,-0.697932563,1),
(0,1,0,1,0,0,0,1,0,0,0,0,1,1,1,1,0,1,1,0,-0.052504548,-0.298589138,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.786576099,-0.47118622,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,7,0,0,-0.933390409,-0.488381804,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,3,0,0,-0.272726013,-0.43402371,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.167716918,-0.298589138,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,8,0,0,-1.006797564,-0.640400202,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.639761789,-0.298589138,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,0,1,0,0,2,0,0,-0.272726013,-0.539821145,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.167716918,-0.55199183,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,-0.346133168,-0.508650924,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.138573639,-0.490534016,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.012674552,-0.479168568,0),
(0,1,0,0,1,0,0,1,1,0,0,0,0,1,0,0,0,3,0,0,-2.120384108,-0.360010713,1),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,0.020902607,-0.612760493,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.566354634,-0.409147973,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.052504548,-0.372295028,1),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,-0.487191244,-0.498516364,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.125911703,0.663272725,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.933390409,-0.298589138,1),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,1,0,0,4,0,0,0.241124073,-0.488381804,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,5,0,0,-1.006797564,-0.565772989,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.012674552,-0.479168568,0),
(1,0,0,1,0,0,0,1,0,0,1,0,0,0,0,1,0,6,0,0,-0.492947478,2.158273858,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.419540323,-0.479168568,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.052504548,-0.479168568,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.713168944,-0.493600181,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,0,1,1,1,2,0,0,1.195417089,1.181977925,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,4,0,0,-0.272726013,-0.69337631,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,2.149710106,-0.53813328,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.012674552,-0.479168568,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,1,0,1,1,0,3.030595968,1.481717668,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,0,1,1,2,0,0,-0.492947478,1.26243896,1),
(0,1,0,1,0,0,0,1,0,0,0,0,1,1,0,0,0,2,0,1,0.314531228,-0.224883248,1),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,0.314531228,-0.114324413,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.125911703,-0.490534016,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.138573639,-0.490534016,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,0,1,1,2,0,0,-0.639761789,1.775771001,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.241124073,-0.434635469,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,3,0,0,0.534752693,-0.488381804,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.125911703,-0.490534016,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.639761789,-0.508650924,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.2399151,-0.499437688,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.608159848,-0.490534016,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,0,1,0,0,2,0,0,0.28674925,-0.479168568,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,1.268824245,0.843852155,0),
(0,0,1,1,0,1,0,0,0,0,1,0,0,0,1,0,0,2,0,0,-1.116908297,-0.539821145,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.566354634,-0.479168568,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,1,0,0,2,0,0,-0.713168944,-0.348340613,0),
(0,0,1,1,0,1,0,0,0,0,1,0,0,1,1,0,0,1,1,0,-0.933390409,-0.539670048,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.639761789,-0.488381804,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,2.99389239,-0.501280335,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,-0.052504548,-0.298589138,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,0,1,1,2,0,0,-0.419540323,5.008745961,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,7,0,0,-2.034497736,-0.743193595,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,3,0,0,-0.639761789,-0.298589138,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.012674552,-0.479168568,0),
(0,1,0,0,1,1,0,0,0,0,0,1,0,0,1,0,0,2,0,0,0.204420495,0.035696555,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,1,1,1,1,1,0,0.204420495,-0.114324413,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,0,1,1,2,0,0,1.78267433,1.775771001,0),
(0,0,1,0,1,1,0,0,1,0,0,0,0,0,1,0,0,2,0,0,-1.300426185,-0.65821123,1),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.209209627,-0.501280335,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.419540323,-0.546115628,1),
(0,0,1,1,0,1,0,0,0,0,1,0,0,0,0,1,0,3,0,0,-0.32620137,-0.523188182,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.122009934,-0.5584024,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,0.241124073,-0.490534016,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.713168944,-0.552874458,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,1,0,0,2,0,0,1.268824245,-0.53813328,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,0,1,0,0,2,0,0,-0.052504548,-0.114324413,1),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.346133168,-0.114324413,0),
(0,1,0,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.492947478,0.036463097,0),
(1,0,0,1,0,0,0,1,0,0,1,0,0,1,0,1,1,3,0,0,-0.786576099,0.864733034,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,0,1,1,0,2,0,0,0.534752693,0.884390395,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-1.006797564,-0.732838444,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,1,1,1,1,0,-0.419540323,1.846252258,0),
(0,0,1,1,0,1,0,0,0,0,0,0,1,1,0,0,0,3,0,1,-0.429239497,-0.697932563,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.566354634,-0.501280335,1),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,1,0,0,2,0,0,-0.419540323,-0.488381804,1),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.786576099,-0.574986225,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.859983254,-0.224883248,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,3,0,0,-0.786576099,-0.395328118,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.199318858,-0.497904605,1),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,5,0,0,-1.52064765,-0.565772989,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,0,1,0,3,0,0,0.498049116,-0.433716602,0),
(0,1,0,0,1,0,0,1,0,1,0,0,0,1,1,0,0,1,1,0,0.901788469,-0.114324413,0),
(0,1,0,0,1,0,0,1,0,1,0,0,0,1,1,0,0,1,1,0,1.562452865,-0.149334711,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,1,1,0,2,0,0,-0.566354634,1.381905152,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.892785063,-0.479168568,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,0,0,0,3,0,0,0.791677736,-0.716255847,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.497222944,-0.533526662,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,2,0,0,1.562452865,1.189503297,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,-1.006797564,-0.502511223,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.020902607,-0.479168568,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.393288936,-0.43402371,0),
(0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,11,0,0,-1.172305527,-0.606478741,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,0,0,0,2,0,0,1.048602779,-0.479168568,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,1,1,0,0,1,1,0,0.754974159,-0.492067099,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.272726013,-0.499437688,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.933390409,-0.43402371,0),
(0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,6,0,0,-2.107904891,-0.654614909,0),
(0,0,1,0,1,0,0,1,1,0,0,0,0,1,0,0,0,3,0,0,-1.52064765,-0.568229852,1),
(1,0,0,1,0,0,0,1,0,0,0,0,1,1,0,1,1,2,0,1,-0.270525577,0.95441099,1),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,0,0,0,6,0,1,1.122009934,-0.729768594,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.330738045,0.838324214,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.125911703,-0.55199183,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,0,2.296524416,1.39664633,0),
(0,0,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,6,0,0,-1.887683426,-0.714720308,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,3,0,0,-2.107904891,-0.798971054,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.639761789,-0.488381804,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,1,0,1,1,0,1.929488641,1.189960273,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,3,0,0,-0.859983254,-0.493600181,0),
(0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,5,0,0,-1.23679714,-0.697091824,0),
(1,0,0,1,0,1,0,0,0,0,1,0,0,1,1,1,0,1,1,0,1.48904571,1.043779382,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.020902607,-0.114324413,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.461345538,-1.072500981,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,11,0,0,-1.172305527,-0.606478741,0),
(0,1,0,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,0.139616833,0.036772661,0),
(0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,7,0,0,-1.52064765,-0.742009036,0),
(0,1,0,0,1,0,0,1,1,0,0,0,0,0,0,1,0,4,0,0,-2.107904891,-0.353868555,1),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,0,0,0,3,0,0,-1.887683426,-0.531376907,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,1.595767566,2.612793513,0),
(0,0,1,1,0,0,1,0,0,0,0,0,1,0,1,0,0,2,0,0,0.200706181,-0.501280335,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.122009934,0.884390395,1),
(0,0,1,0,1,0,1,0,0,0,0,1,0,0,0,0,0,3,0,0,0.754974159,-0.501280335,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.461345538,-0.490534016,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,1,1,0,0,1,1,0,0.167716918,-0.114324413,1),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.786576099,-0.114324413,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,1,0,0,2,0,0,-0.786576099,-0.493600181,1),
(0,1,0,0,1,0,0,1,1,0,0,0,0,0,0,1,0,3,0,0,-1.961090581,-0.433716602,1),
(1,0,0,1,0,1,0,0,0,0,0,0,1,1,1,1,1,1,1,0,1.048602779,0.970685251,1),
(1,0,0,1,0,1,0,0,0,0,1,0,0,1,1,1,1,1,1,0,2.076302951,2.527314335,1),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.209209627,-0.501280335,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,0,0,0,2,0,0,0.901788469,-0.453061942,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,0.209209627,-0.501280335,1),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.419540323,-0.114324413,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.125911703,-0.372295028,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,11,0,0,-1.172305527,-0.606478741,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.314531228,-0.593722262,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,1.158713512,-0.539975927,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.859983254,-0.479168568,1),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,0,1,0,2,0,0,-2.034497736,-0.686927045,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,0.167716918,-0.488381804,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.272726013,-0.380126278,1),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,-1.006797564,-0.501280335,1),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,1,0,1,1,0,0.754974159,1.212381605,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.419540323,-0.552874458,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,0.387938383,-0.298589138,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.566354634,-0.53813328,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.020902607,-0.114324413,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,0,1,0,0,2,0,0,0.050860541,-0.501280335,0),
(1,0,0,1,0,1,0,0,0,0,1,0,0,0,1,1,1,2,0,0,0.094309763,1.710510577,1),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.199318858,-0.488381804,1),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,0.901788469,-0.077471468,0),
(1,0,0,1,0,1,0,0,0,0,1,0,0,1,1,1,1,1,1,0,0.167716918,1.739072838,1),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.020902607,-0.298589138,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-1.006797564,-0.479168568,1),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.199318858,-0.114324413,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.562452865,-0.479168568,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.138573639,-0.490534016,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,0,1,1,0,2,0,0,0.608159848,2.244264063,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.566354634,-0.383350911,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.786576099,-0.298589138,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.676465366,-0.53813328,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.859983254,-0.114324413,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,5,0,0,-1.23679714,-0.697091824,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,1,1,0,2,0,0,0.387938383,2.003798597,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.052504548,-0.499437688,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,2.149710106,-0.077471468,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,7,0,0,-1.814276271,-0.742009036,1),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.419540323,-0.298589138,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,0.001055352,-0.516021513,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,1.048602779,-0.114324413,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,0,0,0,3,0,0,-1.594054805,-0.427574445,1),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.786576099,-0.298589138,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.241124073,-0.167761183,0),
(0,0,1,1,0,1,0,0,0,0,1,0,0,0,1,0,0,2,0,0,-0.69157265,-0.539821145,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,0,1,0,0,2,0,0,0.200706181,-0.501280335,1),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.052504548,-0.298589138,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.566354634,-0.547346516,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,0.020902607,-0.539975927,0),
(1,0,0,0,1,0,1,0,0,1,0,0,0,0,1,1,0,3,0,0,1.048602779,1.138675715,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.346133168,-0.499437688,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,1,0,0,0,3,0,1,-0.419540323,-0.53813328,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,0,0,1,1,3,0,0,0.534752693,0.864276058,1),
(0,1,0,0,1,0,0,1,0,1,0,0,0,0,1,0,0,2,0,0,1.78267433,-0.114324413,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.050106603,-0.53813328,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,0,1,0,3,0,1,-0.052504548,-0.686927045,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,2.369931571,0.884390395,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,0.020902607,-0.479168568,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,1,0,0,0,3,0,1,0.828381314,-0.575907548,0),
(0,0,1,1,0,1,0,0,0,0,0,0,1,1,0,0,0,3,0,1,-0.052504548,-0.697932563,1),
(1,0,0,1,0,1,0,0,0,0,0,0,1,1,1,0,0,1,1,0,0.654149897,1.846252258,1),
(1,0,0,1,0,0,0,1,0,0,1,0,0,1,1,1,1,1,1,0,0.020902607,1.05268551,1),
(1,0,0,1,0,1,0,0,0,0,1,0,0,1,1,0,0,1,1,0,0.387938383,8.367918918,1),
(0,1,0,1,0,0,0,1,0,0,0,0,1,1,0,0,0,2,0,1,1.48904571,-0.114324413,1),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.209209627,-0.501280335,0),
(0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,7,0,0,-1.961090581,-0.742009036,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,0,0,1,1,3,0,0,1.63586002,0.884390395,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,0,0.754974159,-1.072500981,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,0.209209627,-0.501280335,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.461345538,-0.298589138,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,6,0,0,-1.006797564,-0.654614909,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,-0.346133168,-0.499437688,1),
(1,0,0,1,0,0,0,1,0,0,0,0,1,1,0,1,0,2,0,1,2.076302951,2.697862394,1),
(1,0,0,1,0,0,0,1,0,0,1,0,0,1,1,1,0,1,1,0,0.387938383,1.426742287,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.535373377,0.069940312,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.346133168,-1.072500981,1),
(0,1,0,1,0,0,0,1,0,0,0,0,1,1,0,0,0,2,0,1,0.828381314,-0.353868555,1),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,0,1,0,2,0,0,0.534752693,1.116563948,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,0.209209627,-0.501280335,1),
(1,0,0,1,0,0,0,1,0,0,1,0,0,0,1,1,1,2,0,0,2.443338727,0.842827644,1),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,1.122009934,-0.501280335,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.336519033,-1.072500981,0),
(0,0,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,6,0,0,-1.667461961,-0.714720308,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,0,0,0,3,0,1,0.387938383,-0.574986225,1),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,2.590153037,-0.501280335,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.125911703,-0.493600181,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-1.006797564,-0.372295028,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.786576099,-0.479168568,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,1.057651806,0.843852155,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,0.241124073,-0.43402371,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.020902607,-0.372295028,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.566354634,-0.490534016,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.901788469,-0.114324413,1),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,-0.566354634,-0.501280335,1),
(1,0,0,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.272726013,0.864735491,1),
(1,0,0,1,0,1,0,0,0,0,0,0,1,0,1,1,1,2,0,0,-0.786576099,2.284035761,1),
(0,1,0,0,1,1,0,0,0,0,0,1,0,1,1,1,1,1,1,0,0.461345538,-0.123537649,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.419540323,-0.420203856,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.419540323,-0.490534016,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,0.767417337,0.970685251,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.456243901,-0.539666362,0),
(1,0,0,1,0,0,0,1,0,0,1,0,0,0,0,1,0,4,0,0,-2.034497736,0.789186954,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,0.852653438,1.17552866,1),
(1,0,0,1,0,1,0,0,0,0,0,0,1,1,0,1,1,2,0,1,1.48904571,5.008745961,1),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,0.209209627,-0.501280335,1),
(0,0,1,0,1,0,1,0,0,0,0,1,0,0,1,0,0,3,0,0,-0.48919965,-0.501280335,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.786576099,-1.072500981,0),
(0,1,0,1,0,0,1,0,0,0,1,0,0,1,1,1,1,1,1,0,1.164945841,-0.162233241,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.012674552,-0.479168568,0),
(1,0,0,0,1,0,0,1,1,0,0,0,0,0,0,1,0,4,0,0,-2.113777464,0.789186954,1),
(1,0,0,1,0,1,0,0,0,0,1,0,0,1,1,0,0,1,1,0,0.321053847,0.970687093,1),
(1,0,0,1,0,1,0,0,0,0,0,0,1,0,1,1,0,2,0,0,-0.933390409,1.603022821,1),
(0,1,0,0,1,1,0,0,0,0,0,1,0,0,1,0,0,2,0,0,0.020902607,-0.188030303,0),
(1,0,0,1,0,1,0,0,0,0,1,0,0,1,1,1,1,1,1,0,0.020902607,1.025507692,1),
(1,0,0,1,0,1,0,0,0,0,1,0,0,1,1,1,0,1,1,0,-0.419540323,0.970584519,1),
(1,0,0,1,0,1,0,0,0,0,1,0,0,0,0,1,1,5,0,0,-0.859983254,1.690153712,1),
(0,1,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,3,0,1,-0.272726013,-0.114324413,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.125911703,-0.490534016,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,3,0,0,0.975195624,-0.427574445,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.272726013,-0.493600181,1),
(0,1,0,1,0,0,0,1,0,0,0,0,1,0,1,0,0,2,0,0,-0.419540323,-0.114324413,1),
(0,1,0,0,1,0,0,1,0,1,0,0,0,1,1,0,0,1,1,0,1.78267433,-0.040618523,0),
(1,0,0,1,0,0,0,1,0,0,1,0,0,1,0,1,0,3,0,0,0.094309763,1.965410727,1),
(1,0,0,1,0,1,0,0,0,0,0,0,1,0,0,1,1,3,0,1,0.754974159,0.910187456,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.566354634,-0.53813328,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.199318858,-0.490534016,0),
(0,1,0,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,0.020902607,-0.162233241,1),
(0,1,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,3,0,1,-0.566354634,-0.360010713,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,11,0,0,-1.172305527,-0.606478741,0),
(1,0,0,1,0,1,0,0,0,0,1,0,0,1,1,1,0,1,1,0,0.461345538,1.426742287,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,2.296524416,-0.612760493,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,1,1,1,1,1,1,0,0.461345538,-0.114324413,1),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,0,0,0,3,0,1,0.094309763,-0.568229852,1),
(1,0,0,1,0,1,0,0,0,0,1,0,0,1,0,1,1,2,0,0,-1.006797564,1.064203284,1),
(0,0,1,1,0,0,1,0,0,0,1,0,0,0,1,0,0,3,0,0,-0.48919965,-0.501280335,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,1.158713512,1.02811688,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,0,1,0,2,0,0,0.608159848,2.697862394,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,3,0,0,-1.006797564,-0.409147973,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,1,0,0,2,0,0,0.153556415,3.85289511,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.138573639,-0.490534016,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,0,1,1,0,2,0,0,-0.052504548,1.381905152,0),
(1,0,0,1,0,1,0,0,0,0,1,0,0,1,1,1,1,1,1,0,0.828381314,0.910187456,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.122009934,-0.479168568,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,1.122009934,1.544058109,0),
(0,1,0,0,1,0,0,1,1,0,0,0,0,0,0,1,0,3,0,0,-2.034497736,-0.433716602,1),
(1,0,0,1,0,0,0,1,0,0,1,0,0,0,0,1,0,6,0,0,-0.419540323,2.158273858,1),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.125911703,-0.114324413,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.346133168,-0.114324413,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.461345538,-0.114324413,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,1,1,0,1,1,0,-0.419540323,-0.114324413,1),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,0.754974159,-0.114324413,1),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,1,0,0,2,0,0,-0.360570889,-0.479168568,1),
(0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,3,0,0,-1.961090581,-0.681859765,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.901788469,-0.43402371,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.492947478,-0.392564147,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,2.267257582,1.507205164,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,0,0,0,0,3,0,0,-1.08020472,-0.539666362,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,-0.346133168,-0.416518562,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.137718054,-0.539975927,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.125911703,-0.372295028,0),
(1,0,0,1,0,0,0,1,0,0,1,0,0,1,0,1,1,2,0,0,-0.566354634,0.95441099,1),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,0.608159848,-0.114324413,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,-0.523986537,-0.491757534,1),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,-0.523986537,-0.491757534,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,6,0,0,0.754974159,-0.729768594,0),
(0,1,0,0,1,1,0,0,0,0,0,1,0,0,1,0,0,2,0,0,-0.052504548,-0.050907865,0),
(0,0,1,1,0,1,0,0,0,0,0,0,1,1,0,0,0,2,0,1,1.122009934,-0.539821145,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.387938383,-0.552874458,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,0,1,0,0,2,0,0,0.200706181,-0.501280335,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.020902607,-0.53813328,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,0,1,1,1,2,0,0,2.223117261,1.700683125,1),
(0,0,1,1,0,1,0,0,0,0,0,0,1,1,1,0,0,1,1,0,-0.44309617,-0.539666362,1),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,0.209209627,-0.501280335,1),
(1,0,0,1,0,1,0,0,0,0,0,0,1,1,1,1,1,1,1,0,-0.419540323,1.481408103,1),
(1,0,0,0,1,1,0,0,0,0,0,1,0,0,1,1,1,2,0,0,-0.346133168,0.970688936,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,-0.859983254,-0.593722262,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.786576099,-0.479168568,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.566354634,1.426742287,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,5,0,0,-1.961090581,-0.761830656,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,0,1,0,0,2,0,0,-0.16497334,1.955734987,1),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.566354634,-0.53813328,1),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,0,1,0,3,0,0,-0.199318858,2.04525816,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.713168944,-0.776756098,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.786576099,-0.499437688,0),
(1,0,0,1,0,1,0,0,0,0,1,0,0,1,1,0,0,1,1,0,0.901788469,2.281485538,1),
(0,0,1,1,0,1,0,0,0,0,1,0,0,1,0,0,0,3,0,0,-2.107904891,-0.685748979,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.167716918,-0.488381804,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,1,0,0,2,0,0,0.387938383,0.843852155,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.138573639,-0.490534016,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.859983254,-0.298589138,0),
(0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,8,0,0,-2.107904891,-0.640400202,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,0.461345538,-0.114324413,1),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.612627695,-0.502813417,0),
(0,1,0,1,0,1,0,0,0,0,1,0,0,1,1,0,0,1,1,0,-0.933390409,-0.188030303,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,0,0,1,1,4,0,0,0.461345538,1.138675715,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.639761789,-0.497904605,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,3,0,0,-0.125911703,-0.488381804,0),
(1,0,0,1,0,1,0,0,0,0,1,0,0,0,1,1,1,2,0,0,-0.492947478,1.710510577,1),
(0,0,1,1,0,0,0,1,0,0,0,0,1,1,0,1,0,3,0,1,-0.419540323,-0.662204861,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.566354634,-0.497904605,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,0.094309763,-0.493600181,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.195417089,-0.114324413,0),
(0,1,0,0,1,0,0,1,0,1,0,0,0,1,1,0,0,1,1,0,-0.492947478,-0.298589138,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,1,1,0,0,1,1,0,-0.125911703,-0.140121474,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.681567004,-0.488381804,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.272726013,-0.479168568,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,1,0,0,2,0,0,-0.639761789,-0.348340613,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,-0.125911703,-0.488381804,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.713168944,-0.43402371,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,0.314531228,-0.298589138,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.562452865,-0.501280335,0),
(0,1,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,3,0,0,-1.961090581,-0.61183917,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.639761789,-0.499437688,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,5,0,0,-1.23679714,-0.697091824,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.138573639,-0.490534016,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.225800391,-0.567003877,0),
(1,0,0,1,0,0,1,0,0,0,1,0,0,0,1,1,0,2,0,0,0.241124073,1.138675715,1),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.336519033,-1.072500981,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.048602779,-0.488381804,1),
(0,0,1,1,0,0,0,1,0,0,0,0,1,1,1,0,0,1,1,0,-0.012674552,-0.479168568,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,3,0,1,0.314531228,-0.274020508,1),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,0,0,0,3,0,0,-0.859983254,-0.114324413,1),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.020902607,-0.114324413,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,0,0,0,3,0,0,-1.447240495,-0.479168568,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.138573639,-0.490534016,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.639761789,-0.502511223,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.052504548,-0.492067099,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,0,0,0,3,0,1,-0.125911703,-0.71871271,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,3,0,0,-0.859983254,-0.575907548,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.050106603,-0.53813328,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,0,1,0,0,2,0,0,-0.125911703,-0.114324413,1),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.786576099,-0.114324413,1),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.209209627,-0.501280335,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,0,0.167716918,-0.479168568,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,-0.125911703,0.884390395,1),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,1,0,0,2,0,0,-0.360570889,-0.479168568,1),
(0,1,0,1,0,0,0,1,0,0,0,0,1,0,1,0,0,2,0,0,0.901788469,-0.114324413,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.933390409,-0.547346516,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,0,1,1,1,2,0,0,1.48904571,0.987578641,0),
(1,0,0,1,0,0,0,1,0,0,1,0,0,0,0,1,1,4,0,0,-1.153611875,1.138675715,1),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,5,0,0,-0.639761789,-0.565772989,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,6,0,1,-0.419540323,-0.61183917,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,0,0,1,0,6,0,0,2.516745882,2.158273858,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.094309763,-0.298589138,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,3,0,1,1.122009934,-0.427574445,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.713168944,-0.372295028,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,-0.346133168,-0.499437688,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.125911703,-0.114324413,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.505714677,-0.47456195,1),
(1,0,0,0,1,0,0,1,1,0,0,0,0,1,0,1,0,3,0,0,-1.887683426,0.9386453,1),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,0,0,0,2,0,0,-1.22701903,-0.353868555,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.314531228,0.884390395,1),
(0,0,1,1,0,1,0,0,0,0,1,0,0,0,0,0,0,4,0,0,-1.814276271,-0.717638447,1),
(1,0,0,0,1,0,0,1,0,1,0,0,0,1,1,1,0,1,1,0,1.63586002,1.17552866,1),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,4,0,0,0.461345538,-0.56116637,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,-0.42908902,0.39916241,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,1,0,1,1,0,0.020902607,0.972837463,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,0,1,1,0,2,0,0,1.415638555,2.211251195,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.012674552,-0.479168568,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.052504548,-0.490534016,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,0,2.590153037,0.884390395,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,1,1,1,2,0,0,0.898073776,0.838784876,1),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,1.48904571,-0.298589138,1),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.209209627,-0.501280335,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,0,1.3422314,0.884390395,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.314531228,-0.479168568,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,0,1.268824245,1.765175779,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.3422314,-0.114324413,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.012674552,-0.479168568,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.608159848,-0.552874458,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.336519033,-1.072500981,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.929488641,0.884390395,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.581870076,-0.503122982,0),
(0,0,1,1,0,1,0,0,0,0,1,0,0,0,0,0,0,4,0,0,-2.12625668,-0.717638447,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.050106603,-0.53813328,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.608159848,-0.43402371,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,4,0,1,0.241124073,-0.56116637,1),
(0,1,0,1,0,1,0,0,0,0,0,0,1,1,1,1,1,1,1,0,-0.492947478,-0.05597146,1),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.566354634,-0.34741929,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,1.169145717,0.843852155,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,0.314531228,-0.298589138,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,-0.052504548,-0.553184023,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.566354634,-0.518173725,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,0,0,0,2,0,0,-2.034497736,-0.619670421,1),
(0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,8,0,0,-1.52064765,-0.640400202,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.336519033,-1.072500981,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.48904571,-0.479168568,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,1,1,0,0,1,1,0,2.443338727,-0.365845762,1),
(1,0,0,0,1,1,0,0,0,0,0,1,0,0,1,1,1,2,0,0,-0.346133168,2.284035761,1),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,5,0,0,-1.23679714,-0.697091824,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,1,1,0,2,0,0,0.387938383,2.244264063,1),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,1,1,1,1,0,2.076302951,1.116563948,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.020902607,-0.479168568,0),
(0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,3,0,0,-1.52064765,-0.681859765,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,-0.42908902,0.39916241,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.639761789,-0.53813328,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,1.856081486,1.17552866,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,3.030595968,2.576250132,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.639761789,-0.479168568,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.825068236,-0.539670048,0),
(1,0,0,1,0,1,0,0,0,0,1,0,0,0,1,1,1,2,0,0,1.78267433,1.811857404,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.413047038,-0.516021513,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,4,0,1,-0.346133168,0.789186954,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.419540323,-0.497904605,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.933390409,-0.43402371,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,-0.639761789,-0.501280335,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,-0.128698038,-0.510184006,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,0.534752693,-0.365845762,0),
(1,0,0,1,0,0,0,1,0,0,1,0,0,1,1,1,1,1,1,0,-1.006797564,1.05268551,1),
(1,0,0,0,1,1,0,0,0,0,0,1,0,0,1,1,0,2,0,0,-0.859983254,1.603022821,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,1,0,0,0,3,0,1,0.241124073,-0.433716602,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.210668351,0.884390395,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.125911703,-0.519092592,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.272726013,-0.55199183,1),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.052504548,-0.501280335,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.012674552,-0.479168568,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,0,0.461345538,0.865042599,1),
(1,0,0,1,0,1,0,0,0,0,0,0,1,0,1,0,0,2,0,0,1.78267433,1.116563948,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.419540323,-0.520016372,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,0,1.268824245,1.435032357,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,1,1,1,0,1,1,0,0.314531228,-0.298589138,1),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.378151083,-0.479168568,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,0,1,0,0,2,0,0,0.461345538,-0.114324413,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.167716918,-0.490534016,0),
(1,0,0,1,0,0,0,1,0,0,1,0,0,1,1,1,1,1,1,0,0.020902607,0.650374194,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.566354634,-0.490534016,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.137718054,-0.539975927,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,1,0,1,1,2,0,1,1.048602779,1.064203284,1),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.44309617,-0.539666362,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.791677736,-0.501280335,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,1.48904571,-0.298589138,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,0.400276116,3.014107342,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.681567004,-0.488381804,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,4,0,0,-0.492947478,-0.224883248,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,3,0,0,-2.034497736,-0.433716602,1),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.44309617,-0.539666362,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,0,0,0,0,3,0,0,-0.933390409,-0.539666362,0),
(0,0,1,1,0,1,0,0,0,0,0,0,1,1,0,0,0,3,0,0,-1.525246787,-0.523188182,1),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,0.020902607,-0.43402371,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,0,0,0,3,0,0,-1.667461961,-0.427574445,1),
(1,0,0,0,1,0,0,1,0,1,0,0,0,1,1,1,1,1,1,0,1.122009934,0.884390395,0),
(1,0,0,1,0,1,0,0,0,0,1,0,0,1,1,0,0,1,1,0,0.020902607,1.542215462,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.188023813,-0.53813328,0),
(1,0,0,1,0,1,0,0,0,0,1,0,0,1,0,1,1,3,0,0,-0.566354634,2.575940568,1),
(1,0,0,1,0,0,0,1,0,0,1,0,0,1,0,1,1,3,0,0,0.461345538,1.544058109,1),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,7,0,0,-1.52064765,-0.743193595,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,7,0,0,-1.37383334,-0.743193595,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,0.167716918,-0.114324413,1),
(1,0,0,0,1,1,0,0,0,0,0,1,0,0,1,1,0,2,0,0,1.48904571,1.542215462,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,2.516745882,0.843852155,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,0,1,0,0,2,0,0,-0.786576099,-0.114324413,1),
(0,1,0,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.469774908,-0.050753083,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,3,0,0,0.241124073,-0.568229852,0),
(0,1,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,3,0,0,-1.594054805,-0.395328118,1),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,0,1,0,3,0,0,-0.933390409,0.970687093,1),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.199318858,-0.114324413,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.133203377,-0.495442828,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.566354634,-0.539975927,1),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.566354634,-0.499437688,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,2.369931571,0.884390395,0),
(1,0,0,1,0,1,0,0,0,1,0,0,0,0,1,1,0,2,0,0,1.3422314,1.846252258,1),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,0.659484733,2.281485538,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,1,3,0,1,0.681567004,0.884390395,1),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,1,0,0,2,0,0,0.461345538,-0.431259739,1),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.209209627,-0.501280335,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.754974159,-0.490534016,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.125911703,-0.077471468,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.012674552,-0.479168568,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.012674552,-0.479168568,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,3,0,0,-0.419540323,-0.479168568,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.786576099,-0.490534016,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,1,0,0,0,5,0,1,-0.052504548,-0.761830656,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.44309617,-0.539666362,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.167716918,-0.493600181,1),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,2.369931571,-0.298589138,1),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,1,1,0,3,0,0,1.709267175,0.824659142,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,0,0.461345538,0.872413188,1),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,0.209209627,-0.501280335,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-1.006797564,-0.479168568,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.786576099,-0.53813328,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,0.314531228,-0.114324413,1),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,1,1,1,2,0,0,0.681567004,0.987578641,1),
(0,0,1,1,0,1,0,0,0,0,0,0,1,0,1,0,0,2,0,0,-0.748075905,-0.539670048,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.167716918,-0.488381804,1),
(0,1,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,3,0,0,-0.346133168,0.033087367,1),
(1,0,0,1,0,1,0,0,0,0,0,0,1,0,0,1,0,3,0,1,0.681567004,0.970687093,1),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.78267433,-0.114324413,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,1,0,1,1,0,0.461345538,1.88494785,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.090486069,-0.430338416,0),
(1,0,0,1,0,0,0,1,0,0,1,0,0,1,0,1,1,3,0,0,-0.859983254,0.884390395,1),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.268824245,0.033087367,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,0,0,1,1,3,0,0,2.223117261,1.846252258,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.566354634,-0.479168568,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.012674552,-0.479168568,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.387938383,-0.547346516,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,0,1,1,1,2,0,0,1.63586002,1.811857404,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.268824245,-0.53813328,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,0,0,0,3,0,0,0.407724509,-0.501280335,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,0.534752693,-0.114324413,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,3,0,0,0.461345538,-0.479168568,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.265983212,-0.261736193,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.415638555,-1.072500981,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.137718054,-0.539975927,0),
(1,0,0,0,1,1,0,0,0,1,0,0,0,0,1,1,0,2,0,0,1.415638555,1.025507692,1),
(0,1,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,4,0,1,-0.419540323,-0.077471468,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.138573639,-0.490534016,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.078076364,0.490063884,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.048602779,-0.479168568,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,0.387938383,0.884390395,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,0.461345538,-0.499437688,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.020902607,-0.490534016,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.199318858,1.17552866,1),
(0,1,0,1,0,1,0,0,0,0,0,0,1,0,0,0,0,4,0,1,-0.566354634,-0.306342997,1),
(1,0,0,1,0,0,0,1,0,0,1,0,0,1,1,1,0,1,1,0,0.754974159,2.697862394,1),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,0,0,0,7,0,1,0.681567004,-0.743193595,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.185057028,-0.552874458,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,0,1,0,0,2,0,0,0.200706181,-0.501280335,1),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.209209627,-0.501280335,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.387938383,-0.479168568,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,4,0,0,-0.419540323,-0.114324413,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,3,0,0,0.314531228,-0.71871271,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,1,0,0,2,0,0,-0.272726013,-0.479168568,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,0,0,1,0,4,0,0,-1.887683426,-0.353868555,1),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.272726013,-0.298589138,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,0,1,0,0,2,0,0,-0.199318858,-0.539821145,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,0,1,1,1,2,0,0,0.901788469,0.864276058,1),
(0,0,1,0,1,1,0,0,0,0,0,1,0,0,0,0,0,3,0,0,-0.713168944,-0.685748979,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.639761789,-0.493600181,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.639761789,-0.479168568,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,0,2.296524416,1.309732344,0),
(0,1,0,0,1,0,1,0,0,1,0,0,0,1,1,0,0,1,1,0,2.002895796,-0.162233241,0),
(1,0,0,1,0,0,0,1,0,0,1,0,0,1,1,1,1,1,1,0,-0.639761789,0.842827644,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.272726013,-0.490534016,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.612627695,-0.502511223,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,3.691260364,1.138675715,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.562452865,-0.552564893,0),
(1,0,0,0,1,1,0,0,0,1,0,0,0,1,1,1,1,1,1,0,0.167716918,1.17552866,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.859814162,-1.072500981,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,6,0,0,-1.52064765,-0.729768594,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.125911703,-0.114324413,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.167716918,-0.488381804,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,3,0,0,0.094309763,-0.427574445,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,1,0,0,0,6,0,1,0.828381314,-0.654614909,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,-0.360570889,-0.479168568,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.713168944,-0.493600181,0),
(1,0,0,1,0,1,0,0,0,0,1,0,0,1,1,1,1,1,1,0,-0.419540323,1.481408103,1),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,6,0,0,-2.034497736,-0.729768594,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.013639389,-0.55199183,1),
(0,0,1,1,0,1,0,0,0,0,1,0,0,0,0,0,0,4,0,0,-2.12625668,-0.717638447,1),
(1,0,0,0,1,1,0,0,0,0,0,1,0,0,1,1,1,2,0,0,1.3422314,0.81263034,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.786576099,-0.490534016,0),
(1,0,0,0,1,1,0,0,0,1,0,0,0,1,1,1,0,1,1,0,1.929488641,1.544058109,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.001055352,-0.516021513,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.492947478,-0.516021513,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.138573639,-0.490534016,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,0,0,0,2,0,0,-0.859983254,-0.224883248,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.639761789,-0.4509171,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,0.133203377,-0.495442828,1),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,-0.859983254,-0.574986225,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,3,0,0,-0.419540323,-0.298589138,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.138573639,-0.490534016,0),
(0,0,1,1,0,0,1,0,0,0,0,0,1,0,0,0,0,3,0,1,0.167716918,-0.501280335,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.492947478,-0.114324413,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,0,1,1,3,0,0,2.076302951,1.710510577,0),
(1,0,0,0,1,0,0,1,0,1,0,0,0,0,1,0,0,3,0,0,1.48904571,3.85289511,1),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,0.754974159,-0.539975927,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,0,1.268824245,0.813448476,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.461345538,-0.520016372,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,-0.713168944,-0.488381804,1),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,3,0,0,0.167716918,-0.298589138,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.346133168,-0.114324413,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.2399151,-0.499437688,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.975195624,-0.479168568,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,1,1,0,2,0,0,0.6750975,0.843852155,1),
(0,1,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,3,0,1,0.754974159,-0.114324413,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,0,1,1,1,2,0,0,0.094309763,0.843852155,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,2.957188813,-0.298589138,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.094309763,-0.114324413,1),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.336519033,-1.072500981,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.859983254,-0.499437688,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.382836746,-0.479168568,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.859983254,-0.347109725,1),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,0,0,0,8,0,1,0.975195624,-0.640400202,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,0,1,1,2,0,0,0.461345538,8.367918918,1),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,-0.505714677,-0.472719303,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,1,1,1,1,0,-0.199318858,0.81263034,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.713168944,-0.392564147,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,8,0,0,-1.153611875,-0.640400202,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,3,0,0,2.223117261,-0.114324413,0),
(0,1,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,4,0,0,-0.346133168,-0.306342997,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,6,0,0,-1.153611875,-0.654614909,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.786576099,-0.322853117,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.859983254,-0.497904605,0),
(1,0,0,1,0,0,0,1,0,0,1,0,0,1,0,1,1,2,0,0,-1.08020472,2.821703644,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,0,1,1,1,2,0,0,0.094309763,1.02811688,1),
(0,0,1,1,0,1,0,0,0,0,1,0,0,1,0,0,0,2,0,0,-1.887683426,-0.578056075,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.013639389,-0.55199183,1),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.346133168,-0.539975927,0),
(1,0,0,0,1,0,0,1,0,1,0,0,0,1,1,0,0,1,1,0,2.223117261,0.884390395,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.63586002,-0.077471468,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.048602779,-0.479168568,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,-0.612627695,-0.502511223,1),
(1,0,0,0,1,1,0,0,0,0,0,1,0,0,0,1,0,3,0,0,1.415638555,0.970687093,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,0.901788469,-0.508650924,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,0,1,1,0,2,0,0,-0.859983254,2.281485538,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,0,0.387938383,0.865042599,1),
(0,0,1,1,0,1,0,0,0,0,1,0,0,1,0,0,0,2,0,0,-0.859983254,-0.539821145,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.346133168,-0.501892094,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,-0.272726013,-0.493600181,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.681567004,-0.114324413,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,1,1,0,0,1,1,0,1.122009934,-0.077471468,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,0,0.901788469,0.865042599,1),
(1,0,0,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.566354634,0.789186954,1),
(0,0,1,0,1,1,0,0,1,0,0,0,0,0,0,0,0,3,0,0,-1.579092727,-0.697932563,1),
(1,0,0,1,0,1,0,0,0,0,1,0,0,1,1,1,0,1,1,0,-0.419540323,2.576250132,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,1.210668351,0.884390395,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,0,1,1,0,2,0,0,1.3422314,0.843852155,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.052504548,-0.373525916,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.63586002,-0.593412697,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,-0.786576099,-0.508650924,0),
(1,0,0,1,0,1,0,0,0,0,1,0,0,1,1,1,0,1,1,0,0.608159848,2.281485538,1),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,1,1,1,1,1,0,-0.199318858,-0.298589138,1),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.138900342,-0.501280335,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.241124073,-0.499437688,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,0,0,0,2,0,0,-1.740869116,-0.261736193,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,-0.933390409,-0.552564893,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.314531228,-0.114324413,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.48904571,-0.114324413,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,0,1,1,1,2,0,0,-0.199318858,0.884390395,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.713168944,-0.43402371,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,0,1,0,0,4,0,0,0.020902607,-0.298589138,1),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,-0.608619233,-0.502201659,1),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,-0.346133168,-0.114324413,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,1,0,0,2,0,0,-0.346133168,-0.488381804,0),
(1,0,0,1,0,0,0,1,0,0,1,0,0,1,1,1,1,1,1,0,-0.052504548,2.821703644,1),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-1.37383334,-0.380126278,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.336519033,-1.072500981,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.492947478,-0.114324413,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.492947478,-0.114324413,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.089208125,-0.479168568,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,0,0,0,5,0,1,1.3422314,-0.565772989,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,1,1,1,1,0,0.387938383,8.367918918,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.138573639,-0.490534016,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.138573639,-0.490534016,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,0,0.656369878,1.138675715,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,0,1,1,0,2,0,0,0.461345538,0.864735491,0),
(1,0,0,1,0,1,0,0,0,0,1,0,0,0,0,1,1,5,0,0,-0.639761789,1.690153712,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,-0.419540323,-0.479168568,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.094309763,-0.488381804,1),
(1,0,0,0,1,0,0,1,0,1,0,0,0,0,0,1,1,3,0,0,2.957188813,1.544058109,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,3,0,0,-1.006797564,-0.574986225,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,0.020902607,-0.114324413,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,0,1,1,1,2,0,0,-0.786576099,0.884390395,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.094309763,-0.501280335,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,3,0,0,-1.887683426,-0.507422492,1),
(0,0,1,0,1,0,0,1,1,0,0,0,0,1,0,1,1,2,0,0,-1.740869116,-0.612760493,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.241124073,-0.372295028,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.492947478,-0.490534016,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,4,0,1,1.3422314,-0.114324413,1),
(0,1,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,3,0,0,-2.132129253,-0.53813328,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.125911703,-0.497904605,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.859983254,-0.224883248,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.314531228,-0.479168568,0),
(1,0,0,1,0,0,0,1,0,1,0,0,0,1,1,1,1,1,1,0,0.241124073,1.05268551,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.188023813,-0.53813328,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.828381314,-0.547346516,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.713168944,-0.539666362,1),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,1,4,0,1,0.461345538,1.138675715,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-1.006797564,-0.499437688,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,1,1,1,2,0,0,1.562452865,0.842827644,1),
(1,0,0,0,1,1,0,0,0,1,0,0,0,1,1,0,0,1,1,0,0.832722036,1.846252258,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,0.057606185,-0.501280335,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,0,1,0,0,2,0,0,0.28674925,-0.479168568,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.167716918,-0.456135477,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.419540323,-0.372295028,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.3422314,-0.493600181,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,1,1,1,1,1,1,0,2.002895796,-0.68554506,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.137718054,-0.539975927,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,5,0,1,1.78267433,-0.224883248,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.859983254,-0.501280335,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,1,0,1,1,0,0.209209627,-0.501280335,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-1.814276271,-0.612760493,1),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.608619233,-0.502201659,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,1,0,1,1,2,0,1,0.975195624,2.821703644,1),
(0,0,1,1,0,1,0,0,0,0,1,0,0,1,1,0,0,1,1,0,-1.22701903,-0.539666362,1),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,1,1,1,2,0,0,-0.933390409,1.02811688,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,0,-0.052504548,1.138675715,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,4,0,0,-0.888252808,-0.640400202,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.346133168,-0.552874458,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.346133168,-0.53813328,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.859983254,-0.520016372,1),
(0,0,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,6,0,0,-1.594054805,-0.714720308,0),
(0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,4,0,0,-2.107904891,-0.69337631,1),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,1,1,1,1,0,1.195417089,1.846252258,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.209209627,-0.501280335,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-1.006797564,-0.114324413,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,11,0,0,-1.172305527,-0.606478741,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,1.517725019,1.189960273,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.346133168,-0.490534016,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.681567004,-0.114324413,0),
(1,0,0,1,0,0,0,1,0,1,0,0,0,1,1,1,1,1,1,0,1.415638555,0.838633778,1),
(0,0,1,1,0,0,0,1,0,0,0,0,1,1,1,0,0,1,1,0,0.094309763,-0.432490628,1),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,0.020902607,-0.539666362,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,0,0,0,3,0,1,0.020902607,-0.479168568,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.314531228,-0.593412697,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,3,0,1,0.094309763,-0.427574445,1),
(1,0,0,0,1,0,0,1,1,0,0,0,0,0,0,1,1,4,0,0,-1.37383334,1.138675715,1),
(0,0,1,0,1,1,0,0,1,0,0,0,0,1,0,0,0,2,0,0,-2.150481041,-0.758635505,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.199318858,-0.5584024,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.094309763,-0.499437688,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,0.681567004,-1.072500981,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.859983254,-0.499437688,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.681567004,-0.114324413,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,1,1,1,2,0,0,0.241124073,0.884390395,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.272726013,-0.491145775,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.681567004,-0.479168568,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.387938383,-0.298589138,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,7,0,0,-1.740869116,-0.743193595,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.057606185,-0.479168568,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,0,0.859814162,-1.072500981,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.492947478,-0.488381804,0),
(0,1,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,3,0,0,0.094309763,-0.163358485,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.975195624,-0.597097992,0),
(0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,6,0,0,-1.447240495,-0.729768594,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,1,3,0,1,1.63586002,0.650374194,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.199318858,-0.43402371,1),
(1,0,0,0,1,0,0,1,0,1,0,0,0,1,1,0,0,1,1,0,0.608159848,-1.072500981,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,1,0,1,1,2,0,1,-0.199318858,-0.612760493,1),
(0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,6,0,0,-2.034497736,-0.654614909,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.167332401,-0.560245047,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.013639389,-0.55199183,0),
(0,1,0,0,1,1,0,0,1,0,0,0,0,1,0,0,0,3,0,0,-2.107904891,-0.163358485,1),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.209209627,-0.501280335,1),
(1,0,0,1,0,0,0,1,0,0,0,0,1,1,1,1,1,1,1,0,2.369931571,1.875734614,1),
(0,0,1,1,0,1,0,0,0,0,0,0,1,0,1,0,0,2,0,0,-1.08020472,-0.539821145,1),
(0,1,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,3,0,0,-2.120384108,-0.61183917,1),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.44309617,-0.539666362,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.492947478,-0.493600181,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.859983254,-0.460742095,0),
(1,0,0,1,0,1,0,0,0,0,1,0,0,0,0,1,1,3,0,0,0.681567004,0.970584519,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.639761789,-0.43402371,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.012674552,-0.479168568,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.167716918,-0.55199183,1),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,1,0,1,1,0,1.266644868,1.116563948,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.713168944,-0.488381804,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-1.006797564,-0.68554506,0),
(1,0,0,1,0,1,0,0,0,0,1,0,0,1,1,0,0,1,1,0,0.020902607,0.069940312,1),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,0.351234805,-0.598019315,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.933390409,-0.43402371,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.901788469,-0.516021513,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,11,0,0,-1.172305527,-0.606478741,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,0.387938383,-0.490534016,0),
(0,1,0,0,1,0,0,1,0,1,0,0,0,1,0,0,0,2,0,0,-0.125911703,-0.261736193,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,0,1,1,0,2,0,0,1.049461215,2.211251195,1),
(0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,7,0,0,-1.887683426,-0.743193595,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,3.250817433,-0.499437688,0),
(0,0,1,1,0,1,0,0,0,0,1,0,0,0,0,0,0,3,0,0,-1.52064765,-0.697932563,0),
(1,0,0,1,0,0,0,1,0,0,1,0,0,1,0,1,1,2,0,0,-1.006797564,0.379505049,1),
(0,1,0,1,0,0,0,1,0,0,0,0,1,0,1,0,0,2,0,0,1.048602779,-0.114324413,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,1,0,0,0,2,0,1,-0.859983254,-0.727925946,1),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,3,0,1,1.122009934,1.965410727,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,0,1.562452865,0.884390395,1),
(0,0,1,1,0,1,0,0,0,0,0,0,1,1,0,0,0,4,0,1,-0.419540323,-0.717638447,1),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.44309617,-0.539666362,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,3,0,0,0.828381314,-0.552568578,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,-0.639761789,-0.224883248,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,1,1,1,1,1,1,0,1.3422314,0.838633778,1),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,11,0,0,-1.172305527,-0.606478741,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.419540323,-0.114324413,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,1,1,0,0,1,1,0,0.901788469,-0.114324413,1),
(0,1,0,1,0,1,0,0,0,0,1,0,0,0,1,0,0,2,0,0,-0.199318858,-0.051062648,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,0.094309763,2.649336893,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.171563537,-0.372295028,0),
(0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,3,0,0,-1.887683426,-0.798971054,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.272726013,-0.490534016,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,1,3,0,1,1.268824245,0.864276058,1),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,0,0.241124073,-0.703971532,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.268824245,-0.409147973,0),
(0,1,0,1,0,1,0,0,0,0,0,0,1,0,1,0,0,2,0,0,-0.125911703,-0.188030303,1),
(0,0,1,1,0,1,0,0,0,0,1,0,0,1,1,0,0,1,1,0,-1.08020472,-0.539975927,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.713168944,-0.709654256,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.786576099,-0.490534016,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.138573639,-0.490534016,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,1,0,1,0,2,0,1,1.929488641,0.970584519,1),
(0,1,0,1,0,0,0,1,0,0,0,0,1,1,0,0,0,2,0,1,-0.346133168,-0.114324413,1),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.241124073,-0.490534016,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.566354634,-0.297358249,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.125911703,-0.298589138,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.346133168,-0.552874458,0),
(0,0,1,1,0,0,1,0,0,0,0,0,1,1,0,0,0,6,0,1,0.681567004,-0.714720308,0),
(0,1,0,0,1,0,0,1,0,1,0,0,0,1,1,0,0,1,1,0,-0.199318858,-0.114324413,0),
(1,0,0,1,0,0,0,1,0,0,1,0,0,1,1,1,1,1,1,0,-0.786576099,1.138675715,1),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,4,0,0,-0.888252808,-0.640400202,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,1,0,1,1,0,-0.272726013,1.138675715,1),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.167716918,-0.501280335,0);

CREATE TABLE IF NOT EXISTS titanic_test(
pclass_1 int,
pclass_2 int,
pclass_3 int,
sex_female  int,
sex_male    int,
embarked_c  int,
embarked_q  int,
embarked_s  int,
title_master int,
title_misc  int,
title_miss  int,
title_mr    int,
title_mrs   int,
nosibsp     int,
noparch     int,
nullcabin   int,
cabinalpha  int,
family      int,
isalone     int,
ismother      int,
age         string,
realfare    string,
survived int
);

INSERT INTO titanic_test VALUES
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.3299657546908006,-0.5484510555366786,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,1,0,0,2,0,0,1.288825536427935,-0.6097992116840427,0),
(0,1,0,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,2.4394572745124963,-0.410965191368026,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.24535011435148013,-0.486799561907158,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,0,0,0,3,0,1,-0.6288940270463339,-0.6731486553661226,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-1.2425642873581,-0.4451831390503173,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,-0.015223766734567856,-0.5632480058857776,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,3,0,0,-0.32205889689045086,-0.4125065403627239,0),
(0,0,1,1,0,1,0,0,0,0,0,0,1,1,1,0,0,1,1,0,-0.9357291572022169,-0.5928419065839754,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,3,0,0,-0.7056028095853046,-0.5321152223512735,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.18187276297411278,-0.5435236710704286,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.2121167538889643,0.7959110714803547,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,1,1,1,2,0,0,-0.5521852445073632,1.9155482143080353,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,2.5161660570514672,-0.16589070121107513,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,1,1,1,2,0,0,1.288825536427935,1.135316120112811,0),
(0,1,0,1,0,1,0,0,0,0,0,0,1,0,1,0,0,2,0,0,-0.4754764619683924,-0.10223422080925157,0),
(0,1,0,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.36832014596028595,-0.21398078984564667,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.7056028095853046,-0.5931526425413065,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,1,0,0,2,0,0,-0.24535011435148013,-0.5413633163194602,0),
(0,0,1,1,0,1,0,0,0,0,0,0,1,1,1,0,0,1,1,0,1.1354079713499936,-0.5931526425413065,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,0,1,0,0,2,0,0,1.9024957967397012,1.0696546529386848,0),
(0,0,1,0,1,0,0,1,1,0,0,0,0,1,0,0,0,2,0,0,-1.6261082000529539,-0.8931016230678908,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,1,1,0,0,1,1,0,0.903700418293007,1.2163886110755242,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,2,0,0,-0.7056028095853046,1.1428699632660262,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,0,0,1,1,5,0,1,1.3655343189669058,1.6454145602723729,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,1.5189518840448473,-0.5913030237476691,0),
(1,0,0,1,0,1,0,0,0,0,1,0,0,1,0,1,1,2,0,0,-0.6288940270463339,1.1650653887896745,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.5905396357768485,-0.5931526425413065,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,0.8285728411941105,1.1288424543350803,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,0,1,0,0,3,0,0,-0.5353819573922526,-0.5930490638888628,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,1.5189518840448473,-0.16589070121107513,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,3,0,0,-0.4754764619683924,-0.35085258057481167,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,0,0,0,4,0,1,0.21490258088234443,-0.7471334071116172,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,0,0,0,4,0,1,-0.9652701884834723,-0.6939568667945429,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,0,1,1,0,2,0,0,-0.015223766734567856,1.0086172327486518,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.8973747659327316,-0.5928419065839754,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.050311122969114636,-0.5321152223512734,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.7056028095853046,-0.486799561907158,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.39876767942942165,-0.42483733232030624,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.05131935555094821,-0.6052140066946157,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,0,0,0,2,0,0,0.675155276116169,-0.6313768645306161,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,0,1.228053970046515,0.8366026849403768,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.8285728411941105,-0.5469121727003724,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,1,1,0,0,1,1,0,-0.015223766734567856,-0.16589070121107513,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,1,1,1,2,0,0,1.1354079713499936,0.8164122461890313,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.39876767942942165,-0.5413633163194602,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,1,0,1,1,0,1.1354079713499936,1.0696546529386848,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.18155272156363184,-0.5543106478749218,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,1,1,1,1,1,1,0,2.286039709434555,1.6945187684683705,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,1,0,0,0,3,0,1,0.4450289284992567,-0.7355732896513837,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,0,1,1,0,2,0,0,-0.4754764619683924,1.091850078462333,0),
(0,1,0,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.24535011435148013,-0.015457505486960923,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,4,0,0,-0.7823115921242755,-0.27686782882931704,0),
(1,0,0,1,0,0,0,1,0,0,1,0,0,0,0,1,0,6,0,0,-0.16864133181250937,2.1153058109416754,0),
(0,1,0,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.0975016982058483,0.024930770490904555,0),
(0,0,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,6,0,0,-1.5493994175139831,-0.7685581581379166,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.36832014596028595,-0.5435236710704286,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,-0.39876767942942165,-0.5617091230494713,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,-0.4138547638860934,-0.5321152223512734,0),
(1,0,0,1,0,1,0,0,0,0,1,0,0,1,1,1,1,1,1,0,0.4450289284992567,1.6454145602723729,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-1.0124379397411878,-0.5435236710704286,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.13819379834337367,-0.12889832533832785,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.9357291572022169,-0.5543106478749218,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,-0.6288940270463339,-0.5561602666685592,0),
(1,0,0,0,1,1,0,0,1,0,0,0,0,0,0,1,1,5,0,0,-1.3192730698970707,1.6454145602723729,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,1,1,0,0,1,1,0,-0.03505906788845137,-0.35085258057481167,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,-0.9357291572022169,-0.5447518179494039,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.288825536427935,0.44078426310198054,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,1,0,1,1,0,0.0614850158044029,0.9836473790345474,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,6,0,1,2.286039709434555,2.1153058109416754,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,-0.4754764619683924,-0.5543106478749218,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.7056028095853046,-0.5435236710704286,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.09193254927353861,-0.5413633163194602,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,1,1,1,1,0,-0.130286940543024,0.9232240322840018,0),
(1,0,0,1,0,1,0,0,0,0,1,0,0,1,1,1,0,1,1,0,0.36832014596028595,2.0018625249319166,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,1,0,1,1,0,0.17654818961285904,2.0018625249319166,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.050311122969114636,-0.5321152223512734,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,1,1,0,3,0,0,1.9024957967397012,0.7737156459567063,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.015223766734567856,-0.16589070121107513,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,-0.4754764619683924,-0.5543106478749218,0),
(0,0,1,0,1,1,0,0,1,0,0,0,0,0,0,0,0,3,0,0,-1.856234547669866,-0.7517068978486844,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,0,1,1,0,2,0,0,2.82300118720735,2.9743772896760943,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.4422431015058765,0.7959110714803547,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.18187276297411278,-0.5435236710704286,0),
(0,1,0,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.07119798278990797,-0.33544155678622517,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,0,1,0,0,2,0,0,-0.7597439639318478,-0.592997274562641,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,-0.24535011435148013,-0.5447518179494039,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.9357291572022169,-0.5321152223512734,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,0.18155272156363184,-0.5543106478749218,0),
(0,1,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,3,0,0,-2.163069677825749,-0.560476043853713,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,1,0,0,2,0,0,-0.6288940270463339,-0.6134984492713175,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.2877722506196658,-0.5524610290812845,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,1,4,0,1,-0.24535011435148013,0.7959110714803547,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.050311122969114636,-0.5321152223512734,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.39876767942942165,0.7959110714803547,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.39876767942942165,-0.5509221462449782,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,1,1,0,2,0,0,3.513380230058087,0.8168734178082447,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.09193254927353861,-0.5413633163194602,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.7823115921242755,-0.5466014367430413,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.21490258088234443,-0.5321152223512734,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,0,1,1,0,2,0,0,0.981990406272052,0.923227731521589,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,-0.24535011435148013,-0.16589070121107513,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.18155272156363184,-0.5543106478749218,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.32205889689045086,-0.5524610290812845,0),
(0,0,1,1,0,1,0,0,0,0,0,0,1,0,0,0,0,3,0,1,-1.0891467222801585,-0.812639506307078,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.16864133181250937,-0.5721902962134163,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.7056028095853046,-0.5490725274513408,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.18155272156363184,-0.5543106478749218,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.13162236194536187,-0.48310032431988326,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,-0.8973747659327316,-0.16589070121107513,0),
(0,1,0,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,0.8285728411941105,-0.014532696090142292,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,-0.2877722506196658,-0.5521502931239534,0),
(1,0,0,1,0,1,0,0,0,0,1,0,0,1,1,1,0,1,1,0,0.4450289284992567,1.2160852735933676,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,-0.8973747659327316,-0.5888393315145442,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,1,1,0,2,0,0,2.5161660570514672,2.9743772896760943,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,0,1,0,0,2,0,0,-0.9357291572022169,-0.592997274562641,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,0.43700391136597205,-0.6514156345408835,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,1,0,3,0,0,-2.23977846036472,-0.7158440225192517,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,1,0,1,1,0,0.4450289284992567,1.6556767738019853,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,0,1,0,0,2,0,0,-0.09193254927353861,-0.16589070121107513,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-1.3959818524360414,-0.545062553906735,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,0,1,0,0,2,0,0,0.01608158209165432,-0.5543106478749218,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,0,1,1,0,2,0,0,0.36832014596028595,1.0086172327486518,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.16864133181250937,-0.5913030237476691,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.18155272156363184,-0.5543106478749218,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,0,0,0,2,0,0,-1.0124379397411878,-0.5321152223512734,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.6288940270463339,-0.5509221462449782,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,0,1,0,0,3,0,0,-0.5482688502188416,-0.5543106478749218,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.9052816237330813,-0.16589070121107513,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.4754764619683924,-0.5321152223512734,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.13819379834337367,-0.5321152223512734,0),
(1,0,0,0,1,1,0,0,0,1,0,0,0,1,1,1,0,1,1,0,1.7490782316617597,0.9808729508440912,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,1,0,0,0,5,0,1,0.755128050559436,-0.7508629784471076,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,0,1,0,0,2,0,0,0.052044447673335936,-0.6514156345408835,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.981990406272052,-0.5435236710704286,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.4754764619683924,-0.5466014367430413,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.2837045056209655,-0.5931526425413065,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.32205889689045086,-0.16589070121107513,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.5521852445073632,-0.5321152223512734,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,8,0,0,0.7518640586551397,-0.6939568667945429,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,8,0,0,-1.5493994175139831,-0.6939568667945429,0),
(1,0,0,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,0.21490258088234443,0.7410390472691131,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,0,0,1,1,5,0,0,2.3627484919735258,1.6454145602723729,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.16864133181250937,-0.16589070121107513,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.9052816237330813,0.8366026849403768,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,4,0,0,0.0614850158044029,-0.4618297081930536,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,0,1.5258184159218342,0.7908246197978519,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.6288940270463339,-0.5321152223512734,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.228053970046515,0.8366026849403768,0),
(0,1,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,3,0,0,-0.015223766734567856,-0.16589070121107513,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,1,0,1,0,2,0,1,-0.5521852445073632,0.9231229197899495,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.18187276297411278,-0.5435236710704286,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,2.32439410070404,1.335665294975106,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,1,0,0,0,3,0,1,0.4450289284992567,-0.6770032609320629,0),
(0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,7,0,0,-1.3192730698970707,-0.7959501317008317,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.4754764619683924,-0.5691075982240208,0),
(1,0,0,1,0,0,0,1,0,0,1,0,0,1,1,1,0,1,1,0,-0.09193254927353861,2.9743772896760943,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.5521852445073632,-0.5466014367430413,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,0,0.9052816237330813,0.8366026849403768,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,1,0,0,0,3,0,1,-0.32205889689045086,-0.787979155471109,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,-0.6772483080657901,-0.5555461932290716,0),
(0,0,1,0,1,1,0,0,1,0,0,0,0,0,0,0,0,3,0,0,-1.7795257651308953,-0.7517068978486844,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.32205889689045086,-0.12889832533832785,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.626387892936829,-0.6097992116840427,0),
(0,1,0,0,1,0,0,1,0,1,0,0,0,1,1,0,0,1,1,0,0.8285728411941105,-0.16589070121107513,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,0,0,0,3,0,1,-0.32205889689045086,-0.5845210881709988,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,1,1,1,1,0,1.3655343189669058,2.6082267532876413,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,5,0,0,-0.9357291572022169,-0.6190473056522295,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,1,1,0,0,1,1,0,0.7648668924661792,0.9232240322840018,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.6288940270463339,-0.46460413638350956,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.03596369073359349,-0.5691075982240208,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.24535011435148013,-0.5931526425413065,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,-0.5521852445073632,-0.6134984492713175,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.5000917774791281,-0.5928419065839754,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,7,0,0,0.7518640586551397,-0.7959501317008317,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,0,0,0,3,0,0,-1.1658555048191293,-0.16589070121107513,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.7823115921242755,-0.44795756724077335,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,0,1,1,0,2,0,0,1.8257870142007304,0.923227731521589,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,1,0,1,0,4,0,1,0.4450289284992567,-0.4063411443839326,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,1,0,1,1,3,0,1,2.5928748395904377,0.9231229197899495,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.015223766734567856,-0.16589070121107513,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,0,0,1,1,3,0,0,0.5217377110382274,0.9231229197899495,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,1,1,1,2,0,0,-0.9357291572022169,0.8366026849403768,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.18155272156363184,-0.5543106478749218,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,0,0,1,1,3,0,1,-0.24535011435148013,4.9765625060462355,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.7518640586551397,0.05606355402540867,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,0,0,0,2,0,0,-0.7056028095853046,-0.35085258057481167,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,3,0,0,-1.0124379397411878,-0.5321152223512734,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,11,0,0,-1.262098722813484,-0.6599070662753096,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.7518640586551397,-0.16589070121107513,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,0.29161136342131516,-0.16589070121107513,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.0681552133463093,0.7959110714803547,0),
(0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,3,0,0,-1.434336243705527,-0.7700995071326143,0),
(0,1,0,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,2.3627484919735258,-0.21398078984564667,0),
(0,1,0,0,1,0,0,1,1,0,0,0,0,1,0,0,0,3,0,0,-1.7028169825919246,-0.32619099665964674,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.21490258088234443,-0.5466014367430413,0),
(1,0,0,0,1,1,0,0,1,0,0,0,0,1,0,1,1,3,0,0,-1.856234547669866,0.8624973480512997,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.9357291572022169,-0.5524610290812845,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.5521852445073632,-0.35085258057481167,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,1,1,0,0,1,1,0,-0.56552667240812,-0.5274911753671799,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,0.10808114173784363,-0.5543106478749218,0),
(0,0,1,0,1,0,0,1,1,0,0,0,0,1,0,0,0,3,0,0,-2.2911733446658302,-0.772565665524131,0),
(1,0,0,0,1,1,0,0,0,1,0,0,0,0,1,1,0,2,0,0,1.288825536427935,2.238983654276227,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,3,0,0,-1.7028169825919246,-0.48649129210821845,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.39876767942942165,-0.35085258057481167,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,1.3248000262243267,0.7768008101044935,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,0.36832014596028595,-0.5543106478749218,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.4754764619683924,-0.35085258057481167,0),
(1,0,0,1,0,1,0,0,0,0,1,0,0,1,1,1,0,1,1,0,0.21490258088234443,0.9232240322840018,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.39876767942942165,-0.5435236710704286,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.13819379834337367,-0.5721902962134163,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.23044683132178326,-0.6060999740967681,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-1.0124379397411878,-0.35085258057481167,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,0,1,0,0,2,0,0,2.286039709434555,-0.16589070121107513,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,7,0,0,0.5984464935771983,-0.5524610290812845,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,0,0.9052816237330813,2.0166594752810156,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,-0.5846203441951023,-0.5447518179494039,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,3,0,0,2.055913361817643,1.9217129937472288,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,0,0,1,0,3,0,1,1.5189518840448473,2.0018625249319166,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.050311122969114636,-0.5321152223512734,0),
(0,1,0,1,0,1,0,0,0,0,1,0,0,0,1,0,0,2,0,0,-0.015223766734567856,-0.10238958878791714,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.7056028095853046,-0.5321152223512734,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,1,1,1,0,1,1,0,-0.6288940270463339,-0.35085258057481167,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.7056028095853046,-0.5509221462449782,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,1,1,0,0,1,1,0,1.7490782316617597,0.9028782255539907,0),
(0,0,1,1,0,1,0,0,0,0,0,0,1,1,0,0,0,3,0,1,-0.4856118746892921,-0.7517068978486844,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.5521852445073632,-0.5509221462449782,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,0.18155272156363184,-0.5543106478749218,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.7902184499246251,-0.5691075982240208,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.4450289284992567,-0.16589070121107513,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-1.2425642873581,-0.16589070121107513,0),
(1,0,0,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.7056028095853046,0.8366026849403768,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,-0.7056028095853046,-0.6471023235141211,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.5846203441951023,-0.5447518179494039,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,0,1,1,0,2,0,0,0.675155276116169,1.5092461531473025,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.7823115921242755,-0.5466014367430413,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,0,1,1,1,2,0,0,2.5928748395904377,1.6559838105217293,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.7823115921242755,-0.5931526425413065,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,3,0,0,-0.9357291572022169,-0.16589070121107513,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,0,1,1,0,2,0,0,1.3655343189669058,1.496916594268916,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,1,1,0,0,1,1,0,1.9024957967397012,0.9232240322840018,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,1,0,0,0,3,0,1,1.1354079713499936,-0.01792119772008593,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,0,0,1,1,3,0,0,1.1354079713499936,0.8624973480512997,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.4176936775284617,-0.5441377445099163,0),
(0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,4,0,0,-0.9652701884834723,-0.6939568667945429,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,0,1,1,1,2,0,0,0.8285728411941105,0.7908246197978519,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,1,1,0,0,1,1,0,-0.6288940270463339,-0.35085258057481167,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,3,0,0,0.9052816237330813,-0.32619099665964674,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,0,1,0,0,2,0,0,-0.09193254927353861,-0.16589070121107513,0),
(0,0,1,1,0,1,0,0,0,0,0,0,1,0,1,0,0,2,0,0,-0.7597439639318478,-0.592997274562641,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,4,0,0,-2.2459151629678376,-0.6144232586681362,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.7823115921242755,-0.5413633163194602,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,0,1,1,0,2,0,0,-0.24535011435148013,3.932095104071173,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.4754764619683924,-0.43778466387576787,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.17654818961285904,-0.42483733232030624,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.03596369073359349,-0.5691075982240208,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.18155272156363184,-0.5543106478749218,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.16864133181250937,-0.5321152223512734,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.8590203746632462,-0.16589070121107513,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.7056028095853046,-0.5524610290812845,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,0.48338331976874205,-0.48402513371670197,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.7056028095853046,-0.5466014367430413,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,1,0,0,0,3,0,1,-0.09193254927353861,-0.560476043853713,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,3,0,0,-2.23977846036472,-0.6770032609320629,0),
(0,1,0,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.015223766734567856,-0.18531169854426743,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.18187276297411278,-0.5435236710704286,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.8614194422555008,-1.127692473902505,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.03596369073359349,-0.5691075982240208,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.050311122969114636,-0.5321152223512734,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-1.0124379397411878,-0.486799561907158,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,1,0,1,1,0,1.2121167538889643,1.6556767738019853,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.18155272156363184,-0.5543106478749218,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,0,1,1,0,2,0,0,-0.32205889689045086,3.932095104071173,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,0,1,0,0,2,0,0,0.1726668165363672,-0.5543106478749218,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.18097869615322262,-0.5931526425413065,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,0,1,0,0,2,0,0,-0.7823115921242755,-0.16589070121107513,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.16864133181250937,-0.35085258057481167,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,0.7518640586551397,-0.16589070121107513,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,-0.015223766734567856,-0.35085258057481167,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.6288940270463339,-0.35085258057481167,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.5521852445073632,-0.486799561907158,0),
(0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,3,0,0,-2.2589556559994626,-0.787979155471109,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,0.18155272156363184,-0.5543106478749218,0),
(0,0,1,1,0,1,0,0,0,0,1,0,0,0,0,0,0,3,0,0,-1.6261082000529539,-0.7517068978486844,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,3,0,0,-2.163069677825749,-0.6292202090172352,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.4450289284992567,-0.5913030237476691,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.015293734197290222,-0.5913030237476691,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,0,1,1,1,2,0,0,-0.4754764619683924,1.9155482143080353,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,1,0,1,1,0,-0.5000917774791281,-0.5928419065839754,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.050311122969114636,-0.5321152223512734,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.8331087958816026,1.8021036952190812,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,-0.015223766734567856,-0.6134984492713175,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.5000917774791281,-0.5928419065839754,0),
(1,0,0,0,1,0,0,1,0,1,0,0,0,0,0,1,0,3,0,0,1.7490782316617597,0.8910628607002354,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.4450289284992567,-0.42483733232030624,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.32205889689045086,-0.5435236710704286,0),
(0,1,0,1,0,1,0,0,0,0,1,0,0,0,0,0,0,4,0,0,-2.23977846036472,-0.3586357764584377,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,0,1,0,0,3,0,0,-0.5353819573922526,-0.5930490638888628,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.015223766734567856,2.2386137305174993,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.09193254927353861,-0.5466014367430413,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.13819379834337367,-0.5524610290812845,0),
(0,1,0,0,1,1,0,0,0,0,0,1,0,1,1,1,1,1,1,0,0.10882985902741467,-0.014532696090142292,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,0,0,0,2,0,0,0.981990406272052,-0.35085258057481167,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.4754764619683924,-0.486799561907158,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,0.18155272156363184,-0.5543106478749218,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,1,3,0,1,2.5928748395904377,0.8366026849403768,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,0,0,1,0,4,0,0,-0.015223766734567856,0.7410390472691131,0),
(0,0,1,0,1,0,0,1,1,0,0,0,0,1,0,0,0,2,0,0,-2.252818953396345,-0.7818137594923178,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,0,0,1,1,3,0,0,1.9024957967397012,0.6017010981484314,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,1,0,0,2,0,0,1.1354079713499936,-0.6057929373770242,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.9357291572022169,-0.486799561907158,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.6288940270463339,-0.5931526425413065,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.07116736880043238,-0.5672579794303834,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,0.5217377110382274,-0.5543106478749218,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,1,1,1,0,1,1,0,1.9024957967397012,1.381006533328043,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,-1.0124379397411878,-0.5555461932290716,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,0,1,1,1,2,0,0,2.055913361817643,2.485742530614584,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.8590203746632462,-0.35085258057481167,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.24535011435148013,-0.5466014367430413,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,3,0,0,-0.6288940270463339,-0.35085258057481167,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.32205889689045086,-0.5524610290812845,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,1,0,1,1,0,-0.39876767942942165,-0.5928419065839754,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,-0.32205889689045086,-0.16589070121107513,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.21490258088234443,0.8366026849403768,0),
(1,0,0,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,0.675155276116169,2.7812456441008613,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.5521852445073632,-0.6060999740967681,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,0,0,1,0,4,0,0,-1.3959818524360414,-0.4063411443839326,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,1.2121167538889643,1.8021036952190812,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,-0.09193254927353861,-0.16589070121107513,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.7056028095853046,-0.16589070121107513,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,1,0,0,0,3,0,1,1.3655343189669058,-0.44795756724077335,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,1,1,1,0,1,1,0,0.675155276116169,1.0696546529386848,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.18097869615322262,-0.5931526425413065,0),
(0,0,1,1,0,1,0,0,0,0,0,0,1,0,0,0,0,3,0,1,-0.8590203746632462,-0.7394772183851542,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.24535011435148013,-0.5435236710704286,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,-0.015223766734567856,0.7959110714803547,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.13819379834337367,-0.16589070121107513,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,1,0,0,0,3,0,0,0.675155276116169,-0.5928419065839754,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.39876767942942165,-0.35085258057481167,0),
(0,0,1,0,1,1,0,0,1,0,0,0,0,1,1,0,0,1,1,0,-0.5000917774791281,-0.5928419065839754,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.9357291572022169,-0.35085258057481167,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.13819379834337367,-0.5669472434730523,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,11,0,0,0.8394510140979374,-0.6599070662753096,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,1,0,1,1,2,0,1,2.1326221443566133,8.348444694589459,0),
(0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,3,0,0,-1.1777290365783895,-0.7700995071326143,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-1.0891467222801585,-0.5617091230494713,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.32205889689045086,-0.16589070121107513,0),
(0,0,1,1,0,1,0,0,0,0,0,0,1,1,1,0,0,1,1,0,0.5984464935771983,-0.5928419065839754,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.4754764619683924,-0.12889832533832785,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,0.0614850158044029,-0.35085258057481167,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,1,0,1,1,2,0,1,1.1354079713499936,1.2160815743557802,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.39876767942942165,-0.35085258057481167,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.9357291572022169,-0.35085258057481167,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,4,0,0,1.4422431015058765,-0.16589070121107513,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,4,0,0,-2.3034467498720654,-0.7471334071116172,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,0,1.5189518840448473,0.7959110714803547,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,1,1,0,3,0,0,2.2093309268955843,0.7766454421258279,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.5846203441951023,-0.5447518179494039,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.18155272156363184,-0.5543106478749218,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,1,0,0,2,0,0,-0.015223766734567856,-0.5524610290812845,0),
(0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,11,0,0,-1.2042098960886145,-0.6599070662753096,0),
(0,1,0,1,0,1,0,0,0,0,0,0,1,0,0,0,0,3,0,1,-0.4754764619683924,-0.21511029038896126,0),
(0,1,0,1,0,0,0,1,0,0,0,0,1,1,1,0,0,1,1,0,0.0614850158044029,-0.35085258057481167,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.24535011435148013,-0.486799561907158,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,0,1,1,1,2,0,0,-0.39876767942942165,0.923227731521589,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,0,0,0,11,0,1,0.8394510140979374,-0.6599070662753096,0),
(0,0,1,0,1,1,0,0,0,0,0,1,0,0,1,0,0,2,0,0,-0.8187885607933512,-0.5928456058215628,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.6288940270463339,-0.7082253546311741,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,1,0,0,0,2,0,1,1.1354079713499936,1.0696546529386848,0),
(0,1,0,0,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.09193254927353861,-0.10238958878791714,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,-0.7056028095853046,-0.27686782882931704,0),
(1,0,0,1,0,1,0,0,0,0,1,0,0,1,1,1,1,1,1,0,0.0614850158044029,0.8624973480512997,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,0,1.4422431015058765,-1.127692473902505,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.0586991888110229,-0.16589070121107513,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,3,0,1,1.8257870142007304,0.8910628607002354,0),
(1,0,0,1,0,1,0,0,0,0,1,0,0,1,1,0,0,1,1,0,1.1354079713499936,1.6454145602723729,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,1,0,0,3,0,0,-0.6288940270463339,-0.486799561907158,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.7056028095853046,-0.27686782882931704,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,1.9024957967397012,2.571545113372225,0),
(0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,7,0,0,-1.9329433302088368,-0.7959501317008317,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.18155272156363184,-0.5543106478749218,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.32205889689045086,-0.5447518179494039,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,1,1,0,0,1,1,0,-0.23354705269818174,-0.5913030237476691,0),
(0,0,1,1,0,0,0,1,0,0,0,0,1,0,1,0,0,2,0,0,-0.8590203746632462,-0.5321152223512734,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.3394025880112109,-0.17513879517926198,0),
(0,1,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,4,0,0,-0.4754764619683924,-0.16589070121107513,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.4754764619683924,-0.5524610290812845,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,2.055913361817643,-0.16589070121107513,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.7056028095853046,-0.5543106478749218,0),
(0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,5,0,0,-1.856234547669866,-0.8158467452952453,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,0,-0.5521852445073632,0.6017010981484314,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,1,0,1,1,2,0,1,1.595660666583818,0.32980713548373863,0),
(0,0,1,0,1,0,0,1,1,0,0,0,0,1,0,0,0,3,0,0,-1.3192730698970707,-0.6282953996204165,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1.288825536427935,-0.35085258057481167,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,5,0,0,-0.09193254927353861,-0.5845210881709988,0),
(1,0,0,1,0,0,0,1,0,0,0,0,1,0,1,1,0,2,0,0,-0.9357291572022169,1.091850078462333,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,-0.4754764619683924,-0.5913030237476691,0),
(1,0,0,1,0,1,0,0,0,0,0,0,1,0,0,1,1,3,0,1,1.3655343189669058,1.8021036952190812,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.6288940270463339,-0.5524610290812845,0),
(0,0,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0.0614850158044029,-0.5555461932290716,0),
(1,0,0,1,0,0,0,1,0,0,1,0,0,1,1,1,0,1,1,0,-0.015223766734567856,1.9217129937472288,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,0.5984464935771983,-0.35085258057481167,0),
(1,0,0,1,0,1,0,0,0,0,1,0,0,1,0,0,0,2,0,0,-0.6288940270463339,1.0696546529386848,0),
(1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-1.0124379397411878,0.614648429703893,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,0,1,1,1,2,0,0,0.981990406272052,0.9232240322840018,0),
(0,1,0,0,1,1,0,0,0,0,0,1,0,1,1,1,1,1,1,0,-0.7823115921242755,-0.10207885283058599,0),
(0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,0,-0.5521852445073632,-0.35085258057481167,0),
(1,0,0,0,1,1,0,0,0,0,0,1,0,0,0,1,0,3,0,0,1.5189518840448473,2.0018625249319166,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,-0.6451073060437849,-0.5564710026258903,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,3,0,0,-2.0863608952867785,-0.787979155471109,0),
(0,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,1,0,0.18155272156363184,-0.5543106478749218,0),
(1,0,0,1,0,0,1,0,0,0,0,0,1,0,1,1,0,2,0,0,0.5217377110382274,1.091850078462333,0),
(0,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,-0.16864133181250937,-0.5524610290812845,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.050311122969114636,-0.5321152223512734,0),
(1,0,0,1,0,1,0,0,0,1,0,0,0,1,1,1,0,1,1,0,0.675155276116169,1.5579540144589494,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0.6368008848466836,-0.5913030237476691,0),
(0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,0,-0.050311122969114636,-0.5321152223512734,0),
(0,0,1,0,1,1,0,0,1,0,0,0,0,0,0,0,0,3,0,0,-0.37793941004730885,-0.5763013822520744,0);
