DROP DATABASE IF EXISTS scorecard;
CREATE DATABASE scorecard;
DROP TABLE IF EXISTS scorecard.train;
CREATE TABLE IF NOT EXISTS scorecard.train(
  serious_dlqin2yrs int,
  revolving_utilization_of_unsecured_lines float,
  age int,
  number_of_time30_59days_past_due_not_worse int,
  debt_ratio float,
  monthly_income float NULL,
  number_of_open_credit_lines_and_loans int,
  number_of_times_90_days_late int,
  number_real_estate_loans_or_lines int,
  number_of_time60_89_days_past_due_not_worse int,
  number_of_dependents float
);
INSERT INTO scorecard.train VALUES
(1,0.766127,45,2,0.802982,9120.000000,13,0,6,0,2.000000),
(0,0.957151,40,0,0.121876,2600.000000,4,0,0,0,1.000000),
(0,0.658180,38,1,0.085113,3042.000000,2,1,0,0,0.000000),
(0,0.233810,30,0,0.036050,3300.000000,5,0,0,0,0.000000),
(0,0.907239,49,1,0.024926,63588.000000,7,0,1,0,0.000000),
(0,0.213179,74,0,0.375607,3500.000000,3,0,1,0,1.000000),
(0,0.305682,57,0,5710.000000,5400.000000,8,0,3,0,0.000000),
(0,0.754464,39,0,0.209940,3500.000000,8,0,0,0,0.000000),
(0,0.116951,27,0,46.000000,5400.000000,2,0,0,0,0.000000),
(0,0.189169,57,0,0.606291,23684.000000,9,0,4,0,2.000000),
(0,0.644226,30,0,0.309476,2500.000000,5,0,0,0,0.000000),
(0,0.018798,51,0,0.531529,6501.000000,7,0,2,0,2.000000),
(0,0.010352,46,0,0.298354,12454.000000,13,0,2,0,2.000000),
(1,0.964673,40,3,0.382965,13700.000000,9,3,1,1,2.000000),
(0,0.019657,76,0,477.000000,0.000000,6,0,1,0,0.000000),
(0,0.548458,64,0,0.209892,11362.000000,7,0,1,0,2.000000),
(0,0.061086,78,0,2058.000000,5400.000000,10,0,2,0,0.000000),
(0,0.166284,53,0,0.188274,8800.000000,7,0,0,0,0.000000),
(0,0.221813,43,0,0.527888,3280.000000,7,0,1,0,2.000000),
(0,0.602794,25,0,0.065868,333.000000,2,0,0,0,0.000000),
(0,0.200923,43,0,0.430046,12300.000000,10,0,2,0,0.000000),
(1,0.025656,38,0,0.475841,3000.000000,7,0,1,0,2.000000),
(0,1.000000,39,0,0.241104,2500.000000,4,0,0,0,0.000000),
(0,0.075427,32,0,0.085512,7916.000000,6,0,0,0,0.000000),
(0,0.046560,58,0,0.241622,2416.000000,9,0,1,0,0.000000),
(1,0.392248,50,0,1.595253,4676.000000,14,0,3,0,1.000000),
(0,0.052436,58,0,0.097672,8333.000000,22,0,1,0,0.000000),
(0,0.034421,69,0,0.042383,2500.000000,17,0,0,0,1.000000),
(0,0.452516,24,0,0.011761,3400.000000,1,0,0,0,0.000000),
(0,0.392995,58,2,0.436103,5500.000000,15,0,1,0,0.000000),
(0,0.704074,28,1,0.155201,4200.000000,8,0,0,0,0.000000),
(0,1.000000,24,0,0.472703,750.000000,1,0,0,0,0.000000),
(0,0.083418,62,0,977.000000,5400.000000,6,0,1,0,0.000000),
(0,0.186869,57,0,0.313812,7000.000000,9,0,2,0,0.000000),
(0,0.693330,42,2,0.257732,2230.000000,7,0,0,0,0.000000),
(0,0.000000,64,0,0.073539,11000.000000,9,0,1,0,0.000000),
(0,0.881836,50,3,0.567858,4000.000000,9,0,1,0,1.000000),
(0,1.000000,75,1,0.134078,3400.000000,1,0,1,0,1.000000),
(0,0.363636,26,0,0.009990,1000.000000,1,0,0,0,0.000000),
(0,0.304491,52,0,0.808340,3500.000000,10,0,2,0,0.000000),
(0,0.719985,41,1,0.539554,5700.000000,14,0,1,0,0.000000),
(0,0.072898,81,0,75.000000,5400.000000,7,0,0,0,0.000000),
(0,0.469057,31,0,0.048211,9250.000000,4,0,0,0,1.000000),
(0,0.718705,28,0,0.170126,3661.000000,4,0,0,0,1.000000),
(0,0.368876,68,0,1687.500000,1.000000,31,0,1,0,0.000000),
(0,0.000603,70,0,0.177787,16800.000000,12,0,1,0,2.000000),
(0,0.061440,62,0,0.011168,3133.000000,2,0,0,0,0.000000),
(0,0.140111,31,0,0.689370,1937.000000,4,0,2,0,0.000000),
(0,0.834048,38,0,0.393662,13000.000000,13,0,2,0,2.000000),
(0,0.000080,70,0,0.256340,6900.000000,21,1,1,0,0.000000),
(0,0.818978,73,0,3095.000000,0.000000,9,0,1,1,0.000000),
(1,0.728150,31,0,0.824725,3000.000000,10,0,2,0,1.000000),
(0,1.000000,62,0,0.000000,5400.000000,1,0,0,0,0.000000),
(0,0.028562,51,0,0.306381,5750.000000,5,0,1,0,0.000000),
(0,0.992016,29,0,0.008065,2231.000000,1,0,0,0,0.000000),
(0,0.070854,55,0,0.073148,13793.000000,4,0,1,0,0.000000),
(0,0.454972,46,1,0.016922,13000.000000,10,0,0,0,1.000000),
(0,0.401200,64,0,0.351259,3216.000000,4,0,1,0,0.000000),
(0,0.541109,43,0,2477.000000,5400.000000,3,0,1,0,2.000000),
(0,0.655570,35,0,0.261610,5813.000000,10,0,0,0,2.000000),
(0,0.651603,58,0,0.241136,7783.000000,11,0,1,0,0.000000),
(0,0.027400,69,0,0.008034,5600.000000,3,0,0,0,0.000000),
(0,0.101156,72,0,1720.000000,5400.000000,12,0,2,0,0.000000),
(0,0.009789,46,0,1.051398,3326.000000,6,0,2,0,2.000000),
(0,0.337521,60,0,0.549878,4500.000000,10,0,2,0,0.000000),
(0,0.000000,67,0,0.540984,3720.000000,2,0,1,0,0.000000),
(0,0.750874,55,2,0.316416,7723.000000,17,0,1,0,1.000000),
(0,0.006799,27,1,0.681046,764.000000,3,0,0,0,0.000000),
(0,0.004264,31,0,0.111444,2000.000000,6,1,0,0,2.000000),
(0,0.269484,64,0,0.161062,9455.000000,13,0,1,0,3.000000),
(0,0.265898,36,0,0.262612,8384.000000,6,0,2,0,1.000000),
(0,0.142013,67,0,1824.000000,5400.000000,7,0,2,0,0.000000),
(0,0.827708,56,0,0.369591,6793.000000,15,1,1,0,0.000000),
(0,0.059669,31,0,3162.000000,0.000000,11,0,2,0,1.000000),
(1,0.133063,49,1,0.182882,10257.000000,9,0,2,0,3.000000),
(0,0.234218,36,0,0.116614,8600.000000,19,0,0,0,3.000000),
(0,0.122296,29,0,0.694647,4800.000000,5,0,1,0,0.000000),
(0,0.460376,37,0,0.074156,4975.000000,6,0,0,0,0.000000),
(0,0.335559,69,0,0.270449,15000.000000,14,0,2,0,1.000000),
(0,0.270523,41,0,2.797699,1042.000000,11,0,2,0,2.000000),
(0,0.183317,52,0,0.111132,10833.000000,14,0,2,0,1.000000),
(0,0.074862,66,0,0.208842,4500.000000,3,0,1,0,0.000000),
(0,0.017259,53,0,2.604511,12414.000000,13,0,1,0,2.000000),
(0,0.054497,56,0,0.492022,4950.000000,18,0,2,0,0.000000),
(0,0.029164,31,0,0.395032,3300.000000,10,0,1,0,0.000000),
(0,0.000000,58,0,0.316145,4886.000000,9,0,1,0,1.000000),
(0,0.360510,58,1,3282.000000,5400.000000,8,0,2,0,0.000000),
(0,0.003750,64,0,0.004061,3200.000000,5,0,0,1,0.000000),
(1,0.734478,45,0,0.591478,4716.000000,13,0,2,0,2.000000),
(0,0.080564,60,0,0.487289,4916.000000,15,0,2,0,0.000000),
(0,0.039388,51,0,15466.000000,0.000000,7,0,0,0,0.000000),
(0,0.023767,83,0,0.123798,10500.000000,13,0,0,0,0.000000),
(0,0.784836,52,0,2662.000000,5400.000000,10,0,2,1,0.000000),
(0,0.888822,34,0,0.368404,3050.000000,4,0,0,0,1.000000),
(0,0.791174,44,0,0.512415,3100.000000,5,0,1,0,0.000000),
(0,0.245353,37,0,0.288417,6500.000000,11,1,1,1,0.000000),
(0,0.542243,48,2,10.000000,5400.000000,2,0,0,0,0.000000),
(0,0.010531,57,0,0.280665,5714.000000,6,0,1,0,0.000000),
(0,0.363200,32,0,0.480524,2900.000000,4,0,1,0,0.000000),
(0,0.032618,75,0,0.006799,7500.000000,4,0,0,0,0.000000),
(0,0.013025,61,0,15.000000,5400.000000,4,0,0,0,0.000000),
(0,0.019388,34,0,0.325919,4000.000000,9,0,1,0,0.000000),
(0,0.634485,52,0,0.138239,2690.000000,2,0,0,0,0.000000),
(0,0.888009,44,0,0.299246,4908.000000,8,0,0,0,1.000000),
(0,0.003109,57,0,0.258939,8333.000000,7,0,1,0,0.000000),
(0,0.114831,46,0,0.026236,6250.000000,6,0,0,0,3.000000),
(0,0.018887,80,0,0.003479,10060.000000,5,0,0,0,0.000000),
(0,0.635415,32,0,0.519494,3000.000000,4,0,1,0,1.000000),
(0,1.000000,62,0,0.664221,8314.000000,8,0,3,0,0.000000),
(0,0.041258,61,0,4739.000000,5400.000000,11,0,4,0,0.000000),
(0,0.096737,47,0,0.009749,8000.000000,2,0,0,0,2.000000),
(0,0.318446,58,0,1.382629,3833.000000,26,0,4,0,0.000000),
(0,0.186988,52,0,0.023993,3500.000000,4,0,0,0,0.000000),
(0,0.006542,68,0,0.108089,10000.000000,10,0,2,0,1.000000),
(0,0.180972,39,1,0.384442,3097.000000,7,0,1,0,3.000000),
(0,0.007508,74,0,7.000000,5400.000000,4,0,0,0,0.000000),
(0,0.067907,46,0,0.149103,10200.000000,6,0,2,0,0.000000),
(0,0.033462,44,0,1.243363,4067.000000,5,0,2,0,1.000000),
(0,0.007521,68,0,269.000000,5400.000000,4,0,0,0,0.000000),
(0,0.015272,68,0,0.122904,8168.000000,6,0,0,0,0.000000),
(0,0.517121,31,0,0.123752,500.000000,3,0,0,0,0.000000),
(0,0.317976,34,0,0.297934,4500.000000,11,0,2,0,0.000000),
(0,0.297595,67,0,0.239508,4145.000000,13,0,0,0,0.000000),
(0,0.444838,58,0,0.366545,14000.000000,9,0,2,1,4.000000),
(0,0.277957,39,0,4090.000000,5400.000000,9,0,2,0,0.000000),
(0,0.003722,58,0,0.633323,3228.000000,5,0,1,0,0.000000),
(0,0.000000,61,0,0.222660,3300.000000,14,0,1,0,0.000000),
(0,0.000000,59,0,0.218854,19167.000000,13,0,2,0,0.000000),
(0,0.151913,36,0,0.266394,12000.000000,22,0,2,0,0.000000),
(0,0.000000,59,0,0.351700,4500.000000,12,0,1,0,0.000000),
(0,0.175728,43,1,994.000000,5400.000000,4,0,1,0,0.000000),
(0,0.011499,77,0,0.001998,1000.000000,1,0,0,0,0.000000),
(0,0.000000,48,0,0.517469,4550.000000,7,0,2,0,0.000000),
(0,0.163037,81,0,0.086483,2751.000000,7,0,0,0,1.000000),
(0,0.047312,51,0,0.100920,3150.000000,5,0,0,0,0.000000),
(0,0.083880,53,0,0.199648,7943.000000,8,0,1,0,0.000000),
(0,0.089478,56,0,1.065902,2700.000000,11,0,1,0,2.000000),
(0,0.773519,63,0,1.129227,4139.000000,12,0,1,0,1.000000),
(0,0.093962,55,0,0.112052,9450.000000,6,0,2,0,0.000000),
(0,0.219550,54,0,0.315984,5417.000000,20,0,2,0,1.000000),
(0,0.147996,55,0,0.323088,6799.000000,5,0,1,0,0.000000),
(0,0.576519,72,0,3031.000000,5400.000000,11,0,1,0,0.000000),
(0,0.243872,53,0,0.534028,8639.000000,22,0,2,0,3.000000),
(0,0.362484,27,0,567.000000,5400.000000,4,0,0,0,0.000000),
(0,0.116677,31,0,0.343594,3800.000000,7,0,1,0,0.000000),
(0,1.000000,38,0,0.433700,5821.000000,7,0,1,0,4.000000),
(0,0.496912,40,0,0.452364,12500.000000,11,0,2,0,2.000000),
(0,0.130902,48,1,0.427882,3937.000000,17,0,1,0,0.000000),
(0,0.546999,50,0,0.748072,3500.000000,9,0,2,0,3.000000),
(0,0.072277,34,0,0.025912,2083.000000,2,0,0,0,0.000000),
(0,0.000000,48,2,0.370876,3000.000000,14,0,1,0,5.000000),
(0,0.175932,57,1,0.655813,3500.000000,9,0,1,0,1.000000),
(0,0.050790,30,0,0.315171,4000.000000,4,0,1,0,1.000000),
(0,0.000000,28,0,0.144616,3166.000000,7,0,0,0,0.000000),
(0,0.212860,36,0,0.563752,9583.000000,10,0,2,0,1.000000),
(0,0.012682,60,0,0.412980,6825.000000,20,0,2,0,0.000000),
(0,0.121557,58,0,0.342971,12000.000000,23,0,2,0,4.000000),
(0,0.040795,49,0,0.801999,3100.000000,11,0,1,0,0.000000),
(0,0.147712,40,0,0.034848,6800.000000,6,0,0,0,3.000000),
(0,0.000000,63,0,2.000000,5400.000000,4,0,0,0,0.000000),
(0,0.000000,50,1,0.726567,3477.000000,5,0,1,0,1.000000),
(0,0.070772,38,0,2088.000000,5400.000000,6,0,1,0,0.000000),
(1,1.046279,47,1,1.104301,5416.000000,6,0,2,0,1.000000),
(0,0.323720,63,0,0.610841,5146.000000,9,0,2,0,2.000000),
(0,0.364598,42,0,0.593899,6916.000000,7,0,3,0,0.000000),
(0,0.637736,54,2,3.382196,1875.000000,9,0,2,0,0.000000),
(0,0.081380,63,0,1268.000000,5400.000000,8,0,1,0,0.000000),
(0,0.020966,29,0,639.500000,1.000000,3,0,1,0,2.000000),
(0,0.170103,36,0,0.138462,7734.000000,8,0,0,0,0.000000),
(0,0.771846,33,0,0.852430,5000.000000,7,0,3,0,0.000000),
(0,0.055382,72,0,0.089091,4500.000000,4,0,0,0,0.000000),
(0,1.000000,29,0,974.000000,5400.000000,2,0,0,0,0.000000),
(0,0.166533,53,0,0.543626,7506.000000,11,0,3,0,3.000000),
(0,0.008632,79,0,0.365151,4200.000000,9,0,1,0,0.000000),
(0,0.135280,58,0,0.342005,9455.000000,11,0,2,0,2.000000),
(0,0.167571,69,0,0.330734,5000.000000,10,0,1,0,1.000000),
(0,1.000000,69,0,0.005319,2255.000000,0,1,0,0,3.000000),
(0,0.068335,75,0,0.010928,10065.000000,9,0,0,0,0.000000),
(0,0.000000,41,0,0.907539,2400.000000,6,0,1,0,0.000000),
(1,0.946964,35,0,1593.000000,5400.000000,6,0,1,0,1.000000),
(0,0.405184,46,0,0.667835,7700.000000,22,0,2,0,1.000000),
(0,0.055549,65,0,2177.000000,5400.000000,6,0,1,0,1.000000),
(0,0.676195,55,0,0.436666,3970.000000,10,1,1,0,0.000000),
(0,0.184987,55,4,3144.000000,5400.000000,11,0,1,0,0.000000),
(1,0.085338,51,0,0.477504,6200.000000,11,0,1,0,0.000000),
(1,0.000000,25,0,0.152897,2916.000000,3,0,0,1,0.000000),
(1,0.786485,44,0,0.291710,3883.000000,7,2,0,2,1.000000),
(0,0.011210,86,0,13.000000,5400.000000,3,0,0,0,0.000000),
(0,0.038335,56,0,0.438912,5000.000000,7,0,2,0,0.000000),
(0,0.714980,55,0,0.470902,15000.000000,12,0,2,0,3.000000),
(0,0.043032,64,0,0.332016,6833.000000,14,0,2,0,0.000000),
(0,1.095083,53,5,0.536704,3500.000000,7,1,1,2,0.000000),
(0,0.000000,49,0,2932.000000,5400.000000,11,0,1,0,0.000000),
(0,1.000000,55,0,0.156260,3250.000000,5,0,0,0,4.000000),
(0,0.101430,80,1,0.016197,5000.000000,9,0,0,0,0.000000),
(1,0.025892,38,0,74.500000,1.000000,13,0,0,0,2.000000),
(0,0.762159,44,4,0.224466,21000.000000,5,0,1,0,3.000000),
(0,0.231692,40,0,0.119661,3300.000000,7,0,0,0,0.000000),
(0,0.114869,35,0,103.000000,5400.000000,6,0,0,0,0.000000),
(0,0.035490,69,0,0.308439,3400.000000,9,0,1,0,0.000000),
(0,0.045424,64,0,0.181311,5200.000000,4,0,1,0,0.000000),
(0,0.311955,61,0,0.269281,9866.000000,12,0,2,0,2.000000),
(0,0.078739,46,0,0.166215,4800.000000,6,0,1,0,4.000000),
(0,0.137609,49,0,0.429534,7272.000000,11,0,2,0,0.000000),
(0,0.030173,64,0,0.173870,9000.000000,8,0,1,0,0.000000),
(0,0.021978,40,0,0.443756,10000.000000,12,0,5,0,2.000000),
(0,0.443697,27,0,0.024340,5833.000000,4,0,0,0,0.000000),
(0,0.007507,60,0,1253.000000,5400.000000,8,0,1,0,1.000000),
(0,0.046640,92,1,0.034327,2650.000000,13,0,0,0,0.000000),
(0,0.292366,50,0,0.420181,8750.000000,8,0,2,0,0.000000),
(0,0.208083,64,0,2826.000000,5400.000000,14,0,2,0,0.000000),
(0,1.000000,66,1,0.358101,1937.000000,4,1,0,0,0.000000),
(0,0.013501,53,0,0.183464,19000.000000,8,0,1,0,2.000000),
(0,1.000000,62,0,0.049658,6000.000000,1,0,0,0,0.000000),
(1,0.655316,63,0,5223.000000,5400.000000,19,0,2,0,0.000000),
(0,1.000000,50,2,1208.000000,5400.000000,4,0,1,0,0.000000),
(0,0.028114,61,0,0.031349,2200.000000,12,0,0,0,0.000000),
(0,0.222696,42,0,800.000000,1.000000,3,0,1,0,2.000000),
(0,0.593985,63,0,0.332699,5250.000000,4,0,2,0,0.000000),
(0,0.017508,73,1,0.135589,4166.000000,12,0,1,0,0.000000),
(0,0.611866,72,0,0.045783,7600.000000,3,0,1,0,0.000000),
(0,0.333061,52,3,0.700153,5215.000000,15,0,2,1,0.000000),
(0,0.009025,45,0,0.376836,8167.000000,4,0,1,0,2.000000),
(0,0.260272,44,0,0.296855,6962.000000,11,0,1,0,0.000000),
(0,0.455951,63,1,0.701766,6001.000000,19,0,2,0,0.000000),
(0,0.080288,37,0,0.322446,6000.000000,7,0,1,0,0.000000),
(1,1.953488,38,0,0.153500,3556.000000,5,0,0,0,2.000000),
(0,0.181557,36,0,0.560720,2000.000000,7,0,1,0,1.000000),
(0,0.147124,41,0,0.436026,6400.000000,5,0,1,0,2.000000),
(0,0.025602,63,1,0.262774,10000.000000,8,0,1,0,0.000000),
(0,0.000000,76,0,0.002466,7704.000000,3,0,0,0,0.000000),
(0,0.196373,43,0,0.537486,2600.000000,10,0,1,0,0.000000),
(0,0.083945,64,0,0.588073,2900.000000,6,0,1,0,0.000000),
(0,0.034833,67,0,0.460246,12916.000000,9,0,2,0,0.000000),
(0,0.787522,52,0,0.353860,4416.000000,12,0,0,0,1.000000),
(0,0.000000,66,0,3730.000000,5400.000000,8,0,1,0,0.000000),
(0,0.125429,55,0,0.476705,5000.000000,3,0,2,0,0.000000),
(0,0.060375,42,0,0.578677,5833.000000,17,0,2,0,2.000000),
(0,1.000000,28,0,0.000000,5400.000000,0,0,0,0,0.000000),
(0,0.295928,47,0,0.283765,14000.000000,6,0,2,0,1.000000),
(1,0.973339,61,1,0.209962,5500.000000,11,0,0,1,1.000000),
(0,0.002857,73,0,0.000286,10500.000000,10,0,0,0,0.000000),
(0,0.877565,58,0,2825.000000,5400.000000,10,0,2,0,0.000000),
(0,1.000000,68,0,0.040493,6000.000000,0,0,0,0,0.000000),
(0,0.053432,41,0,0.203644,9000.000000,3,0,1,0,0.000000),
(0,0.732661,44,2,0.140420,9200.000000,15,0,1,0,0.000000),
(0,0.084220,42,0,0.458551,6694.000000,26,0,2,0,4.000000),
(0,0.114562,40,0,0.359964,10000.000000,20,0,2,0,2.000000),
(0,0.012151,78,0,0.008887,4500.000000,12,0,0,0,0.000000),
(0,0.081311,81,0,0.165567,3333.000000,4,0,0,0,0.000000),
(0,0.098113,49,0,0.257018,6625.000000,9,0,2,0,0.000000),
(1,1.048211,58,7,0.151957,3500.000000,12,0,0,0,0.000000),
(0,0.011884,54,0,0.092914,9750.000000,8,0,1,0,2.000000),
(0,0.752649,33,1,0.058323,7166.000000,6,0,0,0,0.000000),
(0,0.112321,53,0,0.266910,8500.000000,9,0,1,0,5.000000),
(0,0.000000,23,0,0.000000,1725.000000,1,0,0,0,0.000000),
(0,0.634327,49,1,0.123125,15000.000000,7,0,0,0,1.000000),
(0,0.155763,44,0,0.278077,4825.000000,4,0,1,0,2.000000),
(0,0.000000,63,0,0.007989,9387.000000,9,0,0,0,0.000000),
(0,0.090615,42,0,86.000000,5400.000000,5,0,0,0,0.000000),
(0,0.034645,65,0,0.125190,12500.000000,4,0,1,0,1.000000),
(0,0.027446,54,0,1612.000000,5400.000000,6,0,1,0,0.000000),
(0,0.412399,28,0,0.037260,4991.000000,5,0,0,0,0.000000),
(0,0.024671,78,0,392.000000,5400.000000,6,0,1,0,0.000000),
(0,0.046711,66,0,1.117953,2500.000000,12,0,1,0,0.000000),
(0,0.976532,32,0,0.264079,6800.000000,6,0,0,0,2.000000),
(0,0.007983,43,1,0.009691,208333.000000,11,0,1,0,1.000000),
(0,0.267541,59,0,0.637607,5700.000000,13,0,2,0,1.000000),
(0,0.019779,76,0,0.267149,2900.000000,9,0,0,0,0.000000),
(0,0.010402,68,0,0.094141,3600.000000,6,0,1,0,0.000000),
(0,1.000000,61,0,0.529549,1285.000000,3,0,1,0,0.000000),
(0,0.029816,68,0,0.175140,4464.000000,12,0,1,0,1.000000),
(0,0.181714,57,0,0.130453,11666.000000,17,0,1,0,1.000000),
(0,0.051369,68,0,0.445277,4668.000000,10,0,1,0,2.000000),
(0,0.292645,57,0,0.205928,26484.000000,11,0,2,0,3.000000),
(1,0.220824,46,1,0.637749,1705.000000,5,0,0,0,0.000000),
(0,0.008100,69,0,0.389896,8332.000000,3,0,1,0,0.000000),
(0,0.000000,44,0,0.326384,6666.000000,4,0,2,0,1.000000),
(0,0.006100,28,0,0.139429,3750.000000,8,0,0,0,0.000000),
(0,0.909539,53,1,0.595654,7500.000000,16,0,1,0,1.000000),
(0,0.941073,40,0,0.178184,8855.000000,9,0,1,0,0.000000),
(0,0.991667,36,1,0.554878,5411.000000,10,0,2,0,1.000000),
(0,0.691488,42,0,0.272722,16250.000000,11,0,1,0,1.000000),
(0,0.112855,64,0,0.307576,2652.000000,6,0,1,0,0.000000),
(0,0.260971,57,0,5439.000000,5400.000000,16,0,3,0,0.000000),
(0,0.048244,62,0,0.262879,16615.000000,11,0,1,0,1.000000),
(0,1.000000,47,0,0.092163,9493.000000,2,2,0,1,0.000000),
(0,1.000000,62,0,0.000000,5480.000000,3,0,0,0,0.000000),
(0,0.074256,49,0,0.347930,5000.000000,11,0,2,0,3.000000),
(0,0.144878,66,0,0.284462,8900.000000,9,0,1,0,0.000000),
(0,0.191002,54,0,0.705628,5081.000000,10,0,2,0,2.000000),
(0,0.219383,56,1,942.000000,5400.000000,9,0,1,0,1.000000),
(0,0.679814,83,0,0.689590,4216.000000,6,0,2,0,0.000000),
(0,2340.000000,45,0,0.339333,8333.000000,7,0,2,0,2.000000),
(0,0.371875,29,0,0.536289,2300.000000,9,0,1,0,3.000000),
(0,0.025856,67,0,0.083799,13054.000000,13,0,1,0,0.000000),
(0,0.547888,29,1,0.246515,2725.000000,5,0,0,1,0.000000),
(0,0.271669,46,1,0.282830,15800.000000,14,0,2,0,4.000000),
(0,0.085152,25,0,1005.000000,0.000000,5,0,0,0,0.000000),
(0,0.897203,68,0,0.787803,4000.000000,8,0,2,0,0.000000),
(0,0.258898,33,0,0.537441,4900.000000,3,0,1,0,1.000000),
(0,0.000000,55,1,0.039886,5590.000000,8,0,0,0,0.000000),
(0,0.035941,46,0,0.271186,6666.000000,10,0,1,0,3.000000),
(0,1.000000,66,0,0.046634,11600.000000,2,0,0,0,1.000000),
(0,0.465239,66,0,0.391428,3172.000000,8,1,1,0,0.000000),
(0,0.865423,48,0,0.075848,500.000000,1,0,0,0,0.000000),
(0,0.696412,52,0,0.408872,11000.000000,11,0,1,0,4.000000),
(0,0.544498,32,1,0.166767,6667.000000,5,1,0,0,0.000000),
(0,0.081238,51,0,0.066830,7750.000000,14,0,0,0,2.000000),
(0,0.948763,27,0,0.144948,4166.000000,5,0,0,0,0.000000),
(0,0.000000,32,2,0.463611,7460.000000,10,0,1,1,0.000000),
(0,0.016599,30,0,0.136576,1500.000000,5,0,0,0,0.000000),
(0,0.063330,37,0,0.329935,6179.000000,6,0,1,0,3.000000),
(0,0.093638,49,0,0.042837,8333.000000,10,0,0,0,1.000000),
(0,0.000000,37,0,0.184027,7900.000000,5,0,1,0,5.000000),
(0,0.730272,36,1,0.632794,5500.000000,10,0,2,0,0.000000),
(0,0.426371,62,1,0.406054,3666.000000,15,0,1,0,0.000000),
(0,0.948978,57,0,0.043745,8000.000000,3,0,0,0,1.000000),
(0,0.000000,59,0,0.000000,4200.000000,7,0,0,0,1.000000),
(0,1.002647,38,2,0.472543,3550.000000,8,1,0,1,4.000000),
(0,0.016478,92,0,10.000000,5400.000000,3,0,0,0,0.000000),
(0,0.042607,58,0,3976.000000,5400.000000,13,0,3,0,0.000000),
(0,0.022891,37,0,0.288477,6100.000000,16,0,1,0,0.000000),
(0,0.283822,63,0,0.750201,1244.000000,9,0,0,0,0.000000),
(0,0.319779,32,0,1.247340,12500.000000,12,0,8,0,0.000000),
(0,0.155241,52,0,0.483518,6946.000000,15,0,2,0,1.000000),
(0,0.013115,43,0,4211.000000,0.000000,21,0,2,0,2.000000),
(0,0.067259,29,1,0.168341,2090.000000,3,0,0,0,0.000000),
(0,0.284236,45,1,0.318891,7500.000000,9,0,1,0,2.000000),
(0,0.727560,38,0,0.712459,2423.000000,6,0,1,0,1.000000),
(0,0.687779,62,0,0.249471,7090.000000,15,0,0,0,0.000000),
(0,1.000000,29,0,0.000000,5400.000000,0,0,0,0,0.000000),
(0,0.033709,41,0,0.408706,6500.000000,9,0,1,0,2.000000),
(0,0.000000,29,0,0.193935,3000.000000,7,0,0,0,0.000000),
(1,0.037198,47,0,0.039758,25000.000000,11,0,1,0,3.000000),
(0,0.000000,55,1,0.388321,4400.000000,4,0,2,0,1.000000),
(0,0.053589,87,0,0.001534,5213.000000,4,0,0,0,0.000000),
(0,0.100773,41,0,0.199762,9230.000000,7,0,1,0,0.000000),
(0,0.000000,61,0,1.394967,913.000000,11,0,2,0,0.000000),
(0,0.399947,28,0,0.189703,4000.000000,6,0,0,0,1.000000),
(0,0.052653,43,0,0.572292,1984.000000,9,0,0,0,4.000000),
(0,0.072319,71,0,0.426412,4300.000000,8,0,2,0,1.000000),
(0,0.203960,46,0,0.072915,16100.000000,6,0,1,0,2.000000),
(0,1.000000,30,0,0.090341,5600.000000,1,0,0,0,0.000000),
(1,0.880371,43,0,0.461324,7523.000000,6,0,1,0,1.000000),
(0,0.429246,59,0,0.381254,15928.000000,17,0,1,0,1.000000),
(0,0.000000,47,0,773.000000,5400.000000,2,0,1,0,1.000000),
(0,0.049529,61,0,542.000000,5400.000000,15,0,0,0,0.000000),
(0,0.360908,72,0,0.356679,3697.000000,6,0,1,0,0.000000),
(0,0.335737,50,0,0.457222,5773.000000,9,0,1,0,1.000000),
(1,0.635721,68,1,0.218071,25000.000000,27,0,3,0,0.000000),
(0,0.000000,58,0,8380.000000,5400.000000,20,0,5,0,0.000000),
(0,0.507973,69,2,0.193935,3000.000000,10,2,0,2,0.000000),
(0,0.245842,71,0,151.000000,5400.000000,5,0,0,0,0.000000),
(1,0.953344,48,2,2073.000000,5400.000000,5,1,2,2,0.000000),
(0,1.000000,37,0,0.184626,4500.000000,2,0,0,0,1.000000),
(0,0.118854,50,0,2720.000000,5400.000000,7,0,1,0,2.000000),
(0,0.630074,38,0,0.563328,1886.000000,3,0,1,0,0.000000),
(0,1.000000,35,0,3388.000000,5400.000000,1,0,1,0,0.000000),
(0,0.028423,59,0,0.033982,14330.000000,12,0,1,0,0.000000),
(0,0.143428,67,0,0.119464,5666.000000,9,0,0,0,0.000000),
(0,0.186683,30,0,0.698121,2500.000000,7,0,2,0,2.000000),
(0,0.496389,56,0,0.170165,19580.000000,12,0,1,0,1.000000),
(0,0.457527,51,0,0.333583,8000.000000,16,0,2,0,2.000000),
(0,0.728218,40,1,3878.000000,5400.000000,10,0,2,0,0.000000),
(0,0.947265,28,0,0.467172,1187.000000,4,0,0,0,0.000000),
(0,0.013917,54,0,0.017656,4700.000000,7,0,0,0,2.000000),
(0,0.066347,46,1,4480.000000,5400.000000,6,0,2,0,0.000000),
(0,0.502958,57,0,6381.000000,5400.000000,5,0,2,0,0.000000),
(0,1.047496,35,2,0.314566,3871.000000,8,0,2,1,3.000000),
(0,0.012586,79,0,0.009596,2500.000000,11,0,0,0,0.000000),
(0,0.543446,46,0,0.267147,5000.000000,6,0,2,0,3.000000),
(0,0.026580,79,0,1063.000000,5400.000000,7,0,1,0,0.000000),
(0,0.082317,64,0,0.214426,8636.000000,29,0,1,0,1.000000),
(0,0.292541,74,0,0.164918,2000.000000,3,0,0,0,0.000000),
(0,0.024240,64,0,0.101514,10500.000000,20,0,1,0,0.000000),
(0,0.047650,63,0,0.387957,9000.000000,6,0,2,0,0.000000),
(1,0.739146,63,1,0.285157,6150.000000,12,0,0,0,1.000000),
(0,0.186891,54,0,0.655589,3640.000000,7,0,1,0,1.000000),
(0,0.007502,63,0,0.278226,8050.000000,13,0,2,0,3.000000),
(0,0.522315,45,0,0.290229,14491.000000,13,0,1,0,3.000000),
(0,1.000000,22,0,130.000000,5400.000000,0,0,0,0,0.000000),
(0,0.571605,66,0,870.000000,5400.000000,12,0,0,0,0.000000),
(0,0.903232,57,0,0.130809,5228.000000,10,0,0,0,0.000000),
(0,0.017044,43,0,0.108214,2300.000000,6,0,0,0,1.000000),
(0,0.060733,61,0,0.008550,20000.000000,8,0,0,0,0.000000),
(0,0.000583,54,0,2028.000000,5400.000000,13,0,1,0,1.000000),
(0,0.003895,90,0,876.000000,5400.000000,11,0,1,0,0.000000),
(0,0.250008,60,0,2.086479,7550.000000,26,0,0,0,0.000000),
(0,0.466334,34,2,0.007495,3201.000000,3,0,0,0,0.000000),
(0,0.114589,38,0,34.000000,5400.000000,2,0,0,0,0.000000),
(0,1.000000,60,0,0.000000,4200.000000,0,0,0,0,0.000000),
(0,0.267906,76,0,0.285453,8200.000000,12,0,0,0,0.000000),
(0,0.029694,76,0,0.070513,9600.000000,7,0,0,0,2.000000),
(0,0.305246,39,0,0.188282,10154.000000,6,0,1,0,2.000000),
(0,0.000686,83,0,0.000000,5400.000000,4,0,0,0,0.000000),
(0,0.702494,63,0,0.582163,4697.000000,8,0,2,0,1.000000),
(0,0.742436,52,0,0.414081,9700.000000,10,0,2,0,0.000000),
(1,0.802417,58,1,668.000000,5400.000000,5,1,0,0,0.000000),
(0,1.000000,42,1,0.113422,6250.000000,3,3,0,1,2.000000),
(0,0.134192,63,0,926.500000,1.000000,9,0,1,0,0.000000),
(0,0.002556,58,0,0.115826,7752.000000,17,0,0,0,2.000000),
(0,0.088846,62,0,0.073772,5394.000000,5,0,0,0,0.000000),
(0,0.203948,46,1,1.206516,5800.000000,12,1,4,0,2.000000),
(0,0.006666,27,0,0.000269,7444.000000,5,0,0,0,0.000000),
(0,0.014050,27,0,0.352215,3724.000000,4,0,1,0,1.000000),
(0,1.000000,35,1,0.092985,3064.000000,1,0,0,0,3.000000),
(0,0.368867,55,0,0.437996,9700.000000,18,0,2,0,0.000000),
(0,0.054553,73,0,0.043259,16666.000000,13,0,0,0,0.000000),
(0,0.179488,51,0,0.492530,10173.000000,19,0,4,0,0.000000),
(0,0.026886,36,0,0.344880,11200.000000,6,0,2,0,2.000000),
(0,0.265705,56,0,0.259103,31666.000000,8,0,3,0,1.000000),
(0,0.000000,59,0,2113.000000,5400.000000,13,0,2,0,0.000000),
(0,0.011848,49,0,1599.000000,5400.000000,12,0,1,0,0.000000),
(0,0.070838,64,0,0.255291,6000.000000,6,0,0,0,1.000000),
(0,0.030996,56,0,0.131431,4800.000000,11,0,1,0,0.000000),
(0,0.144914,37,0,0.045366,6700.000000,5,0,0,0,0.000000),
(0,0.353018,48,0,1.299736,4166.000000,17,0,1,0,1.000000),
(0,0.020075,36,0,0.334245,4750.000000,5,0,1,0,0.000000),
(0,0.032769,70,0,724.000000,5400.000000,11,0,1,0,0.000000),
(1,0.733885,49,2,0.369224,8785.000000,20,0,2,0,2.000000),
(0,0.063514,57,0,2221.500000,1.000000,12,0,2,0,0.000000),
(0,0.031572,39,0,0.644706,3900.000000,14,0,1,0,1.000000),
(1,0.991502,61,10,1.297901,3000.000000,11,2,3,5,1.000000),
(0,0.397703,38,0,0.416275,5750.000000,6,0,1,0,2.000000),
(0,0.971352,24,0,0.035803,1200.000000,3,0,0,0,0.000000),
(0,1.000000,33,0,1786.000000,5400.000000,3,0,1,0,0.000000),
(0,0.000000,73,0,0.386728,4550.000000,18,0,0,0,0.000000),
(0,1.000000,79,0,0.130141,5178.000000,6,0,1,0,0.000000),
(0,0.003852,81,0,0.000822,3648.000000,1,0,0,0,1.000000),
(0,0.010888,55,0,0.725137,2000.000000,7,0,2,0,0.000000),
(0,0.686083,57,0,0.160696,11667.000000,6,1,1,0,2.000000),
(0,0.212464,58,0,0.518991,3290.000000,10,0,1,0,1.000000),
(0,0.006956,52,0,0.003279,2439.000000,4,0,0,0,0.000000),
(0,0.073252,51,0,0.446688,10250.000000,9,0,1,0,2.000000),
(0,0.431904,63,0,0.419052,8208.000000,22,1,2,0,0.000000),
(0,0.007000,97,0,3.000000,5400.000000,2,0,0,0,0.000000),
(0,0.014310,56,0,13.000000,5400.000000,2,0,0,0,0.000000),
(0,0.026944,41,0,0.686736,4583.000000,8,0,3,0,0.000000),
(0,0.297095,43,1,0.603763,3666.000000,9,0,1,0,2.000000),
(0,0.316065,56,0,1348.000000,5400.000000,3,0,1,0,0.000000),
(0,0.000000,59,0,862.000000,5400.000000,2,0,1,0,0.000000),
(0,0.922670,40,0,0.207789,9345.000000,7,0,0,0,0.000000),
(0,0.051078,74,0,0.306409,3416.000000,9,0,1,0,0.000000),
(0,0.319191,49,0,0.358153,9400.000000,18,0,2,0,0.000000),
(0,0.008737,68,0,0.209965,6000.000000,28,0,1,0,0.000000),
(0,0.000000,57,0,0.785230,6783.000000,8,0,3,0,0.000000),
(0,0.243674,48,0,0.179980,8900.000000,10,0,1,0,6.000000),
(0,1.000000,40,1,0.191706,3833.000000,3,2,0,0,2.000000),
(0,0.000000,23,0,0.000000,3500.000000,1,0,0,0,1.000000),
(0,0.028911,52,0,0.013544,5389.000000,7,0,0,0,2.000000),
(0,0.034239,48,0,2045.000000,5400.000000,3,0,1,0,0.000000),
(0,0.503299,55,0,0.454057,3166.000000,5,0,2,0,0.000000),
(0,0.799982,61,3,0.671076,5064.000000,19,0,3,1,0.000000),
(0,0.069988,33,0,0.114005,3762.000000,7,0,0,0,0.000000),
(0,0.067901,69,0,0.065493,10000.000000,5,0,1,0,0.000000),
(0,0.740635,39,0,0.432010,5566.000000,7,0,1,0,0.000000),
(0,0.023383,84,0,0.009128,4600.000000,6,0,0,0,0.000000),
(0,1.000000,32,2,0.095585,2060.000000,1,0,0,0,0.000000),
(0,0.003625,78,0,726.000000,5400.000000,8,0,1,0,0.000000),
(0,0.092288,61,0,0.229436,7500.000000,23,0,2,0,2.000000),
(0,0.000000,37,0,0.177007,7236.000000,5,0,1,0,3.000000),
(0,1.000000,33,1,0.257707,5416.000000,2,2,1,0,1.000000),
(0,0.057868,81,0,0.145685,3939.000000,13,0,0,0,0.000000),
(0,0.078077,60,0,0.566105,3917.000000,14,0,1,0,2.000000),
(0,0.201944,46,0,0.394461,10000.000000,15,0,2,0,3.000000),
(0,0.077959,57,0,0.053530,6500.000000,19,0,0,0,0.000000),
(0,0.205676,57,0,0.130310,8333.000000,8,0,1,0,0.000000),
(1,1.000000,32,0,0.006731,3416.000000,1,0,0,0,3.000000),
(1,0.579851,42,0,0.594224,2700.000000,8,0,0,0,0.000000),
(0,0.073393,38,1,0.384762,10000.000000,9,0,2,0,0.000000),
(0,0.079178,82,0,0.176965,5000.000000,3,0,1,0,0.000000),
(0,0.073123,33,0,0.216405,5290.000000,9,0,0,0,0.000000),
(0,0.745173,68,0,0.168768,4917.000000,4,0,1,0,0.000000),
(0,0.100883,52,1,0.280494,5500.000000,6,1,1,0,2.000000),
(0,0.347665,46,0,0.041583,2500.000000,1,0,0,0,1.000000),
(0,0.102032,66,0,90.000000,5400.000000,4,0,0,0,0.000000),
(0,0.354126,57,0,0.558762,4330.000000,4,0,1,0,0.000000),
(0,0.029643,50,0,0.399106,9400.000000,15,3,4,0,0.000000),
(0,0.540204,34,0,0.034395,7500.000000,3,1,0,0,0.000000),
(0,0.640927,53,4,0.524097,11266.000000,17,0,2,0,3.000000),
(0,0.058271,76,0,0.374304,4311.000000,7,0,1,0,0.000000),
(0,0.719306,64,0,0.186226,6228.000000,5,0,1,0,0.000000),
(0,0.045017,72,0,0.020764,3900.000000,8,0,0,0,0.000000),
(0,0.355928,48,0,0.478091,7667.000000,17,0,2,0,0.000000),
(0,0.577622,71,1,0.492500,6399.000000,14,0,2,0,1.000000),
(0,0.015054,59,0,929.000000,5400.000000,11,0,1,0,2.000000),
(0,0.320594,53,0,1.114622,5600.000000,14,0,1,0,1.000000),
(0,0.047587,34,0,997.000000,5400.000000,4,0,0,0,0.000000),
(0,0.173428,51,1,0.086269,5250.000000,11,0,0,0,0.000000),
(0,0.401789,55,0,0.412779,2550.000000,11,0,0,0,0.000000),
(0,0.301152,46,0,0.254662,7668.000000,10,0,1,0,3.000000),
(0,0.000000,27,2,0.229139,2264.000000,5,2,0,1,0.000000),
(0,0.067513,43,0,0.447236,9115.000000,4,0,2,0,0.000000),
(0,0.000000,75,0,0.205972,1640.000000,4,0,0,0,1.000000),
(0,0.993336,31,0,0.068227,4484.000000,6,0,0,0,1.000000),
(0,0.138794,43,0,0.384075,11666.000000,9,0,5,0,0.000000),
(0,0.193585,51,0,0.532755,3800.000000,13,0,2,0,0.000000),
(0,0.001125,28,1,0.057990,6000.000000,8,1,0,0,0.000000),
(0,0.485558,51,0,0.099635,6583.000000,5,0,0,0,0.000000),
(0,0.979522,55,1,0.467850,7433.000000,11,0,2,2,0.000000),
(0,0.090642,69,0,0.016683,4015.000000,2,0,0,0,0.000000),
(0,0.384808,42,0,0.533100,7416.000000,5,0,1,0,3.000000),
(0,0.183676,33,0,0.660528,2497.000000,9,0,1,0,0.000000),
(0,0.018125,60,0,0.023181,1250.000000,4,0,0,0,1.000000),
(1,1.000000,54,0,0.228403,2372.000000,2,0,0,1,0.000000),
(0,0.290320,48,0,0.262849,7996.000000,7,0,1,0,3.000000),
(0,0.052161,49,0,0.067629,6993.000000,5,0,0,0,1.000000),
(0,1.000000,73,0,8500.000000,0.000000,2,0,0,0,0.000000),
(0,1.000000,91,0,0.000000,5400.000000,3,0,0,0,0.000000),
(0,0.412658,66,1,0.195074,4100.000000,7,1,0,0,0.000000),
(0,0.091201,49,1,0.568886,5000.000000,15,0,2,0,0.000000),
(0,0.500235,46,0,0.278026,4700.000000,10,0,1,0,1.000000),
(1,0.913140,37,2,1.620345,4000.000000,16,0,3,0,1.000000),
(0,0.056390,54,0,2126.000000,5400.000000,8,0,1,0,0.000000),
(0,0.611389,22,0,0.347066,800.000000,4,0,0,0,0.000000),
(0,0.065631,31,0,0.162636,5250.000000,10,0,0,0,0.000000),
(0,0.499667,39,0,0.450172,3200.000000,8,0,1,0,0.000000),
(0,1.000000,56,0,7.000000,5400.000000,1,0,0,0,0.000000),
(0,0.289471,44,0,0.482561,8916.000000,17,0,2,0,1.000000),
(1,0.814155,50,1,0.297140,3600.000000,8,0,1,1,1.000000),
(0,0.016407,55,0,0.001786,5599.000000,3,0,0,0,2.000000),
(0,0.078497,52,0,0.207274,8220.000000,5,0,1,0,3.000000),
(0,0.029692,58,2,0.287188,6204.000000,19,0,1,0,0.000000),
(0,0.012559,62,0,0.044762,7416.000000,5,0,0,0,0.000000),
(0,0.062093,42,0,0.230262,8333.000000,6,0,1,0,4.000000),
(0,0.074201,47,0,1215.000000,5400.000000,4,0,1,0,0.000000),
(0,0.551890,42,1,0.790614,3600.000000,18,0,2,0,1.000000),
(1,0.640059,39,0,0.055985,9841.000000,9,0,0,0,2.000000),
(0,0.581816,45,0,0.724784,8000.000000,11,0,2,0,0.000000),
(0,0.000000,82,0,0.000000,5400.000000,3,0,0,0,0.000000),
(0,0.000000,64,0,3819.000000,5400.000000,3,0,2,0,0.000000),
(0,0.312069,55,1,0.127072,1266.000000,5,0,0,0,0.000000),
(0,0.266371,58,0,0.498488,12900.000000,12,0,1,0,2.000000),
(0,0.040186,35,0,0.300839,5600.000000,8,0,2,0,1.000000),
(0,0.749602,62,0,7963.000000,5400.000000,7,0,2,0,3.000000),
(1,0.955546,52,1,0.524950,10480.000000,11,0,3,0,1.000000),
(0,0.086635,40,0,887.000000,0.000000,8,0,1,0,1.000000),
(0,0.212768,57,0,2301.000000,5400.000000,17,0,2,0,0.000000),
(0,0.954396,45,2,0.484214,8836.000000,10,0,1,0,1.000000),
(0,0.188256,27,0,0.881825,3900.000000,6,0,1,0,1.000000),
(0,1.245847,24,1,499.000000,5400.000000,4,1,0,0,0.000000),
(0,0.014050,37,0,0.674400,6120.000000,9,0,1,0,0.000000),
(0,0.329610,36,0,0.437743,3597.000000,16,0,2,0,2.000000),
(0,0.484100,40,0,0.423252,10794.000000,9,0,2,0,2.000000),
(0,0.000000,86,0,2.000000,5400.000000,9,0,0,0,0.000000),
(0,0.035114,56,0,87.000000,5400.000000,11,0,0,0,0.000000),
(0,0.084827,59,0,0.534182,3612.000000,9,0,2,0,0.000000),
(0,1.000000,40,0,0.606166,7200.000000,6,0,3,0,0.000000),
(0,0.152251,49,0,0.030774,9000.000000,3,0,0,0,0.000000),
(0,0.212886,66,0,0.351892,5100.000000,10,0,1,0,0.000000),
(0,1.000000,63,3,0.200843,5217.000000,5,0,1,1,4.000000),
(0,1.000000,45,0,461.000000,5400.000000,2,0,0,0,0.000000),
(0,0.000000,30,0,0.000000,4700.000000,1,0,0,0,1.000000),
(0,0.576285,36,0,0.785405,3000.000000,10,0,1,0,1.000000),
(0,0.408216,39,0,677.000000,5400.000000,4,0,0,0,2.000000),
(0,0.000000,27,0,0.000000,4500.000000,5,0,0,0,0.000000),
(0,0.106800,44,3,0.747375,6000.000000,8,0,3,0,2.000000),
(0,0.004553,34,0,3.000000,5400.000000,2,0,0,0,0.000000),
(0,0.277436,59,0,0.388567,3620.000000,8,0,1,0,1.000000),
(0,0.285343,38,0,0.089511,3250.000000,4,0,0,0,3.000000),
(0,0.162077,38,0,0.024885,70000.000000,6,0,1,0,2.000000),
(0,0.570738,39,0,1314.000000,5400.000000,5,2,2,0,0.000000),
(0,0.622525,43,0,0.353884,10234.000000,8,0,1,0,0.000000),
(0,0.113165,57,0,3169.000000,5400.000000,16,0,1,0,3.000000),
(0,0.000000,75,0,0.527431,801.000000,4,0,1,0,0.000000),
(0,0.732711,29,0,0.338531,8400.000000,10,0,1,0,0.000000),
(0,0.486651,55,0,0.324742,9000.000000,10,0,2,0,0.000000),
(0,0.584845,60,0,0.293638,6003.000000,11,0,1,0,0.000000),
(0,0.875441,37,0,0.437717,1436.000000,5,0,0,0,1.000000),
(0,0.043862,69,0,0.064119,6908.000000,7,0,1,0,0.000000),
(0,0.039296,48,0,0.480393,7420.000000,10,0,2,0,0.000000),
(1,0.339504,89,1,0.549380,2500.000000,9,3,0,1,0.000000),
(0,0.064835,56,2,0.197625,8166.000000,10,0,1,0,0.000000),
(0,0.008685,75,0,0.001327,8289.000000,5,0,0,0,0.000000),
(0,1.000000,55,1,0.138721,4144.000000,1,0,0,0,0.000000),
(0,0.503588,63,0,1.308923,4000.000000,16,0,1,0,0.000000),
(0,0.000309,49,0,562.000000,5400.000000,10,0,1,0,0.000000),
(0,0.697813,31,0,0.236980,12000.000000,10,0,0,0,1.000000),
(0,0.650433,61,0,0.368063,10000.000000,10,0,1,0,1.000000),
(0,0.302482,46,0,0.348057,7900.000000,12,0,1,0,2.000000),
(0,1.000000,40,0,0.185756,2400.000000,1,2,0,0,0.000000),
(0,0.159116,91,0,0.184123,1813.000000,6,0,0,0,0.000000),
(0,0.768537,46,0,2568.000000,5400.000000,5,0,0,0,0.000000),
(0,0.155644,56,0,0.336832,2000.000000,5,0,1,0,0.000000),
(0,0.836294,29,3,0.260170,4350.000000,8,0,1,0,1.000000),
(0,0.293042,45,0,0.373941,3775.000000,5,0,1,0,3.000000),
(0,1.000000,49,1,0.098938,4800.000000,1,0,0,0,4.000000),
(0,0.271898,64,0,556.000000,5400.000000,3,0,1,0,0.000000),
(0,0.000000,51,0,0.238076,10000.000000,6,0,1,0,0.000000),
(0,0.291956,45,0,1021.000000,5400.000000,5,0,0,0,0.000000),
(0,0.106531,78,0,0.024303,5595.000000,9,0,0,0,0.000000),
(0,0.250818,36,0,0.240144,5833.000000,6,0,2,0,1.000000),
(0,0.181580,54,0,0.353943,6048.000000,9,0,1,0,1.000000),
(0,0.002965,67,0,0.349027,16800.000000,14,0,5,0,0.000000),
(0,0.048911,63,0,0.102801,6283.000000,4,0,0,0,1.000000),
(1,0.517045,61,0,0.572590,7500.000000,20,0,2,0,0.000000),
(0,0.024100,86,0,0.010791,2223.000000,6,0,0,0,0.000000),
(0,0.122976,50,0,0.454103,3289.000000,6,0,1,0,1.000000),
(1,0.387066,51,0,0.350874,5833.000000,12,0,1,2,1.000000),
(0,0.021742,70,0,0.187762,5000.000000,11,0,1,0,0.000000),
(0,0.269257,44,0,0.607595,1500.000000,7,0,0,0,3.000000),
(0,0.996302,39,2,0.306102,10930.000000,17,0,0,0,1.000000),
(0,0.019154,49,0,0.201026,33333.000000,6,0,3,0,4.000000),
(0,0.008666,58,0,1.908629,6500.000000,17,0,5,0,0.000000),
(0,0.155742,39,0,723.000000,0.000000,13,0,0,0,2.000000),
(0,0.733914,33,0,0.158976,4333.000000,7,1,0,0,1.000000),
(0,0.210443,53,0,0.513602,5770.000000,10,0,2,0,1.000000),
(0,0.095635,36,0,0.175267,2247.000000,4,0,0,0,1.000000),
(0,0.124801,62,0,0.566894,6584.000000,15,0,2,0,0.000000),
(0,0.016995,62,0,0.002302,5212.000000,4,0,0,0,0.000000),
(0,0.964038,29,1,0.263517,2200.000000,6,0,0,0,0.000000),
(0,0.211206,44,1,0.213839,2080.000000,13,1,0,1,0.000000),
(0,0.184477,32,0,0.444956,7166.000000,11,0,2,0,0.000000),
(0,0.000000,52,0,0.444444,3500.000000,5,0,2,0,1.000000),
(0,0.086605,69,0,73.000000,5400.000000,2,0,0,0,0.000000),
(0,0.069070,71,0,1468.000000,5400.000000,3,0,1,0,0.000000),
(0,0.187091,63,0,0.506873,4000.000000,10,0,2,0,1.000000),
(0,0.732202,44,0,0.258577,12912.000000,26,0,0,0,0.000000),
(0,0.392141,54,0,1.383017,3850.000000,18,0,2,0,2.000000),
(0,0.063689,41,0,0.266877,6665.000000,8,0,0,0,1.000000),
(0,0.616982,32,1,0.191649,6250.000000,10,0,0,0,2.000000),
(0,0.288541,87,1,0.571429,1700.000000,23,0,0,0,0.000000),
(0,0.221107,43,0,0.157213,7333.000000,5,0,1,0,0.000000),
(0,0.193613,47,0,0.020147,5856.000000,1,0,0,0,3.000000),
(0,0.014441,75,0,0.145704,16059.000000,8,0,1,0,0.000000),
(0,0.531963,64,2,0.480082,18500.000000,19,0,3,0,1.000000),
(0,0.346960,41,0,1.432687,1700.000000,13,0,3,0,2.000000),
(0,0.024306,30,0,1581.000000,5400.000000,6,0,1,0,0.000000),
(0,1.000000,40,0,2866.000000,0.000000,2,0,2,0,0.000000),
(0,0.000000,56,0,0.000000,6200.000000,2,0,0,0,0.000000),
(0,0.658540,55,0,0.489715,5541.000000,6,0,1,0,0.000000),
(0,0.104694,36,0,0.297373,4300.000000,8,0,1,0,1.000000),
(0,0.046740,57,0,0.404800,11916.000000,13,0,3,0,0.000000),
(0,0.057888,56,0,0.238128,4400.000000,13,0,1,0,1.000000),
(0,0.883182,49,0,0.183737,4500.000000,18,0,0,0,2.000000),
(0,0.005326,53,0,79.000000,0.000000,4,0,0,0,0.000000),
(0,0.088810,51,0,0.295480,7123.000000,12,0,1,0,0.000000),
(0,0.021320,64,0,0.244968,2334.000000,13,0,1,0,0.000000),
(0,0.281880,28,0,0.179975,2416.000000,7,0,0,0,0.000000),
(0,0.063062,54,0,4659.000000,5400.000000,5,0,2,0,0.000000),
(0,0.000000,53,0,2719.000000,5400.000000,5,0,1,0,0.000000),
(1,0.402346,37,0,0.337622,12667.000000,16,0,2,0,3.000000),
(0,0.143317,70,3,4294.000000,5400.000000,16,0,5,1,0.000000),
(0,0.334296,48,0,5368.000000,5400.000000,13,0,2,0,0.000000),
(0,0.010350,52,0,0.258589,3812.000000,6,0,1,0,1.000000),
(0,0.336596,36,0,0.080372,1181.000000,2,0,0,0,0.000000),
(0,0.044843,51,0,0.233590,11318.000000,5,0,1,0,2.000000),
(0,0.007712,69,0,0.156614,3000.000000,6,0,0,0,0.000000),
(0,1.011333,52,0,10.800499,400.000000,8,0,1,0,2.000000),
(0,0.066779,67,0,84.000000,5400.000000,7,0,0,0,0.000000),
(0,0.000000,36,0,0.370419,7666.000000,4,0,1,0,2.000000),
(0,0.000000,49,0,0.622736,1600.000000,10,0,1,0,1.000000),
(1,0.314686,51,3,0.160318,16984.000000,13,0,2,1,4.000000),
(1,0.149314,36,0,0.558320,4500.000000,9,0,3,0,0.000000),
(0,0.000000,33,0,0.238213,2841.000000,9,0,0,0,0.000000),
(0,0.037850,62,0,0.162892,8741.000000,15,0,1,0,0.000000),
(0,0.281116,69,0,0.162186,4500.000000,10,0,0,0,1.000000),
(0,0.005196,70,0,1514.000000,5400.000000,9,0,2,0,0.000000),
(0,0.133689,49,0,0.093522,4800.000000,7,0,0,0,2.000000),
(0,0.321458,46,2,1434.000000,5400.000000,6,0,1,1,0.000000),
(0,0.000000,65,0,0.416379,6666.000000,10,0,1,0,0.000000),
(0,0.827151,56,1,0.219975,8700.000000,8,0,0,1,1.000000),
(0,0.442798,51,0,2092.000000,5400.000000,11,0,0,0,2.000000),
(0,0.025082,57,0,0.360880,3000.000000,15,0,0,0,0.000000),
(0,0.578849,48,0,0.367554,6613.000000,10,0,1,0,1.000000),
(0,0.020704,47,0,0.645104,3400.000000,6,0,1,0,2.000000),
(1,1.248751,33,0,0.175120,2700.000000,3,2,0,0,0.000000),
(0,1.000000,75,0,8.000000,5400.000000,2,0,0,0,0.000000),
(0,0.569824,40,0,0.361422,11000.000000,18,0,1,0,2.000000),
(0,0.914867,40,0,0.517037,4900.000000,7,0,1,0,1.000000),
(0,0.038258,68,0,0.009832,6000.000000,12,0,0,0,0.000000),
(0,0.964561,35,4,0.305840,4400.000000,10,3,0,2,2.000000),
(0,0.027313,65,0,0.325336,2083.000000,6,0,0,0,0.000000),
(0,0.035606,81,0,0.017261,7125.000000,7,0,0,0,0.000000),
(0,0.004595,52,0,0.390959,7166.000000,7,0,1,0,0.000000),
(0,0.042534,69,0,0.009691,6500.000000,4,0,0,0,1.000000),
(0,0.121365,34,0,3300.000000,5400.000000,5,0,2,0,0.000000),
(0,0.180162,40,0,0.448327,9501.000000,15,0,2,0,1.000000),
(0,0.054940,35,0,0.662153,5833.000000,10,0,2,0,2.000000),
(0,0.099724,80,0,0.008908,11000.000000,3,0,0,0,0.000000),
(0,0.030513,68,0,48.000000,5400.000000,6,0,0,0,0.000000),
(0,0.175434,47,0,0.149078,4500.000000,9,0,0,0,0.000000),
(0,0.019883,64,0,0.028600,6083.000000,16,0,0,0,0.000000),
(1,0.990764,36,2,0.361340,4117.000000,4,0,0,0,1.000000),
(0,0.386084,49,0,0.166452,11666.000000,17,0,0,0,3.000000),
(0,0.008287,55,0,0.115171,7032.000000,8,0,1,0,0.000000),
(0,0.058688,35,0,0.335733,8333.000000,6,0,2,0,2.000000),
(0,0.091107,63,0,0.035418,3500.000000,5,0,0,0,0.000000),
(0,0.023114,64,0,0.513540,9083.000000,16,0,3,0,0.000000),
(0,0.083427,64,0,0.037871,2930.000000,7,0,0,0,2.000000),
(0,0.529412,26,1,0.017052,820.000000,1,0,0,0,0.000000),
(0,0.192722,77,0,0.457931,7035.000000,21,0,1,0,1.000000),
(0,1.000000,32,0,0.177956,4000.000000,1,2,0,0,0.000000),
(0,0.359412,54,0,3.874423,1082.000000,22,0,1,0,0.000000),
(0,0.106517,40,0,0.263152,8800.000000,17,0,3,0,4.000000),
(0,0.079538,53,0,2958.000000,5400.000000,9,0,1,0,2.000000),
(1,2066.000000,58,0,0.271121,6000.000000,8,1,1,0,1.000000),
(0,0.012399,50,3,0.207519,11916.000000,4,0,1,0,0.000000),
(0,1.000000,56,0,0.007119,12500.000000,2,0,0,0,2.000000),
(0,0.003939,75,0,0.199949,7876.000000,11,0,2,0,0.000000),
(0,0.520419,36,1,0.232918,2648.000000,5,0,0,0,3.000000),
(0,0.160899,33,0,0.182364,3333.000000,13,0,0,0,0.000000),
(0,0.252505,52,0,0.442593,6000.000000,13,0,1,0,2.000000),
(0,0.035670,62,0,0.427675,9401.000000,9,0,4,0,0.000000),
(0,0.046748,60,0,1.012369,3233.000000,13,0,2,0,0.000000),
(0,0.009640,52,0,0.262440,4400.000000,5,0,0,0,0.000000),
(0,0.986400,36,0,0.441869,11000.000000,8,0,2,0,0.000000),
(0,0.092392,71,2,0.190062,13000.000000,7,0,1,0,0.000000),
(0,0.001020,83,0,0.000200,5000.000000,10,0,0,0,0.000000),
(0,0.000000,76,0,272.000000,0.000000,6,0,0,0,0.000000),
(0,0.045517,40,0,0.090355,11000.000000,12,0,0,0,3.000000),
(0,0.245745,46,0,0.585122,6707.000000,21,0,1,0,3.000000),
(0,0.292159,78,0,605.000000,5400.000000,5,0,0,0,0.000000),
(0,1.000000,36,0,631.000000,5400.000000,1,0,1,0,0.000000),
(0,0.016142,76,0,0.668266,1666.000000,11,0,1,0,0.000000),
(0,0.759287,41,1,0.408476,1698.000000,4,0,0,0,1.000000),
(0,0.189734,60,0,0.045872,2833.000000,2,0,0,0,0.000000),
(0,0.049082,63,2,0.361939,16441.000000,12,0,1,0,1.000000),
(0,1.163184,52,0,0.319174,4213.000000,7,0,0,0,0.000000),
(0,0.238017,58,0,0.601017,7666.000000,5,0,3,0,0.000000),
(0,0.410946,56,0,0.712194,4575.000000,16,0,1,0,0.000000),
(0,0.476536,33,0,0.312937,5000.000000,4,0,1,0,0.000000),
(0,0.375050,64,0,0.011196,2500.000000,4,0,0,0,0.000000),
(0,0.116188,33,0,0.043739,4000.000000,9,0,0,0,0.000000),
(0,0.018498,40,0,64.000000,5400.000000,13,0,0,0,0.000000),
(0,0.254549,56,0,0.461357,8500.000000,15,0,2,0,4.000000),
(0,0.013574,60,0,0.711076,17000.000000,11,0,3,0,0.000000),
(0,1.000000,27,0,0.260763,3274.000000,3,0,0,1,2.000000),
(0,0.029185,41,0,0.336295,3600.000000,5,0,1,0,0.000000),
(0,0.985092,48,0,0.376906,3082.000000,4,0,1,0,0.000000),
(0,0.011905,69,0,1653.000000,5400.000000,20,0,2,0,0.000000),
(0,0.000000,39,0,0.735132,6708.000000,13,0,2,0,2.000000),
(0,0.312878,36,0,0.230721,8000.000000,28,0,0,0,0.000000),
(0,0.714893,34,1,0.870355,6000.000000,8,0,1,0,0.000000),
(0,0.060868,50,1,3074.000000,5400.000000,15,0,1,0,0.000000),
(0,0.141854,79,0,0.812871,3200.000000,8,0,2,0,0.000000),
(0,0.073192,54,0,0.020708,4490.000000,4,0,0,0,0.000000),
(0,0.473663,36,1,0.650675,2000.000000,8,0,0,0,0.000000),
(1,0.987669,39,5,0.691279,5010.000000,14,0,2,0,2.000000),
(0,0.061215,35,0,0.453693,21000.000000,7,0,2,0,0.000000),
(0,0.475252,38,1,0.428629,2500.000000,8,1,0,0,0.000000),
(0,0.243843,52,0,1321.000000,5400.000000,9,0,1,0,2.000000),
(0,0.621469,24,0,0.010079,4166.000000,3,0,0,0,0.000000),
(0,0.084589,76,0,0.044093,1201.000000,8,0,0,0,0.000000),
(0,0.880240,41,0,1290.000000,5400.000000,6,0,0,0,2.000000),
(0,0.087183,74,0,0.080495,1291.000000,6,0,0,0,0.000000),
(0,0.111715,47,0,0.315174,16666.000000,12,0,2,0,3.000000),
(0,0.000000,57,0,0.335066,10000.000000,11,0,2,0,3.000000),
(0,0.000000,63,0,0.052672,2600.000000,3,0,0,0,1.000000),
(0,0.000000,62,0,17.000000,5400.000000,4,0,0,0,0.000000),
(0,0.659179,39,0,0.285325,5866.000000,6,0,1,0,1.000000),
(0,0.101013,51,0,0.340373,12500.000000,21,0,2,0,1.000000),
(0,0.471803,60,0,0.365788,9633.000000,12,0,1,0,1.000000),
(0,0.224822,68,0,2284.000000,5400.000000,6,0,2,0,0.000000),
(0,0.249923,63,2,0.254313,19416.000000,18,0,2,0,1.000000),
(0,0.000000,55,0,0.369192,7166.000000,7,0,3,0,1.000000),
(0,0.066285,58,0,0.228999,9213.000000,7,0,1,0,0.000000),
(0,0.025712,55,0,0.540703,3500.000000,8,0,1,0,2.000000),
(0,0.901510,33,1,0.128133,23100.000000,8,1,1,0,0.000000),
(1,0.023313,58,0,0.632371,4052.000000,13,1,2,0,0.000000),
(0,0.048541,55,1,0.215576,5700.000000,9,0,1,0,0.000000),
(0,0.077358,44,0,0.324268,10000.000000,10,0,2,0,0.000000),
(0,0.082452,57,0,0.891174,3500.000000,12,0,1,0,1.000000),
(0,1.000000,65,0,0.000000,615.000000,3,0,0,0,0.000000),
(0,0.140603,56,0,0.049700,11850.000000,11,0,0,0,2.000000),
(0,0.357285,25,0,0.001724,2900.000000,1,0,0,0,0.000000),
(0,0.002141,89,1,5.000000,0.000000,4,0,0,0,0.000000),
(1,0.000000,32,0,0.441874,3500.000000,5,0,1,0,2.000000),
(0,0.072378,48,0,0.399050,12000.000000,9,0,2,0,0.000000),
(0,0.228591,38,1,0.181233,2951.000000,4,0,0,0,0.000000),
(0,0.000000,58,0,526.000000,5400.000000,5,0,1,0,1.000000),
(0,0.000000,59,1,0.531464,7881.000000,8,2,1,0,0.000000),
(0,1.000000,32,0,0.132717,4000.000000,1,0,0,0,1.000000),
(0,0.015294,50,0,0.372514,1105.000000,13,0,0,0,0.000000),
(0,0.059184,26,0,0.067061,1520.000000,7,0,0,0,0.000000),
(0,0.211860,55,0,0.128716,6323.000000,8,0,0,0,1.000000),
(0,0.014688,82,0,13.000000,5400.000000,4,0,0,0,0.000000),
(0,0.019416,62,0,1203.000000,5400.000000,9,0,1,0,0.000000),
(0,0.012237,46,0,1189.000000,5400.000000,6,0,1,0,0.000000),
(0,0.917428,66,1,2410.000000,5400.000000,7,1,2,0,0.000000),
(0,0.716284,46,0,0.267752,5280.000000,10,0,2,0,2.000000),
(0,0.000549,59,0,0.000000,2236.000000,4,0,0,0,0.000000),
(0,0.004681,29,0,0.057389,5000.000000,4,0,0,0,0.000000),
(0,0.427591,39,0,0.342355,10862.000000,14,1,2,0,0.000000),
(0,0.982478,36,0,0.508164,3000.000000,3,0,1,0,0.000000),
(0,0.083486,71,0,0.170706,5611.000000,4,0,1,0,0.000000),
(0,0.010875,82,0,0.001287,7769.000000,6,0,0,0,0.000000),
(0,0.014647,26,0,0.121569,1274.000000,7,0,0,0,0.000000),
(1,1.008507,58,3,3265.000000,5400.000000,20,0,0,1,0.000000),
(0,0.537597,68,0,1591.000000,5400.000000,8,0,1,0,0.000000),
(0,0.994429,42,0,2336.000000,0.000000,11,0,2,0,3.000000),
(0,0.556143,58,0,0.177274,3000.000000,2,0,0,0,0.000000),
(1,1.257485,26,0,0.129805,1794.000000,1,2,0,1,0.000000),
(0,0.031594,33,0,523.000000,5400.000000,3,0,0,0,0.000000),
(0,0.354071,51,0,0.053522,6800.000000,5,0,0,0,0.000000),
(0,0.075627,60,0,0.193786,8400.000000,9,0,1,0,0.000000),
(0,0.002966,29,0,0.515939,3230.000000,8,0,1,0,0.000000),
(0,0.020391,79,0,0.225861,2350.000000,5,0,0,0,0.000000),
(0,0.045649,27,0,0.274952,4167.000000,21,0,1,0,0.000000),
(1,0.962947,50,0,0.681276,4106.000000,8,0,1,1,0.000000),
(0,0.160227,31,0,0.356019,2350.000000,5,0,0,0,0.000000),
(0,0.000000,45,0,0.735816,10416.000000,11,0,4,0,1.000000),
(0,0.067401,26,0,0.166518,4479.000000,10,0,0,0,0.000000),
(0,0.134375,63,0,111.000000,5400.000000,2,0,0,0,0.000000),
(0,1.000000,40,0,11.000000,5400.000000,0,0,0,0,0.000000),
(0,0.013219,57,0,0.085322,7500.000000,10,0,1,0,0.000000),
(0,0.000359,54,0,0.720070,4000.000000,11,0,0,0,0.000000),
(0,0.975146,33,0,0.332281,3800.000000,4,0,0,0,2.000000),
(0,0.255610,54,0,0.528551,3414.000000,9,0,1,0,1.000000),
(0,1.000000,24,0,0.000000,3833.000000,1,0,0,0,0.000000),
(0,0.682709,41,4,0.387087,13350.000000,8,0,4,0,1.000000),
(0,0.101551,47,0,228.000000,5400.000000,6,0,0,0,0.000000),
(0,0.013106,76,0,736.000000,5400.000000,15,0,1,0,0.000000),
(0,0.000000,87,0,2.000000,5400.000000,2,0,0,0,0.000000),
(0,0.040537,34,0,0.644091,3646.000000,11,0,1,0,0.000000),
(0,0.000000,46,0,0.107878,3642.000000,11,0,0,0,4.000000),
(0,0.013376,82,0,0.002606,8057.000000,7,0,0,0,0.000000),
(0,1.000000,48,0,0.165213,6421.000000,0,1,0,0,2.000000),
(0,0.198776,83,0,0.217065,2800.000000,9,0,0,0,0.000000),
(0,0.053596,86,0,68.000000,5400.000000,6,0,0,0,1.000000),
(0,0.178964,56,0,0.552931,6772.000000,6,0,1,0,1.000000),
(0,0.000000,90,0,0.000000,5400.000000,3,0,0,0,0.000000),
(0,0.003551,73,0,415.000000,5400.000000,11,0,0,0,0.000000),
(0,0.715720,33,0,1.002499,2800.000000,8,0,2,0,0.000000),
(0,0.011343,85,0,13.000000,5400.000000,5,0,0,0,0.000000),
(0,0.158100,45,2,0.475323,3950.000000,19,0,1,0,1.000000),
(0,0.626266,56,0,0.142385,5449.000000,5,0,0,0,0.000000),
(0,0.000000,31,0,0.432784,2000.000000,9,0,1,0,0.000000),
(0,0.482688,30,0,0.264842,8000.000000,9,0,2,1,1.000000),
(0,0.524916,32,0,969.000000,5400.000000,6,0,0,0,0.000000),
(0,0.335446,40,0,0.344680,4200.000000,6,0,2,1,0.000000),
(0,0.001877,79,0,0.013328,2400.000000,10,0,0,0,0.000000),
(0,0.235225,37,0,0.335037,4500.000000,5,0,1,0,1.000000),
(0,0.000000,63,0,779.000000,5400.000000,6,0,1,0,0.000000),
(0,0.000000,28,0,852.000000,5400.000000,3,0,0,0,0.000000),
(0,0.001901,69,0,0.000000,5455.000000,6,0,0,0,0.000000),
(0,0.107720,47,0,0.216281,9200.000000,12,0,3,0,2.000000),
(0,0.013399,71,0,0.012837,2336.000000,3,0,0,0,1.000000),
(0,0.064098,56,0,1387.000000,5400.000000,11,0,1,0,0.000000),
(0,0.547124,40,0,0.121319,9066.000000,6,0,0,0,4.000000),
(0,0.292568,64,0,2231.000000,0.000000,5,0,1,0,0.000000),
(0,0.157137,59,0,0.264912,3000.000000,8,0,0,0,1.000000),
(0,0.042203,28,0,0.286159,4500.000000,6,0,1,0,0.000000),
(0,0.734284,45,0,11311.000000,0.000000,6,0,2,1,0.000000),
(0,0.835312,31,1,0.332527,7854.000000,9,0,1,0,0.000000),
(0,0.511240,58,0,0.963084,9453.000000,13,0,3,0,1.000000),
(1,0.000000,44,0,6046.000000,5400.000000,9,0,3,0,0.000000),
(0,0.037477,37,0,0.079194,8333.000000,9,0,0,0,0.000000),
(0,0.000000,68,0,0.090386,4347.000000,5,0,0,0,0.000000),
(1,0.719760,47,0,64.000000,5400.000000,2,2,0,0,0.000000),
(0,0.047294,57,0,0.447143,5476.000000,14,0,1,0,0.000000),
(0,0.328685,51,0,1874.000000,5400.000000,6,0,1,0,0.000000),
(0,0.028084,50,0,0.380977,3910.000000,20,0,0,0,3.000000),
(0,0.003888,74,0,4.000000,5400.000000,3,0,0,0,0.000000),
(0,0.009655,73,0,0.122831,18553.000000,6,0,1,0,1.000000),
(1,0.778719,81,0,0.538013,4287.000000,11,0,2,0,0.000000),
(0,0.000000,58,0,0.411084,7000.000000,10,0,2,0,1.000000),
(0,0.054449,87,0,19.000000,5400.000000,1,0,0,0,0.000000),
(0,0.173784,55,0,0.196142,15916.000000,14,0,3,0,0.000000),
(0,0.457155,50,0,0.103425,13400.000000,7,0,0,0,2.000000),
(0,0.119461,34,0,0.322250,6916.000000,5,0,1,0,0.000000),
(0,0.717853,67,0,3174.000000,5400.000000,15,0,3,0,0.000000),
(0,0.607206,63,0,4627.000000,5400.000000,15,0,1,0,0.000000),
(0,0.276593,62,0,0.121836,19000.000000,8,0,1,0,0.000000),
(0,0.128420,59,0,0.226434,11000.000000,10,0,1,0,0.000000),
(0,0.059357,32,0,4121.000000,5400.000000,10,0,1,0,0.000000),
(0,0.000237,64,0,0.427788,6743.000000,10,0,1,0,0.000000),
(0,0.738421,72,0,2367.000000,5400.000000,11,0,1,0,0.000000),
(0,0.086492,64,0,0.074734,5833.000000,8,0,1,0,1.000000),
(0,0.222472,30,0,0.589816,3200.000000,4,0,1,0,0.000000),
(0,0.035755,79,0,0.008294,5666.000000,5,0,0,0,1.000000),
(0,0.003986,81,0,0.207165,3600.000000,10,0,1,0,0.000000),
(0,0.093742,41,2,0.718172,3675.000000,10,0,3,0,2.000000),
(0,0.231979,58,0,0.373801,10633.000000,28,0,4,0,0.000000),
(0,0.105970,55,0,3063.000000,5400.000000,8,0,1,0,0.000000),
(0,0.041411,45,0,0.008456,8750.000000,3,0,0,0,3.000000),
(0,0.223056,44,0,0.430297,12000.000000,13,0,2,0,3.000000),
(0,0.452864,49,0,0.330947,6006.000000,10,0,1,0,1.000000),
(0,0.016032,74,0,1202.000000,5400.000000,4,0,1,0,0.000000),
(0,1.000000,26,0,0.137821,1871.000000,1,0,0,0,0.000000),
(0,0.151892,59,0,0.301075,15075.000000,13,0,2,0,0.000000),
(0,0.606025,39,3,0.375647,7916.000000,10,0,2,0,2.000000),
(0,0.075168,48,0,1421.000000,5400.000000,3,0,1,0,0.000000),
(0,0.061834,49,0,2788.000000,5400.000000,6,0,2,0,0.000000),
(0,0.010186,47,0,0.022504,24750.000000,7,0,0,0,2.000000),
(0,0.515976,28,0,0.679854,4650.000000,14,0,1,0,0.000000),
(0,0.347921,42,0,0.373740,13000.000000,11,0,2,0,2.000000),
(0,0.108983,53,0,0.310352,4800.000000,10,0,1,0,0.000000),
(0,0.165721,68,0,0.311917,8575.000000,10,0,1,0,0.000000),
(0,0.194626,31,1,0.283572,4333.000000,20,0,0,0,0.000000),
(0,0.489875,34,0,0.319172,2800.000000,3,0,0,0,1.000000),
(0,0.958821,56,0,0.236574,9700.000000,12,0,1,0,1.000000),
(0,0.799018,30,0,1.298161,1250.000000,4,0,1,0,0.000000),
(0,0.011505,52,0,0.274253,4050.000000,9,0,1,0,0.000000),
(0,0.819116,54,0,0.528381,2853.000000,7,0,1,0,0.000000),
(0,0.000000,39,0,0.551779,2500.000000,7,0,2,0,0.000000),
(0,0.122544,57,0,0.428934,4333.000000,9,0,1,0,1.000000),
(0,0.667833,60,0,81.000000,5400.000000,2,0,0,0,0.000000),
(0,0.388257,45,0,1.112942,4975.000000,13,0,4,0,1.000000),
(0,2.258964,33,2,0.032484,2000.000000,1,1,0,0,2.000000),
(0,0.013767,64,0,2004.000000,5400.000000,10,0,2,0,0.000000),
(0,0.187798,85,0,790.000000,5400.000000,6,0,0,0,0.000000),
(0,1.000000,34,1,0.000000,5400.000000,0,1,0,0,0.000000),
(0,0.037380,37,0,0.333852,9000.000000,11,0,2,0,0.000000),
(0,0.003400,63,0,0.262695,2500.000000,5,0,0,0,0.000000),
(0,0.020480,35,0,1673.000000,5400.000000,10,0,1,0,1.000000),
(0,0.106476,32,0,0.802308,2685.000000,5,0,1,0,1.000000),
(0,0.518186,73,0,0.504887,8900.000000,17,0,1,0,1.000000),
(0,0.003736,39,0,0.459166,4150.000000,10,0,2,0,0.000000),
(0,1.000000,38,0,2628.000000,5400.000000,6,0,1,0,0.000000),
(0,0.196961,40,0,0.006959,4166.000000,1,0,0,0,0.000000),
(0,0.802994,42,1,0.524458,9178.000000,9,0,1,0,3.000000),
(0,1.000000,36,0,0.194964,2620.000000,3,0,0,0,0.000000),
(0,0.707146,64,0,3930.000000,5400.000000,13,0,2,0,0.000000),
(0,0.288593,51,0,0.226214,10131.000000,4,0,2,0,3.000000),
(0,0.397244,25,0,0.294853,2000.000000,5,0,0,0,0.000000),
(0,0.197441,36,0,777.000000,5400.000000,3,0,1,0,0.000000),
(0,0.004885,34,0,0.474905,5259.000000,11,0,2,0,2.000000),
(1,1.362142,73,1,274.000000,5400.000000,2,3,0,1,0.000000),
(0,0.175452,55,2,0.270180,9600.000000,11,0,2,0,0.000000),
(1,0.514353,39,0,0.984409,2308.000000,15,0,1,0,1.000000),
(0,0.000700,83,0,0.000000,10500.000000,4,0,0,0,0.000000),
(0,0.822400,63,0,0.515794,2500.000000,12,0,0,0,0.000000),
(0,0.042760,52,0,7806.000000,5400.000000,21,0,2,0,2.000000),
(0,0.222506,59,0,0.271467,11400.000000,9,0,2,0,0.000000),
(0,0.391046,24,0,0.069041,3200.000000,11,0,0,0,0.000000),
(0,0.028776,44,0,0.137224,5122.000000,4,0,0,0,0.000000),
(0,0.477368,36,0,0.339874,2700.000000,6,0,0,0,0.000000),
(0,0.018538,74,0,1184.000000,5400.000000,8,0,1,0,0.000000),
(0,0.041367,45,0,0.224578,10000.000000,8,0,0,0,2.000000),
(0,0.994270,41,0,2809.000000,5400.000000,5,0,2,0,0.000000),
(0,0.127160,63,0,0.454098,5489.000000,20,0,4,0,0.000000),
(0,0.610409,41,1,0.064417,2933.000000,7,0,0,0,2.000000),
(0,0.156646,45,1,0.560215,6700.000000,8,0,2,0,2.000000),
(0,0.526202,54,4,0.343546,25000.000000,9,0,3,0,1.000000),
(0,0.037379,76,1,0.372787,2880.000000,8,0,1,0,0.000000),
(0,0.163751,65,0,0.266873,10000.000000,13,0,1,0,0.000000),
(0,0.086383,38,0,2615.000000,5400.000000,6,0,1,0,0.000000),
(0,1.000000,47,0,0.370692,3800.000000,6,0,0,0,1.000000),
(0,0.029133,68,0,0.008222,10337.000000,10,0,1,0,1.000000),
(0,0.153647,34,0,1.220066,3916.000000,7,0,2,0,0.000000),
(0,0.083782,46,0,0.421202,5640.000000,16,0,1,0,2.000000),
(1,0.913774,55,2,0.881655,4300.000000,17,0,2,0,1.000000),
(0,0.251284,34,0,0.751458,8400.000000,18,0,4,0,0.000000),
(0,0.072587,29,0,0.046663,12000.000000,15,0,0,0,0.000000),
(0,0.000000,35,0,0.000000,1500.000000,3,0,0,0,0.000000),
(0,0.133614,43,1,0.421048,12000.000000,14,0,3,1,2.000000),
(0,0.001905,37,0,2.694611,500.000000,11,0,2,0,2.000000),
(0,0.040548,74,0,0.020737,5400.000000,5,0,0,0,0.000000),
(0,0.034529,55,0,0.514162,7166.000000,7,0,2,0,1.000000),
(0,0.010441,72,0,692.000000,5400.000000,7,0,0,0,0.000000),
(0,0.000000,80,1,1589.000000,5400.000000,8,0,1,0,0.000000),
(0,0.001882,50,0,1.317473,2500.000000,9,0,2,0,1.000000),
(0,0.015645,77,0,24.000000,5400.000000,5,0,0,0,0.000000),
(0,0.630902,73,0,0.047401,4577.000000,3,0,0,0,0.000000),
(0,0.000000,52,0,0.257757,8926.000000,11,0,1,0,2.000000),
(0,0.055228,48,0,0.146277,12407.000000,5,0,1,0,0.000000),
(0,0.946509,44,0,0.148162,2665.000000,5,0,0,0,1.000000),
(0,0.000000,50,0,0.000000,6400.000000,2,0,0,0,0.000000),
(0,0.833594,44,0,178.000000,5400.000000,9,0,0,0,0.000000),
(0,0.030328,70,0,1934.000000,5400.000000,11,0,2,0,0.000000),
(0,0.194273,53,0,817.000000,5400.000000,13,0,0,0,3.000000),
(0,0.000000,70,0,0.000000,3500.000000,6,0,0,0,0.000000),
(0,0.205656,36,0,2082.000000,5400.000000,13,0,2,0,0.000000),
(0,0.235753,63,0,724.000000,5400.000000,3,0,0,0,0.000000),
(0,0.029879,50,0,0.318734,13333.000000,11,0,3,0,1.000000),
(1,1.004422,48,3,0.605099,4000.000000,10,0,2,0,1.000000),
(0,0.154956,62,1,2446.000000,5400.000000,4,1,1,0,0.000000),
(0,0.016658,53,0,0.315187,9000.000000,6,0,1,0,0.000000),
(0,0.475841,43,0,0.198811,1850.000000,2,0,0,0,3.000000),
(0,0.061439,58,0,0.498693,6500.000000,19,0,4,0,1.000000),
(0,0.527904,67,0,486.000000,5400.000000,4,0,1,0,0.000000),
(0,0.319379,59,0,0.156959,6300.000000,22,0,0,0,0.000000),
(0,1.000000,55,0,0.167543,5323.000000,1,1,0,1,2.000000),
(0,0.077910,82,0,162.000000,5400.000000,2,0,0,0,0.000000),
(0,0.278636,47,0,0.587362,6867.000000,22,0,1,0,4.000000),
(0,0.352320,43,0,0.246785,8630.000000,8,0,0,0,1.000000),
(0,0.256315,58,3,1.511163,3000.000000,24,0,2,0,0.000000),
(0,0.000000,41,0,0.346902,5600.000000,4,0,1,0,0.000000),
(0,0.066114,63,0,0.621680,9750.000000,24,0,2,0,2.000000),
(0,0.749134,50,2,0.432120,4750.000000,17,0,1,0,0.000000),
(0,0.041992,32,0,85.000000,5400.000000,7,0,0,0,0.000000),
(0,0.212785,37,1,106.272727,21.000000,6,0,2,0,4.000000),
(0,0.951210,36,0,0.061445,2310.000000,2,0,0,0,2.000000),
(0,0.700331,45,1,0.546448,8966.000000,11,0,2,0,1.000000),
(0,0.000000,26,0,346.000000,5400.000000,8,0,0,0,0.000000),
(0,0.019328,80,0,0.180764,5000.000000,11,0,0,0,0.000000),
(1,0.878245,40,0,0.181417,3400.000000,5,0,0,0,1.000000),
(0,0.066929,35,0,0.611050,3637.000000,5,0,1,0,2.000000),
(0,0.110327,52,0,0.313440,6316.000000,16,0,2,0,1.000000),
(1,0.228743,38,2,3558.000000,5400.000000,19,0,3,0,2.000000),
(0,0.691722,78,0,0.691183,6430.000000,6,0,2,0,0.000000),
(0,0.275946,57,1,0.283412,13400.000000,10,0,1,0,0.000000),
(0,0.037454,57,0,0.355044,3300.000000,17,0,1,0,0.000000),
(0,0.357684,32,1,710.000000,5400.000000,6,0,0,0,0.000000),
(0,0.102951,43,1,0.252275,10000.000000,18,0,3,0,3.000000),
(0,1.000000,60,1,10.171276,3000.000000,4,0,1,1,0.000000),
(0,0.040283,54,0,0.135554,12400.000000,11,0,1,0,0.000000),
(0,0.352989,59,1,0.439556,13433.000000,18,0,2,0,2.000000),
(0,0.666949,56,0,0.185055,5700.000000,7,0,0,0,0.000000),
(0,0.181442,32,0,0.067878,8750.000000,2,0,0,0,0.000000),
(0,0.863214,29,0,0.102670,18836.000000,4,0,1,0,2.000000),
(0,0.093633,68,0,0.306847,4366.000000,6,0,2,0,0.000000),
(0,0.000000,50,0,0.000000,6250.000000,4,0,0,0,0.000000),
(0,0.479013,36,0,0.531660,4500.000000,14,0,1,0,2.000000),
(0,0.257067,37,0,0.291809,6140.000000,6,0,0,0,4.000000),
(0,0.024035,63,0,19.000000,5400.000000,2,0,0,0,0.000000),
(0,1.000000,42,0,0.217237,2250.000000,1,0,0,0,2.000000),
(0,0.001890,47,3,0.268693,6579.000000,15,0,2,2,1.000000),
(0,0.399034,32,0,0.433894,2200.000000,7,0,0,0,0.000000),
(0,1.000000,31,0,0.047962,3335.000000,2,0,0,1,4.000000),
(0,0.245931,39,0,0.537720,5500.000000,11,0,1,0,1.000000),
(0,0.003958,52,0,2574.000000,5400.000000,11,0,1,0,2.000000),
(0,0.408691,46,0,1.055196,4166.000000,12,0,2,0,0.000000),
(0,0.897369,57,0,2910.000000,5400.000000,16,0,0,0,0.000000),
(1,0.017559,47,0,0.535402,2513.000000,10,1,1,0,0.000000),
(0,0.115429,41,0,0.278969,6480.000000,12,1,1,1,0.000000),
(0,0.839837,49,0,3308.000000,5400.000000,8,0,2,0,1.000000),
(0,0.004384,36,0,0.637788,4466.000000,11,0,1,0,1.000000),
(0,0.383952,35,0,0.498567,15000.000000,18,0,2,0,0.000000),
(0,0.039609,50,0,1132.000000,5400.000000,13,0,0,0,0.000000),
(0,0.024643,75,0,0.009948,4221.000000,10,0,0,0,1.000000),
(0,1.000000,32,0,0.178302,3050.000000,1,0,0,1,2.000000),
(0,0.284500,66,0,1408.000000,5400.000000,8,0,0,0,1.000000),
(0,1.000000,38,1,0.134071,6503.000000,1,0,0,0,3.000000),
(0,0.224507,58,0,1068.000000,5400.000000,8,0,1,0,0.000000),
(0,0.643134,47,0,0.158998,7823.000000,3,0,0,0,0.000000),
(0,0.149038,44,0,0.288726,3130.000000,8,0,1,0,1.000000),
(1,0.546514,35,0,0.938243,8500.000000,17,0,4,0,2.000000),
(0,0.546016,39,0,0.407319,5000.000000,8,0,1,0,0.000000),
(0,0.149380,54,1,0.428758,8400.000000,14,0,1,0,1.000000),
(0,0.135083,58,0,0.065139,10300.000000,7,0,0,0,2.000000),
(0,0.016221,65,0,0.194925,2600.000000,9,0,2,0,3.000000),
(0,0.068039,55,0,2.496503,1000.000000,6,0,1,0,2.000000),
(0,0.038661,71,0,0.308086,8000.000000,7,0,1,0,0.000000),
(0,0.258812,35,0,3947.000000,5400.000000,4,0,1,0,0.000000),
(0,0.033458,80,0,0.431052,11000.000000,6,0,2,0,0.000000),
(0,1.000000,27,0,0.153061,2253.000000,3,0,0,0,0.000000),
(0,0.391215,39,1,0.287181,11100.000000,8,0,2,0,2.000000),
(0,0.377915,51,0,0.061148,8830.000000,5,0,0,0,1.000000),
(0,0.098408,47,0,0.069744,8100.000000,6,0,0,0,2.000000),
(0,0.039686,46,0,7.000000,5400.000000,6,0,0,0,1.000000),
(0,1.000000,51,1,35.000000,5400.000000,0,1,0,0,0.000000),
(1,0.829561,34,1,0.248188,4000.000000,6,0,1,0,2.000000),
(0,0.631259,39,0,0.273340,2816.000000,7,0,0,0,0.000000),
(0,0.034384,84,0,51.000000,5400.000000,10,0,0,0,0.000000),
(0,0.054538,53,0,0.266824,4650.000000,10,0,1,0,0.000000),
(0,0.500100,34,0,0.211072,8200.000000,3,0,1,0,0.000000),
(0,0.112820,81,0,0.312869,10000.000000,6,0,1,0,0.000000),
(0,0.012539,63,0,0.385101,2375.000000,12,0,2,0,0.000000),
(0,0.996102,43,0,2.579172,1641.000000,9,0,2,0,3.000000),
(1,0.232227,59,6,6.094453,2000.000000,16,2,1,2,1.000000),
(0,0.048037,30,0,2235.000000,5400.000000,5,0,1,0,0.000000),
(0,0.530405,61,1,0.469419,13782.000000,22,0,2,0,0.000000),
(0,0.520689,68,3,0.777370,6000.000000,9,0,3,0,0.000000),
(0,0.022136,48,0,0.003548,6200.000000,2,0,0,0,1.000000),
(0,0.101790,63,0,0.042235,2343.000000,5,0,0,0,0.000000),
(0,0.323482,26,0,262.000000,5400.000000,3,0,0,0,0.000000),
(0,0.014467,51,0,0.262962,4570.000000,28,0,2,0,0.000000),
(0,0.022421,72,0,1004.000000,5400.000000,6,0,1,0,0.000000),
(0,0.002350,66,0,0.391850,5103.000000,5,0,2,0,0.000000),
(0,0.192535,38,0,0.225742,12500.000000,12,0,2,0,0.000000),
(0,0.251804,66,0,0.611755,2500.000000,7,0,1,0,0.000000),
(0,0.088911,35,0,0.000526,3800.000000,3,0,0,0,0.000000),
(0,0.987743,50,0,0.447400,9999.000000,13,0,2,0,0.000000),
(0,1.000000,68,1,0.000000,5400.000000,0,1,0,0,0.000000),
(0,0.030761,62,0,0.015661,3000.000000,5,0,1,0,0.000000),
(0,0.218992,54,0,0.586138,3000.000000,13,0,1,0,0.000000),
(0,1.000000,38,0,0.110879,6700.000000,3,0,0,0,3.000000),
(0,0.000000,45,0,0.365017,7574.000000,10,0,2,0,1.000000),
(0,0.002072,58,0,0.210743,8749.000000,12,0,2,0,0.000000),
(0,0.223967,49,0,1632.000000,5400.000000,8,0,1,0,0.000000),
(0,0.220202,34,0,0.462355,4050.000000,10,0,2,0,1.000000),
(0,0.788340,43,0,0.099845,7100.000000,3,0,0,0,1.000000),
(0,0.034755,73,0,1627.000000,5400.000000,12,0,2,0,0.000000),
(0,0.000000,43,0,0.281729,15450.000000,10,0,2,0,5.000000),
(0,0.148226,63,0,1313.000000,5400.000000,11,0,2,0,0.000000),
(0,0.680283,80,0,0.429853,4568.000000,6,0,1,0,0.000000),
(0,0.179110,41,0,0.274918,9500.000000,10,1,1,0,2.000000),
(0,0.211368,60,0,0.240453,10500.000000,19,0,2,0,0.000000),
(0,0.012987,22,0,0.000000,0.000000,2,0,0,0,0.000000),
(0,0.247136,34,0,0.090524,5666.000000,3,0,0,0,1.000000),
(0,1.000000,43,0,0.129623,3000.000000,1,0,0,0,0.000000),
(1,0.000738,41,0,0.493127,4000.000000,4,0,1,0,2.000000),
(0,0.946978,34,0,0.335438,9500.000000,12,0,2,0,2.000000),
(0,0.866344,34,0,0.148025,2100.000000,1,0,0,0,0.000000),
(0,0.000000,87,0,0.067382,6900.000000,4,0,0,0,1.000000),
(0,1.000000,66,0,0.229471,11142.000000,6,0,1,0,0.000000),
(0,0.096114,41,0,0.224396,8025.000000,10,0,0,0,4.000000),
(0,0.000000,37,0,0.372395,7150.000000,3,0,2,0,2.000000),
(1,1.000000,41,0,219.000000,5400.000000,1,2,0,1,0.000000),
(0,0.275327,66,1,0.383178,5884.000000,17,0,1,0,0.000000),
(0,0.595112,33,0,0.378525,2020.000000,3,0,0,0,0.000000),
(0,0.026147,67,0,0.329780,1500.000000,7,0,1,0,0.000000),
(0,0.289270,48,0,0.691654,2000.000000,7,0,1,0,2.000000),
(0,0.040424,61,0,28.000000,5400.000000,6,0,0,0,0.000000),
(0,0.223678,67,0,0.326283,5200.000000,4,0,1,0,2.000000),
(0,0.077247,32,0,0.368421,4084.000000,7,0,1,0,0.000000),
(0,0.328303,59,1,0.480058,9000.000000,9,0,2,0,0.000000),
(0,0.572324,50,0,1.052171,3200.000000,12,0,1,0,3.000000),
(0,0.966275,37,0,0.683524,4290.000000,8,0,1,0,2.000000),
(0,0.075327,62,0,0.071378,12832.000000,7,0,1,0,0.000000),
(0,0.011074,52,0,0.012373,12850.000000,4,0,0,0,3.000000),
(0,0.369172,82,0,0.048229,26000.000000,12,0,1,0,0.000000),
(0,0.960431,63,0,0.315060,5052.000000,3,0,1,0,1.000000),
(0,0.123471,63,0,0.364188,2635.000000,6,0,1,0,1.000000),
(0,0.127494,64,0,0.094380,14875.000000,6,0,2,0,1.000000),
(0,0.087910,54,0,0.520624,20000.000000,8,0,3,0,2.000000),
(0,0.083766,53,0,0.342108,9116.000000,6,0,2,0,1.000000),
(0,0.000000,78,0,396.000000,5400.000000,3,0,0,0,0.000000),
(0,0.480927,62,0,1.031725,5200.000000,14,0,3,0,1.000000),
(0,0.009917,64,0,0.447431,5468.000000,12,0,2,0,0.000000),
(0,1.000000,37,0,0.377632,11256.000000,11,0,2,0,1.000000),
(0,0.078754,30,0,2129.000000,5400.000000,6,0,2,0,0.000000),
(0,0.135042,71,0,0.017903,10500.000000,14,0,0,0,0.000000),
(0,0.008000,65,0,15.000000,5400.000000,13,0,0,0,0.000000),
(0,0.099191,57,0,0.604399,3500.000000,9,0,2,0,0.000000),
(0,0.297398,52,0,0.579717,6014.000000,8,0,1,0,3.000000),
(0,0.307192,39,0,0.607185,5900.000000,5,0,2,0,0.000000),
(0,0.044225,39,0,1776.000000,5400.000000,4,0,2,0,0.000000),
(0,0.125015,66,2,0.404638,2500.000000,4,0,1,0,0.000000),
(0,0.004104,55,1,1.000000,0.000000,5,0,0,1,0.000000),
(0,0.013714,47,0,0.401268,6466.000000,6,0,2,0,0.000000),
(0,0.267353,72,0,0.426686,4166.000000,10,0,2,0,0.000000),
(0,0.163836,53,1,0.092763,2500.000000,5,0,0,0,0.000000),
(0,1.000000,70,0,0.000000,5400.000000,1,0,0,0,0.000000),
(0,0.820545,45,1,3799.000000,5400.000000,4,0,2,0,2.000000),
(0,0.428383,36,0,0.270612,6573.000000,12,0,1,0,0.000000),
(0,0.019999,52,0,0.188453,4000.000000,6,0,1,0,1.000000),
(0,0.089147,45,1,0.259748,5000.000000,7,0,2,0,0.000000),
(0,0.612031,74,2,0.769672,3138.000000,10,1,2,0,0.000000),
(0,0.000000,48,0,0.056924,10838.000000,4,0,0,0,1.000000),
(0,0.801765,35,1,0.430314,2130.000000,5,0,0,1,2.000000),
(0,0.000000,46,0,0.450289,5018.000000,9,0,1,0,0.000000),
(0,0.010751,76,0,0.117911,3790.000000,17,0,0,0,0.000000),
(0,0.901795,47,1,0.526745,3308.000000,6,0,1,0,3.000000),
(0,0.000000,70,0,0.252527,4945.000000,9,0,1,0,0.000000),
(0,0.001760,46,0,0.214688,5500.000000,5,0,1,0,2.000000),
(0,0.390088,39,0,0.326036,3014.000000,6,0,0,0,0.000000),
(0,0.007354,80,0,0.299914,3500.000000,16,0,0,0,1.000000),
(0,1.000000,38,1,17.000000,5400.000000,1,0,0,0,0.000000),
(0,0.061174,28,0,0.089970,3000.000000,3,0,0,0,0.000000),
(0,0.391427,58,2,0.384780,7476.000000,6,0,2,0,0.000000),
(0,0.132821,42,0,0.914453,3424.000000,16,0,2,0,1.000000),
(0,0.842079,60,0,0.150494,2730.000000,10,0,0,0,1.000000),
(1,0.954449,55,5,773.000000,5400.000000,7,1,0,3,0.000000),
(0,0.804682,43,0,0.533815,10231.000000,12,0,2,0,4.000000),
(0,0.751586,56,0,1.478578,2333.000000,8,0,2,0,0.000000),
(0,0.289105,55,0,0.939431,5728.000000,17,0,3,0,0.000000),
(0,0.003158,32,0,1.000000,5400.000000,1,0,0,0,0.000000),
(0,0.601759,36,0,2162.000000,5400.000000,10,0,1,0,2.000000),
(0,0.684021,50,0,0.894879,11500.000000,21,0,3,0,0.000000),
(1,0.810546,57,2,1.141452,3456.000000,29,0,1,1,1.000000),
(0,0.000000,45,1,0.012530,3750.000000,8,0,0,0,3.000000),
(0,0.000000,53,0,0.460726,3500.000000,7,1,1,1,0.000000),
(0,0.926060,48,1,12546.000000,5400.000000,8,0,4,0,0.000000),
(0,0.179880,23,0,0.003127,2557.000000,2,0,0,0,0.000000),
(0,0.226958,80,0,0.437500,4079.000000,11,0,1,0,1.000000),
(0,0.941447,54,0,1.843950,4850.000000,15,0,4,0,1.000000),
(0,0.023238,58,0,0.812429,6999.000000,19,0,3,0,1.000000),
(0,0.017186,48,0,0.348887,7500.000000,8,0,3,0,2.000000),
(0,0.506995,29,0,0.502999,2500.000000,6,0,1,1,0.000000),
(0,0.120356,59,0,0.151986,11000.000000,10,0,2,0,0.000000),
(0,0.247597,56,0,0.702749,5200.000000,8,0,1,0,2.000000),
(0,0.321935,44,0,1383.000000,5400.000000,7,0,2,0,1.000000),
(0,0.823059,71,1,2061.000000,5400.000000,6,1,0,1,0.000000),
(1,0.902797,45,3,2788.000000,5400.000000,8,2,1,2,0.000000),
(0,0.099482,44,0,0.431369,5004.000000,7,0,1,0,3.000000),
(0,0.418398,58,0,0.414148,7180.000000,14,0,2,0,0.000000),
(0,0.537344,57,0,0.627823,5800.000000,19,0,1,0,0.000000),
(0,0.002776,55,0,0.375849,7800.000000,11,0,2,0,1.000000),
(0,1.000000,82,0,0.000000,1400.000000,0,0,0,0,0.000000),
(1,1.000000,71,1,0.313816,2800.000000,2,0,1,1,0.000000),
(0,0.317047,65,0,0.173403,2300.000000,14,0,0,0,0.000000),
(0,0.100578,69,0,2209.000000,5400.000000,11,0,2,0,2.000000),
(0,0.109278,54,0,1370.000000,5400.000000,5,0,1,0,0.000000),
(0,0.012952,68,0,1968.000000,5400.000000,5,0,1,0,0.000000),
(0,0.186223,58,1,0.251769,8900.000000,11,0,1,0,3.000000),
(0,0.219540,31,0,220.000000,5400.000000,4,0,0,0,0.000000),
(0,0.386876,48,0,0.119083,20850.000000,19,0,0,0,2.000000),
(0,0.809765,64,0,0.476433,10777.000000,11,0,1,0,0.000000),
(0,0.126459,60,0,263.000000,5400.000000,7,0,0,0,0.000000),
(0,0.281813,79,1,0.304638,10500.000000,16,0,2,0,1.000000),
(0,0.058309,70,0,0.723311,2500.000000,12,0,2,0,0.000000),
(0,0.075662,63,0,0.315813,6848.000000,7,0,2,0,0.000000),
(1,0.087649,27,0,0.009995,2200.000000,2,0,0,1,1.000000),
(0,0.544761,58,0,0.592103,5976.000000,13,0,2,0,1.000000),
(0,0.099273,58,0,0.034020,8494.000000,3,0,0,0,3.000000),
(0,0.201133,65,0,0.248418,7583.000000,9,0,2,0,0.000000),
(0,0.000000,48,0,0.318341,2000.000000,5,0,0,0,1.000000),
(0,0.000000,43,0,0.000000,5400.000000,2,0,0,0,0.000000),
(0,0.963615,46,0,0.224283,3557.000000,5,1,1,0,3.000000),
(0,0.027131,43,0,0.256738,8050.000000,6,0,1,0,1.000000),
(0,0.081312,65,1,315.000000,5400.000000,6,0,0,0,0.000000),
(0,0.191297,70,0,0.213110,10083.000000,15,0,1,0,0.000000),
(0,0.103186,75,0,0.136303,14166.000000,5,0,2,0,0.000000),
(0,1.000000,50,0,0.914857,2348.000000,5,0,1,0,0.000000),
(0,0.030586,36,1,0.310936,2916.000000,5,0,0,0,2.000000),
(0,0.041085,64,0,0.264228,12000.000000,8,0,1,0,0.000000),
(1,0.000000,36,0,0.157678,4375.000000,7,0,0,0,2.000000),
(0,0.000000,48,0,4212.000000,5400.000000,6,0,3,0,0.000000),
(0,0.375897,62,0,0.295631,9017.000000,21,0,1,0,0.000000),
(0,1.000000,68,0,0.196746,1351.000000,3,0,0,0,0.000000),
(0,1.000000,59,0,0.020360,5500.000000,1,0,0,0,1.000000),
(0,0.096010,53,0,0.545157,4583.000000,8,0,1,0,1.000000),
(0,0.000000,37,1,1898.000000,5400.000000,3,0,1,0,0.000000),
(0,0.028201,56,0,0.084599,5200.000000,10,0,1,0,0.000000),
(0,0.076703,41,0,0.388437,4790.000000,14,0,2,0,0.000000),
(0,0.227820,77,0,0.554916,6600.000000,24,0,2,0,0.000000),
(0,0.000000,53,0,0.000000,3000.000000,2,0,0,0,1.000000),
(0,0.019391,68,0,0.064577,3700.000000,9,0,0,0,1.000000),
(0,0.149113,68,0,0.699205,4906.000000,8,0,2,0,0.000000),
(0,0.726760,55,0,0.651703,9333.000000,9,0,3,0,2.000000),
(0,0.099815,57,0,0.232340,4260.000000,8,0,1,0,1.000000),
(0,0.000778,74,0,0.209540,13333.000000,6,0,3,0,0.000000),
(0,0.518350,73,0,0.685146,9000.000000,13,0,2,0,0.000000),
(0,0.083984,49,0,2461.000000,5400.000000,5,0,2,0,3.000000),
(0,0.047286,69,0,0.012932,7500.000000,5,0,0,0,0.000000),
(0,0.142123,54,0,2859.000000,5400.000000,18,0,3,0,1.000000),
(0,0.058416,29,0,0.299711,5541.000000,10,0,0,0,0.000000),
(0,0.006556,88,0,6.000000,5400.000000,7,0,0,0,0.000000),
(0,0.062082,28,0,0.012387,5650.000000,6,0,0,0,0.000000),
(0,1.000000,27,0,0.014697,1700.000000,0,0,0,0,1.000000),
(0,0.000000,43,0,0.437351,4620.000000,7,0,1,0,0.000000),
(0,0.065421,56,1,0.238432,1836.000000,9,0,0,0,0.000000),
(0,0.901408,27,0,0.151044,2250.000000,5,0,0,0,0.000000),
(0,0.072018,50,0,1.434783,2000.000000,12,0,1,0,1.000000),
(0,0.392193,43,0,0.150206,9000.000000,8,0,0,0,2.000000),
(0,0.507498,68,0,0.012469,3608.000000,3,0,0,0,0.000000),
(0,0.000000,37,0,1.687366,1400.000000,8,0,2,0,0.000000),
(1,1.000000,60,1,0.540617,4566.000000,2,0,1,1,0.000000),
(0,0.016119,38,0,0.124750,2500.000000,12,0,0,0,1.000000),
(0,0.593789,63,0,3400.000000,5400.000000,13,0,2,0,1.000000),
(0,1.000000,64,0,423.000000,5400.000000,2,0,0,0,0.000000),
(0,0.361682,41,0,0.196751,5600.000000,9,0,0,0,2.000000),
(0,0.811623,33,1,0.439756,1800.000000,8,0,0,0,4.000000),
(0,0.213456,64,0,0.735555,2370.000000,9,0,2,0,0.000000),
(0,0.002125,73,0,3256.000000,5400.000000,9,0,1,0,0.000000),
(0,0.040253,54,0,0.401668,7433.000000,12,0,1,0,2.000000),
(0,0.443626,53,0,0.253687,4000.000000,6,0,0,0,1.000000),
(0,0.002013,59,0,1164.000000,5400.000000,2,0,1,0,0.000000),
(0,0.055759,62,0,0.014802,6417.000000,6,0,0,0,0.000000),
(0,0.007750,60,0,0.220214,7578.000000,8,0,1,0,0.000000),
(0,0.696496,46,0,0.276621,6000.000000,10,0,0,0,1.000000),
(0,0.580695,39,1,0.785197,4417.000000,8,0,2,0,0.000000),
(0,0.120180,52,1,0.427217,9912.000000,10,0,3,0,1.000000),
(0,0.022517,67,0,1031.000000,5400.000000,5,0,1,0,0.000000),
(0,0.017595,52,0,0.306472,3908.000000,7,0,1,0,1.000000),
(0,1.000000,65,1,0.061422,5567.000000,1,0,0,0,0.000000),
(0,0.000000,84,0,0.000000,5400.000000,1,0,0,0,0.000000),
(0,0.465521,47,0,4085.000000,5400.000000,8,0,1,0,0.000000),
(0,0.874913,46,0,0.302200,8500.000000,4,0,1,0,0.000000),
(0,0.037274,63,0,0.953488,1805.000000,8,0,1,0,0.000000),
(0,0.141763,78,0,0.028257,5732.000000,5,0,0,0,0.000000),
(0,0.017926,62,0,0.005187,4240.000000,6,0,0,0,0.000000),
(0,0.082239,30,0,2065.000000,5400.000000,7,0,2,0,0.000000),
(0,0.073727,53,0,0.139694,7000.000000,16,0,0,0,0.000000),
(0,0.006146,74,0,3.000000,5400.000000,2,0,0,0,0.000000),
(0,0.067811,71,0,0.332303,5500.000000,19,0,2,0,1.000000),
(1,0.887081,45,0,0.482276,4710.000000,4,0,1,1,2.000000),
(0,0.293687,31,0,1268.000000,5400.000000,13,0,0,0,0.000000),
(0,0.030154,58,0,0.003999,4000.000000,6,0,0,0,0.000000),
(0,0.414619,70,0,4681.000000,5400.000000,21,0,2,0,0.000000),
(0,0.853240,62,0,0.487716,1912.000000,4,0,0,0,0.000000),
(0,0.004196,45,1,0.478190,8000.000000,12,0,2,0,1.000000),
(1,0.767840,74,3,0.296449,2900.000000,4,1,0,1,0.000000),
(1,0.041192,31,0,0.261369,2000.000000,3,0,0,0,0.000000),
(0,0.015201,63,0,0.007999,5750.000000,3,0,0,0,0.000000),
(0,0.006733,76,0,613.000000,5400.000000,7,0,1,0,0.000000),
(0,0.839793,54,0,0.682406,3091.000000,9,0,1,0,1.000000),
(0,0.113275,54,0,695.000000,5400.000000,5,0,1,0,1.000000),
(0,0.021419,57,0,0.281414,4750.000000,13,0,1,0,1.000000),
(0,0.924272,45,4,0.441761,3725.000000,7,2,0,0,2.000000),
(0,0.028458,54,0,0.219157,9750.000000,22,0,1,0,0.000000),
(0,0.845719,50,0,0.323338,2000.000000,6,0,0,0,1.000000),
(0,1.000000,29,0,0.080187,6833.000000,3,0,0,0,0.000000),
(1,0.965035,35,0,0.062792,7500.000000,2,0,1,1,2.000000),
(0,0.124366,53,0,2196.000000,5400.000000,11,0,3,0,4.000000),
(0,0.033204,71,0,0.318874,6500.000000,11,0,1,0,0.000000),
(0,0.036422,30,0,1756.000000,1.000000,10,0,2,0,0.000000),
(0,1.000000,82,0,278.000000,5400.000000,0,0,0,0,0.000000),
(0,0.760017,48,2,0.917544,6366.000000,10,0,1,0,1.000000),
(0,1.000000,41,0,0.007664,3000.000000,0,0,0,0,0.000000),
(0,0.147776,33,0,430.000000,5400.000000,8,0,0,0,0.000000),
(1,1.008516,59,1,2.219737,5633.000000,23,0,4,0,0.000000),
(0,0.000000,68,0,0.634675,1614.000000,9,0,1,0,1.000000),
(0,0.119776,31,0,0.041960,4551.000000,3,1,0,0,0.000000),
(0,0.251355,39,1,0.385015,7500.000000,7,0,1,0,1.000000),
(0,0.078912,50,1,0.596621,6333.000000,7,0,1,0,0.000000),
(0,0.065464,80,0,0.006854,8461.000000,1,0,0,0,0.000000),
(0,0.018857,35,1,0.234096,8000.000000,11,0,0,0,0.000000),
(0,0.551441,44,0,0.418148,6975.000000,14,0,2,0,1.000000),
(0,0.153328,61,0,3851.000000,5400.000000,6,0,2,0,1.000000),
(0,0.020212,55,0,0.302396,5300.000000,13,0,1,0,0.000000),
(0,0.239552,51,0,0.357445,5916.000000,10,0,1,0,1.000000),
(1,1.000000,34,0,0.254257,6166.000000,5,1,1,1,2.000000),
(0,0.024688,45,0,0.199101,6895.000000,12,0,1,0,0.000000),
(0,0.796279,44,0,2518.000000,5400.000000,6,5,1,2,4.000000),
(1,1.000000,30,0,0.015108,5625.000000,2,0,0,0,1.000000),
(0,0.623875,41,0,0.037185,2500.000000,2,0,0,0,1.000000),
(0,0.176444,67,0,0.182523,9417.000000,15,0,2,0,0.000000),
(0,0.000000,42,0,0.483206,6400.000000,3,0,1,0,4.000000),
(0,0.067697,75,0,0.082054,2083.000000,11,0,0,0,0.000000),
(0,0.330940,41,3,0.316851,5500.000000,6,0,1,0,2.000000),
(0,0.070324,39,0,0.351426,10445.000000,12,0,1,0,4.000000),
(0,0.012739,70,0,0.008664,3000.000000,6,0,0,0,0.000000),
(0,0.007869,63,0,1448.000000,5400.000000,6,0,1,0,0.000000),
(0,0.019478,41,0,0.365306,6150.000000,12,0,2,0,0.000000),
(0,0.447465,59,0,0.496729,7031.000000,10,0,2,0,2.000000),
(0,0.987502,52,0,3844.000000,5400.000000,12,0,2,0,0.000000),
(1,0.983078,42,0,0.884470,4500.000000,17,0,2,0,2.000000),
(0,0.000000,57,0,0.000000,5400.000000,12,0,0,0,0.000000),
(1,0.972151,59,0,1.473798,1850.000000,12,0,2,0,0.000000),
(0,0.714457,49,2,1.602153,4179.000000,15,0,3,0,3.000000),
(0,0.021615,67,0,2290.000000,5400.000000,8,0,1,0,1.000000),
(0,0.073037,49,0,0.249922,6417.000000,8,0,2,0,0.000000),
(0,0.575314,59,0,0.653881,4405.000000,6,0,1,0,0.000000),
(0,0.086460,27,0,1.055531,2250.000000,7,0,2,0,0.000000),
(0,0.254093,57,0,0.457735,5500.000000,12,0,2,0,0.000000),
(0,0.000000,67,0,0.031403,2037.000000,4,0,0,0,1.000000),
(0,0.433365,32,1,0.619267,4120.000000,5,0,1,0,1.000000),
(0,0.122021,59,0,153.000000,5400.000000,9,0,0,0,0.000000),
(0,0.288425,77,0,0.533965,2531.000000,8,0,1,0,0.000000),
(0,0.195257,48,0,0.484398,5383.000000,20,0,3,0,0.000000),
(0,0.846575,45,0,0.158640,6000.000000,5,0,0,0,2.000000),
(0,0.123564,45,0,0.202104,13215.000000,5,0,1,0,2.000000),
(0,0.007162,82,0,3.000000,5400.000000,7,0,0,0,0.000000),
(0,0.011753,63,0,0.104972,3800.000000,3,0,1,0,0.000000),
(0,0.000000,59,0,1486.000000,5400.000000,4,0,1,0,2.000000),
(0,0.170686,50,0,69.000000,5400.000000,5,0,0,0,3.000000),
(0,0.078534,49,0,0.380692,6390.000000,7,0,1,0,0.000000),
(0,0.160061,41,1,0.370770,7416.000000,8,1,1,0,1.000000),
(0,0.163512,50,0,0.507062,8000.000000,14,0,4,0,3.000000),
(0,0.032008,73,0,0.226599,8300.000000,11,0,2,0,0.000000),
(0,0.994133,53,1,0.537498,7666.000000,10,0,1,0,0.000000),
(0,0.322649,38,0,0.267260,4272.000000,5,0,2,0,0.000000),
(0,0.002983,80,0,0.000128,7789.000000,2,0,0,0,0.000000),
(1,0.617026,26,0,0.160913,3417.000000,5,0,0,0,0.000000),
(1,0.409985,69,1,0.279981,14600.000000,15,0,2,0,0.000000),
(0,0.002428,77,0,0.238471,3165.000000,13,0,1,0,0.000000),
(0,0.173949,68,0,3015.000000,5400.000000,7,0,2,0,0.000000),
(0,0.047198,74,0,0.375672,9305.000000,8,0,5,0,8.000000),
(0,0.202775,59,0,6994.000000,5400.000000,23,0,3,0,2.000000),
(0,0.087406,32,0,0.288978,1750.000000,8,0,0,0,2.000000),
(0,0.000000,39,0,0.055916,4166.000000,5,0,0,0,0.000000),
(0,0.045694,49,0,0.300175,4000.000000,14,0,1,0,1.000000),
(0,0.022780,53,0,0.323068,10000.000000,14,0,2,0,1.000000),
(0,0.036934,56,0,0.287935,8362.000000,8,0,1,0,2.000000),
(0,0.000000,62,0,1463.000000,5400.000000,5,0,1,0,0.000000),
(0,0.832105,47,0,0.754366,11166.000000,18,0,3,0,2.000000),
(0,0.644711,27,0,0.087018,6400.000000,7,0,0,0,0.000000),
(0,0.472496,42,0,0.381655,11250.000000,11,0,3,0,3.000000),
(0,0.000000,43,0,3278.000000,0.000000,7,0,3,0,0.000000),
(0,0.017509,59,0,0.365119,9500.000000,8,0,2,0,0.000000),
(0,0.095147,30,0,0.262805,7750.000000,9,0,1,0,0.000000),
(0,0.111328,32,0,0.370438,6000.000000,11,0,1,0,1.000000),
(0,0.279441,57,0,0.001333,3000.000000,1,0,0,0,1.000000),
(0,0.170166,42,0,0.005084,4916.000000,2,0,0,0,0.000000),
(0,0.525350,44,0,0.265853,11716.000000,8,0,2,0,1.000000),
(0,0.007125,67,1,0.186116,7000.000000,25,0,1,0,0.000000),
(0,0.871073,35,0,0.390765,7167.000000,12,0,1,0,0.000000),
(0,0.099146,72,0,2430.000000,5400.000000,23,0,2,0,1.000000),
(0,0.074231,25,0,0.155248,3400.000000,4,0,0,0,0.000000),
(0,0.161644,52,0,0.134433,6121.000000,8,0,0,0,0.000000),
(0,0.000000,46,0,0.014388,833.000000,5,0,0,0,0.000000),
(0,0.685700,44,0,0.372925,5000.000000,10,0,2,0,0.000000),
(0,0.011835,47,0,0.684560,6482.000000,8,0,1,0,2.000000),
(0,0.018457,53,0,0.248861,9000.000000,7,0,2,0,2.000000),
(0,0.000000,37,0,0.372541,7166.000000,6,0,1,0,0.000000),
(0,0.001786,87,0,0.010724,1864.000000,10,0,0,0,1.000000),
(0,0.000000,65,0,7.000000,5400.000000,2,0,0,0,0.000000),
(0,0.032925,65,0,1.034373,1250.000000,21,0,1,0,0.000000),
(0,0.200991,33,0,0.732948,4500.000000,7,0,1,0,0.000000),
(0,0.009986,72,0,0.277165,9791.000000,8,0,2,0,0.000000),
(0,0.443945,65,1,0.662545,13829.000000,19,0,3,0,1.000000),
(0,0.113400,31,0,0.254914,6664.000000,9,0,2,0,0.000000),
(0,0.000000,83,0,4.000000,5400.000000,5,0,0,0,0.000000),
(0,0.081354,59,0,0.028554,60200.000000,13,0,1,0,1.000000),
(0,0.173713,80,0,0.391101,6000.000000,7,0,2,0,0.000000),
(0,0.013096,55,0,0.363039,3500.000000,10,0,2,0,0.000000),
(0,0.015199,59,0,0.280407,21910.000000,5,0,4,0,1.000000),
(0,0.113955,33,0,0.282589,8683.000000,7,0,2,0,1.000000),
(0,0.042969,60,0,0.016796,5417.000000,9,0,0,0,0.000000),
(0,0.022441,63,0,0.012507,7435.000000,19,0,0,0,0.000000),
(0,0.878881,61,1,0.950643,3889.000000,19,0,1,0,1.000000),
(0,0.979196,61,0,0.320731,6400.000000,7,0,1,0,0.000000),
(0,0.029406,62,1,0.246740,3833.000000,10,0,0,0,0.000000),
(0,0.000000,72,0,133.000000,5400.000000,8,0,1,0,0.000000),
(0,0.171692,44,1,0.252375,10000.000000,7,0,2,0,2.000000),
(0,0.030053,58,0,937.000000,5400.000000,5,0,1,0,0.000000),
(0,0.480988,59,0,0.164019,11583.000000,18,0,1,0,1.000000),
(0,0.238236,70,0,1252.000000,5400.000000,11,0,1,0,0.000000),
(0,0.006489,67,0,0.099890,12753.000000,5,0,1,0,1.000000),
(0,0.010653,39,0,0.002526,3166.000000,2,0,0,0,0.000000),
(0,0.241622,40,0,3228.000000,5400.000000,11,0,2,0,0.000000),
(0,1.000000,44,0,0.117096,4585.000000,1,0,0,0,5.000000),
(0,0.892003,60,0,3955.000000,5400.000000,12,0,2,0,0.000000),
(0,0.635388,44,1,0.429331,11666.000000,19,0,2,0,4.000000),
(0,0.018476,49,0,0.162335,2500.000000,6,0,0,0,1.000000),
(1,0.826441,38,0,0.653680,5800.000000,9,0,1,0,2.000000),
(0,0.299786,76,0,0.138246,3500.000000,11,0,0,0,0.000000),
(0,0.654211,37,0,0.269917,10543.000000,10,0,3,0,0.000000),
(0,0.877125,56,1,0.389627,14595.000000,11,0,2,0,2.000000),
(1,0.000000,67,0,0.345825,16383.000000,20,0,3,0,1.000000),
(0,0.462736,64,0,0.575631,8600.000000,32,0,3,0,0.000000),
(0,1.000000,44,0,0.514309,2480.000000,7,0,1,0,5.000000),
(0,0.268399,38,0,0.507759,6250.000000,12,0,1,0,2.000000),
(0,0.002304,73,0,4.000000,5400.000000,5,0,0,0,0.000000),
(0,0.000000,61,0,0.248972,5594.000000,7,0,2,0,0.000000),
(0,0.103319,84,0,0.278180,4000.000000,12,0,0,0,0.000000),
(0,0.171135,52,0,2574.000000,5400.000000,12,0,1,0,0.000000),
(0,0.625696,50,3,0.556181,4440.000000,12,0,2,0,2.000000),
(0,0.001267,40,0,0.730317,2806.000000,15,0,2,0,3.000000),
(0,0.028908,41,0,0.768521,3900.000000,6,0,2,0,1.000000),
(0,0.029542,82,0,0.018151,4076.000000,8,0,0,0,0.000000),
(0,0.108356,63,0,0.005166,6000.000000,3,0,0,0,0.000000),
(0,0.004171,66,0,0.304592,3200.000000,8,0,1,0,0.000000),
(0,0.016866,63,1,496.000000,5400.000000,10,0,1,0,0.000000),
(0,0.000000,59,0,0.160814,6833.000000,9,0,1,0,0.000000),
(0,0.324716,58,2,0.104810,5800.000000,10,0,1,1,2.000000),
(0,0.080482,38,0,0.273973,10000.000000,12,0,1,0,1.000000),
(1,0.000000,41,1,0.526684,8000.000000,4,1,2,1,1.000000),
(0,0.017029,72,0,0.068936,8166.000000,22,0,0,0,0.000000),
(0,0.008289,64,0,0.002894,3800.000000,2,0,0,0,0.000000),
(0,1.089826,60,1,0.633536,3118.000000,7,0,1,0,0.000000),
(0,0.199666,49,1,0.684568,10743.000000,15,0,4,0,2.000000),
(0,0.487838,41,0,0.249076,4600.000000,5,0,1,0,2.000000),
(0,0.003812,50,0,0.362584,24090.000000,27,0,5,0,1.000000),
(0,0.033192,57,0,0.283543,5000.000000,17,0,1,0,0.000000),
(0,1.000000,34,0,0.196641,2440.000000,2,0,0,0,5.000000),
(0,0.350804,43,0,125.000000,5400.000000,4,0,0,0,0.000000),
(0,1.000000,52,0,0.001938,4642.000000,2,0,0,0,0.000000),
(0,0.683462,48,0,0.129355,3903.000000,4,0,0,0,0.000000),
(0,0.000000,53,0,1635.000000,5400.000000,6,0,1,0,2.000000),
(0,0.055607,65,0,2965.000000,5400.000000,5,0,1,0,1.000000),
(0,0.380440,58,0,0.321542,6275.000000,9,0,1,0,0.000000),
(0,0.000000,43,0,2022.000000,5400.000000,3,0,1,0,1.000000),
(0,0.000000,66,0,0.363573,18694.000000,16,0,5,0,0.000000),
(0,0.023298,30,0,0.162630,2600.000000,6,0,0,0,0.000000),
(0,0.971002,46,0,0.498111,1587.000000,3,2,0,1,0.000000),
(0,0.000000,48,1,0.143672,4558.000000,8,0,0,0,0.000000),
(0,0.286564,53,0,1.333712,7916.000000,17,0,7,0,0.000000),
(0,0.188059,55,1,0.542411,5316.000000,19,0,1,0,2.000000),
(0,0.209547,39,0,0.100164,2435.000000,12,0,0,0,0.000000),
(0,0.477141,71,0,0.349573,11350.000000,11,0,3,0,0.000000),
(0,0.523570,40,0,0.152938,8303.000000,7,0,1,0,2.000000),
(0,0.122831,46,0,2162.000000,5400.000000,4,0,1,0,0.000000),
(0,0.267080,51,0,0.841945,6250.000000,25,0,3,0,3.000000),
(0,0.460114,29,0,558.000000,5400.000000,4,0,0,0,0.000000),
(0,0.363994,45,0,0.248252,13586.000000,6,0,2,0,3.000000),
(0,0.857122,64,0,0.469695,9750.000000,8,0,2,0,0.000000),
(0,0.027789,52,0,0.226816,7666.000000,7,0,2,0,2.000000),
(0,0.002524,89,0,1.000000,5400.000000,6,0,0,0,0.000000),
(0,0.822094,76,0,325.000000,5400.000000,6,0,0,0,0.000000),
(0,0.353103,45,0,0.878526,6700.000000,22,0,2,0,3.000000),
(0,0.444218,44,1,0.478291,11400.000000,6,0,2,0,0.000000),
(0,0.673190,35,0,0.424099,3800.000000,5,0,1,0,0.000000),
(0,0.180297,62,0,1609.000000,5400.000000,11,0,1,0,0.000000),
(0,0.038953,62,0,3024.000000,5400.000000,7,0,2,0,0.000000),
(0,0.556134,36,0,0.151914,4100.000000,4,0,0,0,0.000000),
(0,0.057156,60,0,0.224295,6700.000000,10,0,1,0,0.000000),
(0,0.212957,61,0,0.499100,5000.000000,4,0,2,0,0.000000),
(0,0.037448,73,0,2498.000000,5400.000000,4,0,2,0,0.000000),
(1,0.702381,54,0,0.866733,14166.000000,21,0,6,0,3.000000),
(0,0.000000,44,0,2648.000000,5400.000000,12,0,2,0,3.000000),
(0,0.196223,67,0,0.158013,7144.000000,9,0,1,0,0.000000),
(0,0.620904,42,0,1146.000000,5400.000000,14,0,0,0,3.000000),
(0,0.001500,64,0,322.000000,5400.000000,12,0,0,0,0.000000),
(0,0.040857,51,0,0.385323,5000.000000,9,0,1,0,0.000000),
(0,1.000000,65,0,0.282883,9335.000000,10,0,2,1,2.000000),
(0,0.966736,64,0,0.419895,4000.000000,8,0,2,0,0.000000),
(0,0.685584,41,0,0.450441,10895.000000,13,0,5,0,1.000000),
(0,0.020000,48,0,0.090382,5000.000000,11,0,1,0,0.000000),
(0,0.275749,62,0,1348.000000,5400.000000,7,0,1,0,0.000000),
(0,0.000000,60,0,0.254107,7000.000000,9,0,2,0,0.000000),
(0,1.000000,51,0,1.123247,8486.000000,11,0,9,0,1.000000),
(0,0.004396,80,0,0.233197,4150.000000,10,0,2,0,1.000000),
(0,0.216827,56,1,0.854103,3618.000000,16,0,3,0,2.000000),
(0,0.205031,39,0,0.602840,4083.000000,10,0,2,0,2.000000),
(0,1.000000,36,0,0.082449,6500.000000,6,0,0,0,1.000000),
(0,0.555938,53,0,0.451816,3330.000000,10,0,0,0,0.000000),
(0,0.002288,66,0,0.000500,6000.000000,3,0,0,0,0.000000),
(0,0.088300,35,0,3041.000000,5400.000000,8,0,1,0,0.000000),
(0,0.143188,46,0,0.048501,2700.000000,3,0,0,0,0.000000),
(1,1.083406,55,3,0.490218,3526.000000,10,0,1,1,1.000000),
(0,0.688666,34,0,1.034152,2400.000000,12,0,1,0,3.000000),
(0,0.600289,26,0,0.411101,2125.000000,3,0,0,0,0.000000),
(0,0.220222,26,1,0.843945,800.000000,6,0,0,0,0.000000),
(0,0.030141,52,0,0.090074,2286.000000,6,0,0,0,0.000000),
(0,0.239963,58,0,0.195229,7042.000000,8,1,1,0,4.000000),
(0,0.443379,42,0,1.412587,1000.000000,8,0,0,0,0.000000),
(0,0.198455,51,0,0.246161,4492.000000,7,0,1,0,2.000000),
(0,0.439512,66,0,0.027952,2396.000000,2,0,0,0,0.000000),
(0,0.270429,62,0,0.477691,9300.000000,14,0,3,0,1.000000),
(0,0.000000,87,0,0.019108,6436.000000,8,0,0,0,0.000000),
(0,0.023946,63,0,0.032693,8166.000000,13,0,1,0,0.000000),
(0,0.570123,30,0,0.737719,1200.000000,5,0,0,0,0.000000),
(0,1.000000,47,0,2174.000000,5400.000000,1,0,1,0,0.000000),
(0,0.000000,57,0,0.324611,4241.000000,7,0,1,0,1.000000),
(0,0.128842,37,0,0.445555,8200.000000,10,0,2,0,2.000000),
(0,0.339648,65,0,0.265090,8200.000000,6,0,1,0,1.000000),
(0,0.014370,69,0,0.432808,5833.000000,9,0,1,0,0.000000),
(0,0.000000,61,0,2.000000,5400.000000,5,0,0,0,0.000000),
(0,0.511249,38,1,0.476190,4304.000000,10,0,1,0,2.000000),
(0,0.168058,43,0,0.313672,4000.000000,7,0,1,0,0.000000),
(0,0.005971,54,0,0.280198,4453.000000,13,0,1,0,2.000000),
(0,0.123206,44,0,0.643263,4400.000000,10,0,2,0,2.000000),
(0,0.003500,48,0,0.329414,9100.000000,7,0,2,0,1.000000),
(0,0.054783,63,0,0.099980,5000.000000,15,0,0,0,1.000000),
(0,0.041736,46,0,0.036921,7041.000000,22,0,0,0,0.000000),
(1,1.000000,42,0,31.000000,5400.000000,0,2,0,0,0.000000),
(0,0.386691,41,3,0.276689,2500.000000,14,0,0,0,0.000000),
(0,0.956398,35,2,3268.000000,5400.000000,15,0,1,0,0.000000),
(0,0.689770,34,0,0.308231,5855.000000,5,0,2,1,0.000000),
(0,0.121533,29,0,0.155711,4000.000000,4,0,0,0,0.000000),
(0,0.031141,45,0,0.075146,20000.000000,9,0,0,0,0.000000),
(0,0.478720,35,0,0.353108,6000.000000,7,0,1,0,0.000000),
(0,0.246370,73,0,0.289518,5895.000000,5,0,1,0,0.000000),
(0,0.065789,69,0,1234.000000,5400.000000,13,0,2,0,1.000000),
(0,0.351893,45,0,0.563852,3280.000000,18,0,3,0,4.000000),
(0,0.430445,53,0,0.281642,8524.000000,12,0,2,0,0.000000),
(0,0.033499,29,0,0.450358,5166.000000,7,0,2,0,0.000000),
(0,0.072495,74,0,0.523546,3800.000000,9,0,2,0,0.000000),
(0,0.072093,63,1,0.673984,4600.000000,17,0,1,0,1.000000),
(0,0.418715,35,0,0.114119,2400.000000,2,0,0,0,0.000000),
(0,0.088337,43,0,0.216678,10000.000000,15,0,1,0,2.000000),
(0,0.457432,42,1,0.700271,8500.000000,17,0,3,0,2.000000),
(0,0.029571,80,0,0.048762,1332.000000,13,0,0,0,0.000000),
(0,0.168773,58,0,0.289780,10400.000000,11,0,1,0,1.000000),
(0,0.032439,86,0,0.141974,5500.000000,14,0,1,0,0.000000),
(0,1.000000,28,0,0.154551,4800.000000,4,0,0,0,3.000000),
(0,0.831214,42,0,0.105621,17666.000000,12,0,0,0,0.000000),
(0,0.063227,59,0,0.263462,13500.000000,22,0,3,0,0.000000),
(0,0.019139,43,0,8.007968,250.000000,11,0,1,0,2.000000),
(0,0.436410,27,0,0.133778,4200.000000,5,0,0,1,0.000000),
(0,0.483301,40,0,0.303013,3583.000000,11,0,1,0,2.000000),
(0,0.510293,59,0,0.316978,61000.000000,13,0,2,0,1.000000),
(0,0.955237,63,0,65.000000,5400.000000,1,0,0,0,2.000000),
(0,0.070741,65,0,0.146764,2193.000000,5,0,0,0,0.000000),
(0,0.056334,63,0,4542.000000,5400.000000,12,0,3,0,0.000000),
(0,0.559864,63,0,0.589572,2243.000000,6,0,1,0,0.000000),
(0,0.000000,30,0,0.149209,3350.000000,10,0,0,0,0.000000),
(0,0.200990,45,0,1559.000000,5400.000000,5,0,1,0,0.000000),
(0,0.093446,80,0,0.123591,4700.000000,14,0,0,0,0.000000),
(0,0.098019,55,0,0.025918,4166.000000,7,0,0,0,1.000000),
(0,0.135408,61,0,0.343654,5199.000000,12,0,1,0,0.000000),
(0,1.000000,83,0,0.000000,9704.000000,4,0,0,0,0.000000),
(0,0.198674,44,0,2.699720,2500.000000,13,0,3,0,0.000000),
(0,0.905469,31,1,0.352972,1900.000000,6,0,0,2,0.000000),
(0,0.011986,77,0,0.010284,7000.000000,21,0,0,0,0.000000),
(0,0.313093,57,0,1.648470,2417.000000,8,0,1,0,0.000000),
(0,0.127245,46,0,0.643000,14999.000000,11,0,5,0,0.000000),
(0,0.000000,42,0,0.108599,12559.000000,5,0,1,0,3.000000),
(0,0.029726,67,0,685.000000,5400.000000,8,0,0,0,0.000000),
(0,0.312571,33,0,0.107851,6100.000000,5,0,0,0,0.000000),
(0,0.000000,34,0,0.062898,5500.000000,2,0,0,0,0.000000),
(0,0.809738,49,0,0.196739,6500.000000,5,0,0,0,2.000000),
(0,0.085108,54,0,0.160825,9500.000000,7,0,1,0,1.000000),
(0,0.973447,42,0,0.468199,3175.000000,9,0,1,0,0.000000),
(0,0.933834,57,2,6696.000000,5400.000000,8,0,2,0,0.000000),
(0,0.041826,58,0,2707.000000,5400.000000,4,0,1,0,2.000000),
(0,0.639082,48,0,0.362546,3000.000000,5,1,1,0,1.000000),
(0,0.100836,87,0,140.000000,5400.000000,6,0,0,0,0.000000),
(0,0.068398,86,0,60.000000,5400.000000,7,0,0,0,0.000000),
(0,0.019377,68,0,1277.000000,5400.000000,12,0,1,0,0.000000),
(0,0.000000,88,1,0.000000,9265.000000,7,0,0,0,0.000000),
(0,0.059689,76,0,0.282182,10432.000000,20,0,2,0,0.000000),
(0,0.027999,70,0,24.000000,5400.000000,8,0,0,0,0.000000),
(0,0.085784,72,0,0.169006,5200.000000,12,0,0,0,1.000000),
(0,0.132240,59,0,0.549863,4000.000000,9,0,1,0,0.000000),
(0,0.085634,49,0,0.227886,2000.000000,14,0,0,0,0.000000),
(0,0.924107,24,0,0.135388,4800.000000,7,0,0,0,2.000000),
(0,0.009495,56,0,0.055032,7104.000000,2,0,0,0,1.000000),
(0,0.952799,54,0,0.558741,6383.000000,10,0,1,0,1.000000),
(0,0.000054,41,0,0.108462,5577.000000,7,0,0,0,1.000000),
(0,0.655147,46,0,0.378129,5952.000000,6,0,1,0,3.000000),
(0,0.329152,41,0,0.534155,4054.000000,8,0,2,0,1.000000),
(0,0.017050,64,0,0.583656,7500.000000,19,0,4,0,0.000000),
(0,1.000000,30,1,0.154188,4500.000000,4,0,0,1,0.000000),
(1,0.602747,42,0,0.260609,9166.000000,4,0,0,0,1.000000),
(0,0.004770,89,0,0.000573,3490.000000,9,0,0,0,0.000000),
(0,0.034247,43,0,0.159027,5300.000000,10,0,1,0,1.000000),
(0,0.170116,63,0,0.208084,6852.000000,20,0,1,0,0.000000),
(0,0.310076,37,0,0.255326,9058.000000,7,0,1,0,0.000000),
(0,0.999579,55,4,0.148484,7286.000000,6,0,0,0,0.000000),
(0,0.000000,26,0,0.000000,2400.000000,2,0,0,0,0.000000),
(0,0.380480,68,0,0.051771,2568.000000,2,0,0,0,3.000000),
(0,0.187409,38,0,0.497301,5000.000000,7,0,1,0,2.000000),
(0,0.680123,48,0,245.000000,5400.000000,4,0,0,0,0.000000),
(0,0.000000,26,0,0.337245,2300.000000,4,1,1,0,0.000000),
(0,0.273435,48,0,0.218110,10833.000000,10,0,1,0,0.000000),
(0,0.284952,52,0,0.380132,4700.000000,9,0,1,0,0.000000),
(0,0.336222,44,0,0.234941,4000.000000,14,0,0,0,0.000000),
(0,0.030025,61,0,0.852236,1833.000000,5,0,1,0,0.000000),
(0,0.008248,66,0,0.943611,5000.000000,7,0,2,0,0.000000),
(0,0.137529,42,0,0.504560,8333.000000,13,0,2,0,3.000000),
(0,0.546914,67,0,2969.000000,5400.000000,6,0,2,0,0.000000),
(0,0.132249,49,0,29.000000,5400.000000,2,0,0,0,0.000000),
(1,1.000000,35,1,0.900911,3400.000000,6,0,2,0,0.000000),
(0,0.000000,53,2,2658.000000,5400.000000,7,0,1,0,0.000000),
(0,0.205274,51,0,0.361330,8000.000000,10,0,1,0,0.000000),
(0,0.000000,49,1,0.544229,9416.000000,11,0,3,0,2.000000),
(0,0.464196,53,0,0.120939,4985.000000,8,0,0,0,0.000000),
(0,0.466769,58,0,0.327110,4016.000000,8,0,1,0,0.000000),
(0,0.911540,46,0,3353.000000,5400.000000,7,0,1,0,1.000000),
(0,0.014088,51,0,0.007998,3500.000000,6,0,0,0,1.000000),
(0,0.536462,45,1,0.142286,3000.000000,3,2,0,0,1.000000),
(0,0.918342,33,0,0.270289,2833.000000,4,1,0,2,0.000000),
(0,0.000000,51,0,2391.000000,5400.000000,10,0,2,0,0.000000),
(0,0.023225,64,0,0.391854,6800.000000,18,0,4,0,3.000000),
(0,0.016129,60,0,1812.000000,5400.000000,8,0,1,1,0.000000),
(0,1.034894,39,0,0.439363,9729.000000,10,0,1,0,3.000000),
(0,0.147243,85,0,88.000000,5400.000000,3,0,0,0,0.000000),
(1,0.983339,27,0,0.106808,1600.000000,9,0,0,0,0.000000),
(0,0.839908,29,0,364.000000,2.000000,8,0,0,0,0.000000),
(0,0.286010,65,0,3622.000000,5400.000000,5,0,1,0,0.000000),
(0,0.267369,50,0,0.420292,23033.000000,46,0,6,0,0.000000),
(0,0.283697,61,0,0.619663,4800.000000,14,0,1,0,0.000000),
(0,0.000000,26,1,0.000000,0.000000,2,0,0,0,0.000000),
(0,0.143932,61,0,0.222952,6090.000000,9,0,1,0,0.000000),
(0,0.041105,28,0,0.304199,3500.000000,8,0,0,0,0.000000),
(0,0.299418,56,0,0.659716,8583.000000,11,0,2,0,0.000000),
(0,0.000000,49,0,0.355376,15000.000000,12,0,2,0,3.000000),
(0,0.000429,88,0,0.004481,3123.000000,5,0,0,0,0.000000),
(0,0.004505,39,0,0.435849,4200.000000,6,0,2,0,2.000000),
(0,0.492644,55,2,0.827377,7750.000000,13,0,2,0,0.000000),
(0,0.021547,56,0,0.318020,4200.000000,12,0,2,0,2.000000),
(0,0.100173,44,0,0.165315,9000.000000,9,0,1,0,2.000000),
(0,0.621008,64,0,0.310222,7600.000000,14,1,2,0,1.000000),
(0,0.028753,72,0,0.185661,3500.000000,21,0,1,0,0.000000),
(0,0.002682,51,0,0.732788,4400.000000,13,0,2,0,2.000000),
(0,0.498489,39,0,0.286938,17860.000000,13,0,1,0,0.000000),
(0,0.095341,56,0,2779.000000,5400.000000,14,0,3,0,3.000000),
(0,0.097217,43,0,0.276211,13333.000000,5,0,1,0,2.000000),
(0,0.447466,44,0,0.443923,12999.000000,8,0,2,0,2.000000),
(0,0.045759,41,0,0.409915,4800.000000,17,0,2,0,2.000000),
(0,0.000000,41,0,0.004200,10000.000000,7,0,0,0,0.000000),
(0,0.360689,70,0,0.595462,1806.000000,7,0,0,0,0.000000),
(0,0.726089,36,2,0.137082,2720.000000,4,2,0,1,2.000000),
(0,0.129548,53,0,0.562443,5500.000000,17,0,1,0,2.000000),
(0,0.123218,47,0,0.750681,9914.000000,11,0,2,0,5.000000),
(0,0.033214,66,0,1784.000000,5400.000000,5,0,2,0,0.000000),
(0,0.010893,71,0,0.194158,4073.000000,8,1,0,0,0.000000),
(0,0.769774,53,0,0.278076,9500.000000,12,0,2,0,1.000000),
(0,0.006654,50,0,740.000000,5400.000000,7,0,1,0,4.000000),
(0,0.000000,69,0,0.000000,5400.000000,4,0,0,0,0.000000),
(0,0.175604,28,0,28.000000,5400.000000,2,0,0,0,0.000000),
(1,0.922506,45,0,0.501614,12700.000000,11,0,4,0,1.000000),
(0,0.455155,49,1,0.913286,1971.000000,11,0,0,0,0.000000),
(0,0.654651,33,0,0.481545,7043.000000,11,0,2,0,1.000000),
(0,0.844909,60,0,0.357151,8690.000000,6,0,1,0,2.000000),
(0,1.000000,34,0,0.357757,6400.000000,6,0,2,0,0.000000),
(0,0.033984,34,0,0.243744,11708.000000,14,0,2,0,0.000000),
(0,0.000000,44,0,0.183349,9500.000000,11,0,1,0,2.000000),
(0,0.024379,52,0,0.150485,10000.000000,4,0,1,0,3.000000),
(0,0.770868,49,0,0.240425,6500.000000,8,0,0,0,0.000000),
(0,0.000000,71,0,0.233692,4000.000000,6,0,1,0,2.000000),
(0,0.000000,46,0,0.149446,5051.000000,3,0,1,0,0.000000),
(0,0.337736,48,1,3005.000000,5400.000000,11,0,1,0,2.000000),
(0,0.026622,62,0,0.290084,4184.000000,8,0,1,0,2.000000),
(0,0.880187,41,0,0.211888,2472.000000,10,0,0,0,0.000000),
(1,1.000000,50,1,1305.000000,5400.000000,2,0,1,0,0.000000),
(0,0.115815,37,1,0.067859,1900.000000,4,0,0,0,0.000000),
(0,0.992000,57,0,0.555111,4000.000000,8,0,1,0,0.000000),
(0,0.212526,43,1,0.206479,10000.000000,8,0,2,0,0.000000),
(0,1.708045,47,0,1.862758,1500.000000,6,0,1,0,0.000000),
(0,0.132464,44,0,0.120768,3071.000000,11,0,0,0,1.000000),
(0,0.456585,32,0,0.630047,2575.000000,9,0,2,0,0.000000),
(0,1.000000,29,0,0.000000,5400.000000,0,0,0,0,0.000000),
(0,0.558874,30,0,0.214595,3000.000000,9,0,0,0,0.000000),
(0,0.093454,43,0,3986.000000,5400.000000,25,0,2,0,0.000000),
(0,0.850299,41,0,1845.000000,5400.000000,3,0,0,0,0.000000),
(0,0.102222,32,0,0.716513,2500.000000,6,0,1,0,0.000000),
(0,0.000000,52,0,0.360160,10772.000000,10,0,1,0,4.000000),
(0,0.883294,36,0,0.311846,7833.000000,7,0,1,0,0.000000),
(0,0.000000,34,0,0.365407,2566.000000,3,0,0,0,0.000000),
(0,0.038393,76,0,0.013713,10500.000000,11,0,0,0,0.000000),
(0,0.903123,47,0,0.342544,8395.000000,8,0,2,0,0.000000),
(0,0.496969,39,1,0.151994,25000.000000,11,0,2,0,3.000000),
(0,0.940775,41,2,0.381155,4000.000000,10,0,1,0,1.000000),
(0,1.000000,35,0,0.007618,5250.000000,1,0,0,0,0.000000),
(0,1.025987,63,6,0.521442,3800.000000,8,2,2,1,1.000000),
(0,0.071129,80,0,0.093688,3500.000000,6,0,0,0,0.000000),
(0,0.000000,40,0,509.000000,5400.000000,3,0,0,0,0.000000),
(0,0.011501,43,0,0.418702,4052.000000,4,0,1,0,0.000000),
(0,0.000000,60,0,114.000000,5400.000000,7,0,0,0,0.000000),
(0,0.425597,43,0,0.302766,3325.000000,4,0,1,1,0.000000),
(0,0.087453,71,0,1959.000000,5400.000000,11,0,1,0,2.000000),
(0,0.000000,44,0,0.431305,3500.000000,4,0,1,0,2.000000),
(0,0.630788,67,0,0.379420,7210.000000,12,0,2,0,0.000000),
(0,0.004962,74,1,8.000000,5400.000000,9,0,0,0,0.000000),
(0,0.016862,48,0,0.425822,12260.000000,12,0,5,0,4.000000),
(0,0.195056,73,0,1529.000000,5400.000000,10,0,1,0,2.000000),
(0,0.231832,44,0,0.192690,12667.000000,6,0,1,0,2.000000),
(0,0.306339,57,0,0.376374,6915.000000,12,0,3,0,2.000000),
(0,1.000000,49,0,2883.000000,0.000000,9,0,2,0,1.000000),
(0,0.328574,66,1,0.293399,10800.000000,17,0,2,0,1.000000),
(0,0.818660,58,0,1.042791,5000.000000,11,0,2,0,0.000000),
(0,0.246644,45,0,0.109969,3500.000000,5,0,0,0,1.000000),
(0,0.084139,67,1,1295.000000,5400.000000,10,1,2,0,3.000000),
(0,0.010299,29,0,0.001200,2500.000000,1,0,0,0,0.000000),
(0,0.090362,77,0,0.311584,4091.000000,7,0,1,0,0.000000),
(0,0.568392,35,0,0.903676,2719.000000,9,0,1,0,0.000000),
(0,0.005452,59,0,0.001200,5000.000000,7,0,0,0,0.000000),
(0,0.043256,33,1,0.009998,5800.000000,7,0,0,0,0.000000),
(0,0.001925,70,0,0.024569,10500.000000,15,0,0,0,0.000000),
(0,1.006956,66,0,0.214393,2000.000000,3,0,0,0,0.000000),
(0,0.056371,44,0,0.359768,14500.000000,10,0,2,0,1.000000),
(0,0.007899,72,0,508.000000,5400.000000,5,0,1,0,0.000000),
(0,0.000000,29,0,1394.000000,5400.000000,5,0,1,0,0.000000),
(0,0.982432,59,5,0.664256,14239.000000,13,0,2,1,2.000000),
(0,0.018265,55,0,0.012643,7671.000000,6,0,1,0,0.000000),
(1,1.000000,52,0,0.237812,6727.000000,2,4,0,1,1.000000),
(0,0.342057,70,0,0.626395,10933.000000,13,0,3,0,0.000000),
(0,0.039017,67,0,0.499126,1716.000000,5,0,0,0,0.000000),
(0,0.296110,30,0,0.205498,3600.000000,3,0,0,0,1.000000),
(0,0.044576,61,0,37.500000,1.000000,4,0,0,0,0.000000),
(0,0.000350,73,0,681.000000,5400.000000,6,0,1,0,0.000000),
(0,0.000000,25,0,0.633374,820.000000,3,0,0,0,0.000000),
(0,0.003575,70,0,0.410062,6081.000000,15,0,1,0,0.000000),
(0,0.186852,62,0,0.286681,9752.000000,8,0,1,0,0.000000),
(0,0.032998,30,0,0.004461,4482.000000,1,0,0,0,0.000000),
(0,0.006922,68,0,1.000000,5400.000000,9,0,0,0,0.000000),
(0,0.474681,43,0,0.196592,4694.000000,6,0,0,0,1.000000),
(0,0.356635,49,1,0.458135,4000.000000,11,0,2,0,0.000000),
(0,0.982404,57,0,2357.000000,5400.000000,8,0,1,1,0.000000),
(0,0.036348,49,0,0.180970,9752.000000,11,0,0,0,1.000000),
(0,0.258432,70,0,4045.000000,5400.000000,8,0,1,0,1.000000),
(0,0.000000,36,4,0.437850,6250.000000,11,0,2,1,0.000000),
(1,0.537417,38,1,2748.000000,5400.000000,5,3,1,3,0.000000),
(0,0.369472,21,0,7.000000,5400.000000,1,0,0,0,0.000000),
(0,0.042541,35,0,0.486239,9700.000000,12,0,3,0,2.000000),
(1,1.000000,27,98,0.000000,2700.000000,0,98,0,98,0.000000),
(0,0.096566,40,0,0.120809,3310.000000,4,0,0,0,1.000000),
(0,0.295741,47,0,0.178619,3750.000000,3,0,0,0,2.000000),
(0,0.213786,46,0,0.367816,2000.000000,5,0,1,0,0.000000),
(0,0.339794,59,0,3115.000000,5400.000000,19,0,1,0,0.000000),
(0,0.318112,60,0,0.020153,7591.000000,2,0,0,0,0.000000),
(0,0.600066,53,1,0.508578,5070.000000,15,0,1,0,1.000000),
(0,0.044178,31,0,0.338480,5893.000000,9,0,1,0,1.000000),
(0,0.010093,37,0,0.003128,1917.000000,3,0,0,0,0.000000),
(0,0.510087,61,0,0.198656,15030.000000,6,0,1,0,1.000000),
(0,0.039753,66,0,0.243920,2836.000000,15,0,0,0,0.000000),
(0,0.051019,59,0,0.260456,12815.000000,16,0,1,0,3.000000),
(0,1.000000,63,5,0.194619,11000.000000,7,0,2,0,0.000000),
(0,0.142398,57,0,0.264080,4225.000000,6,0,1,0,0.000000),
(0,1.000000,63,0,0.000000,1.000000,2,0,0,0,0.000000),
(0,0.006796,77,0,0.413931,2253.000000,13,0,1,0,0.000000),
(0,0.132963,61,0,0.371700,3900.000000,10,0,1,0,3.000000),
(0,0.827201,53,0,0.505688,2900.000000,8,0,3,0,0.000000),
(0,0.022418,72,0,0.001826,7667.000000,2,0,0,0,0.000000),
(0,0.239177,72,0,1.054042,6716.000000,9,0,2,0,1.000000),
(0,0.304283,32,0,0.274723,4600.000000,8,0,1,0,0.000000),
(0,0.514709,35,0,0.918784,2400.000000,18,0,1,0,1.000000),
(0,0.344318,27,0,0.179534,4416.000000,8,0,0,0,0.000000),
(0,0.022439,81,0,0.230680,3441.000000,8,0,1,0,0.000000),
(0,0.029431,70,0,0.578070,6000.000000,12,0,3,0,0.000000),
(0,0.017833,38,0,0.003871,5166.000000,4,0,0,0,1.000000),
(0,0.006839,43,0,0.527266,2713.000000,7,0,1,0,1.000000),
(0,0.056476,59,0,3612.000000,5400.000000,7,0,2,0,0.000000),
(0,0.000172,71,0,0.000000,30000.000000,8,0,0,0,0.000000),
(0,0.056895,64,0,0.335905,11666.000000,14,0,3,0,0.000000),
(0,1.000000,39,3,0.112225,6780.000000,5,0,0,0,0.000000),
(0,0.212426,36,0,2743.000000,5400.000000,8,0,1,0,0.000000),
(0,0.012399,66,0,14.018767,372.000000,3,0,2,0,0.000000),
(1,0.197702,55,1,0.258874,10000.000000,7,0,2,1,1.000000),
(0,1.624465,61,0,0.432814,11750.000000,12,0,1,0,1.000000),
(0,0.034737,67,0,1969.000000,5400.000000,10,0,2,0,0.000000),
(0,0.108895,58,1,65.000000,5400.000000,2,0,0,0,0.000000),
(1,0.768821,25,1,0.569585,1781.000000,6,0,0,0,0.000000),
(0,0.705197,56,0,0.262722,55000.000000,16,0,6,0,1.000000),
(0,0.987367,56,0,0.613832,14516.000000,21,0,2,1,0.000000),
(0,0.000000,63,1,0.087569,5252.000000,5,0,1,0,1.000000),
(0,0.122047,58,0,1.861569,2000.000000,14,0,1,0,0.000000),
(0,0.391591,45,0,1363.000000,5400.000000,7,0,3,0,0.000000),
(0,0.884177,32,0,0.709527,1500.000000,6,0,0,0,0.000000),
(0,0.332945,38,0,0.004916,12000.000000,3,0,0,0,1.000000),
(0,0.017699,78,0,10.000000,5400.000000,1,0,0,0,0.000000),
(0,0.366062,77,0,0.559043,7900.000000,12,0,1,0,0.000000),
(0,1.000000,32,0,0.566289,1500.000000,4,0,0,0,0.000000),
(0,0.059627,63,0,639.000000,5400.000000,6,0,0,0,1.000000),
(0,0.061398,41,0,0.718474,10300.000000,18,0,3,0,4.000000),
(0,0.162219,49,0,0.459160,4333.000000,9,0,2,0,1.000000),
(0,0.030830,48,1,0.088448,1107.000000,3,0,0,0,2.000000),
(0,0.005661,42,0,0.001607,5600.000000,1,0,0,0,1.000000),
(0,0.045506,58,0,0.009798,5000.000000,5,0,0,0,1.000000),
(0,0.135778,46,0,0.325581,6750.000000,13,0,1,0,1.000000),
(0,0.047724,66,0,0.758121,2000.000000,11,0,1,0,1.000000),
(1,1.000000,70,1,520.000000,5400.000000,3,0,1,1,0.000000),
(0,0.000000,52,0,0.163459,6649.000000,3,0,1,0,2.000000),
(0,1.000000,31,1,813.000000,5400.000000,4,2,0,1,0.000000),
(0,0.017796,92,0,2.000000,5400.000000,2,0,0,0,0.000000),
(0,0.267703,49,0,0.021265,9216.000000,4,0,0,0,1.000000),
(0,0.714014,55,0,0.252201,6700.000000,4,0,0,1,0.000000),
(0,0.947700,39,1,0.048520,3750.000000,8,0,0,0,0.000000),
(1,0.978808,47,1,0.428419,3750.000000,5,4,0,0,1.000000),
(1,1.050952,61,3,0.801222,1800.000000,7,3,2,0,0.000000),
(0,0.959006,30,0,0.213269,3300.000000,5,0,0,0,0.000000),
(0,0.098515,72,0,1189.000000,0.000000,4,0,1,0,0.000000),
(1,1.000000,39,0,0.041420,3041.000000,2,1,0,0,3.000000),
(0,0.000642,53,0,1959.000000,5400.000000,6,0,1,0,0.000000),
(0,0.407186,46,0,0.512998,6500.000000,14,0,3,0,2.000000),
(1,1.000000,79,0,190.000000,5400.000000,0,0,0,0,0.000000),
(0,0.086672,79,0,0.134649,7500.000000,15,0,0,0,0.000000),
(0,0.023656,70,0,0.017937,2452.000000,7,0,0,0,0.000000),
(0,0.911663,37,0,0.632308,5917.000000,11,0,2,0,3.000000),
(0,0.215569,51,0,0.069114,4166.000000,3,0,0,0,3.000000),
(0,0.088047,63,0,0.157283,9466.000000,5,0,1,0,0.000000),
(0,0.059113,59,0,1743.000000,5400.000000,3,0,1,0,0.000000),
(0,0.032967,48,0,0.537308,5400.000000,10,0,2,0,1.000000),
(0,0.042970,40,0,45.000000,0.000000,6,0,0,0,0.000000),
(0,0.026599,62,0,0.074071,13000.000000,9,0,1,0,1.000000),
(0,0.247103,63,0,0.382147,12400.000000,22,0,3,0,1.000000),
(0,0.021640,56,0,0.323073,8966.000000,21,0,2,0,2.000000),
(0,0.064372,41,0,1.083273,4166.000000,7,0,1,0,1.000000),
(0,0.011846,76,0,9.000000,5400.000000,3,0,0,0,0.000000),
(0,0.342435,55,0,3840.000000,5400.000000,5,0,2,0,0.000000),
(0,0.106507,40,0,0.173444,7500.000000,13,1,2,0,1.000000),
(0,0.849229,60,0,0.848819,5800.000000,11,0,2,0,0.000000),
(0,0.350848,47,0,0.432584,11250.000000,9,0,2,0,3.000000),
(0,0.284029,42,0,1623.000000,5400.000000,10,0,1,0,0.000000),
(0,0.909043,42,0,0.422447,8000.000000,11,0,2,0,0.000000),
(0,0.013626,76,0,0.097373,3501.000000,10,0,0,0,0.000000),
(0,0.205386,68,0,1694.000000,5400.000000,11,0,1,0,0.000000),
(0,0.006161,41,0,0.001080,8333.000000,3,0,0,0,0.000000),
(1,1.000000,64,1,0.967924,2836.000000,6,0,1,0,2.000000),
(0,0.167835,37,0,0.716119,3740.000000,20,0,2,0,1.000000),
(0,0.162705,36,0,0.043175,8175.000000,9,0,0,0,4.000000),
(0,0.028593,33,1,0.191657,2660.000000,8,0,0,0,0.000000),
(0,1.000000,31,0,0.000000,1200.000000,0,0,0,0,0.000000),
(0,0.536349,48,0,0.147754,4317.000000,6,0,0,0,2.000000),
(0,0.026159,74,0,41.000000,5400.000000,3,0,0,0,0.000000),
(0,0.009937,76,0,0.327737,5598.000000,16,0,2,0,0.000000),
(0,0.020740,78,0,374.000000,5400.000000,3,0,0,0,1.000000),
(0,0.371644,32,0,0.427944,4100.000000,13,0,0,1,2.000000),
(0,1.000000,42,0,0.082983,5000.000000,1,1,0,0,2.000000),
(0,0.032234,70,0,142.000000,5400.000000,6,0,1,0,0.000000),
(1,0.924602,43,1,0.367098,6880.000000,4,0,0,0,1.000000),
(0,0.250519,77,0,0.363636,4300.000000,24,0,0,0,0.000000),
(0,0.001128,81,1,4546.000000,5400.000000,13,0,5,0,0.000000),
(0,0.017836,80,0,1062.000000,5400.000000,13,0,2,0,0.000000),
(0,0.038488,42,0,1.225011,2270.000000,10,0,2,0,2.000000),
(0,0.680632,33,0,0.057983,3500.000000,4,0,0,0,3.000000),
(0,0.101811,36,0,0.816437,5000.000000,6,0,2,0,2.000000),
(1,1.000000,55,0,0.025399,3700.000000,1,2,0,1,0.000000),
(0,0.435904,43,0,0.353206,5769.000000,5,0,1,0,0.000000),
(0,0.519303,40,0,0.765896,8004.000000,12,0,3,0,0.000000),
(0,0.293554,63,0,0.282177,6300.000000,8,0,1,0,0.000000),
(0,0.203916,57,0,0.346379,7000.000000,8,0,1,0,1.000000),
(0,1.000000,32,0,0.096394,2800.000000,1,0,0,0,1.000000),
(0,0.179849,45,0,0.308615,4166.000000,7,0,2,0,0.000000),
(0,0.000000,60,0,0.203311,9000.000000,7,0,2,0,1.000000),
(0,0.263407,60,0,2300.000000,5400.000000,21,0,1,0,0.000000),
(0,0.013175,41,0,0.121860,8000.000000,8,0,0,0,2.000000),
(0,0.180280,47,0,0.028497,10000.000000,4,0,0,0,5.000000),
(0,0.101740,64,0,0.361221,3800.000000,9,0,1,0,0.000000),
(0,1.209302,49,0,10.000000,5400.000000,1,0,0,0,0.000000),
(0,0.617672,44,1,0.141303,6800.000000,8,0,0,0,2.000000),
(0,0.011140,83,0,18.000000,5400.000000,3,0,0,0,0.000000),
(0,1.000000,45,0,0.000000,4000.000000,3,0,0,0,4.000000),
(1,0.955200,44,0,2277.000000,5400.000000,10,0,1,0,0.000000),
(0,0.038951,69,0,0.179794,8442.000000,15,0,2,0,0.000000),
(0,0.006342,61,0,0.423549,6513.000000,19,0,3,0,1.000000),
(0,0.655345,35,0,0.294356,3950.000000,6,0,0,0,2.000000),
(0,0.494344,51,0,0.692561,3333.000000,6,0,1,0,0.000000),
(1,1.000783,49,1,0.642630,6600.000000,9,0,1,1,0.000000),
(0,0.105556,45,0,0.222071,8100.000000,5,0,2,0,2.000000),
(0,0.208583,50,0,0.050888,6700.000000,10,1,0,0,1.000000),
(0,0.136794,92,1,0.235087,3972.000000,11,0,1,0,1.000000),
(0,0.169233,47,0,0.228154,5000.000000,6,0,1,0,2.000000),
(1,1.000000,46,0,117.000000,5400.000000,2,0,0,0,0.000000),
(0,0.441343,45,0,1.404298,2000.000000,15,0,1,0,0.000000),
(0,0.071486,53,0,0.182434,8857.000000,3,0,2,0,1.000000),
(0,0.007318,64,0,419.000000,5400.000000,7,0,0,0,0.000000),
(0,0.026048,49,0,0.322922,10500.000000,24,0,3,0,0.000000),
(0,0.508255,47,0,0.583696,7813.000000,9,0,1,0,1.000000),
(1,1.000000,41,0,0.492424,5147.000000,5,1,1,0,1.000000),
(0,0.280334,34,0,0.558412,3500.000000,10,0,1,0,0.000000),
(0,0.014084,67,0,0.129409,4705.000000,7,0,1,0,0.000000),
(0,0.508009,49,1,0.360941,8970.000000,10,0,2,0,4.000000),
(0,0.000116,60,0,0.008918,14800.000000,5,0,0,0,1.000000),
(0,0.075930,40,0,87.000000,5400.000000,9,0,0,0,0.000000),
(0,0.000000,28,0,586.000000,5400.000000,11,0,0,0,0.000000),
(0,0.846164,47,0,0.571108,5793.000000,12,0,1,0,0.000000),
(0,0.010646,32,0,0.000831,6016.000000,8,0,0,0,2.000000),
(0,0.031678,28,0,0.114238,2380.000000,7,0,0,0,0.000000),
(0,0.155959,41,0,2599.000000,0.000000,5,0,1,0,0.000000),
(0,1.000000,62,0,0.032639,1776.000000,1,1,0,0,0.000000),
(0,0.281678,32,0,0.400888,8333.000000,7,0,1,0,4.000000),
(0,1.000000,24,0,602.000000,5400.000000,0,0,0,0,0.000000),
(0,0.358290,71,0,1342.000000,5400.000000,4,0,1,0,0.000000),
(0,0.081071,44,0,0.332042,16000.000000,9,0,4,0,3.000000),
(0,0.006632,27,0,0.186841,2750.000000,6,0,0,0,0.000000),
(0,0.197213,49,1,0.196001,4050.000000,6,0,1,2,0.000000),
(0,0.412840,33,0,853.000000,5400.000000,9,0,0,0,2.000000),
(0,0.054562,67,0,91.000000,5400.000000,4,0,0,0,0.000000),
(0,0.000000,48,0,0.000000,5400.000000,2,0,0,0,0.000000),
(0,0.049890,44,1,2549.000000,5400.000000,6,0,1,0,0.000000),
(0,0.556592,45,0,1.409716,6833.000000,22,0,8,0,0.000000),
(0,1.000000,30,0,0.000000,5400.000000,0,1,0,0,0.000000),
(0,0.906382,50,0,5317.000000,5400.000000,16,0,2,0,2.000000),
(0,0.594106,42,0,0.838448,7526.000000,14,0,4,0,2.000000),
(0,0.033830,58,0,0.177038,8500.000000,10,0,2,0,0.000000),
(0,0.041397,64,0,0.018495,4000.000000,5,0,0,0,1.000000),
(0,0.046458,64,0,0.133117,7083.000000,9,0,0,0,0.000000),
(0,0.033935,57,0,5354.000000,5400.000000,9,0,2,0,4.000000),
(0,0.103660,29,0,0.195399,3085.000000,5,0,0,0,0.000000),
(0,1.000000,53,0,0.102674,10995.000000,7,0,0,0,2.000000),
(1,1.000000,30,0,0.000000,2900.000000,3,0,0,0,1.000000),
(0,0.151567,61,0,0.523102,8483.000000,3,0,1,0,0.000000),
(1,0.680162,47,4,0.378736,9000.000000,7,0,1,0,2.000000),
(0,1.000000,55,0,0.958208,5000.000000,8,0,3,0,0.000000),
(0,0.060876,67,0,0.122324,5885.000000,10,0,0,0,2.000000),
(0,1.000000,24,0,0.176026,925.000000,1,0,0,0,0.000000),
(0,0.672443,85,2,0.020381,5347.000000,7,1,0,1,0.000000),
(0,0.389288,63,0,1633.000000,5400.000000,9,0,1,0,0.000000),
(0,0.376297,55,0,1663.000000,5400.000000,5,0,1,0,0.000000),
(0,0.000000,35,0,0.195701,4000.000000,9,0,0,0,4.000000),
(0,0.288158,38,0,0.494089,5666.000000,5,0,2,0,1.000000),
(0,0.484137,46,0,0.144114,12392.000000,7,0,1,0,0.000000),
(0,0.084647,70,0,0.224233,5966.000000,4,0,1,0,0.000000),
(0,0.703167,55,0,0.174802,11000.000000,12,0,0,0,0.000000),
(0,0.076419,44,0,4200.000000,5400.000000,23,0,3,0,3.000000),
(0,0.017639,89,0,0.007223,2214.000000,6,0,0,0,0.000000),
(0,0.008577,49,0,0.142343,2500.000000,10,0,0,0,0.000000),
(0,0.806523,27,0,0.514186,8000.000000,11,0,0,0,0.000000),
(0,0.009386,71,0,0.010706,2988.000000,12,0,0,0,0.000000),
(0,0.862343,34,0,0.370257,5217.000000,6,0,1,1,2.000000),
(0,0.665174,54,0,0.166103,2955.000000,3,0,0,0,0.000000),
(0,0.007230,54,0,705.000000,5400.000000,4,0,2,0,0.000000),
(0,0.025797,75,0,0.005178,15834.000000,2,0,0,0,1.000000),
(0,0.223678,35,0,0.375292,9000.000000,7,0,1,0,0.000000),
(0,0.000000,42,0,0.000000,5000.000000,2,0,0,0,0.000000),
(0,0.242501,27,0,40.000000,5400.000000,1,0,0,0,0.000000),
(0,0.838061,65,2,0.568128,8050.000000,15,0,1,0,0.000000),
(0,0.101924,63,0,0.327049,3500.000000,7,0,1,0,1.000000),
(0,0.101897,24,0,0.017257,1100.000000,7,0,0,0,0.000000),
(0,0.891624,37,0,0.564257,4800.000000,8,0,1,0,1.000000),
(0,0.786357,44,0,0.066129,11416.000000,7,0,0,0,0.000000),
(0,0.936690,50,1,1660.000000,5400.000000,7,0,1,0,0.000000),
(0,0.339486,31,0,0.514125,10300.000000,15,0,2,0,0.000000),
(0,0.611393,51,0,0.401873,9609.000000,14,0,2,0,0.000000),
(0,0.151847,56,1,0.291384,14866.000000,15,0,1,0,1.000000),
(0,0.007293,58,0,0.470048,11000.000000,10,0,1,0,0.000000),
(0,0.036632,61,0,1102.000000,5400.000000,6,0,1,0,0.000000),
(0,0.004538,82,0,0.002221,2701.000000,4,0,0,0,1.000000),
(0,0.027560,78,0,9.000000,5400.000000,3,0,0,0,0.000000),
(0,0.615060,47,0,2.777497,790.000000,7,0,0,0,0.000000),
(0,0.239984,33,0,0.553889,5000.000000,6,0,1,0,1.000000),
(0,0.071618,70,0,1557.000000,5400.000000,18,0,1,0,0.000000),
(0,0.239736,45,0,0.732259,5833.000000,9,0,1,0,0.000000),
(0,0.087409,39,0,0.389115,4666.000000,6,0,2,0,1.000000),
(0,0.291791,37,0,4729.000000,5400.000000,6,0,2,0,0.000000),
(0,0.023749,59,0,0.090884,21730.000000,8,0,1,0,0.000000),
(1,1.022704,44,2,0.200472,8050.000000,6,2,0,2,1.000000),
(0,0.822859,37,0,637.000000,5400.000000,2,0,0,0,0.000000),
(1,1.000000,36,0,2730.000000,5400.000000,2,0,2,0,0.000000),
(0,1.634551,28,0,151.000000,5400.000000,1,3,0,2,0.000000),
(0,0.007329,68,0,0.145238,12000.000000,20,0,1,0,0.000000),
(0,1.000000,46,0,0.001143,7000.000000,0,0,0,0,3.000000),
(0,0.000000,60,0,0.624692,3652.000000,9,0,2,0,0.000000),
(0,0.537109,56,0,1.065304,2250.000000,3,0,1,0,0.000000),
(0,0.319448,55,1,0.133364,2166.000000,6,0,0,0,1.000000),
(0,0.073917,44,0,0.182859,7595.000000,8,0,1,0,0.000000),
(0,0.068063,52,0,0.226804,3200.000000,12,0,2,0,0.000000),
(0,0.335712,41,0,0.648860,3200.000000,3,0,2,0,0.000000),
(0,0.504431,25,0,0.188216,3750.000000,13,0,0,0,0.000000),
(0,0.271031,49,0,3.214642,600.000000,12,0,2,0,2.000000),
(0,0.047648,73,0,639.000000,5400.000000,5,0,1,0,0.000000),
(0,0.159245,50,0,0.410598,6000.000000,5,0,1,0,0.000000),
(0,0.741639,55,1,0.652793,8000.000000,7,0,1,0,0.000000),
(0,0.456196,65,0,0.395202,3000.000000,6,0,0,0,0.000000),
(0,0.004571,28,0,0.008595,5700.000000,4,0,0,0,0.000000),
(0,0.152990,65,0,704.000000,5400.000000,4,0,1,0,0.000000),
(0,0.373342,48,2,3.452438,1250.000000,27,0,2,0,2.000000),
(0,0.371401,29,0,0.459297,3500.000000,8,0,1,0,2.000000),
(1,0.966777,40,2,0.902611,2833.000000,5,3,1,1,2.000000),
(0,0.978734,32,1,1.110963,3000.000000,16,0,1,0,0.000000),
(1,0.909495,23,0,0.149140,2500.000000,8,0,0,0,0.000000),
(0,0.016423,83,0,0.005982,4178.000000,8,0,0,0,0.000000),
(0,0.165360,71,0,0.349833,5999.000000,11,0,2,0,0.000000),
(0,0.683332,48,1,2349.000000,5400.000000,9,0,2,0,0.000000),
(0,0.000000,78,0,0.688541,3900.000000,8,0,1,0,0.000000),
(0,0.188387,56,0,0.078539,16042.000000,3,0,1,0,3.000000),
(0,0.904560,36,0,0.358806,7000.000000,15,0,0,0,1.000000),
(0,0.000000,24,0,0.000000,3100.000000,1,0,0,0,0.000000),
(0,0.024625,50,0,0.197565,7227.000000,6,0,1,0,0.000000),
(0,0.000000,81,0,0.000000,5400.000000,4,0,0,0,0.000000),
(0,0.012536,67,0,1876.000000,5400.000000,12,0,1,0,0.000000),
(0,0.161528,77,0,0.073168,8500.000000,3,0,0,0,1.000000),
(1,1143.000000,44,2,0.547762,6500.000000,13,0,4,0,2.000000),
(0,0.279618,59,2,0.150286,9095.000000,6,0,1,0,1.000000),
(0,0.037579,68,0,1934.000000,5400.000000,6,0,1,0,0.000000),
(0,0.003574,60,0,2.000000,5400.000000,5,0,0,0,0.000000),
(0,0.343658,58,2,0.316710,8000.000000,14,0,1,0,0.000000),
(0,1.000000,23,0,0.117034,862.000000,1,0,0,0,0.000000),
(0,0.442309,43,0,0.063498,5133.000000,4,0,0,1,1.000000),
(0,0.004222,77,0,0.002671,1122.000000,5,0,0,0,0.000000),
(0,0.113971,35,0,0.667822,7790.000000,16,0,7,0,0.000000);
