﻿Namespace AI_AGENT

    ''' <summary>
    ''' These are the Device Models Required for creating Input and Output devices which can be attached to the Intelligent Agent
    ''' </summary>
    Public Class Devices

        ''' <summary>
        ''' Allows For input devices to be attached to the Intelligent Agent
        ''' </summary>
        ''' <remarks></remarks>
        Public Interface InputDevice

            ''' <summary>
            ''' Occurs when Text is populated.
            ''' </summary>
            ''' <remarks></remarks>
            Event SensorTextRecieved(ByRef Recieved As Boolean)

            ''' <summary>
            ''' Gets a value indicating whether Sensor is activated to allow output.
            ''' </summary>
            ''' <value><see langword="true"/> if ; otherwise, Sensor is not Updating Text <see langword="false"/>.</value>
            ''' <remarks></remarks>
            ReadOnly Property Activated As Boolean

            ''' <summary>
            ''' Gets Identification.
            ''' </summary>
            ''' <value></value>
            ''' <remarks></remarks>
            ReadOnly Property Name As String

            ''' <summary>
            ''' Gets TextRecived held in Class.
            ''' </summary>
            ''' <value></value>
            ''' <remarks></remarks>
            ReadOnly Property RecievedText As String

            ''' <summary>
            ''' Activates Sensor
            ''' </summary>
            ''' <remarks></remarks>
            Sub Activate()

            ''' <summary>
            ''' Deactivates sensor
            ''' </summary>
            ''' <remarks></remarks>
            Sub Deactivate()

        End Interface

        ''' <summary>
        ''' Abstract Class: Publisher / Subscriber DesignPattern This allows for clients to register
        ''' to receive Response Updates from the Agentmodel subscribers implement this interface to
        ''' receive notifications from the publisher
        ''' </summary>
        Public Interface IntelligentAgentResponseObserver

            ''' <summary>
            ''' This is the channel to receive data from the publisher this variable needs to match
            ''' the data being updated from the publisher
            '''
            ''' Inputs received to the Agent will be sent to subscribers
            ''' </summary>
            ''' <param name="Data"></param>
            Sub UpdateInput(ByVal Data As String)

            ''' <summary>
            ''' This is the channel to receive data from the publisher this variable needs to match
            ''' the data being updated from the publisher
            '''
            ''' Responses Generated by the Agent will be sent to subscribers
            ''' </summary>
            ''' <param name="Data"></param>
            Sub UpdateResponse(ByVal Data As String)

        End Interface

        ''' <summary>
        ''' Allows for Output devices to be attached to the Class
        ''' </summary>
        ''' <remarks></remarks>
        Public Interface OutputDevice

            ''' <summary>
            ''' Gets a value indicating whether The device is loaded as an output device.
            ''' </summary>
            ''' <value><see langword="true"/> if ; otherwise, <see langword="false"/>.</value>
            ''' <remarks></remarks>
            ReadOnly Property Loaded As Boolean

            ''' <summary>
            ''' Activates all actuators
            ''' </summary>
            ''' <param name="Text"></param>
            ''' <remarks></remarks>
            Sub EffectActuators(ByRef Text As String)

            ''' <summary>
            ''' Loads the device
            ''' </summary>
            ''' <remarks></remarks>
            Sub load()

            ''' <summary>
            ''' Unloads the device
            ''' </summary>
            ''' <remarks></remarks>
            Sub Unload()

        End Interface

    End Class

End Namespace
