/*
 * Copyright 2015 Netflix, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.netflix.spinnaker.igor.scm.bitbucket.client.model

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonProperty

import java.time.ZonedDateTime

@JsonIgnoreProperties(ignoreUnknown = true)
class Commit {
  String hash
  Author author
  String html_href
  Date date
  String message

  @JsonProperty("links")
  public void setUser(Map<String, Object> links) {
    def html = links.get("html")
    html_href = html.href.toString()
  }

  @JsonProperty(value = "date")
  public void setDate(String utctimestamp) {
    date = ZonedDateTime.parse(utctimestamp).toDate()
  }
}
