import test from 'tape'
import nlp from '../_lib.js'
const here = '[two/past-adj] '

let arr = [
  // == adjectives ==
  [`'cool'`, '#Adjective'],
  ['great', '#Adjective'],
  ['legendary', '#Adjective'],
  ['above', '#Adjective'],
  ['moderate', '#Adjective'],
  ['extreme', '#Adjective'],
  ['John is pretty', '#Person #Copula #Adjective'],
  ['John was lofty', '#Person #Copula #Adjective'],
  ['John Smith was lofty', '#FirstName #LastName #Copula #Adjective'],
  ['asdfes was lofty', '#Noun #Copula #Adjective'],
  ['asdfes lksejfj was lofty', '#Noun #Noun #Copula #Adjective'],
  ['5 red roses', '#Value #Adjective #Noun'],
  ['walking is fun', '#Activity #Copula #Adjective'],
  ["walking's great", '#Activity #Copula #Adjective'],
  ['jack is guarded', '#Person #Copula #Adjective'],
  ['jack seems guarded', '#Person #Verb #Adjective'],
  ['germans are nice', '#Demonym #Verb #Adjective'],
  ['Iraqis are nice', '#Plural #Copula #Adjective'],
  ['canadians are nice', '#ProperNoun #Verb #Adjective'],
  ['thom is smart', '#ProperNoun #Verb #Adjective'],
  [`very detailed plan`, '. #Adjective #Noun'],
  [`our detailed plan`, '. #Adjective #Noun'],
  [`the detailed plan`, '. #Adjective #Noun'],
  [`well equipped`, '. #Adjective'],
  [`deeply closed`, `. #Adjective`],
  [`a detailed plan`, 'a #Adjective .'],
  [`seemed closed`, `. #Adjective`],
  [`my failed class`, 'my #Adjective .'],
  [`intoxicated little`, '#Adjective .'],
  [`quickly closed`, `. #PastTense`],
  [`badly damaged`, `. #Adjective`],
  [`each promising image`, '#Determiner #Adjective #Singular'],
  [`the ruling party`, '#Determiner #Noun #Singular'],
  [`deli serves up smoked meat`, '#Noun #PhrasalVerb #Particle #Adjective #Noun'],
  [`The pie was bland and overcooked.`, 'the #Noun was #Adjective and #Adjective'],
  [`our beloved sons`, '#Possessive #Adjective #Noun'],
  [`spaghetti and steamed rice`, '#Noun and #Adjective #Noun'],
  [`for suspected terrorists`, 'for #Adjective #Plural'],
  [`for discounted beauty items`, 'for #Adjective #Noun #Plural'],
  // [`number of registered party members`, '#Noun of #Adjective #Noun #Plural'],
  [`rely on bottled water`, '#Verb on #Adjective #Noun'],

  // === PastTense ===
  [`quickly detailed`, '. #PastTense'],
  [`closed it`, `#PastTense .`],
  [`cramped his style`, `#PastTense #Pronoun #Noun`],
  [`he detailed`, '. #PastTense'],
  ['jack cheered', '#Person #PastTense'],
  ['jack guarded', '#Person #PastTense'],
  // ['baked', '#PastTense'],
  ['faked', '#PastTense'],
  ['maked', '#PastTense'],
  ['mistaked', '#PastTense'],
  ['overtook', '#PastTense'],
  ['remaked', '#PastTense'],
  ['retaked', '#PastTense'],
  ['forsaked', '#PastTense'],
  ['shaked', '#PastTense'],
  ['snaked', '#PastTense'],
  ['took', '#PastTense'],
  ['undertook', '#PastTense'],
  //-ced
  ['they lanced', '. #PastTense'],
  ['he balanced', '. #PastTense'],
  ['we seduced', '. #PastTense'],
  //-shed
  ['impoverished', '#PastTense'],
  ['stashed', '#PastTense'],
  ['crashed', '#PastTense'],
  //-sed
  ['amused', '#PastTense'],
  ['he bruised', 'he #PastTense'],
  ['crossed', '#PastTense'],
  ['dressed', '#PastTense'],
  ['he exposed', 'he #PastTense'],
  ['tossed', '#PastTense'],
  ['tensed', '#PastTense'],
  ['hosed', '#PastTense'],
  //-led
  ['consoled', '#PastTense'],
  ['fuelled', '#PastTense'],
  ['nailed', '#PastTense'],
  ['nestled', '#PastTense'],
  ['riddled', '#PastTense'],
  ['sailed', '#PastTense'],
  ['totaled', '#PastTense'],
  ['whirled', '#PastTense'],
  //-ked
  ['linked', '#PastTense'],
  ['freaked', '#PastTense'],
  ['tucked', '#PastTense'],
  ['cocked', '#PastTense'],
  ['pounced', '#PastTense'],
  ['punched', '#PastTense'],
  ['rumbled', '#PastTense'],
  ['wetted', '#PastTense'],
  ['dubbed', '#PastTense'],
  ['trascribed', '#PastTense'],
  ['barred', '#PastTense'],
  ['vetoed', '#PastTense'],
  ['drenched', '#PastTense'],
  ['fetched', '#PastTense'],
  ['sighed', '#PastTense'],
  ['encouraged', '#PastTense'],
  ['messaged', '#PastTense'],
  ['tugged', '#PastTense'],
  ['wedged', '#PastTense'],
  ['beeped', '#PastTense'],
  ['topped', '#PastTense'],
  ['wiped', '#PastTense'],
  ['logged', '#PastTense'],
  ['displayed', '#PastTense'],
  ['skyped', '#PastTense'],
  ['swallowed', '#PastTense'],
  ['viewed', '#PastTense'],
  ['mooned', '#PastTense'],
  ['boozed', '#PastTense'],
  ['stowed', '#PastTense'],
  ['issued', '#PastTense'],
  ['accrued', '#PastTense'],
  ['defended', '#PastTense'],
  ['engulfed', '#PastTense'],
  ['fed', '#PastTense'],
  ['strafed', '#PastTense'],
  ['stifled', '#PastTense'],
  ['winged', '#PastTense'],
  ['he amazed', 'he #PastTense'],
  ['boxed', '#PastTense'],
  ['shoved', '#PastTense'],
  ['attained', '#PastTense'],
  ['warmed', '#PastTense'],
  ['they dried', 'they #PastTense'],
  ['we rallied', 'we #PastTense'],
  // context
  // ['poodles like being pampered', '#Plural #Infinitive #Gerund #PastTense'],
  ['poodles like to be pampered', '#Plural #Infinitive to #Verb #PastTense'],
  [`we charged back`, 'we #PastTense #Adverb'],
  [`it sliced backward`, 'it #PastTense #Adverb'],
  [`smelled like smoke`, '#PastTense . #Noun'],
  [`faded by fakes`, `#PastTense #Preposition #Plural`],
  [`stranded on base`, `#PastTense #Preposition #Noun`],
  [`ended in ruins`, `#PastTense #Preposition #Plural`],
  [`found in vertebrates`, `#PastTense #Preposition #Plural`],
  [`served by branches`, `#PastTense #Preposition #Plural`],
  [`ended in ruin`, `#PastTense #Preposition #Noun`],
  [`Fullerton created this show`, '#Noun #PastTense #Determiner #Noun'],
  [`should have her hand pierced`, 'should have her #Noun #PastTense'],
  [`will have waited until release`, '#Auxiliary #Auxiliary #PastTense until #Noun'],
  // ['it was fixed', '#Noun #Copula #PastTense'],
  ['it will be boxed', '#Noun #Verb #Verb #PastTense'],
  // ['i am gutted', '#Noun #PastTense #Adjective'],
  // [
  //   'She felt abandoned about the sudden change in plans',
  //   '#Pronoun #PastTense #Adjective #Preposition #Determiner #Adjective #Noun #Preoposition #Noun',
  // ],
  [
    'The puzzled detective was bewildered about the abandoned clues.',
    '#Determiner #Adjective #Noun #Copula #Adjective #Preposition #Determiner #Adjective #Noun',
  ],
  [
    "He was amazed about the abandoned building's mysterious past.",
    '#Pronoun #Copula #Adjective #Preposition #Determiner #Adjective #Possessive #Adjective #Noun',
  ],
  ['He also developed software.', '#Pronoun #Adverb #Verb #Noun'],
  ['Cheese is also aged', '#Noun #Copula #Adverb #Adjective'],
]
test('match:', function (t) {
  arr.forEach(function (a) {
    let [str, match] = a
    let doc = nlp(str).compute('tagRank')
    let tags = doc.json()[0].terms.map(term => term.tagRank[0])
    let m = doc.match(match)
    let msg = `'${(str + "' ").padEnd(20, ' ')}  - '${tags.join(', ')}'`
    t.equal(m.text(), doc.text(), here + msg)
  })
  t.end()
})
