// tag tests that should always pass
//  combination of two datasets:
// the free subset of the Penn-treebank
// and part of the Universal Dependencies English Web Treebank v2.6 -- 2020-05-15
export default [
  {
    text: 'Dr. Talcott led a team of researchers from the National Cancer Institute and the medical schools of Harvard University and Boston University.',
    tags: 'NNP, NNP, VBD, DT, NN, IN, NNS, IN, DT, NNP, NNP, NNP, CC, DT, JJ, NNS, IN, NNP, NNP, CC, NNP, NNP',
  },
  {
    text: 'The monthly sales have been setting records every month since March.',
    tags: 'DT, JJ, NNS, VBP, VBN, VBG, NNS, DT, NN, IN, NNP',
  },
  {
    text: ' Cray Computer will be a concept stock, he said.',
    tags: 'NNP, NNP, MD, VB, DT, NN, NN, PRP, VBD',
  },
  {
    text: 'Esso said the Whiting field started production Tuesday.',
    tags: 'NNP, VBD, DT, NNP, NN, VBD, NN, NNP',
  },
  {
    text: 'Pick a country, any country.',
    tags: 'VB, DT, NN, DT, NN',
  },
  {
    text: 'They fell into oblivion after the 1929 crash.',
    tags: 'PRP, VBD, IN, NN, IN, DT, CD, NN',
  },
  {
    text: 'Political and currency gyrations can whipsaw the funds.',
    tags: 'JJ, CC, NN, NNS, MD, VB, DT, NNS',
  },
  {
    text: 'They cite a lack of imbalances that provide early warning signals of a downturn.',
    tags: 'PRP, VBP, DT, NN, IN, NNS, CC, VBP, JJ, NN, NNS, IN, DT, NN',
  },
  // {
  //   text: 'Characters drink Salty Dogs, whistle Johnny B. Goode and watch Bugs Bunny reruns.',
  //   tags: 'NNS, VBP, NNP, NNP, VBP, NNP, NNP, NNP, CC, VBP, NNP, NNP, NNS',
  // },
  {
    text: 'They read Mickey Spillane and talk about Groucho and Harpo.',
    tags: 'PRP, VBP, NNP, NNP, CC, VBP, IN, NNP, CC, NNP',
  },
  {
    text: ' Consider Jim Courter.',
    tags: 'VB, NNP, NNP',
  },
  {
    text: 'But it resists yielding political ground.',
    tags: 'CC, PRP, VBZ, VBG, JJ, NN',
  },
  {
    text: ' In Asia, as in Europe, a new order is taking shape, Mr. Baker said.',
    tags: 'IN, NNP, IN, IN, NNP, DT, JJ, NN, VBZ, VBG, NN, NNP, NNP, VBD',
  },
  {
    text: 'And South Carolina says it is getting results.',
    tags: 'CC, NNP, NNP, VBZ, PRP, VBZ, VBG, NNS',
  },
  // {
  //   text: " It was full of violence and gangs and kids cutting class, says Linda Ward, the school's principal.",
  //   tags: 'PRP, VBD, JJ, IN, NN, CC, NNS, CC, NNS, VBG, NN, VBZ, NNP, NNP, DT, NN, NN',
  // },
  {
    text: 'I believe in the system.',
    tags: 'PRP, VBP, IN, DT, NN',
  },
  {
    text: 'Mrs. Yeargin declined.',
    tags: 'NNP, NNP, VBD',
  },
  {
    text: 'Yeargin won widespread local support.',
    tags: 'NNP, VBD, JJ, JJ, NN',
  },
  {
    text: 'But Learning Materials matched on 66.5 of 69 subskills.',
    tags: 'CC, NNP, NNPS, VBD, IN, CD, IN, CD, NNS',
  },
  {
    text: 'The two banks merged in 1985.',
    tags: 'DT, CD, NNS, VBD, IN, CD',
  },
  {
    text: "He said the company's core business remains strong.",
    tags: 'PRP, VBD, DT, NN, NN, NN, VBZ, JJ',
  },
  {
    text: 'Estimated volume was a moderate 3.5 million ounces.',
    tags: 'VBN, NN, VBD, DT, JJ, CD, CD, NNS',
  },
  {
    text: 'Mr. Gillespie at Viacom says the ratings are rising.',
    tags: 'NNP, NNP, IN, NNP, VBZ, DT, NNS, VBP, VBG',
  },
  {
    text: 'Ad Notes....',
    tags: 'NNP, NNPS',
  },
  {
    text: 'The business had been handled by VanSant Dugdale, Baltimore.',
    tags: 'DT, NN, VBD, VBN, VBN, IN, NNP, NNP, NNP',
  },
  {
    text: ' The economy is clearly slowing, says Robert Black, president of the Richmond Federal Reserve Bank.',
    tags: 'DT, NN, VBZ, RB, VBG, VBZ, NNP, NNP, NN, IN, DT, NNP, NNP, NNP, NNP',
  },
  {
    text: 'They will mature Dec. 21.',
    tags: 'PRP, MD, VB, NNP, CD',
  },
  {
    text: 'Lancaster Colony Corp. said it acquired Reames Foods Inc. in a cash transaction.',
    tags: 'NNP, NNP, NNP, VBD, PRP, VBD, NNP, NNP, NNP, IN, DT, NN, NN',
  },
  {
    text: 'NL is officially making the offer.',
    tags: 'NNP, VBZ, RB, VBG, DT, NN',
  },
  {
    text: "The Japanese fret openly about the U.S. public's rancor.",
    tags: 'DT, NNP, NN, RB, IN, DT, NNP, NN, NN',
  },
  {
    text: 'But many banks are turning away from strict price competition.',
    tags: 'CC, JJ, NNS, VBP, VBG, RB, IN, JJ, NN, NN',
  },
  {
    text: 'One big reason: thin margins.',
    tags: 'CD, JJ, NN, JJ, NNS',
  },
  {
    text: 'Buy a new Chevrolet.',
    tags: 'VB, DT, JJ, NNP',
  },
  {
    text: 'Buy a diamond necklace.',
    tags: 'VB, DT, NN, NN',
  },
  {
    text: 'In fact, the market has always tanked.',
    tags: 'IN, NN, DT, NN, VBZ, RB, VBN',
  },
  {
    text: 'Always.',
    tags: 'RB',
  },
  {
    text: 'China pulled out of the program in July.',
    tags: 'NNP, VBD, VB, IN, DT, NN, IN, NNP',
  },
  {
    text: 'But regulators are wary.',
    tags: 'CC, NNS, VBP, JJ',
  },
  {
    text: 'He also is a consensus manager, insiders say.',
    tags: 'PRP, RB, VBZ, DT, NN, NN, NNS, VBP',
  },
  {
    text: 'Compromises are possible.',
    tags: 'NNS, VBP, JJ',
  },
  {
    text: 'The company acknowledges some problems.',
    tags: 'DT, NN, VBZ, DT, NNS',
  },
  {
    text: 'A number of cities including Minneapolis, Philadelphia and Houston have vacant grain elevators, Eggers says.',
    tags: 'DT, NN, IN, NNS, VBG, NNP, NNP, CC, NNP, VBP, JJ, NN, NNS, NNP, VBZ',
  },
  {
    text: 'They suffered from malnutrition, chest diseases, cardiovascular disorders, skin problems, infectious diseases and the aftereffects of assaults and rape.',
    tags: 'PRP, VBD, IN, NN, NN, NNS, JJ, NNS, NN, NNS, JJ, NNS, CC, DT, NNS, IN, NNS, CC, NN',
  },
  {
    text: 'That was the law.',
    tags: 'DT, VBD, DT, NN',
  },
  {
    text: 'It was censorship.',
    tags: 'PRP, VBD, NN',
  },
  {
    text: 'It was outrageous.',
    tags: 'PRP, VBD, JJ',
  },
  {
    text: 'But the court disagreed.',
    tags: 'CC, DT, NN, VBD',
  },
  {
    text: 'The man was Charles Z. Wick.',
    tags: 'DT, NN, VBD, NNP, NNP, NNP',
  },
  {
    text: ' Bob has handled the extraordinary growth of the company quite brilliantly, said Mr. Newhouse.',
    tags: 'NNP, VBZ, VBN, DT, JJ, NN, IN, DT, NN, RB, RB, VBD, NNP, NNP',
  },
  {
    text: 'President Reagan learned that lesson.',
    tags: 'NNP, NNP, VBD, DT, NN',
  },
  {
    text: 'Mr. Sidak served as an attorney in the Reagan administration.',
    tags: 'NNP, NNP, VBD, IN, DT, NN, IN, DT, NNP, NN',
  },
  {
    text: 'The death of the Herald, a newsstand paper in a freeway town, was perhaps inevitable.',
    tags: 'DT, NN, IN, DT, NNP, DT, NN, NN, IN, DT, NN, NN, VBD, RB, JJ',
  },
  {
    text: ' The Herald was a survivor from a bygone age, said J. Kendrick Noble, a media analyst with PaineWebber Inc.',
    tags: 'DT, NNP, VBD, DT, NN, IN, DT, JJ, NN, VBD, NNP, NNP, NNP, DT, NNS, NN, IN, NNP, NNP',
  },
  {
    text: 'The reaction in the newsroom was emotional.',
    tags: 'DT, NN, IN, DT, NN, VBD, JJ',
  },
  {
    text: 'The program traders, on the other hand, portray old-fashioned stock pickers as the Neanderthals of the industry.',
    tags: 'DT, NN, NNS, IN, DT, JJ, NN, VBP, JJ, JJ, NN, NNS, IN, DT, NNS, IN, DT, NN',
  },
  {
    text: 'Reducing volatility.',
    tags: 'VBG, NN',
  },
  {
    text: 'Ballot watchers say attention already is focused on the 1990 elections.',
    tags: 'NN, NNS, VBP, NN, RB, VBZ, VBN, IN, DT, CD, NNS',
  },
  {
    text: 'Colleges, she says, are eyeing registration through 900 service.',
    tags: 'NNS, PRP, VBZ, VBP, VBG, NN, IN, CD, NN',
  },
  {
    text: 'FAMILY PETS are improving recovery rates of patients at Columbia Hospital, Milwaukee.',
    tags: 'NN, NNS, VBP, VBG, NN, NNS, IN, NNS, IN, NNP, NNP, NNP',
  },
  {
    text: 'The appointment takes effect Nov. 13.',
    tags: 'DT, NN, VBZ, NN, NNP, CD',
  },
  {
    text: 'Heiwado Co.',
    tags: 'NNP, NNP',
  },
  {
    text: 'Guaranteed by Svenska Handelsbanken.',
    tags: 'VBN, IN, NNP, NNP',
  },
  {
    text: 'Mitsubishi Pencil Co.',
    tags: 'NNP, NNP, NNP',
  },
  {
    text: 'Koizumi Sangyo Corp.',
    tags: 'NNP, NNP, NNP',
  },
  {
    text: 'A stadium craze is sweeping the country.',
    tags: 'DT, NN, NN, VBZ, VBG, DT, NN',
  },
  // {
  //   text: 'Stock prices closed higher in Stockholm, Amsterdam and Frankfurt and lower in Zurich.',
  //   tags: 'NN, NNS, VBD, JJR, IN, NNP, NNP, CC, NNP, CC, JJR, IN, NNP',
  // },
  {
    text: 'A faster version, the SuperDot, was launched in 1984.',
    tags: 'DT, JJR, NN, DT, NNP, VBD, VBN, IN, CD',
  },

  {
    text: 'Columbia has only about 10 million common shares in public hands.',
    tags: 'NNP, VBZ, RB, IN, CD, CD, JJ, NNS, IN, JJ, NNS',
  },
  {
    text: 'But the concept is workable.',
    tags: 'CC, DT, NN, VBZ, JJ',
  },
  {
    text: "Mr. Spiegel's next career move is a subject of speculation on Wall Street.",
    tags: 'NNP, NNP, JJ, NN, NN, VBZ, DT, NN, IN, NN, IN, NNP, NNP',
  },
  {
    text: 'Wedtech management used the merit system.',
    tags: 'NNP, NN, VBD, DT, NN, NN',
  },
  {
    text: 'Numerous other scandals, among them the ones at HUD, have the same characteristics as Wedtech.',
    tags: 'JJ, JJ, NNS, IN, PRP, DT, NNS, IN, NNP, VBP, DT, JJ, NNS, IN, NNP',
  },
  {
    text: 'Railroad companies and some ports are reaping a sudden windfall of business.',
    tags: 'NN, NNS, CC, DT, NNS, VBP, VBG, DT, JJ, NN, IN, NN',
  },
  {
    text: ' The recent rally in precious metals was a result of uncertainty and volatility in equities, he said.',
    tags: 'DT, JJ, NN, IN, JJ, NNS, VBD, DT, NN, IN, NN, CC, NN, IN, NNS, PRP, VBD',
  },
  {
    text: 'The cells were operating in the Ghazaliyah and al-Jihad districts of the capital.',
    tags: 'DT, NNS, VBD, VBG, IN, DT, NNP, CC, NNP, NNP, NNS, IN, DT, NN',
  },
  {
    text: 'Al-Zaman: Guerrillas killed a member of the Kurdistan Democratic Party after kidnapping him in Mosul.',
    tags: 'NNP, NNP, NNS, VBD, DT, NN, IN, DT, NNP, NNP, NNP, IN, VBG, PRP, IN, NNP',
  },
  {
    text: 'Guerrillas killed an engineer, Asi Ali, from Tikrit.',
    tags: 'NNS, VBD, DT, NN, NNP, NNP, IN, NNP',
  },
  {
    text: "They also killed Shaikh Hamid 'Akkab, a clan elder of a branch of the Dulaim tribe in Tikrit.",
    tags: 'PRP, RB, VBD, NNP, NNP, NNP, DT, NN, NN, IN, DT, NN, IN, DT, NNP, NN, IN, NNP',
  },

  {
    text: 'One of them was from the Jubur tribe and was deputy commander of the Hawijah garrison.',
    tags: 'CD, IN, PRP, VBD, IN, DT, NNP, NN, CC, VBD, NN, NN, IN, DT, NNP, NN',
  },
  {
    text: 'There are a wealth of references on Chernobyl.',
    tags: 'EX, VBP, DT, NN, IN, NNS, IN, NNP',
  },
  {
    text: 'IAEA Report Lessons learned',
    tags: 'NNP, NN, NNPS, VBN',
  },
  {
    text: 'That too was stopped.',
    tags: 'DT, RB, VBD, VBN',
  },
  {
    text: 'It should continue to be defanged.',
    tags: 'PRP, MD, VB, TO, VB, VBN',
  },
  {
    text: 'George W. Bush alleged Thursday that John Edwards lacks the experience necessary to be president.',
    tags: 'NNP, NNP, NNP, VBD, NNP, IN, NNP, NNP, VBZ, DT, NN, JJ, TO, VB, NNP',
  },
  {
    text: 'November 5, 1999',
    tags: 'NNP, CD, CD',
  },
  {
    text: 'WASHINGTON (CNN) --',
    tags: 'NNP, NNP',
  },
  {
    text: 'Hiller asked Bush to name the leaders of Chechnya, Taiwan, India and Pakistan.',
    tags: 'NNP, VBD, NNP, TO, VB, DT, NNS, IN, NNP, NNP, NNP, CC, NNP',
  },
  {
    text: 'By Juan Cole',
    tags: 'IN, NNP, NNP',
  },
  {
    text: 'Friday, June 04, 2004',
    tags: 'NNP, NNP, CD, CD',
  },
  {
    text: 'By Ranjit Devraj',
    tags: 'IN, NNP, NNP',
  },
  {
    text: 'NEW DELHI -',
    tags: 'NNP, NNP',
  },
  // {
  //   text: 'But they, too, failed.',
  //   tags: 'CC, PRP, RB, VBD',
  // },
  {
    text: 'Colombo, too, seems to be in an intractable position.',
    tags: 'NNP, RB, VBZ, TO, VB, IN, DT, JJ, NN',
  },
  {
    text: 'Musharraf calls the bluff',
    tags: 'NNP, VBZ, DT, NN',
  },
  {
    text: 'M.D. Nalapat',
    tags: 'NNP, NNP',
  },
  {
    text: 'The F-102 saw service in the Vietnam theater between March 1962 and December 1969.',
    tags: 'DT, NNP, VBD, NN, IN, DT, NNP, NN, IN, NNP, CD, CC, NNP, CD',
  },
  {
    text: 'During this time, F-102 squadrons were based out of Tan Son Nhut, Da Nang and Bien Hoa in Vietnam, and Udorn and Don Muang in Thailand.',
    tags: 'IN, DT, NN, NNP, NNS, VBD, VBN, IN, IN, NNP, NNP, NNP, NNP, NNP, CC, NNP, NNP, IN, NNP, CC, NNP, CC, NNP, NNP, IN, NNP',
  },
  {
    text: 'Six weeks of basic training.',
    tags: 'CD, NNS, IN, JJ, NN',
  },
  {
    text: 'Two years.',
    tags: 'CD, NNS',
  },
  {
    text: 'Did you know that?',
    tags: 'VBD, PRP, VB, DT',
  },
  {
    text: 'That’s fine.',
    tags: 'DT, VBZ, JJ',
  },
  {
    text: 'Many voting centres have already been successfully attacked or destroyed in many areas.',
    tags: 'JJ, NN, NNS, VBP, RB, VBN, RB, VBN, CC, VBN, IN, JJ, NNS',
  },
  {
    text: 'Fistfights, please.',
    tags: 'NNS, UH',
  },
  {
    text: "Al-Gu'ud had favoured elections and was in good terms with the government.",
    tags: 'NNP, NNP, VBD, VBN, NNS, CC, VBD, IN, JJ, NNS, IN, DT, NN',
  },
  {
    text: 'The revolt took two weeks to be suppressed by the Republican Guard.',
    tags: 'DT, NN, VBD, CD, NNS, TO, VB, VBN, IN, DT, NNP, NNP',
  },
  {
    text: 'Remember Luis Posada Carriles?',
    tags: 'VB, NNP, NNP, NNP',
  },
  {
    text: '(Ask Terry Nichols about the Philippines.)',
    tags: 'VB, NNP, NNP, IN, DT, NNPS',
  },
  {
    text: 'But will Posada be given up?',
    tags: 'CC, MD, NNP, VB, VBN, RP',
  },
  {
    text: 'You really got me thinking, I enjoy reading this blog.',
    tags: 'PRP, RB, VBD, PRP, VBG, PRP, VBP, VBG, DT, NN',
  },
  {
    text: 'This is a excellent blog.',
    tags: 'DT, VBZ, DT, JJ, NN',
  },
  {
    text: 'Keep it going.',
    tags: 'VB, PRP, VBG',
  },
  {
    text: 'I agree totally!',
    tags: 'PRP, VBP, RB',
  },
  {
    text: 'Ramtanu Maitra',
    tags: 'NNP, NNP',
  },
  {
    text: 'Deteriorating security',
    tags: 'VBG, NN',
  },
  {
    text: 'The presence of the Sea Tigers in the area with guns, cash and drugs makes the situation extremely dangerous.',
    tags: 'DT, NN, IN, DT, NNP, NNPS, IN, DT, NN, IN, NNS, NN, CC, NNS, VBZ, DT, NN, RB, JJ',
  },
  {
    text: 'Intelligence lapses',
    tags: 'NN, NNS',
  },
  {
    text: 'Steady buildup',
    tags: 'JJ, NN',
  },
  {
    text: 'Karzai, Musharraf new regional equations',
    tags: 'NNP, NNP, JJ, JJ, NNS',
  },
  {
    text: 'That too may change.',
    tags: 'DT, RB, MD, VB',
  },
  {
    text: 'Many Taliban living in Afghanistan voted for President Karzai.',
    tags: 'JJ, NNPS, VBG, IN, NNP, VBD, IN, NNP, NNP',
  },
  {
    text: 'For decades.',
    tags: 'IN, NNS',
  },
  {
    text: 'Bush has a sadistic streak.',
    tags: 'NNP, VBZ, DT, JJ, NN',
  },
  {
    text: 'He clearly enjoyed, as governor, watching executions.',
    tags: 'PRP, RB, VBD, IN, NN, VBG, NNS',
  },
  {
    text: 'He would wear khaki trousers and some old jacket.',
    tags: 'PRP, MD, VB, NN, NNS, CC, DT, JJ, NN',
  },
  {
    text: 'But he just melded with everybody.',
    tags: 'CC, PRP, RB, VBD, IN, NN',
  },
  {
    text: 'He dated a beautiful young woman working on the campaign.',
    tags: 'PRP, VBD, DT, JJ, JJ, NN, VBG, IN, DT, NN',
  },
  {
    text: 'Mr. ARCHIBALD: People have different ways of starting the days in any office.',
    tags: 'NNP, NNP, NNS, VBP, JJ, NNS, IN, VBG, DT, NNS, IN, DT, NN',
  },
  {
    text: 'I thought it unusual and, frankly, inappropriate.',
    tags: 'PRP, VBD, PRP, JJ, CC, RB, JJ',
  },
  {
    text: 'And he would always laugh about that."',
    tags: 'CC, PRP, MD, RB, VB, IN, DT',
  },
  {
    text: 'But the four planeloads of arms have vanished.',
    tags: 'CC, DT, CD, NNS, IN, NNS, VBP, VBN',
  },
  {
    text: '...',
    tags: 'NFP',
  },
  {
    text: 'Police and prosecutors have the tools.',
    tags: 'NNS, CC, NNS, VBP, DT, NNS',
  },
  {
    text: 'Some do, individually.',
    tags: 'DT, VBP, RB',
  },
  {
    text: 'But institutionally?',
    tags: 'CC, RB',
  },
  {
    text: 'CRACKDOWN ON POLYGAMY GROUP',
    tags: 'NN, IN, NN, NN',
  },
  {
    text: '...',
    tags: 'NFP',
  },
  {
    text: '...',
    tags: 'NFP',
  },
  {
    text: '...',
    tags: 'NFP',
  },
  {
    text: 'The Raw Story',
    tags: 'DT, NNP, NNP',
  },
  {
    text: 'Also look up the kingston family.',
    tags: 'RB, VB, RP, DT, NNP, NN',
  },
  {
    text: "It's a good thing too.",
    tags: 'PRP, VBZ, DT, JJ, NN, RB',
  },
  {
    text: 'As the leaders like to boast, the Mujahedeen is a family affair.',
    tags: 'IN, DT, NNS, VBP, TO, VB, DT, NNP, VBZ, DT, NN, NN',
  },
  {
    text: 'Umm...',
    tags: 'UH',
  },
  {
    text: 'Bush successfully makes Satan look good in comparison.',
    tags: 'NNP, RB, VBZ, NNP, VB, JJ, IN, NN',
  },
  {
    text: "Okay, it's partly about strippers and dope.",
    tags: 'UH, PRP, VBZ, RB, IN, NNS, CC, NN',
  },
  {
    text: 'Hmmmmmm ....................',
    tags: 'UH',
  },
  {
    text: 'The wikipedia entry for Aerocom is just a stub .. waiting for someone to put some information into it ....',
    tags: 'DT, NNP, NN, IN, NNP, VBZ, RB, DT, NN, VBG, IN, NN, TO, VB, DT, NN, IN, PRP',
  },
  {
    text: "That's it.",
    tags: 'DT, VBZ, PRP',
  },
  {
    text: '- Simone Weil',
    tags: 'NNP, NNP',
  },
  {
    text: 'Michele Tollis',
    tags: 'NNP, NNP',
  },
  {
    text: 'They\'re inseparable," he says.',
    tags: 'PRP, VBP, JJ, PRP, VBZ',
  },
  {
    text: 'They are doing it deliberately.',
    tags: 'PRP, VBP, VBG, PRP, RB',
  },
  {
    text: 'Is the distinction accurate and valid?',
    tags: 'VBZ, DT, NN, JJ, CC, JJ',
  },
  {
    text: 'Does the distinction actually exist?',
    tags: 'VBZ, DT, NN, RB, VB',
  },
  {
    text: 'John Balance from Coil.',
    tags: 'NNP, NNP, IN, NNP',
  },
  {
    text: '5 kg per gun, 200,000 guns means 1000 tonnes, impossible for 4 containers.',
    tags: 'CD, NNS, IN, NN, CD, NNS, VBZ, CD, NNS, JJ, IN, CD, NNS',
  },
  {
    text: 'I was amazed at the spiel they delivered.',
    tags: 'PRP, VBD, VBN, IN, DT, NN, PRP, VBD',
  },
  {
    text: 'It would have been too painful to watch.',
    tags: 'PRP, MD, VB, VBN, RB, JJ, TO, VB',
  },
  {
    text: 'very creepy, very scary',
    tags: 'RB, JJ, RB, JJ',
  },
  {
    text: 'by exmearden',
    tags: 'IN, NNP',
  },
  {
    text: 'Or was it supposed to initially be a process of alchemical appropriation?',
    tags: 'CC, VBD, PRP, VBN, TO, RB, VB, DT, NN, IN, JJ, NN',
  },
  {
    text: 'True believers are dangerous animals.',
    tags: 'JJ, NNS, VBP, JJ, NNS',
  },
  {
    text: 'Peace.',
    tags: 'NN',
  },
  // {
  //   text: "It's a long but very worthwhile read.",
  //   tags: 'PRP, VBZ, DT, JJ, CC, RB, JJ, NN',
  // },
  {
    text: '"A View from the Eye of the Storm"',
    tags: 'DT, NNP, IN, DT, NNP, IN, DT, NNP',
  },
  {
    text: 'The frequent reports from Algeria about the murders of hundreds of civilians in one village or another by other Algerians have nothing to do with Israel.',
    tags: 'DT, JJ, NNS, IN, NNP, IN, DT, NNS, IN, NNS, IN, NNS, IN, CD, NN, CC, DT, IN, JJ, NNPS, VBP, NN, TO, VB, IN, NNP',
  },
  {
    text: 'It is a very potent psychological weapon.',
    tags: 'PRP, VBZ, DT, RB, JJ, JJ, NN',
  },
  {
    text: 'It creates headlines.',
    tags: 'PRP, VBZ, NNS',
  },
  {
    text: 'It is spectacular.',
    tags: 'PRP, VBZ, JJ',
  },
  {
    text: 'And it is a war!',
    tags: 'CC, PRP, VBZ, DT, NN',
  },
  {
    text: 'It has nothing to do with true fanatic religious beliefs.',
    tags: 'PRP, VBZ, NN, TO, VB, IN, JJ, JJ, JJ, NNS',
  },
  {
    text: 'There are numerous desperate people in the world, in different cultures, countries and continents.',
    tags: 'EX, VBP, JJ, JJ, NNS, IN, DT, NN, IN, JJ, NNS, NNS, CC, NNS',
  },
  {
    text: 'Russia is beginning to understand it.',
    tags: 'NNP, VBZ, VBG, TO, VB, PRP',
  },
  {
    text: 'Words can be lethal.',
    tags: 'NNS, MD, VB, JJ',
  },
  {
    text: 'They kill people.',
    tags: 'PRP, VBP, NNS',
  },
  {
    text: 'They provide an emotional infrastructure for atrocities.',
    tags: 'PRP, VBP, DT, JJ, NN, IN, NNS',
  },
  {
    text: 'Some parts of this same outer circle actually operate as a result of fear from, or blackmail by, the inner circles.',
    tags: 'DT, NNS, IN, DT, JJ, JJ, NN, RB, VBP, IN, DT, NN, IN, NN, IN, CC, NN, IN, DT, JJ, NNS',
  },
  {
    text: 'Should there be death penalty, for deliberate multiple murders?',
    tags: 'MD, EX, VB, NN, NN, IN, JJ, JJ, NNS',
  },
  {
    text: 'These are the old-fashioned dilemmas.',
    tags: 'DT, VBP, DT, JJ, JJ, NNS',
  },
  {
    text: 'It is trying to play ice hockey by sending a ballerina ice-skater into the ring or to knock out a heavyweight boxer by a chess player.',
    tags: 'PRP, VBZ, VBG, TO, VB, NN, NN, IN, VBG, DT, NN, NN, NN, IN, DT, NN, CC, TO, VB, RP, DT, NN, NN, IN, DT, NN, NN',
  },
  {
    text: 'In the short run, only fight and win.',
    tags: 'IN, DT, JJ, NN, RB, VB, CC, VB',
  },
  {
    text: 'Syria is surrounded by Turkey, Iraq, Jordan and Israel.',
    tags: 'NNP, VBZ, VBN, IN, NNP, NNP, NNP, CC, NNP',
  },
  {
    text: 'Zawahiri was associated with a faction of the Egyptian Islamic Jihad known as the Vanguards of Conquest.',
    tags: 'NNP, VBD, VBN, IN, DT, NN, IN, DT, NNP, NNP, NNP, VBN, IN, DT, NNPS, IN, NNP',
  },
  {
    text: 'Al Qaeda, Anthrax and Ayman: Means, Motive, Modus Operandi and Opportunity',
    tags: 'NNP, NNP, NNP, CC, NNP, NNS, NN, NN, NN, CC, NN',
  },
  {
    text: 'Homeland Security',
    tags: 'NN, NN',
  },
  {
    text: 'He had been captured the previous month in Rawalpindi, Pakistan.',
    tags: 'PRP, VBD, VBN, VBN, DT, JJ, NN, IN, NNP, NNP',
  },
  // {
  //   text: 'Photographs from a computer disc included the controls and the locks on the door between the passengers and pilot.',
  //   tags: 'NNS, IN, DT, NN, NN, VBD, DT, NNS, CC, DT, NNS, IN, DT, NN, IN, DT, NNS, CC, NN',
  // },
  {
    text: 'This is old news.',
    tags: 'DT, VBZ, JJ, NN',
  },
  {
    text: 'In the case of the anthrax used in the mailings, there was an electrostatic charge.',
    tags: 'IN, DT, NN, IN, DT, NN, VBN, IN, DT, NNS, EX, VBD, DT, JJ, NN',
  },
  {
    text: 'Understandably, Amerithrax is a confidential investigation.',
    tags: 'RB, NNP, VBZ, DT, JJ, NN',
  },
  {
    text: 'They would know.',
    tags: 'PRP, MD, VB',
  },
  {
    text: 'He reportedly treated them like sons.',
    tags: 'PRP, RB, VBD, PRP, IN, NNS',
  },
  {
    text: 'Philippines',
    tags: 'NNPS',
  },
  {
    text: 'Brazil we have current data already',
    tags: 'NNP, PRP, VBP, JJ, NN, RB',
  },
  {
    text: 'China we have current data already',
    tags: 'NNP, PRP, VBP, JJ, NN, RB',
  },
  {
    text: 'Vince Kaminski',
    tags: 'NNP, NNP',
  },
  {
    text: 'Dear Vince',
    tags: 'JJ, NNP',
  },
  {
    text: 'Kind regards.',
    tags: 'JJ, NNS',
  },
  {
    text: 'Will you drive on that day?',
    tags: 'MD, PRP, VB, IN, DT, NN',
  },
  {
    text: 'Anne, Mike will call you regarding Sarah.',
    tags: 'NNP, NNP, MD, VB, PRP, VBG, NNP',
  },
  {
    text: 'Please advise.',
    tags: 'UH, VB',
  },
  {
    text: 'Good news.',
    tags: 'JJ, NN',
  },
  {
    text: 'This was (another) nice deal for Enron.',
    tags: 'DT, VBD, DT, JJ, NN, IN, NNP',
  },
  {
    text: "I'm happy about this.",
    tags: 'PRP, VBP, JJ, IN, DT',
  },
  {
    text: 'Appreciate the idea.',
    tags: 'VBP, DT, NN',
  },
  {
    text: 'oh god is there an agenda.',
    tags: 'UH, NNP, VBZ, EX, DT, NN',
  },
  {
    text: 'Would dinner Thursday work instead.',
    tags: 'MD, NN, NNP, VB, RB',
  },
  {
    text: 'oh god is there an agenda.',
    tags: 'UH, NNP, VBZ, EX, DT, NN',
  },
  {
    text: 'i completely agree.',
    tags: 'PRP, RB, VBP',
  },
  {
    text: 'i completely agree.',
    tags: 'PRP, RB, VBP',
  },
  {
    text: 'This is pretty easy math for me.',
    tags: 'DT, VBZ, RB, JJ, NN, IN, PRP',
  },
  {
    text: 'I am reviewing the request for an employment agreement renewal on Mark Dean Laurent.',
    tags: 'PRP, VBP, VBG, DT, NN, IN, DT, NN, NN, NN, IN, NNP, NNP, NNP',
  },
  {
    text: 'Job Group: Specialist',
    tags: 'NN, NN, NN',
  },
  {
    text: '1 Year Agreement',
    tags: 'CD, NN, NN',
  },
  {
    text: '1 Year agreement',
    tags: 'CD, NN, NN',
  },
  {
    text: 'Are we going to attend?',
    tags: 'VBP, PRP, VBG, TO, VB',
  },
  {
    text: 'Sonya City',
    tags: 'NNP, NNP',
  },
  {
    text: 'Please let me know Monday morning.',
    tags: 'UH, VB, PRP, VB, NNP, NN',
  },
  {
    text: '18T-EI Indonesia Operations LLC',
    tags: 'NNP, NNP, NNPS, NNP',
  },
  {
    text: 'Despite the name, this entity appears to be a MTM company.',
    tags: 'IN, DT, NN, DT, NN, VBZ, TO, VB, DT, NNP, NN',
  },
  {
    text: '80Y-Enron Broadband Acquisition, Inc.',
    tags: 'NNP, NNP, NNP, NNP',
  },
  {
    text: 'It should be 4 - easy.',
    tags: 'PRP, MD, VB, CD, JJ',
  },
  {
    text: 'Set up last month to centralize merchant asset activities.',
    tags: 'VBN, RP, JJ, NN, TO, VB, NN, NN, NNS',
  },
  {
    text: 'Broke out the activities of 1179.',
    tags: 'VBD, RP, DT, NNS, IN, CD',
  },
  {
    text: 'Set up last month to centralize merchant asset activities.',
    tags: 'VBN, RP, JJ, NN, TO, VB, NN, NN, NNS',
  },
  {
    text: 'Broke out the activities of 1307.',
    tags: 'VBD, RP, DT, NNS, IN, CD',
  },
  {
    text: 'Same as 1307.',
    tags: 'JJ, IN, CD',
  },
  {
    text: 'Please let me know Monday morning.',
    tags: 'UH, VB, PRP, VB, NNP, NN',
  },
  {
    text: 'Hello.',
    tags: 'UH',
  },
  {
    text: 'I found them and purchased both from a gallery in London, William Weston.',
    tags: 'PRP, VBD, PRP, CC, VBD, DT, IN, DT, NN, IN, NNP, NNP, NNP',
  },
  {
    text: 'They should be delivered this week.',
    tags: 'PRP, MD, VB, VBN, DT, NN',
  },
  {
    text: 'I have also purchased an Appel in the last month.',
    tags: 'PRP, VBP, RB, VBN, DT, NNP, IN, DT, JJ, NN',
  },
  {
    text: 'Is there 1 available?',
    tags: 'VBZ, EX, CD, JJ',
  },
  {
    text: 'Mark, I thought you would enjoy the comment about you.',
    tags: 'NNP, PRP, VBD, PRP, MD, VB, DT, NN, IN, PRP',
  },
  {
    text: 'We stayed at the Menger and had a great time.',
    tags: 'PRP, VBD, IN, DT, NNP, CC, VBD, DT, JJ, NN',
  },
  {
    text: "I'm watching for some good vacation days, also ...",
    tags: 'PRP, VBP, VBG, IN, DT, JJ, NN, NNS, RB',
  },
  {
    text: 'I see we expect to have separate contracts for each project.',
    tags: 'PRP, VBP, PRP, VBP, TO, VB, JJ, NNS, IN, DT, NN',
  },
  {
    text: 'I would actually send them the draft Development Agreement a couple days after the LOI.',
    tags: 'PRP, MD, RB, VB, PRP, DT, NN, NN, NN, DT, NN, NNS, IN, DT, NN',
  },
  {
    text: 'Remarkably clear explanation.',
    tags: 'RB, JJ, NN',
  },

  {
    text: 'That is some good stuff.',
    tags: 'DT, VBZ, DT, JJ, NN',
  },
  {
    text: 'Just a reminder to send me a currency report.',
    tags: 'RB, DT, NN, TO, VB, PRP, DT, NN, NN',
  },
  {
    text: 'He will be in Calgary in a couple of weeks and will interview you then.',
    tags: 'PRP, MD, VB, IN, NNP, IN, DT, NN, IN, NNS, CC, MD, VB, PRP, RB',
  },

  {
    text: 'Give him a call tommorow.',
    tags: 'VB, PRP, DT, NN, NN',
  },

  {
    text: 'The deed is done.',
    tags: 'DT, NN, VBZ, JJ',
  },

  {
    text: 'Sushi tonight?',
    tags: 'NN, NN',
  },

  {
    text: 'I will be able to attend.',
    tags: 'PRP, MD, VB, JJ, TO, VB',
  },

  {
    text: 'Mike Jordan',
    tags: 'NNP, NNP',
  },
  {
    text: 'Late Jan sounds great.',
    tags: 'JJ, NNP, VBZ, JJ',
  },
  {
    text: 'Does that work for you?',
    tags: 'VBZ, DT, VB, IN, PRP',
  },
  {
    text: 'And do you want to do it on a Saturday or Sunday?',
    tags: 'CC, VBP, PRP, VB, TO, VB, PRP, IN, DT, NNP, CC, NNP',
  },
  {
    text: 'Hi ...',
    tags: 'UH',
  },
  {
    text: 'She said a shower would be grand.',
    tags: 'PRP, VBD, DT, NN, MD, VB, JJ',
  },
  {
    text: 'Am I turning into Mother?',
    tags: 'VBP, PRP, VBG, IN, NN',
  },
  {
    text: 'Jeff Dasovich',
    tags: 'NNP, NNP',
  },
  {
    text: 'Sent by: Jeff Dasovich',
    tags: 'VBN, IN, NNP, NNP',
  },
  {
    text: 'Jeff Dasovich',
    tags: 'NNP, NNP',
  },
  {
    text: 'Sent by: Jeff Dasovich',
    tags: 'VBN, IN, NNP, NNP',
  },
  {
    text: 'Steven J Kean',
    tags: 'NNP, NNP, NNP',
  },
  {
    text: 'Courtney Votaw',
    tags: 'NNP, NNP',
  },
  {
    text: 'Mark and Steve -',
    tags: 'NNP, CC, NNP',
  },
  {
    text: 'As you can see from the Design Document, they are pretty significant.',
    tags: 'IN, PRP, MD, VB, IN, DT, NN, NN, PRP, VBP, RB, JJ',
  },
  {
    text: 'calendar',
    tags: 'NN',
  },
  {
    text: 'Pin #: 411507',
    tags: 'NN, NN, CD',
  },
  {
    text: 'Pin # for Paul Kaufman ONLY: 362416',
    tags: 'NN, NN, IN, NNP, NNP, RB, CD',
  },
  {
    text: 'Thank you.',
    tags: 'VBP, PRP',
  },
  {
    text: 'Sorry about the flooding.',
    tags: 'JJ, IN, DT, NN',
  },
  {
    text: 'Have a great day.',
    tags: 'VB, DT, JJ, NN',
  },
  {
    text: 'Sorry about the flooding.',
    tags: 'JJ, IN, DT, NN',
  },
  {
    text: 'Have a great day.',
    tags: 'VB, DT, JJ, NN',
  },
  {
    text: 'Nancy, can you please reconfirm with Mark the price for the gas at Bondad?',
    tags: 'NNP, MD, PRP, UH, VB, IN, NNP, DT, NN, IN, DT, NN, IN, NN',
  },
  {
    text: 'Sorry about the flooding.',
    tags: 'JJ, IN, DT, NN',
  },
  {
    text: 'Have a great day.',
    tags: 'VB, DT, JJ, NN',
  },
  {
    text: 'See attached spreadsheet.',
    tags: 'VB, VBN, NN',
  },
  {
    text: 'cool by me!',
    tags: 'JJ, IN, PRP',
  },
  {
    text: 'Did she make it?',
    tags: 'VBD, PRP, VB, PRP',
  },
  {
    text: "And I bet she's on the phone with Shemin too !!!",
    tags: 'CC, PRP, VBP, PRP, VBZ, IN, DT, NN, IN, NNP, RB',
  },
  {
    text: 'Steve, everything looks good with one exception.',
    tags: 'NNP, NN, VBZ, JJ, IN, CD, NN',
  },
  {
    text: 'A heartwarming story of the advances of women in achieving equality throughout the world.',
    tags: 'DT, JJ, NN, IN, DT, NNS, IN, NNS, IN, VBG, NN, IN, DT, NN',
  },
  {
    text: 'Maybe we can go drinking too.',
    tags: 'RB, PRP, MD, VB, VBG, RB',
  },
  {
    text: 'That would be fun.',
    tags: 'DT, MD, VB, JJ',
  },
  {
    text: 'I CAN HANDLE THE TRACTOR.',
    tags: 'PRP, MD, VB, DT, NN',
  },
  {
    text: 'Funny.',
    tags: 'JJ',
  },
  {
    text: 'Vince Kaminski',
    tags: 'NNP, NNP',
  },
  {
    text: 'The eThink Team',
    tags: 'DT, NNP, NN',
  },
  {
    text: 'The response was tremendous and, in some cases, very creative.',
    tags: 'DT, NN, VBD, JJ, CC, IN, DT, NNS, RB, JJ',
  },
  {
    text: 'Confirmed.',
    tags: 'VBN',
  },
  {
    text: 'That would be particularly convenient for me.',
    tags: 'DT, MD, VB, RB, JJ, IN, PRP',
  },
  {
    text: 'Dale Nesbitt',
    tags: 'NNP, NNP',
  },
  {
    text: 'Vince sold!',
    tags: 'NNP, VBD',
  },
  {
    text: "I'll initiate the call.",
    tags: 'PRP, MD, VB, DT, NN',
  },
  {
    text: 'Thursday works for me.',
    tags: 'NNP, VBZ, IN, PRP',
  },
  {
    text: 'A correction.',
    tags: 'DT, NN',
  },
  {
    text: 'Can we do on another day',
    tags: 'MD, PRP, VB, IN, DT, NN',
  },
  {
    text: 'Talk about a shotgun marriage!',
    tags: 'VB, IN, DT, NN, NN',
  },
  {
    text: 'I shall be available on both days.',
    tags: 'PRP, MD, VB, JJ, IN, DT, NNS',
  },
  {
    text: 'It will be nice to see you again.',
    tags: 'PRP, MD, VB, JJ, TO, VB, PRP, RB',
  },
  {
    text: 'Sara Shackleton',
    tags: 'NNP, NNP',
  },
  {
    text: 'Susan Bailey',
    tags: 'NNP, NNP',
  },
  {
    text: 'Susan S. Bailey',
    tags: 'NNP, NNP, NNP',
  },
  {
    text: 'Sara Shackleton',
    tags: 'NNP, NNP',
  },
  {
    text: 'Please advise.',
    tags: 'UH, VB',
  },
  {
    text: 'Sara Shackleton',
    tags: 'NNP, NNP',
  },
  {
    text: 'Sara Shackleton',
    tags: 'NNP, NNP',
  },
  {
    text: 'Sara Shackleton',
    tags: 'NNP, NNP',
  },
  {
    text: 'Sara Shackleton',
    tags: 'NNP, NNP',
  },
  {
    text: 'Sara Shackleton',
    tags: 'NNP, NNP',
  },
  {
    text: 'They showed some kids on TV, and they were quite taken with it.',
    tags: 'PRP, VBD, DT, NNS, IN, NN, CC, PRP, VBD, RB, VBN, IN, PRP',
  },
  {
    text: 'Thank You',
    tags: 'VBP, PRP',
  },
  {
    text: 'Kay Mann',
    tags: 'NNP, NNP',
  },
  {
    text: 'Is that ok with you?',
    tags: 'VBZ, DT, JJ, IN, PRP',
  },
  {
    text: 'the passcode: 6871082#',
    tags: 'DT, NN, CD',
  },
  {
    text: 'the subject: Turbine 1 and Turbine 2 Purchase Agreement',
    tags: 'DT, NN, NN, CD, CC, NN, CD, NN, NN',
  },
  {
    text: 'Lorie Leigh',
    tags: 'NNP, NNP',
  },
  {
    text: 'Kay Mann',
    tags: 'NNP, NNP',
  },
  {
    text: 'Kay Mann',
    tags: 'NNP, NNP',
  },
  {
    text: '- redvepco.doc',
    tags: 'NN',
  },
  {
    text: '- SAMPLE.DOC',
    tags: 'NN',
  },
  {
    text: 'the passcode: 6871082#',
    tags: 'DT, NN, CD',
  },
  {
    text: 'the subject: Turbine 1 and Turbine 2 Purchase Agreement',
    tags: 'DT, NN, NN, CD, CC, NN, CD, NN, NN',
  },
  {
    text: 'Lorie Leigh 46093',
    tags: 'NNP, NNP, CD',
  },
  {
    text: 'Kay Mann',
    tags: 'NNP, NNP',
  },
  {
    text: 'These are always difficult times.',
    tags: 'DT, VBP, RB, JJ, NNS',
  },
  {
    text: 'He is joining an excellent company.',
    tags: 'PRP, VBZ, VBG, DT, JJ, NN',
  },
  {
    text: 'I hope you have a great summer.',
    tags: 'PRP, VBP, PRP, VBP, DT, JJ, NN',
  },
  {
    text: 'Hi -',
    tags: 'UH',
  },
  {
    text: 'Jeff Garten',
    tags: 'NNP, NNP',
  },
  {
    text: 'Good morning, Kitty -',
    tags: 'JJ, NN, NNP',
  },
  {
    text: 'Rosalee Fleming',
    tags: 'NNP, NNP',
  },
  {
    text: 'June 14 Reception',
    tags: 'NNP, CD, NN',
  },
  {
    text: 'Kent Grusendorf',
    tags: 'NNP, NNP',
  },
  {
    text: 'Thank you.',
    tags: 'VBP, PRP',
  },
  {
    text: 'Hi Mr. Katsof -',
    tags: 'UH, NNP, NNP',
  },
  {
    text: 'Sorry.',
    tags: 'JJ',
  },
  {
    text: 'It is very clean and is Sandalwood, Driftwood or something of that nature in color.',
    tags: 'PRP, VBZ, RB, JJ, CC, VBZ, NN, NN, CC, NN, IN, DT, NN, IN, NN',
  },
  {
    text: 'Just jealous.',
    tags: 'RB, JJ',
  },
  {
    text: 'I think she just wants to be able to touch football players legs.',
    tags: 'PRP, VBP, PRP, RB, VBZ, TO, VB, JJ, TO, VB, NN, NNS, NNS',
  },
  {
    text: 'Bro',
    tags: 'NN',
  },
  {
    text: 'W. Don Germany, Jr. 2301 N Brazosport Blvd B 3611, Investment Recovery Freeport, Texas 77541 Pager 1 800 451 0491 (0448) Office 979 238 2102 Home 979 548 7034',
    tags: 'NNP, NNP, NNP, NNP, CD, NNP, NNP, NNP, NNP, CD, NN, NN, NNP, NNP, CD, NN, CD, CD, CD, CD, CD, NN, CD, CD, CD, NN, CD, CD, CD',
  },
  {
    text: 'I need 2 things from you.',
    tags: 'PRP, VBP, CD, NNS, IN, PRP',
  },
  {
    text: 'Hey Ernie.',
    tags: 'UH, NNP',
  },
  {
    text: 'Can you help out?',
    tags: 'MD, PRP, VB, RP',
  },
  {
    text: 'Ernie Simien',
    tags: 'NNP, NNP',
  },
  {
    text: 'Sent by: Ernie Simien',
    tags: 'VBN, IN, NNP, NNP',
  },
  {
    text: 'I need prices for May, June, and July.',
    tags: 'PRP, VBP, NNS, IN, NNP, NNP, CC, NNP',
  },
  {
    text: 'Jan 9.95 Feb 6.25 Mar 4.98 April 5.37',
    tags: 'NNP, CD, NNP, CD, NNP, CD, NNP, CD',
  },
  {
    text: 'Please do me a favour and give me the subject price for Jan, Feb, Mar and Apr 2001.',
    tags: 'UH, VB, PRP, DT, NN, CC, VB, PRP, DT, NN, NN, IN, NNP, NNP, NNP, CC, NNP, CD',
  },
  {
    text: 'Gregg Penman',
    tags: 'NNP, NNP',
  },
  {
    text: 'Kay Mann',
    tags: 'NNP, NNP',
  },
  {
    text: 'Hello -',
    tags: 'UH',
  },
  {
    text: 'Gregg Penman',
    tags: 'NNP, NNP',
  },
  {
    text: 'Kay Mann',
    tags: 'NNP, NNP',
  },
  {
    text: 'Kay Mann',
    tags: 'NNP, NNP',
  },
  {
    text: 'Hello -',
    tags: 'UH',
  },
  {
    text: 'Gregg Penman',
    tags: 'NNP, NNP',
  },
  {
    text: 'Does that work?',
    tags: 'VBZ, DT, VB',
  },
  {
    text: 'Are you coming for Xmas?',
    tags: 'VBP, PRP, VBG, IN, NNP',
  },
  {
    text: 'Adnan Patel',
    tags: 'NNP, NNP',
  },
  {
    text: 'Richard Sage',
    tags: 'NNP, NNP',
  },
  {
    text: "Denis O'Connell",
    tags: 'NNP, NNP',
  },
  {
    text: 'Things in Houston are good and definitely warm.',
    tags: 'NNS, IN, NNP, VBP, JJ, CC, RB, JJ',
  },
  {
    text: 'Are you really?',
    tags: 'VBP, PRP, RB',
  },

  {
    text: "She's a very fun girl.",
    tags: 'PRP, VBZ, DT, RB, JJ, NN',
  },
  {
    text: 'Ted Noble',
    tags: 'NNP, NNP',
  },
  {
    text: 'Smart girl.',
    tags: 'JJ, NN',
  },
  {
    text: 'Ted Noble',
    tags: 'NNP, NNP',
  },
  {
    text: '- Mary Little',
    tags: 'NNP, NNP',
  },
  {
    text: 'Bob Bowen',
    tags: 'NNP, NNP',
  },
  {
    text: 'Bobby is one of those with major injuries .?',
    tags: 'NNP, VBZ, CD, IN, DT, IN, JJ, NNS',
  },
  {
    text: 'He is currently in the emergency room at Ben Taub Hospital .?',
    tags: 'PRP, VBZ, RB, IN, DT, NN, NN, IN, NNP, NNP, NNP',
  },

  {
    text: 'Thank you',
    tags: 'VBP, PRP',
  },
  {
    text: 'Leonardo Pacheco',
    tags: 'NNP, NNP',
  },
  {
    text: 'Mark E Haedicke',
    tags: 'NNP, NNP, NNP',
  },
  {
    text: '9 work days',
    tags: 'CD, NN, NNS',
  },
  {
    text: 'Enclosed is a worksheet for Ineos Acrylics.',
    tags: 'VBN, VBZ, DT, NN, IN, NNP, NNPS',
  },
  {
    text: 'Please find attached the Enron Master Agreement.',
    tags: 'UH, VB, VBN, DT, NNP, NN, NN',
  },
  {
    text: 'I have inserted the company details of Uecomm as requested.',
    tags: 'PRP, VBP, VBN, DT, NN, NNS, IN, NNP, IN, VBN',
  },
  {
    text: 'Marie x33907',
    tags: 'NNP, NN',
  },
  {
    text: 'Benjamin James-at 12.45 pm-3 lbs 4 ozs',
    tags: 'NNP, NNP, IN, CD, NN, CD, NNS, CD, NNS',
  },
  {
    text: 'Toby William-12.46 pm-4 lbs',
    tags: 'NNP, NNP, CD, NN, CD, NNS',
  },
  {
    text: 'Hannah May-12.48 pm-3 lbs 15 ozs.',
    tags: 'NNP, NNP, CD, NN, CD, NNS, CD, NNS',
  },
  {
    text: 'OOPS!',
    tags: 'UH',
  },
  {
    text: 'I have attempted to revise them to make them clearer.',
    tags: 'PRP, VBP, VBN, TO, VB, PRP, TO, VB, PRP, JJR',
  },
  {
    text: 'Marie x33907',
    tags: 'NNP, NN',
  },
  {
    text: 'Patty Snyder',
    tags: 'NNP, NNP',
  },
  {
    text: 'Hi Marie',
    tags: 'UH, NNP',
  },
  {
    text: 'Marie x33907',
    tags: 'NNP, NN',
  },
  {
    text: 'The post id I am looking at for Calgary is 11608.',
    tags: 'DT, NN, NN, PRP, VBP, VBG, IN, IN, NNP, VBZ, CD',
  },
  {
    text: 'The post id I am looking at for Calgary is 11608.',
    tags: 'DT, NN, NN, PRP, VBP, VBG, IN, IN, NNP, VBZ, CD',
  },
  {
    text: "I've booked Videoconference Room # 1.",
    tags: 'PRP, VBP, VBN, NN, NN, NN, CD',
  },
  {
    text: 'should be ok',
    tags: 'MD, VB, JJ',
  },
  {
    text: 'NO',
    tags: 'UH',
  },
  {
    text: 'IEP will be hosting a dinner for California Governor Gray Davis on Thursday, December 7, 2000 at the historic Julia Morgan House in Sacramento.',
    tags: 'NNP, MD, VB, VBG, DT, NN, IN, NNP, NNP, NNP, NNP, IN, NNP, NNP, CD, CD, IN, DT, JJ, NNP, NNP, NNP, IN, NNP',
  },
  {
    text: 'We have already received firm commitments from 3 companies.',
    tags: 'PRP, VBP, RB, VBN, JJ, NNS, IN, CD, NNS',
  },
  {
    text: "I'll be in Portland but can call you.",
    tags: 'PRP, MD, VB, IN, NNP, CC, MD, VB, PRP',
  },
  {
    text: 'We await approval on the final tariff language and can then file at the CPUC.',
    tags: 'PRP, VBP, NN, IN, DT, JJ, NN, NN, CC, MD, RB, VB, IN, DT, NNP',
  },
  {
    text: 'Angie Buis',
    tags: 'NNP, NNP',
  },
  {
    text: 'The duration of the call is 3.5 hours.',
    tags: 'DT, NN, IN, DT, NN, VBZ, CD, NNS',
  },
  // {
  //   text: 'You have all devoted considerable time, resources and spirit in the preparation of this document-and it shows .?',
  //   tags: 'PRP, VBP, RB, VBN, JJ, NN, NNS, CC, NN, IN, DT, NN, IN, DT, NN, CC, PRP, VBZ',
  // },
  {
    text: '- ld2d-#69366-1.DOC',
    tags: 'NN',
  },
  {
    text: '- ld2d-#69345-1.DOC',
    tags: 'NN',
  },
  {
    text: '- ld2d-#69397-1.DOC',
    tags: 'NN',
  },
  {
    text: '- ld2d-#69396-1.DOC',
    tags: 'NN',
  },
  {
    text: '- ld2d-#69377-1.XLS',
    tags: 'NN',
  },
  {
    text: '- ld2d-#69381-1.DOC',
    tags: 'NN',
  },
  {
    text: '- ld2d-#69366-1.DOC',
    tags: 'NN',
  },
  {
    text: '- ld2d-#69336-1.XLS',
    tags: 'NN',
  },
  {
    text: '- ld2d-#69334-1.DOC',
    tags: 'NN',
  },
  {
    text: '- ld2d-#69345-1.DOC',
    tags: 'NN',
  },
  {
    text: 'David Forster',
    tags: 'NNP, NNP',
  },
  {
    text: 'Dear Justin',
    tags: 'JJ, NNP',
  },
  {
    text: 'Jonathan Day',
    tags: 'NNP, NNP',
  },
  {
    text: 'Paul Goddard',
    tags: 'NNP, NNP',
  },
  {
    text: 'Can one of you give me a quick call to discuss.',
    tags: 'MD, CD, IN, PRP, VB, PRP, DT, JJ, NN, TO, VB',
  },
  {
    text: "I'm @ X37047.",
    tags: 'PRP, VBP, IN, NN',
  },
  {
    text: 'David Forster',
    tags: 'NNP, NNP',
  },
  {
    text: 'This message is confidential.',
    tags: 'DT, NN, VBZ, JJ',
  },
  {
    text: 'Sent by: Nella Cappelletto',
    tags: 'VBN, IN, NNP, NNP',
  },
  {
    text: 'Molly Harris',
    tags: 'NNP, NNP',
  },
  {
    text: 'Perhaps you can give them a personal invitation ...',
    tags: 'RB, PRP, MD, VB, PRP, DT, JJ, NN',
  },
  {
    text: 'Wow!',
    tags: 'UH',
  },
  {
    text: 'Carol, will you handle this or Mark?',
    tags: 'NNP, MD, PRP, VB, DT, CC, NNP',
  },
  {
    text: 'Tori Kuykendall',
    tags: 'NNP, NNP',
  },
  {
    text: 'hi mark -',
    tags: 'UH, NNP',
  },
  {
    text: '- ETA_revision0307.doc',
    tags: 'NN',
  },
  {
    text: 'Molly Harris',
    tags: 'NNP, NNP',
  },
  {
    text: 'Molly Harris',
    tags: 'NNP, NNP',
  },
  {
    text: 'Yeah!',
    tags: 'UH',
  },
  {
    text: 'Probably ...',
    tags: 'RB',
  },
  {
    text: 'Molly Harris',
    tags: 'NNP, NNP',
  },
  {
    text: 'Mike Jordan',
    tags: 'NNP, NNP',
  },
  {
    text: 'Mike Jordan',
    tags: 'NNP, NNP',
  },
  {
    text: 'Mike Jordan',
    tags: 'NNP, NNP',
  },
  {
    text: 'I intend to provide weekly updates on the status of the above actions during April',
    tags: 'PRP, VBP, TO, VB, JJ, NNS, IN, DT, NN, IN, DT, JJ, NNS, IN, NNP',
  },
  {
    text: 'Ben Rogers',
    tags: 'NNP, NNP',
  },
  {
    text: 'Ben Rogers',
    tags: 'NNP, NNP',
  },
  // {
  //   text: 'It has been a pleasure to meet with you and I hope we can continue to talk about energy and finance in the future.',
  //   tags: 'PRP, VBZ, VBN, DT, NN, TO, VB, IN, PRP, CC, PRP, VBP, PRP, MD, VB, TO, VB, IN, NN, CC, NN, IN, DT, NN',
  // },
  {
    text: 'Ben Rogers',
    tags: 'NNP, NNP',
  },
  {
    text: 'Randy, this is the issue I left you the voice mail on.',
    tags: 'NNP, DT, VBZ, DT, NN, PRP, VBD, PRP, DT, NN, NN, IN',
  },
  {
    text: 'James Centilli',
    tags: 'NNP, NNP',
  },
  {
    text: 'Susan Scott',
    tags: 'NNP, NNP',
  },
  {
    text: 'Thank you!',
    tags: 'VBP, PRP',
  },
  {
    text: 'DENISE LAGESSE',
    tags: 'NNP, NNP',
  },
  {
    text: 'Drew Fossum',
    tags: 'NNP, NNP',
  },
  {
    text: 'DENISE LAGESSE',
    tags: 'NNP, NNP',
  },
  {
    text: 'Norma, any thoughts?',
    tags: 'NNP, DT, NNS',
  },
  {
    text: 'DENISE LAGESSE',
    tags: 'NNP, NNP',
  },
  {
    text: 'Please approve the purchase of two.',
    tags: 'UH, VB, DT, NN, IN, CD',
  },
  {
    text: 'Drew Fossum',
    tags: 'NNP, NNP',
  },
  {
    text: 'Norma, any thoughts?',
    tags: 'NNP, DT, NNS',
  },
  {
    text: 'DENISE LAGESSE',
    tags: 'NNP, NNP',
  },
  {
    text: 'Please approve the purchase of two.',
    tags: 'UH, VB, DT, NN, IN, CD',
  },
  {
    text: 'Am I scheduled to attend?',
    tags: 'VBP, PRP, VBN, TO, VB',
  },
  {
    text: 'Board members are also invited to join in the substantive session of the DISCO Forum on Thursday, September 13.',
    tags: 'NN, NNS, VBP, RB, VBN, TO, VB, IN, DT, JJ, NN, IN, DT, NNP, NNP, IN, NNP, NNP, CD',
  },
  {
    text: 'correct.',
    tags: 'JJ',
  },
  {
    text: 'We are receiving invoices from Ace Federal Reporters for transcripts of the recent FERC settlement conferences.',
    tags: 'PRP, VBP, VBG, NNS, IN, NNP, NNP, NNPS, IN, NNS, IN, DT, JJ, NNP, NN, NNS',
  },
  {
    text: 'Let me know.',
    tags: 'VB, PRP, VB',
  },
  {
    text: 'Many thanks.',
    tags: 'JJ, NNS',
  },

  {
    text: 'Grand-standing is ignored.',
    tags: 'JJ, NN, VBZ, VBN',
  },
  {
    text: 'Doug and I met with the Chairman of PUCT and have had subsequent conversations.',
    tags: 'NNP, CC, PRP, VBD, IN, DT, NN, IN, NNP, CC, VBP, VBN, JJ, NNS',
  },
  {
    text: 'Thane and I also visited with him.',
    tags: 'NNP, CC, PRP, RB, VBD, IN, PRP',
  },
  {
    text: 'We have been working with the State Affairs legislative committee and keeping them apprised.',
    tags: 'PRP, VBP, VBN, VBG, IN, DT, NN, NNS, JJ, NN, CC, VBG, PRP, VBN',
  },
  {
    text: 'Thane is in Austin on Friday, but is available by phone.',
    tags: 'NNP, VBZ, IN, NNP, IN, NNP, CC, VBZ, JJ, IN, NN',
  },
  {
    text: 'Can we find another time',
    tags: 'MD, PRP, VB, DT, NN',
  },
  {
    text: 'You may want to discuss with Becky.',
    tags: 'PRP, MD, VB, TO, VB, IN, NNP',
  },
  {
    text: 'Many details remain to be worked out, but we will keep you advised.',
    tags: 'JJ, NNS, VBP, TO, VB, VBN, RP, CC, PRP, MD, VB, PRP, VBN',
  },
  {
    text: 'Peter is looking currently for a job.',
    tags: 'NNP, VBZ, VBG, RB, IN, DT, NN',
  },
  {
    text: 'I met him last week at the meeting of the Science and Industry Advance with Mathematics society at the University of Houston.',
    tags: 'PRP, VBD, PRP, JJ, NN, IN, DT, NN, IN, DT, NNP, CC, NNP, NNP, IN, NNPS, NN, IN, DT, NNP, IN, NNP',
  },
  {
    text: 'I shall be glad to make arrangements for an interview.',
    tags: 'PRP, MD, VB, JJ, TO, VB, NNS, IN, DT, NN',
  },
  {
    text: 'Vince Kaminski',
    tags: 'NNP, NNP',
  },
  {
    text: "It's ok with me.",
    tags: 'PRP, VBZ, JJ, IN, PRP',
  },
  {
    text: 'Nasim Khan',
    tags: 'NNP, NNP',
  },
  {
    text: 'Please see the message from Danny Jones.',
    tags: 'UH, VB, DT, NN, IN, NNP, NNP',
  },
  {
    text: 'This is ok by me.',
    tags: 'DT, VBZ, JJ, IN, PRP',
  },
  {
    text: 'Good news.',
    tags: 'JJ, NN',
  },
  {
    text: 'Hello, Bill!',
    tags: 'UH, NNP',
  },
  {
    text: 'Stan will attend in person.',
    tags: 'NNP, MD, VB, IN, NN',
  },
  {
    text: 'By video conference from Jupiter',
    tags: 'IN, NN, NN, IN, NFP',
  },
  {
    text: 'Bill Dorsey.',
    tags: 'NNP, NNP',
  },
  {
    text: 'Thank you for the invitation.',
    tags: 'VBP, PRP, IN, DT, NN',
  },
  {
    text: 'Samuel Schott',
    tags: 'NNP, NNP',
  },
  {
    text: 'Any GCP adjustments will be highlighted in red.',
    tags: 'DT, NN, NNS, MD, VB, VBN, IN, JJ',
  },
  {
    text: "There's a new EOL Counterparty listed in the UK.",
    tags: 'EX, VBZ, DT, JJ, NNP, NN, VBN, IN, DT, NNP',
  },
  {
    text: 'Samuel x3-9890 ENW_GCP',
    tags: 'NNP, NN, NNP',
  },
  {
    text: 'Please see attached.',
    tags: 'UH, VB, VBN',
  },
  {
    text: 'are you the right lawyer to look at this?',
    tags: 'VBP, PRP, DT, JJ, NN, TO, VB, IN, DT',
  },
  {
    text: 'Robert B Cass',
    tags: 'NNP, NNP, NNP',
  },
  {
    text: 'The Transaction is for hot rolled steel with a thickness of 1" and a width of 72 inches.',
    tags: 'DT, NN, VBZ, IN, JJ, VBN, NN, IN, DT, NN, IN, CD, CC, DT, NN, IN, CD, NNS',
  },
  {
    text: 'Each calendar month during the term of the Transaction will be a Dispatch Period.',
    tags: 'DT, NN, NN, IN, DT, NN, IN, DT, NN, MD, VB, DT, NN, NN',
  },
  // {
  //   text: 'select PROGRAMS',
  //   tags: 'VB, NNS',
  // },
  {
    text: 'Bill D Hare',
    tags: 'NNP, NNP, NNP',
  },
  {
    text: 'Tana Jones',
    tags: 'NNP, NNP',
  },
  {
    text: 'Samuel Schott',
    tags: 'NNP, NNP',
  },
  {
    text: 'Samuel Schott',
    tags: 'NNP, NNP',
  },
  {
    text: 'Any GCP adjustments will be highlighted in red.',
    tags: 'DT, NN, NNS, MD, VB, VBN, IN, JJ',
  },
  {
    text: "There's a new EOL Counterparty listed in the UK.",
    tags: 'EX, VBZ, DT, JJ, NNP, NN, VBN, IN, DT, NNP',
  },
  {
    text: 'Samuel x3-9890 ENW_GCP',
    tags: 'NNP, NN, NNP',
  },
  {
    text: 'Please see attached.',
    tags: 'UH, VB, VBN',
  },
  {
    text: "I'll be in town through Sunday morning.",
    tags: 'PRP, MD, VB, IN, NN, IN, NNP, NN',
  },
  {
    text: 'I am in mediation.',
    tags: 'PRP, VBP, IN, NN',
  },
  {
    text: 'I got this.',
    tags: 'PRP, VBD, DT',
  },
  {
    text: '*~*~*~*~*~*~*~*~*~*',
    tags: 'NFP',
  },
  {
    text: 'Passcode: 4153030',
    tags: 'NN, CD',
  },
  {
    text: 'Tobias Munk',
    tags: 'NNP, NNP',
  },
  {
    text: 'Sunjay Arya',
    tags: 'NNP, NNP',
  },
  {
    text: 'Gary Buck',
    tags: 'NNP, NNP',
  },
  {
    text: 'Ryan Seleznov',
    tags: 'NNP, NNP',
  },
  {
    text: 'Mecole Brown',
    tags: 'NNP, NNP',
  },
  {
    text: "Tim O'Rourke",
    tags: 'NNP, NNP',
  },
  {
    text: 'Tana Cashion',
    tags: 'NNP, NNP',
  },
  {
    text: 'Sheila Walton',
    tags: 'NNP, NNP',
  },
  {
    text: 'Wendy Fincher',
    tags: 'NNP, NNP',
  },
  {
    text: 'Sheila Knudsen',
    tags: 'NNP, NNP',
  },
  {
    text: 'Karen Phillips',
    tags: 'NNP, NNP',
  },
  {
    text: 'Neil Davies',
    tags: 'NNP, NNPS',
  },
  {
    text: 'Noel Ryan',
    tags: 'NNP, NNP',
  },
  {
    text: 'Cindy Skinner',
    tags: 'NNP, NNP',
  },
  {
    text: 'Simone Scott Walker',
    tags: 'NNP, NNP, NNP',
  },
  {
    text: 'Shanna Funkhouser',
    tags: 'NNP, NNP',
  },
  {
    text: 'Shanna, I spoke with Per tonight about this.',
    tags: 'NNP, PRP, VBD, IN, NNP, NN, IN, DT',
  },
  {
    text: 'Thank you',
    tags: 'VBP, PRP',
  },
  {
    text: 'Try this.',
    tags: 'VB, DT',
  },
  {
    text: 'bob k',
    tags: 'NNP, NNP',
  },
  {
    text: 'Two in one day.',
    tags: 'CD, IN, CD, NN',
  },
  {
    text: 'Could',
    tags: 'MD',
  },
  {
    text: 'please try to verify.',
    tags: 'UH, VB, TO, VB',
  },
  {
    text: 'Sara Shackleton',
    tags: 'NNP, NNP',
  },
  {
    text: 'Please advise.',
    tags: 'UH, VB',
  },
  {
    text: 'Thank you.',
    tags: 'VBP, PRP',
  },
  {
    text: 'The call was cancelled.',
    tags: 'DT, NN, VBD, VBN',
  },
  {
    text: 'I am waiting to hear about a possible call Friday morning.',
    tags: 'PRP, VBP, VBG, TO, VB, IN, DT, JJ, NN, NNP, NN',
  },
  {
    text: 'The draft you received has been approved by Dan.',
    tags: 'DT, NN, PRP, VBD, VBZ, VBN, VBN, IN, NNP',
  },
  {
    text: 'Looks good.',
    tags: 'VBZ, JJ',
  },
  {
    text: 'Please advise.',
    tags: 'UH, VB',
  },
  {
    text: 'I will initiate the call.',
    tags: 'PRP, MD, VB, DT, NN',
  },
  {
    text: 'I am checking on London.',
    tags: 'PRP, VBP, VBG, IN, NNP',
  },
  {
    text: 'Janice Moore',
    tags: 'NNP, NNP',
  },
  {
    text: 'Becky will bring you the hard copy version.',
    tags: 'NNP, MD, VB, PRP, DT, JJ, NN, NN',
  },
  {
    text: "I'll call you shortly.",
    tags: 'PRP, MD, VB, PRP, RB',
  },
  {
    text: 'St. Petersburg?',
    tags: 'NNP, NNP',
  },
  {
    text: 'Amelia Island Plantation?',
    tags: 'NNP, NNP, NNP',
  },
  {
    text: "I've simply lost track!",
    tags: 'PRP, VBP, RB, VBN, NN',
  },
  {
    text: 'Are you selling burgers up and down the east coast?',
    tags: 'VBP, PRP, VBG, NNS, IN, CC, IN, DT, JJ, NN',
  },
  {
    text: 'In a new franchise business?',
    tags: 'IN, DT, JJ, NN, NN',
  },
  {
    text: 'Robert Quick',
    tags: 'NNP, NNP',
  },
  {
    text: 'tks',
    tags: 'NN',
  },
  {
    text: 'Sara Shackleton',
    tags: 'NNP, NNP',
  },
  {
    text: 'I will be in Sao Paulo on Monday, September 20, 1999.',
    tags: 'PRP, MD, VB, IN, NNP, NNP, IN, NNP, NNP, CD, CD',
  },
  {
    text: 'Thank you.',
    tags: 'VBP, PRP',
  },
  {
    text: 'Jeffrey Dasovich Director, Enron Corp',
    tags: 'NNP, NNP, NN, NNP, NNP',
  },
  {
    text: 'Code is 80435.',
    tags: 'NN, VBZ, CD',
  },
  {
    text: 'Jeff Dasovich',
    tags: 'NNP, NNP',
  },
  {
    text: 'Sent by: Jeff Dasovich',
    tags: 'VBN, IN, NNP, NNP',
  },
  {
    text: 'Code is 80435.',
    tags: 'NN, VBZ, CD',
  },
  {
    text: 'Nice job.',
    tags: 'JJ, NN',
  },
  {
    text: 'Going to be a wild ride.',
    tags: 'VBG, TO, VB, DT, JJ, NN',
  },
  {
    text: "That's a very good point.",
    tags: 'DT, VBZ, DT, RB, JJ, NN',
  },
  {
    text: "I'll make the change.",
    tags: 'PRP, MD, VB, DT, NN',
  },
  {
    text: 'Harry Kingerski',
    tags: 'NNP, NNP',
  },
  {
    text: "You're right, Sue.",
    tags: 'PRP, VBP, JJ, NNP',
  },
  {
    text: 'Shawna Johnson Recruiting Coordinator',
    tags: 'NNP, NNP, NN, NN',
  },
  {
    text: 'have you gotten a price?',
    tags: 'VBP, PRP, VBN, DT, NN',
  },
  {
    text: 'Doug Leach',
    tags: 'NNP, NNP',
  },
  {
    text: 'please print',
    tags: 'UH, VB',
  },
  {
    text: 'David Hoog',
    tags: 'NNP, NNP',
  },
  {
    text: 'please print',
    tags: 'UH, VB',
  },
  {
    text: 'I highlight the relevant skills in the summary.',
    tags: 'PRP, VBD, DT, JJ, NNS, IN, DT, NN',
  },
  {
    text: '- ENRONR~1.DOC',
    tags: 'NN',
  },
  {
    text: 'I stayed for the remainder of the lecture.',
    tags: 'PRP, VBD, IN, DT, NN, IN, DT, NN',
  },
  {
    text: 'Jana Giovannini',
    tags: 'NNP, NNP',
  },
  {
    text: 'Actually, Jen has volunteered for the afternoon session.',
    tags: 'RB, NNP, VBZ, VBN, IN, DT, NN, NN',
  },
  {
    text: 'Please let me know.',
    tags: 'UH, VB, PRP, VB',
  },
  {
    text: 'Jana Giovannini',
    tags: 'NNP, NNP',
  },
  {
    text: 'Great job, guys.',
    tags: 'JJ, NN, NNS',
  },
  {
    text: 'Eric Gonzales',
    tags: 'NNP, NNP',
  },
  {
    text: 'Great job gentlemen!',
    tags: 'JJ, NN, NNS',
  },
  {
    text: 'Finally completed tonight',
    tags: 'RB, VBN, NN',
  },
  {
    text: 'I would add setoff language.',
    tags: 'PRP, MD, VB, NN, NN',
  },
  {
    text: 'Carol St Clair',
    tags: 'NNP, NNP, NNP',
  },
  {
    text: 'Are you okay with that?',
    tags: 'VBP, PRP, JJ, IN, DT',
  },
  {
    text: 'Rhonda L Denton',
    tags: 'NNP, NNP, NNP',
  },
  {
    text: 'Rhonda L Denton',
    tags: 'NNP, NNP, NNP',
  },
  {
    text: 'Just let me know and I can send you a new attachment.',
    tags: 'RB, VB, PRP, VB, CC, PRP, MD, VB, PRP, DT, JJ, NN',
  },
  {
    text: 'Phyllis Lemell',
    tags: 'NNP, NNP',
  },
  {
    text: 'Rhonda L Denton',
    tags: 'NNP, NNP, NNP',
  },
  {
    text: 'Will fax.',
    tags: 'MD, VB',
  },
  {
    text: 'Rhonda L Denton',
    tags: 'NNP, NNP, NNP',
  },
  {
    text: 'Will fax.',
    tags: 'MD, VB',
  },
  {
    text: 'Rhonda L Denton',
    tags: 'NNP, NNP, NNP',
  },
  {
    text: 'Will fax.',
    tags: 'MD, VB',
  },
  {
    text: 'Are we ready to execute?',
    tags: 'VBP, PRP, JJ, TO, VB',
  },
  {
    text: 'Please call me.',
    tags: 'UH, VB, PRP',
  },
  {
    text: 'Were there any?',
    tags: 'VBD, EX, DT',
  },
  {
    text: 'Robert Guthrie with the tax department has worked with us to develop this language.',
    tags: 'NNP, NNP, IN, DT, NN, NN, VBZ, VBN, IN, PRP, TO, VB, DT, NN',
  },
  {
    text: 'We hope to execute this Agreement this week.',
    tags: 'PRP, VBP, TO, VB, DT, NN, DT, NN',
  },
  {
    text: 'It is a fairly standard, fully reimbursable connection with Questar.',
    tags: 'PRP, VBZ, DT, RB, JJ, RB, JJ, NN, IN, NNP',
  },
  {
    text: 'Robert Guthrie with the tax department has worked with us to develop this language.',
    tags: 'NNP, NNP, IN, DT, NN, NN, VBZ, VBN, IN, PRP, TO, VB, DT, NN',
  },
  {
    text: 'We hope to execute this Agreement this week.',
    tags: 'PRP, VBP, TO, VB, DT, NN, DT, NN',
  },
  {
    text: 'Can you and Tom join us?',
    tags: 'MD, PRP, CC, NNP, VB, PRP',
  },
  {
    text: 'John, sorry for the late response, but I think you can implement immediately.',
    tags: 'NNP, JJ, IN, DT, JJ, NN, CC, PRP, VBP, PRP, MD, VB, RB',
  },
  {
    text: 'I was aware.',
    tags: 'PRP, VBD, JJ',
  },
  {
    text: 'John Buchanan',
    tags: 'NNP, NNP',
  },
  {
    text: 'John, sorry for the late response, but I think you can implement immediately.',
    tags: 'NNP, JJ, IN, DT, JJ, NN, CC, PRP, VBP, PRP, MD, VB, RB',
  },
  {
    text: 'Are you comfortable with the difference?',
    tags: 'VBP, PRP, JJ, IN, DT, NN',
  },
  {
    text: 'Any thoughts?',
    tags: 'DT, NNS',
  },
  {
    text: 'See you Sunday.',
    tags: 'VBP, PRP, NNP',
  },
  {
    text: 'These are the vendors of instrumentation required for the interconnect.',
    tags: 'DT, VBP, DT, NNS, IN, NN, VBN, IN, DT, NN',
  },
  {
    text: 'Great.',
    tags: 'JJ',
  },
  {
    text: "I'll get you the announcement.",
    tags: 'PRP, MD, VB, PRP, DT, NN',
  },
  {
    text: 'September 26, 2001',
    tags: 'NNP, CD, CD',
  },
  {
    text: 'By KIMBERLY KINDY',
    tags: 'IN, NNP, NNP',
  },
  {
    text: 'The Orange County Register',
    tags: 'DT, NNP, NNP, NNP',
  },
  {
    text: 'Smutney-Jones also said he was unaware of anyone in the power-generating community',
    tags: 'NNP, NNP, RB, VBD, PRP, VBD, JJ, IN, NN, IN, DT, NN, NN, NN',
  },
  {
    text: 'James J. Hoecker, the former Federal Energy Regulatory Commission chairman, defended making the December decision and also defended Winter.',
    tags: 'NNP, NNP, NNP, DT, JJ, NNP, NNP, NNP, NNP, NN, VBD, VBG, DT, NNP, NN, CC, RB, VBD, NNP',
  },
  {
    text: 'Sue and Jeff --',
    tags: 'NNP, CC, NNP',
  },
  {
    text: 'Sounds good.',
    tags: 'VBZ, JJ',
  },
  {
    text: 'Are you playing golf?',
    tags: 'VBP, PRP, VBG, NN',
  },
  {
    text: 'Have they expressed any interest in negotiating?',
    tags: 'VBP, PRP, VBN, DT, NN, IN, VBG',
  },
  {
    text: 'Particularly in the absence of any entreaty from them.',
    tags: 'RB, IN, DT, NN, IN, DT, NN, IN, PRP',
  },
  {
    text: 'none',
    tags: 'NN',
  },
  {
    text: 'HR-Veronica Parra, Nedre Strambler, Fran Mayes, Felicia Solis',
    tags: 'NN, NNP, NNP, NNP, NNP, NNP, NNP, NNP, NNP',
  },
  {
    text: 'Legal-Bob Carter, Travis McCullough, Lisa Mellencamp, Shelia Tweed, Richard Sanders, Michelle Cash',
    tags: 'JJ, NNP, NNP, NNP, NNP, NNP, NNP, NNP, NNP, NNP, NNP, NNP, NNP',
  },
  {
    text: 'IT-Jason Chumley',
    tags: 'NN, NNP, NNP',
  },
  {
    text: 'Insurance-David Marshall',
    tags: 'NN, NNP, NNP',
  },
  {
    text: 'Looks good',
    tags: 'VBZ, JJ',
  },
  {
    text: 'Steve Van Hooser',
    tags: 'NNP, NNP, NNP',
  },
  {
    text: "I've read the materials you sent and agree we need to address these allegations appropriately.",
    tags: 'PRP, VBP, VBN, DT, NNS, PRP, VBD, CC, VBP, PRP, VBP, TO, VB, DT, NNS, RB',
  },
  {
    text: 'This message is confidential.',
    tags: 'DT, NN, VBZ, JJ',
  },
  {
    text: '- C.DTF',
    tags: 'NN',
  },
  {
    text: 'Call me to discuss.',
    tags: 'VB, PRP, TO, VB',
  },
  {
    text: 'Cheryl Marshall',
    tags: 'NNP, NNP',
  },
  {
    text: 'Richard B Sanders',
    tags: 'NNP, NNP, NNP',
  },
  {
    text: 'Call me to discuss.',
    tags: 'VB, PRP, TO, VB',
  },
  {
    text: 'Cheryl Marshall',
    tags: 'NNP, NNP',
  },
  {
    text: 'Has Liz finished with gathering the documents?',
    tags: 'VBZ, NNP, VBN, IN, VBG, DT, NNS',
  },
  {
    text: 'Hi --',
    tags: 'UH',
  },
  {
    text: 'Thank you.',
    tags: 'VBP, PRP',
  },
  {
    text: 'Dear Mr. Sanders -',
    tags: 'JJ, NNP, NNP',
  },
  {
    text: '-> Gerry',
    tags: 'NFP, NNP',
  },
  {
    text: 'the industry of Marriage and Kids, you heard me.',
    tags: 'DT, NN, IN, NN, CC, NNS, PRP, VBD, PRP',
  },
  {
    text: 'And you might think by reading this I blame the kids .....',
    tags: 'CC, PRP, MD, VB, IN, VBG, DT, PRP, VBP, DT, NNS',
  },
  {
    text: 'Probably it is.',
    tags: 'RB, PRP, VBZ',
  },
  {
    text: 'It must be stamped out.',
    tags: 'PRP, MD, VB, VBN, RP',
  },
  {
    text: 'I hope so.',
    tags: 'PRP, VBP, RB',
  },
  {
    text: 'NASA has some PR hurdles to overcome in the future.',
    tags: 'NNP, VBZ, DT, NN, NNS, TO, VB, IN, DT, NN',
  },
  {
    text: 'I see the merit in flowing with duality.',
    tags: 'PRP, VBP, DT, NN, IN, VBG, IN, NN',
  },
  {
    text: 'In the near future collective choices will need to be made.',
    tags: 'IN, DT, JJ, NN, JJ, NNS, MD, VB, TO, VB, VBN',
  },
  {
    text: 'November 2005',
    tags: 'NNP, CD',
  },
  {
    text: 'Sunshine Coast, British Columbia, Canada',
    tags: 'NNP, NNP, NNP, NNP, NNP',
  },
  {
    text: 'Independent wealth?',
    tags: 'JJ, NN',
  },
  {
    text: 'The company has developed an entirely new category of products.',
    tags: 'DT, NN, VBZ, VBN, DT, RB, JJ, NN, IN, NNS',
  },
  {
    text: 'Innovative Products',
    tags: 'JJ, NNS',
  },
  {
    text: 'Agel introduces an entirely new category of products called Gelceuticals.',
    tags: 'NNP, VBZ, DT, RB, JJ, NN, IN, NNS, VBN, NNS',
  },
  {
    text: 'The company has developed a unique and innovative delivery mechanism for nutritional products.',
    tags: 'DT, NN, VBZ, VBN, DT, JJ, CC, JJ, NN, NN, IN, JJ, NNS',
  },
  {
    text: 'This proprietary Gel Suspension technology makes possible single serving packets of Gelceuticals.',
    tags: 'DT, JJ, NN, NN, NN, VBZ, JJ, JJ, NN, NNS, IN, NNS',
  },
  // {
  //   text: 'Perfect for those with difficulty swallowing tablets or capsules',
  //   tags: 'JJ, IN, DT, IN, NN, VBG, NNS, CC, NNS',
  // },
  {
    text: 'Agel has created a new compensation structure.',
    tags: 'NNP, VBZ, VBN, DT, JJ, NN, NN',
  },

  {
    text: 'The Passcode to participate is: 5107',
    tags: 'DT, NN, TO, VB, VBZ, CD',
  },
  {
    text: 'I encourage you to do this dance, as it has tremendous positive effects.',
    tags: 'PRP, VBP, PRP, TO, VB, DT, NN, IN, PRP, VBZ, JJ, JJ, NNS',
  },
  {
    text: 'Kaoshikii is especially good for women.',
    tags: 'NN, VBZ, RB, JJ, IN, NNS',
  },
  {
    text: 'The Benefits',
    tags: 'DT, NNS',
  },
  {
    text: 'Increases longevity.',
    tags: 'VBZ, NN',
  },
  {
    text: 'Makes for easy delivery at childbirth.',
    tags: 'VBZ, IN, JJ, NN, IN, NN',
  },
  {
    text: 'The spine will become flexible.',
    tags: 'DT, NN, MD, VB, JJ',
  },
  {
    text: 'The mind becomes strong and sharp.',
    tags: 'DT, NN, VBZ, JJ, CC, JJ',
  },
  {
    text: 'Irregularities in menstruation will be cured.',
    tags: 'NNS, IN, NN, MD, VB, VBN',
  },
  {
    text: 'Troubles in the bladder and urethra will be cured.',
    tags: 'NNS, IN, DT, NN, CC, NN, MD, VB, VBN',
  },
  {
    text: 'Removes wrinkles.',
    tags: 'VBZ, NNS',
  },
  {
    text: 'Hopelessness will be lost.',
    tags: 'NN, MD, VB, VBN',
  },
  {
    text: 'The Dance',
    tags: 'DT, NN',
  },
  {
    text: 'The Ideation',
    tags: 'DT, NN',
  },
  {
    text: 'Important information of big companies',
    tags: 'JJ, NN, IN, JJ, NNS',
  },
  {
    text: 'Apple Computers',
    tags: 'NNP, NNPS',
  },
  // {
  //   text: 'It was the favorite fruit of founder Steve Jobs.',
  //   tags: 'PRP, VBD, DT, JJ, NN, IN, NN, NNP, NNP',
  // },
  {
    text: 'It is short for San Francisco.',
    tags: 'PRP, VBZ, JJ, IN, NNP, NNP',
  },
  {
    text: 'This name was formed by using COMp, for computer, and PAQ to denote a small integral object.',
    tags: 'DT, NN, VBD, VBN, IN, VBG, NN, IN, NN, CC, NN, TO, VB, DT, JJ, JJ, NN',
  },
  {
    text: 'It stands for COwpland REsearch Laboratory.',
    tags: 'PRP, VBZ, IN, NNP, NNP, NNP',
  },
  {
    text: 'The name started as a joke boasting about the amount of information the search-engine would be able to search.',
    tags: 'DT, NN, VBD, IN, DT, NN, VBG, IN, DT, NN, IN, NN, DT, NN, NN, MD, VB, JJ, TO, VB',
  },
  {
    text: 'Hewlett Packard',
    tags: 'NNP, NNP',
  },

  {
    text: 'The popular radio company at the time was called Victrola.',
    tags: 'DT, JJ, NN, NN, IN, DT, NN, VBD, VBN, NNP',
  },
  {
    text: 'The project was designed to help use the newly written SQL code by IBM.',
    tags: 'DT, NN, VBD, VBN, TO, VB, VB, DT, RB, VBN, NN, NN, IN, NNP',
  },
  {
    text: 'They kept the name Oracle and created the RDBMS engine.',
    tags: 'PRP, VBD, DT, NN, NNP, CC, VBD, DT, NNP, NN',
  },
  {
    text: 'Founded by 4 Stanford University buddies, SUN is the acronym for Stanford University Network.',
    tags: 'VBN, IN, CD, NNP, NNP, NNS, NNP, VBZ, DT, NN, IN, NNP, NNP, NNP',
  },
  {
    text: 'I am on Yahoo!',
    tags: 'PRP, VBP, IN, NNP',
  },
  {
    text: 'Good Day Mate!',
    tags: 'JJ, NN, NN',
  },
  {
    text: 'Feb 2005',
    tags: 'NNP, CD',
  },
  {
    text: 'rumor has feb 05 on the calender.',
    tags: 'NN, VBZ, NNP, CD, IN, DT, NN',
  },
  {
    text: 'The game is already 100 % functional.',
    tags: 'DT, NN, VBZ, RB, CD, NN, JJ',
  },
  {
    text: 'I am Lady Kingel and I hail from the United Legit Gaming Guilds of Guild Wars.',
    tags: 'PRP, VBP, NNP, NNP, CC, PRP, VBP, IN, DT, NNP, NNP, NNP, NNPS, IN, NNP, NNPS',
  },
  {
    text: 'You will be greeted by many members of this wonderful family.',
    tags: 'PRP, MD, VB, VBN, IN, JJ, NNS, IN, DT, JJ, NN',
  },
  {
    text: 'Come and say hello... you will be warmly welcomed!',
    tags: 'VB, CC, VB, UH, PRP, MD, VB, RB, VBN',
  },
  {
    text: 'We are the children of poverty, financial and spiritual.',
    tags: 'PRP, VBP, DT, NNS, IN, NN, JJ, CC, JJ',
  },
  {
    text: 'Please tell me there is a deeper reason.',
    tags: 'UH, VB, PRP, EX, VBZ, DT, JJR, NN',
  },
  {
    text: 'Are you ready?',
    tags: 'VBP, PRP, JJ',
  },
  // {
  //   text: 'Ideas are welcome.',
  //   tags: 'NNS, VBP, JJ',
  // },
  {
    text: 'I am GEORGE WALKER BUSH, son of the former president of the United States of America George Herbert Walker Bush, and currently serving as President of the United States of America.',
    tags: 'PRP, VBP, NNP, NNP, NNP, NN, IN, DT, JJ, NNP, IN, DT, NNP, NNP, NN, NNP, NNP, NNP, NNP, NNP, CC, RB, VBG, IN, NNP, IN, DT, NNP, NNP, NN, NNP',
  },
  {
    text: 'Watch the airlift',
    tags: 'VB, DT, NN',
  },
  {
    text: 'The Superdome stadium is without power, and toilets are overflowing.',
    tags: 'DT, NNP, NN, VBZ, IN, NN, CC, NNS, VBP, VBG',
  },
  {
    text: 'Map of central New Orleans',
    tags: 'NN, IN, JJ, NNP, NNP',
  },
  {
    text: 'Natalie McVeigh Oakley, England',
    tags: 'NNP, NNP, NNP, NNP',
  },
  {
    text: 'Blogging Katrina',
    tags: 'VBG, NNP',
  },
  {
    text: 'Q: NASA IS A WASTE!',
    tags: 'NN, NNP, VBZ, DT, NN',
  },
  {
    text: 'U.S. Senate Committee on Appropriations',
    tags: 'NNP, NNP, NNP, IN, NNPS',
  },
  {
    text: 'September 21, 2004',
    tags: 'NNP, CD, CD',
  },
  {
    text: 'I hope you have found this information helpful.',
    tags: 'PRP, VBP, PRP, VBP, VBN, DT, NN, JJ',
  },
  {
    text: 'nasa funding',
    tags: 'NNP, NN',
  },
  {
    text: 'Excellent answer googlenut.',
    tags: 'JJ, NN, NNP',
  },
  {
    text: 'Let me add some additional info.',
    tags: 'VB, PRP, VB, DT, JJ, NN',
  },
  {
    text: 'Also NASA has a large outreach program for education, some people believe this is important.',
    tags: 'RB, NNP, VBZ, DT, JJ, NN, NN, IN, NN, DT, NNS, VBP, DT, VBZ, JJ',
  },
  {
    text: 'i find that extremely hard to believe.',
    tags: 'PRP, VBP, DT, RB, JJ, TO, VB',
  },
  {
    text: 'Please take a moment to read this.',
    tags: 'UH, VB, DT, NN, TO, VB, DT',
  },
  {
    text: 'I will attach the letter explaining the benefit we are sponsoring.',
    tags: 'PRP, MD, VB, DT, NN, VBG, DT, NN, PRP, VBP, VBG',
  },
  {
    text: 'It is certainly for a good cause.',
    tags: 'PRP, VBZ, RB, IN, DT, JJ, NN',
  },
  {
    text: 'I hope you have a huge network.',
    tags: 'PRP, VBP, PRP, VBP, DT, JJ, NN',
  },
  {
    text: 'Donations can also be made through Charter One Bank.',
    tags: 'NNS, MD, RB, VB, VBN, IN, NNP, NNP, NNP',
  },
  {
    text: 'By Richard Spencer',
    tags: 'IN, NNP, NNP',
  },
  {
    text: 'Imagine the tension melting away as you continue breathing rhythmically and naturally.',
    tags: 'VB, DT, NN, VBG, RB, IN, PRP, VBP, VBG, RB, CC, RB',
  },
  {
    text: 'It surrounds you.',
    tags: 'PRP, VBZ, PRP',
  },
  {
    text: 'Everything around you is so vast.',
    tags: 'NN, IN, PRP, VBZ, RB, JJ',
  },
  {
    text: 'Yet, there is warmth and a familiarity with the vastness.',
    tags: 'CC, EX, VBZ, NN, CC, DT, NN, IN, DT, NN',
  },
  {
    text: 'Imagine yourself sitting on the beach serenely and restfully.',
    tags: 'VB, PRP, VBG, IN, DT, NN, RB, CC, RB',
  },
  {
    text: 'You are in a state of peace and relaxation.',
    tags: 'PRP, VBP, IN, DT, NN, IN, NN, CC, NN',
  },
  {
    text: 'Another thing you can try.',
    tags: 'DT, NN, PRP, MD, VB',
  },
  {
    text: 'This is called ideation.',
    tags: 'DT, VBZ, VBN, NN',
  },
  {
    text: 'The main thing is to keep practicing.',
    tags: 'DT, JJ, NN, VBZ, TO, VB, VBG',
  },
  {
    text: 'NORTH CAROLINA RELIGIOUS COALITION FOR MARRIAGE EQUALITY',
    tags: 'NNP, NNP, JJ, NNP, IN, NNP, NNP',
  },
  {
    text: 'Furthermore, the Vestry voted unanimously to invite the support of members of the CHS congregation for the Declaration.',
    tags: 'RB, DT, NNP, VBD, RB, TO, VB, DT, NN, IN, NNS, IN, DT, NNP, NN, IN, DT, NN',
  },
  {
    text: 'He has a very high intellect.',
    tags: 'PRP, VBZ, DT, RB, JJ, NN',
  },
  {
    text: 'He has encyclopedic knowledge of hundreds of different Supreme Court cases, and he can recite details from memory.',
    tags: 'PRP, VBZ, JJ, NN, IN, NNS, IN, JJ, NNP, NNP, NNS, CC, PRP, MD, VB, NNS, IN, NN',
  },
  {
    text: 'President Bush loves him.',
    tags: 'NNP, NNP, VBZ, PRP',
  },
  {
    text: '###',
    tags: 'NFP',
  },
  {
    text: 'Reply',
    tags: 'VB',
  },
  {
    text: 'By MARK CARREAU',
    tags: 'IN, NNP, NNP',
  },
  {
    text: 'Copyright 2005 Houston Chronicle',
    tags: 'NN, CD, NNP, NNP',
  },
  {
    text: 'I am serious about doing something.',
    tags: 'PRP, VBP, JJ, IN, VBG, NN',
  },
  {
    text: 'I will.',
    tags: 'PRP, MD',
  },
  {
    text: 'These animals have the misfortune to produce a substance that is useful in the manufacture of perfume.',
    tags: 'DT, NNS, VBP, DT, NN, TO, VB, DT, NN, CC, VBZ, JJ, IN, DT, NN, IN, NN',
  },
  {
    text: 'Travis Job',
    tags: 'NNP, NNP',
  },
  {
    text: 'icq uin: 5249025',
    tags: 'NN, NN, CD',
  },
  {
    text: 'Within seven days, I started getting money in the mail !!',
    tags: 'IN, CD, NNS, PRP, VBD, VBG, NN, IN, DT, NN',
  },
  {
    text: "It's easy.",
    tags: 'PRP, VBZ, JJ',
  },
  {
    text: "It's legal.",
    tags: 'PRP, VBZ, JJ',
  },
  {
    text: 'You are requesting a legitimate service and you are paying for it !!',
    tags: 'PRP, VBP, VBG, DT, JJ, NN, CC, PRP, VBP, VBG, IN, PRP',
  },
  {
    text: 'This is perfectly legal !!',
    tags: 'DT, VBZ, RB, JJ',
  },
  // {
  //   text: 'Visit message boards and post this article as a new message by highlighting the text of this letter and selecting paste from the edit menu.',
  //   tags: 'VB, NN, NNS, CC, VB, DT, NN, IN, DT, JJ, NN, IN, VBG, DT, NN, IN, DT, NN, CC, VBG, NN, IN, DT, NN, NN',
  // },
  {
    text: "You're done.",
    tags: 'PRP, VBP, JJ',
  },
  {
    text: "THAT's IT !!",
    tags: 'DT, VBZ, PRP',
  },
  {
    text: 'By Dan Whipple',
    tags: 'IN, NNP, NNP',
  },
  {
    text: 'Boulder, CO, Feb. 23 (UPI) --',
    tags: 'NNP, NNP, NNP, CD, NNP',
  },
  {
    text: 'The last wolf was killed in Yellowstone National Park in 1943.',
    tags: 'DT, JJ, NN, VBD, VBN, IN, NNP, NNP, NNP, IN, CD',
  },
  {
    text: 'This simple change has triggered a veritable ecological cascade in Yellowstone.',
    tags: 'DT, JJ, NN, VBZ, VBN, DT, JJ, JJ, NN, IN, NNP',
  },
  {
    text: 'Yellowstone has a vast elk herd, one of the largest in the world.',
    tags: 'NNP, VBZ, DT, JJ, NN, NN, CD, IN, DT, JJS, IN, DT, NN',
  },
  {
    text: 'On Jan. 31, Oregon Federal District Court Judge Robert E. Jones appeared to agree with them.',
    tags: 'IN, NNP, CD, NNP, NNP, NNP, NNP, NNP, NNP, NNP, NNP, VBD, TO, VB, IN, PRP',
  },
  {
    text: 'Wolves can migrate considerable distances.',
    tags: 'NNS, MD, VB, JJ, NNS',
  },
  {
    text: 'By Dan Whipple',
    tags: 'IN, NNP, NNP',
  },
  {
    text: 'Boulder, CO, Nov. 15 (UPI) --',
    tags: 'NNP, NNP, NNP, CD, NNP',
  },
  {
    text: 'Important species that probably would decline include shrimp, capelin, Greenland halibut and some varieties of flatfish.',
    tags: 'JJ, NNS, WDT, RB, MD, VB, VBP, NNS, NN, NNP, NN, CC, DT, NNS, IN, NNS',
  },
  {
    text: 'The Pew researchers tried to transcend the economic argument.',
    tags: 'DT, NNP, NNS, VBD, TO, VB, DT, JJ, NN',
  },
  {
    text: 'You have seen the pictures.',
    tags: 'PRP, VBP, VBN, DT, NNS',
  },
  {
    text: 'It is the welfare society that was New Orleans."',
    tags: 'PRP, VBZ, DT, NN, NN, CC, VBD, NNP, NNP',
  },
  {
    text: '-- Paul, Atlanta, USA',
    tags: 'NNP, NNP, NNP',
  },
  {
    text: '-- Mac, Nottingham',
    tags: 'NNP, NNP',
  },
  {
    text: '-- David, Kent',
    tags: 'NNP, NNP',
  },
  {
    text: '-- John B, Windermere, Florida',
    tags: 'NNP, NNP, NNP, NNP',
  },
  {
    text: 'Certainly, representation of the US in other countries will have a certain depiction.',
    tags: 'RB, NN, IN, DT, NNP, IN, JJ, NNS, MD, VB, DT, JJ, NN',
  },
  {
    text: 'Some refused to leave, but so many were unable to.',
    tags: 'DT, VBD, TO, VB, CC, RB, JJ, VBD, JJ, TO',
  },
  {
    text: "These are some of the things I've been wondering ...",
    tags: 'DT, VBP, DT, IN, DT, NNS, PRP, VBP, VBN, VBG',
  },
  {
    text: 'Recently, Bush addressed the nation.',
    tags: 'RB, NNP, VBD, DT, NN',
  },
  {
    text: 'Aries in 2005 - Flexibility',
    tags: 'NNP, IN, CD, NN',
  },
  {
    text: 'Taurus in 2005 - Tenacity',
    tags: 'NNP, IN, CD, NN',
  },
  {
    text: 'Gemini in 2005 - Success',
    tags: 'NNP, IN, CD, NN',
  },
  {
    text: 'Cancer in 2005 - Balance',
    tags: 'NNP, IN, CD, NN',
  },
  {
    text: 'The active ones will be hectic!',
    tags: 'DT, JJ, NNS, MD, VB, JJ',
  },
  {
    text: 'Leo in 2005 - Abundance',
    tags: 'NNP, IN, CD, NN',
  },
  {
    text: 'Pursuing a successful career, along with the usual social and financial advantages, will be easier this year than it has in a long time for you, Leo!',
    tags: 'VBG, DT, JJ, NN, IN, IN, DT, JJ, JJ, CC, JJ, NNS, MD, VB, JJR, DT, NN, IN, PRP, VBZ, IN, DT, JJ, NN, IN, PRP, NNP',
  },
  {
    text: "you'll be able to create opportunities for advancement almost out of thin air.",
    tags: 'PRP, MD, VB, JJ, TO, VB, NNS, IN, NN, RB, IN, IN, JJ, NN',
  },
  {
    text: 'Money may suddenly become tight at a very inconvenient time.',
    tags: 'NN, MD, RB, VB, JJ, IN, DT, RB, JJ, NN',
  },
  {
    text: 'Virgo in 2005 - Perseverance',
    tags: 'NNP, IN, CD, NN',
  },
  {
    text: 'Libra in 2005 - Expansion',
    tags: 'NNP, IN, CD, NN',
  },
  {
    text: 'Scorpio in 2005 - Transmutation',
    tags: 'NNP, IN, CD, NN',
  },
  {
    text: 'Sagittarius in 2005 - Empowerment',
    tags: 'NNP, IN, CD, NN',
  },
  {
    text: 'Capricorn in 2005 - Resolution',
    tags: 'NNP, IN, CD, NN',
  },
  {
    text: 'Aquarius in 2005 - Magic',
    tags: 'NNP, IN, CD, NN',
  },
  {
    text: 'Pisces in 2005 - Self-confidence',
    tags: 'NNP, IN, CD, NN, NN',
  },
  {
    text: "It's a big year for you, friend Pisces.",
    tags: 'PRP, VBZ, DT, JJ, NN, IN, PRP, NN, NNP',
  },
  {
    text: 'ARCHILOCHUS solar eclipse: April 6, 648 BC Friday',
    tags: 'NNP, JJ, NN, NNP, CD, CD, NN, NNP',
  },
  {
    text: 'Petrarch meets LAURA: April 6, 1327 Monday',
    tags: 'NNP, VBZ, NNP, NNP, CD, CD, NNP',
  },
  {
    text: 'DURER dies: April 6, 1528 Monday',
    tags: 'NNP, VBZ, NNP, CD, CD, NNP',
  },
  {
    text: 'Sir Francis Walsingham dies: April 6, 1590 Monday',
    tags: 'NNP, NNP, NNP, VBZ, NNP, CD, CD, NNP',
  },
  {
    text: 'LAURA dies of plague: April 6, 1348 Sunday',
    tags: 'NNP, VBZ, IN, NN, NNP, CD, CD, NNP',
  },
  {
    text: 'RAPHAEL born: April 6, 1483 Sunday',
    tags: 'NNP, VBN, NNP, CD, CD, NNP',
  },
  {
    text: 'RAPHAEL dies: April 6, 1520 Good Friday',
    tags: 'NNP, VBZ, NNP, CD, CD, NNP, NNP',
  },
  {
    text: 'Kent EARTHQUAKE: April 6, 1580 Wednesday',
    tags: 'NNP, NNP, NNP, CD, CD, NNP',
  },
  {
    text: 'Upon the same day he conquered Darius, won a great victory at sea, & died the same day.',
    tags: 'IN, DT, JJ, NN, PRP, VBD, NNP, VBD, DT, JJ, NN, IN, NN, CC, VBD, DT, JJ, NN',
  },
  {
    text: '1533 Atahualpa, inca emperor of peru, imprisoned & learns chess.',
    tags: 'CD, NNP, NNP, NN, IN, NNP, VBN, CC, VBZ, NN',
  },
  {
    text: 'Introduces the word gambit.',
    tags: 'VBZ, DT, NN, NN',
  },
  {
    text: '1570 Gianutto della Mantia, Horatio born in Italy.',
    tags: 'CD, NNP, NN, NNP, NNP, VBN, IN, NNP',
  },
  {
    text: '1575 Leonardo beats Ruy Lopez in Madrid.',
    tags: 'CD, NNP, VBZ, NNP, NNP, IN, NNP',
  },
  {
    text: '1580 Catherine de Medici of France is a keen chess player.',
    tags: 'CD, NNP, NNP, NNP, IN, NNP, VBZ, DT, JJ, NN, NN',
  },
  {
    text: '1580 Ruy lopez died.',
    tags: 'CD, NNP, NN, VBD',
  },
  {
    text: 'Nostromo A Tale of the Seaboard',
    tags: 'NNP, DT, NNP, IN, DT, NNP',
  },
  {
    text: 'He turned away.',
    tags: 'PRP, VBD, RB',
  },
  {
    text: 'Wisteria Lodge',
    tags: 'NNP, NNP',
  },
  {
    text: '"But everything went wrong with us.',
    tags: 'CC, NN, VBD, JJ, IN, PRP',
  },
  {
    text: 'Art Neuendorffer',
    tags: 'NNP, NNP',
  },
  {
    text: 'John Lennon entered stardom being a murderer.',
    tags: 'NNP, NNP, VBD, NN, VBG, DT, NN',
  },
  {
    text: 'One week after that declaration, ONLY ONE WEEK LATER, Brian Epstein, forger of the Beatle farce, died from an overdose.',
    tags: 'CD, NN, IN, DT, NN, RB, CD, NN, RBR, NNP, NNP, NN, IN, DT, NNP, NN, VBD, IN, DT, NN',
  },
  {
    text: 'You have been warned ...',
    tags: 'PRP, VBP, VBN, VBN',
  },
  {
    text: 'THE HIGH COURT.',
    tags: 'DT, JJ, NN',
  },
  {
    text: 'By William Rivers Pitt',
    tags: 'IN, NNP, NNP, NNP',
  },
  {
    text: 'Monday 09 January 2006',
    tags: 'NNP, CD, NNP, CD',
  },
  {
    text: '"Iran has significant capabilities for asymmetric warfare, and poses the additional threat of proliferation.',
    tags: 'NNP, VBZ, JJ, NNS, IN, JJ, NN, CC, VBZ, DT, JJ, NN, IN, NN',
  },
  {
    text: 'In essence, Iran holds the high ground in the Gulf.',
    tags: 'IN, NN, NNP, VBZ, DT, JJ, NN, IN, DT, NN',
  },
  {
    text: 'The Sunburn can reach Mach 3 at high altitude.',
    tags: 'DT, NNP, MD, VB, NNP, CD, IN, JJ, NN',
  },
  {
    text: 'Iran also stands accused of aiding terrorism across the globe.',
    tags: 'NNP, RB, VBZ, VBN, IN, VBG, NN, IN, DT, NN',
  },
  {
    text: 'Is any of this a probability?',
    tags: 'VBZ, DT, IN, DT, DT, NN',
  },
  {
    text: 'They did it once already in Iraq.',
    tags: 'PRP, VBD, PRP, RB, RB, IN, NNP',
  },
  {
    text: '300 - Number of Clean Water Act violations by the mountaintop-mining industry in 2003.',
    tags: 'CD, NN, IN, NNP, NNP, NNP, NNS, IN, DT, NN, NN, NN, IN, CD',
  },
  {
    text: '100 - Percentage of those decisions that Bush then decided to allow the government to ignore indefinitely.',
    tags: 'CD, NN, IN, DT, NNS, WDT, NNP, RB, VBD, TO, VB, DT, NN, TO, VB, RB',
  },
  {
    text: '140 - Number of Saudis, including members of the Bin Laden family, evacuated from United States almost immediately after 11 September.',
    tags: 'CD, NN, IN, NNPS, VBG, NNS, IN, DT, NNP, NNP, NN, VBN, IN, NNP, NNP, RB, RB, IN, CD, NNP',
  },
  {
    text: 'Ambitious warrior',
    tags: 'JJ, NN',
  },
  {
    text: 'Saviour of Iraq',
    tags: 'NN, IN, NNP',
  },
  {
    text: 'Making the country safer',
    tags: 'VBG, DT, NN, JJR',
  },
  {
    text: '95 - Percentage of foreign goods that arrive in the United States by sea.',
    tags: 'CD, NN, IN, JJ, NNS, WDT, VBP, IN, DT, NNP, NNP, IN, NN',
  },
  {
    text: '15,000 - Number of major chemical facilities in the United States.',
    tags: 'CD, NN, IN, JJ, JJ, NNS, IN, DT, NNP, NNP',
  },
  {
    text: 'George Bush: Money manager',
    tags: 'NNP, NNP, NN, NN',
  },
  {
    text: 'George Bush: Tax cutter',
    tags: 'NNP, NNP, NN, NN',
  },
  {
    text: 'Employment tsar',
    tags: 'NN, NN',
  },
  {
    text: 'George Bush: Lawman',
    tags: 'NNP, NNP, NN',
  },
  {
    text: '42 - Number of nationalities of those detainees at Guantanamo.',
    tags: 'CD, NN, IN, NNS, IN, DT, NNS, IN, NNP',
  },
  {
    text: 'Image booster for the US',
    tags: 'NN, NN, IN, DT, NNP',
  },
  {
    text: '13 - Number of vacation days the average American receives each Year.',
    tags: 'CD, NN, IN, NN, NNS, DT, JJ, NNP, VBZ, DT, NN',
  },
  {
    text: 'I think just living in a house with so many girls is making him go crazy?',
    tags: 'PRP, VBP, RB, VBG, IN, DT, NN, IN, RB, JJ, NNS, VBZ, VBG, PRP, VB, JJ',
  },
  {
    text: 'I am sorry for him, he is a good dad',
    tags: 'PRP, VBP, JJ, IN, PRP, PRP, VBZ, DT, JJ, NN',
  },
  {
    text: 'Moreton Morrell in Coventry, Warwickshire',
    tags: 'NNP, NNP, IN, NNP, NNP',
  },
  {
    text: 'Cheap hookers',
    tags: 'JJ, NNS',
  },
  {
    text: 'Would you recommend living in Limerick as a student?',
    tags: 'MD, PRP, VB, VBG, IN, NNP, IN, DT, NN',
  },
  {
    text: 'and would you recommend it as a student?',
    tags: 'CC, MD, PRP, VB, PRP, IN, DT, NN',
  },
  {
    text: 'Orla got it in one.',
    tags: 'NNP, VBD, PRP, IN, CD',
  },
  {
    text: 'Can that be fixed?',
    tags: 'MD, DT, VB, VBN',
  },
  {
    text: 'cynangon mod should work.',
    tags: 'NNP, NNP, MD, VB',
  },
  {
    text: 'Have you tried using clockwork recovery?',
    tags: 'VBP, PRP, VBN, VBG, NN, NN',
  },
  {
    text: 'Get the older version of Cynagon mod.',
    tags: 'VB, DT, JJR, NN, IN, NNP, NNP',
  },
  {
    text: 'Those roms focus on speed and stability.',
    tags: 'DT, NNS, VBP, IN, NN, CC, NN',
  },
  {
    text: 'Or you could just use a home screen launcher replacement.',
    tags: 'CC, PRP, MD, RB, VB, DT, NN, NN, NN, NN',
  },
  {
    text: 'Hope you read through this.',
    tags: 'VBP, PRP, VBD, IN, DT',
  },
  {
    text: 'are the moors and penines in Yorkshire a lonely eerie place?',
    tags: 'VBP, DT, NNS, CC, NNS, IN, NNP, DT, JJ, JJ, NN',
  },
  {
    text: 'I am VERY satisfied.',
    tags: 'PRP, VBP, RB, JJ',
  },
  {
    text: 'lens?',
    tags: 'NN',
  },
  {
    text: 'or it is normal?',
    tags: 'CC, PRP, VBZ, JJ',
  },
  {
    text: 'Is there any cure for mouse poison?',
    tags: 'VBZ, EX, DT, NN, IN, NN, NN',
  },
  {
    text: 'Crayola Air-Dry Clay?',
    tags: 'NNP, NN, NN, NN',
  },
  {
    text: 'She loves giraffes and homemade things!',
    tags: 'PRP, VBZ, NNS, CC, JJ, NNS',
  },
  {
    text: 'good idea?',
    tags: 'JJ, NN',
  },
  {
    text: 'she is also good in a carrier.',
    tags: 'PRP, VBZ, RB, JJ, IN, DT, NN',
  },
  {
    text: 'He loved it.',
    tags: 'PRP, VBD, PRP',
  },
  {
    text: 'NO!',
    tags: 'UH',
  },
  {
    text: 'I have had parakeets for a VERY long time, and I use pledge.',
    tags: 'PRP, VBP, VBN, NNS, IN, DT, RB, JJ, NN, CC, PRP, VBP, NNP',
  },
  {
    text: 'LOL Callum',
    tags: 'UH, NNP',
  },
  {
    text: 'no no no no no no',
    tags: 'UH, UH, UH, UH, UH, UH',
  },
  {
    text: 'no',
    tags: 'UH',
  },
  {
    text: 'Please HELP !!!!!!!!!!!!!!!!!!!!!',
    tags: 'UH, VB',
  },
  {
    text: 'TEN POINTS !!!!!!!!!!?',
    tags: 'CD, NNS',
  },
  {
    text: 'PLEASE !!!!!!',
    tags: 'UH',
  },
  {
    text: 'PLEASE HELP !!!!!!!!!!!',
    tags: 'UH, VB',
  },
  {
    text: '- 20 piece Chicken McNuggets',
    tags: 'CD, NN, NNP, NNPS',
  },

  {
    text: '- 10 piece Chicken McNuggets',
    tags: 'CD, NN, NNP, NNPS',
  },
  {
    text: '- Medium Fountain Drink',
    tags: 'JJ, NN, NN',
  },
  {
    text: '- McCAFE Drink',
    tags: 'NNP, NN',
  },
  {
    text: '- Hash browns',
    tags: 'NN, NNS',
  },
  {
    text: '- Egg McMuffin, Sausage',
    tags: 'NNP, NNP, NN',
  },
  {
    text: 'becca is right.',
    tags: 'NNP, VBZ, JJ',
  },
  {
    text: 'Beardies are actually quite delicate.',
    tags: 'NNS, VBP, RB, RB, JJ',
  },
  {
    text: 'For horses that are strong pullers.',
    tags: 'IN, NNS, CC, VBP, JJ, NNS',
  },
  {
    text: 'It just gives you a little leverage and curb pressure.',
    tags: 'PRP, RB, VBZ, PRP, DT, JJ, NN, CC, NN, NN',
  },
  {
    text: "I know that's vague, but it depends on the horse.",
    tags: 'PRP, VBP, DT, VBZ, JJ, CC, PRP, VBZ, IN, DT, NN',
  },
  {
    text: 'christmas ~ 100',
    tags: 'NNP, SYM, CD',
  },
  {
    text: 'hey kido u made me smile',
    tags: 'UH, NN, PRP, VBD, PRP, VB',
  },
  {
    text: 'Plaster of Paris does two things',
    tags: 'NN, IN, NNP, VBZ, CD, NNS',
  },
  {
    text: 'That might work',
    tags: 'DT, MD, VB',
  },
  {
    text: 'wheels are relatively noiseless -',
    tags: 'NNS, VBP, RB, JJ',
  },
  {
    text: 'petsmart application?',
    tags: 'NNP, NN',
  },
  {
    text: 'It makes a huge difference.',
    tags: 'PRP, VBZ, DT, JJ, NN',
  },
  {
    text: 'Nope',
    tags: 'UH',
  },
  {
    text: 'I applied to get a student visa to study in Canada, I received one that is valid until October of 2015.',
    tags: 'PRP, VBD, TO, VB, DT, NN, NN, TO, VB, IN, NNP, PRP, VBD, CD, WDT, VBZ, JJ, IN, NNP, IN, CD',
  },
  {
    text: 'Hi',
    tags: 'UH',
  },
  {
    text: 'I dislike this urban society and want to leave this whole enviroment.',
    tags: 'PRP, VBP, DT, JJ, NN, CC, VBP, TO, VB, DT, JJ, NN',
  },
  {
    text: 'I live in London.',
    tags: 'PRP, VBP, IN, NNP',
  },
  {
    text: 'Hotels for travelling will be expensive.',
    tags: 'NNS, IN, NN, MD, VB, JJ',
  },
  {
    text: 'Hit the road.',
    tags: 'VB, DT, NN',
  },
  {
    text: 'Should the statue of David be censored?',
    tags: 'MD, DT, NN, IN, NNP, VB, VBN',
  },
  {
    text: "no, it's only a body of a young man",
    tags: 'UH, PRP, VBZ, RB, DT, NN, IN, DT, JJ, NN',
  },
  {
    text: 'No, it was guys.',
    tags: 'UH, PRP, VBD, NNS',
  },
  {
    text: 'Better Steakhouse in Philadelphia?',
    tags: 'JJ, NN, IN, NNP',
  },
  {
    text: 'Many thanks.',
    tags: 'JJ, NNS',
  },
  {
    text: 'or would the steam from the shower be a problem?',
    tags: 'CC, MD, DT, NN, IN, DT, NN, VB, DT, NN',
  },
  {
    text: 'Is normal bird food good?', //fine
    tags: 'VBZ, JJ, NN, NN, JJ',
  },
  {
    text: 'or buy small bait worms.',
    tags: 'CC, VB, JJ, NN, NNS',
  },
  {
    text: 'that should work',
    tags: 'DT, MD, VB',
  },
  {
    text: 'i have two options',
    tags: 'PRP, VBP, CD, NNS',
  },
  {
    text: 'using the metro or the air france bus',
    tags: 'VBG, DT, NNP, CC, DT, NNP, NNP, NN',
  },
  {
    text: 'Buy a ticket for Paris.',
    tags: 'VB, DT, NN, IN, NNP',
  },
  {
    text: 'Buy a ticket from the driver.',
    tags: 'VB, DT, NN, IN, DT, NN',
  },
  {
    text: 'You could also try this in gimp.',
    tags: 'PRP, MD, RB, VB, DT, IN, NNP',
  },
  {
    text: 'Hope this helps.',
    tags: 'VB, DT, VBZ',
  },
  {
    text: 'Only a fool would base a decision using the cheapest surgeon to perform an operation.',
    tags: 'RB, DT, NN, MD, VB, DT, NN, VBG, DT, JJS, NN, TO, VB, DT, NN',
  },
  {
    text: "I've had cats for 35 years and I only feed them dry food.",
    tags: 'PRP, VBP, VBN, NNS, IN, CD, NNS, CC, PRP, RB, VBP, PRP, JJ, NN',
  },
  {
    text: 'Read the labels for contents.',
    tags: 'VB, DT, NNS, IN, NNS',
  },
  {
    text: 'They would be too scared and spooky.',
    tags: 'PRP, MD, VB, RB, JJ, CC, JJ',
  },
  {
    text: '10 gallon nano reef ideas?',
    tags: 'CD, NN, NN, NN, NNS',
  },
  {
    text: 'I am aware of the maintenance involved in keeping a tank this size.',
    tags: 'PRP, VBP, JJ, IN, DT, NN, VBN, IN, VBG, DT, NN, DT, NN',
  },
  {
    text: 'I am currently maintaining a gravity level of 1.024.',
    tags: 'PRP, VBP, RB, VBG, DT, NN, NN, IN, CD',
  },
  {
    text: 'Do I need a protein skimmer or any other equipment?',
    tags: 'VBP, PRP, VB, DT, NN, NN, CC, DT, JJ, NN',
  },
  {
    text: 'NOOK Color or NOOK Tablet?',
    tags: 'NNP, NNP, CC, NNP, NNP',
  },
  {
    text: 'Or just purchase the Color?',
    tags: 'CC, RB, VB, DT, NNP',
  },
  {
    text: 'Pubs in Philadelphia?',
    tags: 'NNP, IN, NNP',
  },
  {
    text: 'You add the water and put water conditioner into the water.',
    tags: 'PRP, VBP, DT, NN, CC, VBP, NN, NN, IN, DT, NN',
  },
  {
    text: 'And do you get charged for it?',
    tags: 'CC, VBP, PRP, VB, VBN, IN, PRP',
  },
  {
    text: 'Hope I helped!',
    tags: 'VB, PRP, VBD',
  },
  {
    text: "He's probably still scared and unsure.",
    tags: 'PRP, VBZ, RB, RB, JJ, CC, JJ',
  },
  {
    text: 'Things to do in Fujairah ..',
    tags: 'NNS, TO, VB, IN, NNP',
  },
  {
    text: 'Are there any new Gaming console?',
    tags: 'VBP, EX, DT, JJ, NN, NN',
  },
  {
    text: 'Anything after 12 is a bonus.',
    tags: 'NN, IN, CD, VBZ, DT, NN',
  },
  {
    text: 'But then again he could be!',
    tags: 'CC, RB, RB, PRP, MD, VB',
  },
  {
    text: 'Pictures would help!',
    tags: 'NNS, MD, VB',
  },
  {
    text: 'You always want to go higher rather than wider for rats.',
    tags: 'PRP, RB, VBP, TO, VB, RBR, RB, IN, RBR, IN, NNS',
  },
  {
    text: 'Both are equal length so go for the taller one.',
    tags: 'DT, VBP, JJ, NN, RB, VB, IN, DT, JJR, CD',
  },
  {
    text: 'good luck!',
    tags: 'JJ, NN',
  },
  {
    text: 'put the heater on the snake he will love it and the the next day you will have dinner',
    tags: 'VB, DT, NN, IN, DT, NN, PRP, MD, VB, PRP, CC, DT, DT, JJ, NN, PRP, MD, VB, NN',
  },
  {
    text: 'You can definately plan on a great meal with reasonable prices.',
    tags: 'PRP, MD, RB, VB, IN, DT, JJ, NN, IN, JJ, NNS',
  },
  {
    text: 'Just relax and enjoy.',
    tags: 'RB, VB, CC, VB',
  },
  {
    text: "We're at the corner of Hubbard and Noble.",
    tags: 'PRP, VBP, IN, DT, NN, IN, NNP, CC, NNP',
  },
  {
    text: '1381 W. Hubbard',
    tags: 'CD, NNP, NNP',
  },
  {
    text: 'Chicago, IL 60622',
    tags: 'NNP, NNP, CD',
  },
  {
    text: 'Monday thru Friday',
    tags: 'NNP, IN, NNP',
  },
  {
    text: 'Happy Hour',
    tags: 'JJ, NN',
  },
  {
    text: 'Monday thru Friday',
    tags: 'NNP, IN, NNP',
  },
  {
    text: 'Or you can visit temples or shrines in Okinawa.',
    tags: 'CC, PRP, MD, VB, NNS, CC, NNS, IN, NNP',
  },
  {
    text: 'Eat at a conveyor-belt sushi restaurant.',
    tags: 'VB, IN, DT, NN, NN, NN, NN',
  },
  {
    text: 'As a result there was a problem with the weapon jamming.',
    tags: 'IN, DT, NN, EX, VBD, DT, NN, IN, DT, NN, VBG',
  },
  {
    text: 'Rotorua is fine.',
    tags: 'NNP, VBZ, JJ',
  },
  {
    text: 'Nothing wrong with rotorua',
    tags: 'NN, JJ, IN, NNP',
  },
  {
    text: 'But I would go for the base number of 15 hh.',
    tags: 'CC, PRP, MD, VB, IN, DT, NN, NN, IN, CD, NNS',
  },
  {
    text: 'Iguazu Falls',
    tags: 'NNP, NNPS',
  },
  {
    text: 'definitely London -',
    tags: 'RB, NNP',
  },
  {
    text: "you'll need to have intermediate French to have a good time in Paris.",
    tags: 'PRP, MD, VB, TO, VB, JJ, NNP, TO, VB, DT, JJ, NN, IN, NNP',
  },
  {
    text: "It's beautiful and the people are extremely friendly.",
    tags: 'PRP, VBZ, JJ, CC, DT, NNS, VBP, RB, JJ',
  },
  {
    text: 'Everything about the place is magical and the people are mostly friendly.',
    tags: 'NN, IN, DT, NN, VBZ, JJ, CC, DT, NNS, VBP, RB, JJ',
  },
  {
    text: 'That is a term invented by online romance scammers',
    tags: 'DT, VBZ, DT, NN, VBN, IN, JJ, NN, NNS',
  },
  {
    text: 'This is an invention of the scammers."',
    tags: 'DT, VBZ, DT, NN, IN, DT, NNS',
  },
  {
    text: 'BTA only exists in the mind of SCAMMERS.',
    tags: 'NNP, RB, VBZ, IN, DT, NN, IN, NNS',
  },
  {
    text: '100 % SCAM.',
    tags: 'CD, NN, NN',
  },
  {
    text: 'Then the environment.',
    tags: 'RB, DT, NN',
  },
  {
    text: 'Then add the other mate.',
    tags: 'RB, VB, DT, JJ, NN',
  },
  {
    text: 'I want to apply for canada skilled immigeration program.',
    tags: 'PRP, VBP, TO, VB, IN, NNP, JJ, NN, NN',
  },
  {
    text: 'Can i apply with 63 points?',
    tags: 'MD, PRP, VB, IN, CD, NNS',
  },
  {
    text: 'The pass mark could change.',
    tags: 'DT, NN, NN, MD, VB',
  },
  {
    text: 'Read the full answer at that web page for conditions.',
    tags: 'VB, DT, JJ, NN, IN, DT, NN, NN, IN, NNS',
  },
  {
    text: 'Jim B',
    tags: 'NNP, NNP',
  },
  {
    text: 'Please help !?',
    tags: 'UH, VB',
  },
  {
    text: 'Can someone please make me feel better about this trip !!!!',
    tags: 'MD, NN, UH, VB, PRP, VB, JJR, IN, DT, NN',
  },
  {
    text: 'Hope it helps!',
    tags: 'VBP, PRP, VBZ',
  },
  {
    text: 'It is free.',
    tags: 'PRP, VBZ, JJ',
  },
  {
    text: 'Feather Type.',
    tags: 'NN, NN',
  },
  {
    text: 'Sussexs have soft feathers.',
    tags: 'NNS, VBP, JJ, NNS',
  },
  {
    text: 'Five Toes: Silkies have five toes.',
    tags: 'CD, NNS, NNS, VBP, CD, NNS',
  },
  {
    text: 'Sussex have four toes.',
    tags: 'NN, VBP, CD, NNS',
  },
  {
    text: 'But only really in the countryside.',
    tags: 'CC, RB, RB, IN, DT, NN',
  },
  {
    text: 'Barn brack and the ring.',
    tags: 'NN, NN, CC, DT, NN',
  },
  {
    text: 'christmas cake for christmas day.',
    tags: 'NNP, NN, IN, NNP, NN',
  },
  {
    text: 'Do animals see images on a TV screen like humans do?',
    tags: 'VBP, NNS, VB, NNS, IN, DT, NN, NN, IN, NNS, VBP',
  },
  {
    text: 'Do animals see images on a TV screen like humans do?',
    tags: 'VBP, NNS, VB, NNS, IN, DT, NN, NN, IN, NNS, VBP',
  },
  {
    text: 'Do dogs enjoy watching T.V.?',
    tags: 'VBP, NNS, VB, VBG, NN',
  },
  {
    text: 'I want to take a cruise around the world.',
    tags: 'PRP, VBP, TO, VB, DT, NN, IN, DT, NN',
  },
  {
    text: 'Good luck!',
    tags: 'JJ, NN',
  },
  {
    text: 'The whole Western Addition and a large portion of the Haight was black.',
    tags: 'DT, JJ, NNP, NNP, CC, DT, JJ, NN, IN, DT, NNP, VBD, JJ',
  },
  {
    text: 'It was an evolution.',
    tags: 'PRP, VBD, DT, NN',
  },
  {
    text: 'Good luck!',
    tags: 'JJ, NN',
  },
  {
    text: 'rabbits are delicate and can get diseases so watch out for that.',
    tags: 'NNS, VBP, JJ, CC, MD, VB, NNS, RB, VB, RP, IN, DT',
  },
  {
    text: 'Switzerland is one, and the Netherlands are passing the same law.',
    tags: 'NNP, VBZ, CD, CC, DT, NNPS, VBP, VBG, DT, JJ, NN',
  },
  {
    text: 'It will become EU law in a couple of years.',
    tags: 'PRP, MD, VB, NNP, NN, IN, DT, NN, IN, NNS',
  },
  {
    text: 'Lay some knowledge on them dude.',
    tags: 'VB, DT, NN, IN, PRP, NN',
  },
  {
    text: 'Good luck!',
    tags: 'JJ, NN',
  },
  {
    text: 'Good luck!',
    tags: 'JJ, NN',
  },
  {
    text: 'Any suggestions?',
    tags: 'DT, NNS',
  },
  {
    text: 'Being gay and living in Toronto is just fine.',
    tags: 'VBG, JJ, CC, VBG, IN, NNP, VBZ, RB, JJ',
  },
  {
    text: 'But, can you immigrate?',
    tags: 'CC, MD, PRP, VB',
  },
  {
    text: 'Do it properly, and legally, and you will be OK.',
    tags: 'VB, PRP, RB, CC, RB, CC, PRP, MD, VB, JJ',
  },
  {
    text: 'Jim B',
    tags: 'NNP, NNP',
  },
  {
    text: "Recently I'm having trouble training him.",
    tags: 'RB, PRP, VBP, VBG, NN, VBG, PRP',
  },
  {
    text: 'Hi, I am a dog trainer for 25 yrs.',
    tags: 'UH, PRP, VBP, DT, NN, NN, IN, CD, NNS',
  },
  {
    text: 'Do this repeatedly and frequently and he will learn to walk on a leash.',
    tags: 'VB, DT, RB, CC, RB, CC, PRP, MD, VB, TO, VB, IN, DT, NN',
  },
  {
    text: 'Hey guys.',
    tags: 'UH, NNS',
  },
  {
    text: "In Delhi I'd recommend Ajay Guesthouse.",
    tags: 'IN, NNP, PRP, MD, VB, NNP, NNP',
  },
  {
    text: 'Those ones are quite small.',
    tags: 'DT, NNS, VBP, RB, JJ',
  },
  {
    text: 'But in general, Delhi is the hardest place to find a nice clean hotel for that price.',
    tags: 'CC, IN, JJ, NNP, VBZ, DT, JJS, NN, TO, VB, DT, JJ, JJ, NN, IN, DT, NN',
  },
  {
    text: 'It was quite easy to find something.',
    tags: 'PRP, VBD, RB, JJ, TO, VB, NN',
  },
  {
    text: 'it is in karol bagh.',
    tags: 'PRP, VBZ, IN, NNP, NNP',
  },
  {
    text: 'a degu, a rat, a mouse, a hamster or a guinea pig?',
    tags: 'DT, NN, DT, NN, DT, NN, DT, NN, CC, DT, NN, NN',
  },
  {
    text: 'Get a guinea pig.',
    tags: 'VB, DT, NN, NN',
  },
  {
    text: "They're incredibly social, highly trainable, and very clean.",
    tags: 'PRP, VBP, RB, JJ, RB, JJ, CC, RB, JJ',
  },
  {
    text: 'Get a guinea pig.',
    tags: 'VB, DT, NN, NN',
  },
  {
    text: 'We have two.',
    tags: 'PRP, VBP, CD',
  },
  {
    text: 'They are social and like to be handled.',
    tags: 'PRP, VBP, JJ, CC, VBP, TO, VB, VBN',
  },
  {
    text: 'They love leaf or romaine lettuce and tomatos, celery, cucumbers, carrots.',
    tags: 'PRP, VBP, NN, CC, NN, NN, CC, NNS, NN, NNS, NNS',
  },
  {
    text: 'Need Advice !?',
    tags: 'VBP, NN',
  },
  {
    text: 'I find the adults are much easier.',
    tags: 'PRP, VBP, DT, NNS, VBP, RB, JJR',
  },
  {
    text: 'Good luck',
    tags: 'JJ, NN',
  },
  {
    text: '- better food',
    tags: 'JJR, NN',
  },
  {
    text: 'Are there any major differences between them?',
    tags: 'VBP, EX, DT, JJ, NNS, IN, PRP',
  },
  {
    text: 'Spa We tried the spa on the Liberty and loved it.',
    tags: 'NN, PRP, VBD, DT, NN, IN, DT, NNP, CC, VBD, PRP',
  },
  {
    text: 'Leave High School?',
    tags: 'VB, NNP, NNP',
  },
  {
    text: 'In the United States?',
    tags: 'IN, DT, NNP, NNP',
  },
  {
    text: 'Lots of places.',
    tags: 'NNS, IN, NNS',
  },
  {
    text: 'Big Cities like New York, Boston, Philadelphia on the East Coast.',
    tags: 'JJ, NNS, IN, NNP, NNP, NNP, NNP, IN, DT, NNP, NNP',
  },
  {
    text: 'The federal sites of Washington, DC.',
    tags: 'DT, JJ, NNS, IN, NNP, NNP',
  },
  {
    text: 'Southern charm of Nashville, Birmingham, New Orleans or Charlotte.',
    tags: 'JJ, NN, IN, NNP, NNP, NNP, NNP, CC, NNP',
  },
  {
    text: 'Amount of time could be dependent on so many things.',
    tags: 'NN, IN, NN, MD, VB, JJ, IN, RB, JJ, NNS',
  },
  {
    text: 'Good luck.',
    tags: 'JJ, NN',
  },
  {
    text: 'Nigeria, a lovely country.',
    tags: 'NNP, DT, JJ, NN',
  },
  {
    text: 'Obudu cattle ranch.',
    tags: 'NNP, NN, NN',
  },
  {
    text: 'he will feel much safer in that one room, than in a huge unknown house.',
    tags: 'PRP, MD, VB, RB, JJR, IN, DT, CD, NN, IN, IN, DT, JJ, JJ, NN',
  },
  {
    text: 'It s very frustrating.',
    tags: 'PRP, VBZ, RB, JJ',
  },
  {
    text: 'I would start with a leash.',
    tags: 'PRP, MD, VB, IN, DT, NN',
  },
  {
    text: 'He will learn to really like this.',
    tags: 'PRP, MD, VB, TO, RB, VB, DT',
  },
  {
    text: 'Try obedience classes.',
    tags: 'VB, NN, NNS',
  },
  {
    text: 'Thank you!',
    tags: 'VBP, PRP',
  },
  {
    text: 'I have taken this tour and it was great.',
    tags: 'PRP, VBP, VBN, DT, NN, CC, PRP, VBD, JJ',
  },
  {
    text: 'tele # 84838389593',
    tags: 'NN, NN, CD',
  },
  {
    text: 'You take a boat across the river, then spend a day biking, eating at a local restaurant, buying souvenirs and doing other things geared towards tourists.',
    tags: 'PRP, VBP, DT, NN, IN, DT, NN, RB, VB, DT, NN, VBG, VBG, IN, DT, JJ, NN, VBG, NNS, CC, VBG, JJ, NNS, VBN, IN, NNS',
  },
  {
    text: "It's called Kiwi Heaven and it's across the river from Cho Ben Tre.",
    tags: 'PRP, VBZ, VBN, NNP, NNP, CC, PRP, VBZ, IN, DT, NN, IN, NNP, NNP, NNP',
  },
  // {
  //   text: 'But there are just so many poses and programs!',
  //   tags: 'CC, EX, VBP, RB, RB, JJ, NNS, CC, NNS',
  // },
  {
    text: 'Then the same thing with the other leg.',
    tags: 'RB, DT, JJ, NN, IN, DT, JJ, NN',
  },
  {
    text: 'and will these antibiotics help?',
    tags: 'CC, MD, DT, NNS, VB',
  },
  {
    text: 'Thank you for the help.',
    tags: 'VBP, PRP, IN, DT, NN',
  },
  {
    text: 'He could also have Parvovirus, a GI foreign body, or any number of things.',
    tags: 'PRP, MD, RB, VB, NNP, DT, NN, JJ, NN, CC, DT, NN, IN, NNS',
  },
  {
    text: 'Bland food.',
    tags: 'JJ, NN',
  },
  {
    text: 'Did they do any x-rays?',
    tags: 'VBD, PRP, VB, DT, NNS',
  },
  {
    text: 'They are also very secretive about being in a relationship.',
    tags: 'PRP, VBP, RB, RB, JJ, IN, VBG, IN, DT, NN',
  },
  {
    text: 'Is it true?',
    tags: 'VBZ, PRP, JJ',
  },
  {
    text: 'Christiane gave you a good answer.',
    tags: 'NNP, VBD, PRP, DT, JJ, NN',
  },
  {
    text: "it's very logical.",
    tags: 'PRP, VBZ, RB, JJ',
  },
  {
    text: "I also wish I'd applied for a scholarship.",
    tags: 'PRP, RB, VBP, PRP, VBD, VBN, IN, DT, NN',
  },
  {
    text: 'Lol.',
    tags: 'UH',
  },

  {
    text: 'Joking.',
    tags: 'VBG',
  },
  {
    text: 'Get an education!',
    tags: 'VB, DT, NN',
  },
  {
    text: 'i have tried EVERYTHING i can to get him to eat but he refuses.',
    tags: 'PRP, VBP, VBN, NN, PRP, MD, TO, VB, PRP, TO, VB, CC, PRP, VBZ',
  },
  {
    text: "I've only tried to feed him one at a time.",
    tags: 'PRP, VBP, RB, VBN, TO, VB, PRP, CD, IN, DT, NN',
  },
  {
    text: "he's just a tiny baby, about the width of a pencil.",
    tags: 'PRP, VBZ, RB, DT, JJ, NN, IN, DT, NN, IN, DT, NN',
  },
  {
    text: 'They have a natural instinct to hibernate.',
    tags: 'PRP, VBP, DT, JJ, NN, TO, VB',
  },
  {
    text: 'hope this helped.',
    tags: 'VBP, DT, VBD',
  },
  {
    text: 'help !?',
    tags: 'VB',
  },
  {
    text: 'or were they actually fighting?',
    tags: 'CC, VBD, PRP, RB, VBG',
  },
  {
    text: 'she will be able to sleep without being afraid.',
    tags: 'PRP, MD, VB, JJ, TO, VB, IN, VBG, JJ',
  },
  {
    text: 'good luck!',
    tags: 'JJ, NN',
  },
  {
    text: 'That means they are fighting.',
    tags: 'DT, VBZ, PRP, VBP, VBG',
  },
  {
    text: 'Thing is, it worked.',
    tags: 'NN, VBZ, PRP, VBD',
  },
  {
    text: 'The Communists agreed.',
    tags: 'DT, NNPS, VBD',
  },
  {
    text: 'THAT WAS THE PLAN.',
    tags: 'DT, VBD, DT, NN',
  },
  {
    text: 'The Americans detected the attempt to infiltrate the urban areas and were already redeploying troops from the rural areas.',
    tags: 'DT, NNPS, VBD, DT, NN, TO, VB, DT, JJ, NNS, CC, VBD, RB, VBG, NNS, IN, DT, JJ, NNS',
  },
  {
    text: 'There is a very good book on the subject that was written by General Vo Nguyen Giap.',
    tags: 'EX, VBZ, DT, RB, JJ, NN, IN, DT, NN, CC, VBD, VBN, IN, NNP, NNP, NNP, NNP',
  },
  {
    text: 'Any advice would be greatly appreciated.',
    tags: 'DT, NN, MD, VB, RB, VBN',
  },
  {
    text: 'UVB on the other hand can only be reproduced by a fluorescent source.',
    tags: 'NN, IN, DT, JJ, NN, MD, RB, VB, VBN, IN, DT, JJ, NN',
  },
  {
    text: 'As for the heat, just be sure to use a thermometer.',
    tags: 'IN, IN, DT, NN, RB, VB, JJ, TO, VB, DT, NN',
  },
  {
    text: 'Also try green leafy veggies, like kale and spinach.',
    tags: 'RB, VB, JJ, NN, NNS, IN, NN, CC, NN',
  },
  {
    text: 'Is a finch or a parakeet better?',
    tags: 'VBZ, DT, NN, CC, DT, NN, JJR',
  },
  {
    text: 'Please help me!',
    tags: 'UH, VB, PRP',
  },
  {
    text: 'Please choose the parakeet ...',
    tags: 'UH, VB, DT, NN',
  },
  {
    text: 'After a couple of weeks I got tired of them.',
    tags: 'IN, DT, NN, IN, NNS, PRP, VBD, JJ, IN, PRP',
  },
  {
    text: 'They are adorable they have beautiful colors and personality.',
    tags: 'PRP, VBP, JJ, PRP, VBP, JJ, NNS, CC, NN',
  },
  {
    text: 'I love them.',
    tags: 'PRP, VBP, PRP',
  },
  {
    text: 'I tamed them in 4 days.',
    tags: 'PRP, VBD, PRP, IN, CD, NNS',
  },
  {
    text: 'The whole family loves them.',
    tags: 'DT, JJ, NN, VBZ, PRP',
  },
  {
    text: 'I have one yellow girl and a green and yellow boy.',
    tags: 'PRP, VBP, CD, JJ, NN, CC, DT, JJ, CC, JJ, NN',
  },
  {
    text: 'These are the steps I used.',
    tags: 'DT, VBP, DT, NNS, PRP, VBD',
  },
  {
    text: 'Hopefully they will work for you.',
    tags: 'RB, PRP, MD, VB, IN, PRP',
  },
  {
    text: 'You have patience.',
    tags: 'PRP, VBP, NN',
  },
  {
    text: 'Good luck!',
    tags: 'JJ, NN',
  },
  {
    text: 'They worked for me and I hope they worked for you!',
    tags: 'PRP, VBD, IN, PRP, CC, PRP, VBP, PRP, VBD, IN, PRP',
  },
  {
    text: 'They are awesome !!!!!!!!!!!!!!!',
    tags: 'PRP, VBP, JJ',
  },
  {
    text: 'a parakeet is friendlier',
    tags: 'DT, NN, VBZ, JJR',
  },
  {
    text: 'Parakeet.',
    tags: 'NN',
  },
  {
    text: 'They are also friendly.',
    tags: 'PRP, VBP, RB, JJ',
  },
  {
    text: 'And then there’s the rain.',
    tags: 'CC, RB, EX, VBZ, DT, NN',
  },
  {
    text: 'You do realise it is quite expensive to visit Ireland?',
    tags: 'PRP, VBP, VB, PRP, VBZ, RB, JJ, TO, VB, NNP',
  },
  {
    text: 'I have 4 Golden Wonder Killifish.',
    tags: 'PRP, VBP, CD, NN, NN, NNS',
  },
  {
    text: 'Wow!',
    tags: 'UH',
  },
  {
    text: 'You also may need to treat the incubation water.',
    tags: 'PRP, RB, MD, VB, TO, VB, DT, NN, NN',
  },
  {
    text: 'Should I get a balcony?',
    tags: 'MD, PRP, VB, DT, NN',
  },
  {
    text: 'Any tips or advice to make this a great experience ??',
    tags: 'DT, NNS, CC, NN, TO, VB, DT, DT, JJ, NN',
  },
  {
    text: 'It is vacation time.',
    tags: 'PRP, VBZ, NN, NN',
  },
  {
    text: 'It has got very spacious rooms, furnished completely and neatly.',
    tags: 'PRP, VBZ, VBN, RB, JJ, NNS, VBN, RB, CC, RB',
  },
  {
    text: 'These are decorated uniquely and marvelously.',
    tags: 'DT, VBP, VBN, RB, CC, RB',
  },
  {
    text: 'The ship offers variety of eatables, deliciously made.',
    tags: 'DT, NN, VBZ, NN, IN, NNS, RB, VBN',
  },
  {
    text: 'There are special regions uniquely and imposingly designed for the children.',
    tags: 'EX, VBP, JJ, NNS, RB, CC, RB, VBN, IN, DT, NNS',
  },
  {
    text: 'It is really an entertainment for the kids.',
    tags: 'PRP, VBZ, RB, DT, NN, IN, DT, NNS',
  },
  {
    text: 'The amusing world of cartoons and stories will be a memorable experience for the children.',
    tags: 'DT, JJ, NN, IN, NNS, CC, NNS, MD, VB, DT, JJ, NN, IN, DT, NNS',
  },
  {
    text: 'There are other amnesties also.',
    tags: 'EX, VBP, JJ, NNS, RB',
  },
  {
    text: 'There are many online sites offering the booking facility with affordable rates.',
    tags: 'EX, VBP, JJ, JJ, NNS, VBG, DT, NN, NN, IN, JJ, NNS',
  },
  {
    text: 'You may also want to avoid Thanksgiving week and the Christmas holidays.',
    tags: 'PRP, MD, RB, VB, TO, VB, NNP, NN, CC, DT, NNP, NNS',
  },
  {
    text: 'Any time would be great.',
    tags: 'DT, NN, MD, VB, JJ',
  },
  {
    text: 'We had a ball.',
    tags: 'PRP, VBD, DT, NN',
  },
  {
    text: 'The range of activities can be illustrated by describing the water activities.',
    tags: 'DT, NN, IN, NNS, MD, VB, VBN, IN, VBG, DT, NN, NNS',
  },
  {
    text: 'but food is always available and it is consistently good.',
    tags: 'CC, NN, VBZ, RB, JJ, CC, PRP, VBZ, RB, JJ',
  },
  {
    text: "It's a father and son business.",
    tags: 'PRP, VBZ, DT, NN, CC, NN, NN',
  },
  {
    text: 'Or are you undecided?',
    tags: 'CC, VBP, PRP, JJ',
  },
  {
    text: 'He had this Habit of telling you Everything ..',
    tags: 'PRP, VBD, DT, NN, IN, VBG, PRP, NN',
  },
  {
    text: 'Might be something different?',
    tags: 'MD, VB, NN, JJ',
  },
  {
    text: 'Think I should do it?',
    tags: 'VB, PRP, MD, VB, PRP',
  },
  {
    text: "He's dropping we",
    tags: 'PRP, VBZ, VBG, NN',
  },
  {
    text: "It's actually one of the alternative therapies for EPM",
    tags: 'PRP, VBZ, RB, CD, IN, DT, JJ, NNS, IN, NN',
  },
  {
    text: 'Is that something you are up for?',
    tags: 'VBZ, DT, NN, PRP, VBP, IN, IN',
  },
  {
    text: 'Or a difficult birth?',
    tags: 'CC, DT, JJ, NN',
  },
  {
    text: 'Extremely bad customer service',
    tags: 'RB, JJ, NN, NN',
  },
  {
    text: 'Rude, insensitive, discourteous people !!!!!',
    tags: 'JJ, JJ, JJ, NNS',
  },
  {
    text: 'Great Doc',
    tags: 'JJ, NN',
  },
  {
    text: 'Excellent Tattoo Shop',
    tags: 'JJ, NN, NN',
  },
  {
    text: 'The shop was great, the service was excellent and the employees were fun guys.',
    tags: 'DT, NN, VBD, JJ, DT, NN, VBD, JJ, CC, DT, NNS, VBD, JJ, NNS',
  },
  {
    text: 'But I found the location wonderful and the neighbors very kind.',
    tags: 'CC, PRP, VBD, DT, NN, JJ, CC, DT, NNS, RB, JJ',
  },
  {
    text: 'Loved the pool and BBQ.',
    tags: 'VBD, DT, NN, CC, NN',
  },
  {
    text: 'Lynda is professional and has great compassion for animals.',
    tags: 'NNP, VBZ, JJ, CC, VBZ, JJ, NN, IN, NNS',
  },
  {
    text: 'these guys were fantastic!',
    tags: 'DT, NNS, VBD, JJ',
  },
  {
    text: 'GREAT JOB GUYS!',
    tags: 'JJ, NN, NNS',
  },
  {
    text: 'This office is awesome!',
    tags: 'DT, NN, VBZ, JJ',
  },
  {
    text: 'Criminal Attorney Dallas',
    tags: 'JJ, NN, NNP',
  },
  {
    text: 'Food was cold',
    tags: 'NN, VBD, JJ',
  },
  {
    text: 'We love Little Farmer',
    tags: 'PRP, VBP, NNP, NNP',
  },
  {
    text: 'Fantastic, quick and efficient service.',
    tags: 'JJ, JJ, CC, JJ, NN',
  },
  {
    text: 'They were beautiful and lasted forever!',
    tags: 'PRP, VBD, JJ, CC, VBD, RB',
  },
  {
    text: 'Excellent bagels and excellent service!',
    tags: 'JJ, NNS, CC, JJ, NN',
  },
  {
    text: 'They are friendly and fast.',
    tags: 'PRP, VBP, JJ, CC, JJ',
  },
  {
    text: 'They are great!',
    tags: 'PRP, VBP, JJ',
  },
  {
    text: 'Great Doctor!',
    tags: 'JJ, NN',
  },
  {
    text: 'Dr. Faris is a great doctor!',
    tags: 'NNP, NNP, VBZ, DT, JJ, NN',
  },
  {
    text: 'happy customer',
    tags: 'JJ, NN',
  },
  {
    text: 'Affordable pricing.',
    tags: 'JJ, NN',
  },
  {
    text: 'Friendly responses.',
    tags: 'JJ, NNS',
  },
  {
    text: 'You will find the same to be true for you.',
    tags: 'PRP, MD, VB, DT, JJ, TO, VB, JJ, IN, PRP',
  },
  {
    text: "This is car number 3 we 've purchased through them.",
    tags: 'DT, VBZ, NN, NN, CD, PRP, VBP, VBN, IN, PRP',
  },
  {
    text: 'Thank you again for great customer service!',
    tags: 'VBP, PRP, RB, IN, JJ, NN, NN',
  },
  {
    text: 'Highly recommended !!',
    tags: 'RB, VBN',
  },
  {
    text: 'Great pub',
    tags: 'JJ, NN',
  },
  {
    text: 'awful awful awful',
    tags: 'JJ, JJ, JJ',
  },
  {
    text: 'They have unbeatable price in town and deliver on time.',
    tags: 'PRP, VBP, JJ, NN, IN, NN, CC, VBP, IN, NN',
  },
  {
    text: 'Great Surgeon',
    tags: 'JJ, NN',
  },
  {
    text: 'Dr. Wallen and staff was excellent.',
    tags: 'NNP, NNP, CC, NN, VBD, JJ',
  },
  {
    text: 'Staff explained insurance procedures and was very helpful.',
    tags: 'NN, VBD, NN, NNS, CC, VBD, RB, JJ',
  },
  {
    text: 'Everyone was very nice.',
    tags: 'NN, VBD, RB, JJ',
  },
  {
    text: 'The artwork is excellent and the prices are very reasonable.',
    tags: 'DT, NN, VBZ, JJ, CC, DT, NNS, VBP, RB, JJ',
  },
  {
    text: 'Good job, Lake Forest Tots!',
    tags: 'JJ, NN, NNP, NNP, NNPS',
  },
  {
    text: 'This place is so great!',
    tags: 'DT, NN, VBZ, RB, JJ',
  },
  {
    text: 'Excellent customer service and honest feedback.',
    tags: 'JJ, NN, NN, CC, JJ, NN',
  },
  {
    text: "I've only had good experiences at Adorn, I was greeted and offered a refreshment.",
    tags: 'PRP, VBP, RB, VBN, JJ, NNS, IN, NNP, PRP, VBD, VBN, CC, VBN, DT, NN',
  },
  {
    text: 'Pure Pilates !!',
    tags: 'JJ, NN',
  },
  {
    text: 'Thoroughly recommended',
    tags: 'RB, VBN',
  },
  {
    text: 'Definitely recommend!',
    tags: 'RB, VBP',
  },
  {
    text: 'and it works!',
    tags: 'CC, PRP, VBZ',
  },
  {
    text: 'Thank you Comfort Zone',
    tags: 'VBP, PRP, NNP, NNP',
  },
  {
    text: 'Absolutely great!',
    tags: 'RB, JJ',
  },
  {
    text: 'CHANGE THE PROCESS, PPL!',
    tags: 'VB, DT, NN, NNS',
  },
  {
    text: 'I love the people, the product and the service!',
    tags: 'PRP, VBP, DT, NNS, DT, NN, CC, DT, NN',
  },
  {
    text: 'Awesome !!!!',
    tags: 'JJ',
  },
  // {
  //   text: 'they save me from having to deal with Tmobile ...',
  //   tags: 'PRP, VBD, PRP, IN, VBG, TO, VB, IN, NNP',
  // },
  {
    text: 'Great service.',
    tags: 'JJ, NN',
  },
  {
    text: 'But service is very poor.',
    tags: 'CC, NN, VBZ, RB, JJ',
  },
  {
    text: 'Attitude of staff very bad.',
    tags: 'NN, IN, NNS, RB, JJ',
  },
  {
    text: 'And then wait again.',
    tags: 'CC, RB, VB, RB',
  },
  {
    text: 'Everything is delicous and cooked perfectly.',
    tags: 'NN, VBZ, JJ, CC, VBN, RB',
  },
  {
    text: 'I love it for discounted beauty items and household appliances.',
    tags: 'PRP, VBP, PRP, IN, JJ, NN, NNS, CC, NN, NNS',
  },
  {
    text: 'The service at Instep was great !!',
    tags: 'DT, NN, IN, NNP, VBD, JJ',
  },
  {
    text: 'Tried Crust on Broad on 3 occasions.',
    tags: 'VBD, NNP, IN, NNP, IN, CD, NNS',
  },
  {
    text: 'Great help!',
    tags: 'JJ, NN',
  },
  {
    text: 'I have nothing bad to say.',
    tags: 'PRP, VBP, NN, JJ, TO, VB',
  },
  {
    text: 'I got a coupon from Pennysaver for this station.',
    tags: 'PRP, VBD, DT, NN, IN, NNP, IN, DT, NN',
  },
  {
    text: 'Are you kidding me?',
    tags: 'VBP, PRP, VBG, PRP',
  },
  {
    text: 'Good location',
    tags: 'JJ, NN',
  },
  {
    text: 'Rcommended by bees, too!',
    tags: 'VBN, IN, NNS, RB',
  },
  {
    text: 'Highly recommended.',
    tags: 'RB, VBN',
  },
  {
    text: 'Very professional.',
    tags: 'RB, JJ',
  },
  {
    text: 'Reasonable rate.',
    tags: 'JJ, NN',
  },
  {
    text: 'Suzanne, Vancouver',
    tags: 'NNP, NNP',
  },
  {
    text: 'GREAT SERVICE AND PEOPLE !!',
    tags: 'JJ, NN, CC, NNS',
  },
  {
    text: 'Deb Watson is the contact person and she and the rest of the staff were great !!!',
    tags: 'NNP, NNP, VBZ, DT, NN, NN, CC, PRP, CC, DT, NN, IN, DT, NN, VBD, JJ',
  },
  {
    text: 'I love it.',
    tags: 'PRP, VBP, PRP',
  },
  {
    text: 'Pedicures are also great.',
    tags: 'NNS, VBP, RB, JJ',
  },
  {
    text: 'Rendy is totally amazing.',
    tags: 'NNP, VBZ, RB, JJ',
  },
  {
    text: 'She is amazing.',
    tags: 'PRP, VBZ, JJ',
  },
  {
    text: 'Excellent!',
    tags: 'JJ',
  },
  {
    text: 'Too bad they were out of the Chocolate Lava Cake.',
    tags: 'RB, JJ, PRP, VBD, IN, IN, DT, NN, NN, NN',
  },
  {
    text: 'Service was excellent!',
    tags: 'NN, VBD, JJ',
  },
  {
    text: 'Excellent Physiotherapists!',
    tags: 'JJ, NNS',
  },
  {
    text: 'This was a flavorful, enjoyable meal for both of us.',
    tags: 'DT, VBD, DT, JJ, JJ, NN, IN, DT, IN, PRP',
  },
  {
    text: 'she needs to develop a personality!',
    tags: 'PRP, VBZ, TO, VB, DT, NN',
  },
  {
    text: 'The nurses are sweet as pie and the doctor is wonderful.',
    tags: 'DT, NNS, VBP, JJ, IN, NN, CC, DT, NN, VBZ, JJ',
  },
  {
    text: 'THANK YOU !!',
    tags: 'VBP, PRP',
  },
  {
    text: "I choose Console Pros and I'm happy I did.",
    tags: 'PRP, VBP, NNP, NNPS, CC, PRP, VBP, JJ, PRP, VBD',
  },
  {
    text: 'This place is bad.',
    tags: 'DT, NN, VBZ, JJ',
  },
  {
    text: 'Oh no !!',
    tags: 'UH, UH',
  },
  {
    text: 'Great',
    tags: 'JJ',
  },
  {
    text: 'Real pros',
    tags: 'JJ, NNS',
  },
  {
    text: 'Antique Lighting, Fixtures, Chicago',
    tags: 'JJ, NN, NNS, NNP',
  },
  {
    text: 'I think they have the largest collection for Chandeliers Chicago.',
    tags: 'PRP, VBP, PRP, VBP, DT, JJS, NN, IN, NNS, NNP',
  },
  {
    text: 'I wanted to try someplace new again.',
    tags: 'PRP, VBD, TO, VB, NN, JJ, RB',
  },
  {
    text: 'This place rocked.',
    tags: 'DT, NN, VBD',
  },
  {
    text: 'We also had the BBQ Spare Ribs .. good also.',
    tags: 'PRP, RB, VBD, DT, NN, NN, NNS, JJ, RB',
  },
  {
    text: 'I ordered the MOO SHU pork and it was great ..',
    tags: 'PRP, VBD, DT, NN, NN, NN, CC, PRP, VBD, JJ',
  },
  {
    text: 'Tiger Heating is awesome.',
    tags: 'NNP, NNP, VBZ, JJ',
  },
  {
    text: 'These guys were absolutely professional.',
    tags: 'DT, NNS, VBD, RB, JJ',
  },
  {
    text: 'Absolutely a wonderful company.',
    tags: 'RB, DT, JJ, NN',
  },
  {
    text: 'Cute place also',
    tags: 'JJ, NN, RB',
  },
  {
    text: 'They fixed the queso!',
    tags: 'PRP, VBD, DT, NN',
  },
  {
    text: 'Thank you thank you',
    tags: 'VBP, PRP, VBP, PRP',
  },
  {
    text: 'I had the morelias enchiladas.',
    tags: 'PRP, VBD, DT, NN, NNS',
  },
  {
    text: 'James Bateman came the day I called and fixed the problem quickly and efficiently.',
    tags: 'NNP, NNP, VBD, DT, NN, PRP, VBD, CC, VBD, DT, NN, RB, CC, RB',
  },
  {
    text: 'tricky short guy',
    tags: 'JJ, JJ, NN',
  },
  {
    text: 'The service is poor ...',
    tags: 'DT, NN, VBZ, JJ',
  },
  {
    text: 'Learn from a Cesar Gracie black belt and former ufc fighter!',
    tags: 'VB, IN, DT, NNP, NNP, JJ, NN, CC, JJ, NNP, NN',
  },
  {
    text: 'Good Pizza at a good price',
    tags: 'JJ, NN, IN, DT, JJ, NN',
  },
  {
    text: 'this is a good place',
    tags: 'DT, VBZ, DT, JJ, NN',
  },
  {
    text: 'The salesperson refused!',
    tags: 'DT, NN, VBD',
  },
  {
    text: 'Good place to be on a Sunday Night.',
    tags: 'JJ, NN, TO, VB, IN, DT, NNP, NN',
  },
  {
    text: 'Perfect Location plus',
    tags: 'JJ, NN, CC',
  },

  {
    text: 'Another great business bites the dust!',
    tags: 'DT, JJ, NN, VBZ, DT, NN',
  },
  {
    text: 'Enjoyed this cozy little spot with a group of 8 folks.',
    tags: 'VBD, DT, JJ, JJ, NN, IN, DT, NN, IN, CD, NNS',
  },
  {
    text: 'Service was excellent.',
    tags: 'NN, VBD, JJ',
  },
  {
    text: 'Food was excellent.',
    tags: 'NN, VBD, JJ',
  },
  {
    text: 'Wine was excellent.',
    tags: 'NN, VBD, JJ',
  },
  {
    text: 'A perfect place for a romantic dinner.',
    tags: 'DT, JJ, NN, IN, DT, JJ, NN',
  },
  {
    text: 'Great staff.',
    tags: 'JJ, NNS',
  },
  {
    text: 'Very helpful !!!!',
    tags: 'RB, JJ',
  },
  {
    text: "I'm really thankful for the folks at HR Office.",
    tags: 'PRP, VBP, RB, JJ, IN, DT, NNS, IN, NNP, NNP',
  },
  // {
  //   text: 'Food good, service poor',
  //   tags: 'NN, JJ, NN, JJ',
  // },
  {
    text: 'Con Garage',
    tags: 'NN, NN',
  },
  {
    text: 'Rude service',
    tags: 'JJ, NN',
  },
  {
    text: 'Fantastic food served without pretense, very reasonably priced wine selections.',
    tags: 'JJ, NN, VBN, IN, NN, RB, RB, VBN, NN, NNS',
  },
  {
    text: 'Will definitely return.',
    tags: 'MD, RB, VB',
  },
  {
    text: 'Consistantly poor',
    tags: 'RB, JJ',
  },
  // {
  //   text: 'Drinks were awesome, prices reasonable, and staff friendly.',
  //   tags: 'NNS, VBD, JJ, NNS, JJ, CC, NN, JJ',
  // },
  {
    text: 'Amazing!',
    tags: 'JJ',
  },
  {
    text: 'Excellent food, fantastic wait staff',
    tags: 'JJ, NN, JJ, NN, NN',
  },
  {
    text: 'I was saddened to see the reviews that claimed World Hats Mart has poor service.',
    tags: 'PRP, VBD, VBN, TO, VB, DT, NNS, WDT, VBD, NNP, NNPS, NNP, VBZ, JJ, NN',
  },
  {
    text: 'I recommend them highly!',
    tags: 'PRP, VBP, PRP, RB',
  },
  {
    text: 'And they THRIVE to get a customer.',
    tags: 'CC, PRP, VBP, TO, VB, DT, NN',
  },
  {
    text: 'Horrible',
    tags: 'JJ',
  },
  {
    text: 'The worst Burger King restaurant !!!',
    tags: 'DT, JJS, NNP, NNP, NN',
  },
  {
    text: 'It actually had a hole in one of the slices.',
    tags: 'PRP, RB, VBD, DT, NN, IN, CD, IN, DT, NNS',
  },
  {
    text: 'There was minimal cheese and sauce and it completely lacked flavor.',
    tags: 'EX, VBD, JJ, NN, CC, NN, CC, PRP, RB, VBD, NN',
  },
  {
    text: 'This was nothing like New York style pizza !!!.',
    tags: 'DT, VBD, NN, IN, NNP, NNP, NN, NN',
  },
  {
    text: 'I love pizza and this was a complete and utter disappointment !!',
    tags: 'PRP, VBP, NN, CC, DT, VBD, DT, JJ, CC, JJ, NN',
  },
  {
    text: 'Easiest Time I ever had purchasing a car!',
    tags: 'JJS, NN, PRP, RB, VBD, VBG, DT, NN',
  },
  {
    text: 'Extremely helpful and professional',
    tags: 'RB, JJ, CC, JJ',
  },
  {
    text: 'Great Barber',
    tags: 'JJ, NN',
  },
  {
    text: 'UGH !!!',
    tags: 'UH',
  },
  {
    text: 'Took a bite, it tasted odd.',
    tags: 'VBD, DT, NN, PRP, VBD, JJ',
  },
  {
    text: 'Ugh !!',
    tags: 'UH',
  },
  {
    text: 'She also refused to get a manager.',
    tags: 'PRP, RB, VBD, TO, VB, DT, NN',
  },
  {
    text: 'Same clerk had considerable difficulty taking down a number.',
    tags: 'JJ, NN, VBD, JJ, NN, VBG, RP, DT, NN',
  },
  {
    text: 'Amazing Experience!',
    tags: 'JJ, NN',
  },
  {
    text: 'Jana made me feel very comfortable.',
    tags: 'NNP, VBD, PRP, VB, RB, JJ',
  },
  // {
  //   text: 'Provided me with warm blanket and has soft music playing.',
  //   tags: 'VBD, PRP, IN, JJ, NN, CC, VBZ, JJ, NN, VBG',
  // },
  {
    text: 'I really enjoyed the staff at Wessex, also the manager Sherri was always very nice and helpful.',
    tags: 'PRP, RB, VBD, DT, NN, IN, NNP, RB, DT, NN, NNP, VBD, RB, RB, JJ, CC, JJ',
  },
  {
    text: 'The fitness center was GREAT!',
    tags: 'DT, NN, NN, VBD, JJ',
  },
  {
    text: 'Everyone was pleasant and very helpful.',
    tags: 'NN, VBD, JJ, CC, RB, JJ',
  },
  {
    text: 'HEAVEN ON EARTHHHHHHH !!!!',
    tags: 'NN, IN, NNP',
  },
  {
    text: 'MUST TRY !!!',
    tags: 'MD, VB',
  },
  {
    text: 'The food continues to be very good -- deli sandwiches, homemade soups, fresh salads.',
    tags: 'DT, NN, VBZ, TO, VB, RB, JJ, NN, NNS, JJ, NNS, JJ, NNS',
  },
  {
    text: 'Love the soups.',
    tags: 'VBP, DT, NNS',
  },
  {
    text: 'A very satisfied new customer!',
    tags: 'DT, RB, JJ, JJ, NN',
  },
  {
    text: 'As a very satisfied new customer, I wholeheartedly recommend United Air Duct Cleaning.',
    tags: 'IN, DT, RB, JJ, JJ, NN, PRP, RB, VBP, NNP, NNP, NNP, NNP',
  },
  {
    text: 'Great Dude Cut!',
    tags: 'JJ, NN, NN',
  },
  {
    text: 'Great service, cool vibe, impeccable style.',
    tags: 'JJ, NN, JJ, NN, JJ, NN',
  },
  {
    text: 'I rated it 5 stars.',
    tags: 'PRP, VBD, PRP, CD, NNS',
  },
  {
    text: 'We prefer the layout of rooms and it is always clean.',
    tags: 'PRP, VBP, DT, NN, IN, NNS, CC, PRP, VBZ, RB, JJ',
  },
  {
    text: 'Luv always ..',
    tags: 'NN, RB',
  },
  {
    text: 'I purchased a nissan from this dealship.',
    tags: 'PRP, VBD, DT, NNP, IN, DT, NN',
  },
  {
    text: 'The sales men were very knowledgeable about every aspect of every car we looked at.',
    tags: 'DT, NNS, NNS, VBD, RB, JJ, IN, DT, NN, IN, DT, NN, PRP, VBD, IN',
  },
  {
    text: 'The paperwork was a very easy and smooth.',
    tags: 'DT, NN, VBD, DT, RB, JJ, CC, JJ',
  },
  {
    text: 'They have a huge inventory.',
    tags: 'PRP, VBP, DT, JJ, NN',
  },
  {
    text: 'As a nurse I know about drug seekers.',
    tags: 'IN, DT, NN, PRP, VBP, IN, NN, NNS',
  },
  {
    text: 'Wonderful Experience',
    tags: 'JJ, NN',
  },
  {
    text: 'He was incredibly informative about the options I had, giving me opinions on different treatments to choose from.',
    tags: 'PRP, VBD, RB, JJ, IN, DT, NNS, PRP, VBD, VBG, PRP, NNS, IN, JJ, NNS, TO, VB, IN',
  },
  // {
  //   text: "There's holes everywhere in the ceiling, sewage constantly leaks through the ceiling, and the whole condition of the school is horrible.",
  //   tags: 'EX, VBZ, NNS, RB, IN, DT, NN, NN, RB, VBZ, IN, DT, NN, CC, DT, JJ, NN, IN, DT, NN, VBZ, JJ',
  // },
  {
    text: 'We both kept trying to find something we liked.',
    tags: 'PRP, DT, VBD, VBG, TO, VB, NN, PRP, VBD',
  },
  {
    text: 'Hino Dealer of the Year',
    tags: 'NNP, NNP, IN, DT, NNP',
  },
  {
    text: 'simple but perfect',
    tags: 'JJ, CC, JJ',
  },
  {
    text: 'David is amazing',
    tags: 'NNP, VBZ, JJ',
  },
  {
    text: 'But just this week a peddle broke.',
    tags: 'CC, RB, DT, NN, DT, NN, VBD',
  },
  {
    text: "It's pretty ridiculous!",
    tags: 'PRP, VBZ, RB, JJ',
  },
  {
    text: 'Terrible service !!!',
    tags: 'JJ, NN',
  },
  {
    text: 'EVER !!!',
    tags: 'RB',
  },
  {
    text: 'Internet Department is rude and insulting',
    tags: 'NN, NN, VBZ, JJ, CC, JJ',
  },
  {
    text: 'I am a mental health counselor and I work with variety of mental health problems.',
    tags: 'PRP, VBP, DT, JJ, NN, NN, CC, PRP, VBP, IN, NN, IN, JJ, NN, NNS',
  },
  {
    text: 'Fantastic for kids',
    tags: 'JJ, IN, NNS',
  },
  {
    text: 'WOW !!!',
    tags: 'UH',
  },
  {
    text: 'The staff is incredibly friendly and helpful and the owner, Mimmy, is an absolute angel.',
    tags: 'DT, NN, VBZ, RB, JJ, CC, JJ, CC, DT, NN, NNP, VBZ, DT, JJ, NN',
  },
  {
    text: 'From the moment you enter the restaurant, you know you are some place special.',
    tags: 'IN, DT, NN, PRP, VBP, DT, NN, PRP, VBP, PRP, VBP, DT, NN, JJ',
  },
  {
    text: 'I have lived in Buckingham Condominiums townhouse for 2 years.',
    tags: 'PRP, VBP, VBN, IN, NNP, NNPS, NN, IN, CD, NNS',
  },
  {
    text: 'I love the location and the apartment !!',
    tags: 'PRP, VBP, DT, NN, CC, DT, NN',
  },
  {
    text: 'The maintenance people are AWESOME !!!!',
    tags: 'DT, NN, NNS, VBP, JJ',
  },
  {
    text: 'And the exterminator is very nice, also.',
    tags: 'CC, DT, NN, VBZ, RB, JJ, RB',
  },
  {
    text: 'She is a pure b**** !!!',
    tags: 'PRP, VBZ, DT, JJ, NN',
  },
  {
    text: 'I would give the Wildernest inn ten stars of five!',
    tags: 'PRP, MD, VB, DT, NNP, NNP, CD, NNS, IN, CD',
  },
  {
    text: 'There were occasional bears on the deck in the morning.',
    tags: 'EX, VBD, JJ, NNS, IN, DT, NN, IN, DT, NN',
  },
  {
    text: 'Kathy and Stewart, the proprietors were the epitome of perfection.',
    tags: 'NNP, CC, NNP, DT, NNS, VBD, DT, NN, IN, NN',
  },
  {
    text: 'Delightful, hospitable, superb, cozy and comfortable.',
    tags: 'JJ, JJ, JJ, JJ, CC, JJ',
  },
  {
    text: 'junkie lube ?!',
    tags: 'NN, NN',
  },
  {
    text: 'WOW!',
    tags: 'UH',
  },
  {
    text: 'a great vacation!',
    tags: 'DT, JJ, NN',
  },
  {
    text: 'Excellent chefs are in the kitchen preparing memorable breakfasts.',
    tags: 'JJ, NNS, VBP, IN, DT, NN, VBG, JJ, NNS',
  },
  {
    text: 'The food was finger licking the bowel fantastic ..',
    tags: 'DT, NN, VBD, NN, VBG, DT, NN, JJ',
  },
  {
    text: 'I got highlights, haircut, and a blowdry.',
    tags: 'PRP, VBD, NNS, NN, CC, DT, NN',
  },
  {
    text: 'She did a great job!',
    tags: 'PRP, VBD, DT, JJ, NN',
  },
  {
    text: 'I would call it the Taj Mahal of the east coast!',
    tags: 'PRP, MD, VB, PRP, DT, NNP, NNP, IN, DT, JJ, NN',
  },
  {
    text: 'hope this helps !!',
    tags: 'VBP, DT, VBZ',
  },
  {
    text: 'That said, I hated this restaurant.',
    tags: 'DT, VBN, PRP, VBD, DT, NN',
  },
  {
    text: 'Bramen Honda was a bit of a hassle.',
    tags: 'NNP, NNP, VBD, DT, NN, IN, DT, NN',
  },
  {
    text: 'Mr. Guerra gave me a better deal without any hassles nor any type of problems.',
    tags: 'NNP, NNP, VBD, PRP, DT, JJR, NN, IN, DT, NNS, CC, DT, NN, IN, NNS',
  },
  {
    text: 'Excellent customer service !!!',
    tags: 'JJ, NN, NN',
  },
  {
    text: 'I have finally found a mechanic I trust !!',
    tags: 'PRP, VBP, RB, VBN, DT, NN, PRP, VBP',
  },
  {
    text: 'Dr. Shady',
    tags: 'NNP, NNP',
  },
  {
    text: 'Kelly hit the nail on the head.',
    tags: 'NNP, VBD, DT, NN, IN, DT, NN',
  },
  {
    text: 'Poor Experience',
    tags: 'JJ, NN',
  },
  {
    text: "It's pretty combative actually.",
    tags: 'PRP, VBZ, RB, JJ, RB',
  },
  {
    text: "you'll love it",
    tags: 'PRP, MD, VB, PRP',
  },
  {
    text: 'Quaint, lovely, small salon with BIG personality.',
    tags: 'JJ, JJ, JJ, NN, IN, JJ, NN',
  },
  {
    text: 'The service is fast.',
    tags: 'DT, NN, VBZ, JJ',
  },
  {
    text: 'Horrible Service!',
    tags: 'JJ, NN',
  },
  {
    text: 'Superb Arrangements',
    tags: 'JJ, NNS',
  },
  {
    text: 'Oh!',
    tags: 'UH',
  },
  {
    text: 'I think 90 percent of the tenants are smokers!',
    tags: 'PRP, VBP, CD, NN, IN, DT, NNS, VBP, NNS',
  },
  {
    text: 'Chicken salad salad is great too.',
    tags: 'NNP, NN, NN, VBZ, JJ, RB',
  },
  {
    text: 'Rate a church?',
    tags: 'VB, DT, NN',
  },
  {
    text: "It's a bloody church, for chrisssake!",
    tags: 'PRP, VBZ, DT, JJ, NN, IN, NN',
  },
  {
    text: 'The pastor at this church is cool, I met him after some holiday service.',
    tags: 'DT, NN, IN, DT, NN, VBZ, JJ, PRP, VBD, PRP, IN, DT, NN, NN',
  },
  {
    text: 'The repair went quickly and the price was extremely fair.',
    tags: 'DT, NN, VBD, RB, CC, DT, NN, VBD, RB, JJ',
  },
  {
    text: 'Roger M., Woodinville',
    tags: 'NNP, NNP, NNP',
  },
  {
    text: 'I had a conversation with the woman running this place in April 2010.',
    tags: 'PRP, VBD, DT, NN, IN, DT, NN, VBG, DT, NN, IN, NNP, CD',
  },
  {
    text: 'Wow, really?',
    tags: 'UH, RB',
  },
  {
    text: 'Excellent service',
    tags: 'JJ, NN',
  },
  {
    text: 'Tiffany is fabulous!',
    tags: 'NNP, VBZ, JJ',
  },
  {
    text: 'The atmosphere was nice and very clean.',
    tags: 'DT, NN, VBD, JJ, CC, RB, JJ',
  },
  {
    text: 'To start we tried the guacamole and salsa verde, it was completly flavorless.',
    tags: 'TO, VB, PRP, VBD, DT, NN, CC, NN, NN, PRP, VBD, RB, JJ',
  },
  {
    text: 'I recommend La Hacienda',
    tags: 'PRP, VBP, NNP, NNP',
  },
  {
    text: 'Might try again',
    tags: 'MD, VB, RB',
  },
  {
    text: 'the people at Fidelity Leasing were very friendly and helpful.',
    tags: 'DT, NNS, IN, NNP, NNP, VBD, RB, JJ, CC, JJ',
  },
  {
    text: 'Fantastic Service!',
    tags: 'JJ, NN',
  },
  {
    text: 'It also came with free balance and rotation for the life of the tires!',
    tags: 'PRP, RB, VBD, IN, JJ, NN, CC, NN, IN, DT, NN, IN, DT, NNS',
  },
  {
    text: 'Pam Gillies',
    tags: 'NNP, NNP',
  },
  {
    text: 'They actually itemized it as a DISPOSAL fee.',
    tags: 'PRP, RB, VBD, PRP, IN, DT, NN, NN',
  },
  {
    text: 'One of the worst places',
    tags: 'CD, IN, DT, JJS, NNS',
  },

  {
    text: 'Wife and I attempted to adopt a dog and was nothing but frustrating.',
    tags: 'NN, CC, PRP, VBD, TO, VB, DT, NN, CC, VBD, NN, CC, JJ',
  },
  {
    text: 'They refused.',
    tags: 'PRP, VBD',
  },
  {
    text: 'College is a Joke and the Salon is a JOKE!',
    tags: 'NN, VBZ, DT, NN, CC, DT, NN, VBZ, DT, NN',
  },
  {
    text: 'You can fool people',
    tags: 'PRP, MD, VB, NNS',
  },
  {
    text: 'Very nice work and friendly guys too.',
    tags: 'RB, JJ, NN, CC, JJ, NNS, RB',
  },
  {
    text: 'New training Centre is excellent',
    tags: 'JJ, NN, NN, VBZ, JJ',
  },
  {
    text: 'Perfect Practice',
    tags: 'JJ, NN',
  },
  {
    text: 'Wonderful service for large group',
    tags: 'JJ, NN, IN, JJ, NN',
  },
  {
    text: 'We were also served salad and soda.',
    tags: 'PRP, VBD, RB, VBN, NN, CC, NN',
  },
  {
    text: 'wonderful',
    tags: 'JJ',
  },
  // {
  //   text: 'I decided it was time to grow up and made an appointment.',
  //   tags: 'PRP, VBD, PRP, VBD, NN, TO, VB, RP, CC, VBD, DT, NN',
  // },
  {
    text: 'One night was too much.',
    tags: 'CD, NN, VBD, RB, JJ',
  },
  {
    text: 'We were having a major problem in maintaining cash.',
    tags: 'PRP, VBD, VBG, DT, JJ, NN, IN, VBG, NN',
  },
  {
    text: 'Being a grocery shop, maintaining 5000 different products was a challenging job.',
    tags: 'VBG, DT, NN, NN, VBG, CD, JJ, NNS, VBD, DT, JJ, NN',
  },
  {
    text: 'Managing POS counter without barcoding was really a tough time.',
    tags: 'VBG, NN, NN, IN, NN, VBD, RB, DT, JJ, NN',
  },
  {
    text: 'The other ladies had a similar experience, both had nail polish on a couple of toes.',
    tags: 'DT, JJ, NNS, VBD, DT, JJ, NN, DT, VBD, NN, NN, IN, DT, NN, IN, NNS',
  },
  {
    text: 'I worked with Andrew for 2 months and did acupuncture and herbs.',
    tags: 'PRP, VBD, IN, NNP, IN, CD, NNS, CC, VBD, NN, CC, NNS',
  },
  {
    text: 'Friendly, clean and excellent location',
    tags: 'JJ, JJ, CC, JJ, NN',
  },
  {
    text: 'The staff was very helpful, and gave us good advice on day and night time activities.',
    tags: 'DT, NN, VBD, RB, JJ, CC, VBD, PRP, JJ, NN, IN, NN, CC, NN, NN, NNS',
  },
  {
    text: 'The location is really stellar!',
    tags: 'DT, NN, VBZ, RB, JJ',
  },
  {
    text: 'I left with a case of BRAWLER !!!!!',
    tags: 'PRP, VBD, IN, DT, NN, IN, NNP',
  },
  {
    text: 'Liars, negative stars!',
    tags: 'NNS, JJ, NNS',
  },
  {
    text: 'Great Job',
    tags: 'JJ, NN',
  },
  {
    text: 'The Peterson Family',
    tags: 'DT, NNP, NN',
  },
  {
    text: 'Poor service',
    tags: 'JJ, NN',
  },
  {
    text: 'Really ??',
    tags: 'RB',
  },
  {
    text: 'I beg to differ.',
    tags: 'PRP, VBP, TO, VB',
  },
  {
    text: 'Again, a great outing for the kids, a frustration for an out of town climber.',
    tags: 'RB, DT, JJ, NN, IN, DT, NNS, DT, NN, IN, DT, IN, IN, NN, NN',
  },
  {
    text: 'Wow!',
    tags: 'UH',
  },
  {
    text: 'Thank you Doctor Gonzales, Doctor Stout, Eva Marie and the entire staff!',
    tags: 'VBP, PRP, NNP, NNP, NNP, NNP, NNP, NNP, CC, DT, JJ, NN',
  },
  {
    text: 'Texas Roadhouse is WAY better !!',
    tags: 'NNP, NNP, VBZ, RB, JJR',
  },
  {
    text: 'Spay and neuter service.',
    tags: 'NN, CC, NN, NN',
  },
  {
    text: 'They recently surprised me a larger order.',
    tags: 'PRP, RB, VBD, PRP, DT, JJR, NN',
  },
  {
    text: 'They have a customer for life in us!',
    tags: 'PRP, VBP, DT, NN, IN, NN, IN, PRP',
  },
  {
    text: 'sheisters',
    tags: 'NNS',
  },
  {
    text: 'I paid 2 k cash for a truck with a bad motor.',
    tags: 'PRP, VBD, CD, NN, NN, IN, DT, NN, IN, DT, JJ, NN',
  },
  {
    text: "It's an adorable little store filled with lots of stationery goodness.",
    tags: 'PRP, VBZ, DT, JJ, JJ, NN, VBN, IN, NNS, IN, NN, NN',
  },
  {
    text: 'Believe me.',
    tags: 'VB, PRP',
  },
  {
    text: 'This is THE premier university in Virginia.',
    tags: 'DT, VBZ, DT, JJ, NN, IN, NNP',
  },
  {
    text: 'It is also the largest.',
    tags: 'PRP, VBZ, RB, DT, JJS',
  },
  {
    text: 'VCU has the # 1 art school in America, and EXCELS in healthcare and medical schooling.',
    tags: 'NNP, VBZ, DT, NN, CD, NN, NN, IN, NNP, CC, VBZ, IN, NN, CC, JJ, NN',
  },
  {
    text: 'A slice of heaven in winter park',
    tags: 'DT, NN, IN, NN, IN, NNP, NNP',
  },
  {
    text: 'Nice selection, very clean, friendly staff!',
    tags: 'JJ, NN, RB, JJ, JJ, NN',
  },
  {
    text: 'The staff are very friendly and conscientious.',
    tags: 'DT, NNS, VBP, RB, JJ, CC, JJ',
  },
  {
    text: 'The selection of meats, veggies and sauces is awesome too!',
    tags: 'DT, NN, IN, NNS, NNS, CC, NNS, VBZ, JJ, RB',
  },
  {
    text: 'Meats are kept VERY cold, seafood smells fresh and the serving bar is VERY clean.',
    tags: 'NNS, VBP, VBN, RB, JJ, NN, VBZ, JJ, CC, DT, NN, NN, VBZ, RB, JJ',
  },
  {
    text: 'Great Cookies, Cakes, and Customer Service',
    tags: 'JJ, NNS, NNS, CC, NN, NN',
  },
  {
    text: 'I am a college student.',
    tags: 'PRP, VBP, DT, NN, NN',
  },
  {
    text: 'I can tell she really cares and wants to help.',
    tags: 'PRP, MD, VB, PRP, RB, VBZ, CC, VBZ, TO, VB',
  },
  {
    text: 'I am SO GLAD to have found Dr. Liau.',
    tags: 'PRP, VBP, RB, JJ, TO, VB, VBN, NNP, NNP',
  },
  {
    text: 'Bowtie has filled that role nicely.',
    tags: 'NNP, VBZ, VBN, DT, NN, RB',
  },
  {
    text: 'A great cinema in a great location.',
    tags: 'DT, JJ, NN, IN, DT, JJ, NN',
  },
  {
    text: 'Thank you, Bowtie!',
    tags: 'VBP, PRP, NNP',
  },
  {
    text: 'Great name for a great store!',
    tags: 'JJ, NN, IN, DT, JJ, NN',
  },
  {
    text: 'Definitely go see them!',
    tags: 'RB, VB, VB, PRP',
  },
  {
    text: 'Will look beautiful.',
    tags: 'MD, VB, JJ',
  },
  {
    text: 'Are they serious?',
    tags: 'VBP, PRP, JJ',
  },
  {
    text: 'Thank you!',
    tags: 'VBP, PRP',
  },
  {
    text: 'The food is excellent, the serivce is horrible.',
    tags: 'DT, NN, VBZ, JJ, DT, NN, VBZ, JJ',
  },
  {
    text: 'I was booked for 2 nights at this hotel in Oct 2007.',
    tags: 'PRP, VBD, VBN, IN, CD, NNS, IN, DT, NN, IN, NNP, CD',
  },
  {
    text: 'Worst Apartments EVER',
    tags: 'JJS, NNS, RB',
  },
  {
    text: 'I have worked with Ted Jurek at Decor and You, and it started out as a decent experience.',
    tags: 'PRP, VBP, VBN, IN, NNP, NNP, IN, NNP, CC, NNP, CC, PRP, VBD, RP, IN, DT, JJ, NN',
  },
  {
    text: 'I figure I would give this company a chance.',
    tags: 'PRP, VBP, PRP, MD, VB, DT, NN, DT, NN',
  },
  {
    text: 'This company is way too expensive with nothing to show for it.',
    tags: 'DT, NN, VBZ, RB, RB, JJ, IN, NN, TO, VB, IN, PRP',
  },
  {
    text: 'Horrible.',
    tags: 'JJ',
  },
  {
    text: 'Horrible.',
    tags: 'JJ',
  },
  {
    text: 'Imagine a hotel having problems with people.',
    tags: 'VB, DT, NN, VBG, NNS, IN, NNS',
  },
  {
    text: "He said he's had a long and bad day.",
    tags: 'PRP, VBD, PRP, VBZ, VBN, DT, JJ, CC, JJ, NN',
  },
  {
    text: 'I came to find out the person was the hotel OWNER also.',
    tags: 'PRP, VBD, TO, VB, RP, DT, NN, VBD, DT, NN, NN, RB',
  },
  {
    text: 'I thought the UK was completely devoid of good NYC style pizza.',
    tags: 'PRP, VBD, DT, NNP, VBD, RB, JJ, IN, JJ, NNP, NN, NN',
  },
  {
    text: 'Good food, good wait staff, poor management',
    tags: 'JJ, NN, JJ, NN, NN, JJ, NN',
  },
  {
    text: 'Sorry for interrupting I guess.',
    tags: 'JJ, IN, VBG, PRP, VBP',
  },
  {
    text: 'IT HAS VERY GOOD PRICES.',
    tags: 'PRP, VBZ, RB, JJ, NNS',
  },
  {
    text: 'Identity Theft',
    tags: 'NN, NN',
  },
  {
    text: 'A girl would show up, then a guy in a nice car would show up.',
    tags: 'DT, NN, MD, VB, RP, RB, DT, NN, IN, DT, JJ, NN, MD, VB, RP',
  },
  {
    text: 'Short time later the guy would leave, then the girl.',
    tags: 'JJ, NN, RBR, DT, NN, MD, VB, RB, DT, NN',
  },
  {
    text: 'It sucked having an SUV.',
    tags: 'PRP, VBD, VBG, DT, NN',
  },
  {
    text: 'Bugs were a small problem, nothing too bad.',
    tags: 'NNS, VBD, DT, JJ, NN, NN, RB, JJ',
  },
  {
    text: 'I hope I can return the favor in the future!',
    tags: 'PRP, VBP, PRP, MD, VB, DT, NN, IN, DT, NN',
  },
  {
    text: 'Alan Grissom',
    tags: 'NNP, NNP',
  },
  {
    text: 'Room ok.',
    tags: 'NN, JJ',
  },
  {
    text: 'THIS STORY IS 100 % TRUE.',
    tags: 'DT, NN, VBZ, CD, NN, JJ',
  },
  {
    text: 'Unlike Saratoga.',
    tags: 'IN, NNP',
  },
  {
    text: '- R. Morris.',
    tags: 'NNP, NNP',
  },
  {
    text: 'Favorite place in Tampa.',
    tags: 'JJ, NN, IN, NNP',
  },
  {
    text: 'AMAZING!',
    tags: 'JJ',
  },
  {
    text: 'I frequent this resturant on a weekly basis but usally only for lunch.',
    tags: 'PRP, VBP, DT, NN, IN, DT, JJ, NN, CC, RB, RB, IN, NN',
  },
  {
    text: 'We were greeted again and sat promptly.',
    tags: 'PRP, VBD, VBN, RB, CC, VBD, RB',
  },
  {
    text: 'AMAZING!',
    tags: 'JJ',
  },
  {
    text: 'I have to say the value of this place always amazes me.',
    tags: 'PRP, VBP, VB, VB, DT, NN, IN, DT, NN, RB, VBZ, PRP',
  },
  {
    text: 'Great work and honest establishment!',
    tags: 'JJ, NN, CC, JJ, NN',
  },
  {
    text: 'The service was excellent and personable.',
    tags: 'DT, NN, VBD, JJ, CC, JJ',
  },
  {
    text: 'We made the decision for a couple of reasons.',
    tags: 'PRP, VBD, DT, NN, IN, DT, NN, IN, NNS',
  },
  {
    text: 'Excellent service and quality',
    tags: 'JJ, NN, CC, NN',
  },
  {
    text: 'Friendly staff, but definitely some problems',
    tags: 'JJ, NN, CC, RB, DT, NNS',
  },
  {
    text: 'May, 2009.',
    tags: 'NNP, CD',
  },
  {
    text: 'Next day got moved into another room, on the same floor with other wedding guests.',
    tags: 'JJ, NN, VBD, VBN, IN, DT, NN, IN, DT, JJ, NN, IN, JJ, NN, NNS',
  },
  {
    text: 'The service stunk.',
    tags: 'DT, NN, VBD',
  },
  {
    text: 'We were standing in the store for 20 minutes to simply pick up an order.',
    tags: 'PRP, VBD, VBG, IN, DT, NN, IN, CD, NNS, TO, RB, VB, RP, DT, NN',
  },
  {
    text: 'Terrible Service',
    tags: 'JJ, NN',
  },
  {
    text: "One of the worst experiences I've ever had with a auto repair shop.",
    tags: 'CD, IN, DT, JJS, NNS, PRP, VBP, RB, VBN, IN, DT, NN, NN, NN',
  },
  {
    text: 'Bad for business.',
    tags: 'JJ, IN, NN',
  },
  {
    text: 'The Salon Experience from Hell',
    tags: 'DT, NN, NN, IN, NNP',
  },
  {
    text: 'Absolute Nightmare!',
    tags: 'JJ, NN',
  },
  {
    text: 'Very unhappy ...',
    tags: 'RB, JJ',
  },
  {
    text: 'Sketchy, right?',
    tags: 'JJ, JJ',
  },
  {
    text: 'I waited.',
    tags: 'PRP, VBD',
  },
  {
    text: 'And waited.',
    tags: 'CC, VBD',
  },
  {
    text: 'Poor Service',
    tags: 'JJ, NN',
  },
  {
    text: 'Excellent Driving School',
    tags: 'JJ, NN, NN',
  },
  {
    text: '....... the rest was history!',
    tags: 'DT, NN, VBD, NN',
  },
  {
    text: 'And every entree we have ordered is perfect.',
    tags: 'CC, DT, NN, PRP, VBP, VBN, VBZ, JJ',
  },
  {
    text: 'The staff is also just so pleasant to deal with.',
    tags: 'DT, NN, VBZ, RB, RB, RB, JJ, TO, VB, IN',
  },
  {
    text: 'Karla Ferguson-Granger',
    tags: 'NNP, NNP, NNP',
  },
  {
    text: 'I had a surgery date of July 17, 2008.',
    tags: 'PRP, VBD, DT, NN, NN, IN, NNP, CD, CD',
  },
  {
    text: 'He said it sarcastically.',
    tags: 'PRP, VBD, PRP, RB',
  },
  {
    text: "Dumbest F'ers ever",
    tags: 'JJS, NNS, RB',
  },
  {
    text: "And he says: You're at Warwick in Pennsylvania?",
    tags: 'CC, PRP, VBZ, PRP, VBP, IN, NNP, IN, NNP',
  },
  {
    text: 'I say, NO, I am at the RADISON WARWICK HOTEL in Rittenhouse Square.',
    tags: 'PRP, VBP, UH, PRP, VBP, IN, DT, NNP, NNP, NNP, IN, NNP, NNP',
  },
  {
    text: 'He says, I have to have an exact ADDRESS.',
    tags: 'PRP, VBZ, PRP, VBP, VB, VB, DT, JJ, NN',
  },
  {
    text: 'We heard nothing.',
    tags: 'PRP, VBD, NN',
  },
  {
    text: 'I WAS calling about one board !!',
    tags: 'PRP, VBD, VBG, IN, CD, NN',
  },
  {
    text: 'I put the coffee thing in hot water and settled for a cup of weak coffee.',
    tags: 'PRP, VBD, DT, NN, NN, IN, JJ, NN, CC, VBD, IN, DT, NN, IN, JJ, NN',
  },
  {
    text: 'Free parking.',
    tags: 'JJ, NN',
  },
  {
    text: 'Quit with the overstatements!',
    tags: 'VB, IN, DT, NNS',
  },
  {
    text: 'Do other brides fall for this ???',
    tags: 'VBP, JJ, NNS, VB, IN, DT',
  },
]
