import test from 'tape'
import nlp from '../_lib.js'
const here = '[two/root-match] '

test('root-verb', function (t) {
  let arr = [
    ['She dances gracefully.', '{dance}'],
    ['They have been studying for hours.', '{study}'],
    ['The cat slept on the sofa.', '{sleep}'],
    ['I will visit my grandparents next week.', '{visit}'],
    ["You shouldn't drive so fast.", '{drive}'],
    ['Birds were chirping in the morning.', '{chirp}'],
    ['The children often play in the park.', '{play}'],
    ['We might go to the cinema tonight.', '{go}'],
    ["He doesn't understand the question.", '{understand}'],
    ['They ran quickly to catch the bus.', '{run}'],
    ['She has painted her room blue.', '{paint}'],
    ['You are listening to the radio.', '{listen}'],
    ["They'll bake a cake for the party.", '{bake}'],
    ["I haven't seen this movie yet.", '{see}'],
    ['The dog barks loudly at strangers.', '{bark}'],
    ['We were swimming in the ocean.', '{swim}'],
    ['She will write a book one day.', '{write}'],
    // ['They have traveled around the world.', '{travel}'],
    ['The teacher is explaining the lesson.', '{explain}'],
    ['He tried to open the door.', '{try}'],
    ['He climbs the mountain every year.', '{climb}'],
    ['They had forgotten their passports at home.', '{forget}'],
    ['I will be cooking dinner when you arrive.', '{cook}'],
    ['You sing beautifully.', '{sing}'],
    ['She had been reading for two hours.', '{read}'],
    ['We enjoy watching movies on weekends.', '{enjoy}'],
    ['The sun rises in the east.', '{rise}'],
    ['They will have completed the project by then.', '{complete}'],
    ['He is wearing a new shirt.', '{wear}'],
    ['I dream of traveling to Paris.', '{dream}'],
    ["The baby cries when she's hungry.", '{cry}'],
    ['They used to live in New York.', '{live}'],
    ['The gardener is planting new flowers.', '{plant}'],
    ['She will have been working there for five years.', '{work}'],
    ['The boys threw the ball in the yard.', '{throw}'],
    ["I was wondering if you'd like to join us.", '{wonder}'],
    ['Birds fly south for the winter.', '{fly}'],
    ['They have bought a new car.', '{buy}'],
    ['She is considering studying abroad.', '{consider}'],
    ['You have grown since I last saw you.', '{grow}'],
    ['The chef prepares delicious meals.', '{prepare}'],
    ['She had hoped to see him again.', '{hope}'],
    ["I've been waiting for this moment.", '{wait}'],
    ['The tree sheds its leaves in autumn.', '{shed}'],
    ['He will give a speech at the conference.', '{give}'],
    ['She knits in her free time.', '{knit}'],
    ['They laughed at the joke.', '{laugh}'],
    ['You should eat healthy foods.', '{eat}'],
    ["I've always loved the rain.", '{love}'],
    ['The artist is drawing a portrait.', '{draw}'],
    ['They had sung in the choir.', '{sing}'],
    ["The door won't open.", '{open}'],
    ['The cat hunts at night.', '{hunt}'],
    ['She has been wanting to see that movie.', '{want}'],
    ['We had driven all night.', '{drive}'],
    ["I'll bring snacks to the party.", '{bring}'],
    ['The students are learning about history.', '{learn}'],
    ["You shouldn't lie to your friends.", '{lie}'],
    ['He builds models as a hobby.', '{build}'],
    ['They were watching the sunset.', '{watch}'],
    ['The horse gallops across the field.', '{gallop}'],
    ['I usually drink tea in the morning.', '{drink}'],
    ['The river flows through the city.', '{flow}'],
    ['She has always admired her sister.', '{admire}'],
    ['I was running when I tripped.', '{run}'],
    ['You are going to love this show.', '{love}'],
    ['She hides her diary under the bed.', '{hide}'],
    ["They've always believed in kindness.", '{believe}'],
    ["I'll be taking the train tomorrow.", '{take}'],
    ["You've changed a lot over the years.", '{change}'],

    ['The wind blows strongly at night.', '{blow}'],
    ['She always smiles when she sees him.', '{smile}'],
    ["I'll be joining the club next week.", '{join}'],
    ["They've been practicing for the competition.", '{practice}'],
    ['The fish swims swiftly in the stream.', '{swim}'],
    ['I have decided to take the job.', '{decide}'],
    ['You were listening to music all night.', '{listen}'],
    ['He often dreams about flying.', '{dream}'],
    ['She will be performing on stage.', '{perform}'],
    ['The children usually skip rope during recess.', '{skip}'],
    ["I've missed the bus again.", '{miss}'],
    ['The sun sets beautifully over the horizon.', '{set}'],
    ['She was crying over the sad movie.', '{cry}'],
    ['The students often discuss their projects.', '{discuss}'],
    // ["I'll be traveling to Spain next month.", '{travel}'],
    ['The bird often perches on that branch.', '{perch}'],
    ["You've been working really hard lately.", '{work}'],
    ['The phone rings incessantly.', '{ring}'],
    ['She was always teasing her younger brother.', '{tease}'],
    ["I've baked cookies for the party.", '{bake}'],
    ['He is going to propose tonight.', '{propose}'],
    ["They've been thinking about moving out.", '{think}'],
    ['I was playing video games last night.', '{play}'],
    ['The dog always chases the postman.', '{chase}'],
    ['The flowers bloom in spring.', '{bloom}'],
    ['He will have written three books by next year.', '{write}'],
    ['She has never tasted such delicious ice cream.', '{taste}'],
    ["I'm often hiking in the mountains.", '{hike}'],
    ['The baby was crawling towards the toy.', '{crawl}'],
    ['They always celebrate their anniversary.', '{celebrate}'],
    ['The mechanic fixes cars.', '{fix}'],
    ['I will have finished my work by then.', '{finish}'],
    ['She sings in the shower every morning.', '{sing}'],
    ['The tree has grown so tall over the years.', '{grow}'],
    ['You were always encouraging me.', '{encourage}'],
    ["I'm planning a trip to the beach.", '{plan}'],
    ['They have never understood the concept.', '{understand}'],
    ['She collects stamps from different countries.', '{collect}'],
    ['You were laughing so hard at that joke.', '{laugh}'],
    ['The kids love playing in the snow.', '{play}'],
    ["She'll be attending the workshop next week.", '{attend}'],
    ["I've often wondered about the universe.", '{wonder}'],
    ['They dive into the pool every summer.', '{dive}'],
    ['The cat always scratches the furniture.', '{scratch}'],
    ["He'll be dancing at the event.", '{dance}'],
    ["You've inspired many people.", '{inspire}'],
    ["She's always cherished those memories.", '{cherish}'],
    ['The rain pours heavily in the monsoon.', '{pour}'],
    ["They've always admired her courage.", '{admire}'],
    ["I've been waiting here for hours.", '{wait}'],
    ['He often jogs in the park.', '{jog}'],
    // ['The horse galloped across the meadow.', '{gallop}'],
    ["She's been knitting a scarf.", '{knit}'],
    ['You always brighten my day.', '{brighten}'],
    ['They will have invested a lot by then.', '{invest}'],
    ['The snake slithered across the ground.', '{slither}'],
    ['She adores her pet cat.', '{adore}'],
    ['I was cleaning my room when you called.', '{clean}'],
    ['Birds chirp every morning.', '{chirp}'],
    ['I will be flying to London next week.', '{fly}'],
    ["You've amazed everyone with your talent.", '{amaze}'],
    ['They were shopping all day.', '{shop}'],
    ["He's been researching this topic for months.", '{research}'],
    ['I always cherish our time together.', '{cherish}'],
    ['The teacher enlightens students with knowledge.', '{enlighten}'],
    ['She will be cooking for the party.', '{cook}'],
    ['The river meanders through the valley.', '{meander}'],
    ["I've been humming that song all day.", '{hum}'],
    ['You often inspire those around you.', '{inspire}'],
    ['The deer grazed in the meadow.', '{graze}'],
    ["I've booked a table for tonight.", '{book}'],
    ['They will be celebrating their victory.', '{celebrate}'],
    ['The clock ticks every second.', '{tick}'],
    ['She was watching her favorite show.', '{watch}'],
    ['I often swim in the lake.', '{swim}'],
    ['The stars shimmer in the night sky.', '{shimmer}'],
    ['You have been teaching for a decade.', '{teach}'],
    ['The wind whispered through the trees.', '{whisper}'],
    ["He'll be painting the wall tomorrow.", '{paint}'],
    ['They always applaud after the performance.', '{applaud}'],
    ["I've danced since I was five.", '{dance}'],
    ['The bird soared high in the sky.', '{soar}'],
    ["She's been collecting coins for years.", '{collect}'],
    ['I always rely on my instincts.', '{rely}'],
    ['The sun blazes in the summer.', '{blaze}'],
    ['He always whistles while working.', '{whistle}'],
    ["They've been hiking up the mountain.", '{hike}'],
    ['I was sketching the landscape.', '{sketch}'],
    ['The dog wags its tail when happy.', '{wag}'],
    ['You should always respect your elders.', '{respect}'],
    ['The leaves rustle in the wind.', '{rustle}'],
    ["I've been daydreaming a lot lately.", '{daydream}'],
    ['They will be camping this weekend.', '{camp}'],
    ['The baby giggles when tickled.', '{giggle}'],
    ["He's been composing music since college.", '{compose}'],
    ['The bee buzzes around the flowers.', '{buzz}'],
    ['She will be translating the document.', '{translate}'],
    ['They were clapping for the winner.', '{clap}'],
    ["I often marvel at nature's beauty.", '{marvel}'],
  ]

  arr.forEach(a => {
    let [str, m] = a
    let doc = nlp(str)
    t.equal(doc.has(m), true, here + str)
  })
  t.end()
})
