import test from 'tape'
import nlp from '../_lib.js'
const here = '[two/freeze-lex] '

test('internal freezeLex', function (t) {
  let arr = [
    ['tiger woods', 'Person'],
    ['houston astros', 'SportsTeam'],
    ['top notch', 'Adjective'],
    ['cold war', 'Noun'],
    ['excuse me', 'Expression'],
    ['chick fil-a', 'Organization'],
    ['financial times', 'Organization'],
    ['guns n roses', 'Organization'],
    ['la z boy', 'Organization'],
    ['labour party', 'Organization'],
    // ['new kids on the block', 'Organization'],
    ['new york times', 'Organization'],
    ['the guess who', 'Organization'],
    ['thin lizzy', 'Organization'],
    ['prime minister', 'Actor'],
    ['free market', 'Singular'],
    ['lay up', 'Singular'],
    ['living room', 'Singular'],
    ['spin off', 'Singular'],
    ['appeal court', 'Uncountable'],
    ['cold war', 'Uncountable'],
    ['gene pool', 'Uncountable'],
    ['machine learning', 'Uncountable'],
    ['nail polish', 'Uncountable'],
    ['time off', 'Uncountable'],
    ['take part', 'Infinitive'],
    ['bill gates', 'Person'],
    ['doctor who', 'Person'],
    ['he man', 'Person'],
    ['iron man', 'Person'],
    ['kid cudi', 'Person'],
    ['run dmc', 'Person'],
    ['rush limbaugh', 'Person'],
    ['snow white', 'Person'],
    ['brand new', 'Adjective'],
    ['en route', 'Adjective'],
    ['off guard', 'Adjective'],
    ['on board', 'Adjective'],
    ['so called', 'Adjective'],
    ['spot on', 'Adjective'],
    ['straight forward', 'Adjective'],
    ['super duper', 'Adjective'],
    ['tip top', 'Adjective'],
    ['top notch', 'Adjective'],
    ['up to date', 'Adjective'],
    ['win win', 'Adjective'],
    ['atlanta united', 'SportsTeam'],

    // ['try in', 'PhrasalVerb'],
    // ['try off', 'PhrasalVerb'],
    // ['try on', 'PhrasalVerb'],
    // ['try out', 'PhrasalVerb'],
    ['iron maiden', 'ProperNoun'],
    ['new york state', 'Region'],
    ['prince edward island', 'Region'],
    ["cote d'ivoire", 'Country'],
    ['isle of man', 'Country'],
    ['united states', 'Country'],
    ['u.s. virgin islands', 'Country'],
    ['united states of america', 'Country'],
    ['cedar breaks', 'Place'],
    ['cedar falls', 'Place'],
    ['point blank', 'Adverb'],
    ['tiny bit', 'Adverb'],
    ['as soon as', 'Conjunction'],
    ['by the time', 'Conjunction'],
    ['no matter', 'Conjunction'],
    ['will like', 'Verb'],
    ['will refine', 'Verb'],
    ['took part', 'PastTense'],
    ['takes part', 'PresentTense'],
    ['taking part', 'Gerund'],
    ['will take part', 'Verb'],
    ['taken part', 'Participle'],
  ]
  arr.forEach(a => {
    let [str, tag] = a
    let doc = nlp(str)
    t.equal(doc.has('^#' + tag + '+$'), true, here + str)
  })
  t.end()
})
