import test from 'tape'
import nlp from '../_lib.js'
const here = '[two/had-would] '

test('had-would', function (t) {
  let arr = [
    ["He'd love to join us for dinner", 'would'],
    ["She'd already finished her work when I arrived", 'had'],
    ["I'd like a cup of coffee, please", 'would'],
    ["They'd never been to that restaurant before", 'had'],
    ["We'd appreciate your help with the project", 'would'],
    ["He'd visited the museum last summer", 'had'],
    ["I'd seen that movie before", 'had'],
    ["She'd be happy to help you with your request", 'would'],
    ["He'd always wanted to learn how to play the piano", 'had'],
    ["I'd never met someone so talented", 'had'],
    ["She'd forgotten to bring her umbrella", 'had'],
    ["They'd finished the task before the deadline", 'had'],
    ["We'd already made plans for the weekend", 'had'],
    ["He'd promised to call me later", 'had'],
    ["I'd never have guessed that he was so skilled", 'would'],
    ["She'd do anything to make her dream come true", 'would'],
    ["I'd visited that city once before", 'had'],
    ["He'd achieved a lot in his career", 'had'],
    ["She'd always known that it was a risky venture", 'had'],
    ["I'd seen this movie a long time ago", 'had'],
    ["They'd never imagined it would turn out like this", 'had'],
    ["We'd already started working on the project", 'had'],
    ["He'd promised to help us with the move", 'had'],
    ["I'd be happy to assist you with your request", 'would'],
    ["She'd done everything she could to succeed", 'had'],
    ["He'd said he would come to the party", 'had'],
    ["I'd never thought of it that way before", 'had'],
    ["They'd always wanted to travel the world", 'had'],
    ["She'd been waiting for this moment her whole life", 'had'],
    ["I'd love to hear your thoughts on this matter", 'would'],
    ["He'd already finished his meal when I arrived", 'had'],
    ["I'd seen that painting in a gallery before", 'had'],
    ["She'd made a mistake in her calculations", 'had'],
    ["He'd do anything to make her happy", 'would'],
    ["I'd never experienced anything like that before", 'had'],
    ["She'd completed the assignment ahead of schedule", 'had'],
    ["They'd always dreamed of owning a beach house", 'had'],
    ["I'd be surprised if he didn't show up", 'would'],
    ["She'd said she would be here by 5 PM", 'had'],
    ["He'd always known that this day would come", 'had'],
    ["I'd already made other plans for the weekend", 'had'],
    ["She'd studied for hours before the exam", 'had'],
    ["I'd never seen such a beautiful sunset", 'had'],
    // ["He'd never let us down before", 'had'],
    ["She'd do anything for her family", 'would'],
    ["I'd been there once before", 'had'],
    ["They'd finished the race in record time", 'had'],
    ["He'd already seen the movie", 'had'],
    ["She'd always wanted to learn how to dance", 'had'],
    ["I'd be surprised if they didn't win", 'would'],
    ["They'd never tried sushi before", 'had'],
    ["We'd love to have you at the party", 'would'],
    ["He'd promised to help with the move", 'had'],
    ["She'd finished her work by noon", 'had'],
    ["I'd never thought of it that way", 'had'],
    ["We'd be happy to assist you", 'would'],
    ["He'd already decided on a career path", 'had'],
    ["She'd always known it was a risky investment", 'had'],
    ["They'd never been to that part of the city before", 'had'],
    ["I'd seen that play performed live", 'had'],
    ["He'd said he'd come to the event", 'had'],
    ["She'd always wanted to travel to Asia", 'had'],
    ["I'd be surprised if he didn't show up", 'would'],
    ["They'd completed the project ahead of schedule", 'had'],
    ["We'd appreciate your feedback", 'would'],
    ["He'd always dreamed of owning a sports car", 'had'],
    ["She'd already made dinner when I arrived", 'had'],
    ["I'd love to visit that museum", 'would'],
    ["He'd achieved a lot in his career", 'had'],
    ["I'd never met someone so knowledgeable", 'had'],
    ["She'd always known she wanted to be a doctor", 'had'],
    ["They'd never seen anything like it before", 'had'],
    ["We'd never imagined it would be so challenging", 'had'],
    ["He'd promised he'd call as soon as he arrived", 'had'],
    ["I'd always wanted to learn how to play the guitar", 'had'],
    ["She'd already finished her meal when I got there", 'had'],
    ["I'd seen that movie a long time ago", 'had'],
    ["He'd always wanted to start his own business", 'had'],
    ["She'd be happy to assist you with your request", 'would'],
    ["They'd completed the task in record time", 'had'],
    ["We'd love to hear your thoughts on this matter", 'would'],
    ["He'd do anything to make her happy", 'would'],
    ["I'd seen that painting in a gallery before", 'had'],
    ["She'd already made plans for the weekend", 'had'],
    ["I'd never been to that part of the country before", 'had'],
    ["They'd always dreamed of living by the ocean", 'had'],
    ["We'd already started working on the project", 'had'],
    ["He'd promised to help us with the move", 'had'],
    ["I'd love to hear more about your experiences", 'would'],
    ["She'd already decided on a new career path", 'had'],
    ["They'd never encountered such a challenge before", 'had'],
    ["We'd appreciate any assistance you can provide", 'would'],
    ["He'd always known that this day would come", 'had'],
    ["I'd seen that movie several times before", 'had'],
    ["She'd always wanted to learn how to cook", 'had'],
    ["They'd already made plans for the weekend", 'had'],
  ]

  arr.forEach(a => {
    let doc = nlp(a[0])
    t.equal(doc.has(a[1]), true, here + a[0])
  })
  t.end()
})
