import test from 'tape'
import nlp from '../_lib.js'
const here = '[three/verb-toPresent] '

test('toPresent:', function (t) {
  let arr = [
    // known forms:
    ['he walked', 'he walks'],
    ['i walked', 'i walk'],
    ['we walked', 'we walk'],
    ['they walked', 'they walk'],
    ['the friends walked', 'the friends walk'],
    ['the friend walked', 'the friend walks'],
    ['our users walked', 'our users walk'],
    ['our user walked', 'our user walks'],
    ['the eye closed', 'the eye closes'],
    ['the eyes closed', 'the eyes close'],

    // copula forms
    ['i am not cool', 'i am not cool'],
    ['i was not cool', 'i am not cool'],
    ['i will not be cool', 'i am not cool'],
    ['he is not cool', 'he is not cool'],
    ['he was not cool', 'he is not cool'],
    ['he will not be cool', 'he is not cool'],
    ['they are not cool', 'they are not cool'],
    ['they were not cool', 'they are not cool'],
    ['they will not be cool', 'they are not cool'],

    ['their colloseum will open', 'their colloseum opens'],
    ['their children will open', 'their children open'],

    ['he walks', 'he walks'],
    ['he walked', 'he walks'],
    ['he will walk', 'he walks'],
    ['he is walking', 'he is walking'],
    ['he was walking', 'he is walking'],
    ['i was walking', 'i am walking'],
    ['we were walking', 'we are walking'],
    ['i am walking', 'i am walking'],
    ['he will be walking', 'he is walking'],
    ['he really will be walking', 'he really is walking'],
    ['he will really be walking', 'he is really walking'],
    ['he will be really walking', 'he is really walking'],
    //
    // ['he has walked', 'he has walked'],
    ['he had walked', 'he has walked'],
    ['he will have walked', 'he has walked'],
    ['he really will have walked', 'he really has walked'],
    ['he will really have walked', 'he has really walked'],
    ['he will have really walked', 'he has really walked'],

    ['he has been walking', 'he has been walking'],
    ['he had been walking', 'he has been walking'],
    ['he will have been walking', 'he has been walking'],
    ['he really will have been walking', 'he really has been walking'],
    ['he will really have been walking', 'he has really been walking'],
    ['he will have really been walking', 'he has really been walking'],
    ['he will have been really walking', 'he has been really walking'],

    ['he got walked', 'he is walked'],
    ['we got walked', 'we are walked'],
    ['i got walked', 'i am walked'],
    ['he was walked', 'he is walked'],
    ['i was walked', 'i am walked'],
    ['soldiers were walked', 'soldiers are walked'],

    ['i am being walked', 'i am being walked'],
    ['we are being walked', 'we are being walked'],
    ['was being walked', 'is being walked'],
    ['had been walked', 'is being walked'],
    // ['has been walked', 'is being walked'], //?
    ['have been walked', 'is being walked'],
    ['usually really walked often', 'usually really walks often'],
    ['were walked', 'are walked'],
    ['was being walked', 'is being walked'],
    // // ['has been walked', 'had been walked'],
    ['had been walked', 'is being walked'],
    // ['will have been walked', 'has been walked'],
    ['will be walked', 'is being walked'],
    ['he used to walk', 'he is walking'],
    ['he did walk', 'he does walk'],
    ['he must walk', 'he must walk'],
    ['he must have walked', 'he must walk'],
    ['he could have walked', 'he could walk'],

    ['would be walked', 'would be walked'],
    ['would have been walked', 'would be walked'],
    ['is going to walk', 'is walking'],
    ['did walk', 'does walk'],
    ['used to walk', 'is walking'],
    // ['do walk', 'did walk'],
    ['does walk', 'does walk'],

    // want-infinitive
    ['he wants to walk', 'he wants to walk'],
    ['he wanted to walk', 'he wants to walk'],
    ['he will want to walk', 'he wants to walk'],

    //past->pres
    ['i wrote', 'i write'],
    ['she wrote', 'she writes'],
    ['we wrote', 'we write'],
    ['they wrote', 'they write'],
    ['it wrote', 'it writes'],
    //future->pres
    ['i will go', 'i go'],
    ['she will go', 'she goes'],
    ['we will go', 'we go'],
    ['they will go', 'they go'],
    ['it will go', 'it goes'],
    //past+adv->pres
    ['i nearly slipped', 'i nearly slip'],
    ['she nearly slipped', 'she nearly slips'],
    ['we nearly slipped', 'we nearly slip'],
    ['they nearly slipped', 'they nearly slip'],
    ['it nearly slipped', 'it nearly slips'],
    //adv+past->pres
    ['i really learned from it', 'i really learn from it'],
    ['he really learned from it', 'he really learns from it'],
    ['everybody really learned from it', 'everybody really learns from it'],
    ['someone really learned from it', 'someone really learns from it'],
    ['eventually, i will learn from it', 'eventually, i learn from it'],
    // neg->pres
    // ['i did not really yell', 'i do not really yell'],
    // ['i do not really yell', 'i do not really yell'],
    // ['i never yell', 'i never yell'],
    // ['i never yelled', 'i never yelled'],
    ['i spoke quickly', 'i speak quickly'],
    ['i do not speak quickly', 'i do not speak quickly'],
    // ['he will never yell', 'he never yells'],
    // ['he never yelled', 'he never yelled'],
    ['he spoke quickly', 'he speaks quickly'],
    ['he did not speak quickly', 'he does not speak quickly'],
    ['we did not speak quickly', 'we do not speak quickly'],
    ['we spoke quickly', 'we speak quickly'],
    ['it spoke quickly', 'it speaks quickly'],
    // copula
    [`i am there`, 'i am there'],
    [`i was there`, 'i am there'],
    [`i will be there`, 'i am there'],
    [`spencer is there`, 'spencer is there'],
    [`spencer was there`, 'spencer is there'],
    [`spencer will be there`, 'spencer is there'],
    [`we are there`, 'we are there'],
    [`we were there`, 'we are there'],
    [`we will be there`, 'we are there'],
    // * -> pres
    [`i do not see it`, `i do not see it`],
    [`i see it clearly`, `i see it clearly`],
    [`i saw it clearly`, `i see it clearly`],
    [`he saw it`, `he sees it`],
    [`he saw it clearly`, `he sees it clearly`],
    [`he sees it clearly`, `he sees it clearly`],
    [`they see it clearly`, `they see it clearly`],
    [`they really saw it`, `they really see it`],
    [`he will really see it`, `he really sees it`],
    ['toronto barely started', 'toronto barely starts'],
    ['toronto hardly even started', 'toronto hardly even starts'],
    // ['toronto did not even start', 'toronto does not even start'],
    ['people will seldom start looking', 'people seldom start looking'],
    ['people seldom started looking', 'people seldom start looking'],
    ['he clearly did not suggest', 'he clearly does not suggest'],
    ['they clearly did not suggest', 'they clearly do not suggest'],
    ['the library did not provide', 'the library does not provide'],
    // ['the library clearly will not provide', 'the library clearly does not provide'],
    // ['this union had disrupted', 'this union has disrupted'],
    ['john wrote everyday', 'john writes everyday'],
    // ['spencer and john wrote everyday', 'spencer and john write everyday'],

    ['there was no hope', 'there is no hope'],
    ['there will be no hope', 'there is no hope'],
    ['there is no hope', 'there is no hope'],

    // present-perfect -> present hmm
    // [`the yankees had gone`, `the yankees go`],
    [`the yankees have gone`, `the yankees go`],
    // gerund-phrase
    [`he starts seeing`, `he starts seeing`],
    [`he started seeing`, `he starts seeing`],
    [`he will start seeing`, `he starts seeing`],
    [`we start seeing`, `we start seeing`],
    [`we started seeing`, `we start seeing`],
    [`we will start seeing`, `we start seeing`],
    [`we have started seeing`, `we start seeing`],
    [`we will have started seeing`, `we start seeing`],


    // contractions
    // [`i'm good`, `i'm good`],
    [`i'd go`, `i'd go`],
    [`i've gone`, `i go`],
    [`we've gone`, `we go`],
    [`we've walked`, `we walk`],
    [`he'll go`, `he goes`],
    [`he'll walk`, `he walks`],
    [`they've seen`, `they see`],
    [`they were good`, 'they are good'],

    // ["has been considering a new strategy", `Considers a new strategy`],
    // ["will be going to the concert tonight", `Goes to the concert`],
    // ["was just making a cup of coffee", `Makes a cup of coffee`],
    // ["must have forgotten the appointment", `Forgets the appointment`],
    // ["can jump higher than anyone else", `Jumps higher than anyone else`],
    // ["could have been mistaken about the time", `Mistakes the time`],
    // ["would be flying to Paris next month", `Flies to Paris`],
    // ["should have started the project earlier", `Starts the project`],
    // ["is planning to visit the museum", `Plans to visit the museum`],
    // ["has been dreaming about a vacation", `Dreams about a vacation`],
    // ["might be moving to a different city", `Moves to a different city`],
    // ["was reading a fascinating book", `Reads a fascinating book`],
    // ["could play the guitar beautifully", `Plays the guitar beautifully`],
    // ["will have finished the report by tomorrow", `Finishes the report`],
    // ["has been working out regularly", `Works out regularly`],
    // ["was going to call you later", `Calls you later`],
    // ["might have left the keys in the car", `Leaves the keys in the car`],
    // ["is starting to understand the concept", `Starts to understand the concept`],
    // ["should be doing the homework now", `Does the homework`],
    // ["would have been upset if you didn't show up", `Gets upset if you don't show up`],
    // ["has been trying to quit smoking", `Tries to quit smoking`],
    // ["can't wait to see the new movie", `Can't wait to see the new movie`],
    // ["were hoping for a positive outcome", `Hopes for a positive outcome`],
    // ["could have told me the truth", `Tells me the truth`],
    // ["wouldn't dare to break the rules", `Doesn't dare to break the rules`],
    // ["is looking forward to the trip", `Looks forward to the trip`],
    // ["should be resting after the surgery", `Rests after the surgery`],
    // ["might be studying for the exam", `Studies for the exam`],
    // ["have been meaning to call you", `Means to call you`],
    // ["was wondering about the results", `Wonders about the results`],
    // ["will be arriving in an hour", `Arrives in an hour`],
    // ["was just thinking about you", `Thinks about you`],
    // ["might have been practicing all day", `Practices all day`],
    // ["was just about to leave", `Is about to leave`],
    // ["should have been more careful", `Is more careful`],
    // ["would be going to the gym regularly", `Goes to the gym regularly`],
    // ["has been waiting for a long time", `Waits for a long time`],
    // ["could have been wrong about him", `Is wrong about him`],
    // ["would have enjoyed the party", `Enjoys the party`],
    // ["will have completed the task soon", `Completes the task soon`],
    // ["might have been feeling lonely", `Feels lonely`],
    // ["could have been living a lie", `Lives a lie`],
    // ["was just starting to get the hang of it", `Starts to get the hang of it`],
    // ["would be celebrating her birthday tomorrow", `Celebrates her birthday`],
    // ["has been missing you a lot", `Misses you a lot`],
    // ["will be working late tonight", `Works late tonight`],
    // ["should have taken the opportunity", `Takes the opportunity`],
    // ["could have been sleeping", `Sleeps`],
    // ["is trying to lose weight", `Tries to lose weight`],
    // ["has been feeling unwell", `Feels unwell`],
    // [`they're good`, 'they were good'],
    //TODO: missing auxillary
    // [`we've said`, 'we said'], //or 'we have said'
    // [`they'd said`, 'they said'], //or 'they have said'
    // (ambiguous)
    // [`he's good`, 'he was good'],
  ]
  arr.forEach(a => {
    let doc = nlp(a[0])
    doc.verbs().toPresentTense()
    t.equal(doc.text(), a[1], here + ' ' + a[0])
  })
  t.end()
})

test('conjugate:', function (t) {
  let arr = [

    ['abolish', 'abolishes'],
    ['absorb', 'absorbs'],
    ['accede', 'accedes'],
    ['acclimate', 'acclimates'],
    ['accomplish', 'accomplishes'],
    ['accost', 'accosts'],
    ['accrue', 'accrues'],
    ['accumulate', 'accumulates'],
    ['accustom', 'accustoms'],
    ['activate', 'activates'],
    ['adapt', 'adapts'],
    ['agree', 'agrees'],
    ['aim', 'aims'],
    ['allow', 'allows'],
    ['alter', 'alters'],
    ['altercate', 'altercates'],
    ['amaze', 'amazes'],
    ['amend', 'amends'],
    ['amuse', 'amuses'],
    ['analyze', 'analyzes'],
    ['animate', 'animates'],
    ['annotate', 'annotates'],
    ['announce', 'announces'],
    ['appreciate', 'appreciates'],
    ['apprehend', 'apprehends'],
    ['ask', 'asks'],
    ['assimilate', 'assimilates'],
    ['attack', 'attacks'],
    ['bake', 'bakes'],
    ['bang', 'bangs'],
    ['bank', 'banks'],
    ['bargain', 'bargains'],
    ['bat', 'bats'],
    ['begin', 'begins'],
    ['belittle', 'belittles'],
    ['belong', 'belongs'],
    ['bend', 'bends'],
    ['betray', 'betrays'],
    ['bleed', 'bleeds'],
    ['blink', 'blinks'],
    ['boil', 'boils'],
    ['bounce', 'bounces'],
    ['break', 'breaks'],
    ['breathe', 'breathes'],
    ['bury', 'buries'],
    ['capture', 'captures'],
    ['carry', 'carries'],
    ['castigate', 'castigates'],
    ['catalog', 'catalogs'],
    ['catch', 'catches'],
    ['celebrate', 'celebrates'],
    ['chase', 'chases'],
    ['cheat', 'cheats'],
    ['chew', 'chews'],
    ['circumvent', 'circumvents'],
    ['clap', 'claps'],
    ['clarify', 'clarifies'],
    ['collect', 'collects'],
    ['commute', 'commutes'],
    ['conclude', 'concludes'],
    ['conform', 'conforms'],
    ['conquer', 'conquers'],
    ['consider', 'considers'],
    ['construct', 'constructs'],
    ['contain', 'contains'],
    ['contemplate', 'contemplates'],
    ['cooperate', 'cooperates'],
    ['create', 'creates'],
    ['cry', 'cries'],
    ['culpabilize', 'culpabilizes'],
    ['cultivate', 'cultivates'],
    ['cut', 'cuts'],
    ['defend', 'defends'],
    ['defy', 'defies'],
    ['deplore', 'deplores'],
    ['depose', 'deposes'],
    ['descend', 'descends'],
    ['design', 'designs'],
    ['detect', 'detects'],
    ['diminish', 'diminishes'],
    ['discern', 'discerns'],
    ['discuss', 'discusses'],
    ['dissolve', 'dissolves'],
    ['divide', 'divides'],
    ['drag', 'drags'],
    ['drain', 'drains'],
    ['draw', 'draws'],
    ['drum', 'drums'],
    ['embark', 'embarks'],
    ['embrace', 'embraces'],
    ['encircle', 'encircles'],
    ['endure', 'endures'],
    ['enforce', 'enforces'],
    ['enhance', 'enhances'],
    ['enjoy', 'enjoys'],
    ['enrich', 'enriches'],
    ['enter', 'enters'],
    ['establish', 'establishes'],
    ['exalt', 'exalts'],
    ['exchange', 'exchanges'],
    ['exclude', 'excludes'],
    ['exert', 'exerts'],
    ['exhort', 'exhorts'],
    ['expect', 'expects'],
    ['expel', 'expels'],
    ['explain', 'explains'],
    ['explode', 'explodes'],
    ['extol', 'extols'],
    ['extrapolate', 'extrapolates'],
    ['exude', 'exudes'],
    ['fabricate', 'fabricates'],
    ['file', 'files'],
    ['fix', 'fixes'],
    ['float', 'floats'],
    ['flood', 'floods'],
    ['flow', 'flows'],
    ['follow', 'follows'],
    ['forsake', 'forsakes'],
    ['frighten', 'frightens'],
    ['fry', 'fries'],
    ['function', 'functions'],
    ['fund', 'funds'],
    ['generate', 'generates'],
    ['glimmer', 'glimmers'],
    ['glorify', 'glorifies'],
    ['glow', 'glows'],
    ['greet', 'greets'],
    ['grip', 'grips'],
    ['guarantee', 'guarantees'],
    ['guide', 'guides'],
    ['harangue', 'harangues'],
    ['harvest', 'harvests'],
    ['hatch', 'hatches'],
    ['hibernate', 'hibernates'],
    ['hide', 'hides'],
    ['hint', 'hints'],
    ['howl', 'howls'],
    ['hurry', 'hurries'],
    ['illuminate', 'illuminates'],
    ['immigrate', 'immigrates'],
    ['impinge', 'impinges'],
    ['impress', 'impresses'],
    ['inculcate', 'inculcates'],
    ['indemnify', 'indemnifies'],
    ['inhale', 'inhales'],
    ['inhibit', 'inhibits'],
    ['insinuate', 'insinuates'],
    ['inspire', 'inspires'],
    ['insulate', 'insulates'],
    ['integrate', 'integrates'],
    ['interrupt', 'interrupts'],
    ['invade', 'invades'],
    ['invert', 'inverts'],
    ['invest', 'invests'],
    ['invite', 'invites'],
    ['joke', 'jokes'],
    ['jump', 'jumps'],
    ['justify', 'justifies'],
    ['knit', 'knits'],
    ['learn', 'learns'],
    ['leave', 'leaves'],
    ['liberalize', 'liberalizes'],
    ['lie', 'lies'],
    ['load', 'loads'],
    ['loosen', 'loosens'],
    ['love', 'loves'],
    ['magnify', 'magnifies'],
    ['march', 'marches'],
    ['mark', 'marks'],
    ['melt', 'melts'],
    ['migrate', 'migrates'],
    ['mobilize', 'mobilizes'],
    ['modify', 'modifies'],
    ['mourn', 'mourns'],
    ['negotiate', 'negotiates'],
    ['neutralize', 'neutralizes'],
    ['omit', 'omits'],
    ['operate', 'operates'],
    ['organize', 'organizes'],
    ['ostracize', 'ostracizes'],
    ['overcome', 'overcomes'],
    ['participate', 'participates'],
    ['paste', 'pastes'],
    ['peg', 'pegs'],
    ['pictorialize', 'pictorializes'],
    ['play', 'plays'],
    ['plug', 'plugs'],
    ['praise', 'praises'],
    ['pray', 'prays'],
    ['preserve', 'preserves'],
    ['proclaim', 'proclaims'],
    ['produce', 'produces'],
    ['prolong', 'prolongs'],
    ['propagate', 'propagates'],
    ['propitiate', 'propitiates'],
    ['provide', 'provides'],
    ['pull', 'pulls'],
    ['puncture', 'punctures'],
    ['purify', 'purifies'],
    ['quench', 'quenches'],
    ['quest', 'quests'],
    ['quiver', 'quivers'],
    ['rain', 'rains'],
    ['ratify', 'ratifies'],
    ['recall', 'recalls'],
    ['receive', 'receives'],
    ['recite', 'recites'],
    ['refine', 'refines'],
    ['refresh', 'refreshes'],
    ['refuse', 'refuses'],
    ['regret', 'regrets'],
    ['regulate', 'regulates'],
    ['reject', 'rejects'],
    ['repair', 'repairs'],
    ['reply', 'replies'],
    ['reside', 'resides'],
    ['resist', 'resists'],
    ['revere', 'reveres'],
    ['revive', 'revives'],
    ['revolutionize', 'revolutionizes'],
    ['roam', 'roams'],
    ['roar', 'roars'],
    ['roll', 'rolls'],
    ['ruin', 'ruins'],
    ['sacrifice', 'sacrifices'],
    ['sacrifices', 'sacrifices'],
    ['saturate', 'saturates'],
    ['scale', 'scales'],
    ['schedule', 'schedules'],
    ['scribble', 'scribbles'],
    ['scrutinize', 'scrutinizes'],
    ['sense', 'senses'],
    ['serve', 'serves'],
    ['sew', 'sews'],
    ['shine', 'shines'],
    ['signal', 'signals'],
    ['sing', 'sings'],
    ['slip', 'slips'],
    ['smash', 'smashes'],
    ['smell', 'smells'],
    ['snatch', 'snatches'],
    ['soar', 'soars'],
    ['sparkle', 'sparkles'],
    ['stalk', 'stalks'],
    ['start', 'starts'],
    ['stay', 'stays'],
    ['stifle', 'stifles'],
    ['stir', 'stirs'],
    ['strain', 'strains'],
    ['strive', 'strives'],
    ['submerge', 'submerges'],
    ['succeed', 'succeeds'],
    ['summarize', 'summarizes'],
    ['swear', 'swears'],
    ['swim', 'swims'],
    ['take', 'takes'],
    ['teach', 'teaches'],
    ['tear', 'tears'],
    ['throw', 'throws'],
    ['thrust', 'thrusts'],
    ['trace', 'traces'],
    ['trade', 'trades'],
    ['treat', 'treats'],
    ['tumble', 'tumbles'],
    ['unite', 'unites'],
    ['unravel', 'unravels'],
    ['update', 'updates'],
    ['uplift', 'uplifts'],
    ['urge', 'urges'],
    ['utilize', 'utilizes'],
    ['waste', 'wastes'],
    ['weave', 'weaves'],
    ['whirl', 'whirls'],
    ['whisper', 'whispers'],
    ['whistle', 'whistles'],
    ['wish', 'wishes'],
    ['work', 'works'],
    ['worship', 'worships'],
    ['yield', 'yields'],
    ['exempt', 'exempts'],
    ['replicate', 'replicates'],
    // ['express', 'expresses'],
  ]
  arr.forEach(a => {
    let doc = nlp(a[0]).tag('Verb')
    let res = doc.verbs().conjugate()[0] || {}
    t.equal(res.PresentTense, a[1], here + ' ' + a[0])
  })
  t.end()
})
