import test from 'tape'
import nlp from '../_lib.js'
const here = '[three/verb-toPastParticiple] '

test('toPastParticiple:', function (t) {
  let arr = [
    [`I eat breakfast every morning.`, `I have eaten breakfast every morning.`],
    [`She reads a book before bed.`, `She has read a book before bed.`],
    [`He teaches math to high school students.`, `He has taught math to high school students.`],
    [`They walk their dog in the park.`, `They have walked their dog in the park.`],
    [`We watch a movie on Friday nights.`, `We have watched a movie on Friday nights.`],
    [`I eat pizza.`, `I have eaten pizza.`],
    [`He reads books.`, `He has read books.`],
    [`She sings songs.`, `She has sung songs.`],
    [`We write letters.`, `We have written letters.`],
    [`You speak Spanish.`, `You have spoken Spanish.`],
    // [`He swims laps.`, `He has swum laps.`],
    [`They climb mountains.`, `They have climbed mountains.`],
    [`She dances ballet.`, `She has danced ballet.`],
    [`We paint pictures.`, `We have painted pictures.`],
    [`I play soccer.`, `I have played soccer.`],
    [`They study history.`, `They have studied history.`],
    [`He cooks dinner.`, `He has cooked dinner.`],
    [`She designs websites.`, `She has designed websites.`],
    [`We watch movies.`, `We have watched movies.`],
    [`You listen to music.`, `You have listened to music.`],
    [`They build houses.`, `They have built houses.`],
    [`I plant flowers.`, `I have planted flowers.`],
    [`He fixes cars.`, `He has fixed cars.`],
    [`She teaches math.`, `She has taught math.`],
    [`We clean the house.`, `We have cleaned the house.`],
    [`You drive a car.`, `You have driven a car.`],
    [`They ride bikes.`, `They have ridden bikes.`],
    [`I take photos.`, `I have taken photos.`],
    [`Spencer does yoga.`, `Spencer has done yoga.`],
    [`We sing in the choir.`, `We have sung in the choir.`],
    [`You draw pictures.`, `You have drawn pictures.`],
    [`They make cookies.`, `They have made cookies.`],
    [`He surfs the internet.`, `He has surfed the internet.`],
    [`She plays the guitar.`, `She has played the guitar.`],
    [`We travel the world.`, `We have travelled the world.`],
    [`You speak to friends.`, `You have spoken to friends.`],
    [`They fish in the river.`, `They have fished in the river.`],
    [`I write stories.`, `I have written stories.`],
    [`He takes a shower.`, `He has taken a shower.`],
    [`She sews clothes.`, `She has sewn clothes.`],
    [`We play board games.`, `We have played board games.`],
    [`You exercise at the gym.`, `You have exercised at the gym.`],
    [`They fly airplanes.`, `They have flown airplanes.`],
    [`He studies science.`, `He has studied science.`],
    ["I sing in the shower.", "I have sung in the shower."],
    ["The sun shines brightly.", "The sun has shone brightly."],
    ["He eats a lot of vegetables.", "He has eaten a lot of vegetables."],
    ["We write a letter to our grandparents.", "We have written a letter to our grandparents."],
    ["The dog barks loudly.", "The dog has barked loudly."],
    ["They play soccer every weekend.", "They have played soccer every weekend."],
    ["She speaks Spanish fluently.", "She has spoken Spanish fluently."],
    ["He teaches math at the local college.", "He has taught math at the local college."],
    ["The tree grows tall.", "The tree has grown tall."],
    ["The bird chirps early in the morning.", "The bird has chirped early in the morning."],
    ["The flower smells sweet.", "The flower has smelled sweet."],
    ["I play the guitar.", "I have played the guitar."],
    ["The wind blows gently.", "The wind has blown gently."],
    // ["the tree will grow", "the tree has grown"],
    ["the tree grows quickly", "the tree has grown quickly"],
    ["She will have eaten", "She has eaten"],
    ["They will have finished", "They have finished"],
    ["He will have written", "He has written"],
    ["We will have seen", "We have seen"],
    ["You will have spoken", "You have spoken"],

    ["She reads a book every night.", "She has read a book every night."],
    // ["I always forget my keys.", "I have always forgotten my keys"],
    ["She paints beautiful pictures.", "She has painted beautiful pictures."],
    ["He drives a fast car.", "He has driven a fast car."],
    ["I clean the house every weekend.", "I have cleaned the house every weekend."],
    ["She dances gracefully.", "She has danced gracefully."],
    ["He flies to New York for business.", "He has flown to New York for business."],
    ["We swim in the pool on hot days.", "We have swum in the pool on hot days."],
    // ["They run a marathon every year.", "They have run a marathon every year."],
    ["She sews her own clothes", "She has sewn her own clothes"],
    ["He builds houses for a living.", "He has built houses for a living."],
    ["We drink coffee every morning.", "We have drunk coffee every morning."],
    ["They watch movies on Friday nights.", "They have watched movies on Friday nights."],
    ["She designs jewelry for a living.", "She has designed jewelry for a living."],
    ["He studies biology in college.", "He has studied biology in college."],
    // ["We take walks in the park.", "We have taken walks in the park."],
    // ["They listen to music on their way to work.", "They have listened to music on their way to work."],
    ["She cooks dinner for her family", "She has cooked dinner for her family"],


    ['i take', 'i have taken'],
    ['i write', 'i have written'],
    ['i make', 'i have made'],
    ['i agree', 'i have agreed'],
    ['i catch', 'i have caught'],
    ['i do', 'i have done'],
    ['i break', 'i have broken'],
    ['i forget', 'i have forgotten'],
    ['i move', 'i have moved'],
    ['i understand', 'i have understood'],
    ['i open', 'i have opened'],
    ['i fill', 'i have filled'],
    ['i speak', 'i have spoken'],
    ['i put', 'i have put'],
    ['i walk', 'i have walked'],
    ['i meet', 'i have met'],
    ['i fly', 'i have flown'],
    ['i keep', 'i have kept'],
    ['i show', 'i have shown'],
    ['i hear', 'i have heard'],
    ['i trust', 'i have trusted'],
    ['i turn', 'i have turned'],
    ['i fall', 'i have fallen'],
    ['i find', 'i have found'],
    ['i give', 'i have given'],
    ['i cause', 'i have caused'],
    ['i stand', 'i have stood'],
    ['i sit', 'i have sat'],
    ['i leave', 'i have left'],
    ['i stop', 'i have stopped'],
    ['i plan', 'i have planned'],
    ['i live', 'i have lived'],
    ['i build', 'i have built'],
    ['i suggest', 'i have suggested'],
    ['i hold', 'i have held'],
    ['i look', 'i have looked'],
    ['i lie', 'i have lied'],
    ['i hope', 'i have hoped'],
    ['i bring', 'i have brought'],
    ['i ask', 'i have asked'],
    ['i seem', 'i have seemed'],
    ['i include', 'i have included'],
    ['i understand', 'i have understood'],
    ['i consider', 'i have considered'],
    ['i realize', 'i have realized'],
    ['i follow', 'i have followed'],
    ['i bring', 'i have brought'],
    ['i think', 'i have thought'],
    ['i explain', 'i have explained'],
    ['i explain', 'i have explained'],
    ['i point', 'i have pointed'],
    ['i choose', 'i have chosen'],
    ['i play', 'i have played'],
    ['i try', 'i have tried'],
    ['i study', 'i have studied'],
    // ['i wear', 'i have worn'],
    ['i act', 'i have acted'],
    ['i help', 'i have helped'],
    ['i remember', 'i have remembered'],
    ['i call', 'i have called'],
    ['i remove', 'i have removed'],
    ['i accept', 'i have accepted'],
    ['i prepare', 'i have prepared'],
    ['i prepare', 'i have prepared'],
    ['i support', 'i have supported'],
    ['i increase', 'i have increased'],
    ['i mean', 'i have meant'],
    ['i meet', 'i have met'],
    ['i add', 'i have added'],
    ['i lose', 'i have lost'],
    ['i appear', 'i have appeared'],
    ['i develop', 'i have developed'],
    ['i reach', 'i have reached'],
    ['i use', 'i have used'],
    ['i like', 'i have liked'],
    ['i choose', 'i have chosen'],
    ['i continue', 'i have continued'],
    ['i create', 'i have created'],
    ['i deal', 'i have dealt'],
    ['i cause', 'i have caused'],
    ['i set', 'i have set'],
    ['i allow', 'i have allowed'],
    ['i notice', 'i have noticed'],
    ['i take', 'i have taken'],
    ['i save', 'i have saved'],
    ['i spend', 'i have spent'],
    ['i suffer', 'i have suffered'],
    ['i provide', 'i have provided'],
    ['i reach', 'i have reached'],
    ['i contain', 'i have contained'],
    ['i include', 'i have included'],
    ['i finish', 'i have finished'],
    ['i face', 'i have faced'],
    ['i explain', 'i have explained'],
    ['i mention', 'i have mentioned'],
    ['i form', 'i have formed'],
    ['i examine', 'i have examined'],
    ['i consider', 'i have considered'],
    ['i cost', 'i have cost'],
    ['i determine', 'i have determined'],
    ['i require', 'i have required'],
    ['i exist', 'i have existed'],
    ['i remain', 'i have remained'],
    ['i involve', 'i have involved'],
    ['i reduce', 'i have reduced'],
    ['i establish', 'i have established'],
    ['i protect', 'i have protected'],
    ['i cause', 'i have caused'],
    ['i represent', 'i have represented'],
    ['i indicate', 'i have indicated'],
    ['i determine', 'i have determined'],
    ['i apply', 'i have applied'],
    ['i increase', 'i have increased'],
    ['i base', 'i have based'],
    ['i answer', 'i have answered'],
    ['i cover', 'i have covered'],
    ['i show', 'i have shown'],
    ['i involve', 'i have involved'],
    ['i notice', 'i have noticed'],
    ['i understand', 'i have understood'],
    ['i pass', 'i have passed'],
    ['i permit', 'i have permitted'],
    ['i prefer', 'i have preferred'],
    ['i contain', 'i have contained'],
    ['i represent', 'i have represented'],
    ['i change', 'i have changed'],
    ['i recognize', 'i have recognized'],
    ['i refer', 'i have referred'],
    ['i decide', 'i have decided'],
    ['i estimate', 'i have estimated'],
    ['i discuss', 'i have discussed'],
    ['i observe', 'i have observed'],
    ['i receive', 'i have received'],
    ['i include', 'i have included'],
    ['i consider', 'i have considered'],
    ['i affect', 'i have affected'],
    ['i agree', 'i have agreed'],
    ['i understand', 'i have understood'],
    ['i happen', 'i have happened'],
    ['i produce', 'i have produced'],
    ['i perform', 'i have performed'],
    ['i connect', 'i have connected'],
    ['i resist', 'i have resisted'],
    ['i consider', 'i have considered'],
    ['i regard', 'i have regarded'],
    ['i occur', 'i have occurred'],
    ['i relate', 'i have related'],
  ]
  arr.forEach(a => {
    let doc = nlp(a[0])
    doc.verbs().toPastParticiple()
    t.equal(doc.text(), a[1], here + ' ' + a[0])
  })
  t.end()
})


test('past vs past-participle:', function (t) {
  let arr = [
    ['arise', 'arose', 'arisen'],
    ['awake', 'awoke', 'awoken'],
    // ['bear', 'bore', 'born'],
    ['beat', 'beat', 'beaten'],
    // ['become', 'became', 'become'],
    ['bet', 'bet', 'bet'],
    ['bid', 'bid', 'bid'],
    ['bind', 'bound', 'bound'],
    ['bleed', 'bled', 'bled'],
    ['blow', 'blew', 'blown'],
    ['break', 'broke', 'broken'],
    ['breed', 'bred', 'bred'],
    ['bring', 'brought', 'brought'],
    ['build', 'built', 'built'],
    ['burst', 'burst', 'burst'],
    ['catch', 'caught', 'caught'],
    ['choose', 'chose', 'chosen'],
    ['cling', 'clung', 'clung'],
    // ['come', 'came', 'come'],
    ['cost', 'cost', 'cost'],
    ['creep', 'crept', 'crept'],
    ['deal', 'dealt', 'dealt'],
    ['dig', 'dug', 'dug'],
    ['do', 'did', 'done'],
    ['draw', 'drew', 'drawn'],
    ['drink', 'drank', 'drunk'],
    ['drive', 'drove', 'driven'],
    ['eat', 'ate', 'eaten'],
    ['fall', 'fell', 'fallen'],
    ['feed', 'fed', 'fed'],
    ['fight', 'fought', 'fought'],
    ['find', 'found', 'found'],
    ['flee', 'fled', 'fled'],
    ['fling', 'flung', 'flung'],
    ['fly', 'flew', 'flown'],
    ['forget', 'forgot', 'forgotten'],
    ['forgive', 'forgave', 'forgiven'],
    ['forsake', 'forsaken', 'forsaken'],
    // ['freeze', 'froze', 'frozen'],
    ['give', 'gave', 'given'],
    ['go', 'went', 'gone'],
    ['grow', 'grew', 'grown'],
    ['hang', 'hung', 'hung'],
    ['have', 'had', 'had'],
    ['hide', 'hid', 'hidden'],
    ['hold', 'held', 'held'],
    ['keep', 'kept', 'kept'],
    ['know', 'knew', 'known'],
    ['leave', 'left', 'left'],
    ['lend', 'lent', 'lent'],
    ['light', 'lit', 'lit'],
    ['make', 'made', 'made'],
    ['meet', 'met', 'met'],
    ['prove', 'proved', 'proven'],
    ['read', 'read', 'read'],
    ['ride', 'rode', 'ridden'],
    ['ring', 'rang', 'rung'],
    ['rise', 'rose', 'risen'],
    // ['run', 'ran', 'run'],
    ['say', 'said', 'said'],
    ['see', 'saw', 'seen'],
    ['seek', 'sought', 'sought'],
    ['set', 'set', 'set'],
    ['shake', 'shook', 'shaken'],
    ['shine', 'shone', 'shone'],
    ['shoot', 'shot', 'shot'],
    ['show', 'showed', 'shown'],
    ['sing', 'sang', 'sung'],
    ['sink', 'sank', 'sunk'],
    ['sit', 'sat', 'sat'],
    ['sleep', 'slept', 'slept'],
    ['speak', 'spoke', 'spoken'],
    ['spend', 'spent', 'spent'],
    ['spread', 'spread', 'spread'],
    ['stand', 'stood', 'stood'],
    ['steal', 'stole', 'stolen'],
    ['stick', 'stuck', 'stuck'],
    ['strike', 'struck', 'struck'],
    ['swear', 'swore', 'sworn'],
    ['swim', 'swam', 'swum'],
    ['take', 'took', 'taken'],
    ['teach', 'taught', 'taught'],
    ['tear', 'tore', 'torn'],
    ['tell', 'told', 'told'],
    ['think', 'thought', 'thought'],
    ['throw', 'threw', 'thrown'],
    ['understand', 'understood', 'understood'],
    ['wake', 'woke', 'woken'],
    // ['wear', 'wore', 'worn'],
    ['win', 'won', 'won'],
    ['write', 'wrote', 'written'],
  ]
  arr.forEach(a => {
    let [present, past, participle] = a
    let doc = nlp(present).tag('#Infinitive')
    let obj = doc.verbs().conjugate()[0] || {}
    t.equal(obj.PastTense, past, here + ' ' + a[0])

    let prt = obj.Participle || obj.PastTense || ''
    prt = prt.replace(/^had /, '')
    t.equal(prt, participle, here + ' ' + a[0])
  })
  t.end()
})



