import test from 'tape'
import nlp from '../_lib.js'
const here = '[three/gerund]'

test('verb-to-gerund:', function (t) {
  let arr = [
    ['we walk', 'we are walking'],
    ['we sing', 'we are singing'],
    ['we win', 'we are winning'],
    ['we will convert', 'we are converting'],
    ['we see', 'we are seeing'],
    ['he is', 'he is being'],
    ['he was', 'he is being'],
    ['i am', 'i am being'],
    ['he walked', 'he is walking'],
    ['he dedicates', 'he is dedicating'],
    // ['he did not walk', 'he was not walking'],
    // ['there is no hope', 'there is no hoping'],


    // copula forms
    ['i am not cool', 'i am being not cool'],
    ['i was not cool', 'i am being not cool'],
    // ['i will not be cool', 'i will not be being cool'],
    ['he is not cool', 'he is being not cool'],
    // ['he was not cool', 'he was being not cool'],
    // ['he will not be cool', 'he will not be being cool'],
    ['they are not cool', 'they are being not cool'],
    // ['they were not cool', 'they were being not cool'],
    // ['they will not be cool', 'they will not be being cool'],

  ]
  arr.forEach(function (a) {
    const doc = nlp(a[0])
    doc.verbs().toGerund()
    let str = doc.out('normal')
    t.equal(str, a[1], here + a[0] + ' -> ' + str)
  })
  t.end()
})


test('verb-to-gerund:', function (t) {
  let arr = [
    ['be', 'being'],
    ['try', 'trying'],
    ['make', 'making'],
    ['come', 'coming'],
    ['do', 'doing'],
    ['watch', 'watching'],
    ['give', 'giving'],
    ['think', 'thinking'],
    ['go', 'going'],
    ['have', 'having'],
    ['find', 'finding'],
    ['get', 'getting'],
    ['run', 'running'],
    ['say', 'saying'],
    ['take', 'taking'],
    ['know', 'knowing'],
    ['tell', 'telling'],
    ['call', 'calling'],
    ['ask', 'asking'],
    ['work', 'working'],
    ['look', 'looking'],
    ['use', 'using'],
    ['feel', 'feeling'],
    ['live', 'living'],
    ['place', 'placing'],
    ['write', 'writing'],
    ['show', 'showing'],
    ['seem', 'seeming'],
    ['try', 'trying'],
    ['help', 'helping'],
    ['start', 'starting'],
    ['play', 'playing'],
    ['stand', 'standing'],
    ['speak', 'speaking'],
    ['listen', 'listening'],
    ['leave', 'leaving'],
    ['open', 'opening'],
    ['move', 'moving'],
    ['continue', 'continuing'],
    ['learn', 'learning'],
    ['hold', 'holding'],
    ['bring', 'bringing'],
    ['mean', 'meaning'],
    ['develop', 'developing'],
    ['produce', 'producing'],
    ['draw', 'drawing'],
    ['arrive', 'arriving'],
    ['stay', 'staying'],
    ['pay', 'paying'],
    ['drive', 'driving'],
    ['happen', 'happening'],
    ['grow', 'growing'],
    ['read', 'reading'],
    ['sing', 'singing'],
    ['sit', 'sitting'],
    ['rise', 'rising'],
    ['form', 'forming'],
    ['remember', 'remembering'],
    ['reach', 'reaching'],
    ['include', 'including'],
    ['consider', 'considering'],
    ['enjoy', 'enjoying'],
    ['lead', 'leading'],
    ['understand', 'understanding'],
    ['set', 'setting'],
    ['support', 'supporting'],
    ['seek', 'seeking'],
    ['create', 'creating'],
    ['discuss', 'discussing'],
    ['present', 'presenting'],
    ['prepare', 'preparing'],
    ['allow', 'allowing'],
    ['appear', 'appearing'],
    ['spend', 'spending'],
    ['continue', 'continuing'],
    ['exist', 'existing'],
    ['cut', 'cutting'],
    ['add', 'adding'],
    ['apply', 'applying'],
    ['decide', 'deciding'],
    ['fix', 'fixing'],
    ['control', 'controlling'],
    ['break', 'breaking'],
    ['purchase', 'purchasing'],
    ['increase', 'increasing'],
    ['build', 'building'],
    ['sell', 'selling'],
    ['raise', 'raising'],
    ['share', 'sharing'],
    ['deliver', 'delivering'],
    ['search', 'searching'],
    ['practice', 'practicing'],
    ['visit', 'visiting'],
    ['protect', 'protecting'],
    ['serve', 'serving'],
    ['test', 'testing'],
    ['maintain', 'maintaining'],
    ['cause', 'causing'],
    ['represent', 'representing'],
    ['publish', 'publishing'],
    ['operate', 'operating'],
    ['respond', 'responding'],
    ['agree', 'agreeing'],
    ['arrive', 'arriving'],
    ['drive', 'driving'],
    ['fly', 'flying'],
    ['remain', 'remaining'],
    ['teach', 'teaching'],
    ['study', 'studying'],
    ['lead', 'leading'],
    ['represent', 'representing'],
    ['speak', 'speaking'],
    ['explain', 'explaining'],
    ['claim', 'claiming'],
    ['reduce', 'reducing'],
    ['select', 'selecting'],
    ['establish', 'establishing'],
    ['collect', 'collecting'],
    ['recognize', 'recognizing'],
    ['bury', 'burying'],
    ['dance', 'dancing'],
    ['win', 'winning'],
    ['roll', 'rolling'],
    ['kiss', 'kissing'],
    ['suffer', 'suffering'],
    ['kiss', 'kissing'],
    ['recognize', 'recognizing'],
    ['combine', 'combining'],
    ['launch', 'launching'],
    ['invest', 'investing'],
    ['shoot', 'shooting'],
    ['skate', 'skating'],
    ['pause', 'pausing'],
    ['review', 'reviewing'],
    ['operate', 'operating'],
    ['declare', 'declaring'],
    ['direct', 'directing'],
    ['donate', 'donating'],
    ['enhance', 'enhancing'],
    ['originate', 'originating'],
    ['detect', 'detecting'],
    ['perform', 'performing'],
    ['attend', 'attending'],
    ['inspect', 'inspecting'],
    ['replace', 'replacing'],
    ['negotiate', 'negotiating'],
    ['discriminate', 'discriminating'],
    ['register', 'registering'],
    ['export', 'exporting'],
    ['transport', 'transporting'],
  ]
  arr.forEach(function (a) {
    const doc = nlp(a[0]).tag('#Infinitive')
    let res = doc.verbs().conjugate()[0] || {}
    t.equal(res.Gerund, a[1], here + a[0] + ' -> ' + res.Gerund)
  })
  t.end()
})
