import test from 'tape'
import nlp from '../_lib.js'
const here = '[three/number-Cardinal] '

//tests 'borrowed' from Travis Savo's lib 💝 https://github.com/TSavo/english2number-js
const cardinal = function (str) {
  let json = nlp(str).values().json()[0] || { number: {} }
  return json.number.num
}

test('parse numbers', function (t) {
  t.equal(cardinal('0'), 0, here + '0')
  t.equal(cardinal('1'), 1, here + '1')
  t.equal(cardinal('2'), 2, here + '2')
  t.equal(cardinal('3'), 3, here + '3')
  t.equal(cardinal('4'), 4, here + '4')
  t.equal(cardinal('5'), 5, here + '5')
  t.equal(cardinal('6'), 6, here + '6')
  t.equal(cardinal('7'), 7, here + '7')
  t.equal(cardinal('8'), 8, here + '8')
  t.equal(cardinal('9'), 9, here + '9')
  t.equal(cardinal('10'), 10, here + '10')
  t.equal(cardinal('20'), 20, here + '20')
  t.equal(cardinal('30'), 30, here + '30')
  t.equal(cardinal('50'), 50, here + '50')
  t.equal(cardinal('90'), 90, here + '90')
  t.equal(cardinal('100'), 100, here + '100')
  t.end()
})
test('parse numbered ordinals', function (t) {
  t.equal(cardinal('0th'), 0, here + '0th')
  t.equal(cardinal('1st'), 1, here + '1st')
  t.equal(cardinal('2nd'), 2, here + '2nd')
  t.equal(cardinal('3rd'), 3, here + '3rd')
  t.equal(cardinal('4th'), 4, here + '4th')
  t.equal(cardinal('5th'), 5, here + '5th')
  t.equal(cardinal('6th'), 6, here + '6th')
  t.equal(cardinal('7th'), 7, here + '7th')
  t.equal(cardinal('8th'), 8, here + '8th')
  t.equal(cardinal('9th'), 9, here + '9th')
  t.equal(cardinal('10th'), 10, here + '10th')
  t.equal(cardinal('20th'), 20, here + '20th')
  t.equal(cardinal('30th'), 30, here + '30th')
  t.equal(cardinal('50th'), 50, here + '50th')
  t.equal(cardinal('77th'), 77, here + '77th')
  t.equal(cardinal('90th'), 90, here + '90th')
  t.equal(cardinal('100th'), 100, here + '100th')
  t.end()
})
test('parse english names of numbers', function (t) {
  t.equal(cardinal('zero'), 0, here + 'zero')
  t.equal(cardinal('one'), 1, here + 'one')
  t.equal(cardinal('two'), 2, here + 'two')
  t.equal(cardinal('three'), 3, here + 'three')
  t.equal(cardinal('four'), 4, here + 'four')
  t.equal(cardinal('five'), 5, here + 'five')
  t.equal(cardinal('six'), 6, here + 'six')
  t.equal(cardinal('seven'), 7, here + 'seven')
  t.equal(cardinal('eight'), 8, here + 'eight')
  t.equal(cardinal('nine'), 9, here + 'nine')
  t.equal(cardinal('ten'), 10, here + 'ten')
  t.equal(cardinal('eleven'), 11, here + 'eleven')
  t.equal(cardinal('twelve'), 12, here + 'twelve')
  t.equal(cardinal('thirteen'), 13, here + 'thirteen')
  t.equal(cardinal('fourteen'), 14, here + 'fourteen')
  t.equal(cardinal('fifteen'), 15, here + 'fifteen')
  t.equal(cardinal('sixteen'), 16, here + 'sixteen')
  t.equal(cardinal('seventeen'), 17, here + 'seventeen')
  t.equal(cardinal('eighteen'), 18, here + 'eighteen')
  t.equal(cardinal('nineteen'), 19, here + 'nineteen')
  t.equal(cardinal('twenty'), 20, here + 'twenty')
  t.equal(cardinal('twenty-five'), 25, here + 'twenty')
  t.equal(cardinal('twenty five'), 25, here + 'twenty')
  t.equal(cardinal('forty-four'), 44, here + 'forty')
  t.equal(cardinal('forty four'), 44, here + 'forty')
  t.equal(cardinal('fourty four'), 44, here + 'fourty') //typo
  t.equal(cardinal('seventy'), 70, here + 'seventy')
  t.equal(cardinal('seventy-seven'), 77, here + 'seventy')
  t.equal(cardinal('eighty eight'), 88, here + 'eighty')
  t.equal(cardinal('ninety nine'), 99, here + 'ninety')
  t.equal(cardinal('one-hundred'), 100, here + 'one-hundred')
  t.equal(cardinal('one hundred'), 100, here + 'one hundred')
  t.end()
})
test('parse english names of ordinal positions', function (t) {
  t.equal(cardinal('zeroth'), 0, here + 'zeroth')
  t.equal(cardinal('first'), 1, here + 'first')
  t.equal(cardinal('second'), 2, here + 'second')
  t.equal(cardinal('third'), 3, here + 'third')
  t.equal(cardinal('fourth'), 4, here + 'fourth')
  t.equal(cardinal('fifth'), 5, here + 'fifth')
  t.equal(cardinal('sixth'), 6, here + 'sixth')
  t.equal(cardinal('seventh'), 7, here + 'seventh')
  t.equal(cardinal('eighth'), 8, here + 'eighth')
  t.equal(cardinal('ninth'), 9, here + 'ninth')
  t.equal(cardinal('tenth'), 10, here + 'tenth')
  t.equal(cardinal('eleventh'), 11, here + 'eleventh')
  t.equal(cardinal('twelfth'), 12, here + 'twelfth')
  t.equal(cardinal('thirteenth'), 13, here + 'thirteenth')
  t.equal(cardinal('fourteenth'), 14, here + 'fourteenth')
  t.equal(cardinal('fifteenth'), 15, here + 'fifteenth')
  t.equal(cardinal('sixteenth'), 16, here + 'sixteenth')
  t.equal(cardinal('seventeenth'), 17, here + 'seventeenth')
  t.equal(cardinal('eighteenth'), 18, here + 'eighteenth')
  t.equal(cardinal('nineteenth'), 19, here + 'nineteenth')
  t.equal(cardinal('twentieth'), 20, here + 'twentieth')
  t.equal(cardinal('twenty first'), 21, here + 'twenty first')
  // t.equal(cardinal('twenty second'), 22, here + 'twenty second')
  t.equal(cardinal('twenty third'), 23, here + 'twenty third')
  t.equal(cardinal('twenty fourth'), 24, here + 'twenty fourth')
  t.equal(cardinal('twenty-fifth'), 25, here + 'twenty fifth')
  t.equal(cardinal('forty-fourth'), 44, here + 'forty-fourth')
  t.equal(cardinal('seventieth'), 70, here + 'seventieth')
  t.equal(cardinal('seventy-seventh'), 77, here + 'seventy')
  t.equal(cardinal('ninetieth'), 90, here + 'ninetieth')
  t.equal(cardinal('ninety ninth'), 99, here + 'ninety')
  // t.equal(cardinal('one-hundredth'), 100, 'one-hundredth')
  t.end()
})

test('parse negative numbers', function (t) {
  t.equal(cardinal('negative thirty eight thousand two hundred sixty three'), -38263, here + '-38263')
  t.equal(cardinal('negative thirty eight thousand two hundred sixty three'), -38263, here + '-38263')
  t.equal(cardinal('negative zero'), 0, here + '-0')
  t.end()
})
