import test from 'tape'
import nlp from '../_lib.js'
const here = '[three/noun-toPlural] '

test('toPlural:', function (t) {
  let arr = [
    ['activity', 'activities'],
    ['aircraft', 'aircraft'],
    ['airplane', 'airplanes'],
    ['alternative', 'alternatives'],
    ['analysis', 'analyses'],
    ['ant', 'ants'],
    ['appendix', 'appendices'],
    ['apple', 'apples'],
    ['armadillo', 'armadillos'],
    ['auto', 'autos'],
    ['avocado', 'avocados'],
    ['baby', 'babies'],
    ['ball', 'balls'],
    ['balloon', 'balloons'],
    ['banana', 'bananas'],
    ['banjo', 'banjos'],
    ['basket', 'baskets'],
    ['bean', 'beans'],
    ['bed', 'beds'],
    ['beggar', 'beggars'],
    ['berry', 'berries'],
    ['bible', 'bibles'],
    ['bicycle', 'bicycles'],
    ['bird', 'birds'],
    ['boat', 'boats'],
    ['book', 'books'],
    ['bottle', 'bottles'],
    ['bowl', 'bowls'],
    ['box', 'boxes'],
    ['bravo', 'bravos'],
    ['bread', 'bread'],
    ['bridge', 'bridges'],
    ['bronco', 'broncos'],
    ['broom', 'brooms'],
    ['brush', 'brushes'],
    ['bus', 'buses'],
    ['butterfly', 'butterflies'],
    ['cafe', 'cafes'],
    ['cake', 'cakes'],
    ['camera', 'cameras'],
    ['candle', 'candles'],
    ['candy', 'candies'],
    ['car', 'cars'],
    ['cargo', 'cargos'],
    ['carrot', 'carrots'],
    ['casino', 'casinos'],
    ['castle', 'castles'],
    ['cat', 'cats'],
    ['cause', 'causes'],
    ['chair', 'chairs'],
    ['characteristic', 'characteristics'],
    // ['cheese', 'cheeses'],
    ['chicken', 'chickens'],
    ['chief', 'chiefs'],
    ['child', 'children'],
    ['chipmunk', 'chipmunks'],
    ['church', 'churches'],
    ['clock', 'clocks'],
    ['cloud', 'clouds'],
    ['coat', 'coats'],
    ['coin', 'coins'],
    ['combo', 'combos'],
    ['computer', 'computers'],
    ['cookie', 'cookies'],
    ['couch', 'couches'],
    ['cow', 'cows'],
    ['cowboy', 'cowboys'],
    ['cowgirl', 'cowgirls'],
    ['crisis', 'crises'],
    ['criterion', 'criteria'],
    ['cup', 'cups'],
    ['cupcake', 'cupcakes'],
    ['daisy', 'daisies'],
    ['deer', 'deer'],
    ['desert', 'deserts'],
    ['desk', 'desks'],
    ['diamond', 'diamonds'],
    ['dice', 'dice'],
    ['dish', 'dishes'],
    ['dog', 'dogs'],
    ['doll', 'dolls'],
    ['door', 'doors'],
    ['dose', 'doses'],
    ['dragon', 'dragons'],
    ['dress', 'dresses'],
    ['drum', 'drums'],
    ['dust', 'dusts'],
    ['elephant', 'elephants'],
    ['embryo', 'embryos'],
    ['envelope', 'envelopes'],
    ['epoch', 'epochs'],
    ['eye', 'eyes'],
    ['fabric', 'fabrics'],
    ['face', 'faces'],
    ['falcon', 'falcons'],
    ['fan', 'fans'],
    // ['fish', 'fish'],
    ['fishbowl', 'fishbowls'],
    ['flag', 'flags'],
    ['flamingo', 'flamingos'],
    ['flower', 'flowers'],
    ['flowerpot', 'flowerpots'],
    ['foot', 'feet'],
    ['fork', 'forks'],
    ['fountain', 'fountains'],
    ['fox', 'foxes'],
    ['fresco', 'frescos'],
    ['frog', 'frogs'],
    ['game', 'games'],
    ['garden', 'gardens'],
    ['gas', 'gases'],
    ['gazebo', 'gazebos'],
    ['ghetto', 'ghettos'],
    ['giraffe', 'giraffes'],
    ['glass', 'glasses'],
    ['globe', 'globes'],
    ['goat', 'goats'],
    ['goose', 'geese'],
    ['greeting', 'greetings'],
    ['guitar', 'guitars'],
    ['gulf', 'gulfs'],
    ['gun', 'guns'],
    // ['hair', 'hairs'],
    ['half', 'halves'],
    ['halibut', 'halibut'],
    ['halo', 'halos'],
    ['hammer', 'hammers'],
    ['hand', 'hands'],
    ['hat', 'hats'],
    ['helmet', 'helmets'],
    ['hero', 'heroes'],
    ['horse', 'horses'],
    ['hour', 'hours'],
    ['house', 'houses'],
    ['index', 'indices'],
    ['insect', 'insects'],
    ['jar', 'jars'],
    ['jellyfish', 'jellyfish'],
    ['juice', 'juices'],
    ['key', 'keys'],
    ['kiss', 'kisses'],
    ['kite', 'kites'],
    ['kitten', 'kittens'],
    ['knife', 'knives'],
    ['lady', 'ladies'],
    ['lake', 'lakes'],
    ['lamp', 'lamps'],
    ['language', 'languages'],
    ['laugh', 'laughs'],
    ['leaf', 'leaves'],
    ['light', 'lights'],
    ['lion', 'lions'],
    ['lip', 'lips'],
    ['lipstick', 'lipsticks'],
    ['lock', 'locks'],
    ['magazine', 'magazines'],
    ['man', 'men'],
    ['mango', 'mangos'],
    ['map', 'maps'],
    ['memento', 'mementos'],
    ['menu', 'menus'],
    ['milk', 'milks'],
    ['mirror', 'mirrors'],
    ['monitor', 'monitors'],
    ['monkey', 'monkeys'],
    ['moon', 'moons'],
    ['moose', 'moose'],
    ['motto', 'mottos'],
    ['mountain', 'mountains'],
    ['mouse', 'mice'],
    ['mug', 'mugs'],
    ['necklace', 'necklaces'],
    ['net', 'nets'],
    ['neurosis', 'neuroses'],
    ['night', 'nights'],
    ['noise', 'noises'],
    ['oak', 'oaks'],
    ['ocean', 'oceans'],
    ['orange', 'oranges'],
    ['ostrich', 'ostriches'],
    ['paintbrush', 'paintbrushes'],
    ['panther', 'panthers'],
    ['paper', 'papers'],
    ['pear', 'pears'],
    ['pen', 'pens'],
    ['pencil', 'pencils'],
    ['person', 'people'],
    ['phone', 'phones'],
    ['picture', 'pictures'],
    ['pillow', 'pillows'],
    ['pizza', 'pizzas'],
    ['plan', 'plans'],
    ['planet', 'planets'],
    ['plant', 'plants'],
    ['plate', 'plates'],
    ['potato', 'potatoes'],
    ['prayer', 'prayers'],
    ['puppy', 'puppies'],
    ['purpose', 'purposes'],
    ['purse', 'purses'],
    ['queen', 'queens'],
    ['quilt', 'quilts'],
    ['rabbit', 'rabbits'],
    ['radio', 'radios'],
    ['rain', 'rains'],
    ['ring', 'rings'],
    ['river', 'rivers'],
    ['robot', 'robots'],
    ['rock', 'rocks'],
    ['room', 'rooms'],
    ['rug', 'rugs'],
    ['ruler', 'rulers'],
    ['salad', 'salads'],
    ['salmon', 'salmon'],
    ['sandwich', 'sandwiches'],
    ['scarf', 'scarves'],
    ['seal', 'seals'],
    ['shark', 'sharks'],
    ['sheep', 'sheep'],
    ['sheepdog', 'sheepdogs'],
    ['shirt', 'shirts'],
    ['shoe', 'shoes'],
    ['skeptic', 'skeptics'],
    ['ski', 'skis'],
    ['sky', 'skies'],
    ['smile', 'smiles'],
    ['snack', 'snacks'],
    ['snail', 'snails'],
    ['snake', 'snakes'],
    ['sock', 'socks'],
    ['sofa', 'sofas'],
    ['solo', 'solos'],
    ['soup', 'soups'],
    ['spacecraft', 'spacecraft'],
    ['spider', 'spiders'],
    ['spoof', 'spoofs'],
    ['spoon', 'spoons'],
    ['star', 'stars'],
    ['stomach', 'stomachs'],
    ['stone', 'stones'],
    ['stopwatch', 'stopwatches'],
    ['story', 'stories'],
    ['student', 'students'],
    ['studio', 'studios'],
    ['suitcase', 'suitcases'],
    ['sun', 'suns'],
    ['table', 'tables'],
    ['tactic', 'tactics'],
    ['telephone', 'telephones'],
    ['telescope', 'telescopes'],
    ['television', 'televisions'],
    ['the bruise', 'the bruises'],
    ['the exercise', 'the exercises'],
    ['the prize', 'the prizes'],
    ['the promise', 'the promises'],
    ['the raise', 'the raises'],
    ['the size', 'the sizes'],
    ['tie', 'ties'],
    ['tiger', 'tigers'],
    ['toothbrush', 'toothbrushes'],
    ['tornado', 'tornados'],
    ['towel', 'towels'],
    ['train', 'trains'],
    ['tree', 'trees'],
    ['trout', 'trout'],
    ['truck', 'trucks'],
    ['tuna', 'tuna'],
    ['tuxedo', 'tuxedos'],
    ['umbrella', 'umbrellas'],
    ['valley', 'valleys'],
    ['vase', 'vases'],
    ['vehicle', 'vehicles'],
    ['violin', 'violins'],
    ['voice', 'voices'],
    ['volcano', 'volcanoes'],
    ['wagon', 'wagons'],
    ['wallet', 'wallets'],
    ['watch', 'watches'],
    ['wave', 'waves'],
    ['whale', 'whales'],
    ['whisper', 'whispers'],
    ['window', 'windows'],
    ['witch', 'witches'],
    ['wolf', 'wolves'],
    ['woman', 'women'],
    ['x-ray', 'x-rays'],
    ['xylophone', 'xylophones'],
    ['yacht', 'yachts'],
    // ['yo-yo', 'yo-yos'],
    ['zebra', 'zebras'],
    ['zoo', 'zoos'],
    // ['mayor of chicago', 'mayors of chicago'],
    // ['zero', 'zeros'],
    // ["Barrymore", "Barrymores"],
    //test that plural.pluralize()==plural..
    // ['swim', 'swims'],
  ]
  arr.forEach(function (a) {
    let doc = nlp(a[0])
    doc.tag('Noun').compute('chunks')
    let str = doc.nouns().toPlural().text()
    t.equal(str, a[1], here + '[toPlural] ' + a[0])

    doc = nlp(a[1])
    doc.tag('Noun').compute('chunks')
    str = doc.nouns().toSingular().text()
    t.equal(str, a[0], here + '[toSingular] ' + a[0])

    doc = nlp(a[0])
    doc.tag('Noun').compute('chunks')
    str = doc.nouns().toSingular().text()
    t.equal(str, a[0], here + '[stay-singular] ' + a[0])

  })
  t.end()
})

test('toPlural - longer:', function (t) {
  let arr = [
    [`we commended him for his hamburger`, `we commended him for his hamburgers`],
    [`everything i say, he liked`, `everything i say, he liked`],
    [`the tornado in Barrie swept through downtown`, `the tornados in Barrie swept through downtown`],
    [`no cookie until after dinner`, `no cookies until after dinners`],
    [`my finger looked green afterwards`, `my fingers looked green afterwards`],

    // ["keep a cool head", "keep cool heads"],
    ["petsmart application?", "petsmart applications?"],
    ["attacked by a bear?", "attacked by bears?"],
    // ["Gal's DIARY: He ws quiet 2dy.", "Gal's DIARY: He ws quiet 2dy."],
    // ["All right relax.", "All right relax."],
    ["HP to be self-sufficient by 2010", "HP to be self-sufficient by 2010"],
    ["the woman", "the women"],
    ["the woman isn't dead.", "the women are not dead."],
    [`my finger was green afterwards`, `my fingers were green afterwards`],
  ]
  arr.forEach(function (a) {
    let doc = nlp(a[0])
    doc.compute('chunks')
    doc.nouns().toPlural()
    t.equal(doc.text(), a[1], here + '[toPlural] ' + a[0])
  })
  t.end()
})
