import test from 'tape'
import nlp from '../_lib.js'
const here = '[three/more-coreference] '

let arr = [
  `(Sarah) walked into the room. [She] immediately noticed the mess on the floor.`,
  `(Michael and Emily) went to the movies. [They] bought tickets for the latest blockbuster.`,
  `(Lisa) finished her presentation. [She] received a round of applause from the audience.`,
  `(David and Rebecca) decided to go for a hike. [They] packed sandwiches and water bottles.`,
  `(Mark) loves playing the guitar. [He] practices every day to improve his skills.`,
  `(Emma) forgot her umbrella at home. [She] got soaked in the rain on her way to work.`,
  `(The students) worked hard on their project. [They] were proud of the final result.`,
  `(Alexander) scored the winning goal. [He] celebrated with his teammates on the field.`,
  `(Mary and Tom) are going on vacation. [They] are excited to explore a new destination.`,
  `(Rachel) lost her phone. [She] retraced her steps to find it.`,
  `(Robert) woke up late. [He] rushed to get ready for work.`,
  `(The cat) jumped onto the counter. [It] knocked over a glass.`,
  `(Jennifer and Andrew) are getting married. [They] are planning a beautiful wedding.`,
  `(The dog) wagged its tail. [It] was happy to see its owner.`,
  `(Amy) baked cookies. [She] shared them with her friends.`,
  `(The children) played in the park. [They] laughed and ran around.`,
  `(Mr.Johnson) is a teacher. [He] enjoys helping his students learn.`,
  `(The book) fell off the shelf. [It] landed with a loud thud.`,
  `(Karen) is a talented artist. [She] painted a stunning landscape.`,
  `(The car) broke down on the highway. [It] had to be towed.`,
  `(James and Lily) won the game. [They] celebrated their victory.`,
  `(The baby) cried all night. [It] needed to be comforted.`,
  `(Sarah) is going on a trip. [She] packed her suitcase.`,
  `(The flowers) bloomed in the garden. [They] added a splash of color.`,
  `(John) finished his homework. [He] rewarded himself with a movie.`,
  `(The computer) crashed. [It] lost all the unsaved data.`,
  `(Samantha and David) adopted a puppy. [They] named it Max.`,
  `(The sun) set behind the mountains. [It] painted the sky with hues of orange.`,
  `(Peter) won the race. [He] crossed the finish line first.`,
  `(The phone) rang. [It] startled everyone in the room.`,
  `(The cookies) smelled delicious. [They] were freshly baked.`,
  `(Maria) loves to dance. [She] dreams of becoming a professional dancer.`,
  `(The movie) was entertaining. [It] kept the audience engaged.`,
  `(Jack and Emily) built a sandcastle. [They] used buckets and shovels.`,
  `(The rain) stopped. [It] left behind glistening droplets on the leaves.`,
  `(Jessica) wrote a poem. [She] shared it with her friends.`,
  `(The restaurant) was crowded. [It] had a long waiting list.`,
  `(Mike) won the lottery. [He] couldn't believe his luck.`,
  `(The alarm) went off. [It] woke everyone up.`,
  `(Emma and Ethan) went on a picnic. [They] enjoyed the sunny weather.`,
  `(The clock) struck midnight. [It] signaled the start of a new day.`,
  `(Alex) fixed the broken chair. [He] used a hammer and nails.`,
  `(The storm) raged outside. [It] made loud thundering sounds.`,
  `(Olivia) received a promotion. [She] celebrated with her colleagues.`,
  `(The guitar) was out of tune. [It] needed to be adjusted.`,
  `(Daniel and Michelle) cooked dinner. [They] prepared a delicious meal.`,
  `(The plane) took off. [It] soared into the sky.`,
  `(Lucas) lost his keys. [He] searched everywhere to find them.`,
  `(The puzzle) was challenging. [It] took hours to complete.`,
  `(Sophie) found a seashell. [She] kept it as a souvenir.`,
  `(The fire) crackled in the fireplace. [It] provided warmth on a cold night.`,
  `(Andrew) fixed his bike. [He] tightened the loose screws.`,
  `(The news) shocked everyone. [It] was unexpected.`,
  `(Emily and Daniel) danced at the party. [They] had a great time.`,
  `(The baby) smiled at its mother. [It] recognized her face.`,
  `(Alexa) wrote a letter. [She] addressed it to her pen pal.`,
  `(The movie) received rave reviews. [It] became a box office hit.`,
  `(The snow) covered the ground. [It] created a winter wonderland.`,
  `(Jacob) scored a goal. [He] was cheered on by the crowd.`,
  `(The painting) hung on the wall. [It] caught everyone's attention.`,
  `  (Lisa) studied all night. [She] wanted to ace the exam.`,
  `(The dog) barked loudly. [It] alerted the family of an intruder.`,
  `(Mike and Sarah) went shopping. [They] bought new clothes for the summer.`,
  `(The phone) vibrated. [It] signaled a new message.`,
  `(David) finished reading the book. [He] was captivated by the story.`,
  `(The flowers) wilted in the heat. [They] needed water to revive.`,
  `(Anna) traveled to Paris. [She] admired the Eiffel Tower.`,
  `(The cake) smelled delicious. [It] was freshly baked.`,
  `(Jason) fixed the leaky faucet. [He] used a wrench to tighten it.`,
  `(The train) arrived at the station. [It] was right on time.`,
  `(The baby) giggled. [It] found something funny.`,
  `(Oliver and Mia) built a sandcastle. [They] decorated it with seashells.`,
  `(The movie) made everyone laugh. [It] was a hilarious comedy.`,
  `(Sophia) wrote a song. [She] performed it at a local café.`,
  `(The rain) poured down. [It] drenched everyone in seconds.`,
  `(Lucas) lost his way in the forest. [He] relied on a compass to find his way back.`,
  `(The tree) provided shade. [It] sheltered the picnic - goers from the sun.`,
  `(Emily) painted a beautiful landscape. [She] used vibrant colors.`,
  `(The soccer team) won the championship. [They] celebrated with a trophy.`,
  `(The traffic) was heavy. [It] caused delays on the road.`,
  `(Jacob) played the piano. [He] composed a melodious tune.`,
  `(The cookie jar) was empty. [It] needed to be refilled.`,
  `(Emma and Ethan) watched a movie. [They] snuggled under a blanket.`,
  `(The firework) exploded in the sky. [It] lit up the night.`,
  `(Sophie) lost her wallet. [She] retraced her steps to find it.`,
  `(The book) captivated the readers. [It] had an intriguing plot.`,
  `(Alex) cooked dinner. [He] prepared a delicious meal from scratch.`,
  `(The waves) crashed against the shore. [They] created a soothing sound.`,
  `(Megan) rode her bicycle. [She] enjoyed the breeze in her hair.`,
  `(The clock) struck twelve. [It] marked the start of a new day.`,
  `(Emily) received a gift. [She] unwrapped it with excitement.`,
  `(The concert) started. [It] showcased talented musicians.`,
  `(David and Lily) planted flowers in the garden. [They] used gardening tools.`,
  `(The storm) passed. [It] left a rainbow in its wake.`,
  `(Sophia) won a singing competition. [She] was awarded a trophy.`,
  `(The butterfly) fluttered its wings. [It] landed on a flower.`,
  `(Adam) fixed the broken window. [He] used a hammer and nails.`,
  `(The snow) fell softly. [It] covered the ground in a white blanket.`,
  `(Emma) found a treasure map. [She] embarked on an adventure.`,
  `(The candle) flickered. [It] created a warm and cozy ambiance.`,
  `(Jason and Olivia) danced at the party. [They] showed off their moves.`,
  `(The coffee) brewed. [It] filled the room with a rich aroma.`,
  `(Sophie) won a scholarship. [She] was thrilled with the opportunity.`,
  `(The cat) purred. [It] enjoyed being petted.`,
  `(Daniel) built a birdhouse. [He] used wood and nails.`,
  `(The play) received rave reviews. [It] attracted a large audience.`,
  `(Amy) lost her voice. [She] couldn't speak for a week.`,
  `  (The mountain) stood tall. [It] offered a breathtaking view.`,
  `(Luke) scored a touchdown. [He] was cheered on by his teammates.`,
  `(The painting) hung in the gallery. [It] was admired by art enthusiasts.`,
  `(Sophia) woke up early. [She] wanted to catch the sunrise.`,
  `(The dog) wagged its tail. [It] greeted its owner with excitement.`,
  `(John and Emily) planned a surprise party. [They] invited all their friends.`,
  `(The phone) rang incessantly. [It] interrupted the quiet atmosphere.`,
  `(Oliver) finished his workout. [He] felt energized and accomplished.`,
  `(The flowers) bloomed in vibrant colors. [They] attracted bees and butterflies.`,
  `(Emma) traveled to Japan. [She] explored ancient temples and tasted sushi.`,
  `(The cake) tasted delicious. [It] melted in their mouths.`,
  `(Daniel) fixed the flat tire. [He] used a jack to lift the car.`,
  `(The train) departed from the station. [It] left a trail of smoke behind.`,
  `(The baby) took its first steps. [It] stumbled but kept trying.`,
  `(Alicia and Liam) built a sandcastle. [They] decorated it with seashells and flags.`,
  `(The movie) kept everyone on the edge of their seats. [It] was a thrilling suspense.`,
  `(Sarah) wrote a heartfelt letter. [She] sealed it with a kiss.`,
  `(The rain) drizzled lightly. [It] created a soothing atmosphere.`,
  `(Lucas) lost his wallet. [He] retraced his steps to find it.`,
  `(The tree) swayed in the wind. [It] provided shade and shelter.`,
  `(Emily) painted a stunning portrait. [She] captured the subject's essence.`,
  `  (The soccer team) scored a goal. [They] celebrated with cheers and high - fives.`,
  `(The traffic) cleared up. [It] allowed for a smooth commute.`,
  `(Jacob) played the guitar. [He] strummed the chords with passion.`,
  `(The cookie jar) was full. [It] tempted everyone with its sweet treats.`,
  `(Emma and Ethan) watched a sunset. [They] marveled at the colors in the sky.`,
  `(The firework) lit up the night sky. [It] dazzled everyone with its brilliance.`,
  `(Sophie) lost her sunglasses. [She] searched her bag frantically to find them.`,
  `(The book) transported the readers to a different world. [It] ignited their imagination.`,
  `(Alex) cooked a gourmet meal. [He] used fresh ingredients and intricate techniques.`,
  `(The waves) crashed against the rocks. [They] created a mesmerizing spectacle.`,
  `(Megan) rode her horse. [She] galloped across the open fields.`,
  `(The clock) chimed midnight. [It] marked the start of a new day.`,
  `(Emily) received a bouquet of roses. [She] blushed with delight.`,
  `(The concert) ended with a standing ovation. [It] left the audience wanting more.`,
  `(David and Lily) planted a vegetable garden. [They] used compost and watered diligently.`,
  `(The storm) passed, revealing a rainbow. [It] brought a sense of awe and wonder.`,
  `(Sophia) won a prestigious award. [She] felt honored and proud.`,
  `(The butterfly) fluttered gracefully. [It] added beauty to the garden.`,
  `(Adam) fixed the leaky roof. [He] used a ladder and roofing materials.`,
  `(The snow) blanketed the landscape. [It] transformed it into a winter wonderland.`,
  `(Emma) found a hidden treasure. [She] rejoiced with excitement.`,
  `(The candle) flickered softly. [It] created a warm and cozy ambiance.`,
  `(Jason and Olivia) danced under the stars. [They] twirled and laughed.`,
  `(The coffee) brewed slowly. [It] filled the room with its rich aroma.`,
  `(Sophie) won a scholarship. [She] was overjoyed with the opportunity.`,
  `(The cat) curled up on the window sill. [It] basked in the sunlight.`,
  `(Daniel) built a bird feeder. [He] used wood and nails to assemble it.`,
  `(The play) received critical acclaim. [It] showcased outstanding performances.`,
  `(Amy) lost her voice. [She] communicated through written notes.`,
  `(The mountain) loomed majestically. [It] challenged climbers with its height.`,
  `(Luke) scored a home run. [He] was cheered on by the crowd.`,
  `(The painting) hung in an art gallery. [It] captivated viewers with its beauty.`,
  `(Sarah) woke up refreshed. [She] had a restful night's sleep.`,
  `(The dog) chased its tail. [It] seemed endlessly amused.`,
  `(Michael and Emily) planned a picnic. [They] packed sandwiches and fruits.`,
  `(The phone) buzzed with notifications. [It] demanded attention.`,
  `(Oliver) completed a crossword puzzle. [He] felt accomplished.`,
  `(The flowers) swayed in the breeze. [They] perfumed the air with their fragrance.`,
  `(Emma) explored a hidden cave. [She] discovered ancient paintings on the walls.`,
  `(The cake) melted in their mouths. [It] was incredibly moist and flavorful.`,
  `(Daniel) fixed a leaky faucet. [He] replaced the worn-out washer.`,
  `(The train) sped through the countryside. [It] offered breathtaking views.`,
  `(The baby) gurgled with joy. [It] brought smiles to everyone's faces.`,
  `(Sophia and Ethan) built a sandcastle. [They] sculpted intricate details.`,
  `(The movie) tugged at their heartstrings. [It] evoked a rollercoaster of emotions.`,
  `(Sarah) composed a heartfelt poem. [She] poured her emotions into every line.`,
  `(The rain) pitter-pattered on the roof. [It] created a soothing rhythm.`,
  `(Lucas) lost his keys. [He] retraced his steps to find them.`,
  `(The tree) provided a shady spot. [It] invited people to rest under its branches.`,
  `(Emily) painted a breathtaking sunset. [She] captured the vivid colors of the sky.`,
  `(The soccer team) celebrated a victory. [They] lifted the trophy with pride.`,
  `(The traffic) flowed smoothly. [It] allowed for a quick and hassle-free commute.`,
  `(Jacob) played the violin. [He] produced enchanting melodies.`,
  `(The cookie jar) was filled to the brim. [It] enticed everyone with its sweet treats.`,
  `(Emma and Ethan) hiked up a mountain. [They] enjoyed panoramic views from the top.`,
  `(The firework) illuminated the night sky. [It] dazzled with vibrant colors.`,
  `(Sophie) found her lost earrings. [She] felt relieved and happy.`,
  `(The book) transported them to a fantasy realm. [It] captivated their imaginations.`,
  `(Alex) prepared a gourmet feast. [He] crafted culinary masterpieces.`,
  `(The waves) gently lapped the shore. [They] created a serene atmosphere.`,
  `(Megan) rode a roller coaster. [She] screamed with exhilaration.`,
  `(The clock) struck noon. [It] marked the midpoint of the day.`,
  `(Emily) received a handwritten letter. [She] cherished the personal touch.`,
  `(The concert) resonated with the audience. [It] left lasting memories.`,
  `(David and Lily) nurtured a vegetable garden. [They] harvested fresh produce.`,
  `(The storm) subsided, revealing a clear sky. [It] brought a sense of calm.`,
  `(Sophia) won a prestigious art competition. [She] felt honored and proud.`,
  `(The butterfly) fluttered gracefully from flower to flower. [It] added beauty to the garden.`,
  `(Adam) fixed a broken chair. [He] used glue and screws.`,
  `(The snow) glistened under the sunlight. [It] created a winter wonderland.`,
  `(Emma) embarked on a thrilling treasure hunt. [She] followed cryptic clues.`,
  `(The candle) emitted a soft glow. [It] created a cozy ambiance.`,
  `(Jason and Olivia) waltzed across the dance floor. [They] twirled with elegance.`,
  `(The coffee) brewed to perfection. [It] released a rich aroma.`,
  `(Sophie) received a scholarship offer. [She] felt grateful and excited.`,
  `(The cat) purred contentedly. [It] curled up in a cozy spot.`,
  `(Daniel) built a treehouse. [He] used sturdy planks and a ladder.`,
  `(The play) enthralled the audience. [It] showcased outstanding performances.`,
  `(Amy) lost her voice. [She] communicated through gestures and expressions.`,
  `(The mountain) loomed majestically over the landscape. [It] challenged adventurous climbers.`,
  `(Luke) scored a winning point. [He] was hailed as the hero of the game.`,
  `(The painting) adorned the gallery walls. [It] captivated visitors with its beauty.`,
]

test('more-coreference:', function (t) {
  arr.forEach(str => {
    let subj = str.match(/\(.*?\)/)[0].replace(/[()]/g, '').toLowerCase()
    let pronoun = str.match(/\[.*?\]/)[0].replace(/[[\]]/g, '').toLowerCase()
    let msg = here + subj + ' → ' + pronoun
    let doc = nlp(str)
    let p = doc.pronouns().notIf('#Possessive').hasReference()
    t.equal(p.text('normal'), pronoun, msg)

  })
})
