import test from 'tape'
import nlp from '../_lib.js'
const here = '[three/adj-comparative] '

test('toComparative misc', function (t) {
  let doc = nlp('he is really cool')
  doc.adjectives().toComparative()
  t.equal(doc.text(), 'he is really cooler', here + 'really cool')

  doc = nlp('he is simply cooler')
  doc.adjectives().toComparative()
  t.equal(doc.text(), 'he is simply cooler', here + 'simply cooler')

  doc = nlp('he is simply the coolest')
  doc.adjectives().toComparative()
  t.equal(doc.text(), 'he is simply the cooler', here + 'simply coolest')

  t.end()
})


test('.toComparative():', function (t) {
  let arr = [
    ["high", "higher"],
    ["great", "greater"],
    ["further", "further"],
    ["good", "better"],
    ["low", "lower"],
    ["large", "larger"],
    ["small", "smaller"],
    ["old", "older"],
    ["broad", "broader"],
    ["strong", "stronger"],
    // ["few", "fewer"],
    ["long", "longer"],
    ["easy", "easier"],
    ["early", "earlier"],
    ["lesser", "lesser"],
    ["wide", "wider"],
    ["young", "younger"],
    ["late", "later"],
    // ["close", "closer"],
    ["short", "shorter"],
    ["fast", "faster"],
    ["slow", "slower"],
    ["clear", "clearer"],
    ["weak", "weaker"],
    ["safe", "safer"],
    ["new", "newer"],
    ["healthy", "healthier"],
    ["big", "bigger"],
    ["bad", "worse"],
    ["lame", "lamer"],
    ["large", "larger"],
    ["late", "later"],
    ["lewd", "lewder"],
    ["likely", "likelier"],
    ["little", "littler"],
    ["lively", "livelier"],
    ["lofty", "loftier"],
    ["soft", "softer"],
    ["steep", "steeper"],
    ["stiff", "stiffer"],
    ['angry', 'angrier'],
    ['bad', 'worse'],
    ['bald', 'balder'],
    ['bawdy', 'bawdier'],
    ['big', 'bigger'],
    ['black', 'blacker'],
    ['bland', 'blander'],
    ['blond', 'blonder'],
    ['bloody', 'bloodier'],
    ['blue', 'bluer'],
    ['bold', 'bolder'],
    ['bored', 'boreder'],
    ['boring', 'boringer'],
    ['bouncy', 'bouncier'],
    ['brash', 'brasher'],
    ['brave', 'braver'],
    ['brief', 'briefer'],
    ['bright', 'brighter'],
    ['broad', 'broader'],
    ['buff', 'buffer'],
    ['burly', 'burlier'],
    ['busy', 'busier'],
    ['calm', 'calmer'],
    ['camp', 'camper'],
    ['catchy', 'catchier'],
    ['cheap', 'cheaper'],
    ['cheesy', 'cheesier'],
    ['chilly', 'chillier'],
    ['clean', 'cleaner'],
    ['clear', 'clearer'],
    ['clever', 'cleverer'],
    ['close', 'closer'],
    ['cloudy', 'cloudier'],
    ['clumsy', 'clumsier'],
    ['coarse', 'coarser'],
    ['cold', 'colder'],
    ['cool', 'cooler'],
    ['costly', 'costlier'],
    ['cozy', 'cozier'],
    ['crazy', 'crazier'],
    ['crisp', 'crisper'],
    ['cruel', 'crueler'],
    ['cuddly', 'cuddlier'],
    ['curly', 'curlier'],
    ['cute', 'cuter'],
    ['damp', 'damper'],
    ['dark', 'darker'],
    ['deadly', 'deadlier'],
    ['dear', 'dearer'],
    ['deep', 'deeper'],
    ['dense', 'denser'],
    ['diffuse', 'diffuser'],
    ['dim', 'dimmer'],
    ['dire', 'direr'],
    ['dirty', 'dirtier'],
    ['divine', 'diviner'],
    ['drunk', 'drunker'],
    ['dry', 'drier'],
    ['dull', 'duller'],
    ['dumb', 'dumber'],
    ['early', 'earlier'],
    ['easy', 'easier'],
    ['edgy', 'edgier'],
    ['eerie', 'eerier'],
    ['empty', 'emptier'],
    ['faint', 'fainter'],
    ['fair', 'fairer'],
    ['fake', 'faker'],
    ['fancy', 'fancier'],
    ['far', 'further'],
    ['fast', 'faster'],
    ['fat', 'fatter'],
    ['faulty', 'faultier'],
    ['feeble', 'feebler'],
    ['few', 'fewer'],
    ['fierce', 'fiercer'],
    ['filthy', 'filthier'],
    ['fine', 'finer'],
    ['firm', 'firmer'],
    ['flat', 'flatter'],
    ['foamy', 'foamier'],
    ['foggy', 'foggier'],
    ['fond', 'fonder'],
    ['foul', 'fouler'],
    ['frail', 'frailer'],
    ['frank', 'franker'],
    ['free', 'freer'],
    ['fresh', 'fresher'],
    ['friendly', 'friendlier'],
    ['full', 'fuller'],
    ['fun', 'funer'],
    ['funny', 'funnier'],
    ['furry', 'furrier'],
    ['gauche', 'gaucher'],
    ['gaudy', 'gaudier'],
    ['gay', 'gaier'],
    ['gentle', 'gentler'],
    ['ghastly', 'ghastlier'],
    ['ghostly', 'ghostlier'],
    ['giddy', 'giddier'],
    ['glad', 'gladder'],
    ['glib', 'glibber'],
    ['gloomy', 'gloomier'],
    ['gold', 'golder'],
    ['good', 'better'],
    ['goofy', 'goofier'],
    ['grand', 'grander'],
    ['grave', 'graver'],
    ['gray', 'grayer'],
    ['great', 'greater'],
    ['greedy', 'greedier'],
    ['green', 'greener'],
    ['grisly', 'grislier'],
    ['groovy', 'groovier'],
    ['gross', 'grosser'],
    ['gruesome', 'gruesomer'],
    ['handsome', 'handsomer'],
    ['handy', 'handier'],
    ['happy', 'happier'],
    ['hard', 'harder'],
    ['hardy', 'hardier'],
    ['harsh', 'harsher'],
    ['heady', 'headier'],
    ['healthy', 'healthier'],
    ['hearty', 'heartier'],
    ['heavy', 'heavier'],
    ['hefty', 'heftier'],
    ['high', 'higher'],
    ['hilly', 'hillier'],
    ['holy', 'holier'],
    ['homely', 'homelier'],
    ['hot', 'hotter'],
    ['huge', 'huger'],
    ['humble', 'humbler'],
    ['humid', 'humider'],
    ['hungry', 'hungrier'],
    ['icy', 'icier'],
    ['jolly', 'jollier'],
    ['juicy', 'juicier'],
    ['keen', 'keener'],
    ['kind', 'kinder'],
    ['lame', 'lamer'],
    ['large', 'larger'],
    ['late', 'later'],
    ['lazy', 'lazier'],
    ['lean', 'leaner'],
    ['leery', 'leerier'],
    ['lengthy', 'lengthier'],
    ['lewd', 'lewder'],
    ['light', 'lighter'],
    ['likely', 'likelier'],
    ['limp', 'limper'],
    ['little', 'littler'],
    ['lively', 'livelier'],
    ['lofty', 'loftier'],
    ['lonely', 'lonelier'],
    ['long', 'longer'],
    ['loose', 'looser'],
    ['loud', 'louder'],
    ['lousy', 'lousier'],
    ['lovely', 'lovelier'],
    ['low', 'lower'],
    ['lucky', 'luckier'],
    ['mad', 'madder'],
    ['mean', 'meaner'],
    ['measly', 'measlier'],
    ['meaty', 'meatier'],
    ['meek', 'meeker'],
    ['mellow', 'mellower'],
    ['messy', 'messier'],
    ['mild', 'milder'],
    ['moist', 'moister'],
    ['moody', 'moodier'],
    ['nappy', 'nappier'],
    ['narrow', 'narrower'],
    ['nasty', 'nastier'],
    ['near', 'nearer'],
    ['neat', 'neater'],
    ['new', 'newer'],
    ['nice', 'nicer'],
    ['nimble', 'nimbler'],
    ['noble', 'nobler'],
    ['noisy', 'noisier'],
    ['nosy', 'nosier'],
    ['numb', 'number'],
    ['odd', 'odder'],
    ['oily', 'oilier'],
    ['old', 'older'],
    ['pale', 'paler'],
    ['petty', 'pettier'],
    ['phony', 'phonier'],
    ['pink', 'pinker'],
    ['poor', 'poorer'],
    ['pretty', 'prettier'],
    ['prickly', 'pricklier'],
    ['proud', 'prouder'],
    ['puny', 'punier'],
    ['pure', 'purer'],
    ['quick', 'quicker'],
    ['quiet', 'quieter'],
    ['rainy', 'rainier'],
    ['rare', 'rarer'],
    ['raw', 'rawer'],
    ['ready', 'readier'],
    ['rich', 'richer'],
    ['right', 'righter'],
    ['ripe', 'riper'],
    ['risky', 'riskier'],
    ['ritzy', 'ritzier'],
    ['roomy', 'roomier'],
    ['rosy', 'rosier'],
    ['rough', 'rougher'],
    ['round', 'rounder'],
    ['rude', 'ruder'],
    ['sad', 'sadder'],
    ['safe', 'safer'],
    ['saintly', 'saintlier'],
    ['salty', 'saltier'],
    ['savvy', 'savvier'],
    ['scanty', 'scantier'],
    ['scarce', 'scarcer'],
    // ['scared', 'scarier'],
    ['scary', 'scarier'],
    ['sexy', 'sexier'],
    ['shady', 'shadier'],
    ['shallow', 'shallower'],
    ['sharp', 'sharper'],
    ['shiny', 'shinier'],
    ['short', 'shorter'],
    ['shrill', 'shriller'],
    ['shy', 'shyer'],
    ['sick', 'sicker'],
    ['sickly', 'sicklier'],
    ['silky', 'silkier'],
    ['silly', 'sillier'],
    ['simple', 'simpler'],
    ['skinny', 'skinnier'],
    ['slack', 'slacker'],
    ['sleek', 'sleeker'],
    ['sleepy', 'sleepier'],
    ['slight', 'slighter'],
    ['slim', 'slimmer'],
    ['slimy', 'slimier'],
    ['sloppy', 'sloppier'],
    ['slow', 'slower'],
    ['sly', 'slier'],
    ['small', 'smaller'],
    ['smart', 'smarter'],
    ['smelly', 'smellier'],
    ['smooth', 'smoother'],
    ['soft', 'softer'],
    ['solemn', 'solemner'],
    ['soon', 'sooner'],
    ['sore', 'sorer'],
    ['sorry', 'sorrier'],
    ['sound', 'sounder'],
    ['sparse', 'sparser'],
    ['speedy', 'speedier'],
    ['spicy', 'spicier'],
    ['sprightly', 'sprightlier'],
    ['square', 'squarer'],
    ['stale', 'staler'],
    ['stark', 'starker'],
    ['steady', 'steadier'],
    ['steep', 'steeper'],
    ['stern', 'sterner'],
    ['stiff', 'stiffer'],
    ['stingy', 'stingier'],
    ['stout', 'stouter'],
    ['straight', 'straighter'],
    ['strict', 'stricter'],
    ['strong', 'stronger'],
    ['stupid', 'stupider'],
    ['sturdy', 'sturdier'],
    ['subtle', 'subtler'],
    ['sweet', 'sweeter'],
    ['swift', 'swifter'],
    ['tall', 'taller'],
    ['tame', 'tamer'],
    ['tawdry', 'tawdrier'],
    ['tense', 'tenser'],
    ['thick', 'thicker'],
    ['thin', 'thinner'],
    ['thirsty', 'thirstier'],
    ['tidy', 'tidier'],
    ['tight', 'tighter'],
    ['timely', 'timelier'],
    ['tiny', 'tinier'],
    ['tough', 'tougher'],
    ['trendy', 'trendier'],
    ['tricky', 'trickier'],
    ['trim', 'trimmer'],
    ['true', 'truer'],
    ['ugly', 'uglier'],
    ['unfriendly', 'unfriendlier'],
    ['unlikely', 'unlikelier'],
    ['unlucky', 'unluckier'],
    ['untidy', 'untidier'],
    ['vague', 'vaguer'],
    ['vain', 'vainer'],
    ['vast', 'vaster'],
    ['warm', 'warmer'],
    ['wary', 'warier'],
    ['weak', 'weaker'],
    ['wealthy', 'wealthier'],
    ['weary', 'wearier'],
    ['weird', 'weirder'],
    ['wet', 'wetter'],
    ['white', 'whiter'],
    ['wicked', 'wickeder'],
    ['wide', 'wider'],
    ['wild', 'wilder'],
    ['wily', 'wilier'],
    ['wise', 'wiser'],
    ['witty', 'wittier'],
    ['wrong', 'wronger'],
    ['young', 'younger'],
    ['zany', 'zanier'],


  ]
  arr.forEach(a => {
    let doc = nlp(a[0]).tag('Adjective')
    doc.adjectives().toComparative()
    t.equal(doc.text(), a[1], here + a[0])
  })
  t.end()
})





// test('.unchanged:', function (t) {
//   let arr = [
//     'energetic',
//     'compassionate',
//     'generous',
//     'ambitious',
//     'considerate',
//     'thorough',
//     'dependable',
//     'patient',
//     'successful',
//     'industrious',
//     'talented',
//     'diligent',
//     'skillful',
//     'supportive',
//     'adaptable',
//     'dynamic',
//     'imaginative',
//     'conscientious',
//     'organized',
//     'polished',
//     'polished',
//     'energetic',
//     'affectionate',
//     'determined',
//     'motivated',
//     'persistent',
//     'ingenious',
//     'thoughtful',
//     'popular',
//     'capable',
//     'loyal',
//     'flexible',
//     'dignified',
//     'skillful',
//     'amusing',
//     'meticulous',
//     'sensitive',
//     'balanced',
//     'sensible',
//     'honorable',
//     'enthusiastic',
//     'reliable',
//     'obedient',
//     'devoted',
//     'affable',
//     'adventurous',
//     'talented',
//     'creative',
//     'confident',
//     'thrifty',
//     'intuitive',
//     'resourceful',
//     'helpful',
//     'courageous',
//     'gentlemanly',
//     'considerate',
//     'energized',
//     'dominant',
//     'eloquent',
//     'resilient',
//     'insightful',
//     'practical',
//     'consistent',
//     'realistic',
//     'independent',
//     'discreet',
//     'diligent',
//     'mature',
//     'responsive',
//     'grateful',
//     'youthful',
//     'upbeat',
//     'gifted',
//     'united',
//     'optimistic',
//     'selfless',
//     'amiable',
//     'detail-oriented',
//     'positive',
//   ]
//   t.end()
// })

