import test from 'tape'
import nlp from '../_lib.js'
const here = '[three/verb-toPresent] '

let arr = [
  ['accidentally', 'accidental'],
  ['accordingly', null],
  ['admirably', 'admirable'],
  ['admittedly', 'admitted'],
  ['affectionately', 'affectionate'],
  ['agilely', 'agile'],
  ['agitatedly', 'agitated'],
  ['amazingly', 'amazing'],
  ['amiably', 'amiable'],
  ['amusedly', 'amused'],
  ['appreciably', 'appreciable'],
  ['aptly', 'apt'],
  ['arbitrarily', 'arbitrary'],
  ['astonishingly', 'astonishing'],
  ['astoundingly', 'astounding'],
  ['automatically', 'automatic'],
  ['awesomely', 'awesome'],
  ['badly', 'bad'],
  ['bashfully', 'bashful'],
  ['beautifully', 'beautiful'],
  ['boomingly', 'booming'],
  ['bravely', 'brave'],
  ['brightly', 'bright'],
  ['brilliantly', 'brilliant'],
  ['calmly', 'calm'],
  ['carelessly', 'careless'],
  ['celestially', 'celestial'],
  ['cheaply', 'cheap'],
  ['cheerfully', 'cheerful'],
  ['classically', 'classical'],
  ['confusedly', 'confused'],
  ['conscientiously', 'conscientious'],
  ['consummately', 'consummate'],
  ['conversely', null],
  ['courageously', 'courageous'],
  ['cozily', 'cozy'],
  ['creatively', 'creative'],
  ['credibly', 'credible'],
  ['critically', 'critical'],
  ['cruelly', 'cruel'],
  ['cynically', 'cynical'],
  ['daily', null],
  ['dazzlingly', 'dazzling'],
  ['dearly', 'dear'],
  ['deeply', 'deep'],
  ['delightfully', 'delightful'],
  ['desirably', 'desirable'],
  ['desperately', 'desperate'],
  ['deviously', 'devious'],
  ['distinguishedly', 'distinguished'],
  ['divinely', 'divine'],
  ['dramatically', 'dramatic'],
  ['dynamically', 'dynamic'],
  ['eagerly', 'eager'],
  ['early', null],
  ['earnestly', 'earnest'],
  ['ecologically', 'ecological'],
  ['electronically', 'electronic'],
  ['elegantly', 'elegant'],
  ['eminently', 'eminent'],
  ['emphatically', 'emphatic'],
  ['environmentally', 'environmental'],
  ['especially', null],
  ['exaltedly', 'exalted'],
  ['exceptionally', 'exceptional'],
  ['expectantly', 'expectant'],
  ['exponentially', 'exponential'],
  ['exquisitely', 'exquisite'],
  ['extravagantly', 'extravagant'],
  ['exuberantly', 'exuberant'],
  ['fabulously', 'fabulous'],
  ['fadedly', 'faded'],
  ['famously', 'famous'],
  ['fancily', 'fancy'],
  ['fantastically', 'fantastic'],
  ['fascinatingly', 'fascinating'],
  ['fastidiously', 'fastidious'],
  ['fiercely', 'fierce'],
  ['flashily', 'flashy'],
  ['flawlessly', 'flawless'],
  ['fleetingly', 'fleeting'],
  ['foolishly', 'foolish'],
  ['forsakenly', 'forsaken'],
  ['fragrantly', 'fragrant'],
  ['frivolously', 'frivolous'],
  ['fully', 'full'],
  ['funnily', 'funny'],
  ['furiously', 'furious'],
  ['fuzzily', 'fuzzy'],
  ['generously', 'generous'],
  ['genetically', 'genetic'],
  ['gently', 'gentle'],
  ['glitteringly', 'glittering'],
  ['globally', 'global'],
  ['gloriously', 'glorious'],
  ['gorgeously', 'gorgeous'],
  ['grandiosely', 'grandiose'],
  ['grandly', 'grand'],
  ['grievingly', 'grieving'],
  ['grimily', 'grimy'],
  ['grumpily', 'grumpy'],
  ['hallowedly', 'hallowed'],
  ['harshly', 'harsh'],
  ['humbly', 'humble'],
  ['humorously', 'humorous'],
  ['icily', 'icy'],
  ['idly', 'idle'],
  ['illustriously', 'illustrious'],
  ['imperfectly', 'imperfect'],
  ['impressively', 'impressive'],
  ['incomparably', 'incomparable'],
  ['incredibly', 'incredible'],
  ['inextricably', 'inextricable'],
  ['infamously', 'infamous'],
  ['innocently', 'innocent'],
  ['insultingly', 'insulting'],
  ['invariably', 'invariable'],
  ['ironically', 'ironic'],
  ['irritably', 'irritable'],
  ['jealously', 'jealous'],
  ['keenly', 'keen'],
  ['lavishly', 'lavish'],
  ['lazily', 'lazy'],
  ['legally', 'legal'],
  ['leggily', 'leggy'],
  ['limpidly', 'limpid'],
  ['locally', 'local'],
  ['loftily', 'lofty'],
  ['loudly', 'loud'],
  ['luxuriously', 'luxurious'],
  ['magnanimously', 'magnanimous'],
  ['magnificently', 'magnificent'],
  ['majestically', 'majestic'],
  ['mammothly', 'mammoth'],
  ['marvelously', 'marvelous'],
  ['mathematically', 'mathematical'],
  ['maturely', 'mature'],
  ['mechanically', 'mechanical'],
  ['methodically', 'methodical'],
  ['miraculously', 'miraculous'],
  ['miserably', 'miserable'],
  ['mistakenly', 'mistaken'],
  ['monumentally', 'monumental'],
  ['moodily', 'moody'],
  ['morally', 'moral'],
  ['mostly', null],
  ['mysteriously', 'mysterious'],
  ['namely', null],
  ['nervously', 'nervous'],
  ['nomadically', 'nomadic'],
  ['notably', 'notable'],
  ['obediently', 'obedient'],
  ['omnipotently', 'omnipotent'],
  ['only', null],
  ['oreintally', 'oreintal'],
  ['originally', 'original'],
  ['outstandingly', 'outstanding'],
  ['painfully', 'painful'],
  ['palatially', 'palatial'],
  ['partly', 'part'],
  ['patiently', 'patient'],
  ['peerlessly', 'peerless'],
  ['perceptibly', 'perceptible'],
  ['perfectly', 'perfect'],
  ['phenomenally', 'phenomenal'],
  ['physically', 'physical'],
  ['pluckily', 'plucky'],
  ['plushly', 'plush'],
  ['politically', 'political'],
  ['portentously', 'portentous'],
  ['potently', 'potent'],
  ['practically', 'practical'],
  ['praiseworthily', 'praiseworthy'],
  ['principally', 'principal'],
  ['prodigiously', 'prodigious'],
  ['profoundly', 'profound'],
  ['provocatively', 'provocative'],
  ['publicly', 'public'],
  ['quickly', 'quick'],
  ['quintessentially', 'quintessential'],
  ['rarely', 'rare'],
  ['remarkably', 'remarkable'],
  ['remotely', 'remote'],
  ['repulsively', 'repulsive'],
  ['resplendently', 'resplendent'],
  ['responsibly', 'responsible'],
  ['richly', 'rich'],
  ['ritzily', 'ritzy'],
  ['romantically', 'romantic'],
  ['roomily', 'roomy'],
  ['rosily', 'rosy'],
  ['roundly', 'round'],
  ['rudely', 'rude'],
  ['safely', 'safe'],
  ['saintly', null],
  ['saltily', 'salty'],
  ['savvily', 'savvy'],
  ['scarcely', 'scarce'],
  ['scaredly', 'scared'],
  ['scarily', 'scary'],
  ['seemingly', 'seeming'],
  ['sensationally', 'sensational'],
  ['severely', 'severe'],
  ['sharply', 'sharp'],
  ['shily', 'shy'],
  ['shrewdly', 'shrewd'],
  ['simply', 'simple'],
  ['singly', 'single'],
  ['singularly', 'singular'],
  ['sleekly', 'sleek'],
  ['sloppily', 'sloppy'],
  ['snazzily', 'snazzy'],
  ['sneakily', 'sneaky'],
  ['soaringly', 'soaring'],
  ['sorrowfully', 'sorrowful'],
  ['splendidly', 'splendid'],
  ['splendiferously', 'splendiferous'],
  ['statistically', 'statistical'],
  ['strikingly', 'striking'],
  ['strongly', 'strong'],
  ['stupendously', 'stupendous'],
  ['stupidly', 'stupid'],
  ['sublimely', 'sublime'],
  ['succinctly', 'succinct'],
  ['succulently', 'succulent'],
  ['superbly', 'superb'],
  ['superiorly', 'superior'],
  ['superlatively', 'superlative'],
  ['superly', 'super'],
  ['systematically', 'systematic'],
  ['systemically', 'systemic'],
  ['talentedly', 'talented'],
  ['tallly', 'tall'],
  ['tastefully', 'tasteful'],
  ['technically', 'technical'],
  ['technologically', 'technological'],
  ['tenderly', 'tender'],
  ['tenuously', 'tenuous'],
  ['terrifically', 'terrific'],
  ['theoretically', 'theoretical'],
  ['thinly', 'thin'],
  ['tidily', 'tidy'],
  ['toughly', 'tough'],
  ['trustworthily', 'trustworthy'],
  ['typically', 'typical'],
  ['unduly', null],
  ['unprecedentedly', 'unprecedented'],
  ['unquestionably', 'unquestionable'],
  ['unrivaledly', 'unrivaled'],
  ['vaguely', 'vague'],
  ['vapidly', 'vapid'],
  ['vertically', 'vertical'],
  ['vivaciously', 'vivacious'],
  ['voguishly', 'voguish'],
  ['warmly', 'warm'],
  ['wholly', 'whole'],
  ['wondrously', 'wondrous'],
  ['worthlessly', 'worthless'],
  ['zealously', 'zealous'],
  // ['prettyly', 'pretty'],
  // ['especially', 'special'],
  // ['lonlely', 'lonely'],
  // ['manly', 'male'],
  // ['uglily', 'ugly'],
  // ['well', 'good'],
  // ['', ''],
]

test('toAdjective:', function (t) {
  arr.forEach(a => {
    let doc = nlp(a[0]).compute('root')
    let json = doc.adverbs().json()[0] || { terms: [{}] }
    t.equal(json.terms[0].root || null, a[1], here + '[ToAdjective] ' + a[0])
  })
  t.end()
})

test('toAdverb:', function (t) {
  let toAdverb = nlp().methods.two.transform.adjective.toAdverb
  arr.forEach(a => {
    if (a[1]) {
      t.equal(toAdverb(a[1]), a[0], here + ` [ToAdverb] ${a[1]}`)
    }
    // let doc = nlp(a[1]).compute('root')
    // let json = doc.adjectives().json()[0] || { terms: [{}] }
    // t.equal(json.terms[0].root || null, a[1], here + ' ' + a[0])
  })
  t.end()
})
