import RegExpEscape from './escape.js'

/**
* emoticons
*
* Variable containing polarity scores for selected emoticons/smileys
*
* @author Scott Cram
*
* Original version:
* @author Steven Loria
* @see {@link https://github.com/sloria/TextBlob/blob/dev/textblob/_text.py|_text.py}
*
* From emoticons section of python file above, data was converted to JSON Object containing selected emoticons/smileys and their associated polarity scores
*/
const emoticons = { "<3": "1.00", "♥": "1.00", ">:D": "1.00", ":-D": "1.00", ":D": "1.00", "=-D": "1.00", "=D": "1.00", "X-D": "1.00", "x-D": "1.00", "XD": "1.00", "xD": "1.00", "8-D": "1.00", ">:P": "0.75", ":-P": "0.75", ":P": "0.75", ":-p": "0.75", ":p": "0.75", ":-b": "0.75", ":b": "0.75", ":c)": "0.75", ":o)": "0.75", ":^)": "0.75", ">:)": "0.50", ":-)": "0.50", ":)": "0.50", "=)": "0.50", "=]": "0.50", ":]": "0.50", ":}": "0.50", ":>": "0.50", ":3": "0.50", "8)": "0.50", "8-)": "0.50", ">;]": "0.25", ";-)": "0.25", ";)": "0.25", ";-]": "0.25", ";]": "0.25", ";D": "0.25", ";^)": "0.25", "*-)": "0.25", "*)": "0.25", ">:o": "0.05", ":-O": "0.05", ":O": "0.05", ":o": "0.05", ":-o": "0.05", "o_O": "0.05", "o.O": "0.05", "°O°": "0.05", "°o°": "0.05", ">:/": "-0.25", ":-/": "-0.25", ":/": "-0.25", ":\\": "-0.25", ">:\\": "-0.25", ":-.": "-0.25", ":-s": "-0.25", ":s": "-0.25", ":S": "-0.25", ":-S": "-0.25", ">.>": "-0.25", ">:[": "-0.75", ":-(": "-0.75", ":(": "-0.75", "=(": "-0.75", ":-[": "-0.75", ":[": "-0.75", ":{": "-0.75", ":-<": "-0.75", ":c": "-0.75", ":-c": "-0.75", "=/": "-0.75", ":'(": "-1.00", ":'''(": "-1.00", ";'(": "-1.00" };
//console.log('emoticons', emoticons);

// Combine all the keys from the emoticon object into a regex which match any of those emoticons
const emoticon_regex = new RegExp((RegExpEscape(Object.keys(emoticons).join(' '))).replace(/\\\s/g, '|'), 'g');
//console.log('emoticon_regex: ', emoticon_regex);

/**
* emojis
*
* Variable containing polarity scores for selected emojis
*
* @author Scott Cram
*
* Original version:
* @author P. Kralj Novak, J. Smailovic, B. Sluban, I. Mozetic
* @see {@link https://kt.ijs.si/data/Emoji_sentiment_ranking/|Emoji Sentiment Ranking v1.0}
*
* From emoji file above, data from Char and Sentiment score columns was used, and converted to JSON Object
*/
const emojis = { "😂": "0.221", "❤": "0.746", "♥": "0.657", "😍": "0.678", "😭": "-0.093", "😘": "0.701", "😊": "0.644", "👌": "0.563", "💕": "0.632", "👏": "0.520", "😁": "0.449", "☺": "0.657", "♡": "0.669", "👍": "0.521", "😩": "-0.368", "🙏": "0.417", "✌": "0.463", "😏": "0.332", "😉": "0.463", "🙌": "0.559", "🙈": "0.432", "💪": "0.555", "😄": "0.421", "😒": "-0.374", "💃": "0.734", "💖": "0.712", "😃": "0.557", "😔": "-0.146", "😱": "0.190", "🎉": "0.738", "😜": "0.455", "☯": "0.001", "🌸": "0.650", "💜": "0.654", "💙": "0.730", "✨": "0.351", "😳": "0.018", "💗": "0.657", "★": "0.283", "☀": "0.465", "😡": "-0.173", "😎": "0.491", "😢": "0.007", "💋": "0.691", "😋": "0.631", "🙊": "0.459", "😴": "-0.080", "🎶": "0.537", "💞": "0.739", "😌": "0.482", "🔥": "0.139", "💯": "0.120", "🔫": "-0.194", "💛": "0.709", "💁": "0.326", "💚": "0.656", "♫": "0.287", "😞": "-0.118", "😆": "0.409", "😝": "0.423", "😪": "-0.080", "😫": "-0.145", "😅": "0.178", "👊": "0.228", "💀": "-0.207", "😀": "0.568", "😚": "0.710", "😻": "0.619", "©": "0.117", "👀": "0.063", "💘": "0.683", "🐓": "0.028", "☕": "0.244", "👋": "0.413", "✋": "0.126", "🎊": "0.721", "🍕": "0.417", "❄": "0.506", "😥": "0.122", "😕": "-0.397", "💥": "0.148", "💔": "-0.121", "😤": "-0.209", "😈": "0.265", "✈": "0.415", "🔝": "0.474", "😰": "-0.020", "⚽": "0.616", "😑": "-0.311", "👑": "0.694", "😹": "0.141", "👉": "0.390", "🍃": "0.378", "🎁": "0.759", "😠": "-0.299", "🐧": "0.456", "🍀": "0.285", "🎈": "0.718", "🎅": "0.318", "😓": "-0.080", "😣": "-0.212", "😐": "-0.388", "✊": "0.429", "😨": "-0.140", "😖": "-0.155", "💤": "0.370", "💓": "0.664", "👎": "-0.188", "💦": "0.471", "✔": "0.270", "😷": "-0.169", "⚡": "0.177", "🙋": "0.485", "🎄": "0.531", "💩": "-0.116", "🎵": "0.500", "➡": "0.147", "😛": "0.601", "😬": "0.194", "👯": "0.439", "💎": "0.561", "🌿": "0.384", "🎂": "0.613", "🌟": "0.327", "🔮": "0.267", "❗": "0.100", "👫": "0.255", "🏆": "0.726", "✖": "0.311", "☝": "0.309", "😙": "0.778", "⛄": "0.521", "👅": "0.461", "♪": "0.534", "🍂": "0.547", "💏": "0.388", "🔪": "0.070", "🌴": "0.525", "👈": "0.424", "🌹": "0.600", "🙆": "0.500", "👻": "0.228", "💰": "0.251", "🍻": "0.512", "🙅": "-0.202", "🌞": "0.558", "🍁": "0.482", "⭐": "0.580", "▪": "0.198", "🎀": "0.629", "☷": "0.064", "🐷": "0.368", "🙉": "0.333", "🌺": "0.549", "💅": "0.388", "🐶": "0.576", "🌚": "0.464", "👽": "0.315", "🎤": "0.476", "👭": "0.463", "🎧": "0.414", "👆": "0.326", "🍸": "0.539", "🍷": "0.393", "®": "0.279", "🍉": "0.597", "😇": "0.587", "☑": "0.101", "🏃": "0.406", "😿": "-0.372", "💣": "0.007", "🍺": "0.493", "▶": "0.209", "😲": "-0.068", "🎸": "0.516", "🍹": "0.659", "💫": "0.500", "📚": "0.336", "😶": "-0.142", "🌷": "0.538", "💝": "0.644", "💨": "0.381", "🏈": "0.530", "💍": "0.478", "☔": "0.289", "👸": "0.605", "🍩": "0.382", "👾": "0.361", "☁": "0.308", "🌻": "0.570", "😵": "0.085", "📒": "0.038", "🐯": "0.476", "👼": "0.333", "🍔": "0.277", "😸": "0.410", "👶": "0.434", "💐": "0.735", "🌊": "0.500", "🍦": "0.459", "🍓": "0.670", "👇": "0.247", "💆": "0.221", "🍴": "0.537", "😧": "-0.063", "😮": "0.269", "🚫": "-0.440", "😽": "0.571", "🌈": "0.516", "🙀": "0.330", "⚠": "-0.066", "🎮": "0.427", "🍆": "0.402", "🍰": "0.448", "👐": "-0.023", "🙇": "0.140", "🍟": "0.302", "🍌": "0.435", "💑": "0.659", "👬": "-0.059", "🐣": "0.476", "🎃": "0.595", "😟": "0.072", "🐾": "0.605", "🎓": "0.563", "🏊": "0.575", "🍫": "0.152", "📷": "0.430", "👄": "0.474", "🌼": "0.779", "🚶": "-0.143", "🐱": "0.513", "🐸": "-0.080", "👿": "-0.534", "🚬": "0.521", "📖": "0.169", "🐒": "0.521", "🌍": "0.592", "🐥": "0.586", "🌀": "0.101", "🐼": "0.261", "🎥": "0.290", "💄": "0.435", "💸": "0.159", "⛔": "0.485", "🏀": "0.254", "💉": "0.358", "💟": "0.682", "🚗": "0.231", "😯": "0.123", "📝": "0.231", "♦": "0.453", "💭": "0.206", "🌙": "0.590", "🐟": "0.689", "👣": "0.344", "☞": "0.115", "✂": "-0.459", "🗿": "0.443", "🍝": "0.117", "👪": "-0.017", "🍭": "0.300", "🌃": "0.390", "❌": "0.271", "🐰": "0.586", "💊": "0.431", "🚨": "0.638", "😦": "-0.368", "🍪": "0.316", "🍣": "-0.232", "🎆": "0.709", "🎎": "0.907", "✅": "0.407", "👹": "0.058", "📱": "0.308", "🙍": "-0.327", "🍑": "0.250", "🎼": "0.327", "🔊": "0.404", "🌌": "0.520", "🍎": "0.320", "🐻": "0.440", "💇": "0.327", "♬": "0.245", "♚": "0.041", "🔴": "0.396", "🍱": "-0.313", "🍊": "0.417", "🍒": "0.313", "🐭": "0.688", "👟": "0.417", "🌎": "0.319", "🍍": "0.468", "🐮": "0.587", "📲": "0.239", "☼": "0.196", "🌅": "0.356", "👠": "0.356", "🌽": "0.444", "💧": "-0.159", "❓": "0.068", "🍬": "0.364", "😺": "0.395", "🐴": "0.070", "🚀": "0.488", "💢": "0.233", "🎬": "0.279", "🍧": "0.302", "🍜": "0.395", "🐏": "0.558", "🐘": "0.023", "👧": "0.140", "🏄": "0.524", "⬆": "0.286", "🍋": "0.244", "🆗": "0.537", "⚪": "0.450", "📺": "0.375", "🍅": "0.350", "⛅": "0.450", "🐢": "0.200", "👙": "0.500", "🏡": "0.436", "🌾": "0.538", "✏": "0.342", "🐬": "0.421", "🍤": "0.053", "♣": "0.342", "🐝": "0.211", "🌝": "0.189", "🔋": "-0.486", "🐍": "0.351", "♔": "0.541", "🍳": "0.028", "🔵": "0.306", "😾": "-0.333", "🌕": "0.556", "🐨": "0.444", "🔐": "0.333", "💿": "0.611", "🌳": "0.486", "👰": "0.486", "⚓": "0.571", "🚴": "0.657", "👗": "0.235", "➕": "0.529", "💬": "0.364", "🔜": "0.273", "🍨": "0.212", "💲": "0.242", "⛽": "0.152", "🍙": "0.281", "🍗": "0.063", "🍲": "0.125", "🍥": "-0.594", "♛": "0.188", "😼": "0.355", "🐙": "0.387", "👨": "0.516", "🍚": "0.452", "🍖": "0.129", "♨": "0.871", "🎹": "0.355", "♕": "0.387", "🚘": "0.067", "🍏": "0.067", "👩": "0.067", "👦": "0.133", "☠": "-0.033", "🐠": "0.414", "🚹": "0.690", "💵": "0.379", "👛": "0.357", "🚙": "0.036", "🌱": "0.571", "💻": "0.250", "🌏": "0.321", "👓": "0.296", "⚾": "-0.037", "🌲": "0.385", "👴": "0.231", "🏠": "0.500", "🍇": "0.269", "🍘": "0.385", "🍛": "0.038", "🐇": "0.231", "🔞": "-0.038", "👵": "0.423", "◀": "0.269", "🔙": "0.192", "🌵": "0.192", "🐽": "0.120", "🍮": "-0.120", "🎇": "0.680", "🐎": "0.400", "💶": "0.000", "🐤": "0.520", "🛀": "0.125", "🌑": "0.458", "🚲": "0.375", "🐑": "-0.167", "🏁": "0.500", "🍞": "0.042", "🎾": "0.542", "🈹": "0.292", "🐳": "0.130", "👮": "-0.348", "☹": "-0.522", "🐵": "0.478", "🗼": "0.522", "♠": "0.304", "👺": "-0.182", "🐚": "0.227", "👂": "-0.136", "🗽": "0.318", "🍵": "0.364", "🆒": "0.364", "🍯": "0.045", "🐺": "0.227", "🌓": "0.591", "🔒": "0.182", "👳": "0.619", "🌂": "0.238", "🚌": "0.190", "♩": "0.524", "🍡": "-0.048", "❥": "0.238", "🎡": "0.286", "💌": "0.500", "🐩": "0.350", "🌜": "0.500", "⌚": "0.200", "🚿": "0.600", "🐖": "0.150", "🔆": "0.550", "🌛": "0.550", "💂": "-0.150", "🐔": "0.300", "🙎": "-0.050", "🏩": "0.421", "🔨": "-0.105", "📢": "0.421", "🐦": "0.421", "🐲": "-0.053", "♻": "0.474", "🌘": "0.579", "🍐": "0.158", "🌔": "0.579", "👖": "0.333", "🚺": "0.167", "😗": "0.611", "🎭": "0.000", "🐄": "0.278", "🍢": "-0.111", "🎨": "0.167", "⬇": "0.389", "🚼": "0.556", "⛲": "0.056", "🌗": "0.611", "🌖": "0.611", "🔅": "0.833", "👜": "0.235", "🐌": "0.647", "💼": "0.529", "🚕": "0.000", "🐹": "0.294", "🌠": "0.529", "🐈": "0.294", "☎": "0.000", "🌁": "0.176", "⚫": "0.235", "♧": "0.471", "🏰": "0.294", "🚵": "0.353", "🎢": "0.471", "🎷": "0.647", "🎐": "0.176", "🌇": "0.500", "⏰": "0.438", "🚂": "0.250", "🎿": "0.375", "🆔": "0.750", "⛪": "0.125", "🌒": "0.563", "🐪": "0.563", "👔": "0.333", "🔱": "0.067", "🆓": "0.200", "🐋": "0.200", "🐛": "0.267", "👕": "0.400", "🚋": "0.067", "💳": "0.400", "🌆": "0.133", "🏧": "0.800", "💡": "0.600", "🔹": "0.133", "⬅": "0.467", "🍠": "0.000", "🐫": "0.333", "🏪": "0.067", "📹": "0.429", "👞": "0.429", "🚑": "0.071", "🆘": "0.071", "👚": "0.571", "🚍": "0.071", "🐂": "0.143", "🚣": "0.571", "✳": "0.000", "🏉": "0.500", "🗻": "0.571", "🐀": "0.143", "⛺": "0.462", "🐕": "0.231", "🏂": "0.385", "👡": "0.385", "📻": "0.308", "✒": "0.231", "🌰": "0.538", "🏢": "0.154", "🎒": "0.462", "🏫": "-0.231", "📴": "0.615", "🚢": "0.231", "🚚": "-0.077", "🐉": "0.154", "🐊": "0.077", "🔔": "0.769", "🏥": "0.250", "❔": "0.000", "🚖": "-0.083", "🃏": "0.083", "☛": "0.333", "💒": "0.500", "🚤": "0.333", "🐐": "0.417", "🔚": "0.333", "🎻": "0.333", "🔷": "0.167", "🚦": "0.083", "🔓": "0.083", "🎽": "0.417", "📅": "0.167", "🎺": "0.583", "🍈": "-0.333", "✉": "0.250", "🍼": "0.455", "📀": "0.091", "🚛": "-0.182", "📓": "0.182", "☉": "0.182", "💴": "-0.182", "🐃": "0.000", "➰": "-0.091", "🔌": "-0.091", "🍄": "0.000", "📕": "0.182", "📣": "0.364", "🚓": "0.273", "🐗": "0.455", "↪": "0.091", "⛳": "0.636", "👱": "0.100", "⏳": "0.000", "💺": "0.200", "🏇": "-0.100", "☻": "0.200", "📞": "0.400", "🌉": "0.500", "🚩": "-0.200", "✎": "0.500", "📃": "0.400", "🏨": "0.200", "📌": "-0.400", "♎": "-0.100", "💷": "0.400", "🚄": "0.500", "⛵": "0.500", "🔸": "0.200", "⌛": "0.100", "🚜": "0.700", "🐆": "0.300", "👒": "0.200", "❕": "0.200", "🔛": "0.400", "♢": "0.300", "👝": "0.333", "🎋": "0.444", "👥": "0.222", "📵": "0.111", "🐡": "0.222", "🏯": "0.111", "☂": "0.000", "🔭": "0.333", "🎪": "0.222", "🐜": "0.444", "♌": "0.556", "☐": "-0.667", "👷": "0.222", "🔈": "0.222", "📄": "0.667", "📍": "0.111", "🚐": "0.556", "🚔": "0.000", "🌋": "0.444", "📡": "0.222", "⏩": "0.111", "🚳": "0.667", "☾": "0.000", "🅰": "0.222", "📥": "0.000", "🔦": "0.000", "👤": "0.500", "🚁": "0.125", "🎠": "0.375", "🐁": "-0.250", "📗": "0.125", "☮": "0.000", "♂": "0.125", "📯": "-0.125", "🔩": "0.125", "👢": "0.500", "📰": "0.250", "📶": "0.250", "🚥": "0.000", "🌄": "0.125", "🗾": "0.250", "🔶": "0.250", "🏤": "0.250", "🎩": "0.250", "Ⓜ": "0.250", "🔧": "-0.375", "🐅": "0.125", "♮": "0.125", "🅾": "-0.125", "🔄": "0.000", "☄": "0.000", "☨": "0.000" };
//console.log('emojis: ', emojis);

// Create emoji regex object tjat matches the emojis from emojis object
const emoji_object_regex = new RegExp((RegExpEscape(Object.keys(emojis).join(' '))).replace(/\\\s/g, '|'), 'g');
//console.log('emoji_object_regex: ', emoji_object_regex);

// Create emoji regex object that matches all emojis
// Ref:
// How to strip emojis from string in JavaScript
// https://edvins.io/how-to-strip-emojis-from-string-in-java-script
const emoji_regex = new RegExp("([✀-➿-‑-⛿]|��|��|��)", 'g');
//console.log('emoji_regex: ', emoji_regex);

export { emoji_object_regex, emoji_regex, emoticon_regex, emoticons, emojis }
