export interface IconProps {
	fill?: string;
	onClick?: (e: Event) => void;
}

export const RevIcon = {
	Plus: ({ fill }: IconProps) => (
		<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M8 0C7.44772 0 7 0.447715 7 1V7H1C0.447715 7 0 7.44772 0 8C0 8.55228 0.447715 9 1 9H7V15C7 15.5523 7.44772 16 8 16C8.55228 16 9 15.5523 9 15V9H15C15.5523 9 16 8.55228 16 8C16 7.44772 15.5523 7 15 7H9V1C9 0.447715 8.55228 0 8 0Z" fill={fill} />
		</svg>
	),
	Burger: ({ fill }: IconProps) => (
		<svg width="16" height="16" viewBox="0 0 16 12" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M0 1C0 0.447715 0.447715 0 1 0H15C15.5523 0 16 0.447715 16 1C16 1.55228 15.5523 2 15 2H1C0.447715 2 0 1.55228 0 1ZM0 6C0 5.44772 0.447715 5 1 5H15C15.5523 5 16 5.44772 16 6C16 6.55228 15.5523 7 15 7H1C0.447715 7 0 6.55228 0 6ZM1 10C0.447715 10 0 10.4477 0 11C0 11.5523 0.447715 12 1 12H15C15.5523 12 16 11.5523 16 11C16 10.4477 15.5523 10 15 10H1Z" fill={fill} />
		</svg>
	),
	Cross: ({ fill }: IconProps) => (
		<svg width="14" height="16" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M0.292893 0.292893C-0.0976311 0.683418 -0.0976311 1.31658 0.292893 1.70711L5.58579 7L0.292893 12.2929C-0.0976309 12.6834 -0.0976309 13.3166 0.292893 13.7071C0.683418 14.0976 1.31658 14.0976 1.70711 13.7071L7 8.41421L12.2929 13.7071C12.6834 14.0976 13.3166 14.0976 13.7071 13.7071C14.0976 13.3166 14.0976 12.6834 13.7071 12.2929L8.41421 7L13.7071 1.70711C14.0976 1.31658 14.0976 0.683418 13.7071 0.292893C13.3166 -0.0976311 12.6834 -0.0976311 12.2929 0.292893L7 5.58579L1.70711 0.292893C1.31658 -0.0976311 0.683418 -0.0976311 0.292893 0.292893Z" fill={fill} />
		</svg>
	),
	More: ({ fill }: IconProps) => (
		<svg width="4" height="16" viewBox="0 0 4 18" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M2 4C3.10457 4 4 3.10457 4 2C4 0.89543 3.10457 0 2 0C0.89543 0 0 0.89543 0 2C0 3.10457 0.89543 4 2 4ZM2 11C3.10457 11 4 10.1046 4 9C4 7.89543 3.10457 7 2 7C0.89543 7 0 7.89543 0 9C0 10.1046 0.89543 11 2 11ZM4 16C4 17.1046 3.10457 18 2 18C0.89543 18 0 17.1046 0 16C0 14.8954 0.89543 14 2 14C3.10457 14 4 14.8954 4 16Z" fill={fill} />
		</svg>
	),
	Minus: ({ fill }: IconProps) => (
		<svg width="16" height="16" viewBox="0 0 16 2" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M1 2C0.447715 2 0 1.55228 0 1C0 0.447715 0.447715 0 1 0H15C15.5523 0 16 0.447715 16 1C16 1.55228 15.5523 2 15 2H1Z" fill={fill} />
		</svg>
	),
	Lens: ({ fill }: IconProps) => (
		<svg width="17" height="16" viewBox="0 0 17 19" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M7.5 15C3.35786 15 0 11.6421 0 7.5C0 3.35786 3.35786 0 7.5 0C11.6421 0 15 3.35786 15 7.5C15 9.48047 14.2324 11.2816 12.9784 12.6222L16.7809 17.3753C17.1259 17.8066 17.056 18.4359 16.6247 18.7809C16.1934 19.1259 15.5641 19.056 15.2191 18.6247L11.4304 13.8888C10.2875 14.5935 8.94124 15 7.5 15ZM7.5 13C10.5376 13 13 10.5376 13 7.5C13 4.46243 10.5376 2 7.5 2C4.46243 2 2 4.46243 2 7.5C2 10.5376 4.46243 13 7.5 13Z" fill={fill} />
		</svg>
	),
	Circle: ({ fill }: IconProps) => (
		<svg width="16" height="16" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M6 12C9.31371 12 12 9.31371 12 6C12 2.68629 9.31371 0 6 0C2.68629 0 0 2.68629 0 6C0 9.31371 2.68629 12 6 12Z" fill={fill} />
		</svg>
	),
	ChevronLeft: ({ fill }: IconProps) => (
		<svg width="16" height="16" viewBox="0 0 9 16" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M2.41421 8L8.70711 14.2929C9.09763 14.6834 9.09763 15.3166 8.70711 15.7071C8.31658 16.0976 7.68342 16.0976 7.29289 15.7071L0.292893 8.70711C-0.0976311 8.31658 -0.0976311 7.68342 0.292893 7.29289L7.29289 0.292893C7.68342 -0.0976311 8.31658 -0.0976311 8.70711 0.292893C9.09763 0.683418 9.09763 1.31658 8.70711 1.70711L2.41421 8Z" fill={fill} />
		</svg>
	),
	ChevronDown: ({ fill }: IconProps) => (
		<svg width="16" height="16" viewBox="0 0 16 9" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M8 6.58579L14.2929 0.292893C14.6834 -0.0976311 15.3166 -0.0976311 15.7071 0.292893C16.0976 0.683418 16.0976 1.31658 15.7071 1.70711L8.70711 8.70711C8.31658 9.09763 7.68342 9.09763 7.29289 8.70711L0.292893 1.70711C-0.0976311 1.31658 -0.0976311 0.683418 0.292893 0.292893C0.683418 -0.0976311 1.31658 -0.0976311 1.70711 0.292893L8 6.58579Z" fill={fill} />
		</svg>
	),
	Share: ({ fill }: IconProps) => (
		<svg width="18" height="16" viewBox="0 0 18 22" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M11.6749 7.25522C12.3302 7.72407 13.1329 8 14 8C16.2091 8 18 6.20914 18 4C18 1.79086 16.2091 0 14 0C11.7909 0 10 1.79086 10 4C10 4.61262 10.1377 5.19307 10.3839 5.71208L6.77272 8.11693C6.05368 7.42525 5.0765 7 4 7C1.79086 7 0 8.79086 0 11C0 13.2091 1.79086 15 4 15C5.07511 15 6.05115 14.5758 6.76992 13.8858L10.3751 16.3065C10.1344 16.8208 10 17.3947 10 18C10 20.2091 11.7909 22 14 22C16.2091 22 18 20.2091 18 18C18 15.7909 16.2091 14 14 14C13.1248 14 12.3152 14.2811 11.6566 14.758L7.8221 12.1832C7.93773 11.8093 8 11.4119 8 11C8 10.5894 7.93812 10.1932 7.82319 9.82028L11.6749 7.25522ZM16 4C16 5.10457 15.1046 6 14 6C12.8954 6 12 5.10457 12 4C12 2.89543 12.8954 2 14 2C15.1046 2 16 2.89543 16 4ZM16 18C16 19.1046 15.1046 20 14 20C12.8954 20 12 19.1046 12 18C12 16.8954 12.8954 16 14 16C15.1046 16 16 16.8954 16 18ZM6 11C6 12.1046 5.10457 13 4 13C2.89543 13 2 12.1046 2 11C2 9.89543 2.89543 9 4 9C5.10457 9 6 9.89543 6 11Z" fill={fill} />
		</svg>
	),
	Heart: ({ fill }: IconProps) => (
		<svg width="22" height="16" viewBox="0 0 22 20" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M1.89036 11.4623L9.53555 19.3885C10.0409 19.9124 10.7609 20.0998 11.4198 19.9502C11.7965 19.8705 12.1545 19.6812 12.4427 19.3825L20.1115 11.4341C22.6314 8.81686 22.6292 4.60714 20.1066 1.99257C17.6012 -0.604129 13.5446 -0.663127 10.9687 1.8173C8.39543 -0.61733 4.37655 -0.545123 1.88939 2.03324C-0.630172 4.64519 -0.629744 8.85091 1.89036 11.4623ZM18.6673 3.38125C20.4429 5.22154 20.4444 8.20475 18.6707 10.047L10.975 18L3.32951 10.0735C1.5571 8.23686 1.55679 5.25878 3.32883 3.42176C5.10087 1.58475 7.97422 1.58443 9.74663 3.42106L10.9702 4.68964L12.236 3.37772C14.0134 1.53938 16.8917 1.54096 18.6673 3.38125Z" fill={fill} />
		</svg>
	),
	Activity: ({ fill }: IconProps) => (
		<svg width="22" height="16" viewBox="0 0 22 11" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M2.28369 7.99382C2.63136 7.99382 2.95408 7.80898 3.13595 7.50568L4.22552 5.68865L6.43895 10.4186C6.81781 11.2282 7.95871 11.182 8.27397 10.3443L10.8808 3.41787L13.114 7.47288C13.2912 7.79472 13.6242 7.99382 13.9851 7.99382H15.2532C15.7716 9.30848 17.03 10.2362 18.5 10.2362C20.433 10.2362 22 8.63217 22 6.65352C22 4.67487 20.433 3.07085 18.5 3.07085C16.8034 3.07085 15.3888 4.3065 15.0681 5.94658H14.5693L11.5813 0.521019C11.1661 -0.232907 10.081 -0.1519 9.77706 0.655715L7.24112 7.39386L5.23585 3.10879C4.89363 2.37748 3.89613 2.32445 3.48173 3.01553L1.72414 5.94658H1C0.447715 5.94658 0 6.40487 0 6.9702C0 7.53553 0.447715 7.99382 1 7.99382H2.28369ZM18.5 8.18894C19.3284 8.18894 20 7.50151 20 6.65352C20 5.80552 19.3284 5.11809 18.5 5.11809C17.6716 5.11809 17 5.80552 17 6.65352C17 7.50151 17.6716 8.18894 18.5 8.18894Z" fill={fill} />
		</svg>
	),
	Alert: ({ fill }: IconProps) => (
		<svg width="24" height="16" viewBox="0 0 24 20" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M12.8741 0.514357C12.4931 -0.171452 11.5068 -0.171452 11.1258 0.514357L1.12582 18.5144C0.755521 19.1809 1.23749 20 1.99997 20H22C22.7625 20 23.2444 19.1809 22.8741 18.5144L12.8741 0.514357ZM3.69949 18L12 3.05913L20.3005 18H3.69949ZM11 8C11 7.44772 11.4477 7 12 7C12.5523 7 13 7.44772 13 8V12C13 12.5523 12.5523 13 12 13C11.4477 13 11 12.5523 11 12V8ZM12 14C11.4477 14 11 14.4477 11 15V16C11 16.5523 11.4477 17 12 17C12.5523 17 13 16.5523 13 16V15C13 14.4477 12.5523 14 12 14Z" fill={fill} />
		</svg>
	),
	ArrowDown: ({ fill }: IconProps) => (
		<svg width="10" height="16" viewBox="0 0 10 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M4 10.5858V0.998529C4 0.447057 4.44772 0 5 0C5.55228 0 6 0.447057 6 0.998529V10.5858L8.29289 8.29289C8.68342 7.90237 9.31658 7.90237 9.70711 8.29289C10.0976 8.68342 10.0976 9.31658 9.70711 9.70711L5.70711 13.7071C5.31658 14.0976 4.68342 14.0976 4.29289 13.7071L0.292893 9.70711C-0.0976311 9.31658 -0.0976311 8.68342 0.292893 8.29289C0.683418 7.90237 1.31658 7.90237 1.70711 8.29289L4 10.5858Z" fill={fill} />
		</svg>
	),
	ArrowLeft: ({ fill }: IconProps) => (
		<svg width="14" height="16" viewBox="0 0 14 10" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M5.70711 9.70711C6.09763 9.31658 6.09763 8.68342 5.70711 8.29289L3.41421 6H13.0015C13.5529 6 14 5.55228 14 5C14 4.44772 13.5529 4 13.0015 4H3.41421L5.70711 1.70711C6.09763 1.31658 6.09763 0.683418 5.70711 0.292893C5.31658 -0.0976311 4.68342 -0.0976311 4.29289 0.292893L0.292893 4.29289C-0.0976311 4.68342 -0.0976311 5.31658 0.292893 5.70711L4.29289 9.70711C4.68342 10.0976 5.31658 10.0976 5.70711 9.70711Z" fill={fill} />
		</svg>
	),
	ArrowRight: ({ fill }: IconProps) => (
		<svg width="14" height="16" viewBox="0 0 14 10" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M10.5858 4L8.29289 1.70711C7.90237 1.31658 7.90237 0.683418 8.29289 0.292893C8.68342 -0.0976311 9.31658 -0.0976311 9.70711 0.292893L13.7071 4.29289C14.0976 4.68342 14.0976 5.31658 13.7071 5.70711L9.70711 9.70711C9.31658 10.0976 8.68342 10.0976 8.29289 9.70711C7.90237 9.31658 7.90237 8.68342 8.29289 8.29289L10.5858 6H0.998529C0.447057 6 0 5.55228 0 5C0 4.44772 0.447057 4 0.998529 4H10.5858Z" fill={fill} />
		</svg>
	),
	ArrowUp: ({ fill }: IconProps) => (
		<svg width="10" height="16" viewBox="0 0 10 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M6 3.41421V13.0015C6 13.5529 5.55228 14 5 14C4.44772 14 4 13.5529 4 13.0015V3.41421L1.70711 5.70711C1.31658 6.09763 0.683418 6.09763 0.292893 5.70711C-0.0976311 5.31658 -0.0976311 4.68342 0.292893 4.29289L4.29289 0.292893C4.68342 -0.0976311 5.31658 -0.0976311 5.70711 0.292893L9.70711 4.29289C10.0976 4.68342 10.0976 5.31658 9.70711 5.70711C9.31658 6.09763 8.68342 6.09763 8.29289 5.70711L6 3.41421Z" fill={fill} />
		</svg>
	),
	Badge: ({ fill }: IconProps) => (
		<svg width="16" height="16" viewBox="0 0 16 22" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M4.00233 14.9311C1.60984 13.5482 0 10.9621 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8C16 10.9621 14.3902 13.5482 11.9977 14.9311C11.9992 14.9538 12 14.9767 12 14.9998V20.9982C12 21.8978 10.9045 22.3397 10.28 21.692L8 19.3272L5.71998 21.692C5.09553 22.3397 4 21.8978 4 20.9982V14.9998C4 14.9767 4.00079 14.9538 4.00233 14.9311ZM6 15.748V18.5204L7.28002 17.1927C7.6733 16.7848 8.3267 16.7848 8.71998 17.1927L10 18.5204V15.748C9.36076 15.9125 8.6906 16 8 16C7.3094 16 6.63924 15.9125 6 15.748ZM8 14C11.3137 14 14 11.3137 14 8C14 4.68629 11.3137 2 8 2C4.68629 2 2 4.68629 2 8C2 11.3137 4.68629 14 8 14ZM8 12C5.79086 12 4 10.2091 4 8C4 5.79086 5.79086 4 8 4C10.2091 4 12 5.79086 12 8C12 10.2091 10.2091 12 8 12ZM10 8C10 9.10457 9.10457 10 8 10C6.89543 10 6 9.10457 6 8C6 6.89543 6.89543 6 8 6C9.10457 6 10 6.89543 10 8Z" fill={fill} />
		</svg>
	),
	Bag: ({ fill }: IconProps) => (
		<svg width="16" height="16" viewBox="0 0 16 22" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M8 0C10.7614 0 13 2.23858 13 5V6H14C15.1046 6 16 6.89543 16 8V20C16 21.1046 15.1046 22 14 22H2C0.89543 22 0 21.1046 0 20V8C0 6.89543 0.89543 6 2 6H3V5C3 2.23858 5.23858 0 8 0ZM2 8H3H13H14V16H2V8ZM2 18V20H14V18H2ZM11 5V6H5V5C5 3.34315 6.34315 2 8 2C9.65685 2 11 3.34315 11 5Z" fill={fill} />
		</svg>
	),
	Battery: ({ fill }: IconProps) => (
		<svg width="22" height="16" viewBox="0 0 22 12" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M20 0H4C2.89543 0 2 0.89543 2 2V3H0.5C0.223858 3 0 3.22386 0 3.5V8.5C0 8.77614 0.223858 9 0.5 9H2V10C2 11.1046 2.89543 12 4 12H20C21.1046 12 22 11.1046 22 10V2C22 0.89543 21.1046 0 20 0ZM4 10V2H15V10H4ZM17 10H20V2H17V10Z" fill={fill} />
		</svg>
	),
	Bell: ({ fill }: IconProps) => (
		<svg width="18" height="16" viewBox="0 0 18 22" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M10.9717 2.3147C10.9902 2.21936 10.9999 2.11475 10.9999 2C10.9999 0.89543 10.1045 0 8.99989 0C7.89532 0 6.99989 0.89543 6.99989 2C6.99989 2.11475 7.00955 2.21936 7.02811 2.3147C5.56198 2.78896 4.16685 3.79097 2.84473 5.26418C2.51538 5.63117 2.33322 6.10689 2.33322 6.6V13.6454L1.18063 16.1692C0.575725 17.4937 1.54377 19 2.99989 19H5.1259C5.56995 20.7252 7.13605 22 8.99989 22C10.8637 22 12.4298 20.7252 12.8739 19H14.9999C16.456 19 17.424 17.4937 16.8191 16.1692L15.6666 13.6454V6.6C15.6666 6.10689 15.4844 5.63117 15.155 5.26418C13.8329 3.79097 12.4378 2.78896 10.9717 2.3147ZM8.99989 20C8.2596 20 7.61326 19.5978 7.26745 19H10.7323C10.3865 19.5978 9.74017 20 8.99989 20ZM4.33322 13V6.6C5.88877 4.86667 7.44433 4 8.99989 4C10.5554 4 12.111 4.86667 13.6666 6.6V13H4.33322ZM14.0865 15L14.9999 17H2.99989L3.91327 15H14.0865Z" fill={fill} />
		</svg>
	),
	Book: ({ fill }: IconProps) => (
		<svg width="17" height="16" viewBox="0 0 17 21" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M2 0H14C15.1046 0 16 0.89543 16 2V3.93641C16.0013 3.95744 16.002 3.97864 16.002 4V9C16.002 9.02136 16.0013 9.04257 16 9.06359V19C16 20.1046 15.1046 21 14 21H2C0.89543 21 0 20.1046 0 19V2C0 0.89543 0.89543 0 2 0ZM14 2V3H8.00199C7.06385 3 6.64209 4.1754 7.3662 4.77186L9.46418 6.5L7.3662 8.22814C6.64209 8.8246 7.06385 10 8.00199 10H14V19H6V19.0952C6 19.5949 5.55228 20 5 20C4.44772 20 4 19.5949 4 19.0952V19H2V2H4V1.90476C4 1.40508 4.44772 1 5 1C5.55228 1 6 1.40508 6 1.90476V2H14ZM11.6728 5.72814L10.7888 5H14.002V8H10.7888L11.6728 7.27186C12.1584 6.87186 12.1584 6.12814 11.6728 5.72814Z" fill={fill} />
		</svg>
	),
	Box: ({ fill }: IconProps) => (
		<svg width="20" height="16" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M0 6V18C0 19.1046 0.89543 20 2 20H18C19.1046 20 20 19.1046 20 18V6C20 5.56726 19.8596 5.14619 19.6 4.8L16.6 0.8C16.2223 0.296388 15.6295 0 15 0H5C4.37049 0 3.77771 0.296388 3.4 0.8L0.4 4.8C0.140356 5.14619 0 5.56726 0 6ZM18 18H2V8H6V14C6 14.5523 6.44772 15 7 15H13C13.5523 15 14 14.5523 14 14V8H18V18ZM12 8V13H8V8H12ZM18 6H2L5 2H15L18 6Z" fill={fill} />
		</svg>
	),
	Bullet: ({ fill }: IconProps) => (
		<svg width="12" height="16" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M6 12C9.31371 12 12 9.31371 12 6C12 2.68629 9.31371 0 6 0C2.68629 0 0 2.68629 0 6C0 9.31371 2.68629 12 6 12Z" fill={fill} />
		</svg>
	),
	Calendar: ({ fill }: IconProps) => (
		<svg width="20" height="16" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M7 4C7 4.55228 6.55228 5 6 5C5.44772 5 5 4.55228 5 4V1C5 0.447715 5.44772 0 6 0C6.55228 0 7 0.447715 7 1V4ZM2 4H4V2H2C0.89543 2 0 2.89543 0 4V7V9V18C0 19.1046 0.89543 20 2 20H18C19.1046 20 20 19.1046 20 18V9V7V4C20 2.89543 19.1046 2 18 2H16V4H18V7H2V4ZM2 9V18H18V9H2ZM14 5C14.5523 5 15 4.55228 15 4V1C15 0.447715 14.5523 0 14 0C13.4477 0 13 0.447715 13 1V4C13 4.55228 13.4477 5 14 5ZM8 2H12V4H8V2ZM9 12V10H7V12H9ZM13 10V12H11V10H13ZM17 12V10H15V12H17ZM5 14V16H3V14H5ZM9 16V14H7V16H9ZM13 14V16H11V14H13ZM17 16V14H15V16H17Z" fill={fill} />
		</svg>
	),
	Camera: ({ fill }: IconProps) => (
		<svg width="20" height="16" viewBox="0 0 20 17" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M6.58579 0.585786L5.17157 2H2C0.89543 2 0 2.89543 0 4V15C0 16.1046 0.89543 17 2 17H18C19.1046 17 20 16.1046 20 15V4C20 2.89543 19.1046 2 18 2H14.8284L13.4142 0.585786C13.0391 0.210714 12.5304 0 12 0H8C7.46957 0 6.96086 0.210714 6.58579 0.585786ZM2 15V4H6L8 2H12L14 4H18V15H2ZM12 9C12 10.1046 11.1046 11 10 11C8.89543 11 8 10.1046 8 9C8 7.89543 8.89543 7 10 7C11.1046 7 12 7.89543 12 9Z" fill={fill} />
		</svg>
	),
	Card: ({ fill }: IconProps) => (
		<svg width="20" height="16" viewBox="0 0 20 15" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M18 0H2C0.89543 0 0 0.89543 0 2V13C0 14.1046 0.89543 15 2 15H18C19.1046 15 20 14.1046 20 13V2C20 0.89543 19.1046 0 18 0ZM2 13V7H18V13H2ZM18 5H2V2H18V5ZM13 9C12.4477 9 12 9.44771 12 10C12 10.5523 12.4477 11 13 11H15C15.5523 11 16 10.5523 16 10C16 9.44771 15.5523 9 15 9H13Z" fill={fill} />
		</svg>
	),
	Cart: ({ fill }: IconProps) => (
		<svg width="22" height="16" viewBox="0 0 22 19" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M14.7669 13.3408L18.8299 2H21.0109C21.5567 2 21.9993 1.55228 21.9993 1C21.9993 0.447715 21.5567 0 21.0109 0H18.1369C17.7209 0 17.3494 0.263534 17.2076 0.659228L14.9338 7.00587C14.8985 7.00199 14.8625 7 14.8261 7H3.0187L2.35977 5H9.88407C10.43 5 10.8725 4.55228 10.8725 4C10.8725 3.44772 10.43 3 9.88407 3H0.98843C0.313787 3 -0.162594 3.6687 0.050747 4.31623L3.01596 13.3162C3.1505 13.7246 3.5282 14 3.95364 14H13.8377C14.2537 14 14.6252 13.7365 14.7669 13.3408ZM4.66605 12L3.67764 9H14.2194L13.1446 12H4.66605ZM5.93045 19C7.02221 19 7.90726 18.1046 7.90726 17C7.90726 15.8954 7.02221 15 5.93045 15C4.83869 15 3.95364 15.8954 3.95364 17C3.95364 18.1046 4.83869 19 5.93045 19ZM14.8261 17C14.8261 18.1046 13.941 19 12.8493 19C11.7575 19 10.8725 18.1046 10.8725 17C10.8725 15.8954 11.7575 15 12.8493 15C13.941 15 14.8261 15.8954 14.8261 17Z" fill={fill} />
		</svg>
	),
	Check: ({ fill }: IconProps) => (
		<svg width="19" height="16" viewBox="0 0 19 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M17.2929 0.292893C17.6834 -0.0976311 18.3166 -0.0976311 18.7071 0.292893C19.0976 0.683418 19.0976 1.31658 18.7071 1.70711L6.70711 13.7071C6.31658 14.0976 5.68342 14.0976 5.29289 13.7071L0.292893 8.70711C-0.0976311 8.31658 -0.0976311 7.68342 0.292893 7.29289C0.683418 6.90237 1.31658 6.90237 1.70711 7.29289L6 11.5858L17.2929 0.292893Z" fill={fill} />
		</svg>
	),
	ChevronRight: ({ fill }: IconProps) => (
		<svg width="9" height="16" viewBox="0 0 9 16" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M6.58579 8L0.292893 1.70711C-0.0976311 1.31658 -0.0976311 0.683418 0.292893 0.292893C0.683418 -0.0976311 1.31658 -0.0976311 1.70711 0.292893L8.70711 7.29289C9.09763 7.68342 9.09763 8.31658 8.70711 8.70711L1.70711 15.7071C1.31658 16.0976 0.683418 16.0976 0.292893 15.7071C-0.0976311 15.3166 -0.0976311 14.6834 0.292893 14.2929L6.58579 8Z" fill={fill} />
		</svg>
	),
	ChevronUp: ({ fill }: IconProps) => (
		<svg width="16" height="16" viewBox="0 0 16 9" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M8 2.41421L1.70711 8.70711C1.31658 9.09763 0.683418 9.09763 0.292893 8.70711C-0.0976311 8.31658 -0.0976311 7.68342 0.292893 7.29289L7.29289 0.292893C7.68342 -0.0976311 8.31658 -0.0976311 8.70711 0.292893L15.7071 7.29289C16.0976 7.68342 16.0976 8.31658 15.7071 8.70711C15.3166 9.09763 14.6834 9.09763 14.2929 8.70711L8 2.41421Z" fill={fill} />
		</svg>
	),
	Comment: ({ fill }: IconProps) => (
		<svg width="22" height="16" viewBox="0 0 22 21" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M19 18V16C20.6569 16 22 14.6569 22 13V3C22 1.34315 20.6569 0 19 0H3C1.34315 0 0 1.34315 0 3V13C0 14.6569 1.34315 16 3 16H12.1716L15.5858 19.4142C16.8457 20.6741 19 19.7818 19 18ZM2 3C2 2.44772 2.44772 2 3 2H19C19.5523 2 20 2.44772 20 3V13C20 13.5523 19.5523 14 19 14H17V18L13 14H3C2.44772 14 2 13.5523 2 13V3Z" fill={fill} />
		</svg>
	),
	Cookie: ({ fill }: IconProps) => (
		<svg width="18" height="16" viewBox="0 0 18 20" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M9.52305 20C12.9356 20 16.0356 18.0913 17.7346 15.0502C18.4463 13.7763 17.6507 12.1563 16.2526 12.0326C15.1009 11.9307 14.1744 10.9699 14.0585 9.75973C13.9635 8.7687 13.193 8.00101 12.2486 7.95649C10.7279 7.88479 9.52305 6.56067 9.52305 4.94947C9.52305 4.30458 9.71381 3.69528 10.0643 3.18584C11.0455 1.75994 9.93189 -0.21081 8.27455 0.0183043C3.56158 0.669834 0 4.9151 0 9.96631C0 15.5078 4.26361 20 9.52305 20ZM12.1635 9.96122C12.3712 12.1301 14.0248 13.8493 16.0932 14.0323C14.769 16.4026 12.3223 17.9933 9.52305 17.9933C5.3155 17.9933 1.90461 14.3995 1.90461 9.96631C1.90461 5.89055 4.7877 2.52427 8.52232 2.00799C7.9537 2.8344 7.61844 3.85068 7.61844 4.94947C7.61844 7.64375 9.63423 9.84197 12.1635 9.96122ZM9.52305 17.0585C7.94522 17.0585 6.66613 15.7109 6.66613 14.0484C6.66613 12.386 7.94522 11.0383 9.52305 11.0383C11.1009 11.0383 12.38 12.386 12.38 14.0484C12.38 15.7109 11.1009 17.0585 9.52305 17.0585ZM10.4754 14.0484C10.4754 14.6026 10.049 15.0518 9.52305 15.0518C8.9971 15.0518 8.57074 14.6026 8.57074 14.0484C8.57074 13.4943 8.9971 13.045 9.52305 13.045C10.049 13.045 10.4754 13.4943 10.4754 14.0484ZM4.28537 13.045C3.49646 13.045 2.85691 12.3712 2.85691 11.54C2.85691 10.7088 3.49646 10.0349 4.28537 10.0349C5.07429 10.0349 5.71383 10.7088 5.71383 11.54C5.71383 12.3712 5.07429 13.045 4.28537 13.045ZM3.80922 11.54C3.80922 11.2629 4.0224 11.0383 4.28537 11.0383C4.54834 11.0383 4.76152 11.2629 4.76152 11.54C4.76152 11.8171 4.54834 12.0417 4.28537 12.0417C4.0224 12.0417 3.80922 11.8171 3.80922 11.54ZM5.23768 8.0282C4.44876 8.0282 3.80922 7.35437 3.80922 6.52315C3.80922 5.69193 4.44876 5.0181 5.23768 5.0181C6.02659 5.0181 6.66613 5.69193 6.66613 6.52315C6.66613 7.35437 6.02659 8.0282 5.23768 8.0282ZM4.76152 6.52315C4.76152 6.24608 4.9747 6.02146 5.23768 6.02146C5.50065 6.02146 5.71383 6.24608 5.71383 6.52315C5.71383 6.80022 5.50065 7.02483 5.23768 7.02483C4.9747 7.02483 4.76152 6.80022 4.76152 6.52315Z" fill={fill} />
		</svg>
	),
	Currency: ({ fill }: IconProps) => (
		<svg width="22" height="16" viewBox="0 0 22 16" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M20 0H2C0.89543 0 0 0.89543 0 2V14C0 15.1046 0.89543 16 2 16H20C21.1046 16 22 15.1046 22 14V2C22 0.89543 21.1046 0 20 0ZM2 14V2H20V14H2ZM11 9C11.5523 9 12 8.55228 12 8C12 7.44772 11.5523 7 11 7C10.4477 7 10 7.44772 10 8C10 8.55228 10.4477 9 11 9ZM8 8C8 9.65685 9.34315 11 11 11C12.6569 11 14 9.65685 14 8C14 6.34315 12.6569 5 11 5C9.34315 5 8 6.34315 8 8ZM6 11C6.55228 11 7 11.4477 7 12C7 12.5523 6.55228 13 6 13H4C3.44772 13 3 12.5523 3 12C3 11.4477 3.44772 11 4 11H6ZM19 4C19 3.44772 18.5523 3 18 3H16C15.4477 3 15 3.44772 15 4C15 4.55228 15.4477 5 16 5H18C18.5523 5 19 4.55228 19 4Z" fill={fill} />
		</svg>
	),
	Desktop: ({ fill }: IconProps) => (
		<svg width="20" height="16" viewBox="0 0 20 18" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M18 0H2C0.89543 0 0 0.89543 0 2V13C0 14.1046 0.89543 15 2 15H7V16H6C5.44772 16 5 16.4477 5 17C5 17.5523 5.44772 18 6 18H7H9H11H13H14C14.5523 18 15 17.5523 15 17C15 16.4477 14.5523 16 14 16H13V15H18C19.1046 15 20 14.1046 20 13V2C20 0.89543 19.1046 0 18 0ZM11 13H13H18V10H2V13H7H9H11ZM11 15V16H9V15H11ZM18 8H2V2H18V8Z" fill={fill} />
		</svg>
	),
	Download: ({ fill }: IconProps) => (
		<svg width="20" height="16" viewBox="0 0 20 18" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M9 0.998529C9 0.447057 9.44771 0 10 0C10.5523 0 11 0.447057 11 0.998529V9.58579L13.2929 7.29289C13.6834 6.90237 14.3166 6.90237 14.7071 7.29289C15.0976 7.68342 15.0976 8.31658 14.7071 8.70711L10.7071 12.7071C10.3166 13.0976 9.68342 13.0976 9.29289 12.7071L5.29289 8.70711C4.90237 8.31658 4.90237 7.68342 5.29289 7.29289C5.68342 6.90237 6.31658 6.90237 6.70711 7.29289L9 9.58579V0.998529ZM18 16V10C18 9.44771 18.4477 9 19 9C19.5523 9 20 9.44771 20 10V17C20 17.5523 19.5523 18 19 18H1C0.447715 18 0 17.5523 0 17V10C0 9.44771 0.447715 9 1 9C1.55228 9 2 9.44771 2 10V16H18Z" fill={fill} />
		</svg>
	),
	Equalizer: ({ fill }: IconProps) => (
		<svg width="20" height="16" viewBox="0 0 20 22" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M13 8C11.1334 8 9.56545 6.72147 9.12406 4.99237C9.08341 4.99741 9.04201 5 9 5H1C0.447715 5 0 4.55228 0 4C0 3.44772 0.447715 3 1 3H9C9.04201 3 9.08341 3.00259 9.12406 3.00763C9.56545 1.27853 11.1334 0 13 0C14.8638 0 16.4299 1.27477 16.874 3H19C19.5523 3 20 3.44772 20 4C20 4.55228 19.5523 5 19 5H16.874C16.4299 6.72523 14.8638 8 13 8ZM0 11C0 10.4477 0.447715 10 1 10H2C2.04201 10 2.08342 10.0026 2.12407 10.0076C2.56545 8.27853 4.13342 7 6 7C7.86384 7 9.42994 8.27477 9.87398 10H19C19.5523 10 20 10.4477 20 11C20 11.5523 19.5523 12 19 12H9.87398C9.42994 13.7252 7.86384 15 6 15C4.13342 15 2.56545 13.7215 2.12407 11.9924C2.08342 11.9974 2.04201 12 2 12H1C0.447715 12 0 11.5523 0 11ZM0 18C0 17.4477 0.447715 17 1 17H8C8.04201 17 8.08342 17.0026 8.12407 17.0076C8.56545 15.2785 10.1334 14 12 14C13.8666 14 15.4345 15.2785 15.8759 17.0076C15.9166 17.0026 15.958 17 16 17H19C19.5523 17 20 17.4477 20 18C20 18.5523 19.5523 19 19 19H16C15.958 19 15.9166 18.9974 15.8759 18.9924C15.4345 20.7215 13.8666 22 12 22C10.1334 22 8.56545 20.7215 8.12407 18.9924C8.08342 18.9974 8.04201 19 8 19H1C0.447715 19 0 18.5523 0 18ZM15 4C15 5.10457 14.1046 6 13 6C11.8954 6 11 5.10457 11 4C11 2.89543 11.8954 2 13 2C14.1046 2 15 2.89543 15 4ZM14 18C14 19.1046 13.1046 20 12 20C10.8954 20 10 19.1046 10 18C10 16.8954 10.8954 16 12 16C13.1046 16 14 16.8954 14 18ZM8 11C8 12.1046 7.10457 13 6 13C4.89543 13 4 12.1046 4 11C4 9.89543 4.89543 9 6 9C7.10457 9 8 9.89543 8 11Z" fill={fill} />
		</svg>
	),
	File: ({ fill }: IconProps) => (
		<svg width="18" height="16" viewBox="0 0 18 22" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M12.7666 0H2C0.89543 0 0 0.89543 0 2V20C0 21.1046 0.89543 22 2 22H16C17.1046 22 18 21.1046 18 20V4.87256C18 4.30109 17.7555 3.75692 17.3283 3.37738L14.0949 0.50482C13.7289 0.17962 13.2562 0 12.7666 0ZM2 16V2H11V7.05005C11 7.60233 11.4477 8.05005 12 8.05005H14.4871C15.0393 8.05005 15.4871 7.60233 15.4871 7.05005C15.4871 6.49776 15.0393 6.05005 14.4871 6.05005H13V2.20735L16 4.87256V16H2ZM2 18V20H16V18H2Z" fill={fill} />
		</svg>
	),
	Flag: ({ fill }: IconProps) => (
		<svg width="19" height="16" viewBox="0 0 19 21" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M1 0C0.447715 0 0 0.447715 0 1V20C0 20.5523 0.447715 21 1 21C1.55228 21 2 20.5523 2 20V13H17C17.85 13 18.3124 12.0068 17.7653 11.3563L14.2293 6.15259L17.7038 1.7104C18.3383 1.0818 17.8932 0 17 0H1ZM2 2V11H14.8521L12.1054 6.73462C11.7702 6.3361 11.7969 5.74702 12.1669 5.38051L14.5697 2H2Z" fill={fill} />
		</svg>
	),
	Folder: ({ fill }: IconProps) => (
		<svg width="20" height="16" viewBox="0 0 20 18" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M2 4V2H6.58579L8.29289 3.70711C8.48043 3.89464 8.73478 4 9 4H18V6H1C0.447715 6 0 6.44772 0 7V17C0 17.5523 0.447715 18 1 18H19C19.5523 18 20 17.5523 20 17V3C20 2.44772 19.5523 2 19 2H9.41421L7.70711 0.292893C7.51957 0.105357 7.26522 0 7 0H1C0.447715 0 0 0.447715 0 1V4C0 4.55228 0.447715 5 1 5C1.55228 5 2 4.55228 2 4ZM2 8H18V16H2V8Z" fill={fill} />
		</svg>
	),
	Gear: ({ fill }: IconProps) => (
		<svg width="22" height="16" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M0.621271 5.98001C0.427852 6.37928 0.257571 6.78974 0.111437 7.20955C-0.209391 8.13121 0.181805 9.14985 1.03708 9.61984C1.53836 9.8953 1.85487 10.419 1.85487 11.0003C1.85487 11.5815 1.53836 12.1052 1.03708 12.3807C0.181805 12.8507 -0.209391 13.8693 0.111437 14.791C0.257571 15.2108 0.427852 15.6213 0.621271 16.0205C1.04647 16.8983 2.04275 17.3413 2.9793 17.0691C3.52849 16.9095 4.12255 17.0561 4.53349 17.467C4.94444 17.878 5.09099 18.4721 4.9314 19.0212C4.65924 19.9578 5.10229 20.9541 5.98001 21.3793C6.37928 21.5727 6.78974 21.743 7.20955 21.8891C8.13121 22.2099 9.14985 21.8187 9.61984 20.9635C9.8953 20.4622 10.419 20.1457 11.0003 20.1457C11.5815 20.1457 12.1052 20.4622 12.3807 20.9635C12.8507 21.8187 13.8693 22.2099 14.791 21.8891C15.2108 21.743 15.6213 21.5727 16.0205 21.3793C16.8983 20.9541 17.3413 19.9578 17.0691 19.0212C16.9095 18.4721 17.0561 17.878 17.467 17.467C17.878 17.0561 18.4721 16.9095 19.0212 17.0691C19.9578 17.3413 20.9541 16.8983 21.3793 16.0205C21.5727 15.6213 21.743 15.2108 21.8891 14.791C22.2099 13.8693 21.8187 12.8507 20.9635 12.3807C20.4622 12.1052 20.1457 11.5815 20.1457 11.0003C20.1457 10.419 20.4622 9.8953 20.9635 9.61984C21.8187 9.14985 22.2099 8.13121 21.8891 7.20955C21.743 6.78974 21.5727 6.37928 21.3793 5.98001C20.9541 5.10229 19.9578 4.65924 19.0212 4.9314C18.4721 5.09099 17.878 4.94444 17.467 4.53349C17.0561 4.12255 16.9095 3.52849 17.0691 2.9793C17.3413 2.04275 16.8983 1.04647 16.0205 0.621271C15.6213 0.427852 15.2108 0.257571 14.791 0.111437C13.8693 -0.209391 12.8507 0.181805 12.3807 1.03708C12.1052 1.53836 11.5815 1.85487 11.0003 1.85487C10.419 1.85487 9.8953 1.53836 9.61984 1.03708C9.14985 0.181805 8.13121 -0.209391 7.20955 0.111437C6.78974 0.257571 6.37928 0.427852 5.98001 0.621271C5.10229 1.04647 4.65924 2.04275 4.9314 2.9793C5.09099 3.52849 4.94444 4.12255 4.53349 4.53349C4.12255 4.94444 3.52849 5.09099 2.9793 4.9314C2.04275 4.65924 1.04647 5.10229 0.621271 5.98001ZM3.85487 11.0003C3.85487 9.64989 3.10568 8.47449 2.00027 7.86705C2.12141 7.51906 2.26216 7.18025 2.42119 6.85195C3.63226 7.20388 4.99295 6.90247 5.94771 5.94771C6.90247 4.99295 7.20388 3.63226 6.85195 2.42119C7.18025 2.26216 7.51906 2.12141 7.86705 2.00027C8.47449 3.10568 9.64989 3.85487 11.0003 3.85487C12.3507 3.85487 13.5261 3.10568 14.1335 2.00027C14.4815 2.12141 14.8203 2.26216 15.1486 2.42119C14.7967 3.63226 15.0981 4.99295 16.0528 5.94771C17.0076 6.90247 18.3683 7.20388 19.5793 6.85195C19.7384 7.18025 19.8791 7.51906 20.0003 7.86705C18.8949 8.47449 18.1457 9.64989 18.1457 11.0003C18.1457 12.3507 18.8949 13.5261 20.0003 14.1335C19.8791 14.4815 19.7384 14.8203 19.5793 15.1486C18.3683 14.7967 17.0076 15.0981 16.0528 16.0528C15.0981 17.0076 14.7967 18.3683 15.1486 19.5793C14.8203 19.7384 14.4815 19.8791 14.1335 20.0003C13.5261 18.8949 12.3507 18.1457 11.0003 18.1457C9.64989 18.1457 8.47449 18.8949 7.86705 20.0003C7.51906 19.8791 7.18025 19.7384 6.85195 19.5793C7.20388 18.3683 6.90247 17.0076 5.94771 16.0528C4.99295 15.0981 3.63226 14.7967 2.42119 15.1486C2.26216 14.8203 2.12141 14.4815 2.00027 14.1335C3.10568 13.5261 3.85487 12.3507 3.85487 11.0003ZM13.0003 11.0003C13.0003 12.1048 12.1048 13.0003 11.0003 13.0003C9.8957 13.0003 9.00027 12.1048 9.00027 11.0003C9.00027 9.8957 9.8957 9.00027 11.0003 9.00027C12.1048 9.00027 13.0003 9.8957 13.0003 11.0003Z" fill={fill} />
		</svg>
	),
	Diamond: ({ fill }: IconProps) => (
		<svg width="22" height="16" viewBox="0 0 22 21" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M5 0H17C17.6974 0 18.3445 0.363296 18.7076 0.958735L21.7076 5.87841C22.1182 6.55179 22.0947 7.40361 21.6477 8.05336L12.6477 20.1337C11.8529 21.2888 10.1471 21.2888 9.35235 20.1337L0.352346 8.05336C-0.0947202 7.40361 -0.118183 6.55179 0.292439 5.87841L3.29244 0.958735C3.65554 0.363296 4.30259 0 5 0ZM2.56082 6H19.4392L17 2H5L2.56082 6ZM19.1951 8H2.80486L11 19L19.1951 8Z" fill={fill} />
		</svg>
	),
	GraphBar: ({ fill }: IconProps) => (
		<svg width="22" height="16" viewBox="0 0 22 20" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M11 0H10C8.89543 0 8 0.89543 8 2V18H7V7C7 5.89543 6.10457 5 5 5H4C2.89543 5 2 5.89543 2 7V18H1C0.447715 18 0 18.4477 0 19C0 19.5523 0.447715 20 1 20H4H5H10H11H16H17H21C21.5523 20 22 19.5523 22 19C22 18.4477 21.5523 18 21 18H19V10C19 8.89543 18.1046 8 17 8H16C14.8954 8 14 8.89543 14 10V18H13V2C13 0.89543 12.1046 0 11 0ZM10 2V18H11V2H10ZM4 7V18H5V7H4ZM16 18V10H17V18H16Z" fill={fill} />
		</svg>
	),
	GraphPie: ({ fill }: IconProps) => (
		<svg width="22" height="16" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M15.2746 0C15.1446 0 15.0149 0.00371348 14.8856 0.0111187C13.8272 0.0717569 13 0.947714 13 2.00784V6.69814C13 7.80271 13.8954 8.69814 15 8.69814H20C21.109 8.69814 22.0063 7.79579 22 6.6868C21.979 2.98852 18.9745 0 15.2746 0ZM15 6.69814V2.00784C15.0909 2.00264 15.1824 2 15.2746 2C17.8753 2 19.9853 4.10091 20 6.69814H15ZM12 10H16.9836C18.0372 10 18.9101 10.8173 18.9793 11.8686C18.9931 12.0783 19 12.2888 19 12.5C19 17.7467 14.7467 22 9.5 22C4.25329 22 0 17.7467 0 12.5C0 7.25329 4.25329 3 9.5 3C9.71121 3 9.92175 3.00692 10.1314 3.02072C11.1827 3.08992 12 3.96283 12 5.0164V10ZM9.5 5C9.66801 5 9.83474 5.00552 10 5.0164V12H16.9836C16.9945 12.1653 17 12.332 17 12.5C17 16.6421 13.6421 20 9.5 20C5.35786 20 2 16.6421 2 12.5C2 8.35786 5.35786 5 9.5 5Z" fill={fill} />
		</svg>
	),
	GraphPoly: ({ fill }: IconProps) => (
		<svg width="22" height="16" viewBox="0 0 22 16" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M5 10C5.38149 10 5.74635 9.92884 6.08202 9.79899L8.11581 12.1717C8.04039 12.4348 8 12.7127 8 13C8 14.6569 9.34315 16 11 16C12.6569 16 14 14.6569 14 13C14 12.6397 13.9365 12.2942 13.82 11.9742L17.0066 7.83165C17.3175 7.94073 17.6518 8.00005 18 8.00005C19.6569 8.00005 21 6.6569 21 5.00005C21 4.37493 20.8088 3.79447 20.4817 3.31396L21.7926 1.60976C22.1294 1.17201 22.0475 0.54416 21.6097 0.207426C21.172 -0.129308 20.5441 -0.0474151 20.2074 0.390339L18.8705 2.12829C18.595 2.04489 18.3027 2.00005 18 2.00005C16.3431 2.00005 15 3.3432 15 5.00005C15 5.57885 15.1639 6.11937 15.4479 6.57772L12.5045 10.404C12.0623 10.1471 11.5483 10 11 10C10.38 10 9.80402 10.1881 9.32584 10.5103L7.60032 8.49716C7.85454 8.05656 8 7.54529 8 7.00005C8 5.3432 6.65685 4.00005 5 4.00005C3.34315 4.00005 2 5.3432 2 7.00005C2 7.4632 2.10495 7.90183 2.29237 8.29347L0.292893 10.2929C-0.0976311 10.6835 -0.0976311 11.3166 0.292893 11.7072C0.683418 12.0977 1.31658 12.0977 1.70711 11.7072L3.70658 9.70768C4.09822 9.8951 4.53685 10 5 10ZM19 5.00005C19 5.55233 18.5523 6.00005 18 6.00005C17.4477 6.00005 17 5.55233 17 5.00005C17 4.44776 17.4477 4.00005 18 4.00005C18.5523 4.00005 19 4.44776 19 5.00005ZM12 13C12 13.5523 11.5523 14 11 14C10.4477 14 10 13.5523 10 13C10 12.4478 10.4477 12 11 12C11.5523 12 12 12.4478 12 13ZM6 7.00005C6 7.55233 5.55228 8.00005 5 8.00005C4.44772 8.00005 4 7.55233 4 7.00005C4 6.44776 4.44772 6.00005 5 6.00005C5.55228 6.00005 6 6.44776 6 7.00005Z" fill={fill} />
		</svg>
	),
	Home: ({ fill }: IconProps) => (
		<svg width="22" height="16" viewBox="0 0 22 21" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M1.00182 12H3.00146V20C3.00146 20.5523 3.44909 21 4.00128 21H10H12H17.9987C18.5509 21 18.9985 20.5523 18.9985 20V12H20.9982C21.8889 12 22.335 10.9229 21.7052 10.2929L11.707 0.292893C11.3165 -0.0976311 10.6835 -0.0976311 10.293 0.292893L0.294844 10.2929C-0.335006 10.9229 0.11108 12 1.00182 12ZM14 13V19H17V11C17 10.4477 17.4477 10 18 10H18.5858L11 2.41421L3.41421 10H4C4.55229 10 5 10.4477 5 11V19H8V13C8 11.8954 8.89543 11 10 11H12C13.1046 11 14 11.8954 14 13ZM10 19V13H12V19H10Z" fill={fill} />
		</svg>
	),
	Image: ({ fill }: IconProps) => (
		<svg width="20" height="16" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M2 0H18C19.1046 0 20 0.89543 20 2V18C20 19.1046 19.1046 20 18 20H2C0.89543 20 0 19.1046 0 18V2C0 0.89543 0.89543 0 2 0ZM2 15.5477L6.04883 10.4167C6.41809 9.94873 7.11213 9.9057 7.53636 10.3244L9.54496 12.3071L14.8746 5.31817C15.2514 4.8241 15.9828 4.78961 16.4044 5.24604L18 6.97349V2H2V15.5477ZM18 9.92108L15.743 7.47764L10.4463 14.4234C10.0808 14.9027 9.37757 14.9521 8.94863 14.5287L6.92666 12.5328L2.61257 18H18V9.92108ZM7 9C5.34315 9 4 7.65685 4 6C4 4.34315 5.34315 3 7 3C8.65685 3 10 4.34315 10 6C10 7.65685 8.65685 9 7 9ZM8 6C8 6.55228 7.55228 7 7 7C6.44772 7 6 6.55228 6 6C6 5.44772 6.44772 5 7 5C7.55228 5 8 5.44772 8 6Z" fill={fill} />
		</svg>
	),
	Info: ({ fill }: IconProps) => (
		<svg width="22" height="16" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M0 11C0 17.0751 4.92487 22 11 22C17.0751 22 22 17.0751 22 11C22 4.92487 17.0751 0 11 0C4.92487 0 0 4.92487 0 11ZM20.24 11C20.24 16.1031 16.1031 20.24 11 20.24C5.89689 20.24 1.76 16.1031 1.76 11C1.76 5.89689 5.89689 1.76 11 1.76C16.1031 1.76 20.24 5.89689 20.24 11ZM10 10C10 9.44771 10.4477 9 11 9C11.5523 9 12 9.44771 12 10V15C12 15.5523 11.5523 16 11 16C10.4477 16 10 15.5523 10 15V10ZM12 7C12 7.55228 11.5523 8 11 8C10.4477 8 10 7.55228 10 7C10 6.44772 10.4477 6 11 6C11.5523 6 12 6.44772 12 7Z" fill={fill} />
		</svg>
	),
	Layers: ({ fill }: IconProps) => (
		<svg width="18" height="16" viewBox="0 0 18 20" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M9.99228 0.263514L16.9923 4.26351C18.3359 5.0313 18.3359 6.9687 16.9923 7.73649L16.5311 8L16.9923 8.26351C18.3359 9.0313 18.3359 10.9687 16.9923 11.7365L16.5311 12L16.9923 12.2635C18.3359 13.0313 18.3359 14.9687 16.9923 15.7365L9.99228 19.7365C9.37741 20.0878 8.62259 20.0878 8.00772 19.7365L1.00772 15.7365C-0.335907 14.9687 -0.335907 13.0313 1.00772 12.2635L1.46887 12L1.00772 11.7365C-0.335907 10.9687 -0.335907 9.0313 1.00772 8.26351L1.46887 8L1.00772 7.73649C-0.335907 6.9687 -0.335907 5.0313 1.00772 4.26351L8.00772 0.263514C8.62259 -0.0878379 9.37741 -0.0878379 9.99228 0.263514ZM9.99228 11.7365L14.5156 9.15175L16 10L9 14L2 10L3.48444 9.15175L8.00772 11.7365C8.62259 12.0878 9.37741 12.0878 9.99228 11.7365ZM14.5156 13.1518L9.99228 15.7365C9.37741 16.0878 8.62259 16.0878 8.00772 15.7365L3.48444 13.1518L2 14L9 18L16 14L14.5156 13.1518ZM2 6L9 2L16 6L9 10L2 6Z" fill={fill} />
		</svg>
	),
	Marker: ({ fill }: IconProps) => (
		<svg width="16" height="16" viewBox="0 0 16 22" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M0 8.16206C0 12.5165 5.2362 22 8 22C10.7638 22 16 12.5165 16 8.16206C16 3.65934 12.4235 0 8 0C3.57653 0 0 3.65934 0 8.16206ZM11.3774 15.581C9.97421 18.1223 8.39916 20 8 20C7.60084 20 6.02579 18.1223 4.62264 15.581C3.06358 12.7573 2 9.7993 2 8.16206C2 4.75379 4.69148 2 8 2C11.3085 2 14 4.75379 14 8.16206C14 9.7993 12.9364 12.7573 11.3774 15.581ZM8 12C5.79086 12 4 10.2091 4 8C4 5.79086 5.79086 4 8 4C10.2091 4 12 5.79086 12 8C12 10.2091 10.2091 12 8 12ZM10 8C10 9.10457 9.10457 10 8 10C6.89543 10 6 9.10457 6 8C6 6.89543 6.89543 6 8 6C9.10457 6 10 6.89543 10 8Z" fill={fill} />
		</svg>
	),
	Mobile: ({ fill }: IconProps) => (
		<svg width="14" height="16" viewBox="0 0 14 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M12 0H2C0.89543 0 0 0.976833 0 2.18182V21.8182C0 23.0232 0.89543 24 2 24H12C13.1046 24 14 23.0232 14 21.8182V2.18182C14 0.976833 13.1046 0 12 0ZM2 22V2H12V22H2ZM7 21C7.55228 21 8 20.5523 8 20C8 19.4477 7.55228 19 7 19C6.44772 19 6 19.4477 6 20C6 20.5523 6.44772 21 7 21ZM5.5 4C5.5 4.27614 5.72386 4.5 6 4.5H8C8.27614 4.5 8.5 4.27614 8.5 4C8.5 3.72386 8.27614 3.5 8 3.5H6C5.72386 3.5 5.5 3.72386 5.5 4Z" fill={fill} />
		</svg>
	),
	PaperBag: ({ fill }: IconProps) => (
		<svg width="18" height="16" viewBox="0 0 18 23" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M16 0.875064C15.2774 0.875064 14.6443 1.25829 14.2928 1.83259L13.9014 1.44815C13.1284 0.688984 11.8915 0.683367 11.1116 1.43548L10.7396 1.79423L10.4317 1.47852C9.68428 0.712341 8.46616 0.670381 7.66783 1.38331L7.21236 1.79006L6.99209 1.54328C6.21358 0.67106 4.85615 0.64969 4.05057 1.49697L3.76864 1.79349L3.37137 1.41926C2.09524 0.217151 0 1.1219 0 2.87506V20.8751C0 21.9796 0.89543 22.8751 2 22.8751H16C17.1046 22.8751 18 21.9796 18 20.8751V2.87506C18 1.77049 17.1046 0.875064 16 0.875064ZM12.5 2.87506L14.2709 4.61432L16 2.87506V15.8751H2V2.87506L3.84634 4.61432L5.5 2.87506L7.0524 4.61432L9 2.87506L10.6966 4.61432L12.5 2.87506ZM2 20.8751V17.8751H16V20.8751H2ZM4 7.87506C4 8.42735 4.44772 8.87506 5 8.87506H8.33264C8.88493 8.87506 9.33264 8.42735 9.33264 7.87506C9.33264 7.32278 8.88493 6.87506 8.33264 6.87506H5C4.44772 6.87506 4 7.32278 4 7.87506Z" fill={fill} />
		</svg>
	),
	Pencil: ({ fill }: IconProps) => (
		<svg width="21" height="16" viewBox="0 0 21 22" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M17.0918 1.41421L19.9203 4.24264C20.7013 5.02369 20.7013 6.29002 19.9203 7.07107L6.48522 20.5061C6.11015 20.8812 5.60144 21.0919 5.07101 21.0919L2.24258 21.0919C1.13801 21.0919 0.242584 20.1965 0.242584 19.0919L0.242584 16.2635C0.242584 15.733 0.453297 15.2243 0.82837 14.8492L14.2634 1.41421C15.0444 0.633165 16.3108 0.633165 17.0918 1.41421ZM12.5459 5.96016L2.24258 16.2635V19.0919H5.07101L15.3743 8.78858L12.5459 5.96016ZM13.9601 4.54594L16.7885 7.37437L18.506 5.65685L15.6776 2.82843L13.9601 4.54594Z" fill={fill} />
		</svg>
	),
	Power: ({ fill }: IconProps) => (
		<svg width="21" height="16" viewBox="0 0 21 22" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M10 0C9.44773 0 9.00002 0.447715 9.00002 1V8C9.00002 8.55229 9.44773 9 10 9C10.5523 9 11 8.55229 11 8V1C11 0.447715 10.5523 0 10 0ZM6.63196 2.73413C6.3658 2.25055 5.75945 2.07166 5.27765 2.33457C4.45547 2.78322 3.69759 3.34949 3.02355 4.02353C-0.855439 7.90252 -0.834157 14.2129 3.07109 18.1181C6.97633 22.0234 13.2867 22.0447 17.1657 18.1657C21.0447 14.2867 21.0234 7.97631 17.1181 4.07107C16.4776 3.43053 15.7629 2.88542 14.9904 2.44416C14.5111 2.17036 13.9032 2.33549 13.6326 2.81299C13.362 3.29049 13.5313 3.89954 14.0106 4.17334C14.6281 4.52605 15.1998 4.96213 15.7134 5.47577C18.8376 8.59997 18.8547 13.6483 15.7515 16.7515C12.6483 19.8546 7.59999 19.8376 4.47579 16.7134C1.3516 13.5892 1.33457 8.54093 4.43776 5.43774C4.97823 4.89728 5.5844 4.44436 6.24153 4.08578C6.72333 3.82287 6.89813 3.21772 6.63196 2.73413Z" fill={fill} />
		</svg>
	),
	Shield: ({ fill }: IconProps) => (
		<svg width="21" height="16" viewBox="0 0 21 22" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M1.36587 3.43204L9.36587 0.149687C9.85231 -0.0498958 10.3978 -0.0498958 10.8842 0.149687L18.8842 3.43204C19.8058 3.81018 20.3087 4.80893 20.0636 5.77448L17.4561 16.0451C17.3515 16.4573 17.1182 16.8254 16.7901 17.0959L11.3975 21.543C10.6586 22.1523 9.59148 22.1523 8.85259 21.543L3.46 17.0959C3.1319 16.8254 2.89859 16.4573 2.79395 16.0451L0.18654 5.77448C-0.0585873 4.80893 0.444245 3.81018 1.36587 3.43204ZM2.12505 5.28235L4.73245 15.5529L10.125 20L15.5176 15.5529L18.125 5.28235L10.125 2L2.12505 5.28235ZM11.125 15V7.4986L14.1194 8.74323C14.6294 8.95521 15.2146 8.71363 15.4266 8.20365C15.6386 7.69366 15.397 7.1084 14.887 6.89642L10.5089 5.07659C9.85029 4.80285 9.12505 5.28679 9.12505 6V15C9.12505 15.5523 9.57276 16 10.125 16C10.6773 16 11.125 15.5523 11.125 15Z" fill={fill} />
		</svg>
	),
	Square: ({ fill }: IconProps) => (
		<svg width="16" height="16" viewBox="0 0 10 10" fill="none" xmlns="http://www.w3.org/2000/svg">
			<rect width="10" height="10" fill={fill} />
		</svg>
	),
	Tag: ({ fill }: IconProps) => (
		<svg width="22" height="16" viewBox="0 0 22 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M10.7046 1.72207C11.0709 1.35576 11.4894 1.00386 12.007 0.994235L19.9968 0.988892C21.1284 0.967852 22.0195 1.85409 21.9985 2.98573L21.9928 10.9801C21.9832 11.4977 21.6625 11.9473 21.2962 12.3136L11.1848 22.425C10.4037 23.2061 9.13829 23.207 8.35835 22.4271L0.591205 14.6599C-0.188736 13.88 -0.187838 12.6145 0.59321 11.8335L10.7046 1.72207ZM12.0056 2.99281L2.0054 13.2457L9.77254 21.0128L19.9942 10.9815L19.9999 2.98714L12.0056 2.99281ZM14.0002 6.99146C14.0002 8.09447 14.8957 8.98863 16.0002 8.98863C17.1048 8.98863 18.0002 8.09447 18.0002 6.99146C18.0002 5.88846 17.1048 4.9943 16.0002 4.9943C14.8957 4.9943 14.0002 5.88846 14.0002 6.99146Z" fill={fill} />
		</svg>
	),
	Thunder: ({ fill }: IconProps) => (
		<svg width="16" height="16" viewBox="0 0 16 22" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M13.3685 6.7183L10.2578 6.1354L11.9263 3.25155C12.6976 1.91822 11.7355 0.25 10.1951 0.25H7.11113C6.39768 0.25 5.73825 0.630057 5.38059 1.24738L1.26958 8.34309C0.577875 9.53698 1.27434 11.0561 2.63035 11.3112L4.91677 11.7414L1.84009 18.4124C0.875478 20.5039 3.62863 22.3003 5.15444 20.5749L14.4983 10.009C15.5272 8.8455 14.8951 7.00437 13.3685 6.7183ZM7.11113 2.25H10.1951L7.11113 7.58057L13.0001 8.68408L3.65624 19.25L7.80704 10.25L3.00011 9.3457L7.11113 2.25Z" fill={fill} />
		</svg>
	),
	Ticket: ({ fill }: IconProps) => (
		<svg width="21" height="16" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M1.87628 15.1435L0.549548 13.8168C-0.183183 13.0841 -0.183183 11.8961 0.549548 11.1634L11.1634 0.549548C11.8961 -0.183183 13.0841 -0.183183 13.8168 0.549548L15.1435 1.87628C15.8763 2.60901 15.8763 3.797 15.1435 4.52973C14.7772 4.89609 14.7772 5.49009 15.1435 5.85646C15.5099 6.22282 16.1039 6.22282 16.4703 5.85646C17.203 5.12372 18.391 5.12372 19.1237 5.85646L20.4505 7.18318C21.1832 7.91591 21.1832 9.10391 20.4505 9.83664L9.83664 20.4505C9.10391 21.1832 7.91591 21.1832 7.18318 20.4505L5.85646 19.1237C5.12372 18.391 5.12372 17.203 5.85646 16.4703C6.22282 16.1039 6.22282 15.5099 5.85646 15.1435C5.49009 14.7772 4.89609 14.7772 4.52973 15.1435C3.797 15.8763 2.60901 15.8763 1.87628 15.1435ZM3.203 13.8168C4.3021 12.7177 6.08409 12.7177 7.18318 13.8168C8.28228 14.9159 8.28228 16.6979 7.18318 17.797L8.50991 19.1237L19.1237 8.50991L17.797 7.18318C16.6979 8.28228 14.9159 8.28228 13.8168 7.18318C12.7177 6.08409 12.7177 4.3021 13.8168 3.203L12.4901 1.87628L1.87628 12.4901L3.203 13.8168ZM7.84655 7.84655C7.48018 8.21291 7.48597 8.81269 7.85947 9.18619L11.8138 13.1405C12.1873 13.514 12.7871 13.5198 13.1535 13.1535C13.5198 12.7871 13.514 12.1873 13.1405 11.8138L9.18619 7.85947C8.81269 7.48597 8.21291 7.48018 7.84655 7.84655Z" fill={fill} />
		</svg>
	),
	Upload: ({ fill }: IconProps) => (
		<svg width="20" height="16" viewBox="0 0 20 18" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M5.29289 5.70711C5.68342 6.09763 6.31658 6.09763 6.70711 5.70711L9 3.41421V12.0015C9 12.5529 9.44771 13 10 13C10.5523 13 11 12.5529 11 12.0015V3.41421L13.2929 5.70711C13.6834 6.09763 14.3166 6.09763 14.7071 5.70711C15.0976 5.31658 15.0976 4.68342 14.7071 4.29289L10.7071 0.292893C10.3166 -0.0976311 9.68342 -0.0976311 9.29289 0.292893L5.29289 4.29289C4.90237 4.68342 4.90237 5.31658 5.29289 5.70711ZM18 10C18 9.44771 18.4477 9 19 9C19.5523 9 20 9.44771 20 10V17C20 17.5523 19.5523 18 19 18H1C0.447715 18 0 17.5523 0 17V10C0 9.44771 0.447715 9 1 9C1.55228 9 2 9.44771 2 10V16H18V10Z" fill={fill} />
		</svg>
	),
	User: ({ fill }: IconProps) => (
		<svg width="18" height="16" viewBox="0 0 18 21" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M9.00001 10C6.23858 10 4.00001 7.76142 4.00001 5C4.00001 2.23858 6.23858 0 9.00001 0C11.7614 0 14 2.23858 14 5C14 7.76142 11.7614 10 9.00001 10ZM9.00001 8C10.6569 8 12 6.65685 12 5C12 3.34315 10.6569 2 9.00001 2C7.34315 2 6.00001 3.34315 6.00001 5C6.00001 6.65685 7.34315 8 9.00001 8ZM0.977676 20.9998C1.52982 21.0121 1.98742 20.5745 1.99976 20.0223C2.12226 14.5373 4.37763 13 8.99995 13C13.8804 13 16.1174 14.5181 15.9954 19.9777C15.9831 20.5298 16.4207 20.9874 16.9729 20.9998C17.525 21.0121 17.9826 20.5745 17.9949 20.0223C18.141 13.4819 15.0479 11 8.99995 11C3.22369 11 0.145765 13.4627 0.000254371 19.9777C-0.0120777 20.5298 0.425529 20.9874 0.977676 20.9998Z" fill={fill} />
		</svg>
	),
	VideoCamera: ({ fill }: IconProps) => (
		<svg width="22" height="16" viewBox="0 0 22 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M15 0H2C0.89543 0 0 0.89543 0 2V12C0 13.1046 0.89543 14 2 14H15C16.1046 14 17 13.1046 17 12V9.91175L20.5134 11.8782C21.1834 12.2368 22 11.7605 22 11.011V2.98903C22 2.23955 21.1834 1.76318 20.5134 2.12178L17 4.09546V2C17 0.89543 16.1046 0 15 0ZM2 8V2H15V8H2ZM2 10V12H15V10H2ZM19.9558 4.6837V9.43863L16 7.06116L19.9558 4.6837ZM13 5.5C12.1716 5.5 11.5 4.82843 11.5 4C11.5 3.17157 12.1716 2.5 13 2.5C13.8284 2.5 14.5 3.17157 14.5 4C14.5 4.82843 13.8284 5.5 13 5.5Z" fill={fill} />
		</svg>
	),
	Wallet: ({ fill }: IconProps) => (
		<svg width="22" height="16" viewBox="0 0 22 20" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M18 4H20C21.1046 4 22 4.89543 22 6V9V15V18C22 19.1046 21.1046 20 20 20H2C0.89543 20 0 19.1046 0 18V2C0 0.89543 0.89543 0 2 0H16C17.1046 0 18 0.89543 18 2V4ZM20 6V8H12C11.4477 8 11 8.44771 11 9V15C11 15.5523 11.4477 16 12 16H20V18H2V6H16H17H20ZM13 14H20V10H13V14ZM2 4H16V2H2V4ZM16 12C16 12.5523 15.5523 13 15 13C14.4477 13 14 12.5523 14 12C14 11.4477 14.4477 11 15 11C15.5523 11 16 11.4477 16 12Z" fill={fill} />
		</svg>
	),
	Watch: ({ fill }: IconProps) => (
		<svg width="14" height="16" viewBox="0 0 14 22" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M4.23374 6.83429L4.97073 7L5.08074 6.38161C5.67171 6.13574 6.32 6 7 6C7.68 6 8.32829 6.13574 8.91926 6.38161L9.02927 7L9.76626 6.83429C11.1127 7.73019 12 9.26147 12 11C12 12.7385 11.1127 14.2698 9.76626 15.1657L9.02927 15L8.91926 15.6184C8.32829 15.8643 7.68 16 7 16C6.32 16 5.67171 15.8643 5.08074 15.6184L4.97073 15L4.23374 15.1657C2.88729 14.2698 2 12.7385 2 11C2 9.26147 2.88729 7.73019 4.23374 6.83429ZM5.47477 4.16665C5.96576 4.05754 6.47616 4 7 4C7.52384 4 8.03424 4.05754 8.52523 4.16665L8.18595 2.25948H5.81405L5.47477 4.16665ZM10.7373 5.08009L9.99512 0.90818C9.90118 0.380112 9.48876 0 9.00976 0H4.99024C4.51124 0 4.09882 0.380112 4.00488 0.90818L3.26271 5.08009C1.30196 6.32053 0 8.50822 0 11C0 13.4918 1.30196 15.6795 3.26271 16.9199L4.00488 21.0918C4.09882 21.6199 4.51124 22 4.99024 22H9.00976C9.48876 22 9.90118 21.6199 9.99512 21.0918L10.7373 16.9199C12.698 15.6795 14 13.4918 14 11C14 8.50822 12.698 6.32053 10.7373 5.08009ZM5.81405 19.7405L5.47477 17.8334C5.96576 17.9425 6.47616 18 7 18C7.52384 18 8.03424 17.9425 8.52523 17.8334L8.18595 19.7405H5.81405Z" fill={fill} />
		</svg>
	),
	Wrench: ({ fill }: IconProps) => (
		<svg width="24" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M16.7079 9.04065L15.2937 7.62644L18.5582 4.36201C19.6567 3.26348 19.0764 1.3596 17.5383 1.01585C14.9258 0.431983 12.2003 1.1843 10.2984 3.08624C8.24419 5.14044 7.55757 8.12813 8.36309 10.85L1.29993 17.9131C0.534573 18.6785 0.547291 19.9321 1.32834 20.7131L3.44966 22.8345C4.23071 23.6155 5.48432 23.6282 6.24968 22.8629L13.0567 16.0558C15.9527 17.2533 19.3412 16.6708 21.6121 14.3999C23.7102 12.3018 24.3988 9.21121 23.4727 6.39903C23.0063 4.983 21.2164 4.53223 20.179 5.56958L16.7079 9.04065ZM11.7126 4.50045C13.1766 3.03644 15.2361 2.52141 17.1439 2.94779L13.1866 6.90513C12.8039 7.28781 12.8103 7.91462 13.2008 8.30514L16.0292 11.1336C16.4198 11.5241 17.0466 11.5304 17.4293 11.1478L21.5932 6.98379C22.271 9.04166 21.8092 11.3744 20.1979 12.9857C18.1673 15.0163 14.9913 15.2213 12.6632 13.6209L4.83547 21.4487L2.71415 19.3273L10.6773 11.3642C9.53109 9.12542 9.87118 6.34188 11.7126 4.50045Z" fill={fill} />
		</svg>
	)
};