# Overview

***EXT2 Filesystem Reader*** is a program written in pure Java, that can read the contents of an ext2-filesystem
image and output that data in a style that imitates the Linux terminal.
This implementation only supports little-endian format.

The most recent version supports the following commands, that once again
try to imitate the way that they work on the Linux kernel:

1. **cd**
2. **ls**
3. **cat**
4. **exit**

# Structure
The first 1024 bytes of an Ext2 disk is the **boot block**, hence the **superblock** offset is 1024. The 
**group-descriptor** offset depends on the block-size chosen at the creation of this Ext2-filesystem disk.
*When  creating  an  Ext2  filesystem,  the  system  administrator  may  choose  the optimal block size 
(from 1024 to 4096 bytes), depending on the expected average file length*. [1]
>This implementation always assumes an optimal block size of 1024 bytes (though this can be changed
manually from *Constants.java*).

Now that we know the block-size, the list of **group-descriptors** (which are the blocks placed immediately after the 
superblock) obviously have the offset of 2048. What the block group descriptors are, will be explained
later on. 

## Boot-block
The contents of the boot-block are reserved for the partition boot sectors and are unused by the Ext2 filesystem 
[[2](http://cs.smith.edu/~nhowe/Teaching/csc262/oldlabs/ext2.html)].

STEP-BY-STEP WALKTHROUGH COMING SOON [HERE](https://soutzis.github.io/EXT2-Filesystem-Reader/)!


# References
1. Understanding the Linux Kernel (2nd edition), Daniel P. Bovet and Marco Cesati, 2002, [Chapter 17](http://ermak.cs.nstu.ru/Understanding.Linux.Kernel.pdf#%5B%7B%22num%22%3A1435%2C%22gen%22%3A0%7D%2C%7B%22name%22%3A%22FitH%22%7D%2C872%5D)
2. [Nicholas Howe & Emanuele Altieri, June 2002](http://cs.smith.edu/~nhowe/Teaching/csc262/oldlabs/ext2.html)
