/*
 * Decompiled with CFR 0.152.
 */
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Superblock {
    private short sMagic;
    private int inodeCount;
    private int blockCount;
    private int blocksPerGroup;
    private int inodesPerGroup;
    private int sInodeSize;
    private String volumeName;
    private ByteBuffer buffer;

    public Superblock(byte[] bytes) {
        this.buffer = ByteBuffer.wrap(bytes);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.read();
    }

    private void read() {
        this.sMagic = this.buffer.getShort(56);
        this.inodeCount = this.buffer.getInt(0);
        this.blockCount = this.buffer.getInt(4);
        this.blocksPerGroup = this.buffer.getInt(32);
        this.inodesPerGroup = this.buffer.getInt(40);
        this.sInodeSize = this.buffer.getInt(88);
        byte[] char_bytes = new byte[16];
        for (int i = 0; i < 16; ++i) {
            char_bytes[i] = this.buffer.get(120 + i);
        }
        this.volumeName = new String(char_bytes);
    }

    int getInodeSize() {
        return this.sInodeSize;
    }

    int getInodeCount() {
        return this.inodeCount;
    }

    int getInodesPerGroup() {
        return this.inodesPerGroup;
    }

    int getBlockCount() {
        return this.blockCount;
    }

    int getBlocksPerGroup() {
        return this.blocksPerGroup;
    }

    String getVolumeName() {
        return this.volumeName;
    }

    String shortToHex(Short s) {
        String transformed = Integer.toHexString(s - -65536);
        return "0x" + transformed;
    }

    int getBlockGroupCount(int num_of_blocks, int blocks_per_group) {
        int count = num_of_blocks / blocks_per_group;
        if (num_of_blocks % blocks_per_group != 0) {
            ++count;
        }
        return count;
    }

    void printGenericData(int inodeSize, int blockGroupCount) {
        boolean correctMagicNum = -4269 == this.sMagic;
        System.out.println("VOLUME NAME: " + this.volumeName);
        System.out.print("Magic number is: " + this.shortToHex(this.sMagic));
        if (correctMagicNum) {
            System.out.println(" -> Magic number is OK.");
        } else {
            System.out.println(" -> Magic number is INVALID, possible corruption of files.");
        }
        System.out.println("Total number of inodes is: " + this.inodeCount);
        System.out.println("Total number of inodes per group is: " + this.inodesPerGroup);
        System.out.println("Total size of inodes is: " + inodeSize);
        System.out.println("Total number of blocks is: " + this.blockCount);
        System.out.println("Total number of blocks per group is: " + this.blocksPerGroup);
        System.out.println("Total number of block groups is: " + blockGroupCount);
    }
}

