/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Date;

public class Inode {
    private short i_mode;
    private short i_uid;
    private int i_size_lower;
    private int i_atime;
    private int i_ctime;
    private int i_mtime;
    private int i_dtime;
    private short i_gid;
    private short i_links_count;
    private int[] i_block_pointer;
    private int i_size_upper;
    private ByteBuffer buffer;

    public Inode(byte[] bytes) {
        this.buffer = ByteBuffer.wrap(bytes);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.i_block_pointer = new int[15];
        this.read();
    }

    private void read() {
        this.i_mode = this.buffer.getShort(0);
        this.i_uid = this.buffer.getShort(2);
        this.i_size_lower = this.buffer.getInt(4);
        this.i_atime = this.buffer.getInt(8);
        this.i_ctime = this.buffer.getInt(12);
        this.i_mtime = this.buffer.getInt(16);
        this.i_dtime = this.buffer.getInt(20);
        this.i_gid = this.buffer.getShort(24);
        this.i_links_count = this.buffer.getShort(26);
        for (int i = 0; i < 15; ++i) {
            this.i_block_pointer[i] = this.buffer.getInt(40 + i * 4);
        }
        this.i_size_upper = this.buffer.getInt(108);
    }

    String readPermissions() {
        String permissions = "";
        if ((this.i_mode & 0xC000) == 49152) {
            permissions = "socket";
        } else if ((this.i_mode & 0xA000) == 40960) {
            permissions = "symbolic link";
        } else if ((this.i_mode & 0x8000) == 32768) {
            permissions = "-";
        } else if ((this.i_mode & 0x6000) == 24576) {
            permissions = "block device";
        } else if ((this.i_mode & 0x4000) == 16384) {
            permissions = "d";
        } else if ((this.i_mode & 0x2000) == 8192) {
            permissions = "c";
        } else if ((this.i_mode & 0x1000) == 4096) {
            permissions = "fifo";
        }
        permissions = permissions + ((this.i_mode & 0x100) == 256 ? "r" : "-");
        permissions = permissions + ((this.i_mode & 0x80) == 128 ? "w" : "-");
        permissions = permissions + ((this.i_mode & 0x40) == 64 ? "x" : "-");
        permissions = permissions + ((this.i_mode & 0x20) == 32 ? "r" : "-");
        permissions = permissions + ((this.i_mode & 0x10) == 16 ? "w" : "-");
        permissions = permissions + ((this.i_mode & 8) == 8 ? "x" : "-");
        permissions = permissions + ((this.i_mode & 4) == 4 ? "r" : "-");
        permissions = permissions + ((this.i_mode & 2) == 2 ? "w" : "-");
        permissions = permissions + ((this.i_mode & 1) == 1 ? "x" : "-");
        permissions = permissions + ((this.i_mode & 0x200) == 512 ? "t" : "");
        return permissions;
    }

    private static int findInodeOffset(String path, Inode inode, Ext2File ext2) throws IOException {
        int[] blockPointers = inode.getBlockPointers();
        int noData = 0;
        for (int i = 0; i < 12; ++i) {
            short recLength;
            if (blockPointers[i] == 0) continue;
            byte[] data = ext2.readBytes(blockPointers[i] * 1024, 1024L);
            ByteBuffer buffer = ByteBuffer.wrap(data);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            for (int j = 0; j < buffer.limit(); j += recLength) {
                recLength = buffer.getShort(j + 4);
                byte[] nameBytes = new byte[buffer.get(j + 4 + 2)];
                for (int k = 0; k < nameBytes.length; ++k) {
                    nameBytes[k] = buffer.get(k + j + 8);
                }
                if (!path.equals(new String(nameBytes).trim())) continue;
                return buffer.getInt(j);
            }
        }
        return noData;
    }

    static Inode getContainingInode(String[] pathArray, int inodeSize, Ext2File ext2, Inode inode, Superblock superblock, GroupDescriptor groupDescriptor) throws IOException {
        Inode currentInode = inode;
        for (String fragment : pathArray) {
            int inodeOffset = Inode.findInodeOffset(fragment, currentInode, ext2);
            if (inodeOffset <= 0) {
                System.out.println("No such file or directory");
                return null;
            }
            byte[] inodeData = ext2.readBytes(Inode.getContainingBlock(inodeOffset, superblock, groupDescriptor), inodeSize);
            currentInode = new Inode(inodeData);
            currentInode.read();
        }
        return currentInode;
    }

    static int getContainingBlock(int rootInodeOffset, Superblock superblock, GroupDescriptor groupDescriptor) {
        int inodeCount = superblock.getInodeCount();
        int inodesPerGroup = superblock.getInodesPerGroup();
        int inodeSize = superblock.getInodeSize();
        int[] gDescPointer = groupDescriptor.getGDescPointer();
        if (rootInodeOffset >= 2 && rootInodeOffset < inodeCount) {
            int pointerDiv = --rootInodeOffset / inodesPerGroup;
            double pointer = rootInodeOffset % inodesPerGroup;
            int inodeTablePointer = gDescPointer[pointerDiv];
            double containingBlock = (pointer * (double)inodeSize / 1024.0 + (double)inodeTablePointer) * 1024.0;
            return (int)containingBlock;
        }
        return 0;
    }

    int[] getBlockPointers() {
        return this.i_block_pointer;
    }

    String getUid() {
        return this.i_uid == 0 ? "root" : "user";
    }

    String getGid() {
        return this.i_gid == 0 ? "root" : "group";
    }

    int getSizeLower() {
        return this.i_size_lower;
    }

    int getSizeUpper() {
        return this.i_size_upper;
    }

    public boolean isFile() {
        return (this.i_mode & 0x8000) == 32768;
    }

    public Date getDate() {
        return new Date((long)this.i_ctime * 1000L);
    }

    short getHardLinks() {
        return this.i_links_count;
    }
}

