/*
 * Decompiled with CFR 0.152.
 */
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class GroupDescriptor {
    private ByteBuffer buffer;
    private int groupCount;
    private int[] gdPointer;

    public GroupDescriptor(byte[] bytes, int groupCount) {
        this.buffer = ByteBuffer.wrap(bytes);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.groupCount = groupCount;
        this.gdPointer = new int[groupCount];
        this.read();
    }

    private void read() {
        int gdSize = 32;
        int inodeTablePointerOffset = 8;
        for (int i = 0; i < this.groupCount; ++i) {
            this.gdPointer[i] = this.buffer.getInt(gdSize * i + inodeTablePointerOffset);
        }
    }

    int[] getGDescPointer() {
        return this.gdPointer;
    }
}

