/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

public class FileInfo {
    void readHexData(ArrayList<byte[]> raw) {
        int counter = 0;
        System.out.print("\n\nHex representation:\n");
        for (byte[] data : raw) {
            for (byte datum : data) {
                if (counter % 26 == 0 && counter != 0) {
                    System.out.print("\n");
                }
                if (datum == 0) continue;
                System.out.print(String.format("%02X ", datum));
                ++counter;
            }
            while (counter % 26 != 0) {
                System.out.print("XX ");
                ++counter;
            }
        }
        System.out.println("\n");
    }

    static void readDirectoryData(Inode inode, int inodeSize, Ext2File ext2, Superblock superblock, GroupDescriptor groupDescriptor) throws IOException {
        FileInfo.readBlockData(inode, inode.isFile(), inodeSize, ext2, superblock, groupDescriptor);
    }

    static void readFileData(Inode inode, int inodeSize, Ext2File ext2, Superblock superblock, GroupDescriptor groupDescriptor, String path) throws IOException {
        if (!inode.isFile()) {
            System.out.println(path + ": Is a directory.");
        } else {
            FileInfo.readBlockData(inode, inode.isFile(), inodeSize, ext2, superblock, groupDescriptor);
        }
    }

    private static void readBlockData(Inode inode, boolean isFile, int inodeSize, Ext2File ext2, Superblock superblock, GroupDescriptor groupDescriptor) throws IOException {
        int[] blockPointers = inode.getBlockPointers();
        for (int i = 0; i < 12; ++i) {
            if (blockPointers[i] == 0) continue;
            FileInfo.printBlockData(blockPointers[i], inodeSize, isFile, ext2, superblock, groupDescriptor);
        }
        if (blockPointers[12] != 0) {
            FileInfo.readIndirectData(blockPointers[12], inodeSize, isFile, ext2, superblock, groupDescriptor);
        }
        if (blockPointers[13] != 0) {
            FileInfo.readDoubleIndirectData(blockPointers[13], inodeSize, isFile, ext2, superblock, groupDescriptor);
        }
        if (blockPointers[14] != 0) {
            FileInfo.readTripleIndirectData(blockPointers[14], inodeSize, isFile, ext2, superblock, groupDescriptor);
        }
    }

    private static void printBlockData(int blockNumber, int inodeSize, boolean isFile, Ext2File ext2, Superblock superblock, GroupDescriptor groupDescriptor) throws IOException {
        byte[] blockData = ext2.readBytes(blockNumber * 1024, 1024L);
        if (isFile) {
            String str = new String(blockData).trim();
            System.out.print(str);
        } else {
            short dirLength;
            ByteBuffer buffer = ByteBuffer.wrap(blockData);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < buffer.limit(); i += dirLength) {
                int inodeOffset = buffer.getInt(i);
                dirLength = buffer.getShort(i + 4);
                byte nameBytes = buffer.get(i + 4 + 2);
                byte[] charBytes = new byte[nameBytes];
                for (int j = 0; j < charBytes.length; ++j) {
                    charBytes[j] = buffer.get(j + i + 8);
                }
                int containingBlock = Inode.getContainingBlock(inodeOffset, superblock, groupDescriptor);
                byte[] otherData = ext2.readBytes(containingBlock, inodeSize);
                Inode iData = new Inode(otherData);
                long fileSize = (long)iData.getSizeUpper() << 32 | (long)iData.getSizeLower() & 0xFFFFFFFFL;
                System.out.format("%-12s\t%-4d\t%-7s\t%-7s\t%-12d %-30s\t%-30s%n", iData.readPermissions(), iData.getHardLinks(), iData.getUid(), iData.getGid(), fileSize, iData.getDate(), new String(charBytes).trim());
            }
        }
    }

    private static void readIndirectData(int blockNumber, int inodeSize, boolean isFile, Ext2File ext2, Superblock superblock, GroupDescriptor groupDescriptor) throws IOException {
        byte[] blockData = ext2.readBytes(blockNumber * 1024, 1024L);
        ByteBuffer buffer = ByteBuffer.wrap(blockData);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < buffer.limit(); i += 4) {
            if (buffer.getInt(i) == 0) continue;
            FileInfo.printBlockData(buffer.getInt(i), inodeSize, isFile, ext2, superblock, groupDescriptor);
        }
    }

    private static void readDoubleIndirectData(int blockNumber, int inodeSize, boolean isFile, Ext2File ext2, Superblock superblock, GroupDescriptor groupDescriptor) throws IOException {
        byte[] blockData = ext2.readBytes(blockNumber * 1024, 1024L);
        ByteBuffer buffer = ByteBuffer.wrap(blockData);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < buffer.limit(); i += 4) {
            if (buffer.getInt(i) == 0) continue;
            FileInfo.readIndirectData(buffer.getInt(i), inodeSize, isFile, ext2, superblock, groupDescriptor);
        }
    }

    private static void readTripleIndirectData(int blockNumber, int inodeSize, boolean isFile, Ext2File ext2, Superblock superblock, GroupDescriptor groupDescriptor) throws IOException {
        byte[] blockData = ext2.readBytes(blockNumber * 1024, 1024L);
        ByteBuffer buffer = ByteBuffer.wrap(blockData);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < buffer.limit(); i += 4) {
            if (buffer.getInt(i) == 0) continue;
            FileInfo.readDoubleIndirectData(buffer.getInt(i), inodeSize, isFile, ext2, superblock, groupDescriptor);
        }
    }
}

