/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Scanner;
import java.util.Stack;

public class Driver {
    private static Inode inode = null;
    private static String currentDir;
    private static Stack<String> pathStack;
    private static boolean running;

    private static String getComputerName() {
        Map<String, String> env = System.getenv();
        if (env.containsKey("USER")) {
            return env.get("USER") + ":";
        }
        return env.getOrDefault("USERNAME", "UnknownHost") + ":";
    }

    private static void getCurrentPathName(String[] pathArray) {
        for (String path : pathArray) {
            if (path.equals("..") && !pathStack.peek().equals("/")) {
                pathStack.pop();
                continue;
            }
            if (path.equals(".") || path.equals("..")) continue;
            if (pathStack.peek().equals("/")) {
                pathStack.push(path);
                continue;
            }
            pathStack.push("/" + path);
        }
        Stack<String> pathStackCopy = new Stack<String>();
        pathStackCopy.addAll(pathStack);
        StringBuilder sb = new StringBuilder();
        while (!pathStackCopy.empty()) {
            sb.insert(0, (String)pathStackCopy.pop());
        }
        currentDir = sb.toString();
    }

    private static boolean getInputYesNo() {
        Scanner scanner = new Scanner(System.in);
        String yes = "y";
        String no = "n";
        String input = scanner.nextLine();
        while (!input.equalsIgnoreCase(yes) && !input.equalsIgnoreCase(no)) {
            System.out.println("Only acceptable inputs are \"Y\" and \"N\" (case insensitive).");
            System.out.print("(Y/N): ");
            input = scanner.nextLine();
        }
        return input.equalsIgnoreCase(yes);
    }

    private static void getCommandAndExecute(String input, int inodeSize, Superblock sBlock, GroupDescriptor groupDesc, Ext2File ext2) throws IOException {
        String manySpacesRegex = " +";
        String[] inputPipeline = input.replaceAll(manySpacesRegex, " ").trim().split(" ");
        String command = inputPipeline[0];
        String path = inputPipeline.length > 1 ? inputPipeline[1] : ".";
        String[] pathArray = path.split("/");
        Inode currentInode = Inode.getContainingInode(pathArray = (String[])Arrays.stream(pathArray).filter(s -> s.length() > 0).toArray(String[]::new), inodeSize, ext2, inode, sBlock, groupDesc);
        if (currentInode == null) {
            return;
        }
        switch (command) {
            case "exit": {
                running = false;
                Command.doExit();
                break;
            }
            case "ls": {
                if (currentInode.isFile()) {
                    System.out.println(pathArray[pathArray.length - 1]);
                    break;
                }
                Command.doLs(currentInode, inodeSize, ext2, sBlock, groupDesc);
                break;
            }
            case "cat": {
                Command.doCat(currentInode, inodeSize, ext2, sBlock, groupDesc, pathArray[pathArray.length - 1]);
                break;
            }
            case "cd": {
                if (currentInode.isFile()) {
                    System.out.println("Not a directory");
                    break;
                }
                inode = currentInode;
                Driver.getCurrentPathName(pathArray);
                break;
            }
            default: {
                System.out.println(command + ": command not found");
            }
        }
    }

    public static void main(String[] args) throws IOException {
        running = true;
        String compName = Driver.getComputerName();
        String promptSymbol = "$ ";
        System.out.println("EXT2 Filesystem Reader version 2.0.2 BY P.SOUTZIS\n");
        String fsName = Ext2File.getFileSystemName();
        Volume vol = new Volume(fsName);
        Ext2File ext2 = new Ext2File(vol);
        byte[] superBlockData = ext2.readBytes(1024L, 1024L);
        Superblock sBlock = new Superblock(superBlockData);
        int blockCount = sBlock.getBlockCount();
        int blocksPerGroup = sBlock.getBlocksPerGroup();
        int inodeSize = sBlock.getInodeSize();
        int blockGroupCount = sBlock.getBlockGroupCount(blockCount, blocksPerGroup);
        byte[] gDescData = ext2.readBytes(2048L, 1024L);
        GroupDescriptor groupDesc = new GroupDescriptor(gDescData, blockGroupCount);
        System.out.print("Would you like to view generic information about the mounted volume? (Y/N): ");
        if (Driver.getInputYesNo()) {
            sBlock.printGenericData(inodeSize, blockGroupCount);
            int[] inodeTable = groupDesc.getGDescPointer();
            for (int i = 0; i < inodeTable.length; ++i) {
                System.out.println("Inode Table " + (i + 1) + " offset in Group Descriptor is: " + inodeTable[i]);
            }
        }
        pathStack.push("/");
        currentDir = pathStack.peek();
        int rootInodeBlockNumber = Inode.getContainingBlock(2, sBlock, groupDesc);
        byte[] rootInodeData = ext2.readBytes(rootInodeBlockNumber, inodeSize);
        inode = new Inode(rootInodeData);
        while (running) {
            System.out.print("\n" + compName + currentDir + promptSymbol);
            Scanner scan = new Scanner(System.in);
            String input = scan.nextLine();
            Driver.getCommandAndExecute(input, inodeSize, sBlock, groupDesc, ext2);
        }
    }

    static {
        pathStack = new Stack();
        running = false;
    }
}

