<?php

use Soosyze\Core\Modules\System\Contract\DatabaseMigrationInterface;
use Soosyze\Queryflatfile\Request;
use Soosyze\Queryflatfile\Schema;

return new class implements DatabaseMigrationInterface {
    public function up(Schema $sch, Request $req): void
    {
        $roles = [
            [
                'id'    => 1,
                'color' => '#e5941f'
            ],
            [
                'id'    => 2,
                'color' => '#fe4341'
            ],
            [
                'id'    => 3,
                'color' => '#858eec'
            ]
        ];

        foreach ($roles as $role) {
            $roleCurrent = $req->from('role')->where('role_id', '=', $role[ 'id' ])->fetch();
            if (isset($roleCurrent) && $roleCurrent[ 'role_color' ] !== '#e6e7f4') {
                continue;
            }

            $req->update('role', [
                    'role_color' => $role[ 'color' ]
                ])
                ->where('role_id', '=', $role[ 'id' ])
                ->execute();
        }
    }
};
