---
title: 节点
description: 节点是流程的核心，通过不同节点的串联和连接，能配置出非常复杂的流程，满足不同的业务常见需求。
keywords:
  - 流程节点
  - 方法调用
  - 变量引擎
createTime: 2024/10/18 15:09:38
permalink: /docs/guide/user/design/nodes/
---

# 节点

### 1.开始节点

开始节点为系统默认节点，表示流程的开始，没有任何业务含义。

### 2.结束节点

结束节点为系统默认节点，表示流程的结束，没有任何业务含义。

### 3.方法节点

方法节点是用来承载接口的，通过方法节点，用户在方法节点上定义不同系统的接口，然后通过流程编排打通各个系统之间的屏障，达到各个系统互通互联的目的。

### 4.判断节点

判断节点是用来承载判断条件的，一个判断节点会有多个分支，默认会有一个else分支，每个分支之间是互斥的，从左往右依次执行，第一个命中的分支将会被触发，如果都没命中就会进入默认的else分支。

判断节点的判断条件只能由一个或多个变量组成，每种数据类型的变量支持的[表达式](/docs/guide/user/data-type-info/#数据类型支持的表达式)是不一样，变量可以是入参变量，出参变量，中间变量，具体变量的赋值来源可以参考[变量](/docs/guide/user/design/variable/)章节。

### 5.代码节点

自定义代码节点是用来承载代码的，即可以在流程设计过程中添加一个自定义的代码节点，可以在这个节点内直接编写Groovy的脚本代码，脚本代码可以完成变量的组装转换，业务逻辑增强，数据清洗等工作，代码节点将极大的提升Juggle编排的灵活性