INSERT INTO `t_user` (`id`, `user_name`, `password`, `deleted`) VALUES (1, 'juggle', '24cb6bcbc65730e9650745d379613563', 0);


INSERT INTO `t_suite` (`id`, `suite_code`, `suite_name`, `suite_classify_id`, `suite_image`, `suite_version`, `suite_desc`, `suite_help_doc_json`, `suite_flag`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 'example_suite', '系统示例接口套件', NULL, 'data:image/png;base64,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', 'v1.0.0', '这是系统内置的一个测试接口', NULL, 0, 0, '2024-04-06 23:17:36', 1, '2024-04-07 00:39:37', NULL);


INSERT INTO `t_api` (`id`, `suite_id`, `api_name`, `api_code`, `api_url`, `api_desc`, `api_request_type`, `api_request_content_type`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 1, '登录接口','dea23c0cad473dfcae523401052f89a0', 'http://127.0.0.1:9127/example/user/login', '', 'POST', 'application/json', 0, '2024-03-08 22:16:37', 1, '2024-07-02 23:29:33', 1);
INSERT INTO `t_api` (`id`, `suite_id`, `api_name`, `api_code`, `api_url`, `api_desc`, `api_request_type`, `api_request_content_type`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (2, 1, '获取用户信息', '7da045369a437a29e66c3154229e3190','http://127.0.0.1:9127/example/user/getUserById', '获取用户信息-测试接口', 'GET', 'application/x-www-form-urlencoded', 0, '2024-03-09 22:32:22', 1, '2024-07-02 23:29:33', 1);
INSERT INTO `t_api` (`id`, `suite_id`, `api_name`, `api_code`, `api_url`, `api_desc`, `api_request_type`, `api_request_content_type`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (8, 1, '发布商品', '86eaa1477f519274bb05fc90b1e76e83','http://127.0.0.1:9127/example/goods/releaseGoods', '', 'GET', 'application/json', 0, '2024-03-10 22:28:57', 1, '2024-07-02 23:29:33', 1);
INSERT INTO `t_api` (`id`, `suite_id`, `api_name`, `api_code`, `api_url`, `api_desc`, `api_request_type`, `api_request_content_type`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (9, 1, '获取商品详情','4a6054620efab47bbd69507b4de044c9', 'http://127.0.0.1:9127/example/goods/getGoodsInfo', '', 'GET', 'application/json', 0, '2024-03-10 22:33:11', 1, '2024-07-02 23:29:33', 1);
INSERT INTO `t_api` (`id`, `suite_id`, `api_name`, `api_code`, `api_url`, `api_desc`, `api_request_type`, `api_request_content_type`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (15, 1, '购买商品','a141ec5b270a87fe4a42a2ea1300cf0d', 'http://127.0.0.1:9127/example/order/placeOrder', '', 'POST', 'application/x-www-form-urlencoded', 0, '2024-03-10 22:43:09', 1, '2024-07-02 23:29:33', 1);
INSERT INTO `t_api` (`id`, `suite_id`, `api_name`, `api_code`, `api_url`, `api_desc`, `api_request_type`, `api_request_content_type`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (16, 1, '获取订单列表','0004812ec25f31c3f25596681997978d', 'http://127.0.0.1:9127/example/order/getUserOrderList', '', 'GET', 'application/x-www-form-urlencoded', 0, '2024-03-10 23:06:32', 1, '2024-07-02 23:29:33', 1);
INSERT INTO `t_api` (`id`, `suite_id`, `api_name`, `api_code`, `api_url`, `api_desc`, `api_request_type`, `api_request_content_type`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (17, 1, '查询订单详情','ad1ecc2a3dbd189f3fa478f30755a200', 'http://127.0.0.1:9127/example/order/getOrderByNo', '查询订单信息 -测试接口', 'GET', 'application/x-www-form-urlencoded', 0, '2024-03-11 22:24:25', 1, '2024-07-02 23:29:33', 1);


INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 'userName', '用户名', 'body', NULL, '{"type":"String"}', 1, 'api', 1, 0, '2024-07-02 15:34:12', -1, '2024-07-23 23:02:43', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 'password', '密码', 'body', NULL, '{"type":"String"}', 1, 'api', 1, 0, '2024-07-02 15:34:12', -1, '2024-07-23 23:02:43', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (2, 'userName', '用户名', NULL, NULL, '{"type":"String"}', NULL, 'api', 1, 0, '2024-07-02 15:34:12', -1, '2024-07-23 23:03:10', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (2, 'loginFlag', '是否登录成功', NULL, NULL, '{"type":"Boolean"}', NULL, 'api', 1, 0, '2024-07-02 15:34:12', -1, '2024-07-23 23:03:10', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (2, 'userId', '用户ID', NULL, NULL, '{"type":"Integer"}', NULL, 'api', 1, 0, '2024-07-02 15:34:12', -1, '2024-07-23 23:03:10', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 'userId', '用户ID', 'query', NULL, '{"type":"Integer"}', 1, 'api', 2, 0, '2024-07-02 15:37:41', -1, '2024-07-23 23:07:22', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (2, 'id', '用户ID', NULL, NULL, '{"type":"Integer"}', NULL, 'api', 2, 0, '2024-07-02 15:37:41', -1, '2024-07-23 23:06:14', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (2, 'name', '用户姓名', NULL, NULL, '{"type":"String"}', NULL, 'api', 2, 0, '2024-07-02 15:37:41', -1, '2024-07-23 23:06:14', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (2, 'age', '用户年龄', NULL, NULL, '{"type":"Integer"}', NULL, 'api', 2, 0, '2024-07-02 15:37:41', -1, '2024-07-23 23:06:14', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (2, 'birthday', '用户生日', NULL, NULL, '{"type":"Date"}', NULL, 'api', 2, 0, '2024-07-02 15:37:41', -1, '2024-07-23 23:06:14', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 'goodsName', '商品名称', 'body', NULL, '{"type":"String"}', 0, 'api', 8, 0, '2024-07-02 15:43:57', -1, '2024-07-23 23:09:08', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 'goodsInventory', '商品库存', 'body', NULL, '{"type":"Integer"}', 0, 'api', 8, 0, '2024-07-02 15:43:57', -1, '2024-07-23 23:09:10', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (2, 'goodsId', '商品ID', NULL, NULL, '{"type":"Integer"}', NULL, 'api', 8, 0, '2024-07-02 15:43:57', -1, '2024-07-23 23:08:25', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (2, 'goodsName', '商品名称', NULL, NULL, '{"type":"String"}', NULL, 'api', 8, 0, '2024-07-02 15:43:57', -1, '2024-07-23 23:08:25', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (2, 'goodsInventory', '商品库存', NULL, NULL, '{"type":"Integer"}', NULL, 'api', 8, 0, '2024-07-02 15:43:57', -1, '2024-07-23 23:08:25', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 'goodsName', '商品名称', 'query', NULL, '{"type":"String"}', 1, 'api', 9, 0, '2024-07-02 15:47:55', -1, '2024-07-23 23:11:00', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 'goodsInventory', '商品库存', 'query', NULL, '{"type":"String"}', 0, 'api', 9, 0, '2024-07-02 15:47:55', -1, '2024-07-23 23:11:02', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (2, 'goodsId', '商品ID', NULL, NULL, '{"type":"Integer"}', NULL, 'api', 9, 0, '2024-07-02 15:47:55', -1, '2024-07-23 23:10:35', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (2, 'goodsName', '商品名称', NULL, NULL, '{"type":"String"}', NULL, 'api', 9, 0, '2024-07-02 15:47:55', -1, '2024-07-23 23:10:35', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (2, 'goodsPrice', '商品价格', NULL, NULL, '{"type":"Double"}', NULL, 'api', 9, 0, '2024-07-02 15:47:55', -1, '2024-07-23 23:10:35', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (2, 'goodsInventory', '商品库存', NULL, NULL, '{"type":"Integer"}', NULL, 'api', 9, 0, '2024-07-02 15:47:55', -1, '2024-07-23 23:10:36', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 'orderName', '订单名称', 'query', NULL, '{"type":"String"}', 0, 'api', 15, 0, '2024-07-02 15:50:33', -1, '2024-07-23 23:12:30', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 'userId', '用户ID', 'query', NULL, '{"type":"Integer"}', 0, 'api', 15, 0, '2024-07-02 15:50:33', -1, '2024-07-23 23:12:31', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (2, 'orderNo', '订单号', NULL, NULL, '{"type":"String"}', NULL, 'api', 15, 0, '2024-07-02 15:50:33', -1, '2024-07-23 23:12:14', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (2, 'orderName', '订单名称', NULL, NULL, '{"type":"String"}', NULL, 'api', 15, 0, '2024-07-02 15:50:33', -1, '2024-07-23 23:12:14', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (2, 'userId', '用户ID', NULL, NULL, '{"type":"Integer"}', NULL, 'api', 15, 0, '2024-07-02 15:50:33', -1, '2024-07-23 23:12:14', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 'userId', '用户ID', 'query', NULL, '{"type":"Integer"}', 0, 'api', 16, 0, '2024-07-02 16:35:20', -1, '2024-07-23 23:13:47', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 'orderName', '订单名称', 'query', NULL, '{"type":"String"}', 0, 'api', 16, 0, '2024-07-02 16:35:20', -1, '2024-07-23 23:13:49', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (2, 'userId', '用户ID', NULL, NULL, '{"type":"Integer"}', NULL, 'api', 16, 0, '2024-07-02 16:35:20', -1, '2024-07-23 23:13:16', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (2, 'orderList', '订单列表', NULL, NULL, '{"type":"List","itemType":"Object","objectKey":"OrderDTO","objectStructure":[{"propKey":"userId","propName":"用户ID","dataType":{"type":"Integer"}},{"propKey":"orderName","propName":"订单名称","dataType":{"type":"String"}},{"propKey":"orderNo","propName":"订单号","dataType":{"type":"String"}}]}', NULL, 'api', 16, 0, '2024-07-02 16:35:20', -1, '2024-07-23 23:13:16', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 'orderNo', '订单号', 'query', NULL, '{"type":"String"}', 1, 'api', 17, 0, '2024-07-02 16:39:09', -1, '2024-07-23 23:15:11', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (2, 'orderNo', '订单号', NULL, NULL, '{"type":"String"}', NULL, 'api', 17, 0, '2024-07-02 16:39:09', -1, '2024-07-23 23:14:44', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (2, 'orderName', '订单名称', NULL, NULL, '{"type":"String"}', NULL, 'api', 17, 0, '2024-07-02 16:39:09', -1, '2024-07-23 23:14:44', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_position`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (2, 'userId', '用户ID', NULL, NULL, '{"type":"Integer"}', NULL, 'api', 17, 0, '2024-07-02 16:39:09', -1, '2024-07-23 23:14:44', NULL);


INSERT INTO `t_object` (`id`, `object_key`, `object_name`, `object_desc`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 'OrderDTO', '订单传输对象', '用于示例接口的对象', 0, '2024-07-02 16:29:35', 1, '2024-07-02 16:29:57', 1);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (3, 'orderNo', '订单号', NULL, '{"type":"String"}', NULL, 'object', 1, 0, '2024-07-02 16:29:57', NULL, '2024-07-03 23:58:28', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (3, 'orderName', '订单名称', NULL, '{"type":"String"}', NULL, 'object', 1, 0, '2024-07-02 16:29:57', NULL, '2024-07-03 23:58:28', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (3, 'userId', '用户ID', NULL, '{"type":"Integer"}', NULL, 'object', 1, 0, '2024-07-02 16:29:57', NULL, '2024-07-03 23:58:28', NULL);


INSERT INTO `t_flow_definition` (`id`, `flow_key`, `flow_name`, `flow_type`, `flow_content`, `remark`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 'sync_example', '示例流程', 'sync', '[{"key":"start_KaiQsdEC","name":"示例流程","elementType":"START","outgoings":["method_h0h73z8o"]},{"key":"end_KqdO1w6v","name":"结束","elementType":"END","incomings":["method_wt93gori"]},{"key":"method_h0h73z8o","name":"用户登录","elementType":"METHOD","desc":"","incomings":["start_KaiQsdEC"],"outgoings":["condition_w98rq3r8"],"method":{"suiteCode":"example_suite","methodCode":"dea23c0cad473dfcae523401052f89a0","url":"http://127.0.0.1:9127/example/user/login","requestType":"POST","requestContentType":"application/json","headerFillRules":[],"inputFillRules":[{"source":"input_userName","sourceType":"VARIABLE","sourceDataType":null,"target":"userName","targetType":"INPUT_PARAM","targetDataType":{"type":"String"}},{"source":"input_password","sourceType":"VARIABLE","sourceDataType":null,"target":"password","targetType":"INPUT_PARAM","targetDataType":{"type":"String"}}],"outputFillRules":[{"source":"userName","sourceType":"OUTPUT_PARAM","sourceDataType":{"type":"String"},"target":"output_userName","targetType":"VARIABLE","targetDataType":{"type":"String"}},{"source":"loginFlag","sourceType":"OUTPUT_PARAM","sourceDataType":{"type":"Boolean"},"target":"env_isLogin","targetType":"VARIABLE","targetDataType":{"type":"Boolean"}},{"source":"userId","sourceType":"OUTPUT_PARAM","sourceDataType":{"type":"Integer"},"target":"env_userId","targetType":"VARIABLE","targetDataType":{"type":"Integer"}}]}},{"key":"condition_w98rq3r8","name":"判断节点","elementType":"CONDITION","desc":"","incomings":["method_h0h73z8o"],"outgoings":["end_KqdO1w6v"],"conditions":[{"conditionName":"登录成功","conditionType":"CUSTOM","outgoing":"method_98a23hlu","expression":"env_isLogin==true","conditionExpressions":[[{"envKey":"env_isLogin","dataType":{"type":"Boolean"},"operator":"equal","assignType":"CONSTANT","value":true}]]},{"conditionName":"默认else分支","conditionType":"DEFAULT","outgoing":"end_KqdO1w6v","expression":"","conditionExpressions":[]}]},{"key":"method_98a23hlu","name":"查询用户信息","elementType":"METHOD","desc":"","incomings":["condition_w98rq3r8"],"outgoings":["condition_pq6w963k"],"method":{"suiteCode":"example_suite","methodCode":"7da045369a437a29e66c3154229e3190","url":"http://127.0.0.1:9127/example/user/getUserById","requestType":"GET","requestContentType":"application/x-www-form-urlencoded","headerFillRules":[],"inputFillRules":[{"source":"env_userId","sourceType":"VARIABLE","sourceDataType":null,"target":"userId","targetType":"INPUT_PARAM","targetDataType":{"type":"Integer"}}],"outputFillRules":[{"source":"age","sourceType":"OUTPUT_PARAM","sourceDataType":{"type":"Integer"},"target":"output_age","targetType":"VARIABLE","targetDataType":{"type":"Integer"}}]}},{"key":"condition_pq6w963k","name":"判断节点","elementType":"CONDITION","desc":"","incomings":["method_98a23hlu"],"outgoings":["end_KqdO1w6v"],"conditions":[{"conditionName":"存款小于10万","conditionType":"CUSTOM","outgoing":"method_2w5t1jbt","expression":"input_deposit<=100000","conditionExpressions":[[{"envKey":"input_deposit","dataType":{"type":"Double","itemType":""},"operator":"lessThanOrEqual","assignType":"CONSTANT","value":100000}]]},{"conditionName":"存款大于10万","conditionType":"CUSTOM","outgoing":"method_wt93gori","expression":"input_deposit>100000","conditionExpressions":[[{"envKey":"input_deposit","dataType":{"type":"Double","itemType":""},"operator":"greaterThan","assignType":"CONSTANT","value":100000}]]},{"conditionName":"默认else分支","conditionType":"DEFAULT","outgoing":"end_KqdO1w6v","expression":"","conditionExpressions":[]}]},{"key":"method_2w5t1jbt","name":"送10元话费","elementType":"METHOD","desc":"","incomings":["condition_pq6w963k"],"outgoings":["end_KqdO1w6v"],"method":{"suiteCode":"example_suite","methodCode":"a141ec5b270a87fe4a42a2ea1300cf0d","url":"http://127.0.0.1:9127/example/order/placeOrder","requestType":"POST","requestContentType":"application/x-www-form-urlencoded","headerFillRules":[],"inputFillRules":[{"source":"env_userId","sourceType":"VARIABLE","sourceDataType":null,"target":"userId","targetType":"INPUT_PARAM","targetDataType":{"type":"Integer"}},{"source":"送10元话费","sourceType":"CONSTANT","sourceDataType":null,"target":"orderName","targetType":"INPUT_PARAM","targetDataType":{"type":"String"}}],"outputFillRules":[{"source":"orderName","sourceType":"OUTPUT_PARAM","sourceDataType":{"type":"String"},"target":"output_orderName","targetType":"VARIABLE","targetDataType":{"type":"String"}}]}},{"key":"method_wt93gori","name":"送一双耐克的鞋","elementType":"METHOD","desc":"","incomings":["condition_pq6w963k"],"outgoings":["end_KqdO1w6v"],"method":{"suiteCode":"example_suite","methodCode":"a141ec5b270a87fe4a42a2ea1300cf0d","url":"http://127.0.0.1:9127/example/order/placeOrder","requestType":"POST","requestContentType":"application/x-www-form-urlencoded","headerFillRules":[],"inputFillRules":[{"source":"env_userId","sourceType":"VARIABLE","sourceDataType":null,"target":"userId","targetType":"INPUT_PARAM","targetDataType":{"type":"Integer"}},{"source":"送一双耐克的鞋","sourceType":"CONSTANT","sourceDataType":null,"target":"orderName","targetType":"INPUT_PARAM","targetDataType":{"type":"String"}}],"outputFillRules":[{"source":"orderName","sourceType":"OUTPUT_PARAM","sourceDataType":{"type":"String"},"target":"output_orderName","targetType":"VARIABLE","targetDataType":{"type":"String"}}]}}]', '', 0, '2024-07-02 10:22:33', 1, '2024-07-04 00:01:00', 1);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 'userName', '用户名称', NULL, '{"type":"String"}', 0, 'flow', 1, 0, '2024-07-03 15:28:34', NULL, '2024-07-04 00:01:08', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 'password', '密码', NULL, '{"type":"String"}', 0, 'flow', 1, 0, '2024-07-03 15:28:34', NULL, '2024-07-04 00:01:08', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 'deposit', '存款', NULL, '{"type":"Double"}', 0, 'flow', 1, 0, '2024-07-03 15:28:34', NULL, '2024-07-04 00:01:08', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (2, 'userName', '用户名称', NULL, '{"type":"String"}', NULL, 'flow', 1, 0, '2024-07-03 15:28:34', NULL, '2024-07-04 00:01:08', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (2, 'age', '用户年龄', NULL, '{"type":"Integer"}', NULL, 'flow', 1, 0, '2024-07-03 15:28:34', NULL, '2024-07-04 00:01:08', NULL);
INSERT INTO `t_parameter` (`param_type`, `param_key`, `param_name`, `param_desc`, `data_type`, `required`, `source_type`, `source_id`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (2, 'orderName', '订单名称', NULL, '{"type":"String"}', NULL, 'flow', 1, 0, '2024-07-03 15:28:34', NULL, '2024-07-04 00:01:08', NULL);
INSERT INTO `t_variable_info` (`flow_definition_id`, `env_key`, `env_name`, `env_type`, `data_type`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 'env_isLogin', '是否登录成功变量', 3, '{"type":"Boolean"}', NULL, NULL, '2024-07-04 00:00:53', NULL);
INSERT INTO `t_variable_info` (`flow_definition_id`, `env_key`, `env_name`, `env_type`, `data_type`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 'env_userId', '用户ID变量', 3, '{"type":"Integer"}', NULL, NULL, '2024-07-04 00:00:53', NULL);
INSERT INTO `t_variable_info` (`flow_definition_id`, `env_key`, `env_name`, `env_type`, `data_type`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 'input_userName', '用户名称', 1, '{"type":"String"}', NULL, NULL, '2024-07-04 00:00:54', NULL);
INSERT INTO `t_variable_info` (`flow_definition_id`, `env_key`, `env_name`, `env_type`, `data_type`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 'input_password', '密码', 1, '{"type":"String"}', NULL, NULL, '2024-07-04 00:00:54', NULL);
INSERT INTO `t_variable_info` (`flow_definition_id`, `env_key`, `env_name`, `env_type`, `data_type`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 'input_deposit', '存款', 1, '{"type":"Double","itemType":""}', NULL, NULL, '2024-07-04 00:00:54', NULL);
INSERT INTO `t_variable_info` (`flow_definition_id`, `env_key`, `env_name`, `env_type`, `data_type`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 'output_userName', '用户名称', 2, '{"type":"String"}', NULL, NULL, '2024-07-04 00:00:54', NULL);
INSERT INTO `t_variable_info` (`flow_definition_id`, `env_key`, `env_name`, `env_type`, `data_type`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 'output_age', '用户年龄', 2, '{"type":"Integer"}', NULL, NULL, '2024-07-04 00:00:54', NULL);
INSERT INTO `t_variable_info` (`flow_definition_id`, `env_key`, `env_name`, `env_type`, `data_type`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 'output_orderName', '订单名称', 2, '{"type":"String"}', NULL, NULL, '2024-07-04 00:00:54', NULL);

INSERT INTO `t_flow_info` (`id`, `flow_key`, `flow_name`, `flow_type`, `remark`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 'sync_example', '示例流程', 'sync', '', 0, '2024-07-04 00:09:26', 1, '2024-07-04 00:10:30', NULL);
INSERT INTO `t_flow_version` (`id`, `flow_id`, `flow_version`, `flow_version_status`, `flow_version_remark`, `flow_content`, `inputs`, `outputs`, `variables`, `deleted`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES (1, 1, 'v1', 1, '', '[{"key":"start_KaiQsdEC","name":"示例流程","elementType":"START","outgoings":["method_h0h73z8o"]},{"key":"end_KqdO1w6v","name":"结束","elementType":"END","incomings":["method_wt93gori"]},{"key":"method_h0h73z8o","name":"用户登录","elementType":"METHOD","desc":"","incomings":["start_KaiQsdEC"],"outgoings":["condition_w98rq3r8"],"method":{"suiteCode":"example_suite","methodCode":"dea23c0cad473dfcae523401052f89a0","url":"http://127.0.0.1:9127/example/user/login","requestType":"POST","requestContentType":"application/json","headerFillRules":[],"inputFillRules":[{"source":"input_userName","sourceType":"VARIABLE","sourceDataType":null,"target":"userName","targetType":"INPUT_PARAM","targetDataType":{"type":"String"}},{"source":"input_password","sourceType":"VARIABLE","sourceDataType":null,"target":"password","targetType":"INPUT_PARAM","targetDataType":{"type":"String"}}],"outputFillRules":[{"source":"userName","sourceType":"OUTPUT_PARAM","sourceDataType":{"type":"String"},"target":"output_userName","targetType":"VARIABLE","targetDataType":{"type":"String"}},{"source":"loginFlag","sourceType":"OUTPUT_PARAM","sourceDataType":{"type":"Boolean"},"target":"env_isLogin","targetType":"VARIABLE","targetDataType":{"type":"Boolean"}},{"source":"userId","sourceType":"OUTPUT_PARAM","sourceDataType":{"type":"Integer"},"target":"env_userId","targetType":"VARIABLE","targetDataType":{"type":"Integer"}}]}},{"key":"condition_w98rq3r8","name":"判断节点","elementType":"CONDITION","desc":"","incomings":["method_h0h73z8o"],"outgoings":["end_KqdO1w6v"],"conditions":[{"conditionName":"登录成功","conditionType":"CUSTOM","outgoing":"method_98a23hlu","expression":"env_isLogin==true","conditionExpressions":[[{"envKey":"env_isLogin","dataType":{"type":"Boolean"},"operator":"equal","assignType":"CONSTANT","value":true}]]},{"conditionName":"默认else分支","conditionType":"DEFAULT","outgoing":"end_KqdO1w6v","expression":"","conditionExpressions":[]}]},{"key":"method_98a23hlu","name":"查询用户信息","elementType":"METHOD","desc":"","incomings":["condition_w98rq3r8"],"outgoings":["condition_pq6w963k"],"method":{"suiteCode":"example_suite","methodCode":"7da045369a437a29e66c3154229e3190","url":"http://127.0.0.1:9127/example/user/getUserById","requestType":"GET","requestContentType":"application/x-www-form-urlencoded","headerFillRules":[],"inputFillRules":[{"source":"env_userId","sourceType":"VARIABLE","sourceDataType":null,"target":"userId","targetType":"INPUT_PARAM","targetDataType":{"type":"Integer"}}],"outputFillRules":[{"source":"age","sourceType":"OUTPUT_PARAM","sourceDataType":{"type":"Integer"},"target":"output_age","targetType":"VARIABLE","targetDataType":{"type":"Integer"}}]}},{"key":"condition_pq6w963k","name":"判断节点","elementType":"CONDITION","desc":"","incomings":["method_98a23hlu"],"outgoings":["end_KqdO1w6v"],"conditions":[{"conditionName":"存款小于10万","conditionType":"CUSTOM","outgoing":"method_2w5t1jbt","expression":"input_deposit<=100000","conditionExpressions":[[{"envKey":"input_deposit","dataType":{"type":"Double","itemType":""},"operator":"lessThanOrEqual","assignType":"CONSTANT","value":100000}]]},{"conditionName":"存款大于10万","conditionType":"CUSTOM","outgoing":"method_wt93gori","expression":"input_deposit>100000","conditionExpressions":[[{"envKey":"input_deposit","dataType":{"type":"Double","itemType":""},"operator":"greaterThan","assignType":"CONSTANT","value":100000}]]},{"conditionName":"默认else分支","conditionType":"DEFAULT","outgoing":"end_KqdO1w6v","expression":"","conditionExpressions":[]}]},{"key":"method_2w5t1jbt","name":"送10元话费","elementType":"METHOD","desc":"","incomings":["condition_pq6w963k"],"outgoings":["end_KqdO1w6v"],"method":{"suiteCode":"example_suite","methodCode":"a141ec5b270a87fe4a42a2ea1300cf0d","url":"http://127.0.0.1:9127/example/order/placeOrder","requestType":"POST","requestContentType":"application/x-www-form-urlencoded","headerFillRules":[],"inputFillRules":[{"source":"env_userId","sourceType":"VARIABLE","sourceDataType":null,"target":"userId","targetType":"INPUT_PARAM","targetDataType":{"type":"Integer"}},{"source":"送10元话费","sourceType":"CONSTANT","sourceDataType":null,"target":"orderName","targetType":"INPUT_PARAM","targetDataType":{"type":"String"}}],"outputFillRules":[{"source":"orderName","sourceType":"OUTPUT_PARAM","sourceDataType":{"type":"String"},"target":"output_orderName","targetType":"VARIABLE","targetDataType":{"type":"String"}}]}},{"key":"method_wt93gori","name":"送一双耐克的鞋","elementType":"METHOD","desc":"","incomings":["condition_pq6w963k"],"outgoings":["end_KqdO1w6v"],"method":{"suiteCode":"example_suite","methodCode":"a141ec5b270a87fe4a42a2ea1300cf0d","url":"http://127.0.0.1:9127/example/order/placeOrder","requestType":"POST","requestContentType":"application/x-www-form-urlencoded","headerFillRules":[],"inputFillRules":[{"source":"env_userId","sourceType":"VARIABLE","sourceDataType":null,"target":"userId","targetType":"INPUT_PARAM","targetDataType":{"type":"Integer"}},{"source":"送一双耐克的鞋","sourceType":"CONSTANT","sourceDataType":null,"target":"orderName","targetType":"INPUT_PARAM","targetDataType":{"type":"String"}}],"outputFillRules":[{"source":"orderName","sourceType":"OUTPUT_PARAM","sourceDataType":{"type":"String"},"target":"output_orderName","targetType":"VARIABLE","targetDataType":{"type":"String"}}]}}]', '[{"key":"userName","name":"用户名称","dataType":{"type":"String"},"required":false},{"key":"password","name":"密码","dataType":{"type":"String"},"required":false},{"key":"deposit","name":"存款","dataType":{"type":"Double","itemType":""},"required":false}]', '[{"key":"userName","name":"用户名称","dataType":{"type":"String"}},{"key":"age","name":"用户年龄","dataType":{"type":"Integer"}},{"key":"orderName","name":"订单名称","dataType":{"type":"String"}}]', '[{"key":"env_isLogin","name":"是否登录成功变量","dataType":{"type":"Boolean"}},{"key":"env_userId","name":"用户ID变量","dataType":{"type":"Integer"}},{"key":"input_userName","name":"用户名称","dataType":{"type":"String"}},{"key":"input_password","name":"密码","dataType":{"type":"String"}},{"key":"input_deposit","name":"存款","dataType":{"type":"Double","itemType":""}},{"key":"output_userName","name":"用户名称","dataType":{"type":"String"}},{"key":"output_age","name":"用户年龄","dataType":{"type":"Integer"}},{"key":"output_orderName","name":"订单名称","dataType":{"type":"String"}}]', 0, '2024-07-04 00:09:26', 1, '2024-07-04 00:10:44', NULL);
