package net.somta.juggle.console.application.service;

import com.github.pagehelper.PageInfo;
import net.somta.juggle.console.domain.object.ObjectAO;
import net.somta.juggle.console.interfaces.dto.ObjectDTO;
import net.somta.juggle.console.interfaces.dto.ObjectInfoDTO;
import net.somta.juggle.console.interfaces.param.ObjectAddParam;
import net.somta.juggle.console.interfaces.param.ObjectQueryParam;
import net.somta.juggle.console.interfaces.param.ObjectUpdateParam;

import java.util.List;

/**
 * @author husong
 */
public interface IObjectService {

    /**
     * Add Object
     * @param objectAddParam Add object parameters
     * @return Boolean
     */
    Boolean addObject(ObjectAddParam objectAddParam);

    /**
     * Delete object based on ID
     * @param objId object id
     * @return Boolean
     */
    Boolean deleteObject(Long objId);

    /**
     * Update Object
     * @param objectUpdateParam Update object parameters
     * @return Boolean
     */
    Boolean updateObject(ObjectUpdateParam objectUpdateParam);

    /**
     * Query object information based on object key
     * @param objectKey object key
     * @return Object AO
     */
    ObjectAO getObjectInfoByKey(String objectKey);

    /**
     * Query object information based on object ID
     * @param objId object id
     * @return Object info
     */
    ObjectInfoDTO getObjectInfo(Long objId);

    /**
     * Get object info list
     * @return Object list
     */
    List<ObjectDTO> getObjectInfoList();

    /**
     * Query Object Paging List
     * @param objectQueryParam Object pagination query parameters
     * @return Object Paging Information
     */
    PageInfo getObjectPageList(ObjectQueryParam objectQueryParam);

}
