# Soluling's Angular Samples

This directory contains Soluling's Angular samples. Learn about [Angular localization](https://www.soluling.com/Help/Angular/Index.htm).

| Sample   | Description                                                  | Notes                                                        |
| -------- | ------------------------------------------------------------ | ------------------------------------------------------------ |
| Simple   | A localized Angular application.                             | Try this first                                               |
| Runtime  | A localized Angular application using runtime language loading. |                                                              |
| Patterns | Shows how to create grammatically correct multi patterns such as [plural, gender and select](https://www.soluling.com/Help/Angular/Index.htm#Patterns) enabled messages. Contains following projects:<br/>Plural - Shows how to use plurals.<br/>Multi - Shows how to use two plural enabled patterns in a single string.<br/>Nested - Even this shows how to use nested patterns you should **not** use nested patterns because Soluling cannot use multi-pattern editor with them.<br/>Gender - Shows how to use genders.<br/>Select - Shows how to use select values. This samples also shows how to localize strings in TypeScript code. |                                                              |
| Ids      | Shows different ways in Soluling to get strings [context](https://www.soluling.com/Help/Angular/Index.htm#Context). |                                                              |
| Fallback | An application that uses [fallback](https://www.soluling.com/Help/Fallback.htm). |                                                              |
| Sport    | Localized application that consumes a multilingual Sport API. | Learn more about the application from [here](https://www.soluling.com/Help/WebSample/Index.htm). |

All samples have been updated to Angular 13.
