# Soluling's ASP.NET Core Samples

This directory contains Soluling's ASP.NET Core samples. Learn about [ASP.NET Core localization](https://www.soluling.com/Help/ASP.NETCore/Index.htm).

## MVC

| Sample      | Description                                                  |
| ----------- | ------------------------------------------------------------ |
| Driving     | A simple driving time calculator sample that shows how to localize strings and images and how to use [plural](https://www.soluling.com/Help/Patterns.htm) enabled message strings. |
| DrivingView | As above but each view file has a set of localized view files. |
| HelloWorld  | A localized Hello World application.                         |
| Minimal     | A minimal localized application.                             |

## Razor Pages

| Sample  | Description                                                  |
| ------- | ------------------------------------------------------------ |
| Driving | A simple driving time calculator sample that shows how to localize strings and images and how to use [plural](https://www.soluling.com/Help/Patterns.htm) enabled message strings. |
| Sport   | A simple localized sport application that use the multilingual sport API (see below). Learn more about the application [here](https://www.soluling.com/Help/WebSample/Index.htm). |

## Web API

| Sample    | Description                                                  |
| --------- | ------------------------------------------------------------ |
| SimpleAPI | A simple multilingual API that uses hard coded resources. Implements only the GET method. |
| SportAPI  | A multilingual API that stores sport in a database. Implements a CRUD (Wikipedia) API. Learn more about the application [here](https://www.soluling.com/Help/WebSample/Index.htm). |

