﻿// Generated from CLDR data. Do not edit.
namespace Soluling
{
  /// <summary>
  /// Contains number abbreviation rules for each language.
  /// </summary>
  public class AbbreviatedNumberData
  {
    // Afrikaans
    private static readonly AbbreviationRule[] AF_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 duisend" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 duisend" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 duisend" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 duisend" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 duisend" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 duisend" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 miljoen" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 miljoen" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 miljoen" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 miljoen" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 miljoen" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 miljoen" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 miljard" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 miljard" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 miljard" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 miljard" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 miljard" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 miljard" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 biljoen" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 biljoen" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 biljoen" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 biljoen" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 biljoen" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 biljoen" }
    };

    private static readonly AbbreviationRule[] AF_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 m" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 m" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 m" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 m" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 m" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 m" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mjd" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mjd" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mjd" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mjd" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mjd" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mjd" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bn" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bn" }
    };

    private static readonly AbbreviationRule[] AF_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤ 000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0 m" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0 m" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00 m" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00 m" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000 m" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000 m" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0 mjd" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0 mjd" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00 mjd" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00 mjd" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000 mjd" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000 mjd" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0 bn" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0 bn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00 bn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00 bn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000 bn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000 bn" }
    };

    // Aghem
    private static readonly AbbreviationRule[] AGQ_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T¤" }
    };

    // Akan
    private static readonly AbbreviationRule[] AK_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Amharic
    private static readonly AbbreviationRule[] AM_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 ሺ" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 ሺ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 ሺ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 ሺ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 ሺ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 ሺ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 ሚሊዮን" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 ሚሊዮን" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 ሚሊዮን" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 ሚሊዮን" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 ሚሊዮን" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 ሚሊዮን" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 ቢሊዮን" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 ቢሊዮን" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 ቢሊዮን" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 ቢሊዮን" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 ቢሊዮን" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 ቢሊዮን" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 ትሪሊዮን" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 ትሪሊዮን" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 ትሪሊዮን" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 ትሪሊዮን" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 ትሪሊዮን" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 ትሪሊዮን" }
    };

    private static readonly AbbreviationRule[] AM_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 ሺ" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 ሺ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 ሺ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 ሺ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 ሺ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 ሺ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 ሜትር" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 ሜትር" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 ሜትር" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 ሜትር" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000ሜ" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000ሜ" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 ቢ" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 ቢ" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 ቢ" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 ቢ" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 ቢ" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 ቢ" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 ት" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 ት" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 ት" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 ት" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 ት" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 ት" }
    };

    private static readonly AbbreviationRule[] AM_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0 ሺ" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0 ሺ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00 ሺ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00 ሺ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000 ሺ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000 ሺ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0 ሜትር" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0 ሜትር" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00 ሜትር" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00 ሜትር" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000 ሜትር" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000 ሜትር" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0 ቢ" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0 ቢ" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00 ቢ" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00 ቢ" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000 ቢ" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000 ቢ" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0 ት" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0 ት" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00 ት" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00 ት" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000 ት" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000 ት" }
    };

    // Arabic
    private static readonly AbbreviationRule[] AR_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Zero, Value = "0 ألف" },
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 ألف" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "0 ألف" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 آلاف" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0 ألف" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 ألف" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Zero, Value = "00 ألف" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 ألف" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "00 ألف" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 ألف" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00 ألف" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 ألف" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Zero, Value = "000 ألف" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 ألف" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "000 ألف" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 ألف" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000 ألف" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 ألف" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Zero, Value = "0 مليون" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 مليون" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "0 مليون" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 ملايين" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0 مليون" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 مليون" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Zero, Value = "00 مليون" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 مليون" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "00 مليون" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 ملايين" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00 مليون" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 مليون" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Zero, Value = "000 مليون" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 مليون" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "000 مليون" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 مليون" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000 مليون" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 مليون" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Zero, Value = "0 مليار" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 مليار" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "0 مليار" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 مليار" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0 مليار" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 مليار" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Zero, Value = "00 مليار" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 مليار" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "00 مليار" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 مليار" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00 مليار" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 مليار" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Zero, Value = "000 مليار" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 مليار" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "000 مليار" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 مليار" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000 مليار" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 مليار" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Zero, Value = "0 تريليون" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 تريليون" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "0 تريليون" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 تريليونات" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0 تريليون" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 تريليون" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Zero, Value = "00 تريليون" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 تريليون" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "00 تريليون" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 تريليون" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00 تريليون" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 تريليون" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Zero, Value = "000 تريليون" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 تريليون" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "000 تريليون" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 تريليون" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000 تريليون" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 تريليون" }
    };

    private static readonly AbbreviationRule[] AR_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Zero, Value = "0 ألف" },
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 ألف" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "0 ألف" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 آلاف" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0 ألف" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 ألف" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Zero, Value = "00 ألف" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 ألف" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "00 ألف" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 ألف" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00 ألف" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 ألف" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Zero, Value = "000 ألف" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 ألف" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "000 ألف" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 ألف" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000 ألف" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 ألف" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Zero, Value = "0 مليو" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 مليو" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "0 مليو" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 مليو" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0 مليو" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 مليو" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Zero, Value = "00 مليو" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 مليو" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "00 مليو" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 مليو" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00 مليو" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 مليو" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Zero, Value = "000 مليو" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 مليو" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "000 مليو" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 مليو" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000 مليو" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 مليو" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Zero, Value = "0 مليا" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 مليا" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "0 مليا" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 مليا" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0 مليا" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 مليا" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Zero, Value = "00 مليا" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 مليا" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "00 مليا" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 مليا" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00 مليا" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 مليا" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Zero, Value = "000 مليا" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 مليا" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "000 مليا" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 مليا" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000 مليا" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 مليا" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Zero, Value = "0 ترليو" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 ترليو" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "0 ترليو" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 ترليو" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0 ترليو" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 ترليو" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Zero, Value = "00 ترليو" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 ترليو" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "00 ترليو" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 ترليو" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00 ترليو" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 ترليو" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Zero, Value = "000 ترليو" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 ترليو" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "000 ترليو" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 ترليو" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000 ترليو" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 ترليو" }
    };

    // Assamese
    private static readonly AbbreviationRule[] AS_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤ 0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤ 00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤ 000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤ 0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤ 00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤ 000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤ 0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤ 00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤ 000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤ 0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤ 00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤ 000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000T" }
    };

    // Asu
    private static readonly AbbreviationRule[] ASA_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0G ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00G ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000G ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T ¤" }
    };

    // Asturian
    private static readonly AbbreviationRule[] AST_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 millar" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 millares" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 millares" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 millares" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 millares" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 millares" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 millón" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 millones" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 millones" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 millones" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 millones" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 millones" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T" }
    };

    private static readonly AbbreviationRule[] AST_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T" }
    };

    // Azerbaijani, Latin
    private static readonly AbbreviationRule[] AZ_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T" }
    };

    private static readonly AbbreviationRule[] AZ_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T" }
    };

    private static readonly AbbreviationRule[] AZ_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤ 0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤ 00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤ 000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤ 0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤ 00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤ 000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤ 0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤ 00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤ 000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤ 0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤ 00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤ 000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000T" }
    };

    // Azerbaijani, Cyrillic
    private static readonly AbbreviationRule[] AZ_CYRL_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤ 0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤ 00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤ 000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤ 0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤ 00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤ 000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤ 0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤ 00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤ 000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤ 0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤ 00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤ 000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000T" }
    };

    // Basaa
    private static readonly AbbreviationRule[] BAS_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T ¤" }
    };

    // Belarusian
    private static readonly AbbreviationRule[] BE_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 тысяча" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 тысячы" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0 тысяч" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 тысячы" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 тысяча" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 тысячы" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00 тысяч" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 тысячы" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 тысяча" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 тысячы" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000 тысяч" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 тысячы" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 мільён" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 мільёны" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0 мільёнаў" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 мільёна" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 мільён" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 мільёны" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00 мільёнаў" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 мільёна" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 мільён" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 мільёны" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000 мільёнаў" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 мільёна" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 мільярд" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 мільярды" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0 мільярдаў" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 мільярда" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 мільярд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 мільярды" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00 мільярдаў" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 мільярда" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 мільярд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 мільярды" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000 мільярдаў" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 мільярда" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 трыльён" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 трыльёны" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0 трыльёнаў" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 трыльёна" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 трыльён" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 трыльёны" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00 трыльёнаў" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 трыльёна" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 трыльён" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 трыльёны" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000 трыльёнаў" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 трыльёна" }
    };

    private static readonly AbbreviationRule[] BE_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 тыс." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 тыс." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0 тыс." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 тыс." },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 тыс." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 тыс." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00 тыс." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 тыс." },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 тыс." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 тыс." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000 тыс." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 тыс." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 млн" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 млн" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0 млн" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 млн" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 млн" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 млн" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00 млн" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 млн" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 млн" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 млн" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000 млн" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 млн" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 млрд" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 млрд" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0 млрд" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 млрд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 млрд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 млрд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00 млрд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 млрд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 млрд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 млрд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000 млрд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 млрд" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 трлн" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 трлн" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0 трлн" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 трлн" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 трлн" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 трлн" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00 трлн" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 трлн" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 трлн" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 трлн" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000 трлн" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 трлн" }
    };

    private static readonly AbbreviationRule[] BE_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 тыс. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 тыс. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0 тыс. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 тыс. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 тыс. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 тыс. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00 тыс. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 тыс. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 тыс. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 тыс. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000 тыс. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 тыс. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 млн ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 млн ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0 млн ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 млн ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 млн ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 млн ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00 млн ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 млн ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 млн ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 млн ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000 млн ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 млн ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 млрд ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 млрд ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0 млрд ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 млрд ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 млрд ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 млрд ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00 млрд ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 млрд ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 млрд ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 млрд ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000 млрд ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 млрд ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 трлн ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 трлн ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0 трлн ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 трлн ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 трлн ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 трлн ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00 трлн ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 трлн ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 трлн ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 трлн ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000 трлн ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 трлн ¤" }
    };

    // Bemba
    private static readonly AbbreviationRule[] BEM_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Bena
    private static readonly AbbreviationRule[] BEZ_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0G¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00G¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000G¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T¤" }
    };

    // Bulgarian
    private static readonly AbbreviationRule[] BG_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 хил." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 хиляди" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 хиляди" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 хиляди" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 хиляди" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 хиляди" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 милион" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 милиона" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 милиона" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 милиона" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 милиона" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 милиона" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 милиард" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 милиарда" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 милиарда" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 милиарда" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 милиарда" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 милиарда" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 трилион" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 трилиона" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 трилиона" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 трилиона" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 трилиона" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 трилиона" }
    };

    private static readonly AbbreviationRule[] BG_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 хил." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 хил." },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 хил." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 хил." },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 хил." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 хил." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 млн." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 млн." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 млн." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 млн." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 млн" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 млн" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 млрд." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 млрд." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 млрд." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 млрд." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 млрд." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 млрд." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 трлн." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 трлн." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 трлн." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 трлн." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 трлн." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 трлн." }
    };

    private static readonly AbbreviationRule[] BG_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 хил. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 хил. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 хил. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 хил. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 хил. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 хил. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 млн. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 млн. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 млн. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 млн. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 млн. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 млн. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 млрд. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 млрд. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 млрд. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 млрд. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 млрд. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 млрд. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 трлн. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 трлн. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 трлн. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 трлн. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 трлн. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 трлн. ¤" }
    };

    // Bamanankan
    private static readonly AbbreviationRule[] BM_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Bangla
    private static readonly AbbreviationRule[] BN_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 হাজার" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 হাজার" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 হাজার" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 হাজার" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "0 লাখ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "0 লাখ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 মিলিয়ন" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 মিলিয়ন" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 মিলিয়ন" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 মিলিয়ন" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 মিলিয়ন" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 মিলিয়ন" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 বিলিয়ন" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 বিলিয়ন" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 বিলিয়ন" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 বিলিয়ন" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 বিলিয়ন" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 বিলিয়ন" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 ট্রিলিয়ন" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 ট্রিলিয়ন" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 ট্রিলিয়ন" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 ট্রিলিয়ন" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 ট্রিলিয়ন" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 ট্রিলিয়ন" }
    };

    private static readonly AbbreviationRule[] BN_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 হাজার" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 হাজার" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 হাজার" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 হাজার" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "0 লাখ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "0 লাখ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000B" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T" }
    };

    // Tibetan
    private static readonly AbbreviationRule[] BO_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000T" }
    };

    // Breton
    private static readonly AbbreviationRule[] BR_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "0K ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0K ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0K ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "00K ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00K ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00K ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "000K ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000K ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000K ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "0M ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0M ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0M ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "00M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "000M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0G ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "0G ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0G ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0G ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00G ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "00G ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00G ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00G ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000G ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "000G ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000G ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000G ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "0T ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0T ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0T ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "00T ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00T ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00T ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "000T ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000T ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000T ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T ¤" }
    };

    // Bodo
    private static readonly AbbreviationRule[] BRX_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤ 0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤ 00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤ 000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤ 0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤ 00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤ 000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤ 0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤ 00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤ 000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤ 0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤ 00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤ 000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000T" }
    };

    // Bosnian, Latin
    private static readonly AbbreviationRule[] BS_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 hiljada" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 hiljade" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 hiljada" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 hiljada" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 hiljade" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 hiljada" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 hiljada" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 hiljade" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 hiljada" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 milion" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 miliona" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 miliona" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 milion" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 miliona" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 miliona" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 milion" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 miliona" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 miliona" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 milijarda" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 milijarde" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 milijardi" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 milijarda" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 milijarde" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 milijardi" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 milijarda" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 milijarde" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 milijardi" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bilion" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 biliona" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 biliona" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bilion" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 biliona" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 biliona" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bilion" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 biliona" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 biliona" }
    };

    private static readonly AbbreviationRule[] BS_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 hilj." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 hilj." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 hilj." },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 hilj." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 hilj." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 hilj." },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 hilj." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 hilj." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 hilj." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mil." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 mil." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mil." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mil." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 mil." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mil." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mil." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 mil." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mil." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mlr." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 mlr." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mlr." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mlr." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 mlr." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mlr." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mlr." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 mlr." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mlr." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bil." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 bil." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bil." }
    };

    private static readonly AbbreviationRule[] BS_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 hilj. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 hilj. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 hilj. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 hilj. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 hilj. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 hilj. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 hilj. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 hilj. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 hilj. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mil. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 mil. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mil. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mil. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 mil. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mil. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mil. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 mil. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mil. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mlr. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 mlr. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mlr. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mlr. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 mlr. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mlr. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mlr. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 mlr. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mlr. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bil. ¤" }
    };

    // Bosnian, Cyrillic
    private static readonly AbbreviationRule[] BS_CYRL_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 хиљ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 хиљ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 хиљ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 хиљ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 хиљ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 хиљ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 мил" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 мил" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 мил" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 мил" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 мил" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 мил" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 мил" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 мил" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 мил" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 млрд" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 млрд" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 млрд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 млрд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 млрд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 млрд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 млрд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 млрд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 млрд" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 бил" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 бил" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 бил" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 бил" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 бил" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 бил" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 бил" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 бил" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 бил" }
    };

    private static readonly AbbreviationRule[] BS_CYRL_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 хиљ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 хиљ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 хиљ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 хиљ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 хиљ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 хиљ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 мил" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 мил" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 мил" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 мил" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 мил" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 мил" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 мил" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 мил" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 мил" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 млрд" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 млрд" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 млрд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 млрд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 млрд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 млрд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 млрд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 млрд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 млрд" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 бил" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 бил" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 бил" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 бил" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 бил" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 бил" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 бил" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 бил" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 бил" }
    };

    private static readonly AbbreviationRule[] BS_CYRL_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 хиљ ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 хиљ ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 хиљ ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 хиљ ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 хиљ ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 хиљ ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 мил ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 мил ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 мил ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 мил ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 мил ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 мил ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 мил ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 мил ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 мил ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 млрд ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 млрд ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 млрд ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 млрд ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 млрд ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 млрд ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 млрд ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 млрд ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 млрд ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 бил ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 бил ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 бил ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 бил ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 бил ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 бил ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 бил ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 бил ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 бил ¤" }
    };

    // Catalan
    private static readonly AbbreviationRule[] CA_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 miler" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 milers" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 milers" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 milers" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 milers" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 milers" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 milió" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 milions" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 milions" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 milions" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 milions" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 milions" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 miler de milions" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 milers de milions" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 milers de milions" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 milers de milions" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 milers de milions" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 milers de milions" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bilió" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bilions" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bilions" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bilions" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bilions" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bilions" }
    };

    private static readonly AbbreviationRule[] CA_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0m" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0m" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00m" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00m" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000m" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000m" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0000 M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0000 M" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00mM" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00mM" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000mM" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000mM" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0B" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0B" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 B" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 B" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 B" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 B" }
    };

    private static readonly AbbreviationRule[] CA_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0m ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0m ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00m ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00m ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000m ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000m ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 M ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0000 M ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0000 M ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00mM ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00mM ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000mM ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000mM ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0B ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0B ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 B ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 B ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 B ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 B ¤" }
    };

    // Chechen
    private static readonly AbbreviationRule[] CE_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 эзар" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 эзар" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 эзар" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 эзар" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 эзар" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 эзар" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 миллион" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 миллион" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 миллион" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 миллион" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 миллион" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 миллион" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 миллиард" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 миллиард" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 миллиард" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 миллиард" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 миллиард" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 миллиард" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 триллион" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 триллион" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 триллион" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 триллион" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 триллион" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 триллион" }
    };

    private static readonly AbbreviationRule[] CE_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 эзар" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 эзар" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 эзар" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 эзар" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 эзар" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 эзар" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 млн" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 млн" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 млн" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 млн" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 млн" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 млн" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 млрд" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 млрд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 млрд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 млрд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 млрд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 млрд" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 трлн" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 трлн" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 трлн" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 трлн" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 трлн" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 трлн" }
    };

    private static readonly AbbreviationRule[] CE_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 эзар ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 эзар ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 эзар ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 эзар ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 эзар ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 эзар ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 млн ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 млн ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 млн ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 млн ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 млн ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 млн ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 млрд ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 млрд ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 млрд ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 млрд ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 млрд ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 млрд ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 трлн ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 трлн ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 трлн ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 трлн ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 трлн ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 трлн ¤" }
    };

    // Chiga
    private static readonly AbbreviationRule[] CGG_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Cherokee
    private static readonly AbbreviationRule[] CHR_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 ᎢᏯᎦᏴᎵ" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 ᎢᏯᎦᏴᎵ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 ᎢᏯᎦᏴᎵ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 ᎢᏯᎦᏴᎵ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 ᎢᏯᎦᏴᎵ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 ᎢᏯᎦᏴᎵ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 ᎢᏳᏆᏗᏅᏛ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 ᎢᏳᏆᏗᏅᏛ" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 ᎢᏳᏆᏗᏅᏛ" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 ᎢᏳᏆᏗᏅᏛ" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 ᎢᏳᏆᏗᏅᏛ" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 ᎢᏳᏆᏗᏅᏛ" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 ᎢᏯᏔᎳᏗᏅᏛ" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 ᎢᏯᏔᎳᏗᏅᏛ" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 ᎢᏯᏔᎳᏗᏅᏛ" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 ᎢᏯᏔᎳᏗᏅᏛ" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 ᎢᏯᏔᎳᏗᏅᏛ" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 ᎢᏯᏔᎳᏗᏅᏛ" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 ᎢᏯᏦᎠᏗᏅᏛ" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 ᎢᏯᏦᎠᏗᏅᏛ" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 ᎢᏯᏦᎠᏗᏅᏛ" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 ᎢᏯᏦᎠᏗᏅᏛ" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 ᎢᏯᏦᎠᏗᏅᏛ" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 ᎢᏯᏦᎠᏗᏅᏛ" }
    };

    private static readonly AbbreviationRule[] CHR_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000B" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T" }
    };

    private static readonly AbbreviationRule[] CHR_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000B" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Czech
    private static readonly AbbreviationRule[] CS_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tisíc" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 tisíce" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0 tisíce" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tisíc" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tisíc" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 tisíc" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00 tisíce" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tisíc" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tisíc" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 tisíc" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000 tisíce" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tisíc" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 milion" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 miliony" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0 milionu" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 milionů" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 milionů" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 milionů" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00 milionu" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 milionů" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 milionů" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 milionů" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000 milionu" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 milionů" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 miliarda" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 miliardy" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0 miliardy" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 miliard" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 miliard" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 miliard" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00 miliardy" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 miliard" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 miliard" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 miliard" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000 miliardy" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 miliard" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bilion" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 biliony" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0 bilionu" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bilionů" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bilionů" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 bilionů" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00 bilionu" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bilionů" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bilionů" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 bilionů" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000 bilionu" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bilionů" }
    };

    private static readonly AbbreviationRule[] CS_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tis." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 tis." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0 tis." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tis." },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tis." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 tis." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00 tis." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tis." },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tis." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 tis." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000 tis." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tis." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mil." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 mil." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0 mil." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mil." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mil." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 mil." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00 mil." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mil." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mil." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 mil." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000 mil." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mil." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mld." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 mld." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0 mld." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mld." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mld." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 mld." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00 mld." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mld." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mld." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 mld." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000 mld." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mld." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bil." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 bil." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0 bil." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bil." }
    };

    private static readonly AbbreviationRule[] CS_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tis. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 tis. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0 tis. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tis. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tis. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 tis. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00 tis. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tis. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tis. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 tis. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000 tis. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tis. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mil. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 mil. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0 mil. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mil. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mil. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 mil. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00 mil. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mil. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mil. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 mil. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000 mil. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mil. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mld. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 mld. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0 mld. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mld. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mld. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 mld. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00 mld. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mld. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mld. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 mld. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000 mld. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mld. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bil. ¤" }
    };

    // Welsh
    private static readonly AbbreviationRule[] CY_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Zero, Value = "0 mil" },
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 mil" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "0 fil" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 mil" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0 mil" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 mil" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Zero, Value = "00 mil" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 mil" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "00 mil" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 mil" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00 mil" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 mil" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Zero, Value = "000 mil" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 mil" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "000 mil" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 mil" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000 mil" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 mil" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Zero, Value = "0 miliwn" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 miliwn" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "0 filiwn" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 miliwn" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0 miliwn" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 miliwn" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Zero, Value = "00 miliwn" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 miliwn" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "00 miliwn" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 miliwn" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00 miliwn" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 miliwn" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Zero, Value = "000 miliwn" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 miliwn" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "000 miliwn" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 miliwn" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000 miliwn" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 miliwn" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Zero, Value = "0 biliwn" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 biliwn" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "0 biliwn" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 biliwn" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0 biliwn" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 biliwn" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Zero, Value = "00 biliwn" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 biliwn" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "00 biliwn" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 biliwn" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00 biliwn" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 biliwn" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Zero, Value = "000 biliwn" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 biliwn" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "000 biliwn" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 biliwn" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000 biliwn" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 biliwn" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Zero, Value = "0 triliwn" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 triliwn" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "0 driliwn" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 thriliwn" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0 thriliwn" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 triliwn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Zero, Value = "00 triliwn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 triliwn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "00 triliwn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 triliwn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00 triliwn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 triliwn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Zero, Value = "000 triliwn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 triliwn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "000 triliwn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 triliwn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000 triliwn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 triliwn" }
    };

    private static readonly AbbreviationRule[] CY_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Zero, Value = "0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Zero, Value = "00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Zero, Value = "000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Zero, Value = "0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Zero, Value = "00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Zero, Value = "000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Zero, Value = "0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Zero, Value = "00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Zero, Value = "000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000B" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Zero, Value = "0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Zero, Value = "00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Zero, Value = "000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T" }
    };

    private static readonly AbbreviationRule[] CY_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Zero, Value = "¤0 mil" },
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Zero, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Zero, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Zero, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Zero, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Zero, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Zero, Value = "¤0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "¤0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "¤0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "¤0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Zero, Value = "¤00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "¤00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "¤00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "¤00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Zero, Value = "¤000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "¤000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "¤000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "¤000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000B" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Zero, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Zero, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Zero, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Danish
    private static readonly AbbreviationRule[] DA_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tusind" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tusind" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tusind" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tusind" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tusind" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tusind" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 million" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 millioner" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 millioner" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 millioner" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 millioner" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 millioner" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 milliard" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 milliarder" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 milliarder" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 milliarder" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 milliarder" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 milliarder" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 billion" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 billioner" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 billioner" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 billioner" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 billioner" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 billioner" }
    };

    private static readonly AbbreviationRule[] DA_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 td" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 td" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 td" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 td" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 td" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 td" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mio" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mio" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mio" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mio" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mio" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mio" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mia" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mia" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mia" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mia" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mia" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mia" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bio" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bio" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bio" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bio" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bio" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bio" }
    };

    private static readonly AbbreviationRule[] DA_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 td ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 td ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 td ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 td ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 td ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 td ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mio ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mio ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mio ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mio ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mio ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mio ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mia ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mia ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mia ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mia ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mia ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mia ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bio ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bio ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bio ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bio ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bio ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bio ¤" }
    };

    // Taita
    private static readonly AbbreviationRule[] DAV_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // German
    private static readonly AbbreviationRule[] DE_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 Tausend" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 Tausend" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 Tausend" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 Tausend" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 Tausend" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 Tausend" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 Million" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 Millionen" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 Millionen" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 Millionen" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 Millionen" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 Millionen" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 Milliarde" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 Milliarden" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 Milliarden" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 Milliarden" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 Milliarden" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 Milliarden" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 Billion" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 Billionen" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 Billionen" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 Billionen" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 Billionen" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 Billionen" }
    };

    private static readonly AbbreviationRule[] DE_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 Tsd." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 Tsd." },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 Tsd." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 Tsd." },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 Tsd." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 Tsd." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 Mio." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 Mio." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 Mio." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 Mio." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 Mio." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 Mio." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 Mrd." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 Mrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 Mrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 Mrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 Mrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 Mrd." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 Bio." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 Bio." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 Bio." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 Bio." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 Bio." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 Bio." }
    };

    private static readonly AbbreviationRule[] DE_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 Tsd. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 Tsd. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 Tsd. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 Tsd. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 Tsd. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 Tsd. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 Mio. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 Mio. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 Mio. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 Mio. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 Mio. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 Mio. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 Mrd. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 Mrd. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 Mrd. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 Mrd. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 Mrd. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 Mrd. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 Bio. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 Bio. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 Bio. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 Bio. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 Bio. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 Bio. ¤" }
    };

    // Zarma
    private static readonly AbbreviationRule[] DJE_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T¤" }
    };

    // Lower Sorbian
    private static readonly AbbreviationRule[] DSB_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tysac" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "0 tysac" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 tysac" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tysac" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tysac" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "00 tysac" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 tysac" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tysac" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tysac" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "000 tysac" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 tysac" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tysac" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 milion" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "0 miliona" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 miliony" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 milionow" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 milionow" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "00 milionow" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 milionow" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 milionow" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 milionow" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "000 milionow" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 milionow" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 milionow" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 miliarda" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "0 miliarźe" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 miliardy" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 miliardow" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 miliardow" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "00 miliardow" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 miliardow" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 miliardow" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 miliardow" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "000 miliardow" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 miliardow" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 miliardow" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bilion" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "0 biliona" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 biliony" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bilionow" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bilionow" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "00 bilionow" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 bilionow" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bilionow" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bilionow" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "000 bilionow" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 bilionow" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bilionow" }
    };

    private static readonly AbbreviationRule[] DSB_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tys." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "0 tys." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 tys." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tys." },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tys." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "00 tys." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 tys." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tys." },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tys." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "000 tys." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 tys." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tys." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mio." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "0 mio." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 mio." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mio." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mio." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "00 mio." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 mio." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mio." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mio." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "000 mio." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 mio." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mio." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mrd." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "0 mrd." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 mrd." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "00 mrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 mrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "000 mrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 mrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mrd." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bil." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "0 bil." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 bil." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "00 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "000 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bil." }
    };

    private static readonly AbbreviationRule[] DSB_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tys. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "0 tys. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 tys. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tys. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tys. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "00 tys. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 tys. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tys. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tys. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "000 tys. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 tys. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tys. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mio. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "0 mio. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 mio. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mio. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mio. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "00 mio. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 mio. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mio. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mio. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "000 mio. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 mio. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mio. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mrd. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "0 mrd. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 mrd. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mrd. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mrd. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "00 mrd. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 mrd. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mrd. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mrd. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "000 mrd. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 mrd. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mrd. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "000 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bil. ¤" }
    };

    // Duala
    private static readonly AbbreviationRule[] DUA_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T ¤" }
    };

    // Jola-Fonyi
    private static readonly AbbreviationRule[] DYO_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T ¤" }
    };

    // Dzongkha
    private static readonly AbbreviationRule[] DZ_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "སྟོང་ཕྲག 0" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "ཁྲི་ཕྲག 0" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "འབུམ་ཕྲག 0" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "ས་ཡ་ 0" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "བྱེ་བ་ 0" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "དུང་ཕྱུར་ 0" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "དུང་ཕྱུར་ 00" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "དུང་ཕྱུར་བརྒྱ་ 0" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "དུང་ཕྱུར་སྟོང 0" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "དུང་ཕྱུར་ཁྲི་ 0" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "དུང་ཕྱུར་འབུམ་ 0" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "དུང་ཕྱུར་ས་ཡ་ 0" }
    };

    private static readonly AbbreviationRule[] DZ_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Embu
    private static readonly AbbreviationRule[] EBU_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Ewe
    private static readonly AbbreviationRule[] EE_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "akpe 0" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "akpe 0" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "akpe 00" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "akpe 00" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "akpe 000" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "akpe 000" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "miliɔn 0" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "miliɔn 0" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "miliɔn 00" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "miliɔn 00" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "miliɔn 000" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "miliɔn 000" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "miliɔn 0000" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "miliɔn 0000" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "miliɔn 00000" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "miliɔn 00000" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "miliɔn 000000" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "miliɔn 000000" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "biliɔn 0" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "biliɔn 0" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "biliɔn 00" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "biliɔn 00" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "biliɔn 000" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "biliɔn 000" }
    };

    private static readonly AbbreviationRule[] EE_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0000M" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00000M" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00000M" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000000M" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000000M" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0B" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0B" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00B" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00B" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000B" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000B" }
    };

    private static readonly AbbreviationRule[] EE_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0000M" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00000M" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00000M" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000000M" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000000M" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0B" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0B" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00B" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00B" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000B" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000B" }
    };

    // Greek
    private static readonly AbbreviationRule[] EL_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 χιλιάδα" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 χιλιάδες" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 χιλιάδες" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 χιλιάδες" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 χιλιάδες" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 χιλιάδες" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 εκατομμύριο" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 εκατομμύρια" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 εκατομμύρια" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 εκατομμύρια" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 εκατομμύρια" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 εκατομμύρια" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 δισεκατομμύριο" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 δισεκατομμύρια" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 δισεκατομμύρια" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 δισεκατομμύρια" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 δισεκατομμύρια" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 δισεκατομμύρια" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 τρισεκατομμύριο" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 τρισεκατομμύρια" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 τρισεκατομμύρια" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 τρισεκατομμύρια" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 τρισεκατομμύρια" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 τρισεκατομμύρια" }
    };

    private static readonly AbbreviationRule[] EL_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 χιλ." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 χιλ." },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 χιλ." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 χιλ." },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 χιλ." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 χιλ." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 εκ." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 εκ." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 εκ." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 εκ." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 εκ." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 εκ." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 δισ." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 δισ." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 δισ." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 δισ." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 δισ." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 δισ." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 τρισ." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 τρισ." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 τρισ." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 τρισ." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 τρισ." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 τρισ." }
    };

    private static readonly AbbreviationRule[] EL_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 χιλ. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 χιλ. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 χιλ. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 χιλ. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 χιλ. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 χιλ. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 εκ. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 εκ. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 εκ. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 εκ. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 εκ. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 εκ. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 δισ. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 δισ. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 δισ. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 δισ. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 δισ. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 δισ. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 τρισ. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 τρισ. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 τρισ. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 τρισ. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 τρισ. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 τρισ. ¤" }
    };

    // English
    private static readonly AbbreviationRule[] EN_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 thousand" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 thousand" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 thousand" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 thousand" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 thousand" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 thousand" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 million" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 million" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 million" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 million" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 million" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 million" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 billion" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 billion" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 billion" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 billion" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 billion" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 billion" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 trillion" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 trillion" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 trillion" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 trillion" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 trillion" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 trillion" }
    };

    private static readonly AbbreviationRule[] EN_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000B" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T" }
    };

    private static readonly AbbreviationRule[] EN_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000B" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Esperanto
    private static readonly AbbreviationRule[] EO_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤ 0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤ 00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤ 000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤ 0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤ 00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤ 000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤ 0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤ 00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤ 000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤ 0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤ 00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤ 000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000T" }
    };

    // Spanish
    private static readonly AbbreviationRule[] ES_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 mil" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 mil" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 mil" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 mil" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 mil" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 mil" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 millón" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 millones" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 millones" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 millones" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 millones" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 millones" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mil millones" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mil millones" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mil millones" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mil millones" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mil millones" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mil millones" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 billón" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 billones" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 billones" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 billones" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 billones" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 billones" }
    };

    private static readonly AbbreviationRule[] ES_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0000 M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0000 M" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 MRD" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 MRD" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 MRD" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 MRD" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 B" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 B" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 B" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 B" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 B" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 B" }
    };

    private static readonly AbbreviationRule[] ES_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 K ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 K ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 K ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 K ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 K ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 K ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 M ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 M ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0000 M ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0000 M ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 MRD ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 MRD ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 MRD ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 MRD ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 B ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 B ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 B ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 B ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 B ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 B ¤" }
    };

    // Estonian
    private static readonly AbbreviationRule[] ET_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tuhat" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tuhat" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tuhat" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tuhat" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tuhat" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tuhat" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 miljon" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 miljonit" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 miljon" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 miljonit" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 miljon" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 miljonit" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 miljard" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 miljardit" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 miljard" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 miljardit" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 miljard" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 miljardit" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 triljon" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 triljonit" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 triljon" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 triljonit" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 triljon" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 triljonit" }
    };

    private static readonly AbbreviationRule[] ET_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tuh" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tuh" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tuh" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tuh" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tuh" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tuh" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mln" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mln" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mln" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mln" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mln" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mln" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mld" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mld" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mld" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mld" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mld" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mld" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 trl" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 trl" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 trl" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 trl" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 trl" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 trl" }
    };

    private static readonly AbbreviationRule[] ET_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tuh ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tuh ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tuh ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tuh ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tuh ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tuh ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mln ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mln ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mln ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mln ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mln ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mln ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mld ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mld ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mld ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mld ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mld ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mld ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 trl ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 trl ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 trl ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 trl ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 trl ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 trl ¤" }
    };

    // Basque
    private static readonly AbbreviationRule[] EU_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0000" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0000" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00000" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00000" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000000" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000000" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 milioi" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 milioi" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 milioi" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 milioi" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 milioi" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 milioi" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0000 milioi" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0000 milioi" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00000 milioi" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00000 milioi" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000000 milioi" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000000 milioi" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bilioi" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bilioi" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bilioi" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bilioi" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bilioi" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bilioi" }
    };

    private static readonly AbbreviationRule[] EU_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0000" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0000" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00000" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00000" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000000" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000000" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0000 M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0000 M" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00000 M" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00000 M" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000000 M" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000000 M" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 B" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 B" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 B" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 B" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 B" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 B" }
    };

    private static readonly AbbreviationRule[] EU_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0000 ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0000 ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00000 ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00000 ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000000 ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000000 ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 M ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 M ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0000 M ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0000 M ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00000 M ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00000 M ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000000 M ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000000 M ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 B ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 B ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 B ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 B ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 B ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 B ¤" }
    };

    // Ewondo
    private static readonly AbbreviationRule[] EWO_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T ¤" }
    };

    // Persian
    private static readonly AbbreviationRule[] FA_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 هزار" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 هزار" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 هزار" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 هزار" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 هزار" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 هزار" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 میلیون" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 میلیون" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 میلیون" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 میلیون" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 میلیون" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 میلیون" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 میلیارد" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 میلیارد" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 میلیارد" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 میلیارد" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 میلیارد" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 میلیارد" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 هزارمیلیارد" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 هزارمیلیارد" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 هزارمیلیارد" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 هزارمیلیارد" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 هزارمیلیارد" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 هزارمیلیارد" }
    };

    private static readonly AbbreviationRule[] FA_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 هزار" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 هزار" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 هزار" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 هزار" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 هزار" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 هزار" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 میلیون" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 میلیون" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 میلیون" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 میلیون" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 م" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 م" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 م" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 م" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 م" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 م" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 میلیارد" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 میلیارد" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 تریلیون" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 تریلیون" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 ت" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 ت" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 ت" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 ت" }
    };

    // Fulah
    private static readonly AbbreviationRule[] FF_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0G ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00G ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000G ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T ¤" }
    };

    // Finnish
    private static readonly AbbreviationRule[] FI_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tuhat" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tuhatta" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tuhatta" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tuhatta" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tuhatta" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tuhatta" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 miljoona" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 miljoonaa" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 miljoonaa" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 miljoonaa" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 miljoonaa" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 miljoonaa" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 miljardi" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 miljardia" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 miljardia" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 miljardia" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 miljardia" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 miljardia" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 biljoona" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 biljoonaa" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 biljoonaa" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 biljoonaa" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 biljoonaa" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 biljoonaa" }
    };

    private static readonly AbbreviationRule[] FI_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 t." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 t." },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 t." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 t." },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 t." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 t." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 milj." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 milj." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 milj." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 milj." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 milj." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 milj." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mrd." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mrd." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bilj." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bilj." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bilj." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bilj." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bilj." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bilj." }
    };

    private static readonly AbbreviationRule[] FI_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 t. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 t. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 t. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 t. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 t. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 t. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 milj. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 milj. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 milj. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 milj. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 milj. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 milj. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mrd. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mrd. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mrd. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mrd. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mrd. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mrd. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bilj. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bilj. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bilj. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bilj. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bilj. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bilj. ¤" }
    };

    // Filipino
    private static readonly AbbreviationRule[] FIL_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 libo" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 na libo" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 libo" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 na libo" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 libo" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 na libo" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 milyon" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 na milyon" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 milyon" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 na milyon" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 milyon" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 na milyon" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 bilyon" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 na bilyon" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 bilyon" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 na bilyon" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 bilyon" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 na bilyon" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 trilyon" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 na trilyon" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 trilyon" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 na trilyon" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 trilyon" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 na trilyon" }
    };

    private static readonly AbbreviationRule[] FIL_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000B" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T" }
    };

    private static readonly AbbreviationRule[] FIL_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000B" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Faroese
    private static readonly AbbreviationRule[] FO_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 túsund" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 túsund" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 túsund" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 túsund" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 túsund" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 túsund" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 millión" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 milliónir" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 milliónir" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 milliónir" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 milliónir" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 milliónir" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 milliard" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 milliardir" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 milliardir" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 milliardir" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 milliardir" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 milliardir" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 billión" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 billiónir" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 billiónir" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 billiónir" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 billiónir" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 billiónir" }
    };

    private static readonly AbbreviationRule[] FO_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tús." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tús." },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tús." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tús." },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tús." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tús." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mió." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mió." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mió." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mió." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mió." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mió." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mia." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mia." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mia." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mia." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mia." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mia." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bió." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bió." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bió." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bió." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bió." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bió." }
    };

    private static readonly AbbreviationRule[] FO_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tús. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tús. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tús. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tús. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tús. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tús. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mió. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mió. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mió. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mió. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mió. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mió. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mia. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mia. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mia. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mia. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mia. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mia. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bió. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bió. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bió. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bió. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bió. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bió. ¤" }
    };

    // French
    private static readonly AbbreviationRule[] FR_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 millier" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 mille" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 mille" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 mille" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 mille" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 mille" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 million" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 millions" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 million" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 millions" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 million" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 millions" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 milliard" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 milliards" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 milliard" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 milliards" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 milliards" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 milliards" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 billion" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 billions" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 billions" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 billions" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 billions" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 billions" }
    };

    private static readonly AbbreviationRule[] FR_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 k" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 k" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 k" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 k" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 k" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 k" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 Md" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 Md" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 Md" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 Md" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 Md" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 Md" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 Bn" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 Bn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 Bn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 Bn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 Bn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 Bn" }
    };

    private static readonly AbbreviationRule[] FR_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 k ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 k ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 k ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 k ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 k ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 k ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 M ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 M ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 Md ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 Md ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 Md ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 Md ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 Md ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 Md ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 Bn ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 Bn ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 Bn ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 Bn ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 Bn ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 Bn ¤" }
    };

    // Friulian
    private static readonly AbbreviationRule[] FUR_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤ 0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤ 00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤ 000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤ 0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤ 00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤ 000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤ 0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤ 00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤ 000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤ 0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤ 00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤ 000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000T" }
    };

    // Western Frisian
    private static readonly AbbreviationRule[] FY_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tûzen" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tûzen" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tûzen" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tûzen" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tûzen" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tûzen" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 miljoen" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 miljoen" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 miljoen" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 miljoen" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 miljoen" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 miljoen" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 miljard" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 miljard" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 miljard" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 miljard" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 miljard" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 miljard" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 biljoen" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 biljoen" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 biljoen" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 biljoen" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 biljoen" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 biljoen" }
    };

    private static readonly AbbreviationRule[] FY_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mln." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mln." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mln." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mln." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mln." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mln." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mld." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mld." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mld." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mld." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mld." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mld." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bln." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bln." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bln." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bln." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bln." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bln." }
    };

    private static readonly AbbreviationRule[] FY_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤ 0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤ 00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤ 000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤ 0 mln." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0 mln." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤ 00 mln." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00 mln." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤ 000 mln." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000 mln." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤ 0 mld." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0 mld." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤ 00 mld." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00 mld." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤ 000 mld." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000 mld." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤ 0 bln." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0 bln." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤ 00 bln." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00 bln." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤ 000 bln." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000 bln." }
    };

    // Irish
    private static readonly AbbreviationRule[] GA_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 mhíle" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "0 mhíle" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 mhíle" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0 míle" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 míle" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 míle" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "00 míle" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 míle" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00 míle" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 míle" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 míle" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "000 míle" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 míle" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000 míle" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 míle" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mhilliún" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "0 mhilliún" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 mhilliún" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0 milliún" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 milliún" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 milliún" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "00 milliún" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 milliún" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00 milliún" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 milliún" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 milliún" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "000 milliún" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 milliún" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000 milliún" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 milliún" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 bhilliún" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "0 bhilliún" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 bhilliún" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0 mbilliún" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 billiún" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 billiún" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "00 billiún" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 billiún" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00 mbilliún" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 billiún" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 billiún" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "000 billiún" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 billiún" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000 billiún" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 billiún" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 trilliún" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "0 thrilliún" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 thrilliún" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0 dtrilliún" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 trilliún" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 trilliún" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "00 trilliún" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 trilliún" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00 dtrilliún" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 trilliún" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 trilliún" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "000 trilliún" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 trilliún" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000 trilliún" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 trilliún" }
    };

    private static readonly AbbreviationRule[] GA_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0k" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "0k" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0k" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0k" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0k" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00k" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "00k" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00k" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00k" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00k" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000k" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "000k" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000k" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000k" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000k" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000B" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T" }
    };

    private static readonly AbbreviationRule[] GA_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0k" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "¤0k" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "¤0k" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "¤0k" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0k" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00k" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "¤00k" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "¤00k" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "¤00k" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00k" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000k" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "¤000k" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "¤000k" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "¤000k" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000k" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "¤0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "¤0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "¤0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "¤00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "¤00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "¤00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "¤000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "¤000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "¤000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000B" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Scottish Gaelic
    private static readonly AbbreviationRule[] GD_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 mhìle" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "0 mhìle" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 mìle" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 mìle" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 mhìle" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "00 mhìle" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 mìle" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 mìle" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 mhìle" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "000 mhìle" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 mìle" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 mìle" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mhillean" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "0 mhillean" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 millean" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 millean" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mhillean" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "00 mhillean" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 millean" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 millean" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mhillean" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "000 mhillean" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 millean" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 millean" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 bhillean" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "0 bhillean" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 billean" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 billean" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 bhillean" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "00 bhillean" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 billean" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 billean" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 billean" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "000 billean" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 bhillean" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 bhillean" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 trillean" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "0 thrillean" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 trillean" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 trillean" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 trillean" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "00 thrillean" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 trillean" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 trillean" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 trillean" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "000 thrillean" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 trillean" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 trillean" }
    };

    private static readonly AbbreviationRule[] GD_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000B" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T" }
    };

    // Galician
    private static readonly AbbreviationRule[] GL_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 millón" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 millóns" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 millóns" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 millóns" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 millóns" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 millóns" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 billón" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 billóns" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 billóns" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 billóns" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 billóns" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 billóns" }
    };

    private static readonly AbbreviationRule[] GL_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mill." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mill." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mill." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mill." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mill" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mill" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bill." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bill." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bill." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bill." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bill." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bill." }
    };

    private static readonly AbbreviationRule[] GL_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 M¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 M¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "0" }
    };

    // Swiss German
    private static readonly AbbreviationRule[] GSW_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tausend" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tausend" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tausend" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tausend" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tausend" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tausend" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 Million" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 Millionen" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 Million" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 Millionen" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 Million" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 Millionen" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 Milliarde" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 Milliarden" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 Milliarde" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 Milliarden" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 Milliarde" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 Milliarden" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 Billion" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 Billionen" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 Billion" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 Billionen" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 Billion" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 Billionen" }
    };

    private static readonly AbbreviationRule[] GSW_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tsd" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tsd" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tsd" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tsd" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tsd" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tsd" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 Mio" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 Mio" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 Mio" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 Mio" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 Mio" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 Mio" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 Mrd" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 Mrd" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 Mrd" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 Mrd" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 Mrd" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 Mrd" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 Bio" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 Bio" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 Bio" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 Bio" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 Bio" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 Bio" }
    };

    private static readonly AbbreviationRule[] GSW_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tsd ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tsd ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tsd ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tsd ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tsd ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tsd ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 Mio ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 Mio ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 Mio ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 Mio ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 Mio ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 Mio ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 Mrd ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 Mrd ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 Mrd ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 Mrd ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 Mrd ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 Mrd ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 Bio ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 Bio ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 Bio ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 Bio ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 Bio ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 Bio ¤" }
    };

    // Gujarati
    private static readonly AbbreviationRule[] GU_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 હજાર" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 હજાર" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 હજાર" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 હજાર" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "0 લાખ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "0 લાખ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "00 લાખ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "00 લાખ" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "0 કરોડ" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "0 કરોડ" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "00 કરોડ" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "00 કરોડ" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 અબજ" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 અબજ" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 અબજ" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 અબજ" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "0 નિખર્વ" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "0 નિખર્વ" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 મહાપદ્મ" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 મહાપદ્મ" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "0 શંકુ" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "0 શંકુ" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "0 જલધિ" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "0 જલધિ" }
    };

    private static readonly AbbreviationRule[] GU_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 હજાર" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 હજાર" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 હજાર" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 હજાર" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "0 લાખ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "0 લાખ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "00 લાખ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "00 લાખ" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "0 કરોડ" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "0 કરોડ" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "00 કરોડ" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "00 કરોડ" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 અબજ" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 અબજ" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 અબજ" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 અબજ" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "0 નિખર્વ" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "0 નિખર્વ" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 મહાપદ્મ" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 મહાપદ્મ" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "0 શંકુ" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "0 શંકુ" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "0 જલધિ" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "0 જલધિ" }
    };

    // Gusii
    private static readonly AbbreviationRule[] GUZ_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Manx
    private static readonly AbbreviationRule[] GV_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "¤0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "¤0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "¤0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "¤00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "¤00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "¤00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "¤000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "¤000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "¤000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Hausa
    private static readonly AbbreviationRule[] HA_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "Dubu 0" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "Dubu 0" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "Dubu 00" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "Dubu 00" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "Dubu 000" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "Dubu 000" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "Miliyan 0" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "Miliyan 0" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "Miliyan 00" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "Miliyan 00" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "Miliyan 000" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "Miliyan 000" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "Biliyan 0" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "Biliyan 0" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "Biliyan 00" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "Biliyan 00" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "Biliyan 000" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "Biliyan 000" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "Triliyan 0" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "Triliyan 0" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "Triliyan 00" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "Triliyan 00" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "Triliyan 000" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "Triliyan 000" }
    };

    private static readonly AbbreviationRule[] HA_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0D" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0D" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00D" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00D" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000D" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000D" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000B" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T" }
    };

    private static readonly AbbreviationRule[] HA_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤ 0D" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0D" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤ 00D" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00D" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤ 000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000D" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤ 0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤ 00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤ 000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000B" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Hawaiian
    private static readonly AbbreviationRule[] HAW_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Hebrew
    private static readonly AbbreviationRule[] HE_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "‏0 אלף" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "‏0 אלף" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "‏0 אלף" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "‏0 אלף" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "‏00 אלף" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "‏00 אלף" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "‏00 אלף" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "‏00 אלף" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "‏000 אלף" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "‏000 אלף" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "‏000 אלף" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "‏000 אלף" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "‏0 מיליון" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "‏0 מיליון" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "‏0 מיליון" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "‏0 מיליון" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "‏00 מיליון" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "‏00 מיליון" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "‏00 מיליון" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "‏00 מיליון" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "‏000 מיליון" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "‏000 מיליון" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "‏000 מיליון" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "‏000 מיליון" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "‏0 מיליארד" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "‏0 מיליארד" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "‏0 מיליארד" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "‏0 מיליארד" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "‏00 מיליארד" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "‏00 מיליארד" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "‏00 מיליארד" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "‏00 מיליארד" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "‏000 מיליארד" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "‏000 מיליארד" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "‏000 מיליארד" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "‏000 מיליארד" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "‏0 טריליון" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "‏0 טריליון" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "‏0 טריליון" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "‏0 טריליון" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "‏00 טריליון" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "‏00 טריליון" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "‏00 טריליון" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "‏00 טריליון" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "‏000 טריליון" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "‏000 טריליון" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "‏000 טריליון" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "‏000 טריליון" }
    };

    private static readonly AbbreviationRule[] HE_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000B" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T" }
    };

    private static readonly AbbreviationRule[] HE_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤ 0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "¤ 0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "¤0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "¤0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "¤00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "¤00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "¤000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "¤000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000B" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Hindi
    private static readonly AbbreviationRule[] HI_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 हज़ार" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 हज़ार" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 हज़ार" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 हज़ार" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "0 लाख" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "0 लाख" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "00 लाख" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "00 लाख" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "0 करोड़" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "0 करोड़" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "00 करोड़" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "00 करोड़" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 अरब" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 अरब" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 अरब" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 अरब" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "0 खरब" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "0 खरब" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "00 खरब" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "00 खरब" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "000 खरब" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "000 खरब" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "0000 खरब" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "0000 खरब" }
    };

    private static readonly AbbreviationRule[] HI_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 हज़ार" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 हज़ार" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 हज़ार" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 हज़ार" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "0 लाख" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "0 लाख" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "00 लाख" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "00 लाख" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "0 क." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "0 क." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "00 क." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "00 क." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 अ." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 अ." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 अ." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 अ." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "0 ख." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "0 ख." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "00 ख." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "00 ख." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "0 नील" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "0 नील" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "00 नील" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "00 नील" }
    };

    // Croatian
    private static readonly AbbreviationRule[] HR_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tisuća" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 tisuće" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tisuća" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tisuća" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 tisuće" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tisuća" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tisuća" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 tisuće" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tisuća" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 milijun" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 milijuna" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 milijuna" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 milijun" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 milijuna" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 milijuna" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 milijun" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 milijuna" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 milijuna" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 milijarda" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 milijarde" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 milijardi" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 milijarda" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 milijarde" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 milijardi" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 milijarda" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 milijarde" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 milijardi" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bilijun" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 bilijuna" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bilijuna" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bilijun" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 bilijuna" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bilijuna" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bilijun" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 bilijuna" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bilijuna" }
    };

    private static readonly AbbreviationRule[] HR_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tis." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 tis." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tis." },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tis." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 tis." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tis." },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tis." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 tis." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tis." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mil." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 mil." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mil." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mil." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 mil." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mil." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mil." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 mil." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mil." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mlr." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 mlr." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mlr." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mlr." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 mlr." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mlr." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mlr." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 mlr." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mlr." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bil." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 bil." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bil." }
    };

    private static readonly AbbreviationRule[] HR_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0000¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0000¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0000¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tis. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 tis. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tis. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tis. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 tis. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tis. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mil. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 mil. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mil. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mil. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 mil. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mil. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mil. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 mil. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mil. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mlr. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 mlr. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mlr. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mlr. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 mlr. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mlr. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mlr. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 mlr. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mlr. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bil. ¤" }
    };

    // Upper Sorbian
    private static readonly AbbreviationRule[] HSB_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tysac" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "0 tysac" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 tysac" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tysac" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tysac" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "00 tysac" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 tysac" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tysac" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tysac" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "000 tysac" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 tysac" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tysac" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 milion" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "0 milionaj" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 miliony" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 milionow" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 milionow" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "00 milionow" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 milionow" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 milionow" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 milionow" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "000 milionow" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 milionow" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 milionow" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 miliarda" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "0 miliardźe" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 miliardy" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 miliardow" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 miliardow" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "00 miliardow" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 miliardow" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 miliardow" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 miliardow" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "000 miliardow" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 miliardow" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 miliardow" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bilion" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "0 bilionaj" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 biliony" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bilionow" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bilionow" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "00 bilionow" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 bilionow" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bilionow" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bilionow" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "000 bilionow" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 bilionow" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bilionow" }
    };

    private static readonly AbbreviationRule[] HSB_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tys." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "0 tys." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 tys." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tys." },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tys." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "00 tys." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 tys." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tys." },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tys." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "000 tys." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 tys." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tys." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mio." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "0 mio." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 mio." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mio." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mio." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "00 mio." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 mio." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mio." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mio." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "000 mio." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 mio." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mio." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mrd." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "0 mrd." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 mrd." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "00 mrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 mrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "000 mrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 mrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mrd." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bil." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "0 bil." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 bil." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "00 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "000 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bil." }
    };

    private static readonly AbbreviationRule[] HSB_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tys. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "0 tys. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 tys. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tys. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tys. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "00 tys. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 tys. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tys. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tys. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "000 tys. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 tys. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tys. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mio. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "0 mio. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 mio. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mio. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mio. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "00 mio. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 mio. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mio. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mio. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "000 mio. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 mio. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mio. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mrd. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "0 mrd. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 mrd. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mrd. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mrd. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "00 mrd. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 mrd. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mrd. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mrd. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "000 mrd. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 mrd. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mrd. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "000 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bil. ¤" }
    };

    // Hungarian
    private static readonly AbbreviationRule[] HU_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 ezer" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 ezer" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 ezer" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 ezer" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 ezer" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 ezer" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 millió" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 millió" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 millió" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 millió" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 millió" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 millió" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 milliárd" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 milliárd" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 milliárd" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 milliárd" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 milliárd" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 milliárd" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 billió" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 billió" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 billió" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 billió" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 billió" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 billió" }
    };

    private static readonly AbbreviationRule[] HU_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 E" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 E" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 E" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 E" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 E" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 E" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 Mrd" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 Mrd" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 Mrd" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 Mrd" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 Mrd" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 Mrd" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 B" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 B" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 B" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 B" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 B" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 B" }
    };

    private static readonly AbbreviationRule[] HU_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 E ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 E ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 E ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 E ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 E ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 E ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 M ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 M ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 Mrd ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 Mrd ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 Mrd ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 Mrd ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 Mrd ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 Mrd ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 B ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 B ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 B ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 B ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 B ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 B ¤" }
    };

    // Armenian
    private static readonly AbbreviationRule[] HY_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 հազար" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 հազար" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 հազար" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 հազար" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 հազար" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 հազար" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 միլիոն" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 միլիոն" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 միլիոն" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 միլիոն" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 միլիոն" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 միլիոն" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 միլիարդ" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 միլիարդ" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 միլիարդ" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 միլիարդ" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 միլիարդ" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 միլիարդ" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 տրիլիոն" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 տրիլիոն" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 տրիլիոն" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 տրիլիոն" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 տրիլիոն" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 տրիլիոն" }
    };

    private static readonly AbbreviationRule[] HY_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 հզր" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 հզր" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 հզր" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 հզր" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 հզր" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 հզր" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 մլն" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 մլն" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 մլն" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 մլն" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 մլն" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 մլն" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 մլրդ" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 մլրդ" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 մլրդ" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 մլրդ" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 մլրդ" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 մլրդ" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 տրլն" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 տրլն" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 տրլն" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 տրլն" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 տրլն" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 տրլն" }
    };

    private static readonly AbbreviationRule[] HY_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 հզր ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 հզր ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 հզր ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 հզր ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 հզր ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 հզր ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 մլն ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 մլն ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 մլն ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 մլն ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 մլն ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 մլն ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 մլրդ ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 մլրդ ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 մլրդ ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 մլրդ ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 մլրդ ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 մլրդ ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 տրլն ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 տրլն ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 տրլն ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 տրլն ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 տրլն ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 տրլն ¤" }
    };

    // Indonesian
    private static readonly AbbreviationRule[] ID_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 ribu" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 ribu" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 ribu" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 juta" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 juta" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 juta" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 miliar" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 miliar" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 miliar" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 triliun" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 triliun" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 triliun" }
    };

    private static readonly AbbreviationRule[] ID_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 rb" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 rb" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 rb" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 jt" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 jt" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 jt" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 M" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 M" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 M" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 T" }
    };

    private static readonly AbbreviationRule[] ID_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0 rb" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00 rb" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000 rb" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0 jt" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00 jt" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000 jt" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0 M" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00 M" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000 M" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0 T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00 T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000 T" }
    };

    // Yi
    private static readonly AbbreviationRule[] II_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000T" }
    };

    // Icelandic
    private static readonly AbbreviationRule[] IS_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 þúsund" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 þúsund" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 þúsund" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 þúsund" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 þúsund" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 þúsund" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 milljón" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 milljónir" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 milljón" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 milljónir" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 milljón" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 milljónir" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 milljarður" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 milljarðar" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 milljarður" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 milljarðar" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 milljarður" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 milljarðar" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 billjón" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 billjónir" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 billjón" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 billjónir" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 billjón" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 billjónir" }
    };

    private static readonly AbbreviationRule[] IS_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 þ." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 þ." },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 þ." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 þ." },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 þ." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 þ." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 m." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 m." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 m." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 m." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 m." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 m." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 ma." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 ma." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 ma." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 ma." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 ma." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 ma." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bn" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bn" }
    };

    private static readonly AbbreviationRule[] IS_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 þ. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 þ. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 þ. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 þ. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 þ. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 þ. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 m. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 m. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 m. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 m. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 m. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 m. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 ma. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 ma. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 ma. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 ma. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 ma. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 ma. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bn ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bn ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bn ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bn ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bn ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bn ¤" }
    };

    // Italian
    private static readonly AbbreviationRule[] IT_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 mila" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 mila" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 mila" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 mila" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 mila" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 mila" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 milione" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 milioni" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 milioni" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 milioni" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 milioni" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 milioni" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 miliardo" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 miliardi" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 miliardi" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 miliardi" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 miliardi" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 miliardi" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 mila miliardi" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 mila miliardi" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 mila miliardi" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 mila miliardi" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 mila miliardi" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 mila miliardi" }
    };

    private static readonly AbbreviationRule[] IT_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 Mln" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 Mln" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 Mln" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 Mln" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 Mln" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 Mln" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 Mld" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 Mld" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 Mld" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 Mld" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 Mld" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 Mld" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 Bln" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 Bln" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 Bln" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 Bln" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 Bln" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 Bln" }
    };

    private static readonly AbbreviationRule[] IT_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "0" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 Mio ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 Mio ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 Mio ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 Mio ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 Mio ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 Mio ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 Mrd ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 Mrd ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 Mrd ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 Mrd ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 Mrd ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 Mrd ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 Bln ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 Bln ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 Bln ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 Bln ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 Bln ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 Bln ¤" }
    };

    // Japanese
    private static readonly AbbreviationRule[] JA_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "0万" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "00万" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "000万" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "0000万" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "0億" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "00億" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "000億" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "0000億" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0兆" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00兆" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000兆" }
    };

    private static readonly AbbreviationRule[] JA_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "0万" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "00万" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "000万" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "0000万" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "0億" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "00億" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "000億" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "0000億" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0兆" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00兆" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000兆" }
    };

    private static readonly AbbreviationRule[] JA_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤0万" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤00万" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤000万" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤0000万" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤0億" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤00億" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤000億" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤0000億" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0兆" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00兆" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000兆" }
    };

    // Ngomba
    private static readonly AbbreviationRule[] JGO_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤ 0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤ 00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤ 000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤ 0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤ 00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤ 000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤ 0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤ 00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤ 000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤ 0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤ 00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤ 000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000T" }
    };

    // Machame
    private static readonly AbbreviationRule[] JMC_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Georgian
    private static readonly AbbreviationRule[] KA_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 ათასი" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 ათასი" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 ათასი" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 ათასი" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 ათასი" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 ათასი" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 მილიონი" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 მილიონი" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 მილიონი" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 მილიონი" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 მილიონი" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 მილიონი" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 მილიარდი" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 მილიარდი" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 მილიარდი" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 მილიარდი" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 მილიარდი" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 მილიარდი" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 ტრილიონი" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 ტრილიონი" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 ტრილიონი" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 ტრილიონი" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 ტრილიონი" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 ტრილიონი" }
    };

    private static readonly AbbreviationRule[] KA_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 ათ." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 ათ." },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 ათ." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 ათ." },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 ათ." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 ათ." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 მლნ." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 მლნ." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 მლნ." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 მლნ." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 მლნ." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 მლნ." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 მლრდ." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 მლრდ." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 მლრდ." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 მლრდ." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 მლრ." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 მლრ." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 ტრლ." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 ტრლ." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 ტრლ." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 ტრლ." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 ტრლ." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 ტრლ." }
    };

    private static readonly AbbreviationRule[] KA_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 ათ. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 ათ. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 ათ. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 ათ. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 ათ. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 ათ. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 მლნ. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 მლნ. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 მლნ. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 მლნ. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 მლნ. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 მლნ. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 მლრდ. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 მლრდ. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 მლრდ. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 მლრდ. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 მლრ. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 მლრ. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 ტრლ. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 ტრლ. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 ტრლ. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 ტრლ. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 ტრლ. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 ტრლ. ¤" }
    };

    // Kabyle
    private static readonly AbbreviationRule[] KAB_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0G¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00G¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000G¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T¤" }
    };

    // Kamba
    private static readonly AbbreviationRule[] KAM_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Makonde
    private static readonly AbbreviationRule[] KDE_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Kabuverdianu
    private static readonly AbbreviationRule[] KEA_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 mil" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 mil" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 mil" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 milhãu" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 milhãu" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 milhãu" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mil milhãu" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mil milhãu" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mil milhãu" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bilhãu" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bilhãu" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bilhãu" }
    };

    private static readonly AbbreviationRule[] KEA_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 mil" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 mil" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 mil" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 MM" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 MM" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 MM" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 Bi" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 Bi" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 Bi" }
    };

    private static readonly AbbreviationRule[] KEA_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 mil ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 mil ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 mil ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 M ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 MM ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 MM ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 MM ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 Bi ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 Bi ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 Bi ¤" }
    };

    // Koyra Chiini
    private static readonly AbbreviationRule[] KHQ_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T¤" }
    };

    // Kikuyu
    private static readonly AbbreviationRule[] KI_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Kazakh
    private static readonly AbbreviationRule[] KK_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 мың" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 мың" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 мың" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 мың" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 мың" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 мың" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 миллион" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 миллион" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 миллион" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 миллион" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 миллион" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 миллион" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 миллиард" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 миллиард" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 миллиард" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 миллиард" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 миллиард" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 миллиард" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 триллион" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 триллион" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 триллион" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 триллион" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 триллион" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 триллион" }
    };

    private static readonly AbbreviationRule[] KK_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 мың" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 мың" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 мың" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 мың" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 м." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 м." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 млн" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 млн" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 млн" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 млн" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 млн" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 млн" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 млрд" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 млрд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 млрд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 млрд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 млрд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 млрд" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 трлн" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 трлн" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 трлн" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 трлн" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 трлн" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 трлн" }
    };

    private static readonly AbbreviationRule[] KK_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 мың ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 мың ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 мың ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 мың ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 мың ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 мың ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 млн ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 млн ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 млн ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 млн ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 млн ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 млн ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 млрд ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 млрд ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 млрд ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 млрд ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 млрд ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 млрд ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 трлн ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 трлн ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 трлн ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 трлн ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 трлн ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 трлн ¤" }
    };

    // Kako
    private static readonly AbbreviationRule[] KKJ_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤ 0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤ 00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤ 000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤ 0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤ 00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤ 000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤ 0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤ 00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤ 000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤ 0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤ 00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤ 000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000T" }
    };

    // Greenlandic
    private static readonly AbbreviationRule[] KL_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tusind" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tusind" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tusind" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tusind" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tusind" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tusind" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 million" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 millioner" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 million" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 millioner" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 million" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 millioner" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 milliard" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 milliarder" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 milliard" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 milliarder" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 milliard" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 milliarder" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 billion" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 billioner" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 billion" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 billioner" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 billion" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 billioner" }
    };

    private static readonly AbbreviationRule[] KL_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 td" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 td" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 td" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 td" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 td" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 td" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mn" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mn" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mn" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mn" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mn" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mn" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 md" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 md" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 md" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 md" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 md" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 md" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bn" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bn" }
    };

    private static readonly AbbreviationRule[] KL_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0 td" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0 td" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00 td" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00 td" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000 td" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000 td" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0 mn" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0 mn" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00 mn" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00 mn" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000 mn" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000 mn" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0 md" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0 md" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00 md" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00 md" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000 md" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000 md" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0 bn" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0 bn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00 bn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00 bn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000 bn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000 bn" }
    };

    // Kalenjin
    private static readonly AbbreviationRule[] KLN_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Khmer
    private static readonly AbbreviationRule[] KM_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0ពាន់" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "0​មឺុន" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "0សែន" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0លាន" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "0​ដប់​លាន" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "0​រយលាន" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0​កោដិ" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "0​ដប់​កោដិ" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "0​រយ​កោដិ" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0​ពាន់​កោដិ" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "0​មឺុន​កោដិ" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "0​សែន​កោដិ" }
    };

    private static readonly AbbreviationRule[] KM_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0ពាន់" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "0​មឺុន" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "0សែន" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0លាន" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "0​ដប់​លាន" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "0​រយលាន" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0​កោដិ" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "0​ដប់​កោដិ" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "0​រយ​កោដិ" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0​ពាន់​កោដិ" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "0​មឺុន​កោដិ" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "0​សែន​កោដិ" }
    };

    private static readonly AbbreviationRule[] KM_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0ពាន់" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤0​មឺុន" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤0សែន" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0លាន" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤0​ដប់​លាន" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤0​រយលាន" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0​កោដិ" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤0​ដប់​កោដិ" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤0​រយ​កោដិ" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0​ពាន់​កោដិ" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤0​មឺុន​កោដិ" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤0​សែន​កោដិ" }
    };

    // Kannada
    private static readonly AbbreviationRule[] KN_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 ಸಾವಿರ" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 ಸಾವಿರ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 ಸಾವಿರ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 ಸಾವಿರ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 ಸಾವಿರ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 ಸಾವಿರ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 ಮಿಲಿಯನ್" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 ಮಿಲಿಯನ್" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 ಮಿಲಿಯನ್" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 ಮಿಲಿಯನ್" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 ಮಿಲಿಯನ್" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 ಮಿಲಿಯನ್" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 ಬಿಲಿಯನ್" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 ಬಿಲಿಯನ್" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 ಬಿಲಿಯನ್" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 ಬಿಲಿಯನ್" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 ಬಿಲಿಯನ್" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 ಬಿಲಿಯನ್" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 ಟ್ರಿಲಿಯನ್‌" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 ಟ್ರಿಲಿಯನ್‌" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 ಟ್ರಿಲಿಯನ್‌" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 ಟ್ರಿಲಿಯನ್‌" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 ಟ್ರಿಲಿಯನ್‌" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 ಟ್ರಿಲಿಯನ್‌" }
    };

    private static readonly AbbreviationRule[] KN_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0ಸಾ" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0ಸಾ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00ಸಾ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00ಸಾ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000ಸಾ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000ಸಾ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0ಮಿ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0ಮಿ" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00ಮಿ" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00ಮಿ" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000ಮಿ" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000ಮಿ" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0ಬಿ" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0ಬಿ" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00ಬಿ" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00ಬಿ" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000ಬಿ" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000ಬಿ" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0ಟ್ರಿ" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0ಟ್ರಿ" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00ಟ್ರಿ" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00ಟ್ರಿ" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000ಟ್ರಿ" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000ಟ್ರಿ" }
    };

    // Korean
    private static readonly AbbreviationRule[] KO_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0천" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "0만" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "00만" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "000만" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "0000만" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "0억" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "00억" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "000억" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "0000억" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0조" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00조" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000조" }
    };

    private static readonly AbbreviationRule[] KO_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0천" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "0만" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "00만" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "000만" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "0000만" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "0억" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "00억" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "000억" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "0000억" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0조" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00조" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000조" }
    };

    private static readonly AbbreviationRule[] KO_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0천" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤0만" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤00만" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤000만" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤0000만" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤0억" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤00억" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤000억" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤0000억" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0조" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00조" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000조" }
    };

    // Konkani
    private static readonly AbbreviationRule[] KOK_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000T" }
    };

    // Kashmiri
    private static readonly AbbreviationRule[] KS_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤ 0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤ 00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤ 000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤ 0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤ 00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤ 000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤ 0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤ 00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤ 000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤ 0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤ 00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤ 000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000T" }
    };

    // Shambala
    private static readonly AbbreviationRule[] KSB_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0G¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00G¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000G¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T¤" }
    };

    // Bafia
    private static readonly AbbreviationRule[] KSF_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T ¤" }
    };

    // Colognian
    private static readonly AbbreviationRule[] KSH_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Zero, Value = "0 Dousend" },
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 Dousend" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 Dousend" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Zero, Value = "00 Dousend" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 Dousend" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 Dousend" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Zero, Value = "000 Dousend" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 Dousend" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 Dousend" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Zero, Value = "0 Milljuhne" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 Million" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 Milljuhne" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Zero, Value = "00 Milljuhne" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 Milljuhne" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 Millionen" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Zero, Value = "000 Milljuhne" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 Milljuhne" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 Millionen" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Zero, Value = "0 Milljard" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 Milliarde" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 Milljarde" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Zero, Value = "00 Milljarde" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 Milljarde" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 Milliarden" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Zero, Value = "000 Milljarde" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 Milliarde" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 Milliarden" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Zero, Value = "0 Billjuhn" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 Billjuhn" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 Billjuhn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Zero, Value = "00 Billjuhn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 Billion" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 Billionen" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Zero, Value = "000 Billjuhn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 Billion" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 Billionen" }
    };

    private static readonly AbbreviationRule[] KSH_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Zero, Value = "0 tsd" },
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tsd" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tsd" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Zero, Value = "00 tsd" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tsd" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tsd" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Zero, Value = "000 tsd" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tsd" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tsd" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Zero, Value = "0 Mio" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 Mio" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 Mio" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Zero, Value = "00 Mio" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 Mio" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 Mio" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Zero, Value = "000 Mio" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 Mio" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 Mio" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Zero, Value = "0 Mrd" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 Mrd" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 Mrd" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Zero, Value = "00 Mrd" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 Mrd" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 Mrd" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Zero, Value = "000 Mrd" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 Mrd" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 Mrd" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Zero, Value = "0 Bio" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 Bio" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 Bio" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Zero, Value = "00 Bio" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 Bio" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 Bio" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Zero, Value = "000 Bio" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 Bio" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 Bio" }
    };

    private static readonly AbbreviationRule[] KSH_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Zero, Value = "0 tsd ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tsd ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tsd ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Zero, Value = "00 tsd ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tsd ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tsd ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Zero, Value = "000 tsd ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tsd ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tsd ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Zero, Value = "0 Mio ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 Mio ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 Mio ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Zero, Value = "00 Mio ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 Mio ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 Mio ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Zero, Value = "000 Mio ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 Mio ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 Mio ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Zero, Value = "0 Mrd ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 Mrd ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 Mrd ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Zero, Value = "00 Mrd ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 Mrd ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 Mrd ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Zero, Value = "000 Mrd ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 Mrd ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 Mrd ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Zero, Value = "0 Bio ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 Bio ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 Bio ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Zero, Value = "00 Bio ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 Bio ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 Bio ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Zero, Value = "000 Bio ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 Bio ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 Bio ¤" }
    };

    // Cornish
    private static readonly AbbreviationRule[] KW_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "¤0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "¤00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "¤000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Kyrgyz
    private static readonly AbbreviationRule[] KY_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 миӊ" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 миӊ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 миӊ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 миӊ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 миӊ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 миӊ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 миллион" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 миллион" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 миллион" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 миллион" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 миллион" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 миллион" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 миллиард" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 миллиард" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 миллиард" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 миллиард" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 миллиард" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 миллиард" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 триллион" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 триллион" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 триллион" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 триллион" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 триллион" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 триллион" }
    };

    private static readonly AbbreviationRule[] KY_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 миӊ" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 миӊ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 миӊ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 миӊ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 миӊ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 миӊ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 млн" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 млн" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 млн" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 млн" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 млн" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 млн" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 млд" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 млд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 млд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 млд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 млд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 млд" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 трлн" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 трлн" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 трлн" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 трлн" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 трлн" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 трлн" }
    };

    private static readonly AbbreviationRule[] KY_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 миӊ ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 миӊ ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 миӊ ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 миӊ ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 миӊ ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 миӊ ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 млн ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 млн ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 млн ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 млн ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 млн ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 млн ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 млд ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 млд ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 млд ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 млд ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 млд ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 млд ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 трлн ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 трлн ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 трлн ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 трлн ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 трлн ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 трлн ¤" }
    };

    // Langi
    private static readonly AbbreviationRule[] LAG_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Zero, Value = "¤ 0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤ 0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Zero, Value = "¤ 00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤ 00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Zero, Value = "¤ 000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤ 000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Zero, Value = "¤ 0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤ 0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Zero, Value = "¤ 00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤ 00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Zero, Value = "¤ 000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤ 000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Zero, Value = "¤ 0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤ 0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Zero, Value = "¤ 00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤ 00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Zero, Value = "¤ 000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤ 000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Zero, Value = "¤ 0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤ 0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Zero, Value = "¤ 00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤ 00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Zero, Value = "¤ 000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤ 000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000T" }
    };

    // Luxembourgish
    private static readonly AbbreviationRule[] LB_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 Dausend" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 Dausend" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 Dausend" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 Dausend" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 Dausend" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 Dausend" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 Millioun" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 Milliounen" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 Milliounen" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 Milliounen" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 Milliounen" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 Milliounen" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 Milliard" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 Milliarden" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 Milliarden" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 Milliarden" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 Milliarden" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 Milliarden" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 Billioun" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 Billiounen" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 Billiounen" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 Billiounen" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 Billiounen" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 Billiounen" }
    };

    private static readonly AbbreviationRule[] LB_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 Dsd." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 Dsd." },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 Dsd." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 Dsd." },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 Dsd." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 Dsd." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 Mio." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 Mio." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 Mio." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 Mio." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 Mio." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 Mio." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 Mrd." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 Mrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 Mrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 Mrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 Mrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 Mrd." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 Bio." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 Bio." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 Bio." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 Bio." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 Bio." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 Bio." }
    };

    private static readonly AbbreviationRule[] LB_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 Dsd. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 Dsd. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 Dsd. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 Dsd. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 Dsd. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 Dsd. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 Mio. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 Mio. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 Mio. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 Mio. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 Mio. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 Mio. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 Mrd. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 Mrd. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 Mrd. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 Mrd. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 Mrd. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 Mrd. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 Bio. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 Bio. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 Bio. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 Bio. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 Bio. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 Bio. ¤" }
    };

    // Ganda
    private static readonly AbbreviationRule[] LG_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0G¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00G¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000G¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T¤" }
    };

    // Lakota
    private static readonly AbbreviationRule[] LKT_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000T" }
    };

    // Lingala
    private static readonly AbbreviationRule[] LN_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0G ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00G ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000G ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T ¤" }
    };

    // Lao
    private static readonly AbbreviationRule[] LO_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0ພັນ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00ພັນ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000ພັນ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0ລ້ານ" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00ລ້ານ" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000ລ້ານ" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0ພັນລ້ານ" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00ພັນລ້ານ" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000ພັນລ້ານ" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0000ພັນລ້ານ" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00ລ້ານລ້ານ" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000ລ້ານລ້ານ" }
    };

    private static readonly AbbreviationRule[] LO_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0ພັນ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00ພັນ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000ພັນ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0ລ້ານ" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00ລ້ານ" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000ລ້ານ" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0ຕື້" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00ຕື້" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000ຕື້" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0000ຕື້" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00ພັນຕື້" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000ພັນຕື້" }
    };

    private static readonly AbbreviationRule[] LO_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0 ພັນ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00 ພັນ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000 ກີບ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0 ລ້ານ" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00 ລ້ານ" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000 ລ້ານ" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0 ຕື້" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00 ຕື້" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000 ຕື້" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0 ລ້ານລ້ານ" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00 ລ້ານລ້ານ" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000 ລ້ານລ້ານ" }
    };

    // Lithuanian
    private static readonly AbbreviationRule[] LT_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tūkstantis" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 tūkstančiai" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0 tūkstančio" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tūkstančių" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tūkstantis" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 tūkstančiai" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00 tūkstančio" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tūkstančių" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tūkstantis" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 tūkstančiai" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000 tūkstančio" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tūkstančių" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 milijonas" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 milijonai" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0 milijono" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 milijonų" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 milijonas" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 milijonai" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00 milijono" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 milijonų" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 milijonas" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 milijonai" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000 milijono" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 milijonų" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 milijardas" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 milijardai" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0 milijardo" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 milijardų" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 milijardas" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 milijardai" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00 milijardo" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 milijardų" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 milijardas" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 milijardai" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000 milijardo" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 milijardų" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 trilijonas" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 trilijonai" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0 trilijono" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 trilijonų" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 trilijonas" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 trilijonai" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00 trilijono" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 trilijonų" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 trilijonas" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 trilijonai" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000 trilijono" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 trilijonų" }
    };

    private static readonly AbbreviationRule[] LT_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tūkst." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 tūkst." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0 tūkst." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tūkst." },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tūkst." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 tūkst." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00 tūkst." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tūkst." },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tūkst." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 tūkst." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000 tūkst." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tūkst." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mln." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 mln." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0 mln." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mln." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mln." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 mln." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00 mln." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mln." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mln." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 mln." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000 mln." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mln." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mlrd." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 mlrd." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0 mlrd." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mlrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mlrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 mlrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00 mlrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mlrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mlrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 mlrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000 mlrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mlrd." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 trln." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 trln." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0 trln." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 trln." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 trln." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 trln." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00 trln." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 trln." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 trln." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 trln." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000 trln." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 trln." }
    };

    private static readonly AbbreviationRule[] LT_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tūkst. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 tūkst. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0 tūkst. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tūkst. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tūkst. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 tūkst. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00 tūkst. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tūkst. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tūkst. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 tūkst. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000 tūkst. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tūkst. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mln. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 mln. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0 mln. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mln. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mln. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 mln. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00 mln. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mln. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mln. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 mln. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000 mln. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mln. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mlrd. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 mlrd. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0 mlrd. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mlrd. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mlrd. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 mlrd. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00 mlrd. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mlrd. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mlrd. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 mlrd. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000 mlrd. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mlrd. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 trln. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 trln. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0 trln. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 trln. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 trln. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 trln. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00 trln. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 trln. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 trln. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 trln. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000 trln. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 trln. ¤" }
    };

    // Luba-Katanga
    private static readonly AbbreviationRule[] LU_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T¤" }
    };

    // Luo
    private static readonly AbbreviationRule[] LUO_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T¤" }
    };

    // Luyia
    private static readonly AbbreviationRule[] LUY_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Latvian
    private static readonly AbbreviationRule[] LV_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Zero, Value = "0 tūkstoši" },
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tūkstotis" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tūkstoši" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Zero, Value = "00 tūkstoši" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tūkstotis" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tūkstoši" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Zero, Value = "000 tūkstoši" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tūkstotis" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tūkstoši" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Zero, Value = "0 miljoni" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 miljons" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 miljoni" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Zero, Value = "00 miljoni" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 miljons" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 miljoni" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Zero, Value = "000 miljoni" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 miljons" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 miljoni" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Zero, Value = "0 miljardi" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 miljards" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 miljardi" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Zero, Value = "00 miljardi" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 miljards" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 miljardi" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Zero, Value = "000 miljardi" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 miljards" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 miljardi" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Zero, Value = "0 triljoni" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 triljons" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 triljoni" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Zero, Value = "00 triljoni" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 triljons" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 triljoni" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Zero, Value = "000 triljoni" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 triljons" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 triljoni" }
    };

    private static readonly AbbreviationRule[] LV_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Zero, Value = "0 tūkst." },
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tūkst." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tūkst." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Zero, Value = "00 tūkst." },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tūkst." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tūkst." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Zero, Value = "000 tūkst." },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tūkst." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tūkst." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Zero, Value = "0 milj." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 milj." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 milj." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Zero, Value = "00 milj." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 milj." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 milj." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Zero, Value = "000 milj." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 milj." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 milj." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Zero, Value = "0 mljrd." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mljrd." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mljrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Zero, Value = "00 mljrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mljrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mljrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Zero, Value = "000 mljrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mljrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mljrd." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Zero, Value = "0 trilj." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 trilj." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 trilj." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Zero, Value = "00 trilj." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 trilj." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 trilj." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Zero, Value = "000 trilj." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 trilj." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 trilj." }
    };

    private static readonly AbbreviationRule[] LV_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Zero, Value = "0 tūkst. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tūkst. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tūkst. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Zero, Value = "00 tūkst. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tūkst. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tūkst. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Zero, Value = "000 tūkst. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tūkst. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tūkst. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Zero, Value = "0 milj. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 milj. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 milj. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Zero, Value = "00 milj. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 milj. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 milj. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Zero, Value = "000 milj. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 milj. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 milj. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Zero, Value = "0 mljrd. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mljrd. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mljrd. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Zero, Value = "¤00 mljrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00 mljrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00 mljrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Zero, Value = "¤000 mljrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000 mljrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000 mljrd." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Zero, Value = "¤0 trilj." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0 trilj." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0 trilj." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Zero, Value = "¤00 trilj." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00 trilj." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00 trilj." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Zero, Value = "¤000 trilj." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000 trilj." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000 trilj." }
    };

    // Masai
    private static readonly AbbreviationRule[] MAS_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Meru
    private static readonly AbbreviationRule[] MER_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Morisyen
    private static readonly AbbreviationRule[] MFE_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000T" }
    };

    // Malagasy
    private static readonly AbbreviationRule[] MG_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Makhuwa-Meetto
    private static readonly AbbreviationRule[] MGH_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000T" }
    };

    // Metaʼ
    private static readonly AbbreviationRule[] MGO_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤ 0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤ 00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤ 000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤ 0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤ 00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤ 000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤ 0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤ 00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤ 000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤ 0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤ 00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤ 000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000T" }
    };

    // Macedonian
    private static readonly AbbreviationRule[] MK_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 илјада" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 илјади" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 илјади" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 илјади" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 илјади" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 илјади" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 милион" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 милиони" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 милиони" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 милиони" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 милиони" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 милиони" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 милијарда" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 милијарди" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 милијарди" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 милијарди" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 милијарди" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 милијарди" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 трилион" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 трилиони" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 трилиони" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 трилиони" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 трилиони" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 трилиони" }
    };

    private static readonly AbbreviationRule[] MK_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 илј." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 илј." },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 илј." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 илј." },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 илј." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 илј." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 мил." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 мил." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 мил." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 мил." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 М" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 М" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 милј." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 милј." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 милј." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 милј." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 мј." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 милј." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 трил." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 трил." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 трил." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 трил." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 трил." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 трил." }
    };

    private static readonly AbbreviationRule[] MK_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤ 0 илј." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0 илј." },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤ 00 илј." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00 илј." },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤ 000 илј." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000 илј." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤ 0 мил." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0 мил." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤ 00 мил." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00 мил." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤ 000 М" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000 М" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤ 0 милј." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0 милј." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤ 00 милј." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00 милј." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤ 000 мј." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000 милј." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤ 0 трил." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0 трил." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤ 00 трил." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00 трил." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤ 000 трил." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000 трил." }
    };

    // Malayalam
    private static readonly AbbreviationRule[] ML_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 ആയിരം" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 ആയിരം" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 ആയിരം" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 ആയിരം" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 ആയിരം" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 ആയിരം" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 ദശലക്ഷം" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 ദശലക്ഷം" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 ദശലക്ഷം" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 ദശലക്ഷം" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 ദശലക്ഷം" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 ദശലക്ഷം" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 ലക്ഷം കോടി" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 ലക്ഷം കോടി" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 ലക്ഷം കോടി" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 ലക്ഷം കോടി" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 ലക്ഷം കോടി" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 ലക്ഷം കോടി" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 ട്രില്യൺ" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 ട്രില്യൺ" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 ട്രില്യൺ" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 ട്രില്യൺ" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 ട്രില്യൺ" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 ട്രില്യൺ" }
    };

    private static readonly AbbreviationRule[] ML_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000B" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T" }
    };

    private static readonly AbbreviationRule[] ML_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000B" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Mongolian, Cyrillic
    private static readonly AbbreviationRule[] MN_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 мянга" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 мянга" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 мянга" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 мянга" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 мянга" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 мянга" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 сая" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 сая" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 сая" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 сая" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 сая" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 сая" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 тэрбум" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 тэрбум" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 тэрбум" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 тэрбум" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 тэрбум" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 тэрбум" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 их наяд" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 их наяд" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 их наяд" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 их наяд" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 их наяд" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 их наяд" }
    };

    private static readonly AbbreviationRule[] MN_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0мянга" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0мянга" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00мянга" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00мянга" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000М" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000М" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0сая" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0сая" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00сая" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00сая" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000сая" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000сая" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0тэрбум" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0тэрбум" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00Т" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00Т" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000Т" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000Т" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0ИН" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0ИН" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00ИН" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00ИН" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000ИН" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000ИН" }
    };

    private static readonly AbbreviationRule[] MN_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤ 0Мянга" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0Мянга" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤ 00Мянга" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00Мянга" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤ 0Мянга" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 0Мянга" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤ 0Сая" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0Сая" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤ 00Сая" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00Сая" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤ 000Сая" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000Сая" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤ 0Тэрбум" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0Тэрбум" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤ 00Тэрбум" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00Тэрбум" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤ 000Тэрбум" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000Тэрбум" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤ 0ИН" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0ИН" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤ 00ИН" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00ИН" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤ 000ИН" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000ИН" }
    };

    // Marathi
    private static readonly AbbreviationRule[] MR_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 हजार" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 हजार" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 हजार" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 हजार" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "0 लाख" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "0 लाख" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "00 लाख" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "00 लाख" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "0 कोटी" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "0 कोटी" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "00 कोटी" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "00 कोटी" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 अब्ज" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 अब्ज" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 अब्ज" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 अब्ज" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "0 खर्व" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "0 खर्व" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "00 खर्व" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "00 खर्व" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "0 पद्म" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "0 पद्म" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "00 पद्म" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "00 पद्म" }
    };

    private static readonly AbbreviationRule[] MR_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 ह" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 ह" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 ह" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 ह" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "0 लाख" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "0 लाख" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "00 लाख" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "00 लाख" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "0 कोटी" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "0 कोटी" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "00 कोटी" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "00 कोटी" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 अब्ज" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 अब्ज" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 अब्ज" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 अब्ज" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "0 खर्व" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "0 खर्व" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "00 खर्व" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "00 खर्व" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "0 पद्म" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "0 पद्म" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "00 पद्म" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "00 पद्म" }
    };

    // Malay
    private static readonly AbbreviationRule[] MS_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 ribu" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 ribu" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 ribu" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 juta" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 juta" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 juta" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 bilion" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 bilion" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 bilion" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 trilion" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 trilion" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 trilion" }
    };

    private static readonly AbbreviationRule[] MS_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0J" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00J" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000J" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000B" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T" }
    };

    private static readonly AbbreviationRule[] MS_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0J" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00J" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000J" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000B" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Maltese
    private static readonly AbbreviationRule[] MT_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "¤0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "¤0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "¤00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "¤00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "¤000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "¤000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Mundang
    private static readonly AbbreviationRule[] MUA_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Burmese
    private static readonly AbbreviationRule[] MY_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0ထောင်" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "0သောင်း" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "0သိန်း" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0သန်း" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "0ကုဋေ" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "00ကုဋေ" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "ကုဋေ000" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "ကုဋေ0000" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "ကုဋေ0သောင်း" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "ကုဋေ0သိန်း" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "ကုဋေ0သန်း" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "0ကောဋိ" }
    };

    private static readonly AbbreviationRule[] MY_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0ထောင်" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "0သောင်း" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "0သိန်း" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0သန်း" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "0ကုဋေ" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "00ကုဋေ" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "ကုဋေ000" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "ကုဋေ0ထ" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "ကုဋေ0သ" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "ဋေ0သိန်း" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "ဋေ0သန်း" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "0ကောဋိ" }
    };

    private static readonly AbbreviationRule[] MY_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0ထောင်" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 0သောင်း" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 0သိန်း" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0သန်း" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 0ကုဋေ" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 00ကုဋေ" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ ကုဋေ000" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ ကုဋေ0000" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ ကုဋေ0သောင်း" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ ကုဋေ0သိန်း" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ ကုဋေ0သန်း" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 0ကောဋိ" }
    };

    // Nama
    private static readonly AbbreviationRule[] NAQ_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "¤0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "¤00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "¤000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Norwegian Bokmål
    private static readonly AbbreviationRule[] NB_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tusen" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tusen" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tusen" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tusen" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tusen" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tusen" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 million" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 millioner" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 million" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 millioner" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 million" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 millioner" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 milliard" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 milliarder" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 milliard" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 milliarder" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 milliard" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 milliarder" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 billion" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 billioner" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 billioner" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 billioner" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 billioner" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 billioner" }
    };

    private static readonly AbbreviationRule[] NB_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0k" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0k" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00k" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00k" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000k" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000k" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mill" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mill" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mill" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mill" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mill" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mill" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mrd" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mrd" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mrd" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mrd" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mrd" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mrd" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bill" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bill" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bill" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bill" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bill" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bill" }
    };

    // North Ndebele
    private static readonly AbbreviationRule[] ND_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Nepali
    private static readonly AbbreviationRule[] NE_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 हजार" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 हजार" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 हजार" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 हजार" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "0 लाख" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "0 लाख" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 करोड" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 करोड" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 करोड" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 करोड" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 करोड" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 करोड" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 अर्ब" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 अर्ब" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 अर्ब" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 अर्ब" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 अरब" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 अरब" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 खर्ब" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 खर्ब" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "0 शंख" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "0 शंख" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "00 शंख" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "00 शंख" }
    };

    private static readonly AbbreviationRule[] NE_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 हजार" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 हजार" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 हजार" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 हजार" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "0 लाख" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "0 लाख" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "00 लाख" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "00 लाख" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "0 करोड" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "0 करोड" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "00 करोड" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "00 करोड" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 अरब" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 अरब" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 अरब" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 अरब" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "0 खरब" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "0 खरब" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "00 खरब" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "00 खरब" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "0 शंख" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "0 शंख" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "00 शंख" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "00 शंख" }
    };

    // Dutch
    private static readonly AbbreviationRule[] NL_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 duizend" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 duizend" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 duizend" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 duizend" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 duizend" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 duizend" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 miljoen" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 miljoen" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 miljoen" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 miljoen" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 miljoen" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 miljoen" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 miljard" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 miljard" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 miljard" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 miljard" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 miljard" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 miljard" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 biljoen" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 biljoen" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 biljoen" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 biljoen" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 biljoen" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 biljoen" }
    };

    private static readonly AbbreviationRule[] NL_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mln." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mln." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mln." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mln." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mln." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mln." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mld." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mld." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mld." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mld." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mld." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mld." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bln." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bln." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bln." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bln." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bln." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bln." }
    };

    // Kwasio
    private static readonly AbbreviationRule[] NMG_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T ¤" }
    };

    // Norwegian Nynorsk
    private static readonly AbbreviationRule[] NN_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tusen" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tusen" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tusen" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tusen" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tusen" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tusen" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 million" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 millioner" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 million" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 millioner" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 million" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 millioner" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 milliard" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 milliarder" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 milliard" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 milliarder" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 milliard" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 milliarder" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 billion" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 billioner" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 billion" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 billioner" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 billion" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 billioner" }
    };

    private static readonly AbbreviationRule[] NN_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tn" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tn" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tn" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tn" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tn" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tn" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mn" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mn" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mn" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mn" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mn" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mn" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 md" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 md" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 md" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 md" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 md" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 md" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bn" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bn" }
    };

    private static readonly AbbreviationRule[] NN_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tn ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tn ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tn ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tn ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tn ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tn ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mn ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mn ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mn ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mn ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mn ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mn ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 md ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 md ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 md ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 md ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 md ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 md ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bn ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bn ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bn ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bn ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bn ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bn ¤" }
    };

    // Ngiemboon
    private static readonly AbbreviationRule[] NNH_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤ 0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤ 00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤ 000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤ 0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤ 00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤ 000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤ 0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤ 00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤ 000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤ 0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤ 00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤ 000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000T" }
    };

    // Nuer
    private static readonly AbbreviationRule[] NUS_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Nyankole
    private static readonly AbbreviationRule[] NYN_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Oromo
    private static readonly AbbreviationRule[] OM_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Odia
    private static readonly AbbreviationRule[] OR_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤ 0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤ 00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤ 000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤ 0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤ 00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤ 000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤ 0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤ 00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤ 000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤ 0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤ 00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤ 000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000T" }
    };

    // Ossetic
    private static readonly AbbreviationRule[] OS_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤ 0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤ 00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤ 000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤ 0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤ 00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤ 000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤ 0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤ 00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤ 000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤ 0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤ 00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤ 000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000T" }
    };

    // Punjabi
    private static readonly AbbreviationRule[] PA_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 ਹਜ਼ਾਰ" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 ਹਜ਼ਾਰ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 ਹਜ਼ਾਰ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 ਹਜ਼ਾਰ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "0 ਲੱਖ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "0 ਲੱਖ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "00 ਲੱਖ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "00 ਲੱਖ" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "0 ਕਰੋੜ" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "0 ਕਰੋੜ" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "00 ਕਰੋੜ" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "00 ਕਰੋੜ" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 ਅਰਬ" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 ਅਰਬ" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 ਅਰਬ" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 ਅਰਬ" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "0 ਖਰਬ" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "0 ਖਰਬ" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "00 ਖਰਬ" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "00 ਖਰਬ" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "0 ਨੀਲ" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "0 ਨੀਲ" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "00 ਨੀਲ" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "00 ਨੀਲ" }
    };

    private static readonly AbbreviationRule[] PA_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 ਹਜ਼ਾਰ" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 ਹਜ਼ਾਰ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 ਹਜ਼ਾਰ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 ਹਜ਼ਾਰ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "0 ਲੱਖ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "0 ਲੱਖ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "00 ਲੱਖ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "00 ਲੱਖ" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "0 ਕਰੋੜ" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "0 ਕਰੋੜ" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "00 ਕਰੋੜ" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "00 ਕਰੋੜ" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 ਅਰਬ" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 ਅਰਬ" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 ਅਰਬ" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 ਅਰਬ" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "0 ਖਰਬ" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "0 ਖਰਬ" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "00 ਖਰਬ" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "00 ਖਰਬ" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "0 ਨੀਲ" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "0 ਨੀਲ" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "00 ਨੀਲ" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "00 ਨੀਲ" }
    };

    // Punjabi
    private static readonly AbbreviationRule[] PA_ARAB_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤ 0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤ 00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤ 000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤ 0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤ 00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤ 000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤ 0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤ 00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤ 000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤ 0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤ 00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤ 000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000T" }
    };

    // Polish
    private static readonly AbbreviationRule[] PL_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tysiąc" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 tysiące" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0 tysięcy" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tysiąca" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tysiąc" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 tysiące" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00 tysięcy" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tysiąca" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tysiąc" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 tysiące" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000 tysięcy" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tysiąca" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 milion" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 miliony" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0 milionów" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 miliona" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 milion" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 miliony" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00 milionów" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 miliona" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 milion" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 miliony" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000 milionów" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 miliona" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 miliard" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 miliardy" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0 miliardów" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 miliarda" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 miliard" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 miliardy" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00 miliardów" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 miliarda" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 miliard" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 miliardy" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000 miliardów" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 miliarda" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bilion" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 biliony" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0 bilionów" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 biliona" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bilion" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 biliony" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00 bilionów" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 biliona" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bilion" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 biliony" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000 bilionów" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 biliona" }
    };

    private static readonly AbbreviationRule[] PL_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tys." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 tys." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0 tys." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tys." },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tys." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 tys." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00 tys." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tys." },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tys." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 tys." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000 tys." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tys." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mln" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 mln" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0 mln" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mln" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mln" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 mln" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00 mln" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mln" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mln" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 mln" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000 mln" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mln" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mld" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 mld" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0 mld" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mld" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mld" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 mld" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00 mld" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mld" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mld" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 mld" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000 mld" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mld" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bln" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 bln" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0 bln" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bln" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bln" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 bln" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00 bln" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bln" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bln" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 bln" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000 bln" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bln" }
    };

    private static readonly AbbreviationRule[] PL_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tys. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 tys. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0 tys. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tys. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tys. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 tys. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00 tys. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tys. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tys. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 tys. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000 tys. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tys. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mln ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 mln ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0 mln ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mln ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mln ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 mln ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00 mln ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mln ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mln ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 mln ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000 mln ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mln ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mld ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 mld ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0 mld ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mld ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mld ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 mld ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00 mld ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mld ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mld ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 mld ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000 mld ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mld ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bln ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 bln ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0 bln ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bln ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bln ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 bln ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00 bln ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bln ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bln ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 bln ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000 bln ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bln ¤" }
    };

    // Portuguese
    private static readonly AbbreviationRule[] PT_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 mil" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 mil" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 mil" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 mil" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 mil" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 mil" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 milhão" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 milhões" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 milhão" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 milhões" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 milhão" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 milhões" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 bilhão" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 bilhões" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 bilhão" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 bilhões" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 bilhão" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 bilhões" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 trilhão" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 trilhões" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 trilhão" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 trilhões" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 trilhão" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 trilhões" }
    };

    private static readonly AbbreviationRule[] PT_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 mil" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 mil" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 mil" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 mil" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 mil" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 mil" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mi" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mi" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mi" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mi" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mi" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mi" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 bi" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 bi" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 bi" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 bi" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 bi" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 bi" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 tri" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 tri" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 tri" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 tri" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 tri" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 tri" }
    };

    private static readonly AbbreviationRule[] PT_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0 mil" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0 mil" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00 mil" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00 mil" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000 mil" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000 mil" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0 mi" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0 mi" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00 mi" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00 mi" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000 mi" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000 mi" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0 bi" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0 bi" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00 bi" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00 bi" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000 bi" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000 bi" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0 tri" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0 tri" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00 tri" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00 tri" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000 tri" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000 tri" }
    };

    // 
    private static readonly AbbreviationRule[] QU_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000T" }
    };

    // Romansh
    private static readonly AbbreviationRule[] RM_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0G ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00G ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000G ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T ¤" }
    };

    // Rundi
    private static readonly AbbreviationRule[] RN_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T¤" }
    };

    // Romanian
    private static readonly AbbreviationRule[] RO_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 mie" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 mii" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 de mii" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 mie" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 mii" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 de mii" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 mie" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 mii" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 de mii" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 milion" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 milioane" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 de milioane" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 milion" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 milioane" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 de milioane" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 milion" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 milioane" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 de milioane" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 miliard" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 miliarde" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 de miliarde" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 miliard" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 miliarde" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 de miliarde" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 miliard" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 miliarde" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 de miliarde" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 trilion" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 trilioane" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 de trilioane" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 trilion" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 trilioane" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 de trilioane" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 trilion" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 trilioane" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 de trilioane" }
    };

    private static readonly AbbreviationRule[] RO_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mil." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 mil." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mil." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mil." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 mil." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mil." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mil." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 mil." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mil." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mld." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 mld." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mld." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mld." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 mld." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mld." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mld." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 mld." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mld." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 tril." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 tril." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 tril." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 tril." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 tril." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 tril." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 tril." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 tril." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 tril." }
    };

    private static readonly AbbreviationRule[] RO_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 mie ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 mii ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 mii ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 mii ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 mii ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 mii ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 mii ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 mii ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 mii ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mil. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 mil. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mil. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mil. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 mil. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mil. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mil. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 mil. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mil. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mld. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 mld. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mld. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mld. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 mld. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mld. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mld. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 mld. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mld. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 tril. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 tril. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 tril. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 tril. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 tril. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 tril. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 tril. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 tril. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 tril. ¤" }
    };

    // Rombo
    private static readonly AbbreviationRule[] ROF_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // 
    private static readonly AbbreviationRule[] ROOT_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T" }
    };

    // Russian
    private static readonly AbbreviationRule[] RU_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 тысяча" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 тысячи" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0 тысяч" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 тысячи" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 тысяча" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 тысячи" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00 тысяч" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 тысячи" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 тысяча" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 тысячи" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000 тысяч" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 тысячи" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 миллион" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 миллиона" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0 миллионов" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 миллиона" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 миллион" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 миллиона" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00 миллионов" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 миллиона" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 миллион" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 миллиона" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000 миллионов" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 миллиона" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 миллиард" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 миллиарда" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0 миллиардов" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 миллиарда" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 миллиард" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 миллиарда" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00 миллиардов" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 миллиарда" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 миллиард" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 миллиарда" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000 миллиардов" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 миллиарда" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 триллион" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 триллиона" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0 триллионов" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 триллиона" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 триллион" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 триллиона" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00 триллионов" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 триллиона" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 триллион" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 триллиона" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000 триллионов" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 триллиона" }
    };

    private static readonly AbbreviationRule[] RU_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 тыс." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 тыс." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0 тыс." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 тыс." },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 тыс." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 тыс." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00 тыс." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 тыс." },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 тыс." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 тыс." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000 тыс." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 тыс." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 млн" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 млн" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0 млн" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 млн" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 млн" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 млн" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00 млн" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 млн" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 млн" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 млн" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000 млн" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 млн" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 млрд" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 млрд" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0 млрд" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 млрд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 млрд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 млрд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00 млрд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 млрд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 млрд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 млрд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000 млрд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 млрд" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 трлн" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 трлн" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0 трлн" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 трлн" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 трлн" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 трлн" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00 трлн" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 трлн" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 трлн" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 трлн" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000 трлн" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 трлн" }
    };

    private static readonly AbbreviationRule[] RU_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 тыс. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 тыс. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0 тыс. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 тыс. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 тыс. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 тыс. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00 тыс. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 тыс. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 тыс. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 тыс. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000 тыс. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 тыс. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 млн ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 млн ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0 млн ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 млн ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 млн ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 млн ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00 млн ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 млн ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 млн ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 млн ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000 млн ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 млн ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 млрд ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 млрд ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0 млрд ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 млрд ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 млрд ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 млрд ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00 млрд ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 млрд ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 млрд ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 млрд ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000 млрд ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 млрд ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 трлн ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 трлн ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0 трлн ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 трлн ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 трлн ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 трлн ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00 трлн ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 трлн ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 трлн ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 трлн ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000 трлн ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 трлн ¤" }
    };

    // Kinyarwanda
    private static readonly AbbreviationRule[] RW_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000T" }
    };

    // Rwa
    private static readonly AbbreviationRule[] RWK_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0G¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00G¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000G¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T¤" }
    };

    // Sakha
    private static readonly AbbreviationRule[] SAH_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 тыһыынча" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 тыһыынча" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 тыһыынча" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 мөлүйүөн" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 мөлүйүөн" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 мөлүйүөн" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 миллиард" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 миллиард" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 миллиард" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 триллион" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 триллион" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 триллион" }
    };

    private static readonly AbbreviationRule[] SAH_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 тыһ." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 тыһ." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 тыһ." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 мөл" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 мөл" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 мөл" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 млрд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 млрд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 млрд" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 трлн" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 трлн" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 трлн" }
    };

    private static readonly AbbreviationRule[] SAH_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 тыһ. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 тыһ. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 тыһ. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 мөл ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 мөл ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 мөл ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 млрд ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 млрд ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 млрд ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 трлн ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 трлн ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 трлн ¤" }
    };

    // Samburu
    private static readonly AbbreviationRule[] SAQ_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Sangu
    private static readonly AbbreviationRule[] SBP_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T¤" }
    };

    // Northern Sami
    private static readonly AbbreviationRule[] SE_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 duhát" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "0 duháhat" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 duháhat" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 duhát" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "00 duháhat" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 duháhat" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 duhát" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "000 duháhat" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 duháhat" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 miljona" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "0 miljonat" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 miljonat" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 miljona" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "00 miljonat" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 miljonat" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 miljona" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "000 miljonat" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 miljonat" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 miljardi" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "0 miljardit" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 miljardit" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 miljardi" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "00 miljardit" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 miljardit" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 miljardi" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "000 miljardit" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 miljardit" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 biljona" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "0 biljonat" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 biljonat" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 biljona" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "00 biljonat" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 biljonat" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 biljona" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "000 biljonat" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 biljonat" }
    };

    private static readonly AbbreviationRule[] SE_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 dt" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "0 dt" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 dt" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 dt" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "00 dt" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 dt" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 dt" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "000 dt" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 dt" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mn" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "0 mn" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mn" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mn" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "00 mn" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mn" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mn" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "000 mn" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mn" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 md" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "0 md" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 md" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 md" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "00 md" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 md" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 md" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "000 md" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 md" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bn" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "0 bn" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "00 bn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "000 bn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bn" }
    };

    private static readonly AbbreviationRule[] SE_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 dt ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "0 dt ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 dt ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 dt ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "00 dt ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 dt ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 dt ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "000 dt ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 dt ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mn ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "0 mn ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mn ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mn ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "00 mn ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mn ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mn ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "000 mn ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mn ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 md ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "0 md ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 md ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 md ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "00 md ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 md ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 md ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "000 md ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 md ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bn ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "0 bn ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bn ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bn ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "00 bn ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bn ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bn ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "000 bn ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bn ¤" }
    };

    // Sena
    private static readonly AbbreviationRule[] SEH_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0G¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00G¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000G¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T¤" }
    };

    // Koyraboro Senni
    private static readonly AbbreviationRule[] SES_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T¤" }
    };

    // Sango
    private static readonly AbbreviationRule[] SG_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Tachelhit
    private static readonly AbbreviationRule[] SHI_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0K¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00K¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000K¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0M¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0G¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0G¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00G¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00G¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000G¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000G¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0T¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00T¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000T¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T¤" }
    };

    // Tachelhit, Latin
    private static readonly AbbreviationRule[] SHI_LATN_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0K¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00K¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000K¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0M¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0G¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0G¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00G¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00G¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000G¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000G¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0T¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00T¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000T¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T¤" }
    };

    // Sinhala
    private static readonly AbbreviationRule[] SI_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "දහස 0" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "දහස 0" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "දහස 00" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "දහස 00" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "දහස 000" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "දහස 000" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "මිලියන 0" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "මිලියන 0" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "මිලියන 00" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "මිලියන 00" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "මිලියන 000" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "මිලියන 000" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "බිලියන 0" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "බිලියන 0" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "බිලියන 00" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "බිලියන 00" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "බිලියන 000" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "බිලියන 000" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "ට්‍රිලියන 0" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "ට්‍රිලියන 0" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "ට්‍රිලියන 00" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "ට්‍රිලියන 00" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "ට්‍රිලියන 000" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "ට්‍රිලියන 000" }
    };

    private static readonly AbbreviationRule[] SI_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "ද0" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "ද0" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "ද00" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "ද00" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "ද000" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "ද000" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "මි0" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "මි0" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "මි00" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "මි00" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "මි000" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "මි000" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "බි0" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "බි0" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "බි00" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "බි00" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "බි000" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "බි000" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "ට්‍රි0" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "ට්‍රි0" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "ට්‍රි00" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "ට්‍රි00" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "ට්‍රි000" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "ට්‍රි000" }
    };

    private static readonly AbbreviationRule[] SI_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤ද0" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ද0" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤ද00" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ද00" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤ද000" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ද000" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤මි0" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤මි0" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤මි00" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤මි00" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤මි000" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤මි000" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤බි0" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤බි0" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤බි00" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤බි00" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤බි000" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤බි000" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤ට්‍රි0" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ට්‍රි0" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤ට්‍රි00" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ට්‍රි00" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤ට්‍රි000" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ට්‍රි000" }
    };

    // Slovak
    private static readonly AbbreviationRule[] SK_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tisíc" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 tisíce" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0 tisíca" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tisíc" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tisíc" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 tisíc" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00 tisíca" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tisíc" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tisíc" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 tisíc" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000 tisíca" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tisíc" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 milión" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 milióny" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0 milióna" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 miliónov" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 miliónov" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 miliónov" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00 milióna" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 miliónov" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 miliónov" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 miliónov" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000 milióna" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 miliónov" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 miliarda" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 miliardy" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0 miliardy" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 miliárd" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 miliárd" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 miliárd" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00 miliardy" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 miliárd" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 miliárd" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 miliárd" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000 miliardy" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 miliárd" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bilión" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 bilióny" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0 bilióna" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 biliónov" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 biliónov" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 biliónov" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00 bilióna" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 biliónov" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 biliónov" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 biliónov" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000 bilióna" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 biliónov" }
    };

    private static readonly AbbreviationRule[] SK_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tis." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 tis." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0 tis." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tis." },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tis." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 tis." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00 tis." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tis." },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tis." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 tis." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000 tis." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tis." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mil." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 mil." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0 mil." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mil." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mil." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 mil." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00 mil." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mil." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mil." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 mil." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000 mil." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mil." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mld." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 mld." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0 mld." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mld." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mld." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 mld." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00 mld." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mld." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mld." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 mld." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000 mld." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mld." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bil." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 bil." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0 bil." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bil." }
    };

    private static readonly AbbreviationRule[] SK_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tis. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 tis. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0 tis. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tis. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tis. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 tis. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00 tis. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tis. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tis. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 tis. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000 tis. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tis. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mil. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 mil. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0 mil. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mil. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mil. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 mil. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00 mil. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mil. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mil. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 mil. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000 mil. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mil. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mld. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 mld. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0 mld. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mld. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mld. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 mld. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00 mld. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mld. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mld. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 mld. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000 mld. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mld. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bil. ¤" }
    };

    // Slovenian
    private static readonly AbbreviationRule[] SL_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tisoč" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "0 tisoč" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 tisoč" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tisoč" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tisoč" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "00 tisoč" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 tisoč" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tisoč" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tisoč" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "000 tisoč" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 tisoč" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tisoč" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 milijon" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "0 milijona" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 milijone" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 milijonov" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 milijon" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "00 milijona" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 milijoni" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 milijonov" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 milijon" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "000 milijona" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 milijoni" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 milijonov" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 milijarda" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "0 milijardi" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 milijarde" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 milijard" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 milijarda" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "00 milijardi" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 milijarde" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 milijard" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 milijarda" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "000 milijardi" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 milijarde" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 milijard" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bilijon" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "0 bilijona" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 bilijoni" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bilijonov" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bilijon" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "00 bilijona" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 bilijoni" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bilijonov" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bilijon" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "000 bilijona" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 bilijoni" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bilijonov" }
    };

    private static readonly AbbreviationRule[] SL_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tis." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "0 tis." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 tis." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tis." },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tis." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "00 tis." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 tis." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tis." },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tis." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "000 tis." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 tis." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tis." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mio." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "0 mio." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 mio." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mio." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mio." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "00 mio." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 mio." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mio." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mio." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "000 mio." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 mio." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mio." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mrd." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "0 mrd." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 mrd." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "00 mrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 mrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "000 mrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 mrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mrd." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bil." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "0 bil." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 bil." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "00 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "000 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bil." }
    };

    private static readonly AbbreviationRule[] SL_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tis. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "0 tis. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 tis. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tis. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tis. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "00 tis. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 tis. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tis. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tis. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "000 tis. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 tis. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tis. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mio. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "0 mio. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 mio. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mio. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mio. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "00 mio. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 mio. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mio. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mio. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "000 mio. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 mio. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mio. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mrd. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "0 mrd. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 mrd. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mrd. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mrd. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "00 mrd. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 mrd. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mrd. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mrd. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "000 mrd. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 mrd. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mrd. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "000 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bil. ¤" }
    };

    // Sami, Inari
    private static readonly AbbreviationRule[] SMN_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tuhháát" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "0 tuhháát" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tuhháát" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tuhháát" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "00 tuhháát" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tuhháát" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tuhháát" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "000 tuhháát" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tuhháát" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 miljovn" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "0 miljovn" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 miljovn" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 miljovn" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "00 miljovn" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 miljovn" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 miljovn" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "000 miljovn" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 miljovn" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 miljard" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "0 miljard" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 miljard" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 miljard" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "00 miljard" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 miljard" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 miljard" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "000 miljard" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 miljard" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 biljovn" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "0 biljovn" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 biljovn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 biljovn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "00 biljovn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 biljovn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 biljovn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "000 biljovn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 biljovn" }
    };

    private static readonly AbbreviationRule[] SMN_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤ 0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Two, Value = "¤ 0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤ 00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Two, Value = "¤ 00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤ 000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Two, Value = "¤ 000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤ 0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Two, Value = "¤ 0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤ 00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Two, Value = "¤ 00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤ 000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Two, Value = "¤ 000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤ 0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Two, Value = "¤ 0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤ 00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Two, Value = "¤ 00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤ 000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Two, Value = "¤ 000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤ 0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Two, Value = "¤ 0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤ 00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Two, Value = "¤ 00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤ 000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Two, Value = "¤ 000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000T" }
    };

    // Shona
    private static readonly AbbreviationRule[] SN_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Somali
    private static readonly AbbreviationRule[] SO_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "Kun" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K" }
    };

    private static readonly AbbreviationRule[] SO_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Albanian
    private static readonly AbbreviationRule[] SQ_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 mijë" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 mijë" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 mijë" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 mijë" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 mijë" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 mijë" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 milion" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 milion" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 milion" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 milion" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 milion" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 milion" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 miliard" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 miliard" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 miliard" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 miliard" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 miliard" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 miliard" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bilion" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bilion" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bilion" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bilion" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bilion" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bilion" }
    };

    private static readonly AbbreviationRule[] SQ_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 mijë" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 mijë" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 mijë" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 mijë" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 mijë" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 mijë" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 Mln" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 Mln" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 Mln" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 Mln" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 Mln" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 Mln" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 Mld" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 Mld" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 Mld" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 Mld" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 Mld" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 Mld" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 Bln" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 Bln" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 Bln" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 Bln" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 Bln" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 Bln" }
    };

    private static readonly AbbreviationRule[] SQ_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 mijë ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 mijë ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 mijë ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 mijë ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 mijë ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 mijë ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 Mln ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 Mln ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 Mln ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 Mln ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 Mln ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 Mln ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 Mld ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 Mld ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 Mld ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 Mld ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 Mld ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 Mld ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 Bln ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 Bln ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 Bln ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 Bln ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 Bln ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 Bln ¤" }
    };

    // Serbian, Cyrillic
    private static readonly AbbreviationRule[] SR_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 хиљада" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 хиљаде" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 хиљада" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 хиљада" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 хиљаде" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 хиљада" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 хиљада" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 хиљаде" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 хиљада" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 милион" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 милиона" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 милиона" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 милион" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 милиона" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 милиона" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 милион" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 милиона" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 милиона" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 милијарда" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 милијарде" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 милијарди" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 милијарда" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 милијарде" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 милијарди" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 милијарда" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 милијарде" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 милијарди" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 билион" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 билиона" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 билиона" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 билион" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 билиона" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 билиона" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 билион" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 билиона" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 билиона" }
    };

    private static readonly AbbreviationRule[] SR_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 хиљ." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 хиљ." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 хиљ." },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 хиљ." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 хиљ." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 хиљ." },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 хиљ." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 хиљ." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 хиљ." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 мил." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 мил." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 мил." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 мил." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 мил." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 мил." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 мил." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 мил." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 мил." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 млрд." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 млрд." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 млрд." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 млрд." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 млрд." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 млрд." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 млрд." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 млрд." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 млрд." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 бил." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 бил." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 бил." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 бил." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 бил." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 бил." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 бил." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 бил." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 бил." }
    };

    private static readonly AbbreviationRule[] SR_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 хиљ. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 хиљ. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 хиљ. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 хиљ. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 хиљ. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 хиљ. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 хиљ. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 хиљ. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 хиљ. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 мил. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 мил. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 мил. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 мил. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 мил. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 мил. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 мил. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 мил. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 мил. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 млрд. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 млрд. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 млрд. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 млрд. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 млрд. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 млрд. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 млрд. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 млрд. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 млрд. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 бил. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 бил. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 бил. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 бил. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 бил. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 бил. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 бил. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 бил. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 бил. ¤" }
    };

    // Serbian, Latin
    private static readonly AbbreviationRule[] SR_LATN_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 hiljada" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 hiljade" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 hiljada" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 hiljada" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 hiljade" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 hiljada" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 hiljada" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 hiljade" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 hiljada" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 milion" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 miliona" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 miliona" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 milion" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 miliona" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 miliona" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 milion" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 miliona" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 miliona" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 milijarda" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 milijarde" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 milijardi" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 milijarda" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 milijarde" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 milijardi" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 milijarda" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 milijarde" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 milijardi" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bilion" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 biliona" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 biliona" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bilion" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 biliona" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 biliona" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bilion" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 biliona" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 biliona" }
    };

    private static readonly AbbreviationRule[] SR_LATN_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 hilj." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 hilj." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 hilj." },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 hilj." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 hilj." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 hilj." },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 hilj." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 hilj." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 hilj." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mil." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 mil." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mil." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mil." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 mil." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mil." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mil." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 mil." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mil." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mlrd." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 mlrd." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mlrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mlrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 mlrd." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mlrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mlrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 mlrd." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mlrd." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bil." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 bil." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 bil." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 bil." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bil." }
    };

    private static readonly AbbreviationRule[] SR_LATN_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 hilj. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 hilj. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 hilj. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 hilj. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 hilj. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 hilj. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 hilj. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 hilj. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 hilj. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mil. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 mil. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mil. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mil. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 mil. ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mil. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mil. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 mil. ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mil. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mlrd. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 mlrd. ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mlrd. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mlrd. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 mlrd. ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mlrd. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mlrd. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 mlrd. ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mlrd. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 bil. ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bil. ¤" }
    };

    // Swedish
    private static readonly AbbreviationRule[] SV_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tusen" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tusen" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tusen" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tusen" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tusen" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tusen" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 miljon" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 miljoner" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 miljon" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 miljoner" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 miljoner" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 miljoner" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 miljard" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 miljarder" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 miljarder" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 miljarder" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 miljarder" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 miljarder" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 biljon" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 biljoner" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 biljoner" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 biljoner" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 biljoner" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 biljoner" }
    };

    private static readonly AbbreviationRule[] SV_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tn" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tn" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tn" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tn" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tn" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tn" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mn" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mn" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mn" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mn" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mn" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mn" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 md" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 md" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 md" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 md" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 md" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 md" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bn" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bn" }
    };

    private static readonly AbbreviationRule[] SV_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 tn ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 tn ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 tn ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 tn ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 tn ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 tn ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mn ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mn ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mn ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mn ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mn ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mn ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 md ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 md ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 md ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 md ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 md ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 md ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 bn ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 bn ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 bn ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 bn ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 bn ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 bn ¤" }
    };

    // Kiswahili
    private static readonly AbbreviationRule[] SW_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "Elfu 0" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "Elfu 0" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "Elfu 00" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "Elfu 00" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "Elfu 000" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "Elfu 000" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "Milioni 0" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "Milioni 0" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "Milioni 00" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "Milioni 00" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "Milioni 000" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "Milioni 000" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "Bilioni 0" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "Bilioni 0" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "Bilioni 00" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "Bilioni 00" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "Bilioni 000" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "Bilioni 000" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "Trilioni 0" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "Trilioni 0" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "Trilioni 00" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "Trilioni 00" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "Trilioni 000" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "Trilioni 000" }
    };

    private static readonly AbbreviationRule[] SW_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "elfu 0" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "elfu 0" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "elfu 00" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "elfu 00" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "elfu 000" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "elfu 000" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "M0" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "M0" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "M00" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "M00" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "M000" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "M000" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "B0" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "B0" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "B00" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "B00" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "B000" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "B000" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "T0" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "T0" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "T00" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "T00" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "T000" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "T000" }
    };

    private static readonly AbbreviationRule[] SW_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤elfu 0" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤elfu 0" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤elfu 00" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤elfu 00" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤laki 000" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤laki 000" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤M0" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤M0" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤M00" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤M00" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤M000" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤M000" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤B0" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤B0" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤B00" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤B00" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤B000" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤B000" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤T0" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤T0" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤T00" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤T00" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤T000" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤T000" }
    };

    // Tamil
    private static readonly AbbreviationRule[] TA_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 ஆயிரம்" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 ஆயிரம்" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 ஆயிரம்" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 ஆயிரம்" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 ஆயிரம்" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 ஆயிரம்" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 மில்லியன்" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 மில்லியன்" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 மில்லியன்" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 மில்லியன்" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 மில்லியன்" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 மில்லியன்" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 பில்லியன்" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 பில்லியன்" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 பில்லியன்" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 பில்லியன்" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 பில்லியன்" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 பில்லியன்" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 டிரில்லியன்" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 டிரில்லியன்" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 டிரில்லியன்" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 டிரில்லியன்" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 டிரில்லியன்" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 டிரில்லியன்" }
    };

    private static readonly AbbreviationRule[] TA_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0ஆ" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0ஆ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00ஆ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00ஆ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000ஆ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000ஆ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0மி" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0மி" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00மி" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00மி" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000மி" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000மி" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0பி" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0பி" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00பி" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00பி" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000பி" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000பி" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0டி" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0டி" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00டி" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00டி" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000டி" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000டி" }
    };

    private static readonly AbbreviationRule[] TA_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤ 0ஆ" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0ஆ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤ 00ஆ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00ஆ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤ 000ஆ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000ஆ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤ 0மி" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0மி" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤ 00மி" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00மி" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤ 000மி" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000மி" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤ 0பி" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0பி" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤ 00பி" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00பி" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤ 000பி" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000பி" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤ 0டி" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0டி" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤ 00டி" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00டி" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤ 000டி" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000டி" }
    };

    // Telugu
    private static readonly AbbreviationRule[] TE_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 వేయి" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 వేలు" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 వేలు" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 వేలు" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 వేలు" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 వేలు" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 మిలియన్" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 మిలియన్లు" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 మిలియన్లు" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 మిలియన్లు" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 మిలియన్లు" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 మిలియన్లు" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 బిలియన్" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 బిలియన్లు" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 బిలియన్లు" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 బిలియన్లు" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 బిలియన్లు" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 బిలియన్లు" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 ట్రిలియన్" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 ట్రిలియన్లు" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 ట్రిలియన్లు" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 ట్రిలియన్లు" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 ట్రిలియన్లు" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 ట్రిలియన్లు" }
    };

    private static readonly AbbreviationRule[] TE_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0వే" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0వే" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00వే" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00వే" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000వే" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000వే" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0మి" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0మి" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00మి" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00మి" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000మి" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000మి" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0బి" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0బి" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00బి" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00బి" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000బి" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000బి" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0ట్రి" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0ట్రి" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00ట్రి" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00ట్రి" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000ట్రి" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000ట్రి" }
    };

    private static readonly AbbreviationRule[] TE_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0వే" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0వే" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00వే" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00వే" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000వే" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000వే" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0మి" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0మి" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00మి" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00మి" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000మి" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000మి" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0బి" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0బి" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00బి" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00బి" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000బి" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000బి" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0ట్రి" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0ట్రి" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00ట్రి" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00ట్రి" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000ట్రి" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000ట్రి" }
    };

    // Teso
    private static readonly AbbreviationRule[] TEO_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Thai
    private static readonly AbbreviationRule[] TH_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 พัน" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "0 หมื่น" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "0 แสน" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 ล้าน" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 ล้าน" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 ล้าน" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 พันล้าน" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "0 หมื่นล้าน" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "0 แสนล้าน" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 ล้านล้าน" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 ล้านล้าน" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 ล้านล้าน" }
    };

    private static readonly AbbreviationRule[] TH_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 พ." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "0 ม." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "0 ส." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 ล." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 ล." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 ล." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 พ.ล." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "0 ม.ล." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "0 ส.ล." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 ล.ล." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 ล.ล." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 ล.ล." }
    };

    private static readonly AbbreviationRule[] TH_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0 พ." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤0 ม." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤0 ส." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0 ล." },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00 ล." },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000 ล." },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0 พ.ล." },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤0 ม.ล." },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤0 ส.ล." },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0 ล.ล." },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00 ล.ล." },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000 ล.ล." }
    };

    // Tigrinya
    private static readonly AbbreviationRule[] TI_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Turkmen
    private static readonly AbbreviationRule[] TK_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 müň" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 müň" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 müň" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 müň" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 müň" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 müň" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 million" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 million" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 million" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 million" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 million" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 million" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 milliard" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 milliard" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 milliard" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 milliard" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 milliard" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 milliard" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 trillion" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 trillion" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 trillion" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 trillion" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 trillion" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 trillion" }
    };

    private static readonly AbbreviationRule[] TK_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 müň" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 müň" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 müň" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 müň" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 müň" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 müň" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mln" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mln" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mln" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mln" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mln" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mln" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mlrd" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mlrd" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mlrd" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mlrd" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mlrd" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mlrd" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 trln" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 trln" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 trln" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 trln" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 trln" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 trln" }
    };

    private static readonly AbbreviationRule[] TK_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 müň ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 müň ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 müň ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 müň ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 müň ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 müň ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mln ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mln ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mln ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mln ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mln ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mln ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mlrd ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mlrd ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mlrd ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mlrd ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mlrd ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mlrd ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 trln ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 trln ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 trln ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 trln ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 trln ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 trln ¤" }
    };

    // Tongan
    private static readonly AbbreviationRule[] TO_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 afe" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "0 mano" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "0 kilu" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 miliona" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 miliona" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 miliona" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 piliona" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 piliona" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 piliona" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 tiliona" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 tiliona" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 tiliona" }
    };

    private static readonly AbbreviationRule[] TO_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0k" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00k" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000k" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0Ki" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00Ki" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000Ki" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T" }
    };

    private static readonly AbbreviationRule[] TO_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0k" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00k" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000k" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0Ki" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00Ki" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000Ki" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000T" }
    };

    // Turkish
    private static readonly AbbreviationRule[] TR_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 bin" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 bin" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 bin" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 bin" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 bin" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 bin" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 milyon" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 milyon" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 milyon" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 milyon" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 milyon" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 milyon" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 milyar" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 milyar" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 milyar" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 milyar" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 milyar" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 milyar" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 trilyon" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 trilyon" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 trilyon" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 trilyon" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 trilyon" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 trilyon" }
    };

    private static readonly AbbreviationRule[] TR_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 B" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 B" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 B" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 B" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 B" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 B" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 Mn" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 Mn" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 Mn" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 Mn" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 Mn" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 Mn" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 Mr" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 Mr" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 Mr" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 Mr" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 Mr" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 Mr" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 Tn" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 Tn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 Tn" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 Tn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 Tn" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 Tn" }
    };

    private static readonly AbbreviationRule[] TR_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 B ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 B ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 B ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 B ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 B ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 B ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 Mn ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 Mn ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 Mn ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 Mn ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 Mn ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 Mn ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 Mr ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 Mr ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 Mr ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 Mr ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 Mr ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 Mr ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 Tn ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 Tn ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 Tn ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 Tn ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 Tn ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 Tn ¤" }
    };

    // Tasawaq
    private static readonly AbbreviationRule[] TWQ_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T¤" }
    };

    // Central Atlas Tamazight
    private static readonly AbbreviationRule[] TZM_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0G ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00G ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000G ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T ¤" }
    };

    // Uyghur
    private static readonly AbbreviationRule[] UG_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 مىڭ" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 مىڭ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 مىڭ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 مىڭ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 مىڭ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 مىڭ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 مىليون" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 مىليون" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 مىليون" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 مىليون" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 مىليون" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 مىليون" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 مىليارد" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 مىليارد" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 مىليارد" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 مىليارد" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 مىليارد" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 مىليارد" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 تىرىليون" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 تىرىليون" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 تىرىليون" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 تىرىليون" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 تىرىليون" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 تىرىليون" }
    };

    private static readonly AbbreviationRule[] UG_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0مىڭ" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0مىڭ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00مىڭ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00مىڭ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000مىڭ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000مىڭ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0مىليون" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0مىليون" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00مىليون" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00مىليون" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000مىليون" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000مىليون" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0مىليارد" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0مىليارد" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00مىليارد" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00مىليارد" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000مىليارد" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000مىليارد" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T" }
    };

    private static readonly AbbreviationRule[] UG_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0مىڭ" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0مىڭ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00مىڭ" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00مىڭ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000مىڭ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000مىڭ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0مىليون" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0مىليون" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00مىليون" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00مىليون" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000مىليون" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000مىليون" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0مىليارد" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0مىليارد" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00مىليارد" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00مىليارد" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000مىليارد" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000مىليارد" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Ukrainian
    private static readonly AbbreviationRule[] UK_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 тисяча" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 тисячі" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0 тисяч" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 тисячі" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 тисяча" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 тисячі" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00 тисяч" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 тисячі" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 тисяча" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 тисячі" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000 тисяч" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 тисячі" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 мільйон" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 мільйони" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0 мільйонів" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 мільйона" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 мільйон" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 мільйони" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00 мільйонів" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 мільйона" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 мільйон" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 мільйони" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000 мільйонів" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 мільйона" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 мільярд" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 мільярди" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0 мільярдів" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 мільярда" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 мільярд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 мільярди" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00 мільярдів" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 мільярда" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 мільярд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 мільярди" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000 мільярдів" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 мільярда" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 трильйон" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 трильйони" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0 трильйонів" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 трильйона" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 трильйон" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 трильйони" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00 трильйонів" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 трильйона" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 трильйон" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 трильйони" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000 трильйонів" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 трильйона" }
    };

    private static readonly AbbreviationRule[] UK_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 тис." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 тис." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0 тис." },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 тис." },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 тис." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 тис." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00 тис." },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 тис." },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 тис." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 тис." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000 тис." },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 тис." },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 млн" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 млн" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0 млн" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 млн" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 млн" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 млн" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00 млн" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 млн" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 млн" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 млн" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000 млн" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 млн" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 млрд" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 млрд" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0 млрд" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 млрд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 млрд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 млрд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00 млрд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 млрд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 млрд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 млрд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000 млрд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 млрд" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 трлн" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 трлн" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0 трлн" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 трлн" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 трлн" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 трлн" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00 трлн" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 трлн" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 трлн" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 трлн" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000 трлн" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 трлн" }
    };

    private static readonly AbbreviationRule[] UK_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 тис. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Few, Value = "0 тис. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Many, Value = "0 тис. ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 тис. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 тис. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Few, Value = "00 тис. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Many, Value = "00 тис. ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 тис. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 тис. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Few, Value = "000 тис. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Many, Value = "000 тис. ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 тис. ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 млн ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Few, Value = "0 млн ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Many, Value = "0 млн ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 млн ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 млн ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Few, Value = "00 млн ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Many, Value = "00 млн ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 млн ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 млн ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Few, Value = "000 млн ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Many, Value = "000 млн ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 млн ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 млрд ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Few, Value = "0 млрд ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Many, Value = "0 млрд ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 млрд ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 млрд ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Few, Value = "00 млрд ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Many, Value = "00 млрд ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 млрд ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 млрд ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Few, Value = "000 млрд ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Many, Value = "000 млрд ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 млрд ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 трлн ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Few, Value = "0 трлн ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Many, Value = "0 трлн ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 трлн ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 трлн ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Few, Value = "00 трлн ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Many, Value = "00 трлн ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 трлн ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 трлн ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Few, Value = "000 трлн ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Many, Value = "000 трлн ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 трлн ¤" }
    };

    // Urdu
    private static readonly AbbreviationRule[] UR_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 ہزار" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 ہزار" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 ہزار" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 ہزار" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "0 لاکھ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "0 لاکھ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "00 لاکھ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "00 لاکھ" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "0 کروڑ" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "0 کروڑ" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "00 کروڑ" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "00 کروڑ" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 ارب" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 ارب" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 ارب" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 ارب" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "0 کھرب" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "0 کھرب" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "00 کھرب" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "00 کھرب" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 ٹریلین" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 ٹریلین" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 ٹریلین" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 ٹریلین" }
    };

    private static readonly AbbreviationRule[] UR_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 ہزار" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 ہزار" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 ہزار" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 ہزار" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "0 لاکھ" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "0 لاکھ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "00 لاکھ" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "00 لاکھ" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "0 کروڑ" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "0 کروڑ" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "00 کروڑ" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "00 کروڑ" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 ارب" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 ارب" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 ارب" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 ارب" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "0 کھرب" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "0 کھرب" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "00 کھرب" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "00 کھرب" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 ٹریلین" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 ٹریلین" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 ٹریلین" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 ٹریلین" }
    };

    // Uzbek, Latin
    private static readonly AbbreviationRule[] UZ_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 ming" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 ming" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 ming" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 ming" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 ming" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 ming" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 million" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 million" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 million" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 million" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 million" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 million" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 milliard" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 milliard" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 milliard" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 milliard" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 milliard" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 milliard" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 trillion" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 trillion" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 trillion" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 trillion" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 trillion" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 trillion" }
    };

    private static readonly AbbreviationRule[] UZ_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 ming" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 ming" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 ming" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 ming" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 ming" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 ming" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 mln" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 mln" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 mln" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 mln" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 mln" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 mln" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 mlrd" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 mlrd" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 mlrd" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 mlrd" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 mlrd" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 mlrd" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 trln" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 trln" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 trln" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 trln" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 trln" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 trln" }
    };

    // Uzbek, Perso-Arabic
    private static readonly AbbreviationRule[] UZ_ARAB_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0G ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00G ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000G ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T ¤" }
    };

    // Uzbek, Cyrillic
    private static readonly AbbreviationRule[] UZ_CYRL_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 минг" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 минг" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 минг" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 минг" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 минг" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 минг" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 миллион" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 миллион" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 миллион" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 миллион" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 миллион" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 миллион" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 миллиард" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 миллиард" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 миллиард" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 миллиард" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 миллиард" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 миллиард" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 трилион" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 трилион" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 трилион" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 трилион" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 трилион" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 трилион" }
    };

    private static readonly AbbreviationRule[] UZ_CYRL_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0минг" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0минг" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00минг" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00минг" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000минг" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000минг" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0млн" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0млн" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00млн" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00млн" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000млн" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000млн" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0млрд" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0млрд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00млрд" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00млрд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000млрд" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000млрд" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0трлн" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0трлн" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00трлн" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00трлн" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000трлн" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000трлн" }
    };

    // Vai
    private static readonly AbbreviationRule[] VAI_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Vai, Latin
    private static readonly AbbreviationRule[] VAI_LATN_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Vietnamese
    private static readonly AbbreviationRule[] VI_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 nghìn" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 nghìn" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 nghìn" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 triệu" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 triệu" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 triệu" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 tỷ" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 tỷ" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 tỷ" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 nghìn tỷ" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 nghìn tỷ" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 nghìn tỷ" }
    };

    private static readonly AbbreviationRule[] VI_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 N" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 N" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 N" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 Tr" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 Tr" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 Tr" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 T" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 T" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 NT" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 NT" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 NT" }
    };

    private static readonly AbbreviationRule[] VI_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 N ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 N ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 N ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 Tr ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 Tr ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 Tr ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 T ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 T ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 T ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 NT ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 NT ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 NT ¤" }
    };

    // Vunjo
    private static readonly AbbreviationRule[] VUN_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // Walser
    private static readonly AbbreviationRule[] WAE_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤ 0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤ 00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤ 000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤ 0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤ 00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤ 000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤ 0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤ 00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤ 000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤ 0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤ 00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤ 000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000T" }
    };

    // Soga
    private static readonly AbbreviationRule[] XOG_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K ¤" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0G ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00G ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000G ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T ¤" }
    };

    // Yangben
    private static readonly AbbreviationRule[] YAV_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K ¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K ¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K ¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M ¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M ¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M ¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G ¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G ¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G ¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T ¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T ¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T ¤" }
    };

    // Yiddish
    private static readonly AbbreviationRule[] YI_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤ 0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤ 0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤ 00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤ 00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤ 000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤ 000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤ 0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤ 00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤ 000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤ 000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤ 0G" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤ 0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤ 00G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤ 00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤ 000G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤ 000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤ 0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤ 0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤ 00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤ 00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤ 000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤ 000T" }
    };

    // Yoruba
    private static readonly AbbreviationRule[] YO_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0G" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00G" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000G" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    // 
    private static readonly AbbreviationRule[] YUE_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0千" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "0萬" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "00萬" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "000萬" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "0000萬" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "0億" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "00億" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "000億" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "0000億" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0兆" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00兆" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000兆" }
    };

    private static readonly AbbreviationRule[] YUE_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0千" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "0萬" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "00萬" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "000萬" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "0000萬" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "0億" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "00億" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "000億" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "0000億" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0兆" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00兆" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000兆" }
    };

    // Standard Moroccan Tamazight
    private static readonly AbbreviationRule[] ZGH_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K¤" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K¤" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K¤" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M¤" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M¤" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M¤" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0G¤" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00G¤" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000G¤" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T¤" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T¤" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T¤" }
    };

    // Chinese, Simplified
    private static readonly AbbreviationRule[] ZH_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0千" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "0万" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "00万" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "000万" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "0000万" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "0亿" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "00亿" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "000亿" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "0000亿" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0兆" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00兆" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000兆" }
    };

    private static readonly AbbreviationRule[] ZH_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0千" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "0万" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "00万" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "000万" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "0000万" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "0亿" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "00亿" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "000亿" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "0000亿" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0兆" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00兆" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000兆" }
    };

    // Chinese, Traditional
    private static readonly AbbreviationRule[] ZH_HANT_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0千" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "0萬" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "00萬" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "000萬" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "0000萬" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "0億" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "00億" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "000億" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "0000億" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0兆" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00兆" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000兆" }
    };

    private static readonly AbbreviationRule[] ZH_HANT_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0千" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "0萬" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "00萬" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "000萬" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "0000萬" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "0億" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "00億" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "000億" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "0000億" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0兆" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00兆" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000兆" }
    };

    // isiZulu
    private static readonly AbbreviationRule[] ZU_LONG =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0 inkulungwane" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0 inkulungwane" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00 inkulungwane" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00 inkulungwane" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000 inkulungwane" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000 inkulungwane" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0 isigidi" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0 isigidi" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00 isigidi" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00 isigidi" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000 isigidi" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000 isigidi" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0 isigidi sezigidi" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0 isigidi sezigidi" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00 isigidi sezigidi" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00 isigidi sezigidi" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000 isigidi sezigidi" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000 isigidi sezigidi" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0 isigidintathu" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0 isigidintathu" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00 isigidintathu" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00 isigidintathu" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000 isigidintathu" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000 isigidintathu" }
    };

    private static readonly AbbreviationRule[] ZU_SHORT =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "0B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "00B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "000B" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "000T" }
    };

    private static readonly AbbreviationRule[] ZU_CURRENCY =
    {
      new AbbreviationRule { Range = 1000, Plural = Plural.One, Value = "¤0K" },
      new AbbreviationRule { Range = 1000, Plural = Plural.Other, Value = "¤0K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.One, Value = "¤00K" },
      new AbbreviationRule { Range = 10000, Plural = Plural.Other, Value = "¤00K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.One, Value = "¤000K" },
      new AbbreviationRule { Range = 100000, Plural = Plural.Other, Value = "¤000K" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.One, Value = "¤0M" },
      new AbbreviationRule { Range = 1000000, Plural = Plural.Other, Value = "¤ 0M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.One, Value = "¤00M" },
      new AbbreviationRule { Range = 10000000, Plural = Plural.Other, Value = "¤ 00M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.One, Value = "¤000M" },
      new AbbreviationRule { Range = 100000000, Plural = Plural.Other, Value = "¤000M" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.One, Value = "¤0B" },
      new AbbreviationRule { Range = 1000000000, Plural = Plural.Other, Value = "¤0B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.One, Value = "¤00B" },
      new AbbreviationRule { Range = 10000000000, Plural = Plural.Other, Value = "¤00B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.One, Value = "¤000B" },
      new AbbreviationRule { Range = 100000000000, Plural = Plural.Other, Value = "¤000B" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.One, Value = "¤0T" },
      new AbbreviationRule { Range = 1000000000000, Plural = Plural.Other, Value = "¤0T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.One, Value = "¤00T" },
      new AbbreviationRule { Range = 10000000000000, Plural = Plural.Other, Value = "¤00T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.One, Value = "¤000T" },
      new AbbreviationRule { Range = 100000000000000, Plural = Plural.Other, Value = "¤000T" }
    };

    private static readonly AbbreviationRule[] EMPTY = {};

    /// <summary>
    /// Initialize data.
    /// </summary>
    public static void Initialize()
    {
    }

    static AbbreviatedNumberData()
    {
      AbbreviatedNumber.Register("af", AF_LONG, AF_SHORT, AF_CURRENCY);
      AbbreviatedNumber.Register("agq", EMPTY, EMPTY, AGQ_CURRENCY);
      AbbreviatedNumber.Register("ak", EMPTY, EMPTY, AK_CURRENCY);
      AbbreviatedNumber.Register("am", AM_LONG, AM_SHORT, AM_CURRENCY);
      AbbreviatedNumber.Register("ar", AR_LONG, AR_SHORT, EMPTY);
      AbbreviatedNumber.Register("as", EMPTY, EMPTY, AS_CURRENCY);
      AbbreviatedNumber.Register("asa", EMPTY, EMPTY, ASA_CURRENCY);
      AbbreviatedNumber.Register("ast", AST_LONG, AST_SHORT, EMPTY);
      AbbreviatedNumber.Register("az", AZ_LONG, AZ_SHORT, AZ_CURRENCY);
      AbbreviatedNumber.Register("az-Cyrl", EMPTY, EMPTY, AZ_CYRL_CURRENCY);
      AbbreviatedNumber.Register("bas", EMPTY, EMPTY, BAS_CURRENCY);
      AbbreviatedNumber.Register("be", BE_LONG, BE_SHORT, BE_CURRENCY);
      AbbreviatedNumber.Register("bem", EMPTY, EMPTY, BEM_CURRENCY);
      AbbreviatedNumber.Register("bez", EMPTY, EMPTY, BEZ_CURRENCY);
      AbbreviatedNumber.Register("bg", BG_LONG, BG_SHORT, BG_CURRENCY);
      AbbreviatedNumber.Register("bm", EMPTY, EMPTY, BM_CURRENCY);
      AbbreviatedNumber.Register("bn", BN_LONG, BN_SHORT, EMPTY);
      AbbreviatedNumber.Register("bo", EMPTY, EMPTY, BO_CURRENCY);
      AbbreviatedNumber.Register("br", EMPTY, EMPTY, BR_CURRENCY);
      AbbreviatedNumber.Register("brx", EMPTY, EMPTY, BRX_CURRENCY);
      AbbreviatedNumber.Register("bs", BS_LONG, BS_SHORT, BS_CURRENCY);
      AbbreviatedNumber.Register("bs-Cyrl", BS_CYRL_LONG, BS_CYRL_SHORT, BS_CYRL_CURRENCY);
      AbbreviatedNumber.Register("ca", CA_LONG, CA_SHORT, CA_CURRENCY);
      AbbreviatedNumber.Register("ce", CE_LONG, CE_SHORT, CE_CURRENCY);
      AbbreviatedNumber.Register("cgg", EMPTY, EMPTY, CGG_CURRENCY);
      AbbreviatedNumber.Register("chr", CHR_LONG, CHR_SHORT, CHR_CURRENCY);
      AbbreviatedNumber.Register("cs", CS_LONG, CS_SHORT, CS_CURRENCY);
      AbbreviatedNumber.Register("cy", CY_LONG, CY_SHORT, CY_CURRENCY);
      AbbreviatedNumber.Register("da", DA_LONG, DA_SHORT, DA_CURRENCY);
      AbbreviatedNumber.Register("dav", EMPTY, EMPTY, DAV_CURRENCY);
      AbbreviatedNumber.Register("de", DE_LONG, DE_SHORT, DE_CURRENCY);
      AbbreviatedNumber.Register("dje", EMPTY, EMPTY, DJE_CURRENCY);
      AbbreviatedNumber.Register("dsb", DSB_LONG, DSB_SHORT, DSB_CURRENCY);
      AbbreviatedNumber.Register("dua", EMPTY, EMPTY, DUA_CURRENCY);
      AbbreviatedNumber.Register("dyo", EMPTY, EMPTY, DYO_CURRENCY);
      AbbreviatedNumber.Register("dz", DZ_LONG, EMPTY, DZ_CURRENCY);
      AbbreviatedNumber.Register("ebu", EMPTY, EMPTY, EBU_CURRENCY);
      AbbreviatedNumber.Register("ee", EE_LONG, EE_SHORT, EE_CURRENCY);
      AbbreviatedNumber.Register("el", EL_LONG, EL_SHORT, EL_CURRENCY);
      AbbreviatedNumber.Register("en", EN_LONG, EN_SHORT, EN_CURRENCY);
      AbbreviatedNumber.Register("eo", EMPTY, EMPTY, EO_CURRENCY);
      AbbreviatedNumber.Register("es", ES_LONG, ES_SHORT, ES_CURRENCY);
      AbbreviatedNumber.Register("et", ET_LONG, ET_SHORT, ET_CURRENCY);
      AbbreviatedNumber.Register("eu", EU_LONG, EU_SHORT, EU_CURRENCY);
      AbbreviatedNumber.Register("ewo", EMPTY, EMPTY, EWO_CURRENCY);
      AbbreviatedNumber.Register("fa", FA_LONG, FA_SHORT, EMPTY);
      AbbreviatedNumber.Register("ff", EMPTY, EMPTY, FF_CURRENCY);
      AbbreviatedNumber.Register("fi", FI_LONG, FI_SHORT, FI_CURRENCY);
      AbbreviatedNumber.Register("fil", FIL_LONG, FIL_SHORT, FIL_CURRENCY);
      AbbreviatedNumber.Register("fo", FO_LONG, FO_SHORT, FO_CURRENCY);
      AbbreviatedNumber.Register("fr", FR_LONG, FR_SHORT, FR_CURRENCY);
      AbbreviatedNumber.Register("fur", EMPTY, EMPTY, FUR_CURRENCY);
      AbbreviatedNumber.Register("fy", FY_LONG, FY_SHORT, FY_CURRENCY);
      AbbreviatedNumber.Register("ga", GA_LONG, GA_SHORT, GA_CURRENCY);
      AbbreviatedNumber.Register("gd", GD_LONG, GD_SHORT, EMPTY);
      AbbreviatedNumber.Register("gl", GL_LONG, GL_SHORT, GL_CURRENCY);
      AbbreviatedNumber.Register("gsw", GSW_LONG, GSW_SHORT, GSW_CURRENCY);
      AbbreviatedNumber.Register("gu", GU_LONG, GU_SHORT, EMPTY);
      AbbreviatedNumber.Register("guz", EMPTY, EMPTY, GUZ_CURRENCY);
      AbbreviatedNumber.Register("gv", EMPTY, EMPTY, GV_CURRENCY);
      AbbreviatedNumber.Register("ha", HA_LONG, HA_SHORT, HA_CURRENCY);
      AbbreviatedNumber.Register("haw", EMPTY, EMPTY, HAW_CURRENCY);
      AbbreviatedNumber.Register("he", HE_LONG, HE_SHORT, HE_CURRENCY);
      AbbreviatedNumber.Register("hi", HI_LONG, HI_SHORT, EMPTY);
      AbbreviatedNumber.Register("hr", HR_LONG, HR_SHORT, HR_CURRENCY);
      AbbreviatedNumber.Register("hsb", HSB_LONG, HSB_SHORT, HSB_CURRENCY);
      AbbreviatedNumber.Register("hu", HU_LONG, HU_SHORT, HU_CURRENCY);
      AbbreviatedNumber.Register("hy", HY_LONG, HY_SHORT, HY_CURRENCY);
      AbbreviatedNumber.Register("id", ID_LONG, ID_SHORT, ID_CURRENCY);
      AbbreviatedNumber.Register("ii", EMPTY, EMPTY, II_CURRENCY);
      AbbreviatedNumber.Register("is", IS_LONG, IS_SHORT, IS_CURRENCY);
      AbbreviatedNumber.Register("it", IT_LONG, IT_SHORT, IT_CURRENCY);
      AbbreviatedNumber.Register("ja", JA_LONG, JA_SHORT, JA_CURRENCY);
      AbbreviatedNumber.Register("jgo", EMPTY, EMPTY, JGO_CURRENCY);
      AbbreviatedNumber.Register("jmc", EMPTY, EMPTY, JMC_CURRENCY);
      AbbreviatedNumber.Register("ka", KA_LONG, KA_SHORT, KA_CURRENCY);
      AbbreviatedNumber.Register("kab", EMPTY, EMPTY, KAB_CURRENCY);
      AbbreviatedNumber.Register("kam", EMPTY, EMPTY, KAM_CURRENCY);
      AbbreviatedNumber.Register("kde", EMPTY, EMPTY, KDE_CURRENCY);
      AbbreviatedNumber.Register("kea", KEA_LONG, KEA_SHORT, KEA_CURRENCY);
      AbbreviatedNumber.Register("khq", EMPTY, EMPTY, KHQ_CURRENCY);
      AbbreviatedNumber.Register("ki", EMPTY, EMPTY, KI_CURRENCY);
      AbbreviatedNumber.Register("kk", KK_LONG, KK_SHORT, KK_CURRENCY);
      AbbreviatedNumber.Register("kkj", EMPTY, EMPTY, KKJ_CURRENCY);
      AbbreviatedNumber.Register("kl", KL_LONG, KL_SHORT, KL_CURRENCY);
      AbbreviatedNumber.Register("kln", EMPTY, EMPTY, KLN_CURRENCY);
      AbbreviatedNumber.Register("km", KM_LONG, KM_SHORT, KM_CURRENCY);
      AbbreviatedNumber.Register("kn", KN_LONG, KN_SHORT, EMPTY);
      AbbreviatedNumber.Register("ko", KO_LONG, KO_SHORT, KO_CURRENCY);
      AbbreviatedNumber.Register("kok", EMPTY, EMPTY, KOK_CURRENCY);
      AbbreviatedNumber.Register("ks", EMPTY, EMPTY, KS_CURRENCY);
      AbbreviatedNumber.Register("ksb", EMPTY, EMPTY, KSB_CURRENCY);
      AbbreviatedNumber.Register("ksf", EMPTY, EMPTY, KSF_CURRENCY);
      AbbreviatedNumber.Register("ksh", KSH_LONG, KSH_SHORT, KSH_CURRENCY);
      AbbreviatedNumber.Register("kw", EMPTY, EMPTY, KW_CURRENCY);
      AbbreviatedNumber.Register("ky", KY_LONG, KY_SHORT, KY_CURRENCY);
      AbbreviatedNumber.Register("lag", EMPTY, EMPTY, LAG_CURRENCY);
      AbbreviatedNumber.Register("lb", LB_LONG, LB_SHORT, LB_CURRENCY);
      AbbreviatedNumber.Register("lg", EMPTY, EMPTY, LG_CURRENCY);
      AbbreviatedNumber.Register("lkt", EMPTY, EMPTY, LKT_CURRENCY);
      AbbreviatedNumber.Register("ln", EMPTY, EMPTY, LN_CURRENCY);
      AbbreviatedNumber.Register("lo", LO_LONG, LO_SHORT, LO_CURRENCY);
      AbbreviatedNumber.Register("lt", LT_LONG, LT_SHORT, LT_CURRENCY);
      AbbreviatedNumber.Register("lu", EMPTY, EMPTY, LU_CURRENCY);
      AbbreviatedNumber.Register("luo", EMPTY, EMPTY, LUO_CURRENCY);
      AbbreviatedNumber.Register("luy", EMPTY, EMPTY, LUY_CURRENCY);
      AbbreviatedNumber.Register("lv", LV_LONG, LV_SHORT, LV_CURRENCY);
      AbbreviatedNumber.Register("mas", EMPTY, EMPTY, MAS_CURRENCY);
      AbbreviatedNumber.Register("mer", EMPTY, EMPTY, MER_CURRENCY);
      AbbreviatedNumber.Register("mfe", EMPTY, EMPTY, MFE_CURRENCY);
      AbbreviatedNumber.Register("mg", EMPTY, EMPTY, MG_CURRENCY);
      AbbreviatedNumber.Register("mgh", EMPTY, EMPTY, MGH_CURRENCY);
      AbbreviatedNumber.Register("mgo", EMPTY, EMPTY, MGO_CURRENCY);
      AbbreviatedNumber.Register("mk", MK_LONG, MK_SHORT, MK_CURRENCY);
      AbbreviatedNumber.Register("ml", ML_LONG, ML_SHORT, ML_CURRENCY);
      AbbreviatedNumber.Register("mn", MN_LONG, MN_SHORT, MN_CURRENCY);
      AbbreviatedNumber.Register("mr", MR_LONG, MR_SHORT, EMPTY);
      AbbreviatedNumber.Register("ms", MS_LONG, MS_SHORT, MS_CURRENCY);
      AbbreviatedNumber.Register("mt", EMPTY, EMPTY, MT_CURRENCY);
      AbbreviatedNumber.Register("mua", EMPTY, EMPTY, MUA_CURRENCY);
      AbbreviatedNumber.Register("my", MY_LONG, MY_SHORT, MY_CURRENCY);
      AbbreviatedNumber.Register("naq", EMPTY, EMPTY, NAQ_CURRENCY);
      AbbreviatedNumber.Register("nb", NB_LONG, NB_SHORT, EMPTY);
      AbbreviatedNumber.Register("nd", EMPTY, EMPTY, ND_CURRENCY);
      AbbreviatedNumber.Register("ne", NE_LONG, NE_SHORT, EMPTY);
      AbbreviatedNumber.Register("nl", NL_LONG, NL_SHORT, EMPTY);
      AbbreviatedNumber.Register("nmg", EMPTY, EMPTY, NMG_CURRENCY);
      AbbreviatedNumber.Register("nn", NN_LONG, NN_SHORT, NN_CURRENCY);
      AbbreviatedNumber.Register("nnh", EMPTY, EMPTY, NNH_CURRENCY);
      AbbreviatedNumber.Register("nus", EMPTY, EMPTY, NUS_CURRENCY);
      AbbreviatedNumber.Register("nyn", EMPTY, EMPTY, NYN_CURRENCY);
      AbbreviatedNumber.Register("om", EMPTY, EMPTY, OM_CURRENCY);
      AbbreviatedNumber.Register("or", EMPTY, EMPTY, OR_CURRENCY);
      AbbreviatedNumber.Register("os", EMPTY, EMPTY, OS_CURRENCY);
      AbbreviatedNumber.Register("pa", PA_LONG, PA_SHORT, EMPTY);
      AbbreviatedNumber.Register("pa-Arab", EMPTY, EMPTY, PA_ARAB_CURRENCY);
      AbbreviatedNumber.Register("pl", PL_LONG, PL_SHORT, PL_CURRENCY);
      AbbreviatedNumber.Register("pt", PT_LONG, PT_SHORT, PT_CURRENCY);
      AbbreviatedNumber.Register("qu", EMPTY, EMPTY, QU_CURRENCY);
      AbbreviatedNumber.Register("rm", EMPTY, EMPTY, RM_CURRENCY);
      AbbreviatedNumber.Register("rn", EMPTY, EMPTY, RN_CURRENCY);
      AbbreviatedNumber.Register("ro", RO_LONG, RO_SHORT, RO_CURRENCY);
      AbbreviatedNumber.Register("rof", EMPTY, EMPTY, ROF_CURRENCY);
      AbbreviatedNumber.Register("root", EMPTY, ROOT_SHORT, EMPTY);
      AbbreviatedNumber.Register("ru", RU_LONG, RU_SHORT, RU_CURRENCY);
      AbbreviatedNumber.Register("rw", EMPTY, EMPTY, RW_CURRENCY);
      AbbreviatedNumber.Register("rwk", EMPTY, EMPTY, RWK_CURRENCY);
      AbbreviatedNumber.Register("sah", SAH_LONG, SAH_SHORT, SAH_CURRENCY);
      AbbreviatedNumber.Register("saq", EMPTY, EMPTY, SAQ_CURRENCY);
      AbbreviatedNumber.Register("sbp", EMPTY, EMPTY, SBP_CURRENCY);
      AbbreviatedNumber.Register("se", SE_LONG, SE_SHORT, SE_CURRENCY);
      AbbreviatedNumber.Register("seh", EMPTY, EMPTY, SEH_CURRENCY);
      AbbreviatedNumber.Register("ses", EMPTY, EMPTY, SES_CURRENCY);
      AbbreviatedNumber.Register("sg", EMPTY, EMPTY, SG_CURRENCY);
      AbbreviatedNumber.Register("shi", EMPTY, EMPTY, SHI_CURRENCY);
      AbbreviatedNumber.Register("shi-Latn", EMPTY, EMPTY, SHI_LATN_CURRENCY);
      AbbreviatedNumber.Register("si", SI_LONG, SI_SHORT, SI_CURRENCY);
      AbbreviatedNumber.Register("sk", SK_LONG, SK_SHORT, SK_CURRENCY);
      AbbreviatedNumber.Register("sl", SL_LONG, SL_SHORT, SL_CURRENCY);
      AbbreviatedNumber.Register("smn", SMN_LONG, EMPTY, SMN_CURRENCY);
      AbbreviatedNumber.Register("sn", EMPTY, EMPTY, SN_CURRENCY);
      AbbreviatedNumber.Register("so", SO_LONG, EMPTY, SO_CURRENCY);
      AbbreviatedNumber.Register("sq", SQ_LONG, SQ_SHORT, SQ_CURRENCY);
      AbbreviatedNumber.Register("sr", SR_LONG, SR_SHORT, SR_CURRENCY);
      AbbreviatedNumber.Register("sr-Latn", SR_LATN_LONG, SR_LATN_SHORT, SR_LATN_CURRENCY);
      AbbreviatedNumber.Register("sv", SV_LONG, SV_SHORT, SV_CURRENCY);
      AbbreviatedNumber.Register("sw", SW_LONG, SW_SHORT, SW_CURRENCY);
      AbbreviatedNumber.Register("ta", TA_LONG, TA_SHORT, TA_CURRENCY);
      AbbreviatedNumber.Register("te", TE_LONG, TE_SHORT, TE_CURRENCY);
      AbbreviatedNumber.Register("teo", EMPTY, EMPTY, TEO_CURRENCY);
      AbbreviatedNumber.Register("th", TH_LONG, TH_SHORT, TH_CURRENCY);
      AbbreviatedNumber.Register("ti", EMPTY, EMPTY, TI_CURRENCY);
      AbbreviatedNumber.Register("tk", TK_LONG, TK_SHORT, TK_CURRENCY);
      AbbreviatedNumber.Register("to", TO_LONG, TO_SHORT, TO_CURRENCY);
      AbbreviatedNumber.Register("tr", TR_LONG, TR_SHORT, TR_CURRENCY);
      AbbreviatedNumber.Register("twq", EMPTY, EMPTY, TWQ_CURRENCY);
      AbbreviatedNumber.Register("tzm", EMPTY, EMPTY, TZM_CURRENCY);
      AbbreviatedNumber.Register("ug", UG_LONG, UG_SHORT, UG_CURRENCY);
      AbbreviatedNumber.Register("uk", UK_LONG, UK_SHORT, UK_CURRENCY);
      AbbreviatedNumber.Register("ur", UR_LONG, UR_SHORT, EMPTY);
      AbbreviatedNumber.Register("uz", UZ_LONG, UZ_SHORT, EMPTY);
      AbbreviatedNumber.Register("uz-Arab", EMPTY, EMPTY, UZ_ARAB_CURRENCY);
      AbbreviatedNumber.Register("uz-Cyrl", UZ_CYRL_LONG, UZ_CYRL_SHORT, EMPTY);
      AbbreviatedNumber.Register("vai", EMPTY, EMPTY, VAI_CURRENCY);
      AbbreviatedNumber.Register("vai-Latn", EMPTY, EMPTY, VAI_LATN_CURRENCY);
      AbbreviatedNumber.Register("vi", VI_LONG, VI_SHORT, VI_CURRENCY);
      AbbreviatedNumber.Register("vun", EMPTY, EMPTY, VUN_CURRENCY);
      AbbreviatedNumber.Register("wae", EMPTY, EMPTY, WAE_CURRENCY);
      AbbreviatedNumber.Register("xog", EMPTY, EMPTY, XOG_CURRENCY);
      AbbreviatedNumber.Register("yav", EMPTY, EMPTY, YAV_CURRENCY);
      AbbreviatedNumber.Register("yi", EMPTY, EMPTY, YI_CURRENCY);
      AbbreviatedNumber.Register("yo", EMPTY, EMPTY, YO_CURRENCY);
      AbbreviatedNumber.Register("yue", YUE_LONG, YUE_SHORT, EMPTY);
      AbbreviatedNumber.Register("zgh", EMPTY, EMPTY, ZGH_CURRENCY);
      AbbreviatedNumber.Register("zh", ZH_LONG, ZH_SHORT, EMPTY);
      AbbreviatedNumber.Register("zh-Hant", ZH_HANT_LONG, ZH_HANT_SHORT, EMPTY);
      AbbreviatedNumber.Register("zu", ZU_LONG, ZU_SHORT, ZU_CURRENCY);
    }
  }
}
