# FEW 1.1 - Semantic Markup Practice

Learn Semantic HTML by marking up these documents. 

## What is this? 

This is a directory of text documents that you can mark up for practice to learn HTML. The documents contain the typical content you might see in web sites on your phone and desktop. Only the text is included here! Your job is to add the markup!

Besides writing syntactically correct HTML code your goal is to use HTML markup to enhance the meaning and preserve the context of the information. The markup should add clarity. 

**Your goal** is to mark up the document with the tags that best describe the content text. You want the tags to best express the message and intent of the content of each document.

**Don't** worry about what the documents look like in the browser. _This is a common beginner mistake_. The default styles in the browser are only default choices provided when no other stylesheet has been included.

Use these tags: 

- Sectional tags
    - Header `<header>`
    - Section `<section>`
    - Article `<article>`
    - Footer `<footer>`
- Headings h1-6 `<h1>`
- Paragraphs `<p>`
- small `<small>`
- BlockQuote `<blockquote>`
- pre `<pre>`
- code `<code>`
- Inline tags
    - strong `<strong>`
    - emphasis `<em>`
    - abbreviation `<abbr>`
    - anchor `<a>`
    - time `<time>`
    - Superscript `<sup>`
    - quote `<q>`

## Getting started!

**tl;dr** download this repo and start adding HTML tags to each of the documents. 

This repo contains a list of challenges and solutions. Each of the solution files is marked. 

The challenge file contains only text, no markup, you will add markup (tags). 

Before you start read the comments in each file. Also read the text itself. The markup you add should add context and reinforce the meaning and intent. 

### How to Download This Code

If you're having trouble downloading this repo, here are the steps:

1. Open a Terminal window and navigate to the folder where you'd like to place this repository. (It's probably called something like: `dev/courses/web1.0`)

2. Type in the following code:

```
$ git clone git@github.com:soggybag/learn-semantic-markup.git
```

3. Go to GitHub.com and create a new repository. _(NOTE: Make sure that the checkbox for "Initialize this repository with a README" is NOT checked.)_

4. Type in the following to update your repository's destination:

```
$ git remote set-url origin git@github.com:YOUR_USERNAME/YOUR_REPO_NAME.git
$ git push -u origin master
```

5. Refresh the page in your newly-created GitHub repo to make sure your changes were successfully pushed.


### Check your work

You can check your work in a few ways: 

Use the Validator to check your syntax. The HTML validator checks the syntax of your HTML. 

https://validator.w3.org

Check your work in the validator. 

Check your work against the solutions. What you have doesn't have to be the same as the solution!

### Feel free to contribute

Feel free to contribute! If you have ideas for a document that might make a good challenge feel free to contribute. See the [contributing](contributing.md) guide. If you have a particularly good solution feel free to contribute that also! 
