# Contributing to Soenneker.SignalR.Web.Clients

We're excited that you're interested in contributing!

## How to Contribute

1. **Create an Issue**
   - If you have a new feature idea, a bug report, or any other improvement suggestion, start by creating an issue on the [Issues](https://github.com/soenneker/soenneker.signalr.web.clients/issues) page.
   - Clearly describe the problem or enhancement you're proposing and provide as much detail as possible.

1. **Fork the Repository**
   - If you want to work on a feature or bug fix, fork the repository's `main` branch to your GitHub account.

1. **Create a Branch**
   - Create a new branch for your contribution. Use a descriptive name that reflects the purpose of your changes.

1. **Make Changes**
   - If you've changed APIs, update the documentation.
   - If you've added code that should be tested, add tests.
   - Be sure to follow the coding conventions and guidelines of the project.

1. **Test Your Changes**
   - Test your changes thoroughly to ensure that they work as expected.

1. **Commit Changes**
   - Commit your changes with a clear and concise commit message.

1. **Push Changes**
   - Push your changes to your forked repository on GitHub.

1. **Create a Pull Request**
   - Go to the [Pull Requests](https://github.com/soenneker/soenneker.signalr.web.clients/pulls) page of the original repository.
   - Click on "New Pull Request."
   - Select your forked repository and the branch with your changes.
   - Provide a clear title and description. Include the link of the original issue.

1. **Code Review**
   - Your pull request will be reviewed by the maintainers.
   - Be responsive to any feedback and make necessary changes.
   - Once your pull request is approved, it will be merged into the main branch.

## Sponsor us

If you don't have the time or expertise to contribute code, you can still support us by [sponsoring](https://github.com/sponsors/soenneker).
